// DlgHistFindResults.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include <algorithm>			// For find template.
#include "DynamicDraw.h"
#include "DynamicDrawView.h"	// g_pView.
#include "HistViewDoc.h"		// FFHistViewDoc().
#include "HistViewFrame.h"		// For FFHistViewFrame().
#include "FrameWnd.h"			// For FFGetMainWnd().
#include "FoundDoc.h"			// g_pDoc.
#include "UtilMisc.h"			// For FdsecToFiletime.
#include "UtilMath.h"			// For _i64towcs.
#include "UtilDlg.h"			// For SetUnitString.etc.
#include "UtilStr.h"			// For GetResString.
#include "UtilWin.h"			// For FFSetItemText.
#include "WndHistFindPanel.h"	// For GetHtreeFindPanel().
#include "PursuerText.h"		// For CFCPursuerText.
#include "DlgHistFindResults.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiNiBfLiDeKiDiLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myFindRecTypeToName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FTHFRecType _xZkqqHx_iCkJiCoH_xHqqkZx_ _xZkqqHx_jFlGiOjKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static WString myFindRecTypeToName (FTHFRecType recType)
{
	WString wstrName;
	switch (recType)
	{
	case FDHF_OBJ_MODIFY:		// _xZkqqHx_jFjEjFgJiMjPiNpFiBeC_xHqqkZx_
		wstrName.LoadString(IDS_OBJECT);
		break;
	case FDHF_TEXT_MODIFY:		// _xZkqqHx_iDgFiDeMiDfIiDgHiMjPiNpFiBeC_xHqqkZx_
// 06.11.15 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		wstrName.LoadString(IDR_COMMON_TEXT);
		wstrName.LoadString(IDS_TEXT);
		break;
	case FDHF_CHAR_MODIFY:		// _xZkqqHx_jFlGiOjKjFmPiNfIiMjPiNpFiBeC_xHqqkZx_
		wstrName.LoadString(IDS_TEXT_PARTS);
		break;
	case FDHF_LINK_MODIFY:		// _xZkqqHx_iDiKiDjDiDeOiMjPiNpFiBeC_xHqqkZx_
		wstrName.LoadString(IDS_LINK);
		break;
	case FDHF_LABEL_BEGIN:		// _xZkqqHx_iDiJiDhIiDiLiKeKiOgOiMjPiNpFiBeC_xHqqkZx_
		wstrName.LoadString(IDS_LABEL_BEGIN);
		break;
	case FDHF_LABEL_END:		// _xZkqqHx_iDiJiDhIiDiLiPeJjHlJiMjPiNpFiBeC_xHqqkZx_
		wstrName.LoadString(IDS_LABEL_END);
		break;
	case FDHF_TIME_LABEL:		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiMjPiNpFiBeC_xHqqkZx_
		wstrName.LoadString(IDS_TIME_LABEL);
		break;
	case FDHF_HISTORY_DOC:		// _xZkqqHx_jFlGiPjBiMjPiNpFiBeC_xHqqkZx_
		wstrName.LoadString(IDS_DOCUMENT);
		break;
	case FDHF_HI_FORK_TAG:		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiMjPiNpFiBeC_xHqqkZx_
		wstrName.LoadString(IDS_HI_FORK_TAG);
		break;
	case FDHF_TIME_SIGNAL:		// _xZkqqHx_jDpKiOjOiMjPiNpFiBeC_xHqqkZx_
		wstrName.LoadString(IDS_DATE);
		break;
	}
	return wstrName;
} // myFindRecTypeToName.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgHistFindResults _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::CFCDlgHistFindResults
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiCiBfLiDgIiDiMiDfIiDfPiDeDiDeBiDiNiDePjAoKjHhAiCmMiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCDlgHistFindResults::CFCDlgHistFindResults ()
	: BASE_CLASS()
{
} // CFCDlgHistFindResults::CFCDlgHistFindResults.

void CFCDlgHistFindResults::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCDlgHistFindResults)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_MAP
} // CFCDlgHistFindResults::DoDataExchange.

BEGIN_MESSAGE_MAP(CFCDlgHistFindResults, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCDlgHistFindResults)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_HFR_BTN_DO_VIEW, OnHfrBtnDoView)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_HFR_BTN_CLEAR_LIST, OnHfrBtnClearList)
	ON_BN_CLICKED(IDC_HFR_BTN_SHOW_PANEL, OnHfrBtnShowPanel)
	ON_NOTIFY(NM_DBLCLK, IDC_HFR_LSV_RESULTS, OnDblclkHfrLsvResults)
	ON_NOTIFY(LVN_COLUMNCLICK, IDC_HFR_LSV_RESULTS, OnColumnclickHfrLsvResults)
	ON_BN_CLICKED(IDC_HFR_BTN_DO_NEXT_VIEW, OnHfrBtnDoNextView)
	ON_BN_CLICKED(IDC_HFR_BTN_DO_PREV_VIEW, OnHfrBtnDoPrevView)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_USER_PURSUER_TEXT_NEED_INFO, OnUserPursuerTextNeedInfo)
	ON_WM_GETMINMAXINFO()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCDlgHistFindResults _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::GetHistoryFind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ m_histFind _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FCHistoryFind_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDhAiDgMiDiLiCkJiCoHiBeBiMjPiNpFiPiIjHjNiCmFiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHistoryFind& CFCDlgHistFindResults::GetHistoryFind ()
{
	return m_histFind;
} // CFCDlgHistFindResults::GetHistoryFind.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::UpdateList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiMiLiJmKjFfMiOkGiDiKiDfIiDgHiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::UpdateList ()
{
	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMjAnNjCoI_xHqqkZx_ -----
	CListCtrl* pCtrl = reinterpret_cast<CListCtrl*>(GetDlgItem(IDC_HFR_LSV_RESULTS));
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	pCtrl->DeleteAllItems();
	COleDateTime otmDate;
	for (int iC = 0; iC < m_histFind.GetFindRecSize(); iC++)
	{
		CString strText;
		LV_ITEM	lvitem;
		lvitem.mask = LVIF_TEXT | LVIF_IMAGE;
		lvitem.iItem = iC;
		lvitem.iSubItem = 0;
		WStrToTStr tstrText(myFindRecTypeToName(m_histFind.GetFindRec(iC).m_recType));
		lvitem.pszText = (_TCHAR*)(const _TCHAR*)tstrText;
		lvitem.iImage = int(m_histFind.GetFindRec(iC).m_recType);
		pCtrl->InsertItem(&lvitem);
		WString wstrProjTitle = m_histFind.AtomToStr(m_histFind.GetFindRec(iC).m_atmProjTitle);
		FFSetItemText(pCtrl, iC, 1, wstrProjTitle);
		FFSetItemText(pCtrl, iC, 2,
				m_histFind.AtomToStr(m_histFind.GetFindRec(iC).m_atmHidocument));
		FFSetItemText(pCtrl, iC, 3,
				m_histFind.AtomToStr(m_histFind.GetFindRec(iC).m_atmHistVer));
		// 10_xZkqqHx_jAgJjAjEjFlGiOjKjHpBiCmJjFmPiKlHiBeC_xHqqkZx_
		FFSetItemText(pCtrl, iC, 4,
					_i64towcs(m_histFind.GetFindRec(iC).m_fliSessionIndex, 10));
		otmDate = FdsecToFiletime(m_histFind.GetFindRec(iC).m_fdstDate);
		// _xZkqqHx_jHoBiBeG_xHqqkZx_04/12/19 12:15
		// IDS_FORM_DATE_TIME = "%y/%m/%d %H:%M"
		pCtrl->SetItemText(iC, 5, otmDate.Format(FFLoadString(IDS_FORM_DATE_TIME)));
		FFSetItemText(pCtrl, iC, 6,
					m_histFind.AtomToStr(m_histFind.GetFindRec(iC).m_atmContent));
		FFSetItemText(pCtrl, iC, 7,
				m_histFind.AtomToStr(m_histFind.GetFindRec(iC).m_atmUserInfo));
	}
} // CFCDlgHistFindResults::UpdateList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::GetCurSel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiMlLiNnNiCmMjBeJjBpAiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiDeDiDjDiDgGiDgCiDeOiDfIiBeCjBeJjBpAiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCDlgHistFindResults::GetCurSel () const
{
	CListCtrl* pCtrl = (CListCtrl*)GetDlgItem(IDC_HFR_LSV_RESULTS);
	long lC;
	for (lC = pCtrl->GetItemCount() - 1; 0 <= lC; lC--)
	{
		// _xZkqqHx_iNhDiCmMiPpDjBnEiBgJ_xHqqkZx_SELECTED_xZkqqHx_iBgKiCpAiOoGjDlOiBeC_xHqqkZx_
		UINT dwItemState = pCtrl->GetItemState(lC, LVIS_SELECTED);
		if (dwItemState & LVIS_SELECTED)
			break;
	}
	return lC;
} // CFCDlgHistFindResults::GetCurSel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::SetCurSel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiMlLiNnNiCmMjBeJjBpAiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::SetCurSel (long lIndex)
{
	CListCtrl* pCtrl = (CListCtrl*)GetDlgItem(IDC_HFR_LSV_RESULTS);
	long lC;
	for (lC = pCtrl->GetItemCount() - 1; 0 <= lC; lC--)
	{
		if (lC == lIndex)
			pCtrl->SetItemState(lC, LVIS_SELECTED, LVIS_SELECTED);
		else
			pCtrl->SetItemState(lC, 0, LVIS_SELECTED);
	}
} // CFCDlgHistFindResults::SetCurSel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::SetCurSel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiMlLiNnNiCmMjBeJjBpAiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rec	:_xZkqqHx_iDeBiDeDiDgFiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::SetCurSel (const FCHFRecord& rec)
{
	CListCtrl* pCtrl = (CListCtrl*)GetDlgItem(IDC_HFR_LSV_RESULTS);
	long lC;
	for (lC = pCtrl->GetItemCount() - 1; 0 <= lC; lC--)
	{
		if (GetItem(lC) == rec)
			pCtrl->SetItemState(lC, LVIS_SELECTED, LVIS_SELECTED);
		else
			pCtrl->SetItemState(lC, 0, LVIS_SELECTED);
	}
} // CFCDlgHistFindResults::SetCurSel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::GetCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiMiLiJmKiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiMiLiJmKiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCDlgHistFindResults::GetCount () const
{
	return m_histFind.GetFindRecSize();
} // CFCDlgHistFindResults::GetCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::GetItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiMjPiNpFiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiMiLiJmKiCmMiDeBiDeDiDgFiDiAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCHFRecord& CFCDlgHistFindResults::GetItem (long lIndex) const
{
	return m_histFind.GetFindRec(lIndex);
} // CFCDlgHistFindResults::GetItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::AtomToStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCHFRecord_xZkqqHx_iDeOiDiJiDfIjCiGiCmFiOgHiCoNiCoKiCoJiDeBiDgHiDiAiCpAjFlGiOjKjHpBiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wAtom	:_xZkqqHx_iDeBiDgHiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString CFCDlgHistFindResults::AtomToStr (WORD wAtom) const
{
	return m_histFind.AtomToStr(wAtom);
} // CFCDlgHistFindResults::AtomToStr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::UpdateColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiJiDiAjFfMiOkGiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::UpdateColumn ()
{
	HD_ITEM curItem;
	CListCtrl* pCtrl = reinterpret_cast<CListCtrl*>(GetDlgItem(IDC_HFR_LSV_RESULTS));
	CHeaderCtrl* pHdrCtrl= pCtrl->GetHeaderCtrl();
	for (int iC = 0; iC < pHdrCtrl->GetItemCount(); iC++)
	{
		WORD wItem = iC;
		WORD wRItem = wItem | 0x8000;
		if (find(m_histFind.GetSortOrder().begin(), m_histFind.GetSortOrder().end(),
				wItem) != m_histFind.GetSortOrder().end())
		//----- _xZkqqHx_iPiHiDfMiBfLiDgHiCmMiPoKiNiH_xHqqkZx_ -----
		{
			curItem.mask = HDI_IMAGE | HDI_FORMAT;
			curItem.iImage = 0;
			curItem.fmt = HDF_LEFT | HDF_IMAGE | HDF_STRING | HDF_BITMAP_ON_RIGHT;
		} else
		if (find(m_histFind.GetSortOrder().begin(), m_histFind.GetSortOrder().end(),
				wRItem) != m_histFind.GetSortOrder().end())
		//----- _xZkqqHx_iLhEiDfMiBfLiDgHiCmMiPoKiNiH_xHqqkZx_ -----
		{
			curItem.mask = HDI_IMAGE | HDI_FORMAT;
			curItem.iImage = 1;
			curItem.fmt = HDF_LEFT | HDF_IMAGE | HDF_STRING | HDF_BITMAP_ON_RIGHT;
		} else
		//----- _xZkqqHx_iDfMiBfLiDgHjBmOiPnLiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			curItem.mask = HDI_FORMAT;
			curItem.fmt = HDF_LEFT | HDF_STRING;
		}
		pHdrCtrl->SetItem(iC, &curItem);
	}
} // CFCDlgHistFindResults::UpdateColumn.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgHistFindResults _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgHistFindResults::OnInitDialog ()
{
	// _xZkqqHx_iDiCiBfLiDgIiDiMiDfIiDfPiDeDiDeBiDiNiDePiCmMiPoKiNiHiBeB_xHqqkZx_BASE_CLASS::OnInitDialog()_xZkqqHx_iCmM_xHqqkZx_
	// _xZkqqHx_jBePiCmJiDfCiDjDiDgHiDiNiBfLiDiLiCmNiNoMjAkMiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
	// BASE_CLASS::OnInitDialog() _xZkqqHx_iCmFiDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJjFmPiNfIiCkK_xHqqkZx_
	// _xZkqqHx_jDpMiCoJiClNiCnPiBeBiClBiClBiCmFiDiMiDeDiDeBiDeFiDgHiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_

//----- 06.05.30 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFjHmMiIoGiCpAiMhGiOfKiBeC_xHqqkZx_
	CRect rtWindow;
	GetWindowRect(rtWindow);

	// CFCDlgDsmBookmark _xZkqqHx_iCmG_xHqqkZx_ CFCDlgHistFindResults _xZkqqHx_iCmN_xHqqkZx_
	// _xZkqqHx_iJgFiLlPiClFiCkAiCkEiCoGiCkEiCmFiBeBiMoDiCkJiCoHiNoMjAkMiClFiClNiDeFiDeCiDjDiDgIiDeFiCmMiDfEiDeDiDfJiCkK_xHqqkZx_
	// _xZkqqHx_iInJiPoNiCmJjBoFiCkLiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeCiClBiCmMiClNiCnPiBeB_xHqqkZx_rtDefaultStone _xZkqqHx_iCmF_xHqqkZx_
	// _xZkqqHx_iDfEiDeDiDfJiCpAjClCjAkOiClHiCoJiBeC_xHqqkZx_
	CRect rtDefaultStone;
	GetDlgItem(IDC_HFR_STC_DEFAULT_SIZE_STONE)->GetWindowRect(rtDefaultStone);
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_+4 _xZkqqHx_iCmNiBeBiDeFiDeCiDjDiDgIiDeFiDhEiDiMiBfLiDiAiCmMjFjNiBeC_xHqqkZx_
	SetWindowPos(	NULL, 0, 0,
					rtDefaultStone.right - rtWindow.left + 4,
					rtDefaultStone.bottom - rtWindow.top + 4,
					SWP_NOACTIVATE|SWP_NOCOPYBITS|SWP_NOOWNERZORDER|
					SWP_NOSENDCHANGING|SWP_NOMOVE|SWP_NOZORDER);

	//----- _xZkqqHx_iDhEiDiMiBfLiDiAiDfEiDeDiDfJiCmMiNmFiPkMjCgMiCpAiMhGiOfK_xHqqkZx_ -----
	CRect rtMinStone;
	GetDlgItem(IDC_HFR_STC_MIN_SIZE_STONE)->GetWindowRect(rtMinStone);
	m_szMinFrame.cx = rtMinStone.right - rtWindow.left;
	m_szMinFrame.cy = rtMinStone.bottom - rtWindow.top;
//----- 06.05.30 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iDiMiDeDiDeBiDeFiDgHiPoOjFpBiCpAiMhGiOfK_xHqqkZx_ -----
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiOgMjFpLiCmJjCmHiPfNiClFiCmEiDiKiDfEiDeDiDfJiBeC_xHqqkZx_
	const long aId1[] = {	IDC_HFR_LSV_RESULTS };
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiJeFiJlKiCmJjCmHiPfNiClFiCmEiInKjDkOiBeC_xHqqkZx_
	const long aId2[] = {	IDC_HFR_BTN_DO_NEXT_VIEW,
							IDC_HFR_BTN_DO_PREV_VIEW,
							IDC_HFR_BTN_DO_VIEW,
							IDC_HFR_BTN_CLEAR_LIST,
							IDC_HFR_BTN_SHOW_PANEL,
							ID_HELP,
							IDCANCEL };
	FFInitDlgLayout(m_mpLayoutInfo,
					this,
					sizeof(aId1) / sizeof(aId1[0]),
					aId1,
					FCDlgLayoutRec::HOOK_ALL);
	FFInitDlgLayout(m_mpLayoutInfo,
					this,
					sizeof(aId2) / sizeof(aId2[0]),
					aId2,
					FCDlgLayoutRec::HOOK_RIGHT | FCDlgLayoutRec::HOOK_BOTTOM);

//----- 06.05.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iDhEiDiMiBfLiDiAiDfEiDeDiDfJiCmMiNmFiPkMjCgMiCpAiMhGiOfK_xHqqkZx_ -----
//	CRect rtWindow;
//	GetWindowRect(rtWindow);
//	CRect rtMinStone;
//	GetDlgItem(IDC_HFR_STC_MIN_SIZE_STONE)->GetWindowRect(rtMinStone);
//	m_szMinFrame.cx = rtMinStone.right - rtWindow.left;
//	m_szMinFrame.cy = rtMinStone.bottom - rtWindow.top;
//----- 06.05.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	if (!BASE_CLASS::OnInitDialog())
		return FALSE;
	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLjHhAiCmMiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCmMjAnNjCoI_xHqqkZx_ -----
	m_pImageList = new CImageList();
	ASSERT(m_pImageList != NULL);    // serious allocation failure checking
	m_pImageList->Create(16, 16, ILC_MASK, 10, 10);
	m_pImageList->Add(FFGetApp()->LoadIcon(IDI_HTREE_FIND_OBJECT));			// _xZkqqHx_jFjEjFgJiMjPiNpFiBeC_xHqqkZx_
	m_pImageList->Add(FFGetApp()->LoadIcon(IDI_HTREE_FIND_TEXT));			// _xZkqqHx_iDgFiDeMiDfIiDgHiMjPiNpFiBeC_xHqqkZx_
	m_pImageList->Add(FFGetApp()->LoadIcon(IDI_HTREE_FIND_CHAR));			// _xZkqqHx_jFlGiOjKjFmPiNfIiMjPiNpFiBeC_xHqqkZx_
	m_pImageList->Add(FFGetApp()->LoadIcon(IDI_HTREE_FIND_LINK));			// _xZkqqHx_iDiKiDjDiDeOiMjPiNpFiBeC_xHqqkZx_
	m_pImageList->Add(FFGetApp()->LoadIcon(IDI_HTREE_FIND_LABEL_BEGIN));	// _xZkqqHx_iDiJiDhIiDiLiKeKiOgOiMjPiNpFiBeC_xHqqkZx_
	m_pImageList->Add(FFGetApp()->LoadIcon(IDI_HTREE_FIND_LABEL_END));		// _xZkqqHx_iDiJiDhIiDiLiPeJjHlJiMjPiNpFiBeC_xHqqkZx_
	m_pImageList->Add(FFGetApp()->LoadIcon(IDI_HTREE_FIND_TIME_LABEL));		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiMjPiNpFiBeC_xHqqkZx_
	m_pImageList->Add(FFGetApp()->LoadIcon(IDI_HTREE_FIND_DOCUMENT));		// _xZkqqHx_jFlGiPjBiMjPiNpFiBeC_xHqqkZx_
	m_pImageList->Add(FFGetApp()->LoadIcon(IDI_HTREE_FIND_HI_FORK_TAG));	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiMjPiNpFiBeC_xHqqkZx_
	m_pImageList->Add(FFGetApp()->LoadIcon(IDI_HTREE_FIND_DATE));			// _xZkqqHx_jDpKiOjOiMjPiNpFiBeC_xHqqkZx_

	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiDhHiDgCiDfPjHhAiCmMiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCmMjAnNjCoI_xHqqkZx_ -----
	m_pImageListHead = new CImageList();
	ASSERT(m_pImageListHead != NULL);    // serious allocation failure checking
	m_pImageListHead->Create(10, 10, ILC_MASK, 2, 2);
	m_pImageListHead->Add(FFGetApp()->LoadIcon(IDI_SORT_MARK));		// Image 0.
	m_pImageListHead->Add(FFGetApp()->LoadIcon(IDI_SORT_REV_MARK));	// Image 1.

	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMjAnNjCoI_xHqqkZx_ -----
	CListCtrl* pCtrl = reinterpret_cast<CListCtrl*>(GetDlgItem(IDC_HFR_LSV_RESULTS));
	// _xZkqqHx_iDhEiDeIiBfLiDeKiDfIjGlDiClFiPpDjBnEiCmFiCoAjBeJjBpAiDhNiBfLiDeOiCkKjFfMiOkGiClDiCoKiCoJiCoGiCkEiCmJiDfIiDfOiDeDiDiLjFmPiNfIiBeC_xHqqkZx_
	pCtrl->ModifyStyle(0, LVS_SHOWSELALWAYS);
	// _xZkqqHx_jBfDiDeKiDiJiDiAjBeJjBpAiCmMiKgHjCkDiDfIiDfOiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	pCtrl->SetExtendedStyle(pCtrl->GetExtendedStyle()|LVS_EX_FULLROWSELECT);
	// _xZkqqHx_iDeBiDeDiDfCiDjDjFfMiOkGjHhAiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	pCtrl->SetImageList(m_pImageList, LVSIL_SMALL);
	// _xZkqqHx_iDhHiDgCiDfPjHhAiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	CHeaderCtrl* pHdrCtrl= pCtrl->GetHeaderCtrl();
	pHdrCtrl->SetImageList(m_pImageListHead);

	//----- _xZkqqHx_iDeKiDiJiDiAiCmMjAnNjCoI_xHqqkZx_ -----
	CRect rect;
	pCtrl->GetClientRect(rect);
	// _xZkqqHx_iDeKiDiJiDiAjFjNiBeCiDgGiDhEiDeIiDiLiDgHjCgMiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
	int aColumnWidth[8] =
		{
			rect.Width() / 14,
			rect.Width() / 7,
			rect.Width() / 7,
			rect.Width() / 14,
			rect.Width() / 14,
			rect.Width() / 7,
			rect.Width() * 3 / 14,
			rect.Width() * 2 / 14
		};
	//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHjCgMiCpAiOoGjDlO_xHqqkZx_ -----
	// _xZkqqHx_iDeKiDiJiDiAjFjNiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	int* pColumnWidth;
	UINT uiDataSz;
	if (FFGetApp()->GetProfileBinaryW(GetRegKeyName(), L"ColumnWidth", (LPBYTE*)&pColumnWidth, &uiDataSz))
	//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiDeKiDiJiDiAjFjNiCkKjDmHiCnNiPgPiClJiClNiPoKiNiH_xHqqkZx_ -----
	{
		if (uiDataSz == sizeof(aColumnWidth))
		{
			// _xZkqqHx_iDeKiDiJiDiAjFjNiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			for (int iC = 0; iC != sizeof(aColumnWidth) / sizeof(aColumnWidth[0]); iC++)
				aColumnWidth[iC] = pColumnWidth[iC];
		}
		delete[] pColumnWidth;
	}
	FFInsertColumn(pCtrl, 0, GetResWString(IDS_KIND), LVCFMT_LEFT, aColumnWidth[0]);
	FFInsertColumn(pCtrl, 1, GetResWString(IDS_PROJECT_NAME), LVCFMT_LEFT, aColumnWidth[1]);
	FFInsertColumn(pCtrl, 2, GetResWString(IDS_DOCUMENT_NAME), LVCFMT_LEFT, aColumnWidth[2]);
	FFInsertColumn(pCtrl, 3, GetResWString(IDS_VERSION), LVCFMT_LEFT, aColumnWidth[3]);
	FFInsertColumn(pCtrl, 4, GetResWString(IDS_POSITION), LVCFMT_LEFT, aColumnWidth[4]);
	FFInsertColumn(pCtrl, 5, GetResWString(IDS_DATE), LVCFMT_LEFT, aColumnWidth[5]);
	FFInsertColumn(pCtrl, 6, GetResWString(IDS_COMMENT), LVCFMT_LEFT, aColumnWidth[6]);
	FFInsertColumn(pCtrl, 7, GetResWString(IDS_USER_NAME), LVCFMT_LEFT, aColumnWidth[7]);

	// _xZkqqHx_iDfMiBfLiDgHiPoOjFpBiCmMiPiJiKpKiJlLiBeCiDeKiDiJiDiAiCePiCpAiDfMiBfLiDgHjBmOiPnLiCmJjAnNjCoIiBeC_xHqqkZx_
	WORDVector vSortOrder;
	vSortOrder.push_back(0);
	m_histFind.SetSortOrder(vSortOrder);
	// _xZkqqHx_iDeKiDiJiDiAjFfMiOkGiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateColumn();

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
//----- 05.11.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
//	FFJustifyWindow(m_hWnd);
//----- 05.11.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// BASE_CLASS_xZkqqHx_iCmFiDeFiDeCiDjDiDgIiDeFiImKjChFiCpAiOhHjCoIiClDiCoKiCoJiClNiCnPiBeB_xHqqkZx_FFJustifyWindow _xZkqqHx_iCmNiOmAiNhDiClFiCmIiCkCiBeC_xHqqkZx_

	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCDlgHistFindResults::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::OnDestroy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDfPiDeDiDeBiDiNiDePiDeJiDhFiDfHiDeGiDeOiDgHiCkKjEgKiKpMiClDiCoKiCoJiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::OnDestroy ()
{
//----- 06.02.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::OnDestroy();
//
//	// _xZkqqHx_iDeDiDiBiBfLiDfHiDiKiDfIiDgHjEgKiKpMiBeC_xHqqkZx_
//	delete m_pImageList;
//	m_pImageList = NULL;
//	// _xZkqqHx_iDhHiDgCiDfPiDeDiDiBiBfLiDfHiDiKiDfIiDgHjEgKiKpMiBeC_xHqqkZx_
//	delete m_pImageListHead;
//	m_pImageListHead = NULL;
//----- 06.02.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDeKiDiJiDiAjFjNiCpAiDiMiDfHiDfIiDgHiDiKiCmJiLeMjIfOiBeC_xHqqkZx_
	CListCtrl* pCtrl = reinterpret_cast<CListCtrl*>(GetDlgItem(IDC_HFR_LSV_RESULTS));
	int aColumnWidth[8];
	for (int iC = 0; iC != 8; iC++)
		aColumnWidth[iC] = pCtrl->GetColumnWidth(iC);
	FFGetApp()->WriteProfileBinaryW(GetRegKeyName(), L"ColumnWidth", (LPBYTE)aColumnWidth, sizeof(aColumnWidth));

	// _xZkqqHx_iDeDiDiBiBfLiDfHiDiKiDfIiDgHjEgKiKpMiBeC_xHqqkZx_
	delete m_pImageList;
	m_pImageList = NULL;
	// _xZkqqHx_iDhHiDgCiDfPiDeDiDiBiBfLiDfHiDiKiDfIiDgHjEgKiKpMiBeC_xHqqkZx_
	delete m_pImageListHead;
	m_pImageListHead = NULL;

	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDestroy();
//----- 06.02.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCDlgHistFindResults::OnDestroy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::OnSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkKiDfEiDeDiDfJjFmPiNfIiClDiCoKiClNjClMiMoDiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_iDfEiDeDiDfJjFmPiNfIiCmMiDfOiDeDiDhGiBeCiNmFjBoFiJlLiBeFiNmFiPkMiJlLjDjJiBeCiBeC_xHqqkZx_
 *			cx, cy	:_xZkqqHx_iDfEiDeDiDfJjFmPiNfIiMoDiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::OnSize (UINT nType, int cx, int cy)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSize(nType, cx, cy);
	// OnInitDialog_xZkqqHx_iImIjBePiCmM_xHqqkZx_OnSize_xZkqqHx_iCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (GetDlgItem(IDC_HFR_LSV_RESULTS) == NULL) return;
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiNmEjEhKjChFiBeC_xHqqkZx_
	FFDlgLayout(m_mpLayoutInfo, this, CSize(cx, cy));
} // CFCDlgHistFindResults::OnSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::OnHfrBtnDoView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFjHjKjHpAiImKjChFiCpAjFfMiOkGiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::OnHfrBtnDoView ()
{
	FFGetMainWnd()->PostMessage(WM_COMMAND, ID_HTREE_JUMP_CURRENT_FIND_RESULT, 0);
} // CFCDlgHistFindResults::OnHfrBtnDoView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::OnHfrBtnClearList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiDiKiDfIiDgHiPmBiLiOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::OnHfrBtnClearList ()
{
	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiPiJiKpKiJlL_xHqqkZx_ -----
	CListCtrl* pCtrl = reinterpret_cast<CListCtrl*>(GetDlgItem(IDC_HFR_LSV_RESULTS));
	pCtrl->DeleteAllItems();
	// _xZkqqHx_iMjPiNpFiDeJiDhFiDfHiDeGiDeOiDgHjCiGiCmMiDiMiDfCiBfLiDgIiPmBiLiOiBeC_xHqqkZx_
	m_histFind.ClearRecord();
} // CFCDlgHistFindResults::OnHfrBtnClearList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::OnHfrBtnShowPanel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiMjPiNpFiDhAiDgMiDiLiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::OnHfrBtnShowPanel ()
{
	FFHistViewFrame()->GetHtreeFindPanel()->SetWindowVisible(TRUE);
	FFHistViewFrame()->GetHtreeFindPanel()->SetFocus();
} // CFCDlgHistFindResults::OnHfrBtnShowPanel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::OnDblclkHfrLsvResults
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiDiMiDfCiBfLiDgIiCkKiDfPiDhFiDiLiDeOiDiKiDgCiDeOiClDiCoKiClNiCmGiCkLiCmJ_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pNMHDR	:NM_LISTVIEW_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pResult	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeCiCePiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.26 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::OnDblclkHfrLsvResults (NMHDR* pNMHDR, LRESULT* pResult)
{
	OnHfrBtnDoView();
	*pResult = 0;
} // CFCDlgHistFindResults::OnDblclkHfrLsvResults.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::OnColumnclickHfrLsvResults
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiDeKiDiJiDiAiCkKiDeOiDiKiDgCiDeOiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pNMHDR	:NM_LISTVIEW_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pResult	:_xZkqqHx_iMiLiJmKiCpAjFnEiClHiBeCiCePiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::OnColumnclickHfrLsvResults (NMHDR* pNMHDR, LRESULT* pResult)
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	WORD wItem = pNMListView->iSubItem;
	WORD wRItem = wItem | 0x8000;

	// _xZkqqHx_iDfMiBfLiDgHiPiHiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
	WORDVector vSortOrder = m_histFind.GetSortOrder();

	BOOL bReverse = FALSE;
	if (vSortOrder.back() == wItem) bReverse = TRUE;

	if (0 <= ::GetKeyState(VK_CONTROL))
	//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLjDkPiOjOiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		vSortOrder.clear();
	}
	WORDVector::iterator iR;
	iR = find(vSortOrder.begin(), vSortOrder.end(), wItem);
	if (iR != vSortOrder.end()) vSortOrder.erase(iR);
	iR = find(vSortOrder.begin(), vSortOrder.end(), wRItem);
	if (iR != vSortOrder.end()) vSortOrder.erase(iR);

	if (bReverse)
	//----- _xZkqqHx_iLhEiDfMiBfLiDgHiCmMiPoKiNiH_xHqqkZx_ -----
	{
		vSortOrder.push_back(wRItem);
	} else
	//----- _xZkqqHx_iPiHiDfMiBfLiDgHiPoKiNiH_xHqqkZx_ -----
	{
		vSortOrder.push_back(wItem);
	}

	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpAiCpAiOoGjDlOiClFiBeBiLeMjIfOiBeC_xHqqkZx_
	const long lCurSel = GetCurSel();
	FCHFRecord recCurSel;
	if (lCurSel != -1)
		recCurSel = GetItem(lCurSel);

	// _xZkqqHx_iDfMiBfLiDgHiPiHiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
	m_histFind.SetSortOrder(vSortOrder);
	// _xZkqqHx_iDeKiDiJiDiAjFfMiOkGiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateColumn();
	// _xZkqqHx_iDiKiDfIiDgHiDgGiBfLiDfOiCpAiDfMiBfLiDgHiBeC_xHqqkZx_
	m_histFind.SortFindRec();
	// _xZkqqHx_iDfMiBfLiDgHiMiLiJmKiCpAjFfMiOkGiBeC_xHqqkZx_
	UpdateList();

	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpAiCkKiCkAiCmBiClNiPoKiNiHiCmNiClLiCoKiCpAjBeJjBpAiBeC_xHqqkZx_
	if (lCurSel != -1)
		SetCurSel(recCurSel);

	*pResult = 0;
} // CFCDlgHistFindResults::OnColumnclickHfrLsvResults.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::OnGetMinMaxInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiNmFjBoFjCgMiBeBiNmFiPkMjCgMiCmMiPoOjFpBiCpAjFnEiClHiBeCiDiKiDfEiDeDiDfJiOjOjDjJiCmJjHjIjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpMMI	:_xZkqqHx_iNmFjBoFiBeBiNmFiPkMjCgMjDjJiCpAjFnEiClHjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::OnGetMinMaxInfo (MINMAXINFO FAR* lpMMI)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnGetMinMaxInfo(lpMMI);
	lpMMI->ptMinTrackSize.x = m_szMinFrame.cx;
	lpMMI->ptMinTrackSize.y = m_szMinFrame.cy;
} // CFCDlgHistFindResults::OnGetMinMaxInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::OnCancel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeMiDiDiDjDiDfKiDiLiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::OnCancel ()
{
	// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiPiIjHjNiCmFiCoAjEpBjFfMiOkGiCmJiCmIiCoJiCkKiBeB_xHqqkZx_OnShowWindow_xZkqqHx_iCpAiOmAiNhDiClHiCoJiClNiCnPiImIiJlKiBeC_xHqqkZx_
	SetWindowVisible(FALSE);
} // CFCDlgHistFindResults::OnCancel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::OnHfrBtnDoNextView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiOjPiCmMiImKjChFiCnGiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::OnHfrBtnDoNextView ()
{
	FFGetMainWnd()->PostMessage(WM_COMMAND, ID_HTREE_JUMP_NEXT_FIND_RESULT, 0);
} // CFCDlgHistFindResults::OnHfrBtnDoNextView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::OnHfrBtnDoPrevView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFjBePiCmMiImKjChFiCnGiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHistFindResults::OnHfrBtnDoPrevView ()
{
	FFGetMainWnd()->PostMessage(WM_COMMAND, ID_HTREE_JUMP_PREV_FIND_RESULT, 0);
} // CFCDlgHistFindResults::OnHfrBtnDoPrevView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHistFindResults::OnUserPursuerTextNeedInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCkKiDhBiDjDiDgHiPoOjFpBiCmMjAnNjCoIiCpAjHhGiLiBiClHiCoJiNnLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFeLiClIiBeB_xHqqkZx_GetCursorPos_xZkqqHx_iKnGjAjEiCmFiDhNiDeFiDfIiImKjChFiCpAiOoGjDlOiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCkK_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJjHiKiCmBiCmEiCkCiCoJiCmGiBeBiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmIiCmHiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiMlLiNnNiCmMiImKjChFiCmGjAeIiCkCiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmNiBeBiDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiCpAjClCiCnHiBeBiCnMiClIiClLiCmMiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			WM_USER_PURSUER_TEXT_NEED_INFO_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpA_xHqqkZx_SendMessage_xZkqqHx_iCmFjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjGnPiCoIjCgMiCkKiCePiCmMiPoKiNiHiCmNiBeBiClLiCmMiDeFiDeCiDjDiDgIiDeFiCmMjAgFiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jGnPiCoIjCgMiCkKiCePiImIiKePiCmFiCkAiCoJiCkJjAgFiDeFiDeCiDjDiDgIiDeFiCkKjGlDiCkNiCmIiCoJiCnMiCmFiClBiCoKiCpAiMeKiCoIjFnEiClHiBeC_xHqqkZx_
 *			wParam _xZkqqHx_iCmJiCmNiBeBiNmFiPiJiCmJiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClFiClNiDeFiDeCiDjDiDgIiDeFiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCDlgHistFindResults::OnUserPursuerTextNeedInfo (WPARAM wParam, LPARAM)
{
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupHistFindResultsHint())
	{
		// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMiMlLiNnNiCmMiImKjChFiCpAiBeBiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
		CPoint dvptMouse;
		(void)::GetCursorPos(&dvptMouse);
		CListCtrl* pCtrl = reinterpret_cast<CListCtrl*>(GetDlgItem(IDC_HFR_LSV_RESULTS));
		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
		pCtrl->ScreenToClient(&dvptMouse);
		int iC;
		for (iC = 0; iC != pCtrl->GetItemCount(); iC++)
		{
			CRect rect;
			pCtrl->GetItemRect(iC, rect, LVIR_BOUNDS);
			if (rect.PtInRect(dvptMouse))
			//----- _xZkqqHx_iDhNiDeFiDfIiCkKiDiKiDfIiDgHiDhCiDiFiBfLiCmJjDpMiCoJiPoKiNiH_xHqqkZx_ -----
			{
				const FCHFRecord& rec = m_histFind.GetFindRec(iC);
				// IDS_FORM_HTREE_PROPERTY_I =
				// _xZkqqHx_iOoNjFmK_xHqqkZx_:%s\r\n
				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_:%s\r\n
				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfOiDeDiDgHiDiL_xHqqkZx_:%s\r\n
				// _xZkqqHx_jFlGiPjBiDfOiDeDiDgHiDiL_xHqqkZx_:%s\r\n
				// _xZkqqHx_iDgPiBfLiDfHiDiHiDjD_xHqqkZx_:%s\r\n
				// _xZkqqHx_iDfCiDiBiDjDiDgH_xHqqkZx_:%s\r\n
				// _xZkqqHx_jDpKiOjO_xHqqkZx_:%s\r\n
				// _xZkqqHx_jFnCiPfHiOnC_xHqqkZx_:%s\r\n
				// _xZkqqHx_jHjKjHpAiImKjChF_xHqqkZx_:%I64d_xZkqqHx_iDfKiDgCiDfGiDiHiDjD_xHqqkZx_
				FFGetApp()->GetPopHint()->SetTargetInfo(
					FormatResString(IDS_FORM_HTREE_PROPERTY_I,
									(const wchar_t*)myFindRecTypeToName(rec.m_recType),		// _xZkqqHx_iOoNjFmKiBeC_xHqqkZx_
									m_histFind.AtomToStr(rec.m_atmProjPath),				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiBeC_xHqqkZx_
									m_histFind.AtomToStr(rec.m_atmProjTitle),				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
									m_histFind.AtomToStr(rec.m_atmHidocument),				// _xZkqqHx_jFlGiPjBiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
									m_histFind.AtomToStr(rec.m_atmHistVer),					// _xZkqqHx_iDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
									m_histFind.AtomToStr(rec.m_atmContent),					// _xZkqqHx_iDfCiDiBiDjDiDgHiBeC_xHqqkZx_
									(const wchar_t*)TStrToWStr(COleDateTime(FdsecToFiletime(rec.m_fdstDate)).Format(FFLoadString(IDS_FORM_DATE_TIME_LONG))),
																							// _xZkqqHx_jDpKiOjOiBeC_xHqqkZx_
									m_histFind.AtomToStr(rec.m_atmUserInfo),				// _xZkqqHx_jFnCiPfHiOnCiBeC_xHqqkZx_
									rec.m_fliSessionIndex));								// _xZkqqHx_jHjKjHpAiImKjChFiBeC_xHqqkZx_
				break;
			}
		}
	}
	return 1;
} // CFCDlgHistFindResults::OnUserPursuerTextNeedInfo.
