// DlgImportHidocument.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"			// For FFGetApp.
#include "UtilStr.h"				// For FFLoadWString.
#include "UtilDlg.h"				// For FFGetDlgItemText.
#include "UtilMisc.h"				// For FdsecToFiletime.
#include "UtilErr.h"				// For FFErrorBox.
#include "HTreeManager.h"			// For FDHT_VMODE_TREE.
#include "WndHistoryTree.h"			// For CFCWndHistoryTree.
#include "DynamicDb.h"				// For g_pFileServer.
#include "HiProject.h"				// For FCHiProject.
#include "DocumentRecCopy.h"		// For FCDocumentRecCopy.
#include "DlgImportHidocument.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCDlgImportHidocument _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

CFCDlgImportHidocument::CFCDlgImportHidocument (CWnd* pParent /*=NULL*/)
	: BASE_CLASS(CFCDlgImportHidocument::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFCDlgImportHidocument)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_INIT

	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiBeC_xHqqkZx_
	m_pWndHTree = NULL;
} // CFCDlgImportHidocument::CFCDlgImportHidocument.

void CFCDlgImportHidocument::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCDlgImportHidocument)
	DDX_Control(pDX, IDC_IHI_STC_CHK_LOG_COMMAND_USER_ID, m_stcChkLogCommandUserId);
	DDX_Control(pDX, IDC_IHI_STC_BORDER_1, m_stcBorder1);
	DDX_Control(pDX, IDC_IHI_STC_BORDER_2, m_stcBorder2);
	DDX_Control(pDX, IDC_IHI_STC_BORDER_3, m_stcBorder3);
	DDX_Control(pDX, IDC_IHI_LSV_HIDOCUMENT, m_lsvHidocument);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFCDlgImportHidocument, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCDlgImportHidocument)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_IHI_RDO_HTREE_PROJECT_VIEW, OnIhiRdoHtreeProjectView)
	ON_BN_CLICKED(IDC_IHI_RDO_HTREE_TREE_VIEW, OnIhiRdoHtreeTreeView)
	ON_BN_CLICKED(IDC_IHI_RDO_HTREE_BRANCH_VIEW, OnIhiRdoHtreeBranchView)
	ON_BN_CLICKED(IDC_IHI_RDO_HTREE_FONT_SMALL, OnIhiRdoHtreeFontSmall)
	ON_BN_CLICKED(IDC_IHI_RDO_HTREE_FONT_MEDIUM, OnIhiRdoHtreeFontMedium)
	ON_BN_CLICKED(IDC_IHI_RDO_HTREE_FONT_LARGE, OnIhiRdoHtreeFontLarge)
	ON_BN_CLICKED(IDC_IHI_BTN_OPEN_PROJECT, OnIhiBtnOpenProject)
	ON_BN_CLICKED(IDC_IHI_BTN_LOAD_PROJECT, OnIhiBtnLoadProject)
	ON_BN_CLICKED(IDC_IHI_BTN_HTREE_ZOOMIN, OnIhiBtnHtreeZoomin)
	ON_BN_CLICKED(IDC_IHI_BTN_HTREE_ZOOMOUT, OnIhiBtnHtreeZoomout)
	ON_BN_CLICKED(IDC_IHI_BTN_LIST_IN_ONE, OnIhiBtnListInOne)
	ON_BN_CLICKED(IDC_IHI_BTN_LIST_IN_LOWER, OnIhiBtnListInLower)
	ON_BN_CLICKED(IDC_IHI_BTN_LIST_IN_ALL, OnIhiBtnListInAll)
	ON_BN_CLICKED(IDC_IHI_BTN_LIST_OUT_ONE, OnIhiBtnListOutOne)
	ON_BN_CLICKED(IDC_IHI_BTN_LIST_OUT_ALL, OnIhiBtnListOutAll)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_USER_WHT_VIEW_MODE_CHANGED, OnUserWhtViewModeChanged)
	ON_MESSAGE(WM_USER_WHT_SELCHANGED, OnUserWhtSelchanged)
	ON_MESSAGE(WM_USER_LCH_DOC_SELCHANGED, OnUserLchDocSelchanged)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCDlgImportHidocument _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::GetProjectPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDhMiBfLiDgHiClHiCoJjBmOiPnLiCmMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString CFCDlgImportHidocument::GetProjectPath () const
{
	return m_projectCopy.GetFilePath();
} // CFCDlgImportHidocument::GetProjectPath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::GetDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDhMiBfLiDgHiClHiCoJjBmOiPnLiCmMjHjKjHpAjFlGiPjBiCgIiCgDiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stDocId	:_xZkqqHx_jHjKjHpAjFlGiPjBiCgIiCgDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::GetDocumentId (longSet& stDocId) const
{
	m_lsvHidocument.GetHidocument(stDocId);
} // CFCDlgImportHidocument::GetDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::UpdateControls
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiBhGiDfCiDjDiDgHiDiNiBfLiDiLiCpAiPjMiCkNiCnJiCkJiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmM_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::UpdateControls ()
{
	if (m_lsvHidocument.GetSelectedHidocumentId() == -1)
	//----- _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
		FFSetDlgItemText(this, IDC_IHI_EDT_REGISTER_DATE, L"");
		// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
		FFSetDlgItemText(this, IDC_IHI_EDT_USER_ID, L"");
		// [_xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfO_xHqqkZx_]_xZkqqHx_iDgAiDeGiDgCiDeOiDhLiDgCiDeOiDfIiCmMiDgAiDeGiDgCiDeOiDhNiBfLiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
		m_stcChkLogCommandUserId.SetCheck(FALSE);

		// _xZkqqHx_iDfCiDiBiDjDiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmJjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
		FFSetDlgItemText(this, IDC_IHI_EDT_COMMENT, L"");
	} else
	//----- _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		const FCDocumentRecCopy* pDocRec = m_projectCopy.GetDocumentRec(m_lsvHidocument.GetSelectedHidocumentId());
		// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
		COleDateTime otmDate = FdsecToFiletime(pDocRec->GetDate());
	    // IDS_FORM_DATE_TIME_LONG "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d_xZkqqHx_jDpK_xHqqkZx_ %#H_xZkqqHx_iOjO_xHqqkZx_%#M_xZkqqHx_jFkK_xHqqkZx_"
		SetDlgItemText(IDC_IHI_EDT_REGISTER_DATE, otmDate.Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));

//----- 05.10.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		if (pDocRec->GetUserId() != GUID_NULL)
//		//---- _xZkqqHx_iNoMjAkMiOnCiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			WString wstrUserId;
//			wstrUserId.Format(L"%s (%s-%04X)",	m_projectCopy.UserIdToUserName(pDocRec->GetUserId()),
//												FFGuidToString(pDocRec->GetUserId()).c_str(),
//												FFGetGuidCheckCode(pDocRec->GetUserId()));
//			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
//			FFSetDlgItemText(this, IDC_IHI_EDT_USER_ID, wstrUserId);
//		} else
//		//---- _xZkqqHx_iNoMjAkMiOnCiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
//			FFSetDlgItemText(this, IDC_IHI_EDT_USER_ID, L"");
//		}
//----- 05.10.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
		FFSetDlgItemText(this, IDC_IHI_EDT_USER_ID,
						FFGetFormedUserId(	pDocRec->GetUserId(),
											m_projectCopy.UserIdToUserName(pDocRec->GetUserId())));
//----- 05.10.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		// [_xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfO_xHqqkZx_]_xZkqqHx_iDgAiDeGiDgCiDeOiDhLiDgCiDeOiDfIiCmJiDgAiDeGiDgCiDeOiDhNiBfLiDeOjAnNjCoIiBeC_xHqqkZx_
		if (pDocRec->GetIsLogCommandUserId())
			m_stcChkLogCommandUserId.SetCheck(TRUE);
		else
			m_stcChkLogCommandUserId.SetCheck(FALSE);
		// _xZkqqHx_iDfCiDiBiDjDiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmJjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
		FFSetDlgItemText(this, IDC_IHI_EDT_COMMENT, pDocRec->GetComment());
	}
} // CFCDlgImportHidocument::UpdateControls.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::UpdateActivate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::UpdateActivate ()
{
// 05.09.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (*m_pWndHTree->GetSelectedProjectPath() == L'\0')
	if (!m_pWndHTree->IsSelectedProjectOpened())
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjBeJjBpAiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_jHjKjHpAiDhCiDiFiBfLjFfMiOkGiDiCiBfLiDgIiCmMiDiJiDfHiDeJiDhLiDfOiDjD_xHqqkZx_ ------
		GetDlgItem(IDC_IHI_RDO_HTREE_PROJECT_VIEW)->EnableWindow(FALSE);
		GetDlgItem(IDC_IHI_RDO_HTREE_TREE_VIEW)->EnableWindow(FALSE);
		GetDlgItem(IDC_IHI_RDO_HTREE_BRANCH_VIEW)->EnableWindow(FALSE);
		//----- _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDhEiDeIiDjDiDgHiCmMiDiJiDfHiDeJiDhLiDfOiDjD_xHqqkZx_ ------
		GetDlgItem(IDC_IHI_RDO_HTREE_FONT_SMALL)->EnableWindow(FALSE);
		GetDlgItem(IDC_IHI_RDO_HTREE_FONT_MEDIUM)->EnableWindow(FALSE);
		GetDlgItem(IDC_IHI_RDO_HTREE_FONT_LARGE)->EnableWindow(FALSE);
		//----- _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiCmMiDfJiBfLiDiAiDhLiDfOiDjD_xHqqkZx_ ------
		GetDlgItem(IDC_IHI_BTN_HTREE_ZOOMIN)->EnableWindow(FALSE);
		GetDlgItem(IDC_IHI_BTN_HTREE_ZOOMOUT)->EnableWindow(FALSE);
		// _xZkqqHx_iBhFiIoKiCmCiCpAjCmHiJmBiBhGiDhLiDfOiDjDiBeC_xHqqkZx_
		GetDlgItem(IDC_IHI_BTN_LIST_IN_ONE)->EnableWindow(FALSE);
		// _xZkqqHx_iBhFiImIiJlKiCmMiOhNiCpAjCmHiJmBiBhGiDhLiDfOiDjDiBeC_xHqqkZx_
		GetDlgItem(IDC_IHI_BTN_LIST_IN_LOWER)->EnableWindow(FALSE);
		// _xZkqqHx_iBhFjBfDiCmEiCpAjCmHiJmBiBhGiDhLiDfOiDjDiBeC_xHqqkZx_
		GetDlgItem(IDC_IHI_BTN_LIST_IN_ALL)->EnableWindow(FALSE);
	} else
	{
		if (!m_pWndHTree->IsDocumentSelected())
		//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKjBeJjBpAiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			//----- _xZkqqHx_jHjKjHpAiDhCiDiFiBfLjFfMiOkGiDiCiBfLiDgIiCmMiDiJiDfHiDeJiDhLiDfOiDjD_xHqqkZx_ ------
			GetDlgItem(IDC_IHI_RDO_HTREE_PROJECT_VIEW)->EnableWindow(TRUE);
			GetDlgItem(IDC_IHI_RDO_HTREE_TREE_VIEW)->EnableWindow(FALSE);
			GetDlgItem(IDC_IHI_RDO_HTREE_BRANCH_VIEW)->EnableWindow(FALSE);
			// _xZkqqHx_iBhFiIoKiCmCiCpAjCmHiJmBiBhGiDhLiDfOiDjDiBeC_xHqqkZx_
			GetDlgItem(IDC_IHI_BTN_LIST_IN_ONE)->EnableWindow(FALSE);
			// _xZkqqHx_iBhFiImIiJlKiCmMiOhNiCpAjCmHiJmBiBhGiDhLiDfOiDjDiBeC_xHqqkZx_
			GetDlgItem(IDC_IHI_BTN_LIST_IN_LOWER)->EnableWindow(FALSE);
		} else
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiBeBjHjKjHpAjFlGiPjBiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			//----- _xZkqqHx_jHjKjHpAiDhCiDiFiBfLjFfMiOkGiDiCiBfLiDgIiCmMiDiJiDfHiDeJiDhLiDfOiDjD_xHqqkZx_ ------
			GetDlgItem(IDC_IHI_RDO_HTREE_PROJECT_VIEW)->EnableWindow(TRUE);
			GetDlgItem(IDC_IHI_RDO_HTREE_TREE_VIEW)->EnableWindow(TRUE);
			GetDlgItem(IDC_IHI_RDO_HTREE_BRANCH_VIEW)->EnableWindow(TRUE);
			// _xZkqqHx_iBhFiIoKiCmCiCpAjCmHiJmBiBhGiDhLiDfOiDjDiBeC_xHqqkZx_
			GetDlgItem(IDC_IHI_BTN_LIST_IN_ONE)->EnableWindow(TRUE);
			// _xZkqqHx_iBhFiImIiJlKiCmMiOhNiCpAjCmHiJmBiBhGiDhLiDfOiDjDiBeC_xHqqkZx_
			GetDlgItem(IDC_IHI_BTN_LIST_IN_LOWER)->EnableWindow(TRUE);
		}
		//----- _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDhEiDeIiDjDiDgHiCmMiDiJiDfHiDeJiDhLiDfOiDjD_xHqqkZx_ ------
		GetDlgItem(IDC_IHI_RDO_HTREE_FONT_SMALL)->EnableWindow(TRUE);
		GetDlgItem(IDC_IHI_RDO_HTREE_FONT_MEDIUM)->EnableWindow(TRUE);
		GetDlgItem(IDC_IHI_RDO_HTREE_FONT_LARGE)->EnableWindow(TRUE);
		//----- _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiCmMiDfJiBfLiDiAiDhLiDfOiDjD_xHqqkZx_ ------
//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		switch (m_pWndHTree->GetViewMode())
		{
		case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
			GetDlgItem(IDC_IHI_BTN_HTREE_ZOOMIN)->EnableWindow(TRUE);
			GetDlgItem(IDC_IHI_BTN_HTREE_ZOOMOUT)->EnableWindow(TRUE);
			break;
		default:	// case FDHT_VMODE_PROJECT:		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
			GetDlgItem(IDC_IHI_BTN_HTREE_ZOOMIN)->EnableWindow(FALSE);
			GetDlgItem(IDC_IHI_BTN_HTREE_ZOOMOUT)->EnableWindow(FALSE);
		}
//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iBhFjBfDiCmEiCpAjCmHiJmBiBhGiDhLiDfOiDjDiBeC_xHqqkZx_
		GetDlgItem(IDC_IHI_BTN_LIST_IN_ALL)->EnableWindow(TRUE);
	}

	if (m_lsvHidocument.GetSelectedHidocumentId() != -1)
	//----- _xZkqqHx_iDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmFjFlGiPjBiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iBhFiIoKiCmCiCpAiJpAiPjMiBhGiDhLiDfOiDjDiBeC_xHqqkZx_
		GetDlgItem(IDC_IHI_BTN_LIST_OUT_ONE)->EnableWindow(TRUE);
	} else
	//----- _xZkqqHx_iDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmFjFlGiPjBiCkKjBeJjBpAiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iBhFiIoKiCmCiCpAiJpAiPjMiBhGiDhLiDfOiDjDiBeC_xHqqkZx_
		GetDlgItem(IDC_IHI_BTN_LIST_OUT_ONE)->EnableWindow(FALSE);
	}
	if (m_lsvHidocument.GetItemCount() != 0)
	//----- _xZkqqHx_iDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmJiDiKiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iBhFjBfDiCmEiCpAiJpAiPjMiBhGiDhLiDfOiDjDiBeC_xHqqkZx_
		GetDlgItem(IDC_IHI_BTN_LIST_OUT_ALL)->EnableWindow(TRUE);
	} else
	//----- _xZkqqHx_iDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmJiDiKiDfIiDgHiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iBhFjBfDiCmEiCpAiJpAiPjMiBhGiDhLiDfOiDjDiBeC_xHqqkZx_
		GetDlgItem(IDC_IHI_BTN_LIST_OUT_ALL)->EnableWindow(FALSE);
	}

} // CFCDlgImportHidocument::UpdateActivate.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgImportHidocument _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

int CFCDlgImportHidocument::OnCreate (LPCREATESTRUCT lpCreateStruct)
{
	if (BASE_CLASS::OnCreate(lpCreateStruct) == -1)
		return -1;

	m_pWndHTree = new CFCWndHistoryTree();
	return 0;
} // CFCDlgImportHidocument::OnCreate.

void CFCDlgImportHidocument::OnDestroy ()
{
	BASE_CLASS::OnDestroy();

	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiBeC_xHqqkZx_
	delete m_pWndHTree;
	m_pWndHTree = NULL;
} // CFCDlgImportHidocument::OnDestroy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiOjOiCmJiOmAiNhDiBeC_xHqqkZx_
 *
_xZkqqHx_iEkL_xHqqkZx_ <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgImportHidocument::OnInitDialog ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnInitDialog();

	//----- _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjAlGjAkM_xHqqkZx_ -----
	DWORDVector vActionList;
	// _xZkqqHx_jBfDiDhCiDiFiBfLiCmFiBeBiDhGiDiNiDfHiDeGiDeOiDgHiBeFjFlGiPjBiPoDiCmFiBeBiNlGiDhLiDfOiDjDiDfPiDeFiDjDiCmMiPoKiNiHiCmNiBeBjBeJjBpAiCpAjFmPiNfIiBeC_xHqqkZx_
	vActionList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_PROJECT|FD_WHT_ON_DOCUMENT | FD_WHT_MS_LBDOWN | FD_WHT_AC_SELECT);
	// _xZkqqHx_jBfDiDhCiDiFiBfLiCmFiBeBiDhGiDiNiDfHiDeGiDeOiDgHiBeFjFlGiPjBiPoDiCmFiBeBiDfGiDhEiDgHiDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiBeBiNlGiDhLiDfOiDjDiDfPiDeFiDjDiCmMiPoKiNiHiCmNiBeBiJlKiImKiCmMiDhCiDiFiBfLiDiCiBfLiDgIiBeC_xHqqkZx_
	vActionList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_PROJECT|FD_WHT_ON_DOCUMENT | FD_WHT_MS_LBDOWN | FD_WHT_KY_SHIFT | FD_WHT_AC_LOWER);
	// _xZkqqHx_jBfDiDhCiDiFiBfLiCmFiBeBjEhHiMgJiCmFiBeBiDfGiDhEiDgHiDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiBeBiNlGiDhLiDfOiDjDiDfPiDeFiDjDiCmMiPoKiNiHiCmNiBeBiPoDiImKiCmMiDhCiDiFiBfLiDiCiBfLiDgIiBeC_xHqqkZx_
	vActionList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_BACKGROUND | FD_WHT_MS_LBDOWN | FD_WHT_KY_SHIFT | FD_WHT_AC_UPPER);
	// _xZkqqHx_jBfDiDhCiDiFiBfLiCmFiBeBiDhGiDiNiDfHiDeGiDeOiDgHiBeFjFlGiPjBiPoDiCmFiBeBiDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiBeBiNlGiDhLiDfOiDjDiDfPiDeFiDjDiCmMiPoKiNiHiCmNiBeBjBeJjBpAiCpAjFmPiNfIiBeC_xHqqkZx_
	vActionList.push_back(FD_WHT_VW_ALL | FD_WHT_ON_PROJECT|FD_WHT_ON_DOCUMENT | FD_WHT_MS_LBDOWN | FD_WHT_KY_CTRL | FD_WHT_AC_SELECT);
	CRect rtWnd;
	GetDlgItem(IDC_IHI_STC_HTREE)->GetWindowRect(rtWnd);
	ScreenToClient(rtWnd);
	m_pWndHTree->Create(WS_EX_CLIENTEDGE|WS_EX_WINDOWEDGE,
						WS_VISIBLE|WS_CHILD|WS_TABSTOP|WS_VSCROLL,
						rtWnd,						// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiLoJiMgAiBeC_xHqqkZx_
						this,						// _xZkqqHx_jAgFiDeFiDeDiDjDiDgIiDeFiBeC_xHqqkZx_
						NULL,						// _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						this,						// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHjBjHjFhEjAoGiBeC_xHqqkZx_
						FALSE,						// _xZkqqHx_iOkJjDkO_xHqqkZx_ALT_xZkqqHx_iBeC_xHqqkZx_
						&vActionList[0],			// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiDiKiDfIiDgHiBeC_xHqqkZx_
						vActionList.size(),
						NULL,						// _xZkqqHx_iDiBiDgKiDiFiBfL_xHqqkZx_ID_xZkqqHx_iDiKiDfIiDgHiBeC_xHqqkZx_
						0,
						NULL);
	m_pWndHTree->SetFontZoom(1.0);

	// _xZkqqHx_iDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	m_lsvHidocument.Initialize();
	m_lsvHidocument.SetHidocument(m_projectCopy, longSet());

	CButton* pButton;
	//----- _xZkqqHx_iDhCiDiFiBfLiDiCiBfLiDgIjFmPiNfIiDhLiDfOiDjDiCmMiDeBiDeDiDfCiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	pButton = (CButton*)GetDlgItem(IDC_IHI_RDO_HTREE_PROJECT_VIEW);
	pButton->SetIcon(FFGetApp()->LoadIcon(IDI_HTREE_PROJECT_VIEW));
	pButton = (CButton*)GetDlgItem(IDC_IHI_RDO_HTREE_TREE_VIEW);
	pButton->SetIcon(FFGetApp()->LoadIcon(IDI_HTREE_TREE_VIEW));
	pButton = (CButton*)GetDlgItem(IDC_IHI_RDO_HTREE_BRANCH_VIEW);
	pButton->SetIcon(FFGetApp()->LoadIcon(IDI_HTREE_BRANCH_VIEW));

	//----- _xZkqqHx_iDhEiDeIiDjDiDgHiDfEiDeDiDfJjFmPiNfIiDhLiDfOiDjDiCmMiDeBiDeDiDfCiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	pButton = (CButton*)GetDlgItem(IDC_IHI_RDO_HTREE_FONT_SMALL);
	pButton->SetIcon(FFGetApp()->LoadIcon(IDI_HTREE_FONT_SMALL));
	pButton = (CButton*)GetDlgItem(IDC_IHI_RDO_HTREE_FONT_MEDIUM);
	pButton->SetIcon(FFGetApp()->LoadIcon(IDI_HTREE_FONT_MEDIUM));
	pButton = (CButton*)GetDlgItem(IDC_IHI_RDO_HTREE_FONT_LARGE);
	pButton->SetIcon(FFGetApp()->LoadIcon(IDI_HTREE_FONT_LARGE));

	//----- _xZkqqHx_iDfJiBfLiDiAjFmPiNfIiDhLiDfOiDjDiCmMiDeBiDeDiDfCiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	pButton = (CButton*)GetDlgItem(IDC_IHI_BTN_HTREE_ZOOMIN);
	pButton->SetIcon(FFGetApp()->LoadIcon(IDI_HTREE_ZOOMIN));
	pButton = (CButton*)GetDlgItem(IDC_IHI_BTN_HTREE_ZOOMOUT);
	pButton->SetIcon(FFGetApp()->LoadIcon(IDI_HTREE_ZOOMOUT));

	// _xZkqqHx_iDhCiDiFiBfLiDiCiBfLiDgIjFmPiNfIiDiJiDfHiDeJiDhLiDfOiDjDiCmMiPpDjBnEiCpAjAnNjCoIiBeC_xHqqkZx_
	CheckRadioButton(IDC_IHI_RDO_HTREE_PROJECT_VIEW, IDC_IHI_RDO_HTREE_BRANCH_VIEW, IDC_IHI_RDO_HTREE_PROJECT_VIEW);
	// _xZkqqHx_iDhEiDeIiDjDiDgHiDfEiDeDiDfJjFmPiNfIiDiJiDfHiDeJiDhLiDfOiDjDiCmMiPpDjBnEiCpAjAnNjCoIiBeC_xHqqkZx_
	CheckRadioButton(IDC_IHI_RDO_HTREE_FONT_SMALL, IDC_IHI_RDO_HTREE_FONT_LARGE, IDC_IHI_RDO_HTREE_FONT_LARGE);

	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPiNfIiBeC_xHqqkZx_
	UpdateControls();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiCpAjFmPiNfIiBeC_xHqqkZx_
	UpdateActivate();

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
	FFJustifyWindow(m_hWnd);

	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCDlgImportHidocument::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiBtnOpenProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDhGiDiNiDfHiDeGiDeOiDgHiCpAiKeKiCkNiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiBtnOpenProject ()
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIjFlGiOjKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
	WString wstrFilePath;
	FFGetDlgItemText(this, IDC_IHI_EDT_PROJECT_PATH, wstrFilePath);
	if (wstrFilePath.IsEmpty())
	//----- _xZkqqHx_iKpJjBlGiDhEiDeAiDeDiDiLiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		wstrFilePath = g_pFileServer->GetCurrentDirectory() + L"\\*.mdpj";
	}
	// _xZkqqHx_iDhEiDeAiDeDiDiLjDpMjHmNiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
	// IDS_OPEN_PROJECT = "_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiKeKiCkN_xHqqkZx_"
	WString wstrNewFilePath;
//----- 05.10.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (g_pFileServer->OnDlgOpenTopGroup(
//				TRUE,
//				wstrNewFilePath,
//				FFLoadWString(IDS_OPEN_PROJECT),
//				wstrFilePath.c_str(),
//				OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY,
//				L"Dynamic Draw Projects (*.mdpj)|*.mdpj||") == IDOK)
//----- 05.10.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (g_pFileServer->OnDlgOpenTopGroup(	wstrNewFilePath,
											m_hWnd,
											FFLoadWString(IDS_OPEN_PROJECT),
											wstrFilePath.c_str(),
											L"Dynamic Draw Projects",
											L".mdpj") == IDOK)
//----- 05.10.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	{
		// _xZkqqHx_jAfGiClFiCkCiDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAjAnNjCoIiBeC_xHqqkZx_
		FFSetDlgItemText(this, IDC_IHI_EDT_PROJECT_PATH, wstrNewFilePath);
	}
} // CFCDlgImportHidocument::OnIhiBtnOpenProject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiBtnLoadProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDhGiDiNiDfHiDeGiDeOiDgHiCpAjDmHiCnNiNjOiCnOiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiBtnLoadProject ()
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIjFlGiOjKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
	WString wstrFilePath;
	FFGetDlgItemText(this, IDC_IHI_EDT_PROJECT_PATH, wstrFilePath);
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClHiCoJiDhEiDeAiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
//	FCDbReadLock autoLockProjectRead(wstrFilePath, FALSE);
//	if (!autoLockProjectRead.TryLock())
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAiOjOiMmAiDhAiDgMiDiLiCmFjFfMiOkGiBeC_xHqqkZx_
//		FFErrorBox(FFGetDDErrorMessage());
//	} else
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		m_projectCopy.SetFilePath(wstrFilePath);
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FCHiProject project = g_pFileServer->GetTopGroup(HString(wstrFilePath));
	// _xZkqqHx_iDiNiDgCiDeOiClHiCoJiDhEiDeAiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	FCDbReadLock autoLockProjectRead;
	if (!project.TryLock(autoLockProjectRead))
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAiOjOiMmAiDhAiDgMiDiLiCmFjFfMiOkGiBeC_xHqqkZx_
		FFErrorBox(FFGetDDErrorMessage());
	} else
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		project.UpdateData(autoLockProjectRead);
		m_projectCopy = project;
		m_lsvHidocument.SetHidocument(m_projectCopy, longSet());
		if (!m_pWndHTree->SyncToDocument(
						FDHT_VMODE_PROJECT,				// _xZkqqHx_jAfGiClFiCkCiDhCiDiFiBfLiDiCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
						m_projectCopy.GetFilePath(),	// _xZkqqHx_iDhCiDiFiBfLiCmJjFfMiOkGiClHiCoJjHjKjHpAjFlGiPjBiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
						-1,								// _xZkqqHx_iDhCiDiFiBfLiCmJjFfMiOkGiClHiCoJjHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
						-1,								// _xZkqqHx_iDhNiBfLiDeKiBfLjFfMiOkGjBmOiPnLiCmMjFlGiPjBiImKjChFiBeC_xHqqkZx_
						TRUE,
						FALSE,
						FALSE,							// _xZkqqHx_iDfJiBfLiDiAjCgMiCpAiBeBjHjKjHpAjGnIiCkKiOpLiCnMiCoJiCoGiCkEiCmJjClCjAkOiClHiCoJiCkJiBeI_xHqqkZx_
						TRUE))							// _xZkqqHx_iDhNiBfLiDeKiBfLjFfMiOkGjBmOiPnLiCpAiBeBiMlLiNnNiCmMjFfMiOkGiCmGiClFiCmEjAnNjCoIiClHiCoJiCkJiBeI_xHqqkZx_
			FFErrorBox(FFGetDDErrorMessage());
//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPiNfIiBeC_xHqqkZx_
		UpdateControls();
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiCpAjFmPiNfIiBeC_xHqqkZx_
		UpdateActivate();
//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
} // CFCDlgImportHidocument::OnIhiBtnLoadProject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiRdoHtreeProjectView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiDhGiDiNiDfHiDeGiDeOiDgHiDhCiDiFiBfLiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiRdoHtreeProjectView ()
{
	if (!m_pWndHTree->ChangeViewMode(FDHT_VMODE_PROJECT))
		FFErrorBox(FFGetDDErrorMessage());
//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiCpAjFmPiNfIiBeC_xHqqkZx_
	UpdateActivate();
//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCDlgImportHidocument::OnIhiRdoHtreeProjectView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiRdoHtreeTreeView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiDgDiDiKiBfLiDhCiDiFiBfLiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiRdoHtreeTreeView ()
{
	if (!m_pWndHTree->ChangeViewMode(FDHT_VMODE_TREE))
		FFErrorBox(FFGetDDErrorMessage());
//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiCpAjFmPiNfIiBeC_xHqqkZx_
	UpdateActivate();
//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCDlgImportHidocument::OnIhiRdoHtreeTreeView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiRdoHtreeBranchView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiDhFiDiJiDjDiDgAiDhCiDiFiBfLiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiRdoHtreeBranchView ()
{
	if (!m_pWndHTree->ChangeViewMode(FDHT_VMODE_BRANCH))
		FFErrorBox(FFGetDDErrorMessage());
//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiCpAjFmPiNfIiBeC_xHqqkZx_
	UpdateActivate();
//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCDlgImportHidocument::OnIhiRdoHtreeBranchView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiRdoHtreeFontSmall
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiPkMiClDiCkCiDhEiDeIiDjDiDgHiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiRdoHtreeFontSmall ()
{
	m_pWndHTree->SetFontZoom(0.5);
} // CFCDlgImportHidocument::OnIhiRdoHtreeFontSmall.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiRdoHtreeFontMedium
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFjFiBjCmKiCmMiDhEiDeIiDjDiDgHiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiRdoHtreeFontMedium ()
{
	m_pWndHTree->SetFontZoom(0.75);
} // CFCDlgImportHidocument::OnIhiRdoHtreeFontMedium.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiRdoHtreeFontLarge
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFjBoFiCkLiCkCiDhEiDeIiDjDiDgHiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiRdoHtreeFontLarge ()
{
	m_pWndHTree->SetFontZoom(1.0);
} // CFCDlgImportHidocument::OnIhiRdoHtreeFontLarge.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnUserWhtViewModeChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhCiDiFiBfLiDiCiBfLiDgIiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDhCiDiFiBfLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCfAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCDlgImportHidocument::OnUserWhtViewModeChanged (WPARAM wParam, LPARAM lParam)
{
	DWORD dwMode = 0;
	switch (m_pWndHTree->GetViewMode())
	{
	case FDHT_VMODE_PROJECT:		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		dwMode = IDC_IHI_RDO_HTREE_PROJECT_VIEW;
		break;
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		dwMode = IDC_IHI_RDO_HTREE_TREE_VIEW;
		break;
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		dwMode = IDC_IHI_RDO_HTREE_BRANCH_VIEW;
		break;
	}
	CheckRadioButton(IDC_IHI_RDO_HTREE_PROJECT_VIEW, IDC_IHI_RDO_HTREE_BRANCH_VIEW, dwMode);
	return 1;
} // CFCDlgImportHidocument::OnUserWhtViewModeChanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnUserWhtSelchanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDhCiDiFiBfLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCfAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCDlgImportHidocument::OnUserWhtSelchanged (WPARAM wParam, LPARAM lParam)
{
	long lSelectedDocumentId;
	if (m_pWndHTree->IsDocumentSelected(NULL, &lSelectedDocumentId))
	{
		// _xZkqqHx_iDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMjBeJjBpAiCpAjFmPiNfIiBeC_xHqqkZx_
		m_lsvHidocument.SetSelectedHidocumentId(lSelectedDocumentId);
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiCpAjFmPiNfIiBeC_xHqqkZx_
		UpdateActivate();
	}
	return 1;
} // CFCDlgImportHidocument::OnUserWhtSelchanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnUserLchDocSelchanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDhCiDiFiBfLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jBeJjBpAiClDiCoKiClNjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCfAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCDlgImportHidocument::OnUserLchDocSelchanged (WPARAM wParam, LPARAM lParam)
{
	long lDocId = long(lParam);
//----- 05.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_pWndHTree->SyncToDocument(
//			FDHT_VMODE_NONE,				// _xZkqqHx_jAfGiClFiCkCiDhCiDiFiBfLiDiCiBfLiDgIiCpAiOhHjCoIiBeCjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FDHT_VMODE_NONE_xZkqqHx_iBeC_xHqqkZx_
//			m_projectCopy.GetFilePath(),		// _xZkqqHx_iDhCiDiFiBfLiCmJjFfMiOkGiClHiCoJjHjKjHpAjFlGiPjBiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
//			lDocId,							// _xZkqqHx_iDhCiDiFiBfLiCmJjFfMiOkGiClHiCoJjHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
//			L"",							// _xZkqqHx_iDhNiBfLiDeKiBfLjFfMiOkGjBmOiPnLiCmMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiBeC_xHqqkZx_
//			-1,								// _xZkqqHx_iDhNiBfLiDeKiBfLjFfMiOkGjBmOiPnLiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//			0,								// _xZkqqHx_iDhNiBfLiDeKiBfLjFfMiOkGjBmOiPnLiCmMjFlGiPjBiImKjChFiBeC_xHqqkZx_
//			FALSE,							// _xZkqqHx_iDfJiBfLiDiAjCgMiCpAiBeBjHjKjHpAjGnIiCkKiOpLiCnMiCoJiCoGiCkEiCmJjClCjAkOiClHiCoJiCkJiBeI_xHqqkZx_
//			FALSE);							// _xZkqqHx_iDhNiBfLiDeKiBfLjFfMiOkGjBmOiPnLiCpAiBeBiMlLiNnNiCmMjFfMiOkGiCmGiClFiCmEjAnNjCoIiClHiCoJiCkJiBeI_xHqqkZx_
//----- 05.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!m_pWndHTree->SyncToDocument(
					FDHT_VMODE_NONE,				// _xZkqqHx_jAfGiClFiCkCiDhCiDiFiBfLiDiCiBfLiDgIiCpAiOhHjCoIiBeCjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FDHT_VMODE_NONE_xZkqqHx_iBeC_xHqqkZx_
					m_projectCopy.GetFilePath(),		// _xZkqqHx_iDhCiDiFiBfLiCmJjFfMiOkGiClHiCoJjHjKjHpAjFlGiPjBiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
					lDocId,							// _xZkqqHx_iDhCiDiFiBfLiCmJjFfMiOkGiClHiCoJjHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
					-1,								// _xZkqqHx_iDhNiBfLiDeKiBfLjFfMiOkGjBmOiPnLiCmMjFlGiPjBiImKjChFiBeC_xHqqkZx_
					TRUE,
					FALSE,
					FALSE,							// _xZkqqHx_iDfJiBfLiDiAjCgMiCpAiBeBjHjKjHpAjGnIiCkKiOpLiCnMiCoJiCoGiCkEiCmJjClCjAkOiClHiCoJiCkJiBeI_xHqqkZx_
					FALSE))							// _xZkqqHx_iDhNiBfLiDeKiBfLjFfMiOkGjBmOiPnLiCpAiBeBiMlLiNnNiCmMjFfMiOkGiCmGiClFiCmEjAnNjCoIiClHiCoJiCkJiBeI_xHqqkZx_
		FFErrorBox(FFGetDDErrorMessage());
//----- 05.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPiNfIiBeC_xHqqkZx_
	UpdateControls();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiCpAjFmPiNfIiBeC_xHqqkZx_
	UpdateActivate();
	return 1;
} // CFCDlgImportHidocument::OnUserLchDocSelchanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiBtnHtreeZoomin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiDfJiBfLiDiAiDeDiDjDiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiBtnHtreeZoomin ()
{
	long lZoom100 = D2L(m_pWndHTree->GetZoom() * 100.0);
	// _xZkqqHx_iMlLiNnNiCmMiDfJiBfLiDiAjCgMiCoGiCoIiBeBiIoKiCmCiPkMiClDiCkCjCgMiCpAjBeJjBpAiBeC_xHqqkZx_
	long lNewZoom = D2L(double(FFGetUpperZoomValue(ID_HTREE_CMB_ZOOM, lZoom100)) * 2.56);
	m_pWndHTree->PostMessage(WM_USER_SET_ZOOM256, TRUE, lNewZoom);
} // CFCDlgImportHidocument::OnIhiBtnHtreeZoomin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiBtnHtreeZoomout
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiDfJiBfLiDiAiDeBiDeFiDgHiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiBtnHtreeZoomout ()
{
	long lZoom100 = D2L(m_pWndHTree->GetZoom() * 100.0);
	// _xZkqqHx_iMlLiNnNiCmMiDfJiBfLiDiAjCgMiCoGiCoIiBeBiIoKiCmCiPkMiClDiCkCjCgMiCpAjBeJjBpAiBeC_xHqqkZx_
	long lNewZoom = D2L(double(FFGetLowerZoomValue(ID_HTREE_CMB_ZOOM, lZoom100)) * 2.56);
	m_pWndHTree->PostMessage(WM_USER_SET_ZOOM256, TRUE, lNewZoom);
} // CFCDlgImportHidocument::OnIhiBtnHtreeZoomout.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiBtnListInOne
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiIoKiCmCiCpAjCmHiJmBiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiBtnListInOne ()
{
	long lSelectedDocumentId;
	if (m_pWndHTree->IsDocumentSelected(NULL, &lSelectedDocumentId))
		m_lsvHidocument.AddHidocument(lSelectedDocumentId);
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiCpAjFmPiNfIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCDlgImportHidocument::OnIhiBtnListInOne.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiBtnListInLower
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiImIiJlKiCmMiOhNiCpAjCmHiJmBiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiBtnListInLower ()
{
	long lSelectedDocumentId;
	if (m_pWndHTree->IsDocumentSelected(NULL, &lSelectedDocumentId))
	{
		longSet stDocId;
		m_projectCopy.GetLowerHidocument(stDocId, lSelectedDocumentId);
		m_lsvHidocument.AddHidocument(stDocId);
	}
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiCpAjFmPiNfIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCDlgImportHidocument::OnIhiBtnListInLower.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiBtnListInAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFjBfDiCmEiCpAjCmHiJmBiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiBtnListInAll ()
{
	longSet stDocId;
	long lDocId;
	const FCDocumentRecCopy* pDocRec;
	for (pDocRec = m_projectCopy.GetFirstHidocumentRec(lDocId);
		 lDocId != -1;
		 pDocRec = m_projectCopy.GetNextHidocumentRec(lDocId))
	{
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iJlMiCmMjHjKjHpAjFlGiPjBiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
//		if (pDocRec->GetIsTemporary()) continue;
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		stDocId.insert(lDocId);
	}
	m_lsvHidocument.AddHidocument(stDocId);
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiCpAjFmPiNfIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCDlgImportHidocument::OnIhiBtnListInAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiBtnListOutOne
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiIoKiCmCiCpAiJpAiPjMiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiBtnListOutOne ()
{
	if (m_lsvHidocument.GetSelectedHidocumentId() != -1)
		m_lsvHidocument.DelHidocument(m_lsvHidocument.GetSelectedHidocumentId());
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiCpAjFmPiNfIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCDlgImportHidocument::OnIhiBtnListOutOne.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgImportHidocument::OnIhiBtnListOutAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFjBfDiCmEiCpAiJpAiPjMiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgImportHidocument::OnIhiBtnListOutAll ()
{
	m_lsvHidocument.DelHidocumentAll();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiCpAjFmPiNfIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCDlgImportHidocument::OnIhiBtnListOutAll.
