// DlgObjLabelList.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include <algorithm>			// For sort template.
#include "DynamicDraw.h"		// For FFGetApp.
#include "RegData.h"			// For FCRegData.
#include "FoundDoc.h"			// For g_pDoc.
#include "DynamicDrawView.h"	// For g_pView.
#include "UtilMisc.h"				// For FdsecToFiletime.
#include "UtilDlg.h"			// For SetUnitString.etc.
#include "UtilStr.h"			// For FFExtractUntil.
#include "UtilSort.h"			// For FCLess.
#include "UtilWin.h"			// For FFInsertColumn.
#include "SheetManager.h"		// For FCSheetManager.
#include "ObjLabel.h"			// For FCObjLabel.
#include "RichText.h"			// For GetRichText.
#include "PursuerText.h"		// For CFCPursuerText.
#include "DlgObjLabelList.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define FDLL_LABEL_NAME_CLM			0
#define FDLL_LABEL_SHEET_CLM		1
#define FDLL_LABEL_CTIME_CLM		2
#define FDLL_LABEL_MTIME_CLM		3

#define FDLL_LABEL_NAME_WIDTH		200
#define FDLL_LABEL_SHEET_WIDTH		70
#define FDLL_LABEL_CTIME_WIDTH		70
#define FDLL_LABEL_MTIME_WIDTH		70

/////////////////////////////////////////////////////////////////////////////
// CFCDlgObjLabelList _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgObjLabelList::CFCDlgObjLabelList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCDlgObjLabelList::CFCDlgObjLabelList (CWnd* pParent /*=NULL*/)
	: BASE_CLASS(CFCDlgObjLabelList::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFCDlgObjLabelList)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_INIT
} // CFCDlgObjLabelList::CFCDlgObjLabelList.


void CFCDlgObjLabelList::DoDataExchange (CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCDlgObjLabelList)
	DDX_Control(pDX, IDC_LLP_LSV_LABEL_LIST, m_lstLabelList);
	//}}AFX_DATA_MAP
} // CFCDlgObjLabelList::DoDataExchange.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgObjLabelList::UpdateColumnWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFjNiCmJiNiHiCoNiClJiCmEiDeKiDiJiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeKiDiJiDiAiCmMjAnNjCoIiCpAiPeJiCoNiCoHiClJiCmEiCkJiCoHiOmAiNhDiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgObjLabelList::UpdateColumnWidth ()
{
	//----- _xZkqqHx_iDeKiDiJiDiAiCmMjAnNjCoI_xHqqkZx_ -----
	CRect rect;
	m_lstLabelList.GetClientRect(rect);
	// _xZkqqHx_iDiJiDhIiDiLjGlMiCmMjClHiClDiCpAiMhGiOfKiBeC_xHqqkZx_
	long lNameWidth = rect.Width() - FDLL_LABEL_SHEET_WIDTH - 
							FDLL_LABEL_CTIME_WIDTH - FDLL_LABEL_MTIME_WIDTH;
	// _xZkqqHx_iNmFjCoBiCmMiDiJiDhIiDiLjGlMjClHiCpAiJlKiJpBiCoHiCmIiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
	if (lNameWidth < FDLL_LABEL_NAME_WIDTH)
		lNameWidth = FDLL_LABEL_NAME_WIDTH;
	// _xZkqqHx_iOgDiCoIiCmMiDeKiDiJiDiAjClHiCpAjAnNjCoIiBeC_xHqqkZx_
	m_lstLabelList.SetColumnWidth(FDLL_LABEL_NAME_CLM, lNameWidth);
	m_lstLabelList.SetColumnWidth(FDLL_LABEL_SHEET_CLM, FDLL_LABEL_SHEET_WIDTH);
	m_lstLabelList.SetColumnWidth(FDLL_LABEL_CTIME_CLM, FDLL_LABEL_CTIME_WIDTH);
	m_lstLabelList.SetColumnWidth(FDLL_LABEL_MTIME_CLM, FDLL_LABEL_MTIME_WIDTH);
} // CFCDlgObjLabelList::UpdateColumnWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgObjLabelList::InitControl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scid	:pObj_xZkqqHx_iCkKjBkOiClHiCoJiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgObjLabelList::InitControl ()
{
	// _xZkqqHx_iDiJiDhIiDiLjFfMiOkGjIgHiCmMiDfOiDhFjAjEiCpA_xHqqkZx_8_xZkqqHx_iCmJjAnNjCoIiBeCiIoMiCoKiCmIiCkCiCoGiCkEiPkNiCmIiCnPiCmJiClHiCoJiBeC_xHqqkZx_
	((CEdit*)GetDlgItem(IDC_LLP_EDT_LABEL_NAME))->SetTabStops(8);
	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMjAnNjCoI_xHqqkZx_ -----
	// _xZkqqHx_jBfDiDeKiDiJiDiAjBeJjBpAiCmMiKgHjCkDiDfIiDfOiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	m_lstLabelList.SetExtendedStyle(m_lstLabelList.GetExtendedStyle()|LVS_EX_FULLROWSELECT);
	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLjHhAiCmMiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCmMjAnNjCoI_xHqqkZx_ -----
	m_imageHeadList.Create(16, 16, ILC_MASK, 4, 4);
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_NAME_TAG));		// Image 0.
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_SHEET));			// Image 1.
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_TIME_SIGNAL));	// Image 2.
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_TIME_SIGNAL));	// Image 3.
	// _xZkqqHx_iDhHiDgCiDfPjHhAiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	m_lstLabelList.GetHeaderCtrl()->SetImageList(&m_imageHeadList);
	//----- _xZkqqHx_iDeKiDiJiDiAiCmMjBhNjDpM_xHqqkZx_ -----
	// _xZkqqHx_iDiJiDhIiDiLjFlG_xHqqkZx_\n_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_\n_xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
	WString strMenuTbl;
	strMenuTbl.LoadString(IDS_OBJ_LABEL_LIST_CTRL);
	for (int iC = 0; !strMenuTbl.IsEmpty(); iC++)
	{
		// _xZkqqHx_iDeKiDiJiDiAiDeBiDeDiDgFiDiAiCmMjBhNjDpMiBeC_xHqqkZx_
		FFInsertColumn(&m_lstLabelList, iC, ::FFExtractUntil(strMenuTbl, L"\n"),
									LVCFMT_LEFT, 10);
		//----- _xZkqqHx_iDeKiDiJiDiAiCmJiDeBiDeDiDfCiDjDiCpAjAnNjCoI_xHqqkZx_ -----
		HD_ITEM curItem;
		curItem.mask= HDI_IMAGE | HDI_FORMAT;
		curItem.iImage= iC;
		curItem.fmt= HDF_LEFT | HDF_IMAGE | HDF_STRING | HDF_BITMAP;
		m_lstLabelList.GetHeaderCtrl()->SetItem(iC, &curItem);
	}
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFjNiCmJiNiHiCoNiClJiCmEiDeKiDiJiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateColumnWidth();
} // CFCDlgObjLabelList::InitControl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgObjLabelList::UpdateList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLjCiGiCmMjFfMiOkGiDeBiDeDiDgFiDiAiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgObjLabelList::UpdateList ()
{
	m_lstLabelList.DeleteAllItems();
	//----- _xZkqqHx_iDiJiDhIiDiLiDiKiDfIiDgHiCmJiDeBiDeDiDgFiDiAiCpAjDgPjIfO_xHqqkZx_ -----
	WString wstrName;
	WString strTime;
	for (long lIdx = 0; lIdx < m_vRecList.size(); lIdx++)
	{
		// _xZkqqHx_iDiJiDhIiDiLjGlMjDgPjIfOiBeC_xHqqkZx_
		FFInsertItem(&m_lstLabelList, lIdx, m_vRecList[lIdx]->wstrLabel);
		// _xZkqqHx_iDfGiBfLiDgHjGlMjDgPjIfOiBeC_xHqqkZx_
		g_pDoc->GetSheetManager()->GetSheetInfo(wstrName, m_vRecList[lIdx]->stidObjLabel);
		FFSetItemText(&m_lstLabelList, lIdx, FDLL_LABEL_SHEET_CLM, wstrName);
		// _xZkqqHx_iNoMjAkMiOjOiKnEjDgPjIfOiBeC_xHqqkZx_
		// _xZkqqHx_jHoBiBeG_xHqqkZx_04/12/19 12:15
		// IDS_FORM_DATE_TIME = "%y/%m/%d %H:%M"
		strTime = TStrToWStr(COleDateTime(FdtimeToFiletime(m_vRecList[lIdx]->pObjLabel->GetLabelCtime())).
								Format(FFLoadString(IDS_FORM_DATE_TIME)));
		FFSetItemText(&m_lstLabelList, lIdx, FDLL_LABEL_CTIME_CLM, strTime);
		// _xZkqqHx_iNfIjAfGiOjOiKnEjDgPjIfOiBeC_xHqqkZx_
		strTime = TStrToWStr(COleDateTime(FdtimeToFiletime(m_vRecList[lIdx]->pObjLabel->GetLabelMtime())).
								Format(FFLoadString(IDS_FORM_DATE_TIME)));
		FFSetItemText(&m_lstLabelList, lIdx, FDLL_LABEL_MTIME_CLM, strTime);
	}
} // CFCDlgObjLabelList::UpdateList.


BEGIN_MESSAGE_MAP(CFCDlgObjLabelList, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCDlgObjLabelList)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LLP_LSV_LABEL_LIST, OnItemchangedLlpLsvLabelList)
	ON_NOTIFY(NM_DBLCLK, IDC_LLP_LSV_LABEL_LIST, OnDblclkLlpLsvLabelList)
	ON_BN_CLICKED(IDC_LLP_BTN_MOVE_VIEW, OnLlpBtnMoveView)
	ON_NOTIFY(LVN_COLUMNCLICK, IDC_LLP_LSV_LABEL_LIST, OnColumnclickLlpLsvLabelList)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_USER_PURSUER_TEXT_NEED_INFO, OnUserPursuerTextNeedInfo)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCDlgObjLabelList _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgObjLabelList::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiOjOiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgObjLabelList::OnInitDialog ()
{
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::OnInitDialog();
	// _xZkqqHx_iKgFiDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	InitControl();
	//_xZkqqHx_iDiMiDfCiBfLiDgIjDgPjIfOiBeC_xHqqkZx_
	g_pDoc->GetObjLabelStid(m_vRecList);
	// _xZkqqHx_iDiJiDhIiDiLiDiKiDfIiDgHiCmJiDeBiDeDiDgFiDiAiCpAjDgPjIfOiBeC_xHqqkZx_
	UpdateList();

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
	if (!IsKindOf(RUNTIME_CLASS(CPropertyPage)))
		::FFJustifyWindow(m_hWnd);
	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCDlgObjLabelList::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgObjLabelList::OnOK
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OK_xZkqqHx_iDhLiDfOiDjDiBeBiJpMiNhDiCkKiJjPiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgObjLabelList::OnOK ()
{
	// _xZkqqHx_iBhFiDiJiDhIiDiLiImKjChFiCpAjFfMiOkGiBhGiDhLiDfOiDjDiCpAiOmAiNhDiBeC_xHqqkZx_
	OnLlpBtnMoveView();
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::OnOK();
} // CFCDlgObjLabelList::OnOK.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgObjLabelList::OnItemchangedLlpLsvLabelList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmJjFmPiNfIiCkKiCkAiCmBiClNiPoKiNiHiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgObjLabelList::OnItemchangedLlpLsvLabelList (NMHDR* pNMHDR, LRESULT* pResult)
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// _xZkqqHx_iDeBiDeDiDgFiDiAiCkKjBeJjBpAiClDiCoKiClNiPoKiNiHiBeBiDiJiDhIiDiLiCpAjFfMiOkGjIgHiCmJjAnNjCoIiBeC_xHqqkZx_
	if (0 <= pNMListView->iItem && pNMListView->iItem < m_vRecList.size() &&
		pNMListView->uChanged & LVIF_STATE && pNMListView->uNewState & LVIS_SELECTED)
		FFSetDlgItemText(this, IDC_LLP_EDT_LABEL_NAME,
						m_vRecList[pNMListView->iItem]->wstrLabel);
	*pResult = 0;
} // CFCDlgObjLabelList::OnItemchangedLlpLsvLabelList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgObjLabelList::OnDblclkLlpLsvLabelList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKiDfPiDhFiDiLiDeOiDiKiDgCiDeOiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgObjLabelList::OnDblclkLlpLsvLabelList (NMHDR* pNMHDR, LRESULT* pResult)
{
	// _xZkqqHx_iBhFiDiJiDhIiDiLiImKjChFiCpAjFfMiOkGiBhGiDhLiDfOiDjDiCpAiOmAiNhDiBeC_xHqqkZx_
	OnLlpBtnMoveView();
	*pResult = 0;
} // CFCDlgObjLabelList::OnDblclkLlpLsvLabelList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgObjLabelList::OnLlpBtnMoveView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDiJiDhIiDiLiImKjChFiCpAjFfMiOkGiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgObjLabelList::OnLlpBtnMoveView ()
{
	POSITION pos = m_lstLabelList.GetFirstSelectedItemPosition();
	// _xZkqqHx_jBeJjBpAiDeBiDeDiDgFiDiAiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (pos == NULL) return;
	// _xZkqqHx_iDfGiBfLiDgHiCpAiInKjDkOiClFiCmEjBfDjBmMiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	int iIndex = m_lstLabelList.GetNextSelectedItem(pos);
	DBLRect mmrtFrame = m_vRecList[iIndex]->pObjLabel->GetResizeFrame();
	g_pView->SetScrollCenter(mmrtFrame.CenterPoint(),
							m_vRecList[iIndex]->stidObjLabel);
	if (!g_pReg->GetIsShowObjLabel())
	{
		// _xZkqqHx_iDiJiDhIiDiLjFjEjFgJjFfMiOkGiDiCiBfLiDgIiCpAjFmPiNfIiBeC_xHqqkZx_
		// SetIsShowObjLabel_xZkqqHx_iCmNiBeBiDfCiDhNiDjDiDgIiCmJiClFiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkK_xHqqkZx_
		// _xZkqqHx_iInDjAhNiClFiCmIiCkCiPoKiPiKiCmFjAnIjCgGiClDiCoKiCmEiClFiCnMiCkEiClNiCnPiBeC_xHqqkZx_
		g_pReg->SetIsShowObjLabel(TRUE);
		// _xZkqqHx_iPeDjAlDiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
		g_pDoc->SetModifiedFlag(TRUE);
		// _xZkqqHx_jFmPiNfIiCpAiDhCiDiFiBfLiCmJjElNiJgGiClHiCoJiBeC_xHqqkZx_
		g_pView->UpdateShowObjLabel();
	}
} // CFCDlgObjLabelList::OnLlpBtnMoveView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgObjLabelList::OnColumnclickLlpLsvLabelList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiJiDiAiCkKiDeOiDiKiDgCiDeOiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgObjLabelList::OnColumnclickLlpLsvLabelList (NMHDR* pNMHDR, LRESULT* pResult)
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// _xZkqqHx_iDeOiDiKiDgCiDeOiClDiCoKiClNiDeKiDiJiDiAiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	WORD wItem = pNMListView->iSubItem;
	// _xZkqqHx_iDfMiBfLiDgHiPiHiCmJiDeKiDiJiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	FFAddSortOrder(g_pDoc->LabelSortOrder(), wItem);
	// _xZkqqHx_iDfMiBfLiDgHiPiHjEhKjHpBiCmJiPfNiCmBiCmEiDiMiDfCiBfLiDgIiCpAiDfMiBfLiDgHiBeC_xHqqkZx_
//----- 02.06.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (auto_ptr_xZkqqHx_jFmPjAjEiCmMjEhKjHpBiCmN_xHqqkZx_sort()_xZkqqHx_iCmFiCmNiOgHiCkGiCmIiCkC_xHqqkZx_)-----
//	sort(m_vRecList.begin(), m_vRecList.end(),
//		FCLess<FCLabelStidRec, FCLabelStidRecAuto>(g_pDoc->LabelSortOrder()));
//----- 02.06.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (auto_ptr_xZkqqHx_jFmPjAjEiCmMjEhKjHpBiCmN_xHqqkZx_sort()_xZkqqHx_iCmFiCmNiOgHiCkGiCmIiCkC_xHqqkZx_)-----
	//_xZkqqHx_iDiMiDfCiBfLiDgIiCpAiJpAjFpKiBeC_xHqqkZx_
	m_vRecList.clear();
	//_xZkqqHx_iDfMiBfLiDgHiClDiCoKiClNiDiMiDfCiBfLiDgIiOoGjDlOiBeC_xHqqkZx_
	g_pDoc->GetObjLabelStid(m_vRecList);
//----- 02.06.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (auto_ptr_xZkqqHx_jFmPjAjEiCmMjEhKjHpBiCmN_xHqqkZx_sort()_xZkqqHx_iCmFiCmNiOgHiCkGiCmIiCkC_xHqqkZx_)-----
	// _xZkqqHx_iDiJiDhIiDiLiDiKiDfIiDgHiCmJiDeBiDeDiDgFiDiAiCpAjDgPjIfOiBeC_xHqqkZx_
	UpdateList();
	*pResult = 0;
} // CFCDlgObjLabelList::OnColumnclickLlpLsvLabelList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgObjLabelList::OnUserPursuerTextNeedInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCkKiDhBiDjDiDgHiPoOjFpBiCmMjAnNjCoIiCpAjHhGiLiBiClHiCoJiNnLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFeLiClIiBeB_xHqqkZx_GetCursorPos_xZkqqHx_iKnGjAjEiCmFiDhNiDeFiDfIiImKjChFiCpAiOoGjDlOiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCkK_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJjHiKiCmBiCmEiCkCiCoJiCmGiBeBiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmIiCmHiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiMlLiNnNiCmMiImKjChFiCmGjAeIiCkCiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmNiBeBiDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiCpAjClCiCnHiBeBiCnMiClIiClLiCmMiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			WM_USER_PURSUER_TEXT_NEED_INFO_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpA_xHqqkZx_SendMessage_xZkqqHx_iCmFjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjGnPiCoIjCgMiCkKiCePiCmMiPoKiNiHiCmNiBeBiClLiCmMiDeFiDeCiDjDiDgIiDeFiCmMjAgFiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jGnPiCoIjCgMiCkKiCePiImIiKePiCmFiCkAiCoJiCkJjAgFiDeFiDeCiDjDiDgIiDeFiCkKjGlDiCkNiCmIiCoJiCnMiCmFiClBiCoKiCpAiMeKiCoIjFnEiClHiBeC_xHqqkZx_
 *			wParam _xZkqqHx_iCmJiCmNiBeBiNmFiPiJiCmJiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClFiClNiDeFiDeCiDjDiDgIiDeFiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCDlgObjLabelList::OnUserPursuerTextNeedInfo (WPARAM wParam, LPARAM)
{
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupObjLabelListHint())
	{
		// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMiMlLiNnNiCmMiImKjChFiCpAiBeBiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
		CPoint dvptMouse;
		(void)::GetCursorPos(&dvptMouse);
		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
		m_lstLabelList.ScreenToClient(&dvptMouse);
		int iC;
		for (iC = 0; iC != m_lstLabelList.GetItemCount(); iC++)
		{
			CRect rect;
			m_lstLabelList.GetItemRect(iC, rect, LVIR_BOUNDS);
			if (rect.PtInRect(dvptMouse))
			//----- _xZkqqHx_iDhNiDeFiDfIiCkKiDiKiDfIiDgHiDhCiDiFiBfLiCmJjDpMiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDfGiBfLiDgHjGlMjDgPjIfOiBeC_xHqqkZx_
				WString wstrSheet;
				g_pDoc->GetSheetManager()->GetSheetInfo(wstrSheet, m_vRecList[iC]->stidObjLabel);
				// _xZkqqHx_iNoMjAkMiOjOiKnEjDgPjIfOiBeC_xHqqkZx_
				WString wstrCreateTime = TStrToWStr(COleDateTime(FdtimeToFiletime(m_vRecList[iC]->pObjLabel->GetLabelCtime())).Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));
				// _xZkqqHx_iNfIjAfGiOjOiKnEjDgPjIfOiBeC_xHqqkZx_
				WString wstrModifyTime = TStrToWStr(COleDateTime(FdtimeToFiletime(m_vRecList[iC]->pObjLabel->GetLabelMtime())).Format(FFLoadString(IDS_FORM_DATE_TIME)));
				// IDS_FORM_HTREE_PROPERTY_J =
				// _xZkqqHx_iDiJiDhIiDiLjFlG_xHqqkZx_:%s\r\n
				// _xZkqqHx_iDfGiBfLiDgHjGlM_xHqqkZx_:%s\r\n
				// _xZkqqHx_iNoMjAkMjDpKiOjO_xHqqkZx_:%s\r\n
				// _xZkqqHx_iNfIjAfGjDpKiOjO_xHqqkZx_:%s
				FFGetApp()->GetPopHint()->SetTargetInfo(
					FormatResString(IDS_FORM_HTREE_PROPERTY_J,
									m_vRecList[iC]->wstrLabel.c_str(),	// _xZkqqHx_iDiJiDhIiDiLjFlGiBeC_xHqqkZx_
									wstrSheet.c_str(),					// _xZkqqHx_iDfGiBfLiDgHjGlMiBeC_xHqqkZx_
									wstrCreateTime.c_str(),				// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
									wstrModifyTime.c_str()));			// _xZkqqHx_iNfIjAfGjDpKiOjOiBeC_xHqqkZx_
				break;
			}
		}
	}
	return 1;
} // CFCDlgObjLabelList::OnUserPursuerTextNeedInfo.
