#ifndef __DocumentRecCopy_h
#define __DocumentRecCopy_h

class FCProjectCopy;
class FCHiDocumentRec;

class FCDocumentRecCopy
{
public:
	FCDocumentRecCopy (const FCProjectCopy* pProjectCopy);
	void			operator = (FCHiDocumentRec& rec);
	long			GetSuperDocId () const;			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
	const WString&	GetDocTitle () const;			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
	const WString&	GetVersion () const;			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	GUID			GetUserId () const;				// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	FDSECTIME		GetDate () const;				// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
	const WString&	GetComment () const;			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
	BOOL			GetIsLogCommandUserId () const;	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
	double			GetHtreeScore () const;			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
	WString			GetHintText () const;
// 06.01.31 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	BOOL			GetIsTemporary () const;

protected:
	const FCProjectCopy*	m_pProjectCopy;
	long		m_lSuperDocId;			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
	WString		m_wstrDocTitle;			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
	WString		m_wstrVersion;			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	GUID		m_guidUserId;			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	FDSECTIME	m_fdstDate;				// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
	WString		m_wstrComment;			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
	BOOL		m_bIsLogCommandUserId;	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
	double		m_dHtreeScore;			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
}; // class FCDocumentRecCopy.

class FCDocRecCopyFactory
{
public:
	virtual FCDocumentRecCopy*	Create (const FCProjectCopy* pProjectCopy) const;
	virtual void				Delete (FCDocumentRecCopy* pDocRecCopy) const;
}; // class FCDocRecCopyFactory.

#endif//__DocumentRecCopy_h
