#include "stdafx.h"
#include <algorithm>		// For sort template.
#include "resource.h"		// For IDS_ERR_MSG_CONVERTER_DEF_FILE.
#include "UtilFile.h"		// For FFSplitFileName.
#include "UtilWin.h"		// For FFGetMolipExePath().
#include "UtilStr.h"		// For GetLine.
#include "UtilErr.h"		// For CFCMiscException.
#include "UtilMisc.h"		// For operator < (GUID, GUID)
#include "UtilVersion.h"	// For FCHeaderInf.
#include "UndoArchive.h"	// For FCUndoArchive.
#include "MolipExport.h"	// For FCExport::CreateMolipMainI.
#include "HiProject.h"		// For operator < (GUID, GUID).
#include "FoundDoc.h"		// For FCWorkFile.
#include "FileConv.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

vector<FCConvNodeAuto>			FCFileConvManager::s_vNode;
map<WString, long>				FCFileConvManager::s_mpTypVerToNodeId;
// 05.05.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//map<WString, FCFileConverter*>	FCFileConvManager::s_mpPathToConv;
vector<FCConvLink>				FCFileConvManager::s_vConvLink;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IMpgFileConv::RegisterConvertInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiCmMiPoOjFpBiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_MolipSDK_xZkqqHx_iCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpA_xHqqkZx_
 *			_xZkqqHx_jCmKiClFiCmEiDhGiDiJiDePiDeDiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	clsidPlugIn			:_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_CLSID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pFileConvInfo		:_xZkqqHx_iDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiPoOjFpBiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lFileConvInfoSize	:_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void IMpgFileConv::RegisterConvertInfo (GUID clsidPlugIn, const FCFileConvInfo* pFileConvInfo, long lFileConvInfoSize) const
{
	FCFileConvManager::RegisterConvertInfo(clsidPlugIn, pFileConvInfo, lFileConvInfoSize);
} // IMpgFileConv::RegisterConvertInfo.

///////////////////////////////////////////////////////////////////////////
// FCConvNode_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	myLess
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCConvNode_xZkqqHx_iCmMjBoFiPkMiKnGiMfHiCpAjEoEiKhCiClHiCoJiDeOiDiJiDfIiBeC_xHqqkZx_sort_xZkqqHx_jHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class myLess
{
public:
	myLess (WString* wstrpExtPriority,
			long lExtPrioritySize,
			WString* wstrpVerPriority,
			long lVerPrioritySize)
	{
		long lC;
		for (lC = 0; lC < lExtPrioritySize; lC++)
			m_mpExtToPriority[wstrpExtPriority[lC]] = lC;
		for (lC = 0; lC < lVerPrioritySize; lC++)
			m_mpVerToPriority[wstrpVerPriority[lC]] = lC;
	}

	bool operator () (const FCConvNode& node0, const FCConvNode& node1)
	{
		map<WString, long>::const_iterator iEtp0 = m_mpExtToPriority.find(node0.m_wstrType);
		map<WString, long>::const_iterator iEtp1 = m_mpExtToPriority.find(node1.m_wstrType);

		if (iEtp0 == m_mpExtToPriority.end() && iEtp1 == m_mpExtToPriority.end())
		//----- _xZkqqHx_iCmHiClPiCoHiCoAiDhGiDiJiDeDiDeJiDiKiDgFiDeCiDiKiDfIiDgHiCmJiNnKiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			int iCmp = wcscmp(node0.m_wstrType, node1.m_wstrType);
			if (iCmp != 0) return (iCmp < 0);
		} else
		if (iEtp0 != m_mpExtToPriority.end() && iEtp1 == m_mpExtToPriority.end())
		//----- _xZkqqHx_jBoG_xHqqkZx_2_xZkqqHx_iIpIjAjEiCkKiDhGiDiJiDeDiDeJiDiKiDgFiDeCiDiKiDfIiDgHiCmJiNnKiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhGiDiJiDeDiDeJiDiKiDgFiDeCiDiKiDfIiDgHiCmJiNnKiCmBiCmEiCkCiCmIiCkCjFpLiCkKiDhGiDiJiDeDiDeJiDiKiDgFiDeCiCmNiNiCiCkCiBeC_xHqqkZx_
			return true;
		} else
		if (iEtp0 == m_mpExtToPriority.end() && iEtp1 != m_mpExtToPriority.end())
		//----- _xZkqqHx_jBoG_xHqqkZx_1_xZkqqHx_iIpIjAjEiCkKiDhGiDiJiDeDiDeJiDiKiDgFiDeCiDiKiDfIiDgHiCmJiNnKiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhGiDiJiDeDiDeJiDiKiDgFiDeCiDiKiDfIiDgHiCmJiNnKiCmBiCmEiCkCiCmIiCkCjFpLiCkKiDhGiDiJiDeDiDeJiDiKiDgFiDeCiCmNiNiCiCkCiBeC_xHqqkZx_
			return false;
		} else
		// if (iEtp0 != m_mpExtToPriority.end() && iEtp1 != m_mpExtToPriority.end())
		//----- _xZkqqHx_iCmHiClPiCoHiCoAiDhGiDiJiDeDiDeJiDiKiDgFiDeCiDiKiDfIiDgHiCmJiNnKiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if ((*iEtp0).second != (*iEtp1).second)
				return ((*iEtp0).second < (*iEtp1).second);
		}

		map<WString, long>::const_iterator iVtp0 = m_mpVerToPriority.find(node0.m_wstrVersion);
		map<WString, long>::const_iterator iVtp1 = m_mpVerToPriority.find(node1.m_wstrVersion);

		if (iVtp0 == m_mpVerToPriority.end() && iVtp1 == m_mpVerToPriority.end())
		//----- _xZkqqHx_iCmHiClPiCoHiCoAiDhGiDiJiDeDiDeJiDiKiDgFiDeCiDiKiDfIiDgHiCmJiNnKiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			int iCmp = wcscmp(node0.m_wstrType, node1.m_wstrType);
			if (iCmp != 0) return (iCmp < 0);
		} else
		if (iVtp0 != m_mpVerToPriority.end() && iVtp1 == m_mpVerToPriority.end())
		//----- _xZkqqHx_jBoG_xHqqkZx_2_xZkqqHx_iIpIjAjEiCkKiDhGiDiJiDeDiDeJiDiKiDgFiDeCiDiKiDfIiDgHiCmJiNnKiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhGiDiJiDeDiDeJiDiKiDgFiDeCiDiKiDfIiDgHiCmJiNnKiCmBiCmEiCkCiCmIiCkCjFpLiCkKiDhGiDiJiDeDiDeJiDiKiDgFiDeCiCmNiNiCiCkCiBeC_xHqqkZx_
			return true;
		} else
		if (iVtp0 == m_mpVerToPriority.end() && iVtp1 != m_mpVerToPriority.end())
		//----- _xZkqqHx_jBoG_xHqqkZx_1_xZkqqHx_iIpIjAjEiCkKiDhGiDiJiDeDiDeJiDiKiDgFiDeCiDiKiDfIiDgHiCmJiNnKiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhGiDiJiDeDiDeJiDiKiDgFiDeCiDiKiDfIiDgHiCmJiNnKiCmBiCmEiCkCiCmIiCkCjFpLiCkKiDhGiDiJiDeDiDeJiDiKiDgFiDeCiCmNiNiCiCkCiBeC_xHqqkZx_
			return false;
		} else
		// if (iVtp0 != m_mpVerToPriority.end() && iVtp1 != m_mpVerToPriority.end())
		//----- _xZkqqHx_iCmHiClPiCoHiCoAiDhGiDiJiDeDiDeJiDiKiDgFiDeCiDiKiDfIiDgHiCmJiNnKiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if ((*iVtp0).second != (*iVtp1).second)
				return ((*iVtp0).second < (*iVtp1).second);
		}
		return false;
	}

protected:
	map<WString, long>	m_mpExtToPriority;
	map<WString, long>	m_mpVerToPriority;
}; // class myLess.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCConvNode::FCConvNode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpType		:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_jHoBiBeG_xHqqkZx_"*fcore" ".mdrw"
 *			wcpVersion	:_xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_jHoBiBeG_xHqqkZx_"1.0" "2.0"
 *			wcpTypeName	:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCConvNode::FCConvNode (const wchar_t* wcpType,
						const wchar_t* wcpVersion,
						const wchar_t* wcpTypeName)
			:m_wstrType(wcpType),
			 m_wstrVersion(wcpVersion),
			 m_wstrTypeName(wcpTypeName),
			 m_bPassed(FALSE)
{
} // FCConvNode::FCConvNode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhG_xHqqkZx_/_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiDgNiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCmFiCmMjBoDjDpMiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cn	:_xZkqqHx_jBoDjDpMiMlDiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhG_xHqqkZx_/_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiDgNiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCConvNode::operator = (const FCConvNode& cn)
{
	m_wstrType = cn.m_wstrType;
	m_wstrVersion = cn.m_wstrVersion;
	m_wstrTypeName = cn.m_wstrTypeName;
	m_bPassed = cn.m_bPassed;
	m_stInflowLinkId = cn.m_stInflowLinkId;
	m_stOutflowLinkId = cn.m_stOutflowLinkId;
} // FCConvNode::operator =.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCConvNode::FindLinkPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgNiBfLiDgIiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCkJiCoHiBeBiDfDiBfLiDiLiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhG_xHqqkZx_
 *			_xZkqqHx_iCnMiCmFjFmPiKlHiClHiCoJiNmFjHmHiCmMiDfCiDjDiDgPiBfLiDfOiCmMiDhAiDfIiCpAjCfEiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vGoodPath		:_xZkqqHx_iClBiCoKiCnMiCmFjCfEiNpFiClFiClNjCiGiCmFiNmFiCoAjHmHiCkCiDgNiBfLiDgIiKnEiCmMjFmPiKlHiDiKiDjDiDeO_xHqqkZx_
 *							 _xZkqqHx_iCmM_xHqqkZx_ID_xZkqqHx_iCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			lGoodLoss		:_xZkqqHx_iClBiCoKiCnMiCmFjCfEiNpFiClFiClNjCiGiCmFiNmFiCoAjHmHiCkCiBgJjCoBiCkCiBgKiDfCiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpTypeGoal		:_xZkqqHx_jFmPiKlHjAoGiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"*fcore" "C:\doc\a.mdrw"
 *			wcpVersionGoal	:_xZkqqHx_jFmPiKlHjAoGiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"1.0" "2.0"
 *			vPath			:_xZkqqHx_iMlLiNnNjCfEiNpFjCiGiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lLoss			:_xZkqqHx_iMlLiNnNjCfEiNpFjCiGiCmMiDhAiDfIiCmMiDfCiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDhAiDfIiCmMjHmHiClFiIkLiClFiCmMiKoOiPiAiCmNiBeBiDhAiDfIiCmMiNiHiMhGiDfCiDfIiDgHiCkKiPkNiCmIiCkCiClBiCmGiBeB_xHqqkZx_
 *			_xZkqqHx_iDfCiDfIiDgHiCkKjDjJiClFiCkCiPoKiNiHiCmNiDhAiDfIiCmMjClHiClDiCkKjCfKiCkCiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCConvNode::FindLinkPath (	longVector& vGoodPath,
								long& lGoodLoss,
								const wchar_t* wcpTypeGoal,
								const wchar_t* wcpVersionGoal,
								longVector& vPath,
								long& lLoss)
{
	// _xZkqqHx_iKpJiCmJiMjPiNpFiNmPiCnNiCmIiCoHjCfEiClDiCmIiCkCiBeC_xHqqkZx_
	if (m_bPassed) return;
	m_bPassed = TRUE;

	// _xZkqqHx_iClHiCmFiCmJ_xHqqkZx_Good_xZkqqHx_iDhAiDfIiCpAiJhKiCkGiCmEiCkCiClNiCoHiBeBjCfEiClDiCmIiCkCiBeC_xHqqkZx_
	if (!vGoodPath.empty() && vGoodPath.size() <= vPath.size())
	{
		m_bPassed = FALSE;
		return;
	}

	if (m_wstrType == wcpTypeGoal &&
		m_wstrVersion == wcpVersionGoal)
	//----- _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCkKjCfEiClFiCmEiCkCiCoJjGnKjDeJiCmMiDgNiBfLiDgIiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (vGoodPath.empty() ||
			lLoss < lGoodLoss ||
			(lLoss == lGoodLoss && vPath.size() < vGoodPath.size()))
		//----- _xZkqqHx_iDfCiDfIiDgHiCkKiCoGiCoIjHeEiCoKiCmEiCkCiCoJiBeBiIlNiCkCiCmNiDhAiDfIjClHiCkKiCoGiCoIjCfKiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDePiDgCiDgIiDhAiDfIiCpAiNfIjAfGiBeC_xHqqkZx_
			vGoodPath = vPath;
			lGoodLoss = lLoss;
		}
		m_bPassed = FALSE;
		return;
	}

//----- 05.05.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (!vPath.empty() && m_wstrType != L"*fcore")
//	//----- _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCkKiDhMiBfLiDfOiDhFiDiLiDfCiDeBiMgAiOkOiCmFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jFfHiPiAiDfCiDeBiMgAiOkOiCmFiCoAjHmHiCkCiCmMiCmNiBeBjFmPiKlHiDhAiDfIiNmFiPiJiCmMiDgNiBfLiDgIiBeB_xHqqkZx_
//		// _xZkqqHx_iIlNiCkCiCmN_xHqqkZx_ _xZkqqHx_jFmPiKlHiDhAiDfIiNmFiMoDiCmMiDgNiBfLiDgIiCmMiCnNiBeC_xHqqkZx_
//		// _xZkqqHx_jFfHiPiAiDfCiDeBiCkJiCoHjFfHiPiAiDfCiDeBiCnGiCmMjFmPiKlHiCpAjEpAiCkPiCoJiClNiCnPiBeB_xHqqkZx_
//		// _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_iMjPiNpFjBkMjDhIiCpAiPoDiClAiCoJiClNiCnPiBeB_xHqqkZx_
//		// _xZkqqHx_jCiGiKnEiDhAiDfIiCmNjBfDiCmEiDhMiBfLiDfOiDhFiDiLiDfCiDeBiMgAiOkOiCmJiBeC_xHqqkZx_
//		m_bPassed = FALSE;
//		return;
//	}
//----- 05.05.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!vPath.empty() && m_wstrType == L"*ccore")
	//----- _xZkqqHx_jCiGiKnEiDgNiBfLiDgIiCkKjFkBiNiHiDfCiDeBiMgAiOkOiCmFiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFkBiNiHiDfCiDeBiCmNiDgIiDeMiDiFiDiBiDjDiDgHjCiGiCmM_xHqqkZx_STORAGE_xZkqqHx_iCmJiPjBiCkLiNjOiCnNiCpAiNhDiCkEiClNiCnPiBeB_xHqqkZx_
		// _xZkqqHx_jFmPiKlHiDhAiDfIiNmFiPiJiCmMiDgNiBfLiDgIiBeBiIlNiCkCiCmN_xHqqkZx_ _xZkqqHx_jFmPiKlHiDhAiDfIiNmFiMoDiCmMiDgNiBfLiDgIiCmMiCnN_xHqqkZx_
		// _xZkqqHx_iOhHjCoIiJmCjEfMiBeCjCiGiKnEiDhAiDfIiCmNjBfDiCmEjFkBiNiHiDfCiDeBiImIiKePiCmMiMgAiOkOiCmJiBeC_xHqqkZx_
		m_bPassed = FALSE;
		return;
	}
//----- 05.05.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	longSet::const_iterator iId;
	for (iId = m_stOutflowLinkId.begin();iId != m_stOutflowLinkId.end(); iId++)
	{
		const FCConvLink& convLink = FCFileConvManager::IdToConvLink(*iId);
		vPath.push_back(*iId);
		lLoss += convLink.m_lLoss;
		FCFileConvManager::IdToNode(convLink.m_lNodeTo)->
			FindLinkPath(vGoodPath, lGoodLoss, wcpTypeGoal,
						wcpVersionGoal, vPath, lLoss);
		vPath.pop_back();
		lLoss -= convLink.m_lLoss;
	}
	m_bPassed = FALSE;
} // FCConvNode::FindLinkPath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCConvNode::EnumConvertableTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgNiBfLiDgIiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCnGjFmPiKlHiJmCjEfMiCmIiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAjBfDiCmEjHpBiLjDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stNodeIdFrom	:_xZkqqHx_jFmPiKlHiJmCjEfMiCmIiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDgNiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iNmEiLeBjDeJiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCConvNode::EnumConvertableTo (longSet& stNodeIdFrom)
{
	// _xZkqqHx_iKpJiCmJiMjPiNpFiNmPiCnNiCmIiCoHjCfEiClDiCmIiCkCiBeC_xHqqkZx_
	if (m_bPassed) return;
	m_bPassed = TRUE;
	longSet::const_iterator iId;
	for (iId = m_stInflowLinkId.begin();iId != m_stInflowLinkId.end(); iId++)
	{
		const FCConvLink& convLink = FCFileConvManager::IdToConvLink(*iId);
		stNodeIdFrom.insert(convLink.m_lNodeFrom);
		FCFileConvManager::IdToNode(convLink.m_lNodeFrom)->
						EnumConvertableTo(stNodeIdFrom);
	}
	// _xZkqqHx_iMgPjIeIiCpAjCfEiClHiCoNiCkPiCmFiCmNiCmIiCkNiBeBjBfDiCmEiCmMiDgNiBfLiDgIiCpAjCfEiClHiCmMiCmFiBeB_xHqqkZx_m_bPassed _xZkqqHx_iCmNjGnPiClDiCmIiCkCiBeC_xHqqkZx_
} // FCConvNode::EnumConvertableTo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCConvNode::EnumConvertableFrom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgNiBfLiDgIiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCkJiCoHjFmPiKlHiJmCjEfMiCmIiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAjBfDiCmEjHpBiLjDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stNodeIdTo	:_xZkqqHx_jFmPiKlHiJmCjEfMiCmIiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDgNiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iNmEiLeBjDeJiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCConvNode::EnumConvertableFrom (longSet& stNodeIdTo)
{
	// _xZkqqHx_iKpJiCmJiMjPiNpFiNmPiCnNiCmIiCoHjCfEiClDiCmIiCkCiBeC_xHqqkZx_
	if (m_bPassed) return;
	m_bPassed = TRUE;
	longSet::const_iterator iId;
	for (iId = m_stOutflowLinkId.begin();iId != m_stOutflowLinkId.end(); iId++)
	{
		const FCConvLink& convLink = FCFileConvManager::IdToConvLink(*iId);
		stNodeIdTo.insert(convLink.m_lNodeTo);
		// _xZkqqHx_iNmEiLeBjDeJiCmJiOjPiCmMiDgNiBfLiDgIiCpAjCfEiClHiBeC_xHqqkZx_
		FCFileConvManager::IdToNode(convLink.m_lNodeTo)->
						EnumConvertableFrom(stNodeIdTo);
	}
	// _xZkqqHx_iMgPjIeIiCpAjCfEiClHiCoNiCkPiCmFiCmNiCmIiCkNiBeBjBfDiCmEiCmMiDgNiBfLiDgIiCpAjCfEiClHiCmMiCmFiBeB_xHqqkZx_m_bPassed _xZkqqHx_iCmNjGnPiClDiCmIiCkCiBeC_xHqqkZx_
} // FCConvNode::EnumConvertableFrom.

///////////////////////////////////////////////////////////////////////////
// FCConvLink_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCConvLink::FCConvLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lNodeFrom	:_xZkqqHx_jFmPiKlHiMlDiCmMiDgNiBfLiDgIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lNodeTo		:_xZkqqHx_jFmPiKlHjAoGiCmMiDgNiBfLiDgIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpConvPath	:_xZkqqHx_iDfCiDjDiDgPiBfLiDfOiCmMiDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lLoss		:_xZkqqHx_iClBiCmMjFmPiKlHiCmMiDfCiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpLoss		:_xZkqqHx_iClBiCmMjFmPiKlHiCmMiDfCiDfIiDgHiCmMiMhIiNjAjFlGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCConvLink::FCConvLink (long lNodeFrom, long lNodeTo, const GUID& clsidPlugIn,
						long lLoss, const wchar_t* wcpLoss) :
			m_lNodeFrom(lNodeFrom),
			m_lNodeTo(lNodeTo),
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			m_wstrConvPath(wcpConvPath),
			m_clsidPlugIn(clsidPlugIn),
			m_lLoss(lLoss),
			m_wstrLoss(wcpLoss)
{}

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmPiKlHiDiKiDjDiDeOiDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCmFiCmMjBoDjDpMiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cl	:_xZkqqHx_jBoDjDpMiMlDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCConvLink::operator = (const FCConvLink& cl)
{
	m_lNodeFrom = cl.m_lNodeFrom;
	m_lNodeTo = cl.m_lNodeTo;
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_wstrConvPath = cl.m_wstrConvPath;
	m_clsidPlugIn = cl.m_clsidPlugIn;
	m_lLoss = cl.m_lLoss;
	m_wstrLoss = cl.m_wstrLoss;
} // FCConvLink::operator =.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCConvLink::Warning
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCoAiClFiBeBiClBiCmMjFmPiKlHiDiKiDjDiDeOiCmJiDfCiDfIiDgHiCmJiKnGiClHiCoJiMhIiNjAjFlGiCkKjFhEiCkCiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmFiClLiCoKiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMhIiNjAjFlGiCkKjFhEiCkCiCmEiCkCiCmIiCkCiPoKiNiHiCmNiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCConvLink::Warning () const
{
	if (!m_wstrLoss.empty())
		FFErrorBox(m_wstrLoss.c_str());
} // FCConvLink::Warning.

///////////////////////////////////////////////////////////////////////////
// FCFileConvManager_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::FCFileConvManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFileConvManager::FCFileConvManager ()
{
} // FCFileConvManager::FCFileConvManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::~FCFileConvManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFileConvManager::~FCFileConvManager ()
{
	FreeAllConverter();
} // FCFileConvManager::~FCFileConvManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::LoadConverter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDfCiDjDiDgPiBfLiDfOiDhGiDiJiDePiDeDiDjDiCmJiBeBiDfCiDjDiDgPiBfLiDfOjGhLjBmMiCpAjDmHiCnNiNjOiCnMiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	clsidPlugIn	:_xZkqqHx_iDfCiDjDiDgPiBfLiDfOiDhGiDiJiDePiDeDiDjDiCmM_xHqqkZx_CLSID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgPiBfLiDfOiDhGiDiJiDePiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
IMpgPlugInFileConv* FCFileConvManager::LoadConverter (const GUID& clsidPlugIn)
{
	// clsidPlugIn_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJiDhGiDiJiDePiDeDiDjDiCmMiBeBiDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	IMpgPlugInFileConv* pPlugInFileConvI = FCExport::GetPlugInFileConvI(clsidPlugIn);
	// _xZkqqHx_iKpJiCmJiDhGiDiJiDePiDeDiDjDjGhLjBmMiCpAjDmHiCnNiNjOiCnNiNmPiCnNiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	if (m_stLoadedPlugIn.find(clsidPlugIn) == m_stLoadedPlugIn.end())
	//----- _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDgPiBfLiDfOjGhLjBmMiCkKiCnMiClOjDmHiCnNiNjOiCnMiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmJiDfCiDjDiDgPiBfLiDfOjGhLjBmMiCpAjDmHiCnNiNjOiCnMiClJiCoJiBeC_xHqqkZx_
		pPlugInFileConvI->LoadConverter();
		// _xZkqqHx_iDhGiDiJiDePiDeDiDjDjDmHiCnNiNjOiCnNiNmPiCnNiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
		m_stLoadedPlugIn.insert(clsidPlugIn);
	}
	// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDgPiBfLiDfOiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	return pPlugInFileConvI;
} // FCFileConvManager::LoadConverter.

//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::LoadFuncAnalyzeVersion
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FuncAnalyzeVersion FCFileConvManager::LoadFuncAnalyzeVersion (const GUID& clsidPlugIn)
//{
//	// clsidPlugIn_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJiDhGiDiJiDePiDeDiDjDiCmMiBeBiDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
//	IMpgPlugInFileConv* pPlugInFileConvI = FCExport::GetPlugInFileConvI(clsidPlugIn);
//	const wchar_t* wcpFileConverterPath = pPlugInFileConvI->GetFileConverterPath();
//	if (m_mpConvPathToInstance.find(wcpFileConverterPath) == m_mpConvPathToInstance.end())
//	{
//		// _xZkqqHx_iDfCiDjDiDgPiBfLiDfOiBfLiCpAiDiNiBfLiDgIiClFiCmEiPiJiKpKiJlLiBeC_xHqqkZx_
//		HINSTANCE hInst = FCExport::LoadPlugInModule(wcpFileConverterPath);
//		// _xZkqqHx_iBhFiOhHjCoIiCmMiDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCkKiMkJiCmCiCkJiCoIiCnMiClJiCpBiBeCiDhEiDeAiDeDiDiLjGlMiCpAiKgNjEeGiClFiCmEiCkNiClOiClDiCkCiBeCiBhG_xHqqkZx_
//		if (hInst <= (HINSTANCE)HINSTANCE_ERROR)
//			FFThrowMiscException(IDS_ERR_MSG_FILE_NOT_FOUND, wcpFileConverterPath);
//		m_mpConvPathToInstance[wcpFileConverterPath] = hInst;
//	}
//	FuncAnalyzeVersion funcAnalyzeVersion = (FuncAnalyzeVersion)GetProcAddress(m_mpConvPathToInstance[wcpFileConverterPath], "DllAnalyzeVersion");
//	// funcAnalyzeVersion _xZkqqHx_iCmN_xHqqkZx_ NULL _xZkqqHx_iCmMiPoKiNiHiCoAiCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
//	return funcAnalyzeVersion;
//} // FCFileConvManager::LoadFuncAnalyzeVersion.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::LoadFuncDoConvert
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FuncDoConvert FCFileConvManager::LoadFuncDoConvert (const GUID& clsidPlugIn)
//{
//	// clsidPlugIn_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJiDhGiDiJiDePiDeDiDjDiCmMiBeBiDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
//	IMpgPlugInFileConv* pPlugInFileConvI = FCExport::GetPlugInFileConvI(clsidPlugIn);
//	const wchar_t* wcpFileConverterPath = pPlugInFileConvI->GetFileConverterPath();
//	if (m_mpConvPathToInstance.find(wcpFileConverterPath) == m_mpConvPathToInstance.end())
//	{
//		// _xZkqqHx_iDfCiDjDiDgPiBfLiDfOiBfLiCpAiDiNiBfLiDgIiClFiCmEiPiJiKpKiJlLiBeC_xHqqkZx_
//		HINSTANCE hInst = FCExport::LoadPlugInModule(wcpFileConverterPath);
//		// _xZkqqHx_iBhFiOhHjCoIiCmMiDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCkKiMkJiCmCiCkJiCoIiCnMiClJiCpBiBeCiDhEiDeAiDeDiDiLjGlMiCpAiKgNjEeGiClFiCmEiCkNiClOiClDiCkCiBeCiBhG_xHqqkZx_
//		if (hInst <= (HINSTANCE)HINSTANCE_ERROR)
//			FFThrowMiscException(IDS_ERR_MSG_FILE_NOT_FOUND, wcpFileConverterPath);
//		m_mpConvPathToInstance[wcpFileConverterPath] = hInst;
//	}
//	FuncDoConvert funcDoConvert = (FuncDoConvert)GetProcAddress(m_mpConvPathToInstance[wcpFileConverterPath], "DllDoConvert");
//	if (funcDoConvert == NULL)
//		FFThrowMiscUnknown();
//	return funcDoConvert;
//} // FCFileConvManager::LoadFuncDoConvert.
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::FreeAllConverter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgPiBfLiDfOjGhLjBmMiCpAjDmHiCnNiNjOiCnNiNmPiCnNiCmMiDhGiDiJiDePiDeDiDjDiCkJiCoHiBeBiDfCiDjDiDgPiBfLiDfOjGhLjBmMiCpA_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFileConvManager::FreeAllConverter ()
{
	set<GUID>::iterator iGuid;
	for (iGuid = m_stLoadedPlugIn.begin(); iGuid != m_stLoadedPlugIn.end(); iGuid++)
	{
		// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiBeBiDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
		IMpgPlugInFileConv* pPlugInFileConvI = FCExport::GetPlugInFileConvI(*iGuid);
		// _xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDgPiBfLiDfOjGhLjBmMiCpAiJpAjFpKiBeC_xHqqkZx_
		pPlugInFileConvI->FreeConverter();
	}
	// _xZkqqHx_jGhLjBmMjDmHiCnNiNjOiCnNiNmPiCnNiCmMiDhGiDiJiDePiDeDiDjD_xHqqkZx_CLSID_xZkqqHx_jFmPjAjEiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_stLoadedPlugIn.clear();

//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	map<WString, HINSTANCE>::iterator iConv;
//	for (iConv = m_mpConvPathToInstance.begin(); iConv != m_mpConvPathToInstance.end(); iConv++)
//		FCExport::FreePlugInModule(iConv->second);
//	// _xZkqqHx_jDmHiCnNiNjOiCnNiNmPiCnNiCmMiDiCiDfHiDiFiBfLiDiLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//	m_mpConvPathToInstance.clear();
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCFileConvManager::FreeAllConverter.
//----- 05.05.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::EnumConvertableTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCnGjFmPiKlHiJmCjEfMiCmIiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAjBfDiCmEjHpBiLjDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stNodeIdFrom	:_xZkqqHx_jFmPiKlHiJmCjEfMiCmIiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDgNiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpTypeGoal		:_xZkqqHx_jFmPiKlHjAoGiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpVersionGoal	:_xZkqqHx_jFmPiKlHjAoGiCmMiDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFileConvManager::EnumConvertableTo (longSet& stNodeIdFrom,
										  const wchar_t* wcpTypeGoal,
										  const wchar_t* wcpVersionGoal)
{
	long lNodeIdGoal = TypeVersionToNodeId(wcpTypeGoal, wcpVersionGoal);
	if (lNodeIdGoal == -1) return;
	vector<FCConvNodeAuto>::iterator iCn;
	for (iCn = s_vNode.begin(); iCn != s_vNode.end(); iCn++)
		(*iCn)->m_bPassed = FALSE;
	stNodeIdFrom.insert(lNodeIdGoal);
	s_vNode[lNodeIdGoal]->EnumConvertableTo(stNodeIdFrom);
} // FCFileConvManager::EnumConvertableTo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::EnumConvertableFrom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCkJiCoHjFmPiKlHiJmCjEfMiCmIiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAjBfDiCmEjHpBiLjDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stNodeIdTo		:_xZkqqHx_jFmPiKlHiJmCjEfMiCmIiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDgNiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpTypeStart	:_xZkqqHx_jFmPiKlHiMlDiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpVersionStart	:_xZkqqHx_jFmPiKlHiMlDiCmMiDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFileConvManager::EnumConvertableFrom (longSet& stNodeIdTo,
										  const wchar_t* wcpTypeStart,
										  const wchar_t* wcpVersionStart)
{
	long lNodeIdStart = TypeVersionToNodeId(wcpTypeStart, wcpVersionStart);
	if (lNodeIdStart == -1) return;
	vector<FCConvNodeAuto>::iterator iCn;
	for (iCn = s_vNode.begin(); iCn != s_vNode.end(); iCn++)
		(*iCn)->m_bPassed = FALSE;
	stNodeIdTo.insert(lNodeIdStart);
	s_vNode[lNodeIdStart]->EnumConvertableFrom(stNodeIdTo);
} // FCFileConvManager::EnumConvertableFrom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::AnalyzeVersion
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrVersion	:_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpFilePath	:_xZkqqHx_jClCiCnHiCoJiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiCkKjFhDjGlOiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFileConvManager::AnalyzeVersion (WString& wstrVersion, const wchar_t* wcpFilePath)
{
	// _xZkqqHx_iDhEiDeAiDeDiDiLiKgHjCkDiOhBiBhL_xHqqkZx_"/"_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_ _xZkqqHx_jHoBiBeG_xHqqkZx_".mdrw/"
	WString wstrExtension = FFGetFileExtension(wcpFilePath) + L'/';

	//-------------------------------------------------------------
	// _xZkqqHx_iClBiCmMiDhEiDeAiDeDiDiLiMgAiOkOiCpAiDfEiDhMiBfLiDgHiClFiCmEiCkCiCoJjCiGiCmFiBeB_xHqqkZx_
	// _xZkqqHx_iCoAiCmBiCmGiCoAiDgPiBfLiDfHiDiHiDjDiCmMjAfGiClFiCkCiDgNiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_

	multimap<double, GUID> mmpVersionToAnalyzGuid;
	map<WString, long>::const_iterator iTypNid =
		s_mpTypVerToNodeId.lower_bound(wstrExtension);
	for (; iTypNid != s_mpTypVerToNodeId.end(); iTypNid++)
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLiMgAiOkOiCkKiInJiCmIiCoJiPoKiNiHiCmNiBeBiClBiCoKiImIiPoDiMjPiNpFiClFiCmIiCkCiBeC_xHqqkZx_
		if (wcsncmp(wstrExtension.c_str(), (*iTypNid).first, wstrExtension.size()) != 0)
			break;
		const long lNodeId = (*iTypNid).second;
		const FCConvNode* pNode = s_vNode[lNodeId].get();
		double dVersion = wcstod(pNode->m_wstrVersion.c_str(), NULL);
		// _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCkJiCoHiPgPiCmEiNhDiCkNjFmPiKlHiDiKiDjDiDeOiCpAjBfDiCmEiPfHiCnPiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMjFmPiKlHiDiKiDjDiDeOiCmMiDfCiDjDiDgPiBfLiDfOiCmNiBeBiClBiCmMiDhEiDeAiDeDiDiLiMgAiOkOiCpAiDfEiDhMiBfLiDgHiClFiCmE_xHqqkZx_
		// _xZkqqHx_iCkCiCoJiCmMiCmFiBeBiClBiCmMiDfCiDjDiDgPiBfLiDfOiCmJiBeBiDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAjClCiCnHiClDiClJiCoJiBeC_xHqqkZx_
		longSet::const_iterator iLnkid;
		for (iLnkid = pNode->m_stOutflowLinkId.begin();
			 iLnkid != pNode->m_stOutflowLinkId.end(); iLnkid++)
			mmpVersionToAnalyzGuid.insert(pair<double, GUID>(dVersion, IdToConvLink(*iLnkid).m_clsidPlugIn));
	}
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCkKjAfGiClFiCkCjFpLiCkJiCoHjClCiCnHiCmEiCkCiCkNiBeCjAfGiClFiCkCjFpLiCkK_xHqqkZx_
	// _xZkqqHx_iJpAjAmNiCmFiCkLiCoJiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDjAjEiCkKjBlNiCkCiCmNiClIiBeC_xHqqkZx_
	set<GUID> stConvCLSID;
	multimap<double, GUID>::reverse_iterator rVerPgin;
	for (rVerPgin = mmpVersionToAnalyzGuid.rbegin();
		 rVerPgin != mmpVersionToAnalyzGuid.rend(); rVerPgin++)
	{
		if (stConvCLSID.find((*rVerPgin).second) == stConvCLSID.end())
		//----- _xZkqqHx_jGkCjClCiNlIiCmMiDfCiDjDiDgPiBfLiDfOiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfCiDjDiDgPiBfLiDfOiDhGiDiJiDePiDeDiDjDiCmM_xHqqkZx_GUID_xZkqqHx_iCpAjClCiNlIiNmPiCnNiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
			stConvCLSID.insert((*rVerPgin).second);
			IMpgPlugInFileConv* pPlugInFileConvI = LoadConverter((*rVerPgin).second);
			if (pPlugInFileConvI->AnalyzeVersion(wstrVersion, wcpFilePath) == S_OK)
				return TRUE;
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			FuncAnalyzeVersion funcAnalyzeVersion = LoadFuncAnalyzeVersion((*rVerPgin).second);
//			if (funcAnalyzeVersion != NULL &&
//				(*funcAnalyzeVersion)(wstrVersion, wcpFilePath) == S_OK)
//				return TRUE;
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		}
	}
	return FALSE;
} // FCFileConvManager::AnalyzeVersion.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::DoConvert
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiMgAiOkOiCpAjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTypeStart	:_xZkqqHx_jFmPiKlHiMlDiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"*fcore" "C:\doc\a.mdrw"
 *			wcpVersionStart	:_xZkqqHx_jFmPiKlHiMlDiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"2.0" "3.0"
 *			pStorageStart	:_xZkqqHx_jFmPiKlHiMlDiCmMiDhEiDeAiDeDiDiLiBeBiIlNiCkCiCmNiDfIiDgHiDiMiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 wcpTypeStart_xZkqqHx_iCmJ_xHqqkZx_ _xZkqqHx_jFkBiNiHiDfCiDeB_xHqqkZx_ "*ccore" _xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmE_xHqqkZx_
 *							 _xZkqqHx_iCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_LPSTORAGE_xZkqqHx_iMfOiCmMiDfIiDgHiDiMiBfLiDfHiBeC_xHqqkZx_
 *							 wcpTypeStart_xZkqqHx_iCmJ_xHqqkZx_ _xZkqqHx_iDhEiDiJiDgCiDgHiDfCiDeB_xHqqkZx_ "*fcore" "*xcore" _xZkqqHx_iCkK_xHqqkZx_
 *							 _xZkqqHx_iOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_MfcFile*_xZkqqHx_iMfOiCmMiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *							 _xZkqqHx_iClLiCoKiImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			wcpTypeGoal		:_xZkqqHx_jFmPiKlHjAoGiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"*fcore" "*fcore2" "C:\doc\a.mdrw"
 *			wcpVersionGoal	:_xZkqqHx_jFmPiKlHjAoGiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"2.0" "3.0"
 *			pStorageGoal	:_xZkqqHx_jFmPiKlHjAoGiCmMiDhEiDeAiDeDiDiLiBeBiIlNiCkCiCmNiDfIiDgHiDiMiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 wcpTypeGoal_xZkqqHx_iCmJ_xHqqkZx_ _xZkqqHx_jFkBiNiHiDfCiDeB_xHqqkZx_ "*ccore" _xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmE_xHqqkZx_
 *							 _xZkqqHx_iCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_LPSTORAGE_xZkqqHx_iMfOiCmMiDfIiDgHiDiMiBfLiDfHiBeC_xHqqkZx_
 *							 wcpTypeGoal_xZkqqHx_iCmJ_xHqqkZx_ _xZkqqHx_iDhEiDiJiDgCiDgHiDfCiDeB_xHqqkZx_ "*fcore" "*xcore" _xZkqqHx_iCkK_xHqqkZx_
 *							 _xZkqqHx_iOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_MfcFile*_xZkqqHx_iMfOiCmMiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *							 _xZkqqHx_iClLiCoKiImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			 bShowConvWarnning
 *							:_xZkqqHx_jFmPiKlHiDiNiDfIiCmMiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pImageData		:_xZkqqHx_iPjBiCkLiPgPiClHiDhEiDeAiDeDiDiLiCmMiDeDiDiBiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiBgJiCkJiCoHiDeDiDiBiBfLiDfHiBgKiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *			lImageSize		:pImageData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szImage			:_xZkqqHx_iDeDiDiBiBfLiDfHiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDfIiDfOiBfLiDgHiCkJiCoHiDfDiBfLiDiLiCnMiCmFiCmMiDfCiDjDiDgPiBfLiDfOiDhAiDfIiCpAjCfEiNpFiClFiCmEiBeBiClLiCmMiDhAiDfIiCpA_xHqqkZx_
 *			_xZkqqHx_jCeIiCmBiCmEjFmPiKlHiBeBjFmPiKlHiCmFiDfDiBfLiDiLiCmMiMgAiOkOiCnMiCmFiClNiCmHiCoIjCiFiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFmPiKlHiMlDiBeFjFmPiKlHjAoGiDfOiDeDiDhGiCmJiCmNiImIiJlKiCmMiOoNjHnOiCkKiCkAiCoJiBeC_xHqqkZx_
 *			"*fcore"	:_xZkqqHx_iDhEiDiJiDgCiDgHiDfCiDeBiBeCiDhEiDiJiDgCiDgHiDhEiDeAiDeDiDiLiCmMiDfCiDeBiMgAiOkOiBeC_xHqqkZx_
 *			"*xcore"	:_xZkqqHx_iDhEiDiJiDgCiDgHiDfCiDeBiBeC_xHqqkZx_*fcore _xZkqqHx_iCmGjDkPiClGiClOiCkKiBeBjFjNiNeMjBlNiKhAjApMjFjEjFgJiCmM_xHqqkZx_
 *						 _xZkqqHx_jBkEjApMiDgGiBfLiDfOiCkKjFeLiClIjAnNjCoIiClDiCoKiCmEiCkCiCoJiBeCiOfKiPgPiCmJiOjOiKnEiCkKiCkJiCkJiCoJ_xHqqkZx_
 *						 _xZkqqHx_iPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *			"*ccore"	:_xZkqqHx_jFkBiNiHiDfCiDeBiBeCjFkBiNiHiDhEiDeAiDeDiDiLiCmMiDfCiDeBiMgAiOkOiBeC_xHqqkZx_
 *			"file path"	:_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlMiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_jAoGjDkKiCmJ_xHqqkZx_ * _xZkqqHx_iCkKjFhEiCkNiCkJjFhEiCkJiCmIiCkCiCkJiCmFiDfCiDeBiCkJiDhEiDeAiDeDiDiLiCkJiCpAiLoGjFmKiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			pStorageStart(pStorageGoal)_xZkqqHx_iCmMjCgMiCmNiBeBjFkBiNiHiDfCiDeBiCmMiPoKiNiHiCmN_xHqqkZx_ LPSTORAGE _xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClLiCoKiImIiKePiCmMiDfCiDeBiMgAiOkOiCmMiPoKiNiHiCmN_xHqqkZx_ CFile_xZkqqHx_iDhMiDeDiDjDiDfOiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_MMM Ver1.0_xZkqqHx_iMgAiOkOiBhGiCkJiCoHjFmPiKlHiCmMiPoKiNiH_xHqqkZx_
 *			wcpTypeStart = "C:\Doc\ABC.MMM"
 *			wcpVersionStart	= "1.0"
 *			_xZkqqHx_iDeBiBfLiDeKiDeDiDhFiBhF_xHqqkZx_fcore Ver2.0 _xZkqqHx_iMgAiOkOiBhGiCkJiCoHjFmPiKlHiCmMiPoKiNiH_xHqqkZx_
 *			wcpTypeStart = "*fcore"
 *			wcpVersionStart	= "2.0"
 *
 *			_xZkqqHx_jFmPiKlHjAoGiCmJ_xHqqkZx_"*fcore"_xZkqqHx_iCpAiOhHjCoIiClHiCoJiPoKiNiHiBeBiDhHiDgCiDfPiCmJiLeMjIfOiClDiCoKiCoJjFlGiPjBiDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_
 *			_xZkqqHx_iCpAjAjEjCgMiCmGiClFiCmEjCmHiJmBiCmFiCkLiCoJiBeCjAjEjCgMiCpAjCmHiJmBiClFiCmIiCkCiPoKiNiHiCmNiBeBjFmPiKlHiMlDiCmMiDgGiBfLiDfOiCmJ_xHqqkZx_
 *			_xZkqqHx_iKoOiCmDiCkCiCmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiBeG_xHqqkZx_
 *			FD_DTP_PORTABLE_FORMAT_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ "*fcore2"
 *			FD_DTP_TEMPLATE_FORMAT_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ "*fcore3"
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFileConvManager::DoConvert (	const wchar_t* wcpTypeStart,
									const wchar_t* wcpVersionStart,
									void* pStorageStart,
									const wchar_t* wcpTypeGoal,
									const wchar_t* wcpVersionGoal,
									void* pStorageGoal,
									BOOL bShowConvWarnning,
									const BYTE* pImageData,
									long lImageSize,
									CSize szImage)
{
	// _xZkqqHx_jFlGiPjBiDhEiDeIiBfLiDhNiDgCiDgHiKnEiCpAjFmPiKlHiClHiCoJiDfCiDjDiDgPiBfLiDfOiCmMiDhAiDfIiCpAiMjPiNpFiBeC_xHqqkZx_
	longVector vGoodPath;
	FindLinkPath(vGoodPath, wcpTypeStart, wcpVersionStart,
							wcpTypeGoal, wcpVersionGoal);
	if (vGoodPath.empty())
	//----- _xZkqqHx_jFmPiKlHiDhAiDfIiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_ERR_MSG_DOCUMENT_CONVERTOR_NOT_FOUND =
		// _xZkqqHx_jFlGiPjBiCpAjFmPiKlHiClHiCoJiDfCiDjDiDgPiBfLiDfOiCkKiMkJiCmCiCkJiCoIiCnMiClJiCpBiBeC_xHqqkZx_ 
		FFThrowMiscException(IDS_ERR_MSG_DOCUMENT_CONVERTOR_NOT_FOUND);
	}

	BYTEVector byvBitBuff;
	if (pImageData == NULL)
	//----- _xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iLpDiCmMiDeDiDiBiBfLiDfHiCpAiNoMjAkMiBeC_xHqqkZx_
		szImage = CSize(1,1);
		// ChipRec_xZkqqHx_iCmM_xHqqkZx_m_pBits_xZkqqHx_iCmMiDfEiDeDiDfJiBeC_xHqqkZx_
		lImageSize = (szImage.cx * szImage.cy * 32) / 8;
		byvBitBuff.resize(lImageSize, 0);
		pImageData = byvBitBuff.begin();
	}

	// _xZkqqHx_jCiGiKnEiDiPiBfLiDeOiDhEiDeAiDeDiDiLjHhAiCmJiIoKiOjOiDhEiDeAiDeDiDiLiCpAiCfBiCmCjHhAiInDiClHiCoJiBeC_xHqqkZx_
	FCWorkFile workFileA;
	FCWorkFile workFileB;
	FCWorkFile* pWorkFileFrom = &workFileA;
	FCWorkFile* pWorkFileTo = &workFileB;

	WString wstrTypeFrom;				// _xZkqqHx_jCiGiKnEiDhAiDfIiCmMjFmPiKlHiCmFiOgHiCoNiCoKiCoJjFmPiKlHiMlDiBeC_xHqqkZx_
	WString wstrVersionFrom;			// _xZkqqHx_jCiGiKnEiDhAiDfIiCmMjFmPiKlHiCmFiOgHiCoNiCoKiCoJjFmPiKlHiMlDiBeC_xHqqkZx_
	WString wstrTypeTo;					// _xZkqqHx_jCiGiKnEiDhAiDfIiCmMjFmPiKlHiCmFiOgHiCoNiCoKiCoJjFmPiKlHjAoGiBeC_xHqqkZx_
	WString wstrVersionTo;				// _xZkqqHx_jCiGiKnEiDhAiDfIiCmMjFmPiKlHiCmFiOgHiCoNiCoKiCoJjFmPiKlHjAoGiBeC_xHqqkZx_

	void* pStorageFrom = NULL;
	void* pStorageTo = NULL;

	for (long lC = 0; lC < vGoodPath.size(); lC++)
	{
		// _xZkqqHx_iNmFiPiJiCmMjFmPiKlHiCkJiBeI_xHqqkZx_
		const BOOL bIsFirstConv = (lC == 0);
		// _xZkqqHx_iNmFiMoDiCmMjFmPiKlHiCkJiBeI_xHqqkZx_
		const BOOL bIsLastConv = (lC == vGoodPath.size() - 1);

		// _xZkqqHx_jFmPiKlHiDiKiDjDiDeOiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
		const FCConvLink& convLink = IdToConvLink(vGoodPath[lC]);
		// _xZkqqHx_iMhIiNjAiCkKiCkAiCoJiPoKiNiHiCmNjFfMiOkGiBeC_xHqqkZx_
		if (bShowConvWarnning)
			convLink.Warning();

		if (bIsFirstConv)
		//----- _xZkqqHx_iNmFiPiJiCmMjFmPiKlHiDhAiDfIiCmMiPoKiNiH_xHqqkZx_ -----
		{
			wstrTypeFrom = wcpTypeStart;
			wstrVersionFrom = wcpVersionStart;
			pStorageFrom = pStorageStart;
		} else
		//----- _xZkqqHx_iNmFiPiJiCmMjFmPiKlHiDhAiDfIiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFmPiKlHiMlDiCpAiOhHjCoIiBeCjBePiJpBiCmMiDhAiDfIiCmMjFmPiKlHjAoGiBeC_xHqqkZx_
			wstrTypeFrom = wstrTypeTo;
			wstrVersionFrom = wstrVersionTo;
			pStorageFrom = pStorageTo;
		}

		if (bIsLastConv)
		//----- _xZkqqHx_iNmFiMoDiCmMjFmPiKlHiDhAiDfIiCmMiPoKiNiH_xHqqkZx_ -----
		{
			wstrTypeTo = wcpTypeGoal;
			wstrVersionTo = wcpVersionGoal;
			pStorageTo = pStorageGoal;
		} else
		//----- _xZkqqHx_iNmFiMoDiCmMjFmPiKlHiDhAiDfIiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFmPiKlHjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
			wstrTypeTo = IdToNode(convLink.m_lNodeTo)->m_wstrType;
			wstrVersionTo = IdToNode(convLink.m_lNodeTo)->m_wstrVersion;
			if (wstrTypeTo.at(0) != L'*')
			//----- _xZkqqHx_jFmPiKlHjAoGiCkKiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iIoKiOjOiDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_WString(wstrTypeTo)_xZkqqHx_iCmNiBeBjDkPiIoKiCmMiOpDiCkPiOoGiCoIjFmPjAjEiCpAjFnLiMoMiClHiCoJiClNiCnPiBeC_xHqqkZx_
				::FFMakeUniqTmpFileName(wstrTypeTo, L"_DDTmp", WString(wstrTypeTo));
				// _xZkqqHx_jFmPiKlHjAoGiCmMiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
				pStorageTo = NULL;
			} else
			//----- _xZkqqHx_jFmPiKlHjAoGiCkKiDiBiDiCiDiKiDgGiBfLiDfOiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFmPiKlHjAoGiCmMiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
				pStorageTo = &pWorkFileTo->file;
			}
		}

		// _xZkqqHx_jFmPiKlHiBeC_xHqqkZx_
		IMpgPlugInFileConv* pPlugInFileConvI = LoadConverter(convLink.m_clsidPlugIn);

		pPlugInFileConvI->DoConvert(wstrTypeFrom,
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		FuncDoConvert funcDoConvert = LoadFuncDoConvert(convLink.m_clsidPlugIn);
//		(*funcDoConvert)(	wstrTypeFrom,
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
							wstrVersionFrom,
							pStorageFrom,
							wstrTypeTo,
							wstrVersionTo,
							pStorageTo,
							pImageData,
							lImageSize,
							szImage);

		if (!bIsFirstConv)
		//----- _xZkqqHx_iNmFiPiJiCmMjFmPiKlHiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			if (wstrTypeFrom.at(0) != L'*')
			//----- _xZkqqHx_jFmPiKlHiMlDiCkKiIoKiOjOiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFmPiKlHiMlDiIoKiOjOiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
				FFDeleteFile(wstrTypeFrom);
			}
			// _xZkqqHx_jFmPiKlHiMlDiCmMiDhEiDeAiDeDiDiLjClHiCpAiCePiCmJiBeC_xHqqkZx_
			if (pStorageFrom != NULL)
				((CFile*)pStorageFrom)->SetLength(0);
		}
		if (!bIsLastConv)
		//----- _xZkqqHx_iNmFiMoDiCmMjFmPiKlHiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFmPiKlHjAoGiCmMiDhEiDeAiDeDiDiLiImKjChFiCpAiCePiCmJiBeC_xHqqkZx_
			if (pStorageTo != NULL)
				((CFile*)pStorageTo)->Seek(0, CFile::begin);
		}
		// WorkFile _xZkqqHx_iCmM_xHqqkZx_From _xZkqqHx_iCmG_xHqqkZx_To_xZkqqHx_iCpAjDpMiCoKjBnGiCkGiBeC_xHqqkZx_
		Exchange(pWorkFileFrom, pWorkFileTo);
	}
	// _xZkqqHx_iDiNiBfLiDgIiClFiClNiDfCiDjDiDgPiBfLiDfOiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
	FreeAllConverter();
} // FCFileConvManager::DoConvert.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::GetFileDialogFilterString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgPiBfLiDfOiCmFjFmPiKlHiJmCjEfMiCmIiDhEiDeAiDeDiDiLiMgAiOkOiCpAjClCiCnHiPgPiClFiBeBiClLiCmMiPoOjFpBiCmJiKoOiCmDiCkCiCmE_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCmMiDhEiDeCiDiLiDfOjFlGiOjKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strFilter		:_xZkqqHx_iDhEiDeCiDiLiDfOjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vConvNode		:_xZkqqHx_iDhEiDeCiDiLiDfOiPoOjFpBiCpAjFnEiClHiBeCiDhEiDeCiDiLiDfOjFlGiOjKjHpBiCmMiPiHiPjIiCmG_xHqqkZx_
 *							 _xZkqqHx_iIoKjChGiClFiCmEiCkCiCoJiBeCjDkPiClGiDhEiDeAiDeDiDiLiOoNjHnOiCmFiBeBiDgPiBfLiDfHiDiHiDjD_xHqqkZx_
 *							 _xZkqqHx_iIoBiCkCiCpAjClCiCnHiCoJiNnLiCmJjFeLjHhGiBeC_xHqqkZx_
 *			bIsSave			:_xZkqqHx_jFnLjBlGiDfPiDeDiDeBiDiNiDePiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *			wstrpExtPriority:_xZkqqHx_jFfMiOkGiPiHiCpAiMiIiCnPiCoJiDhGiDiJiDeDiDeJiDiKiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iNmFiPiJiCmMjEhKjHpBjHhGjBgGiCkKiIoKjEnEjHeEjAoGiPiHiImKiCkKiNiCiCkCiBeCjBkGiClP_xHqqkZx_
 *							 _xZkqqHx_iDhEiDeCiDiLiDfOjFlGiOjKjHpBiCmMiNmFiPiJiCmJjFfMiOkGiClDiCoKiCoJiBeC_xHqqkZx_
 *			lExtPrioritySize:wstrpExtPriority_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstrpVerPriority:_xZkqqHx_jFfMiOkGiPiHiCpAiMiIiCnPiCoJiDhGiDiJiDeDiDeJiDiKiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iNmFiPiJiCmMjEhKjHpBjHhGjBgGiCkKiIoKjEnEjHeEjAoGiPiHiImKiCkKiNiCiCkCiBeCjBkGiClP_xHqqkZx_
 *							 _xZkqqHx_iDhEiDeCiDiLiDfOjFlGiOjKjHpBiCmMiNmFiPiJiCmJjFfMiOkGiClDiCoKiCoJiBeC_xHqqkZx_
 *			lVerPrioritySize:wstrpVerPriority_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFileConvManager::GetFileDialogFilterString (	CString& strFilter,
													vector<FCConvNode>& vConvNode,
													BOOL bIsSave,
													WString* wstrpExtPriority,
													long lExtPrioritySize,
													WString* wstrpVerPriority,
													long lVerPrioritySize)
{
	// _xZkqqHx_iKpJiCmJjDgPjIfOiClDiCoKiClNiMgAiOkOiCpAiLeMjIfOiBeC_xHqqkZx_
	WStringSet stRegistered;

//----- 05.07.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiCmMiDhEiDeCiDiLiDfOjFlGiOjKjHpBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	// "Dynamic Draw Standard Format\n.mdrw\nDynamic Draw Portable Format\n.mdpf\n _xZkqqHx_iBeFiBeFiBeF_xHqqkZx_"
	WString wstrFilterName;
	wstrFilterName.LoadString(IDS_CTRL_IMPORT_EXPORT_FILTER);

	// _xZkqqHx_iDhEiDeCiDiLiDfOjFlGiOjKjHpBiCpAjAnNjCoIiBeC_xHqqkZx_
	while (!wstrFilterName.IsEmpty())
	{
		WString wstrTypeName = FFExtractUntil(wstrFilterName, L"\n");
		WString wstrExtension = FFExtractUntil(wstrFilterName, L"\n");
		vConvNode.push_back(FCConvNode(wstrExtension, FCHeaderInf::GetStcFileVersionString(), wstrTypeName));
		if (bIsSave)
		//----- _xZkqqHx_jFnLjBlGiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iLeMjIfOiNmPiCnNiCkJiCmHiCkEiCkJiCmMiMjPiNlIjHhAjFlGiOjKjHpBiBeC_xHqqkZx_
			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiBhLiDgPiBfLiDfHiDiHiDjDiCpAiLeMjIfOiBeCjFnLjBlGiCmMiPoKiNiHiDgPiBfLiDfHiDiHiDjDiCoAiOhHjCoIiCkKjFeLjHhGiBeC_xHqqkZx_
			stRegistered.insert(wstrExtension + L"/" + FCHeaderInf::GetStcFileVersionString());
		} else
		//----- _xZkqqHx_jDmHiCnNiNjOiCnNiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iLeMjIfOiNmPiCnNiCkJiCmHiCkEiCkJiCmMiMjPiNlIjHhAjFlGiOjKjHpBiBeC_xHqqkZx_
			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiLeMjIfOiBeCjDmHiCnNiNjOiCnNiCmMiPoKiNiHiDgPiBfLiDfHiDiHiDjDiCmNjFhDjHhAiBeC_xHqqkZx_
			stRegistered.insert(wstrExtension);
		}
	}
//----- 05.07.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	longSet stNodeId;
	if (bIsSave)
	//----- _xZkqqHx_jFnLjBlGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfCiDjDiDgPiBfLiDfOjCoIiLgAiDhEiDeAiDeDiDiLiCkJiCoHiBeBiMlLiNnNiCmMiDgPiBfLiDfHiDiHiDjD_xHqqkZx_"_xZkqqHx_iCkJiCoH_xHqqkZx_"_xZkqqHx_jFmPiKlHiJmCjEfMiCmIiMgAiOkOiCmMiIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
		EnumConvertableFrom(stNodeId, L"*fcore", FCHeaderInf::GetStcFileVersionString());
// 06.06.24 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		EnumConvertableFrom(stNodeId, L"*xcore", FCHeaderInf::GetStcFileVersionString());
	} else
	//----- _xZkqqHx_jDmHiCnNiNjOiCnNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfCiDjDiDgPiBfLiDfOjCoIiLgAiDhEiDeAiDeDiDiLiCkJiCoHiBeBiMlLiNnNiCmMiDgPiBfLiDfHiDiHiDjD_xHqqkZx_"_xZkqqHx_iCnG_xHqqkZx_"_xZkqqHx_jFmPiKlHiJmCjEfMiCmIiMgAiOkOiCmMiIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
		EnumConvertableTo(stNodeId, L"*fcore", FCHeaderInf::GetStcFileVersionString());
// 06.06.24 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		EnumConvertableTo(stNodeId, L"*xcore", FCHeaderInf::GetStcFileVersionString());
	}
	longSet::const_iterator iSt;
	for (iSt = stNodeId.begin(); iSt != stNodeId.end(); iSt++)
	{
		FCConvNode* pNode = IdToNode(*iSt);
		if (pNode->m_wstrType.at(0) == L'.')
		//----- _xZkqqHx_jFmPiKlHiJmCjEfMiMgAiOkOiCmMiCkEiClPiBeBiDhEiDeAiDeDiDiLiMgAiOkOiCmMiCoAiCmMiClOiCkPjBeJjFmK_xHqqkZx_ -----
		{
			// _xZkqqHx_iLeMjIfOiNmPiCnNiCkJiCmHiCkEiCkJiCmMiMjPiNlIjHhAjFlGiOjKjHpBiBeC_xHqqkZx_
			WString wstrRegType;
			if (bIsSave)
			//----- _xZkqqHx_jFnLjBlGiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiBhLiDgPiBfLiDfHiDiHiDjDiCpAiLeMjIfOiBeCjFnLjBlGiCmMiPoKiNiHiDgPiBfLiDfHiDiHiDjDiCoAiOhHjCoIiCkKjFeLjHhGiBeC_xHqqkZx_
				wstrRegType = pNode->m_wstrType + L"/" + pNode->m_wstrVersion;
			} else
			//----- _xZkqqHx_jDmHiCnNiNjOiCnNiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiLeMjIfOiBeCjDmHiCnNiNjOiCnNiCmMiPoKiNiHiDgPiBfLiDfHiDiHiDjDiCmNjFhDjHhAiBeC_xHqqkZx_
				wstrRegType = pNode->m_wstrType;
			}
			if (stRegistered.find(wstrRegType) == stRegistered.end())
			//----- _xZkqqHx_iCnMiClOjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCiDhEiDeAiDeDiDiLiMgAiOkOiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDhEiDeAiDeDiDiLiKgHjCkDiOhB_xHqqkZx_/_xZkqqHx_iDgPiBfLiDfHiDiHiDjD_xHqqkZx_/_xZkqqHx_jFlGiPjBiOoNjHnOjGlM_xHqqkZx_ _xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_strFilter_xZkqqHx_iCmMiPiHiPjIiCmJjBmOiJjOiClFiCmEiBeC_xHqqkZx_
				vConvNode.push_back(*pNode);
				// _xZkqqHx_jFhDjHhAiCmIjFmPiKlHiDiKiDjDiDeOiPoOjFpBiCpAiNoNiPjMiBeC_xHqqkZx_
				vConvNode.back().m_stInflowLinkId.clear();
				vConvNode.back().m_stOutflowLinkId.clear();
				// _xZkqqHx_iLeMjIfOiNmPiCnNiMjPiNlIjFmPjAjEiCnGjDgPjIfOiBeC_xHqqkZx_
				stRegistered.insert(wstrRegType);
			}
		}
	}

	sort(vConvNode.begin(), vConvNode.end(),
		myLess(wstrpExtPriority, lExtPrioritySize,
				wstrpVerPriority, lVerPrioritySize));

	if (bIsSave)
	//----- _xZkqqHx_jFnLjBlGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCmMiDhEiDeCiDiLiDfOjFlGiOjKjHpBiCpAiNoMjAkM_xHqqkZx_ ------
		// _xZkqqHx_jHoB_xHqqkZx_
		// "Dynamic Draw Standard Format (*.mdrw)\0*.mdrw\0Dynamic Draw Portable Format (*.mdpf)\0*.mdpf\0 _xZkqqHx_iBgDiBgD_xHqqkZx_\0\0"
		vector<FCConvNode>::const_iterator iNod;
		for (iNod = vConvNode.begin(); iNod != vConvNode.end(); iNod++)
		{
			strFilter += WStrToTStr((*iNod).m_wstrTypeName);
			strFilter += _T(" ");
			strFilter += WStrToTStr((*iNod).m_wstrVersion);
			strFilter += _T(" (*");
			strFilter += WStrToTStr((*iNod).m_wstrType);
			strFilter += _T(")");
			strFilter += _T('\0');
			strFilter += _T("*");
			strFilter += WStrToTStr((*iNod).m_wstrType);
			strFilter += _T('\0');
		}
		strFilter += _T('\0');
	} else
	//----- _xZkqqHx_jDmHiCnNiNjOiCnNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCmMiDhEiDeCiDiLiDfOjFlGiOjKjHpBiCpAiNoMjAkM_xHqqkZx_ ------
		// _xZkqqHx_jHoB_xHqqkZx_ _xZkqqHx_jFnLjBlGiCmJjBmOiClFiCmEiBeBiClHiCnHiCmEiCmMjFlGiPjBiCmGiBeBiDgPiBfLiDfHiDiHiDjDjGlMiCkKjCmHiJmBiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
		// "_xZkqqHx_iClHiCnHiCmEiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_jFlGiPjB_xHqqkZx_ (*.mdrw;*.mdpf;_xZkqqHx_iBgD_xHqqkZx_)\0*.mdrw;*.mdpf;_xZkqqHx_iBgD_xHqqkZx_\0Dynamic Draw Standard Format 4.0 (*.mdrw)\0
		// *.mdrw\0Dynamic Draw Portable Format 4.0 (*.mdpf)\0*.mdpf\0 _xZkqqHx_iBeFiBeFiBeF_xHqqkZx_\0\0"

		CString strAllExts;
		vector<FCConvNode>::const_iterator iNod;
		for (iNod = vConvNode.begin(); iNod != vConvNode.end(); iNod++)
		{
			strAllExts += _T('*');
			strAllExts += WStrToTStr((*iNod).m_wstrType);
			strAllExts += _T(';');
		}
		strAllExts.TrimRight(_T(';'));

		// strFilter += _T("_xZkqqHx_iClHiCnHiCmEiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_ (*.mdrw;*.mdpf)");
		// IDS_CTRL_ALL_DOCUMENT = _xZkqqHx_iClHiCnHiCmEiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_jFlGiPjBiBeC_xHqqkZx_
		strFilter.LoadString(IDS_CTRL_ALL_DOCUMENT);
		strFilter += _T(" (");
		strFilter += strAllExts;
		strFilter += _T(")");
		strFilter += _T('\0');
		strFilter += strAllExts;
		strFilter += _T('\0');

		for (iNod = vConvNode.begin(); iNod != vConvNode.end(); iNod++)
		{
			strFilter += WStrToTStr((*iNod).m_wstrTypeName);
			strFilter += _T(" (*");
			strFilter += WStrToTStr((*iNod).m_wstrType);
			strFilter += _T(")");
			strFilter += _T('\0');
			strFilter += _T("*");
			strFilter += WStrToTStr((*iNod).m_wstrType);
			strFilter += _T('\0');
		}
		strFilter += _T('\0');

		// _xZkqqHx_iBhFiClHiCnHiCmEiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_iDhEiDeAiDeDiDiLiBhGiCmJjBmOiJjOiClFiCmEiBeC_xHqqkZx_
		vConvNode.insert(vConvNode.begin(), FCConvNode(L"", L"", L""));
	}
} // FCFileConvManager::GetFileDialogFilterString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::IdToNode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgNiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCkJiCoHiDgNiBfLiDgIiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lNodeId	:_xZkqqHx_iDgNiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiKlHiDiKiDjDiDeOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCConvNode* FCFileConvManager::IdToNode (long lNodeId)
{
	return s_vNode[lNodeId].get();
} // FCFileConvManager::IdToNode.

//----- 03.05.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//WString FCFileConvManager::IdToConvFile (long lConvId)
//{
//	return m_vConvFile[lConvId];
//} // FCFileConvManager::IdToConvFile.
//----- 03.05.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::IdToConvLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgNiBfLiDgIiKnEiCmMjFmPiKlHiDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCkJiCoHjFmPiKlHiDiKiDjDiDeOiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_jFmPiKlHiDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiKlHiDiKiDjDiDeOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCConvLink& FCFileConvManager::IdToConvLink (long lId)
{
	return s_vConvLink[lId];
} // FCFileConvManager::IdToConvLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::SelectCore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmIiDfCiDeBiMgAiOkOiCpAiKpEiCmCiCkJjHhAiInDiClFiBeBiOhHjCoIiClDiCoKiClNiMgAiOkOiCmJiDfCiDjDiDgPiBfLiDgH_xHqqkZx_
 *			_xZkqqHx_iJmCjEfMiCmIiDfCiDeBiMgAiOkOiCpAjBeJjBpAiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pStartCore		:_xZkqqHx_jBeJjBpAiJmCjEfMiCmIiDfCiDeBiMgAiOkOiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lStartCoreSize	:pStartCore_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpVersionStart	:_xZkqqHx_jFmPiKlHiMlDiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"1.0" "2.0"
 *			wcpTypeGoal		:_xZkqqHx_jFmPiKlHjAoGiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"*fcore" "C:\doc\a.mdrw"
 *			wcpVersionGoal	:_xZkqqHx_jFmPiKlHjAoGiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"1.0" "2.0"
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmIiDfCiDeBiMgAiOkOiCpAjFnEiClHiBeCiDhAiDfIiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiLpDjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCFileConvManager::SelectCore (	const wchar_t* pStartCore[],
										long lStartCoreSize,
										const wchar_t* wcpVersionStart,
										const wchar_t* wcpTypeGoal,
										const wchar_t* wcpVersionGoal)
{
	long lC;
	for (lC = 0; lC != lStartCoreSize; lC++)
	{
		// _xZkqqHx_jFlGiPjBiDhEiDeIiBfLiDhNiDgCiDgHiKnEiCpAjFmPiKlHiClHiCoJiDfCiDjDiDgPiBfLiDfOiCmMiDhAiDfIiCpAiMjPiNpFiBeC_xHqqkZx_
		longVector vGoodPath;
		FindLinkPath(vGoodPath, pStartCore[lC], wcpVersionStart,
								wcpTypeGoal, wcpVersionGoal);
		if (!vGoodPath.empty())
			return pStartCore[lC];
	}
	return WString();
} // FCFileConvManager::SelectCore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::TypeVersionToNodeId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	"_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhG_xHqqkZx_/_xZkqqHx_iDgPiBfLiDfHiDiHiDjD_xHqqkZx_" _xZkqqHx_iCkJiCoH_xHqqkZx_ _xZkqqHx_iDgNiBfLiDgI_xHqqkZx_ID _xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpType		:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiBgJ_xHqqkZx_*ccore,.mdrw_xZkqqHx_jDjJiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpVersion	:_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiBgJ_xHqqkZx_"1.0","2.0"_xZkqqHx_jDjJiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgNiBfLiDgI_xHqqkZx_ID_xZkqqHx_iBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCFileConvManager::TypeVersionToNodeId (const wchar_t* wcpType,
											const wchar_t* wcpVersion)
{
	map<WString, long>::const_iterator iTypNid =
		s_mpTypVerToNodeId.find(WString(wcpType) + L"/" + wcpVersion);
	if (iTypNid == s_mpTypVerToNodeId.end()) return -1;
	return (*iTypNid).second;
} // FCFileConvManager::TypeVersionToNodeId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::SetTypeVersionToNodeId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	"_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhG_xHqqkZx_/_xZkqqHx_iDgPiBfLiDfHiDiHiDjD_xHqqkZx_" -> _xZkqqHx_iDgNiBfLiDgI_xHqqkZx_ID _xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCmJ_xHqqkZx_
 *			_xZkqqHx_iDiMiDfCiBfLiDgIiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpType		:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiBgJ_xHqqkZx_*ccore,.mdrw_xZkqqHx_jDjJiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpVersion	:_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiBgJ_xHqqkZx_"1.0","2.0"_xZkqqHx_jDjJiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lNodeId		:_xZkqqHx_iDgNiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFileConvManager::SetTypeVersionToNodeId (const wchar_t* wcpType,
										const wchar_t* wcpVersion,
										long lNodeId)
{
	s_mpTypVerToNodeId[WString(wcpType) + L"/" + wcpVersion] = lNodeId;
} // FCFileConvManager::SetTypeVersionToNodeId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::RegisterConvertInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiCmMiPoOjFpBiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_MolipSDK_xZkqqHx_iCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpA_xHqqkZx_
 *			_xZkqqHx_jCmKiClFiCmEiDhGiDiJiDePiDeDiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	clsidPlugIn			:_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_CLSID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pFileConvInfo		:_xZkqqHx_iDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiPoOjFpBiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lFileConvInfoSize	:_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFileConvManager::RegisterConvertInfo (GUID clsidPlugIn, const FCFileConvInfo* pFileConvInfo, long lFileConvInfoSize)
{
	// _xZkqqHx_jDkPiClGjCoIiLgA_xHqqkZx_(_xZkqqHx_jHoBiBeG_xHqqkZx_A->B _xZkqqHx_iCkK_xHqqkZx_2_xZkqqHx_iJpBiImIiPoD_xHqqkZx_)_xZkqqHx_iCkKiPgEjFkBiClFiCmIiCkCiCoGiCkEiCmJiKmEiOiLiClHiCoJiClNiCnPiCmMjFmPjAjEiBeC_xHqqkZx_
	set<longPair> stNodeIdPair;
	long lC;
	for (lC = 0; lC != lFileConvInfoSize; lC++)
	{
		long lNodeIdFrom = TypeVersionToNodeId(	pFileConvInfo[lC].wcpTypeFrom,
												pFileConvInfo[lC].wcpVersionFrom);
		if (lNodeIdFrom == -1)
		{
			FCConvNode* pNode = new FCConvNode(	pFileConvInfo[lC].wcpTypeFrom,
												pFileConvInfo[lC].wcpVersionFrom,
												pFileConvInfo[lC].wcpTypeNameFrom);
			lNodeIdFrom = s_vNode.size();
			SetTypeVersionToNodeId(	pFileConvInfo[lC].wcpTypeFrom,
									pFileConvInfo[lC].wcpVersionFrom,
									lNodeIdFrom);
			s_vNode.push_back(FCConvNodeAuto(pNode));
		}
		long lNodeIdTo = TypeVersionToNodeId(pFileConvInfo[lC].wcpTypeTo,
											pFileConvInfo[lC].wcpVersionTo);
		if (lNodeIdTo == -1)
		{
			FCConvNode* pNode = new FCConvNode(	pFileConvInfo[lC].wcpTypeTo,
												pFileConvInfo[lC].wcpVersionTo,
												pFileConvInfo[lC].wcpTypeNameTo);
			pNode->m_bPassed = FALSE;
			lNodeIdTo = s_vNode.size();
			SetTypeVersionToNodeId(	pFileConvInfo[lC].wcpTypeTo,
									pFileConvInfo[lC].wcpVersionTo,
									lNodeIdTo);
			s_vNode.push_back(FCConvNodeAuto(pNode));
		}
		if (stNodeIdPair.find(longPair(lNodeIdFrom, lNodeIdTo)) != stNodeIdPair.end())
		{
			// _xZkqqHx_iDfCiDjDiDgPiBfLiDfOiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmJiCkIiCkCiCmEiBeBjDkPiClGjFmPiKlHiCkKiCfBiJpBiImIiPoDjCoIiLgAiClDiCoKiCmEiCkCiCnMiClHiBeC_xHqqkZx_
//----- 05.05.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			FFErrorBox(IDS_ERR_MSG_CONVERTER_DOUBLE_DEF,
//										FCExport::GetPlugInInfoI(clsidPlugIn)->GetComponentName());
//----- 05.05.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			FFThrowMiscException(IDS_ERR_MSG_CONVERTER_DOUBLE_DEF,
								FCExport::GetPlugInInfoI(clsidPlugIn)->GetComponentName());
		}
		stNodeIdPair.insert(longPair(lNodeIdFrom, lNodeIdTo));
		long lConvLinkId = s_vConvLink.size();
		s_vConvLink.push_back(FCConvLink(	lNodeIdFrom,
											lNodeIdTo,
											clsidPlugIn,
											pFileConvInfo[lC].lLossPoint,
											pFileConvInfo[lC].wcpLossMessage));
		s_vNode[lNodeIdFrom]->m_stOutflowLinkId.insert(lConvLinkId);
		s_vNode[lNodeIdTo]->m_stInflowLinkId.insert(lConvLinkId);
	}
} // FCFileConvManager::RegisterConvertInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFileConvManager::FindLinkPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDfIiDfOiBfLiDgHiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCkJiCoHiBeBiDfDiBfLiDiLiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhG_xHqqkZx_
			_xZkqqHx_iCnMiCmFjFmPiKlHiClHiCoJiNmFjHmHiCmMiDfCiDjDiDgPiBfLiDfOiCmMiDhAiDfIiCpAjCfEiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vGoodPath		:_xZkqqHx_iDgNiBfLiDgIiKnEiCmMjFmPiKlHiDiKiDjDiDeOiCmM_xHqqkZx_ID_xZkqqHx_iCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpTypeStart	:_xZkqqHx_jFmPiKlHiMlDiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"*fcore" "C:\doc\a.mdrw"
 *			wcpVersionStart	:_xZkqqHx_jFmPiKlHiMlDiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"1.0" "2.0"
 *			wcpTypeGoal		:_xZkqqHx_jFmPiKlHjAoGiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"*fcore" "C:\doc\a.mdrw"
 *			wcpVersionGoal	:_xZkqqHx_jFmPiKlHjAoGiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jHoBiBeG_xHqqkZx_"1.0" "2.0"
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDhAiDfIiCmMjHmHiClFiIkLiClFiCmMiKoOiPiAiCmNiBeBiDhAiDfIiCmMiNiHiMhGiDfCiDfIiDgHiCkKiPkNiCmIiCkCiClBiCmGiBeB_xHqqkZx_
 *			_xZkqqHx_iDfCiDfIiDgHiCkKjDjJiClFiCkCiPoKiNiHiCmNiDhAiDfIiCmMjClHiClDiCkKjCfKiCkCiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFileConvManager::FindLinkPath (	longVector& vGoodPath,
										const wchar_t* wcpTypeStart,
										const wchar_t* wcpVersionStart,
										const wchar_t* wcpTypeGoal,
										const wchar_t* wcpVersionGoal)
{
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlDiClFiCmMjFmPiKlHiMlDiDfOiDeDiDhG_xHqqkZx_" _xZkqqHx_jHoBiBeG_xHqqkZx_"*fcore" ".mdrw"
	WString wstrTypeStart = wcpTypeStart;
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlDiClFiCmMjFmPiKlHjAoGiDfOiDeDiDhG_xHqqkZx_" _xZkqqHx_jHoBiBeG_xHqqkZx_"*fcore" ".mdrw"
	WString wstrTypeGoal = wcpTypeGoal;
	// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmMiMgAiOkOiCmMiPoKiNiHiBeBiDhEiDeAiDeDiDiLiKgHjCkDiOhBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	if (wcpTypeStart[0] != L'*')
		wstrTypeStart = FFGetFileExtension(wcpTypeStart);
	// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmMiMgAiOkOiCmMiPoKiNiHiBeBiDhEiDeAiDeDiDiLiKgHjCkDiOhBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	if (wcpTypeGoal[0] != L'*')
		wstrTypeGoal = FFGetFileExtension(wcpTypeGoal);
	// _xZkqqHx_iDfIiDfOiBfLiDgHiDgNiBfLiDgIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	long lNodeIdStart = TypeVersionToNodeId(wstrTypeStart, wcpVersionStart);
	if (lNodeIdStart == -1) return;
	// _xZkqqHx_iDfDiBfLiDiLiDgNiBfLiDgIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	long lNodeIdGoal = TypeVersionToNodeId(wstrTypeGoal, wcpVersionGoal);
	if (lNodeIdGoal == -1) return;
	// _xZkqqHx_jCfEiNpFjBePiCmJiDgNiBfLiDgIiCmMiDiPiBfLiDeOjDoAjFjEjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	vector<FCConvNodeAuto>::iterator iCn;
	for (iCn = s_vNode.begin(); iCn != s_vNode.end(); iCn++)
		(*iCn)->m_bPassed = FALSE;

	// _xZkqqHx_iNmEiLeBjDeJiCmJiNmFjHmHiCmMiDhAiDfIiCpAjCfEiNpFiBeC_xHqqkZx_
	longVector vPath;
	long lGoodLoss = 0;
	long lLoss = 0;
	s_vNode[lNodeIdStart]->FindLinkPath(vGoodPath, lGoodLoss, wstrTypeGoal,
										wcpVersionGoal, vPath, lLoss);
} // FCFileConvManager::FindLinkPath.
