// HString.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "Heap.h"		// For FCHeap.
#include "HString.h"	// This header.

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCStrIdRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDkPiClGjFlGiOjKjHpBiCpAjDkPiClG_xHqqkZx_ID_xZkqqHx_iCmFiKmHjHjNiClHiCoJiClNiCnPiCmMiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCStrIdRec
{
	FCStrIdRec ();
	FCStrIdRec (const wchar_t* wcpString);
	FCStrIdRec (DWORD dwId);
	BOOL			m_bIsId;	// m_wcpData_xZkqqHx_iCkKiDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iCkJiCmHiCkEiCkJiBeC_xHqqkZx_
	const wchar_t*	m_wcpData;	// _xZkqqHx_iDgGiBfLiDfO_xHqqkZx_ID/_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
}; // struct FCStrIdRec.

struct S_HSTRING
{
	FCHeap			s_heap;			// HString_xZkqqHx_iDeOiDiJiDfIiLkEjCmKiCmMiDhBiBfLiDhGiBeC_xHqqkZx_
	set<FCStrIdRec>	s_stStringId;	// _xZkqqHx_jDkPiClGjFlGiOjKjHpBiCpAjDkPiClG_xHqqkZx_ID_xZkqqHx_iCmFiKmHjHjNiClHiCoJiClNiCnPiCmMiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
}; // struct S_HSTRING.

typedef FCCsAreaRead<S_HSTRING>		s0_read;
typedef FCCsAreaWrite<S_HSTRING>		s0_write;
typedef FCCsAreaReadWrite<S_HSTRING>	s0_readwrite;

static FCCsAreaDef<S_HSTRING> s_0;

/////////////////////////////////////////////////////////////////////////////
// FCStrIdRec

FCStrIdRec::FCStrIdRec () : m_bIsId(FALSE), m_wcpData(NULL) {}
FCStrIdRec::FCStrIdRec (const wchar_t* wcpString) : m_bIsId(FALSE), m_wcpData(wcpString) {}
FCStrIdRec::FCStrIdRec (DWORD dwId) : m_bIsId(TRUE), m_wcpData((const wchar_t*)dwId) {}

inline bool operator < (const FCStrIdRec& rec1, const FCStrIdRec& rec2)
{
	s0_read s0r(s_0);
	DsString tmpStr1;
	const wchar_t* wcp1;
	if (rec1.m_bIsId)
	{
		const DWORD dwDataSize = s0r->s_heap.GetDataSize(DWORD(rec1.m_wcpData));
		s0r->s_heap.GetData(tmpStr1.Allocate(dwDataSize), dwDataSize, 0, DWORD(rec1.m_wcpData));
		wcp1 = tmpStr1;
	} else
	{
		wcp1 = rec1.m_wcpData;
	}
	DsString tmpStr2;
	const wchar_t* wcp2;
	if (rec2.m_bIsId)
	{
		const DWORD dwDataSize = s0r->s_heap.GetDataSize(DWORD(rec2.m_wcpData));
		s0r->s_heap.GetData(tmpStr2.Allocate(dwDataSize), dwDataSize, 0, DWORD(rec2.m_wcpData));
		wcp2 = tmpStr2;
	} else
	{
		wcp2 = rec2.m_wcpData;
	}
	return (wcscmp(wcp1, wcp2) < 0);
} // inline bool operator < (const FCStrIdRec& rec1, const FCStrIdRec& rec2).

/////////////////////////////////////////////////////////////////////////////
// HString

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HString::HString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HString::HString ()
		:m_dwDataId(DWORD(-1))
{
} // HString::HString ();

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HString::HString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstring	:_xZkqqHx_jBoDjDpMiClHiCoJjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HString::HString (const HString& hstring)
		:m_dwDataId(DWORD(-1))
{
	Set(hstring);
} // HString::HString (const HString& hstring);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HString::HString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	s	:_xZkqqHx_jBoDjDpMiClHiCoJjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HString::HString (const wchar_t* s)
		:m_dwDataId(DWORD(-1))
{
	Set(s);
} // HString::HString (const wchar_t* s);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HString::~HString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HString::~HString ()
{
	Empty();
} // HString::~HString ();

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HString::GetLength
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBjClHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBjClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD HString::GetLength () const
{
	s0_read s0r(s_0);
	if (m_dwDataId != DWORD(-1))
	//----- NULL_xZkqqHx_iCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhBiBfLiDhGiCkJiCoHiDgGiBfLiDfOiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
		const DWORD dwDataSize = s0r->s_heap.GetDataSize(m_dwDataId);
		// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJ_xHqqkZx_ / 2 - 1 _xZkqqHx_iCkKjFlGiOjKjHpBjClHiBeC_xHqqkZx_
		return (dwDataSize / sizeof(wchar_t)) - 1;
	} else
	//----- NULL_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		return 0;
	}
} // DWORD HString::GetLength () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HString::IsEmpty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCkKiLpDiBgJ_xHqqkZx_NULL_xZkqqHx_iCpAiKnMiCnOiBgKiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLpD_xHqqkZx_(NULL)_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL HString::IsEmpty () const
{
	return (GetLength() == 0);
} // BOOL HString::IsEmpty () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HString::IsNull
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCkK_xHqqkZx_NULL_xZkqqHx_iCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	NULL_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL HString::IsNull () const
{
	return (m_dwDataId == DWORD(-1));
} // BOOL HString::IsNull () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HString::c_str
 *
//----- 05.12.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCpA_xHqqkZx_TmpString_xZkqqHx_iMfOiCmGiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TmpString_xZkqqHx_iMfOiCmMjFlGiOjKjHpBiBeC_xHqqkZx_
//----- 05.12.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCpA_xHqqkZx_DsString_xZkqqHx_iMfOiCmGiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	DsString_xZkqqHx_iMfOiCmMjFlGiOjKjHpBiBeC_xHqqkZx_
//----- 05.12.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCmNiDhBiBfLiDhGiCmJjFnLjBlGiClDiCoKiCmEiCkCiCoJiClNiCnPiBeBjClMjAnKiCmJ_xHqqkZx_ wchar* _xZkqqHx_iCmGiClFiCmEiCmN_xHqqkZx_
 *			_xZkqqHx_iOoGiCoIiPgPiClJiCmIiCkCiBeCiOoGiCoIiPgPiClJiClNiCmGiClFiCmEiCoAiDhBiBfLiDhGjHmMiIoGiCmNiPoNiCmJiInKjDkOiClHiCoJiClNiCnP_xHqqkZx_
// 05.12.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
// *			_xZkqqHx_iKoLiMkPiBeCiClBiCmMiClNiCnPiBeB_xHqqkZx_TmpString_xZkqqHx_iMfOiCmGiClFiCmEjHmMiIoGiCpAiKgNjFnLiClFiBeBiClLiCmMjHmMiIoGiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iKoLiMkPiBeCiClBiCmMiClNiCnPiBeB_xHqqkZx_DsString_xZkqqHx_iMfOiCmGiClFiCmEjHmMiIoGiCpAiKgNjFnLiClFiBeBiClLiCmMjHmMiIoGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DsString HString::c_str () const
{
	s0_read s0r(s_0);
	DsString tmpString;
	if (m_dwDataId != DWORD(-1))
	//----- _xZkqqHx_jFlGiOjKjHpBiCkK_xHqqkZx_NULL_xZkqqHx_iCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
		const DWORD dwDataSize = s0r->s_heap.GetDataSize(m_dwDataId);
		// _xZkqqHx_jFlGiOjKjHpBiDfEiDeDiDfJiCmMjHmMiIoGiCpA_xHqqkZx_DsString_xZkqqHx_iCmJiKgNjFnLiClFiBeBiDhBiBfLiDhGiCkJiCoHiDgGiBfLiDfOiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		s0r->s_heap.GetData(tmpString.Allocate(dwDataSize), dwDataSize, 0, m_dwDataId);
	}
	// DsString_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	return tmpString;
} // DsString HString::c_str () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HString::GetAt
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiImKjChFiCmMjFlGiOjKiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIndex	:_xZkqqHx_jFlGiOjKiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
wchar_t HString::GetAt (DWORD dwIndex) const
{
	return c_str()[dwIndex];
} // wchar_t HString::GetAt (DWORD dwIndex) const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DsString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DsString()_xZkqqHx_iCmMiDeJiDhJiDiMiBfLiDfOiCpAiOmAiNhDiBeCjFlGiOjKjHpBiCpA_xHqqkZx_DsString_xZkqqHx_iMfOiCmFjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	DsString_xZkqqHx_iMfOjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HString::operator DsString () const
{
	return c_str();
} // HString::operator DsString () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	WString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	WString()_xZkqqHx_iCmMiDeJiDhJiDiMiBfLiDfOiCpAiOmAiNhDiBeCjFlGiOjKjHpBiCpA_xHqqkZx_WString_xZkqqHx_iMfOiCmFjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	WString_xZkqqHx_iMfOjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HString::operator WString () const
{
	s0_read s0r(s_0);
	WString wstr;
	if (m_dwDataId != DWORD(-1))
	//----- _xZkqqHx_jFlGiOjKjHpBiCkK_xHqqkZx_NULL_xZkqqHx_iCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
		const DWORD dwDataSize = s0r->s_heap.GetDataSize(m_dwDataId);
		if (dwDataSize != sizeof(wchar_t))
		//----- _xZkqqHx_iLpDjFlGiOjKiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFlGiOjKjHpBiDfEiDeDiDfJiCmMjHmMiIoGiCpA_xHqqkZx_WString_xZkqqHx_iCmJiKgNjFnLiClFiBeBiDhBiBfLiDhGiCkJiCoHiDgGiBfLiDfOiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			wstr.resize((dwDataSize / sizeof(wchar_t)) - 1, L'\0');
			s0r->s_heap.GetData(&wstr.at(0), dwDataSize, 0, m_dwDataId);
		}
	}
	return wstr;
} // HString::operator WString () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	[]
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiImKjChFiCmMjFlGiOjKiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIndex	:_xZkqqHx_jFlGiOjKiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
wchar_t HString::operator [] (DWORD dwIndex) const
{
	return GetAt(dwIndex);
} // wchar_t HString::operator [] (DWORD dwIndex) const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiOjKjHpBiCpAjBoDjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstring	:_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void HString::operator = (const HString& hstring)
{
	Set(hstring);
} // void HString::operator = (const HString& hstring);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiOjKjHpBiCpAjBoDjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	s	:_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void HString::operator = (const wchar_t* s)
{
	Set(s);
} // void HString::operator = (const wchar_t* s);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HString::Set
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiOjKjHpBiCpAjBoDjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstring	:_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void HString::Set (const HString& hstring)
{
	s0_readwrite s0rw(s_0);
	Empty();
	if (!hstring.IsNull())
	//----- _xZkqqHx_jBoDjDpMiClHiCoJjFlGiOjKjHpBiCkK_xHqqkZx_NULL_xZkqqHx_iCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iCmMiCnNiCpAjFkBiOmKiBeC_xHqqkZx_
		m_dwDataId = hstring.m_dwDataId;
		// _xZkqqHx_iDhBiBfLiDhGiCmMiDgGiBfLiDfOiOfBiPmGiDeKiDeFiDjDiDfOiCpAiJmBiOfKiBeC_xHqqkZx_
		s0rw->s_heap.IncrementReference(m_dwDataId);
	}
} // void HString::Set (const HString& hstring);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HString::Set
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiOjKjHpBiCpAjBoDjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	s	:_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void HString::Set (const wchar_t* s)
{
	s0_readwrite s0rw(s_0);
	Empty();
	if (s == NULL)
	//----- NULL_xZkqqHx_jFlGiOjKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iCmJ_xHqqkZx_NULL_xZkqqHx_jFlGiOjKiCmM_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		m_dwDataId = DWORD(-1);
	} else
	//----- NULL_xZkqqHx_jFlGiOjKiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// HString_xZkqqHx_iCmFiIlFiCmBiCmEiCkCiCoJjFlGiOjKjHpBiIoKjHjHiCkJiCoHiBeBjDkPiClGiCoAiCmMiCpAjCfEiClHiBeC_xHqqkZx_
		set<FCStrIdRec>::const_iterator i = s0rw->s_stStringId.find(FCStrIdRec(s));
		if (i != s0rw->s_stStringId.end())
		//----- _xZkqqHx_jDkPiClGjFlGiOjKjHpBiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
			m_dwDataId = DWORD((*i).m_wcpData);
			// _xZkqqHx_iDhBiBfLiDhGiCmMiDgGiBfLiDfOiOfBiPmGiDeKiDeFiDjDiDfOiCpAiJmBiOfKiBeC_xHqqkZx_
			s0rw->s_heap.IncrementReference(m_dwDataId);
		} else
		//----- _xZkqqHx_jDkPiClGjFlGiOjKjHpBiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFlGiOjKjHpBjClHiCkJiCoHiDgGiBfLiDfOiDfEiDeDiDfJiCpAiOfKiPgPiBeC_xHqqkZx_
			const size_t szStrLen = wcslen(s);
			const size_t szDataSize = sizeof(wchar_t) * (szStrLen + 1);
			// _xZkqqHx_jFlGiOjKjHpBiCpAiDgGiBfLiDfOiCmGiClFiCmEiDhBiBfLiDhGiCmJjAnNjCoIiBeC_xHqqkZx_
			m_dwDataId = s0rw->s_heap.AllocateData(s, szDataSize);
			// _xZkqqHx_iDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iCpAjFlGiOjKjHpBiIoKjHjHiCmJjDgPjIfOiBeC_xHqqkZx_
			s0rw->s_stStringId.insert(FCStrIdRec(m_dwDataId));
		}
	}
} // void HString::Set (const wchar_t* s);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HString::Empty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	HString_xZkqqHx_iCmMjDoAjHgFiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void HString::Empty ()
{
	s0_readwrite s0rw(s_0);
	if (m_dwDataId != DWORD(-1))
	//----- NULL_xZkqqHx_jFlGiOjKiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhBiBfLiDhGiCmMiDgGiBfLiDfOiOfBiPmGiDeKiDeFiDjDiDfOiCpAiMlIiOfKiBeC_xHqqkZx_
		if (s0rw->s_heap.DecrementReference(m_dwDataId) == 0)
		//----- _xZkqqHx_iDgGiBfLiDfOiOfBiPmGiDeKiDeFiDjDiDfOiCkKiCePiCmMiPoKiNiH_xHqqkZx_ ----
		{
			// _xZkqqHx_jFlGiOjKjHpBiIoKjHjHiCkJiCoHjDgPjIfOjGjFiPmBiBeC_xHqqkZx_
			s0rw->s_stStringId.erase(FCStrIdRec(m_dwDataId));
			// _xZkqqHx_iDhBiBfLiDhGiCkJiCoHiDgGiBfLiDfOjHmMiIoGiCpAiNoNiPjMiBeC_xHqqkZx_
			s0rw->s_heap.FreeData(m_dwDataId);
			// _xZkqqHx_iDhBiBfLiDhGjHmMiIoGiCpAiNmFjDeLiJlLiBeC_xHqqkZx_
			s0rw->s_heap.Reduce();
		}
		// _xZkqqHx_iDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iCpAiDeOiDiKiDeBiBeC_xHqqkZx_
		m_dwDataId = DWORD(-1);
	}
} // void HString::Empty ();

