#ifndef __Heap_h
#define __Heap_h

#include "HeapPool.h"	// For FCHeapPool.

/////////////////////////////////////////////////////////////////////////////
// FCHeapSegmentPosition

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCHeapSegmentPosition
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhBiBfLiDhGiCmM_xHqqkZx_(_xZkqqHx_iDgPiDgCiDhEiDeA_xHqqkZx_ID, _xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChF_xHqqkZx_)_xZkqqHx_iCpAiLeMjIfOiClHiCoJjFmPjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCHeapSegmentPosition : public pair<DWORD, DWORD>
{
	FCHeapSegmentPosition (DWORD dwHeapBufferId, DWORD dwSegmentPosition);
	DWORD	GetHeapBufferId () const;
	DWORD	GetSegmentPosition () const;
	void	SetSegmentPosition (DWORD dwSegmentPosition);
	static const FCHeapSegmentPosition& Invalid ();
protected:
	static const FCHeapSegmentPosition s_Invalid;
}; // struct FCHeapSegmentPosition.

/////////////////////////////////////////////////////////////////////////////
// FCHeap

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCHeap
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhBiBfLiDhGiCpAiIlFiCkEiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhBiBfLiDhGiDfGiDfIiDgFiDiAjBfDjBmMiCmMiOoGiCoIiCnMiCmGiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCHeap
{
public:
	FCHeap ();
	~FCHeap ();
	DWORD	AllocateData (const void* pData, DWORD dwDataSize);
	void	FreeData (DWORD dwDataId);
	void	Reduce ();
	DWORD	IncrementReference (DWORD dwDataId);
	DWORD	DecrementReference (DWORD dwDataId);
	DWORD	GetDataSize (DWORD dwDataId) const;
	DWORD	GetData (void* pDataBuff, DWORD dwBuffSize, DWORD dwStartOffset, DWORD dwDataId) const;

protected:
	DWORD	IssueFreeDataId ();
	void	RegisterFreeDataId (DWORD dwDataId);

protected:
	FCHeapPool						m_heapPool;						// _xZkqqHx_iDhBiBfLiDhGiDhGiBfLiDiLiBeC_xHqqkZx_
	vector<FCHeapSegmentPosition>	m_vIdToHeapSegment;				// _xZkqqHx_iDgGiBfLiDfO_xHqqkZx_ID->_xZkqqHx_iDfKiDePiDiBiDjDiDgHiDeBiDgIiDiMiDfI_xHqqkZx_ _xZkqqHx_jEhKjHpBiBeC_xHqqkZx_
	DWORDSet						m_stFreeDataId;					// _xZkqqHx_iDhEiDiKiBfLiDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iPfHiNiHiBeC_xHqqkZx_
	map<DWORD, DWORD>				m_mpBufferIdToEmptySegment;		// _xZkqqHx_iDgPiDgCiDhEiDeA_xHqqkZx_ID->_xZkqqHx_iLpDiDfKiDePiDiBiDjDiDgHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	DWORD							m_dwEmptySegment;				// _xZkqqHx_iLpDiCmJiCmIiCmBiClNiDfKiDePiDiBiDjDiDgHjAjEiBeCiKfEiOfKiBeC_xHqqkZx_
}; // class FCHeap.

#endif//__Heap_h
