#include "stdafx.h"
#include "HistViewFrame.h"	// For FFHistViewFrame().
#include "HistDrawFrame.h"	// For FFHistDrawFrame().
#include "HTreeManager.h"	// For FTHTViewMode.
#include "HiFrameWnd.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static FCHiFrameWnd	s_HiFrameWnd;

////////////////////////////////////////////////////////////////////////////
// FCHiFrameWnd_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

//----- 06.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//void FCHiFrameWnd::UpdateStatusBarUserDate ()
//{
//	if (FFHistViewFrame() != NULL)
//		FFHistViewFrame()->UpdateStatusBarUserDate();
//} // FCHiFrameWnd::UpdateStatusBarUserDate.
//----- 06.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
void FCHiFrameWnd::SetStatusBarUser (const GUID& guidUserId, const wchar_t* wcpUserName)
{
	if (FFHistViewFrame() != NULL)
		FFHistViewFrame()->SetStatusBarUser(guidUserId, wcpUserName);
	else
	if (FFHistDrawFrame() != NULL)
		FFHistDrawFrame()->SetStatusBarUser(guidUserId, wcpUserName);
} // FCHiFrameWnd::SetStatusBarUser.

void FCHiFrameWnd::SetStatusBarDate (FDSECTIME fdstDate)
{
	if (FFHistViewFrame() != NULL)
		FFHistViewFrame()->SetStatusBarDate(fdstDate);
	else
	if (FFHistDrawFrame() != NULL)
		FFHistDrawFrame()->SetStatusBarDate(fdstDate);
} // FCHiFrameWnd::SetStatusBarDate.

//----- 06.04.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//FDSECTIME FCHiFrameWnd::GetStatusBarDate () const
//{
//	if (FFHistViewFrame() != NULL)
//		return FFHistViewFrame()->GetStatusBarDate();
//	else
//	if (FFHistDrawFrame() != NULL)
//		return FFHistDrawFrame()->GetStatusBarDate();
//	else
//		return FDSECTIME(-1);
//} // FCHiFrameWnd::GetStatusBarDate.
//----- 06.04.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

void FCHiFrameWnd::SetHiviewTempMark (	short nForkOrLabel,
										const wchar_t* wcpProjectPath,
										long lDocumentId,
										flint fliSessionIndex)
{
	if (FFHistViewFrame() != NULL)
		FFHistViewFrame()->SetHiviewTempMark(nForkOrLabel, wcpProjectPath, lDocumentId, fliSessionIndex);
	else
	if (FFHistDrawFrame() != NULL)
		FFHistDrawFrame()->SetHiviewTempMark(nForkOrLabel, wcpProjectPath, lDocumentId, fliSessionIndex);
} // FCHiFrameWnd::SetHiviewTempMark.

void FCHiFrameWnd::SetHiviewMarkUpHidocument (	const wchar_t* wcpProjectPath,
												const longSet& stDocId)
{
	if (FFHistViewFrame() != NULL)
		FFHistViewFrame()->SetHiviewMarkUpHidocument(wcpProjectPath, stDocId);
	else
	if (FFHistDrawFrame() != NULL)
		FFHistDrawFrame()->SetHiviewMarkUpHidocument(wcpProjectPath, stDocId);
} // FCHiFrameWnd::SetHiviewMarkUpHidocument.

long FCHiFrameWnd::GetHiMoveOperation (long& lOpeValue) const
{
	if (FFHistViewFrame() != NULL)
		return FFHistViewFrame()->GetHiMoveOperation(lOpeValue);
	else
		return 0;
} // FCHiFrameWnd::GetHiMoveOperation.

BOOL FCHiFrameWnd::SyncHiviewToDocument (	FTHTViewMode viewMode,
											const wchar_t* wcpProjectPath,
											long lDocumentId,
											flint fliSessionIndex,
											BOOL bIsSelect,
											BOOL bIsMark,
											BOOL bIsFitHtreeViewZoom,
											BOOL bScrollTo,
											const WStringVector* vProjectPath,
											const longVector* vDocumentId)
{
	if (FFHistViewFrame() != NULL)
		return FFHistViewFrame()->SyncHiviewToDocument(
									viewMode,
									wcpProjectPath,
									lDocumentId,
									fliSessionIndex,
									bIsSelect,
									bIsMark,
									bIsFitHtreeViewZoom,
									bScrollTo,
									vProjectPath,
									vDocumentId);
	else
	if (FFHistDrawFrame() != NULL)
		return FFHistDrawFrame()->SyncHiviewToDocument(
									viewMode,
									wcpProjectPath,
									lDocumentId,
									fliSessionIndex,
									bIsSelect,
									bIsMark,
									bIsFitHtreeViewZoom,
									bScrollTo,
									vProjectPath,
									vDocumentId);
	return TRUE;
} // FCHiFrameWnd::SyncHiviewToDocument.

void FCHiFrameWnd::SetHiviewFontZoom (double dZoom)
{
	if (FFHistViewFrame() != NULL)
		FFHistViewFrame()->SetHiviewFontZoom(dZoom);
	else
	if (FFHistDrawFrame() != NULL)
		FFHistDrawFrame()->SetHiviewFontZoom(dZoom);
} // FCHiFrameWnd::SetHiviewFontZoom.

void FCHiFrameWnd::ChangeHiviewViewMode (FTHTViewMode viewMode)
{
	if (FFHistViewFrame() != NULL)
		FFHistViewFrame()->ChangeHiviewViewMode(viewMode);
	else
	if (FFHistDrawFrame() != NULL)
		FFHistDrawFrame()->ChangeHiviewViewMode(viewMode);
} // FCHiFrameWnd::ChangeHiviewViewMode.

void FCHiFrameWnd::SetHiviewZoom256 (long lZoom256)
{
	if (g_pInPlace != NULL)
	{
	} else
	{
		if (FFHistViewFrame() != NULL)
			FFHistViewFrame()->SetHiviewZoom256(lZoom256);
		else
		if (FFHistDrawFrame() != NULL)
			FFHistDrawFrame()->SetHiviewZoom256(lZoom256);
	}
} // FCHiFrameWnd::SetHiviewZoom256.

FCHiFrameWnd* FFGetHiMainWnd ()
{
	return &s_HiFrameWnd;
} // FFGetHiMainWnd.

