#ifndef __HiSpotTable_h
#define __HiSpotTable_h

#include "HiTableBase.h"	// For Baseclass.

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS FCHiTableBase

class FCDbReadLock;
class FCDbWriteLock;
class FCDbGroup;
class FCHiProject;
class FCSpotConstIterator;
class FCDbTable;

class FCHiSpotTable : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;

public:
	FCHiSpotTable ();
	FCHiSpotTable (const FCDbGroup& dbGroup);
	virtual ~FCHiSpotTable ();
	virtual void	operator = (const FCDbGroup& dbGroup);
	virtual void	AppendSpot (flint fliSessionIndex,
								const void* pData,
								DWORD dwDataSize);
	virtual void	DeleteSpotAfter (flint fliSessionIndex);
	virtual BOOL	IsThereSpot (flint fliSessionIndex);
	virtual FCSpotConstIterator	FindNearestSpot (flint& fliDistMin, flint fliSessionIndex);
	virtual FCSpotConstIterator	GetFirstSpot ();
	virtual FCSpotConstIterator	GetLastSpot ();
	virtual FCSpotConstIterator	GetLowerBoundSpot (flint fliSessionIndex);
	virtual FCSpotConstIterator	GetUpperBoundSpot (flint fliSessionIndex);
	virtual FCSpotConstIterator	FindSpot (flint fliSessionIndex);
}; // class FCHiSpotTable.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCSpotConstIterator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDhMiDgCiDgHiDiKiDfIiDgHiCmMiDeDiDfOiDiMiBfLiDfOiBeCiDfCiDjDiDfIiDgHiDeDiDfOiDiMiBfLiDfOiCmMiDhIiBfLiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCSpotConstIterator
{
public:
	FCSpotConstIterator (FCHiSpotTable* pHiSpotTable = NULL, DWORD dwIndex = DWORD(-1))
		: m_pHiSpotTable(pHiSpotTable), m_dwIndex(dwIndex) {}
	BOOL GetIsInvalid () const
		{
			return m_pHiSpotTable == NULL;
		}
	BOOL IsEnd ()
		{
			return (m_dwIndex == m_pHiSpotTable->GetRecordCount());
		}
	operator ++ (int)
		{
			m_dwIndex++;
		}
	flint GetSessionIndex ()
		{
			return m_pHiSpotTable->GetRecordPrimaryId(m_dwIndex);
		}
	FC2Fold<BYTE*, DWORD> GetSpotStream ()
		{
			DWORD dwDataSize = m_pHiSpotTable->GetRecordDataSize(m_dwIndex);
			if (dwDataSize == 0)
				return FC2Fold<BYTE*, DWORD>(NULL, 0);
			BYTE* pData = new BYTE[dwDataSize];
			m_pHiSpotTable->GetRecordData(pData, dwDataSize, m_dwIndex);
			return FC2Fold<BYTE*, DWORD>(pData, dwDataSize);
		}

protected:
	FCHiSpotTable*	m_pHiSpotTable;
	DWORD			m_dwIndex;
}; // class FCSpotConstIterator.

#endif//__HiSpotTable_h

