#ifndef __HiSummaryTable_h
#define __HiSummaryTable_h

#include "HiTableBase.h"	// For Baseclass.

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS FCHiTableBase

class FCDbGroup;
class FCHiProject;

enum FTHICode
{
	FDHI_ABS_TIME,			// _xZkqqHx_jAoCjBmOiOjOiKnEiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
	FDHI_LABEL_CREATE,		// _xZkqqHx_iDiJiDhIiDiLiNoMjAkMiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
	FDHI_LABEL_DELETE,		// _xZkqqHx_iDiJiDhIiDiLiNoNiPjMiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
	FDHI_NONE = 0xff,
}; // enum FTHICode.

//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//struct FCOpeIdLabel
//{
//	FCOpeIdLabel (	BOOL bIsCreate,
//					GUID guidUserId,
//					FDSECTIME fdstTime,
//					DWORD dwLabelId,
//					const wchar_t* wcpLabelText)
//	:	m_bIsCreate(bIsCreate),
//		m_guidUserId(guidUserId),
//		m_fdstTime(fdstTime),
//		m_dwLabelId(dwLabelId),
//		m_wstrLabelText(wcpLabelText) {}
//
//	BOOL		m_bIsCreate;
//	GUID		m_guidUserId;
//	FDSECTIME	m_fdstTime;
//	DWORD		m_dwLabelId;
//	WString		m_wstrLabelText;
//}; // struct FCOpeIdLabel.
//
//typedef vector<FCOpeIdLabel>	FCOpeIdLabelVector;
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
struct FCStLabelOperate
{
	FCStLabelOperate (	BOOL bIsCreate,
						GUID guidUserId,
						FDSECTIME fdstTime,
						DWORD dwLabelId,
						const wchar_t* wcpLabelText)
	:	m_bIsCreate(bIsCreate),
		m_guidUserId(guidUserId),
		m_fdstTime(fdstTime),
		m_dwLabelId(dwLabelId),
		m_wstrLabelText(wcpLabelText) {}

	BOOL		m_bIsCreate;
	GUID		m_guidUserId;
	FDSECTIME	m_fdstTime;
	DWORD		m_dwLabelId;
	WString		m_wstrLabelText;
}; // struct FCStLabelOperate.

typedef vector<FCStLabelOperate> FCStLabelOperateVector;
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCHiSummaryTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiNoMjAkMiBeBjDmHiCnNiNjOiCnNiBeBiPjBiCkLiNjOiCnNjDjJiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.02.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCHiSummaryTable : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;

public:
	FCHiSummaryTable ();
	FCHiSummaryTable (const FCDbGroup& dbGroup);
	virtual ~FCHiSummaryTable ();
	virtual void	operator = (const FCDbGroup& dbGroup);

	virtual BOOL	UpdateData (const FCDbReadLock& readLock);

	virtual void	Clear ();
// 06.02.07 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	Close ();
	virtual void	UpdateRecordModified ();
	virtual BOOL	IsOpened () const;

	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDjAkHiMoE_xHqqkZx_ -----
	virtual void	CmdSessionBegin ();
	virtual BOOL	CmdSessionEnd (	flint fliSessionIndex = 0,
									const GUID& guidUserId = GUID_NULL,
									FDSECTIME fdstTime = 0);
	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiLeMjIfO_xHqqkZx_ -----
	virtual void	CmdAbsTime ();
	virtual void	CmdLabelCreate (DWORD dwObjId,
									const wchar_t* wcpLabel);
	virtual void	CmdLabelDelete (DWORD dwObjId,
									const wchar_t* wcpLabel);

	// CmdLabelModify _xZkqqHx_iCmNiBeB_xHqqkZx_CmdLabelDelete -> CmdLabelCreate_xZkqqHx_iCmJjFkKiJpAiBeCiMjPiNpFiCmFiCmNiClLiCmBiClPiCkKjFnGjHjIiBeC_xHqqkZx_

	virtual flint	SeeNextSessionIndex ();
	virtual flint	SeePrevSessionIndex ();
	virtual flint	SeePrevSessionInfo (GUID& guidPrevUserId, FDSECTIME& fdstPrevSessionTime);

	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCmMiInKjDkO_xHqqkZx_ -----
	virtual void	SeekToSessionIndex (flint fliSessionIndex);
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual BOOL	SyncToSessionIndex (flint fliNextSessionIndex,
//										FCOpeIdLabelVector& pvOpeIdLabel);
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual BOOL	SyncToSessionIndex (flint fliNextSessionIndex,
										FCStLabelOperateVector& vLabelOperate);
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	virtual void	LoadRecord (flint* pfliSessionIndex,
								GUID* pguidUserId,
								FDSECTIME* pfdstTime,
								BOOL* pbIsAbsTime,
								FCStLabelOperateVector* pvLabelOperate,
								BOOL bOppositeOperate,
								DWORD dwIndex);

protected:
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual BOOL	MoveSession (	long lStep,
//									FCOpeIdLabelVector* pvOpeIdLabel = NULL);
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual BOOL	MoveSession (	long lStep,
									FCStLabelOperateVector* pvLabelOperate);
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	virtual void	SkipSession ();
	virtual void	RSkipSession ();
	virtual void	LoadCmdAbsTime (const BYTE*& pStream);
	virtual void	LoadCmdLabelCreate (const BYTE*& pStream,
										DWORD& dwObjId,
										WString& wstrLabel);
	virtual void	LoadCmdLabelDelete (const BYTE*& pStream,
										DWORD& dwObjId,
										WString& wstrLabel);
protected:
	long		m_lSessionDepth;		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCmMiDgMiDfIiDgHiCmMjAfLiClDiBeC_xHqqkZx_
	DWORD		m_dwNextIndex;
	BYTEVector	m_vRecordBuffer;
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	GUID		m_guidTableGuid;			// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
//	DWORD		m_dwLockedDeleteIdentifier;
//	DWORD		m_dwLockedAppendIdentifier;
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
}; // class FCHiSummaryTable.

#endif//__HiSummaryTable_h
