#include "stdafx.h"
#include <algorithm>			// For sort template.
#include "UtilStdLib.h"			// For m1_for.
#include "UtilStr.h"			// For StrNewCpy.
#include "FoundDoc.h"			// For CFCFoundDoc.
#include "HiSummaryTable.h"		// For FCHiSummaryTable.
#include "HiCommandTable.h"		// For FCHiCommandTable.
#include "SearchParser.h"		// For FCSearchParser.
#include "HiTerminateTable.h"	// For FCHiTerminateTable.
#include "FrameWnd.h"			// For FFGetMainWnd().
#include "DlgProgressBar.h"		// For CFCDlgProgressBar.
#include "ObjDynabase.h"		// For FCObjDynabase.
#include "RichText.h"			// For FCRichText.
#include "HistoryFindInfo.h"	// For FCFindObjectInfo,etc.
#include "HistoryFind.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

////////////////////////////////////////////////////////////////////////////
// FCHistoryFind _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FCHistoryFind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHistoryFind::FCHistoryFind ()
{
	ClearAll();
} // FCHistoryFind::FCHistoryFind.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::~FCHistoryFind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHistoryFind::~FCHistoryFind ()
{
	ClearAll();
} // FCHistoryFind::~FCHistoryFind.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::ClearAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMiDiBiDjDiDgPjFmPjAjEiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::ClearAll ()
{
	//----- _xZkqqHx_iDeBiDgHiDiAiDgFiBfLiDhFiDiLiDeOiDiKiDeB_xHqqkZx_ -----
	WCharPVector::iterator i;
	for (i = m_vStrTbl.begin(); i != m_vStrTbl.end(); i++)
		delete[] *i;
	m_vStrTbl.clear();
	m_vRecord.clear();			// _xZkqqHx_iMjPiNpFiMiLiJmKiDiMiDfCiBfLiDgIiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	m_pDlgProgressBar = NULL;	// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiBeC_xHqqkZx_
} // FCHistoryFind::ClearAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::ClearRecord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDiMiDfCiBfLiDgIiCmGiBeBiDeBiDgHiDiAiDgFiBfLiDhFiDiLiCmMiCnNiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::ClearRecord ()
{
	//----- _xZkqqHx_iDeBiDgHiDiAiDgFiBfLiDhFiDiLiDeOiDiKiDeB_xHqqkZx_ -----
	WCharPVector::iterator i;
	for (i = m_vStrTbl.begin(); i != m_vStrTbl.end(); i++)
		delete[] *i;
	m_vStrTbl.clear();
	// _xZkqqHx_iMjPiNpFiMiLiJmKiDiMiDfCiBfLiDgIiDgFiBfLiDhFiDiLiDeOiDiKiDeBiBeC_xHqqkZx_
	m_vRecord.clear();
} // FCHistoryFind::ClearRecord.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::AtomToStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDgHiDiAiCpAiDiJiDhIiDiLjFlGiOjKjHpBiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wAtom	:_xZkqqHx_iDeBiDgHiDiAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.02.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.04.12 Fukushiro M. HistoryIndex.cpp _xZkqqHx_iCkJiCoHiDfCiDhDiBfLiBeC_xHqqkZx_
 *************************************************************************/
const wchar_t* FCHistoryFind::AtomToStr (WORD wAtom) const
{
	if (m_vStrTbl.size() <= wAtom) return NULL;
	return m_vStrTbl[wAtom];
} // FCHistoryFind::AtomToStr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FindObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCmMiBeBiOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiImKjChFiCkJiCoHjBePjFpLiBeFiMoDjFpLiCmJ_xHqqkZx_
 *			_xZkqqHx_iMpMiCkJiCmBiCmEiBeBiOhHjCoIiClDiCoKiClNjFjEjFgJiCkKjBiAiNoMiClDiCoKiClNiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj				:_xZkqqHx_iMjPiNpFiClHiCoJjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mpLabelIdToString	:_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCmMiDiJiDhIiDiL_xHqqkZx_ID->_xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpKeyword			:_xZkqqHx_iNgJiCoIiNjOiCnNiMjPiNpFiClHiCoJiDiJiDhIiDiLjFlGiOjKjHpBiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *								 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *			bMultiWord			:_xZkqqHx_jFkBjAjEjCfAiMoKiCmMiMjPiNpFiCpAiLjGiJmCiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bRegexp				:_xZkqqHx_jAlDiLeLjFfMiMlLiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *			bAsUppercase		:_xZkqqHx_jBoFjFlGiOjKiBeFiPkMjFlGiOjKiCpAiLoGjFmKiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *			fdstFrom			:_xZkqqHx_iKeKiOgOiOjOiKnEiCmMiNgJiNjOiCnNiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			fdstUntil			:_xZkqqHx_iPeJjHlJiOjOiKnEiCmMiNgJiNjOiCnNiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			stLimitUserId		:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMiNgJiNjOiCnNiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchAbove		:_xZkqqHx_jBePjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchSuper		:_xZkqqHx_iPoDiImKiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchAboveBranch	:_xZkqqHx_jBePjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchBelow		:_xZkqqHx_iMoDjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchBelowBranch	:_xZkqqHx_iMoDjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			lStartDocId			:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *			fliStartSessionIndex:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartCommandPtr	:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartIndexPtr	:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bFindCreateObject	:_xZkqqHx_jFjEjFgJiCmMiNoMjAkMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bFindDeleteObject	:_xZkqqHx_jFjEjFgJiCmMiNoNiPjMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bFindModifyObject	:_xZkqqHx_jFjEjFgJiCmMjFmPiNfIiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iBhFiPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiBhGiPoKiNiHiCmNiBhFjBePjFpLiCpAiMjPiNpFiClHiCoJiBhGiCkKjFeLjAhLiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiCmJiCmNiImIiJlKiCmMjBgHiCnNiNiHiCoNiClJiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_jBePjFpLiMjPiNpFiCmMjBgHiCnNiNiHiCoNiClJ_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkN_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_     _xZkqqHx_iEkLiBhOiEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_iEkLiBhOiEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_jBePjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_iEkLiBhOiEkL_xHqqkZx_
 *          _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiElC_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_     _xZkqqHx_iEkLiBjLiEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_iEkLiBhOiEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_jBePjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_iEkLiBhOiEkL_xHqqkZx_
 *          _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiElC_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_     _xZkqqHx_iEkLiBjLiEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_iEkLiBhOiEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_jBePjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_iEkLiBjLiEkL_xHqqkZx_
 *          _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiElC_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_     _xZkqqHx_iEkLiBjLiEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_iEkLiBjLiEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_jBePjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_iEkLiBhOiEkL_xHqqkZx_
 *          _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiElC_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_     _xZkqqHx_iEkLiBjLiEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_iEkLiBjLiEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_jBePjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_iEkLiBjLiEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkO_xHqqkZx_
 *          
 *          _xZkqqHx_iMoDjFpLiMjPiNpFiCmMjBgHiCnNiNiHiCoNiClJ_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkN_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_     _xZkqqHx_iEkLiBhOiEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iMoDjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_iEkLiBhOiEkL_xHqqkZx_
 *          _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiElC_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_     _xZkqqHx_iEkLiBjLiEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iMoDjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_iEkLiBhOiEkL_xHqqkZx_
 *          _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiElC_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_     _xZkqqHx_iEkLiBjLiEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iMoDjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_ _xZkqqHx_iEkLiBjLiEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkO_xHqqkZx_
 *
 *          _xZkqqHx_iMoDjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJiPoKiNiHiBeBjBePjFpLiMjPiNpFiCmNiMjPiNpFiKeKiOgOiImKjChFiBgJiChHiBgKiCoGiCoIiCoAiPoDiCkJiCoH_xHqqkZx_
 *          _xZkqqHx_jFkKiKpCiClHiCoJiOhNiCpAiMjPiNpFiClHiCoJiBeCiImKjChFiChHiCkJiCoHjFkKiKpCiClHiCoJiOhNiCmNiMjPiNpFiClFiCmIiCkCiBeC_xHqqkZx_
 *          _xZkqqHx_iIoKjFpLiBeBiMoDjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJiPoKiNiHiBeBiMoDjFpLiMjPiNpFiCmNiImKjChFiChHiCkJiCoHjFkKiKpCiClHiCoJiOhNiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iMjPiNpFjHoB_xHqqkZx_
 *
 *          _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiBeBiPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiBeBjBePjFpLjBlMiOhNiCpAiMjPiNpFiClFiCmIiCkC_xHqqkZx_ _xZkqqHx_iPoKiNiH_xHqqkZx_
 *
 *          _xZkqqHx_iEkL_xHqqkZx_                              
 *          _xZkqqHx_iEkL_xHqqkZx_                              
 *          _xZkqqHx_iElFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_     
 *          _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_     
 *          _xZkqqHx_iElAiEkKiEkN_xHqqkZx_                    _xZkqqHx_iEkA_xHqqkZx_     
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_ 
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkN_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iElFiEjPiEkC_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_  _xZkqqHx_iBfBiEkL_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_ 
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iChH_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_     
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_         
 *          _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_         
 *                                          
 *                                          
 *          _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiBeBiPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiBeBjBePjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJ_xHqqkZx_ _xZkqqHx_iPoKiNiH_xHqqkZx_
 *
 *          _xZkqqHx_iEkL_xHqqkZx_                              
 *          _xZkqqHx_iEkL_xHqqkZx_                              
 *          _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_    
 *          _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_    
 *          _xZkqqHx_iElAiEkKiEkN_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_    
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iElAiEkKiEkN_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkN_xHqqkZx_          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iElAiEkKiEkN_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkN_xHqqkZx_  _xZkqqHx_iBfBiEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iChH_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_    
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_        
 *          _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_        
 *                                          
 *                                          
 *          _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiBeBiPoDiImKjHjKjHpAiCpAiMjPiNpFiClFiCmIiCkCiBeBjBePjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJ_xHqqkZx_ _xZkqqHx_iPoKiNiH_xHqqkZx_
 *
 *          _xZkqqHx_iEkA_xHqqkZx_                              
 *          _xZkqqHx_iEkA_xHqqkZx_                              
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_     
 *          _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_     
 *          _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_                    _xZkqqHx_iEkA_xHqqkZx_     
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                    _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_ 
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkN_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iElAiEkKiEkN_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_  _xZkqqHx_iBfBiEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_ 
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iChH_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_     
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_         
 *          _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_         
 *                                          
 *                                          
 *          _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiBeBiPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiBeBjBePjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJ_xHqqkZx_ _xZkqqHx_iPoKiNiH_xHqqkZx_
 *
 *          _xZkqqHx_iEkL_xHqqkZx_                              
 *          _xZkqqHx_iEkL_xHqqkZx_                              
 *          _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_      
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_      
 *          _xZkqqHx_iElAiEkKiEkN_xHqqkZx_                  _xZkqqHx_iEkL_xHqqkZx_      
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iElAiEkKiEkN_xHqqkZx_  
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiEkKiEkN_xHqqkZx_          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iChHiBkIiEkFiEjPiEkC_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_      
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_          
 *          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_          
 *          _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_          
 *                                          
 *                                          
 *          _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiBeBiMoDjFpLjBlMiOhNiCpAiMjPiNpFiClHiCoJ_xHqqkZx_ _xZkqqHx_iPoKiNiH_xHqqkZx_
 *
 *          _xZkqqHx_iEkA_xHqqkZx_                              
 *          _xZkqqHx_iEkA_xHqqkZx_                              
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_      
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_      
 *          _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_      
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEjPiEjPiEkC_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iChHiBkIiElAiEkKiEkN_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_      
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkN_xHqqkZx_          
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_          
 *          _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_          
 *                                          
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.04.18 Fukushiro M. _xZkqqHx_iDiJiDhIiDiLiNgJiCoIiNjOiCnNjHhAiCmMiIpIjAjEiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::FindObject (const HString& hstrProjectPath,
								const ObjDynabaseVector& vObj,
								const ObjIdToWStringMap& mpLabelIdToString,
								const wchar_t* wcpKeyword,
								BOOL bMultiWord,
								BOOL bRegexp,
								BOOL bAsUppercase,
								FDSECTIME fdstFrom,
								FDSECTIME fdstUntil,
								const set<GUID>& stLimitUserId,
								BOOL bSearchAbove,
								BOOL bSearchSuper,
								BOOL bSearchAboveBranch,
								BOOL bSearchBelow,
								BOOL bSearchBelowBranch,
								long lStartDocId,
								flint fliStartSessionIndex,
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//								flint fliStartCommandPtr,
//								flint fliStartIndexPtr,
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
								BOOL bFindCreateObject,
								BOOL bFindDeleteObject,
								BOOL bFindModifyObject,
								BOOL bFindModifyText)
{
	FCFindObjectInfo findObjInfo;
	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiBeC_xHqqkZx_
	findObjInfo.SetTargetObjects(vObj);
//----- 06.03.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMjPiNpFiClDiCoKiCoJiDiJiDhIiDiLiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
//	findObjInfo.m_mpLabelIdToString = mpLabelIdToString;
//----- 06.03.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCmMjAfGiLeLiNoMjAkMiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findObjInfo.m_bFindCreateObject = bFindCreateObject;
	// _xZkqqHx_jFjEjFgJiCmMiNoNiPjMiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findObjInfo.m_bFindDeleteObject = bFindDeleteObject;
	// _xZkqqHx_jFjEjFgJiCmMjFmPiNfIiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findObjInfo.m_bFindModifyObject = bFindModifyObject;
	// _xZkqqHx_jFjEjFgJiCmMiDgFiDeMiDfIiDgHjFmPiNfIiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findObjInfo.m_bFindModifyText = bFindModifyText;

//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FCSearchParser sp;
//	if (wcpKeyword != NULL)
//	//----- _xZkqqHx_iDiJiDhIiDiLiMjPiNpFiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		if (!sp.ParseSearch(wcpKeyword, bRegexp, bAsUppercase, bMultiWord, FALSE)) return;
//		// _xZkqqHx_iMjPiNpFiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
//		findObjInfo.m_pSP = &sp;
//		// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
//		findObjInfo.m_bLabelHitting = FALSE;
//
//		ObjIdToWStringMap::const_iterator iOl;
//		for (iOl = mpLabelIdToString.begin(); iOl != mpLabelIdToString.end(); iOl++)
//		{
//			// _xZkqqHx_jAnNjCoIjCiGiCmMiDiJiDhIiDiLjFlGiOjKjHpBiCkKiCfAiCmCiCmFiCoAiDhBiDgCiDgHiClFiClNiPoKiNiHiBeC_xHqqkZx_
//			if (sp.IsMatch((*iOl).second))
//			{
//				// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
//				findObjInfo.m_bLabelHitting = TRUE;
//				break;
//			}
//		}
//	} else
//	//----- _xZkqqHx_iDiJiDhIiDiLiMjPiNpFiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iMjPiNpFiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
//		findObjInfo.m_pSP = NULL;
//		// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
//		findObjInfo.m_bLabelHitting = TRUE;
//	}
//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	FindBaseOne(findObjInfo,
				hstrProjectPath,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
				mpLabelIdToString,
				wcpKeyword,
				bMultiWord,
				bRegexp,
				bAsUppercase,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
				fdstFrom,
				fdstUntil,
				stLimitUserId,
				bSearchAbove,
				bSearchSuper,
				bSearchAboveBranch,
				bSearchBelow,
				bSearchBelowBranch,
				lStartDocId,
				fliStartSessionIndex);
} // FCHistoryFind::FindObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FindLink
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCmMiBeBiOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiImKjChFiCkJiCoHjBePjFpLiBeFiMoDjFpLiCmJ_xHqqkZx_
 *			_xZkqqHx_iMpMiCkJiCmBiCmEiBeBiOhHjCoIiClDiCoKiClNjFjEjFgJiCkKjBiAiNoMiClDiCoKiClNiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj				:_xZkqqHx_iMjPiNpFiClHiCoJjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mpLabelIdToString	:_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCmMiDiJiDhIiDiL_xHqqkZx_ID->_xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpKeyword			:_xZkqqHx_iNgJiCoIiNjOiCnNiMjPiNpFiClHiCoJiDiJiDhIiDiLjFlGiOjKjHpBiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *								 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *			bMultiWord			:_xZkqqHx_jFkBjAjEjCfAiMoKiCmMiMjPiNpFiCpAiLjGiJmCiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bRegexp				:_xZkqqHx_jAlDiLeLjFfMiMlLiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *			bAsUppercase		:_xZkqqHx_jBoFjFlGiOjKiBeFiPkMjFlGiOjKiCpAiLoGjFmKiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *			fdstFrom			:_xZkqqHx_iKeKiOgOiOjOiKnEiCmMiNgJiNjOiCnNiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			fdstUntil			:_xZkqqHx_iPeJjHlJiOjOiKnEiCmMiNgJiNjOiCnNiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			stLimitUserId		:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMiNgJiNjOiCnNiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchAbove		:_xZkqqHx_jBePjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchSuper		:_xZkqqHx_iPoDiImKiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchAboveBranch	:_xZkqqHx_jBePjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchBelow		:_xZkqqHx_iMoDjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchBelowBranch	:_xZkqqHx_iMoDjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			lStartDocId			:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *			fliStartSessionIndex	:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartCommandPtr		:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartIndexPtr		:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bFindCreateLink			:_xZkqqHx_jFjEjFgJiMmCiBfIiCnGiCmMiDiKiDjDiDeOiNoMjAkMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bFindDeleteLink			:_xZkqqHx_jFjEjFgJiMmCiBfIiCnGiCmMiDiKiDjDiDeOiNoNiPjMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bFindCreateInterLink	:_xZkqqHx_jFjEjFgJiKnEiDiKiDjDiDeOiCmMiNoMjAkMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bFindDeleteInterLink	:_xZkqqHx_jFjEjFgJiKnEiDiKiDjDiDeOiCmMiNoNiPjMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMjPiNpFjFpLiMpMiCmJiKnGiClFiCmEiCmNiBeB_xHqqkZx_FindObject_xZkqqHx_iKnGjAjEiCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::FindLink (	const HString& hstrProjectPath,
								const ObjDynabaseVector& vObj,
								const ObjIdToWStringMap& mpLabelIdToString,
								const wchar_t* wcpKeyword,
								BOOL bMultiWord,
								BOOL bRegexp,
								BOOL bAsUppercase,
								FDSECTIME fdstFrom,
								FDSECTIME fdstUntil,
								const set<GUID>& stLimitUserId,
								BOOL bSearchAbove,
								BOOL bSearchSuper,
								BOOL bSearchAboveBranch,
								BOOL bSearchBelow,
								BOOL bSearchBelowBranch,
								long lStartDocId,
								flint fliStartSessionIndex,
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//								flint fliStartCommandPtr,
//								flint fliStartIndexPtr,
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
								BOOL bFindCreateLink,
								BOOL bFindDeleteLink,
								BOOL bFindCreateInterLink,
								BOOL bFindDeleteInterLink)
{
	FCFindLinkInfo findLinkInfo;
	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiBeC_xHqqkZx_
	findLinkInfo.SetTargetObjects(vObj);
//----- 06.03.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMjPiNpFiClDiCoKiCoJiDiJiDhIiDiLiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
//	findLinkInfo.m_mpLabelIdToString = mpLabelIdToString;
//----- 06.03.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiMmCiBfIiCnGiCmMiDiKiDjDiDeOiNoMjAkMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
	findLinkInfo.m_bFindCreateLink = bFindCreateLink;
	// _xZkqqHx_jFjEjFgJiMmCiBfIiCnGiCmMiDiKiDjDiDeOiNoNiPjMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
	findLinkInfo.m_bFindDeleteLink = bFindDeleteLink;
	// _xZkqqHx_jFjEjFgJiKnEiDiKiDjDiDeOiCmMiNoMjAkMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
	findLinkInfo.m_bFindCreateInterLink = bFindCreateInterLink;
	// _xZkqqHx_jFjEjFgJiKnEiDiKiDjDiDeOiCmMiNoNiPjMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
	findLinkInfo.m_bFindDeleteInterLink = bFindDeleteInterLink;
//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FCSearchParser sp;
//	if (wcpKeyword != NULL)
//	//----- _xZkqqHx_iDiJiDhIiDiLiMjPiNpFiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		if (!sp.ParseSearch(wcpKeyword, bRegexp, bAsUppercase, bMultiWord, FALSE)) return;
//		// _xZkqqHx_iMjPiNpFiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
//		findLinkInfo.m_pSP = &sp;
//		// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
//		findLinkInfo.m_bLabelHitting = FALSE;
//
//		ObjIdToWStringMap::const_iterator iOl;
//		for (iOl = mpLabelIdToString.begin(); iOl != mpLabelIdToString.end(); iOl++)
//		{
//			// _xZkqqHx_jAnNjCoIjCiGiCmMiDiJiDhIiDiLjFlGiOjKjHpBiCkKiCfAiCmCiCmFiCoAiDhBiDgCiDgHiClFiClNiPoKiNiHiBeC_xHqqkZx_
//			if (sp.IsMatch((*iOl).second))
//			{
//				// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
//				findLinkInfo.m_bLabelHitting = TRUE;
//				break;
//			}
//		}
//	} else
//	//----- _xZkqqHx_iDiJiDhIiDiLiMjPiNpFiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iMjPiNpFiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
//		findLinkInfo.m_pSP = NULL;
//		// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
//		findLinkInfo.m_bLabelHitting = TRUE;
//	}
//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	FindBaseOne(findLinkInfo,
				hstrProjectPath,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
				mpLabelIdToString,
				wcpKeyword,
				bMultiWord,
				bRegexp,
				bAsUppercase,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
				fdstFrom,
				fdstUntil,
				stLimitUserId,
				bSearchAbove,
				bSearchSuper,
				bSearchAboveBranch,
				bSearchBelow,
				bSearchBelowBranch,
				lStartDocId,
				fliStartSessionIndex);
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//				fliStartCommandPtr,
//				fliStartIndexPtr);
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCHistoryFind::FindLink.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FindLabel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdstFrom			:_xZkqqHx_iKeKiOgOiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstUntil			:_xZkqqHx_iPeJjHlJiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stLimitUserId		:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAllDocument	:_xZkqqHx_jBfDiCmEiCmMjFlGiPjBiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAbove		:_xZkqqHx_jBePjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchSuper		:_xZkqqHx_iPoDiImKiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAboveBranch	:_xZkqqHx_jBePjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchBelow		:_xZkqqHx_iMoDjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchBelowBranch	:_xZkqqHx_iMoDjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lStartDocId			:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartSessionIndex:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartCommandPtr	:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartIndexPtr	:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bFindCreateLabel	:_xZkqqHx_iDiJiDhIiDiLiCmMiNoMjAkMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bFindDeleteLabel	:_xZkqqHx_iDiJiDhIiDiLiCmMiNoNiPjMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bFindTimeLabel		:_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpKeyword			:_xZkqqHx_iMjPiNpFiClHiCoJiDiJiDhIiDiLjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bMultiWord			:_xZkqqHx_jFkBjAjEjCfAiMoKiCmMiMjPiNpFiCpAiLjGiJmCiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bRegexp				:_xZkqqHx_jAlDiLeLjFfMiMlLiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bAsUppercase		:_xZkqqHx_jBoFjFlGiOjKiBeFiPkMjFlGiOjKiCpAiLoGjFmKiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::FindLabel (	const HString& hstrProjectPath,
								FDSECTIME fdstFrom,
								FDSECTIME fdstUntil,
								const set<GUID>& stLimitUserId,
								BOOL bSearchAllDocument,
								BOOL bSearchAbove,
								BOOL bSearchSuper,
								BOOL bSearchAboveBranch,
								BOOL bSearchBelow,
								BOOL bSearchBelowBranch,
								long lStartDocId,
								flint fliStartSessionIndex,
// 06.01.16 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//								flint fliStartIndexPtr,
								BOOL bFindCreateLabel,
								BOOL bFindDeleteLabel,
								BOOL bFindTimeLabel,
								const wchar_t* wcpKeyword,
								BOOL bMultiWord,
								BOOL bRegexp,
								BOOL bAsUppercase)
{
	FCSearchParser sp;
	if (!sp.ParseSearch(wcpKeyword, bRegexp, bAsUppercase, bMultiWord, FALSE)) return;
	FCFindLabelInfo findLabelInfo;
	// _xZkqqHx_iDiJiDhIiDiLiNoMjAkMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
	findLabelInfo.m_bFindCreateLabel = bFindCreateLabel;
	// _xZkqqHx_iDiJiDhIiDiLiNoNiPjMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
	findLabelInfo.m_bFindDeleteLabel = bFindDeleteLabel;
	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
	findLabelInfo.m_bFindTimeLabel = bFindTimeLabel;
	// _xZkqqHx_iMjPiNpFiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	findLabelInfo.m_pLabelSP = &sp;
	if (bSearchAllDocument)
		FindBaseAll(findLabelInfo,
					hstrProjectPath,
					fdstFrom,
					fdstUntil,
					stLimitUserId);
	else
		FindBaseOne(findLabelInfo,
					hstrProjectPath,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
					ObjIdToWStringMap(),
					NULL,
					FALSE,
					FALSE,
					FALSE,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
					fdstFrom,
					fdstUntil,
					stLimitUserId,
					bSearchAbove,
					bSearchSuper,
					bSearchAboveBranch,
					bSearchBelow,
					bSearchBelowBranch,
					lStartDocId,
					fliStartSessionIndex);
} // FCHistoryFind::FindLabel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FindDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBjGlMiBeBjHjKjHpAjFkKiKpCiDfOiDePiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdstFrom			:_xZkqqHx_iKeKiOgOiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstUntil			:_xZkqqHx_iPeJjHlJiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAllDocument	:_xZkqqHx_jBfDiCmEiCmMjFlGiPjBiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAbove		:_xZkqqHx_jBePjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchSuper		:_xZkqqHx_iPoDiImKiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAboveBranch	:_xZkqqHx_jBePjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchBelow		:_xZkqqHx_iMoDjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchBelowBranch	:_xZkqqHx_iMoDjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lStartDocId			:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartSessionIndex:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stLimitUserId		:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bFindDocument		:_xZkqqHx_jFlGiPjBjGlMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bFindHiForkTag		:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiDfOiDeDiDgHiDiLiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bFindComment		:_xZkqqHx_jFlGiPjBiBeBjHjKjHpAjFkKiKpCiDfOiDePiCmMiDfCiDiBiDjDiDgHiCoAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpKeyword			:_xZkqqHx_iMjPiNpFiClHiCoJiDiJiDhIiDiLjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bMultiWord			:_xZkqqHx_jFkBjAjEjCfAiMoKiCmMiMjPiNpFiCpAiLjGiJmCiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bRegexp				:_xZkqqHx_jAlDiLeLjFfMiMlLiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bAsUppercase		:_xZkqqHx_jBoFjFlGiOjKiBeFiPkMjFlGiOjKiCpAiLoGjFmKiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::FindDocument (	const HString& hstrProjectPath,
									FDSECTIME fdstFrom,
									FDSECTIME fdstUntil,
									const set<GUID>& stLimitUserId,
									BOOL bSearchAllDocument,
									BOOL bSearchAbove,
									BOOL bSearchSuper,
									BOOL bSearchAboveBranch,
									BOOL bSearchBelow,
									BOOL bSearchBelowBranch,
									long lStartDocId,
									flint fliStartSessionIndex,
									BOOL bFindDocument,
									BOOL bFindHiForkTag,
									BOOL bFindComment,
									const wchar_t* wcpKeyword,
									BOOL bMultiWord,
									BOOL bRegexp,
									BOOL bAsUppercase)
{
	FCSearchParser sp;
	if (!sp.ParseSearch(wcpKeyword, bRegexp, bAsUppercase, bMultiWord, FALSE)) return;
	FCFindDocumentInfo findDocumentInfo;
	// _xZkqqHx_jFlGiPjBjGlMiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
	findDocumentInfo.m_bFindDocument = bFindDocument;
	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiDfOiDeDiDgHiDiLiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
	findDocumentInfo.m_bFindHiForkTag = bFindHiForkTag;
	// _xZkqqHx_jFlGiPjBiBeBjHjKjHpAjFkKiKpCiDfOiDePiCmMiDfCiDiBiDjDiDgHiCoAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
	findDocumentInfo.m_bFindComment = bFindComment;
	// _xZkqqHx_iMjPiNpFiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	findDocumentInfo.m_pDocSP = &sp;
	if (bSearchAllDocument)
		FindBaseAll(findDocumentInfo,
					hstrProjectPath,
					fdstFrom,
					fdstUntil,
					stLimitUserId);
	else
		FindBaseOne(findDocumentInfo,
					hstrProjectPath,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
					ObjIdToWStringMap(),
					NULL,
					FALSE,
					FALSE,
					FALSE,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
					fdstFrom,
					fdstUntil,
					stLimitUserId,
					bSearchAbove,
					bSearchSuper,
					bSearchAboveBranch,
					bSearchBelow,
					bSearchBelowBranch,
					lStartDocId,
					fliStartSessionIndex);
} // FCHistoryFind::FindDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FindDate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	fdstTargetTime _xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJiOjOiKnEiCmJiNmFiCoAiLnPiCkCiOjOiKnEiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiCnNiOgHiCmBiCmEjBgFiCkNiNiCjBkMiCmFiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::FindDate (	const HString& hstrProjectPath,
								BOOL bIsRoughSearch,
								FDSECTIME fdstFrom,
								FDSECTIME fdstUntil,
								const set<GUID>& stLimitUserId,
								BOOL bSearchAllDocument,
								BOOL bSearchAbove,
								BOOL bSearchSuper,
								BOOL bSearchAboveBranch,
								BOOL bSearchBelow,
								BOOL bSearchBelowBranch,
								long lStartDocId,
								flint fliStartSessionIndex,
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//								flint fliStartCommandPtr,
//								flint fliStartIndexPtr,
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
								FDSECTIME fdstTargetTime)
{
	FCFindDateAInfo findDateAInfo;
	FCFindDateBInfo findDateBInfo;
	FCFindDateBaseInfo& findDateInfo = bIsRoughSearch ? (FCFindDateBaseInfo&)findDateAInfo :
														 (FCFindDateBaseInfo&)findDateBInfo;
	// _xZkqqHx_iMjPiNpFiClHiCoJiDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
	findDateInfo.m_fdstTargetTime = fdstTargetTime;
	if (bSearchAllDocument)
		FindBaseAll(findDateInfo,
					hstrProjectPath,
					fdstFrom,
					fdstUntil,
					stLimitUserId);
	else
		FindBaseOne(findDateInfo,
					hstrProjectPath,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
					ObjIdToWStringMap(),
					NULL,
					FALSE,
					FALSE,
					FALSE,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
					fdstFrom,
					fdstUntil,
					stLimitUserId,
					bSearchAbove,
					bSearchSuper,
					bSearchAboveBranch,
					bSearchBelow,
					bSearchBelowBranch,
					lStartDocId,
					fliStartSessionIndex);
} // FCHistoryFind::FindDate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FindText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrProjectPath		:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstFrom			:_xZkqqHx_iKeKiOgOiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstUntil			:_xZkqqHx_iPeJjHlJiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stLimitUserId		:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAllDocument	:_xZkqqHx_jBfDiCmEiCmMjFlGiPjBiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAbove		:_xZkqqHx_jBePjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchSuper		:_xZkqqHx_iPoDiImKiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAboveBranch	:_xZkqqHx_jBePjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchBelow		:_xZkqqHx_iMoDjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchBelowBranch	:_xZkqqHx_iMoDjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lStartDocId			:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartSessionIndex:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpKeyword			:_xZkqqHx_iMjPiNpFiClHiCoJiDiJiDhIiDiLjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bMultiWord			:_xZkqqHx_jFkBjAjEjCfAiMoKiCmMiMjPiNpFiCpAiLjGiJmCiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bRegexp				:_xZkqqHx_jAlDiLeLjFfMiMlLiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bAsUppercase		:_xZkqqHx_jBoFjFlGiOjKiBeFiPkMjFlGiOjKiCpAiLoGjFmKiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::FindText (	const HString& hstrProjectPath,
								FDSECTIME fdstFrom,
								FDSECTIME fdstUntil,
								const set<GUID>& stLimitUserId,
								BOOL bSearchAllDocument,
								BOOL bSearchAbove,
								BOOL bSearchSuper,
								BOOL bSearchAboveBranch,
								BOOL bSearchBelow,
								BOOL bSearchBelowBranch,
								long lStartDocId,
								flint fliStartSessionIndex,
								BOOL bSearchBeginOfHit,
								BOOL bSearchEndOfHit,
								BOOL bSearchSelectedInside,
								const ObjDynabaseVector& vObj,
								const wchar_t* wcpKeyword,
								BOOL bMultiWord,
								BOOL bRegexp,
								BOOL bAsUppercase)
{
	FCSearchParser sp;
	if (!sp.ParseSearch(wcpKeyword, bRegexp, bAsUppercase, bMultiWord, FALSE)) return;
	FCFindTextInfo findTextInfo;
	// _xZkqqHx_iMjPiNpFiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	findTextInfo.m_bSearchBeginOfHit = bSearchBeginOfHit;	// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIiCkKjEkNjAlGiClFiClNiOjOiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findTextInfo.m_bSearchEndOfHit = bSearchEndOfHit;		// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIiCkKiPmBjGmFiClFiClNiOjOiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findTextInfo.m_bTargetInside = bSearchSelectedInside;	// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCmJiMmAiCmBiCmEiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiBeC_xHqqkZx_
	if (bSearchSelectedInside)
		findTextInfo.SetTargetObjects(vObj);
	findTextInfo.m_pTextSP = &sp;
	if (bSearchAllDocument)
	//----- _xZkqqHx_jBfDjFlGiPjBiCpAiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
	{
		findTextInfo.m_bNeedToSetText = TRUE;
		FindBaseAll(findTextInfo,
					hstrProjectPath,
					fdstFrom,
					fdstUntil,
					stLimitUserId);
	} else
	//----- _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiImKjChFiCpAiKoOjDfPiCmJiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
	{
		findTextInfo.m_bNeedToSetText = FALSE;
		if (bSearchSelectedInside)
		//----- _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCmJiMmAiCmBiCmEiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// vObj_xZkqqHx_iCmMiJlKiCmMiDgFiDeMiDfIiDgHiCmMiCnNiPfHiCnPiCoJiBeC_xHqqkZx_
			struct my
			{
				my (map<DWORD, WString>& mpIdToText) : m_mpIdToText(mpIdToText) {}
				void EnumAllObject (FCObjDynabase* pObj)
				{
					// UNICODE_xZkqqHx_iCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
					if (pObj->GetRichText() != NULL)
						pObj->GetRichText()->GetText(m_mpIdToText[pObj->GetObjID()]);
					for (long lIndex = 0; lIndex != pObj->GetMemberSize(); lIndex++)
						EnumAllObject(pObj->GetMember(lIndex));
				}
				map<DWORD, WString>& m_mpIdToText;
			} My(findTextInfo.m_mpObjectIdToText);
			mdef_const_iterator(ObjDynabaseVector, iObj);
			m1_for (iObj, vObj)
				My.EnumAllObject(*iObj);
		} else
		//----- _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMlLiNnNiCmMjFlGiPjBiCkJiCoHiDgFiDeMiDfIiDgHjFjEjFgJiCpAjCiKiPgPiBeC_xHqqkZx_
			g_pDoc->GetObjectToTextMap(findTextInfo.m_mpObjectIdToText);
		}

		// _xZkqqHx_iKpJiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiDgFiDeMiDfIiDgHiCpAiMjPiNpFiBeC_xHqqkZx_
		map<DWORD, WString>::const_iterator iIs;
		for (iIs = findTextInfo.m_mpObjectIdToText.begin();
			 iIs != findTextInfo.m_mpObjectIdToText.end(); iIs++)
		{
			if (findTextInfo.m_pTextSP->IsMatch(iIs->second))
				findTextInfo.m_stHitTextId.insert(iIs->first);
		}
		FindBaseOne(findTextInfo,
					hstrProjectPath,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
					ObjIdToWStringMap(),
					NULL,
					FALSE,
					FALSE,
					FALSE,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
					fdstFrom,
					fdstUntil,
					stLimitUserId,
					bSearchAbove,
					bSearchSuper,
					bSearchAboveBranch,
					bSearchBelow,
					bSearchBelowBranch,
					lStartDocId,
					fliStartSessionIndex);
	}
} // FCHistoryFind::FindText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FindChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCmMiBeBiOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiImKjChFiCkJiCoHjBePjFpLiBeFiMoDjFpLiCmJ_xHqqkZx_
 *			_xZkqqHx_iMpMiCkJiCmBiCmEiBeBiOhHjCoIiClDiCoKiClNjFjEjFgJiCkKjBiAiNoMiClDiCoKiClNiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj				:_xZkqqHx_iMjPiNpFiClHiCoJjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mpLabelIdToString	:_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCmMiDiJiDhIiDiL_xHqqkZx_ID->_xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpKeyword			:_xZkqqHx_iNgJiCoIiNjOiCnNiMjPiNpFiClHiCoJiDiJiDhIiDiLjFlGiOjKjHpBiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *								 NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *			bMultiWord			:_xZkqqHx_jFkBjAjEjCfAiMoKiCmMiMjPiNpFiCpAiLjGiJmCiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bRegexp				:_xZkqqHx_jAlDiLeLjFfMiMlLiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *			bAsUppercase		:_xZkqqHx_jBoFjFlGiOjKiBeFiPkMjFlGiOjKiCpAiLoGjFmKiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *			fdstFrom			:_xZkqqHx_iKeKiOgOiOjOiKnEiCmMiNgJiNjOiCnNiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			fdstUntil			:_xZkqqHx_iPeJjHlJiOjOiKnEiCmMiNgJiNjOiCnNiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			stLimitUserId		:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMiNgJiNjOiCnNiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchAbove		:_xZkqqHx_jBePjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchSuper		:_xZkqqHx_iPoDiImKiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchAboveBranch	:_xZkqqHx_jBePjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchBelow		:_xZkqqHx_iMoDjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchBelowBranch	:_xZkqqHx_iMoDjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			lStartDocId			:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *			fliStartSessionIndex:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsFlatChar			:_xZkqqHx_jFlGiOjKjBkOjAkLiBgJiDhEiDeIiDjDiDgHjDjJiBgKiCmMjFmPiNfIiCpAiMjPiNpFjBmOiPnLiCmJiClHiCoJiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 TRUE _xZkqqHx_iCmMiPoKiNiHiCmNiMjPiNpFjBmOiPnLiCmJiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.02 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::FindChar (	const HString& hstrProjectPath,
								const map<DWORD, longRangeVector>& mpObjectIdToCharSelect,
								const ObjIdToWStringMap& mpLabelIdToString,
								const wchar_t* wcpKeyword,
								BOOL bMultiWord,
								BOOL bRegexp,
								BOOL bAsUppercase,
								FDSECTIME fdstFrom,
								FDSECTIME fdstUntil,
								const set<GUID>& stLimitUserId,
								BOOL bSearchAbove,
								BOOL bSearchSuper,
								BOOL bSearchAboveBranch,
								BOOL bSearchBelow,
								BOOL bSearchBelowBranch,
								long lStartDocId,
								flint fliStartSessionIndex,
								BOOL bIsFlatChar)
{
	FCFindCharInfo findCharInfo;
	// ID->_xZkqqHx_jFlGiOjKjBeJjBpAiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	findCharInfo.m_mpObjectIdToCharSelect = mpObjectIdToCharSelect;
	// _xZkqqHx_jFlGiOjKjBkOjAkLiCmMjFmPiNfIiCpAjFmPiNfIiCmJiKnMiCnMiClJiCoJiCkJiBeI_xHqqkZx_
	findCharInfo.m_bIsFlatChar = bIsFlatChar;
	FindBaseOne(findCharInfo,
				hstrProjectPath,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
				mpLabelIdToString,
				wcpKeyword,
				bMultiWord,
				bRegexp,
				bAsUppercase,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
				fdstFrom,
				fdstUntil,
				stLimitUserId,
				bSearchAbove,
				bSearchSuper,
				bSearchAboveBranch,
				bSearchBelow,
				bSearchBelowBranch,
				lStartDocId,
				fliStartSessionIndex);
} // FCHistoryFind::FindChar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::MakeTimeIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrProjectPath		:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstFrom			:_xZkqqHx_iKeKiOgOiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstUntil			:_xZkqqHx_iPeJjHlJiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stLimitUserId		:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAllDocument	:_xZkqqHx_jBfDiCmEiCmMjFlGiPjBiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lStartDocId			:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpWorkDirPath		:_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoMjAkMiClHiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iNmFiMoDiCmJ_xHqqkZx_ '\'_xZkqqHx_iCmNiCmCiCkJiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiCpAjCiGjCgGiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHistoryFind::MakeTimeIndex (	const HString& hstrProjectPath,
									FDSECTIME fdstFrom,
									FDSECTIME fdstUntil,
									const set<GUID>& stLimitUserId,
									BOOL bSearchAllDocument,
									long lStartDocId,
									const wchar_t* wcpWorkDirPath)
{
	FCMakeTimeIndexInfo mtiInfo;
	mtiInfo.m_wstrWorkDirPath = wcpWorkDirPath;
	if (bSearchAllDocument)
	//----- _xZkqqHx_jBfDjFlGiPjBiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		return FindBaseAll(	mtiInfo,
							hstrProjectPath,
							fdstFrom,
							fdstUntil,
							stLimitUserId);
	} else
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiPjBiCkJiCoHiJlKiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		return FindBaseOne(	mtiInfo,
							hstrProjectPath,
							ObjIdToWStringMap(),
							NULL,
							FALSE,
							FALSE,
							FALSE,
							fdstFrom,
							fdstUntil,
							stLimitUserId,
							FALSE,
							FALSE,
							FALSE,
							TRUE,
							TRUE,
							lStartDocId,
							-1);
	}
} // FCHistoryFind::MakeTimeIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::GetFindRecSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiMiLiJmKiCmMiDiMiDfCiBfLiDgIiCmMiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHistoryFind::GetFindRecSize () const
{
	return m_vRecord.size();
} // FCHistoryFind::GetFindRecSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::GetFindRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiMiLiJmKiCmMiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIdx	:_xZkqqHx_iDiMiDfCiBfLiDgIiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCHFRecord& FCHistoryFind::GetFindRec (long lIdx) const
{
	return m_vRecord[lIdx];
} // FCHistoryFind::GetFindRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	myLess
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCHistoryFind_xZkqqHx_iCmM_xHqqkZx_SortOrder_xZkqqHx_iCmJiPfNiCmBiCmEiBeBjDpBiCmCiCmM_xHqqkZx_FCHFRecord_xZkqqHx_iCmMjBoFiPkMiKnGiMfHiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiDeOiDiJiDfIiBeC_xHqqkZx_sort_xZkqqHx_jHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class myLess
{
public:
	myLess (FCHistoryFind& historyFind) : m_historyFind(historyFind) {}
	bool operator () (const FCHFRecord& rec0, const FCHFRecord& rec1) const
	{
		WORDVector::const_iterator iR;
		for (iR = m_historyFind.GetSortOrder().begin();
			 iR != m_historyFind.GetSortOrder().end(); iR++)
		{
			WORD wItem = *iR & 0x7fff;
			BOOL bReverse = (*iR & 0x8000) != 0;
			switch (wItem)
			{
			case 0:
			{
				if (rec0.m_recType == rec1.m_recType) break;
				return bReverse ? (rec1.m_recType < rec0.m_recType) :
									(rec0.m_recType < rec1.m_recType);
			}
			case 1:
			{
				int iResult = AtomCmp(rec0.m_atmProjPath, rec1.m_atmProjPath);
				if (iResult == 0) break;
				return bReverse ? (0 < iResult) : (iResult < 0);
			}
			case 2:
			{
				int iResult = AtomCmp(rec0.m_atmHidocument, rec1.m_atmHidocument);
				if (iResult == 0) break;
				return bReverse ? (0 < iResult) : (iResult < 0);
			}
			case 3:
			{
				int iResult = AtomCmp(rec0.m_atmHistVer, rec1.m_atmHistVer);
				if (iResult == 0) break;
				return bReverse ? (0 < iResult) : (iResult < 0);
			}
			case 4:
			{
				if (rec0.m_fliSessionIndex == rec1.m_fliSessionIndex) break;
				return bReverse ? (rec1.m_fliSessionIndex < rec0.m_fliSessionIndex) :
									(rec0.m_fliSessionIndex < rec1.m_fliSessionIndex);
			}
			case 5:
			{
				if (rec0.m_fdstDate == rec1.m_fdstDate) break;
				return bReverse ? (rec1.m_fdstDate < rec0.m_fdstDate) :
									(rec0.m_fdstDate < rec1.m_fdstDate);
			}
			case 6:
			{
				int iResult = AtomCmp(rec0.m_atmContent, rec1.m_atmContent);
				if (iResult == 0) break;
				return bReverse ? (0 < iResult) : (iResult < 0);
			}
			default:
				return FALSE;
			}
		}
		return FALSE;
	}
	int AtomCmp (WORD wAtom0, WORD wAtom1) const
	{
		const wchar_t* tcpStr0 = m_historyFind.AtomToStr(wAtom0);
		const wchar_t* tcpStr1 = m_historyFind.AtomToStr(wAtom1);
		return wcscmp(tcpStr0, tcpStr1);
	}
protected:
	FCHistoryFind&	m_historyFind;
}; // class myLess.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::SortFindRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiMiLiJmKiDiMiDfCiBfLiDgIiDiKiDfIiDgHiCpAiDfMiBfLiDgHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::SortFindRec ()
{
	if (m_vRecord.empty()) return;
	sort(m_vRecord.begin(), m_vRecord.end(), myLess(*this));
} // FCHistoryFind::SortFindRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::GetSortOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfMiBfLiDgHiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfMiBfLiDgHiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	WORD_xZkqqHx_iMfOiCmMjEhKjHpBiBeCiDfMiBfLiDgHiClHiCoJiDeKiDiJiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCmMiPiHjEnEiCkKiLeMjIfOiClDiCoKiCmE_xHqqkZx_
 *			_xZkqqHx_iCkCiCoJiBeCiLhEiDfMiBfLiDgHiClHiCoJiDeKiDiJiDiAiCmNiBeBiNmFiPoDiImKiDhCiDgCiDgHiCmJiCfAiCkKjHkHiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const WORDVector& FCHistoryFind::GetSortOrder () const
{
	return m_vSortOrder;
} // FCHistoryFind::GetSortOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::SetSortOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfMiBfLiDgHiPoOjFpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vOrder	:_xZkqqHx_iDfMiBfLiDgHiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	WORD_xZkqqHx_iMfOiCmMjEhKjHpBiBeCiDfMiBfLiDgHiClHiCoJiDeKiDiJiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCmMiPiHjEnEiCkKiLeMjIfOiClDiCoKiCmE_xHqqkZx_
 *			_xZkqqHx_iCkCiCoJiBeCiLhEiDfMiBfLiDgHiClHiCoJiDeKiDiJiDiAiCmNiBeBiNmFiPoDiImKiDhCiDgCiDgHiCmJiCfAiCkKjHkHiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::SetSortOrder (const WORDVector& vOrder)
{
	m_vSortOrder = vOrder;
} // FCHistoryFind::SetSortOrder.

//----- 06.02.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FindBase
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FindObject, FindLabel _xZkqqHx_jDjJiBeBiMjPiNpFiKnGjAjEiCmMiLkEjHeMiKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	findInfo			:_xZkqqHx_iMjPiNpFiPpAiMiPiCmMjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fdstFrom			:_xZkqqHx_iKeKiOgOiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fdstUntil			:_xZkqqHx_iPeJjHlJiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
// *			stLimitUserId		:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
// *			bSearchAbove		:_xZkqqHx_jBePjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			bSearchSuper		:_xZkqqHx_iPoDiImKiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			bSearchAboveBranch	:_xZkqqHx_jBePjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			bSearchBelow		:_xZkqqHx_iMoDjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			bSearchBelowBranch	:_xZkqqHx_iMoDjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lStartDocId			:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliStartSessionIndex:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliStartCommandPtr	:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliStartIndexPtr	:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHistoryFind::FindBase (	FCFindBaseInfo& findInfo,
//								const HString& hstrProjectPath,
//								FDSECTIME fdstFrom,
//								FDSECTIME fdstUntil,
//								const set<GUID>& stLimitUserId,
//								BOOL bSearchAllDocument,
//								BOOL bSearchAbove,
//								BOOL bSearchSuper,
//								BOOL bSearchAboveBranch,
//								BOOL bSearchBelow,
//								BOOL bSearchBelowBranch,
//								long lStartDocId,
//								flint fliStartSessionIndex)
//{
//	BOOL bSucceed = TRUE;
//	if (bSearchAllDocument)
//	//----- _xZkqqHx_jBfDjHjKjHpAjFlGiPjBiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jBfDjHjKjHpAjFlGiPjBiCpAiMjPiNpFiClHiCoJiPoKiNiHiCmNiBeBjHjKjHpAiNfMjBkCiDgHiDgCiDhGiCmMjFlGiPjBiCpAjClCiCnHiBeB_xHqqkZx_
//		// _xZkqqHx_iClLiCmMjFlGiPjBiCkJiCoHiJlKjHkMiCmMjFlGiPjBjBfDiCmEiCpAiMjPiNpFiClDiClJiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmEiBeBiCgAiBeBiCgBiBeBiCgCiClLiCoKiClMiCoKiCmJiKnGiClFiCmEiJlKjHkMiCpAjBfDiCmEiMjPiNpFiClHiCoJiBeC_xHqqkZx_
//		//
//		//  _xZkqqHx_iCgA_xHqqkZx_          _xZkqqHx_iCgB_xHqqkZx_          _xZkqqHx_iCgC_xHqqkZx_
//		//  _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
//		//  _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
//		//  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_      _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_      _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
//		//  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//		//  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
//		//  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//		//  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//		//  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
//
//		// _xZkqqHx_iMjPiNpFjEmNiImNiCpAjClCiNlIiBeC_xHqqkZx_
//		map<long, flint> mpTopDocToSession;
//		if (!GetSearchAreaAll(mpTopDocToSession, hstrProjectPath))
//			return FALSE;
//
//		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
//		findInfo.m_lDocumentId = -1;
//		// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiBeC_xHqqkZx_
//		findInfo.m_fliNextSessionIndex = -1;
//		// _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
//		findInfo.m_bIsSearchAbove = FALSE;
//		// _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
//		findInfo.m_bIsSearchSuper = FALSE;
//		// _xZkqqHx_jBePjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
//		findInfo.m_bIsSearchAboveBranch = FALSE;
//
//		// _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
//		findInfo.m_bIsSearchBelow = TRUE;
//		// _xZkqqHx_jBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
//		findInfo.m_bIsSearchBelowBranch = TRUE;
//		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
//		findInfo.m_fdstLimitTimeFrom = fdstFrom;
//		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
//		findInfo.m_fdstLimitTimeUntil = fdstUntil;
//		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
//		findInfo.m_stLimitUserId = stLimitUserId;
//
//		// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCpAjFfMiOkGiBeC_xHqqkZx_
//		ShowProgressBar();
//		map<long, flint>::const_iterator iIds;
//		for (iIds = mpTopDocToSession.begin();
//			 bSucceed && iIds != mpTopDocToSession.end();
//			 iIds++)
//		{
//			// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
//			findInfo.m_lDocumentId = (*iIds).first;
//			// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiBeC_xHqqkZx_
//			findInfo.m_fliNextSessionIndex = (*iIds).second;
//			// _xZkqqHx_iMjPiNpFiKeKiOgOiBeC_xHqqkZx_
//			bSucceed = FindSub(findInfo, -1);
//		}
//		// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//		HideProgressBar();
//	} else
//	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iMjPiNpFjEmNiImNiCpAjClCiNlIiBeC_xHqqkZx_
//		if (!GetSearchAreaFork(	hstrProjectPath,
//								lStartDocId,
//								fliStartSessionIndex,
//								bSearchAbove,
//								bSearchSuper,
//								bSearchAboveBranch,
//								bSearchBelow,
//								bSearchBelowBranch))
//			return FALSE;
//
//		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
//		findInfo.m_lDocumentId = lStartDocId;
//		// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiBeC_xHqqkZx_
//		findInfo.m_fliNextSessionIndex = fliStartSessionIndex;
////----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiBeC_xHqqkZx_
////		findInfo.m_fliNextCommandPtr = fliStartCommandPtr;
////		// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiBeC_xHqqkZx_
////		findInfo.m_fliNextIndexPtr = fliStartIndexPtr;
////----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//		// _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
//		findInfo.m_bIsSearchAbove = bSearchAbove;
//		// _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
//		findInfo.m_bIsSearchSuper = bSearchSuper;
//		// _xZkqqHx_jBePjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
//		findInfo.m_bIsSearchAboveBranch = bSearchAboveBranch;
//
//		// _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
//		findInfo.m_bIsSearchBelow = bSearchBelow;
//		// _xZkqqHx_jBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
//		findInfo.m_bIsSearchBelowBranch = bSearchBelowBranch;
//		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
//		findInfo.m_fdstLimitTimeFrom = fdstFrom;
//		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
//		findInfo.m_fdstLimitTimeUntil = fdstUntil;
//		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
//		findInfo.m_stLimitUserId = stLimitUserId;
//
//		// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCpAjFfMiOkGiBeC_xHqqkZx_
//		ShowProgressBar();
//		// _xZkqqHx_iMjPiNpFiKeKiOgOiBeC_xHqqkZx_
//		bSucceed = FindSub(findInfo, -1);
//		// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//		HideProgressBar();
//	}
//	// _xZkqqHx_iMjPiNpFiMiLiJmKiDiMiDfCiBfLiDgIiDiKiDfIiDgHiCpAiDfMiBfLiDgHiClHiCoJiBeC_xHqqkZx_
//	SortFindRec();
//	return bSucceed;
//} // FCHistoryFind::FindBase.
//----- 06.02.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FindBaseAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FindObject, FindLabel _xZkqqHx_jDjJiBeBiMjPiNpFiKnGjAjEiCmMiLkEjHeMiKnGjAjEiBeCjBfDjHjKjHpAjFlGiPjBiCpA_xHqqkZx_
 *			_xZkqqHx_iPoDiCkJiCoHiJlKiCnGiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	findInfo			:_xZkqqHx_iMjPiNpFiPpAiMiPiCmMjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstFrom			:_xZkqqHx_iKeKiOgOiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstUntil			:_xZkqqHx_iPeJjHlJiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stLimitUserId		:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAbove		:_xZkqqHx_jBePjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchSuper		:_xZkqqHx_iPoDiImKiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAboveBranch	:_xZkqqHx_jBePjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchBelow		:_xZkqqHx_iMoDjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchBelowBranch	:_xZkqqHx_iMoDjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lStartDocId			:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartSessionIndex:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartCommandPtr	:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartIndexPtr	:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBfDjHjKjHpAjFlGiPjBiCpAiMjPiNpFiClHiCoJiPoKiNiHiCmNiBeBjHjKjHpAiNfMjBkCiDgHiDgCiDhGiCmMjFlGiPjBiCpAjClCiCnHiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCmMjFlGiPjBiCkJiCoHiJlKjHkMiCmMjFlGiPjBjBfDiCmEiCpAiMjPiNpFiClDiClJiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmEiBeBiCgAiBeBiCgBiBeBiCgCiClLiCoKiClMiCoKiCmJiKnGiClFiCmEiJlKjHkMiCpAjBfDiCmEiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 *			 _xZkqqHx_iCgA_xHqqkZx_          _xZkqqHx_iCgB_xHqqkZx_          _xZkqqHx_iCgC_xHqqkZx_
 *			 _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *			 _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *			 _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_      _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_      _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *			 _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *			 _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_
 *			 _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *			 _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *			 _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHistoryFind::FindBaseAll (	FCFindBaseInfo& findInfo,
									const HString& hstrProjectPath,
									FDSECTIME fdstFrom,
									FDSECTIME fdstUntil,
									const set<GUID>& stLimitUserId)
{
	// _xZkqqHx_iMjPiNpFjEmNiImNiCpAjClCiNlIiBeC_xHqqkZx_
	map<long, flint> mpTopDocToSession;
	if (!GetSearchAreaAll(mpTopDocToSession, hstrProjectPath))
		return FALSE;

	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
	findInfo.m_lDocumentId = -1;
	// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiBeC_xHqqkZx_
	findInfo.m_fliNextSessionIndex = -1;
	// _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findInfo.m_bIsSearchAbove = FALSE;
	// _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findInfo.m_bIsSearchSuper = FALSE;
	// _xZkqqHx_jBePjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findInfo.m_bIsSearchAboveBranch = FALSE;

	// _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findInfo.m_bIsSearchBelow = TRUE;
	// _xZkqqHx_jBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findInfo.m_bIsSearchBelowBranch = TRUE;
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
	findInfo.m_fdstLimitTimeFrom = fdstFrom;
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
	findInfo.m_fdstLimitTimeUntil = fdstUntil;
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
	findInfo.m_stLimitUserId = stLimitUserId;

	// _xZkqqHx_iMjPiNpFiMiLiJmKiBeC_xHqqkZx_
	BOOL bSucceed = TRUE;
	// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCpAjFfMiOkGiBeC_xHqqkZx_
	ShowProgressBar();
	map<long, flint>::const_iterator iIds;
	for (iIds = mpTopDocToSession.begin();
		 bSucceed && iIds != mpTopDocToSession.end();
		 iIds++)
	{
		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
		findInfo.m_lDocumentId = (*iIds).first;
		// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiBeC_xHqqkZx_
		findInfo.m_fliNextSessionIndex = (*iIds).second;
		FCFindBaseInfoAuto pFindInfo(findInfo.Duplicate());
		// _xZkqqHx_iPiJiKpKiJlLiBeC_xHqqkZx_
		pFindInfo->Initialize(hstrProjectPath);
		// _xZkqqHx_iMjPiNpFiKeKiOgOiBeC_xHqqkZx_
		bSucceed = FindSub(*pFindInfo.get(), -1);
	}
	// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
	HideProgressBar();
	// _xZkqqHx_iMjPiNpFiMiLiJmKiDiMiDfCiBfLiDgIiDiKiDfIiDgHiCpAiDfMiBfLiDgHiClHiCoJiBeC_xHqqkZx_
	SortFindRec();
	return bSucceed;
} // FCHistoryFind::FindBaseAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FindBaseOne
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FindObject, FindLabel _xZkqqHx_jDjJiBeBiMjPiNpFiKnGjAjEiCmMiLkEjHeMiKnGjAjEiBeCiMlLiNnNiImKjChFiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClDiCoKiClNiOhNjFpLiMpMiCnGiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	findInfo			:_xZkqqHx_iMjPiNpFiPpAiMiPiCmMjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstFrom			:_xZkqqHx_iKeKiOgOiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstUntil			:_xZkqqHx_iPeJjHlJiOjOiKnEiCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stLimitUserId		:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMiNgJiNjOiCnNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAbove		:_xZkqqHx_jBePjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchSuper		:_xZkqqHx_iPoDiImKiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAboveBranch	:_xZkqqHx_jBePjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchBelow		:_xZkqqHx_iMoDjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchBelowBranch	:_xZkqqHx_iMoDjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lStartDocId			:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartSessionIndex:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iNmFiPiJiCkJiCoHiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHistoryFind::FindBaseOne (	FCFindBaseInfo& findInfo,
									const HString& hstrProjectPath,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
									const ObjIdToWStringMap& mpLabelIdToString,
									const wchar_t* wcpKeyword,
									BOOL bMultiWord,
									BOOL bRegexp,
									BOOL bAsUppercase,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
									FDSECTIME fdstFrom,
									FDSECTIME fdstUntil,
									const set<GUID>& stLimitUserId,
									BOOL bSearchAbove,
									BOOL bSearchSuper,
									BOOL bSearchAboveBranch,
									BOOL bSearchBelow,
									BOOL bSearchBelowBranch,
									long lStartDocId,
									flint fliStartSessionIndex)
{
	// _xZkqqHx_iMjPiNpFjEmNiImNiCpAjClCiNlIiBeC_xHqqkZx_
	if (!GetSearchAreaFork(	hstrProjectPath,
							lStartDocId,
							fliStartSessionIndex,
							bSearchAbove,
							bSearchSuper,
							bSearchAboveBranch,
							bSearchBelow,
							bSearchBelowBranch))
		return FALSE;

	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
	findInfo.m_lDocumentId = lStartDocId;
	// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiBeC_xHqqkZx_
	findInfo.m_fliNextSessionIndex = fliStartSessionIndex;
	// _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findInfo.m_bIsSearchAbove = bSearchAbove;
	// _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findInfo.m_bIsSearchSuper = bSearchSuper;
	// _xZkqqHx_jBePjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findInfo.m_bIsSearchAboveBranch = bSearchAboveBranch;

	// _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findInfo.m_bIsSearchBelow = bSearchBelow;
	// _xZkqqHx_jBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	findInfo.m_bIsSearchBelowBranch = bSearchBelowBranch;

//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNiBeC_xHqqkZx_
	FCSearchParser sp;
	if (wcpKeyword != NULL)
	//----- _xZkqqHx_iDiJiDhIiDiLiMjPiNpFiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (!sp.ParseSearch(wcpKeyword, bRegexp, bAsUppercase, bMultiWord, FALSE))
			return FALSE;
		// _xZkqqHx_iMjPiNpFiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
		findInfo.m_pSP = &sp;
		// _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNjHhAiBeCiMjPiNpFiClDiCoKiCoJiDiJiDhIiDiLiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
		findInfo.m_mpLabelIdToString = mpLabelIdToString;
		// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
		findInfo.m_bLabelHitting = FALSE;

		ObjIdToWStringMap::const_iterator iOl;
		for (iOl = mpLabelIdToString.begin(); iOl != mpLabelIdToString.end(); iOl++)
		{
			// _xZkqqHx_jAnNjCoIjCiGiCmMiDiJiDhIiDiLjFlGiOjKjHpBiCkKiCfAiCmCiCmFiCoAiDhBiDgCiDgHiClFiClNiPoKiNiHiBeC_xHqqkZx_
			if (sp.IsMatch((*iOl).second))
			{
				// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
				findInfo.m_bLabelHitting = TRUE;
				break;
			}
		}
	} else
	//----- _xZkqqHx_iDiJiDhIiDiLiMjPiNpFiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
		findInfo.m_pSP = NULL;
		// _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNjHhAiBeCiMjPiNpFiClDiCoKiCoJiDiJiDhIiDiLiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
		findInfo.m_mpLabelIdToString.clear();
		// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
		findInfo.m_bLabelHitting = TRUE;
	}
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
	findInfo.m_fdstLimitTimeFrom = fdstFrom;
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
	findInfo.m_fdstLimitTimeUntil = fdstUntil;
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
	findInfo.m_stLimitUserId = stLimitUserId;
	// _xZkqqHx_iPiJiKpKiJlLiBeC_xHqqkZx_
	findInfo.Initialize(hstrProjectPath);
	// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCpAjFfMiOkGiBeC_xHqqkZx_
	ShowProgressBar();
	// _xZkqqHx_iMjPiNpFiKeKiOgOiBeC_xHqqkZx_
	BOOL bSucceed = FindSub(findInfo, -1);
	// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
	HideProgressBar();
	// _xZkqqHx_iMjPiNpFiMiLiJmKiDiMiDfCiBfLiDgIiDiKiDfIiDgHiCpAiDfMiBfLiDgHiClHiCoJiBeC_xHqqkZx_
	SortFindRec();
	return bSucceed;
} // FCHistoryFind::FindBaseOne.
//----- 06.02.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::StrToAtom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiCpAiDeBiDgHiDiAiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpLabel	:_xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDgHiDiAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.02.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.04.12 Fukushiro M. HistoryIndex.cpp _xZkqqHx_iCkJiCoHiDfCiDhDiBfLiBeC_xHqqkZx_
 *************************************************************************/
WORD FCHistoryFind::StrToAtom (const wchar_t* tcpLabel)
{
	if (long(WORD(-1)) <= m_vStrTbl.size()) return WORD(-1);

	WORD wIdx;
	for (wIdx = 0; wIdx < m_vStrTbl.size(); wIdx++)
		if (!wcscmp(tcpLabel, m_vStrTbl[wIdx])) return wIdx;
	// _xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiCkKiDgFiBfLiDhFiDiLiCmJiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNjAfGiLeLiCmJjDgPjIfOiClHiCoJiBeC_xHqqkZx_
	m_vStrTbl.push_back(StrNewCpy(tcpLabel));
	return m_vStrTbl.size() - 1;
} // FCHistoryFind::StrToAtom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::AppendFindRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMkJiCmCiCkJiCmBiClNiImKjChFiBgJiDiJiDhIiDiLjDjJiBgKiCmMiDiMiDfCiBfLiDgIiCpAiMjPiNpFiMiLiJmKiDiKiDfIiDgHiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	recType			:_xZkqqHx_jCmHiJmBiClHiCoJiDiMiDfCiBfLiDgIiDfOiDeDiDhGiBeC_xHqqkZx_
 *			wcpProjPath		:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiBeC_xHqqkZx_
 *			lDocId			:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *			wcpDocTitle		:_xZkqqHx_jHjKjHpAjFlGiPjBiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
 *			wcpDocVersion	:_xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
 *			fdstDate		:_xZkqqHx_jDpKiOjOiBeC_xHqqkZx_
 *			wcpContent		:_xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::AppendFindRec (	FTHFRecType recType,
									const wchar_t* wcpProjPath,
									const wchar_t* wcpProjTitle,
									long lDocId,
									const wchar_t* wcpDocTitle,
									const wchar_t* wcpDocVersion,
									flint fliSessionIndex,
									FDSECTIME fdstDate,
									const GUID& guidUserId,
									const wchar_t* wcpContent,
									long lId)
{
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCkKiClBiCoKiImIiPoDiLeMjIfOiCmFiCkLiCmIiCkCiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
	if (FDHF_MAX_REC <= m_vRecord.size()) return;
	// _xZkqqHx_iDiGiBfLiDfFiPoOjFpBiBgJ_xHqqkZx_ Tanaka Taro (XXX-XXXX-XXX) ) _xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
// 06.02.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	WString wstrUserName = g_pProject->UserIdToUserName(guidUserId);
	WString wstrUserName = m_searchProject.UserIdToUserName(guidUserId);
	WString wstrUserInfo = FFGetFormedUserId(guidUserId, wstrUserName);

	//----- _xZkqqHx_jDkPiClGiDiMiDfCiBfLiDgIiCkKjDgPjIfOiNmPiCnNiCkJiCmHiCkEiCkJjClCiNlI_xHqqkZx_ -----
	FCHFRecord newRec(	recType,
						StrToAtom(wcpProjPath),
						StrToAtom(wcpProjTitle),
						lDocId,
						StrToAtom(wcpDocTitle),
						StrToAtom(wcpDocVersion),
						fliSessionIndex,
						fdstDate,
						StrToAtom(wcpContent),
						lId,
						StrToAtom(wstrUserInfo));
	FCHFRecordVector::iterator i = find(m_vRecord.begin(), m_vRecord.end(), newRec);
	if (i != m_vRecord.end()) return;
	// _xZkqqHx_iDiMiDfCiBfLiDgIiCmJjCmHiJmBiBeC_xHqqkZx_
	m_vRecord.push_back(newRec);
} // FCHistoryFind::AppendFindRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FindSub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	findInfo	:_xZkqqHx_iMjPiNpFiClHiCoJjBmOiPnLiCmMjFlGiPjBiPoOjFpBiCmGiBeBiMjPiNpFiClHiCoJjBmOiPnLiCmMjFjEjFgJiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	findInfo _xZkqqHx_iCmJiCmNiBeBiMjPiNpFjBmOiPnLiCmMjFlGiPjBiBeBiMjPiNpFiKeKiOgOiImKjChFiBeBiMjPiNpFjFpLjGeAiBgJiPoDjFpLiBeB_xHqqkZx_
 *			_xZkqqHx_iJlKjFpLiBeBjFkKiKpCjDjJiBgKiBeBiDhNiDgCiDgAiDjDiDePiDhAiDfOiBfLiDjD_xHqqkZx_ _xZkqqHx_iCmGiCkCiCmBiClNiPoDjFpLiCkKiLeMjIfOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			findInfo _xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNjFlGiPjBiCmJiKnGiClFiCmEiBeB_xHqqkZx_findInfo_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiMjPiNpFjFpLjGeAiCmF_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmNiBeBiMjPiNpFjFpLjGeAiCmJiPfNiCmBiCmE_xHqqkZx_ _xZkqqHx_iNmEiLeBjDeJiCmJjFkKiKpCjFlGiPjBiCoAiMjPiNpFiClHiCoJiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_iIoKjDhIiCmJiClNiCkNiClDiCpBiCmMjFlGiPjBiCpAiDiNiDgCiDeOiClFiCmIiCkCiCoGiCkEiCmJiBeBiCnMiClI_xHqqkZx_ _xZkqqHx_iClBiCmMjFlGiPjBiCmMiCnNiCpA_xHqqkZx_
 *			_xZkqqHx_jBfDiCmEiMjPiNpFiClFiBeBiMjPiNpFiPeJjHlJiMoDiCmJiDiNiDgCiDeOiCpAiJpAiPjMiBeBjBlMiCmMjFkKiKpCjFlGiPjBiCmMiMjPiNpFiCpA_xHqqkZx_
 *			_xZkqqHx_iKeKiOgOiClHiCoJiBeC_xHqqkZx_
 *			findInfo _xZkqqHx_iCmMiMjPiNpFiKeKiOgOiCmJiCgAiCkKiLeMjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiCnMiClIiCgAiCpAjBfDiCmE_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiClFiPeJiCoNiCmBiCmEiCkJiCoHiBeBiCgBiBeBiCgCiBeBiCgDiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iBeG_xHqqkZx_            
 *          _xZkqqHx_iEkA_xHqqkZx_            
 *          _xZkqqHx_iEkA_xHqqkZx_            
 *          _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_        
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_        
 *          _xZkqqHx_iCgD_xHqqkZx_  _xZkqqHx_iEkFiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iCgC_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iCgA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkFiEjPiEkC_xHqqkZx_    
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iCgB_xHqqkZx_    
 *          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_    
 *          _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_    
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHistoryFind::FindSub (	FCFindBaseInfo& findInfo,
								long lFlowFromDocId)
{
	FCReqLock reqLock(m_searchProject.GetSubTableName(findInfo.m_lDocumentId));
	DWORD dwLockType = FCReqLock::PROJECT_READ|FCReqLock::FORK_READ|FCReqLock::TERMINATE_READ;
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiBeC_xHqqkZx_
	if (findInfo.IsNeedCommandFile())
		dwLockType |= FCReqLock::COMMAND_READ;
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiBeC_xHqqkZx_
	if (findInfo.IsNeedIndexFile())
		dwLockType |= FCReqLock::SUMMARY_READ;
	if (!reqLock.TryLock(dwLockType))
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkKiDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
		FFErrorBox(FFGetDDErrorMessage());
		return FALSE;
	}

	if (!CheckUpdateProject(reqLock))
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJiMjPiNpFjFhDjEfMiCmIiPeDjAlDiCkKjDpMiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
		FFErrorBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
		return FALSE;
	}

	// CheckUpdateProject _xZkqqHx_iCmJiCoGiCmBiCmEiBeB_xHqqkZx_findInfo.m_lDocumentId _xZkqqHx_iCmM_xHqqkZx_
	// _xZkqqHx_jFlGiPjBiCkKjBlGiNnNiClFiCmEiCkCiCoJiClBiCmGiCkKiKgNjEeGiCmFiCkLiClNiClNiCnPiBeBiImIiJlKiCnGjAgJiCnOiBeC_xHqqkZx_

	// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_findInfo.m_mpFindRec _xZkqqHx_iCmNjDoAjFjEiCmFjFmPiNfIiClDiCoKiCoJiClNiCnPiBeB_xHqqkZx_
	// findInfo _xZkqqHx_iCpAiJlNjDhIiCoAiOgHiCkEiPoKiNiHiCmNiBeBiClBiCoKiCpAiDeOiDiKiDeBiClFiCmEiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	findInfo.m_mpFindRec.clear();

	// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAiDeJiBfLiDhGiDjDiClHiCoJiBeC_xHqqkZx_
	auto_ptr<FCHiCommandTable> autoCmdGate;
	if (findInfo.IsNeedCommandFile())
	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiH_xHqqkZx_ -----
	{
		autoCmdGate = auto_ptr<FCHiCommandTable>(new FCHiCommandTable);
		// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAiDeJiBfLiDhGiDjDiClHiCoJiBeC_xHqqkZx_
		*autoCmdGate = m_searchProject.GetSubGroup(findInfo.m_lDocumentId);
		autoCmdGate->UpdateData(reqLock.m_autoLockCommandRead);
	}
	// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiDeJiBfLiDhGiDjDiClHiCoJiBeC_xHqqkZx_
	auto_ptr<FCHiSummaryTable> autoHistoryIndex;
	if (findInfo.IsNeedIndexFile())
	//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiH_xHqqkZx_ -----
	{
		autoHistoryIndex = auto_ptr<FCHiSummaryTable>(new FCHiSummaryTable);
		// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCpAiDeJiBfLiDhGiDjDiClHiCoJiBeC_xHqqkZx_
		*autoHistoryIndex = m_searchProject.GetSubGroup(findInfo.m_lDocumentId);
		autoHistoryIndex->UpdateData(reqLock.m_autoLockSummaryRead);
	}
	// _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiDeJiBfLiDhGiDjDiClHiCoJiBeC_xHqqkZx_
	FCHiTerminateTable cmdTerminate;
	cmdTerminate = m_searchProject.GetSubGroup(findInfo.m_lDocumentId);
	cmdTerminate.UpdateData(reqLock.m_autoLockTerminateRead);

	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjHjKjHpAjFkKiKpCiOhNiBeC_xHqqkZx_
	vector<FCFindBaseInfoAuto> vFindObjInfo;

	// _xZkqqHx_iMjPiNpFiBeC_xHqqkZx_

	if (findInfo.m_bIsSearchAbove)
	//----- _xZkqqHx_jBePjFpLiCnGiMpMiCkJiCmBiCmEiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBePjFpLiMjPiNpFiCmNiBeBiMjPiNpFiKeKiOgOjFlGiPjBiImIiKePiCmNiBeBjBfDiCmEjHjKjHpAjFkKiKpCiImKjChFiCkJiCoHiKeKiOgOiClDiCoKiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiClNiCnPiBeBiMjPiNpFjCiGiCmJjBlMiDeBiDhGiDiKiCmFjFlGiPjBiCpAjFnCiPfHiClDiCoKiCmEiCoAiJgFiLlPiCpAiOpDiCkPiCmJiCkNiCkCiBeC_xHqqkZx_
		// _xZkqqHx_jFlGiPjBiCmMjCmHiJmBiBeBiPoDiPjBiCkLiCmNjHjKjHpAjFkKiKpCiCoGiCoIiPoDiCmJiCmNjFhDiJmCjEfMiCmIiClNiCnPiBeC_xHqqkZx_
		// _xZkqqHx_jCeBiClFiBeBiMjPiNpFiKeKiOgOjFlGiPjBiCmFiCmNiMlLiNnNiImKjChFiCkKiMjPiNpFiKeKiOgOiImKjChFiCmGiCmIiCoJiClNiCnPiBeBiPoDiPjBiCkLiCmMiJgFiLlPiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
		if (autoCmdGate.get() != NULL)
		//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAjGnKjDeJiCmMiDfKiDgCiDfGiDiHiDjDiLkLiKeFiCnMiCmFiInKjDkOiBeC_xHqqkZx_
			autoCmdGate->SeekToSessionIndex(findInfo.m_fliNextSessionIndex);
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBjFiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
			autoCmdGate->SetupSessionTimeAndIndex();
		}
		if (autoHistoryIndex.get() != NULL)
		//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjGnKjDeJiCmMiDfKiDgCiDfGiDiHiDjDiLkLiKeFiCnMiCmFiInKjDkOiBeC_xHqqkZx_
			autoHistoryIndex->SeekToSessionIndex(findInfo.m_fliNextSessionIndex);
		}
		// _xZkqqHx_jBePjFpLiCpAiMjPiNpFiBeC_xHqqkZx_
		FCFindBaseInfoAuto pFindInfo(findInfo.Duplicate());
		FindObjectResult result = FindAboveSub(	pFindInfo.get(),
												lFlowFromDocId,
												reqLock,
												autoCmdGate.get(),
												autoHistoryIndex.get(),
												cmdTerminate,
												vFindObjInfo);
		// _xZkqqHx_iMjPiNpFiCmJjChGjGlNjDeJiCmIiPeDjAlDiCkKjDpMiCmBiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBgJjFlGiPjBiNoNiPjMjDjJiCmMiPoKiNiHiBgKiBeC_xHqqkZx_
		if (result == Failed)
			return FALSE;
		// _xZkqqHx_iMjPiNpFiKeKiOgOiCmMjFlGiPjBiCmFiCkAiCoIiBeBiKiOiCmCjBlMiDeBiDhGiDiKiCkJiCoHiPoDiPjBiCkLiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
		if (result == Overwrited)
			return FALSE;
		// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
		findInfo.m_mpFindRec = pFindInfo->m_mpFindRec;
	}

	if (findInfo.m_bIsSearchBelow)
	//----- _xZkqqHx_iMoDjFpLiCnGiMpMiCkJiCmBiCmEiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFjAgJjClLiCmMiDgGiBfLiDfOiDfKiDgCiDfGiDiHiDjDjAjEiCpAiLeMiJkPiBeC_xHqqkZx_
		const flint fliSearchProgress = m_fliSearchProgress;

		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjHjKjHpAjFkKiKpCiOhNiBeC_xHqqkZx_
		vector<FCFindBaseInfoAuto> vFindObjInfoBelow;
		for (;;)
		{
			// _xZkqqHx_iMjPiNpFjAgJjClLiCmMiDgGiBfLiDfOiDfKiDgCiDfGiDiHiDjDjAjEiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
			m_fliSearchProgress = fliSearchProgress;

			vFindObjInfoBelow.clear();

			if (autoCmdGate.get() != NULL)
			//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAjGnKjDeJiCmMiDfKiDgCiDfGiDiHiDjDiLkLiKeFiCnMiCmFiInKjDkOiBeC_xHqqkZx_
				autoCmdGate->SeekToSessionIndex(findInfo.m_fliNextSessionIndex);
				// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBjFiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
				autoCmdGate->SetupSessionTimeAndIndex();
			}
			if (autoHistoryIndex.get() != NULL)
			//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjGnKjDeJiCmMiDfKiDgCiDfGiDiHiDjDiLkLiKeFiCnMiCmFiInKjDkOiBeC_xHqqkZx_
				autoHistoryIndex->SeekToSessionIndex(findInfo.m_fliNextSessionIndex);
			}
			// _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiBeC_xHqqkZx_
			FCFindBaseInfoAuto pFindInfo(findInfo.Duplicate());
			FindObjectResult result = FindBelowSub(	pFindInfo.get(),
													lFlowFromDocId,
													reqLock,
													autoCmdGate.get(),
													autoHistoryIndex.get(),
													cmdTerminate,
													vFindObjInfoBelow);
			// _xZkqqHx_iMjPiNpFiCmJjChGjGlNjDeJiCmIiPeDjAlDiCkKjDpMiCmBiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBgJjFlGiPjBiNoNiPjMjDjJiCmMiPoKiNiHiBgKiBeC_xHqqkZx_
			if (result == Failed)
				return FALSE;
			// _xZkqqHx_jBlMiDeBiDhGiDiKiCkJiCoHiPoDiPjBiCkLiClDiCoKiClNiPoKiNiHiCmNiCoAiCkEiIoKjDhIiMjPiNpFiBeC_xHqqkZx_
			if (result == Overwrited) continue;
			// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
			findInfo.m_mpFindRec = pFindInfo->m_mpFindRec;
			break;
		}
		// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
		vFindObjInfo.insert(vFindObjInfo.end(), vFindObjInfoBelow.begin(), vFindObjInfoBelow.end());
	}
	map<flint, FCFindBaseInfo::FindRec>::const_iterator iIxr;
	FCHiDocumentRec hiDocRec = m_searchProject.GetDocumentRec(findInfo.m_lDocumentId);
	for (iIxr = findInfo.m_mpFindRec.begin();
		 iIxr != findInfo.m_mpFindRec.end(); iIxr++)
	//----- _xZkqqHx_iMjPiNpFiCmFiDhBiDgCiDgHiClFiClNiImKjChFiPoOjFpBiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		if ((*iIxr).second.m_iAreaFlag != -1)
		{
			AppendFindRec(	(*iIxr).second.m_recType,
							m_searchProject.GetFilePath(),
							m_searchProject.GetTitle(),
							findInfo.m_lDocumentId,
							hiDocRec.GetDocTitle(),
							hiDocRec.GetVersion(),
							(*iIxr).first,
							(*iIxr).second.m_fdstSessionTime,
							(*iIxr).second.m_guidSessionUser,
							(*iIxr).second.m_wstrComment,
							(*iIxr).second.m_lId);
		}
	}

	// _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCpAiDeOiDiNiBfLiDfJiClHiCoJiBeC_xHqqkZx_
	if (autoCmdGate.get() != NULL) autoCmdGate->Clear();
	// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiDeOiDiNiBfLiDfJiClHiCoJiBeC_xHqqkZx_
	if (autoHistoryIndex.get() != NULL) autoHistoryIndex->Clear();
	// _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiDeOiDiNiBfLiDfJiClHiCoJiBeC_xHqqkZx_
	cmdTerminate.Clear();
	// _xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
	reqLock.ClearAllLock();

	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjHjKjHpAjFkKiKpCiOhNiCpAiBeBiNmEiLeBjDeJiCmJiMjPiNpFiClHiCoJiBeC_xHqqkZx_
	vector<FCFindBaseInfoAuto>::iterator iInf;
	for (iInf = vFindObjInfo.begin(); iInf != vFindObjInfo.end(); iInf++)
	{
		if (!FindSub(	*(*iInf).get(),
						findInfo.m_lDocumentId)) return FALSE;
	}
	return TRUE;
} // FCHistoryFind::FindSub.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FindAboveSub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	pFindInfo _xZkqqHx_iCmFiOkGiClDiCoKiCoJiKeKiOgOiImKjChFiBgJiChHiCmGiClHiCoJiBgKiCkJiCoHiPoDiCpAiMjPiNpFiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iBgJiChHiCmNiKnMiCnMiCmIiCkCiBgKiBeCiChHiCoGiCoIiPoDiCmJjFkKiKpCiCkKiCkAiCmBiCmEiCoAiBeBiClLiCmMiOhNiCmMiMjPiNpFiCmNiClFiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFkKiKpCiBeBiPoDiImKjFlGiPjBiCmNiBeB_xHqqkZx_vFindObjInfo _xZkqqHx_iCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiBeBiDfKiDgCiDfGiDiHiDjDiCkK_xHqqkZx_ [0 - 6] _xZkqqHx_iCmMjHjKjHpAiCmMiDfAiBfLiDfIiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCkK_xHqqkZx_NextSession=4_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iPoDjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1SessionAbove _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliSessionIndex = 3_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 2_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 1_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 0_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1SessionBelow _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliSessionIndex = 4_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 5_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 6_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfCiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkC_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEkGiEjPiEkDiEjP_xHqqkZx_ NextSession = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 4 _xZkqqHx_iBkJiMjPiNpFiKeKiOgOiImKjChF_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 4   _xZkqqHx_iBfA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 6
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 6
 *                  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 7
 *
 *    
 *     _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiNfMjBkCiBeC_xHqqkZx_
 *      _xZkqqHx_iBgDiElBiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiElBiBgD_xHqqkZx_  _xZkqqHx_iBgDiElBiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElBiBgD_xHqqkZx_
 *        _xZkqqHx_iEkLiDfKiDgCiDfGiDiHiDjDiDfEiDeDiDfJiEkLiDfCiDhNiDjDiDgIiCfAiEkL_xHqqkZx_      _xZkqqHx_iEkLiDfCiDhNiDjDiDgIiCiOiEkLiPeJjCfLiDfCiDhNiDjDiDgIiEkLiDfKiDgCiDfGiDiHiDjDiDfEiDeDiDfJiEkL_xHqqkZx_
 *      _xZkqqHx_iBgDiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiElDiBgD_xHqqkZx_  _xZkqqHx_iBgDiElDiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElDiBgD_xHqqkZx_
 *        _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
 *        _xZkqqHx_iEkJiEjPiEjPiEjP_xHqqkZx_SizU_xZkqqHx_iEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_SizU_xZkqqHx_iEjPiEjPiEjPiEkH_xHqqkZx_  
 *                          _xZkqqHx_iEkA_xHqqkZx_                                            _xZkqqHx_iEkA_xHqqkZx_
 *                          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiDfKiDgCiDfGiDiHiDjDiDfEiDeDiDfJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *     _xZkqqHx_iDfCiDhNiDjDiDgIiCmMiNfMjBkCiBeC_xHqqkZx_
 *      _xZkqqHx_iBgDiElBiEkKiEkKiElBiEkKiEkKiElBiEkKiEkKiElBiBgD_xHqqkZx_  _xZkqqHx_iBgDiElBiEkKiEkKiElBiBgD_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_CRC _xZkqqHx_iEkL_xHqqkZx_Size_xZkqqHx_iEkL_xHqqkZx_CMD _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_Size_xZkqqHx_iEkL_xHqqkZx_
 *      _xZkqqHx_iBgDiElDiEkKiEkKiElDiEkKiEkKiElDiEkKiEkKiElDiBgD_xHqqkZx_  _xZkqqHx_iBgDiElDiEkKiEkKiElDiBgD_xHqqkZx_
 *        _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        _xZkqqHx_iEkJ_xHqqkZx_ _xZkqqHx_iCfB_xHqqkZx_ _xZkqqHx_iEkJ_xHqqkZx_SizU_xZkqqHx_iEkJ_xHqqkZx_ _xZkqqHx_iCfB_xHqqkZx_ _xZkqqHx_iEkJiEjPiEjPiEjPiEkJ_xHqqkZx_SizU_xZkqqHx_iEkJ_xHqqkZx_
 *    
 *    
 *          _xZkqqHx_iBhJiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmGiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMjBmOiJjOiBhK_xHqqkZx_
 *    
 *           _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiL_xHqqkZx_
 *        Next=0    Next=1    Next=2    Next=3    Next=4    Next=5    Next=6
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiBgD_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_Session0_xZkqqHx_iEkL_xHqqkZx_Session1_xZkqqHx_iEkL_xHqqkZx_Session2_xZkqqHx_iEkL_xHqqkZx_Session3_xZkqqHx_iEkL_xHqqkZx_Session4_xZkqqHx_iEkL_xHqqkZx_Session5_xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiBgD_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkD_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkD_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *          _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiBgD_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_Session0_xZkqqHx_iEkL_xHqqkZx_Session2_xZkqqHx_iEkL_xHqqkZx_Session5_xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiBgD_xHqqkZx_
 *           _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiL_xHqqkZx_
 *    
 *          _xZkqqHx_jHoBiCkGiCmOiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmM_xHqqkZx_Session2_xZkqqHx_iCmFiDiJiDhIiDiLjFjEjFgJiCgAiCkKiNoMjAkMiClDiCoKiBeB_xHqqkZx_Session5_xZkqqHx_iCmF_xHqqkZx_
 *          _xZkqqHx_iNoNiPjMiClDiCoKiClNiPoKiNiHiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *          Session2_xZkqqHx_iPeJjHlJiMoDiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmNiCfCiCmJiCmIiCmBiCmEiCkCiCoJiCkKiBeB_xHqqkZx_
 *          _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmFiCmNiDiJiDhIiDiLjFjEjFgJiCgAiCmMiNoMjAkMiCmN_xHqqkZx_Session2_xZkqqHx_iCmJiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *          _xZkqqHx_jDkPjHgMiCmJiDiJiDhIiDiLjFjEjFgJiCgAiCmMiNoNiPjMiCmNiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmM_xHqqkZx_Session5_xZkqqHx_iCmJiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *          _xZkqqHx_iClBiClBiCmFiBeBiDiJiDhIiDiLiCgAiCmFiMjPiNpFiCpAiCkJiCkPiClNiPoKiNiHiCpAiNgMiCkGiCoJiCmGiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmFiCmM_xHqqkZx_
 *          Session2_xZkqqHx_jClMiMoDiCkKiDiJiDhIiDiLjFjEjFgJiCgAiCkKiNoMjAkMiClDiCoKiClNiPpDjBnEiCmFiCkAiCoIiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmM_xHqqkZx_
 *          NextSession=3_xZkqqHx_iCkJiCoH_xHqqkZx_NextSession=5_xZkqqHx_iCnMiCmFiCpAiDeKiDgPiBfLiClHiCoJiBeC_xHqqkZx_
 *          _xZkqqHx_iCmCiCnMiCoIiBeBiDiJiDhIiDiLjFjEjFgJiCgAiCkKiNoMjAkMiClDiCoKiClN_xHqqkZx_Session2_xZkqqHx_iCmNiDiJiDhIiDiLiCgAiCmMiDeKiDgPiBfLjEmNiImNiCmJiKnMiCnMiCoKiClIiBeB_xHqqkZx_
 *          _xZkqqHx_iDiJiDhIiDiLjFjEjFgJiCgAiCkKiNoNiPjMiClDiCoKiClN_xHqqkZx_Session5_xZkqqHx_iCmNiDiJiDhIiDiLiCgAiCmMiDeKiDgPiBfLjEmNiImNiCmJiKnMiCnMiCoKiCoJiBeC_xHqqkZx_
 *    
 *                              _xZkqqHx_iCgI_xHqqkZx_     _xZkqqHx_iBkJ_xHqqkZx_ _xZkqqHx_iCgH_xHqqkZx_     _xZkqqHx_iBkJ_xHqqkZx_ _xZkqqHx_iCgG_xHqqkZx_     _xZkqqHx_iBkJ_xHqqkZx_ _xZkqqHx_iCgF_xHqqkZx_     _xZkqqHx_iBkJ_xHqqkZx_ _xZkqqHx_iCgE_xHqqkZx_
 *      _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_
 *        Next=0    Next=1    Next=2    Next=3    Next=4    Next=5    Next=6
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiBgD_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_Session0_xZkqqHx_iEkL_xHqqkZx_Session1_xZkqqHx_iEkL_xHqqkZx_Session2_xZkqqHx_iEkL_xHqqkZx_Session3_xZkqqHx_iEkL_xHqqkZx_Session4_xZkqqHx_iEkL_xHqqkZx_Session5_xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiBgD_xHqqkZx_
 *         _xZkqqHx_iEkEiEkGiEjPiEjPiEkDiEkEiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiBgD_xHqqkZx_
 *           _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_                      
 *           _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiBgD_xHqqkZx_
 *           _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_
 *           _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiBgD_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_Session0_xZkqqHx_iEkL_xHqqkZx_Session2_xZkqqHx_iEkL_xHqqkZx_Session5_xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiBgD_xHqqkZx_
 *                     _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_
 *                     _xZkqqHx_iChA_xHqqkZx_        _xZkqqHx_iCgP_xHqqkZx_
 *           _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiL_xHqqkZx_
 *    
 *     _xZkqqHx_iPoDjHoBiCmFiBeBiImKjChFiCgEiCkJiCoHjBePjFpLiCnG_xHqqkZx_Session5_xZkqqHx_iCpAiDfEiBfLiDgAiClHiCoJiPoKiNiHiCmNiBeBiCnMiClIiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpA_xHqqkZx_
 *     _xZkqqHx_iImKjChFiCgFiCmJjDkPiKpKiClDiClJiCmEiCkJiCoHiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiPpAiMiPiCmJiPfNiCmBiCmEiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmM_xHqqkZx_
 *     Session5_xZkqqHx_iCpAiDfEiBfLiDgAiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *     _xZkqqHx_iImKjChFiCgFiCmJjDkPiKpKiClDiClJiCoJiBeBjBkGiClPiDeDiDjDiDgGiDgCiDeOiDfIiCpAiImKjChFiCgPiCmJiInKjDkOiClHiCoJiCmGiBeBiDiJiDhIiDiLiCgAiCkK_xHqqkZx_
 *     _xZkqqHx_jBlGiNnNiClFiCmEiCkCiCoJiPpDjBnEiCmJiCmIiCoJiCmMiCmFiBeBiDiJiDhIiDiLiCgAiCmNiDiJiDhIiDiLiMjPiNpFjAkHiMmAiCmMjBmOiPnLiCmGiCmIiCoJiBeC_xHqqkZx_
 *     Session3_xZkqqHx_iCpAiDfEiBfLiDgAiClHiCoJiPoKiNiHiCmNiBeBiImKjChFiCgHiCmJjDkPiKpKiClDiClJiCoJiBeBjBkGiClPiDeDiDjDiDgGiDgCiDeOiDfIiCmN_xHqqkZx_
 *     _xZkqqHx_iImKjChFiCgPiCmMiCnMiCnMiCmIiCmMiCmFiBeBiDiJiDhIiDiLiCgAiCmNiDiJiDhIiDiLiMjPiNpFjAkHiMmAiCmMjBmOiPnLiCmGiCmIiCoJiBeC_xHqqkZx_
 *     Session2_xZkqqHx_iCpAiDfEiBfLiDgAiClHiCoJiPoKiNiHiCmNiBeBiImKjChFiCgIiCmJjDkPiKpKiClDiClJiCoJiCkKiBeBiDeDiDjDiDgGiDgCiDeOiDfIiCmN_xHqqkZx_
 *     _xZkqqHx_iImKjChFiChAiCnGiInKjDkOiClFiBeBiDiJiDhIiDiLiCgAiCmNjBlGiNnNiClFiCmIiCkNiCmIiCoJiBeCiClBiCmMiClNiCnPiBeB_xHqqkZx_Session2_xZkqqHx_iCmJiCkIiCkCiCmEiCmN_xHqqkZx_
 *     _xZkqqHx_iDiJiDhIiDiLiCgAiCmNiDiJiDhIiDiLiMjPiNpFjAkHiMmAiCmMjBmOiPnLiCmFiCmNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHistoryFind::FindObjectResult FCHistoryFind::FindAboveSub (
										FCFindBaseInfo* pFindInfo,
										long lFlowFromDocId,
										FCReqLock& reqLock,
										FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										FCHiTerminateTable& cmdTerminate,
										vector<FCFindBaseInfoAuto>& vFindObjInfo)
{
	// _xZkqqHx_jHfMiCnPiLeMjIfOiClDiCoKiCmEiCkCiCoJjFkKiKpCiImKjChFiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
	FCFindForkData* pForkData = DocumentIdToForkData(pFindInfo->m_lDocumentId);
	// _xZkqqHx_jFkKiKpCiPoOjFpBiBeCiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_->_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_jDjJiBeC_xHqqkZx_
	multimap<flint, long>& mmpSessionToFork = pForkData->m_mmpSessionToDocId;

	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	flint fliNextSessionIndex = pFindInfo->m_fliNextSessionIndex;

	// _xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCpAiBeBiKeKiOgOiDfKiDgCiDfGiDiHiDjDiBgJiChHiBgKiCmMiClHiCkOiPoDiCmMiImKjChFiCnMiCmFiInKjDkOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	multimap<flint, long>::reverse_iterator rFork;
	for (rFork = mmpSessionToFork.rbegin();
		 rFork != mmpSessionToFork.rend() && fliNextSessionIndex <= (*rFork).first;
		 rFork++);

	for (;;)
	//----- _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDiCmMiPiIjHjNiCpAiBeBjHjKjHpAiDhEiDeAiDeDiDiLiCmMjAoGjDkKiCnMiCmFiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFjBmOiPnLiCkKjGlDiCkCiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
		if (!pFindInfo->IsThereTarget()) break;

		// _xZkqqHx_iDiNiDgCiDeOiJpAjFpKjHhGiLiBiCkKiCkAiCoJiPoKiNiHiCmNiBeBiIoKiOjOjDeJiCmJiJpAjFpKiClFiCmEiNmEiDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
		FindObjectResult result = CheckUpdateFork(	reqLock,
													pFindInfo->m_lDocumentId,
													pCmdGate,
													pHistoryIndex,
													cmdTerminate);
		// _xZkqqHx_iJpAjFpKjHhGiLiBiCmMiPiIjHjNiMiLiJmKiBeC_xHqqkZx_
		switch (result)
		{
		case Failed:			// _xZkqqHx_iJpAjFpKjHhGiLiBiPiIjHjNiCmFiBeBiMjPiNpFjFhDjEfMiCmGiCmIiCoJiPeDjAlDiCkKjDpMiCmBiClNiPoKiNiHiBeC_xHqqkZx_
			return Failed;
		case Overwrited:		// _xZkqqHx_iJpAjFpKjHhGiLiBiPiIjHjNiCmFiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKiPoDiPjBiCkLiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
			// _xZkqqHx_jBePjFpLiMjPiNpFiCmNiBeBiMjPiNpFiKeKiOgOjFlGiPjBiImIiKePiCmNiBeBjBfDiCmEjHjKjHpAjFkKiKpCiImKjChFiCkJiCoHiKeKiOgOiClDiCoKiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iClBiCmMiClNiCnPiBeBiMjPiNpFjCiGiCmJjBlMiDeBiDhGiDiKiCmFjFlGiPjBiCpAjFnCiPfHiClDiCoKiCmEiCoAiJgFiLlPiCpAiOpDiCkPiCmJiCkNiCkCiBeC_xHqqkZx_
			// _xZkqqHx_jFlGiPjBiCmMjCmHiJmBiBeBiPoDiPjBiCkLiCmNjHjKjHpAjFkKiKpCiCoGiCoIiPoDiCmJiCmNjFhDiJmCjEfMiCmIiClNiCnPiBeC_xHqqkZx_
			// _xZkqqHx_jCeBiClFiBeBiMjPiNpFiKeKiOgOjFlGiPjBiCmFiCmNiMlLiNnNiImKjChFiCkKiMjPiNpFiKeKiOgOiImKjChFiCmGiCmIiCoJiClNiCnPiBeBiPoDiPjBiCkLiCmMiJgFiLlPiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
			if (lFlowFromDocId == -1)
			//----- _xZkqqHx_iMjPiNpFiKeKiOgOiCmMjFlGiPjBiCmFiCkAiCoIiBeBiKiOiCmCjBlMiDeBiDhGiDiKiCkJiCoHiPoDiPjBiCkLiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
				FFErrorBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
				return Overwrited;
			}
			break;
		case UndoOrAppended:	// _xZkqqHx_iJpAjFpKjHhGiLiBiPiIjHjNiCmFiBeBiDfKiDgCiDfGiDiHiDjDiCkKjCmHiJmB_xHqqkZx_ _xZkqqHx_iIlNiCkCiCmNjGnPiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
		case NotChanged:		// _xZkqqHx_iJpAjFpKjHhGiLiBiPiIjHjNiCmFiBeBiDhEiDeAiDeDiDiLiCmJiPeDjAlDiCkKjDpMiCoHiCmIiCkJiCmBiClNiPoKiNiHiBeC_xHqqkZx_
			break;
		}

		// _xZkqqHx_iMjPiNpFiPpAiMiPiCpAjAnNjCoIiBeC_xHqqkZx_
		// _xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiCkKjFkKiKpCiImKjChFiCmJiCkAiCoJiPoKiNiHiCmNiBeBiMlLiPpDiBgJiMjPiNpFiPpDjBnEiBgKiCpA_xHqqkZx_
		// _xZkqqHx_iDfIiDgJiDgCiDhGiCmGiClFiCmEiLeMjIfOiClFiCmEiBeBjFkKiKpCjAoGiCmMiMjPiNpFiCmFiOgHjHhAiClHiCoJiBeC_xHqqkZx_
		if (pFindInfo->m_bIsSearchAboveBranch)
		//----- _xZkqqHx_jBePjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmGjFkKiKpCiImKjChFiCkKiIoKjChGiClHiCoJiCmIiCoHiCmOiBeBiMoDiCmFiMjPiNpFiClHiCoJiInHiCmM_xHqqkZx_
			// _xZkqqHx_jFkKiKpCiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
			for (; rFork != mmpSessionToFork.rend(); rFork++)
			{
				// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmGiIoKjChGiClHiCoJjBfDiCmEiCmMjFkKiKpCiPoOjFpBiCpAiDiLiBfLiDhGiClDiClJiCoJiBeC_xHqqkZx_
				if ((*rFork).first != fliNextSessionIndex) break;
				// _xZkqqHx_jFkKiKpCjAoGiCkKiBeBiMjPiNpFiMlDiCmMjHjKjHpAiCmFiCmIiCkCiCkJjClCiCnHiCoJiBeC_xHqqkZx_
				if ((*rFork).second != lFlowFromDocId)
				//----- _xZkqqHx_jGkCiClOjClCiCnHiCoHiCoKiCmEiCkCiCmIiCkCjHjKjHpAjFlGiPjBiCmMiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iMjPiNpFiPpAiMiPiCpAjAnNjCoIiBeCiMlLiPpDiBgJiMjPiNpFiPpDjBnEiBgKiCpAiDfIiDgJiDgCiDhGiCmGiClFiCmEiLeMjIfOiClHiCoJiBeC_xHqqkZx_
					vFindObjInfo.push_back(FCFindBaseInfoAuto(pFindInfo->Duplicate()));
					// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFlGiPjBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_lDocumentId = (*rFork).second;
					// _xZkqqHx_iDhEiDeAiDeDiDiLiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_fliNextSessionIndex = (*rFork).first;
//----- 06.02.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//					vFindObjInfo.back()->m_fliNextCommandPtr = FD_CMDFILE_HEAD_SIZE;
//					vFindObjInfo.back()->m_fliNextIndexPtr = 0;
//----- 06.02.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
					// _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClFiCmIiCkCiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_bIsSearchAbove = FALSE;
					// _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClFiCmIiCkCiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_bIsSearchSuper = FALSE;
					// _xZkqqHx_jBePjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClFiCmIiCkCiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_bIsSearchAboveBranch = FALSE;
					// _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_bIsSearchBelow = TRUE;
					// _xZkqqHx_iMoDjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_bIsSearchBelowBranch = TRUE;
					// _xZkqqHx_iMjPiNpFiMiLiJmKiCmNiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
					vFindObjInfo.back()->m_mpFindRec.clear();
				}
			}
		}

		// _xZkqqHx_iMjPiNpFiPpAiMiPiCpAjAnNjCoIiBeC_xHqqkZx_
		// _xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiCkKjFkKiKpCiImKjChFiCmJiCkAiCoJiPoKiNiHiCmNiBeBiMlLiPpDiBgJiMjPiNpFiPpDjBnEiBgKiCpA_xHqqkZx_
		// _xZkqqHx_iDfIiDgJiDgCiDhGiCmGiClFiCmEiLeMjIfOiClFiCmEiBeBjFkKiKpCjAoGiCmMiMjPiNpFiCmFiOgHjHhAiClHiCoJiBeC_xHqqkZx_
		if (fliNextSessionIndex == pForkData->m_fliSuperSessionIndex)
		//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMjAoGjDkKiCnMiCmFjHiIiClNiPoKiNiH_xHqqkZx_ -----
		{
			if (pFindInfo->m_bIsSearchSuper)
			//----- _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				if (pForkData->m_lSuperDocumentId != -1)
				//----- _xZkqqHx_iPoDiImKiCmMjHjKjHpAjFlGiPjBiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iMjPiNpFiPpAiMiPiCpAjAnNjCoIiBeCiMlLiPpDiBgJiMjPiNpFiPpDjBnEiBgKiCpAiDfIiDgJiDgCiDhGiCmGiClFiCmEiLeMjIfOiClHiCoJiBeC_xHqqkZx_
					vFindObjInfo.push_back(FCFindBaseInfoAuto(pFindInfo->Duplicate()));
					// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFlGiPjBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_lDocumentId = pForkData->m_lSuperDocumentId;
					// _xZkqqHx_iDhEiDeAiDeDiDiLiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_fliNextSessionIndex = pForkData->m_fliSuperSessionIndex;
//----- 06.02.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//					vFindObjInfo.back()->m_fliNextCommandPtr = pForkData->m_fliSuperCommandPtr;
//					vFindObjInfo.back()->m_fliNextIndexPtr = pForkData->m_fliSuperIndexPtr;
//----- 06.02.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
					// _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_bIsSearchAbove = TRUE;
					// _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_bIsSearchSuper = TRUE;
					// _xZkqqHx_jBePjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiBeB_xHqqkZx_
					// _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiBeBiMoDjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiBeBiCmJjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_bIsSearchBelow = vFindObjInfo.back()->m_bIsSearchAboveBranch;
					vFindObjInfo.back()->m_bIsSearchBelowBranch = vFindObjInfo.back()->m_bIsSearchAboveBranch;
					// _xZkqqHx_iMjPiNpFiMiLiJmKiCmNiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
					vFindObjInfo.back()->m_mpFindRec.clear();
				}
			}
			// _xZkqqHx_iClBiCoKiImIiPoDjBePjFpLiCnGiPoDiCkKiCoKiCmIiCkCiBeCiMjPiNpFiCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
			break;
		}
//----- 06.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// _xZkqqHx_iDgFiDfIiDgHiBeC_xHqqkZx_
//		Sleep(10);
//----- 06.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

		//----- _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiPiIjHjN_xHqqkZx_ -----
		// _xZkqqHx_iMjPiNpFjAgJjClLiCmMiDgGiBfLiDfOiDfKiDgCiDfGiDiHiDjDjAjEiBeC_xHqqkZx_
		m_fliSearchProgress++;
		double dProgress = double(m_fliSearchProgress) / double(m_fliSearchTotal);
		if (1.0 < dProgress) dProgress = 1.0;
		// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCmJjAgJjClLiCpAjFfMiOkGiBeC_xHqqkZx_
		if (m_pDlgProgressBar->SetProgressValue(dProgress) == CFCDlgProgressBar::STOP)
			return Failed;

		// _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDjBePjFpLiCnGiMjPiNpFiBeC_xHqqkZx_
		pFindInfo->Search1SessionAbove(	pCmdGate,
										pHistoryIndex,
										fliNextSessionIndex - 1);
		// _xZkqqHx_iDeDiDjDiDfOiBfLiDfKiDgCiDfGiDiHiDjDiCpAiMjPiNpFiBeC_xHqqkZx_
		pFindInfo->Search1InterSession(	DocumentIdToForkData(pFindInfo->m_lDocumentId),
										&m_searchProject,
										pHistoryIndex,
										fliNextSessionIndex - 1);
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiIoKiCmCiInKjDkOiBeC_xHqqkZx_
		fliNextSessionIndex--;
	}
	return NotChanged;
} // FCHistoryFind::FindAboveSub.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::FindBelowSub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	pFindInfo _xZkqqHx_iCmFiOkGiClDiCoKiCoJiKeKiOgOiImKjChFiBgJiChHiCmGiClHiCoJiBgKiCkJiCoHiJlKiCpAiMjPiNpFiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iBgJiChHiCpAiKnMiCnOiBgKiBeCiChHiCoGiCoIiJlKiCmJjFkKiKpCiCkKiCkAiCmBiCmEiCoAiBeBiClLiCmMiOhNiCmMiMjPiNpFiCmNiClFiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFkKiKpCiCmNiBeB_xHqqkZx_vFindObjInfo _xZkqqHx_iCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiBeBiDfKiDgCiDfGiDiHiDjDiCkK_xHqqkZx_ [0 - 6] _xZkqqHx_iCmMjHjKjHpAiCmMiDfAiBfLiDfIiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCkK_xHqqkZx_NextSession=4_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iPoDjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1SessionAbove _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliSessionIndex = 3_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 2_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 1_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 0_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1SessionBelow _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliSessionIndex = 4_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 5_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 6_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfCiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkC_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEkGiEjPiEkDiEjP_xHqqkZx_ NextSession = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 4 _xZkqqHx_iBkJiMjPiNpFiKeKiOgOiImKjChF_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 4   _xZkqqHx_iBfA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 6
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 6
 *                  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 7
 *
 *    
 *     _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiNfMjBkCiBeC_xHqqkZx_
 *      _xZkqqHx_iBgDiElBiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiElBiBgD_xHqqkZx_  _xZkqqHx_iBgDiElBiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElBiBgD_xHqqkZx_
 *        _xZkqqHx_iEkLiDfKiDgCiDfGiDiHiDjDiDfEiDeDiDfJiEkLiDfCiDhNiDjDiDgIiCfAiEkL_xHqqkZx_      _xZkqqHx_iEkLiDfCiDhNiDjDiDgIiCiOiEkLiPeJjCfLiDfCiDhNiDjDiDgIiEkLiDfKiDgCiDfGiDiHiDjDiDfEiDeDiDfJiEkL_xHqqkZx_
 *      _xZkqqHx_iBgDiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiElDiBgD_xHqqkZx_  _xZkqqHx_iBgDiElDiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElDiBgD_xHqqkZx_
 *        _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
 *        _xZkqqHx_iEkJiEjPiEjPiEjP_xHqqkZx_SizU_xZkqqHx_iEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_SizU_xZkqqHx_iEjPiEjPiEjPiEkH_xHqqkZx_  
 *                          _xZkqqHx_iEkA_xHqqkZx_                                            _xZkqqHx_iEkA_xHqqkZx_
 *                          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiDfKiDgCiDfGiDiHiDjDiDfEiDeDiDfJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *     _xZkqqHx_iDfCiDhNiDjDiDgIiCmMiNfMjBkCiBeC_xHqqkZx_
 *      _xZkqqHx_iBgDiElBiEkKiEkKiElBiEkKiEkKiElBiEkKiEkKiElBiBgD_xHqqkZx_  _xZkqqHx_iBgDiElBiEkKiEkKiElBiBgD_xHqqkZx_
 *        _xZkqqHx_iEkL_xHqqkZx_CRC _xZkqqHx_iEkL_xHqqkZx_Size_xZkqqHx_iEkL_xHqqkZx_CMD _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_Size_xZkqqHx_iEkL_xHqqkZx_
 *      _xZkqqHx_iBgDiElDiEkKiEkKiElDiEkKiEkKiElDiEkKiEkKiElDiBgD_xHqqkZx_  _xZkqqHx_iBgDiElDiEkKiEkKiElDiBgD_xHqqkZx_
 *        _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *        _xZkqqHx_iEkJ_xHqqkZx_ _xZkqqHx_iCfB_xHqqkZx_ _xZkqqHx_iEkJ_xHqqkZx_SizU_xZkqqHx_iEkJ_xHqqkZx_ _xZkqqHx_iCfB_xHqqkZx_ _xZkqqHx_iEkJiEjPiEjPiEjPiEkJ_xHqqkZx_SizU_xZkqqHx_iEkJ_xHqqkZx_
 *    
 *    
 *          _xZkqqHx_iBhJiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmGiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMjBmOiJjOiBhK_xHqqkZx_
 *    
 *           _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiL_xHqqkZx_
 *        Next=0    Next=1    Next=2    Next=3    Next=4    Next=5    Next=6
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiBgD_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_Session0_xZkqqHx_iEkL_xHqqkZx_Session1_xZkqqHx_iEkL_xHqqkZx_Session2_xZkqqHx_iEkL_xHqqkZx_Session3_xZkqqHx_iEkL_xHqqkZx_Session4_xZkqqHx_iEkL_xHqqkZx_Session5_xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiBgD_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkD_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkD_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *          _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiBgD_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_Session0_xZkqqHx_iEkL_xHqqkZx_Session2_xZkqqHx_iEkL_xHqqkZx_Session5_xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiBgD_xHqqkZx_
 *           _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiL_xHqqkZx_
 *    
 *          _xZkqqHx_jHoBiCkGiCmOiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmM_xHqqkZx_Session2_xZkqqHx_iCmFiDiJiDhIiDiLjFjEjFgJiCgAiCkKiNoMjAkMiClDiCoKiBeB_xHqqkZx_Session5_xZkqqHx_iCmF_xHqqkZx_
 *          _xZkqqHx_iNoNiPjMiClDiCoKiClNiPoKiNiHiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *          Session2_xZkqqHx_iPeJjHlJiMoDiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmNiCfCiCmJiCmIiCmBiCmEiCkCiCoJiCkKiBeB_xHqqkZx_
 *          _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmFiCmNiDiJiDhIiDiLjFjEjFgJiCgAiCmMiNoMjAkMiCmN_xHqqkZx_Session2_xZkqqHx_iCmJiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *          _xZkqqHx_jDkPjHgMiCmJiDiJiDhIiDiLjFjEjFgJiCgAiCmMiNoNiPjMiCmNiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmM_xHqqkZx_Session5_xZkqqHx_iCmJiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *          _xZkqqHx_iClBiClBiCmFiBeBiDiJiDhIiDiLiCgAiCmFiMjPiNpFiCpAiCkJiCkPiClNiPoKiNiHiCpAiNgMiCkGiCoJiCmGiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmFiCmM_xHqqkZx_
 *          Session2_xZkqqHx_jClMiMoDiCkKiDiJiDhIiDiLjFjEjFgJiCgAiCkKiNoMjAkMiClDiCoKiClNiPpDjBnEiCmFiCkAiCoIiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmM_xHqqkZx_
 *          NextSession=3_xZkqqHx_iCkJiCoH_xHqqkZx_NextSession=5_xZkqqHx_iCnMiCmFiCpAiDeKiDgPiBfLiClHiCoJiBeC_xHqqkZx_
 *          _xZkqqHx_iCmCiCnMiCoIiBeBiDiJiDhIiDiLjFjEjFgJiCgAiCkKiNoMjAkMiClDiCoKiClN_xHqqkZx_Session2_xZkqqHx_iCmNiDiJiDhIiDiLiCgAiCmMiDeKiDgPiBfLjEmNiImNiCmJiKnMiCnMiCoKiClIiBeB_xHqqkZx_
 *          _xZkqqHx_iDiJiDhIiDiLjFjEjFgJiCgAiCkKiNoNiPjMiClDiCoKiClN_xHqqkZx_Session5_xZkqqHx_iCmNiDiJiDhIiDiLiCgAiCmMiDeKiDgPiBfLjEmNiImNiCmJiKnMiCnMiCoKiCoJiBeC_xHqqkZx_
 *    
 *                              _xZkqqHx_iCgE_xHqqkZx_ _xZkqqHx_iBkI_xHqqkZx_     _xZkqqHx_iCgF_xHqqkZx_ _xZkqqHx_iBkI_xHqqkZx_     _xZkqqHx_iCgG_xHqqkZx_ _xZkqqHx_iBkI_xHqqkZx_     _xZkqqHx_iCgH_xHqqkZx_ _xZkqqHx_iBkI_xHqqkZx_     _xZkqqHx_iCgI_xHqqkZx_
 *      _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_
 *        Next=0    Next=1    Next=2    Next=3    Next=4    Next=5    Next=6
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiBgD_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_Session0_xZkqqHx_iEkL_xHqqkZx_Session1_xZkqqHx_iEkL_xHqqkZx_Session2_xZkqqHx_iEkL_xHqqkZx_Session3_xZkqqHx_iEkL_xHqqkZx_Session4_xZkqqHx_iEkL_xHqqkZx_Session5_xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiBgD_xHqqkZx_
 *         _xZkqqHx_iEkEiEkGiEjPiEjPiEkDiEkEiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiBgD_xHqqkZx_
 *           _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_                      
 *           _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiBgD_xHqqkZx_
 *           _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_
 *           _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiEkKiEkKiEkKiEkKiElBiBgD_xHqqkZx_
 *           _xZkqqHx_iEkL_xHqqkZx_Session0_xZkqqHx_iEkL_xHqqkZx_Session2_xZkqqHx_iEkL_xHqqkZx_Session5_xZkqqHx_iEkL_xHqqkZx_
 *           _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiElDiBgD_xHqqkZx_
 *                     _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_
 *                     _xZkqqHx_iCgP_xHqqkZx_        _xZkqqHx_iChA_xHqqkZx_
 *           _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiL_xHqqkZx_
 *    
 *     _xZkqqHx_iPoDjHoBiCmFiBeBiImKjChFiCgEiCkJiCoHiMoDjFpLiCnG_xHqqkZx_Session2_xZkqqHx_iCpAiDfEiBfLiDgAiClHiCoJiPoKiNiHiCmNiBeBiCnMiClIiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpA_xHqqkZx_
 *     _xZkqqHx_iImKjChFiCgEiCmJjDkPiKpKiClDiClJiCmEiCkJiCoHiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiPpAiMiPiCmJiPfNiCmBiCmEiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmM_xHqqkZx_
 *     Session2_xZkqqHx_iCpAiDfEiBfLiDgAiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *     _xZkqqHx_iImKjChFiCgEiCmJjDkPiKpKiClDiClJiCoJiBeBjBkGiClPiDeDiDjDiDgGiDgCiDeOiDfIiCpAiImKjChFiCgPiCmJiInKjDkOiClHiCoJiCmGiBeBiDiJiDhIiDiLiCgAiCkK_xHqqkZx_
 *     _xZkqqHx_jBlGiNnNiClFiCmIiCkCiPpDjBnEiCmJiCmIiCoJiCmMiCmFiBeBiDiJiDhIiDiLiCgAiCmNiDiJiDhIiDiLiMjPiNpFjAkHiMmAiCmMjBmOiPnLiKePiCmGiCmIiCoJiBeC_xHqqkZx_
 *     Session3_xZkqqHx_iCpAiDfEiBfLiDgAiClHiCoJiPoKiNiHiCmNiBeBiImKjChFiCgFiCmJjDkPiKpKiClDiClJiCoJiBeBjBkGiClPiDeDiDjDiDgGiDgCiDeOiDfIiCmN_xHqqkZx_
 *     _xZkqqHx_iImKjChFiChAiCmJiInKjDkOiClHiCoJiCmMiCmFiBeBiDiJiDhIiDiLiCgAiCmNiDiJiDhIiDiLiMjPiNpFjAkHiMmAiCmMjBmOiPnLiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHistoryFind::FindObjectResult FCHistoryFind::FindBelowSub (
													FCFindBaseInfo* pFindInfo,
													long lFlowFromDocId,
													FCReqLock& reqLock,
													FCHiCommandTable* pCmdGate,
													FCHiSummaryTable* pHistoryIndex,
													FCHiTerminateTable& cmdTerminate,
													vector<FCFindBaseInfoAuto>& vFindObjInfo)
{
	// _xZkqqHx_jHfMiCnPiLeMjIfOiClDiCoKiCmEiCkCiCoJjFkKiKpCiImKjChFiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
	FCFindForkData* pForkData = DocumentIdToForkData(pFindInfo->m_lDocumentId);
	// _xZkqqHx_jFkKiKpCiPoOjFpBiBeCiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_->_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_jDjJiBeC_xHqqkZx_
	multimap<flint, long>& mmpSessionToFork = pForkData->m_mmpSessionToDocId;
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiPeJjCfLiBeC_xHqqkZx_
	flint fliSessionIndexEnd = cmdTerminate.SeeEndSessionIndex();

	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	flint fliNextSessionIndex = pFindInfo->m_fliNextSessionIndex;

	// _xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCpAiBeBiKeKiOgOiDfKiDgCiDfGiDiHiDjDiBgJiChHiBgKiCmMiJlKiCmMiImKjChFiBgJiChHiCpAiKnMiCnOiBgKiCnMiCmFiInKjDkOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	multimap<flint, long>::iterator iFork;
	iFork = mmpSessionToFork.lower_bound(fliNextSessionIndex);

	for (;;)
	//----- _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDiCmMiPiIjHjNiCpAiBeBjHjKjHpAiDhEiDeAiDeDiDiLiCmMiPeJjCfLiCnMiCmFiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFjBmOiPnLiCkKjGlDiCkCiPoKiNiHiCmNiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
		if (!pFindInfo->IsThereTarget()) break;

		// _xZkqqHx_iDiNiDgCiDeOiJpAjFpKjHhGiLiBiCkKiCkAiCoJiPoKiNiHiCmNiBeBiIoKiOjOjDeJiCmJiJpAjFpKiClFiCmEiNmEiDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
		FindObjectResult result = CheckUpdateFork(	reqLock,
													pFindInfo->m_lDocumentId,
													pCmdGate,
													pHistoryIndex,
													cmdTerminate);
		// _xZkqqHx_iJpAjFpKjHhGiLiBiCmMiPiIjHjNiMiLiJmKiBeC_xHqqkZx_
		switch (result)
		{
		case Failed:			// _xZkqqHx_iJpAjFpKjHhGiLiBiPiIjHjNiCmFiBeBiMjPiNpFjFhDjEfMiCmGiCmIiCoJiPeDjAlDiCkKjDpMiCmBiClNiPoKiNiHiBeC_xHqqkZx_
			return Failed;
		case Overwrited:		// _xZkqqHx_iJpAjFpKjHhGiLiBiPiIjHjNiCmFiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKiPoDiPjBiCkLiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
			// _xZkqqHx_iMoDjFpLiMjPiNpFiCmNiBeBjBePjFpLiMjPiNpFiCmGiIoBiCmBiCmEiBeBiMjPiNpFjCiGiCmJjBlMiDeBiDhGiDiKiCmFjFlGiPjBiCpAjFnCiPfHiClDiCoKiCoJiCmG_xHqqkZx_
			// _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiCoCiClHiCkCiBeC_xHqqkZx_
			return Overwrited;
		case UndoOrAppended:	// _xZkqqHx_iJpAjFpKjHhGiLiBiPiIjHjNiCmFiBeBiDfKiDgCiDfGiDiHiDjDiCkKjCmHiJmB_xHqqkZx_ _xZkqqHx_iIlNiCkCiCmNjGnPiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiPeJjCfLiCpAiOoGjDlOiClFiCmIiCkIiClHiBeC_xHqqkZx_
			fliSessionIndexEnd = cmdTerminate.SeeEndSessionIndex();
			break;
		case NotChanged:		// _xZkqqHx_iJpAjFpKjHhGiLiBiPiIjHjNiCmFiBeBiDhEiDeAiDeDiDiLiCmJiPeDjAlDiCkKjDpMiCoHiCmIiCkJiCmBiClNiPoKiNiHiBeC_xHqqkZx_
			break;
		}

		// _xZkqqHx_iMjPiNpFiPpAiMiPiCpAjAnNjCoIiBeC_xHqqkZx_
		// _xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiCkKjFkKiKpCiImKjChFiCmJiCkAiCoJiPoKiNiHiCmNiBeBiMlLiPpDiBgJiMjPiNpFiPpDjBnEiBgKiCpA_xHqqkZx_
		// _xZkqqHx_iDfIiDgJiDgCiDhGiCmGiClFiCmEiLeMjIfOiClFiCmEiBeBjFkKiKpCjAoGiCmMiMjPiNpFiCmFiOgHjHhAiClHiCoJiBeC_xHqqkZx_
		if (pFindInfo->m_bIsSearchBelowBranch)
		//----- _xZkqqHx_jBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmGjFkKiKpCiImKjChFiCkKiIoKjChGiClHiCoJiCmIiCoHiCmOiBeBiMoDiCmFiMjPiNpFiClHiCoJiInHiCmM_xHqqkZx_
			// _xZkqqHx_jFkKiKpCiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
			for (; iFork != mmpSessionToFork.end(); iFork++)
			{
				// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmGiIoKjChGiClHiCoJjBfDiCmEiCmMjFkKiKpCiPoOjFpBiCpAiDiLiBfLiDhGiClDiClJiCoJiBeC_xHqqkZx_
				if ((*iFork).first != fliNextSessionIndex) break;
				// _xZkqqHx_jFkKiKpCjAoGiCkKiBeBiMjPiNpFiMlDiCmMjHjKjHpAiCmFiCmIiCkCiCkJjClCiCnHiCoJiBeC_xHqqkZx_
				if ((*iFork).second != lFlowFromDocId)
				//----- _xZkqqHx_jGkCiClOjClCiCnHiCoHiCoKiCmEiCkCiCmIiCkCjHjKjHpAjFlGiPjBiCmMiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iMjPiNpFiPpAiMiPiCpAjAnNjCoIiBeCiMlLiPpDiBgJiMjPiNpFiPpDjBnEiBgKiCpAiDfIiDgJiDgCiDhGiCmGiClFiCmEiLeMjIfOiClHiCoJiBeC_xHqqkZx_
					vFindObjInfo.push_back(FCFindBaseInfoAuto(pFindInfo->Duplicate()));
					// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFlGiPjBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_lDocumentId = (*iFork).second;
					// _xZkqqHx_iDhEiDeAiDeDiDiLiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_fliNextSessionIndex = (*iFork).first;
//----- 06.02.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//					vFindObjInfo.back()->m_fliNextCommandPtr = FD_CMDFILE_HEAD_SIZE;
//					vFindObjInfo.back()->m_fliNextIndexPtr = 0;
//----- 06.02.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
					// _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClFiCmIiCkCiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_bIsSearchAbove = FALSE;
					// _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClFiCmIiCkCiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_bIsSearchSuper = FALSE;
					// _xZkqqHx_jBePjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClFiCmIiCkCiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_bIsSearchAboveBranch = FALSE;
					// _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_bIsSearchBelow = TRUE;
					// _xZkqqHx_iMoDjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
					vFindObjInfo.back()->m_bIsSearchBelowBranch = TRUE;
					// _xZkqqHx_iMjPiNpFiMiLiJmKiCmNiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
					vFindObjInfo.back()->m_mpFindRec.clear();
				}
			}
		}

		// _xZkqqHx_iPeJjCfLiCoGiCoIiMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiCkKiMoDjFpLiCmJiCkAiCoJiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		// _xZkqqHx_jBlMiDeBiDhGiDiKiCmF_xHqqkZx_Undo_xZkqqHx_iClFiClNiPoKiNiHiCmJiCmNiBeBiMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiCkK_xHqqkZx_
		// _xZkqqHx_iPeJjCfLiCpAiJhKiCkGiCoJiPoKiNiHiCkKiCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
		if (fliSessionIndexEnd <= fliNextSessionIndex)
		//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiPeJjCfLiCnMiCmFjHiIiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeDiDjDiDfOiBfLiDfKiDgCiDfGiDiHiDjDiCpAiMjPiNpFiBeC_xHqqkZx_
			if (fliSessionIndexEnd == fliNextSessionIndex)
				pFindInfo->Search1InterSession(	DocumentIdToForkData(pFindInfo->m_lDocumentId),
												&m_searchProject,
												pHistoryIndex,
												fliNextSessionIndex);
			// _xZkqqHx_iClBiCoKiImIiPoDiMoDjFpLiCnGiPoDiCkKiCoKiCmIiCkCiBeCiMjPiNpFiCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
			break;
		}
//----- 06.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// _xZkqqHx_iDgFiDfIiDgHiBeC_xHqqkZx_
//		Sleep(10);
//----- 06.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

		//----- _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiPiIjHjN_xHqqkZx_ -----
		// _xZkqqHx_iMjPiNpFjAgJjClLiCmMiDgGiBfLiDfOiDfKiDgCiDfGiDiHiDjDjAjEiBeC_xHqqkZx_
		m_fliSearchProgress++;
		double dProgress = double(m_fliSearchProgress) / double(m_fliSearchTotal);
		if (1.0 < dProgress) dProgress = 1.0;
		// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCmJjAgJjClLiCpAjFfMiOkGiBeC_xHqqkZx_
		if (m_pDlgProgressBar->SetProgressValue(dProgress) == CFCDlgProgressBar::STOP)
			return Failed;

		// _xZkqqHx_iDeDiDjDiDfOiBfLiDfKiDgCiDfGiDiHiDjDiCpAiMjPiNpFiBeC_xHqqkZx_
		pFindInfo->Search1InterSession(	DocumentIdToForkData(pFindInfo->m_lDocumentId),
										&m_searchProject,
										pHistoryIndex,
										fliNextSessionIndex);
		// _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDiMoDjFpLiCnGiMjPiNpFiBeC_xHqqkZx_
		pFindInfo->Search1SessionBelow(	pCmdGate,
										pHistoryIndex,
										fliNextSessionIndex);
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiCfAiCmCjAgJiCnPiCoJiBeC_xHqqkZx_
		fliNextSessionIndex++;
	}
	return NotChanged;
} // FCHistoryFind::FindBelowSub.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::GetSearchAreaAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiNiDfHiDeGiDeOiDgHiCmJiKnGiClFiCmEiBeBjBfDiCmEiCmMjFlGiPjBiCmMjFkKiKpCiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mpTopDocToSession	:_xZkqqHx_iDgHiDgCiDhGjFlGiPjB_xHqqkZx_ID->_xZkqqHx_iKeKiOgOiDfKiDgCiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iCpAiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			wcpProjectPath		:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiClOiClFiCmJiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	GetSearchAreaFork _xZkqqHx_iCkKiBeBiOhHjCoIiClDiCoKiClNjEmNiImNiCmMiCnNiCpAiMjPiNpFiClHiCoJiCmMiCmJjBmOiClFiCmEiBeBiClBiCmM_xHqqkZx_
 *			_xZkqqHx_iKnGjAjEiCmNiBeBjBfDiCmEiCmMjFlGiPjBiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiCmNiBeB_xHqqkZx_GetSearchAreaForkBranch_xZkqqHx_iKnGjAjEiCpAiNmEiLeBjDeJiCmJiMmEiCnEiClBiCmGiCmF_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jDmHiCnNiPgPiClDiCoKiClNiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCmMiPoOjFpBiCmNiBeB_xHqqkZx_m_mpSearchDocIdToFork_xZkqqHx_jFmPjAjEiCmJ_xHqqkZx_
 *			_xZkqqHx_iOpLjEfLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHistoryFind::GetSearchAreaAll (	map<long, flint>& mpTopDocToSession,
										const HString& hstrProjectPath)
{
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FCDbReadLock autoLockProjectRead(wcpProjectPath);
//	if (!autoLockProjectRead.TryLock())
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
//		FFErrorBox(FFGetDDErrorMessage());
//		return FALSE;
//	}
//	m_searchProject.SetFilePath(wcpProjectPath);
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	m_searchProject = g_pFileServer->GetTopGroup(hstrProjectPath);
	// _xZkqqHx_iDiNiDgCiDeOiClHiCoJiDhEiDeAiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	FCDbReadLock autoLockProjectRead;
	if (!m_searchProject.TryLock(autoLockProjectRead))
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
		FFErrorBox(FFGetDDErrorMessage());
		return FALSE;
	}
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	m_searchProject.UpdateData(autoLockProjectRead);
	m_mpSearchDocIdToFork.clear();
	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDgGiBfLiDfOiDfKiDgCiDfGiDiHiDjDjAjEiBeC_xHqqkZx_
	m_fliSearchTotal = 0;

	// _xZkqqHx_iDgHiDgCiDhGjFlGiPjB_xHqqkZx_ID->_xZkqqHx_iDgHiDgCiDhGiDfKiDgCiDfGiDiHiDjDjEhKjHpBiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	mpTopDocToSession.clear();

	// _xZkqqHx_iDgHiDgCiDhGiCmMjHjKjHpAjFlGiPjBiCpAiOoGjDlOiBeC_xHqqkZx_
	longSet stTopId;
	m_searchProject.GetHidocumentTree(stTopId, map<long, longSet>());

	longSet::const_iterator iId;
	for (iId = stTopId.begin(); iId != stTopId.end(); iId++)
	//----- _xZkqqHx_iDgHiDgCiDhGjHjKjHpAjFlGiPjBiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		flint fliStartSessionIndex = -1;
		if (!GetSearchAreaForkBranch(*iId, fliStartSessionIndex, -1, FALSE, FALSE, FALSE, TRUE, TRUE))
		{
			m_mpSearchDocIdToFork.clear();
			return FALSE;
		}
		// _xZkqqHx_iDgHiDgCiDhGjFlGiPjB_xHqqkZx_ID->_xZkqqHx_iDgHiDgCiDhGiDfKiDgCiDfGiDiHiDjDjEhKjHpBiCpAjAnNjCoIiBeC_xHqqkZx_
		mpTopDocToSession[*iId] = fliStartSessionIndex;
	}
	return TRUE;
} // FCHistoryFind::GetSearchAreaAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::GetSearchAreaFork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiNiDfHiDeGiDeOiDgHiCmJiKnGiClFiCmEiBeBiOhHjCoIiClDiCoKiClNjFlGiPjBiImKjChFiCkJiCoHiBeB_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClDiCoKiClNjEmNiImNiCmMjFkKiKpCiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFjEmNiImNiCmJiKnGiClFiCmEiCmNiBeB_xHqqkZx_FindObject_xZkqqHx_iKnGjAjEiCmMjAoAjGlOiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	project				:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCpAiPiJiKpKiJlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			mpDocIdToFork		:_xZkqqHx_jFlGiPjB_xHqqkZx_ID->_xZkqqHx_iDhEiDeIiBfLiDeOiPoOjFpB_xHqqkZx_ _xZkqqHx_iCpAiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			wcpProjectPath		:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lStartDocId			:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartSessionIndex:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 -1 _xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmNiClBiCmMjFlGiPjBiCmMiDgHiDgCiDhGiCkJiCoHiMjPiNpFiClFiBeB_xHqqkZx_
 *								 _xZkqqHx_iClLiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsSearchAbove		:_xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsSearchSuper		:_xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsSearchBelow		:_xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsSearchBelowBranch:_xZkqqHx_jBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiClOiClFiCmJiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	GetSearchAreaAll _xZkqqHx_iCkKiBeBjBfDiCmEiCmMjFlGiPjBiCpAiMjPiNpFiClHiCoJiCmMiCmJjBmOiClFiCmEiBeBiClBiCmM_xHqqkZx_
 *			_xZkqqHx_iKnGjAjEiCmNiBeBiOhHjCoIiClDiCoKiClNjEmNiImNiCmMiCnNiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiCmNiBeB_xHqqkZx_GetSearchAreaForkBranch_xZkqqHx_iKnGjAjEiCpAiNmEiLeBjDeJiCmJiMmEiCnEiClBiCmGiCmF_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jDmHiCnNiPgPiClDiCoKiClNiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCmMiPoOjFpBiCmNiBeB_xHqqkZx_m_mpSearchDocIdToFork_xZkqqHx_jFmPjAjEiCmJ_xHqqkZx_
 *			_xZkqqHx_iOpLjEfLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHistoryFind::GetSearchAreaFork (	const HString& hstrProjectPath,
										long lStartDocId,
										flint& fliStartSessionIndex,
										BOOL bIsSearchAbove,
										BOOL bIsSearchSuper,
										BOOL bIsSearchAboveBranch,
										BOOL bIsSearchBelow,
										BOOL bIsSearchBelowBranch)
{
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FCDbReadLock autoLockProjectRead(wcpProjectPath);
//	if (!autoLockProjectRead.TryLock())
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
//		FFErrorBox(FFGetDDErrorMessage());
//		return FALSE;
//	}
//	m_searchProject.SetFilePath(wcpProjectPath);
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	m_searchProject = g_pFileServer->GetTopGroup(hstrProjectPath);
	// _xZkqqHx_iDiNiDgCiDeOiClHiCoJiDhEiDeAiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	FCDbReadLock autoLockProjectRead;
	if (!m_searchProject.TryLock(autoLockProjectRead))
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
		FFErrorBox(FFGetDDErrorMessage());
		return FALSE;
	}
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	m_searchProject.UpdateData(autoLockProjectRead);
	m_mpSearchDocIdToFork.clear();
	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDgGiBfLiDfOiDfKiDgCiDfGiDiHiDjDjAjEiBeC_xHqqkZx_
	m_fliSearchTotal = 0;

	BOOL bSearch;
	bSearch = GetSearchAreaForkBranch(	lStartDocId,
										fliStartSessionIndex,
										-1,
										bIsSearchAbove,
										bIsSearchSuper,
										bIsSearchAboveBranch,
										bIsSearchBelow,
										bIsSearchBelowBranch);
	if (!bSearch)
	{
		m_mpSearchDocIdToFork.clear();
		return FALSE;
	} else
	{
		return TRUE;
	}
} // FCHistoryFind::GetSearchAreaFork.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::GetSearchAreaForkBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCpAjDmHiCnNiPgPiClFiCmEiBeBiClLiCmMiPoOjFpBiCpA_xHqqkZx_
 *			_xZkqqHx_jFmPjAjEiCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNfIiCmJiBeBiClLiCmMjFlGiPjBiCkJiCoHjFkKiKpCiClHiCoJjFlGiPjBiCpAiNmEiLeBjDeJiCmJjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFjEmNiImNiCmJiKnGiClFiCmEiCmNiBeB_xHqqkZx_FindObject_xZkqqHx_iKnGjAjEiCmMjAoAjGlOiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId				:_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliStartSessionIndex:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 -1 _xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmNiClBiCmMjFlGiPjBiCmMiDgHiDgCiDhGiCkJiCoHiMjPiNpFiClFiBeB_xHqqkZx_
 *								 _xZkqqHx_iClLiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			lSearchFromDocId	:_xZkqqHx_iClBiCmMiKnGjAjEiCpAiMmEiCnBiPgPiClFiClNiMlDiCmMiKnGjAjEiCmFiKeKiCkCiCmEiCkCiCoJjFlGiPjBiCmMiBeB_xHqqkZx_
 *								 _xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSearchAbove		:_xZkqqHx_jBePjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchSuper		:_xZkqqHx_iPoDiImKiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchAboveBranch	:_xZkqqHx_jBePjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchBelow		:_xZkqqHx_iMoDjFpLiCmJiMpMiCkJiCmBiCmEiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bSearchBelowBranch	:_xZkqqHx_iMoDjFpLiCmMiBeBjBlMiCmMiOhNiCoAiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiClOiClFiCmJiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHistoryFind::GetSearchAreaForkBranch (	long lDocId,
												flint& fliStartSessionIndex,
												long lSearchFromDocId,
												BOOL bIsSearchAbove,
												BOOL bIsSearchSuper,
												BOOL bIsSearchAboveBranch,
												BOOL bIsSearchBelow,
												BOOL bIsSearchBelowBranch)
{
	FCHiDocumentRec hiDocRec = m_searchProject.GetDocumentRec(lDocId);
	if (hiDocRec.GetIsInvalid())
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCkKiDhGiDiNiDfHiDeGiDeOiDgHjCiGiCmJjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
		// _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
		FFErrorBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
		return FALSE;
	}

	FCDbReadLock autoLockForkRead(m_searchProject.GetFilePathH(), lDocId, FDHI_FORK_TABLE_ID);
	if (!autoLockForkRead.TryLock())
	//----- _xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCkKiDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
		FFErrorBox(FFGetDDErrorMessage());
		return FALSE;
	}

	// _xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
	m_mpSearchDocIdToFork[lDocId].m_wstrTitle = hiDocRec.GetDocTitle();
	// _xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
	m_mpSearchDocIdToFork[lDocId].m_wstrComment = hiDocRec.GetComment();
	// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMiOjOiKnEiBeC_xHqqkZx_
	m_mpSearchDocIdToFork[lDocId].m_fdstCreateTime = hiDocRec.GetDate();
	// _xZkqqHx_jHjKjHpAjFlGiPjBiCmMiNoMjAkMiOnCiBeC_xHqqkZx_
	m_mpSearchDocIdToFork[lDocId].m_guidUserId = hiDocRec.GetUserId();
//----- 05.11.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iPoDiImKjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_mpSearchDocIdToFork[lDocId].m_lSuperDocumentId = hiDocRec.GetSuperDocId();
//----- 05.11.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDgGiBfLiDfOiPeDjAlDiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
	m_mpSearchDocIdToFork[lDocId].m_dwLockDeleteIdentifier = autoLockForkRead.GetLockDeleteIdentifier();
	// _xZkqqHx_iDgGiBfLiDfOjCmHiJmBiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
	m_mpSearchDocIdToFork[lDocId].m_dwLockAppendIdentifier = autoLockForkRead.GetLockAppendIdentifier();

	// _xZkqqHx_iPoDiImKjFlGiPjBiCmMiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FCHiForkTable forkFile(&m_searchProject, lDocId, &autoLockForkRead);
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FCHiForkTable forkFile = m_searchProject.GetSubGroup(lDocId);
	forkFile.UpdateData(autoLockForkRead);
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	flint fliSuperSessionIndex;
//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	flint fliSuperCommandPtr;
//	flint fliSuperIndexPtr;
//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	long lSuperDocId;
// 06.01.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	forkFile.GetSuperInfo(&fliSuperSessionIndex, &fliSuperCommandPtr, &fliSuperIndexPtr, &lSuperDocId);
	forkFile.GetSuperInfo(&fliSuperSessionIndex, &lSuperDocId);

	// _xZkqqHx_iKeKiOgOiDfKiDgCiDfGiDiHiDjDiCkKiDgGiDhEiDeIiDiLiDgHiCmMiPoKiNiHiCmNiBeBiNmFiPiJiCmMiDfKiDgCiDfGiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
	if (fliStartSessionIndex == -1)
		fliStartSessionIndex = fliSuperSessionIndex;

	// _xZkqqHx_iPoDiImKjFlGiPjBiCmMiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
	m_mpSearchDocIdToFork[lDocId].m_fliSuperSessionIndex = fliSuperSessionIndex;
//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	m_mpSearchDocIdToFork[lDocId].m_fliSuperCommandPtr = fliSuperCommandPtr;
//	m_mpSearchDocIdToFork[lDocId].m_fliSuperIndexPtr = fliSuperIndexPtr;
//----- 06.01.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 05.11.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDiKiDfIiDgHiBeC_xHqqkZx_
	forkFile.GetTimeLabelList(m_mpSearchDocIdToFork[lDocId].m_mmpTimeLabelList);
	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiKiDfIiDgHiBeC_xHqqkZx_
	forkFile.GetHiForkTagList(m_mpSearchDocIdToFork[lDocId].m_mpHiForkTagList);
//----- 05.11.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	if (bIsSearchAbove)
	//----- _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDgGiBfLiDfOiDfKiDgCiDfGiDiHiDjDjAjEiBeC_xHqqkZx_(_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChF_xHqqkZx_ - _xZkqqHx_jAoGjDkKiImKjChF_xHqqkZx_)_xZkqqHx_iCpAiJmBiOfKiBeC_xHqqkZx_
		m_fliSearchTotal += (fliStartSessionIndex - fliSuperSessionIndex);
	}
	if (bIsSearchBelow)
	//----- _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
		FCDbReadLock autoLockTerminateRead(m_searchProject.GetFilePathH(), lDocId, FDHI_TERMINATE_TABLE_ID);
		if (!autoLockTerminateRead.TryLock())
		//----- _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCkKiDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFErrorBox(FFGetDDErrorMessage());
			return FALSE;
		}
		// _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCkJiCoHiPeJjCfLiDfKiDgCiDfGiDiHiDjDiCpAiOoGjDlOiBeC_xHqqkZx_
		FCHiTerminateTable cmdTerminate = m_searchProject.GetSubGroup(lDocId);
		const flint fliSessionIndexEnd = cmdTerminate.SeeEndSessionIndex();
		cmdTerminate.Clear();
		// _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
		autoLockTerminateRead.UnlockAll();
		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDgGiBfLiDfOiDfKiDgCiDfGiDiHiDjDjAjEiBeC_xHqqkZx_(_xZkqqHx_iPeJjCfLiImKjChF_xHqqkZx_ - _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChF_xHqqkZx_)_xZkqqHx_iCpAiJmBiOfKiBeC_xHqqkZx_
		m_fliSearchTotal += (fliSessionIndexEnd - fliStartSessionIndex);
	}

	// _xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiBeCiDhGiDiNiDfHiDeGiDeOiDgHiCkKiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiClNiCnPiBeB_xHqqkZx_
	// _xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCmJjHjKjHpAjFkKiKpCiCmMiPeDjAlDiCkKjDpMiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
	autoLockForkRead.UnlockAll();

	FCForkConstIterator iFork;
	if (bIsSearchAboveBranch)
	//----- _xZkqqHx_jBePjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		for (iFork = forkFile.GetFirstFork();
			 !iFork.IsEnd() && iFork.GetSessionIndex() < fliStartSessionIndex;
			 iFork++)
		{
			// _xZkqqHx_iJlMjHjKjHpAjFkKiKpCiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (iFork.GetIsTemporary()) continue;
			// _xZkqqHx_jFkKiKpCiPoOjFpBiBeCiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_->_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			m_mpSearchDocIdToFork[lDocId].m_mmpSessionToDocId.insert(
						pair<flint, long>(	iFork.GetSessionIndex(),
											iFork.GetDocumentId()));
		}
	}
	if (bIsSearchBelowBranch)
	//----- _xZkqqHx_iMoDjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		for (iFork = forkFile.GetLowerBoundFork(fliStartSessionIndex);
			 !iFork.IsEnd();
			 iFork++)
		{
			// _xZkqqHx_iJlMjHjKjHpAjFkKiKpCiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (iFork.GetIsTemporary()) continue;
			// _xZkqqHx_jFkKiKpCiPoOjFpBiBeCiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_->_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			m_mpSearchDocIdToFork[lDocId].m_mmpSessionToDocId.insert(
						pair<flint, long>(	iFork.GetSessionIndex(),
											iFork.GetDocumentId()));
		}
	}
	multimap<flint, long>::const_iterator iStd;
	for (iStd = m_mpSearchDocIdToFork[lDocId].m_mmpSessionToDocId.begin();
		 iStd != m_mpSearchDocIdToFork[lDocId].m_mmpSessionToDocId.end(); iStd++)
	{
		// _xZkqqHx_iClBiCmMjHjKjHpAjFlGiPjBiCpAiMjPiNpFiClHiCoJiCmMiCmJjCeIiCmBiClNjBePiCmMjFlGiPjBiCmIiCoHiCmOiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		if ((*iStd).second == lSearchFromDocId) continue;
		// _xZkqqHx_iClBiCmMjHjKjHpAiCkJiCoHjFkKiKpCiClHiCoJjHjKjHpAiCpAjClCiNlIiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jFkKiKpCiOhNiCmIiCmMiCmFiBeBiDgHiDgCiDhGiCkJiCoHiMoDjFpLiCnGjClCiNlIiClHiCoKiCmOjHmHiCkCiBeC_xHqqkZx_
		flint fliStartSessionTmp = (*iStd).first;
		if (!GetSearchAreaForkBranch(	(*iStd).second,
										fliStartSessionTmp,
										lDocId,
										FALSE,	// _xZkqqHx_jBePjFpLiCpAiMjPiNpFiBeI_xHqqkZx_
										FALSE,	// _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiBeI_xHqqkZx_
										FALSE,	// _xZkqqHx_jBePjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiBeI_xHqqkZx_
										TRUE,	// _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiBeI_xHqqkZx_
										TRUE))	// _xZkqqHx_iMoDjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiBeI_xHqqkZx_
			return FALSE;
	}

	if (lSuperDocId != -1 && bIsSearchSuper)
	//----- _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiBeC_xHqqkZx_
		return GetSearchAreaForkBranch(	lSuperDocId,
										fliSuperSessionIndex,
										lDocId,
										bIsSearchAbove,
										bIsSearchSuper,
										bIsSearchAboveBranch,
										bIsSearchAboveBranch,
										bIsSearchAboveBranch);
	}
	return TRUE;
} // FCHistoryFind::GetSearchAreaForkBranch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::DocumentIdToForkData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLeMjIfOiClDiCoKiCmEiCkCiCoJiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiIoKjHjHiCmMiPoOjFpBiCkJiCoHiBeBiDhEiDeIiBfLiDeOiPoOjFpBiCpA_xHqqkZx_
 *			_xZkqqHx_iOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDeOiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindForkData* FCHistoryFind::DocumentIdToForkData (long lDocId)
{
	map<long, FCFindForkData>::iterator i = m_mpSearchDocIdToFork.find(lDocId);
	if (i != m_mpSearchDocIdToFork.end())
		return &(*i).second;
	else
		return NULL;
} // FCHistoryFind::DocumentIdToForkData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::CheckUpdateProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiPeDjAlDiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeBiPeDjAlDjBePiCmJjCiKiPgPiClDiCoKiClNjDoAjHgFiCkK_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjCiGiCmJiOgDiCmBiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iOgDiCmBiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeBiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *			reqLock.m_autoLockProjectRead _xZkqqHx_iCmNiBeBiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	reqLock	:_xZkqqHx_iDiNiDgCiDeOjHhAjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiNfIjAfGiClDiCoKiBeBiLeMjIfOiCkKiOgDiCmBiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHistoryFind::CheckUpdateProject (FCReqLock& reqLock)
{
	if (m_searchProject.IsRealTableRecordModified() ||
		m_searchProject.IsVirtualTableRecordModified())
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJiPeDjAlDiCkKjDpMiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		m_searchProject.UpdateData(reqLock.m_autoLockProjectRead);
		map<long, FCFindForkData>::const_iterator i;
		for (i = m_mpSearchDocIdToFork.begin(); i != m_mpSearchDocIdToFork.end(); i++)
		{
			FCHiDocumentRec hiDocRec = m_searchProject.GetDocumentRec((*i).first);
			if (hiDocRec.GetIsInvalid())
			//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiNoNiPjMiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
				FFErrorBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
				return FALSE;
			}
			if ((*i).second.m_wstrTitle != hiDocRec.GetDocTitle() ||
				(*i).second.m_wstrComment != hiDocRec.GetComment() ||
				(*i).second.m_fdstCreateTime != hiDocRec.GetDate() ||
				(*i).second.m_guidUserId != hiDocRec.GetUserId() ||
				(*i).second.m_lSuperDocumentId != hiDocRec.GetSuperDocId())
			//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDfOiDeDiDgHiDiLiBeBjHjKjHpAjFlGiPjBiCmMiDfCiDiBiDjDiDgHiBeBjHjKjHpAjFlGiPjBiNoMjAkMiOjOiKnEiBeBiPoDiImKjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
				FFErrorBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
				return FALSE;
			}
		}
	}
	return TRUE;
} // FCHistoryFind::CheckUpdateProject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::CheckUpdateFork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiMjPiNpFiCmNiBeBiCnMiClIiMjPiNpFjEmNiImNiClHiCnHiCmEiCmMiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCpAjDmHiCnNiPgPiClFiCmE_xHqqkZx_
 *			m_mpSearchDocIdToFork_xZkqqHx_jFmPjAjEiCmJiLeMjIfOiClFiClNiMoDiBeBiMjPiNpFiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClFiCkJiClFiBeBjHjKjHpAiMjPiNpFiCmJiCmNjClHiCkNiOjOiKnEiCkKiCkJiCkJiCoJiClNiCnPiBeBiMjPiNpFjCiGiCmJjBlMiCmMiDeBiDhGiDiKiCmJ_xHqqkZx_
 *			_xZkqqHx_iCoGiCmBiCmEiMjPiNpFjEmNiImNiCmMiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCkKiNfIjAfGiClDiCoKiCoJiPoKiNiHiCoAiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiCmMiNiHiKnEiCmJiClBiCmMiKnGjAjEiCpAiMmEiCnBiPgPiClHiClBiCmGiCmFiBeBiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCmMjDoAjHgFiCkK_xHqqkZx_
 *			m_mpSearchDocIdToFork_xZkqqHx_jFmPjAjEiCmMjDoAjHgFiCmGjAeIiCkCiIoBiCmBiCmEiCkCiCmIiCkCiCkJiMjPiNlIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCnMiClNiBeBjBlMiCmMiDeBiDhGiDiKiCmJiCoGiCoJiJpAjFpKjHhGiLiBiCpAiOpDiCkPjFhEiCkPiCmEiBeBiDeMiDiDiDgCiDfGiDiFiDiNiDgCiDeO_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiIoKiOjOjDeJiCmJiJpAjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	reqLock		:_xZkqqHx_iDiNiDgCiDeOjFmPjAjEiCpAiOhHjCoIiBeCiDhGiDiNiDfHiDeGiDeOiDgHiBeBiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiBeB_xHqqkZx_
 *						 _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCkK_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			lDocId		:_xZkqqHx_iMjPiNlIjBmOiPnLiCmMjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pCmdGate	:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			cmdTerminate:_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	Failed			:_xZkqqHx_iDgAiDeGiDgCiDeOiCmJiOlIjEhDiClFiClNiPoKiNiHiBeBiIlNiCkCiCmNiMjPiNpFjBmOiPnLiCmM_xHqqkZx_
 *							 _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiNoNiPjMiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
 *			Overwrited		:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiBeBiIlNiCkCiCmNiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkK_xHqqkZx_
 *							 _xZkqqHx_iPoDiPjBiCkLiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
 *			UndoOrAppended	:_xZkqqHx_iDfCiDhNiDjDiDgIiCkKiChEiCiOiCiEiCiPiIlNiCkCiCmNjCmHiJmBiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
 *			NotChanged		:_xZkqqHx_iJlNiCoAjFmPiNfIiCkKjGlDiCkCiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBlMiCmMiDeBiDhGiDiKiCmMiDiNiDgCiDeOiCmJiCoGiCoJiBeBiJpAjFpKjHhGiLiBiCpAiMjPiNlIiClFiBeBiJpAjFpKjHhGiLiBiCkKjDmNiCkCiCmE_xHqqkZx_
 *			_xZkqqHx_iCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAjAjEjFgCiKnEiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiMoDiBeBiNmEiCnBiDiNiDgCiDeOiClFiCmIiCkIiClFiCmEiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCmMiNfIjAfGiCpAjClCiNlIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iOjPiCmJiBeBiOhHjCoIiClDiCoKiClNjFlGiPjBiCmMiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCmMiNfIjAfGiCpAjClCiCnHiBeBiNfIjAfGiClDiCoKiCmE_xHqqkZx_
 *			_xZkqqHx_iCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_m_mpSearchDocIdToFork_xZkqqHx_jFmPjAjEiCmJiLeMjIfOiClDiCoKiClNiPoOjFpBiCkK_xHqqkZx_
 *			_xZkqqHx_iNfIjAfGiMoDiCmMiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCmJiOgDiCmBiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCmEiCoAiBeB_xHqqkZx_m_mpSearchDocIdToFork_xZkqqHx_jFmPjAjEiCmJ_xHqqkZx_
 *			_xZkqqHx_iLeMjIfOiClDiCoKiClNiPoOjFpBiCkKiOgDiCmBiCmEiCkCiCoJiCmMiCmIiCoHiMjPiNpFiCmJiOhIiPoBiCmNjGlDiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.02 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHistoryFind::FindObjectResult FCHistoryFind::CheckUpdateFork (
										FCReqLock& reqLock,
										long lDocId,
										FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										FCHiTerminateTable& cmdTerminate)
{
//----- 05.11.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	longSet stFileAtom;
//	if (g_pFileServer->GetUnlockRequestFileAtom(stFileAtom))
//	{
//		DWORD dwLockType = FCReqLock::PROJECT_READ|FCReqLock::FORK_READ|FCReqLock::TERMINATE_READ;
//		// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiBeC_xHqqkZx_
//		if (pCmdGate != NULL)
//			dwLockType |= FCReqLock::COMMAND_READ;
//		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiBeC_xHqqkZx_
//		if (pHistoryIndex != NULL)
//			dwLockType |= FCReqLock::SUMMARY_READ;
//		WString wstrErrMessage;
//		long lC;
//		for (lC = 0; lC < 10; lC++)
//		{
//			// READ_xZkqqHx_iDiNiDgCiDeOiDeMiBfLiDhGiClDiCoKiClNiDhEiDeAiDeDiDiLiCmMiDeMiBfLiDhGiCpAjBfDiCmEiJpAiPjMiClHiCoJiBeC_xHqqkZx_
//			g_pFileServer->UnkeepAllReadLockForCache();
//			reqLock.Unlock(dwLockType);
//			// 4 * 0.5 = 2_xZkqqHx_jFgCiCnJiCmHiDeDiDjDiDfOiBfLiDgPiDiLiCpAiCmGiCoJiBeC_xHqqkZx_
//			for (long lSleep = 0; lSleep < 4; lSleep++)
//			{
//				// WM_PAINT _xZkqqHx_iCpAiDgGiDeCiDfIiDhAiDgCiDgAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
//				m_pDlgProgressBar->DispatchRedraw();
//				// 0.5_xZkqqHx_jFgCiCnJiCmHiDeDiDjDiDfOiBfLiDgPiDiLiBeC_xHqqkZx_
//				Sleep(500);
//			}
//			// _xZkqqHx_iNmEiCnBiDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
//			if (reqLock.TryLock(&wstrErrMessage, dwLockType)) break;
//		}
//		if (lC == 10)
//		{
//			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
//			FFErrorBox(FFGetDDErrorMessage());
//			return Failed;
//
//		}
//	}
//----- 05.11.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (g_pFileServer->UnkeepIfUnlockRequest())
	//----- _xZkqqHx_iJpAjFpKjHhGiLiBiCmJiCoGiCmBiCmEiDeMiBfLiDhGiJpAiPjMiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		DWORD dwLockType = FCReqLock::PROJECT_READ|FCReqLock::FORK_READ|FCReqLock::TERMINATE_READ;
		// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiBeC_xHqqkZx_
		if (pCmdGate != NULL)
			dwLockType |= FCReqLock::COMMAND_READ;
		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiBeC_xHqqkZx_
		if (pHistoryIndex != NULL)
			dwLockType |= FCReqLock::SUMMARY_READ;
		long lC;
		for (lC = 0; lC < 20; lC++)
		{
			// _xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
			reqLock.Unlock(dwLockType);
			// WM_PAINT _xZkqqHx_iCpAiDgGiDeCiDfIiDhAiDgCiDgAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
			if (m_pDlgProgressBar->DispatchRedraw() == CFCDlgProgressBar::STOP)
				return Failed;
			// 1_xZkqqHx_jFgCiCnJiCmHiDeDiDjDiDfOiBfLiDgPiDiLiBeC_xHqqkZx_
			Sleep(1000);
			// _xZkqqHx_iNmEiCnBiDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
			if (reqLock.TryLock(dwLockType)) break;
		}
		if (lC == 20)
		{
			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFErrorBox(FFGetDDErrorMessage());
			return Failed;

		}
	}
//----- 05.11.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJiPeDjAlDiCkKjDpMiCmBiClNiPoKiNiHiCpAiMjPiNlIiBeC_xHqqkZx_
	if (!CheckUpdateProject(reqLock)) return Failed;

	FCFindForkData* pForkData = DocumentIdToForkData(lDocId);

	if (pForkData->m_dwLockDeleteIdentifier != reqLock.m_autoLockForkRead.GetLockDeleteIdentifier() ||
		pForkData->m_dwLockAppendIdentifier != reqLock.m_autoLockForkRead.GetLockAppendIdentifier())
	//----- _xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCmJiPeDjAlDiCkKjDpMiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeDjAlDiCkKjDpMiCmBiCmEiCkCiCmEiCoAiBeBiPeDjAlDjBePiCmJjCiKiPgPiClDiCoKiCmEiCkCiClN_xHqqkZx_ _xZkqqHx_jFkKiKpCiPoOjFpBiCkK_xHqqkZx_
		// _xZkqqHx_iPeDjAlDiMoDiCoAiOgDiCmBiCmEiCkCiCoKiCmOiBeBiMjPiNpFiCpAjBlBiNhDiClFiCmEjGoCjBoIiCmIiCkCiBeC_xHqqkZx_

		// _xZkqqHx_iPeDjAlDiMoDiCmMiDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiCkJiCoHiDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		FCHiForkTable forkFile(&m_searchProject, lDocId, &reqLock.m_autoLockForkRead);
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FCHiForkTable forkFile = m_searchProject.GetSubGroup(lDocId);
		forkFile.UpdateData(reqLock.m_autoLockForkRead);
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

		// _xZkqqHx_iPeDjAlDiMoDiCmMiBeBjFlGiPjB_xHqqkZx_ID->_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_ _xZkqqHx_iCmMiDgOiDgCiDfGiDiFiCpAiNoMjAkMiBeC_xHqqkZx_
		map<long, flint> mpDocIdToSessionIdx;
		FCForkConstIterator iFork;
		for (iFork = forkFile.GetFirstFork(); !iFork.IsEnd(); iFork++)
			mpDocIdToSessionIdx[iFork.GetDocumentId()] = iFork.GetSessionIndex();
		multimap<flint, long>::const_iterator iStd;
		for (iStd = pForkData->m_mmpSessionToDocId.begin();
			 iStd != pForkData->m_mmpSessionToDocId.end(); iStd++)
		//----- _xZkqqHx_iPeDjAlDjBePiCmMiBeBiDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_jFlGiPjB_xHqqkZx_ID _xZkqqHx_iPoOjFpBiCpAiDiLiBfLiDhG_xHqqkZx_ -----
		{
			// _xZkqqHx_iPeDjAlDjBePiCmMjFkKiKpCjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCkKiBeBiPeDjAlDiMoDiCmMjFkKiKpCiPoOjFpBiCkKjDgPjIfOiClDiCoKiCmEiCkCiCoJiCkJiMjPiNpFiBeC_xHqqkZx_
			map<long, flint>::const_iterator iIts;
			iIts = mpDocIdToSessionIdx.find((*iStd).second);
			if (iIts == mpDocIdToSessionIdx.end())
			//----- _xZkqqHx_iPeDjAlDjBePiCmMjFkKiKpCjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCkKiBeBiPeDjAlDiMoDiCmMjFkKiKpCiPoOjFpBiCmJjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
				FFErrorBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
				return Failed;
			}
			if ((*iIts).second != (*iStd).first)
			//----- _xZkqqHx_iPeDjAlDjBePiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCmGiBeBiPeDjAlDiMoDiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
				FFErrorBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
				return Failed;
			}
		}

//----- 05.11.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDiKiDfIiDgH_xHqqkZx_ _xZkqqHx_iCpAjEoEiKhC_xHqqkZx_ -----
		FCIdxToTimeLabelInfoMmap::const_iterator iTml;
		for (iTml = pForkData->m_mmpTimeLabelList.begin();
			 iTml != pForkData->m_mmpTimeLabelList.end(); iTml++)
		{
			// _xZkqqHx_iLeMjIfOiClDiCoKiCmEiCkCiCoJiOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCkJiCoHiBeBjAfGiClFiCkCiOjOiKnEiDiJiDhIiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
			FCTimeLabelConstIterator iTimeLabel = forkFile.FindTimeLabelById((*iTml).second.m_lTimeLabelId);
			if (iTimeLabel.IsEnd())
			//----- _xZkqqHx_jAfGiClFiCkCiOjOiKnEiDiJiDhIiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
				FFErrorBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
				return Failed;
			}
			// _xZkqqHx_iLeMjIfOiClDiCoKiCmEiCkCiCoJiPoOjFpBiCmGjAfGiClFiCkCiPoOjFpBiCpAjEoEiKhCiBeC_xHqqkZx_
			// _xZkqqHx_iDiJiDhIiDiLiCmMiNmAjFfHiCmIiCmHiCmNiMjPiNpFiCmJiKnGiMfHiClFiCmIiCkCiCmMiCmFiBeBjFmPiJlLiClFiCmEiCkCiCmEiCoAjGoCjBoIiCmIiCkCiBeC_xHqqkZx_
			if (iTimeLabel.GetSessionIndex() != (*iTml).first ||
				iTimeLabel.GetCreateTime() != (*iTml).second.m_fdstCreateTime ||
				iTimeLabel.GetUserId() != (*iTml).second.m_guidUserId ||
				iTimeLabel.GetLabelText() != (*iTml).second.m_wstrLabel)
			{
				// _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
				FFErrorBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
				return Failed;
			}
		}

		//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiKiDfIiDgH_xHqqkZx_ _xZkqqHx_iCpAjEoEiKhC_xHqqkZx_ -----
		FCIdxToHiForkTagInfoMap::const_iterator iHtg;
		for (iHtg = pForkData->m_mpHiForkTagList.begin();
			 iHtg != pForkData->m_mpHiForkTagList.end(); iHtg++)
		{
			// _xZkqqHx_iLeMjIfOiClDiCoKiCmEiCkCiCoJjHjKjHpAjFkKiKpCiDfOiDePiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCkJiCoHiBeBjAfGiClFiCkCjHjKjHpAjFkKiKpCiDfOiDePiCpAiOoGjDlOiBeC_xHqqkZx_
			FDSECTIME fdstCreateTime;
			GUID guidUserId;
			WString wstrTitle;
			WString wstrComment;
			BOOL bIsThereHiForkTag = forkFile.IsThereHiForkTag(	(*iHtg).first,
																&fdstCreateTime,
																NULL,
																&guidUserId,
																&wstrTitle,
																&wstrComment);
			if (!bIsThereHiForkTag)
			//----- _xZkqqHx_jAfGiClFiCkCjHjKjHpAjFkKiKpCiDfOiDePiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
				FFErrorBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
				return Failed;
			}
			// _xZkqqHx_iLeMjIfOiClDiCoKiCmEiCkCiCoJiPoOjFpBiCmGjAfGiClFiCkCiPoOjFpBiCpAjEoEiKhCiBeC_xHqqkZx_
			// _xZkqqHx_iDfIiDfCiDeBiCmNiMjPiNpFiCmJiKnGiMfHiClFiCmIiCkCiCmMiCmFiBeBjFmPiJlLiClFiCmEiCkCiCmEiCoAjGoCjBoIiCmIiCkCiBeC_xHqqkZx_
			if (fdstCreateTime != (*iHtg).second.m_fdstCreateTime ||
				guidUserId != (*iHtg).second.m_guidUserId ||
				wstrTitle != (*iHtg).second.m_wstrTitle ||
				wstrComment != (*iHtg).second.m_wstrComment)
			{
				// _xZkqqHx_jHjKjHpAjFlGiPjBiCmNiNoMiLmGjCiGiCmJjBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiCoGiCmBiCmEiNfIjAfGiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
				FFErrorBox(IDS_ERR_MSG_HIDOC_IS_MODIFIED);
				return Failed;
			}
		}
//----- 05.11.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

		// _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCpAiNmFjAfGiCmJiBeC_xHqqkZx_
		pForkData->m_dwLockDeleteIdentifier = reqLock.m_autoLockForkRead.GetLockDeleteIdentifier();
		pForkData->m_dwLockAppendIdentifier = reqLock.m_autoLockForkRead.GetLockAppendIdentifier();
	}

//----- 06.02.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if ((pCmdGate != NULL && pCmdGate->IsVirtualTableRecordOverwrited()) ||
//		(pHistoryIndex != NULL && pHistoryIndex->IsVirtualTableRecordOverwrited()))
//	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiBeBiIlNiCkCiCmNiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNmEjDhIjDmHiCnNjClMiClHiBeC_xHqqkZx_
//		if (pCmdGate != NULL)
//			pCmdGate->ReOpen();
//		if (pHistoryIndex != NULL)
//			pHistoryIndex->ReOpen();
//		cmdTerminate.ReOpen();
//		return Overwrited;
//	}
//----- 06.02.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCkKiPoDiPjBiCkLiBgJ_xHqqkZx_Undo_xZkqqHx_iClFiCmEiCkJiCoHjBiAiNoMiBgKiClDiCoKiClNiCkJiBeI_xHqqkZx_
	BOOL bIsCmdOverwrited = FALSE;
	if (pCmdGate != NULL)
	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiCkKiMjPiNpFjBmOiPnLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		 if (pCmdGate->IsRealTableReplaced() ||
			 pCmdGate->IsRealTableRecordDeleted() ||
			 pCmdGate->IsVirtualTableRecordOverwrited())
			bIsCmdOverwrited = TRUE;
	}
	if (pHistoryIndex != NULL)
	//----- _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCkKiMjPiNpFjBmOiPnLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		 if (pHistoryIndex->IsRealTableReplaced() ||
			 pHistoryIndex->IsRealTableRecordDeleted() ||
			 pHistoryIndex->IsVirtualTableRecordOverwrited())
			bIsCmdOverwrited = TRUE;
	}
	if (bIsCmdOverwrited)
	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiBeBiIlNiCkCiCmNiDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCkKiPoDiPjBiCkLiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNmEjDhIjDmHiCnNjClMiClHiBeC_xHqqkZx_
		if (pCmdGate != NULL)
			pCmdGate->UpdateData(reqLock.m_autoLockCommandRead);
		if (pHistoryIndex != NULL)
			pHistoryIndex->UpdateData(reqLock.m_autoLockSummaryRead);
		cmdTerminate.UpdateData(reqLock.m_autoLockTerminateRead);
		return Overwrited;
	}
//----- 06.02.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	if (cmdTerminate.IsRealTableRecordModified() ||
		cmdTerminate.IsVirtualTableRecordModified())
	//----- _xZkqqHx_iPeJjCfLiImKjChFiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// bIsCmdOverwrited = FALSE _xZkqqHx_iCmIiCmMiCmFiBeBiDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiBeB_xHqqkZx_
		// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmGiCoAiCmJiBeBjGkCiPeDjAlDiIlNiCkCiCmNjCmHiJmBiPeDjAlDiBeCiCoGiCmBiCmE_xHqqkZx_
		// UpdateRecordModified() _xZkqqHx_iCmFjHmHiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNmEjDhIjDmHiCnNjClMiClHiBeC_xHqqkZx_
		if (pCmdGate != NULL)
			pCmdGate->UpdateRecordModified();;
		if (pHistoryIndex != NULL)
			pHistoryIndex->UpdateRecordModified();;
		cmdTerminate.UpdateData(reqLock.m_autoLockTerminateRead);
		return UndoOrAppended;
	}

	return NotChanged;
} // FCHistoryFind::CheckUpdateFork.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::ShowProgressBar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiKnGjAjEiImIiNhOiBeBiDhGiDiNiDePiDiMiDfIiDgPiBfLiCmJjAgJjClLiCkKjCmKjCgNiClDiCoKiBeB_xHqqkZx_
 *			_xZkqqHx_jFfMiOkGiCkKiNfIjAfGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::ShowProgressBar ()
{
	if (m_pDlgProgressBar != NULL) FFThrowMiscUnknown();
	// _xZkqqHx_iMjPiNpFjAgJjClLiCmMiDgGiBfLiDfOiDfKiDgCiDfGiDiHiDjDjAjEiBeC_xHqqkZx_
	m_fliSearchProgress = 0;
	m_pDlgProgressBar = new CFCDlgProgressBar();
	m_pDlgProgressBar->Create(CFCDlgProgressBar::IDD, FFGetMainWnd()->GetWnd());
	// _xZkqqHx_iNmEjFfMiOkGiDeDiDhIiDjDiDgHiCpAiJpBiClHiClNiCnPiBeB_xHqqkZx_SetProgressValue_xZkqqHx_iCpAiMmEiCnEiBeC_xHqqkZx_
	m_pDlgProgressBar->SetProgressValue(0.0);
	// _xZkqqHx_iPoDiLeMiCmM_xHqqkZx_Create_xZkqqHx_iCmFiDhEiDeIiBfLiDeKiDfIiCkKiDfPiDeDiDeBiDiNiDePiCmJiInKiNhDiClFiCmEiClFiCnMiCkEiClNiCnPiBeBiDhEiDiMiBfLiDiAiCmJjGnPiClHiBeC_xHqqkZx_
	FFGetMainWnd()->GetWnd()->SetFocus();
} // FCHistoryFind::ShowProgressBar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHistoryFind::HideProgressBar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCpAjEpBjFfMiOkGiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiCpAjEpBjFfMiOkGiCmJiClFiCmEiBeBiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHistoryFind::HideProgressBar ()
{
	if (m_pDlgProgressBar == NULL) FFThrowMiscUnknown();
	m_pDlgProgressBar->DestroyWindow();
	delete m_pDlgProgressBar;
	m_pDlgProgressBar = NULL;
} // FCHistoryFind::HideProgressBar.

