#ifndef __HistoryFind_h
#define __HistoryFind_h

#include "HiProject.h"		// For FCHiProject.
#include "HiForkTable.h"	// For FCIdxToTimeLabelInfoMmap,etc.

// _xZkqqHx_iNmFjBoFiCmMiDiMiDfCiBfLiDgIjAjEiBeC_xHqqkZx_
#define FDHF_MAX_REC	10000

class FCFindForkData;
// 06.02.21 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//class FCSearchParser;
class FCHiProject;
class FCHiCommandTable;
class FCHiSummaryTable;
// 06.02.21 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//class FCHiForkTable;
class FCHiTerminateTable;
struct FCReqLock;
class CFCDlgProgressBar;
// 06.02.21 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//class FCSearchParser;
// 06.02.21 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//struct FCLinkMolipInfo;
// 06.02.21 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//enum FTGateCmd;

typedef map<DWORD, WString> ObjIdToWStringMap;

enum FTHFRecType
{
	FDHF_NONE = -1,			// _xZkqqHx_iCmIiClFiBeC_xHqqkZx_
	FDHF_OBJ_MODIFY = 0,	// _xZkqqHx_jFjEjFgJiMjPiNpFiBeC_xHqqkZx_
	FDHF_TEXT_MODIFY,		// _xZkqqHx_iDgFiDeMiDfIiDgHiMjPiNpFiBeC_xHqqkZx_
	FDHF_CHAR_MODIFY,		// _xZkqqHx_jFlGiOjKjFmPiNfIiMjPiNpFiBeC_xHqqkZx_
	FDHF_LINK_MODIFY,		// _xZkqqHx_iDiKiDjDiDeOiMjPiNpFiBeC_xHqqkZx_
	FDHF_LABEL_BEGIN,		// _xZkqqHx_iDiJiDhIiDiLiKeKiOgOiMjPiNpFiBeC_xHqqkZx_
	FDHF_LABEL_END,			// _xZkqqHx_iDiJiDhIiDiLiPeJjHlJiMjPiNpFiBeC_xHqqkZx_
	FDHF_TIME_LABEL,		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiMjPiNpFiBeC_xHqqkZx_
	FDHF_HISTORY_DOC,		// _xZkqqHx_jFlGiPjBiMjPiNpFiBeC_xHqqkZx_
	FDHF_HI_FORK_TAG,		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiMjPiNpFiBeC_xHqqkZx_
	FDHF_TIME_SIGNAL,		// _xZkqqHx_jDpKiOjOiMjPiNpFiBeC_xHqqkZx_
}; // enum FTHFRecType.

class FCHFRecord
{
public:
	FCHFRecord (FTHFRecType recType = FDHF_NONE,
				WORD atmProjPath = WORD(-1),
				WORD atmProjTitle = WORD(-1),
				long lDocId = -1,
				WORD atmHidocument = WORD(-1),
				WORD atmHistVer = WORD(-1),
				flint fliSessionIndex = -1,
				FDSECTIME fdstDate = FDSECTIME(-1),
				WORD atmContent = WORD(-1),
				long lId = -1,
				WORD atmUserInfo = WORD(-1))
			{
				m_recType		= recType;
				m_atmProjPath	= atmProjPath;
				m_atmProjTitle	= atmProjTitle;
				m_lDocId		= lDocId;
				m_atmHidocument	= atmHidocument;
				m_atmHistVer	= atmHistVer;
				m_fliSessionIndex = fliSessionIndex;
				m_fdstDate		= fdstDate;
				m_atmContent	= atmContent;
				m_lId			= lId;
				m_atmUserInfo	= atmUserInfo;
			}
	BOOL operator == (const FCHFRecord& rec) const
			{
				return	m_recType		== rec.m_recType &&
						m_atmProjPath	== rec.m_atmProjPath &&
						m_atmProjTitle	== rec.m_atmProjTitle &&
						m_lDocId		== rec.m_lDocId &&
						m_atmHidocument	== rec.m_atmHidocument &&
						m_atmHistVer	== rec.m_atmHistVer &&
						m_fliSessionIndex == rec.m_fliSessionIndex &&
						m_fdstDate		== rec.m_fdstDate &&
						m_atmContent	== rec.m_atmContent &&
						m_lId			== rec.m_lId &&
						m_atmUserInfo	== rec.m_atmUserInfo;
			}

public:
	FTHFRecType	m_recType;			// _xZkqqHx_iDhNiBfLiDeOiOoNjHnOiBeC_xHqqkZx_
	WORD		m_atmProjPath;		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiBeC_xHqqkZx_
	WORD		m_atmProjTitle;		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
	long		m_lDocId;			// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	WORD		m_atmHidocument;	// _xZkqqHx_jHjKjHpAjFlGiPjBiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
	WORD		m_atmHistVer;		// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	flint		m_fliSessionIndex;	// _xZkqqHx_iDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
	FDSECTIME	m_fdstDate;			// _xZkqqHx_jDpKiOjOiBeC_xHqqkZx_
	WORD		m_atmContent;		// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
	long		m_lId;				// ID_xZkqqHx_iBeC_xHqqkZx_
	WORD		m_atmUserInfo;		// _xZkqqHx_iDiGiBfLiDfFiPoOjFpBiBeC_xHqqkZx_
}; // class FCHFRecord.

typedef vector<FCHFRecord>	FCHFRecordVector;

class FCFindBaseInfo;
typedef auto_ptr<FCFindBaseInfo>	FCFindBaseInfoAuto;

class FCFindForkData
{
public:
	WString						m_wstrTitle;				// _xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
	WString						m_wstrComment;				// _xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
	FDSECTIME					m_fdstCreateTime;			// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMiOjOiKnEiBeC_xHqqkZx_
	GUID						m_guidUserId;				// _xZkqqHx_jHjKjHpAjFlGiPjBiCmMiNoMjAkMiOnCiBeC_xHqqkZx_
	long						m_lSuperDocumentId;			// _xZkqqHx_iPoDiImKjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	flint						m_fliSuperSessionIndex;		// _xZkqqHx_iPoDiImKjFlGiPjBiCmJiCkIiCkPiCoJiBeBjFkKiKpCiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	multimap<flint, long>		m_mmpSessionToDocId;		// _xZkqqHx_jFkKiKpCiPoOjFpBiBeCiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_->_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	FCIdxToTimeLabelInfoMmap	m_mmpTimeLabelList;			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDiKiDfIiDgHiBeC_xHqqkZx_
	FCIdxToHiForkTagInfoMap		m_mpHiForkTagList;			// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiKiDfIiDgHiBeC_xHqqkZx_
	DWORD						m_dwLockDeleteIdentifier;	// _xZkqqHx_iDgGiBfLiDfOiPeDjAlDiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
	DWORD						m_dwLockAppendIdentifier;	// _xZkqqHx_iDgGiBfLiDfOjCmHiJmBiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
}; // class FCFindForkData.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCHistoryFind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiCmMiMjPiNpFiCpAiNhDiCkEiDeOiDiJiDfIiBeC_xHqqkZx_HistoryViewer_xZkqqHx_iCmFiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCHistoryFind
{
public:
	FCHistoryFind ();
	~FCHistoryFind ();
	void	ClearAll ();
	void	ClearRecord ();

	void	FindObject (const HString& hstrProjectPath,
						const ObjDynabaseVector& vObj,
						const ObjIdToWStringMap& mpLabelIdToString,
						const wchar_t* wcpKeyword,
						BOOL bMultiWord,
						BOOL bRegexp,
						BOOL bAsUppercase,
						FDSECTIME fdstFrom,
						FDSECTIME fdstUntil,
						const set<GUID>& stLimitUserId,
						BOOL bSearchAbove,
						BOOL bSearchSuper,
						BOOL bSearchAboveBranch,
						BOOL bSearchBelow,
						BOOL bSearchBelowBranch,
						long lStartDocId,
						flint fliStartSessionIndex,
						BOOL bFindCreateObject,
						BOOL bFindDeleteObject,
						BOOL bFindModifyObject,
						BOOL bFindModifyText);

	void	FindLink (	const HString& hstrProjectPath,
						const ObjDynabaseVector& vObj,
						const ObjIdToWStringMap& mpLabelIdToString,
						const wchar_t* wcpKeyword,
						BOOL bMultiWord,
						BOOL bRegexp,
						BOOL bAsUppercase,
						FDSECTIME fdstFrom,
						FDSECTIME fdstUntil,
						const set<GUID>& stLimitUserId,
						BOOL bSearchAbove,
						BOOL bSearchSuper,
						BOOL bSearchAboveBranch,
						BOOL bSearchBelow,
						BOOL bSearchBelowBranch,
						long lStartDocId,
						flint fliStartSessionIndex,
						BOOL bFindCreateLink,
						BOOL bFindDeleteLink,
						BOOL bFindCreateInterLink,
						BOOL bFindDeleteInterLink);

	void	FindLabel (	const HString& hstrProjectPath,
						FDSECTIME fdstFrom,
						FDSECTIME fdstUntil,
						const set<GUID>& stLimitUserId,
						BOOL bSearchAllDocument,
						BOOL bSearchAbove,
						BOOL bSearchSuper,
						BOOL bSearchAboveBranch,
						BOOL bSearchBelow,
						BOOL bSearchBelowBranch,
						long lStartDocId,
						flint fliStartSessionIndex,
						BOOL bFindCreateLabel,
						BOOL bFindDeleteLabel,
						BOOL bFindTimeLabel,
						const wchar_t* wcpKeyword,
						BOOL bMultiWord,
						BOOL bRegexp,
						BOOL bAsUppercase);

	void	FindDocument (	const HString& hstrProjectPath,
							FDSECTIME fdstFrom,
							FDSECTIME fdstUntil,
							const set<GUID>& stLimitUserId,
							BOOL bSearchAllDocument,
							BOOL bSearchAbove,
							BOOL bSearchSuper,
							BOOL bSearchAboveBranch,
							BOOL bSearchBelow,
							BOOL bSearchBelowBranch,
							long lStartDocId,
							flint fliStartSessionIndex,
							BOOL bFindDocument,
							BOOL bFindHiForkTag,
							BOOL bFindComment,
							const wchar_t* wcpKeyword,
							BOOL bMultiWord,
							BOOL bRegexp,
							BOOL bAsUppercase);

	void	FindDate (	const HString& hstrProjectPath,
						BOOL bIsRoughSearch,
						FDSECTIME fdstFrom,
						FDSECTIME fdstUntil,
						const set<GUID>& stLimitUserId,
						BOOL bSearchAllDocument,
						BOOL bSearchAbove,
						BOOL bSearchSuper,
						BOOL bSearchAboveBranch,
						BOOL bSearchBelow,
						BOOL bSearchBelowBranch,
						long lStartDocId,
						flint fliStartSessionIndex,
						FDSECTIME fdstTargetTime);

	void	FindText (	const HString& hstrProjectPath,
						FDSECTIME fdstFrom,
						FDSECTIME fdstUntil,
						const set<GUID>& stLimitUserId,
						BOOL bSearchAllDocument,
						BOOL bSearchAbove,
						BOOL bSearchSuper,
						BOOL bSearchAboveBranch,
						BOOL bSearchBelow,
						BOOL bSearchBelowBranch,
						long lStartDocId,
						flint fliStartSessionIndex,
						BOOL bSearchBeginOfHit,
						BOOL bSearchEndOfHit,
						BOOL bSearchSelectedInside,
						const ObjDynabaseVector& vObj,
						const wchar_t* wcpKeyword,
						BOOL bMultiWord,
						BOOL bRegexp,
						BOOL bAsUppercase);

	void	FindChar (	const HString& hstrProjectPath,
						const map<DWORD, longRangeVector>& mpObjectIdToCharSelect,
						const ObjIdToWStringMap& mpLabelIdToString,
						const wchar_t* wcpKeyword,
						BOOL bMultiWord,
						BOOL bRegexp,
						BOOL bAsUppercase,
						FDSECTIME fdstFrom,
						FDSECTIME fdstUntil,
						const set<GUID>& stLimitUserId,
						BOOL bSearchAbove,
						BOOL bSearchSuper,
						BOOL bSearchAboveBranch,
						BOOL bSearchBelow,
						BOOL bSearchBelowBranch,
						long lStartDocId,
						flint fliStartSessionIndex,
						BOOL bIsFlatChar);

//----- 06.04.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	BOOL	MakeTimeIndex (	const HString& hstrProjectPath,
							FDSECTIME fdstFrom,
							FDSECTIME fdstUntil,
							const set<GUID>& stLimitUserId,
							BOOL bSearchAllDocument,
							long lStartDocId,
							const wchar_t* wcpWorkDirPath);
//----- 06.04.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----



	const wchar_t* AtomToStr (WORD wAtom) const;
	long	GetFindRecSize () const;
	const FCHFRecord&	GetFindRec (long lIdx) const;
	void	SortFindRec ();

	const WORDVector&	GetSortOrder () const;
	void	SetSortOrder (const WORDVector& vOrder);

protected:
	BOOL	FindBaseAll (	FCFindBaseInfo& findInfo,
							const HString& hstrProjectPath,
							FDSECTIME fdstFrom,
							FDSECTIME fdstUntil,
							const set<GUID>& stLimitUserId);

	BOOL	FindBaseOne (	FCFindBaseInfo& findInfo,
							const HString& hstrProjectPath,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
							const ObjIdToWStringMap& mpLabelIdToString,
							const wchar_t* wcpKeyword,
							BOOL bMultiWord,
							BOOL bRegexp,
							BOOL bAsUppercase,
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
							FDSECTIME fdstFrom,
							FDSECTIME fdstUntil,
							const set<GUID>& stLimitUserId,
							BOOL bSearchAbove,
							BOOL bSearchSuper,
							BOOL bSearchAboveBranch,
							BOOL bSearchBelow,
							BOOL bSearchBelowBranch,
							long lStartDocId,
							flint fliStartSessionIndex);

	WORD	StrToAtom (const wchar_t* wcpLabel);
	void	AppendFindRec (	FTHFRecType recType,
							const wchar_t* wcpProjPath,
							const wchar_t* wcpProjTitle,
							long lDocId,
							const wchar_t* wcpDocTitle,
							const wchar_t* wcpDocVersion,
							flint fliSessionIndex,
							FDSECTIME fdstDate,
							const GUID& guidUserId,
							const wchar_t* wcpContent,
							long lId);

	BOOL	FindSub (	FCFindBaseInfo& findInfo,
						long lFlowFromDocId);

	enum FindObjectResult
	{
		Failed,
		Overwrited,
		UndoOrAppended,
		NotChanged,
	};

	FindObjectResult	FindAboveSub (	FCFindBaseInfo* pFindInfo,
										long lFlowFromDocId,
										FCReqLock& reqLock,
										FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										FCHiTerminateTable& cmdTerminate,
										vector<FCFindBaseInfoAuto>& vFindObjInfo);

	FindObjectResult	FindBelowSub (	FCFindBaseInfo* pFindInfo,
										long lFlowFromDocId,
										FCReqLock& reqLock,
										FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										FCHiTerminateTable& cmdTerminate,
										vector<FCFindBaseInfoAuto>& vFindObjInfo);

	BOOL	GetSearchAreaAll (	map<long, flint>& mpTopDocToSession,
								const HString& hstrProjectPath);

	BOOL	GetSearchAreaFork (	const HString& hstrProjectPath,
								long lStartDocId,
								flint& fliStartSessionIndex,
								BOOL bIsSearchAbove,
								BOOL bIsSearchSuper,
								BOOL bIsSearchAboveBranch,
								BOOL bIsSearchBelow,
								BOOL bIsSearchBelowBranch);

	BOOL	GetSearchAreaForkBranch (	long lDocId,
										flint& fliStartSessionIndex,
										long lSearchFromDocId,
										BOOL bIsSearchAbove,
										BOOL bIsSearchSuper,
										BOOL bIsSearchAboveBranch,
										BOOL bIsSearchBelow,
										BOOL bIsSearchBelowBranch);

	FCFindForkData*	DocumentIdToForkData (long lDocId);

	BOOL	CheckUpdateProject (FCReqLock& reqLock);

	FindObjectResult	CheckUpdateFork (	FCReqLock& reqLock,
											long lDocId,
											FCHiCommandTable* pCmdGate,
											FCHiSummaryTable* pHistoryIndex,
											FCHiTerminateTable& cmdTerminate);

	void	ShowProgressBar ();
	void	HideProgressBar ();

protected:
	WCharPVector		m_vStrTbl;			// _xZkqqHx_iDeBiDgHiDiAiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	FCHFRecordVector	m_vRecord;			// _xZkqqHx_iMjPiNpFiMiLiJmKiDiMiDfCiBfLiDgIiDgFiBfLiDhFiDiLiBeC_xHqqkZx_

	WORDVector			m_vSortOrder;		// _xZkqqHx_iDfMiBfLiDgHiPiHiPoOjFpBiBeC_xHqqkZx_

	FCHiProject			m_searchProject;
	map<long, FCFindForkData> m_mpSearchDocIdToFork;
	flint				m_fliSearchTotal;		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDgGiBfLiDfOiDfKiDgCiDfGiDiHiDjDjAjEiBeC_xHqqkZx_
	flint				m_fliSearchProgress;	// _xZkqqHx_iMjPiNpFjAgJjClLiCmMiDgGiBfLiDfOiDfKiDgCiDfGiDiHiDjDjAjEiBeC_xHqqkZx_
	CFCDlgProgressBar*	m_pDlgProgressBar;		// _xZkqqHx_iDhGiDiNiDePiDiMiDfIiDgPiBfLiDfPiDeDiDeBiDiNiDePiBeC_xHqqkZx_
}; // class FCHistoryFind.

#endif//__HistoryFind_h
