#include "stdafx.h"
#include "DynamicDraw.h"
// 01.02.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include <set>				// For set.
#include <algorithm>		// For reverse.
#include "ObjDynabase.h"		// For FCObjDynabase.
#include "ZOrder.h"			// For FCZOrder.
#include "UtilStr.h"		// For GetResString.
#include "UndoArchive.h"		// For FCUndoArchive.
#include "NewFDObjAny.h"	// For NewFDObjAny.
#include "LayerManager.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*************************************************************************
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_ m_mpLZHash _xZkqqHx_iCmMiOgEjBgHiCnN_xHqqkZx_
 *			ZHash _xZkqqHx_iCmN_xHqqkZx_ 32bit_xZkqqHx_iBeC_xHqqkZx_
 *			_xZkqqHx_iPoDiImK_xHqqkZx_16bit _xZkqqHx_iCmNiBeBiDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCmMiJlKiImK_xHqqkZx_16bit_xZkqqHx_iBeC_xHqqkZx_
 *			_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMiPoKiNiHiCmNiBeBiPoDiImK_xHqqkZx_16bit _xZkqqHx_iCmN_xHqqkZx_ 0xffff _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKiImK_xHqqkZx_16bit _xZkqqHx_iCmNiBeBiDiMiDeDiDiEiBfLiCmJiCkIiCkPiCoJ_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCmMiJlKiImK_xHqqkZx_16bit_xZkqqHx_iBeC_xHqqkZx_
 *			_xZkqqHx_iPoDiImK_xHqqkZx_16bit = 0xffff _xZkqqHx_iCmFiCkAiCmBiCmEiCoAiBeBjFeLiClIiClFiCoAiNmFiPoDiImKiDiMiDeDiDiEiBfLiCmGiCmN_xHqqkZx_
 *			_xZkqqHx_iMmAiCoHiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			Z_xZkqqHx_iDeJiBfLiDfPiBfLiCkKjBoFiCkLiCkNiCmE_xHqqkZx_ 0xffff _xZkqqHx_iCmJjCeCiClFiClNiPoKiNiHiCoAjHeMiCoIjDlOiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/


//----- 03.07.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerZOrder::FCLayerZOrder
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwA	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			dwB	:Z_xZkqqHx_iDeJiBfLiDfPiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCLayerZOrder::FCLayerZOrder (DWORD dwA, DWORD dwB)
//			: dwLayerIdx(dwA), dwZOrder(dwB)
//{
//} // FCLayerZOrder::FCLayerZOrder.
//----- 03.07.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerRec::FCLayerRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpName	:_xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wFlag	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiLjGiJmCiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pvLayer	:_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLayerRec::FCLayerRec (const wchar_t* tcpName, WORD wFlag, ObjDynabaseVector* pvLayer)
			: m_strName(tcpName), m_wFlag(wFlag), m_pvLayer(pvLayer)
{
} // FCLayerRec::FCLayerRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerRec::Delete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiBeBiNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMiDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCmNiKePjFjEiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_jHfOiCkGiCoHiCoKiCoJiCmMiCmFiBeBiNoNiPjMiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerRec::Delete ()
{
	delete m_pvLayer;
	m_pvLayer = NULL;
} // FCLayerRec::Delete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::FCLayerManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bReady			:_xZkqqHx_iDiMiDeDiDiEiBfLiCmMiPiAjEpFiCkKiPgPjHiIiCmEiCkCiCoJiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpName			:_xZkqqHx_iDfGiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mpLZHash		:_xZkqqHx_iCgLiChJiDeJiBfLiDfPiBfL_xHqqkZx_->_xZkqqHx_iDiMiDeDiDiEiBfLiDgOiDgCiDfGiDiFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vBottomLayer	:_xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vTopLayer		:_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLayerManager::FCLayerManager (BOOL bReady, const wchar_t* tcpName,
								ObjectLZHashMap& mpLZHash,
						ObjDynabaseVector& vBottomLayer, ObjDynabaseVector& vTopLayer)
{
// 03.07.24 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	m_bReady = bReady;
	m_strName = tcpName;
//----- 03.07.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiBeC_xHqqkZx_
//	FCLayerRec recBtm(GetResWString(IDS_BOTTOM_LAYER), FDOZ_ON_DRAW, &vBottomLayer);
//	// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiBeC_xHqqkZx_
//	FCLayerRec recTop(GetResWString(IDS_TOP_LAYER), FDOZ_ON_DRAW, &vTopLayer);
//----- 03.07.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiBeC_xHqqkZx_
	FCLayerRec recBtm(FFLoadWString(IDS_BOTTOM_LAYER), FDOZ_ON_DRAW, &vBottomLayer);
	// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiBeC_xHqqkZx_
	FCLayerRec recTop(FFLoadWString(IDS_TOP_LAYER), FDOZ_ON_DRAW, &vTopLayer);
//----- 03.07.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAjAnNjCoIiBeC_xHqqkZx_
	m_mpLZHash = &mpLZHash;
	// _xZkqqHx_iNmFiJlKiImKiBeBiNmFiPoDiImKiDiMiDeDiDiEiBfLiCpAjAnNjCoIiBeC_xHqqkZx_
	m_vLayerTable.push_back(recBtm);
	m_vLayerTable.push_back(recTop);
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiNmFiPoDiImKiDiMiDeDiDiEiBfLiCmJjAnNjCoIiBeC_xHqqkZx_
	m_dwCurLayerIdx = m_vLayerTable.size() - 1;
} // FCLayerManager::FCLayerManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::~FCLayerManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLayerManager::~FCLayerManager ()
{
	for (long lC = 1; lC < long(GetLayerSize()) - 1; lC++)
	{
		m_vLayerTable[lC].Delete();
	}
	m_vLayerTable.clear();
	m_mpLZHash = NULL;
} // FCLayerManager::~FCLayerManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::DeleteAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjBfDiCmEiNoNiPjMiClFiBeBjDoAjHgFiCpAjBfDiCmEjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::DeleteAll ()
{
	//----- _xZkqqHx_iDiMiDeDiDiEiBfLiDgFiBfLiDhFiDiLjCiGiCmMiKgFiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiNoNiPjM_xHqqkZx_ -----
	ObjDynabaseVector::iterator iObj;
	for (long lC = 1; lC < long(GetLayerSize()) - 1; lC++)
	{
		ObjDynabaseVector* pvObj = GetObjOrder(lC);
		// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiNoNiPjMiBeC_xHqqkZx_
		for (iObj = pvObj->begin(); iObj != pvObj->end(); iObj++)
		{
// 02.05.29 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ (Molip_xZkqqHx_iCpA_xHqqkZx_OLE_xZkqqHx_iCmGiClFiCmEiDhJiBfLiDfIiDgHiClFiClNjAoGiCmMiDeBiDhGiDiKiCkJiCoHiBeB_xHqqkZx_Molip_xZkqqHx_iNmEjFnCiPfHiCkKiCmFiCkLiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_)
//			(*iObj)->Terminate();
			delete *iObj;
		}
		// _xZkqqHx_iDiMiDeDiDiEiBfLiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
		m_vLayerTable[lC].Delete();
	}
	// _xZkqqHx_iDiMiDeDiDiEiBfLiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_vLayerTable.clear();
	m_mpLZHash = NULL;
} // FCLayerManager::DeleteAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::GetName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* FCLayerManager::GetName () const
{
	return m_strName.c_str();
} // FCLayerManager::GetName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::GetName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString& FCLayerManager::GetName ()
{
	return m_strName;
} // FCLayerManager::GetName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::SetName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjGlMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpName	:_xZkqqHx_iDfGiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::SetName (const wchar_t* tcpName)
{
	m_strName = tcpName;
} // FCLayerManager::SetName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::IsReady
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLiCmMiPiAjEpFiCkKiPgPjHiIiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiAjEpFiCkKiPgPjHiIiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCLayerManager::IsReady () const
{
	return m_bReady;
} // FCLayerManager::IsReady.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdar		:_xZkqqHx_iPgPjHmNjAoGiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsOutObject:_xZkqqHx_jFjEjFgJiPoOjFpBiCpAiPgPjHmNiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCLayerManager::OutStream (FCUndoArchive& fdar, BOOL bIsOutObject) const
void FCLayerManager::OutStream (FCUndoArchive& fdar, BOOL bIsOutObject, BOOL bIsOutBezier) const
{
	if (bIsOutObject)
	//----- _xZkqqHx_jFjEjFgJiPoOjFpBiCpAiPgPjHmNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfGiBfLiDgHjGlMiCpAiPgPjHmNiBeC_xHqqkZx_
		fdar.WriteString(m_strName);
		//----- _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLiCmMiLeMjIfO_xHqqkZx_ -----
		ObjDynabaseVector::iterator iObj;
		// _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
		fdar << DWORD(m_vLayerTable.size() - 2);
		for (DWORD dwC = 1; dwC < m_vLayerTable.size() - 1; dwC++)
		{
			// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAiPgPjHmNiBeC_xHqqkZx_
			fdar.WriteString(m_vLayerTable[dwC].m_strName);
			// _xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
			fdar << m_vLayerTable[dwC].m_wFlag;
			// _xZkqqHx_jFjEjFgJjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
			fdar << DWORD(m_vLayerTable[dwC].m_pvLayer->size());
			for (iObj = m_vLayerTable[dwC].m_pvLayer->begin();
				 iObj != m_vLayerTable[dwC].m_pvLayer->end(); iObj++)
			{
				// _xZkqqHx_jFjEjFgJiDfOiDeDiDhGiBjFjFjEjFgJiCpAiLeMjIfOiBeC_xHqqkZx_
				fdar << BYTE((*iObj)->Type());
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//				(*iObj)->OutStream(fdar);
				(*iObj)->OutStream(fdar, bIsOutBezier);
			}
		}
		// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
		fdar << m_vLayerTable.front().m_wFlag;
		// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
		fdar << m_vLayerTable.back().m_wFlag;
		// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiPgPjHmNiBeC_xHqqkZx_
		fdar << m_dwCurLayerIdx;
	} else
	//----- _xZkqqHx_jFjEjFgJiPoOjFpBiCpAiPgPjHmNiClFiCmIiCkCiBgJiDgFiDjDiDhGiDiMiBfLiDgHjDjJiBgKiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDfGiBfLiDgHjGlMiCpAiPgPjHmN_xHqqkZx_ -----
		// "_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_1"_xZkqqHx_iBeC_xHqqkZx_
		WString strSheetName;
		strSheetName.Format(L"%s1", ::GetResWString(IDS_UNTITLED_SHEET));
		// _xZkqqHx_iDfGiBfLiDgHjGlMiCpAiPgPjHmNiBeC_xHqqkZx_
		fdar.WriteString(strSheetName);
		//----- _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLiCmMiLeMjIfO_xHqqkZx_ -----
		// _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
		fdar << DWORD(m_vLayerTable.size() - 2);
		for (DWORD dwC = 1; dwC < m_vLayerTable.size() - 1; dwC++)
		{
			// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAiPgPjHmNiBeC_xHqqkZx_
			fdar.WriteString(m_vLayerTable[dwC].m_strName);
			// _xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
			fdar << m_vLayerTable[dwC].m_wFlag;
			// _xZkqqHx_jFjEjFgJjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
			fdar << DWORD(0);
		}
		// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
		fdar << m_vLayerTable.front().m_wFlag;
		// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
		fdar << m_vLayerTable.back().m_wFlag;
		// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiPgPjHmNiBeC_xHqqkZx_
		fdar << m_dwCurLayerIdx;
	}
} // FCLayerManager::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdar	:_xZkqqHx_jDpMjHmNiMlDiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::InStream (FCUndoArchive& fdar)
{
	ASSERT(m_vLayerTable.size() == 2);
// 03.04.29 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	FCUndoArchive fdar(ar);
	// _xZkqqHx_iDfGiBfLiDgHjGlMiCpAjDpMjHmNiBeC_xHqqkZx_
	fdar.ReadString(m_strName);
	//----- _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLiCmMjDgPjIfO_xHqqkZx_ -----
	WORD wFlag;
	WString wstrName;
	DWORD dwLayerSz;
	DWORD dwObjSz;
	BYTE byType;
	FCObjDynabase* pObj;
	// _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
	fdar >> dwLayerSz;
	for (DWORD dwLayerC = 1; dwLayerC <= dwLayerSz; dwLayerC++)
	{
		// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAjDpMjHmNiBeC_xHqqkZx_
		fdar.ReadString(wstrName);
		// _xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAjDpMjHmNiBeC_xHqqkZx_
		fdar >> wFlag;
		// _xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_1_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		InsertLayer(dwLayerC, wstrName.c_str(), wFlag);
		// _xZkqqHx_jFjEjFgJjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
		fdar >> dwObjSz;
		for (DWORD dwObjC = 0; dwObjC < dwObjSz; dwObjC++)
		{
			fdar >> byType;
			pObj = NewFDObjAny(FTObjectType(byType));
			pObj->InStream(fdar);
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiDgFiBfLiDhFiDiLiCmJiLkNjAkHjDgPjIfOiBeCiDePiDiLiBfLiDhGiCmMiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiCoAjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
			pObj->RegisterObjForceID();
			// _xZkqqHx_jFjEjFgJiCpAiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiCmJjDgPjIfOiBeC_xHqqkZx_
			AppendToLZOrder(dwLayerC, pObj);
		}
	}
	// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAjDpMjHmNiBeC_xHqqkZx_
	fdar >> m_vLayerTable.front().m_wFlag;
	// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAjDpMjHmNiBeC_xHqqkZx_
	fdar >> m_vLayerTable.back().m_wFlag;
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAjDpMjHmNiBeC_xHqqkZx_
	fdar >> m_dwCurLayerIdx;
//----- 03.07.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMiPiAjEpFiCkKiPgPjHiIiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
	m_bReady = TRUE;
//----- 03.07.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCLayerManager::InStream.

//----- 03.06.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::OutStreamTemplate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHjHhAiDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdar	:_xZkqqHx_iPgPjHmNjAoGiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OutStream_xZkqqHx_iKnGjAjEiCmGjDkPiClGiMgAiOkOiCmFiDhEiDeAiDeDiDiLiCpAiPgPjHmNiBeCjFjEjFgJjAjE_xHqqkZx_=0_xZkqqHx_iCpAiPgPjHmNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCLayerManager::OutStreamTemplate (FCUndoArchive& fdar) const
//{
//	//----- _xZkqqHx_iDfGiBfLiDgHjGlMiCpAiPgPjHmN_xHqqkZx_ -----
//	// "_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_1"_xZkqqHx_iBeC_xHqqkZx_
//	WString strSheetName;
//	strSheetName.Format(L"%s1", ::GetResWString(IDS_UNTITLED_SHEET));
//	// _xZkqqHx_iDfGiBfLiDgHjGlMiCpAiPgPjHmNiBeC_xHqqkZx_
//	fdar.WriteString(strSheetName);
//	//----- _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLiCmMiLeMjIfO_xHqqkZx_ -----
//	// _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
//	fdar << DWORD(m_vLayerTable.size() - 2);
//	for (DWORD dwC = 1; dwC < m_vLayerTable.size() - 1; dwC++)
//	{
//		// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAiPgPjHmNiBeC_xHqqkZx_
//		fdar.WriteString(m_vLayerTable[dwC].m_strName);
//		// _xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
//		fdar << m_vLayerTable[dwC].m_wFlag;
//		// _xZkqqHx_jFjEjFgJjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
//		fdar << DWORD(0);
//	}
//	// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
//	fdar << m_vLayerTable.front().m_wFlag;
//	// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
//	fdar << m_vLayerTable.back().m_wFlag;
//	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiPgPjHmNiBeC_xHqqkZx_
//	fdar << m_dwCurLayerIdx;
//} // FCLayerManager::OutStreamTemplate.
//----- 03.06.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::InsertLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMiJlKiCmJiDiMiDeDiDiEiBfLiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_jBhNjDpMiClHiCoJiDiMiDeDiDiEiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeCjBhNjDpMiMoDiBeBiClBiCmM_xHqqkZx_
 *						 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmJiCmIiCoJiBeC_xHqqkZx_
 *			tcpName, wFlag	:_xZkqqHx_iDiMiDeDiDiEiBfLiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::InsertLayer (DWORD dwLayerIdx, const wchar_t* tcpName, WORD wFlag)
{
	m_vLayerTable.insert(m_vLayerTable.begin() + dwLayerIdx,
						FCLayerRec(tcpName, wFlag, new ObjDynabaseVector));
	// _xZkqqHx_jBhNjDpMiImKjChFiCkJiCoHiNmFiPoDiImKjBePiDiMiDeDiDiEiBfLiCnMiCmFiDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCpAiNmEiMhGiOfKiBeC_xHqqkZx_
	UpdateLZHashTable(FCLayerZOrder(dwLayerIdx, 0), FCLayerZOrder(GetLayerSize() - 2));
} // FCLayerManager::InsertLayer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::DeleteLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDeDiDiEiBfLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_iNoNiPjMiClHiCoJiDiMiDeDiDiEiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::DeleteLayer (DWORD dwLayerIdx)
{
	ASSERT(GetObjOrder(dwLayerIdx)->empty());
	m_vLayerTable[dwLayerIdx].Delete();
	m_vLayerTable.erase(&m_vLayerTable[dwLayerIdx]);
	// _xZkqqHx_iNoNiPjMiImKjChFiCkJiCoHiNmFiPoDiImKjBePiDiMiDeDiDiEiBfLiCnMiCmFiDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCpAiNmEiMhGiOfKiBeC_xHqqkZx_
	UpdateLZHashTable(FCLayerZOrder(dwLayerIdx, 0), FCLayerZOrder(GetLayerSize() - 2));
} // FCLayerManager::DeleteLayer.

//----- 02.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::ModifyLayer
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLiPoOjFpBiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_jFmPiNfIiClHiCoJiDiMiDeDiDiEiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			tcpName, wFlag	:_xZkqqHx_jFmPiNfIiMoDiCmMiDiMiDeDiDiEiBfLiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCLayerManager::ModifyLayer (DWORD dwLayerIdx, const wchar_t* tcpName, WORD wFlag)
//{
//	BOOL bRedraw = FALSE;
//	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiImIiJlKiCkJiCmCjFfMiOkGiLjGiJmCiDhEiDiJiDePiCmJjFmPiNfIiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
//	if (dwLayerIdx <= GetCurrentLayerIdx() &&
//		(m_vLayerTable[dwLayerIdx].m_wFlag & FDOZ_ON_DRAW) !=
//		(wFlag & FDOZ_ON_DRAW))
//		bRedraw = TRUE;
//	m_vLayerTable[dwLayerIdx].m_strName = tcpName;
//	m_vLayerTable[dwLayerIdx].m_wFlag = wFlag;
//	return bRedraw;
//} // FCLayerManager::ModifyLayer.
//----- 02.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----

//----- 02.09.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::ModifyLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLiPoOjFpBiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
// 02.06.06 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bViewUpdated:_xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiImIiJlKiCmFjFfMiOkGiMkAiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiHiCmNjAfOiCpAjFnEiClHiBeC_xHqqkZx_
 *			dwLayerIdx	:_xZkqqHx_jFmPiNfIiClHiCoJiDiMiDeDiDiEiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpName, wFlag	:_xZkqqHx_jFmPiNfIiMoDiCmMiDiMiDeDiDiEiBfLiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
// 02.06.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiImIiJlKiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 02.06.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)
//BOOL FCLayerManager::ModifyLayer (DWORD dwLayerIdx, const wchar_t* tcpName, WORD wFlag)
BOOL FCLayerManager::ModifyLayer (BOOL& bViewUpdated, DWORD dwLayerIdx, const wchar_t* tcpName, WORD wFlag)
{
//----- 02.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
//	BOOL bRedraw = FALSE;
//	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiImIiJlKiCkJiCmCjFfMiOkGiLjGiJmCiDhEiDiJiDePiCmJjFmPiNfIiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
//	if (dwLayerIdx <= GetCurrentLayerIdx() &&
//		(m_vLayerTable[dwLayerIdx].m_wFlag & FDOZ_ON_DRAW) !=
//		(wFlag & FDOZ_ON_DRAW))
//		bRedraw = TRUE;
//	m_vLayerTable[dwLayerIdx].m_strName = tcpName;
//	m_vLayerTable[dwLayerIdx].m_wFlag = wFlag;
//	return bRedraw;
//----- 02.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiImIiJlKiCkJiCmCjFfMiOkGiLjGiJmCiDhEiDiJiDePiCmJjFmPiNfIiCkAiCoJiPoKiNiHiCmNjAfOiBeC_xHqqkZx_
	bViewUpdated = (dwLayerIdx <= GetCurrentLayerIdx() &&
					(m_vLayerTable[dwLayerIdx].m_wFlag & FDOZ_ON_DRAW) !=
					(wFlag & FDOZ_ON_DRAW));
	// _xZkqqHx_iDiMiDeDiDiEiBfLiPoOjFpBiCpAjFmPiNfIiBeC_xHqqkZx_
	m_vLayerTable[dwLayerIdx].m_strName = tcpName;
	m_vLayerTable[dwLayerIdx].m_wFlag = wFlag;
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiImIiJlKiCmJjFmPiNfIiCkAiCoJiPoKiNiHiCmNjAfOiCpAjFnEiClHiBeC_xHqqkZx_
	return (dwLayerIdx <= GetCurrentLayerIdx());
//----- 02.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
} // FCLayerManager::ModifyLayer.
//----- 02.09.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::SetCurrentLayerIdx
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIdx	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::SetCurrentLayerIdx (DWORD dwIdx)
{
	m_dwCurLayerIdx = dwIdx;
} // FCLayerManager::SetCurrentLayerIdx.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::ReOrderLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLiCmMiPiHjEnEiCpAjFmAiCnHjBnGiCkGiCoJiBeCiNmFiPoDiImKiDiMiDeDiDiEiBfLiBeBiNmFiJlKiImKiDiMiDeDiDiEiBfLiCmN_xHqqkZx_
 *			_xZkqqHx_jBmOiPnLiCmJiCmIiCoHiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			_xZkqqHx_jDpMiCoKjBnGiCkGiCmMjEmNiImNiCmNiBeB_xHqqkZx_[dwFirstIdx, dwLastIdx]
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwFirstIdx		:_xZkqqHx_jFmAiCnHjBnGiCkGiCoJiDiMiDeDiDiEiBfLiCmMiNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwLastIdx		:_xZkqqHx_jFmAiCnHjBnGiCkGiCoJiDiMiDeDiDiEiBfLiCmMiNmFiMoDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwaNewLayerIdx	:_xZkqqHx_jFmAiCnHjBnGiCkGiCoJjBePiCmMiDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiBeB_xHqqkZx_
 *							 _xZkqqHx_jAfGiClFiCkCiDiMiDeDiDiEiBfLiPiHiCmJjFmAiCnHiClNjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCLayerManager::ReOrderLayer (DWORD dwFirstIdx, DWORD dwLastIdx, const DWORD dwaNewLayerIdx[])
{
//	ASSERT(dwFirstIdx != 0);
//	ASSERT(dwLastIdx != m_vLayerTable.size() - 1);
	LayerRecVector vLayerTable = m_vLayerTable;
	DWORD dwSize = dwLastIdx + 1 - dwFirstIdx;
	for (DWORD dwCount = 0; dwCount < dwSize; dwCount++)
	{
//		ASSERT(dwaNewLayerIdx[dwCount] != 0);
//		ASSERT(dwaNewLayerIdx[dwCount] != m_vLayerTable.size() - 1);
		m_vLayerTable[dwFirstIdx + dwCount] = vLayerTable[dwaNewLayerIdx[dwCount]];
	}
	// _xZkqqHx_jDpMiCoKjBnGiCkGjEmNiImNiCmMiDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCpAiNmEiMhGiOfKiBeC_xHqqkZx_
	UpdateLZHashTable(FCLayerZOrder(dwFirstIdx, 0), FCLayerZOrder(dwLastIdx));
	// _xZkqqHx_iNmEjFgAiJoGjFeLjHhGiBeI_xHqqkZx_
	return (dwFirstIdx <= GetCurrentLayerIdx());
} // FCLayerManager::ReOrderLayer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::AppendToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiJmCjEfMiCmIiDiMiDeDiDiEiBfLiCmFiBeBiDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCmJiNmFiCoAiLnPiCkCiDiMiDeDiDiEiBfLiCmJ_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::AppendToLZOrder (FCObjDynabase* pObj)
{
	AppendToLZOrder(FirstFrontLayerIdx(GetCurrentLayerIdx(), FDOZ_ON_EDIT), pObj);
} // FCLayerManager::AppendToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::AppendToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiJmCjEfMiCmIiDiMiDeDiDiEiBfLiCmFiBeBiDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCmJiNmFiCoAiLnPiCkCiDiMiDeDiDiEiBfLiCmJ_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj	:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::AppendToLZOrder (const ObjDynabaseVector& vObj)
{
	AppendToLZOrder(FirstFrontLayerIdx(GetCurrentLayerIdx(), FDOZ_ON_EDIT), vObj);
} // FCLayerManager::AppendToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::AppendToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiJmCjEfMiCmIiDiMiDeDiDiEiBfLiCmFiBeBiDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCmJiNmFiCoAiLnPiCkCiDiMiDeDiDiEiBfLiCmJ_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObjArray	:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJjEhKjHpBiCmMiNmFiPiJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lArraySz	:_xZkqqHx_jFjEjFgJjEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::AppendToLZOrder (FCObjDynabase*const* pObjArray, long lArraySz)
{
	AppendToLZOrder(FirstFrontLayerIdx(GetCurrentLayerIdx(), FDOZ_ON_EDIT),
					pObjArray, lArraySz);
} // FCLayerManager::AppendToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::AppendToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_jCmHiJmBiClHiCoJiDiMiDeDiDiEiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObj		:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::AppendToLZOrder (DWORD dwLayerIdx, FCObjDynabase* pObj)
{
	// _xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCmM_xHqqkZx_ZOrder_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_
	DWORD dwZOrder = GetObjOrder(dwLayerIdx)->size();
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiNmFiMoDiCmJjCmHiJmBiBeC_xHqqkZx_
	GetObjOrder(dwLayerIdx)->push_back(pObj);
	// _xZkqqHx_jCmHiJmBiClFiClNjFjEjFgJiCmMiDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateLZHashTable(FCLayerZOrder(dwLayerIdx, dwZOrder));
} // FCLayerManager::AppendToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::AppendToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_jCmHiJmBiClHiCoJiDiMiDeDiDiEiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vObj		:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::AppendToLZOrder (DWORD dwLayerIdx, const ObjDynabaseVector& vObj)
{
//----- 01.04.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jCmHiJmBiClHiCoJiNmFiPiJiCmMjFjEjFgJiCmM_xHqqkZx_ZOrder_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_
//	DWORD dwZOrder = GetObjOrder(dwLayerIdx)->size();
//	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiNmFiMoDiCmJjCmHiJmBiBeC_xHqqkZx_
//	GetObjOrder(dwLayerIdx)->insert(GetObjOrder(dwLayerIdx)->end(), vObj.begin(), vObj.end());
//	// _xZkqqHx_jCmHiJmBiClFiClNjFjEjFgJiCmMiDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
//	UpdateLZHashTable(FCLayerZOrder(dwLayerIdx, dwZOrder),
//						LAST_LAYER_ORDER);
//----- 01.04.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	AppendToLZOrder(dwLayerIdx, vObj.begin(), vObj.size());
//----- 01.04.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCLayerManager::AppendToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::AppendToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_jCmHiJmBiClHiCoJiDiMiDeDiDiEiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObjArray	:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJjEhKjHpBiCmMiNmFiPiJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lArraySz	:_xZkqqHx_jFjEjFgJjEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::AppendToLZOrder (DWORD dwLayerIdx, FCObjDynabase*const* pObjArray,
										long lArraySz)
{
	// _xZkqqHx_jCmHiJmBiClHiCoJiNmFiPiJiCmMjFjEjFgJiCmM_xHqqkZx_ZOrder_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_
	DWORD dwZOrder = GetObjOrder(dwLayerIdx)->size();
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiNmFiMoDiCmJjCmHiJmBiBeC_xHqqkZx_
	GetObjOrder(dwLayerIdx)->insert(GetObjOrder(dwLayerIdx)->end(),
									pObjArray, pObjArray + lArraySz);
	// _xZkqqHx_jCmHiJmBiClFiClNjFjEjFgJiCmMiDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateLZHashTable(FCLayerZOrder(dwLayerIdx, dwZOrder),
						LAST_LAYER_ORDER);
} // FCLayerManager::AppendToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::InsertToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPos	:_xZkqqHx_jBhNjDpMiClHiCoJiImKjChFiCmMjFjEjFgJiCpAiOhHjCoIiBeCiClBiCmMjFjEjFgJiCmMjBePiCmJjBhNjDpMiBeC_xHqqkZx_
 *			pObj	:_xZkqqHx_jBhNjDpMiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::InsertToLZOrder (FCObjDynabase* pPos, FCObjDynabase* pObj)
{
	// _xZkqqHx_jBhNjDpMiImKjChFiCpAiOoGjDlOiClFiBeBjFjEjFgJiCpAjBhNjDpMiBeC_xHqqkZx_
	InsertToLZOrder(ObjDynabaseToLZOrder(pPos), pObj);
} // FCLayerManager::InsertToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::InsertToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPos	:_xZkqqHx_jBhNjDpMiClHiCoJiImKjChFiCmMjFjEjFgJiCpAiOhHjCoIiBeCiClBiCmMjFjEjFgJiCmMjBePiCmJjBhNjDpMiBeC_xHqqkZx_
 *			vObj	:_xZkqqHx_jBhNjDpMiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::InsertToLZOrder (FCObjDynabase* pPos, const ObjDynabaseVector& vObj)
{
	// _xZkqqHx_jBhNjDpMiImKjChFiCpAiOoGjDlOiClFiBeBjFjEjFgJiCpAjBhNjDpMiBeC_xHqqkZx_
	InsertToLZOrder(ObjDynabaseToLZOrder(pPos), vObj.begin(), vObj.size());
} // FCLayerManager::InsertToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::InsertToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPos		:_xZkqqHx_jBhNjDpMiClHiCoJiImKjChFiCmMjFjEjFgJiCpAiOhHjCoIiBeCiClBiCmMjFjEjFgJiCmMjBePiCmJjBhNjDpMiBeC_xHqqkZx_
 *			pObjArray	:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJjEhKjHpBiCmMiNmFiPiJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lArraySz	:_xZkqqHx_jFjEjFgJjEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::InsertToLZOrder (FCObjDynabase* pPos,
									FCObjDynabase*const* pObjArray, long lArraySz)
{
	// _xZkqqHx_jBhNjDpMiImKjChFiCpAiOoGjDlOiClFiBeBjFjEjFgJiCpAjBhNjDpMiBeC_xHqqkZx_
	InsertToLZOrder(ObjDynabaseToLZOrder(pPos), pObjArray, lArraySz);
} // FCLayerManager::InsertToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::InsertToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:_xZkqqHx_jBhNjDpMiClHiCoJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObj	:_xZkqqHx_jBhNjDpMiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::InsertToLZOrder (const FCLayerZOrder& lzorder, FCObjDynabase* pObj)
{
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMiOhHjCoIiImKjChFiCmJjCmHiJmBiBeC_xHqqkZx_
	GetObjOrder(lzorder.dwLayerIdx)->insert(GetObjOrder(lzorder.dwLayerIdx)->begin() +
													lzorder.dwZOrder, pObj);
	// _xZkqqHx_jBhNjDpMiImKjChFiImIiNhOiCmMjFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateLZHashTable(lzorder, LAST_LAYER_ORDER);
} // FCLayerManager::InsertToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::InsertToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:_xZkqqHx_jBhNjDpMiClHiCoJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vObj	:_xZkqqHx_jBhNjDpMiClHiCoJjFjEjFgJiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::InsertToLZOrder (const FCLayerZOrder& lzorder, const ObjDynabaseVector& vObj)
{
//----- 01.04.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMiOhHjCoIiImKjChFiCmJjCmHiJmBiBeC_xHqqkZx_
//	GetObjOrder(lzorder.dwLayerIdx)->insert(GetObjOrder(lzorder.dwLayerIdx)->begin() +
//											lzorder.dwZOrder, vObj.begin(), vObj.end());
//	// _xZkqqHx_jBhNjDpMiImKjChFiImIiNhOiCmMjFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
//	UpdateLZHashTable(lzorder, LAST_LAYER_ORDER);
//----- 01.04.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	InsertToLZOrder(lzorder, vObj.begin(), vObj.size());
//----- 01.04.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCLayerManager::InsertToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::InsertToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder		:_xZkqqHx_jBhNjDpMiClHiCoJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObjArray	:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJjEhKjHpBiCmMiNmFiPiJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lArraySz	:_xZkqqHx_jFjEjFgJjEhKjHpBiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::InsertToLZOrder (const FCLayerZOrder& lzorder,
										FCObjDynabase*const* pObjArray, long lArraySz)
{
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMiOhHjCoIiImKjChFiCmJjCmHiJmBiBeC_xHqqkZx_
	GetObjOrder(lzorder.dwLayerIdx)->insert(GetObjOrder(lzorder.dwLayerIdx)->begin() +
									lzorder.dwZOrder, pObjArray, pObjArray + lArraySz);
	// _xZkqqHx_jBhNjDpMiImKjChFiImIiNhOiCmMjFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateLZHashTable(lzorder, LAST_LAYER_ORDER);
} // FCLayerManager::InsertToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::InsertToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vLZOrder	:_xZkqqHx_jBhNjDpMiClHiCoJiImKjChFiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vObj		:_xZkqqHx_jBhNjDpMiClHiCoJjFjEjFgJiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vLZOrder_xZkqqHx_iCmG_xHqqkZx_vObj_xZkqqHx_iCmMjEhKjHpBiCmNjBmOiCmJiCmIiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::InsertToLZOrder (const LayerZOrderVector& vLZOrder,
									const ObjDynabaseVector& vObj)
{
	for (long lC = 0; lC < vLZOrder.size(); lC++)
	{
		// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMiOhHjCoIiImKjChFiCmJjCmHiJmBiBeC_xHqqkZx_
		GetObjOrder(vLZOrder[lC].dwLayerIdx)->insert(
									GetObjOrder(vLZOrder[lC].dwLayerIdx)->begin() +
										vLZOrder[lC].dwZOrder, vObj[lC]);
	}
	// _xZkqqHx_jBhNjDpMiImKjChFiImIiNhOiCmMjFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateLZHashTable(vLZOrder[0], LAST_LAYER_ORDER);
} // FCLayerManager::InsertToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::RemoveFromLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCkJiCoHjFjEjFgJiCpAiPjMiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iPjMiCkNjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::RemoveFromLZOrder (FCObjDynabase* pObj)
{
	// _xZkqqHx_jFjEjFgJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
	FCLayerZOrder lzorder = ObjDynabaseToLZOrder(pObj);
	// _xZkqqHx_jFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCkJiCoHiBeBiClBiCmMjFjEjFgJiCmJiKnGiClHiCoJiDiMiDfCiBfLiDgIiCpAjGjFiPmBiBeC_xHqqkZx_
	EraseFromLZHashTable(pObj);
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMiOhHjCoIiImKjChFiCpAjGjFiPmBiBeC_xHqqkZx_
	GetObjOrder(lzorder.dwLayerIdx)->erase(GetObjOrder(lzorder.dwLayerIdx)->begin() +
												lzorder.dwZOrder);
	// _xZkqqHx_iNoNiPjMiImKjChFiImIiNhOiCmMjFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateLZHashTable(lzorder, LAST_LAYER_ORDER);
} // FCLayerManager::RemoveFromLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::RemoveFromLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCkJiCoHjFjEjFgJiCpAiPjMiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj	:_xZkqqHx_iPjMiCkNjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::RemoveFromLZOrder (const ObjDynabaseVector& vObj)
{
	set<FCLayerZOrder> stLZOrder;
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
	{
		// _xZkqqHx_jFjEjFgJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		FCLayerZOrder lzorder = ObjDynabaseToLZOrder(*iObj);
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCkJiCoHiBeBiClBiCmMjFjEjFgJiCmJiKnGiClHiCoJiDiMiDfCiBfLiDgIiCpAjGjFiPmBiBeC_xHqqkZx_
		EraseFromLZHashTable(*iObj);
		// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMiOhHjCoIiImKjChFiCmJiJlMiPiIjChFiCmGiClFiCmE_xHqqkZx_NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		// _xZkqqHx_iClBiClBiCmFiChJiDeJiBfLiDfPiBfLiCkJiCoHjGjFiPmBiClHiCoJiCmGiBeBjFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCkKiLlGiCkEiCkJiCoHiBeC_xHqqkZx_
		GetObjOrder(lzorder.dwLayerIdx)->at(lzorder.dwZOrder) = NULL;
		stLZOrder.insert(lzorder);
	}
	//----- _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmM_xHqqkZx_ NULL _xZkqqHx_iCmMjFjEjFgJiCpAiNoNiPjM_xHqqkZx_ -----
	set<FCLayerZOrder>::reverse_iterator iZr;
	for (iZr = stLZOrder.rbegin(); iZr != stLZOrder.rend(); iZr++)
		GetObjOrder((*iZr).dwLayerIdx)->erase(GetObjOrder((*iZr).dwLayerIdx)->begin() +
											(*iZr).dwZOrder);
	// _xZkqqHx_iNoNiPjMiNmFiPkMiImKjChFiImIiNhOiCmMjFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateLZHashTable(*stLZOrder.begin(), LAST_LAYER_ORDER);
} // FCLayerManager::RemoveFromLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::MoveZFront
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiBeB_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCmMiIoKiCmCjBePiCmJiInKjDkOiClHiCoJiBeCiDiMiDeDiDiEiBfLiKnEiCmNiInKjDkO_xHqqkZx_
 *			_xZkqqHx_iClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:_xZkqqHx_iInKjDkOiClHiCoJjFjEjFgJiCmM_xHqqkZx_LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObj	:_xZkqqHx_iInKjDkOiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiClDiCoKiClNiCoH_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCLayerManager::MoveZFront (const FCLayerZOrder& lzorder, FCObjDynabase* pObj)
{
	if (lzorder.dwZOrder + 1 < GetObjOrder(lzorder.dwLayerIdx)->size())
	{
		// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJiCkIiCkCiCmEiBeBjFjEjFgJiCpAiClLiCmMiIoKiCmCiMoDiCoLiCmMjFjEjFgJiCmGjDpMiCoKjBnGiCkGiBeC_xHqqkZx_
		Exchange(GetObjOrder(lzorder.dwLayerIdx)->at(lzorder.dwZOrder),
				 GetObjOrder(lzorder.dwLayerIdx)->at(lzorder.dwZOrder + 1));
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
		UpdateLZHashTable(lzorder,
						FCLayerZOrder(lzorder.dwLayerIdx, lzorder.dwZOrder + 1));
		return TRUE;
	}
	return FALSE;
} // FCLayerManager::MoveZFront.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::MoveLZFront
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiPfHiNiHiCpAiBeB_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCmMiIoKiCmCjBePiCmJiInKjDkOiClHiCoJiBeCiDiMiDeDiDiEiBfLiKnEiCmNiInKjDkO_xHqqkZx_
 *			_xZkqqHx_iClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vMoved	:_xZkqqHx_iInKjDkOiClDiCoKiClNjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			vObj	:_xZkqqHx_iInKjDkOiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIoKiCmCiCmFiCoAiInKjDkOiClDiCoKiClNiCoH_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCLayerManager::MoveLZFront (ObjDynabaseVector& vMoved, const ObjDynabaseVector& vObj)
{
	FCLayerZOrder lzorderPrev(DWORD(-1), DWORD(-1));
	ObjDynabaseVector::const_reverse_iterator riObj;
	for (riObj = vObj.rbegin(); riObj != vObj.rend(); riObj++)
	{
		// _xZkqqHx_jFjEjFgJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		FCLayerZOrder lzorder = ObjDynabaseToLZOrder(*riObj);
		// _xZkqqHx_iDiMiDeDiDiEiBfLiCkKiIoBiCkEiCkJiBeBjBePiCkKiCmCiCkJiCkGiCmEiCkCiCmIiCkCiPoKiNiHiCmNiInKjDkOiPiIjHjNiBeC_xHqqkZx_
		if (lzorder.dwLayerIdx != lzorderPrev.dwLayerIdx ||
			lzorder.dwZOrder + 1 != lzorderPrev.dwZOrder)
		{
			// _xZkqqHx_iNmFjBePjGmKiCmFiCmNiPiIjHjNiClFiCmIiCkCiBeC_xHqqkZx_
			if (MoveZFront(lzorder, *riObj))
				vMoved.push_back(*riObj);
		}
		lzorderPrev = lzorder;
	}
	if (vMoved.empty()) return FALSE;
	// _xZkqqHx_iInKjDkOiDiKiDfIiDgHiCpAiLhEjDfNiBeC_xHqqkZx_
	reverse(vMoved.begin(), vMoved.end());
	return TRUE;
} // FCLayerManager::MoveLZFront.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::MoveZBack
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiBeB_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCmMiIoKiCmCiMoDiCoLiCmJiInKjDkOiClHiCoJiBeCiDiMiDeDiDiEiBfLiKnEiCmNiInKjDkO_xHqqkZx_
 *			_xZkqqHx_iClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:_xZkqqHx_iInKjDkOiClHiCoJjFjEjFgJiCmM_xHqqkZx_LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObj	:_xZkqqHx_iInKjDkOiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiClDiCoKiClNiCoH_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCLayerManager::MoveZBack (const FCLayerZOrder& lzorder, FCObjDynabase* pObj)
{
	if (0 < lzorder.dwZOrder)
	{
		// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJiCkIiCkCiCmEiBeBjFjEjFgJiCpAiClLiCmMiIoKiCmCjBePiCmMjFjEjFgJiCmGjDpMiCoKjBnGiCkGiBeC_xHqqkZx_
		Exchange(GetObjOrder(lzorder.dwLayerIdx)->at(lzorder.dwZOrder - 1),
				 GetObjOrder(lzorder.dwLayerIdx)->at(lzorder.dwZOrder));
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
		UpdateLZHashTable(FCLayerZOrder(lzorder.dwLayerIdx, lzorder.dwZOrder - 1),
							lzorder);
		return TRUE;
	}
	return FALSE;
} // FCLayerManager::MoveZBack.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::MoveLZBack
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiPfHiNiHiCpAiBeB_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCmMiIoKiCmCiMoDiCoLiCmJiInKjDkOiClHiCoJiBeCiDiMiDeDiDiEiBfLiKnEiCmNiInKjDkO_xHqqkZx_
 *			_xZkqqHx_iClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vMoved	:_xZkqqHx_iInKjDkOiClDiCoKiClNjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			vObj	:_xZkqqHx_iInKjDkOiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIoKiCmCiCmFiCoAiInKjDkOiClDiCoKiClNiCoH_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCLayerManager::MoveLZBack (ObjDynabaseVector& vMoved, const ObjDynabaseVector& vObj)
{
	FCLayerZOrder lzorderPrev(DWORD(-1), DWORD(-1));
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
	{
		// _xZkqqHx_jFjEjFgJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		FCLayerZOrder lzorder = ObjDynabaseToLZOrder(*iObj);
		// _xZkqqHx_iDiMiDeDiDiEiBfLiCkKiInJiCmIiCoJiCkJiBeBjBePiCkKiCmCiCkJiCkGiCmEiCkCiCmIiCkPiCoKiCmOiInKjDkOiPiIjHjNiBeC_xHqqkZx_
		if (lzorder.dwLayerIdx != lzorderPrev.dwLayerIdx ||
			lzorder.dwZOrder != lzorderPrev.dwZOrder + 1)
		{
			// Z_xZkqqHx_iDeJiBfLiDfPiBfLiInKjDkOiPiIjHjNiBeCiNmFjEhHjGmKiCmFiCmNjDkOiNoMiClFiCmIiCkCiBeC_xHqqkZx_
			if (MoveZBack(lzorder, *iObj))
				vMoved.push_back(*iObj);
		}
		lzorderPrev = lzorder;
	}
	if (vMoved.empty()) return FALSE;
	return TRUE;
} // FCLayerManager::MoveLZBack.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::ObjDynabaseToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkJiCoH_xHqqkZx_LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiBeCiOhHjCoIiCmMjFjEjFgJiCkK_xHqqkZx_LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			LAST_LAYER_ORDER_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLayerZOrder FCLayerManager::ObjDynabaseToLZOrder (const FCObjDynabase* pObj) const
{
	// ZHash_xZkqqHx_jCgMiBgJ_xHqqkZx_Layer,_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMiJlKiCfBiDgPiDeDiDgHiBgKiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	ObjectLZHashMap::const_iterator i = m_mpLZHash->find(pObj);
	if (i != m_mpLZHash->end())
	//----- _xZkqqHx_jFjEjFgJiCkK_xHqqkZx_LZ_xZkqqHx_iDeJiBfLiDfPiBfLiDgOiDgCiDfGiDiFiCmJiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		DWORD dwLayerIdx = (*i).second >> 16;
		if (dwLayerIdx == 0x0000ffff)
		//----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMiJmCjEfMjAkLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iPoDiImK_xHqqkZx_16bit = 0xffff _xZkqqHx_iCmFiCkAiCmBiCmEiCoAiBeBjFeLiClIiClFiCoAiNmFiPoDiImKiDiMiDeDiDiEiBfLiCmGiCmN_xHqqkZx_
			// _xZkqqHx_iMmAiCoHiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
			// Z_xZkqqHx_iDeJiBfLiDfPiBfLiCkKjBoFiCkLiCkNiCmE_xHqqkZx_ 0xffff _xZkqqHx_iCmJjCeCiClFiClNiPoKiNiHiCoAjHeMiCoIjDlOiCoJiBeC_xHqqkZx_
			for (DWORD dwZOrder = (*i).second & 0x0000ffff;
				 dwZOrder < GetTopObjOrder()->size(); dwZOrder += 0x10000)
				if (GetTopObjOrder()->at(dwZOrder) == pObj)
					return FCLayerZOrder(GetLayerSize() - 1, dwZOrder);
		}
		for (; dwLayerIdx < GetLayerSize(); dwLayerIdx += 0x10000)
		{
			for (DWORD dwZOrder = (*i).second & 0x0000ffff;
				 dwZOrder < GetObjOrder(dwLayerIdx)->size(); dwZOrder += 0x10000)
				if (GetObjOrder(dwLayerIdx)->at(dwZOrder) == pObj)
					return FCLayerZOrder(dwLayerIdx, dwZOrder);
		}
	}
	return LAST_LAYER_ORDER;
} // FCLayerManager::ObjDynabaseToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::LZOrderToObjDynabase
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCkJiCoHjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjDynabase* FCLayerManager::LZOrderToObjDynabase (const FCLayerZOrder& lzorder) const
{
	return GetObjOrder(lzorder.dwLayerIdx)->at(lzorder.dwZOrder);
} // FCLayerManager::LZOrderToObjDynabase.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::GetCurrentLayerIdx
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCLayerManager::GetCurrentLayerIdx () const
{
	return m_dwCurLayerIdx;
} // FCLayerManager::GetCurrentLayerIdx.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::GetZOrderSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiPpAiMiPiCmJiIoKjChGiClHiCoJiChJiDeJiBfLiDfPiBfLiCmMjAjEiBgJjFjEjFgJjAjEiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wOption		:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJjBgHiCnNiNjOiCnOiDiMiDeDiDiEiBfLiCmMiPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwFromIdx	:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJjBgHiCnNiNjOiCnOiDiMiDeDiDiEiBfLiCmMiKeKiOgOiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwUntilIdx	:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJjBgHiCnNiNjOiCnOiDiMiDeDiDiEiBfLiCmMiPeJjHlJiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iKeKjAnN_xHqqkZx_>	[dwFromIdx, dwUntilIdx]_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_dwUntilIdx == DWORD(-1)_xZkqqHx_iCmIiCoHiCmOiBeB_xHqqkZx_
 *			_xZkqqHx_iNmFiMoDiCnMiCmFiMjPiNpFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCLayerManager::GetZOrderSize (WORD wOption, DWORD dwFromIdx, DWORD dwUntilIdx) const
{
	DWORD dwCount = 0;
	if (dwUntilIdx == DWORD(-1))
		dwUntilIdx = GetLayerSize() - 1;
	for (DWORD dwIdx = dwFromIdx; dwIdx <= dwUntilIdx; dwIdx++)
	{
		if ((m_vLayerTable[dwIdx].m_wFlag & wOption) == wOption)
			dwCount += GetObjOrder(dwIdx)->size();
	}
	return dwCount;
} // FCLayerManager::GetZOrderSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::GetZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiPpAiMiPiCmJiIoKjChGiClHiCoJiChJiDeJiBfLiDfPiBfLiCpAjBgHiCnNjHkHiCmEiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	zOrder		:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
 *			wOption		:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJjBgHiCnNiNjOiCnOiDiMiDeDiDiEiBfLiCmMiPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwFromIdx	:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJjBgHiCnNiNjOiCnOiDiMiDeDiDiEiBfLiCmMiKeKiOgOiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwUntilIdx	:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJjBgHiCnNiNjOiCnOiDiMiDeDiDiEiBfLiCmMiPeJjHlJiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iKeKjAnN_xHqqkZx_>	[dwFromIdx, dwUntilIdx]_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_dwUntilIdx == DWORD(-1)_xZkqqHx_iCmIiCoHiCmOiBeB_xHqqkZx_
 *			_xZkqqHx_iNmFiMoDiCnMiCmFiMjPiNpFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::GetZOrder (FCZOrder& zOrder, WORD wOption, DWORD dwFromIdx, DWORD dwUntilIdx) const
{
	if (dwUntilIdx == DWORD(-1))
		dwUntilIdx = GetLayerSize() - 1;
	for (DWORD dwIdx = dwFromIdx; dwIdx <= dwUntilIdx; dwIdx++)
	{
		if ((m_vLayerTable[dwIdx].m_wFlag & wOption) == wOption)
		{
			zOrder.PushBack(GetObjOrder(dwIdx));
		}
	}
} // FCLayerManager::GetZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::GetZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiPpAiMiPiCmJiIoKjChGiClHiCoJiChJiDeJiBfLiDfPiBfLiCpAiBeBiCfAjEhKjHpBiCmJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj		:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOpDiCkPiOoGiCoJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wOption		:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJjBgHiCnNiNjOiCnOiDiMiDeDiDiEiBfLiCmMiPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwFromIdx	:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJjBgHiCnNiNjOiCnOiDiMiDeDiDiEiBfLiCmMiKeKiOgOiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwUntilIdx	:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJjBgHiCnNiNjOiCnOiDiMiDeDiDiEiBfLiCmMiPeJjHlJiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iKeKjAnN_xHqqkZx_>	[dwFromIdx, dwUntilIdx]_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_dwUntilIdx == DWORD(-1)_xZkqqHx_iCmIiCoHiCmOiBeB_xHqqkZx_
 *			_xZkqqHx_iNmFiMoDiCnMiCmFiMjPiNpFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::GetZOrder (ObjDynabaseVector& vObj, WORD wOption, DWORD dwFromIdx, DWORD dwUntilIdx) const
{
	if (dwUntilIdx == DWORD(-1))
		dwUntilIdx = GetLayerSize() - 1;
	for (DWORD dwIdx = dwFromIdx; dwIdx <= dwUntilIdx; dwIdx++)
	{
		if ((m_vLayerTable[dwIdx].m_wFlag & wOption) == wOption)
		{
			vObj.insert(vObj.end(), GetObjOrder(dwIdx)->begin(), GetObjOrder(dwIdx)->end());
		}
	}
} // FCLayerManager::GetZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::FirstFrontLayerIdx
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDeDiDiEiBfLiImIiJlK_xHqqkZx_(_xZkqqHx_jBkGiClPiImIiJlKiCmM_xHqqkZx_Idx)_xZkqqHx_iCmMiBeBiOhHjCoIiCmMiDeJiDhGiDfGiDiHiDjDiCmJiIoKjChG_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiNmFiPiJiCmMiDiMiDeDiDiEiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwFromIdx	:_xZkqqHx_iMjPiNpFiKeKiOgOiDiMiDeDiDiEiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wOption		:_xZkqqHx_iMjPiNpFjHhAiCmMiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_Idx_xZkqqHx_iCpAjFnEiClHiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCLayerManager::FirstFrontLayerIdx (DWORD dwFromIdx, WORD wOption) const
{
	if (dwFromIdx == DWORD(-1))
		dwFromIdx = GetLayerSize() - 1;
	for (;;)
	{
		if ((m_vLayerTable[dwFromIdx].m_wFlag & wOption) == wOption)
		{
			return dwFromIdx;
		}
		if (dwFromIdx == 0) break;
		dwFromIdx--;
	}
	return DWORD(-1);
} // FCLayerManager::FirstFrontLayerIdx.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::GetObjOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDeDiDiEiBfLiCmMjFjEjFgJjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
ObjDynabaseVector* FCLayerManager::GetObjOrder (DWORD dwLayerIdx) const
{
	return m_vLayerTable[dwLayerIdx].m_pvLayer;
} // FCLayerManager::GetObjOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::GetLayerSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCLayerManager::GetLayerSize () const
{
	return m_vLayerTable.size();
} // FCLayerManager::GetLayerSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::GetLayerInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDeDiDiEiBfLiCmMiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strName		:_xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *			wFlag		:_xZkqqHx_iDiMiDeDiDiEiBfLiCmMiDeBiDeOiDfKiDfIiLjGiJmCiDhEiDiJiDePiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *			dwLayerIdx	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::GetLayerInfo (WString* wstrName, WORD* wFlag, DWORD dwLayerIdx) const
{
	if (wstrName != NULL)
		*wstrName = m_vLayerTable[dwLayerIdx].m_strName;
	if (wFlag != NULL)
		*wFlag = m_vLayerTable[dwLayerIdx].m_wFlag;
} // FCLayerManager::GetLayerInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::FirstFrontLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_LZOrder_xZkqqHx_iImIiJlKiCmJiCkAiCoIiBeBiOhHjCoIiCmMiDeJiDhGiDfGiDiHiDjDiCmJiIoKjChGiClHiCoJiDiMiDeDiDiEiBfLiCmM_xHqqkZx_
 *			_xZkqqHx_iNmFiPiJiCmMjFjEjFgJiCmM_xHqqkZx_LZOrder_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:_xZkqqHx_jFnEiClHjCgMiBeC_xHqqkZx_
 *			wOption	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiLjGiJmCiCmMiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lzFrom	:_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCpAiOhHjCoIiBeCiNmFiPiJiCkJiCoHiCmMiPoKiNiHiCmN_xHqqkZx_
 *					 LAST_LAYER_ORDER _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_lzorder_xZkqqHx_iCmJ_xHqqkZx_LAST_LAYER_ORDER
 *			_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::FirstFrontLZOrder (FCLayerZOrder& lzorder, WORD wOption,
										const FCLayerZOrder& lzFrom) const
{
	lzorder = lzFrom;
	if (GetLayerSize() <= lzorder.dwLayerIdx)
	{
		lzorder.dwLayerIdx = GetLayerSize() - 1;
		lzorder.dwZOrder = DWORD(-1);
	}
	for (;;)
	{
		if (!GetObjOrder(lzorder.dwLayerIdx)->empty() &&
			(m_vLayerTable[lzorder.dwLayerIdx].m_wFlag & wOption) == wOption)
		{
			if (GetObjOrder(lzorder.dwLayerIdx)->size() <= lzorder.dwZOrder)
			{
				lzorder.dwZOrder = GetObjOrder(lzorder.dwLayerIdx)->size() - 1;
			}
			break;
		}
		lzorder.dwLayerIdx--;
		lzorder.dwZOrder = DWORD(-1);
		if (lzorder.dwLayerIdx == DWORD(-1))
		{
			lzorder.dwLayerIdx = DWORD(-1);
			lzorder.dwZOrder = DWORD(-1);
			break;
		}
	}
} // FCLayerManager::FirstFrontLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::NextBackLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	lzorder_xZkqqHx_iCpAiIoKiCmCiJlKiCmJiBgJjBePiCmJiBgKjAgJiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:_xZkqqHx_jAgJiCnPiCoJjCgMiCpAiOhHjCoIiBeCjAgJiCnPiClNjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iClBiCoKiImIiPoDjAgJiCnPiCoHiCoKiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_lzorder _xZkqqHx_iCmJ_xHqqkZx_{DWORD(-1),DWORD(-1)}_xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::NextBackLZOrder (FCLayerZOrder& lzorder, WORD wOption) const
{
	lzorder.dwZOrder--;
	while (lzorder.dwZOrder == DWORD(-1) ||
			(m_vLayerTable[lzorder.dwLayerIdx].m_wFlag & wOption) != wOption)
	{
		lzorder.dwLayerIdx--;
		if (lzorder.dwLayerIdx == DWORD(-1))
		{
			lzorder.dwLayerIdx = DWORD(-1);
			lzorder.dwZOrder = DWORD(-1);
			return;
		}
		lzorder.dwZOrder = DWORD(GetObjOrder(lzorder.dwLayerIdx)->size()) - 1;
	}
} // FCLayerManager::NextBackLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::FirstBackLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_LZOrder_xZkqqHx_iImIiPoDiCmJiCkAiCoIiBeBiOhHjCoIiCmMiDeJiDhGiDfGiDiHiDjDiCmJiIoKjChGiClHiCoJiDiMiDeDiDiEiBfLiCmM_xHqqkZx_
 *			_xZkqqHx_iNmFiPiJiCmMjFjEjFgJiCmM_xHqqkZx_LZOrder_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:_xZkqqHx_jFnEiClHjCgMiBeC_xHqqkZx_
 *			wOption	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiLjGiJmCiCmMiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lzFrom	:_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCpAiOhHjCoIiBeCiNmFiPiJiCkJiCoHiCmMiPoKiNiHiCmN_xHqqkZx_
 *					 FCLayerZOrder(DWORD(0), DWORD(0)) _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_lzorder_xZkqqHx_iCmJ_xHqqkZx_LAST_LAYER_ORDER
 *			_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::FirstBackLZOrder (FCLayerZOrder& lzorder, WORD wOption,
										const FCLayerZOrder& lzFrom) const
{
	lzorder = lzFrom;
	for (;;)
	{
		if (!GetObjOrder(lzorder.dwLayerIdx)->empty() &&
			(m_vLayerTable[lzorder.dwLayerIdx].m_wFlag & wOption) == wOption)
		{
			break;
		}
		lzorder.dwLayerIdx++;
		lzorder.dwZOrder = DWORD(0);
		if (GetLayerSize() <= lzorder.dwLayerIdx)
		{
			lzorder.dwLayerIdx = DWORD(-1);
			lzorder.dwZOrder = DWORD(-1);
			break;
		}
	}
} // FCLayerManager::FirstBackLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::NextFrontLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	lzorder_xZkqqHx_iCpAiIoKiCmCiPoDiCmJiBgJiMoDiCoLiCmJiBgKjAgJiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:_xZkqqHx_jAgJiCnPiCoJjCgMiCpAiOhHjCoIiBeCjAgJiCnPiClNjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iClBiCoKiImIiPoDjAgJiCnPiCoHiCoKiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_lzorder _xZkqqHx_iCmJ_xHqqkZx_{DWORD(-1),DWORD(-1)}_xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::NextFrontLZOrder (FCLayerZOrder& lzorder, WORD wOption) const
{
	lzorder.dwZOrder++;
	while (GetObjOrder(lzorder.dwLayerIdx)->size() <= lzorder.dwZOrder ||
			(m_vLayerTable[lzorder.dwLayerIdx].m_wFlag & wOption) != wOption)
	{
		lzorder.dwLayerIdx++;
		if (GetLayerSize() <= lzorder.dwLayerIdx)
		{
			lzorder.dwLayerIdx = DWORD(-1);
			lzorder.dwZOrder = DWORD(-1);
			return;
		}
		lzorder.dwZOrder = 0;
	}
} // FCLayerManager::NextFrontLZOrder.

//----------<NOT EXPORT TO VIEWER>-----------

//----- 05.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////////////////////////////////////////////////////////////////////////////////
//// _xZkqqHx_iImIiJlKiCmMiKnGjAjEiCmMiDhNiDeOiDiNjDfHiKeKiCmMiCfAjHoBiBeC_xHqqkZx_
//// 
//// /*************************************************************************
////  * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::IsUsedSColor
////  *
////  * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiJlKiCmMjCiGiKnEiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCmJjBmOiClFiCmEiBeBiOhHjCoIiCmM_xHqqkZx_SColor_xZkqqHx_iCkKiOgHiCoNiCoKiCmE_xHqqkZx_
////  *			_xZkqqHx_iCkCiCoJiCkJiCmHiCkEiCkJiCpAjGoCiCkCiNiHiCoNiClJiCoJiBeC_xHqqkZx_
////  *
////  * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	val	:SColorID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
////  *
////  * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIoKiCmCiCmFiCoAiOgHiCoNiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
////  *
////  * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
////  *************************************************************************/
//// BOOL FCLayerManager::IsUsedSColor (SColorID val) const
//// {
//// 	//----- _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLiCmMiMjPiNlI_xHqqkZx_ -----
////     ObjDynabaseVector::const_iterator iObj;
////     for (DWORD dwC = 1; dwC < m_vLayerTable.size() - 1; dwC++)
////     {
////         for (iObj = m_vLayerTable[dwC].m_pvLayer->begin();
////              iObj != m_vLayerTable[dwC].m_pvLayer->end(); iObj++)
////         {
////             if ((*iObj)->IsUsedSColor(val)) return TRUE;
////         }
////     }
////     return FALSE;
//// }
//// 
////////////////////////////////////////////////////////////////////////////////
//
//#define MYISUSED(x) \
//BOOL FCLayerManager::IsUsed##x (x##ID val) const \
//{ \
//	ObjDynabaseVector::const_iterator iObj; \
//	for (DWORD dwC = 1; dwC < m_vLayerTable.size() - 1; dwC++) \
//	{ \
//		for (iObj = m_vLayerTable[dwC].m_pvLayer->begin(); \
//			 iObj != m_vLayerTable[dwC].m_pvLayer->end(); iObj++) \
//		{ \
//			if ((*iObj)->IsUsed##x(val)) return TRUE; \
//		} \
//	} \
//	return FALSE; \
//} \
//
//MYISUSED(SColor)
//MYISUSED(EmfImage)
//MYISUSED(BrushRegister)
//MYISUSED(PenRegister)
//MYISUSED(PenStyle)
//MYISUSED(SFont)
//MYISUSED(PictArrow)
//
//#undef MYISUSED
//----- 05.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::CallForAllObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmJjBmOiClFiCmEiBeBiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	func	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			data	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCkK_xHqqkZx_FALSE_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCkK_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClFiClNiPoKiNiHiCmNiBeBiClLiClBiCmFiPiIjHjNiCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCLayerManager::CallForAllObject (FuncForAllObject func, void* data) const
{
	ObjDynabaseVector::const_iterator iObj;
	for (DWORD dwC = 1; dwC < m_vLayerTable.size() - 1; dwC++)
	{
		for (iObj = m_vLayerTable[dwC].m_pvLayer->begin();
			 iObj != m_vLayerTable[dwC].m_pvLayer->end(); iObj++)
		{
			if (!(*func)(*iObj, data)) return FALSE;
		}
	}
	return TRUE;
} // FCLayerManager::CallForAllObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::GetTopObjOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
ObjDynabaseVector* FCLayerManager::GetTopObjOrder () const
{
	return m_vLayerTable.back().m_pvLayer;
} // FCLayerManager::GetTopObjOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::NextFrontLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	lzorder_xZkqqHx_iCpAiIoKiCmCiPoDiCmJiBgJiMoDiCoLiCmJiBgKjAgJiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:_xZkqqHx_jAgJiCnPiCoJjCgMiCpAiOhHjCoIiBeCjAgJiCnPiClNjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iClBiCoKiImIiPoDjAgJiCnPiCoHiCoKiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_lzorder _xZkqqHx_iCmJ_xHqqkZx_{DWORD(-1),DWORD(-1)}_xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::NextFrontLZOrder (FCLayerZOrder& lzorder) const
{
	lzorder.dwZOrder++;
	if (GetObjOrder(lzorder.dwLayerIdx)->size() <= lzorder.dwZOrder)
	{
		lzorder.dwZOrder = 0;
		do
		{
			lzorder.dwLayerIdx++;
			if (GetLayerSize() <= lzorder.dwLayerIdx)
			{
				lzorder.dwLayerIdx = DWORD(-1);
				lzorder.dwZOrder = DWORD(-1);
				break;
			}
		} while (GetObjOrder(lzorder.dwLayerIdx)->empty());
	}
} // FCLayerManager::NextFrontLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::UpdateLZHashTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCmMjCgMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:_xZkqqHx_iNfIjAfGiClHiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::UpdateLZHashTable (const FCLayerZOrder& lzorder)
{
	// _xZkqqHx_jBlGiNnNiClFiCmIiCkC_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (GetObjOrder(lzorder.dwLayerIdx)->size() <= lzorder.dwZOrder) return;
	DWORD dwLZHash;
	if (lzorder.dwLayerIdx == long(GetLayerSize()) - 1)
		dwLZHash = 0xffff0000;
	else
		dwLZHash = DWORD(lzorder.dwLayerIdx & 0x0000ffff) << 16;
	dwLZHash |= lzorder.dwZOrder & 0x0000ffff;
	// _xZkqqHx_jFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCmJjCmHiJmBiBeC_xHqqkZx_
	(*m_mpLZHash)[LZOrderToObjDynabase(lzorder)] = dwLZHash;
} // FCLayerManager::UpdateLZHashTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::UpdateLZHashTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCmMjCgMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorderFrom	:_xZkqqHx_iNfIjAfGiClHiCoJjEmNiImNiCmMiNmFiPiJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lzorderUntil:_xZkqqHx_iNfIjAfGiClHiCoJjEmNiImNiCmMiNmFiMoDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	[lzorderFrom, lzorderUntil]_xZkqqHx_iCpAiNfIjAfGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::UpdateLZHashTable (FCLayerZOrder lzorderFrom,
										FCLayerZOrder lzorderUntil)
{
	while (lzorderFrom <= lzorderUntil)
	{
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCmJjCmHiJmBiBeC_xHqqkZx_
		UpdateLZHashTable(lzorderFrom);
		NextFrontLZOrder(lzorderFrom);
		if (lzorderFrom.dwLayerIdx == DWORD(-1)) break;
	}
} // FCLayerManager::UpdateLZHashTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCLayerManager::EraseFromLZHashTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCkJiCoHjFjEjFgJiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iNoNiPjMiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCLayerManager::EraseFromLZHashTable (const FCObjDynabase* pObj)
{
	// _xZkqqHx_jFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCkJiCoHiBeBiClBiCmMjFjEjFgJiCmJiKnGiClHiCoJiDiMiDfCiBfLiDgIiCpAjGjFiPmBiBeC_xHqqkZx_
	m_mpLZHash->erase(pObj);
} // FCLayerManager::EraseFromLZHashTable.

