// ListCtrlUserId.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include <algorithm>			// For reverse template.
#include "DynamicDraw.h"
#include "RegData.h"			// For SaveRegBinary.etc.
#include "HiProject.h"		// For operator < (GUID, GUID).
#include "UtilMisc.h"				// For FFGetGuidCheckCode.
#include "UtilStr.h"			// For FFGuidToString.
#include "UtilWin.h"			// For FFInsertColumn.
#include "ListCtrlUserId.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCListCtrlUserId

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::CFCListCtrlUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCListCtrlUserId::CFCListCtrlUserId ()
{
	// _xZkqqHx_iDfMiBfLiDgHiCmJiOgHiCmBiCmEiCkCiCoJiDeKiDiJiDiAiBeC_xHqqkZx_
	m_lSortColumn = 1;
	// _xZkqqHx_iLhEjFpLiMpMiCnGiCmMiDfMiBfLiDgHiCkJiBeI_xHqqkZx_
	m_lSortReverse = 0;
} // CFCListCtrlUserId::CFCListCtrlUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::~CFCListCtrlUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCListCtrlUserId::~CFCListCtrlUserId ()
{
} // CFCListCtrlUserId::~CFCListCtrlUserId.

BEGIN_MESSAGE_MAP(CFCListCtrlUserId, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCListCtrlUserId)
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnclick)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCListCtrlUserId _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpRegSection	:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiLeMjIfOiClHiCoJiDfKiDeOiDfGiDiHiDjDjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iDfKiDeOiDfGiDiHiDjDjGlMiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpRegName		:_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiLeMjIfOiClHiCoJjGlMjBePiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiLeMjIfOiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlUserId::Initialize (const wchar_t* wcpRegSection, const wchar_t* wcpRegName)
{
	if (wcpRegSection == NULL)
		m_wstrRegSection.Empty();
	else
		m_wstrRegSection = wcpRegSection;
	if (wcpRegName == NULL)
		m_wstrRegName.Empty();
	else
		m_wstrRegName = wcpRegName;

	// _xZkqqHx_jBfDiDeKiDiJiDiAjBeJjBpAiCmMiKgHjCkDiDfIiDfOiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	SetExtendedStyle(GetExtendedStyle()|LVS_EX_FULLROWSELECT);

	// _xZkqqHx_iDhHiDgCiDfPiDeDiDiBiBfLiDfHiDiKiDfIiDgHiBeC_xHqqkZx_
	m_imageHeadList.Create(10, 10, ILC_MASK, 2, 2);
	m_imageHeadList.Add(AfxGetApp()->LoadIcon(IDI_SORT_MARK));		// Image 0.
	m_imageHeadList.Add(AfxGetApp()->LoadIcon(IDI_SORT_REV_MARK));	// Image 1.
	// _xZkqqHx_iDhHiDgCiDfPjHhAiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	CHeaderCtrl* pHdrCtrl= GetHeaderCtrl();
	pHdrCtrl->SetImageList(&m_imageHeadList);

	//----- _xZkqqHx_iDeKiDiJiDiAiCmMjAnNjCoI_xHqqkZx_ -----
	CRect rect;
	GetClientRect(rect);
	// IDS_USER_NAME = "_xZkqqHx_jFlGiPjBjGlM_xHqqkZx_"
	// IDS_USER_ID = "_xZkqqHx_jFlGiPjB_xHqqkZx_ID"
	long lRectWidth = rect.Width() - 24;
	long lWidth0 = lRectWidth * 1 / 3;
	long lWidth1 = (lRectWidth - lWidth0);
	FFInsertColumn(this, 0, FFLoadWString(IDS_USER_NAME), LVCFMT_LEFT, lWidth0);
	FFInsertColumn(this, 1, FFLoadWString(IDS_USER_ID), LVCFMT_LEFT, lWidth1);
} // CFCListCtrlUserId::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::AddUser
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidUserId	:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpUserName	:_xZkqqHx_iDiGiBfLiDfFjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlUserId::AddUser (const GUID& guidUserId, const wchar_t* wcpUserName)
{
	m_mpUserIdToUserName[guidUserId] = wcpUserName;
	// _xZkqqHx_jDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiCpAiNmEjFfMiOkGiClHiCoJiBeC_xHqqkZx_
	UpdateRegisteredList();
} // CFCListCtrlUserId::AddUser.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::DelUser
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidUserId	:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlUserId::DelUser (const GUID& guidUserId)
{
	m_mpUserIdToUserName.erase(guidUserId);
	// _xZkqqHx_jDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiCpAiNmEjFfMiOkGiClHiCoJiBeC_xHqqkZx_
	UpdateRegisteredList();
} // CFCListCtrlUserId::DelUser.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::ClearUser
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiPoOjFpBiCpAiClHiCnHiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlUserId::ClearUser ()
{
	m_mpUserIdToUserName.clear();
	// _xZkqqHx_jDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiCpAiNmEjFfMiOkGiClHiCoJiBeC_xHqqkZx_
	UpdateRegisteredList();
} // CFCListCtrlUserId::ClearUser.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::GetSelectedUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiNhDiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stGuidUserId	:_xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiNhDiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlUserId::GetSelectedUserId (set<GUID>& stGuidUserId) const
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
	stGuidUserId.clear();
	const long lLineCount = GetItemCount();
	long lC;
	for (lC = 0; lC < lLineCount; lC++)
	{
		// _xZkqqHx_iNhDiCmMiPpDjBnEiBgJ_xHqqkZx_SELECTED_xZkqqHx_iBgKiCpAiOoGjDlOiBeC_xHqqkZx_
		UINT dwItemState = GetItemState(lC, LVIS_SELECTED);
		if (dwItemState & LVIS_SELECTED)
		//----- _xZkqqHx_jBeJjBpAiPpDjBnEiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeKiDiJiDiAiCfAiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_jFlGiOjKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
			WString wstrUserId = TStrToWStr(GetItemText(lC, 1));
			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_jFlGiOjKjHpBiCpAiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmJjFmPiKlHiBeC_xHqqkZx_
			stGuidUserId.insert(FFStringToGuid(wstrUserId));
		}
	}
} // CFCListCtrlUserId::GetSelectedUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::UserIdToUserName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmJjBmOiJjOiClHiCoJiDiGiBfLiDfFjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidUserId	:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmJjBmOiJjOiClHiCoJiDiGiBfLiDfFjGlMiBeCiOhHjCoIiClDiCoKiClNiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CFCListCtrlUserId::UserIdToUserName (const GUID& guidUserId) const
{
	map<GUID, WString>::const_iterator iUn;
	iUn = m_mpUserIdToUserName.find(guidUserId);
	return (iUn != m_mpUserIdToUserName.end()) ? (*iUn).second : NULL;
} // CFCListCtrlUserId::UserIdToUserName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::GetUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJjBfDiCmEiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stUserId	:_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlUserId::GetUserId (set<GUID>& stUserId) const
{
	stUserId.clear();
	map<GUID, WString>::const_iterator iUn;
	for (iUn = m_mpUserIdToUserName.begin(); iUn != m_mpUserIdToUserName.end(); iUn++)
		stUserId.insert((*iUn).first);
} // CFCListCtrlUserId::GetUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::GetUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmJjAnNjCoIiClDiCoKiCmEiCkCiCoJiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lItem	:_xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
GUID CFCListCtrlUserId::GetUserId (long lItem) const
{
	// _xZkqqHx_iDeKiDiJiDiAiCfAiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_jFlGiOjKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
	const WString wstrUserId = TStrToWStr(GetItemText(lItem, 1));
	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_jFlGiOjKjHpBiCpAiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmJjFmPiKlHiBeC_xHqqkZx_
	return FFStringToGuid(wstrUserId);
} // CFCListCtrlUserId::GetUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::UpdateRegistory
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMiDgGiBfLiDfOiCpAiDiMiDfHiDfIiDgHiDiKiCmJiDfKiBfLiDhFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlUserId::UpdateRegistory ()
{
	WString wstr;
	WString wstrList;
	// _xZkqqHx_iDfMiBfLiDgHjCiGiCmMiDeKiDiJiDiAiBeC_xHqqkZx_
	wstr.Format(L"%ld", m_lSortColumn);
	::FFAppendString(wstrList, wstr);
	// _xZkqqHx_iDfMiBfLiDgHjCiGiCmMiDeKiDiJiDiAiCmNiLhEiDfMiBfLiDgHiCkJiBeI_xHqqkZx_
	wstr.Format(L"%ld", m_lSortReverse);
	::FFAppendString(wstrList, wstr);
	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID->_xZkqqHx_iDiGiBfLiDfFjGlM_xHqqkZx_ _xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_
	map<GUID, WString>::const_iterator iUn;
	for (iUn = m_mpUserIdToUserName.begin(); iUn != m_mpUserIdToUserName.end(); iUn++)
	{
		::FFAppendString(wstrList, FFGuidToString((*iUn).first));
		::FFAppendString(wstrList, (*iUn).second);
	}
	g_pReg->SaveRegString(m_wstrRegSection, m_wstrRegName, wstrList);
} // CFCListCtrlUserId::UpdateRegistory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::UpdateControl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiDgGiBfLiDfOiCpAiDiNiBfLiDgIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlUserId::UpdateControl ()
{
	//----- _xZkqqHx_iKgFiDfCiDjDiDgHiDiNiBfLiDiLiCmMiDgGiDhEiDeIiDiLiDgHjCgMiCpAjAnNjCoI_xHqqkZx_ -----
	WString wstrList;
	g_pReg->LoadRegString(m_wstrRegSection, m_wstrRegName, wstrList);
	WString wstr;
	// _xZkqqHx_iDfMiBfLiDgHjCiGiCmMiDeKiDiJiDiAiBeC_xHqqkZx_
	wstr = FFExtractString(wstrList);
	m_lSortColumn = wcstol(wstr, NULL, 10);
	// _xZkqqHx_iDfMiBfLiDgHjCiGiCmMiDeKiDiJiDiAiCmNiLhEiDfMiBfLiDgHiCkJiBeI_xHqqkZx_
	wstr = FFExtractString(wstrList);
	m_lSortReverse = wcstol(wstr, NULL, 10);
	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID->_xZkqqHx_iDiGiBfLiDfFjGlMiBeC_xHqqkZx_
	m_mpUserIdToUserName.clear();
	while (!wstrList.IsEmpty())
	{
		wstr = FFExtractString(wstrList);
		GUID guidUserId = FFStringToGuid(wstr);
		wstr = FFExtractString(wstrList);
		m_mpUserIdToUserName[guidUserId] = wstr;
	}
	// _xZkqqHx_jDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiCpAiNmEjFfMiOkGiClHiCoJiBeC_xHqqkZx_
	UpdateRegisteredList();
} // CFCListCtrlUserId::UpdateControl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::UpdateRegisteredList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiCpAiNmEjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlUserId::UpdateRegisteredList ()
{
	// _xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiNhDiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	set<GUID> stSelectedUserId;
	GetSelectedUserId(stSelectedUserId);

	// _xZkqqHx_iDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	DeleteAllItems();

	//----- _xZkqqHx_iDeKiDiJiDiAiCmJiDfMiBfLiDgHiCpAiOkGiClHiDeBiDeDiDfCiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	CHeaderCtrl* pHdrCtrl= GetHeaderCtrl();
	long lC;
	for (lC = 0; lC < pHdrCtrl->GetItemCount(); lC++)
	{
		HD_ITEM curItem;
		if (lC == m_lSortColumn)
		//----- _xZkqqHx_iDfMiBfLiDgHjCiGiCmMiDeKiDiJiDiAiCmMiPoKiNiH_xHqqkZx_ -----
		{
			curItem.mask= HDI_IMAGE | HDI_FORMAT;
			curItem.iImage= m_lSortReverse;
			curItem.fmt= HDF_LEFT | HDF_IMAGE | HDF_STRING | HDF_BITMAP_ON_RIGHT;
		} else
		//----- _xZkqqHx_iDfMiBfLiDgHjCiGiCmMiDeKiDiJiDiAiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			curItem.mask= HDI_FORMAT;
			curItem.fmt= HDF_LEFT | HDF_STRING;
		}
		pHdrCtrl->SetItem(lC, &curItem);
	}
	// _xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
	if (m_mpUserIdToUserName.empty()) return;

	vector<GUID> vUserId;
	switch (m_lSortColumn)
	{
	case 0:	// _xZkqqHx_iDiGiBfLiDfFjGlMiBeC_xHqqkZx_
	  {
		multimap<WString, GUID> mpStrToId;
		map<GUID, WString>::const_iterator iUn;
		for (iUn = m_mpUserIdToUserName.begin(); iUn != m_mpUserIdToUserName.end(); iUn++)
			mpStrToId.insert(pair<WString, GUID>((*iUn).second, (*iUn).first));
		multimap<WString, GUID>::const_iterator iSi;
		for (iSi = mpStrToId.begin(); iSi != mpStrToId.end(); iSi++)
			vUserId.push_back((*iSi).second);
		break;
	  }
	default:	// case 1:	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	  {
		map<GUID, WString>::const_iterator iUn;
		for (iUn = m_mpUserIdToUserName.begin(); iUn != m_mpUserIdToUserName.end(); iUn++)
			vUserId.push_back((*iUn).first);
		break;
	  }
	}
	// _xZkqqHx_iLhEiPiHiCmMiPoKiNiHiCmNiBeBiDiKiDgPiBfLiDfIiClHiCoJiBeC_xHqqkZx_
	if (m_lSortColumn != -1 && m_lSortReverse == 1)
		reverse(vUserId.begin(), vUserId.end());

	// _xZkqqHx_iDfMiBfLiDgHiNmPiCnNiCmMjEhKjHpBiCmMiPiHiCmJiBeBiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmJ_xHqqkZx_
	// _xZkqqHx_iDiMiDfCiBfLiDgIiNhDiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_

	for (lC = 0; lC < vUserId.size(); lC++)
	{
		FFInsertItem(this, lC, UserIdToUserName(vUserId[lC]));
		FFSetItemText(this, lC, 1, FFGuidToExString(vUserId[lC]));
	}
	for (lC = 0; lC < vUserId.size(); lC++)
	{
		// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjAnNjCoIiBeC_xHqqkZx_
		if (stSelectedUserId.find(vUserId[lC]) != stSelectedUserId.end())
			SetItemState(lC, LVIS_SELECTED, LVIS_SELECTED);
	}
} // CFCListCtrlUserId::UpdateRegisteredList.

/////////////////////////////////////////////////////////////////////////////
// CFCListCtrlUserId _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlUserId::OnColumnclick
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiJiDiAiCkKiDeOiDiKiDgCiDeOiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlUserId::OnColumnclick (NMHDR* pNMHDR, LRESULT* pResult)
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	// _xZkqqHx_iMlLiNnNiDfMiBfLiDgHjCiGiCmMiDeKiDiJiDiAiCpAiDeOiDiKiDgCiDeOiClFiClNiPoKiNiHiCmNiBeBiDfMiBfLiDgHiCpAiLhEiPiHiCmJiBeC_xHqqkZx_
	if (m_lSortColumn == pNMListView->iSubItem)
	{
		// _xZkqqHx_iDfMiBfLiDgHiCmJiOgHiCmBiCmEiCkCiCoJiDeKiDiJiDiAiBeC_xHqqkZx_
		m_lSortReverse = !m_lSortReverse;
	} else
	{
		// _xZkqqHx_iDfMiBfLiDgHiCmJiOgHiCmBiCmEiCkCiCoJiDeKiDiJiDiAiBeC_xHqqkZx_
		m_lSortColumn = pNMListView->iSubItem;
		// _xZkqqHx_iLhEjFpLiMpMiCnGiCmMiDfMiBfLiDgHiCkJiBeI_xHqqkZx_
		m_lSortReverse = 0;
	}
	// _xZkqqHx_jDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiCpAiNmEjFfMiOkGiClHiCoJiBeC_xHqqkZx_
	UpdateRegisteredList();

	*pResult = 0;
} // CFCListCtrlUserId::OnColumnclick.
