#$allfile = `dir *.cpp *.h *.pltp_* *.pl_* *.pl`;
$allfile = `dir *.cpp *.h`;
#$allfile = `dir FoundDoc.cpp`;
#$allfile = `dir *.cpp *.h *.pltp_* *.pl_* *.pl *.rc`;
#$allfile = `dir *.pl_cpp *.pl_h`;
@lines = split /\n/, $allfile;
@lines = grep /^\d/, @lines;

#$/ = "";	# Paragraph mode.

WID:foreach $i (@lines)
{
	$i =~ s/^\S+\s+\S+\s+\S+\s+(.+)$/$1/;
	next WID if ($i eq 'FdExtern.h');
	next WID if ($i eq 'FdExtern.cpp');
	print "Convert $i ....";
	$fin = $i.".Old";
	if (rename($i, $fin) == 0) { die "Cannot rename $i to $fin\n"; }
	$fout = $i;

	open(FDIN, "${fin}") || die "Cannot open ${fin}\n";
	open(FDOUT, ">${fout}") || die "Cannot open ${fout}\n";

	$state = "S_0";
	while (<FDIN>)
	{
		if ($state eq "S_0")
		{
			if (/^\w[\w\s_\&\*]+\s[\w_]+::AssertValid\s*\(.*\)\s+const\s*$/)
			{
				$state = "S_0";
			} elsif (/^\w[\w\s_\&\*]+\s[\w_]+::Dump\s*\(.*\)\s+const\s*$/)
			{
				$state = "S_0";
			} elsif (/^\w[\w\s_\&\*]+\s[\w_]+::[\w_]+\s*\(.*\)\s*$/)
			{
				$state = "S_2";
			} elsif (/^\w[\w\s_\&\*]+\s[\w_]+::[\w_]+\s*\(.*\)\s+const\s*$/)
			{
				$state = "S_2";
			} elsif (/^\w[\w\s_\&\*]+\s[\w_]+::[\w_]+\s*\(.*,\s*$/)
			{
				$state = "S_1";
			}
		} elsif ($state eq "S_1")
		{
			if (/^\s+\w[\w\s_\&\*\[\],]+,\s*$/)
			{
				$state = "S_1";
			} elsif (/^\s+\w[\w\s_\&\*\[\],]+\)\s*$/)
			{
				$state = "S_2";
			} elsif (/^\s+\w[\w\s_\&\*\[\],]+\)\s+const\s*$/)
			{
				$state = "S_2";
			} else
			{
				$state = "S_0";
			}
		} elsif ($state eq "S_2")
		{
			if (/^\{\s*$/)
			{
				$state = "S_3";
			} else
			{
				$state = "S_0";
			}
		} else
		{
			if (!/^\tFDM_TRACE/)
			{
				print FDOUT "\tFDM_TRACE(__FILE__, __LINE__);\n";
			}
			$state = "S_0";
		}
		print FDOUT;
	}
	close FDIN;
	close FDOUT;
	print "OK\n";
}
