#include "stdafx.h"
#include "resource.h"	// For ProObjPoly.h.
#include <math.h>		// for sqrt.
#include "FoundDoc.h"	// For RegisterObject.
#include "LinkManager.h"// For LinkManager.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilMath.h"	// For mmroundoff.
#include "UtilMisc.h"		// For CalcBezier.
#include "UtilBezier.h"	// For CalcBezierMid.
#include "Arrow.h"		// For FCStdArrow.
#include "RegData.h"	// For GetOptiRegColor.
#include <algorithm>	// For sort,unique template.
#include "UndoArchive.h"	// For FCUndoArchive.
#include "ProObjPoly.h"	// For CFCProObjPoly.
#include "RichText.h"	// For GetRichText().
#include "ObjPoly.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::FCObjPoly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *************************************************************************/
FCObjPoly::FCObjPoly ()
{
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// m_mmrtResize_xZkqqHx_iCmN_xHqqkZx_double_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjPoly, m_mmrtResize));
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	memset(&m_mmrtResize, 0, sizeof(FCObjPoly) - offsetof(FCObjPoly, m_mmrtResize));
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDiKiDjDiDeOiInKjDkOiOjOiCmMjIeBiMiLjDfPiNmEjEhKjChFjFpLjGeAiBeCjIeBiMiLjDfPiInKjDkOiCmNjGlDiCkCiBeC_xHqqkZx_
	m_byLinkMoveType = FDOP_LMTYPE_NONE;
	// _xZkqqHx_iKeKiOgOjDfPiInKjDkOiOjOiCmMjHnHjAnKjDfPiCmMiInKjDkOiMgAiOkOiBeC_xHqqkZx_
	m_byBgnMoveStyle = FDOP_LMSTYL_NONE;
	// _xZkqqHx_iPeJjHlJjDfPiInKjDkOiOjOiCmMjHnHjAnKjDfPiCmMiInKjDkOiMgAiOkOiBeC_xHqqkZx_
	m_byEndMoveStyle = FDOP_LMSTYL_NONE;
	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiA_xHqqkZx_.
	m_mmrtResize = mmroundoff(DBLRect(0,0,0,0));
	// _xZkqqHx_iKeKiLmIjApMiBeC_xHqqkZx_
	m_bIsOpenPolyJoint = TRUE;
	m_lJoint = 0;
	m_pJoint = NULL;
} // FCObjPoly::FCObjPoly.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	: _xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	: _xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoly::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_POLY) return TRUE;
	return BASE_CLASS::IsKindOf(nType);
} // FCObjPoly::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjFjEjFgJiCmMiMfOiCpAjFnEiClH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiMfO_xHqqkZx_
 *************************************************************************/
FTObjectType FCObjPoly::Type () const
{
	return FDOJ_POLY;
} // FCObjPoly::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jCgMiCmMjAlDiKgNiClDiCmGiOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *************************************************************************/
DBLRect FCObjPoly::GetResizeFrame () const
{
	return m_mmrtResize;
} // FCObjPoly::GetResizeFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetOuterFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeCjApMiCkKiCkAiCoKiCmOiClLiCmMjFjNiCoAiNgMjHlGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeCjCgMiCmJiCmNiCkAiCoJjCpGjDhIiMoLiNlHiCkKiCkAiCmBiCmEiCoAiCoGiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiDfEiDeDiDfJiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiMhGiOfKiCmN_xHqqkZx_ ObjFigure::GetOuterFrame _xZkqqHx_iCmFiJmCjEfMiClOiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_jIeBiMiLjDfP_xHqqkZx_ = 0 _xZkqqHx_iCmMiPiIjHjNiCkKjFeLjHhGiCmIiClNiCnPiBeBiClBiCmMiKnGjAjEiCpAjCmHiJmBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.23 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
DBLRect FCObjPoly::GetOuterFrame () const
{
	// _xZkqqHx_jIeBiMiLjDfPiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeCiDgDiBfLiDiLjDoAjFjEjFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeCjFmPiNfIiCmJjBmOiJjOiBeC_xHqqkZx_
	if (m_lJoint == 0) return DBLRect(0,0,1,1);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::GetOuterFrame();
} // FCObjPoly::GetOuterFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::IsEqual
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiKkOjBfDiCmJjDjJiClFiCkCiCmMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkNiBeBiLeAjEfMjDeJiCmJjDjJiClFiCkCiClBiCmGiCpAjClCiCnHiCoJiBeCjHoBiCkGiCmOiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNjEoEiKhCiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_jEoEiKhCjAoGiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDjJiClFiCkCiPoKiNiHiBeB_xHqqkZx_ FALSE  :_xZkqqHx_iIoBiCkEiPoKiNiH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClI_xHqqkZx_BASE_CLASS_xZkqqHx_iCmMjEoEiKhCiCpAiClHiCoJiBeCiClLiCmMiOjPiCmJiOkJjFkKiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_ObjDynabase::IsEqual_xZkqqHx_iCmFiDeOiDiJiDfIiCmMiMfOiCpAjEoEiKhCiClHiCoJiCmMiCmFiBeB_xHqqkZx_
 *			BASE_CLASS::IsEqual_xZkqqHx_iCkK_xHqqkZx_TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiMfOiCmNjDjJiClFiCkCiCmGiClFiCmEiCoGiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoly::IsEqual (const FCObjDynabase* objp) const
{
	if (!BASE_CLASS::IsEqual(objp)) return FALSE;
	const FCObjPoly* trgp = static_cast<const FCObjPoly*>(objp);
	if (memcmp(&m_mmrtResize, &trgp->m_mmrtResize,
			offsetof(FCObjPoly, m_pJoint) -
				offsetof(FCObjPoly, m_mmrtResize)) != 0) return FALSE;
	if (m_lJoint != trgp->m_lJoint) return FALSE;
	return (memcmp(m_pJoint, trgp->m_pJoint,
					m_lJoint * sizeof(FCPolyJoint)) == 0);
} // FCObjPoly::IsEqual.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjPoly::OutStream (FCUndoArchive& ar)
void FCObjPoly::OutStream (FCUndoArchive& ar, BOOL bIsOutBezier)
{
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BASE_CLASS::OutStream(ar);
	BASE_CLASS::OutStream(ar, bIsOutBezier);
	ar << m_mmrtResize;			// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiA_xHqqkZx_.
	ar << m_wLinkMoveStream;	// _xZkqqHx_iDiKiDjDiDeOiInKjDkOiOjOiCmMjIeBiMiLjDfPiNmEjEhKjChFjFpLjGeAiBeC_xHqqkZx_
	ar << m_bIsOpenPolyJoint;	// _xZkqqHx_iKeKiLmIjApMiCkJiBeI_xHqqkZx_
	ar << m_lJoint;				// _xZkqqHx_jIeBiMiLjDfPiCmMjAjEiBeC_xHqqkZx_
	for (long ll = 0; ll < m_lJoint; ll++)
		m_pJoint[ll].OutStream(ar);		// _xZkqqHx_jIeBiMiLjDfPiBeC_xHqqkZx_
} // FCObjPoly::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void FCObjPoly::InStream (FCUndoArchive& ar)
{
	BASE_CLASS::InStream(ar);
	// _xZkqqHx_iKpJjBlGiCmMjIeBiMiLjDfPiCpAiNoNiPjMiBeC_xHqqkZx_
	if (m_pJoint != NULL) delete[] m_pJoint;
	ar >> m_mmrtResize;			// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiA_xHqqkZx_.
	ar >> m_wLinkMoveStream;	// _xZkqqHx_iDiKiDjDiDeOiInKjDkOiOjOiCmMjIeBiMiLjDfPiNmEjEhKjChFjFpLjGeAiBeC_xHqqkZx_
	ar >> m_bIsOpenPolyJoint;	// _xZkqqHx_iKeKiLmIjApMiCkJiBeI_xHqqkZx_
	ar >> m_lJoint;				// _xZkqqHx_jIeBiMiLjDfPiCmMjAjEiBeC_xHqqkZx_
	// _xZkqqHx_jIeBiMiLjDfPiCmMjHmMiIoGiCpAjAlGjAkMiBeC_xHqqkZx_
	m_pJoint = new FCPolyJoint[m_lJoint];
	for (long ll = 0; ll < m_lJoint; ll++)
		m_pJoint[ll].InStream(ar);		// _xZkqqHx_jIeBiMiLjDfPiBeC_xHqqkZx_
} // FCObjPoly::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::CreatePropertyPage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiMmFjHeMiCmM_xHqqkZx_PropertyPage_xZkqqHx_iCpAiNoMjAkMiBeFiPiJiKpKiJlLiClFiBeBiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPropPage	: PropertyPage_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiInHiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *			vSelect		: _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiPfHiNiH_xHqqkZx_
 *************************************************************************/
void FCObjPoly::CreatePropertyPage (CPropertyPageVector& vPropPage,
											const ObjDynabaseVector& vSelect)
{
	BASE_CLASS::CreatePropertyPage(vPropPage, vSelect);
	ObjDynabaseVector::const_iterator i;
	for (i = vSelect.begin(); i != vSelect.end(); i++)
		if (!(*i)->IsKindOf(FDOJ_POLY)) return;
	vPropPage.push_back(new CFCProObjPoly());
} // FCObjPoly::CreatePropertyPage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::IsClosePolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	NewObjPolygon_xZkqqHx_iCkKjFnEiClHiDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoly::IsClosePolygon () const
{
	return !m_bIsOpenPolyJoint;
} // FCObjPoly::IsClosePolygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::NewObjPolygonForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiOmAiNmAjFfHiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	: _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			lPolySize	: mmptpPoly_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAjFnEiClH_xHqqkZx_.
 *			bIsClose	: _xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClH_xHqqkZx_.
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	: _xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiH_xHqqkZx_.
 *			iClipSize	: mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmElemLen_xZkqqHx_iCmNiBeBjClIjDfPiNmAjFfHiCpAiMhGiOfKiClHiCoJiOjOiCmJiBeBjHnHiCoIiNiHiCkEjClIjDfPiCmGjClIjDfPiCmM_xHqqkZx_
 *			_xZkqqHx_iKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOkGiClHiBeC_xHqqkZx_mmElemLen_xZkqqHx_iCmMjCgMiCkKiPkMiClDiCkCiCnJiCmHjClIjDfPiKnEiCmM_xHqqkZx_
 *			_xZkqqHx_iLjHjHkDiCmNiLlHiCnMiCoIjAhNiMgAiCmMjAlIjDhIiCmNiMpMiPoDiClHiCoJiCkKiBeBiCoGiCoIjBlNiCkNiCmMiMhGiOfKiOjOiKnEiCmG_xHqqkZx_
 *			_xZkqqHx_iCoGiCoIjBlNiCkNiCmMiDiBiDiCiDiKiCpAjFeLjHhGiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.27 Fukushiro M. _xZkqqHx_jGoOiIpDiCmMiDfEiDeDiDfJiCpAiNgMjHlGiClFiClNiBeC_xHqqkZx_
 *************************************************************************/
void FCObjPoly::NewObjPolygonForDraw (	DBLPointVector& vmmptPoly,
										mmetol mmElemLen,
										const DBLRect mmrtaClip[],
										int iClipSize) const
{
	// _xZkqqHx_jIeBiMiLjDfPiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeCiDgDiBfLiDiLjDoAjFjEjFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeCjFmPiNfIiCmJjBmOiJjOiBeC_xHqqkZx_
	if (m_pJoint == NULL) return;
	long	lEndPoint;
	if (m_bIsOpenPolyJoint)	lEndPoint = m_lJoint - 1;
	else					lEndPoint = m_lJoint;

	DBLRectVector mmrtvClip;
	if (0 < iClipSize)
	//----- _xZkqqHx_iDeOiDiKiDgCiDhGiCkKiCfAiCmCiImIiPoDjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		//---------------------------------------------------------------------
		// _xZkqqHx_jGoOiIpDiCmMiMhGiOfKiCmNiBeBjGoOiIpDiCmMjCfLjDfPiCkJiCoHiNmFjBoFiCmF_xHqqkZx_ P + 0.5W + W _xZkqqHx_iCmMiLjHjHkDiCmMjEmNiImNiCmM_xHqqkZx_
		// _xZkqqHx_jIeBiMiLjDfPiCmMiDhMiDiKiDfDiDjDiCkKjAlDiKgNiCmJiMhGiOfKiClDiCoKiCmEiCkCiCmIiCkCiCmGiBeBjGoOiIpDiCpAiDhMiDiKiDfDiDjDiCmJ_xHqqkZx_
		// _xZkqqHx_jAnKjBlBiClHiCoJiClNiCnPiCmMiMhGiOfKiCkKjAlDiClFiCkNiNhDiCoNiCoKiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiClNiCnPiBeBjGoOiIpDiCmMjCfLjDfPiCpAjCiGjAfDiCmJ_xHqqkZx_ P + 0.5W + W _xZkqqHx_iCmMiLjHjHkDiCpAiCoAiCmCiLoJiMgAiCkK_xHqqkZx_
		// _xZkqqHx_iNmEjFgAiJoGjEmNiImNiCmJjDpMiCoJiCkJiCmHiCkEiCkJiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
		// Arrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
		//---------------------------------------------------------------------
		const double mmWeight = GetStdPenWeight();
		if ((GetArrowFType() != FDUG_ARW_TYPE_FLAT ||
			 GetArrowBType() != FDUG_ARW_TYPE_FLAT) && !IsClosePolygon())
		//----- _xZkqqHx_iKeKiOgOiBeFiPeJjHlJjGoOiIpDiCmMjBoFiCkLiClDiCpAiNgMjHlGiClHiCoJ_xHqqkZx_ -----
		{
			// GetEdgePoint_xZkqqHx_iCmMiMhGiOfKiCmJiCmNiDfCiDfIiDgHiCkKiCkJiCkJiCoJiCmMiCmFiBeBiCnMiClIiCfAiCmCiCmFiCoAjGoOiIpDiCkKiCkAiCoJiCkJiCmHiCkEiCkJjElLjCgGiBeC_xHqqkZx_
			DBLPoint mmptEdgeF;
			DBLPoint mmptEdgeB;
			GetEdgePoint(mmptEdgeF, mmptEdgeB);
			if (GetArrowFType() != FDUG_ARW_TYPE_FLAT)
			{
				DBLRect mmrtArrow;
				if (GetArrowFType() == FDUG_ARW_TYPE_PICT)
				{
					FCPictArrow arrow(GetPictArrowF(), FALSE);
					// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
					arrow.CalcAffectFrame(mmrtArrow, mmptEdgeF, mmWeight, mmWeight);
				} else
				{
					FCStdArrow arrow(FCUGArrowParams(GetArrowFType(), GetArrowFParam0(),
										GetArrowFParam1(), GetArrowFParam2()), FALSE);
					// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
					arrow.CalcAffectFrame(mmrtArrow, mmptEdgeF, mmWeight, mmWeight);
				}
				// _xZkqqHx_iNmFjBoFiJgFiLlPjEmNiImNiCmMiLoJiMgAiCkKiDiKiBfLiDfHiDiHiDjDiCmMiCkCiClIiCoKiCkJiCmGiMpAiNlHiClHiCoJiPoKiNiHiCmNiBeBiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiBeC_xHqqkZx_
				for (long lC = 0; lC < iClipSize; lC++)
				{
					if (!(mmrtaClip[lC] & mmrtArrow).IsRectNull())
					{
						// _xZkqqHx_jCmHiJmBiClHiCoJiLoJiMgAiCmNiBeBjApMjFjNiCmMiNgMjHlGiCmNjFhDjHhGiBeCiImIiMoDiCmM_xHqqkZx_CalcBezier2_xZkqqHx_iCmF_xHqqkZx_
						// _xZkqqHx_iNgMjHlGiClDiCoKiCoJiInHiBeC_xHqqkZx_
						mmrtvClip.push_back(mmrtArrow.ReduceRect(mmWeight / 2.0));
						break;
					}
				}
			}
			if (GetArrowBType() != FDUG_ARW_TYPE_FLAT)
			{
				DBLRect mmrtArrow;
				if (GetArrowBType() == FDUG_ARW_TYPE_PICT)
				{
					FCPictArrow arrow(GetPictArrowB(), FALSE);
					// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
					arrow.CalcAffectFrame(mmrtArrow, mmptEdgeB, mmWeight, mmWeight);
				} else
				{
					FCStdArrow arrow(FCUGArrowParams(GetArrowBType(), GetArrowBParam0(),
										GetArrowBParam1(), GetArrowBParam2()), FALSE);
					// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
					arrow.CalcAffectFrame(mmrtArrow, mmptEdgeB, mmWeight, mmWeight);
				}
				// _xZkqqHx_iNmFjBoFiJgFiLlPjEmNiImNiCmMiLoJiMgAiCkKiDiKiBfLiDfHiDiHiDjDiCmMiCkCiClIiCoKiCkJiCmGiMpAiNlHiClHiCoJiPoKiNiHiCmNiBeBiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiBeC_xHqqkZx_
				for (long lC = 0; lC < iClipSize; lC++)
				{
					if (!(mmrtaClip[lC] & mmrtArrow).IsRectNull())
					{
						// _xZkqqHx_jCmHiJmBiClHiCoJiLoJiMgAiCmNiBeBjApMjFjNiCmMiNgMjHlGiCmNjFhDjHhGiBeCiImIiMoDiCmM_xHqqkZx_CalcBezier2_xZkqqHx_iCmF_xHqqkZx_
						// _xZkqqHx_iNgMjHlGiClDiCoKiCoJiInHiBeC_xHqqkZx_
						mmrtvClip.push_back(mmrtArrow.ReduceRect(mmWeight / 2.0));
						break;
					}
				}
			}
		}
		mmrtvClip.insert(mmrtvClip.end(), mmrtaClip, mmrtaClip + iClipSize);
	}
	double dMinRatio = 0.0;	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiPmIjHkKjHhAiCmMiKoOiPiAjCgMiBeC_xHqqkZx_
	// _xZkqqHx_iDgGiDeCiDfIiDhGiDiMiDeDjFgAiJoGiCmFiCmNiBeBiClIiCoKiCkK_xHqqkZx_dMinRatio_xZkqqHx_iImIjDoAiCmMjDfPiCmNiPmIjHkKiBgJiNiCjBkMiJlLiCmMiInHiBgKiBeC_xHqqkZx_
	// _xZkqqHx_iPmIjHkKiKoOiPiAjCgMiCpAiOfKiPgPiBeCjFjEjFgJiCmMjBoFiCkLiClDiBgJjIfPjHjNiNmAjFfHiBgKiCkJiCoHjElLjCgGiBeC_xHqqkZx_
	if (g_->eDrawWhich == FDDR_DISPLAY)
		dMinRatio = ::StdMinRatio(mm2lg(m_mmrtResize));
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	::CalcBezier2(vmmptPoly, (const FCPolyJoint*)m_pJoint, m_lJoint, GetStdPenWeight(),
//				0L, lEndPoint, mmElemLen, 1.0, mmrtvClip.begin(), mmrtvClip.size(),
//				dMinRatio);
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiBeC_xHqqkZx_
	if (mmElemLen < 0)
		mmElemLen = CalcOptimumElemLen();
	::CalcBezier2(vmmptPoly,
				 (const FCPolyJoint*)m_pJoint, m_lJoint,
				 GetStdPenWeight(),
				 0L, lEndPoint,
				 mmElemLen, 1.0,
				 mmrtvClip.begin(), mmrtvClip.size(),
				 dMinRatio);
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjPoly::NewObjPolygonForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::NewObjBezierForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	: _xZkqqHx_iDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJjFgAiJoGjDjJiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoly::NewObjBezierForDraw (FCMmPolyBezier& polyBezier) const
{
	// _xZkqqHx_jIeBiMiLjDfPiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeCiDgDiBfLiDiLjDoAjFjEjFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeCjFmPiNfIiCmJjBmOiJjOiBeC_xHqqkZx_
	if (m_pJoint == NULL) return;
	FFControlConv(polyBezier, m_pJoint, m_lJoint, m_bIsOpenPolyJoint);
} // FCObjPoly::NewObjBezierForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetEdgePoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFmCiClGiClNjAhNiMgAiCmMiPoKiNiHiCmNiBeBjCgMiCmN_xHqqkZx_DBLPoint(0,0)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoly::GetEdgePoint (DBLPoint& mmptF, DBLPoint& mmptB) const
{
	mmptF = m_pJoint[0].m_mmptPivot;
	mmptB = m_pJoint[m_lJoint - 1].m_mmptPivot;
} // FCObjPoly::GetEdgePoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetMolipPos
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MOLIP_xZkqqHx_iBgJiDiKiDjDiDeOiCpAjCkDiCoJiCmGiCkLjDjJiCmJiOgHjHhAiBgKiCmMiNmAjFfHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipId	:_xZkqqHx_iOoGjDlOiClHiCoJ_xHqqkZx_MOLIP_xZkqqHx_iCmMiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			lTerminalIdx:MOLIP_xZkqqHx_iCmMiDfOiBfLiDhOiDgJiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	MOLIP_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID -1 _xZkqqHx_iCmNiBeBjFjEjFgJiCmMjCiGjAfDiNmAjFfHiCpAiOkGiClFiBeBjBfDiCmEiCmMjFjEjFgJiCkK_xHqqkZx_
 *			_xZkqqHx_iOjNiCmBiCmEiCkCiCoJiDhMiDeDiDjDiDgHiCmFiCkAiCoJiBeCiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCkK_xHqqkZx_0_xZkqqHx_iImIiPoDiCmMiDhMiDeDiDjDiDgHiCmN_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiClCiCmGiCmJiOjNiCmBiCmEiCkCiCoJjAjEiCkKiInJiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNfIiCmJiBeBiKgFiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDiCiDiKiDhGiCmNiBeBjFkBjAjEiCmMiDfOiBfLiDhOiDgJiDiLiDhMiDeDiDjDiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_iOjNiCmCiClBiCmGiCkKiPgPjHiIiCoJiBeCiDfOiBfLiDhOiDgJiDiL_xHqqkZx_Idx = 0 _xZkqqHx_iCmMiDhMiDeDiDjDiDgHiCkKiBeBiClLiCmM_xHqqkZx_
 *			_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID _xZkqqHx_iCmMjAlDiOkOiCmIiDiCiDiKiDhGiImKjChFiBeBiDfOiBfLiDhOiDgJiDiL_xHqqkZx_ID _xZkqqHx_iCkK_xHqqkZx_ 1_xZkqqHx_iImIiPoDiCmM_xHqqkZx_
 *			_xZkqqHx_iDhMiDeDiDjDiDgHiCmNiBeBiDiKiDjDiDeOiOjOiCmMjFoCiPjFjDeJiCmIiDiCiDiKiDhGiImKjChFiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfOiBfLiDhOiDgJiDiL_xHqqkZx_Idx _xZkqqHx_iCkK_xHqqkZx_ 0 _xZkqqHx_iClFiCkJjGlDiCkCiDiCiDiKiDhGiCmFiCmNiBeBiDfOiBfLiDhOiDgJiDiL_xHqqkZx_Idx _xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jCgMiCmNjGlDiOiLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCObjPoly::GetMolipPos (long lMolipId, long lTerminalIdx) const
{
	DBLPoint mmpt;
	if (lMolipId == -1)
	//----- -1_xZkqqHx_iDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		DBLRect mmrt = GetResizeFrame();
		mmpt = mmrt.CenterPoint();
	} else if (lMolipId & 1)
	//----- _xZkqqHx_jCiGiKnEjDfPiCmMiDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jCiGiKnEjDfPiCmMjClMjBePiCmMjIeBiMiLjDfP_xHqqkZx_ID_xZkqqHx_iCpAiMhGiOfKiBeC_xHqqkZx_
		const long lJntID = MolipIDToJointID(lMolipId - 1);
		DBLPoint mmpta4[4];	// _xZkqqHx_iDhIiDfHiDeHiMhGiOfKjHhAiCmMiCfDjDfPiNmAjFfHiBeC_xHqqkZx_
		/*----- _xZkqqHx_iDhIiDfHiDeHiLmIjApMiMhGiOfKiCmJiOgHiCkEiCfDjDfPiCpAiLiBiCnPiCoJ_xHqqkZx_ -----*/
		mmpta4[0] = m_pJoint[lJntID].m_mmptPivot;
		mmpta4[1] = m_pJoint[lJntID].m_mmptPivot + m_pJoint[lJntID].m_mmptNext;
		if (lJntID == m_lJoint - 1)
		// _xZkqqHx_iKeKiOgOjDfPiCmGiPeJjHlJjDfPiCmMjCiGiKnEjDfPiCmMiPoKiNiHiBeC_xHqqkZx_
		{
			mmpta4[2] = m_pJoint[0].m_mmptPivot + m_pJoint[0].m_mmptPrev;
			mmpta4[3] = m_pJoint[0].m_mmptPivot;
		} else
		// _xZkqqHx_jCmKiPoNiCmMjCiGiKnEjDfPiCmMiPoKiNiHiBeC_xHqqkZx_
		{
			mmpta4[2] = m_pJoint[lJntID + 1].m_mmptPivot + m_pJoint[lJntID + 1].m_mmptPrev;
			mmpta4[3] = m_pJoint[lJntID + 1].m_mmptPivot;
		}
		CalcBezierMid(mmpta4, mmpt);
	} else
	//----- _xZkqqHx_jIeBiMiLjDfPiCmMiDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iKeKiLmIjApM_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_jCfLjDfPiCmMiDiCiDiKiDhGiCmMiPoKiNiHiCmN_xHqqkZx_ _xZkqqHx_iDfOiBfLiDhOiDgJiDiLiCkKiCfBiMmCjBlGiNnNiClHiCoJ_xHqqkZx_ -----
		if (lTerminalIdx == 1 && GetIsOpenPolyJoint())
		//----- _xZkqqHx_iKeKiLmIjApM_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_iDfOiBfLiDhOiDgJiDiL_xHqqkZx_ 1 _xZkqqHx_iOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (lMolipId == 0)
			//----- _xZkqqHx_iKeKiLmIjApM_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_iOgOjDfPiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
			{
				DBLPoint mmptOffset = m_pJoint[0].m_mmptNext;
				if (almost0(mmptOffset))
					mmptOffset = (m_pJoint[1].m_mmptPivot + m_pJoint[1].m_mmptPrev) -
											m_pJoint[0].m_mmptPivot;
				if (almost0(mmptOffset))
					mmptOffset.SetPoint(1.0, 1.0);
				mmpt = m_pJoint[0].m_mmptPivot +
						FD_TERMINAL_DISTANCE * mmptOffset / mmptOffset.Len();
			} else
			if (lMolipId == JointIDtoMolipID(GetJointSize() - 1))
			//----- _xZkqqHx_iKeKiLmIjApM_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_iPeJjDfPiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
			{
				DBLPoint mmptOffset = m_pJoint[GetJointSize() - 1].m_mmptPrev;
				if (almost0(mmptOffset))
					mmptOffset = (m_pJoint[GetJointSize() - 2].m_mmptPivot +
										m_pJoint[GetJointSize() - 2].m_mmptNext) -
									m_pJoint[GetJointSize() - 1].m_mmptPivot;
				if (almost0(mmptOffset))
					mmptOffset.SetPoint(1.0, 1.0);
				mmpt = m_pJoint[GetJointSize() - 1].m_mmptPivot +
						FD_TERMINAL_DISTANCE * mmptOffset / mmptOffset.Len();
			} else
			//----- _xZkqqHx_iKeKiLmIjApM_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_iOgOjDfPiBeBiPeJjDfPiImIiKePiCmMiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
			{
				mmpt = m_pJoint[MolipIDToJointID(lMolipId)].m_mmptPivot;
			}
		} else
		{
			mmpt = m_pJoint[MolipIDToJointID(lMolipId)].m_mmptPivot;
		}
	}
	return mmpt;
} // FCObjPoly::GetMolipPos.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetMolipCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MOLIP_xZkqqHx_iBgJiDiKiDjDiDeOiCpAjCkDiCoJiCmGiCkLjDjJiCmJiOgHjHhAiBgKiCmMjAjEiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID -1 _xZkqqHx_iCmMjAjEiCmNiDeKiDeFiDjDiDgHiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjPoly::GetMolipCount () const
{
	// _xZkqqHx_jBlNiKhAjApMiCmMiKeKjFmCiCmJiKnGiCoNiCoHiClIiKeKiOgOjDfPiBhMiPeJjHlJjDfPjCiGiKnEjDfPiCoAiDeKiDeFiDjDiDgHiBeCiClLiCkEiClFiCmIiCkCiCmG_xHqqkZx_
	// _xZkqqHx_jBlNiKhAjApMiCmMiKeKiPiIjHjNiCmFiCkCiClPiCkCiClPiDiKiDjDiDeOiNoNiPjMiCpAiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	return 2 * m_lJoint;
} // FCObjPoly::GetMolipCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetFrontEdgeMolipId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iBeCiKeKiOgOjDfPiDiCiDiKiDhGiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjPoly::GetFrontEdgeMolipId () const
{
	if (GetIsOpenPolyJoint())
		return 0;
	else
		return -1;
} // FCObjPoly::GetFrontEdgeMolipId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetBackEdgeMolipId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iBeCiPeJjHlJjDfPiDiCiDiKiDhGiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjPoly::GetBackEdgeMolipId () const
{
	if (GetIsOpenPolyJoint())
		return JointIDtoMolipID(GetJointSize() - 1);
	else
		return -1;
} // FCObjPoly::GetBackEdgeMolipId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetMolipTerminalCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDiCiDiKiDhGiCmMiBeBiDfOiBfLiDhOiDgJiDiLjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipId	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfOiBfLiDhOiDgJiDiLjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iIoKiCmCiCmMiDiCiDiKiDhGiCmJiCmNiBeBiIoKiCmCiImIiPoDiCmMiDiCiDiKiDhGiImKjChFiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCoHiCmMiDiCiDiKiDhGiImKjChFiCpAiDiCiDiKiDhGiDfOiBfLiDhOiDgJiDiLiDhMiDeDiDjDiDgHiBgJiDfOiBfLiDhOiDgJiDiLiBgK_xHqqkZx_
 *			_xZkqqHx_iCmGiMmEiCnEiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmFiCmNiBeBiOhHjCoIiCmMiDiCiDiKiDhGiCmJjBlGiNnNiClHiCoJiDfOiBfLiDhOiDgJiDiLiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iCnJiCmGiCpBiCmHiCmMiDiCiDiKiDhGiCmFiCmNiBeBiDfOiBfLiDhOiDgJiDiLjAjEiCmN_xHqqkZx_ 1 _xZkqqHx_iMmCiBeC_xHqqkZx_
 *			_xZkqqHx_iDfOiBfLiDhOiDgJiDiLiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_ = 0 _xZkqqHx_iCmMiDfOiBfLiDhOiDgJiDiLiCkKiBeBiClLiCmMiDiCiDiKiDhGiCmM_xHqqkZx_
 *			_xZkqqHx_jAlDiOkOiCmIiDiCiDiKiDhGiImKjChFiCmFiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjPoly::GetMolipTerminalCount (long lMolipId) const
{
	//----- _xZkqqHx_iKeKiLmIjApM_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_jCfLjDfPiCmMiDiCiDiKiDhGiCmMiPoKiNiHiCmN_xHqqkZx_ _xZkqqHx_iDfOiBfLiDhOiDgJiDiLiCkKiCfBiMmC_xHqqkZx_ -----
	if (GetIsOpenPolyJoint())
	{
		if (lMolipId == 0 ||
			lMolipId == JointIDtoMolipID(GetJointSize() - 1))
			return 2;
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::GetMolipTerminalCount(lMolipId);
} // FCObjPoly::GetMolipTerminalCount.

//----- 06.12.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 06.12.07 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::IsThereArea
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmJjGmKjAmPiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGmKjAmPiCkKiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjClCiCnHiCoJiNnLiCmJiOgHiCoNiCoKiCoJiClNiCnPiBeBiPgPjHiIiCoJiClOiCkP_xHqqkZx_
// *			_xZkqqHx_iMhGiOfKjBkMjDhIiCkKjBkMiCkCiClBiCmGiCkKiLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjPoly::IsThereArea () const
//{
//	struct my
//	{
//		my (const FCObjPoly* pPoly)
//		{
//			if (pPoly->IsClosePolygon())
//			//----- _xZkqqHx_jFmCiClGiClNiDhMiDiKiDiJiDeDiDjDiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				m_ctlIdFirst.first = 0;
//				m_ctlIdFirst.second = 0;
//				m_ctlIdEnd.first = pPoly->GetJointSize();
//				m_ctlIdEnd.second = 0;
//			} else
//			//----- _xZkqqHx_iKeKiCkCiClNiDhMiDiKiDiJiDeDiDjDiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				m_ctlIdFirst.first = 0;
//				m_ctlIdFirst.second = 1;
//				m_ctlIdEnd.first = pPoly->GetJointSize() - 1;
//				m_ctlIdEnd.second = 2;
//			}
//		}
//		const pair<long, long>& First () const
//		{
//			return m_ctlIdFirst;
//		}
//		const pair<long, long>& End () const
//		{
//			return m_ctlIdEnd;
//		}
//		void Next (pair<long, long>& ctlId) const
//		{
//			ctlId.second++;
//			if (ctlId.second == 3)
//			{
//				ctlId.first++;
//				ctlId.second = 0;
//			}
//		}
//		DBLPoint GetPoint (	const pair<long, long>& ctlId,
//							const FCPolyJoint* pJoints) const
//		{
//			switch (ctlId.second)
//			{
//			case 0:
//				return pJoints[ctlId.first].GetPrevPullPoint();
//			case 1:
//				return pJoints[ctlId.first].GetPivotPoint();
//			default:
//				return pJoints[ctlId.first].GetNextPullPoint();
//			}
//		}
//
//		pair<long, long>	m_ctlIdFirst;
//		pair<long, long>	m_ctlIdEnd;
//	} My(this);
//
//	BOOL bIsThereArea = FALSE;
//	DBLLine mmlnPrev;
//	pair<long, long> ctlId = My.First();
//	DBLPoint mmptPrev = My.GetPoint(ctlId, GetJoints());
//	BOOL bIsFirst = TRUE;
//	for (My.Next(ctlId); ctlId != My.End(); My.Next(ctlId))
//	{
//		DBLPoint mmptNext = My.GetPoint(ctlId, GetJoints());
//		if (!abouteq(mmptPrev, mmptNext))
//		{
//			if (bIsFirst)
//			{
//				bIsFirst = FALSE;
//				mmlnPrev.SetPoints(mmptPrev, mmptNext);
//				mmptPrev = mmptNext;
//			} else
//			{
//				DBLLine mmlnNext(mmptPrev, mmptNext);
//				if (!abouteq(mmlnPrev, mmlnNext))
//					bIsThereArea = TRUE;
//				mmlnPrev = mmlnNext;
//				mmptPrev = mmptNext;
//			}
//		}
//	}
//	return bIsThereArea;
//} // FCObjPoly::IsThereArea.
////----- 06.12.07 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.12.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::CanRotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiJpBjDfNiKhAiCpAjAnNjCoIiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoly::CanRotate () const
{
	return TRUE;
} // FCObjPoly::CanRotate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFOPCalcOA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMjFkKiCgOiCgAiCmMiLjHjHkDiCkKjCfKiClHiCkMiCoJiBgJ_xHqqkZx_10mm_xZkqqHx_jGkCjGjOiCmMiBgKiPoKiNiHiCmNiBeBjDfPiCgOiBeBjDfPiCgAiCpA_xHqqkZx_
 *			_xZkqqHx_iInKjDkOiClHiCoJiClBiCmGiCmF_xHqqkZx_10mm_xZkqqHx_iCmJjFoCjAlDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptO	:_xZkqqHx_iInKjDkOjBePiCmMjDfPiCgOiCpAjAnNjCoIiClFiBeBiInKjDkOiMoDiCmMjDfPiCgOiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptA	:_xZkqqHx_iInKjDkOjBePiCmMjDfPiCgAiCpAjAnNjCoIiClFiBeBiInKjDkOiMoDiCmMjDfPiCgAiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptOA	:_xZkqqHx_iInKjDkOiMoDiCmMjApMjFkKiCgOiCgAiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmOA	:_xZkqqHx_iInKjDkOiMoDiCmMjApMjFkKiCgOiCgAiCmMjClHiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P246_xZkqqHx_iCpAiOfBiPmGiBeCiCgOiCgAiCkKjCfKiClHiCkMiCoJiCmGiBeBiCgOiCgAiCmMjClHiClDiCmMjEoEjHkGiCmF_xHqqkZx_
 *			_xZkqqHx_iMiIiCnPiCoHiCoKiCoJjDfPiChCiCkKiOfKiPgPiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iCgOiCgAiCkKjEpBiPoNiCmJjCfKiCkCiBgJ_xHqqkZx_0.01mm_xZkqqHx_jGkCjGjOiCmMiBgKiPoKiNiHiCmNiBeBiIoKjHkFiCmJjAiFjFlNjFpLiMpM_xHqqkZx_10mm_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jApMjFkKiCmJjAlDiLeLiJlLiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCgOiCgAiCkKjCfKiCkCiBgJ_xHqqkZx_10mm_xZkqqHx_jGkCjGjOiCmMiBgKiPoKiNiHiCmNiBeBiCgOiCgAiCmMiMpMiCkLiCpAjFnLiCmBiClNiCnMiCnM_xHqqkZx_
 *			10mm_xZkqqHx_iCmMjApMjFkKiCmJjAlDiLeLiJlLiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCkCiClIiCoKiCmMiPoKiNiHiCoAiBeBjGhLjHiIiCmMiCfBjDfPiCmMjCiGjAfDiCmGiInKjDkOiMoDiCmMiCfBjDfPiCmMjCiGjAfDiCkKiIoKjChG_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiCoGiCkEiCmJiBeBjDfPiCgOiBeFjDfPiCgAiCpAiLmPjDjJiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	FCObjPoly::MoveMolip_xZkqqHx_iKnGjAjEiCmMjFoCiPjFiKnGjAjEiBeC_xHqqkZx_static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void FFOPCalcOA (DBLPoint& mmptO, DBLPoint& mmptA, DBLPoint& mmptOA,
						double& mmOA)
{
	//----- _xZkqqHx_iInKjDkOjBePiCmMiKeKiOgOjDfPiBeFiPeJjHlJjDfPiCpAiOfKiPgP_xHqqkZx_ -----
	mmptOA = mmptA - mmptO;
	mmOA = mmptOA.Len();
	// OA_xZkqqHx_iCmMiLjHjHkDiCkKjEpHiPkNiBgJ_xHqqkZx_0.01_xZkqqHx_iImIiJlKiBgKiCmMiOjOiCmNiBeB_xHqqkZx_(10.0, 0)_xZkqqHx_iCnGjFoCjAlDiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCoKiCpAjEpHiPkNiCmFiCmNiCmIiCkN_xHqqkZx_OA == 0.0_xZkqqHx_iCmMiOjOiCmGiCkLiCmMiCnNiCmMiPiIjHjNiCmGiClHiCoJiCmGiBeB_xHqqkZx_
	// _xZkqqHx_iJiJiOfKiMoLiNlHiCmMiKnGiMfHiCmFiLmJiCnPiCmEiPkMiClDiCkCiLjHjHkDiCmMiPoKiNiHiCkKjEkNjAlGiClFiBeBiDeHiDiJiBfLiCkKjAlGiClGiCoJiBeC_xHqqkZx_
	if (mmOA < 0.01)
	{
		mmptOA = DBLPoint(10.0, 0.0);
		mmptO -= DBLPoint(5.0, 0.0);
		mmptA  = mmptO + mmptOA;
		mmOA = 10.0;
	} else if (mmOA < 10.0)
	// OA_xZkqqHx_iCmMiLjHjHkDiCkK_xHqqkZx_[0.01, 10.0)_xZkqqHx_iCmMiOjOiCmNiBeBiMpMiCkLiCpAjFmPiCkGiClIiLjHjHkDiCmMiCnNiCpA_xHqqkZx_10.0_xZkqqHx_iCnGjFoCjAlDiBeC_xHqqkZx_
	{
		// O,A_xZkqqHx_iCpAjHlMjFpLiCmJiIpIiCmBjCkDiCoJiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
		double mmDiff = (10.0 - mmOA) / 2.0;
		mmptOA *= 10.0 / mmOA;
		mmptO -= mmptOA * mmDiff / 10.0;
		mmptA  = mmptO + mmptOA;
		mmOA = 10.0;
	}
} // FFOPCalcOA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFOPCalcNewP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P228_xZkqqHx_iCmJiCkIiCkCiCmEiBeBjDfPiCgOiCmGjDfPiCgAiCkKiInKjDkOiClFiClNiOjOiCmMjDfPiCgPiCmMiInKjDkOiMoDiCmM_xHqqkZx_
 *			_xZkqqHx_iNmAjFfHiCpAiMhGiOfKiClHiCoJiBeCiInKjDkOiOjOiCmJiCmNiBeBiCjCiBfOiCiOiCmGiCjGiCmNjFmPiJlLiClFiCmIiCkCiCoAiCmMiCmGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P228,P246,P247_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptP		:_xZkqqHx_iInKjDkOjBePiCmMiCgPiNmAjFfHiCpAjAnNjCoIiClFiBeBiInKjDkOiMoDiCmMiCgPiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmlnOA		:_xZkqqHx_jClMjApMiCgOiCgAiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmptO		:_xZkqqHx_jDfPiCgOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmptOA		:_xZkqqHx_jApMjFkKiCgOiCgAiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmOA		:_xZkqqHx_jApMjFkKiCgOiCgAiCmMjClHiClDiCpAjAnNjCoIiClHiCoJiBeCiBiBiCiOiBeC_xHqqkZx_
 *			mmptO_new	:_xZkqqHx_iInKjDkOiMoDiCmMjDfPiCgOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmptOA_new	:_xZkqqHx_iInKjDkOiMoDiCmMjApMjFkKiCgOiCgAiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmOA_new	:_xZkqqHx_iInKjDkOiMoDiCmMjApMjFkKiCgOiCgAiCmMjClHiClDiCpAjAnNjCoIiClHiCoJiBeCiBiBiCiOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	FCObjPoly::MoveMolip_xZkqqHx_iKnGjAjEiCmMjFoCiPjFiKnGjAjEiBeC_xHqqkZx_static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void FFOPCalcNewP (DBLPoint& mmptP, const DBLLine& mmlnOA,
						const DBLPoint& mmptO, const DBLPoint& mmptOA,
						const double& mmOA,
						const DBLPoint& mmptO_new, const DBLPoint& mmptOA_new,
						const double& mmOA_new)
{
	ASSERT(mmOA != 0.0);
	ASSERT(mmOA_new != 0.0);
	DBLPoint mmptS = mmlnOA.GetNearest(mmptP);
	DBLPoint mmptOS = mmptS - mmptO;
	//----- OS_xZkqqHx_iCmG_xHqqkZx_OA_xZkqqHx_iCkKjDkPiClGiMpMiCkLiCkJiCmHiCkEiCkJiCpAjFiEiNiGiCmJiNgMjHlGiClFiCmEiBeB_xHqqkZx_r/n_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeCjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P247_xZkqqHx_iCpAiOfBiPmG_xHqqkZx_ -----
	double dR;
	if (!almost0(mmOA))
		dR = mmptOS.Len() / mmOA;
	else
		dR = mmptOS.Len();
	if (mmptOS.x * mmptOA.x + mmptOS.y * mmptOA.y < 0) dR = -dR;
	DBLPoint mmptSP = mmptP - mmptS;
	double mmV = mmptSP.Len();
	// _xZkqqHx_jDfPiCgPiCkKiCgOiCgAiCmMiNlGiCmJiCkAiCoJiPoKiNiHiCmNiBeB_xHqqkZx_v_xZkqqHx_iCmMjCgMiCpAjFiJiCmJiClHiCoJiBeCjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P247_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
	if (mmptOA.x * mmptSP.y - mmptOA.y * mmptSP.x < 0) mmV = -mmV;
	// _xZkqqHx_iInKjDkOiMoDiCmMjDfPiChCiCpAiOfKiPgPiBeC_xHqqkZx_
	mmptS = mmptO_new + mmptOA_new * dR;
	double dV;
	if (!almost0(mmOA_new))
		dV = mmV / mmOA_new;
	else
		dV = mmV;
	mmptP.x = mmptS.x - mmptOA_new.y * dV;
	mmptP.y = mmptS.y + mmptOA_new.x * dV;
} // FFOPCalcNewP.

//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::CalcResizeFrameSelf
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// *************************************************************************/
//void FCObjPoly::CalcResizeFrameSelf ()
//{
//	// _xZkqqHx_jIeBiMiLjDfPiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeCiDgDiBfLiDiLjDoAjFjEjFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeCjFmPiNfIiCmJjBmOiJjOiBeC_xHqqkZx_
//	if (m_pJoint == NULL)
//	{
//		m_mmrtResize.SetRect(0,0,0,0);
//		return;
//	}
//	DBLPointVector vmmptPoint;
//	// _xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//// 05.03.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////	NewObjPolygon(vmmptPoint, FFGetStdElemLen(), NULL, 0);
//	NewObjPolygonForResize(vmmptPoint, FFGetStdElemLen(), NULL, 0);
//	// _xZkqqHx_jClIjDfPiNmAjFfHiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAiLiBiCnPiCoJ_xHqqkZx_.
//	::FFCalcFrame(m_mmrtResize, vmmptPoint.size(), vmmptPoint.begin());
////----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmEjEhKjChFiBeC_xHqqkZx_
////	if (GetRichText() != NULL)
////	{
////		// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmEjEhKjChFiBeC_xHqqkZx_
////		GetRichText()->CalcTextLayout(NULL, this);
////	}
////----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::CalcResizeFrameSelf();
////----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCObjPoly::CalcResizeFrameSelf.
//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::CalcResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoly::CalcResizeFrame ()
{
	// _xZkqqHx_jIeBiMiLjDfPiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeCiDgDiBfLiDiLjDoAjFjEjFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeCjFmPiNfIiCmJjBmOiJjOiBeC_xHqqkZx_
	if (m_pJoint == NULL)
	{
		m_mmrtResize.SetRect(0,0,0,0);
		return;
	}
	DBLPointVector vmmptPoint;
	// _xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	NewObjPolygonForResize(vmmptPoint, FFGetStdElemLen(), NULL, 0);
	NewObjPolygonForResize(vmmptPoint, -1, NULL, 0);
	// _xZkqqHx_jClIjDfPiNmAjFfHiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAiLiBiCnPiCoJ_xHqqkZx_.
	::FFCalcFrame(m_mmrtResize, vmmptPoint.size(), vmmptPoint.begin());
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::CalcResizeFrame();
} // FCObjPoly::CalcResizeFrame.
//----- 05.06.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetAngleLinkStandardPosition
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAjDhIiIoKjCoIiMfOiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCmMiClNiCnPiCmJiBeBiKhAjDhIiMhGiOfKiCmMiKoOiPiAiCmGiCmIiCoJjDfPiCpA_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			LinkManager.mdrw _xZkqqHx_iCmM_xHqqkZx_CalcNewMovingAngle_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptA		:_xZkqqHx_iDiKiDjDiDeOiMlDiCmMjDfP_xHqqkZx_A_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lMolipIdG	:_xZkqqHx_iDiKiDjDiDeOjAoGiCmMiDiCiDiKiDhG_xHqqkZx_G_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pRecExcept	:_xZkqqHx_iDiCiDiKiDhGiKnEiDiKiDjDiDeO_xHqqkZx_AG_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDfP_xHqqkZx_M_xZkqqHx_iCmMiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	LinkManager.mdrw _xZkqqHx_iCmM_xHqqkZx_CalcNewMovingAngle_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *			_xZkqqHx_iKoOiPiAjApM_xHqqkZx_AM_xZkqqHx_iCpAiOfKiPgPiClHiCoJiClNiCnPiCmMjDfP_xHqqkZx_M_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iKoOjGhLjDeJiCmJiCmNjDfP_xHqqkZx_A_xZkqqHx_iCmGjDfP_xHqqkZx_H_xZkqqHx_iCmMiImKjChFiKnGiMfHiCpAiKoOiPiAiCmJiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jDfP_xHqqkZx_H_xZkqqHx_iCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiKhAjDhIiIoKjCoIiMfOiDiKiDjDiDeOiCkKiCkAiCoJiPoKiNiHiCmNiBeBiClLiCmM_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOjAoGiCmMiImKjChFiCpAjDfP_xHqqkZx_H_xZkqqHx_iCmGiClFiCmEiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			pRecExcept _xZkqqHx_iCmNiBeBiKhAjDhIiIoKjCoIiMfOiDiKiDjDiDeOiCpAiMjPiNpFiClHiCoJiNnLiBeBjGlDiOiLiClHiCoJiDiKiDjDiDeO_xHqqkZx_
 *			_xZkqqHx_iCmGiClFiCmEjHfOiCkGiCoHiCoKiCoJiBeCjBlNiKhAjApMjFjEjFgJiImIiKePiCmMiPoKiNiHiCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCObjPoly::GetAngleLinkStandardPosition (const DBLPoint& mmptA,
												  long lMolipIdG,
												  const FCLinkRec* pRecExcept) const
{
	// _xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiKeKiOgOjDfPiDiCiDiKiDhGiBeBiPeJjHlJjDfPiDiCiDiKiDhGiImIiKePiCmMiPoKiNiHiCmNiBeB_xHqqkZx_Superlcass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	if (lMolipIdG != JointIDtoMolipID(0) &&
		lMolipIdG != JointIDtoMolipID(GetJointSize() - 1))
		return BASE_CLASS::GetAngleLinkStandardPosition(mmptA, lMolipIdG, pRecExcept);
	long lMolipIdH;
	if (m_byLinkMoveType == FDOP_LMTYPE_AXIS)
	//----- _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCpAiMiLiCnEiOlCjApMiCpAjCiGjAfDiCmJiInKjDkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (lMolipIdG == JointIDtoMolipID(0))
		// _xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiKeKiOgOjDfPiDiCiDiKiDhGiCmMiPoKiNiHiBeC_xHqqkZx_
			lMolipIdH = JointIDtoMolipID(GetJointSize() - 1);
		else
		// _xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiPeJjHlJjDfPiDiCiDiKiDhGiCmMiPoKiNiHiBeC_xHqqkZx_
			lMolipIdH = JointIDtoMolipID(0);
	} else
	//----- _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCpAiMiLiCnEiOlCjApMiCpAjCiGjAfDiCmJiInKjDkOiClHiCoJiBeBiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (lMolipIdG == JointIDtoMolipID(0))
		// _xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiKeKiOgOjDfPiDiCiDiKiDhGiCmMiPoKiNiHiBeC_xHqqkZx_
			lMolipIdH = JointIDtoMolipID(1);
		else
		// _xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiPeJjHlJjDfPiDiCiDiKiDhGiCmMiPoKiNiHiBeC_xHqqkZx_
			lMolipIdH = JointIDtoMolipID(GetJointSize() - 2);
	}
	// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJ_xHqqkZx_R_xZkqqHx_iCmMiDiCiDiKiDhGiNmAjFfH_xHqqkZx_H_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	DBLPoint mmptH = GetMolipPos(lMolipIdH);
	// _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_H_xZkqqHx_iCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiKhAjDhIiIoKjCoIiMfOiDiKiDjDiDeOiCpAiOoGjDlOiBeC_xHqqkZx_
	const FCLinkRec* pLinkRec =
			g_pDoc->LinkManager()->Get1stAngleLinkIn(GetObjID(), lMolipIdH, pRecExcept);
	if (pLinkRec != NULL)
	{
		// _xZkqqHx_jFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
		FCObjDynabase* pObjS = g_pDoc->ObjID2Object(pLinkRec->m_mlpFrom.dwObjID);
		mmptH = pObjS->GetMolipPos(pLinkRec->m_mlpFrom.lMolipId);
	}
	if (m_byLinkMoveType == FDOP_LMTYPE_SAMEHV)
	//----- _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGjAiFjFlNiBeFjAiCjClMiCmIjIeBiMiLjDfPiCkKiInKjDkOiClHiCoJ_xHqqkZx_ -----
	{
		// _xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiKeKiOgOjDfPiDiCiDiKiDhG_xHqqkZx_/_xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiCmMiPoKiNiHiBeC_xHqqkZx_
		BYTE byMoveStyle = (lMolipIdG == JointIDtoMolipID(0)) ?
										m_byBgnMoveStyle : m_byEndMoveStyle;
		switch (byMoveStyle)
		{
		 case FDOP_LMSTYL_NONE:			// _xZkqqHx_jHnHiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
			break;
		 case FDOP_LMSTYL_MOVE_HORZ:	// _xZkqqHx_iKeKiOgOjDfPiCmGiChHjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
			if (almosteq(mmptA.y, mmptH.y) || mmptA.y < mmptH.y)
				mmptH.SetPoint(mmptA.x, mmptA.y + 10.0);
			else
				mmptH.SetPoint(mmptA.x, mmptA.y - 10.0);
			break;
		 case FDOP_LMSTYL_MOVE_VERT:	// _xZkqqHx_iKeKiOgOjDfPiCmGiChIjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
			if (almosteq(mmptA.x, mmptH.x) || mmptA.x < mmptH.x)
				mmptH.SetPoint(mmptA.x + 10.0, mmptA.y);
			else
				mmptH.SetPoint(mmptA.x - 10.0, mmptA.y);
			break;
		}
	}
	if (abouteq(mmptA, mmptH))
	{
		// _xZkqqHx_jBmOiPnLiDiCiDiKiDhGiCkJiCoHjAiFjFlNiJeFjFpLiMpMiCmJiJlMjBhKiCmM_xHqqkZx_2_xZkqqHx_jEnEjGnKiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
		mmptH = mmptA + DBLPoint(10, 0);
	}
	return mmptH;
} // FCObjPoly::GetAngleLinkStandardPosition.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetAngleLinkStandardSign
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAjDhIiIoKjCoIiMfOiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCmMiClNiCnPiCmJiBeBiInKjDkOiKhAjDhI_xHqqkZx_(m_mmptOffset.x)_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jFpLiMpMiCpAiMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			LinkManager.mdrw _xZkqqHx_iCmM_xHqqkZx_CalcNewMovingAngle_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptA		:_xZkqqHx_iDiKiDjDiDeOiMlDiCmMjDfP_xHqqkZx_A_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lMolipIdG	:_xZkqqHx_iDiKiDjDiDeOjAoGiCmMiDiCiDiKiDhG_xHqqkZx_G_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pRecExcept	:_xZkqqHx_iDiCiDiKiDhGiKnEiDiKiDjDiDeO_xHqqkZx_AG_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDjFpLiMpMiCmMiPoKiNiHiCmN_xHqqkZx_ 1_xZkqqHx_iBeCjFiJjFpLiMpMiCmMiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	LinkManager.mdrw _xZkqqHx_iCmM_xHqqkZx_CalcNewMovingAngle_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *			_xZkqqHx_iInKjDkOiKhAjDhI_xHqqkZx_(m_mmptOffset.x)_xZkqqHx_iCmMjFpLiMpMiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iKoOjGhLjDeJiCmJiCmNjDfP_xHqqkZx_A_xZkqqHx_iCmGjDfP_xHqqkZx_H_xZkqqHx_iCmMiImKjChFiKnGiMfHiCpAiKoOiPiAiCmJiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jDfP_xHqqkZx_H_xZkqqHx_iCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiKhAjDhIiIoKjCoIiMfOiDiKiDjDiDeOiCkKiCkAiCoJiPoKiNiHiCmNiBeBiClLiCmM_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOjAoGiCmMiImKjChFiCpAjDfP_xHqqkZx_H_xZkqqHx_iCmGiClFiCmEiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			pRecExcept _xZkqqHx_iCmNiBeBiKhAjDhIiIoKjCoIiMfOiDiKiDjDiDeOiCpAiMjPiNpFiClHiCoJiNnLiBeBjGlDiOiLiClHiCoJiDiKiDjDiDeO_xHqqkZx_
 *			_xZkqqHx_iCmGiClFiCmEjHfOiCkGiCoHiCoKiCoJiBeCjBlNiKhAjApMjFjEjFgJiImIiKePiCmMiPoKiNiHiCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
short FCObjPoly::GetAngleLinkStandardSign (const DBLPoint& mmptA,
										  long lMolipIdG,
										  const FCLinkRec* pRecExcept) const
{
	// _xZkqqHx_iBhFiKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGjAiFjFlNiBeFjAiCjClMiCmIjIeBiMiLjDfPiCkKiInKjDkOiClHiCoJiBhGiImIiKePiCmMiPoKiNiHiCmNiBeB_xHqqkZx_Superlcass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	if (m_byLinkMoveType != FDOP_LMTYPE_SAMEHV)
		return BASE_CLASS::GetAngleLinkStandardSign(mmptA, lMolipIdG, pRecExcept);
	// _xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiKeKiOgOjDfPiDiCiDiKiDhGiBeBiPeJjHlJjDfPiDiCiDiKiDhGiImIiKePiCmMiPoKiNiHiCmNiBeB_xHqqkZx_Superlcass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	if (lMolipIdG != JointIDtoMolipID(0) &&
		lMolipIdG != JointIDtoMolipID(GetJointSize() - 1))
		return BASE_CLASS::GetAngleLinkStandardSign(mmptA, lMolipIdG, pRecExcept);
	long lMolipIdH;
	if (lMolipIdG == JointIDtoMolipID(0))
	// _xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiKeKiOgOjDfPiDiCiDiKiDhGiCmMiPoKiNiHiBeC_xHqqkZx_
		lMolipIdH = JointIDtoMolipID(1);
	else
	// _xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiPeJjHlJjDfPiDiCiDiKiDhGiCmMiPoKiNiHiBeC_xHqqkZx_
		lMolipIdH = JointIDtoMolipID(GetJointSize() - 2);
	// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJ_xHqqkZx_R_xZkqqHx_iCmMiDiCiDiKiDhGiNmAjFfH_xHqqkZx_H_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	DBLPoint mmptH = GetMolipPos(lMolipIdH);
	// _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_H_xZkqqHx_iCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiKhAjDhIiIoKjCoIiMfOiDiKiDjDiDeOiCpAiOoGjDlOiBeC_xHqqkZx_
	const FCLinkRec* pLinkRec =
			g_pDoc->LinkManager()->Get1stAngleLinkIn(GetObjID(), lMolipIdH, pRecExcept);
	if (pLinkRec != NULL)
	{
		// _xZkqqHx_jFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
		FCObjDynabase* pObjS = g_pDoc->ObjID2Object(pLinkRec->m_mlpFrom.dwObjID);
		mmptH = pObjS->GetMolipPos(pLinkRec->m_mlpFrom.lMolipId);
	}
	// _xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiKeKiOgOjDfPiDiCiDiKiDhG_xHqqkZx_/_xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiCmMiPoKiNiHiBeC_xHqqkZx_
	BYTE byMoveStyle = (lMolipIdG == JointIDtoMolipID(0)) ?
									m_byBgnMoveStyle : m_byEndMoveStyle;
	switch (byMoveStyle)
	{
	 case FDOP_LMSTYL_NONE:			// _xZkqqHx_jHnHiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
		break;
	 case FDOP_LMSTYL_MOVE_HORZ:	// _xZkqqHx_iKeKiOgOjDfPiCmGiChHjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
		if (almosteq(mmptA.y, mmptH.y) || mmptA.y < mmptH.y)
			return 1;
		else
			return -1;
	 case FDOP_LMSTYL_MOVE_VERT:	// _xZkqqHx_iKeKiOgOjDfPiCmGiChIjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
		if (almosteq(mmptA.x, mmptH.x) || mmptA.x < mmptH.x)
			return 1;
		else
			return -1;
	}
	return 1;
} // FCObjPoly::GetAngleLinkStandardSign.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::~FCObjPoly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *************************************************************************/
FCObjPoly::~FCObjPoly ()
{
	if (m_pJoint != NULL) delete[] m_pJoint;
} // FCObjPoly::~FCObjPoly.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::DeleteJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCpAiNoNiPjMiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lP	: _xZkqqHx_jIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
 *************************************************************************/
void FCObjPoly::DeleteJoint (long lP)
{
	long l;
	m_lJoint--;
	for (l = lP; l < m_lJoint; l++)
	{
		m_pJoint[l] = m_pJoint[l+1];
	}
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	JointUpdated();
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCObjPoly::DeleteJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::DeleteJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIdx	:_xZkqqHx_iNoNiPjMiCpAiKeKiOgOiClHiCoJjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lSz		:_xZkqqHx_iNoNiPjMiClHiCoJjIeBiMiLjDfPiCmMjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoly::DeleteJoint (long lIdx, long lSz)
{
	FCPolyJoint* pNewJoint = new FCPolyJoint[m_lJoint - lSz];
	memcpy(pNewJoint, m_pJoint, lIdx * sizeof(FCPolyJoint));
	memcpy(pNewJoint + lIdx, m_pJoint + lIdx + lSz,
			(m_lJoint - lIdx - lSz) * sizeof(FCPolyJoint));
	m_lJoint -= lSz;
	if (m_pJoint != NULL) delete[] m_pJoint;
	m_pJoint = pNewJoint;
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	JointUpdated();
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCObjPoly::DeleteJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::InsertJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	lInsert_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCmMjBePiCmJjIeBiMiLjDfPiCpAjBhNjDpMiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lInsert		: _xZkqqHx_jBhNjDpMiImKjChF_xHqqkZx_
 *			polyJoint	: _xZkqqHx_jBhNjDpMiClHiCoJjIeBiMiLjDfP_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CommandGate_xZkqqHx_iCmFiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoly::InsertJoint (long lInsert, const FCPolyJoint& polyJoint)
{
	FCPolyJoint* apNewJoint = new FCPolyJoint[m_lJoint + 1];

	memcpy(apNewJoint, m_pJoint, lInsert * sizeof(FCPolyJoint));
	memcpy(apNewJoint + lInsert, &polyJoint, sizeof(FCPolyJoint));
	memcpy(apNewJoint + lInsert + 1,
			m_pJoint + lInsert, (m_lJoint - lInsert) * sizeof(FCPolyJoint));
	m_lJoint++;
	if (m_pJoint != NULL) delete[] m_pJoint;
	m_pJoint = apNewJoint;
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	JointUpdated();
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCObjPoly::InsertJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::InsertJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	lInsert_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCmMjBePiCmJiBeBjFkBjAjEiCmMjIeBiMiLjDfPiCpAjBhNjDpMiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lInsert	: _xZkqqHx_jBhNjDpMiImKjChF_xHqqkZx_
 *			aoJoint	: _xZkqqHx_jBhNjDpMiClHiCoJjIeBiMiLjDfP_xHqqkZx_
 *			lJoint	: aoJoint_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_
 *************************************************************************/
void FCObjPoly::InsertJoint (long lInsert,
							 const FCPolyJoint aoJoint[], long lJoint)
{
	long lNewJoint = m_lJoint + lJoint;
	FCPolyJoint* apNewJoint = new FCPolyJoint[lNewJoint];

	memcpy(apNewJoint, m_pJoint, lInsert * sizeof(FCPolyJoint));
	memcpy(apNewJoint + lInsert, aoJoint, lJoint * sizeof(FCPolyJoint));
	memcpy(apNewJoint + lInsert + lJoint,
			m_pJoint + lInsert, (m_lJoint - lInsert) * sizeof(FCPolyJoint));
	m_lJoint = lNewJoint;
	if (m_pJoint != NULL) delete[] m_pJoint;
	m_pJoint = apNewJoint;
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	JointUpdated();
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCObjPoly::InsertJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::SetJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHjEhKjHpBiCkJiCoHiDfHiDiHiDeDiDjDiDgHjEhKjHpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lPointSize	:_xZkqqHx_iDhMiDeDiDjDiDgHjEhKjHpBiCmMiDfEiDeDiDfJ_xHqqkZx_
 *			mmptPoint	:_xZkqqHx_iDhMiDeDiDjDiDgHjEhKjHpB_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoly::SetJoint (long lPointSize, const DBLPoint* mmptpPoint)
{
	m_lJoint = lPointSize;
	if (m_pJoint != NULL) delete[] m_pJoint;
	m_pJoint = new FCPolyJoint[lPointSize];
	for (long l = 0; l < lPointSize; l++)
	{
		m_pJoint[l].m_nType = FDJT_BTH_PULL_0;
		m_pJoint[l].m_mmptPivot = mmptpPoint[l];
		m_pJoint[l].m_mmptPrev = DBLPoint(0,0);
		m_pJoint[l].m_mmptNext = DBLPoint(0,0);
	}
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	JointUpdated();
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCObjPoly::SetJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetJoints
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjEhKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.30 Fukushiro M. _xZkqqHx_iDhHiDgCiDfPiCkJiCoHiInKjDkO_xHqqkZx_
 *************************************************************************/
const FCPolyJoint* FCObjPoly::GetJoints () const
{
	return m_pJoint;
} // FCObjPoly::GetJoints.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	l	:_xZkqqHx_jIeBiMiLjDfPiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.30 Fukushiro M. _xZkqqHx_iDhHiDgCiDfPiCkJiCoHiInKjDkO_xHqqkZx_
 *************************************************************************/
FCPolyJoint& FCObjPoly::GetJoint (long l) const
{
	return m_pJoint[l];
} // FCObjPoly::GetJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetJointSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjEhKjHpBiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPjEhKjHpBiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.30 Fukushiro M. _xZkqqHx_iDhHiDgCiDfPiCkJiCoHiInKjDkO_xHqqkZx_
 *************************************************************************/
long FCObjPoly::GetJointSize () const
{
	return m_lJoint;
} // FCObjPoly::GetJointSize.

short FCObjPoly::GetJointType (long lIndex) const
{
	return GetJoint(lIndex).GetJointType();
} // FCObjPoly::GetJointType.

mmetol FCObjPoly::GetPivotX (long lIndex) const
{
	return GetJoint(lIndex).GetPivotX();
} // FCObjPoly::GetPivotX.

mmetol FCObjPoly::GetPivotY (long lIndex) const
{
	return GetJoint(lIndex).GetPivotY();
} // FCObjPoly::GetPivotY.

mmetol FCObjPoly::GetPrevPullX (long lIndex) const
{
	return GetJoint(lIndex).GetPrevPullX();
} // FCObjPoly::GetPrevPullX.

mmetol FCObjPoly::GetPrevPullY (long lIndex) const
{
	return GetJoint(lIndex).GetPrevPullY();
} // FCObjPoly::GetPrevPullY.

mmetol FCObjPoly::GetNextPullX (long lIndex) const
{
	return GetJoint(lIndex).GetNextPullX();
} // FCObjPoly::GetNextPullX.

mmetol FCObjPoly::GetNextPullY (long lIndex) const
{
	return GetJoint(lIndex).GetNextPullY();
} // FCObjPoly::GetNextPullY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::SetJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfHiDiHiDeDiDjDiDgHjEhKjHpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lJointSize	:_xZkqqHx_iDhMiDeDiDjDiDgHjEhKjHpBiCmMiDfEiDeDiDfJ_xHqqkZx_
 *			pjpJoint	:_xZkqqHx_iDhMiDeDiDjDiDgHjEhKjHpB_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoly::SetJoint (long lJointSize, const FCPolyJoint* pjpJoint)
{
	m_lJoint = lJointSize;
	if (m_pJoint != NULL) delete[] m_pJoint;
	m_pJoint = new FCPolyJoint[lJointSize];
	memcpy(m_pJoint, pjpJoint, lJointSize * sizeof(FCPolyJoint));
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	JointUpdated();
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCObjPoly::SetJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::CanSetOpenPolyJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMjHlMjCfLiCmMjAnKjBlBiPpDjBnEiCpAjFmPiNfIiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ObjPoly_xZkqqHx_iCmGiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmM_xHqqkZx_ObjWidePoly_xZkqqHx_iCmFiBeB_xHqqkZx_SetIsOpenPolyJoint
 *			_xZkqqHx_iKnGjAjEiCmMiIlFiCkCiCkKjFmPiCoNiCoJiClNiCnPiBeBiClBiCmMiKnGjAjEiCkKjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoly::CanSetOpenPolyJoint () const
{
	return TRUE;
} // FCObjPoly::CanSetOpenPolyJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetIsOpenPolyJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMjHlMjCfLiCkKiKeKiCkCiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	GetIsOpenPolygon_xZkqqHx_iCmGjDkPiClGjCgMiCpAjFnEiClHiCkKiBeBiDfEiDhFiDeOiDiJiDfIiCmM_xHqqkZx_ObjWidePoly_xZkqqHx_iCmFiCmN_xHqqkZx_
 *			_xZkqqHx_jCgMiCkKiInJiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoly::GetIsOpenPolyJoint () const
{
	return m_bIsOpenPolyJoint;
} // FCObjPoly::GetIsOpenPolyJoint.

void FCObjPoly::SetJointType (long lIndex, short nType)
{
	m_pJoint[lIndex].SetJointType(nType);
} // FCObjPoly::SetJointType.

void FCObjPoly::SetPivotX (long lIndex, mmetol mm)
{
	m_pJoint[lIndex].SetPivotX(mm);
	// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	JointUpdated();
} // FCObjPoly::SetPivotX.

void FCObjPoly::SetPivotY (long lIndex, mmetol mm)
{
	m_pJoint[lIndex].SetPivotY(mm);
	// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	JointUpdated();
} // FCObjPoly::SetPivotY.

void FCObjPoly::SetPrevPullX (long lIndex, mmetol mm)
{
	m_pJoint[lIndex].SetPrevPullX(mm);
	// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	JointUpdated();
} // FCObjPoly::SetPrevPullX.

void FCObjPoly::SetPrevPullY (long lIndex, mmetol mm)
{
	m_pJoint[lIndex].SetPrevPullY(mm);
	// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	JointUpdated();
} // FCObjPoly::SetPrevPullY.

void FCObjPoly::SetNextPullX (long lIndex, mmetol mm)
{
	m_pJoint[lIndex].SetNextPullX(mm);
	// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	JointUpdated();
} // FCObjPoly::SetNextPullX.

void FCObjPoly::SetNextPullY (long lIndex, mmetol mm)
{
	m_pJoint[lIndex].SetNextPullY(mm);
	// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	JointUpdated();
} // FCObjPoly::SetNextPullY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::SetIsOpenPolyJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMjHlMjCfLiCpAiKeKiCkNiCkJjFmCiClGiCoJiCkJiCmMjAnNjCoIiCpAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bOpen	:_xZkqqHx_iKeKiCkNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFmCiClGiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjAnNjCoIiCmFiCkLiCmIiCkCiPoKiNiHiBeFiKpJiCmJjDkPiClGjCgMiCkKjAnNjCoI_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoly::SetIsOpenPolyJoint (BOOL bOpen)
{
	if (m_bIsOpenPolyJoint == bOpen) return FALSE;
	m_bIsOpenPolyJoint = bOpen;
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
	JointUpdated();
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	return TRUE;
} // FCObjPoly::SetIsOpenPolyJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetLinkMoveType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiInKjDkOiOjOiCmMjIeBiMiLjDfPiNmEjEhKjChFjFpLjGeAiCmMiDfOiDeDiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiNmEjEhKjChFjFpLjGeAiCmMiDfOiDeDiDhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDhGiCmNiImIiJlKiCmMiCfCiCmCiCkKiCkAiCoJiBeC_xHqqkZx_
 *			FDOP_LMTYPE_NONE	:_xZkqqHx_iDiKiDjDiDeOiDiCiDiKiDhGiInKjDkOiCmJjElKiCkEjBlMiCmMjIeBiMiLjDfPiInKjDkOiCmNjGlDiCkCiBeC_xHqqkZx_
 *			FDOP_LMTYPE_AXIS	:_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCpAiMiLiCnEiOlCjApMiCpAjCiGjAfDiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *			FDOP_LMTYPE_SAMEHV	:_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGjAiFjFlNiBeFjAiCjClMiCmIjIeBiMiLjDfPiCkKiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FCObjPoly::GetLinkMoveType () const
{
	return m_byLinkMoveType;
} // FCObjPoly::GetLinkMoveType.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::SetLinkMoveType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiInKjDkOiOjOiCmMjIeBiMiLjDfPiNmEjEhKjChFjFpLjGeAiCmMiDfOiDeDiDhGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wType	:_xZkqqHx_jIeBiMiLjDfPiNmEjEhKjChFjFpLjGeAiCmMiDfOiDeDiDhGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpJiCmJjDkPiClGiDfOiDeDiDhGiCkKjAnNjCoIiNmPiCnNiCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDhGiCmNiImIiJlKiCmMiCfCiCmCiCkKiCkAiCoJiBeC_xHqqkZx_
 *			FDOP_LMTYPE_NONE	:_xZkqqHx_iDiKiDjDiDeOiDiCiDiKiDhGiInKjDkOiCmJjElKiCkEjBlMiCmMjIeBiMiLjDfPiInKjDkOiCmNjGlDiCkCiBeC_xHqqkZx_
 *			FDOP_LMTYPE_AXIS	:_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCpAiMiLiCnEiOlCjApMiCpAjCiGjAfDiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *			FDOP_LMTYPE_SAMEHV	:_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGjAiFjFlNiBeFjAiCjClMiCmIjIeBiMiLjDfPiCkKiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoly::SetLinkMoveType (WORD wType)
{
	if (m_byLinkMoveType == wType) return FALSE;
	m_byLinkMoveType = wType;
	return TRUE;
} // FCObjPoly::SetLinkMoveType.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetBgnLinkMoveStyle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiCmMiDiKiDjDiDeOiInKjDkOiOjOiCmMiBeBjHnHiCmMjIeBiMiLjDfPiCmMiInKjDkOiDfIiDfOiDeDiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfIiDfOiDeDiDiLiCmNiImIiJlKiCmMiCfCiCmCiCkKiCkAiCoJiBeC_xHqqkZx_
 *			FDOP_LMSTYL_NONE		:_xZkqqHx_jHnHiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
 *			FDOP_LMSTYL_MOVE_HORZ	:_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChHjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *			FDOP_LMSTYL_MOVE_VERT	:_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChIjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FCObjPoly::GetBgnLinkMoveStyle () const
{
	return m_byBgnMoveStyle;
} // FCObjPoly::GetBgnLinkMoveStyle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::SetBgnLinkMoveStyle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiCmMiDiKiDjDiDeOiInKjDkOiOjOiCmMiBeBjHnHiCmMjIeBiMiLjDfPiCmMiInKjDkOiDfIiDfOiDeDiDiLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wStyle	:_xZkqqHx_iInKjDkOiDfIiDfOiDeDiDiLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpJiCmJjDkPiClGiDfIiDfOiDeDiDiLiCkKjAnNjCoIiNmPiCnNiCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfIiDfOiDeDiDiLiCmNiImIiJlKiCmMiCfCiCmCiCkKiCkAiCoJiBeC_xHqqkZx_
 *			FDOP_LMSTYL_NONE		:_xZkqqHx_jHnHiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
 *			FDOP_LMSTYL_MOVE_HORZ	:_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChHjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *			FDOP_LMSTYL_MOVE_VERT	:_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChIjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoly::SetBgnLinkMoveStyle (WORD wStyle)
{
	if (m_byBgnMoveStyle == wStyle) return FALSE;
	m_byBgnMoveStyle = wStyle;
	return TRUE;
} // FCObjPoly::SetBgnLinkMoveStyle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::GetEndLinkMoveStyle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiCmMiDiKiDjDiDeOiInKjDkOiOjOiCmMiBeBjHnHiCmMjIeBiMiLjDfPiCmMiInKjDkOiDfIiDfOiDeDiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfIiDfOiDeDiDiLiCmNiImIiJlKiCmMiCfCiCmCiCkKiCkAiCoJiBeC_xHqqkZx_
 *			FDOP_LMSTYL_NONE		:_xZkqqHx_jHnHiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
 *			FDOP_LMSTYL_MOVE_HORZ	:_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChHjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *			FDOP_LMSTYL_MOVE_VERT	:_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChIjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FCObjPoly::GetEndLinkMoveStyle () const
{
	return m_byEndMoveStyle;
} // FCObjPoly::GetEndLinkMoveStyle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::SetEndLinkMoveStyle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiCmMiDiKiDjDiDeOiInKjDkOiOjOiCmMiBeBjHnHiCmMjIeBiMiLjDfPiCmMiInKjDkOiDfIiDfOiDeDiDiLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wStyle	:_xZkqqHx_iInKjDkOiDfIiDfOiDeDiDiLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpJiCmJjDkPiClGiDfIiDfOiDeDiDiLiCkKjAnNjCoIiNmPiCnNiCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfIiDfOiDeDiDiLiCmNiImIiJlKiCmMiCfCiCmCiCkKiCkAiCoJiBeC_xHqqkZx_
 *			FDOP_LMSTYL_NONE		:_xZkqqHx_jHnHiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
 *			FDOP_LMSTYL_MOVE_HORZ	:_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChHjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *			FDOP_LMSTYL_MOVE_VERT	:_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChIjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjPoly::SetEndLinkMoveStyle (WORD wStyle)
{
	if (m_byEndMoveStyle == wStyle) return FALSE;
	m_byEndMoveStyle = wStyle;
	return TRUE;
} // FCObjPoly::SetEndLinkMoveStyle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::Copy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmMjFjEjFgJiCmJjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jBkOjAkLiCpAiDfCiDhDiBfLiClDiCoKiCoJjFjEjFgJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoly::Copy (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Copy(pObj);
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	FCObjPoly::CopySelf(pObj);
} // FCObjPoly::Copy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::CopySelf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmJjBkOiClHiCoJjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoly::CopySelf (FCObjDynabase* pObj) const
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFjGlDiCkPiCoKiCmOjFkBiOmKiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FCObjPoly::Type())) return;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// m_mmrtResize_xZkqqHx_iCmN_xHqqkZx_double_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjPoly, m_mmrtResize));
	ASSERT(sizeof(*this) - offsetof(FCObjPoly, m_pJoint) == sizeof(m_pJoint));
	FCObjPoly* pPoly = reinterpret_cast<FCObjPoly*>(pObj);
	if (pPoly->m_pJoint != NULL) delete[] pPoly->m_pJoint;
	memcpy(&pPoly->m_mmrtResize, &m_mmrtResize,
			offsetof(FCObjPoly, m_pJoint) - offsetof(FCObjPoly, m_mmrtResize));
	pPoly->m_pJoint = new FCPolyJoint[m_lJoint];
	memcpy(pPoly->m_pJoint, m_pJoint, m_lJoint * sizeof(FCPolyJoint));
} // FCObjPoly::CopySelf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::MoveMolip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipId	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *			mmptOffset	:_xZkqqHx_iInKjDkOiLjHjHkDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCkKiInKjDkOiClDiCoKiCoJiPoKiNiHiCmNiBeBjFjEjFgJiCmMiDfOiDeDiDhGiCmJiCoGiCmBiCmE_xHqqkZx_
 *			_xZkqqHx_jBlMiCmMjIeBiMiLjDfPiCoAiNmEiMhGiOfKiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P228,P246,P247_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCmMiNmEiMhGiOfKiCmNiClFiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoly::MoveMolip (long lMolipId, const DBLPoint& mmptOffset)
{
	// _xZkqqHx_iInKjDkOjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (mmptOffset.IsNull()) return;
	if (lMolipId != -1)
	{
//----- 01.08.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_jIeBiMiLjDfPiKnEiDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBjClMjAnKiInKjDkOjFhDiJmCjEfMiCmIiInHjFjMiLeBiBeC_xHqqkZx_
//		if (lMolipId & 1) return;
//----- 01.08.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		if (lMolipId & 1)
		//----- _xZkqqHx_jIeBiMiLjDfPiKnEiDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iOgOjDfPiBeBiPeJjDfPiKnEiDiCiDiKiDhGiCkJiCmHiCkEiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
			const long lLastJointMolipId = JointIDtoMolipID(m_lJoint - 1);
			long lJointId_0, lJointId_1;
			if (lMolipId == lLastJointMolipId + 1)
			{
				lJointId_0 = 0;
				lJointId_1 = m_lJoint - 1;
			} else
			{
				lJointId_0 = MolipIDToJointID(lMolipId - 1);
				lJointId_1 = MolipIDToJointID(lMolipId + 1);
			}
			// _xZkqqHx_jIeBiMiLjDfPiKnEiDiCiDiKiDhGiCmMjHlMjBkEjIeBiMiLjDfPiCpA_xHqqkZx_mmptOffset_xZkqqHx_iClOiCkPiInKjDkOiBeC_xHqqkZx_
			m_pJoint[lJointId_0].MovePivot(mmptOffset);
			m_pJoint[lJointId_1].MovePivot(mmptOffset);
		} else
		{
//----- 01.08.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			//----- _xZkqqHx_jIeBiMiLjDfPiDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
			const long lJointID = MolipIDToJointID(lMolipId);
			if (!m_bIsOpenPolyJoint || m_byLinkMoveType == FDOP_LMTYPE_NONE ||
				(lJointID != 0 && lJointID != m_lJoint - 1))
			//----- _xZkqqHx_iDiKiDjDiDeOiDiCiDiKiDhGiInKjDkOiCmJjElKiCkEjBlMiCmMjIeBiMiLjDfPiInKjDkOiCmNjGlDiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCpA_xHqqkZx_mmptOffset_xZkqqHx_iClOiCkPiInKjDkOiBeC_xHqqkZx_
				m_pJoint[lJointID].MovePivot(mmptOffset);
			} else
			if (m_byLinkMoveType == FDOP_LMTYPE_AXIS)
			//----- _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCpAiMiLiCnEiOlCjApMiCpAjCiGjAfDiCmJiInKjDkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmNiLjHjHkDiCkKjCfKiClHiCkMiCoJiPoKiNiHiCmJjFoCjAlDiClHiCoJiClNiCnPiBeBjFnLjBlGiClFiCmEiCkIiCkNiBeC_xHqqkZx_
				DBLPoint mmptPivotNew0 = m_pJoint[0].m_mmptPivot;
				DBLPoint mmptPivotNewN = m_pJoint[m_lJoint - 1].m_mmptPivot;
				// _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
				if (lJointID == 0)	mmptPivotNew0 += mmptOffset;
				else				mmptPivotNewN += mmptOffset;

				DBLPoint mmptO = m_pJoint[0].m_mmptPivot;
				DBLPoint mmptA = m_pJoint[m_lJoint - 1].m_mmptPivot;
				DBLPoint mmptOA;
				double mmOA;
				// _xZkqqHx_iInKjDkOjBePiCmMiKeKiOgOjDfPiBeFiPeJjHlJjDfPiCpAiBeBjCfKiClHiCkMiCoJiPoKiNiHiCmNjFoCjAlDiClHiCoJiBeC_xHqqkZx_
				FFOPCalcOA(mmptO, mmptA, mmptOA, mmOA);
				m_pJoint[0].m_mmptPivot = mmptO;
				m_pJoint[m_lJoint - 1].m_mmptPivot = mmptA;

				//----- _xZkqqHx_iInKjDkOiMoDiCmMiKeKiOgOjDfPiBeFiPeJjHlJjDfPiCpAiOfKiPgP_xHqqkZx_ -----
				DBLPoint mmptO_new = mmptPivotNew0;
				DBLPoint mmptA_new = mmptPivotNewN;
				DBLPoint mmptOA_new;
				double mmOA_new;
				// _xZkqqHx_iInKjDkOiMoDiCmMiKeKiOgOjDfPiBeFiPeJjHlJjDfPiCpAiBeBjCfKiClHiCkMiCoJiPoKiNiHiCmNjFoCjAlDiClHiCoJiBeC_xHqqkZx_
				FFOPCalcOA(mmptO_new, mmptA_new, mmptOA_new, mmOA_new);

				// _xZkqqHx_jDfPiCkKiInKjDkOiClFiCmEiCkCiCmIiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
				if (mmptO == mmptO_new && mmptA == mmptA_new) return;

				const DBLLine mmlnOA(mmptO, mmptA);

				for (long l = 0; l < m_lJoint; l++)
				{
					// mmptPrev,mmptNext_xZkqqHx_iCmMiNmAjFfHiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
					DBLPoint mmptPrev = m_pJoint[l].m_mmptPivot + m_pJoint[l].m_mmptPrev;
					DBLPoint mmptNext = m_pJoint[l].m_mmptPivot + m_pJoint[l].m_mmptNext;
					// _xZkqqHx_iDhDiDhLiDgCiDgHiCmMiNmAjFfHiCpAjFmPiKlHiClHiCoJiBeC_xHqqkZx_
					if (l == 0)
						m_pJoint[l].m_mmptPivot = mmptO_new;
					else if (l == m_lJoint - 1)
						m_pJoint[l].m_mmptPivot = mmptA_new;
					else
						FFOPCalcNewP(m_pJoint[l].m_mmptPivot, mmlnOA, mmptO, mmptOA,
										mmOA, mmptO_new, mmptOA_new, mmOA_new);
					// m_mmptPrev/m_mmptNext_xZkqqHx_iCkK_xHqqkZx_0_xZkqqHx_iCmMiOjOiCmJiCmNiNmEjEhKjChFiMhGiOfKiCpAiClFiCmIiCkCiBeC_xHqqkZx_
					// _xZkqqHx_jCgMiCkKjEpHjGkNiCmJiLlGiCmBiCmEiClFiCnMiCkEiCmMiCpAjGgIiCkOiClNiCnPiBeC_xHqqkZx_
					if (!m_pJoint[l].m_mmptPrev.IsNull())
					{
						FFOPCalcNewP(mmptPrev, mmlnOA, mmptO, mmptOA, mmOA,
											mmptO_new, mmptOA_new, mmOA_new);
						m_pJoint[l].m_mmptPrev = mmptPrev - m_pJoint[l].m_mmptPivot;
					}
					if (!m_pJoint[l].m_mmptNext.IsNull())
					{
						FFOPCalcNewP(mmptNext, mmlnOA, mmptO, mmptOA, mmOA,
											mmptO_new, mmptOA_new, mmOA_new);
						m_pJoint[l].m_mmptNext = mmptNext - m_pJoint[l].m_mmptPivot;
					}
				}
				// _xZkqqHx_jFoCjAlDiClFiCmEiCkCiClNiKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmMiDhDiDhLiDgCiDgHiCpAjGhLjHiIiCmMiImKjChFiCmJjGnPiClHiBeC_xHqqkZx_
				m_pJoint[0].m_mmptPivot = mmptPivotNew0;
				m_pJoint[m_lJoint - 1].m_mmptPivot = mmptPivotNewN;
			} else
			//----- _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGjAiFjFlNiBeFjAiCjClMiCmIjIeBiMiLjDfPiCkKiInKjDkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iOhHjCoIiClDiCoKiClNjIeBiMiLjDfPiCpA_xHqqkZx_mmptOffset_xZkqqHx_iClOiCkPiInKjDkOiBeC_xHqqkZx_
				m_pJoint[lJointID].MovePivot(mmptOffset);
				if (m_lJoint <= 2)
				{
		//			return;
				} else
				if (lJointID == 0)
				{
					switch (m_byBgnMoveStyle)
					{
					 case FDOP_LMSTYL_NONE:			// _xZkqqHx_jHnHiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
						break;
					 case FDOP_LMSTYL_MOVE_HORZ:	// _xZkqqHx_iKeKiOgOjDfPiCmGiChHjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
						m_pJoint[1].MovePivot(DBLPoint(mmptOffset.x, 0));
						break;
					 case FDOP_LMSTYL_MOVE_VERT:	// _xZkqqHx_iKeKiOgOjDfPiCmGiChIjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
						m_pJoint[1].MovePivot(DBLPoint(0, mmptOffset.y));
						break;
					}
				} else
				{
					switch (m_byEndMoveStyle)
					{
					 case FDOP_LMSTYL_NONE:			// _xZkqqHx_jHnHiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
						break;
					 case FDOP_LMSTYL_MOVE_HORZ:	// _xZkqqHx_iPeJjHlJjDfPiCmGiChHjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
						m_pJoint[m_lJoint - 2].MovePivot(DBLPoint(mmptOffset.x, 0));
						break;
					 case FDOP_LMSTYL_MOVE_VERT:	// _xZkqqHx_iPeJjHlJjDfPiCmGiChIjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
						m_pJoint[m_lJoint - 2].MovePivot(DBLPoint(0, mmptOffset.y));
						break;
					}
				}
			}
		}
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_jIeBiMiLjDfPiNfIjAfGiCpAjCmKjCgNiBeC_xHqqkZx_
		JointUpdated();
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::MoveMolip(lMolipId, mmptOffset);
} // FCObjPoly::MoveMolip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::Move
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiInKjDkOiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmDX	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_X_xZkqqHx_jFpLiMpMiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmDY	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_Y_xZkqqHx_jFpLiMpMiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *************************************************************************/
void FCObjPoly::Move (mmetol mmDX, mmetol mmDY)
{
	long	l;
	for (l = 0; l < m_lJoint; l++)
	{
		m_pJoint[l].m_mmptPivot.x += mmDX;
		m_pJoint[l].m_mmptPivot.y += mmDY;
	}
	m_mmrtResize += DBLPoint(mmDX, mmDY);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Move(mmDX, mmDY);
} // FCObjPoly::Move.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::Resize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiDiKiDfEiDeDiDfJiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	: X_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			bYPosi	: Y_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			mmrtNew	: _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfH_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *************************************************************************/
void FCObjPoly::Resize (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld)
{
// 05.04.05 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	DBLRect	mmrtOld = GetResizeFrame();

	//----- _xZkqqHx_iKgHiPgLjEoEiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
	double	dAX, dAY;
	if (almost0(mmrtOld.Width()))
		dAX = 1.0;
	else
		dAX = mmrtNew.Width() / mmrtOld.Width();
	if (almost0(mmrtOld.Height()))
		dAY = 1.0;
	else
		dAY = mmrtNew.Height() / mmrtOld.Height();

	double	mmBaseX = mmrtNew.left;
	double	mmBaseY = mmrtNew.top;
	if (!bXPosi)
	{
		dAX = -dAX;
		mmBaseX = mmrtNew.right;
	}
	if (!bYPosi)
	{
		dAY = -dAY;
		mmBaseY = mmrtNew.bottom;
	}

	long l;
	for (l = 0; l < m_lJoint; l++)
	{
		m_pJoint[l].m_mmptPivot.x	= mmBaseX + dAX * (m_pJoint[l].m_mmptPivot.x - mmrtOld.left);
		m_pJoint[l].m_mmptPivot.y	= mmBaseY + dAY * (m_pJoint[l].m_mmptPivot.y - mmrtOld.top);
		m_pJoint[l].m_mmptPrev.x	= dAX * m_pJoint[l].m_mmptPrev.x;
		m_pJoint[l].m_mmptPrev.y	= dAY * m_pJoint[l].m_mmptPrev.y;
		m_pJoint[l].m_mmptNext.x	= dAX * m_pJoint[l].m_mmptNext.x;
		m_pJoint[l].m_mmptNext.y	= dAY * m_pJoint[l].m_mmptNext.y;
	}
	m_mmrtResize = mmrtNew;	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiA_xHqqkZx_.
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Resize(bXPosi, bYPosi, mmrtNew, mmrtOld);
} // FCObjPoly::Resize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::Rotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR		:_xZkqqHx_iJpBjDfNiClDiClJiCoJiKhAjDhIiBeC_xHqqkZx_-2.0 < dR < 2.0.
 *			mmCX	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfH_xHqqkZx_
 *			mmCY	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
 *************************************************************************/
void FCObjPoly::Rotate (double dR, const DBLPoint& mmptCenter)
{
	// _xZkqqHx_iJpBjDfNiKhAjDhIiCkKiCePiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
	if (dR == 0.0) return;
	//----- _xZkqqHx_iJpBjDfNjFmPiKlHiCmM_xHqqkZx_Sin,Cos_xZkqqHx_iCpAiOfKiPgP_xHqqkZx_ -----
	const double dSinR = sin(dR * M_PI);
	const double dCosR = cos(dR * M_PI);
	for (long lC = 0; lC < m_lJoint; lC++)
	{
		// _xZkqqHx_iJpBjDfNjFmPiKlHiCpAiOfKiPgPiBeC_xHqqkZx_
		::RotateConv(m_pJoint[lC].m_mmptPivot, dSinR, dCosR, mmptCenter.x, mmptCenter.y);
		::RotateConv(m_pJoint[lC].m_mmptPrev, dSinR, dCosR, 0, 0);
		::RotateConv(m_pJoint[lC].m_mmptNext, dSinR, dCosR, 0, 0);
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDhEiDiMiBfLiDiAiNmEiMhGiOfKiCmNiImIiJlKiCmFiBeC_xHqqkZx_
	BASE_CLASS::Rotate(dR, mmptCenter);
} // FCObjPoly::Rotate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::JointUpdated
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJjCmKjCgNiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	WidePoly_xZkqqHx_iCmMiDhIiDfHiDeGiLmIjApMiLnPiOjHiCmFjHjIjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjPoly::JointUpdated ()
{
} // FCObjPoly::JointUpdated.

//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::CalcOptimumElemLen
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFjDeLiCmIjAlIjDhIiCpAiMhGiOfKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFjDeLiCmIjAlIjDhIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjPoly::CalcOptimumElemLen () const
{
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
	DBLRect mmrtFrame;
	FFCalcFrame(mmrtFrame, GetJointSize(), GetJoints());
	// _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCmMjFjNiBhLiNiCiClD_xHqqkZx_ _xZkqqHx_iCmM_xHqqkZx_20_xZkqqHx_jFkKiCmM_xHqqkZx_1 _xZkqqHx_iCpAiKoOiPiAiCmJiBeC_xHqqkZx_
	mmetol mmElemLen = (mmrtFrame.Width() + mmrtFrame.Height()) / 20.0;
	// _xZkqqHx_jFfHiPiAjCgMiCoGiCoIiCoAjBoFiCkLiCkCiPoKiNiHiCmNiBeBjFfHiPiAjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	if (FFGetStdElemLen() < mmElemLen)
		mmElemLen = FFGetStdElemLen();
	return mmElemLen;
} // FCObjPoly::CalcOptimumElemLen.
//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

