#include "stdafx.h"
#include <float.h>			// For DBL_MAX.
#include "FoundDoc.h"		// For g_pDoc.
#include "RegData.h"		// For g_pReg.
#include "UndoArchive.h"	// For FCUndoArchive.
#include "UtilStdLib.h"		// For FFNext.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilMisc.h"		// For RotateConv.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilMath.h"		// For mmroundoff.
#include "UtilErr.h"		// For FFThrowMiscUnknown.
#include "UtilFile.h"		// For operator << (BYTEVector& vStream, const T data).
#include "UtilStr.h"		// For FFGetCSVTable.
// 06.11.22 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "UtilObj.h"		// For FFGetFramePoint.
#include "DynamicDrawView.h"// For g_pView.
#include "RichText.h"		// For FCRichText.
#include "ObjTextRect.h"	// For FCObjTextRect.
#include "ObjLine.h"		// For FCObjLine.
#include "ProObjFigurePen.h"	// For CFCProObjFigurePen.
#include "ProObjFigureBrush.h"	// For CFCProObjFigureBrush.
#include "ProTableText.h"		// For CFCProTableText.
#include "ProObjTextRectSizeLimit.h"	// For CFCProObjTextRectSizeLimit.
#include "PrsObjProperty.h"		// For CFCPrsObjProperty.
#include "ObjTable.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*************************************************************************
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>
 *
 *	_xZkqqHx_jFfMjFjEjFgJiCmNiBeBiDfKiDiLiCmGjAiFjFlNiMhCjApMiBeBjAiCjClMiMhCjApMiCkJiCoHiNfMjAkMiClDiCoKiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_jFfMjFjEjFgJiOkJjBmMiCmNiDePiDiLiBfLiDhGjFjEjFgJiCmMiDfEiDhFiDeOiDiJiDfIiCmFiCkAiCoIiBeBiClLiCmMiDiBiDjDiDgPiBfLiCmGiClFiCmE_xHqqkZx_
 *	_xZkqqHx_iDfKiDiLiCmNiDgFiDeMiDfIiDgHiLoJiMgAjFjEjFgJiBeBiMhCjApMiCmNjClMjApMjFjEjFgJiCmFjBoDjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_iClBiCoKiCoHiCpAiDfKiDiLjFjEjFgJiBeBiMhCjApMjFjEjFgJiCmGiMmEiCnEiBeC_xHqqkZx_
 *	_xZkqqHx_iDfKiDiLiBeBjAiFjFlNiMhCjApMiBeBjAiCjClMiMhCjApMiCmNiDeDiDjDiDgGiDgCiDeOiDfIiCmFjDmBjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiMfOiCmNiBeBiDfKiDiLiCmN_xHqqkZx_FCLineColumn_xZkqqHx_iMfOiBeBiMhCjApMiCmN_xHqqkZx_FCFrontSide_xZkqqHx_iMfOiCmFiCkAiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_jHoBiCkGiCmOiBeBiJlKjAhNiCpAjHoBiCmJiCnNiCoJiCmGiBeBiNlGiPoDiCmMiDfKiDiLiCmN_xHqqkZx_[0,0]_xZkqqHx_iBeBiJeFiJlKiCmMiDfKiDiLiCmN_xHqqkZx_[3,2]
 *	_xZkqqHx_iCmGiClFiCmEjFfMiClDiCoKiCmEiCkCiCoJiBeCiClBiCoKiCmN_xHqqkZx_FCLineColumn(0,0)_xZkqqHx_iBeB_xHqqkZx_FCLineColumn(3,2)
 *	_xZkqqHx_iCmFiCkAiCoIiBeBiClLiCoKiClMiCoKiCePiNhDjGnKiCePjHpBjGnKiBeBiCfCiNhDjGnKiCfBjHpBjGnKiCmGiCkCiCkEiInDjGkBiCmFiCkAiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_iDfKiDiLiCkKiClBiCmMiCoGiCkEiCmJ_xHqqkZx_[_xZkqqHx_iNhDiBeBjHpB_xHqqkZx_]_xZkqqHx_iCmGjFfMiMlLiClHiCoJiCmMiCmJjBmOiClFiCmEiBeBiMhCjApMiCmMiPoKiNiHiCmN_xHqqkZx_
 *	_xZkqqHx_jAiFjFlNiMhCjApMiCmGjAiCjClMiMhCjApMiCmFiPiHiPjIiCkKiInJiCmIiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_jAiFjFlNiMhCjApMiCmMiPoKiNiHiCmNiBeBiNlGiPoDiCkK_xHqqkZx_[0,0]_xZkqqHx_iBeBiJeFiJlKiCkK_xHqqkZx_[4,2]_xZkqqHx_iCmFiCkAiCoJiCkKiBeBiClBiCoKiCmN_xHqqkZx_
 *	FCFrontSide(0,0)_xZkqqHx_iBeB_xHqqkZx_FCFrontSide(4,2)_xZkqqHx_iCmFiCkAiCoIiBeBiClLiCoKiClMiCoKiCePiNhDjGnKiCePjHpBjGnKiBeB_xHqqkZx_
 *	_xZkqqHx_iCfDiNhDjGnKiCfBjHpBjGnKiCmGiCkCiCkEiInDjGkBiCmFiCkAiCoJiBeCiClBiCoKiCmJjBmOiClFiCmEiBeBjAiCjClMiMhCjApMiCmNiBeB_xHqqkZx_
 *	_xZkqqHx_iNlGiPoDiCkK_xHqqkZx_[0,0]_xZkqqHx_iBeBiJeFiJlKiCkK_xHqqkZx_[3,3]_xZkqqHx_iCmFiCkAiCoJiCkKiBeBiClBiCoKiCmN_xHqqkZx_
 *	FCFrontSide(0,0)_xZkqqHx_iBeB_xHqqkZx_FCFrontSide(3,3)_xZkqqHx_iCmFiCkAiCoIiBeBiClLiCoKiClMiCoKiCePjHpBjGnKiCePiNhDjGnKiBeB_xHqqkZx_
 *	_xZkqqHx_iCfCjHpBjGnKiCfCiNhDjGnKiCmGiCkCiCkEiInDjGkBiCmFiCkAiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_iClBiCmMiCoGiCkEiCmJiBeBjAiFjFlNiMhCjApMiCkK_xHqqkZx_[_xZkqqHx_iNhDiBeBjHpB_xHqqkZx_]_xZkqqHx_iCmMiPiHiPjIiCmFjFfMiClHiCmMiCmJjBmOiClFiCmEjAiCjClMiMhCjApMiCmN_xHqqkZx_
 *	[_xZkqqHx_jHpBiBeBiNhD_xHqqkZx_]_xZkqqHx_iCmMiPiHiPjIiCmFjFfMiClHiBeCiClBiCoKiCmNiBeBiNhDiBeBjHpBiCmGiCkCiCkEiNgMiCkGjFpLiCmFiCmNiCmIiCkNiBeB_xHqqkZx_
 *	_xZkqqHx_iMhCjApMiCpAjAlDjGmKiBgJjAiFjFlNiMhCjApMiCmNiNlGjBkEiBeBjAiCjClMiMhCjApMiCmNiPoDjBkEiBgKiCkJiCoHiMkJiClNiPoKiNiHiCmJiBeB_xHqqkZx_
 *	_xZkqqHx_jAlDjGmKiCmMjFmAiCnBiCpAjBoGiCfAiBeBiJkBiCkJiCoHiMkJiClNjFmAiCnBiCpAjBoGiCfBiCmGiClHiCoJiNgMiCkGjFpLiCmFiCkAiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_iClBiCmMiCoGiCkEiCmJiClFiClNjFpLiCkKiBeBjAiFjFlNiMhCjApMiBeBjAiCjClMiMhCjApMiCpAjDkPjHgMiCmJiIlFiCkGiCoJiClNiCnP_xHqqkZx_
 *	_xZkqqHx_iDhGiDiNiDePiDiJiDiAiPoDjFnGjHjIiCmFiCkAiCoIiBeBiCnMiClNjHjNiJpAiClFiCoCiClHiCkCiBeC_xHqqkZx_
 *
 *                  0              1              2          
 *                                                           
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]  [2,1]   [2,2]  [2,2]   [3,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *                                                           
 *	_xZkqqHx_jFfMjFjEjFgJiCmFiCmNiBeBiDeHiDeOiDfKiDiLiCmMiDfKiDiLiMiLiNiHiCmMiCoGiCkEiCmJiBeBjFkBjAjEiCmMiDfKiDiLiCpAiMiLiNiHiClFiCmE_xHqqkZx_
 *	_xZkqqHx_iIoKiCmCiCmMiDfKiDiLiCmGiClFiCmEiIlFiCkEiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_iMiLiNiHiClFiClNiPoKiNiHiCmNiBeBiMiLiNiHiClFiClNjFkBjAjEiDfKiDiLiCmMiCkEiClPiBeBiNlGiPoDiCmMiDfKiDiLjFjEjFgJiCpAiOgDiClFiCmE_xHqqkZx_
 *	_xZkqqHx_jBlMiCmMiDfKiDiLjFjEjFgJiCmNjBfDiCmEiNoNiPjMiClDiCoKiBeBiDePiDiLiBfLiDhGjFjEjFgJiCmMiDiBiDjDiDgPiBfLiCkJiCoHjGjFiPmBiClDiCoKiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_iCnMiClNiBeBiDfKiDiLjDkPiOgNiCpAiOgEjAnIiCmBiCmEiCkCiClNiMhCjApMjFjEjFgJiCoAjDkPjHgMiCmJiNoNiPjMiClDiCoKiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_iDfKiDiLiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_->_xZkqqHx_iDiBiDjDiDgPiBfLiDeDiDjDiDgGiDgCiDeOiDfIiDgFiBfLiDhFiDiL_xHqqkZx_ _xZkqqHx_iCmJiCmN_xHqqkZx_ -1 _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_iMhCjApMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_->_xZkqqHx_iDiBiDjDiDgPiBfLiDeDiDjDiDgGiDgCiDeOiDfIiDgFiBfLiDhFiDiL_xHqqkZx_ _xZkqqHx_iCoAjDkPjHgMiCmJ_xHqqkZx_ -1 _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiCmNiBeB_xHqqkZx_[2,2]_xZkqqHx_iCkJiCoH_xHqqkZx_[3,3]_xZkqqHx_iCmMjEmNiImNiCkKiMiLiNiHiClDiCoKiCmEiCkCiCoJiCkKiBeBiClBiCmMiPoKiNiHiBeB_xHqqkZx_
 *	[2,3]_xZkqqHx_iBeB_xHqqkZx_[3,2]_xZkqqHx_iBeB_xHqqkZx_[3,3]_xZkqqHx_iCmMiDfKiDiLjFjEjFgJiCmNjBlGiNnNiClJiClIiBeB_xHqqkZx_[2,2]_xZkqqHx_iCmMiDfKiDiLjFjEjFgJiCmJiCoGiCmBiCmE_xHqqkZx_
 *	_xZkqqHx_jFfMiOkGjDjJiCmMiLeAjEfMiCkKiCnMiCkJiCmIiCoNiCoKiCoJiBeC_xHqqkZx_
 *	_xZkqqHx_iClBiCmMiCoGiCkEiCmJiDfKiDiLiMiLiNiHiCmFiOlIiCoNiCoKiClNiDfKiDiLiCmFiCkAiCmBiCmEiCoAiBeBiPiIjHjNiPoDiDeBiDgIiDiMiDfIiCpAjFeLjHhGiCmG_xHqqkZx_
 *	_xZkqqHx_iClHiCoJiPoKiNiHiCkKiCkAiCoJiBeCiJlKjAhNiCmJiCkIiCkCiCmE_xHqqkZx_[2,3]_xZkqqHx_iBeB_xHqqkZx_[3,2]_xZkqqHx_iBeB_xHqqkZx_[3,3]_xZkqqHx_iCpAiJlMjBhKiDeBiDgIiDiMiDfIiBeB_xHqqkZx_
 *	_xZkqqHx_iClLiCoKiCoHiCpA_xHqqkZx_[2,2]_xZkqqHx_iCmFjFfMiMlLiClHiCoJiPoKiNiHiCmNiOmAiDeBiDgIiDiMiDfIiCmGiMmEiCnEiBeC_xHqqkZx_
 *	_xZkqqHx_iCmIiCkIiBeBiMhCjApMiCmMiPoKiNiHiBeBiNoNiPjMiClDiCoKiClNiMhCjApMiCpAjBlMiCmMiMhCjApMiCkKiLeAjEfMjDeJiCmJiCnMiCkJiCmIiCkEjFeLjHhGiCmNiCmIiCkCiCkKiBeB_xHqqkZx_
 *	_xZkqqHx_jFnGiLfIiPoDiBeBiNoNiPjMiClDiCoKiClNiMhCjApMiCpAiKnMiCnNjDlOiCmIiCkCiDeBiDgIiDiMiDfIiCpAiOmAiDeBiDgIiDiMiDfIiBeBiNoNiPjMiClDiCoKiClNiMhCjApMiCpA_xHqqkZx_
 *	_xZkqqHx_iKnMiCnNjDlOiCoJiDeBiDgIiDiMiDfIiCpAiJlMjBhKiDeBiDgIiDiMiDfIiCmGiMmEiCnEiBeC_xHqqkZx_
 *	
 *                  0              1              2              3          
 *                                                                          
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,3]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]  [0,3]   [4,0]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]  [1,3]   [4,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_             _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[2,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]          [2,2]  [2,2]                  [4,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]                         [4,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEjPiEjPiEjP_xHqqkZx_[4,3]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/

// _xZkqqHx_iDgFiDeMiDfIiDgHjFmPiNfIiCmJiCoGiCoJiOkJjDkOiDfEiDeDiDfJjFmPiNfIiCmMiCoEiCmGiCoIiBeC_xHqqkZx_
static mmetol s_mmAutoTextHorzSpace = 0.2;
static mmetol s_mmAutoTextVertSpace = 0.01;

//////////////////////////////////////////////////////////////////////
// FCObjTable _xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::FCObjTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_FDFoundDoc_xZkqqHx_iCmM_xHqqkZx_InStream_xZkqqHx_iCmFjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *          _xZkqqHx_iDeBiDeDiDgFiDiAiCmMjEhKjHpBiBeC_xHqqkZx_
 *              0     
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkC_xHqqkZx_
 *         0_xZkqqHx_iEkA_xHqqkZx_ (0,0)_xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *          _xZkqqHx_jAiFjFlNiMhCjApMiCmMjEhKjHpBiBeC_xHqqkZx_
 *              0     
 *          _xZkqqHx_iEkB_xHqqkZx_(0,0) _xZkqqHx_iEkC_xHqqkZx_
 *         0_xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkE_xHqqkZx_(0,1) _xZkqqHx_iEkD_xHqqkZx_
 *
 *          _xZkqqHx_jAiCjClMiMhCjApMiCmMjEhKjHpBiBeC_xHqqkZx_
 *              0     
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkC_xHqqkZx_
 *      0  (0,0)   (0,1)
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjTable::FCObjTable ()
{
	// m_vLineHeight_xZkqqHx_iCmN_xHqqkZx_double_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	// sizeof(BASE_CLASS)_xZkqqHx_iCmNiBeB_xHqqkZx_4_xZkqqHx_iCmMjEhLjAjEiClOiCmBiClNiCmMiCmFiBeBjFoCjAlDiCmJ_xHqqkZx_4_xZkqqHx_iCpAjBkLiClHiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjTable, m_mmptLeftTop));
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	memset(&m_mmptLeftTop, 0, sizeof(FCObjTable) - offsetof(FCObjTable, m_mmptLeftTop));
} // FCObjTable::FCObjTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	: _xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	: _xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjTable::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_TABLE) return TRUE;
	return BASE_CLASS::IsKindOf(nType);
} // FCObjTable::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjArc::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiMfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiCmMiMfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTObjectType FCObjTable::Type () const
{
	return FDOJ_TABLE;
} // FCObjTable::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::OnDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsMono	:_xZkqqHx_iDiCiDgNiDeOiDiNjFgAiJoGiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::OnDraw (CDC* pDC, BOOL bIsMono)
{
	//----- _xZkqqHx_iDfKiDiLiCpAjFgAiJoG_xHqqkZx_ -----
	for (long lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
	{
		for (long lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
		{
			FCObjTextRect* pCell = GetCell(FCLineColumn(lLineIndex, lColumnIndex));
			// _xZkqqHx_jGjFiPmBiClDiCoKiClNiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (pCell == NULL) continue;
			if (g_->eDrawWhich != FDDR_DISPLAY ||
				g_pView->IsRgnOverlap(pCell->GetOuterFrame()))
				pCell->OnDraw(pDC, bIsMono);
		}
	}
	long lFrontIndex;
	long lSideIndex;
	//----- _xZkqqHx_jAiFjFlNiMhCjApMiCpAjFgAiJoG_xHqqkZx_ -----
	for (lFrontIndex = 0; lFrontIndex <= GetLineCount(); lFrontIndex++)
	{
		for (lSideIndex = 0; lSideIndex != GetColumnCount(); lSideIndex++)
		{
			FCObjLine* pRuled = GetRuled(TRUE, FCFrontSide(lFrontIndex, lSideIndex));
			// _xZkqqHx_jGjFiPmBiClDiCoKiClNiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (pRuled == NULL) continue;
			if (g_->eDrawWhich != FDDR_DISPLAY ||
				g_pView->IsRgnOverlap(pRuled->GetOuterFrame()))
				pRuled->OnDraw(pDC, bIsMono);
		}
	}
	//----- _xZkqqHx_jAiCjClMiMhCjApMiCpAjFgAiJoG_xHqqkZx_ -----
	for (lFrontIndex = 0; lFrontIndex <= GetColumnCount(); lFrontIndex++)
	{
		for (lSideIndex = 0; lSideIndex != GetLineCount(); lSideIndex++)
		{
			FCObjLine* pRuled = GetRuled(FALSE, FCFrontSide(lFrontIndex, lSideIndex));
			// _xZkqqHx_jGjFiPmBiClDiCoKiClNiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (pRuled == NULL) continue;
			if (g_->eDrawWhich != FDDR_DISPLAY ||
				g_pView->IsRgnOverlap(pRuled->GetOuterFrame()))
				pRuled->OnDraw(pDC, bIsMono);
		}
	}
	// Superclass_xZkqqHx_iKnGjAjEiCpAjEpCiCnBiJhKiCkGiCmEiOmAiNhDiBeC_xHqqkZx_
	BASE_BASE_CLASS::OnDraw(pDC, bIsMono);
} // FCObjTable::OnDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjFigure::IsEqual
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiKkOjBfDiCmJjDjJiClFiCkCiCmMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkNiBeBiLeAjEfMjDeJiCmJjDjJiClFiCkCiClBiCmGiCpAjClCiCnHiCoJiBeCjHoBiCkGiCmOiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNjEoEiKhCiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_jEoEiKhCjAoGiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDjJiClFiCkCiPoKiNiHiBeB_xHqqkZx_ FALSE  :_xZkqqHx_iIoBiCkEiPoKiNiH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClI_xHqqkZx_BASE_CLASS_xZkqqHx_iCmMjEoEiKhCiCpAiClHiCoJiBeCiClLiCmMiOjPiCmJiOkJjFkKiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_ObjDynabase::IsEqual_xZkqqHx_iCmFiDeOiDiJiDfIiCmMiMfOiCpAjEoEiKhCiClHiCoJiCmMiCmFiBeB_xHqqkZx_
 *			BASE_CLASS::IsEqual_xZkqqHx_iCkK_xHqqkZx_TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiMfOiCmNjDjJiClFiCkCiCmGiClFiCmEiCoGiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjTable::IsEqual (const FCObjDynabase* objp) const
{
	if (!BASE_CLASS::IsEqual(objp)) return FALSE;
	const FCObjTable* pObjTable = (const FCObjTable*)objp;
	// _xZkqqHx_jFjEjFgJjEhKjHpBiCpAiDiBiDjDiDgPiBfLiDeDiDjDiDgGiDgCiDeOiDfIjEhKjHpBiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
	vector<longVector> vvCellMemberIndexA;
	vector<longVector> vvCellMemberIndexB;
	ObjArrayToMemberArray(vvCellMemberIndexA, m_vvCell);
	pObjTable->ObjArrayToMemberArray(vvCellMemberIndexB, pObjTable->m_vvCell);
	vector<longVector> vvHorzRuledMemberIndexA;
	vector<longVector> vvHorzRuledMemberIndexB;
	ObjArrayToMemberArray(vvHorzRuledMemberIndexA, m_vvHorzRuled);
	pObjTable->ObjArrayToMemberArray(vvHorzRuledMemberIndexB, pObjTable->m_vvHorzRuled);
	vector<longVector> vvVertRuledMemberIndexA;
	vector<longVector> vvVertRuledMemberIndexB;
	ObjArrayToMemberArray(vvVertRuledMemberIndexA, m_vvVertRuled);
	pObjTable->ObjArrayToMemberArray(vvVertRuledMemberIndexB, pObjTable->m_vvVertRuled);

	return (almosteq(m_mmptLeftTop, pObjTable->m_mmptLeftTop) &&
			almosteq(m_vLineHeight, pObjTable->m_vLineHeight) &&
			almosteq(m_vColumnWidth, pObjTable->m_vColumnWidth) &&
			vvCellMemberIndexA == vvCellMemberIndexB &&
			vvHorzRuledMemberIndexA == vvHorzRuledMemberIndexB &&
			vvVertRuledMemberIndexA == vvVertRuledMemberIndexB);
} // FCObjTable::IsEqual.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjTable::OutStream (FCUndoArchive& ar)
void FCObjTable::OutStream (FCUndoArchive& ar, BOOL bIsOutBezier)
{
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BASE_CLASS::OutStream(ar);
	BASE_CLASS::OutStream(ar, bIsOutBezier);
	// _xZkqqHx_iNlGiPoDiNmAjFfHiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_mmptLeftTop;
	// _xZkqqHx_iNhDjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << long(m_vLineHeight.size());
	// _xZkqqHx_jHpBjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << long(m_vColumnWidth.size());
	mmetolVector::const_iterator iMm;
	// _xZkqqHx_iKgFiNhDiCmMiNiCiClDiCpAiPgPjHmNiBeC_xHqqkZx_
	for (iMm = m_vLineHeight.begin(); iMm != m_vLineHeight.end(); iMm++)
		ar << *iMm;
	// _xZkqqHx_iKgFjHpBiCmMjFjNiCpAiPgPjHmNiBeC_xHqqkZx_
	for (iMm = m_vColumnWidth.begin(); iMm != m_vColumnWidth.end(); iMm++)
		ar << *iMm;
	// _xZkqqHx_iDfKiDiLiCpAiBeBiCfAiNhDiCfAjHpBiBeBiCfAiNhDiCfBjHpBiBeBiCfAiNhDiCfCjHpBiBeFiBeFiBeFiCfBiNhDiCfAjHpBiBeBiCfBiNhDiCfBjHpBiBeBiCfBiNhDiCfCjHpBiBeFiBeFiBeF_xHqqkZx_
	// _xZkqqHx_iCmMiPiHiCmJiPgPjHmNiBeC_xHqqkZx_
	// _xZkqqHx_jFjEjFgJiCpAiDiBiDjDiDgPiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCmJjFmPiKlHiClFiCmEjFnLjBlGiClHiCoJiBeC_xHqqkZx_
	// InStream_xZkqqHx_iCmFjDmHiCnNiNjOiCnOiCmGiCkLjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNjGkCjDgPjIfOiCmMiPpDjBnEiCmIiCmMiCmFiBeB_xHqqkZx_
	// _xZkqqHx_jFnLjBlGiCmJjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
	map<const FCObjDynabase*, long> mpObjToIndex;
	GetObjToIndexTable(mpObjToIndex);
	// _xZkqqHx_jFjEjFgJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnLjBlGiBeC_xHqqkZx_
// 05.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	vector<ObjDynabaseVector>::const_iterator iiObj;
	mdef_const_iterator(vector<ObjDynabaseVector>, iiObj);
	ObjDynabaseVector::const_iterator iObj;
	m3_for (iiObj, m_vvCell, m_vvHorzRuled, m_vvVertRuled)
	{
		for (iObj = (*iiObj).begin(); iObj != (*iiObj).end(); iObj++)
			ar << mpObjToIndex[*iObj];
	}
} // FCObjTable::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::InStream (FCUndoArchive& ar)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::InStream(ar);

	// _xZkqqHx_iKgFjFmPjAjEiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_vvHorzRuled.clear();
	m_vvVertRuled.clear();
	m_vvCell.clear();
	m_vLineHeight.clear();
	m_vColumnWidth.clear();
	// _xZkqqHx_iNlGiPoDiNmAjFfHiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> m_mmptLeftTop;
	long lLineCount;
	long lColumnCount;
	// _xZkqqHx_iNhDjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> lLineCount;
	// _xZkqqHx_jHpBjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> lColumnCount;

	ASSERT((lLineCount == 0 && lColumnCount == 0) || (lLineCount != 0 && lColumnCount != 0));

	// _xZkqqHx_iNhDiCmGjHpBiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeBiImIiJlKiCmMjDmHiCnNiNjOiCnNiPiIjHjNiCpAiNhDiCmBiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
	// m_vvHorzRuled.push_back(ObjDynabaseVector()) _xZkqqHx_iCmFiDfDiDhOiCkKjAnNjCoIiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	if (lLineCount != 0 && lColumnCount != 0)
	//----- _xZkqqHx_iNhDiCmGjHpBiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		long lLineIndex;
		long lColumnIndex;
		// _xZkqqHx_iKgFiNhDiCmMiNiCiClDiCpAjDpMjHmNiBeC_xHqqkZx_
		for (lLineIndex = 0; lLineIndex != lLineCount; lLineIndex++)
		{
			mmetol mmHeight;
			ar >> mmHeight;
			m_vLineHeight.push_back(mmHeight);
		}
		// _xZkqqHx_iKgFjHpBiCmMjFjNiCpAjDpMjHmNiBeC_xHqqkZx_
		for (lColumnIndex = 0; lColumnIndex != lColumnCount; lColumnIndex++)
		{
			mmetol mmWidth;
			ar >> mmWidth;
			m_vColumnWidth.push_back(mmWidth);
		}

		// _xZkqqHx_iDfKiDiLiCpAiBeBiCfAiNhDiCfAjHpBiBeBiCfAiNhDiCfBjHpBiBeBiCfAiNhDiCfCjHpBiBeFiBeFiBeFiCfBiNhDiCfAjHpBiBeBiCfBiNhDiCfBjHpBiBeBiCfBiNhDiCfCjHpBiBeFiBeFiBeF_xHqqkZx_
		// _xZkqqHx_iCmMiPiHiCmJjDpMjHmNiBeC_xHqqkZx_
		for (lLineIndex = 0; lLineIndex != lLineCount; lLineIndex++)
		{
			m_vvCell.push_back(ObjDynabaseVector());
			for (lColumnIndex = 0; lColumnIndex != lColumnCount; lColumnIndex++)
			{
				long lMemberIndex;
				ar >> lMemberIndex;
				if (lMemberIndex != -1)
					m_vvCell.back().push_back(GetMember(lMemberIndex));
				else
					m_vvCell.back().push_back(NULL);
			}
		}
		long lFrontIndex;
		long lSideIndex;
		// _xZkqqHx_jAiFjFlNiMhCjApMiCpAiBeB_xHqqkZx_[0,0] [0,1] [0,2]_xZkqqHx_iBgD_xHqqkZx_[1,0] [1,1] [1,2]_xZkqqHx_iBgDiCmMiPiHiCmJjDpMjHmNiBeC_xHqqkZx_
		for (lFrontIndex = 0; lFrontIndex <= lLineCount; lFrontIndex++)
		{
			m_vvHorzRuled.push_back(ObjDynabaseVector());
			for (lSideIndex = 0; lSideIndex != lColumnCount; lSideIndex++)
			{
				long lMemberIndex;
				ar >> lMemberIndex;
				if (lMemberIndex != -1)
					m_vvHorzRuled.back().push_back(GetMember(lMemberIndex));
				else
					m_vvHorzRuled.back().push_back(NULL);
			}
		}
		// _xZkqqHx_jAiCjClMiMhCjApMiCpAiBeB_xHqqkZx_[0,0] [0,1] [0,2]_xZkqqHx_iBgD_xHqqkZx_[1,0] [1,1] [1,2]_xZkqqHx_iBgDiCmMiPiHiCmJjDpMjHmNiBeC_xHqqkZx_
		for (lFrontIndex = 0; lFrontIndex <= lColumnCount; lFrontIndex++)
		{
			m_vvVertRuled.push_back(ObjDynabaseVector());
			for (lSideIndex = 0; lSideIndex != lLineCount; lSideIndex++)
			{
				long lMemberIndex;
				ar >> lMemberIndex;
				if (lMemberIndex != -1)
					m_vvVertRuled.back().push_back(GetMember(lMemberIndex));
				else
					m_vvVertRuled.back().push_back(NULL);
			}
		}
	}
} // FCObjTable::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::NewObjPolygonForResize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJjHhAiCmMiDhMiDiKiDiJiDeDiDjDiNoMjAkMiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	:_xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	:_xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iClipSize	:mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmMiDhEiDiMiBfLiDiAjFgAiJoGiCmGiBeBjFjEjFgJiDfEiDeDiDfJiMhGiOfKiOjOiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiCoGiCkEiCmJjFkBjAjEiCmMjFjEjFgJiCmMiPfHiNiHiCmMiPoKiNiHiBeB_xHqqkZx_DBL_MAX_xZkqqHx_iCmF_xHqqkZx_
 *			_xZkqqHx_iLoGjAnIiCoHiCoKiClNjFkBjAjEiCmMiDhMiDiKiDiJiDeDiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::NewObjPolygonForResize (	DBLPointVector& vmmptPoly,
											mmetol mmElemLen,
											const DBLRect mmrtaClip[],
											int iClipSize) const
{
	// _xZkqqHx_iDfKiDiLiCkKiDiKiDfEiDeDiDfJiCpAjAkHiMmAiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeBjFfMiCmGjDkPiClGiDeDiDiBiBfLiDfHiCmF_xHqqkZx_
	// _xZkqqHx_iDhMiDiKiDiJiDeDiDjDiCpAjFgAiJoGiClHiCoJiCmGiBeBiDiKiDfEiDeDiDfJjCiGiCmMiDeDiDiBiBfLiDfHiCmGiDiKiDfEiDeDiDfJiMoDiCmM_xHqqkZx_
	// _xZkqqHx_jFjEjFgJiDeDiDiBiBfLiDfHiCkKjAeIiCkCiIoBiCkEiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jFfMiCmMiKePjBkEiLoJiMgAiClOiCkPiCpAiDeDiDiBiBfLiDfHiCmGiClFiCmEjFnEiClHiBeC_xHqqkZx_
	vmmptPoly.assign(5);
	GetResizeFrame().Get5Polygon(&vmmptPoly[0]);
} // FCObjTable::NewObjPolygonForResize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::CanRotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpBjDfNiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjTable::CanRotate () const
{
	return FALSE;
} // FCObjTable::CanRotate.

//----- 05.06.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetIsResizableHorz
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjNiCmJiDiKiDfEiDeDiDfJiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmWidth	:_xZkqqHx_iDiKiDfEiDeDiDfJiClFiClNiCkCjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjTable::GetIsResizableHorz (mmetol mmWidth) const
//{
//	return CalcNewColumnWidth(mmetolVector(), mmWidth);
//} // FCObjTable::GetIsResizableHorz.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetIsResizableVert
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNiCiClDiCmJiDiKiDfEiDeDiDfJiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmHeight:_xZkqqHx_iDiKiDfEiDeDiDfJiClFiClNiCkCiNiCiClDiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjTable::GetIsResizableVert (mmetol mmHeight) const
//{
//	return CalcNewLineHeight(mmetolVector(), mmHeight);
//} // FCObjTable::GetIsResizableVert.
//----- 05.06.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetMemberResizeHorzByText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCmMiBeBjAiFjFlNjFpLiMpMiCmMiDiKiDfEiDeDiDfJiLeLjBkFiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_RPT_NONE:
// *					_xZkqqHx_iDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCmIiCkCiBeC_xHqqkZx_
// *			FD_RPT_H_LEFT:
// *					_xZkqqHx_jFjEjFgJiCmMiNlGjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_H_CENTER:
// *					_xZkqqHx_jFjEjFgJiCmMjCiGiJjLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_H_RIGHT:
// *					_xZkqqHx_jFjEjFgJiCmMiJeFjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiFjFlNjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiBeBiDiBiDjDiDgPiBfLjFjEjFgJiCkKiDiKiDfEiDeDiDfJjBkOjAkLiCpAiOjNiCmBiCmEiCkCiClNiCoHiBeB_xHqqkZx_
// *			_xZkqqHx_jAiFjFlNiBeFjAiCjClMjHlMjFpLiMpMiCmMiDiKiDfEiDeDiDfJjBkOjAkLiCmJiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmFiCmNiBeBiIoKjFpLiMpMiCmMiCnNiCmMiDiKiDfEiDeDiDfJiCmNjGlDjHjNiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WORD FCObjTable::GetMemberResizeHorzByText (const FCObjDynabase* pObj) const
//{
//	return pObj->GetStdResizeHorzByText();
//} // FCObjTable::GetMemberResizeHorzByText.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetMemberResizeVertByText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCmMiBeBjAiCjClMjFpLiMpMiCmMiDiKiDfEiDeDiDfJiLeLjBkFiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_RPT_NONE:
// *					_xZkqqHx_iDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmMjAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCmIiCkCiBeC_xHqqkZx_
// *			FD_RPT_V_TOP:
// *					_xZkqqHx_jFjEjFgJiCmMiPoDjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_V_CENTER:
// *					_xZkqqHx_jFjEjFgJiCmMjCiGiJjLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *			FD_RPT_V_BOTTOM:
// *					_xZkqqHx_jFjEjFgJiCmMiJlKjCfLiCpAiMmFjCoIiClFiBeBiDgFiDeMiDfIiDgHiDfEiDeDiDfJiCmJjFjEjFgJiDfEiDeDiDfJiCmM_xHqqkZx_
// *					_xZkqqHx_jAiCjClMjFpLiMpMiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiBeBiDiBiDjDiDgPiBfLjFjEjFgJiCkKiDiKiDfEiDeDiDfJjBkOjAkLiCpAiOjNiCmBiCmEiCkCiClNiCoHiBeB_xHqqkZx_
// *			_xZkqqHx_jAiFjFlNiBeFjAiCjClMjHlMjFpLiMpMiCmMiDiKiDfEiDeDiDfJjBkOjAkLiCmJiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmFiCmNiBeBiIoKjFpLiMpMiCmMiCnNiCmMiDiKiDfEiDeDiDfJiCmNjGlDjHjNiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WORD FCObjTable::GetMemberResizeVertByText (const FCObjDynabase* pObj) const
//{
//	return pObj->GetStdResizeVertByText();
//} // FCObjTable::GetMemberResizeVertByText.
//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetMemberFixResizeByText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCmMiBeBiDgFiDeMiDfIiDgHjFmPiNfIiOjOiCmMjCmHiPfNiDiKiDfEiDeDiDfJiCmMiLeLjBkFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_RPT_V_MASK _xZkqqHx_iCmFiDhNiDfIiDeOiClFiClNjCgMiBeC_xHqqkZx_
 *				FD_RPT_NONE		:_xZkqqHx_jAiCjClMjFpLiMpMiCmJiCmNiDfEiDeDiDfJjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *				FD_RPT_V_TOP	:_xZkqqHx_jFjEjFgJiCmMiPoDiCpAiMmFjCoIiClFiCmEiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *				FD_RPT_V_BOTTOM	:_xZkqqHx_jFjEjFgJiCmMiJlKiCpAiMmFjCoIiClFiCmEiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *				FD_RPT_V_CENTER	:_xZkqqHx_jFjEjFgJiCmMjCiGjAfDiCpAiMmFjCoIiClFiCmEiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *			FD_RPT_H_MASK _xZkqqHx_iCmFiDhNiDfIiDeOiClFiClNjCgMiBeC_xHqqkZx_
 *				FD_RPT_NONE		:_xZkqqHx_jAiCjClMjFpLiMpMiCmJiCmNiDfEiDeDiDfJjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *				FD_RPT_H_LEFT	:_xZkqqHx_jFjEjFgJiCmMiNlGiCpAiMmFjCoIiClFiCmEiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *				FD_RPT_H_RIGHT	:_xZkqqHx_jFjEjFgJiCmMiJeFiCpAiMmFjCoIiClFiCmEiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *				FD_RPT_H_CENTER	:_xZkqqHx_jFjEjFgJiCmMjCiGjAfDiCpAiMmFjCoIiClFiCmEiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiBeBiDiBiDjDiDgPiBfLjFjEjFgJiCkKjAiFjFlNiBeFjAiCjClMiCmMiCkCiClIiCoKiCkJiCmJ_xHqqkZx_
 *			_xZkqqHx_iDiKiDfEiDeDiDfJiJmCiCpAiOjNiCmBiCmEiCkCiClNiCoHiBeBjAiFjFlNiBeFjAiCjClMjHlMjFpLiMpMiCpAiDiKiDfEiDeDiDfJiJmC_xHqqkZx_
 *			_xZkqqHx_iCmJiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmFiCmNiBeBiIoKjFpLiMpMiCmMiCnNiCmMiDiKiDfEiDeDiDfJiCmNjGlDjHjNiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FCObjTable::GetMemberFixResizeByText (const FCObjDynabase* pObj) const
{
	// _xZkqqHx_jFfMiCmMiDfKiDiLiCmMiDgFiDeMiDfIiDgHiCpAjFnCiPfHiClHiCoJiNnLiBeBiDeHiDgGiDeCiDfOiPoDiCmFiDiKiDfEiDeDiDfJiClHiCoJjFpLjGeA_xHqqkZx_
	// _xZkqqHx_iCpAiMiIjCoIiClHiCoJiBeCjFfMiCmMiDfKiDiLiCmNiJeFiJlKiCmMiCnNjAeMiCnBiCoJiCoGiCkEiCmJiMkJiClJiCoJiBeC_xHqqkZx_
	WORD wFixResize = 0;
	if (pObj->GetStdFixResizeByText() & FD_RPT_H_MASK)
		wFixResize |= FD_RPT_H_LEFT;
	if (pObj->GetStdFixResizeByText() & FD_RPT_V_MASK)
		wFixResize |= FD_RPT_V_TOP;
	return wFixResize;
} // FCObjTable::GetMemberFixResizeByText.
//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetIsMemberShortenByText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCmMiDgFiDeMiDfIiDgHiPgLiPkMiOjOiCmJiBeBjAgFjFjEjFgJiCoAiPgLiPkMiClHiCoJiCkJiCmHiCkEiCkJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDiBiDjDiDgPiBfLjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPgLiPkMiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjTable::GetIsMemberShortenByText (const FCObjDynabase* pObj) const
{
	return pObj->GetIsShortenByText();
} // FCObjTable::GetIsMemberShortenByText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::AdjustObjectSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjFjEjFgJiCpAiBeBiClBiCmMjFjEjFgJiCmJiKnMiCnMiCoKiCoJjFjEjFgJiBgJiDiBiDjDiDgPiBfLiBgKiCmMiDgFiDeMiDfIiDgHiCmM_xHqqkZx_
 *			_xZkqqHx_iIoMiCoKiCkKjGlDiCkNiCmIiCoJiCoGiCkEiCmJiDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pTextObj	:_xZkqqHx_iDgFiDeMiDfIiDgHiCkKjFmPiNfIiClDiCoKiClNjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRatioHorz	:_xZkqqHx_iDgFiDeMiDfIiDgHiCmMjAiFjFlNjFpLiMpMiDiKiDfEiDeDiDfJiCmMiKgHjBoFjHkGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRatioVert	:_xZkqqHx_iDgFiDeMiDfIiDgHiCmMjAiCjClMjFpLiMpMiDiKiDfEiDeDiDfJiCmMiKgHjBoFjHkGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dTextAngle	:_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmFiDfCiDhNiDjDiDgIjEkNiNhDiClHiCoJiClBiCmGiCmJjCiNiInDiBeCiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkCiCmEiCkIiCkN_xHqqkZx_
 *			_xZkqqHx_jFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDeOiDiJiDfIjCiGiCmFiCmNiCmIiCkNiBeBiCoNiClEiCoNiClEjFjEjFgJiDeOiDiJiDfIjCiGiCmJiClBiCmMiKnGjAjEiCpAjChFiCkNiCmMiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_jFfMjFjEjFgJiCmFiDiBiDjDiDgPiBfLiCkKiDiKiDfEiDeDiDfJiClDiCoKiClNiNnLiCmMiPiIjHjNiCpAiNhDiCoNiClJiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::AdjustObjectSize (	FCObjDynabase* pTextObj,
									double dRatioHorz,
									double dRatioVert,
									const DBLPoint& mmptFixPoint)
{
	if (pTextObj == NULL)
	//----- _xZkqqHx_jBfDiCmEiCmMiDfKiDiLiCmJiDgFiDeMiDfIiDgHiNiHiCoNiClJiCpAjDeLjHhAiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		AdjustObjectSize(mmptFixPoint);
		return;
	}

	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDfEiDeDiDfJjFmPiNfIiCkKiOhHiOkGiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiJlNiCoAiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (almosteq(dRatioHorz, 1.0) && almosteq(dRatioVert, 1.0)) return;

	// _xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmMiMmFjCoIjDfPiCpAiBeBiNlGiPoDiCkJiCoHiCmMiDhEiDiMiBfLiDiAiDfEiDeDiDfJiCmJjBmOiClHiCoJjEoEjHkGiCmFiLeMjIfOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	const double dFixRatioX = (mmptFixPoint.x - GetResizeFrame().left) / GetResizeFrame().Width();
	const double dFixRatioY = (mmptFixPoint.y - GetResizeFrame().top) / GetResizeFrame().Height();

	// _xZkqqHx_iDfKiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	FCLineColumn cellIndex;
	GetCellIndex(cellIndex, pTextObj);

	//----- _xZkqqHx_iImIiNhOiBeBjCfAjDmGiDfKiDiLiCmMiPoKiNiH_xHqqkZx_ -----

	// dRatioHorz_xZkqqHx_iBeB_xHqqkZx_dRatioVert _xZkqqHx_iCmNiDgFiDeMiDfIiDgHiCmMiKhAjDhI_xHqqkZx_=0_xZkqqHx_iCmJjBmOiClFiCmEjAiFjFlNiBeFjAiCjClMiCmIiCmMiCmFiBeB_xHqqkZx_
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKiJpBjDfNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiCoKiCmJiNiHiCoNiClJiCmEiPeDjAlDiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	// 90_xZkqqHx_jDhIiJpBjDfNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiKgHjBoFjEoEiCmM_xHqqkZx_X_xZkqqHx_iCmG_xHqqkZx_Y_xZkqqHx_iCpAjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCoKiCmJiCoGiCmBiCmEiBeBiDfKiDiLiCmMiKgHjBoFjEoEiCmGiCmIiCoJiBeC_xHqqkZx_
	if (almosteq(pTextObj->GetTextAngle(), 0.5) || almosteq(pTextObj->GetTextAngle(), 1.5))
		::Exchange(dRatioHorz, dRatioVert);

	// _xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJiCpAiOgHiCmBiCmEiBeBiDfKiDiLiCmMiKgHjBoFjCgMiCpAiOfKiPgPiBeC_xHqqkZx_
	// _xZkqqHx_iMiLiNiHiDfKiDiLiCmMiPoKiNiHiCmNiBeB_xHqqkZx_LineHeight * (dRatioVert - 1.0) _xZkqqHx_iCmFiCmNjAlDiClFiCkCjCgMiCkKiOfKiPgPiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	const mmetol mmInflateX = pTextObj->GetResizeFrame().Width() * (dRatioHorz - 1.0);
	const mmetol mmInflateY = pTextObj->GetResizeFrame().Height() * (dRatioVert - 1.0);

	if (!almost0(mmInflateX))
	//----- _xZkqqHx_iDfKiDiLiCmMjAiFjFlNjFpLiMpMiCnGiCmMiKgHjBoFiBeFiPgLiPkMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAfGiClFiCkCjFjNiCpAiOfKiPgPiBeCjFiJiCmMjCgMiCoAiCkAiCoIjDlOiCoJiCkKiBeB_xHqqkZx_
		// cellIndex _xZkqqHx_iCmMiNmFiPkMiDfEiDeDiDfJiCoAjClCiCnHiCoJiCmMiCmFiBeBjFoCjAlDiClDiCoKiCoJiBeC_xHqqkZx_
		mmetol mmNewWidth = GetColumnWidth(cellIndex.GetColumnIndex()) + mmInflateX;
		if (mmInflateX < 0.0)
		//----- _xZkqqHx_iDfEiDeDiDfJiPgLiPkMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// stCellIndex _xZkqqHx_iCmJiOmAiDeBiDgIiDiMiDfIiCmMiDfKiDiLiCmMiCnNiPfHiCnPiCoJiBeC_xHqqkZx_
			set<FCLineColumn> stCellTmp;
			set<FCLineColumn> stCellIndex;
			long lLineIndex;
			for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
				stCellTmp.insert(FCLineColumn(lLineIndex, cellIndex.GetColumnIndex()));
			// _xZkqqHx_iJlMjBhKiDeBiDgIiDiMiDfIiCmMiDfKiDiLiPfHiNiHiCkJiCoHiBeBjBmOiJjOiClHiCoJiOmAiDeBiDgIiDiMiDfIiCmMiDfKiDiLiPfHiNiHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			GetRealCell(stCellIndex, stCellTmp);

			// _xZkqqHx_iClBiCmMjHpBiCmFiNmFjBoFiCmMiDgFiDeMiDfIiDgHjFjNiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			mmetol mmMaxWidth = 0.0;
			set<FCLineColumn>::const_iterator iLc;
			for (iLc = stCellIndex.begin(); iLc != stCellIndex.end(); iLc++)
			{
				FCObjTextRect* pCell = GetCell(*iLc);
				mmetol mmWidth;
				if (almosteq(pCell->GetTextAngle(), 0.0) || almosteq(pCell->GetTextAngle(), 1.0))
					mmWidth = GetCellWidthMin(*iLc);
				else
					mmWidth = GetCellHeightMin(*iLc);
				if (mmMaxWidth < mmWidth)
					mmMaxWidth = mmWidth;
			}
			// _xZkqqHx_iClBiCmMjHpBiCmFiNmFjBoFiCmMiDgFiDeMiDfIiDgHjFjNiCoGiCoIiLlHiCkCjFjNiCmJjFmPiNfIiCmNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
			if (mmNewWidth < mmMaxWidth)
				mmNewWidth = mmMaxWidth;
			// _xZkqqHx_iNkBiCmMjFjNiCoGiCoIiLlHiCkNiCmIiCoJiPoKiNiHiCmMiCnNiBeBjHpBjFjNjFmPiNfIiCpAiOmAiNhDiBeC_xHqqkZx_
			if (GetColumnWidth(cellIndex.GetColumnIndex()) < mmNewWidth)
				mmNewWidth = GetColumnWidth(cellIndex.GetColumnIndex());
		}
//----- 05.08.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iClBiCmMjHpBiCmMiNmFiPkMjCgMiBeBiNmFjBoFjCgMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		mmetol mmMin;
		mmetol mmMax;
		CalcColumnMinMax(mmMin, mmMax, cellIndex.GetColumnIndex());
		if (mmNewWidth < mmMin) mmNewWidth = mmMin;
		if (mmMax < mmNewWidth) mmNewWidth = mmMax;
//----- 05.08.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		FFSnapGeMP(&mmNewWidth, NULL);
		g_pDoc->CmdSetTableColumnWidth(this, cellIndex.GetColumnIndex(), mmNewWidth);
	}
	if (!almost0(mmInflateY))
	//----- _xZkqqHx_iDfKiDiLiCmMjAiCjClMjFpLiMpMiCnGiCmMiKgHjBoFiBeFiPgLiPkMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAfGiClFiCkCiNiCiClDiCpAiOfKiPgPiBeCjFiJiCmMjCgMiCoAiCkAiCoIjDlOiCoJiCkKiBeB_xHqqkZx_
		// cellIndex _xZkqqHx_iCmMiNmFiPkMiDfEiDeDiDfJiCoAjClCiCnHiCoJiCmMiCmFiBeBjFoCjAlDiClDiCoKiCoJiBeC_xHqqkZx_
		mmetol mmNewHeight = GetLineHeight(cellIndex.GetLineIndex()) + mmInflateY;
		if (mmInflateY < 0.0)
		//----- _xZkqqHx_iDfEiDeDiDfJiPgLiPkMiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// stCellIndex _xZkqqHx_iCmJiOmAiDeBiDgIiDiMiDfIiCmMiDfKiDiLiCmMiCnNiPfHiCnPiCoJiBeC_xHqqkZx_
			set<FCLineColumn> stCellTmp;
			set<FCLineColumn> stCellIndex;
			long lColumnIndex;
			for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
				stCellTmp.insert(FCLineColumn(cellIndex.GetLineIndex(), lColumnIndex));
			// _xZkqqHx_iJlMjBhKiDeBiDgIiDiMiDfIiCmMiDfKiDiLiPfHiNiHiCkJiCoHiBeBjBmOiJjOiClHiCoJiOmAiDeBiDgIiDiMiDfIiCmMiDfKiDiLiPfHiNiHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			GetRealCell(stCellIndex, stCellTmp);

			// _xZkqqHx_iClBiCmMiNhDiCmFiNmFjBoFiCmMiDgFiDeMiDfIiDgHiNiCiClDiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			mmetol mmMaxHeight = 0.0;
			set<FCLineColumn>::const_iterator iLc;
			for (iLc = stCellIndex.begin(); iLc != stCellIndex.end(); iLc++)
			{
				FCObjTextRect* pCell = GetCell(*iLc);
				mmetol mmHeight;
				if (almosteq(pCell->GetTextAngle(), 0.0) || almosteq(pCell->GetTextAngle(), 1.0))
					mmHeight = GetCellHeightMin(*iLc);
				else
					mmHeight = GetCellWidthMin(*iLc);
				if (mmMaxHeight < mmHeight)
					mmMaxHeight = mmHeight;
			}
			// _xZkqqHx_iClBiCmMiNhDiCmFiNmFjBoFiCmMiDgFiDeMiDfIiDgHiNiCiClDiCoGiCoIjCoBiCkCiNiCiClDiCmJjFmPiNfIiCmNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
			if (mmNewHeight < mmMaxHeight)
				mmNewHeight = mmMaxHeight;
			// _xZkqqHx_iNkBiCmMiNiCiClDiCoGiCoIjCoBiCkNiCmIiCoJiPoKiNiHiCmMiCnNiBeBiNhDiNiCiClDjFmPiNfIiCpAiOmAiNhDiBeC_xHqqkZx_
			if (GetLineHeight(cellIndex.GetLineIndex()) < mmNewHeight)
				mmNewHeight = GetLineHeight(cellIndex.GetLineIndex());
		}
//----- 05.08.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iClBiCmMiNhDiCmMiNmFiPkMjCgMiBeBiNmFjBoFjCgMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		mmetol mmMin;
		mmetol mmMax;
		CalcLineMinMax(mmMin, mmMax, cellIndex.GetLineIndex());
		if (mmNewHeight < mmMin) mmNewHeight = mmMin;
		if (mmMax < mmNewHeight) mmNewHeight = mmMax;
//----- 05.08.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		FFSnapGeMP(NULL, &mmNewHeight);
		g_pDoc->CmdSetTableLineHeight(this, cellIndex.GetLineIndex(), mmNewHeight);
	}

	// _xZkqqHx_iMmFjCoIjDfPiCkKiDiKiDfEiDeDiDfJiCmFiInKjDkOiClFiClNjAoGiCpAiMhGiOfKiBeC_xHqqkZx_
	DBLPoint mmptMovedFixPoint(	GetResizeFrame().left + dFixRatioX * GetResizeFrame().Width(),
								GetResizeFrame().top + dFixRatioY * GetResizeFrame().Height());
	// _xZkqqHx_iMmFjCoIjDfPiCkKiMlDiCmMiImKjChFiCmJjGnPiCoJiCoGiCkEiBeBjFfMjFjEjFgJiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
	g_pDoc->CmdMove1Obj(this, mmptFixPoint - mmptMovedFixPoint);
	// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	g_pDoc->LinkManager()->MovedNotify(this);
} // FCObjTable::AdjustObjectSize.

//----- 06.11.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::CanCopyText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCpAiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmJiDfCiDhDiBfLiCmFiCkLiCoJiCkJiCmHiCkEiCkJjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjTable::CanCopyText () const
//{
//	// _xZkqqHx_iDfKiDiLiCkKiCkAiCoJiCmMiCmFiBeBjFeLiClIiDgFiDeMiDfIiDgHiCmNiDfCiDhDiBfLiClDiCoKiCoJiBeC_xHqqkZx_
//	return TRUE;
//} // FCObjTable::CanCopyText.
//----- 06.11.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.11.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::CopyText
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCpAiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmJiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHiCmGiBeBiJmCjEfMiCmFiCkAiCoKiCmO_xHqqkZx_RTF_xZkqqHx_iCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCObjTable::CopyText () const
//{
//	// _xZkqqHx_iDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHiCpAiBeBiDfOiDhFiLoGjAnIiCoIiCmM_xHqqkZx_CSV_xZkqqHx_iMgAiOkOiCmFiPgPjHmNiClHiCoJiBeC_xHqqkZx_
//
//	// CSV_xZkqqHx_iDgGiBfLiDfOiBgJiDfOiDhFiLoGjAnIiCoIiBgKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
//	WString wstrCsv;
//	long lLineIndex;
//	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
//	//----- _xZkqqHx_jBfDiNhDiCpAiDiLiBfLiDhG_xHqqkZx_ -----
//	{
//		long lColumnIndex;
//		for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
//		//----- _xZkqqHx_jBfDjHpBiCpAiDiLiBfLiDhG_xHqqkZx_ -----
//		{
//			WString wstrItem;
//			const FCObjTextRect* pObj = GetCell(FCLineColumn(lLineIndex, lColumnIndex));
//			if (pObj != NULL && pObj->GetRichText() != NULL)
//			//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOoGjDlOiBeCiJpMiNhDiCmN_xHqqkZx_"\r\n"_xZkqqHx_iBeC_xHqqkZx_
//// 06.04.07 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////				pObj->GetRichText()->GetText(wstrItem, TRUE);
//				pObj->GetRichText()->GetText(wstrItem, TRUE, TRUE);
//			}
//			// _xZkqqHx_iDfPiDhFiDiLiDeOiDeIiBfLiDgHiCmMjFmPiKlHiBeC_xHqqkZx_ " -> ""
//			wstrItem.Replace(L"\"", L"\"\"");
//			// _xZkqqHx_iDfPiDhFiDiLiDeOiDeIiBfLiDgHiCmFiImNiCkEiBeC_xHqqkZx_
//			wstrItem.Insert(0, L'\"');
//			wstrItem += L'\"';
//
//			if (lColumnIndex != 0)
//				wstrCsv += L'\t';
//			wstrCsv += wstrItem;
//		}
//		wstrCsv += L"\r\n";
//	}
//
//	if (::OpenClipboard(NULL))
//	//----- _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCpAiKeKiCkN_xHqqkZx_ -----
//	{
//		if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
//		//----- NT,2000,XP _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// CF_UNICODETEXT_xZkqqHx_iMgAiOkOiCmFiPgPjHmNiBeC_xHqqkZx_
//			const long lByteSize = sizeof(wchar_t) * (wstrCsv.GetLength() + 1);
//			HGLOBAL hText = GlobalAlloc(GHND, lByteSize);
//// 06.11.16 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
//			if (hText == NULL) FFThrowMiscUnknown();
//			BYTE* pBuff = (BYTE*)GlobalLock(hText);
//// 06.11.16 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
//			if (pBuff == NULL) FFThrowMiscUnknown();
//			memcpy(pBuff, wstrCsv.c_str(), lByteSize);
//			GlobalUnlock(hText);
//			::SetClipboardData(CF_UNICODETEXT, hText);
//		}
//		// CF_TEXT_xZkqqHx_iMgAiOkOiCmFiPgPjHmNiBeC_xHqqkZx_
//		astring strText = WStrToAStr(wstrCsv);
//		const long lByteSize = (strText.length() + 1);
//		HGLOBAL hText = GlobalAlloc(GHND, lByteSize);
//// 06.11.16 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
//		if (hText == NULL) FFThrowMiscUnknown();
//		BYTE* pBuff = (BYTE*)GlobalLock(hText);
//// 06.11.16 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
//		if (pBuff == NULL) FFThrowMiscUnknown();
//		memcpy(pBuff, strText.c_str(), lByteSize);
//		GlobalUnlock(hText);
//		::SetClipboardData(CF_TEXT, hText);
//		// _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCpAjFmCiClGiCoJiBeC_xHqqkZx_
//		::CloseClipboard();
//	}
//} // FCObjTable::CopyText.
//----- 06.11.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::CanGetText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetText_xZkqqHx_iCmFiDgFiDeMiDfIiDgHiCkKiOoGjDlOiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCkKiOoGjDlOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjTable::CanGetText () const
{
	// _xZkqqHx_iDfKiDiLiCkKiCkAiCoJiCmMiCmFiBeBjFeLiClIiDgFiDeMiDfIiDgHiCmNiDfCiDhDiBfLiClDiCoKiCoJiBeC_xHqqkZx_
	return TRUE;
} // FCObjTable::CanGetText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkOjAkLiCpAiPjMiCkCiClNiBeBiPiDjAiIiCmIjFlGiOjKjHpBiCmMiCnNiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstr	:_xZkqqHx_iDgFiDeMiDfIiDgHjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIs2CR	:_xZkqqHx_iJpMiNhDiCpAiCfBjFlGiOjK_xHqqkZx_("\r\n")_xZkqqHx_iCmJiClHiCoJiCkJiCpAiOhHjCoIiBeC_xHqqkZx_FALSE _xZkqqHx_iCmIiCoHiCmO_xHqqkZx_ "\n"_xZkqqHx_iCmMiCnNiBeC_xHqqkZx_
 *			bIsCutLastCR	:_xZkqqHx_iNmFiMoDiCmMiJpMiNhDiCpAiDeKiDgCiDgHiClHiCoJiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCkKiOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFlGiOjKjHpBiCpAjElCiCkLiPgPiClHiBeC_xHqqkZx_wstr_xZkqqHx_iCkKiLpDiCmFiCoA_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiBeBiJpMiNhDiCmMiCnNiCmMiDgFiDeMiDfIiDgHiCmJ_xHqqkZx_bIsCutLastCR=TRUE_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmIiCmHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjTable::GetText (WString& wstr, BOOL bIs2CR, BOOL bIsCutLastCR) const
{
	// _xZkqqHx_iDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHiCpAiBeBiDfOiDhFiLoGjAnIiCoIiCmM_xHqqkZx_CSV_xZkqqHx_iMgAiOkOiCmFiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	// CSV_xZkqqHx_iDgGiBfLiDfOiBgJiDfOiDhFiLoGjAnIiCoIiBgKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jFmPjAjEiCpAiLpDiCmJiBeC_xHqqkZx_
	wstr.Empty();
	long lLineIndex;
	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
	//----- _xZkqqHx_jBfDiNhDiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		long lColumnIndex;
		for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
		//----- _xZkqqHx_jBfDjHpBiCpAiDiLiBfLiDhG_xHqqkZx_ -----
		{
			WString wstrItem;
			const FCObjTextRect* pObj = GetCell(FCLineColumn(lLineIndex, lColumnIndex));
			if (pObj != NULL && pObj->GetRichText() != NULL)
			//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOoGjDlOiBeCiNmFiMoDiCmMiJpMiNhDiCmNiDeKiDgCiDgHiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
				pObj->GetRichText()->GetText(wstrItem, bIs2CR, TRUE);
			}
			// _xZkqqHx_iDfPiDhFiDiLiDeOiDeIiBfLiDgHiCmMjFmPiKlHiBeC_xHqqkZx_ " -> ""
			wstrItem.Replace(L"\"", L"\"\"");
			// _xZkqqHx_iDfPiDhFiDiLiDeOiDeIiBfLiDgHiCmFiImNiCkEiBeC_xHqqkZx_
			wstrItem.Insert(0, L'\"');
			wstrItem += L'\"';

			if (lColumnIndex != 0)
				wstr += L'\t';
			wstr += wstrItem;
		}
		// _xZkqqHx_iJpMiNhDiClHiCoJiBeC_xHqqkZx_
		wstr += (bIs2CR ? L"\r\n" : L"\n");
	}
	// _xZkqqHx_iNmFiMoDiCmMiJpMiNhDiCpAiNoNiPjMiBeC_xHqqkZx_
	if (bIsCutLastCR)
		wstr.resize(wstr.size() - (bIs2CR ? 2 : 1));
	return TRUE;
} // FCObjTable::GetText.
//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.11.21 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::SetText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiDeMiDfIiDgHiCpAjDfMiCoIjFhEiCkPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpText		:_xZkqqHx_jDfMiCoIjFhEiCkPiCoJiMlDiCmMiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClHiCoJiBeCiDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkCiCmEiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iMmEiCnBiPgPiClHjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::SetText (const wchar_t* wcpText)
{
	// _xZkqqHx_iDiKiDfEiDeDiDfJjBePiCmMiMmFjCoIjDfPiCpAiOfKiPgPiBeC_xHqqkZx_
	const DBLPoint mmptFixBefore = FFGetFramePoint(	GetResizeFrame(),
													g_pReg->GetResizeFixPosition());
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiBeBiDfOiDhFiLoGjAnIiCoIiCmFiDhNiDgHiDiKiDgCiDeOiDfIiPpDiCmMiDgFiDeMiDfIiDgHjEhKjHpBiCmJiNoMiCoIjClMiClHiBeC_xHqqkZx_
	// vvTextTable_xZkqqHx_iCmNiNmFjCoBiCmFiCoA_xHqqkZx_(1 x 1)_xZkqqHx_iCmMiDhNiDgHiDiKiDgCiDeOiDfIiCkKjDpMiCoJiBeC_xHqqkZx_
	vector<WStringVector> vvTextTable;
	FFGetCSVTable(vvTextTable, wcpText);
	if (GetColumnCount() < vvTextTable.front().size())
	//----- _xZkqqHx_iMlLiNnNiCmMjHpBjAjEiCkKjAnNjCoIiClHiCoJjHpBjAjEiCoGiCoIiPkNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHpBjBhNjDpMiCmMiDfCiDhNiDjDiDgIiOmAiNhDiBeC_xHqqkZx_
		while (GetColumnCount() != vvTextTable.front().size())
		{
			// _xZkqqHx_iCfCjHpBiImIiPoDiCkAiCoJiPoKiNiHiCmNiBeBiNmFiMoDiCkJiCoHiCfBjHpBjGnKiCpAjBjNiCoCiClHiBeC_xHqqkZx_
			if (2 < GetColumnCount())
				g_pDoc->CmdInsertTableCellColumn(this, GetColumnCount() - 2, -1.0);
			else
				g_pDoc->CmdInsertTableCellColumn(this, GetColumnCount() - 1, -1.0);
		}
	} else
	if (vvTextTable.front().size() < GetColumnCount())
	//----- _xZkqqHx_iMlLiNnNiCmMjHpBjAjEiCkKjAnNjCoIiClHiCoJjHpBjAjEiCoGiCoIjBlNiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHpBiNoNiPjMiCmMiDfCiDhNiDjDiDgIiOmAiNhDiBeC_xHqqkZx_
		while (GetColumnCount() != vvTextTable.front().size())
		{
			// _xZkqqHx_iCfCjHpBiImIiPoDiCkAiCoJiPoKiNiHiCmNiBeBiNmFiMoDiCkJiCoHiCfBjHpBjGnKiCpAiMlIiCoHiClHiBeC_xHqqkZx_
			if (2 < GetColumnCount())
				g_pDoc->CmdDeleteTableCellColumn(this, GetColumnCount() - 2);
			else
				g_pDoc->CmdDeleteTableCellColumn(this, GetColumnCount() - 1);
		}
	}
	if (GetLineCount() < (long)vvTextTable.size())
	//----- _xZkqqHx_iMlLiNnNiCmMiNhDjAjEiCkKjAnNjCoIiClHiCoJiNhDjAjEiCoGiCoIiPkNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNhDjBhNjDpMiCmMiDfCiDhNiDjDiDgIiOmAiNhDiBeC_xHqqkZx_
		while (GetLineCount() != (long)vvTextTable.size())
		{
			// _xZkqqHx_iCfCiNhDiImIiPoDiCkAiCoJiPoKiNiHiCmNiBeBiNmFiMoDiCkJiCoHiCfBiNhDjGnKiCpAjBjNiCoCiClHiBeC_xHqqkZx_
			if (2 < GetLineCount())
				g_pDoc->CmdInsertTableCellLine(this, GetLineCount() - 2, -1.0);
			else
				g_pDoc->CmdInsertTableCellLine(this, GetLineCount() - 1, -1.0);
		}
	} else
	if ((long)vvTextTable.size() < GetLineCount())
	//----- _xZkqqHx_iMlLiNnNiCmMiNhDjAjEiCkKjAnNjCoIiClHiCoJiNhDjAjEiCoGiCoIjBlNiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNhDiNoNiPjMiCmMiDfCiDhNiDjDiDgIiOmAiNhDiBeC_xHqqkZx_
		while (GetLineCount() != (long)vvTextTable.size())
		{
			// _xZkqqHx_iCfCiNhDiImIiPoDiCkAiCoJiPoKiNiHiCmNiBeBiNmFiMoDiCkJiCoHiCfBiNhDjGnKiCpAiMlIiCoHiClHiBeC_xHqqkZx_
			if (2 < GetLineCount())
				g_pDoc->CmdDeleteTableCellLine(this, GetLineCount() - 2);
			else
				g_pDoc->CmdDeleteTableCellLine(this, GetLineCount() - 1);
		}
	}
	FCLineColumn cellIndex;
	for (cellIndex.Set(0, 0);
		 cellIndex.GetLineIndex() != (long)vvTextTable.size();
		 cellIndex.IncHorz(vvTextTable.front().size()))
	//----- _xZkqqHx_jAiFjFlNjFpLiMpMiCmJiDfKiDiLiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		FCObjDynabase* pObj = GetCell(cellIndex);
		if (pObj != NULL)
			pObj->SetText(vvTextTable[cellIndex.GetLineIndex()][cellIndex.GetColumnIndex()]);
	}

	// _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiMmFjCoIjDfPiCpAiOfKiPgPiBeC_xHqqkZx_
	const DBLPoint mmptFixAfter = FFGetFramePoint(GetResizeFrame(), g_pReg->GetResizeFixPosition());
	// _xZkqqHx_iDiKiDfEiDeDiDfJjBePiCmMiMmFjCoIjDfPiCnMiCmFiInKjDkOiBeC_xHqqkZx_
	if (!almosteq(mmptFixBefore, mmptFixAfter))
		g_pDoc->CmdMove1Obj(this, mmptFixBefore - mmptFixAfter);
} // FCObjTable::SetText.
//----- 06.11.21 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.11.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::PasteOverAs
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkJiCoHiBeBiOhHjCoIiClDiCoKiClNjBkOjAkLiCmMiCnNiCpAjDfMiCoIjFhEiCkPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objFig		:_xZkqqHx_jDfMiCoIjFhEiCkPiCoJiMlDiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwPasteAttr	:_xZkqqHx_jDfMiCoIjFhEiCkPiCoJjBkOjAkLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClHiCoJiBeCiDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkCiCmEiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iMmEiCnBiPgPiClHjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::PasteOverAs (const FCObjFigure& objFig, DWORD dwPasteAttr)
{
	if ((dwPasteAttr & FD_PASTE_ATTR_TEXT) ||
		(dwPasteAttr & FD_PASTE_ATTR_PLAIN_TEXT))
	//----- _xZkqqHx_iDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgH_xHqqkZx_/_xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfCiDhDiBfLiClHiCoJiDhGiDiMiBfLiDjDiDgFiDeMiDfIiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		WString wstrText;
		if (objFig.GetText(wstrText, TRUE))
		//----- _xZkqqHx_iDfCiDhDiBfLiMlDiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			SetText(wstrText);
		}
		// Baseclass_xZkqqHx_iKnGjAjEiCmMiClNiCnPjBkOjAkLjAnNjCoIiCpAiKePiClHiBeC_xHqqkZx_
		dwPasteAttr &= ~FD_PASTE_ATTR_TEXT;
		dwPasteAttr &= ~FD_PASTE_ATTR_PLAIN_TEXT;
	}
	if (dwPasteAttr & FD_PASTE_ATTR_PEN)
	//----- _xZkqqHx_iDhJiDjDjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		FCFrontSide ruledIndex;
		for (ruledIndex.Set(0, 0);
			 ruledIndex.GetFrontIndex() <= GetLineCount();
			 ruledIndex.IncVert(GetColumnCount()))
		//----- _xZkqqHx_jAiFjFlNjFpLiMpMiCmMiMhCjApMiCpAiDiLiBfLiDhG_xHqqkZx_ -----
		{
			FCObjDynabase* pObj = GetRuled(TRUE, ruledIndex);
			if (pObj != NULL)
				pObj->PasteOverAs(objFig, FD_PASTE_ATTR_PEN);
		}
		for (ruledIndex.Set(0, 0);
			 ruledIndex.GetFrontIndex() <= GetColumnCount();
			 ruledIndex.IncVert(GetLineCount()))
		//----- _xZkqqHx_jAiCjClMjFpLiMpMiCmMiMhCjApMiCpAiDiLiBfLiDhG_xHqqkZx_ -----
		{
			FCObjDynabase* pObj = GetRuled(FALSE, ruledIndex);
			if (pObj != NULL)
				pObj->PasteOverAs(objFig, FD_PASTE_ATTR_PEN);
		}
		// Baseclass_xZkqqHx_iKnGjAjEiCmMiClNiCnPjBkOjAkLjAnNjCoIiCpAiKePiClHiBeC_xHqqkZx_
		dwPasteAttr &= ~FD_PASTE_ATTR_PEN;
	}
	if (dwPasteAttr & FD_PASTE_ATTR_BRUSH)
	//----- _xZkqqHx_iDhFiDiJiDfGjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		FCLineColumn cellIndex;
		for (cellIndex.Set(0, 0);
			 cellIndex.GetLineIndex() != GetLineCount();
			 cellIndex.IncHorz(GetColumnCount()))
		//----- _xZkqqHx_jAiFjFlNjFpLiMpMiCmJiDfKiDiLiCpAiDiLiBfLiDhG_xHqqkZx_ -----
		{
			FCObjDynabase* pObj = GetCell(cellIndex);
			if (pObj != NULL)
				pObj->PasteOverAs(objFig, FD_PASTE_ATTR_BRUSH);
		}
		// Baseclass_xZkqqHx_iKnGjAjEiCmMiClNiCnPjBkOjAkLjAnNjCoIiCpAiKePiClHiBeC_xHqqkZx_
		dwPasteAttr &= ~FD_PASTE_ATTR_BRUSH;
	}
	// Baseclass_xZkqqHx_iKnGjAjEiCmMiClNiCnPjBkOjAkLjAnNjCoIiCpAiKePiClHiBeC_xHqqkZx_
	dwPasteAttr &= ~FD_PASTE_ATTR_GRAPHICS;
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::PasteOverAs(objFig, dwPasteAttr);
} // FCObjTable::PasteOverAs.
//----- 06.11.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::~FCObjTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjTable::~FCObjTable ()
{
} // FCObjTable::~FCObjTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::InitTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiClDiCoKiClNjFfMiCpAiOhHjCoIiDfEiDeDiDfJiCmMjFfMiCmGiClFiCmEiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMjAhNiCmNiCfAiCjIiCfAiCmMjFfMiBeC_xHqqkZx_
 *
 *                  0           
 *                              
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_   
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_   
 *     0   [0,0]  [0,0]   [1,0] 
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_   
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_   
 *
 *
 *                 0              1          
 *                                           
 *         _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *         _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *    0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]
 *         _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *         _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *         _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *    1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]
 *         _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *         _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[2,1]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::InitTable ()
{
	ASSERT(GetLineCount() == 0);
	ASSERT(GetColumnCount() == 0);

	// 1 x 1 _xZkqqHx_iCmMjFfMiCmJiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	const long lLineCount = 1;
	const long lColumnCount = 1;

	// _xZkqqHx_iNlGiPoDiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
	m_mmptLeftTop.SetPoint(0.0, 0.0);
	long lLineIndex;
	long lColumnIndex;

	for (lLineIndex = 0; lLineIndex != lLineCount; lLineIndex++)
		m_vLineHeight.push_back(10.0);
	for (lColumnIndex = 0; lColumnIndex != lColumnCount; lColumnIndex++)
		m_vColumnWidth.push_back(20.0);

	ObjDynabaseVector vInsertMember;
	for (lLineIndex = 0; lLineIndex != lLineCount; lLineIndex++)
	{
		// _xZkqqHx_iDfKiDiLiCmJiNhDiCpAjBhNjDpMiBeC_xHqqkZx_
		m_vvCell.push_back(ObjDynabaseVector());
		for (lColumnIndex = 0; lColumnIndex != lColumnCount; lColumnIndex++)
		{
			// _xZkqqHx_iDfKiDiLjFjEjFgJiCpAiNoMjAkMiBeC_xHqqkZx_
			FCObjTextRect* pObjTextRect = new FCObjTextRect();
			// _xZkqqHx_iDfKiDiLjFjEjFgJiCmMiDgFiDeMiDfIiDgHiDiKiDfEiDeDiDfJjDmBjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
			pObjTextRect->SetIsResizeHorzByText(FALSE);
			pObjTextRect->SetIsResizeVertByText(TRUE);
			pObjTextRect->SetIsShortenByText(TRUE);
			// _xZkqqHx_iDfKiDiLiCmJjHpBiCpAjBhNjDpMiBeC_xHqqkZx_
			vInsertMember.push_back(pObjTextRect);
			m_vvCell.back().push_back(pObjTextRect);
		}
	}
	for (lLineIndex = 0; lLineIndex <= lLineCount; lLineIndex++)
	{
		// _xZkqqHx_jAiFjFlNiMhCjApMiCmJiNhDiCpAjBhNjDpMiBeC_xHqqkZx_
		m_vvHorzRuled.push_back(ObjDynabaseVector());
		for (lColumnIndex = 0; lColumnIndex != lColumnCount; lColumnIndex++)
		{
			// _xZkqqHx_jAiFjFlNiMhCjApMiCmJjHpBiCpAjBhNjDpMiBeC_xHqqkZx_
			vInsertMember.push_back(new FCObjLine());
			m_vvHorzRuled.back().push_back(vInsertMember.back());
		}
	}
	for (lColumnIndex = 0; lColumnIndex <= lColumnCount; lColumnIndex++)
	{
		// _xZkqqHx_jAiCjClMiMhCjApMiCmJjHpBiCpAjBhNjDpMiBeC_xHqqkZx_
		m_vvVertRuled.push_back(ObjDynabaseVector());
		for (lLineIndex = 0; lLineIndex != lLineCount; lLineIndex++)
		{
			// _xZkqqHx_jAiCjClMiMhCjApMiCmJiNhDiCpAjBhNjDpMiBeC_xHqqkZx_
			vInsertMember.push_back(new FCObjLine());
			m_vvVertRuled.back().push_back(vInsertMember.back());
		}
	}
	// _xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCmJjCmHiJmBiBeC_xHqqkZx_
	longVector vInsertIndex;
	AddGroup(vInsertIndex, vInsertMember);
	// _xZkqqHx_iNhDiNiCiBeBjHpBjFjNiPoOjFpBiCmJiNiHiCoNiClJiCmEiBeBjFjEjFgJiCpAiNmEjEhKjChFiClHiCoJiBeC_xHqqkZx_
	LayoutCellRuled();
	// _xZkqqHx_jBfDjBmMiCmMiNiCiClDiCpAiNmEiMhGiOfKiBeC_xHqqkZx_
	CalcResizeFrame();
} // FCObjTable::InitTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::InitTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiDfEiDeDiDfJiCmMjFfMiCmJiKgHjBoFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLineCount	:_xZkqqHx_iNhDjAjEiCpAiOhHjCoIiBeCiCfAiImIiPoDiBeC_xHqqkZx_
 *			lColumnCount:_xZkqqHx_jHpBjAjEiCpAiOhHjCoIiBeCiCfAiImIiPoDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMjAhNiCmNiCfAiCjIiCfAiCmMjFfMiBeC_xHqqkZx_
 *
 *                  0           
 *                              
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_   
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_   
 *     0   [0,0]  [0,0]   [1,0] 
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_   
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_   
 *
 *
 *                 0              1          
 *                                           
 *         _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *         _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *    0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]
 *         _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *         _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *         _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *    1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]
 *         _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *         _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[2,1]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::InitTable (long lLineCount, long lColumnCount)
{
	ASSERT(0 < lLineCount);
	ASSERT(0 < lColumnCount);
	ASSERT(GetLineCount() == 1);
	ASSERT(GetColumnCount() == 1);

	long lLineIndex;
	for (lLineIndex = 1; lLineIndex != lLineCount; lLineIndex++)
	{
		ObjDynabaseVector vNewCell;
		ObjDynabaseVector vNewHorzRuled;
		ObjDynabaseVector vNewVertRuled;
		// _xZkqqHx_iKpJjBlGiCmMiNhDiCpAiMlDiCmJjBhNjDpMiClHiCoJiNhDiCmMjFjEjFgJjEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
		DuplicateLine(vNewCell, vNewHorzRuled, vNewVertRuled, lLineIndex, FALSE);
		// _xZkqqHx_iNoMjAkMiClFiClNjFjEjFgJjEhKjHpBiCpAiNhDiCmGiClFiCmEjBhNjDpMiBeC_xHqqkZx_
		InsertLine(vNewCell, vNewHorzRuled, vNewVertRuled, lLineIndex, -1.0);
		// _xZkqqHx_iDePiDiLiBfLiDhGjDgPjIfOiBeC_xHqqkZx_
		ObjDynabaseVector vInsertMember;
// 05.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		ObjDynabaseVector::iterator iObj;
		mdef_iterator(ObjDynabaseVector, iObj);
		m3_for (iObj, vNewCell, vNewHorzRuled, vNewVertRuled)
			if (*iObj != NULL) vInsertMember.push_back(*iObj);
		// _xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCpAjCmHiJmBiBeC_xHqqkZx_
		AddGroup(longVector(), vInsertMember);
	}

	long lColumnIndex;
	for (lColumnIndex = 1; lColumnIndex != lColumnCount; lColumnIndex++)
	{
		ObjDynabaseVector vNewCell;
		ObjDynabaseVector vNewVertRuled;
		ObjDynabaseVector vNewHorzRuled;
		// _xZkqqHx_iKpJjBlGiCmMjHpBiCpAiMlDiCmJjBhNjDpMiClHiCoJjHpBiCmMjFjEjFgJjEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
		DuplicateColumn(vNewCell, vNewVertRuled, vNewHorzRuled, lColumnIndex, FALSE);
		// _xZkqqHx_iNoMjAkMiClFiClNjFjEjFgJjEhKjHpBiCpAjHpBiCmGiClFiCmEjBhNjDpMiBeC_xHqqkZx_
		InsertColumn(vNewCell, vNewVertRuled, vNewHorzRuled, lColumnIndex, -1.0);
		// _xZkqqHx_iDePiDiLiBfLiDhGjDgPjIfOiBeC_xHqqkZx_
		ObjDynabaseVector vInsertMember;
// 05.12.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		ObjDynabaseVector::iterator iObj;
		mdef_iterator(ObjDynabaseVector, iObj);
		m3_for (iObj, vNewCell, vNewVertRuled, vNewHorzRuled)
			if (*iObj != NULL) vInsertMember.push_back(*iObj);
		// _xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiCpAjCmHiJmBiBeC_xHqqkZx_
		AddGroup(longVector(), vInsertMember);
	}
	// _xZkqqHx_iNhDiNiCiBeBjHpBjFjNiPoOjFpBiCmJiNiHiCoNiClJiCmEiBeBjFjEjFgJiCpAiNmEjEhKjChFiClHiCoJiBeC_xHqqkZx_
	LayoutCellRuled();
	// _xZkqqHx_jBfDjBmMiCmMiNiCiClDiCpAiNmEiMhGiOfKiBeC_xHqqkZx_
	CalcResizeFrame();
} // FCObjTable::InitTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::DuplicateLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNhDiCpAjBhNjDpMiClHiCoJiNnLiCmJiOfBiPmGiClHiCoJjFjEjFgJiCpAjFkBjAlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vNewCell		:_xZkqqHx_iDfKiDiLjFjEjFgJiCpAjFkBjAlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			vNewHorzRuled	:_xZkqqHx_jAiFjFlNiMhCjApMjFjEjFgJiCpAjFkBjAlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			vNewVertRuled	:_xZkqqHx_jAiCjClMiMhCjApMjFjEjFgJiCpAjFkBjAlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			lLineIndex		:_xZkqqHx_iNhDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bRegisterObjId	:_xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAjDgPjIfOiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBhNjDpMiClHiCoJiNhDiCmGjDkPiClGiNhDiCmJiCkAiCoJiDfKiDiLiBeBjClMiPoDiCmMjAiFjFlNiMhCjApMiBeBjDkPiClGiNhDiCmMjAiCjClMiMhCjApMiCpA_xHqqkZx_
 *			_xZkqqHx_jFkBiOmKiClHiCoJiBeCiNmFiMoDiCmJiNhDiCpAjCmHiJmBiClHiCoJiPoKiNiHiCmNiBeBiIoKiCmCiPoDiCmMiNhDiCmMiDfKiDiLiBeB_xHqqkZx_
 *			_xZkqqHx_iIoKiCmCiPoDiCmMiNhDiCmMjAiCjClMiMhCjApMiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjAhNiCmFiNhDiCfBiCmJjBhNjDpMiClHiCoJiPoKiNiHiCmNiBeBiDfKiDiL_xHqqkZx_[2,0]_xZkqqHx_iBgA_xHqqkZx_[2,2]_xZkqqHx_iBeBjAiFjFlNiMhCjApM_xHqqkZx_[2,0]_xZkqqHx_iBgA_xHqqkZx_[2,3]_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_jAiCjClMiMhCjApM_xHqqkZx_[0,2]_xZkqqHx_iBgA_xHqqkZx_[4,2]_xZkqqHx_iCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNhDiCfDiCmJjBhNjDpMiClHiCoJiPoKiNiHiCmNiBeBiDfKiDiL_xHqqkZx_[3,0]_xZkqqHx_iBgA_xHqqkZx_[3,3]_xZkqqHx_iBeBjAiFjFlNiMhCjApM_xHqqkZx_[4,0]_xZkqqHx_iBgA_xHqqkZx_[4,3]_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_jAiCjClMiMhCjApM_xHqqkZx_[0,3]_xZkqqHx_iBgA_xHqqkZx_[4,3]_xZkqqHx_iCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 *                  0              1              2              3          
 *                                                                          
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,3]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]  [0,3]   [4,0]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]  [1,3]   [4,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_             _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[2,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]          [2,2]  [2,2]                  [4,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[3,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]  [3,3]   [4,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,3]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::DuplicateLine (ObjDynabaseVector& vNewCell,
								ObjDynabaseVector& vNewHorzRuled,
								ObjDynabaseVector& vNewVertRuled,
								long lLineIndex,
								BOOL bRegisterObjId) const
{
	// _xZkqqHx_jAfGiClFiCkNiNoMjAkMiClDiCoKiCoJiDfKiDiLiCmGiMhCjApMiCmMjFjEjFgJiBeC_xHqqkZx_
	vNewCell.clear();
	vNewHorzRuled.clear();
	vNewVertRuled.clear();
	long lC;
	for (lC = 0; lC != GetColumnCount(); lC++)
	{
		// _xZkqqHx_iNmFiMoDiCmMiNhDiCmJjCmHiJmBiClHiCoJiPoKiNiHiCmNiBeBiIoKiCmCjBePiCmMiNhDiCmMjFjEjFgJiCpAiOfBiPmGiClHiCoJiBeC_xHqqkZx_
		const FCObjTextRect* pObj = NULL;
		if (lLineIndex == GetLineCount())
			pObj = GetCell(FCLineColumn(lLineIndex - 1, lC));
		else
			pObj = GetCell(FCLineColumn(lLineIndex, lC));
		if (pObj != NULL)
		//----- _xZkqqHx_iOfBiPmGjBmOiPnLiCmMjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFjEjFgJiCpAjFkBjAlLiBeC_xHqqkZx_
			FCObjTextRect* pNewObj = (FCObjTextRect*)pObj->Duplicate();
			// _xZkqqHx_iJpMiNhDiDfCiBfLiDgIiCfAjFlGiOjKiCmMiDgFiDeMiDfIiDgHiCmJiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
			if (pNewObj->GetRichText() != NULL)
				pNewObj->GetRichText()->EmptyText(pNewObj);
			vNewCell.push_back(pNewObj);
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiClFiBeBjFjEjFgJiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			if (bRegisterObjId) pNewObj->RegisterObjID();
		} else
		//----- _xZkqqHx_iOfBiPmGjBmOiPnLiCmMjFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			vNewCell.push_back(NULL);
		}
	}
	for (lC = 0; lC != GetColumnCount(); lC++)
	{
		const FCObjLine* pObj = GetRuled(TRUE, FCFrontSide(lLineIndex, lC));
		if (pObj != NULL)
		//----- _xZkqqHx_iOfBiPmGjBmOiPnLiCmMjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFjEjFgJiCpAjFkBjAlLiBeC_xHqqkZx_
			FCObjLine* pNewObj = (FCObjLine*)pObj->Duplicate();
			vNewHorzRuled.push_back(pNewObj);
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiClFiBeBjFjEjFgJiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			if (bRegisterObjId) pNewObj->RegisterObjID();
		} else
		//----- _xZkqqHx_iOfBiPmGjBmOiPnLiCmMjFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			vNewHorzRuled.push_back(NULL);
		}
	}
	for (lC = 0; lC <= GetColumnCount(); lC++)
	{
		// _xZkqqHx_iNmFiMoDiCmMiNhDiCmJjCmHiJmBiClHiCoJiPoKiNiHiCmNiBeBiIoKiCmCjBePiCmMiNhDiCmMjFjEjFgJiCpAiOfBiPmGiClHiCoJiBeC_xHqqkZx_
		const FCObjLine* pObj = NULL;
		if (lLineIndex == GetLineCount())
			pObj = (FCObjLine*)GetRuled(FALSE, FCFrontSide(lC, lLineIndex - 1));
		else
			pObj = (FCObjLine*)GetRuled(FALSE, FCFrontSide(lC, lLineIndex));
		if (pObj != NULL)
		//----- _xZkqqHx_iOfBiPmGjBmOiPnLiCmMjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFjEjFgJiCpAjFkBjAlLiBeC_xHqqkZx_
			FCObjLine* pNewObj = (FCObjLine*)pObj->Duplicate();
			vNewVertRuled.push_back(pNewObj);
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiClFiBeBjFjEjFgJiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			if (bRegisterObjId) pNewObj->RegisterObjID();
		} else
		//----- _xZkqqHx_iOfBiPmGjBmOiPnLiCmMjFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			vNewVertRuled.push_back(NULL);
		}
	}
} // FCObjTable::DuplicateLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::DuplicateColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHpBiCpAjBhNjDpMiClHiCoJiNnLiCmJiOfBiPmGiClHiCoJjFjEjFgJiCpAjFkBjAlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vNewCell		:_xZkqqHx_iDfKiDiLjFjEjFgJiCpAjFkBjAlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			vNewVertRuled	:_xZkqqHx_jAiCjClMiMhCjApMjFjEjFgJiCpAjFkBjAlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			vNewHorzRuled	:_xZkqqHx_jAiFjFlNiMhCjApMjFjEjFgJiCpAjFkBjAlLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			lColumnIndex	:_xZkqqHx_jHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bRegisterObjId	:_xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAjDgPjIfOiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBhNjDpMiClHiCoJjHpBiCmGjDkPiClGjHpBiCmJiCkAiCoJiDfKiDiLiBeBjClMiNlGiCmMjAiCjClMiMhCjApMiBeBjDkPiClGjHpBiCmMjAiFjFlNiMhCjApMiCpA_xHqqkZx_
 *			_xZkqqHx_jFkBiOmKiClHiCoJiBeCiNmFiMoDiCmJjHpBiCpAjCmHiJmBiClHiCoJiPoKiNiHiCmNiBeBiIoKiCmCiNlGiCmMjHpBiCmMiDfKiDiLiBeB_xHqqkZx_
 *			_xZkqqHx_iIoKiCmCiNlGiCmMjHpBiCmMjAiFjFlNiMhCjApMiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjAhNiCmFjHpBiCfBiCmJjBhNjDpMiClHiCoJiPoKiNiHiCmNiBeBiDfKiDiL_xHqqkZx_[0,2]_xZkqqHx_iBgA_xHqqkZx_[3,2]_xZkqqHx_iBeBjAiCjClMiMhCjApM_xHqqkZx_[2,0]_xZkqqHx_iBgA_xHqqkZx_[2,3]_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_jAiFjFlNiMhCjApM_xHqqkZx_[0,2]_xZkqqHx_iBgA_xHqqkZx_[4,2]_xZkqqHx_iCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHpBiCfDiCmJjBhNjDpMiClHiCoJiPoKiNiHiCmNiBeBiDfKiDiL_xHqqkZx_[0,3]_xZkqqHx_iBgA_xHqqkZx_[3,3]_xZkqqHx_iBeBjAiCjClMiMhCjApM_xHqqkZx_[4,0]_xZkqqHx_iBgA_xHqqkZx_[4,3]_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_jAiFjFlNiMhCjApM_xHqqkZx_[0,3]_xZkqqHx_iBgA_xHqqkZx_[4,3]_xZkqqHx_iCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 *                  0              1              2              3          
 *                                                                          
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,3]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]  [0,3]   [4,0]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]  [1,3]   [4,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_             _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[2,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]          [2,2]  [2,2]                  [4,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[3,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]  [3,3]   [4,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,3]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::DuplicateColumn (	ObjDynabaseVector& vNewCell,
									ObjDynabaseVector& vNewVertRuled,
									ObjDynabaseVector& vNewHorzRuled,
									long lColumnIndex,
									BOOL bRegisterObjId) const
{
	// _xZkqqHx_jAfGiClFiCkNiNoMjAkMiClDiCoKiCoJiDfKiDiLiCmGiMhCjApMiCmMjFjEjFgJiBeC_xHqqkZx_
	vNewCell.clear();
	vNewVertRuled.clear();
	vNewHorzRuled.clear();
	long lC;
	for (lC = 0; lC != GetLineCount(); lC++)
	{
		// _xZkqqHx_iNmFiMoDiCmMjHpBiCmJjCmHiJmBiClHiCoJiPoKiNiHiCmNiBeBiIoKiCmCjBePiCmMjHpBiCmMjFjEjFgJiCpAiOfBiPmGiClHiCoJiBeC_xHqqkZx_
		const FCObjTextRect* pObj = NULL;
		if (lColumnIndex == GetColumnCount())
			pObj = GetCell(FCLineColumn(lC, lColumnIndex - 1));
		else
			pObj = GetCell(FCLineColumn(lC, lColumnIndex));
		if (pObj != NULL)
		//----- _xZkqqHx_iOfBiPmGjBmOiPnLiCmMjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFjEjFgJiCpAjFkBjAlLiBeC_xHqqkZx_
			FCObjTextRect* pNewObj = (FCObjTextRect*)pObj->Duplicate();
			// _xZkqqHx_iJpMiNhDiDfCiBfLiDgIiCfAjFlGiOjKiCmMiDgFiDeMiDfIiDgHiCmJiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
			if (pNewObj->GetRichText() != NULL)
				pNewObj->GetRichText()->EmptyText(pNewObj);
			vNewCell.push_back(pNewObj);
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiClFiBeBjFjEjFgJiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			if (bRegisterObjId) pNewObj->RegisterObjID();
		} else
		//----- _xZkqqHx_iOfBiPmGjBmOiPnLiCmMjFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			vNewCell.push_back(NULL);
		}
	}
	for (lC = 0; lC != GetLineCount(); lC++)
	{
		const FCObjLine* pObj = GetRuled(FALSE, FCFrontSide(lColumnIndex, lC));
		if (pObj != NULL)
		//----- _xZkqqHx_iOfBiPmGjBmOiPnLiCmMjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFjEjFgJiCpAjFkBjAlLiBeC_xHqqkZx_
			FCObjLine* pNewObj = (FCObjLine*)pObj->Duplicate();
			vNewVertRuled.push_back(pNewObj);
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiClFiBeBjFjEjFgJiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			if (bRegisterObjId) pNewObj->RegisterObjID();
		} else
		//----- _xZkqqHx_iOfBiPmGjBmOiPnLiCmMjFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			vNewVertRuled.push_back(NULL);
		}
	}
	for (lC = 0; lC <= GetLineCount(); lC++)
	{
		// _xZkqqHx_iNmFiMoDiCmMjHpBiCmJjCmHiJmBiClHiCoJiPoKiNiHiCmNiBeBiIoKiCmCjBePiCmMjHpBiCmMjFjEjFgJiCpAiOfBiPmGiClHiCoJiBeC_xHqqkZx_
		const FCObjLine* pObj = NULL;
		if (lColumnIndex == GetColumnCount())
			pObj = (FCObjLine*)GetRuled(TRUE, FCFrontSide(lC, lColumnIndex - 1));
		else
			pObj = (FCObjLine*)GetRuled(TRUE, FCFrontSide(lC, lColumnIndex));
		if (pObj != NULL)
		//----- _xZkqqHx_iOfBiPmGjBmOiPnLiCmMjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFjEjFgJiCpAjFkBjAlLiBeC_xHqqkZx_
			FCObjLine* pNewObj = (FCObjLine*)pObj->Duplicate();
			vNewHorzRuled.push_back(pNewObj);
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiClFiBeBjFjEjFgJiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			if (bRegisterObjId) pNewObj->RegisterObjID();
		} else
		//----- _xZkqqHx_iOfBiPmGjBmOiPnLiCmMjFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			vNewHorzRuled.push_back(NULL);
		}
	}
} // FCObjTable::DuplicateColumn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::InsertLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNhDiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vAppendCell		:_xZkqqHx_jBhNjDpMiClHiCoJiDfKiDiLjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vAppendHorzRuled:_xZkqqHx_jBhNjDpMiClHiCoJjAiFjFlNiMhCjApMjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vAppendVertRuled:_xZkqqHx_jBhNjDpMiClHiCoJjAiCjClMiMhCjApMjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lLineIndex		:_xZkqqHx_jBhNjDpMiImKjChFiCpAiOhHjCoIiBeCjBhNjDpMiClDiCoKiClNiNhDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_
 *							 lLineIndex _xZkqqHx_iCmGiCmIiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *			mmHeight		:_xZkqqHx_jBhNjDpMiClHiCoJiNhDiCmMiNiCiClDiCpAiOhHjCoIiBeCiOkJjDkOiCmMiPoKiNiHiCmN_xHqqkZx_-1.0_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 *                             _xZkqqHx_iBhJjBhNjDpMjBePiBhK_xHqqkZx_
 *
 *                  0              1              2          
 *                                                           
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]  [2,1]   [2,2]  [2,2]   [3,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                                  _xZkqqHx_iEkA_xHqqkZx_   
 *                                                             _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   
 *                               _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_                                                        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   
 *                             _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_                                                    _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_ 
 *                              _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_                                                      _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_  
 *                                _xZkqqHx_iBfPiBfO_xHqqkZx_                                                          _xZkqqHx_iBfPiBfO_xHqqkZx_    
 *
 *                  0              1              2                                0              1              2          
 *                                                                                                                          
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_                _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]         0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]
 *          _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiBgDiBgD_xHqqkZx_[1,0]_xZkqqHx_iBgDiBgDiEkIiBgDiBgD_xHqqkZx_[1,1]_xZkqqHx_iBgDiBgDiEkIiBgDiBgD_xHqqkZx_[1,2]_xZkqqHx_iBgDiBgDiEkD_xHqqkZx_                _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]         1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_                _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]         2   [0,2]  [2,0]   [1,2]  [2,1]   [2,2]  [2,2]   [3,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_                _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]  [2,1]   [2,2]  [2,2]   [3,2]         3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_                _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]         4   [0,4]  [4,0]   [1,4]  [4,1]   [2,4]  [4,2]   [3,4]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_  
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_                _xZkqqHx_iEkEiBgDiBgD_xHqqkZx_[5,0]_xZkqqHx_iBgDiBgDiEkIiBgDiBgD_xHqqkZx_[5,1]_xZkqqHx_iBgDiBgDiEkIiBgDiBgD_xHqqkZx_[5,2]_xZkqqHx_iBgDiBgDiEkD_xHqqkZx_  
 *
 *                           _xZkqqHx_iBhJiCePiNhDiCmJjBhNjDpMiBhK_xHqqkZx_                                                  _xZkqqHx_iBhJiCfDiNhDiCmJjBhNjDpMiBhK_xHqqkZx_
 *
 *
 *
 *                  0              1              2              3          
 *                                                                          
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,3]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]  [0,3]   [4,0]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]  [1,3]   [4,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_             _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[2,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]          [2,2]  [2,2]                  [4,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[3,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]  [3,3]   [4,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,3]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjTable::InsertLine (	const ObjDynabaseVector& vAppendCell,
								const ObjDynabaseVector& vAppendHorzRuled,
								const ObjDynabaseVector& vAppendVertRuled,
								long lLineIndex,
								mmetol mmHeight)
{
	// _xZkqqHx_jBhNjDpMiClDiCoKiCoJiDeDiDjDiDgGiDgCiDeOiDfIiBgI_xHqqkZx_lLineIndex_xZkqqHx_iBgIiCmJjBmOiClFiCmEiBeB_xHqqkZx_
	// _xZkqqHx_iDfKiDiLiCmN_xHqqkZx_ [lLineIndex,n]_xZkqqHx_iBeBjAiFjFlNiMhCjApMiCmN_xHqqkZx_ [lLineIndex+1,n]_xZkqqHx_iBeB_xHqqkZx_
	// _xZkqqHx_jAiCjClMiMhCjApMiCmN_xHqqkZx_ [n,lLineIndex] _xZkqqHx_iCkKjBhNjDpMiImKjChFiCmGiCmIiCoJiBeC_xHqqkZx_

	long lC;
	//----- _xZkqqHx_iDfKiDiLiCpAiCfAiNhDjBhNjDpM_xHqqkZx_ -----
	m_vvCell.insert(&m_vvCell[lLineIndex], ObjDynabaseVector());
	//----- _xZkqqHx_jBhNjDpMiClFiClNiNhDiCmMiKgFjHpBiCmJiDfKiDiLiCpAjBhNjDpM_xHqqkZx_ -----
	for (lC = 0; lC != GetColumnCount(); lC++)
		m_vvCell[lLineIndex].push_back(vAppendCell[lC]);

	//----- _xZkqqHx_jAiFjFlNiMhCjApMiCpAiCfAiNhDjBhNjDpM_xHqqkZx_ -----
	m_vvHorzRuled.insert(&m_vvHorzRuled[lLineIndex + 1], ObjDynabaseVector());
	for (lC = 0; lC != GetColumnCount(); lC++)
		m_vvHorzRuled[lLineIndex + 1].push_back(vAppendHorzRuled[lC]);

	//----- _xZkqqHx_jAiCjClMiMhCjApMiCpAjHpBjAjEjFkKjBhNjDpM_xHqqkZx_ -----
	for (lC = 0; lC <= GetColumnCount(); lC++)
		m_vvVertRuled[lC].insert(&m_vvVertRuled[lC][lLineIndex], vAppendVertRuled[lC]);

	//----- _xZkqqHx_iNhDiNiCiPoOjFpBiCpAiCfAiNhDjBhNjDpM_xHqqkZx_ -----
	if (mmHeight < 0.0)
	{
		// _xZkqqHx_iNmFiMoDiCmMiNhDiCmJjCmHiJmBiClHiCoJiPoKiNiHiCmNiBeBiIoKiCmCjBePiCmMiNhDiCmMiNiCiClDiCpAiOgHiCkEiBeC_xHqqkZx_
		if (lLineIndex == GetLineCount())
			mmHeight = GetLineHeight(lLineIndex - 1);
		else
			mmHeight = GetLineHeight(lLineIndex);
	}
	m_vLineHeight.insert(&m_vLineHeight[lLineIndex], mmHeight);
	return mmHeight;
} // FCObjTable::InsertLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::InsertColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHpBiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vAppendCell		:_xZkqqHx_jBhNjDpMiClHiCoJiDfKiDiLjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vAppendVertRuled:_xZkqqHx_jBhNjDpMiClHiCoJjAiCjClMiMhCjApMjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vAppendHorzRuled:_xZkqqHx_jBhNjDpMiClHiCoJjAiFjFlNiMhCjApMjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lColumnIndex	:_xZkqqHx_jBhNjDpMiImKjChFiCpAiOhHjCoIiBeCjBhNjDpMiClDiCoKiClNjHpBiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_
 *							 lColumnIndex _xZkqqHx_iCmGiCmIiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *			mmWidth			:_xZkqqHx_jBhNjDpMiClHiCoJjHpBiCmMjFjNiCpAiOhHjCoIiBeCiOkJjDkOiCmMiPoKiNiHiCmN_xHqqkZx_-1.0_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 *                               _xZkqqHx_iBhJjBhNjDpMjBePiBhK_xHqqkZx_
 *
 *                  0              1              2          
 *                                                           
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]  [2,1]   [2,2]  [2,2]   [3,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                                    _xZkqqHx_iEkA_xHqqkZx_   
 *                                                             _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   
 *                                _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_                                                         _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_   
 *                              _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_                                                     _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_ 
 *                               _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_                                                       _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_  
 *                                 _xZkqqHx_iBfPiBfO_xHqqkZx_                                                           _xZkqqHx_iBfPiBfO_xHqqkZx_    
 *                                                                       
 *                  0               0              1              2                              0              1              2             0           
 *                                                                                                                                                       
 *          _xZkqqHx_iEkBiBgDiBgD_xHqqkZx_[0,0]_xZkqqHx_iBgDiBgDiEkCiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_              _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkCiBgDiBgD_xHqqkZx_[0,3]_xZkqqHx_iBgDiBgDiEkC_xHqqkZx_   
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_   
 *     0   [0,0]  [0,0]   [1,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]       0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]  [0,3]   [4,0] 
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_   
 *          _xZkqqHx_iEkFiBgDiBgD_xHqqkZx_[1,0]_xZkqqHx_iBgDiBgDiEkHiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_              _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkHiBgDiBgD_xHqqkZx_[1,3]_xZkqqHx_iBgDiBgDiEkH_xHqqkZx_   
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_   
 *     0   [0,1]  [1,0]   [1,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]       0   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]  [1,3]   [4,1] 
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_   
 *          _xZkqqHx_iEkFiBgDiBgD_xHqqkZx_[2,0]_xZkqqHx_iBgDiBgDiEkHiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_              _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkHiBgDiBgD_xHqqkZx_[2,3]_xZkqqHx_iBgDiBgDiEkH_xHqqkZx_   
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_   
 *     1   [0,2]  [2,0]   [1,2]  [2,0]   [1,2]  [2,1]   [2,2]  [2,2]   [3,2]       1   [0,2]  [2,0]   [1,2]  [2,1]   [2,2]  [2,2]   [3,2]  [2,3]   [4,2] 
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_   
 *          _xZkqqHx_iEkFiBgDiBgD_xHqqkZx_[3,0]_xZkqqHx_iBgDiBgDiEkHiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_              _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkHiBgDiBgD_xHqqkZx_[3,3]_xZkqqHx_iBgDiBgDiEkH_xHqqkZx_   
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_   
 *     2   [0,3]  [3,0]   [1,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]       2   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]  [3,3]   [4,3] 
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_   
 *          _xZkqqHx_iEkEiBgDiBgD_xHqqkZx_[4,0]_xZkqqHx_iBgDiBgDiEkDiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_              _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkDiBgDiBgD_xHqqkZx_[4,3]_xZkqqHx_iBgDiBgDiEkD_xHqqkZx_   
 *
 *                             _xZkqqHx_iBhJiCePjHpBiCmJjBhNjDpMiBhK_xHqqkZx_                                                      _xZkqqHx_iBhJiCfCjHpBiCmJjBhNjDpMiBhK_xHqqkZx_
 *
 *
 *                  0              1              2              3          
 *                                                                          
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,3]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]  [0,3]   [4,0]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]  [1,3]   [4,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_             _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[2,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]          [2,2]  [2,2]                  [4,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[3,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]  [3,3]   [4,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,3]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjTable::InsertColumn (	const ObjDynabaseVector& vAppendCell,
								const ObjDynabaseVector& vAppendVertRuled,
								const ObjDynabaseVector& vAppendHorzRuled,
								long lColumnIndex,
								mmetol mmWidth)
{
	// _xZkqqHx_jBhNjDpMiClDiCoKiCoJiDeDiDjDiDgGiDgCiDeOiDfIiBgI_xHqqkZx_lColumnIndex_xZkqqHx_iBgIiCmJjBmOiClFiCmEiBeB_xHqqkZx_
	// _xZkqqHx_iDfKiDiLiCmN_xHqqkZx_ [n,lColumnIndex]_xZkqqHx_iBeBjAiCjClMiMhCjApMiCmN_xHqqkZx_ [n,lColumnIndex+1]_xZkqqHx_iBeB_xHqqkZx_
	// _xZkqqHx_jAiFjFlNiMhCjApMiCmN_xHqqkZx_ [lColumnIndex,n] _xZkqqHx_iCkKjBhNjDpMiImKjChFiCmGiCmIiCoJiBeC_xHqqkZx_

	long lC;
	//----- _xZkqqHx_jBhNjDpMiClFiClNjHpBiCmMiKgFiNhDiCmJiDfKiDiLiCpAjBhNjDpM_xHqqkZx_ -----
	for (lC = 0; lC != GetLineCount(); lC++)
		m_vvCell[lC].insert(&m_vvCell[lC][lColumnIndex], vAppendCell[lC]);

	//----- _xZkqqHx_jAiCjClMiMhCjApMiCpAiCfAjHpBjBhNjDpM_xHqqkZx_ -----
	m_vvVertRuled.insert(&m_vvVertRuled[lColumnIndex + 1], ObjDynabaseVector());
	for (lC = 0; lC != GetLineCount(); lC++)
		m_vvVertRuled[lColumnIndex + 1].push_back(vAppendVertRuled[lC]);

	//----- _xZkqqHx_jAiFjFlNiMhCjApMiCpAiNhDjAjEjFkKjBhNjDpM_xHqqkZx_ -----
	for (lC = 0; lC <= GetLineCount(); lC++)
		m_vvHorzRuled[lC].insert(&m_vvHorzRuled[lC][lColumnIndex], vAppendHorzRuled[lC]);

	//----- _xZkqqHx_jHpBjFjNiPoOjFpBiCpAiCfAjHpBjBhNjDpM_xHqqkZx_ -----
	if (mmWidth < 0.0)
	{
		// _xZkqqHx_iNmFiMoDiCmMjHpBiCmJjCmHiJmBiClHiCoJiPoKiNiHiCmNiBeBiIoKiCmCjBePiCmMjHpBiCmMjFjNiCpAiOgHiCkEiBeC_xHqqkZx_
		if (lColumnIndex == GetColumnCount())
			mmWidth = GetColumnWidth(lColumnIndex - 1);
		else
			mmWidth = GetColumnWidth(lColumnIndex);
	}
	m_vColumnWidth.insert(&m_vColumnWidth[lColumnIndex], mmWidth);
	return mmWidth;
} // FCObjTable::InsertColumn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::DeleteLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNhDiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vRemoveCell		:_xZkqqHx_iNoNiPjMiClDiCoKiClNiDfKiDiLjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			vRemoveHorzRuled:_xZkqqHx_iNoNiPjMiClDiCoKiClNjAiFjFlNiMhCjApMjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			vRemoveVertRuled:_xZkqqHx_iNoNiPjMiClDiCoKiClNjAiCjClMiMhCjApMjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			lColumnIndex	:_xZkqqHx_iNoNiPjMiClHiCoJjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *                  0              1              2          
 *                                                           
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]
 *          _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_  
 *          _xZkqqHx_iEkEiBgDiBgD_xHqqkZx_[1,0]_xZkqqHx_iBgDiBgDiEkIiBgDiBgD_xHqqkZx_[1,1]_xZkqqHx_iBgDiBgDiEkIiBgDiBgD_xHqqkZx_[1,2]_xZkqqHx_iBgDiBgDiEkD_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]  [2,1]   [2,2]  [2,2]   [3,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     4   [0,4]  [4,0]   [1,4]  [4,1]   [2,4]  [4,2]   [3,4]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[5,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[5,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[5,2]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 *                      _xZkqqHx_iBhJiCePiNhDiCpAiNoNiPjMiClHiCoJiPoKiNiHiBhK_xHqqkZx_               
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::DeleteLine (ObjDynabaseVector& vRemoveCell,
							ObjDynabaseVector& vRemoveHorzRuled,
							ObjDynabaseVector& vRemoveVertRuled,
							long lLineIndex)
{
	// _xZkqqHx_iCfAiNhDiClFiCkJiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (GetLineCount() == 1) FFThrowMiscUnknown();

	// _xZkqqHx_iNoNiPjMiClDiCoKiCoJiDeDiDjDiDgGiDgCiDeOiDfIiBgI_xHqqkZx_lLineIndex_xZkqqHx_iBgIiCmJjBmOiClFiCmEiBeB_xHqqkZx_
	// _xZkqqHx_iDfKiDiLiCmN_xHqqkZx_ [lLineIndex,n]_xZkqqHx_iBeBjAiFjFlNiMhCjApMiCmN_xHqqkZx_ [lLineIndex+1,n]_xZkqqHx_iBeB_xHqqkZx_
	// _xZkqqHx_jAiCjClMiMhCjApMiCmN_xHqqkZx_ [n,lLineIndex] _xZkqqHx_iCkKiNoNiPjMjBmOiPnLiCmGiCmIiCoJiBeC_xHqqkZx_

	long lC;
	//----- _xZkqqHx_iNoNiPjMiClHiCoJiNhDiCmMiKgFjHpBiCmMiDfKiDiLiCpAiNoNiPjM_xHqqkZx_ -----
	for (lC = 0; lC != GetColumnCount(); lC++)
		vRemoveCell.push_back(m_vvCell[lLineIndex][lC]);
	m_vvCell.erase(&m_vvCell[lLineIndex]);

	//----- _xZkqqHx_jAiFjFlNiMhCjApMiCpAiCfAiNhDiNoNiPjM_xHqqkZx_ -----
	for (lC = 0; lC != GetColumnCount(); lC++)
		vRemoveHorzRuled.push_back(m_vvHorzRuled[lLineIndex + 1][lC]);
	m_vvHorzRuled.erase(&m_vvHorzRuled[lLineIndex + 1]);

	//----- _xZkqqHx_jAiCjClMiMhCjApMiCpAjHpBjAjE_xHqqkZx_+1_xZkqqHx_jFkKiNoNiPjM_xHqqkZx_ -----
	for (lC = 0; lC <= GetColumnCount(); lC++)
	{
		vRemoveVertRuled.push_back(m_vvVertRuled[lC][lLineIndex]);
		m_vvVertRuled[lC].erase(&m_vvVertRuled[lC][lLineIndex]);
	}

	//----- _xZkqqHx_iNhDiNiCiPoOjFpBiCpAiNoNiPjM_xHqqkZx_ -----
	// GetLineCount _xZkqqHx_iCmMiMlDiCmIiCmMiCmFiBeBiNmFiMoDiCmJiNoNiPjMiBeC_xHqqkZx_
	m_vLineHeight.erase(&m_vLineHeight[lLineIndex]);
} // FCObjTable::DeleteLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::DeleteColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHpBiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vRemoveCell		:_xZkqqHx_iNoNiPjMiClDiCoKiClNiDfKiDiLjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			vRemoveVertRuled:_xZkqqHx_iNoNiPjMiClDiCoKiClNjAiCjClMiMhCjApMjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			vRemoveHorzRuled:_xZkqqHx_iNoNiPjMiClDiCoKiClNjAiFjFlNiMhCjApMjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *			lColumnIndex	:_xZkqqHx_iNoNiPjMiClHiCoJjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *                  0               1              2              3         
 *                                                                          
 *          _xZkqqHx_iEkBiBgDiBgD_xHqqkZx_[0,0]_xZkqqHx_iBgDiBgDiEkCiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,3]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]  [0,3]   [4,0]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiBgDiBgD_xHqqkZx_[1,0]_xZkqqHx_iBgDiBgDiEkHiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]  [1,3]   [4,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiBgDiBgD_xHqqkZx_[2,0]_xZkqqHx_iBgDiBgDiEkHiEjPiEjP_xHqqkZx_[2,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,2]  [2,0]   [1,2]  [2,1]   [2,2]  [2,2]   [3,2]  [2,3]   [4,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiBgDiBgD_xHqqkZx_[3,0]_xZkqqHx_iBgDiBgDiEkHiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]  [3,3]   [4,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiBgDiBgD_xHqqkZx_[4,0]_xZkqqHx_iBgDiBgDiEkDiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,3]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 *                              _xZkqqHx_iBhJiCePjHpBiCpAiNoNiPjMiClHiCoJiPoKiNiHiBhK_xHqqkZx_                      
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::DeleteColumn (	ObjDynabaseVector& vRemoveCell,
								ObjDynabaseVector& vRemoveVertRuled,
								ObjDynabaseVector& vRemoveHorzRuled,
								long lColumnIndex)
{
	// _xZkqqHx_iCfAjHpBiClFiCkJiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (GetColumnCount() == 1) FFThrowMiscUnknown();

	// _xZkqqHx_iNoNiPjMiClDiCoKiCoJiDeDiDjDiDgGiDgCiDeOiDfIiBgI_xHqqkZx_lColumnIndex_xZkqqHx_iBgIiCmJjBmOiClFiCmEiBeB_xHqqkZx_
	// _xZkqqHx_iDfKiDiLiCmN_xHqqkZx_ [n,lColumnIndex]_xZkqqHx_iBeBjAiCjClMiMhCjApMiCmN_xHqqkZx_ [lColumnIndex+1,n]_xZkqqHx_iBeB_xHqqkZx_
	// _xZkqqHx_jAiFjFlNiMhCjApMiCmN_xHqqkZx_ [n,lColumnIndex] _xZkqqHx_iCkKiNoNiPjMjBmOiPnLiCmGiCmIiCoJiBeC_xHqqkZx_

	long lC;
	//----- _xZkqqHx_iNoNiPjMiClHiCoJjHpBiCmMiKgFiNhDiCmMiDfKiDiLiCpAiNoNiPjM_xHqqkZx_ -----
	for (lC = 0; lC != GetLineCount(); lC++)
	{
		vRemoveCell.push_back(m_vvCell[lC][lColumnIndex]);
		m_vvCell[lC].erase(&m_vvCell[lC][lColumnIndex]);
	}

	//----- _xZkqqHx_jAiCjClMiMhCjApMiCpAiCfAjHpBiNoNiPjM_xHqqkZx_ -----
	for (lC = 0; lC != GetLineCount(); lC++)
		vRemoveVertRuled.push_back(m_vvVertRuled[lColumnIndex + 1][lC]);
	m_vvVertRuled.erase(&m_vvVertRuled[lColumnIndex + 1]);

	//----- _xZkqqHx_jAiFjFlNiMhCjApMiCpAiNhDjAjE_xHqqkZx_+1_xZkqqHx_jFkKiNoNiPjM_xHqqkZx_ -----
	for (lC = 0; lC <= GetLineCount(); lC++)
	{
		vRemoveHorzRuled.push_back(m_vvHorzRuled[lC][lColumnIndex]);
		m_vvHorzRuled[lC].erase(&m_vvHorzRuled[lC][lColumnIndex]);
	}

	//----- _xZkqqHx_jHpBjFjNiPoOjFpBiCpAiNoNiPjM_xHqqkZx_ -----
	// GetColumnCount _xZkqqHx_iCmMiMlDiCmIiCmMiCmFiBeBiNmFiMoDiCmJiNoNiPjMiBeC_xHqqkZx_
	m_vColumnWidth.erase(&m_vColumnWidth[lColumnIndex]);
} // FCObjTable::DeleteColumn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetLineCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiNhDjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNhDjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjTable::GetLineCount () const
{
	return m_vLineHeight.size();
} // FCObjTable::GetLineCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetColumnCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMjHpBjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHpBjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjTable::GetColumnCount () const
{
	return m_vColumnWidth.size();
} // FCObjTable::GetColumnCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetLineHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNhDiCmMiNiCiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLineIndex	:_xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNhDiCmMiNiCiClDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjTable::GetLineHeight (long lLineIndex) const
{
	return m_vLineHeight[lLineIndex];
} // FCObjTable::GetLineHeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetColumnWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHpBiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lColumnIndex	:_xZkqqHx_jHpBiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHpBiCmMjFjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjTable::GetColumnWidth (long lColumnIndex) const
{
// 05.02.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return m_vHorzRuledLine[lColumnIndex].m_mmWidth;
	return m_vColumnWidth[lColumnIndex];
} // FCObjTable::GetColumnWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::SetLineHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNhDiCmMiNiCiClDiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLineIndex	:_xZkqqHx_iNhDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmWidth		:_xZkqqHx_iNhDiCmMiNiCiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::SetLineHeight (long lLineIndex, mmetol mmWidth)
{
	m_vLineHeight[lLineIndex] = mmWidth;

	// _xZkqqHx_iNhDiNiCiBeBjHpBjFjNiPoOjFpBiCmJiNiHiCoNiClJiCmEiBeBjFjEjFgJiCpAiNmEjEhKjChFiClHiCoJiBeC_xHqqkZx_
	LayoutCellRuled();
	// _xZkqqHx_jBfDjBmMiCmMiNiCiClDiCpAiNmEiMhGiOfKiBeC_xHqqkZx_
	CalcResizeFrame();
// 05.05.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	CalcOuterFrame();
} // FCObjTable::SetLineHeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::SetColumnWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHpBiCmMjFjNiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lColumnIndex:_xZkqqHx_jHpBiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmWidth		:_xZkqqHx_jHpBiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::SetColumnWidth (long lColumnIndex, mmetol mmWidth)
{
	m_vColumnWidth[lColumnIndex] = mmWidth;
	// _xZkqqHx_iNhDiNiCiBeBjHpBjFjNiPoOjFpBiCmJiNiHiCoNiClJiCmEiBeBjFjEjFgJiCpAiNmEjEhKjChFiClHiCoJiBeC_xHqqkZx_
	LayoutCellRuled();
	// _xZkqqHx_jBfDjBmMiCmMiNiCiClDiCpAiNmEiMhGiOfKiBeC_xHqqkZx_
	CalcResizeFrame();
// 05.05.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	CalcOuterFrame();
} // FCObjTable::SetColumnWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetCellTopCoord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNhDiCmMiPoDiCmMiMhCjApMiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLineIndex	:_xZkqqHx_iNhDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNhDiCmMiPoDiCmMiMhCjApMiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjTable::GetCellTopCoord (long lLineIndex) const
{
	long lLine;
	mmetol mmY = m_mmptLeftTop.y;
	for (lLine = 0; lLine < lLineIndex; lLine++)
		mmY += GetLineHeight(lLine);
	return mmY;
} // FCObjTable::GetCellTopCoord.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetCellLeftCoord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHpBiCmMiPoDiCmMiMhCjApMiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lColumnIndex	:_xZkqqHx_jHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHpBiCmMiPoDiCmMiMhCjApMiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjTable::GetCellLeftCoord (long lColumnIndex) const
{
	long lColumn;
	mmetol mmX = m_mmptLeftTop.x;
	for (lColumn = 0; lColumn < lColumnIndex; lColumn++)
		mmX += GetColumnWidth(lColumn);
	return mmX;
} // FCObjTable::GetCellLeftCoord.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetHorzRuledY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMjAiFjFlNiMhCjApMiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmY			:0 < lFrontIndex _xZkqqHx_iCmMiPoKiNiHiCmNiBeBiIoKiCmCiPoDiCmMjAiFjFlNiMhCjApMiCmM_xHqqkZx_
 *						 Y_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeCjAfGiClFiCkC_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			lFrontIndex	:_xZkqqHx_jAiFjFlNiMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiMhCjApMiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjTable::GetHorzRuledY (mmetol& mmY, long lFrontIndex) const
{
	if (lFrontIndex == 0)
	{
		mmY = m_mmptLeftTop.y;
	} else
	if (lFrontIndex <= GetLineCount())
	{
		mmY += GetLineHeight(lFrontIndex - 1);
	} else
	{
		return FALSE;
	}
	return TRUE;
} // FCObjTable::GetHorzRuledY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetVertRuledX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMjAiCjClMiMhCjApMiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmX			:0 < lFrontIndex _xZkqqHx_iCmMiPoKiNiHiCmNiBeBiIoKiCmCiNlGiCmMjAiCjClMiMhCjApMiCmM_xHqqkZx_
 *						 X_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeCjAfGiClFiCkC_xHqqkZx_X_xZkqqHx_iNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			lFrontIndex	:_xZkqqHx_jAiCjClMiMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiMhCjApMiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjTable::GetVertRuledX (mmetol& mmX, long lFrontIndex) const
{
	if (lFrontIndex == 0)
	{
		mmX = m_mmptLeftTop.x;
	} else
	if (lFrontIndex <= GetColumnCount())
	{
		mmX += GetColumnWidth(lFrontIndex - 1);
	} else
	{
		return FALSE;
	}
	return TRUE;
} // FCObjTable::GetVertRuledX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::CalcLineTopBottomArray
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFfMjFjEjFgJiCmMjBfDiCmEiCmMiNhDiCmMiPoDiNmAjFfHiCmGiJlKiNmAjFfHiCmMiDhJiDeBiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTopBottom	:_xZkqqHx_jBfDiCmEiCmMiNhDiCmMiPoDiNmAjFfHiCmGiJlKiNmAjFfHiCmMiDhJiDeBiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			pObjTable	:_xZkqqHx_jFfMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::CalcLineTopBottomArray (vector< pair<mmetol, mmetol> >& vTopBottom) const
{
	vTopBottom.clear();
	mmetol mmTop = m_mmptLeftTop.y;
	long lLineIndex;
	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
	{
		mmetol mmBottom = mmTop + GetLineHeight(lLineIndex);
		vTopBottom.push_back(pair<mmetol, mmetol>(mmTop, mmBottom));
		mmTop = mmBottom;
	}
} // FCObjTable::CalcLineTopBottomArray.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::CalcColumnLeftRightArray
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFfMjFjEjFgJiCmMjBfDiCmEiCmMjHpBiCmMiNlGiNmAjFfHiCmGiJeFiNmAjFfHiCmMiDhJiDeBiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vLeftRight	:_xZkqqHx_jBfDiCmEiCmMjHpBiCmMiNlGiNmAjFfHiCmGiJeFiNmAjFfHiCmMiDhJiDeBiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			pObjTable	:_xZkqqHx_jFfMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::CalcColumnLeftRightArray (vector< pair<mmetol, mmetol> >& vLeftRight) const
{
	vLeftRight.clear();
	mmetol mmLeft = m_mmptLeftTop.x;
	long lColumnIndex;
	for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
	{
		mmetol mmRight = mmLeft + GetColumnWidth(lColumnIndex);
		vLeftRight.push_back(pair<mmetol, mmetol>(mmLeft, mmRight));
		mmLeft = mmRight;
	}
} // FCObjTable::CalcColumnLeftRightArray.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetCellFrameRuled
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLiCmMiOpMiImNiCmMiMhCjApMiBgJjAiCjClMiMhCjApMiBgKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stLeftRuledIndex	:_xZkqqHx_iNlGjBkEiMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			stTopRuledIndex		:_xZkqqHx_iPoDjBkEiMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			stRightRuledIndex	:_xZkqqHx_iJeFjBkEiMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			stBottomRuledIndex	:_xZkqqHx_iJlKjBkEiMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			cellIndex			:_xZkqqHx_iDfKiDiLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLiCmMiOpMiImNiCmMiMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLiCkKjBlMiCmGiMiLiNiHiClFiCmEiCkCiClNiPoKiNiHiCmNiBeBiClLiCoKiCoHiCoAiKnMiCnPiClNiOpMiImNiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiBeB_xHqqkZx_[1,1]_xZkqqHx_iCmMiDfKiDiLiCpAiOhHjCoIiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iNlGjBkEiBeG_xHqqkZx_[1,1]_xZkqqHx_iBeB_xHqqkZx_[1,2]
 *			_xZkqqHx_iPoDjBkEiBeG_xHqqkZx_[1,1]
 *			_xZkqqHx_iJeFjBkEiBeG_xHqqkZx_[2,1]_xZkqqHx_iBeB_xHqqkZx_[2,2]
 *			_xZkqqHx_iJlKjBkEiBeG_xHqqkZx_[3,1]
 *
 *                     0               1               2               3          
 *                                                                                
 *            _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_-[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_-[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_-[0,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_-[0,3]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *            _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_  
 *       0   [0,0]   [0,0]   [1,0]   [0,1]   [2,0]   [0,2]   [3,0]   [0,3]   [4,0]
 *            _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_  
 *            _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_-[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_-[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_-[1,2]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_-[1,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *            _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_  
 *       1   [0,1]   [1,0]   [1,1]   [1,1]   [2,1]   [1,2]   [3,1]   [1,3]   [4,1]
 *            _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_  
 *            _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_-[2,0]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_              _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_-[2,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_-[2,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *            _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_  
 *       2   [0,2]   [2,0]   [1,2]           [2,2]   [2,2]                   [4,2]
 *            _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_  
 *            _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_-[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_-[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_-[3,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_-[3,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *            _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_  
 *       3   [0,3]   [3,0]   [1,3]   [3,1]   [2,3]   [3,2]   [3,3]   [3,3]   [4,3]
 *            _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_  
 *            _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_-[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_-[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_-[4,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_-[4,3]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::GetCellFrameRuled (set<FCFrontSide>* stLeftRuledIndex,
									set<FCFrontSide>* stTopRuledIndex,
									set<FCFrontSide>* stRightRuledIndex,
									set<FCFrontSide>* stBottomRuledIndex,
									const FCLineColumn& cellIndex) const
{
	if (GetCell(cellIndex) == NULL) FFThrowMiscUnknown();
	FCLineColumn cellIndexFrom;
	FCLineColumn cellIndexUntil;
	// cellIndex_xZkqqHx_iCkKjBkOiClHiCoJiDfKiDiLiDhFiDiNiDgCiDeOiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	GetCellBlock(cellIndex, &cellIndexFrom, &cellIndexUntil);
	long lLineIndex;
	long lColumnIndex;
	if (stLeftRuledIndex != NULL)
	//----- _xZkqqHx_iNlGjBkEjAiCjClMiMhCjApMiCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		for (lLineIndex = cellIndexFrom.GetLineIndex();
			 lLineIndex <= cellIndexUntil.GetLineIndex(); lLineIndex++)
		{
			// _xZkqqHx_iMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			FCFrontSide ruledIndex(cellIndexFrom.GetColumnIndex(), lLineIndex);
			// _xZkqqHx_iMhCjApMjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiBeBiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
			if (GetRuled(FALSE, ruledIndex) != NULL)
				stLeftRuledIndex->insert(ruledIndex);
		}
	}

	if (stTopRuledIndex != NULL)
	//----- _xZkqqHx_iPoDjBkEjAiCjClMiMhCjApMiCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		for (lColumnIndex = cellIndexFrom.GetColumnIndex();
			 lColumnIndex <= cellIndexUntil.GetColumnIndex(); lColumnIndex++)
		{
			// _xZkqqHx_iMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			FCFrontSide ruledIndex(cellIndexFrom.GetLineIndex(), lColumnIndex);
			// _xZkqqHx_iMhCjApMjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiBeBiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
			if (GetRuled(TRUE, ruledIndex) != NULL)
				stTopRuledIndex->insert(ruledIndex);
		}
	}

	if (stRightRuledIndex != NULL)
	//----- _xZkqqHx_iJeFjBkEjAiCjClMiMhCjApMiCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		for (lLineIndex = cellIndexFrom.GetLineIndex();
			 lLineIndex <= cellIndexUntil.GetLineIndex(); lLineIndex++)
		{
			// _xZkqqHx_iMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			FCFrontSide ruledIndex(cellIndexUntil.GetColumnIndex() + 1, lLineIndex);
			// _xZkqqHx_iMhCjApMjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiBeBiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
			if (GetRuled(FALSE, ruledIndex) != NULL)
				stRightRuledIndex->insert(ruledIndex);
		}
	}

	if (stBottomRuledIndex != NULL)
	//----- _xZkqqHx_iJlKjBkEjAiCjClMiMhCjApMiCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		for (lColumnIndex = cellIndexFrom.GetColumnIndex();
			 lColumnIndex <= cellIndexUntil.GetColumnIndex(); lColumnIndex++)
		{
			// _xZkqqHx_iMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			FCFrontSide ruledIndex(cellIndexUntil.GetLineIndex() + 1, lColumnIndex);
			// _xZkqqHx_iMhCjApMjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiBeBiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
			if (GetRuled(TRUE, ruledIndex) != NULL)
				stBottomRuledIndex->insert(ruledIndex);
		}
	}
} // FCObjTable::GetCellFrameRuled.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::Copy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmMjFjEjFgJiCmJjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jBkOjAkLiCpAiDfCiDhDiBfLiClDiCoKiCoJjFjEjFgJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::Copy (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Copy(pObj);
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	FCObjTable::CopySelf(pObj);
} // FCObjTable::Copy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::CopySelf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmJjBkOiClHiCoJjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::CopySelf (FCObjDynabase* pObj) const
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFjGlDiCkPiCoKiCmOjFkBiOmKiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FCObjTable::Type())) return;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	ASSERT(	sizeof(*this) - offsetof(FCObjTable, m_mmptLeftTop) ==
			sizeof(m_mmptLeftTop) +
			sizeof(m_vLineHeight) +
			sizeof(m_vColumnWidth) +
			sizeof(m_vvCell) +
			sizeof(m_vvHorzRuled) +
			sizeof(m_vvVertRuled));
	FCObjTable* pPt = reinterpret_cast<FCObjTable*>(pObj);
	pPt->m_mmptLeftTop = m_mmptLeftTop;
	pPt->m_vLineHeight = m_vLineHeight;
	pPt->m_vColumnWidth = m_vColumnWidth;
	vector<longVector> vvCellMemberIndex;
	ObjArrayToMemberArray(vvCellMemberIndex, m_vvCell);
	pPt->MemberArrayToObjArray(pPt->m_vvCell, vvCellMemberIndex);
	vector<longVector> vvHorzRuledMemberIndex;
	ObjArrayToMemberArray(vvHorzRuledMemberIndex, m_vvHorzRuled);
	pPt->MemberArrayToObjArray(pPt->m_vvHorzRuled, vvHorzRuledMemberIndex);
	vector<longVector> vvVertRuledMemberIndex;
	ObjArrayToMemberArray(vvVertRuledMemberIndex, m_vvVertRuled);
	pPt->MemberArrayToObjArray(pPt->m_vvVertRuled, vvVertRuledMemberIndex);
} // FCObjTable::CopySelf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::Move
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiInKjDkOiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmDX	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_X_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *			mmDY	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_Y_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::Move (mmetol mmDX, mmetol mmDY)
{
	if (mmDX == 0.0 && mmDY == 0.0) return;
	// _xZkqqHx_iNlGiPoDiNmAjFfHiCpAiLeMjIfOiBeC_xHqqkZx_
	m_mmptLeftTop += DBLPoint(mmDX, mmDY);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Move(mmDX, mmDY);
} // FCObjTable::Move.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::Resize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiDiKiDfEiDeDiDfJiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmNiBeBiDfEiDeDiDfJiCkKiCmIiCoJiCnHiCkNjAlDiKgNiCmJ_xHqqkZx_mmrtNew_xZkqqHx_iCmJiCmIiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	: X_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			bYPosi	: Y_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			mmrtNew	: _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfH_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::Resize (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld)
{
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	double dMagnifH = mmrtNew.Width() / mmrtOld.Width();
//	double dMagnifV = mmrtNew.Height() / mmrtOld.Height();
//
//	mmetol mmWidth = 0.0;
//	mmetol mmHeight = 0.0;
//	mmetolVector::iterator iRule;
//	for (iRule = m_vColumnWidth.begin(); iRule != m_vColumnWidth.end(); iRule++)
//	{
//		*iRule *= dMagnifH;
//		mmWidth += *iRule;
//	}
//	for (iRule = m_vLineHeight.begin(); iRule != m_vLineHeight.end(); iRule++)
//	{
//		*iRule *= dMagnifV;
//		mmHeight += *iRule;
//	}
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----

	mmetolVector vNewColumnWidth;
// 05.06.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (!CalcNewColumnWidth(vNewColumnWidth, mmrtNew.Width())) return;
	CalcNewColumnWidth(vNewColumnWidth, mmrtNew.Width());
	mmetolVector vNewLineHeight;
// 05.06.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (!CalcNewLineHeight(vNewLineHeight, mmrtNew.Height())) return;
	CalcNewLineHeight(vNewLineHeight, mmrtNew.Height());

	mmetol mmWidth = 0.0;
	long lColumnIndex;
	for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
	{
		m_vColumnWidth[lColumnIndex] = vNewColumnWidth[lColumnIndex];
		mmWidth += m_vColumnWidth[lColumnIndex];
	}
	mmetol mmHeight = 0.0;
	long lLineIndex;
	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
	{
		m_vLineHeight[lLineIndex] = vNewLineHeight[lLineIndex];
		mmHeight += m_vLineHeight[lLineIndex];
	}
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iMoLiNlHjFoCjAlDiBeCiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCmGiIoKjChGiClHiCoJiCoGiCkEiBeBiNmFiMoDiCmMiNhDiBeBiNmFiMoDiCmMjHpBiCmMjFjNiCpAjFoCjAlDiBeC_xHqqkZx_
	m_vColumnWidth.back() += (mmrtNew.Width() - mmWidth);
	m_vLineHeight.back() += (mmrtNew.Height() - mmHeight);
	// _xZkqqHx_iNlGiPoDiNmAjFfHiCpAiLeMjIfOiBeC_xHqqkZx_
	m_mmptLeftTop = DBLPoint(mmrtNew.left, mmrtNew.top);

//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCjElNjDfNiCmNiClDiClJiCmIiCkCiBeC_xHqqkZx_
//	BASE_CLASS::Resize(TRUE, TRUE, mmrtNew, mmrtOld);
//
//	// _xZkqqHx_iNhDiNiCiBeBjHpBjFjNiPoOjFpBiCmJiNiHiCoNiClJiCmEiBeBjFjEjFgJiCpAiNmEjEhKjChFiClHiCoJiBeC_xHqqkZx_BASE_CLASS::Resize _xZkqqHx_iCmF_xHqqkZx_
//	// _xZkqqHx_iNmEjEhKjChFiCmNiPgPjHiIiCmEiCkCiCoJiCkKiBeBiNnHiCkJiCkCiMoLiNlHiCpA_xHqqkZx_ m_vColumnWidth_xZkqqHx_iBeB_xHqqkZx_m_vLineHeight_xZkqqHx_iCmJ_xHqqkZx_
//	// _xZkqqHx_iNiHiCoNiClJiCoJiClNiCnPiCmJiNmEjEhKjChFiClHiCoJiBeC_xHqqkZx_
//	LayoutCellRuled();
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iNhDiNiCiBeBjHpBjFjNiPoOjFpBiCmJiNiHiCoNiClJiCmEiBeBjFjEjFgJiCpAiNmEjEhKjChFiClHiCoJiBeC_xHqqkZx_BASE_CLASS::Resize _xZkqqHx_iCmF_xHqqkZx_
	// _xZkqqHx_iNmEjEhKjChFiCmNiPgPjHiIiCmEiCkCiCoJiCkKiBeBiNnHiCkJiCkCiMoLiNlHiCpA_xHqqkZx_ m_vColumnWidth_xZkqqHx_iBeB_xHqqkZx_m_vLineHeight_xZkqqHx_iCmJ_xHqqkZx_
	// _xZkqqHx_iNiHiCoNiClJiCoJiClNiCnPiCmJiNmEjEhKjChFiClHiCoJiBeC_xHqqkZx_
	LayoutCellRuled();
	// BASE_CLASS_xZkqqHx_iCmMjAfGiClFiCkCiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	// BASE_CLASS::Resize _xZkqqHx_iCpAiMmEiCmOiClIiCmJiDiBiDjDiDgPiBfLiCpAiDiMiDeDiDeBiDeFiDgHiClFiClNiClNiCnPiBeB_xHqqkZx_
	// _xZkqqHx_iClBiClBiCmFjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	m_mmrtResize = mmrtNew;
	// Base-BaseClass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCjElNjDfNiCmNiClDiClJiCmIiCkCiBeC_xHqqkZx_
	BASE_BASE_CLASS::Resize(TRUE, TRUE, mmrtNew, mmrtOld);
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjTable::Resize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::Rotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR		:_xZkqqHx_iJpBjDfNiClDiClJiCoJiKhAjDhIiBeC_xHqqkZx_-2.0 < dR < 2.0.
 *			mmCX	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfH_xHqqkZx_
 *			mmCX	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::Rotate (double dR, const DBLPoint& mmptCenter)
{
	// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmM_xHqqkZx_Rotate_xZkqqHx_iKnGjAjEiCmNiDiBiDjDiDgPiBfLjFjEjFgJiCpAiJpBjDfNiClDiClJiCoJiCmMiCmFiBeBiOmAiNhDiClFiCmIiCkCiBeC_xHqqkZx_
	BASE_BASE_CLASS::Rotate(dR, mmptCenter);
} // FCObjTable::Rotate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::OutSizeStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiPoOjFpBiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vBuff	:_xZkqqHx_iPgPjHmNjAoGiCmMiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bXPosi	:X_xZkqqHx_jFpLiMpMiCkKjElNjDfNiClFiClNiDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bYPosi	:Y_xZkqqHx_jFpLiMpMiCkKjElNjDfNiClFiClNiDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiPoOjFpBiCpAiMlDiCmJiDfEiDeDiDfJiCpAjFjMiMlDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::OutSizeStream (BYTEVector& vBuff, BOOL bXPosi, BOOL bYPosi) const
{
	// _xZkqqHx_iNlGiPoDiNmAjFfHiCpAiLeMjIfOiBeC_xHqqkZx_
	vBuff << m_mmptLeftTop;
	// _xZkqqHx_iDfEiDeDiDfJiCpAiKkOjBfDiCmJiLeMjIfOiClHiCoJiClNiCnPiCmJiBeBjBfDiCmEiCmMjHpBiCmMjFjNiCmGiNhDiCmMiNiCiClDiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
	long lColumnIndex;
	for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
		vBuff << GetColumnWidth(lColumnIndex);
	long lLineIndex;
	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
		vBuff << GetLineHeight(lLineIndex);
} // FCObjTable::OutSizeStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::InSizeStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiPoOjFpBiCpAjDmHiCnNiNjOiCpBiCmFiBeBiDfEiDeDiDfJiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pBuff	:_xZkqqHx_iDgGiBfLiDfOiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::InSizeStream (const BYTE*& pBuff)
{
	// _xZkqqHx_iNlGiPoDiNmAjFfHiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	FFReadData(m_mmptLeftTop, pBuff);
	// _xZkqqHx_jBfDiCmEiCmMjHpBiCmMjFjNiCmGiNhDiCmMiNiCiClDiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	long lColumnIndex;
	for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
	{
		mmetol mmWidth;
		FFReadData(mmWidth, pBuff);
		m_vColumnWidth[lColumnIndex] = mmWidth;
	}
	long lLineIndex;
	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
	{
		mmetol mmHeight;
		FFReadData(mmHeight, pBuff);
		m_vLineHeight[lLineIndex] = mmHeight;
	}
	// _xZkqqHx_iNhDiNiCiBeBjHpBjFjNiPoOjFpBiCmJiNiHiCoNiClJiCmEiBeBjFjEjFgJiCpAiNmEjEhKjChFiClHiCoJiBeC_xHqqkZx_
	LayoutCellRuled();
	// _xZkqqHx_jBfDjBmMiCmMiNiCiClDiCpAiNmEiMhGiOfKiBeC_xHqqkZx_
	CalcResizeFrame();
} // FCObjTable::InSizeStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetCell
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLiCmMjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cellIndex	:_xZkqqHx_iDfKiDiLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDiLiCmMjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjTextRect* FCObjTable::GetCell (const FCLineColumn& cellIndex)
{
	return (FCObjTextRect*)m_vvCell[cellIndex.GetLineIndex()][cellIndex.GetColumnIndex()];
} // FCObjTable::GetCell.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetCell
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLiCmMjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cellIndex	:_xZkqqHx_iDfKiDiLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDiLiCmMjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCObjTextRect* FCObjTable::GetCell (const FCLineColumn& cellIndex) const
{
	return (const FCObjTextRect*)m_vvCell[cellIndex.GetLineIndex()][cellIndex.GetColumnIndex()];
} // FCObjTable::GetCell.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetRuled
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiMhCjApMiCmMjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsHorz		:_xZkqqHx_jAiFjFlNiMhCjApMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBjAiCjClMiMhCjApMiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			ruledIndex	:_xZkqqHx_iMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMhCjApMiCmMjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjLine* FCObjTable::GetRuled (BOOL bIsHorz, const FCFrontSide& ruledIndex)
{
	if (bIsHorz)	// _xZkqqHx_jAiFjFlNiMhCjApMiCmMiPoKiNiHiBeC_xHqqkZx_
		return (FCObjLine*)m_vvHorzRuled[ruledIndex.GetFrontIndex()][ruledIndex.GetSideIndex()];
	else			// _xZkqqHx_jAiCjClMiMhCjApMiCmMiPoKiNiHiBeC_xHqqkZx_
		return (FCObjLine*)m_vvVertRuled[ruledIndex.GetFrontIndex()][ruledIndex.GetSideIndex()];
} // FCObjTable::GetRuled.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetRuled
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiMhCjApMiCmMjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsHorz		:_xZkqqHx_jAiFjFlNiMhCjApMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBjAiCjClMiMhCjApMiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			ruledIndex	:_xZkqqHx_iMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMhCjApMiCmMjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCObjLine* FCObjTable::GetRuled (BOOL bIsHorz, const FCFrontSide& ruledIndex) const
{
	if (bIsHorz)	// _xZkqqHx_jAiFjFlNiMhCjApMiCmMiPoKiNiHiBeC_xHqqkZx_
		return (const FCObjLine*)m_vvHorzRuled[ruledIndex.GetFrontIndex()][ruledIndex.GetSideIndex()];
	else			// _xZkqqHx_jAiCjClMiMhCjApMiCmMiPoKiNiHiBeC_xHqqkZx_
		return (const FCObjLine*)m_vvVertRuled[ruledIndex.GetFrontIndex()][ruledIndex.GetSideIndex()];
} // FCObjTable::GetRuled.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::SetCell
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLiCmMjFjEjFgJiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cellIndex	:_xZkqqHx_iDfKiDiLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pCell		:_xZkqqHx_iDfKiDiLjFjEjFgJiCpAiOhHjCoIiBeCiJpAiPjMiClHiCoJiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::SetCell (const FCLineColumn& cellIndex, FCObjTextRect* pCell)
{
	m_vvCell[cellIndex.GetLineIndex()][cellIndex.GetColumnIndex()] = pCell;
} // FCObjTable::SetCell.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::SetRuled
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiMhCjApMiCmMjFjEjFgJiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsHorz		:_xZkqqHx_jAiFjFlNiMhCjApMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBjAiCjClMiMhCjApMiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			ruledIndex	:_xZkqqHx_iMhCjApMiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pRuled		:_xZkqqHx_iMhCjApMjFjEjFgJiCpAiOhHjCoIiBeCiJpAiPjMiClHiCoJiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::SetRuled (BOOL bIsHorz, const FCFrontSide& ruledIndex, FCObjLine* pRuled)
{
	if (bIsHorz)	// _xZkqqHx_jAiFjFlNiMhCjApMiCmMiPoKiNiHiBeC_xHqqkZx_
		m_vvHorzRuled[ruledIndex.GetFrontIndex()][ruledIndex.GetSideIndex()] = pRuled;
	else			// _xZkqqHx_jAiCjClMiMhCjApMiCmMiPoKiNiHiBeC_xHqqkZx_
		m_vvVertRuled[ruledIndex.GetFrontIndex()][ruledIndex.GetSideIndex()] = pRuled;
} // FCObjTable::SetRuled.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetIncludedRuled
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkBjAjEiCmMiDfKiDiLiCmFiNfMjAkMiClDiCoKiCoJiLoJiMgAiCmMiDfKiDiLiDhFiDiNiDgCiDeOiCmJiKnMiCnMiCoKiCoJiMhCjApM_xHqqkZx_
 *			_xZkqqHx_iBgJiDhFiDiNiDgCiDeOiCmMjHnGiKhDiCmNiKnMiCnMiCmIiCkCiBgKiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stHorzRuled		:_xZkqqHx_jAiFjFlNiMhCjApMiCmMiIoKjHjHiCpAjFnEiClHiBeCiOmAiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *			stVertRuled		:_xZkqqHx_jAiCjClMiMhCjApMiCmMiIoKjHjHiCpAjFnEiClHiBeCiOmAiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *			cellIndexFrom	:_xZkqqHx_iDfKiDiLiDhFiDiNiDgCiDeOiCmMiNlGiPoDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iJlMjBhKiDeBiDgIiDiMiDfIiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *			cellIndexUntil	:_xZkqqHx_iDfKiDiLiDhFiDiNiDgCiDeOiCmMiJeFiJlKiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iJlMjBhKiDeBiDgIiDiMiDfIiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiCkGiCmOiBeBiJlKiCmMjAhNiCmJiCkIiCkCiCmEiBeB_xHqqkZx_cellIndexFrom=[0,0]_xZkqqHx_iBeB_xHqqkZx_
 *			cellIndexUntil=[1,1]_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiBeBjDfPjApMiCmFiOkGiClHiMhCjApMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 *                  0              1              2          
 *                                                           
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiBgDiBgD_xHqqkZx_[1,0]_xZkqqHx_iBgDiBgDiEkJiBgDiBgD_xHqqkZx_[1,1]_xZkqqHx_iBgDiBgDiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBeG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]  [2,1]   [2,2]  [2,2]   [3,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]  [3,2]   [3,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *                                                           
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::GetIncludedRuled (	set<FCFrontSide> &stHorzRuled,
									set<FCFrontSide>& stVertRuled,
									const FCLineColumn& cellIndexFrom,
									const FCLineColumn& cellIndexUntil) const
{
	stHorzRuled.clear();
	stVertRuled.clear();
	long lFrontIndex;
	long lSideIndex;
	//----- _xZkqqHx_jAiFjFlNiMhCjApMiCpAjAnNjCoI_xHqqkZx_ -----
	for (lFrontIndex = cellIndexFrom.GetLineIndex() + 1;
		 lFrontIndex <= cellIndexUntil.GetLineIndex(); lFrontIndex++)
	{
		for (lSideIndex = cellIndexFrom.GetColumnIndex();
			 lSideIndex <= cellIndexUntil.GetColumnIndex(); lSideIndex++)
		{
			if (GetRuled(TRUE, FCFrontSide(lFrontIndex, lSideIndex)) != NULL)
				stHorzRuled.insert(FCFrontSide(lFrontIndex, lSideIndex));
		}
	}
	//----- _xZkqqHx_jAiCjClMiMhCjApMiCpAjAnNjCoI_xHqqkZx_ -----
	for (lFrontIndex = cellIndexFrom.GetColumnIndex() + 1;
		 lFrontIndex <= cellIndexUntil.GetColumnIndex(); lFrontIndex++)
	{
		for (lSideIndex = cellIndexFrom.GetLineIndex();
			 lSideIndex <= cellIndexUntil.GetLineIndex(); lSideIndex++)
		{
			if (GetRuled(FALSE, FCFrontSide(lFrontIndex, lSideIndex)) != NULL)
				stVertRuled.insert(FCFrontSide(lFrontIndex, lSideIndex));
		}
	}
} // FCObjTable::GetIncludedRuled.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetCellBlock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLiCkKjBkOiClHiCoJiDfKiDiLiDhFiDiNiDgCiDeOiCmMjEmNiImNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cellIndex		:_xZkqqHx_jClCiCnHiCoJjBmOiPnLiCmMiDfKiDiLiCpAiOhHjCoIiBeCiJlMjBhKiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *			pCellIndexFrom	:_xZkqqHx_iDfKiDiLiDhFiDiNiDgCiDeOiCmMiNlGiPoDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeCiJlMjBhKiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pCellIndexUntil	:_xZkqqHx_iDfKiDiLiDhFiDiNiDgCiDeOiCmMiJeFiJlKiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeCiJlMjBhKiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDiLiDhFiDiNiDgCiDeOiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiCkGiCmOiJlKjAhNiCmMiPoKiNiHiBeB_xHqqkZx_cellIndex = [2,2]_xZkqqHx_iBgJ_xHqqkZx_[2,3],[3,2],[3,3]_xZkqqHx_iCmFiCoAjDkPiClGiBgK_xHqqkZx_
 *			_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_cellIndexFrom = [2,2]_xZkqqHx_iBeB_xHqqkZx_cellIndexUntil = [3,3]
 *			_xZkqqHx_iCkKjFnEiCoJiBeC_xHqqkZx_
 *
 *                  0              1              2              3          
 *                                                                          
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,3]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]  [0,3]   [4,0]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]  [1,3]   [4,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_             _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[2,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]          [2,2]  [2,2]                  [4,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]                 [3,3]    [4,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEjPiEjPiEjP_xHqqkZx_[4,3]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjTable::GetCellBlock (	const FCLineColumn& cellIndex,
								FCLineColumn* pCellIndexFrom,
								FCLineColumn* pCellIndexUntil) const
{
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FCLineColumn cellIndexFrom;
//	FCLineColumn cellIndexUntil;
//	long lLineIndex;
//	long lColumnIndex;
//	// _xZkqqHx_iPoDjFpLiMpMiCpAiMjPiNpFiBeC_xHqqkZx_
//	for (lLineIndex = cellIndex.GetLineIndex(); lLineIndex != 0; lLineIndex--)
//	{
//		// _xZkqqHx_iMjPiNpFjBmOiPnLiDfKiDiLiCmMiPoDiCmMiMhCjApMiBeC_xHqqkZx_
//		FCFrontSide ruledIndex(lLineIndex, cellIndex.GetColumnIndex());
//		// _xZkqqHx_iPoDiCmMiMhCjApMiCkKiCkAiCmBiClNiCoHiMjPiNpFiCpAjCoCiOhOiBeC_xHqqkZx_
//		if (GetRuled(TRUE, ruledIndex) != NULL) break;
//	}
//	cellIndexFrom.SetLineIndex(lLineIndex);
//
//	// _xZkqqHx_iNlGjFpLiMpMiCpAiMjPiNpFiBeC_xHqqkZx_
//	for (lColumnIndex = cellIndex.GetColumnIndex(); lColumnIndex != 0; lColumnIndex--)
//	{
//		// _xZkqqHx_iMjPiNpFjBmOiPnLiDfKiDiLiCmMiNlGiCmMiMhCjApMiBeC_xHqqkZx_
//		FCFrontSide ruledIndex(lColumnIndex, cellIndex.GetLineIndex());
//		// _xZkqqHx_iNlGiCmMiMhCjApMiCkKiCkAiCmBiClNiCoHiMjPiNpFiCpAjCoCiOhOiBeC_xHqqkZx_
//		if (GetRuled(FALSE, ruledIndex) != NULL) break;
//	}
//	cellIndexFrom.SetColumnIndex(lColumnIndex);
//
//	// _xZkqqHx_iJlKjFpLiMpMiCpAiMjPiNpFiBeC_xHqqkZx_
//	for (lLineIndex = cellIndex.GetLineIndex(); lLineIndex != GetLineCount(); lLineIndex++)
//	{
//		// _xZkqqHx_iMjPiNpFjBmOiPnLiDfKiDiLiCmMiJlKiCmMiMhCjApMiBeC_xHqqkZx_
//		FCFrontSide ruledIndex(lLineIndex + 1, cellIndex.GetColumnIndex());
//		// _xZkqqHx_iJlKiCmMiMhCjApMiCkKiCkAiCmBiClNiCoHiMjPiNpFiCpAjCoCiOhOiBeC_xHqqkZx_
//		if (GetRuled(TRUE, ruledIndex) != NULL) break;
//	}
//	cellIndexUntil.SetLineIndex(lLineIndex);
//
//	// _xZkqqHx_iJeFjFpLiMpMiCpAiMjPiNpFiBeC_xHqqkZx_
//	for (lColumnIndex = cellIndex.GetColumnIndex(); lColumnIndex != GetColumnCount(); lColumnIndex++)
//	{
//		// _xZkqqHx_iMjPiNpFjBmOiPnLiDfKiDiLiCmMiJeFiCmMiMhCjApMiBeC_xHqqkZx_
//		FCFrontSide ruledIndex(lColumnIndex + 1, cellIndex.GetLineIndex());
//		// _xZkqqHx_iJeFiCmMiMhCjApMiCkKiCkAiCmBiClNiCoHiMjPiNpFiCpAjCoCiOhOiBeC_xHqqkZx_
//		if (GetRuled(FALSE, ruledIndex) != NULL) break;
//	}
//	cellIndexUntil.SetColumnIndex(lColumnIndex);
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const FCLineColumn cellIndexFrom = GetCellBlockFrom(cellIndex);
	const FCLineColumn cellIndexUntil = GetCellBlockUntil(cellIndex);
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	if (pCellIndexFrom != NULL)
		*pCellIndexFrom = cellIndexFrom;
	if (pCellIndexUntil != NULL)
		*pCellIndexUntil = cellIndexUntil;
	// _xZkqqHx_iDfKiDiLiDhFiDiNiDgCiDeOjAjEiCpAiMhGiOfKiBeC_xHqqkZx_
	return	(cellIndexUntil.GetLineIndex() - cellIndexFrom.GetLineIndex() + 1) *
			(cellIndexUntil.GetColumnIndex() - cellIndexFrom.GetColumnIndex() + 1);
} // FCObjTable::GetCellBlock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetCellBlockFrom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLiCkKjBkOiClHiCoJiDfKiDiLiDhFiDiNiDgCiDeOiCmMjEmNiImNiCmMiNlGiPoDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cellIndex	:_xZkqqHx_jClCiCnHiCoJjBmOiPnLiCmMiDfKiDiLiCpAiOhHjCoIiBeCiJlMjBhKiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDiLiDhFiDiNiDgCiDeOiCmMiNlGiPoDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeCiJlMjBhKiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiCkGiCmOiJlKjAhNiCmMiPoKiNiHiBeB_xHqqkZx_cellIndex = [2,2]_xZkqqHx_iBgJ_xHqqkZx_[2,3],[3,2],[3,3]_xZkqqHx_iCmFiCoAjDkPiClGiBgK_xHqqkZx_
 *			_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_[2,2]_xZkqqHx_iCkKjFnEiCoJiBeC_xHqqkZx_
 *
 *                  0              1              2              3          
 *                                                                          
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,3]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]  [0,3]   [4,0]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]  [1,3]   [4,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_             _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[2,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]          [2,2]  [2,2]                  [4,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]                 [3,3]    [4,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEjPiEjPiEjP_xHqqkZx_[4,3]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLineColumn FCObjTable::GetCellBlockFrom (const FCLineColumn& cellIndex) const
{
	FCLineColumn cellIndexFrom;
	long lLineIndex;
	long lColumnIndex;
	// _xZkqqHx_iPoDjFpLiMpMiCpAiMjPiNpFiBeC_xHqqkZx_
	for (lLineIndex = cellIndex.GetLineIndex(); lLineIndex != 0; lLineIndex--)
	{
		// _xZkqqHx_iMjPiNpFjBmOiPnLiDfKiDiLiCmMiPoDiCmMiMhCjApMiBeC_xHqqkZx_
		FCFrontSide ruledIndex(lLineIndex, cellIndex.GetColumnIndex());
		// _xZkqqHx_iPoDiCmMiMhCjApMiCkKiCkAiCmBiClNiCoHiMjPiNpFiCpAjCoCiOhOiBeC_xHqqkZx_
		if (GetRuled(TRUE, ruledIndex) != NULL) break;
	}
	cellIndexFrom.SetLineIndex(lLineIndex);

	// _xZkqqHx_iNlGjFpLiMpMiCpAiMjPiNpFiBeC_xHqqkZx_
	for (lColumnIndex = cellIndex.GetColumnIndex(); lColumnIndex != 0; lColumnIndex--)
	{
		// _xZkqqHx_iMjPiNpFjBmOiPnLiDfKiDiLiCmMiNlGiCmMiMhCjApMiBeC_xHqqkZx_
		FCFrontSide ruledIndex(lColumnIndex, cellIndex.GetLineIndex());
		// _xZkqqHx_iNlGiCmMiMhCjApMiCkKiCkAiCmBiClNiCoHiMjPiNpFiCpAjCoCiOhOiBeC_xHqqkZx_
		if (GetRuled(FALSE, ruledIndex) != NULL) break;
	}
	cellIndexFrom.SetColumnIndex(lColumnIndex);
	return cellIndexFrom;
} // FCObjTable::GetCellBlockFrom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetCellBlockUntil
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLiCkKjBkOiClHiCoJiDfKiDiLiDhFiDiNiDgCiDeOiCmMjEmNiImNiCmMiJeFiJlKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cellIndex	:_xZkqqHx_jClCiCnHiCoJjBmOiPnLiCmMiDfKiDiLiCpAiOhHjCoIiBeCiJlMjBhKiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDiLiDhFiDiNiDgCiDeOiCmMiJeFiJlKiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeCiJlMjBhKiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiCkGiCmOiJlKjAhNiCmMiPoKiNiHiBeB_xHqqkZx_cellIndex = [2,2]_xZkqqHx_iBgJ_xHqqkZx_[2,3],[3,2],[3,3]_xZkqqHx_iCmFiCoAjDkPiClGiBgK_xHqqkZx_
 *			_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_[3,3]_xZkqqHx_iCkKjFnEiCoJiBeC_xHqqkZx_
 *
 *                  0              1              2              3          
 *                                                                          
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,3]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]   [1,0]  [0,1]   [2,0]  [0,2]   [3,0]  [0,3]   [4,0]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]  [1,3]   [4,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_             _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[2,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]          [2,2]  [2,2]                  [4,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]                 [3,3]    [4,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEjPiEjPiEjP_xHqqkZx_[4,3]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLineColumn FCObjTable::GetCellBlockUntil (const FCLineColumn& cellIndex) const
{
	FCLineColumn cellIndexUntil;
	long lLineIndex;
	long lColumnIndex;
	// _xZkqqHx_iJlKjFpLiMpMiCpAiMjPiNpFiBeC_xHqqkZx_
	for (lLineIndex = cellIndex.GetLineIndex(); lLineIndex != GetLineCount(); lLineIndex++)
	{
		// _xZkqqHx_iMjPiNpFjBmOiPnLiDfKiDiLiCmMiJlKiCmMiMhCjApMiBeC_xHqqkZx_
		FCFrontSide ruledIndex(lLineIndex + 1, cellIndex.GetColumnIndex());
		// _xZkqqHx_iJlKiCmMiMhCjApMiCkKiCkAiCmBiClNiCoHiMjPiNpFiCpAjCoCiOhOiBeC_xHqqkZx_
		if (GetRuled(TRUE, ruledIndex) != NULL) break;
	}
	cellIndexUntil.SetLineIndex(lLineIndex);

	// _xZkqqHx_iJeFjFpLiMpMiCpAiMjPiNpFiBeC_xHqqkZx_
	for (lColumnIndex = cellIndex.GetColumnIndex(); lColumnIndex != GetColumnCount(); lColumnIndex++)
	{
		// _xZkqqHx_iMjPiNpFjBmOiPnLiDfKiDiLiCmMiJeFiCmMiMhCjApMiBeC_xHqqkZx_
		FCFrontSide ruledIndex(lColumnIndex + 1, cellIndex.GetLineIndex());
		// _xZkqqHx_iJeFiCmMiMhCjApMiCkKiCkAiCmBiClNiCoHiMjPiNpFiCpAjCoCiOhOiBeC_xHqqkZx_
		if (GetRuled(FALSE, ruledIndex) != NULL) break;
	}
	cellIndexUntil.SetColumnIndex(lColumnIndex);
	return cellIndexUntil;
} // FCObjTable::GetCellBlockUntil.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetFinalCellBlock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjEmNiImNiCmJiKnMiCnMiCoKiCoJiDfKiDiLiDhFiDiNiDgCiDeOiCpAiNgMjHlGiClFiCmEjEmNiImNiCpAiKgHjBoFiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iNmFiPeJjDeJiCmJiLiBiCnPiCoHiCoKiCoJjEmNiImNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cellIndexFrom	:_xZkqqHx_iNmFiPeJjEmNiImNiCmMiNlGiPoDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeCiJlMjBhKiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *			cellIndexUntil	:_xZkqqHx_iNmFiPeJjEmNiImNiCmMiJeFiJlKiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeCiJlMjBhKiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *			cellIndexFromFirst	:_xZkqqHx_jClCiCnHiCoJjBmOiPnLiCmMiDfKiDiLjEmNiImNiCmMiCkCiClIiCoKiCkJiCmMiKhAiCmM_xHqqkZx_
 *								 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *								_xZkqqHx_iOmAiDeBiDgIiDiMiDfIiBeBiJlMjBhKiDeBiDgIiDiMiDfIiCmHiClPiCoHiCmFiCoAjHmHiCkCiBeC_xHqqkZx_
 *			cellIndexUntilFirst	:cellIndexFromFirst_xZkqqHx_iCmGjBmOiKhAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *								_xZkqqHx_iOmAiDeBiDgIiDiMiDfIiBeBiJlMjBhKiDeBiDgIiDiMiDfIiCmHiClPiCoHiCmFiCoAjHmHiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKiCmMjEgKjApMjFjEjFkKiHeAiCpAjBeJjBpAiClFiClNiPoKiNiHiBeBiIoKjFjEiCmJiMiLiNiHiDfKiDiLiBgJiBkGiJeFiJlKiCmMjFjEjFkKiBgK_xHqqkZx_
 *			_xZkqqHx_iCpAiKnMiCnOiClNiCnPiBeBjBeJjBpAjEmNiImNiCmNiHeBiCmGiCmIiCoJiBeCiNfIiCmJiHeBiCmJiCoAiMiLiNiHiDfKiDiLiBkGiCkKiKnMiCnMiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_iClNiCnPjBeJjBpAjEmNiImNiCmNiHeCiCmGiKgHjBoFiClFiBeBiNmFiPeJjDeJiCmJiCmNiHeDiCmJiCmIiCoJiBeCjBkGiClPiBeB_xHqqkZx_
 *			cellIndexFromFirst	:[1,1]
 *			cellIndexUntilFirst	:[2,2]
 *			_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_
 *			cellIndexFrom		:[0,0]
 *			cellIndexUntil		:[3,3]
 *
 *			_xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkH_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkBiBgDiBgDiBgDiBgDiBgDiHeAiBgDiEkCiEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeGiEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkJiBeGiEjPiEjPiEjPiEkJiEjPiEjPiEjPiBeGiEkIiEjPiEjPiEjPiEjPiEkH_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_       _xZkqqHx_iBkG_xHqqkZx_         _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  
 *			                  _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_  
 *			                _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *			                 _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_ 
 *			                   _xZkqqHx_iBfPiBfO_xHqqkZx_   
 *			_xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBkG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkH_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkBiBgDiBgDiBgDiBgDiBgDiHeBiBgDiBgDiBgDiBgDiBgDiBgDiEkCiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkJiBeGiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiBeGiEkH_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkJiBeGiEjPiEjPiEjPiEkH_xHqqkZx_                _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkDiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  
 *			                  _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_  
 *			                _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *			                 _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_ 
 *			                   _xZkqqHx_iBfPiBfO_xHqqkZx_   
 *			_xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBkG_xHqqkZx_     _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBgDiHeCiBgDiBgDiBgDiBgDiBgDiBgDiEkCiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkGiBeGiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkJiBeGiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiBeGiEkH_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkJiBeGiEjPiEjPiEjPiEkH_xHqqkZx_                _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkDiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  
 *			                  _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_  
 *			                _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *			                 _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_ 
 *			                   _xZkqqHx_iBfPiBfO_xHqqkZx_   
 *			_xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_  
 *			_xZkqqHx_iEkAiEkBiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiHeDiBgDiBgDiBgDiBgDiBgDiBgDiEkCiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkAiBeG_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiBeGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiBeGiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiBeGiEkH_xHqqkZx_  
 *			_xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiBeGiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_                _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkAiBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeGiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkAiEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkDiEkA_xHqqkZx_  
 *			_xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  
 *
 *                  0              1              2              3          
 *                                                                          
 *          _xZkqqHx_iEkBiEjPiEjP_xHqqkZx_[0,0]_xZkqqHx_iEjPiEjPiEjPiEjPiEjP_xHqqkZx_[0,1]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,2]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[0,3]_xZkqqHx_iEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     0   [0,0]  [0,0]          [0,1]   [2,0]  [0,2]   [3,0]  [0,3]   [4,0]
 *          _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[1,0]_xZkqqHx_iEjPiEjPiEkGiEjPiEjP_xHqqkZx_[1,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[1,2]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *     1   [0,1]  [1,0]   [1,1]  [1,1]   [2,1]  [1,2]   [3,1]          [4,1]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[2,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,1]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[2,2]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[2,3]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     2   [0,2]  [2,0]   [1,2]  [2,1]   [2,2]  [2,2]                  [4,2]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_[3,0]_xZkqqHx_iEjPiEjPiEkJiEjPiEjP_xHqqkZx_[3,1]_xZkqqHx_iEjPiEjPiEkH_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *     3   [0,3]  [3,0]   [1,3]  [3,1]   [2,3]                         [4,3]
 *          _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_  
 *          _xZkqqHx_iEkEiEjPiEjP_xHqqkZx_[4,0]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,1]_xZkqqHx_iEjPiEjPiEkIiEjPiEjP_xHqqkZx_[4,2]_xZkqqHx_iEjPiEjPiEjPiEjPiEjP_xHqqkZx_[4,3]_xZkqqHx_iEjPiEjPiEkD_xHqqkZx_  
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::GetFinalCellBlock (FCLineColumn& cellIndexFrom,
									FCLineColumn& cellIndexUntil,
									const FCLineColumn& cellIndexFromFirst,
									const FCLineColumn& cellIndexUntilFirst) const
{
	long lLineMin = cellIndexFromFirst.GetLineIndex();
	long lLineMax = cellIndexUntilFirst.GetLineIndex();
	long lColumnMin = cellIndexFromFirst.GetColumnIndex();
	long lColumnMax = cellIndexUntilFirst.GetColumnIndex();
	// _xZkqqHx_iNhDiBeBjHpBiCmMjBoFiPkMiCpAjAlDiLeLiJlLiBeC_xHqqkZx_
	if (lLineMax < lLineMin) ::Exchange(lLineMax, lLineMin);
	if (lColumnMax < lColumnMin) ::Exchange(lColumnMax, lColumnMin);

	// _xZkqqHx_jBeJjBpAjEmNiImNiCmMiOpMiImNiCmMiDfKiDiLiCpAjClCiCnHiBeBiMiLiNiHiDfKiDiLiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_
	// _xZkqqHx_iClLiCmMiDfKiDiLiDhFiDiNiDgCiDeOiCmMjBfDiCmEiCpAjBeJjBpAjEmNiImNiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_

	// _xZkqqHx_jEmNiImNiCkKiKgHjBoFiClDiCoKiClNiCkJiBeI_xHqqkZx_
	BOOL bExtend = FALSE;
	do {
		long lLineIndex;
		long lColumnIndex;
		// _xZkqqHx_jEmNiImNiCkKiKgHjBoFiClDiCoKiClNiCkJiBeI_xHqqkZx_
		bExtend = FALSE;
		// _xZkqqHx_jFjNiCkKiCfAiIlNiCkCiCmNiNiCiClDiCkKiCfAiCmMjEmNiImNiCmMiPoKiNiHiCpAiNgMjHlGiClFiBeB_xHqqkZx_stAroundCell_xZkqqHx_iCmJ_xHqqkZx_
		// _xZkqqHx_iIoKjDhIiCnMiCmGiCnPiCmEiCkJiCoHjClCiCnHiCoJiBeC_xHqqkZx_
		set<FCLineColumn> stAroundCell;
		for (lColumnIndex = lColumnMin; lColumnIndex <= lColumnMax; lColumnIndex++)
		{
			stAroundCell.insert(FCLineColumn(lLineMin, lColumnIndex));
			stAroundCell.insert(FCLineColumn(lLineMax, lColumnIndex));
		}
		for (lLineIndex = lLineMin + 1; lLineIndex < lLineMax; lLineIndex++)
		{
			stAroundCell.insert(FCLineColumn(lLineIndex, lColumnMin));
			stAroundCell.insert(FCLineColumn(lLineIndex, lColumnMax));
		}
		set<FCLineColumn>::const_iterator iLc;
		for (iLc = stAroundCell.begin(); !bExtend && iLc != stAroundCell.end(); iLc++)
		{
			FCLineColumn cellBlockFrom;
			FCLineColumn cellBlockUntil;
			GetCellBlock(*iLc, &cellBlockFrom, &cellBlockUntil);
			if (cellBlockFrom.GetLineIndex() < lLineMin)
			{
				bExtend = TRUE;	// _xZkqqHx_jEmNiImNiCkKiKgHjBoFiClDiCoKiClNiCkJiBeI_xHqqkZx_
				lLineMin = cellBlockFrom.GetLineIndex();
			}
			if (lLineMax < cellBlockUntil.GetLineIndex())
			{
				bExtend = TRUE;	// _xZkqqHx_jEmNiImNiCkKiKgHjBoFiClDiCoKiClNiCkJiBeI_xHqqkZx_
				lLineMax = cellBlockUntil.GetLineIndex();
			}
			if (cellBlockFrom.GetColumnIndex() < lColumnMin)
			{
				bExtend = TRUE;	// _xZkqqHx_jEmNiImNiCkKiKgHjBoFiClDiCoKiClNiCkJiBeI_xHqqkZx_
				lColumnMin = cellBlockFrom.GetColumnIndex();
			}
			if (lColumnMax < cellBlockUntil.GetColumnIndex())
			{
				bExtend = TRUE;	// _xZkqqHx_jEmNiImNiCkKiKgHjBoFiClDiCoKiClNiCkJiBeI_xHqqkZx_
				lColumnMax = cellBlockUntil.GetColumnIndex();
			}
		}
	} while (bExtend);

	cellIndexFrom.Set(lLineMin, lColumnMin);
	cellIndexUntil.Set(lLineMax, lColumnMax);
} // FCObjTable::GetFinalCellBlock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetIncludedCell
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLjEmNiImNiCmJiKkOjBfDiCmJiKnMiCnMiCoKiCoJiDfKiDiLiCmMiCnNiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stCellIndex		:_xZkqqHx_iDfKiDiLiPfHiNiHiCpAjFnEiClHiBeCiOmAiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *			cellIndexFrom	:_xZkqqHx_jClCiCnHiCoJjBmOiPnLiCmMiDfKiDiLjEmNiImNiCmMiCkCiClIiCoKiCkJiCmMiKhAiCmM_xHqqkZx_
							 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iOmAiDeBiDgIiDiMiDfIiBeBiJlMjBhKiDeBiDgIiDiMiDfIiCmHiClPiCoHiCmFiCoAjHmHiCkCiBeC_xHqqkZx_
 *			cellIndexUntil	:cellIndexFromFirst_xZkqqHx_iCmGjBmOiKhAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iOmAiDeBiDgIiDiMiDfIiBeBiJlMjBhKiDeBiDgIiDiMiDfIiCmHiClPiCoHiCmFiCoAjHmHiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jEmNiImNiCmJiMiLiNiHiDfKiDiLiCkKiKnMiCnMiCoKiBeBiIoKjFjEiCkKiCmNiCnNiPgPiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_jBmOiPnLiCkJiCoHiPjMiKePiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::GetIncludedCell (	set<FCLineColumn>& stCellIndex,
									const FCLineColumn& cellIndexFrom,
									const FCLineColumn& cellIndexUntil) const
{
	stCellIndex.clear();
	long lLineMin = cellIndexFrom.GetLineIndex();
	long lLineMax = cellIndexUntil.GetLineIndex();
	long lColumnMin = cellIndexFrom.GetColumnIndex();
	long lColumnMax = cellIndexUntil.GetColumnIndex();
	// _xZkqqHx_iNhDiBeBjHpBiCmMjBoFiPkMiCpAjAlDiLeLiJlLiBeC_xHqqkZx_
	if (lLineMax < lLineMin) ::Exchange(lLineMax, lLineMin);
	if (lColumnMax < lColumnMin) ::Exchange(lColumnMax, lColumnMin);
	long lLineIndex;
	long lColumnIndex;
	for (lLineIndex = lLineMin; lLineIndex <= lLineMax; lLineIndex++)
	{
		for (lColumnIndex = lColumnMin; lColumnIndex <= lColumnMax; lColumnIndex++)
		{
			FCLineColumn cellIndexFrom;
			FCLineColumn cellIndexUntil;
			// _xZkqqHx_iDfKiDiLiCkKjBkOiClHiCoJiDfKiDiLiDhFiDiNiDgCiDeOiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			GetCellBlock(FCLineColumn(lLineIndex, lColumnIndex), &cellIndexFrom, &cellIndexUntil);
			// _xZkqqHx_iDfKiDiLiDhFiDiNiDgCiDeOiCkKiKkOjBfDiCmJjEmNiImNiCmJiKnMiCnMiCoKiCoJiPoKiNiHiCmNjBeJjBpAjBmOiPnLiCmJiBeC_xHqqkZx_
			if (lLineMin <= cellIndexFrom.GetLineIndex() &&
				cellIndexUntil.GetLineIndex() <= lLineMax &&
				lColumnMin <= cellIndexFrom.GetColumnIndex() &&
				cellIndexUntil.GetColumnIndex() <= lColumnMax)
				stCellIndex.insert(cellIndexFrom);
		}
	}
} // FCObjTable::GetIncludedCell.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetRealCell
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlMjBhKiDeBiDgIiDiMiDfIiCmMiDfKiDiLiPfHiNiHiCkJiCoHiBeBjBmOiJjOiClHiCoJiOmAiDeBiDgIiDiMiDfIiCmMiDfKiDiLiPfHiNiHiCpA_xHqqkZx_
 *			_xZkqqHx_iLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stRealCellIndex		:_xZkqqHx_iOmAiDeBiDgIiDiMiDfIiCmMiDfKiDiLiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			stVirtualCellIndex	:_xZkqqHx_iJlMjBhKiDeBiDgIiDiMiDfIiCmMiDfKiDiLiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiBeBiJlMjBhKiDeBiDgIiDiMiDfIiCkKiDfKiDiLiDhFiDiNiDgCiDeOiCpAiOhHiClHiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iDfKiDiLiDhFiDiNiDgCiDeOiCmMiOmAiDeBiDgIiDiMiDfIiCmJjChFiKlHiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *			stVirtualCellIndex _xZkqqHx_iCmMjCgM_xHqqkZx_
 *			_xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBkG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBkG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBkG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkH_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBkG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_             _xZkqqHx_iBkG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  
 *			                  _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_  
 *			                _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_
 *			                 _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_ 
 *			                   _xZkqqHx_iBfPiBfO_xHqqkZx_   
 *			_xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBkG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBkG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBkG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkH_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBkG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_   _xZkqqHx_iBkG_xHqqkZx_             _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEkH_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_  
 *			_xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  
 *			stRealCellIndex _xZkqqHx_iCmMjCgM_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::GetRealCell (	set<FCLineColumn>& stRealCellIndex,
								set<FCLineColumn> stVirtualCellIndex) const
{
	stRealCellIndex.clear();
	while (!stVirtualCellIndex.empty())
	{
		FCLineColumn cellIndexFrom;
		FCLineColumn cellIndexUntil;
		// _xZkqqHx_jBkOiClHiCoJiDfKiDiLiDhFiDiNiDgCiDeOiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		GetCellBlock(*stVirtualCellIndex.begin(), &cellIndexFrom, &cellIndexUntil);
		// _xZkqqHx_iDfKiDiLiDhFiDiNiDgCiDeOiCmMiNlGiPoDiClOiCkPiCpAjAnNjCoIiBeC_xHqqkZx_
		stRealCellIndex.insert(cellIndexFrom);
		// _xZkqqHx_iDfKiDiLiDhFiDiNiDgCiDeOjBfDiCmEiCpA_xHqqkZx_stVirtualCellIndex_xZkqqHx_iCkJiCoHiNoNiPjMiBeC_xHqqkZx_
		long lLineIndex;
		long lColumnIndex;
		for (lLineIndex = cellIndexFrom.GetLineIndex();
			 lLineIndex <= cellIndexUntil.GetLineIndex(); lLineIndex++)
			for (lColumnIndex = cellIndexFrom.GetColumnIndex();
				 lColumnIndex <= cellIndexUntil.GetColumnIndex(); lColumnIndex++)
				stVirtualCellIndex.erase(FCLineColumn(lLineIndex, lColumnIndex));
	}
} // FCObjTable::GetRealCell.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetCellIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLjFjEjFgJiCmMiDfKiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cellIndex	:_xZkqqHx_iDfKiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeCiOmAiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *			pCell		:_xZkqqHx_iDfKiDiLjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBmOiJjOiClHiCoJiDfKiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjTable::GetCellIndex (FCLineColumn& cellIndex, const FCObjDynabase* pCell) const
{
	long lLineIndex;
	long lColumnIndex;
	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
	{
		for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
		{
			if (GetCell(FCLineColumn(lLineIndex, lColumnIndex)) == pCell)
			{
				cellIndex.Set(lLineIndex, lColumnIndex);
				return TRUE;
			}
		}
	}
	return FALSE;
} // FCObjTable::GetCellIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::OnTableProperties
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMjFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwTitleId		:_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePiCmMiDfOiDeDiDgHiDiLiCmMiDiKiDfMiBfLiDfI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsToolInside	:_xZkqqHx_iDgDiBfLiDiLjDoAjFjEjFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeCiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stCellId		:_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiCpAjFfMiOkGiClHiCoJiDfKiDiLiCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
 *							 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			stHorzRuledId	:_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiCpAjFfMiOkGiClHiCoJjAiFjFlNiMhCjApMiCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
 *							 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			stVertRuledId	:_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiCpAjFfMiOkGiClHiCoJjAiCjClMiMhCjApMiCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
 *							 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwFrontPage		:_xZkqqHx_iCkCiClPiCmOiCpBiPoDiCmJjFfMiOkGiClHiCoJiDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *				0	_xZkqqHx_jFfM_xHqqkZx_->_xZkqqHx_iDfKiDiL_xHqqkZx_->_xZkqqHx_iMhCjApM_xHqqkZx_ _xZkqqHx_iCmMiPiHiCmFiNmFiMoDiCmJjCmHiJmBiClDiCoKiClNiDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiBeC_xHqqkZx_
 *				IDD_PRO_FIGURE_BRUSH
 *					_xZkqqHx_iDfKiDiLiCmMiDhFiDiJiDfGiDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiBeC_xHqqkZx_
 *				IDD_PRO_TABLE_TEXT
 *					_xZkqqHx_iDfKiDiLiCmMiDgFiDeMiDfIiDgHiDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiBeC_xHqqkZx_
 *				IDD_PRO_TEXT_RECT_SIZE_LIMIT
 *					_xZkqqHx_iDfKiDiLiCmMiDfEiDeDiDfJjAkHiMmAiDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiBeC_xHqqkZx_
 *				IDD_PRO_FIGURE_PEN
 *					_xZkqqHx_iMhCjApMiCmMiDhJiDjDiDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCToolTableEdit::OnObjectProperties _xZkqqHx_iCmG_xHqqkZx_
 *			FCToolTable::OnInsideObjProperty _xZkqqHx_iCmFiLkEjCmKjFjEjFkKiCkKjBlNiCkCiClNiCnPiBeBiClBiClBiCmJ_xHqqkZx_
 *			_xZkqqHx_iCnMiCmGiCnPiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::OnTableProperties (DWORD dwTitleId,
									BOOL bIsToolInside,
									FCObjTable* pTable,
									const set<FCLineColumn>* stCellId,
									const set<FCFrontSide>* stHorzRuledId,
									const set<FCFrontSide>* stVertRuledId,
									DWORD dwFrontPage)
{
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmMiPfHiNiHiBeC_xHqqkZx_
	ObjDynabaseVector vObj;
	vObj.push_back(pTable);
	CFCPrsObjProperty sheet(dwTitleId);
	CPropertyPageVector vPropPage;
	CPropertyPageVector::const_iterator iPn;
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJiDfOiBfLiDfBiDgCiDgHiCmMjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
	sheet.SetTargetObject(&vObj, bIsToolInside);
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiNoMjAkMiBeC_xHqqkZx_
	(*vObj.begin())->CreatePropertyPage(vPropPage, vObj);
	// _xZkqqHx_iDhJiBfLiDfHiCpAiDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
	for (iPn = vPropPage.begin(); iPn != vPropPage.end(); ++iPn)
		sheet.AddPage(*iPn);

	// _xZkqqHx_jFfMiCmMiMhCjApMiDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiBeC_xHqqkZx_
	CFCProObjFigurePen prpTableRuled;
	if ((stHorzRuledId != NULL && !stHorzRuledId->empty()) ||
		(stVertRuledId != NULL && !stVertRuledId->empty()))
	//----- _xZkqqHx_jFfMiCmMiMhCjApMiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		set<FCFrontSide>::const_iterator iFs;
		// _xZkqqHx_iOhHjCoIiClDiCoKiClNiMhCjApMiCpAjAnNjCoIiBeC_xHqqkZx_
		for (iFs = stHorzRuledId->begin(); iFs != stHorzRuledId->end(); iFs++)
			prpTableRuled.AppendTargetObject(pTable->GetRuled(TRUE, *iFs));
		for (iFs = stVertRuledId->begin(); iFs != stVertRuledId->end(); iFs++)
			prpTableRuled.AppendTargetObject(pTable->GetRuled(FALSE, *iFs));
		// _xZkqqHx_iNmFiMoDiCmJjFfMiMhCjApMiDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAjCmHiJmBiBeC_xHqqkZx_
		sheet.AddPage(&prpTableRuled);
		// _xZkqqHx_iDeBiDeOiDgFiDeCiDhFiCmIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
		if (dwFrontPage == CFCProObjFigurePen::IDD)
			sheet.SetActivePage(&prpTableRuled);
	}

	// _xZkqqHx_jFfMiCmMiDfKiDiLiDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiBeC_xHqqkZx_
	CFCProObjFigureBrush prpTableCell;
	CFCProTableText prpTableText;
	CFCProObjTextRectSizeLimit prpSizeLimit;
	if (stCellId != NULL && !stCellId->empty())
	//----- _xZkqqHx_jFfMiCmMiDfKiDiLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		set<FCLineColumn>::const_iterator iLc;
		// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
		for (iLc = stCellId->begin(); iLc != stCellId->end(); iLc++)
		{
			prpTableCell.AppendTargetObject(pTable->GetCell(*iLc));
			prpTableText.AppendTargetObject(pTable->GetCell(*iLc));
			prpSizeLimit.AppendTargetObject(pTable->GetCell(*iLc));
		}
		// _xZkqqHx_iNmFiMoDiCmJjFfMiDfKiDiLiDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAjCmHiJmBiBeC_xHqqkZx_
		sheet.AddPage(&prpTableCell);
		sheet.AddPage(&prpTableText);
		if (g_pReg->GetIsExpertMode())
			sheet.AddPage(&prpSizeLimit);
		// _xZkqqHx_iDeBiDeOiDgFiDeCiDhFiCmIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
		if (dwFrontPage == CFCProObjFigureBrush::IDD)
			sheet.SetActivePage(&prpTableCell);
		if (dwFrontPage == CFCProTableText::IDD)
			sheet.SetActivePage(&prpTableText);
		if (g_pReg->GetIsExpertMode() &&
			dwFrontPage == CFCProObjTextRectSizeLimit::IDD)
			sheet.SetActivePage(&prpSizeLimit);
	}
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfGiBfLiDgHiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
	sheet.DoModal();
	// _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiJpAjFpKiBeC_xHqqkZx_
	for (iPn = vPropPage.begin(); iPn != vPropPage.end(); ++iPn)
		delete *iPn;
} // FCObjTable::OnTableProperties.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::LayoutCellRuled
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNhDiNiCiBeBjHpBjFjNiPoOjFpBiCmJiNiHiCoNiClJiCmEiBeBjFjEjFgJiCpAiNmEjEhKjChFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::LayoutCellRuled ()
{
	// _xZkqqHx_jBfDiNhDiCmMiPoDiMhCjApMiBeFiJlKiMhCjApMiCmMiNmAjFfHiDfKiDgCiDgHiCpAiOfKiPgPiBeC_xHqqkZx_
	vector< pair<mmetol, mmetol> > vTopBottom;
	CalcLineTopBottomArray(vTopBottom);
	// _xZkqqHx_jBfDjHpBiCmMiNlGiMhCjApMiBeFiJeFiMhCjApMiCmMiNmAjFfHiDfKiDgCiDgHiCpAiOfKiPgPiBeC_xHqqkZx_
	vector< pair<mmetol, mmetol> > vLeftRight;
	CalcColumnLeftRightArray(vLeftRight);
	for (long lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
	{
		for (long lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
		{
			FCObjTextRect* pObjTextRect = GetCell(FCLineColumn(lLineIndex, lColumnIndex));
			// _xZkqqHx_iDfKiDiLiMiLiNiHiCmJiCoGiCmBiCmEiDfKiDiLjFjEjFgJiCkKiNoNiPjMiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (pObjTextRect == NULL) continue;
			FCLineColumn cellIndexFrom;
			FCLineColumn cellIndexUntil;
			// _xZkqqHx_iDfKiDiLiCkKjBkOiClHiCoJiDfKiDiLiDhFiDiNiDgCiDeOiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			GetCellBlock(FCLineColumn(lLineIndex, lColumnIndex), &cellIndexFrom, &cellIndexUntil);
			pObjTextRect->Resize(TRUE, TRUE,
								DBLRect(vLeftRight[cellIndexFrom.GetColumnIndex()].first,
										vTopBottom[cellIndexFrom.GetLineIndex()].first,
										vLeftRight[cellIndexUntil.GetColumnIndex()].second,
										vTopBottom[cellIndexUntil.GetLineIndex()].second),
								pObjTextRect->GetResizeFrame());
		}
	}
	mmetol mmY;
	for (long lHorzRuledIndex = 0; GetHorzRuledY(mmY, lHorzRuledIndex); lHorzRuledIndex++)
	{
		for (long lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
		{
			FCObjLine* pObjLine = GetRuled(TRUE, FCFrontSide(lHorzRuledIndex, lColumnIndex));
			// _xZkqqHx_iDfKiDiLiMiLiNiHiCmJiCoGiCmBiCmEiMhCjApMjFjEjFgJiCkKiNoNiPjMiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (pObjLine == NULL) continue;
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			pObjLine->Resize(TRUE, TRUE,
//							DBLRect(vLeftRight[lColumnIndex].first,
//									mmY,
//									vLeftRight[lColumnIndex].second,
//									mmY),
//							pObjLine->GetResizeFrame());
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			pObjLine->SetFromEndX(vLeftRight[lColumnIndex].first);
			pObjLine->SetFromEndY(mmY);
			pObjLine->SetToEndX(vLeftRight[lColumnIndex].second);
			pObjLine->SetToEndY(mmY);
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	mmetol mmX;
	for (long lVertRuledIndex = 0; GetVertRuledX(mmX, lVertRuledIndex); lVertRuledIndex++)
	{
		for (long lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
		{
			FCObjLine* pObjLine = GetRuled(FALSE, FCFrontSide(lVertRuledIndex, lLineIndex));
			// _xZkqqHx_iDfKiDiLiMiLiNiHiCmJiCoGiCmBiCmEiMhCjApMjFjEjFgJiCkKiNoNiPjMiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (pObjLine == NULL) continue;
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			pObjLine->Resize(TRUE, TRUE,
//							DBLRect(mmX,
//									vTopBottom[lLineIndex].first,
//									mmX,
//									vTopBottom[lLineIndex].second),
//							pObjLine->GetResizeFrame());
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			pObjLine->SetFromEndX(mmX);
			pObjLine->SetFromEndY(vTopBottom[lLineIndex].first);
			pObjLine->SetToEndX(mmX);
			pObjLine->SetToEndY(vTopBottom[lLineIndex].second);
//----- 05.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
} // FCObjTable::LayoutCellRuled.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::MemberArrayToObjArray
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiDeDiDjDiDgGiDgCiDeOiDfIjEhKjHpBiCkJiCoHiBeBjFjEjFgJjEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vvObj			:_xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiDeDiDjDiDgGiDgCiDeOiDfIjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vvMemberIndex	:_xZkqqHx_jFjEjFgJjEhKjHpBiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::MemberArrayToObjArray (vector<ObjDynabaseVector>& vvObj, const vector<longVector>& vvMemberIndex) const
{
	vvObj.clear();
	vector<longVector>::const_iterator iiIdx;
	for (iiIdx = vvMemberIndex.begin(); iiIdx != vvMemberIndex.end(); iiIdx++)
	{
		vvObj.push_back(ObjDynabaseVector());
		longVector::const_iterator iIdx;
		for (iIdx = (*iiIdx).begin(); iIdx != (*iiIdx).end(); iIdx++)
		{
			if (*iIdx != -1)
				vvObj.back().push_back(GetMember(*iIdx));
			else
				vvObj.back().push_back(NULL);
		}
	}
} // FCObjTable::MemberArrayToObjArray.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::ObjArrayToMemberArray
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJjEhKjHpBiCkJiCoHiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiDeDiDjDiDgGiDgCiDeOiDfIjEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vvMemberIndex	:_xZkqqHx_jFjEjFgJjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			vvObj			:_xZkqqHx_iDePiDiLiBfLiDhGiDiBiDjDiDgPiBfLiDeDiDjDiDgGiDgCiDeOiDfIjEhKjHpBiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::ObjArrayToMemberArray (vector<longVector>& vvMemberIndex, const vector<ObjDynabaseVector>& vvObj) const
{
	vvMemberIndex.clear();
	map<const FCObjDynabase*, long> mpObjToIndex;
	GetObjToIndexTable(mpObjToIndex);
	vector<ObjDynabaseVector>::const_iterator iiObj;
	for (iiObj = vvObj.begin(); iiObj != vvObj.end(); iiObj++)
	{
		vvMemberIndex.push_back(longVector());
		ObjDynabaseVector::const_iterator iObj;
		for (iObj = (*iiObj).begin(); iObj != (*iiObj).end(); iObj++)
			vvMemberIndex.back().push_back(mpObjToIndex[*iObj]);
	}
} // FCObjTable::ObjArrayToMemberArray.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetCellWidthMin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLiCkKiOoGiCoJiOjGiCkKiCmFiCkLiCoJiBeBiNmFiPkMiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cellIndex	:_xZkqqHx_iDfKiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeCiOmAiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCpAjClCiCnHiBeBiDgFiDeMiDfIiDgHiCkKjAoIiCnPiCoJjHmMiIoGiCmGiDhNiBfLiDfHiDjDiCkJiCoHiNmFiPkMiCmM_xHqqkZx_
 *			_xZkqqHx_jFjNiCpAiMhGiOfKiBeC_xHqqkZx_
//----- 05.08.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
// *			_xZkqqHx_iDgFiDeMiDfIiDgHiCkKiDhEiDiMiBfLiDiAiCpAiCkAiCnDiCoKiCmEiCkCiCmEiCoAiBeBiMlLiNnNiCmMiDfKiDiLiCmM_xHqqkZx_
// *			_xZkqqHx_jFjNiCpAiPoDiJpBiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
//----- 05.08.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjTable::GetCellWidthMin (const FCLineColumn& cellIndex) const
{
	mmetol mmWidth = FD_OBJ_TABLE_MIN_CELL_WIDTH;
	const FCObjTextRect* pCell = GetCell(cellIndex);
	// _xZkqqHx_jBmOiJjOiClHiCoJiDfKiDiLiCkKjGlDiCkCiPoKiNiHiCmNiNmFiPkMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
	if (pCell == NULL) return mmWidth;
	const FCRichText* pText = pCell->GetRichText();
	if (pText != NULL)
	//----- _xZkqqHx_iDfKiDiLiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (almosteq(pText->GetAngle(), 0.5) || almosteq(pText->GetAngle(), 1.5))
		//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCkKiJkBiMpMiCkLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			mmetol mmTop;
			mmetol mmBottom;
			pText->GetTextTopBottom(mmTop, mmBottom);
			// _xZkqqHx_iDgFiDeMiDfIiDgHiClPiCoFiCkEiCmHiCmMiNiCiClDiCmJiCoEiCmGiCoIiCpAjBkLiClFiClNjCgMiBeC_xHqqkZx_
			// _xZkqqHx_iCkLiCmBiClPiCoIiCmMiNiCiClDiCmJiDiKiDfEiDeDiDfJiClHiCoJiCmGiBeBiNmEiDiMiDeDiDeBiDeFiDgHiCmFiDgFiDeMiDfIiDgHiCkKjDpMiCoHiCmIiCkNiCmIiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
			mmWidth = mmBottom - mmTop + pText->GetMarginT() + pText->GetMarginB() + s_mmAutoTextVertSpace;
		} else
		//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCkKiPgDiMpMiCkLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			mmetol mmLeft;
			mmetol mmRight;
			pText->GetTextLeftRight(mmLeft, mmRight);
			// _xZkqqHx_iDgFiDeMiDfIiDgHiClPiCoFiCkEiCmHiCmMjFjNiCmJiCoEiCmGiCoIiCpAjBkLiClFiClNjCgMiBeC_xHqqkZx_
			// _xZkqqHx_iCkLiCmBiClPiCoIiCmMjFjNiCmJiDiKiDfEiDeDiDfJiClHiCoJiCmGiBeBiNmEiDiMiDeDiDeBiDeFiDgHiCmFiDgFiDeMiDfIiDgHiCkKjDpMiCoHiCmIiCkNiCmIiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
			mmWidth = mmRight - mmLeft + pText->GetMarginL() + pText->GetMarginR() + s_mmAutoTextHorzSpace;
		}
	}
//----- 05.08.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (mmWidth < pCell->GetResizeFrame().Width())
//		return mmWidth;
//	else
//		return pCell->GetResizeFrame().Width();
//----- 05.08.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return mmWidth;
//----- 05.08.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjTable::GetCellWidthMin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::GetCellHeightMin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDiLiCkKiOoGiCoJiOjGiCkKiCmFiCkLiCoJiBeBiNmFiPkMiCmMiNiCiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cellIndex	:_xZkqqHx_iDfKiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeCiOmAiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNiCiClDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCpAjClCiCnHiBeBiDgFiDeMiDfIiDgHiCkKjAoIiCnPiCoJjHmMiIoGiCmGiDhNiBfLiDfHiDjDiCkJiCoHiNmFiPkMiCmM_xHqqkZx_
 *			_xZkqqHx_iNiCiClDiCpAiMhGiOfKiBeC_xHqqkZx_
//----- 05.08.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
// *			_xZkqqHx_iDgFiDeMiDfIiDgHiCkKiDhEiDiMiBfLiDiAiCpAiCkAiCnDiCoKiCmEiCkCiCmEiCoAiBeBiMlLiNnNiCmMiDfKiDiLiCmM_xHqqkZx_
// *			_xZkqqHx_iNiCiClDiCpAiPoDiJpBiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
//----- 05.08.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjTable::GetCellHeightMin (const FCLineColumn& cellIndex) const
{
	mmetol mmHeight = FD_OBJ_TABLE_MIN_CELL_HEIGHT;
	const FCObjTextRect* pCell = GetCell(cellIndex);
	// _xZkqqHx_jBmOiJjOiClHiCoJiDfKiDiLiCkKjGlDiCkCiPoKiNiHiCmNiNmFiPkMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
	if (pCell == NULL) return mmHeight;
	const FCRichText* pText = pCell->GetRichText();
	if (pText != NULL)
	//----- _xZkqqHx_iDfKiDiLiCmJiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (almosteq(pText->GetAngle(), 0.5) || almosteq(pText->GetAngle(), 1.5))
		//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCkKiJkBiMpMiCkLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			mmetol mmLeft;
			mmetol mmRight;
			pText->GetTextLeftRight(mmLeft, mmRight);
			// _xZkqqHx_iDgFiDeMiDfIiDgHiClPiCoFiCkEiCmHiCmMjFjNiCmJiCoEiCmGiCoIiCpAjBkLiClFiClNjCgMiBeC_xHqqkZx_
			// _xZkqqHx_iCkLiCmBiClPiCoIiCmMjFjNiCmJiDiKiDfEiDeDiDfJiClHiCoJiCmGiBeBiNmEiDiMiDeDiDeBiDeFiDgHiCmFiDgFiDeMiDfIiDgHiCkKjDpMiCoHiCmIiCkNiCmIiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
			mmHeight = mmRight - mmLeft + pText->GetMarginL() + pText->GetMarginR() + s_mmAutoTextHorzSpace;
		} else
		//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCkKiPgDiMpMiCkLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			mmetol mmTop;
			mmetol mmBottom;
			pText->GetTextTopBottom(mmTop, mmBottom);
			// _xZkqqHx_iDgFiDeMiDfIiDgHiClPiCoFiCkEiCmHiCmMiNiCiClDiCmJiCoEiCmGiCoIiCpAjBkLiClFiClNjCgMiBeC_xHqqkZx_
			// _xZkqqHx_iCkLiCmBiClPiCoIiCmMiNiCiClDiCmJiDiKiDfEiDeDiDfJiClHiCoJiCmGiBeBiNmEiDiMiDeDiDeBiDeFiDgHiCmFiDgFiDeMiDfIiDgHiCkKjDpMiCoHiCmIiCkNiCmIiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
			mmHeight = mmBottom - mmTop + pText->GetMarginT() + pText->GetMarginB() + s_mmAutoTextVertSpace;
		}
	}
//----- 05.08.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (mmHeight < pCell->GetResizeFrame().Height())
//		return mmHeight;
//	else
//		return pCell->GetResizeFrame().Height();
//----- 05.08.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return mmHeight;
//----- 05.08.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjTable::GetCellHeightMin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::CalcNewColumnWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjNiCmJjFfMiCpAjFmPiNfIiClFiClNiPoKiNiHiCmMiBeBiKgFjHpBiCmMjAfGiClFiCkCjFjNiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vNewColumnWidth	:_xZkqqHx_jAfGiClFiCkCjHpBjFjNiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmNewWidth		:_xZkqqHx_jFmPiNfIiClHiCoJjFfMjFjEjFgJiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
//----- 05.06.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
//----- 05.06.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iNiCiClDiCgLiCmMjFfMjFjEjFgJiCpAiBeBiNiCiClDiCgMiCmJiDiKiDfEiDeDiDfJiClHiCoJiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkCiEjPiEkGiEjPiEjPiEjPiEkG_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkKiCgA_xHqqkZx_    _xZkqqHx_iBkK_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkHiEjPiEkJ_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkKiCgB_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkHiEjPiEkJ_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkK_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiCgC_xHqqkZx_    _xZkqqHx_iEkAiCgL_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkHiEjPiEkJ_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkKiCgD_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkHiEjPiEkJ_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkKiCgE_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEjPiEkIiEjPiEjPiEjPiEkI_xHqqkZx_
 *
 *           _xZkqqHx_iCgLiBiBiCgAiBhLiCgBiBhLiCgCiBhLiCgDiBhLiCgE_xHqqkZx_
 *           _xZkqqHx_iCgLiBkIiCgMiBgJiCgLiBiDiCgMiBgK_xHqqkZx_
 *           _xZkqqHx_iCgA_xHqqkZx_m <= _xZkqqHx_iCgA_xHqqkZx_ <= _xZkqqHx_iCgA_xHqqkZx_n
 *           _xZkqqHx_iCgB_xHqqkZx_m <= _xZkqqHx_iCgB_xHqqkZx_ <= _xZkqqHx_iCgB_xHqqkZx_n
 *           _xZkqqHx_iCgC_xHqqkZx_m <= _xZkqqHx_iCgC_xHqqkZx_ <= _xZkqqHx_iCgC_xHqqkZx_n
 *           _xZkqqHx_iCgD_xHqqkZx_m <= _xZkqqHx_iCgD_xHqqkZx_ <= _xZkqqHx_iCgD_xHqqkZx_n
 *           _xZkqqHx_iCgE_xHqqkZx_m <= _xZkqqHx_iCgE_xHqqkZx_ <= _xZkqqHx_iCgE_xHqqkZx_n
 *           _xZkqqHx_iCfAiBeEiCgMiBiB_xHqqkZx_(_xZkqqHx_iCgAiBhLiCgBiBhLiCgCiBhLiCgDiBhLiCgE_xHqqkZx_)_xZkqqHx_iBhOiCjC_xHqqkZx_1_xZkqqHx_iCmGiClHiCoJiBeCiCjC_xHqqkZx_1_xZkqqHx_iCpAiOfKiPgPiClFiBeBiCgA_xHqqkZx_1_xZkqqHx_iBiBiCgAiBhOiCjC_xHqqkZx_1_xZkqqHx_iBeBiCgB_xHqqkZx_1_xZkqqHx_iBiBiCgBiBhOiCjC_xHqqkZx_1_xZkqqHx_iBeBiBeFiBeFiBeF_xHqqkZx_
 *           _xZkqqHx_iBeAiBeAiCkJiCoHiCgA_xHqqkZx_1_xZkqqHx_iBeBiCgB_xHqqkZx_1_xZkqqHx_iBeBiCgC_xHqqkZx_1_xZkqqHx_iBeBiCgD_xHqqkZx_1_xZkqqHx_iBeBiCgE_xHqqkZx_1_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
 *           _xZkqqHx_iCfBiBeEiCgB_xHqqkZx_1_xZkqqHx_iCkKiPoDiMmAjCgM_xHqqkZx_ _xZkqqHx_iCgB_xHqqkZx_n_xZkqqHx_iCpAjClEiCkGiCmEiCkCiCoJiCmGiClHiCoJiBeCiClBiCmMiPoKiNiHiBeB_xHqqkZx_
 *           _xZkqqHx_iBeAiBeAiCgMiBiBiCgB_xHqqkZx_n_xZkqqHx_iBhL_xHqqkZx_(_xZkqqHx_iCgAiBhLiCgCiBhLiCgDiBhLiCgE_xHqqkZx_)_xZkqqHx_iBhOiCjC_xHqqkZx_2
 *           _xZkqqHx_iBeAiBeAiCjC_xHqqkZx_2_xZkqqHx_iBiB_xHqqkZx_(_xZkqqHx_iCgMiBhMiCgB_xHqqkZx_n)_xZkqqHx_iBfO_xHqqkZx_(_xZkqqHx_iCgAiBhLiCgCiBhLiCgDiBhLiCgE_xHqqkZx_)
 *           _xZkqqHx_iBeAiBeAiCgA_xHqqkZx_2_xZkqqHx_iBiBiCgAiBhOiCjC_xHqqkZx_2_xZkqqHx_iBeBiCgC_xHqqkZx_2_xZkqqHx_iBiBiCgCiBhOiCjC_xHqqkZx_2_xZkqqHx_iBeBiBeFiBeFiBeFiCkJiCoHiCgA_xHqqkZx_2_xZkqqHx_iBeBiCgC_xHqqkZx_2_xZkqqHx_iBeBiCgD_xHqqkZx_2_xZkqqHx_iBeBiCgE_xHqqkZx_2_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
 *           _xZkqqHx_iCfCiBeEiCgD_xHqqkZx_2_xZkqqHx_iBeBiCgE_xHqqkZx_2_xZkqqHx_iCkKiPoDiMmAjCgM_xHqqkZx_ _xZkqqHx_iCgD_xHqqkZx_n_xZkqqHx_iBeBiCgE_xHqqkZx_n_xZkqqHx_iCpAjClEiCkGiCmEiCkCiCoJiCmGiClHiCoJiBeCiClBiCmMiPoKiNiHiBeB_xHqqkZx_
 *           _xZkqqHx_iBeAiBeAiCgMiBiBiCgB_xHqqkZx_n_xZkqqHx_iBhLiCgD_xHqqkZx_n_xZkqqHx_iBhLiCgE_xHqqkZx_n_xZkqqHx_iBhL_xHqqkZx_(_xZkqqHx_iCgAiBhLiCgC_xHqqkZx_)_xZkqqHx_iBhOiCjC_xHqqkZx_3
 *           _xZkqqHx_iBeAiBeAiCjC_xHqqkZx_3_xZkqqHx_iBiB_xHqqkZx_(_xZkqqHx_iCgMiBhMiCgB_xHqqkZx_n_xZkqqHx_iBhMiCgD_xHqqkZx_n_xZkqqHx_iBhMiCgE_xHqqkZx_n)_xZkqqHx_iBfO_xHqqkZx_(_xZkqqHx_iCgAiBhLiCgC_xHqqkZx_)
 *           _xZkqqHx_iBeAiBeAiCgA_xHqqkZx_3_xZkqqHx_iBiBiCgAiBhOiCjC_xHqqkZx_3_xZkqqHx_iBeBiCgC_xHqqkZx_3_xZkqqHx_iBiBiCgCiBhOiCjC_xHqqkZx_3 _xZkqqHx_iCkJiCoHiCgA_xHqqkZx_3_xZkqqHx_iBeBiCgC_xHqqkZx_3_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
 *           _xZkqqHx_iCfDiBeEiCfAiBgAiCfCiCmMiMeKiCoIjFnEiClFiCmFiBeBiCgAiBeBiCgBiBeBiCgCiBeBiCgDiBeBiCgEiCmMiNmFiPeJjDeJiCmIjCgMiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 05.06.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//BOOL FCObjTable::CalcNewColumnWidth (mmetolVector& vNewColumnWidth, mmetol mmNewWidth) const
void FCObjTable::CalcNewColumnWidth (mmetolVector& vNewColumnWidth, mmetol mmNewWidth) const
{
	// _xZkqqHx_iCnMiClIiBeBjHpBjFjNiCmMiNmFiPkMjCgMiBeBiNmFjBoFjCgMiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	mmetolVector vColumnMin;
	mmetolVector vColumnMax;
	long lColumnIndex;
	for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
	{
		mmetol mmMin, mmMax;
		// _xZkqqHx_jHpBjFjNiCmMiNmFiPkMjCgMiBeBiNmFjBoFjCgMiCpAiOoGjDlOiBeC_xHqqkZx_
		CalcColumnMinMax(mmMin, mmMax, lColumnIndex);
		vColumnMin.push_back(mmMin);
		vColumnMax.push_back(mmMax);
	}

//----- 05.06.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMjHpBjFjNiCkKiNmFiPkMjCgMiBeFiNmFjBoFjCgMiCpAjClEiCkGiCmEiCkCiCoJiPoKiNiHiCoAiCkAiCoIjDlOiCoJiBgJiNmFiPkMjCgMiBeFiNmFjBoFjCgMjFmPiNfIjClMiMoDiCmIiCmHiBgK_xHqqkZx_
//	// _xZkqqHx_iCmMiCmFiBeBiNmFiPkMjCgMiBeFiNmFjBoFjCgMiCmFjFoCjAlDiClFiClNiMlLiNnNiCmMjHpBjFjNiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
//	mmetol mmCurrentWidth = 0.0;
//	mmetolVector vCurrentColumnWidth;
//	for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
//	{
//		mmetol mmWidth = GetColumnWidth(lColumnIndex);
//		if (mmWidth < vColumnMin[lColumnIndex])
//			mmWidth = vColumnMin[lColumnIndex];
//		else
//		if (vColumnMax[lColumnIndex] < mmWidth)
//			mmWidth = vColumnMax[lColumnIndex];
//		mmCurrentWidth += mmWidth;
//		vCurrentColumnWidth.push_back(mmWidth);
//	}
//----- 05.06.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// mpLimitIndexToWidth _xZkqqHx_iCmNiBeBiNmFiPkMiNmFjBoFjCgMiCpAjClEiCkGiClNjHpBiBeB_xHqqkZx_stUnlimitIndex_xZkqqHx_iCmNiNmFiPkMiNmFjBoFjCgMiCpA_xHqqkZx_
	// _xZkqqHx_jClEiCkGiCmEiCkCiCmIiCkCjHpBiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	// _xZkqqHx_iJpAjAoAiCmMjHoB_xHqqkZx_ _xZkqqHx_iCfCiBeEiCmJiCkIiCkCiCmEiCmNiBeB_xHqqkZx_mpLimitIndexToWidth=(B,D,E)_xZkqqHx_iBeB_xHqqkZx_stUnlimitIndex=(A,C)
	map<long, mmetol> mpLimitIndexToWidth;
	set<long> stUnlimitIndex;
	for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
		stUnlimitIndex.insert(lColumnIndex);
	// mmLimit _xZkqqHx_iCmNiBeBiNmFjBoFiNmFiPkMjCgMiCpAjClEiCkGiClNjHpBjFjNiCmMjIgBiBeB_xHqqkZx_mmUnlimit_xZkqqHx_iCmNjClEiCkGiCmEiCkCiCmIiCkCjHpBjFjNiCmMjIgBiBeC_xHqqkZx_
	// _xZkqqHx_iJpAjAoAiCmMjHoB_xHqqkZx_ _xZkqqHx_iCfCiBeEiCmJiCkIiCkCiCmEiCmNiBeB_xHqqkZx_mmLimit=(Bn+Dn+En)_xZkqqHx_iBeB_xHqqkZx_mmUnlimit=(A+C)
	mmetol mmLimit = 0.0;
// 05.06.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	mmetol mmUnlimit = mmCurrentWidth;
	mmetol mmUnlimit = GetResizeFrame().Width();
	double dR;
	for (;;)
	{
		BOOL bUnchanged = TRUE;
		// _xZkqqHx_iCjCiCpAiMhGiOfKiBeC_xHqqkZx_
		dR = (mmNewWidth - mmLimit) / mmUnlimit;
		set<long>::iterator iId;
		for (iId = stUnlimitIndex.begin(); iId != stUnlimitIndex.end();)
		//----- _xZkqqHx_iNmFjBoFiBeFiNmFiPkMjCgMiCpAjClEiCkGiCmEiCkCiCmIiCkCjHpBiCmJiKnGiClFiCmE_xHqqkZx_ -----
		{
			// _xZkqqHx_jAfGiClFiCkCjHpBjFjNiCpAiMhGiOfKiBeC_xHqqkZx_
			mmetol mmWidth = GetColumnWidth(*iId) * dR;
			// _xZkqqHx_jAfGiClFiCkCjHpBjFjNiCkKiBeBiClLiCmMjFjNiCmMjAkHiMmAiCpAiJhKiCkGiClNiPoKiNiHiCmNiBeB_xHqqkZx_stUnlimitIndex_xZkqqHx_iCkJiCoH_xHqqkZx_
			// mpLimitIndexToWidth_xZkqqHx_iCnG_xHqqkZx_ _xZkqqHx_iClLiCmMjHpBiDeDiDjDiDgGiDgCiDeOiDfIiCpAiInKiClHiBeC_xHqqkZx_
			BOOL bOverLimit = FALSE;
			if (mmWidth < vColumnMin[*iId])
			{
				mmWidth = vColumnMin[*iId];
				bOverLimit = TRUE;
			} else
			if (vColumnMax[*iId] < mmWidth)
			{
				mmWidth = vColumnMax[*iId];
				bOverLimit = TRUE;
			}
//			if (mmWidth < FD_OBJ_TABLE_MIN_CELL_WIDTH) return FALSE;
			if (bOverLimit)
			//----- _xZkqqHx_jAfGiClFiCkCjHpBjFjNiCkKiBeBiClLiCmMjFjNiCmMjAkHiMmAiCpAiJhKiCkGiClNiPoKiNiH_xHqqkZx_ -----
			{
				// stUnlimitIndex_xZkqqHx_iCkJiCoH_xHqqkZx_mpLimitIndexToWidth_xZkqqHx_iCnG_xHqqkZx_ _xZkqqHx_jHpBiDeDiDjDiDgGiDgCiDeOiDfIiCpAiInKiClHiBeC_xHqqkZx_
				bUnchanged = FALSE;
				mpLimitIndexToWidth[*iId] = mmWidth;
				// mmLimit_xZkqqHx_iBeB_xHqqkZx_mmUnlimit _xZkqqHx_iCpAjFoCjAlDiClHiCoJiBeC_xHqqkZx_
				mmLimit += mmWidth;
				mmUnlimit -= GetColumnWidth(*iId);
				iId = stUnlimitIndex.erase(iId);
			} else
			{
				iId++;
			}
		}
		// _xZkqqHx_iIoKiCmCiCoAjHpBjFjNjAkHiMmAjCgMiCpAjClEiCkGiCmIiCkJiCmBiClNiPoKiNiHiCmNiBeBiCjCiCmNjAlDiClFiCkCjCgMiCmIiCmMiCmFiDiLiBfLiDhGiCpAiPeJjHlJiBeC_xHqqkZx_
		if (bUnchanged) break;
//----- 05.06.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_jBfDiCmEiCmMjHpBiCkKjAkHiMmAjCgMiCpAjClEiCkGiCmEiClFiCnMiCmBiClNiPoKiNiHiCmNiBeBjAfGiClFiCkCjFjNiCmJiDiKiDfEiDeDiDfJiCmNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
//		if (stUnlimitIndex.empty()) return FALSE;
//----- 05.06.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_jBfDiCmEiCmMjHpBiCkKjAkHiMmAjCgMiCpAjClEiCkGiCmEiClFiCnMiCmBiClNiPoKiNiHiCmNiBeBjAfGiClFiCkCjFjNiCmJiDiKiDfEiDeDiDfJiCmNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
		if (stUnlimitIndex.empty()) break;
//----- 05.06.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	if (stUnlimitIndex.empty())
	//----- _xZkqqHx_jBfDiCmEiCmMjHpBiCkKjAkHiMmAjCgMiCpAjClEiCkGiCmEiClFiCnMiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iCkAiCkLiCoHiCnPiCmEiBeBjAkHiMmAjCgMiCmJiCnAiCmBiCkJiCkJiCmBiClNjHpBiCpAiLmPjDjJiCmJiDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iCjCiCpAiMhGiOfKiBeC_xHqqkZx_
		dR = mmNewWidth / mmLimit;
		// _xZkqqHx_jAfGiClFiCkCjHpBjFjNiCpAjAnNjCoIiBeC_xHqqkZx_
		vNewColumnWidth.assign(GetColumnCount(), 0.0);
		map<long, mmetol>::const_iterator iLm;
		for (iLm = mpLimitIndexToWidth.begin(); iLm != mpLimitIndexToWidth.end(); iLm++)
			vNewColumnWidth[(*iLm).first] = (*iLm).second * dR;
	} else
	//----- _xZkqqHx_jAkHiMmAjCgMiCpAjClEiCkGiCmIiCkCjHpBiCkKiOgDiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAfGiClFiCkCjHpBjFjNiCpAjAnNjCoIiBeC_xHqqkZx_
		vNewColumnWidth.assign(GetColumnCount(), 0.0);
		map<long, mmetol>::const_iterator iLm;
		for (iLm = mpLimitIndexToWidth.begin(); iLm != mpLimitIndexToWidth.end(); iLm++)
			vNewColumnWidth[(*iLm).first] = (*iLm).second;
		set<long>::const_iterator iId;
		for (iId = stUnlimitIndex.begin(); iId != stUnlimitIndex.end(); iId++)
			vNewColumnWidth[*iId] = GetColumnWidth(*iId) * dR;
	}
// 05.06.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	return TRUE;
} // FCObjTable::CalcNewColumnWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::CalcColumnMinMax
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHpBiCmMiNmFiPkMjFjNiCmGiNmFjBoFjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmMin	:_xZkqqHx_iNmFiPkMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmMax	:_xZkqqHx_iNmFjBoFjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *			lColumnIndex	:_xZkqqHx_jHpBiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHpBiCmMiDfKiDiLiCpAjBfDiCmEjClCiCnHiBeBiNmFiPkMjFjNiBeFiNmFjBoFjFjNiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNiBeBiClLiCmMjCgMiCmMjFjNiCkKiNmFiCoAiNeMiCkNiCmIiCoJiCoGiCkEiBeBiNmFiPkMjFjNiBeFiNmFjBoFjFjNiCpAiPfHiMhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::CalcColumnMinMax (mmetol& mmMin, mmetol& mmMax, long lColumnIndex) const
{
	mmMin = DBL_MAX;
	mmMax = -DBL_MAX;
	long lLineIndex;
	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
	{
		// _xZkqqHx_iClLiCmMjHpBiBeFiNhDiCmMiDfKiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNjClCiCnHiCmIiCkNiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
		// _xZkqqHx_jHpBiCmMjBfDiCmEiCmMiDfKiDiLiCkKjBlGiNnNiClFiCmIiCkNiCmEiCoAiBeBiKnGjAjEiNmFiMoDiCmFiNmFiPkMjCgMiBeFiNmFjBoFjCgMiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		if (GetCell(FCLineColumn(lLineIndex, lColumnIndex)) != NULL)
		//----- _xZkqqHx_iDfKiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ ----
		{
			// _xZkqqHx_iDfKiDiLiCmMiNmFiPkMjFjNiBeBiNmFjBoFjFjNiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiClLiCmMjCgMiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
			if (GetCell(FCLineColumn(lLineIndex, lColumnIndex))->GetMinWidth() < mmMin)
				mmMin = GetCell(FCLineColumn(lLineIndex, lColumnIndex))->GetMinWidth();
			if (mmMax < GetCell(FCLineColumn(lLineIndex, lColumnIndex))->GetMaxWidth())
				mmMax = GetCell(FCLineColumn(lLineIndex, lColumnIndex))->GetMaxWidth();
		}
	}
	// _xZkqqHx_iNmFiPkMjFjNiBeBiNmFjBoFjFjNiCkKjAnNjCoIiClDiCoKiCmIiCkJiCmBiClNiPoKiNiHiCmNiBeBiDgGiDhEiDeIiDiLiDgHjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	if (mmMin == DBL_MAX)
		mmMin = FD_OBJ_TABLE_MIN_CELL_WIDTH;
	if (mmMax == -DBL_MAX)
		mmMax = DBL_MAX;
} // FCObjTable::CalcColumnMinMax.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::CalcNewLineHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNiCiClDiCmJjFfMiCpAjFmPiNfIiClFiClNiPoKiNiHiCmMiBeBiKgFiNhDiCmMjAfGiClFiCkCiNiCiClDiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vNewLineHeight	:_xZkqqHx_jAfGiClFiCkCiNhDiNiCiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmNewHeight		:_xZkqqHx_jFmPiNfIiClHiCoJjFfMjFjEjFgJiCmMiNiCiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
//----- 05.06.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
//----- 05.06.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iNiCiClDiCgLiCmMjFfMjFjEjFgJiCpAiBeBiNiCiClDiCgMiCmJiDiKiDfEiDeDiDfJiClHiCoJiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkCiEjPiEkGiEjPiEjPiEjPiEkG_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkKiCgA_xHqqkZx_    _xZkqqHx_iBkK_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkHiEjPiEkJ_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkKiCgB_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkHiEjPiEkJ_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkK_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiCgC_xHqqkZx_    _xZkqqHx_iEkAiCgL_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkHiEjPiEkJ_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkKiCgD_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkHiEjPiEkJ_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkKiCgE_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEjPiEkIiEjPiEjPiEjPiEkI_xHqqkZx_
 *
 *           _xZkqqHx_iCgLiBiBiCgAiBhLiCgBiBhLiCgCiBhLiCgDiBhLiCgE_xHqqkZx_
 *           _xZkqqHx_iCgLiBkIiCgMiBgJiCgLiBiDiCgMiBgK_xHqqkZx_
 *           _xZkqqHx_iCgA_xHqqkZx_m <= _xZkqqHx_iCgA_xHqqkZx_ <= _xZkqqHx_iCgA_xHqqkZx_n
 *           _xZkqqHx_iCgB_xHqqkZx_m <= _xZkqqHx_iCgB_xHqqkZx_ <= _xZkqqHx_iCgB_xHqqkZx_n
 *           _xZkqqHx_iCgC_xHqqkZx_m <= _xZkqqHx_iCgC_xHqqkZx_ <= _xZkqqHx_iCgC_xHqqkZx_n
 *           _xZkqqHx_iCgD_xHqqkZx_m <= _xZkqqHx_iCgD_xHqqkZx_ <= _xZkqqHx_iCgD_xHqqkZx_n
 *           _xZkqqHx_iCgE_xHqqkZx_m <= _xZkqqHx_iCgE_xHqqkZx_ <= _xZkqqHx_iCgE_xHqqkZx_n
 *           _xZkqqHx_iCfAiBeEiCgMiBiB_xHqqkZx_(_xZkqqHx_iCgAiBhLiCgBiBhLiCgCiBhLiCgDiBhLiCgE_xHqqkZx_)_xZkqqHx_iBhOiCjC_xHqqkZx_1_xZkqqHx_iCmGiClHiCoJiBeCiCjC_xHqqkZx_1_xZkqqHx_iCpAiOfKiPgPiClFiBeBiCgA_xHqqkZx_1_xZkqqHx_iBiBiCgAiBhOiCjC_xHqqkZx_1_xZkqqHx_iBeBiCgB_xHqqkZx_1_xZkqqHx_iBiBiCgBiBhOiCjC_xHqqkZx_1_xZkqqHx_iBeBiBeFiBeFiBeF_xHqqkZx_
 *           _xZkqqHx_iBeAiBeAiCkJiCoHiCgA_xHqqkZx_1_xZkqqHx_iBeBiCgB_xHqqkZx_1_xZkqqHx_iBeBiCgC_xHqqkZx_1_xZkqqHx_iBeBiCgD_xHqqkZx_1_xZkqqHx_iBeBiCgE_xHqqkZx_1_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
 *           _xZkqqHx_iCfBiBeEiCgB_xHqqkZx_1_xZkqqHx_iCkKiPoDiMmAjCgM_xHqqkZx_ _xZkqqHx_iCgB_xHqqkZx_n_xZkqqHx_iCpAjClEiCkGiCmEiCkCiCoJiCmGiClHiCoJiBeCiClBiCmMiPoKiNiHiBeB_xHqqkZx_
 *           _xZkqqHx_iBeAiBeAiCgMiBiBiCgB_xHqqkZx_n_xZkqqHx_iBhL_xHqqkZx_(_xZkqqHx_iCgAiBhLiCgCiBhLiCgDiBhLiCgE_xHqqkZx_)_xZkqqHx_iBhOiCjC_xHqqkZx_2
 *           _xZkqqHx_iBeAiBeAiCjC_xHqqkZx_2_xZkqqHx_iBiB_xHqqkZx_(_xZkqqHx_iCgMiBhMiCgB_xHqqkZx_n)_xZkqqHx_iBfO_xHqqkZx_(_xZkqqHx_iCgAiBhLiCgCiBhLiCgDiBhLiCgE_xHqqkZx_)
 *           _xZkqqHx_iBeAiBeAiCgA_xHqqkZx_2_xZkqqHx_iBiBiCgAiBhOiCjC_xHqqkZx_2_xZkqqHx_iBeBiCgC_xHqqkZx_2_xZkqqHx_iBiBiCgCiBhOiCjC_xHqqkZx_2_xZkqqHx_iBeBiBeFiBeFiBeFiCkJiCoHiCgA_xHqqkZx_2_xZkqqHx_iBeBiCgC_xHqqkZx_2_xZkqqHx_iBeBiCgD_xHqqkZx_2_xZkqqHx_iBeBiCgE_xHqqkZx_2_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
 *           _xZkqqHx_iCfCiBeEiCgD_xHqqkZx_2_xZkqqHx_iBeBiCgE_xHqqkZx_2_xZkqqHx_iCkKiPoDiMmAjCgM_xHqqkZx_ _xZkqqHx_iCgD_xHqqkZx_n_xZkqqHx_iBeBiCgE_xHqqkZx_n_xZkqqHx_iCpAjClEiCkGiCmEiCkCiCoJiCmGiClHiCoJiBeCiClBiCmMiPoKiNiHiBeB_xHqqkZx_
 *           _xZkqqHx_iBeAiBeAiCgMiBiBiCgB_xHqqkZx_n_xZkqqHx_iBhLiCgD_xHqqkZx_n_xZkqqHx_iBhLiCgE_xHqqkZx_n_xZkqqHx_iBhL_xHqqkZx_(_xZkqqHx_iCgAiBhLiCgC_xHqqkZx_)_xZkqqHx_iBhOiCjC_xHqqkZx_3
 *           _xZkqqHx_iBeAiBeAiCjC_xHqqkZx_3_xZkqqHx_iBiB_xHqqkZx_(_xZkqqHx_iCgMiBhMiCgB_xHqqkZx_n_xZkqqHx_iBhMiCgD_xHqqkZx_n_xZkqqHx_iBhMiCgE_xHqqkZx_n)_xZkqqHx_iBfO_xHqqkZx_(_xZkqqHx_iCgAiBhLiCgC_xHqqkZx_)
 *           _xZkqqHx_iBeAiBeAiCgA_xHqqkZx_3_xZkqqHx_iBiBiCgAiBhOiCjC_xHqqkZx_3_xZkqqHx_iBeBiCgC_xHqqkZx_3_xZkqqHx_iBiBiCgCiBhOiCjC_xHqqkZx_3 _xZkqqHx_iCkJiCoHiCgA_xHqqkZx_3_xZkqqHx_iBeBiCgC_xHqqkZx_3_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
 *           _xZkqqHx_iCfDiBeEiCfAiBgAiCfCiCmMiMeKiCoIjFnEiClFiCmFiBeBiCgAiBeBiCgBiBeBiCgCiBeBiCgDiBeBiCgEiCmMiNmFiPeJjDeJiCmIjCgMiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 05.06.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//BOOL FCObjTable::CalcNewLineHeight (mmetolVector& vNewLineHeight, mmetol mmNewHeight) const
void FCObjTable::CalcNewLineHeight (mmetolVector& vNewLineHeight, mmetol mmNewHeight) const
{
	// _xZkqqHx_iCnMiClIiBeBiNhDiNiCiCmMiNmFiPkMjCgMiBeBiNmFjBoFjCgMiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	mmetolVector vLineMin;
	mmetolVector vLineMax;
	long lLineIndex;
	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
	{
		mmetol mmMin, mmMax;
		// _xZkqqHx_iNhDiNiCiCmMiNmFiPkMjCgMiBeBiNmFjBoFjCgMiCpAiOoGjDlOiBeC_xHqqkZx_
		CalcLineMinMax(mmMin, mmMax, lLineIndex);
		vLineMin.push_back(mmMin);
		vLineMax.push_back(mmMax);
	}

//----- 05.06.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMiNhDiNiCiCkKiNmFiPkMjCgMiBeFiNmFjBoFjCgMiCpAjClEiCkGiCmEiCkCiCoJiPoKiNiHiCoAiCkAiCoIjDlOiCoJiBgJiNmFiPkMjCgMiBeFiNmFjBoFjCgMjFmPiNfIjClMiMoDiCmIiCmHiBgK_xHqqkZx_
//	// _xZkqqHx_iCmMiCmFiBeBiNmFiPkMjCgMiBeFiNmFjBoFjCgMiCmFjFoCjAlDiClFiClNiMlLiNnNiCmMiNhDiNiCiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
//	mmetol mmCurrentHeight = 0.0;
//	mmetolVector vCurrentLineHeight;
//	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
//	{
//		mmetol mmHeight = GetLineHeight(lLineIndex);
//		if (mmHeight < vLineMin[lLineIndex])
//			mmHeight = vLineMin[lLineIndex];
//		else
//		if (vLineMax[lLineIndex] < mmHeight)
//			mmHeight = vLineMax[lLineIndex];
//		mmCurrentHeight += mmHeight;
//		vCurrentLineHeight.push_back(mmHeight);
//	}
//----- 05.06.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// mpLimitIndexToHeight _xZkqqHx_iCmNiBeBiNmFiPkMiNmFjBoFjCgMiCpAjClEiCkGiClNiNhDiBeB_xHqqkZx_stUnlimitIndex_xZkqqHx_iCmNiNmFiPkMiNmFjBoFjCgMiCpA_xHqqkZx_
	// _xZkqqHx_jClEiCkGiCmEiCkCiCmIiCkCiNhDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	// _xZkqqHx_iJpAjAoAiCmMjHoB_xHqqkZx_ _xZkqqHx_iCfCiBeEiCmJiCkIiCkCiCmEiCmNiBeB_xHqqkZx_mpLimitIndexToHeight=(B,D,E)_xZkqqHx_iBeB_xHqqkZx_stUnlimitIndex=(A,C)
	map<long, mmetol> mpLimitIndexToHeight;
	set<long> stUnlimitIndex;
	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
		stUnlimitIndex.insert(lLineIndex);
	// mmLimit _xZkqqHx_iCmNiBeBiNmFjBoFiNmFiPkMjCgMiCpAjClEiCkGiClNiNhDiNiCiCmMjIgBiBeB_xHqqkZx_mmUnlimit_xZkqqHx_iCmNjClEiCkGiCmEiCkCiCmIiCkCiNhDiNiCiCmMjIgBiBeC_xHqqkZx_
	// _xZkqqHx_iJpAjAoAiCmMjHoB_xHqqkZx_ _xZkqqHx_iCfCiBeEiCmJiCkIiCkCiCmEiCmNiBeB_xHqqkZx_mmLimit=(Bn+Dn+En)_xZkqqHx_iBeB_xHqqkZx_mmUnlimit=(A+C)
	mmetol mmLimit = 0.0;
// 05.06.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	mmetol mmUnlimit = mmCurrentHeight;
	mmetol mmUnlimit = GetResizeFrame().Height();
	double dR;
	for (;;)
	{
		BOOL bUnchanged = TRUE;
		// _xZkqqHx_iCjCiCpAiMhGiOfKiBeC_xHqqkZx_
		dR = (mmNewHeight - mmLimit) / mmUnlimit;
		set<long>::iterator iId;
		for (iId = stUnlimitIndex.begin(); iId != stUnlimitIndex.end();)
		//----- _xZkqqHx_iNmFjBoFiBeFiNmFiPkMjCgMiCpAjClEiCkGiCmEiCkCiCmIiCkCiNhDiCmJiKnGiClFiCmE_xHqqkZx_ -----
		{
			// _xZkqqHx_jAfGiClFiCkCiNhDiNiCiCpAiMhGiOfKiBeC_xHqqkZx_
			mmetol mmHeight = GetLineHeight(*iId) * dR;
			// _xZkqqHx_jAfGiClFiCkCiNhDiNiCiCkKiBeBiClLiCmMiNiCiClDiCmMjAkHiMmAiCpAiJhKiCkGiClNiPoKiNiHiCmNiBeB_xHqqkZx_stUnlimitIndex_xZkqqHx_iCkJiCoH_xHqqkZx_
			// mpLimitIndexToHeight_xZkqqHx_iCnG_xHqqkZx_ _xZkqqHx_iClLiCmMiNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiInKiClHiBeC_xHqqkZx_
			BOOL bOverLimit = FALSE;
			if (mmHeight < vLineMin[*iId])
			{
				mmHeight = vLineMin[*iId];
				bOverLimit = TRUE;
			} else
			if (vLineMax[*iId] < mmHeight)
			{
				mmHeight = vLineMax[*iId];
				bOverLimit = TRUE;
			}
//			if (mmHeight < FD_OBJ_TABLE_MIN_CELL_HEIGHT) return FALSE;
			if (bOverLimit)
			//----- _xZkqqHx_jAfGiClFiCkCiNhDiNiCiCkKiBeBiClLiCmMiNiCiClDiCmMjAkHiMmAiCpAiJhKiCkGiClNiPoKiNiH_xHqqkZx_ -----
			{
				// stUnlimitIndex_xZkqqHx_iCkJiCoH_xHqqkZx_mpLimitIndexToHeight_xZkqqHx_iCnG_xHqqkZx_ _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiInKiClHiBeC_xHqqkZx_
				bUnchanged = FALSE;
				mpLimitIndexToHeight[*iId] = mmHeight;
				// mmLimit_xZkqqHx_iBeB_xHqqkZx_mmUnlimit _xZkqqHx_iCpAjFoCjAlDiClHiCoJiBeC_xHqqkZx_
				mmLimit += mmHeight;
				mmUnlimit -= GetLineHeight(*iId);
				iId = stUnlimitIndex.erase(iId);
			} else
			{
				iId++;
			}
		}
		// _xZkqqHx_iIoKiCmCiCoAiNhDiNiCjAkHiMmAjCgMiCpAjClEiCkGiCmIiCkJiCmBiClNiPoKiNiHiCmNiBeBiCjCiCmNjAlDiClFiCkCjCgMiCmIiCmMiCmFiDiLiBfLiDhGiCpAiPeJjHlJiBeC_xHqqkZx_
		if (bUnchanged) break;
		// _xZkqqHx_jBfDiCmEiCmMiNhDiCkKjAkHiMmAjCgMiCpAjClEiCkGiCmEiClFiCnMiCmBiClNiPoKiNiHiCmNiBeBjAfGiClFiCkCiNiCiClDiCmJiDiKiDfEiDeDiDfJiCmNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
// 05.06.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		if (stUnlimitIndex.empty()) return FALSE;
		if (stUnlimitIndex.empty()) break;
	}
	if (stUnlimitIndex.empty())
	//----- _xZkqqHx_jBfDiCmEiCmMiNhDiCkKjAkHiMmAjCgMiCpAjClEiCkGiCmEiClFiCnMiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iCkAiCkLiCoHiCnPiCmEiBeBjAkHiMmAjCgMiCmJiCnAiCmBiCkJiCkJiCmBiClNiNhDiCpAiLmPjDjJiCmJiDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iCjCiCpAiMhGiOfKiBeC_xHqqkZx_
		dR = mmNewHeight / mmLimit;
		// _xZkqqHx_jAfGiClFiCkCiNhDiNiCiCpAjAnNjCoIiBeC_xHqqkZx_
		vNewLineHeight.assign(GetLineCount(), 0.0);
		map<long, mmetol>::const_iterator iLm;
		for (iLm = mpLimitIndexToHeight.begin(); iLm != mpLimitIndexToHeight.end(); iLm++)
			vNewLineHeight[(*iLm).first] = (*iLm).second * dR;
	} else
	//----- _xZkqqHx_jAkHiMmAjCgMiCpAjClEiCkGiCmIiCkCiNhDiCkKiOgDiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAfGiClFiCkCiNhDiNiCiCpAjAnNjCoIiBeC_xHqqkZx_
		vNewLineHeight.assign(GetLineCount(), 0.0);
		map<long, mmetol>::const_iterator iLm;
		for (iLm = mpLimitIndexToHeight.begin(); iLm != mpLimitIndexToHeight.end(); iLm++)
			vNewLineHeight[(*iLm).first] = (*iLm).second;
		set<long>::const_iterator iId;
		for (iId = stUnlimitIndex.begin(); iId != stUnlimitIndex.end(); iId++)
			vNewLineHeight[*iId] = GetLineHeight(*iId) * dR;
	}
// 05.06.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	return TRUE;
} // FCObjTable::CalcNewLineHeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::CalcLineMinMax
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNhDiCmMiNmFiPkMiNiCiCmGiNmFjBoFiNiCiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmMin	:_xZkqqHx_iNmFiPkMiNiCiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmMax	:_xZkqqHx_iNmFjBoFiNiCiCpAjFnEiClHiBeC_xHqqkZx_
 *			lLineIndex	:_xZkqqHx_iNhDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNhDiCmMiDfKiDiLiCpAjBfDiCmEjClCiCnHiBeBiNmFiPkMiNiCiBeFiNmFjBoFiNiCiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNiBeBiClLiCmMjCgMiCmMiNiCiClDiCkKiNmFiCoAiNeMiCkNiCmIiCoJiCoGiCkEiBeBiNmFiPkMiNiCiBeFiNmFjBoFiNiCiCpAiPfHiMhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::CalcLineMinMax (mmetol& mmMin, mmetol& mmMax, long lLineIndex) const
{
	mmMin = DBL_MAX;
	mmMax = -DBL_MAX;
	long lColumnIndex;
	for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
	{
		// _xZkqqHx_iClLiCmMiNhDiBeFiDiMiDgDiCmMiDfKiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNjClCiCnHiCmIiCkNiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iNhDiCmMjBfDiCmEiCmMiDfKiDiLiCkKjBlGiNnNiClFiCmIiCkNiCmEiCoAiBeBiKnGjAjEiNmFiMoDiCmFiNmFiPkMjCgMiBeFiNmFjBoFjCgMiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		if (GetCell(FCLineColumn(lLineIndex, lColumnIndex)) != NULL)
		//----- _xZkqqHx_iDfKiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ ----
		{
			// _xZkqqHx_iDfKiDiLiCmMiNmFiPkMiNiCiBeBiNmFjBoFiNiCiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiClLiCmMjCgMiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
			if (GetCell(FCLineColumn(lLineIndex, lColumnIndex))->GetMinHeight() < mmMin)
				mmMin = GetCell(FCLineColumn(lLineIndex, lColumnIndex))->GetMinHeight();
			if (mmMax < GetCell(FCLineColumn(lLineIndex, lColumnIndex))->GetMaxHeight())
				mmMax = GetCell(FCLineColumn(lLineIndex, lColumnIndex))->GetMaxHeight();
		}
	}
	// _xZkqqHx_iNmFiPkMiNiCiBeBiNmFjBoFiNiCiCkKjAnNjCoIiClDiCoKiCmIiCkJiCmBiClNiPoKiNiHiCmNiBeBiDgGiDhEiDeIiDiLiDgHjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	if (mmMin == DBL_MAX)
		mmMin = FD_OBJ_TABLE_MIN_CELL_HEIGHT;
	if (mmMax == -DBL_MAX)
		mmMax = DBL_MAX;
} // FCObjTable::CalcLineMinMax.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjTable::AdjustObjectSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjFjEjFgJiCpAiBeBiClBiCmMjFjEjFgJiCmJiKnMiCnMiCoKiCoJjFjEjFgJiBgJiDiBiDjDiDgPiBfLiBgKiCmMiDgFiDeMiDfIiDgHiCmM_xHqqkZx_
 *			_xZkqqHx_iIoMiCoKiCkKjGlDiCkNiCmIiCoJiCoGiCkEiCmJiDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptFixPoint	:_xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmMiMmFjCoIjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmFiDfCiDhNiDjDiDgIjEkNiNhDiClHiCoJiClBiCmGiCmJjCiNiInDiBeCiDfKiDgCiDfGiDiHiDjDiCpAiKeKiCkCiCmEiCkIiCkN_xHqqkZx_
 *			_xZkqqHx_jFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjTable::AdjustObjectSize (const DBLPoint& mmptFixPoint)
{
	// _xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmMiMmFjCoIjDfPiCpAiBeBiNlGiPoDiCkJiCoHiCmMiDhEiDiMiBfLiDiAiDfEiDeDiDfJiCmJjBmOiClHiCoJjEoEjHkGiCmFiLeMjIfOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	const double dFixRatioX = (mmptFixPoint.x - GetResizeFrame().left) / GetResizeFrame().Width();
	const double dFixRatioY = (mmptFixPoint.y - GetResizeFrame().top) / GetResizeFrame().Height();

	long lColumnIndex;
	for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
	{
		// _xZkqqHx_iClBiCmMjHpBiCmFiNmFjBoFiCmMiDgFiDeMiDfIiDgHjFjNiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		mmetol mmMaxWidth = FD_OBJ_TABLE_MIN_CELL_WIDTH;
		long lLineIndex;
		for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
		{
			FCObjTextRect* pCell = GetCell(FCLineColumn(lLineIndex, lColumnIndex));
			if (pCell != NULL)
			{
				mmetol mmWidth;
				if (almosteq(pCell->GetTextAngle(), 0.0) || almosteq(pCell->GetTextAngle(), 1.0))
					mmWidth = GetCellWidthMin(FCLineColumn(lLineIndex, lColumnIndex));
				else
					mmWidth = GetCellHeightMin(FCLineColumn(lLineIndex, lColumnIndex));
				if (mmMaxWidth < mmWidth)
					mmMaxWidth = mmWidth;
			}
		}
		// _xZkqqHx_iClBiCmMjHpBiCmMiNmFiPkMjCgMiBeBiNmFjBoFjCgMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		mmetol mmMin;
		mmetol mmMax;
		CalcColumnMinMax(mmMin, mmMax, lColumnIndex);
		if (mmMaxWidth < mmMin) mmMaxWidth = mmMin;
		if (mmMax < mmMaxWidth) mmMaxWidth = mmMax;
		FFSnapGeMP(&mmMaxWidth, NULL);
		g_pDoc->CmdSetTableColumnWidth(this, lColumnIndex, mmMaxWidth);
	}
	long lLineIndex;
	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
	{
		// _xZkqqHx_iClBiCmMiNhDiCmFiNmFjBoFiCmMiDgFiDeMiDfIiDgHiNiCiClDiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		mmetol mmMaxHeight = FD_OBJ_TABLE_MIN_CELL_HEIGHT;
		long lColumnIndex;
		for (lColumnIndex = 0; lColumnIndex != GetColumnCount(); lColumnIndex++)
		{
			FCObjTextRect* pCell = GetCell(FCLineColumn(lLineIndex, lColumnIndex));
			if (pCell != NULL)
			{
				mmetol mmHeight;
				if (almosteq(pCell->GetTextAngle(), 0.0) || almosteq(pCell->GetTextAngle(), 1.0))
					mmHeight = GetCellHeightMin(FCLineColumn(lLineIndex, lColumnIndex));
				else
					mmHeight = GetCellWidthMin(FCLineColumn(lLineIndex, lColumnIndex));
				if (mmMaxHeight < mmHeight)
					mmMaxHeight = mmHeight;
			}
		}
		// _xZkqqHx_iClBiCmMiNhDiCmMiNmFiPkMjCgMiBeBiNmFjBoFjCgMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		mmetol mmMin;
		mmetol mmMax;
		CalcLineMinMax(mmMin, mmMax, lLineIndex);
		if (mmMaxHeight < mmMin) mmMaxHeight = mmMin;
		if (mmMax < mmMaxHeight) mmMaxHeight = mmMax;
		FFSnapGeMP(NULL, &mmMaxHeight);
		g_pDoc->CmdSetTableLineHeight(this, lLineIndex, mmMaxHeight);
	}

	// _xZkqqHx_iMmFjCoIjDfPiCkKiDiKiDfEiDeDiDfJiCmFiInKjDkOiClFiClNjAoGiCpAiMhGiOfKiBeC_xHqqkZx_
	DBLPoint mmptMovedFixPoint(	GetResizeFrame().left + dFixRatioX * GetResizeFrame().Width(),
								GetResizeFrame().top + dFixRatioY * GetResizeFrame().Height());
	// _xZkqqHx_iMmFjCoIjDfPiCkKiMlDiCmMiImKjChFiCmJjGnPiCoJiCoGiCkEiBeBjFfMjFjEjFgJiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
	g_pDoc->CmdMove1Obj(this, mmptFixPoint - mmptMovedFixPoint);
	// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
	g_pDoc->LinkManager()->MovedNotify(this);
} // FCObjTable::AdjustObjectSize.
