// PreToolbar.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilErr.h"		// For FFThrowMiscUnknown().
#include "UtilStr.h"		// For FFExtractUntil.
#include "UtilWin.h"		// For FFAddString.
#include "UtilDlg.h"		// For FFCommandStringToId.
#include "UtilToolbar.h"	// For FFGetToolbarCommandPoolList.
#include "PreToolbar.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myDeleteCurSel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfIiDgHiDhLiDgCiDeOiDfIiCkJiCoHjBeJjBpAiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDeBiDeDiDgFiDiAiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrText	:_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiDgFiDeMiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			uiData		:_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiDgGiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *			pListBox	:_xZkqqHx_iDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bDeleteSeparator
 *						:_xZkqqHx_iDfKiDhAiDiMiBfLiDfOiBfLiCpAiNoNiPjMiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static BOOL myDeleteCurSel (WString& wstrText, UINT& uiData, CListBox* pListBox, BOOL bDeleteSeparator)
{
	int iCurSel = pListBox->GetCurSel();
	if (iCurSel == LB_ERR)
		return FALSE;
	FFGetText(pListBox, iCurSel, wstrText);
	uiData = (UINT)pListBox->GetItemData(iCurSel);
	// _xZkqqHx_iDfKiDhAiDiMiBfLiDfOiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
// 06.10.30 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (uiData == FD_TOOLBAR_SEPARATOR_ID && !bDeleteSeparator)
	if (uiData == ID_SEPARATOR && !bDeleteSeparator)
		return TRUE;
	pListBox->DeleteString(iCurSel);
	// _xZkqqHx_iNoNiPjMiClDiCoKiClNiImKjChFiCkKjBeJjBpAiClDiCoKiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
	if (pListBox->GetCount() == 0)
	{
		iCurSel = LB_ERR;
	} else
	{
		if (iCurSel == pListBox->GetCount())
			iCurSel = pListBox->GetCount() - 1;
	}
	pListBox->SetCurSel(iCurSel);
	return TRUE;
} // myDeleteCurSel.

/////////////////////////////////////////////////////////////////////////////
// CFCPreToolbar _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfH_xHqqkZx_

IMPLEMENT_DYNCREATE(CFCPreToolbar, CFCPropertyPageBase)

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::CFCPreToolbar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCPreToolbar::CFCPreToolbar ()
			: BASE_CLASS(CFCPreToolbar::IDD)
{
	//{{AFX_DATA_INIT(CFCPreToolbar)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDiBiDjDiDgPiCmMiPiJiKpKiJlLiPiIjHjNiCpAjCmHiJmBiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_INIT
} // CFCPreToolbar::CFCPreToolbar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::~CFCPreToolbar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCPreToolbar::~CFCPreToolbar ()
{
} // CFCPreToolbar::~CFCPreToolbar.

/////////////////////////////////////////////////////////////////////////////
// CFCPreToolbar _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfH_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::CheckConsistency
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCgMiCkKjAlDiClFiCkNjAnNjCoIiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	uiToolbarId	:_xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGlFiPiCjCgMiCmJjFmPiNfIiCkKiCkAiCoIiBeBiNmEjFgAiJoGiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCPreToolbar::CheckConsistency (UINT uiToolbarId)
{
	BOOL bIsConsistent = TRUE;	// _xZkqqHx_jGlDjGlFiPiCiCkJiBeI_xHqqkZx_
	if (uiToolbarId != UINT(-1))
	//----- _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		UINTVector vCommandId;
		GetToolbarCommandList(vCommandId, uiToolbarId);
		if (vCommandId.empty())
			bIsConsistent = FALSE;	// _xZkqqHx_jGlDjGlFiPiCiCkJiBeI_xHqqkZx_

		BOOL bIsNoButtons = TRUE;	// _xZkqqHx_iDhLiDfOiDjDiCkKiIoKiCmCiCoAiCmIiCkCiBeC_xHqqkZx_
		UINTVector::const_iterator iId;
		for (iId = vCommandId.begin();
			 bIsNoButtons && iId != vCommandId.end(); iId++)
		{
			if (*iId != ID_SEPARATOR &&
				!FFIsToolbarDropdown(*iId))
				bIsNoButtons = FALSE;
		}
		if (bIsNoButtons)
			bIsConsistent = FALSE;	// _xZkqqHx_jGlDjGlFiPiCiCkJiBeI_xHqqkZx_
	}
	if (m_bIsConsistent == TRUE &&
		bIsConsistent == FALSE)
	//----- _xZkqqHx_jAfGiClFiCkNjGlFiPiCiCkKjEkNjAlGiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		WString wstr;
		wstr.LoadString(uiToolbarId);
		wstr = FFExtractUntil(wstr, L'\n');
		// IDS_ERR_MSG_TOOLBAR_MUST_HAVE_BUTTON_EXCEPT_PULLDOWN_SEPARATOR =
		// "_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmJiCmNiBeB_xHqqkZx_\r\n_xZkqqHx_iDhGiDiLiDfPiDeFiDjDiDiBiDgKiDiFiBfLiCmGiDfKiDhAiDiMiBfLiDfOiBfLiImIiKePiCmJiBeB_xHqqkZx_\r\n1_xZkqqHx_iMmCiImIiPoDiCmMiDhLiDfOiDjDiCkKjEhKjChFiClDiCoKiCmEiCkCiCoJjFeLjHhGiCkKiCkAiCoIiCnMiClHiBeC_xHqqkZx_"
		FFErrorBox(	IDS_ERR_MSG_TOOLBAR_MUST_HAVE_BUTTON_EXCEPT_PULLDOWN_SEPARATOR,
					wstr.c_str());
	}
	if (m_bIsConsistent != bIsConsistent)
	//----- _xZkqqHx_jGlFiPiCiCmJjFmPiNfIiCkKiCkAiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jGlFiPiCiCpAjAnNjCoIiBeC_xHqqkZx_
		m_bIsConsistent = bIsConsistent;
		return TRUE;
	}
	return FALSE;
} // CFCPreToolbar::CheckConsistency.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::UpdateModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiBeBiIoKiCmCiCmFiCoAjFmPiNfIiCkKiCkAiCoKiCmOiPeDjAlDiDhEiDiJiDeP_xHqqkZx_
 *			_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeCiIoKiCmCiCoAjFmPiNfIiCkKiCmIiCkPiCoKiCmOiPeDjAlDiDhEiDiJiDePiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::UpdateModified ()
{
	// _xZkqqHx_iPeDjAlDiCkKiCkAiCoJiCkJiBeI_xHqqkZx_
	BOOL bIsModified = FALSE;
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CComboBox* pToolbarBox = (CComboBox*)GetDlgItem(IDC_TBS_CMB_TOOLBAR_NAME);
	for (int iIndex = 0;
		 !bIsModified && iIndex != pToolbarBox->GetCount();
		 iIndex++)
	{
		UINT uiToolbarId = (UINT)pToolbarBox->GetItemData(iIndex);
		UINTVector vCommandIdOld;
		FFGetToolbarCommandList(vCommandIdOld, uiToolbarId);
		UINTVector vCommandIdNew;
		GetToolbarCommandList(vCommandIdNew, uiToolbarId);
		//----- _xZkqqHx_jCgMiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		if (vCommandIdOld != vCommandIdNew)
			bIsModified = TRUE;
	}
	SetModified(bIsModified);
} // CFCPreToolbar::UpdateModified.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::UpdateActivate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKgFjBkOjAkLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjClCiCnHiBeBjHeMiMpIiPpDjBnEjFmPjAjEiCpAiNfIjAfGiClFiClNiMoD_xHqqkZx_
 *			_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::UpdateActivate ()
{
	// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPlaced = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_PLACED);
	int iSelPlaced = pListPlaced->GetCurSel();
	if (iSelPlaced == LB_ERR ||
		iSelPlaced == pListPlaced->GetCount() - 1)
	{
		GetDlgItem(IDC_TBS_BTN_UNPLACE)->EnableWindow(FALSE);
	} else
	{
		GetDlgItem(IDC_TBS_BTN_UNPLACE)->EnableWindow(TRUE);
	}

	if (iSelPlaced == LB_ERR ||
		iSelPlaced == 0 ||
		iSelPlaced == pListPlaced->GetCount() - 1)
	{
		GetDlgItem(IDC_TBS_BTN_MOVE_UP)->EnableWindow(FALSE);
	} else
	{
		GetDlgItem(IDC_TBS_BTN_MOVE_UP)->EnableWindow(TRUE);
	}

	if (iSelPlaced == LB_ERR ||
		iSelPlaced == pListPlaced->GetCount() - 2 ||
		iSelPlaced == pListPlaced->GetCount() - 1)
	{
		GetDlgItem(IDC_TBS_BTN_MOVE_DOWN)->EnableWindow(FALSE);
	} else
	{
		GetDlgItem(IDC_TBS_BTN_MOVE_DOWN)->EnableWindow(TRUE);
	}
} // CFCPreToolbar::UpdateActivate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::InitAllTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLjBfDiCmEiCpAiBeBiMlLiNnNjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OnInitDialog_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::InitAllTable ()
{
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_mpToolbarToCommandIdVector.clear();
	CComboBox* pToolbarBox = (CComboBox*)GetDlgItem(IDC_TBS_CMB_TOOLBAR_NAME);
	int iIndex;
	for (iIndex = 0; iIndex != pToolbarBox->GetCount(); iIndex++)
	{
		UINT uiToolbarId = (UINT)pToolbarBox->GetItemData(iIndex);
		// _xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiCmMiBeBiOhHjCoIiClDiCoKiClNiDgDiBfLiDiLiDgPiBfLiCmM_xHqqkZx_
		// _xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiCpAiBeBiMlLiNnNjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
		InitTableByCurrent(uiToolbarId);
	}
} // CFCPreToolbar::InitAllTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::InitTableByCurrent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiCmMiBeBiOhHjCoIiClDiCoKiClNiDgDiBfLiDiLiDgPiBfLiCmM_xHqqkZx_
 *			_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiCpAiBeBiMlLiNnNjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	uiToolbarId	:_xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::InitTableByCurrent (UINT uiToolbarId)
{
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	m_mpToolbarToCommandIdVector[uiToolbarId].clear();
	FFGetToolbarCommandList(m_mpToolbarToCommandIdVector[uiToolbarId], uiToolbarId);
} // CFCPreToolbar::InitTableByCurrent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::InitTableByDefault
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiCmMiBeBiOhHjCoIiClDiCoKiClNiDgDiBfLiDiLiDgPiBfLiCmM_xHqqkZx_
 *			_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiCpAiBeBiDgGiDhEiDeIiDiLiDgHjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	uiToolbarId	:_xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::InitTableByDefault (UINT uiToolbarId)
{
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	m_mpToolbarToCommandIdVector[uiToolbarId].clear();
	FFGetDefaultToolbarCommandList(m_mpToolbarToCommandIdVector[uiToolbarId], uiToolbarId);
} // CFCPreToolbar::InitTableByDefault.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::GetCurrentToolbarId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiDgDiBfLiDiLiDgPiBfLiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiDgDiBfLiDiLiDgPiBfLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
UINT CFCPreToolbar::GetCurrentToolbarId () const
{
	CComboBox* pToolbarBox = (CComboBox*)GetDlgItem(IDC_TBS_CMB_TOOLBAR_NAME);
	if (pToolbarBox->GetCurSel() != CB_ERR)
		return (UINT)pToolbarBox->GetItemData(pToolbarBox->GetCurSel());
	else
		return UINT(-1);
} // CFCPreToolbar::GetCurrentToolbarId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::UpdateImageList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAiBeBjEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfI_xHqqkZx_
 *			_xZkqqHx_iCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::UpdateImageList ()
{
	longVector vImageList;
	// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPlaced = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_PLACED);
	int index;
	for (index = 0; index != pListPlaced->GetCount() - 1; index++)
	//----- _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		UINT uiCommandId = (UINT)pListPlaced->GetItemData(index);
		if (uiCommandId == ID_SEPARATOR)
			vImageList.push_back(CFCStcImageList::SEPARATOR);
		else
		if (FFIsToolbarDropdown(uiCommandId))
			vImageList.push_back(CFCStcImageList::DROPDOWN);
		else
			vImageList.push_back(CommandIdToIndex(uiCommandId));
	}
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	if (vImageList.empty())
		m_stcImageList.SetImageIndexList(NULL, 0);
	else
		m_stcImageList.SetImageIndexList(&vImageList.at(0), (long)vImageList.size());

	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpAiCpAiOoGjDlOiBeC_xHqqkZx_
	int iSelPlaced = pListPlaced->GetCurSel();
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDeDiDiBiBfLiDfHiCpAjBeJjBpAiBeC_xHqqkZx_
	if (iSelPlaced != LB_ERR)
		m_stcImageList.SetCurSel(iSelPlaced, FALSE);
	else
		m_stcImageList.SetCurSel(-1, FALSE);

	m_stcImageList.RedrawWindow();
} // CFCPreToolbar::UpdateImageList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::MakeCommandIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDiBiBfLiDfHiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID(m_vCommandId)_xZkqqHx_iCmGiBeB_xHqqkZx_
 *			_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID->_xZkqqHx_iDeDiDiBiBfLiDfHiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_(m_mpCommandIdToIndex)_xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_iPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::MakeCommandIndex ()
{
	CToolBar xxx;
	xxx.Create(this, WS_CHILD);
	xxx.LoadToolBar(IDR_TOOLBAR_1);
	long lButtonCount = (long)xxx.GetToolBarCtrl().GetButtonCount();
	for (long lIndex = 0; lIndex != lButtonCount; lIndex++)
	{
		UINT uiID;
		UINT uiStyle;
		int iImage;
		xxx.GetButtonInfo(lIndex, uiID, uiStyle, iImage);
		ASSERT(uiStyle == TBBS_BUTTON);
		m_vCommandId.push_back(uiID);
		m_mpCommandIdToIndex[uiID] = lIndex;
	}
} // CFCPreToolbar::MakeCommandIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::CommandIdToIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCkJiCoHiDeDiDiBiBfLiDfHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	uiCommandId	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDiBiBfLiDfHiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCPreToolbar::CommandIdToIndex (UINT uiCommandId) const
{
	map<UINT, long>::const_iterator i = m_mpCommandIdToIndex.find(uiCommandId);
	if (i == m_mpCommandIdToIndex.end())
		FFThrowMiscUnknown();
	return i->second;
} // CFCPreToolbar::CommandIdToIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::IndexToCommandId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDiBiBfLiDfHiDeDiDjDiDgGiDgCiDeOiDfIiCkJiCoHiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeDiDiBiBfLiDfHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
UINT CFCPreToolbar::IndexToCommandId (long lIndex) const
{
	return m_vCommandId[lIndex];
} // CFCPreToolbar::IndexToCommandId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::GetToolbarCommandList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDfPiDeDiDeBiDiNiDePiCmFjAnNjCoIiClDiCoKiCmEiCkCiCoJiBeBiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCmMiDiKiDfIiDgHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vCommandId	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			uiToolbarId	:_xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::GetToolbarCommandList (UINTVector& vCommandId, UINT uiToolbarId)
{
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	map<UINT, UINTVector>::const_iterator i = m_mpToolbarToCommandIdVector.find(uiToolbarId);
	if (i == m_mpToolbarToCommandIdVector.end())
		FFThrowMiscUnknown();
	vCommandId = i->second;
} // CFCPreToolbar::GetToolbarCommandList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnToolbarChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgDiBfLiDiLiDgPiBfLiCmJiKoOiCmDiCkCiCmEiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgDiBfLiDiLiDgPiBfLiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::OnToolbarChanged ()
{
	// _xZkqqHx_jGkCjEhKjChFiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPool = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_POOL);
	pListPool->ResetContent();
	// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPlaced = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_PLACED);
	pListPlaced->ResetContent();

	UINT uiToolbarId = GetCurrentToolbarId();
	if (uiToolbarId != UINT(-1))
	//----- _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfCiDhNiDjDiDgIiDhGiBfLiDiLiDiKiDfIiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		UINTSet stId;
		FFGetToolbarCommandPoolList(stId, uiToolbarId);
		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDhNiDjDiDgIiDiKiDfIiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		UINTVector vCommandId;
		GetToolbarCommandList(vCommandId, uiToolbarId);
		// _xZkqqHx_iDhGiBfLiDiLiDiKiDfIiDgHiCkJiCoHiDfCiDhNiDjDiDgIiDiKiDfIiDgHiCpAiNoNiPjMiBeC_xHqqkZx_
		UINTVector::const_iterator iCmd;
		for (iCmd = vCommandId.begin(); iCmd != vCommandId.end(); iCmd++)
			stId.erase(*iCmd);
		// _xZkqqHx_iDhGiBfLiDiLiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhGiBfLiDiLiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
		UINTSet::const_iterator iId;
		for (iId = stId.begin(); iId != stId.end(); iId++)
		{
			WString wstr;
			wstr.LoadString(*iId);
			wstr = FFExtractUntil(wstr, L'\n');
			int index = FFAddString(pListPool, wstr);
			pListPool->SetItemData(index, (DWORD)*iId);
		}
		// _xZkqqHx_iDhGiBfLiDiLiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiNmFiMoDiCmJiDfKiDhAiDiMiBfLiDfOiCpAjCmHiJmBiBeC_xHqqkZx_
		int index = FFAddString(pListPool, FFLoadWString(IDS_SEPARATOR));
		pListPool->SetItemData(index, (DWORD)ID_SEPARATOR);
		pListPool->SetCurSel(0);
		OnSelchangeTbsLstButtonPool();

		// _xZkqqHx_jEhKjChFiNmPiCnNiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmJiDgGiDhEiDeIiDiLiDgHiDfCiDhNiDjDiDgIiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
		for (iCmd = vCommandId.begin(); iCmd != vCommandId.end(); iCmd++)
		{
			if (*iCmd == ID_SEPARATOR)
			{
				// _xZkqqHx_iDfKiDhAiDiMiBfLiDfOiCpAjCmHiJmBiBeC_xHqqkZx_
				int index = FFAddString(pListPlaced, FFLoadWString(IDS_SEPARATOR));
				pListPlaced->SetItemData(index, (DWORD)ID_SEPARATOR);
			} else
			{
				WString wstr;
				wstr.LoadString(*iCmd);
				wstr = FFExtractUntil(wstr, L'\n');
				int index = FFAddString(pListPlaced, wstr);
				pListPlaced->SetItemData(index, (DWORD)*iCmd);
			}
		}
		// _xZkqqHx_jEhKjChFiNmPiCnNiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmJ_xHqqkZx_ END _xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
		index = FFAddString(pListPlaced, L"-- END --");
		pListPlaced->SetItemData(index, DWORD(-1));
		pListPlaced->SetCurSel(0);
	}
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAiBeBjEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfI_xHqqkZx_
	// _xZkqqHx_iCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
	UpdateImageList();
} // CFCPreToolbar::OnToolbarChanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnPlacedChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCmMjDoAjHgFiCpAiBeB_xHqqkZx_
 *			_xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiCmJjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::OnPlacedChanged ()
{
	UINT uiToolbarId = GetCurrentToolbarId();
	// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPlaced = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_PLACED);
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	m_mpToolbarToCommandIdVector[uiToolbarId].clear();
	int iIndex;
	for (iIndex = 0; iIndex != pListPlaced->GetCount() - 1; iIndex++)
	{
		UINT uiCommandId = (UINT)pListPlaced->GetItemData(iIndex);
		m_mpToolbarToCommandIdVector[uiToolbarId].push_back(uiCommandId);
	}
} // CFCPreToolbar::OnPlacedChanged.

/////////////////////////////////////////////////////////////////////////////
// CFCPreToolbar _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfH_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::DoDataExchange
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::DoDataExchange (CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCPreToolbar)
	DDX_Control(pDX, IDC_TBS_STC_IMAGE_POOL, m_stcImagePool);
	DDX_Control(pDX, IDC_TBS_STC_TOOLBAR_IMAGE, m_stcImageList);
	//}}AFX_DATA_MAP
} // CFCPreToolbar::DoDataExchange.

BEGIN_MESSAGE_MAP(CFCPreToolbar, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCPreToolbar)
	ON_CBN_SELCHANGE(IDC_TBS_CMB_TOOLBAR_NAME, OnSelchangeTbsCmbToolbarName)
	ON_BN_CLICKED(IDC_TBS_BTN_PLACE, OnTbsBtnPlace)
	ON_BN_CLICKED(IDC_TBS_BTN_UNPLACE, OnTbsBtnUnplace)
	ON_BN_CLICKED(IDC_TBS_BTN_MOVE_UP, OnTbsBtnMoveUp)
	ON_BN_CLICKED(IDC_TBS_BTN_MOVE_DOWN, OnTbsBtnMoveDown)
	ON_BN_CLICKED(IDC_TBS_BTN_INIT_BY_DEFAULT, OnTbsBtnInitByDefault)
	ON_BN_CLICKED(IDC_TBS_BTN_INIT_BY_CURRENT, OnTbsBtnInitByCurrent)
	ON_LBN_SELCHANGE(IDC_TBS_LST_BUTTON_POOL, OnSelchangeTbsLstButtonPool)
	ON_LBN_SELCHANGE(IDC_TBS_LST_BUTTON_PLACED, OnSelchangeTbsLstButtonPlaced)
	ON_WM_CTLCOLOR()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_USER_IMGLST_SELCHANGED, OnUserImglstSelchanged)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCPreToolbar _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCPreToolbar::OnInitDialog ()
{
	BASE_CLASS::OnInitDialog();

	// _xZkqqHx_jGlDjGlFiPiCiCkJiBeI_xHqqkZx_
	m_bIsConsistent = TRUE;

	// _xZkqqHx_iDeDiDiBiBfLiDfHiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID(m_vCommandId)_xZkqqHx_iCmGiBeB_xHqqkZx_
	// _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID->_xZkqqHx_iDeDiDiBiBfLiDfHiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_(m_mpCommandIdToIndex)_xZkqqHx_iCpA_xHqqkZx_
	// _xZkqqHx_iPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	MakeCommandIndex();
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDeDiDiBiBfLiDfHiDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_stcImagePool.SetStyle(CFCStcImageList::STYLE_HORZ_CENTER |
							CFCStcImageList::STYLE_VERT_CENTER |
							CFCStcImageList::STYLE_HALF_DROPDOWN);	// _xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiDeDiDiBiBfLiDfHiCmNjElMjFkKiBeC_xHqqkZx_
	m_stcImagePool.SetBitmap(IDR_TOOLBAR_1, CSize(22, 18), 16, RGB(192,192,192));
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDeDiDiBiBfLiDfHiDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_stcImageList.SetStyle(CFCStcImageList::STYLE_HORZ_CENTER |
							CFCStcImageList::STYLE_VERT_CENTER);
	m_stcImageList.SetBitmap(IDR_TOOLBAR_1, CSize(22, 18), 16, RGB(192,192,192));
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CComboBox* pToolbarBox = (CComboBox*)GetDlgItem(IDC_TBS_CMB_TOOLBAR_NAME);
	UINTVector vToolbarId;
	FFGetToolbarList(vToolbarId);
	UINTVector::const_iterator iId;
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	for (iId = vToolbarId.begin(); iId != vToolbarId.end(); iId++)
	{
		WString wstr;
		wstr.LoadString(*iId);
		wstr = FFExtractUntil(wstr, L'\n');
		int index = FFAddString(pToolbarBox, wstr);
		pToolbarBox->SetItemData(index, (DWORD)*iId);
	}
	pToolbarBox->SetCurSel(0);
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLjBfDiCmEiCpAiBeBiMlLiNnNjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	InitAllTable();
	// _xZkqqHx_iMlLiNnNiCmMiDgDiBfLiDiLiDgPiBfLiCmJiKoOiCmDiCkCiCmEiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	OnToolbarChanged();
	// _xZkqqHx_iMmCiBfIiCmMjCgMiCmMjBiKiKnGiKnGiMfHiCkKjGlDjGlFiPiCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	if (CheckConsistency(GetCurrentToolbarId()))
		GetDlgItem(IDC_TBS_LST_BUTTON_PLACED)->Invalidate();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
	// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	UpdateModified();

//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCPreToolbar::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnOK
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OK_xZkqqHx_iDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::OnOK ()
{
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CComboBox* pToolbarBox = (CComboBox*)GetDlgItem(IDC_TBS_CMB_TOOLBAR_NAME);
	int iIndex;
	for (iIndex = 0; iIndex != pToolbarBox->GetCount(); iIndex++)
	{
		UINT uiToolbarId = (UINT)pToolbarBox->GetItemData(iIndex);
		// _xZkqqHx_iMmCiBfIiCmMjCgMiCmMjBiKiKnGiKnGiMfHiCkKjGlDjGlFiPiCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		m_bIsConsistent = TRUE;
		CheckConsistency(uiToolbarId);
		if (m_bIsConsistent)
		//----- _xZkqqHx_jCgMiCmJjGlFiPiCiCkKiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			UINTVector vCommandIdOld;
			FFGetToolbarCommandList(vCommandIdOld, uiToolbarId);
			UINTVector vCommandIdNew;
			GetToolbarCommandList(vCommandIdNew, uiToolbarId);
			if (vCommandIdOld != vCommandIdNew)
			//----- _xZkqqHx_jCgMiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				FFSetToolbarCommandList(uiToolbarId, &vCommandIdNew.at(0), (long)vCommandIdNew.size());
			}
		}
	}
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnOK();
} // CFCPreToolbar::OnOK.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnCtlColor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhBiDfCiDjDiDgHiDiNiBfLiDiLiCkKjFgAiJoGiClDiCoKiCoJjClMjBePiCmJiBeBiDhEiDiMiBfLiDiAiDiPiBfLiDeOiCkJiCoHiClBiCmM_xHqqkZx_
 *			_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiCkKiMmEiCnBiPgPiClDiCoKiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HBRUSH CFCPreToolbar::OnCtlColor (CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	HBRUSH hbr = BASE_CLASS::OnCtlColor(pDC, pWnd, nCtlColor);

	//-----	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMiCkEiClPiBeBiDeHiDiJiBfLiCkKiCkAiCoJiCoAiCmMiCmNjAeGiCpAjFmPiCkGiCmEjFfMiOkG_xHqqkZx_ -----
	DWORD dwID = 0;
	HWND hwndParent = ::GetParent(pWnd->m_hWnd);
	if (hwndParent == m_hWnd)
		dwID = ::GetDlgCtrlID(pWnd->m_hWnd);
	else
		dwID = ::GetDlgCtrlID(hwndParent);
	switch (dwID)
	{
	case IDC_TBS_LST_BUTTON_PLACED:	// _xZkqqHx_jAnNjCoIiClDiCoKiClNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
		if (!m_bIsConsistent)
		//----- _xZkqqHx_jCgMiCmJjGlFiPiCiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFfMiOkGiCmMjAeGiCpAjAnEiCkNjFmPiCkGiCoJiBeC_xHqqkZx_
			pDC->SetTextColor(FD_COLREF_RED);
			pDC->SetBkColor(FD_COLREF_WHITE);
		}
		break;
	}

	// TODO: _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmMiDhFiDiJiDfGiCkKjGfNiCnNiCmMiCoAiCmMiCmFiCmIiCkCiPoKiNiHiCmJiCmNiBeBiIoBiCkEiDhFiDiJiDfGiCpAjFnEiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_
	return hbr;
} // CFCPreToolbar::OnCtlColor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnSelchangeTbsCmbToolbarName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfLjAnNjCoIiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::OnSelchangeTbsCmbToolbarName ()
{
	// _xZkqqHx_iMlLiNnNiCmMiDgDiBfLiDiLiDgPiBfLiCmJiKoOiCmDiCkCiCmEiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	OnToolbarChanged();
	// _xZkqqHx_iMmCiBfIiCmMjCgMiCmMjBiKiKnGiKnGiMfHiCkKjGlDjGlFiPiCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	if (CheckConsistency(GetCurrentToolbarId()))
		GetDlgItem(IDC_TBS_LST_BUTTON_PLACED)->Invalidate();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
	// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	UpdateModified();
} // CFCPreToolbar::OnSelchangeTbsCmbToolbarName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnTbsBtnPlace
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhKjChFiDhLiDfOiDjDiBhF_xHqqkZx_>>_xZkqqHx_iBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::OnTbsBtnPlace ()
{
	// _xZkqqHx_jGkCjEhKjChFiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPool = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_POOL);
	// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPlaced = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_PLACED);
	int iSelPlaced = pListPlaced->GetCurSel();
	if (iSelPlaced != LB_ERR)
	{
		WString wstrText;
		UINT uiCommandId;
		// _xZkqqHx_iDiKiDfIiDgHiDhLiDgCiDeOiDfIiCkJiCoHiMlLiNnNiCmMjBeJjBpAiNiAjGnKiCpAiNoNiPjMiBeC_xHqqkZx_
		if (myDeleteCurSel(wstrText, uiCommandId, pListPool, FALSE))
		//----- _xZkqqHx_iDiKiDfIiDgHiDhLiDgCiDeOiDfIiCkJiCoHiNoNiPjMiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iBhFjAnNjCoIiJmCjEfMiCmIiDfCiDhNiDjDiDgIiBhGiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiPiIjHjNiBeC_xHqqkZx_
			OnSelchangeTbsLstButtonPool();
			int index = FFInsertString(pListPlaced, iSelPlaced, wstrText);
			pListPlaced->SetItemData(index, (DWORD)uiCommandId);
			pListPlaced->SetCurSel(index + 1);
			// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCmMjDoAjHgFiCpAiBeB_xHqqkZx_
			// _xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiCmJjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
			OnPlacedChanged();
			// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAiBeBjEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfI_xHqqkZx_
			// _xZkqqHx_iCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
			UpdateImageList();
		}
		// _xZkqqHx_iMmCiBfIiCmMjCgMiCmMjBiKiKnGiKnGiMfHiCkKjGlDjGlFiPiCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		if (CheckConsistency(GetCurrentToolbarId()))
			GetDlgItem(IDC_TBS_LST_BUTTON_PLACED)->Invalidate();
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
		UpdateActivate();
		// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		UpdateModified();
	}
} // CFCPreToolbar::OnTbsBtnPlace.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnTbsBtnUnplace
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhKjChFiOoGiCoIiPmBiClFiDhLiDfOiDjDiBhF_xHqqkZx_<<_xZkqqHx_iBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::OnTbsBtnUnplace ()
{
	// _xZkqqHx_jGkCjEhKjChFiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPool = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_POOL);
	// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPlaced = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_PLACED);
	int iSelPlaced = pListPlaced->GetCurSel();
	if (iSelPlaced != LB_ERR &&
		iSelPlaced != pListPlaced->GetCount() - 1)
	{
		WString wstrText;
		UINT uiCommandId;
		// _xZkqqHx_iDiKiDfIiDgHiDhLiDgCiDeOiDfIiCkJiCoHiMlLiNnNiCmMjBeJjBpAiNiAjGnKiCpAiNoNiPjMiBeC_xHqqkZx_
		if (myDeleteCurSel(wstrText, uiCommandId, pListPlaced, TRUE))
		//----- _xZkqqHx_iDiKiDfIiDgHiDhLiDgCiDeOiDfIiCkJiCoHiNoNiPjMiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCmMjDoAjHgFiCpAiBeB_xHqqkZx_
			// _xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiCmJjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
			OnPlacedChanged();
			if (uiCommandId != ID_SEPARATOR)
			//----- _xZkqqHx_iNoNiPjMiClDiCoKiClNiCmMiCkKiDfKiDhAiDiMiBfLiDfOiBfLiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
			{
				for (int iC = 0; iC != pListPool->GetCount(); iC++)
				{
					UINT ui = (UINT)pListPool->GetItemData(iC);
					if (ui == 0 || uiCommandId < ui)
					//----- _xZkqqHx_iDfKiDhAiDiMiBfLiDfOiBfLiCkJiBeBiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCkKiCoGiCoIjBoFiCkLiCkCiPoKiNiH_xHqqkZx_ -----
					{
						int index = FFInsertString(pListPool, iC, wstrText);
						pListPool->SetItemData(index, (DWORD)uiCommandId);
						pListPool->SetCurSel(index);
						// _xZkqqHx_iBhFjAnNjCoIiJmCjEfMiCmIiDfCiDhNiDjDiDgIiBhGiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiPiIjHjNiBeC_xHqqkZx_
						OnSelchangeTbsLstButtonPool();
						break;
					}
				}
				// _xZkqqHx_iNmFiMoDiCmJ_xHqqkZx_UINT(-1)_xZkqqHx_iCmMiDfKiDhAiDiMiBfLiDfOiCkKiCkAiCoJiCmMiCmFiBeBjFeLiClIiClLiCmMjBePiCmJjBhNjDpMiClDiCoKiCoJiCmNiClIiBeC_xHqqkZx_
			} else
			//----- _xZkqqHx_iNoNiPjMiClDiCoKiClNiCmMiCkKiDfKiDhAiDiMiBfLiDfOiBfLiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDfKiDhAiDiMiBfLiDfOiBfLiCpAjBeJjBpAiBeC_xHqqkZx_
				pListPool->SetCurSel(pListPool->GetCount() - 1);
				// _xZkqqHx_iBhFjAnNjCoIiJmCjEfMiCmIiDfCiDhNiDjDiDgIiBhGiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiPiIjHjNiBeC_xHqqkZx_
				OnSelchangeTbsLstButtonPool();
			}
			// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAiBeBjEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfI_xHqqkZx_
			// _xZkqqHx_iCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
			UpdateImageList();
		}
		// _xZkqqHx_iMmCiBfIiCmMjCgMiCmMjBiKiKnGiKnGiMfHiCkKjGlDjGlFiPiCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		if (CheckConsistency(GetCurrentToolbarId()))
			GetDlgItem(IDC_TBS_LST_BUTTON_PLACED)->Invalidate();
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
		UpdateActivate();
		// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		UpdateModified();
	}
} // CFCPreToolbar::OnTbsBtnUnplace.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnTbsBtnMoveUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiPoDiCnGiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::OnTbsBtnMoveUp ()
{
	// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPlaced = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_PLACED);
	int iSelPlaced = pListPlaced->GetCurSel();
	if (iSelPlaced != LB_ERR &&
		iSelPlaced != 0 &&
		iSelPlaced != pListPlaced->GetCount() - 1)
	{
		WString wstrText;
		FFGetText(pListPlaced, iSelPlaced, wstrText);
		UINT uiCommandId = (UINT)pListPlaced->GetItemData(iSelPlaced);
		pListPlaced->DeleteString(iSelPlaced);
		iSelPlaced = FFInsertString(pListPlaced, iSelPlaced - 1, wstrText);
		pListPlaced->SetItemData(iSelPlaced, (DWORD)uiCommandId);
		pListPlaced->SetCurSel(iSelPlaced);
		// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCmMjDoAjHgFiCpAiBeB_xHqqkZx_
		// _xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiCmJjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
		OnPlacedChanged();
		// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAiBeBjEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfI_xHqqkZx_
		// _xZkqqHx_iCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
		UpdateImageList();
		// _xZkqqHx_iMmCiBfIiCmMjCgMiCmMjBiKiKnGiKnGiMfHiCkKjGlDjGlFiPiCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		if (CheckConsistency(GetCurrentToolbarId()))
			GetDlgItem(IDC_TBS_LST_BUTTON_PLACED)->Invalidate();
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
		UpdateActivate();
		// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		UpdateModified();
	}
} // CFCPreToolbar::OnTbsBtnMoveUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnTbsBtnMoveDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiJlKiCnGiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::OnTbsBtnMoveDown ()
{
	// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPlaced = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_PLACED);
	int iSelPlaced = pListPlaced->GetCurSel();
	if (iSelPlaced != LB_ERR &&
		iSelPlaced != pListPlaced->GetCount() - 2 &&
		iSelPlaced != pListPlaced->GetCount() - 1)
	{
		WString wstrText;
		FFGetText(pListPlaced, iSelPlaced, wstrText);
		UINT uiCommandId = (UINT)pListPlaced->GetItemData(iSelPlaced);
		pListPlaced->DeleteString(iSelPlaced);
		iSelPlaced = FFInsertString(pListPlaced, iSelPlaced + 1, wstrText);
		pListPlaced->SetItemData(iSelPlaced, (DWORD)uiCommandId);
		pListPlaced->SetCurSel(iSelPlaced);
		// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCmMjDoAjHgFiCpAiBeB_xHqqkZx_
		// _xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiCmJjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
		OnPlacedChanged();
		// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAiBeBjEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfI_xHqqkZx_
		// _xZkqqHx_iCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
		UpdateImageList();
		// _xZkqqHx_iMmCiBfIiCmMjCgMiCmMjBiKiKnGiKnGiMfHiCkKjGlDjGlFiPiCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		if (CheckConsistency(GetCurrentToolbarId()))
			GetDlgItem(IDC_TBS_LST_BUTTON_PLACED)->Invalidate();
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
		UpdateActivate();
		// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		UpdateModified();
	}
} // CFCPreToolbar::OnTbsBtnMoveDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnTbsBtnInitByDefault
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDgGiDhEiDeIiDiLiDgHiCpAjAnNjCoIiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::OnTbsBtnInitByDefault ()
{
	UINT uiToolbarId = GetCurrentToolbarId();
	if (uiToolbarId != UINT(-1))
	{
		// _xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiCmMiBeBiOhHjCoIiClDiCoKiClNiDgDiBfLiDiLiDgPiBfLiCmM_xHqqkZx_
		// _xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiCpAiBeBiDgGiDhEiDeIiDiLiDgHjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
		InitTableByDefault(uiToolbarId);
		// _xZkqqHx_iMlLiNnNiCmMiDgDiBfLiDiLiDgPiBfLiCmJiKoOiCmDiCkCiCmEiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
		OnToolbarChanged();
		// _xZkqqHx_iMmCiBfIiCmMjCgMiCmMjBiKiKnGiKnGiMfHiCkKjGlDjGlFiPiCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		if (CheckConsistency(GetCurrentToolbarId()))
			GetDlgItem(IDC_TBS_LST_BUTTON_PLACED)->Invalidate();
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
		UpdateActivate();
		// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		UpdateModified();
	}
} // CFCPreToolbar::OnTbsBtnInitByDefault.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnTbsBtnInitByCurrent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiMlLiNnNjCgMiCpAjAnNjCoIiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::OnTbsBtnInitByCurrent ()
{
	UINT uiToolbarId = GetCurrentToolbarId();
	if (uiToolbarId != UINT(-1))
	{
		// _xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_->_xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiDgFiBfLiDhFiDiLiCmMiBeBiOhHjCoIiClDiCoKiClNiDgDiBfLiDiLiDgPiBfLiCmM_xHqqkZx_
		// _xZkqqHx_iDfCiDhNiDjDiDgIiIoKjHjHiCpAiBeBiMlLiNnNjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
		InitTableByCurrent(uiToolbarId);
		// _xZkqqHx_iMlLiNnNiCmMiDgDiBfLiDiLiDgPiBfLiCmJiKoOiCmDiCkCiCmEiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
		OnToolbarChanged();
		// _xZkqqHx_iMmCiBfIiCmMjCgMiCmMjBiKiKnGiKnGiMfHiCkKjGlDjGlFiPiCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		if (CheckConsistency(GetCurrentToolbarId()))
			GetDlgItem(IDC_TBS_LST_BUTTON_PLACED)->Invalidate();
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
		UpdateActivate();
		// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		UpdateModified();
	}
} // CFCPreToolbar::OnTbsBtnInitByCurrent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnSelchangeTbsLstButtonPool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjAnNjCoIiJmCjEfMiCmIiDfCiDhNiDjDiDgIiBhGiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::OnSelchangeTbsLstButtonPool ()
{
	// _xZkqqHx_jGkCjEhKjChFiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPool = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_POOL);
	int iSelPool = pListPool->GetCurSel();
	if (iSelPool != LB_ERR)
	{
		UINT uiCommandId = (UINT)pListPool->GetItemData(iSelPool);
		longVector vImageList;
		if (uiCommandId == ID_SEPARATOR)
			vImageList.push_back(CFCStcImageList::SEPARATOR);
		else
		if (FFIsToolbarDropdown(uiCommandId))
			vImageList.push_back(CFCStcImageList::DROPDOWN);
		else
			vImageList.push_back(CommandIdToIndex(uiCommandId));

		m_stcImagePool.SetImageIndexList(&vImageList.at(0), (long)vImageList.size());
		m_stcImagePool.RedrawWindow();
	} else
	{
		m_stcImagePool.SetImageIndexList(NULL, 0);
		m_stcImagePool.RedrawWindow();
	}
	// _xZkqqHx_iMmCiBfIiCmMjCgMiCmMjBiKiKnGiKnGiMfHiCkKjGlDjGlFiPiCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	if (CheckConsistency(GetCurrentToolbarId()))
		GetDlgItem(IDC_TBS_LST_BUTTON_PLACED)->Invalidate();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
	// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	UpdateModified();
} // CFCPreToolbar::OnSelchangeTbsLstButtonPool.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnSelchangeTbsLstButtonPlaced
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjAnNjCoIiClDiCoKiClNiDfCiDhNiDjDiDgIiBhGiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCPreToolbar::OnSelchangeTbsLstButtonPlaced ()
{
	// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPlaced = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_PLACED);
	int iSelPlaced = pListPlaced->GetCurSel();
	if (iSelPlaced != LB_ERR)
		m_stcImageList.SetCurSel(iSelPlaced, TRUE);
	else
		m_stcImageList.SetCurSel(-1, TRUE);
	// _xZkqqHx_iMmCiBfIiCmMjCgMiCmMjBiKiKnGiKnGiMfHiCkKjGlDjGlFiPiCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	if (CheckConsistency(GetCurrentToolbarId()))
		GetDlgItem(IDC_TBS_LST_BUTTON_PLACED)->Invalidate();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
	// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	UpdateModified();
} // CFCPreToolbar::OnSelchangeTbsLstButtonPlaced.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCPreToolbar::OnUserImglstSelchanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDgDiBfLiDiLiDgPiBfLiDeDiDiBiBfLiDfHiBhGiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJ_xHqqkZx_1.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCPreToolbar::OnUserImglstSelchanged (WPARAM wParam, LPARAM lParam)
{
	ASSERT(wParam == IDC_TBS_STC_TOOLBAR_IMAGE);
	// _xZkqqHx_jEhKjChFiNmPiCnNiDfCiDhNiDjDiDgIiCmMiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	CListBox* pListPlaced = (CListBox*)GetDlgItem(IDC_TBS_LST_BUTTON_PLACED);
	long lCurSel = (long)lParam;
	if (lCurSel != -1)
		pListPlaced->SetCurSel(lCurSel);
	else
		pListPlaced->SetCurSel(LB_ERR);
	// _xZkqqHx_iBhFjAnNjCoIiClDiCoKiClNiDfCiDhNiDjDiDgIiBhGiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiPiIjHjNiBeC_xHqqkZx_
	OnSelchangeTbsLstButtonPlaced();
	// _xZkqqHx_iMmCiBfIiCmMjCgMiCmMjBiKiKnGiKnGiMfHiCkKjGlDjGlFiPiCiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	if (CheckConsistency(GetCurrentToolbarId()))
		GetDlgItem(IDC_TBS_LST_BUTTON_PLACED)->Invalidate();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
	// _xZkqqHx_jBkOjAkLiCmJjFmPiNfIiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	UpdateModified();
	return 1;
} // CFCPreToolbar::OnUserImglstSelchanged.

