// SheetListCtrl.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilDlg.h"		// For RightByLeftHand.
#include "UtilStr.h"		// For FFExtractUntil.
#include "UtilWin.h"		// For FFInsertColumn.
#include "RegData.h"		// For FCRegData.
#include "DlgInputStr.h"	// For CFCDlgInputStr.
#include "SheetListCtrl.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


const int FDLL_CURRENT_SHEET_CLM	= 0;
const int FDLL_SHEET_NAME_CLM		= 1;

#define FDLL_CURRENT_SHEET_WIDTH	30		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHjCgMiBeC_xHqqkZx_
#define FDLL_SHEET_NAME_WIDTH		80		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiNmFiPkMjCgMiBeC_xHqqkZx_

/////////////////////////////////////////////////////////////////////////////
// CFCSheetListCtrl

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::CFCSheetListCtrl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCSheetListCtrl::CFCSheetListCtrl ()
{
	m_stidCurrent = 0;		// _xZkqqHx_jFfMiOkGjCiGiDfGiBfLiDgHiBeC_xHqqkZx_
} // CFCSheetListCtrl::CFCSheetListCtrl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::~CFCSheetListCtrl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCSheetListCtrl::~CFCSheetListCtrl ()
{
} // CFCSheetListCtrl::~CFCSheetListCtrl.

/////////////////////////////////////////////////////////////////////////////
// CFCSheetListCtrl _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCSheetListCtrl::Initialize ()
{
	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLjHhAiCmMiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCmMjAnNjCoI_xHqqkZx_ -----
	m_imageList.Create(16, 16, ILC_MASK, 1, 4);
	m_imageList.Add(FFGetApp()->LoadIcon(IDI_CURRENT_MARK));		// Image 0.

	m_imageHeadList.Create(16, 16, ILC_MASK, 2, 4);
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_SHEET_EYE));	// Image 0.
	m_imageHeadList.Add(FFGetApp()->LoadIcon(IDI_NAME_TAG));	// Image 1.

	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMjAnNjCoI_xHqqkZx_ -----
	// _xZkqqHx_iDhEiDeIiBfLiDeKiDfIjGlDiClFiPpDjBnEiCmFiCoAjBeJjBpAiDhNiBfLiDeOiCkKjFfMiOkGiClDiCoKiCoJiCoGiCkEiCmJiDfIiDfOiDeDiDiLjFmPiNfIiBeC_xHqqkZx_
	ModifyStyle(0, LVS_SHOWSELALWAYS);
	// _xZkqqHx_iDeBiDeDiDfCiDjDjFfMiOkGjHhAiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	SetImageList(&m_imageList, LVSIL_SMALL);
	// _xZkqqHx_iDhHiDgCiDfPjHhAiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	CHeaderCtrl* pHdrCtrl= GetHeaderCtrl();
	pHdrCtrl->SetImageList(&m_imageHeadList);

	//----- _xZkqqHx_iDeKiDiJiDiAiCmMjBhNjDpM_xHqqkZx_ -----
	// _xZkqqHx_iMlLiNnN_xHqqkZx_\n_xZkqqHx_iDfGiBfLiDgHjGlMiBeC_xHqqkZx_
	WString strMenuTbl;
	strMenuTbl.LoadString(IDS_SHEET_LIST_CTRL);
	FFInsertColumn(this, FDLL_CURRENT_SHEET_CLM,::FFExtractUntil(strMenuTbl, L"\n"), LVCFMT_LEFT, 60);
	FFInsertColumn(this, FDLL_SHEET_NAME_CLM,   ::FFExtractUntil(strMenuTbl, L"\n"), LVCFMT_LEFT, 200);
	//----- _xZkqqHx_iDeKiDiJiDiAiCmJiDeBiDeDiDfCiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	HD_ITEM curItem;
	for (int iC = 0; iC < pHdrCtrl->GetItemCount(); iC++)
	{
// 01.07.08 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		pHdrCtrl->GetItem(iC, &curItem);
		curItem.mask= HDI_IMAGE | HDI_FORMAT;
		curItem.iImage= iC;
		curItem.fmt= HDF_CENTER | HDF_IMAGE | HDF_STRING | HDF_BITMAP;
		pHdrCtrl->SetItem(iC, &curItem);
	}
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFjNiCmJiNiHiCoNiClJiCmEiDeKiDiJiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateColumnWidth();
} // CFCSheetListCtrl::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::UpdateColumnWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFjNiCmJiNiHiCoNiClJiCmEiDeKiDiJiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeKiDiJiDiAiCmMjAnNjCoIiCpAiPeJiCoNiCoHiClJiCmEiCkJiCoHiOmAiNhDiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCSheetListCtrl::UpdateColumnWidth ()
{
	//----- _xZkqqHx_iDeKiDiJiDiAiCmMjAnNjCoI_xHqqkZx_ -----
	CRect rect;
	GetClientRect(rect);
	// _xZkqqHx_iDfGiBfLiDgHjGlMiCmMjClHiClDiCpAiMhGiOfKiBeC_xHqqkZx_
	long lSheetNameWidth = rect.Width() - FDLL_CURRENT_SHEET_WIDTH;
	// _xZkqqHx_iNmFjCoBiCmMiDfGiBfLiDgHjGlMjClHiCpAiJlKiJpBiCoHiCmIiCkCiCoGiCkEiCmJiBeC_xHqqkZx_
	if (lSheetNameWidth < FDLL_SHEET_NAME_WIDTH)
		lSheetNameWidth = FDLL_SHEET_NAME_WIDTH;
	// _xZkqqHx_iOgDiCoIiCmMiDeKiDiJiDiAjClHiCpAjAnNjCoIiBeC_xHqqkZx_
	SetColumnWidth(FDLL_CURRENT_SHEET_CLM, FDLL_CURRENT_SHEET_WIDTH);
	SetColumnWidth(FDLL_SHEET_NAME_CLM, lSheetNameWidth);
} // CFCSheetListCtrl::UpdateColumnWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::SetCurrentSheetId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stid	:_xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCSheetListCtrl::SetCurrentSheetId (SheetID stid)
{
	// _xZkqqHx_jFmPiNfIjGlDiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
	if (m_stidCurrent == stid) return;
	long lCurIdx = ItemDataToIndex(m_stidCurrent);
	// _xZkqqHx_iMmDiCkCjFfMiOkGjCiGiDfGiBfLiDgHiCmMiNmEjFgAiJoGjHmMiIoGjAnNjCoIiBeC_xHqqkZx_
	RedrawItems(lCurIdx, lCurIdx);
	// _xZkqqHx_jFfMiOkGjCiGiDfGiBfLiDgHiCmMjAnNjCoIiBeC_xHqqkZx_
	m_stidCurrent = stid;
	lCurIdx = ItemDataToIndex(m_stidCurrent);
	// _xZkqqHx_jAfGiClFiCkCjFfMiOkGjCiGiDfGiBfLiDgHiCmMiNmEjFgAiJoGjHmMiIoGjAnNjCoIiBeC_xHqqkZx_
	RedrawItems(lCurIdx, lCurIdx);
	// _xZkqqHx_iKePjFjEiCkJiCoHiCmMiOmAiNhDiCmIiCmMiCmFiBeBiDfGiBfLiDgHiCmMjFmPiNfIiCmNjCmKjCgNiClFiCmIiCkCiBeC_xHqqkZx_
} // CFCSheetListCtrl::SetCurrentSheetId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::GetCurrentSheetId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD CFCSheetListCtrl::GetCurrentSheetId () const
{
	return m_stidCurrent;
} // CFCSheetListCtrl::GetCurrentSheetId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::AppendRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDfCiBfLiDgIiCmMiDfCiDhDiBfLiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_iDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			rec		:_xZkqqHx_iDiMiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCSheetListCtrl::AppendRec (DWORD dwId, const FCSheetCtrlRec& rec)
{
	m_mpIdToRec[dwId] = SheetCtrlRecAuto(new FCSheetCtrlRec(rec));
} // CFCSheetListCtrl::AppendRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::SetIdOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCmMjFfMiOkGiPiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIdSz	:dwId_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDiMiDfCiBfLiDgIiCmMiPiHjEnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCSheetListCtrl::SetIdOrder (DWORD dwIdSz, const DWORD dwId[])
{
	// _xZkqqHx_jBfDiCmEiCmMiDeBiDeDiDgFiDiAiCpAiNoNiPjMiBgJiDiMiDfCiBfLiDgIiCmNiNoNiPjMiClFiCmIiCkCiBgKiBeC_xHqqkZx_
	DeleteAllItems();
	for (DWORD dwC = 0; dwC != dwIdSz; dwC++)
	{
		// LastItem_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		CListCtrl::InsertItem(dwC, _T(""));
		SetItemData(dwC, dwId[dwC]);
	}
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	UpdateItemSize();
	UpdateScrollSize(TRUE);
} // CFCSheetListCtrl::SetIdOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::GetIdOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCmMjFfMiOkGiPiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vstid	:stid_xZkqqHx_iCmMjFfMiOkGiPiHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCSheetListCtrl::GetIdOrder (FDSheetIDVector& vstid) const
{
	vstid.clear();
	for	(long lIndex = 0; lIndex != GetItemCount(); lIndex++)
	{
		vstid.push_back(GetItemData(lIndex));
	}
} // CFCSheetListCtrl::GetIdOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::GetRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_ID_xZkqqHx_iCmMiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCSheetCtrlRec* CFCSheetListCtrl::GetRec (DWORD dwId) const
{
	return (*m_mpIdToRec.find(dwId)).second.get();
} // CFCSheetListCtrl::GetRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::CanDeleteItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCmFiBeBiDeBiDeDiDgFiDiAiCpAiNoNiPjMiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCSheetListCtrl::CanDeleteItem () const
{
	if (!BASE_CLASS::CanDeleteItem()) return FALSE;
	long lFrontSelected;
	long lMidSelected;
	long lBackSelected;
	GetSelectedCount(lFrontSelected, lMidSelected, lBackSelected);
	// _xZkqqHx_iDfGiBfLiDgHiCkKiIoKiCmCiCoAiOgDiCoHiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (GetItemCount() == lFrontSelected + lMidSelected + lBackSelected) return FALSE;
	return TRUE;
} // CFCSheetListCtrl::CanDeleteItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::GetSubMenuIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiPpAiMiPiCmFiDhMiDgCiDhGiDeBiDgCiDhGiClHiCoJiDiBiDgKiDiFiBfLiCmMiBeB_xHqqkZx_IDR_RBTN_MULTI_xZkqqHx_iCmMjCiGiCmJ_xHqqkZx_
 *			_xZkqqHx_iCkIiCkPiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_iPpAiMiPiCpAiOhHjCoIiBeCjCmKiPoNiOjOiCmMiDhMiDgCiDhGiDeBiDgCiDhGiCmN_xHqqkZx_ 0_xZkqqHx_iBeBiDeBiDeDiDgFiDiAiInKjDkOjCiGiCmM_xHqqkZx_
 *				 _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiCmN_xHqqkZx_ 1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCSheetListCtrl::GetSubMenuIndex (long lId) const
{
	if (lId == 0) return FD_MENU_MULT_SHEET_STATIC;
	return FD_MENU_MULT_SHEET_MOVING;
} // CFCSheetListCtrl::GetSubMenuIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::OnInsertItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMjBhNjDpMiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_jBhNjDpMiImKjChFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_jBhNjDpMiClDiCoKiCoJiDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBhNjDpMiDeBiDeDiDgFiDiAiCkKiNoMjAkMiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_	FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCSheetListCtrl::OnInsertItem (long lIndex, DWORD dwId)
{
//----- 01.11.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FCSheetCtrlRec rec;
//	// "_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_n"
//	rec.strName.Format(_T("%s%d"), ::GetResWString(IDS_UNTITLED_SHEET), dwId + 1);
//	m_mpIdToRec[dwId] = SheetCtrlRecAuto(new FCSheetCtrlRec(rec));
//	return TRUE;
//----- 01.11.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	//----- _xZkqqHx_iKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJjGlMjBePiCmMiIoKjHjHiCpAiOoGjDlO_xHqqkZx_ -----
	WStringSet stNameList;
	IdToSheetCtrlRecMap::const_iterator iRc;
	for (iRc = m_mpIdToRec.begin(); iRc != m_mpIdToRec.end(); iRc++)
		stNameList.insert((const wchar_t*)(*iRc).second->strName);

	//----- _xZkqqHx_iCnMiClOjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCjGlMjBePiCpAiNoMjAkMiClHiCoJ_xHqqkZx_ -----
	WString strName;
	for (long lC = 1;; lC++)
	{
		// "_xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_n"
		strName.Format(L"%s%d", ::GetResWString(IDS_UNTITLED_SHEET), lC);
		if (stNameList.find((const wchar_t*)strName) == stNameList.end()) break;
	}

	//----- _xZkqqHx_iNoMjAkMiClFiClNjGlMjBePiCmFiDiMiDfCiBfLiDgIiCpAjDgPjIfO_xHqqkZx_ -----
	FCSheetCtrlRec rec;
	// "_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_n"
	rec.strName = strName;
	m_mpIdToRec[dwId] = SheetCtrlRecAuto(new FCSheetCtrlRec(rec));
	return TRUE;
//----- 01.11.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCSheetListCtrl::OnInsertItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::OnChangeItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMjFmPiNfIiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKjFmPiNfIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_	FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCSheetListCtrl::OnChangeItem (long lIndex, DWORD dwId)
{
	// _xZkqqHx_jGlMjBePiCpAiDfPiDeDiDeBiDiNiDePiCmFjAnNjCoIiBeC_xHqqkZx_
	CFCDlgInputStr dlgStr;
	// "_xZkqqHx_jDgPjIfOjGlMiCpAjDpMjHmNiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_";
	dlgStr.m_strTitle.LoadString(IDS_MSG_INPUT_ENTRY_NAME);
	dlgStr.m_strInput = GetRec(dwId)->strName;
	if (dlgStr.DoModal() != IDOK) return FALSE;
	(*m_mpIdToRec[dwId].get()).strName = TStrToWStr(dlgStr.m_strInput);
	return TRUE;
} // CFCSheetListCtrl::OnChangeItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::OnDeleteItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmMiNoNiPjMiBhGiCmMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKiNoNiPjMiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPgPjHiIiCmIiCkCiPoKiNiHiCmN_xHqqkZx_	FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCSheetListCtrl::OnDeleteItem (long lIndex, DWORD dwId)
{
	if (dwId == m_stidCurrent)
	{
		long lIndex = ItemDataToIndex(m_stidCurrent);
		if (GetItemCount() - 1 == lIndex)
			m_stidCurrent = GetItemData(lIndex - 1);
		else
			m_stidCurrent = GetItemData(lIndex + 1);
	}
	m_mpIdToRec.erase(dwId);
	return TRUE;
} // CFCSheetListCtrl::OnDeleteItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolBaseFDA.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMessage	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCommand	:_xZkqqHx_iDfCiDhNiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCSheetListCtrl::TransFDA (long lState, DWORD dwMessage, DWORD dwCommand)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	long lNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeBiDeDiDgFiDiAiCkKjGlDiCkCiPoKiNiHiCmNiDfPiDiBiBeC_xHqqkZx_
//	if (GetItemCount() == 0) return lNextState;
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (lState)
	{
	case STATE_IDLE:				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		switch (dwMessage)
		{
		case WM_LBUTTONDOWN:		// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			if (PointToColumn(NULL, m_ptMsc) != FDLL_SHEET_NAME_CLM)
				lNextState = STATE_CLICK_NOT_NAME_COLUMN;		// _xZkqqHx_iDfGiBfLiDgHjGlMiImIiKePiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
			break;
		}
		break;

	case STATE_CLICK_NOT_NAME_COLUMN:	// _xZkqqHx_iDfGiBfLiDgHjGlMiImIiKePiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (lNextState == STATE_NONE)
		lNextState = BASE_CLASS::TransFDA(lState, dwMessage, dwCommand);
	return lNextState;
} // CFCSheetListCtrl::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCSheetListCtrl::StateFDA (long lState)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (lState)
	{
	case STATE_CLICK_NOT_NAME_COLUMN:		// _xZkqqHx_iDfGiBfLiDgHjGlMiImIiKePiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
		StateClickNotNameColumn();
		break;
	default:
		BASE_CLASS::StateFDA(lState);
	}
} // CFCSheetListCtrl::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::StateClickNotNameColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDfGiBfLiDgHjGlMiImIiKePiDeOiDiKiDgCiDeOiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCSheetListCtrl::StateClickNotNameColumn ()
{
	TRACE(_T("CFCSheetListCtrl::StateClickNotNameColumn\r\n"));
	long lIndex;
	if (PointToColumn(&lIndex, m_ptMsc) == FDLL_CURRENT_SHEET_CLM)
	//----- _xZkqqHx_jFfMiOkGjCiGiDfGiBfLiDgHiCpAiJjPiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		if (0 <= lIndex && m_stidCurrent != GetItemData(lIndex))
		{
			// _xZkqqHx_iMmDiCkCjFfMiOkGjCiGiDfGiBfLiDgHiCmMiNmEjFgAiJoGjHmMiIoGjAnNjCoIiBeC_xHqqkZx_
			long lCurIdx = ItemDataToIndex(m_stidCurrent);
			RedrawItems(lCurIdx, lCurIdx);
			RedrawItems(lIndex, lIndex);
			m_stidCurrent = GetItemData(lIndex);
			// _xZkqqHx_iDfGiBfLiDgHiCmMjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
			GetParent()->PostMessage(WM_USER_MULTICTRL_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
		}
	}
} // CFCSheetListCtrl::StateClickNotNameColumn.

BEGIN_MESSAGE_MAP(CFCSheetListCtrl, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCSheetListCtrl)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCSheetListCtrl _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCSheetListCtrl::DrawItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiBfLiDgJiBfLjFgAiJoGiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiPoDiCmMiKePiKmPiCkKjFmPiJlLiClFiClNiCmGiCkLiCmJ_xHqqkZx_
 *			_xZkqqHx_iMmEiCnBiPgPiClDiCoKiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpDIS	:_xZkqqHx_jHhGiLiBiClDiCoKiClNjFgAiJoGiCmMiMfOiCmJiCmCiCkCiCmEiCmMiPoOjFpBiCpAiOjNiCmC_xHqqkZx_
 *					 DRAWITEMSTRUCT _xZkqqHx_iNfMjBkCjBmMiCnGiCmM_xHqqkZx_ long _xZkqqHx_iDhMiDeDiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCSheetListCtrl::DrawItem (LPDRAWITEMSTRUCT lpDIS)
{
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	CDC* pDC = CDC::FromHandle(lpDIS->hDC);
	FCAutoDC atDC(pDC, TRUE, 0, 0);

	CRect rtLabel;
	GetSubItemRect(lpDIS->itemID, 1, LVIR_LABEL, rtLabel);

//----- 06.10.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	WString wstrItem;
	wstrItem.Format(L"%ld. %s",
					(long)lpDIS->itemID + 1,
					GetRec(lpDIS->itemData)->strName.c_str());
//----- 06.10.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	if (lpDIS->itemState & ODS_SELECTED)
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDCSub(pDC, FALSE, 0, 0);
		atDCSub.FillRect(&lpDIS->rcItem, FCAtBrush(::GetSysColor(COLOR_HIGHLIGHT)));
		// _xZkqqHx_iDgFiDeMiDfIiDgHjElNjDfNjAeGiBeC_xHqqkZx_
		atDCSub.SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		atDCSub.DrawText(GetRec(lpDIS->itemData)->strName, CP_ACP, rtLabel,
//						DT_CENTER|DT_VCENTER|DT_SINGLELINE);
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		atDCSub.DrawText(wstrItem, CP_ACP, rtLabel,
						DT_LEFT|DT_VCENTER|DT_SINGLELINE);
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	} else
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDCSub(pDC, FALSE, 0, 0);
		// _xZkqqHx_jCmKiPoNiCmMjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
		atDCSub.FillRect(&lpDIS->rcItem, FCAtBrush(pDC->GetBkColor()));
		atDCSub.SetTextColor(::GetSysColor(COLOR_WINDOWTEXT));
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		atDCSub.DrawText(GetRec(lpDIS->itemData)->strName, CP_ACP, rtLabel,
//						DT_CENTER|DT_VCENTER|DT_SINGLELINE);
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		atDCSub.DrawText(wstrItem, CP_ACP, rtLabel,
						DT_LEFT|DT_VCENTER|DT_SINGLELINE);
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	if (GetItemState(lpDIS->itemID, LVIS_CUT) == LVIS_CUT)
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDCSub(pDC, FALSE, 0, 0);
		atDCSub.SetTextColor(::GetSysColor(COLOR_INACTIVECAPTION));
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		atDCSub.DrawText(GetRec(lpDIS->itemData)->strName, CP_ACP, rtLabel,
//						DT_CENTER|DT_VCENTER|DT_SINGLELINE);
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		atDCSub.DrawText(wstrItem, CP_ACP, rtLabel,
						DT_LEFT|DT_VCENTER|DT_SINGLELINE);
//----- 06.10.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		atDCSub.DrawFocusRect(&lpDIS->rcItem);
	}
	if (lpDIS->itemData == m_stidCurrent)
	{
		CImageList* pImg = GetImageList(LVSIL_SMALL);
		// _xZkqqHx_iOiLjDfPiCmMjFgAiJoGjIgHiCpAiOoGjDlOiBeC_xHqqkZx_
		CRect rtEye;
		CListCtrl::GetItemRect(lpDIS->itemID, rtEye, LVIR_BOUNDS);
		rtEye.right = rtEye.left + GetColumnWidth(0);
		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNoMjAkMiBeC_xHqqkZx_
		CRgn rgn;
		rgn.CreateRectRgn(rtEye.left, rtEye.top, rtEye.right, rtEye.bottom);
		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeCiDiKiBfLiDfHiDiHiDjDiCmNiDfCiDhDiBfLiClDiCoKiCoJiCmMiCmFiBeBiDeJiDiKiDfHiDgJiDiLiCmNiNoNiPjMiClFiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
		atDC.SetClipRgn(&rgn);
		long lx = (rtEye.Width() - 16) / 2;
		if (lx < 0) lx = 0;
		long ly = (rtEye.Height() - 16) / 2;
		if (ly < 0) ly = 0;
		if (lpDIS->itemState & ODS_SELECTED)
			pImg->Draw(pDC, 0, CPoint(rtEye.left + lx, rtEye.top + ly), ILD_SELECTED);
		else
			pImg->Draw(pDC, 0, CPoint(rtEye.left + lx, rtEye.top + ly), ILD_TRANSPARENT);
	}
} // CFCSheetListCtrl::DrawItem.

