// StcDIBImage.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "dynamicdraw.h"
#include "StcDIBImage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCStcDIBImage

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcDIBImage::CFCStcDIBImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCStcDIBImage::CFCStcDIBImage ()
{
} // CFCStcDIBImage::CFCStcDIBImage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcDIBImage::~CFCStcDIBImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCStcDIBImage::~CFCStcDIBImage ()
{
} // CFCStcDIBImage::~CFCStcDIBImage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcDIBImage::SetImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiClHiCoJiDeDiDiBiBfLiDfHiDgGiBfLiDfOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	szImage			:_xZkqqHx_iDeDiDiBiBfLiDfHiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pImageData		:_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lImageDataSize	:_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeDiDiBiBfLiDfHjAnNjCoIiMoDiBeBjFfMiOkGiCmNjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcDIBImage::SetImage (const CSize& szImage,
							const BYTE* pImageData, long lImageDataSize)
{
	m_szImage = szImage;
	m_vImageData.clear();
	m_vImageData.insert(m_vImageData.begin(), pImageData, pImageData + lImageDataSize);
	Invalidate();
} // CFCStcDIBImage::SetImage.

BEGIN_MESSAGE_MAP(CFCStcDIBImage, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCStcDIBImage)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCStcDIBImage _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcDIBImage::OnPaint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJoGjGmKjFfMiOkGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcDIBImage::OnPaint ()
{
	CRect rtClient;
	GetClientRect(rtClient);
	CPaintDC dc(this); // _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_
	if (m_vImageData.empty())
	{
		// _xZkqqHx_jEhHiMgJiCmFjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
		dc.FillRect(rtClient, &CBrush(GetSysColor(COLOR_3DFACE)));
	} else
	{
		BITMAPINFO bmi;
		ZeroMemory(&bmi, sizeof(BITMAPINFO));
		bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
		bmi.bmiHeader.biWidth = m_szImage.cx;
		// _xZkqqHx_iPoDiCkJiCoHiJlKiCnGiCmM_xHqqkZx_DIB_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_biHeight_xZkqqHx_iCkKjFiJiCmMjCgMiBeC_xHqqkZx_
		bmi.bmiHeader.biHeight = -m_szImage.cy;
		bmi.bmiHeader.biPlanes = 1;
		bmi.bmiHeader.biBitCount = 32;
		bmi.bmiHeader.biCompression = BI_RGB;
		bmi.bmiHeader.biSizeImage = m_szImage.cx * m_szImage.cy * 4;

		int iVal = ::StretchDIBits(dc.m_hDC,
							0, 0, rtClient.Width(), rtClient.Height(),
							0, 0, m_szImage.cx, m_szImage.cy,
							m_vImageData.begin(), &bmi,
							DIB_RGB_COLORS, SRCCOPY);
	}
	// _xZkqqHx_jFgAiJoGjHhAiDiBiDgCiDfKiBfLiDfHiCmGiClFiCmE_xHqqkZx_ CStatic::OnPaint() _xZkqqHx_iCpAiMmEiCnBiPgPiClFiCmEiCmNiCkCiCkPiCnMiClJiCpB_xHqqkZx_
} // CFCStcDIBImage::OnPaint.
