// TextOut.cpp

#include "stdafx.h"
#include "DynamicDrawView.h"	// For g_pView.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilMisc.h"			// For M_PI.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilFile.h"		// For BYTEVector <<.
#include "UtilStr.h"		// For GetTChar.
#include "RegData.h"		// For FCRegData.
#include "TextOut.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

typedef vector<int>	intVector;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTextLineInfo::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vStream	:_xZkqqHx_iPgPjHmNjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTextLineInfo::OutStream (BYTEVector& vStream) const
{
	vStream << dwMask;				// _xZkqqHx_jHeMiMpIiDiBiDjDiDgPjFmPjAjEiCmMiDhNiDfIiDeOiBeC_xHqqkZx_
	vStream << mmStartIndent;		// _xZkqqHx_jAoGjDkKiNhDiCmMiNlGiDeDiDjDiDgGiDjDiDgHiBeC_xHqqkZx_
	vStream << mmRightIndent;		// _xZkqqHx_jAoGjDkKiBeFiMhAjBlBiNhDiCmMiJeFiDeDiDjDiDgGiDjDiDgHiBeC_xHqqkZx_
	vStream << mmOffset;			// _xZkqqHx_iMhAjBlBiNhDiCmMiDeDiDjDiDgGiDjDiDgHiBgJjAoGjDkKiNhDiCmJjBmOiClHiCoJiDeJiDhEiDfKiDgCiDgHjCgMiBgK_xHqqkZx_
	//----- _xZkqqHx_iDfOiDhFjEhKjHpB_xHqqkZx_ -----
	::WriteVSizeU(vStream, mmvTabs.size());
	mmetolVector::const_iterator iTab;
	for (iTab = mmvTabs.begin(); iTab != mmvTabs.end(); iTab++)
		vStream << *iTab;
	vStream << byAlignment;			// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgHiBgJiNlGjCiGiJjLiJeFiKpBiClJiBgK_xHqqkZx_
	vStream << nTwipLineAfter;		// _xZkqqHx_iNhDiKnEiBgJiNhDiCmMiJlKiBgKiCmM_xHqqkZx_TWIPS_xZkqqHx_jAjEiBeC_xHqqkZx_
} // FCTextLineInfo::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTextLineInfo::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiCkJiCoHjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pData	:_xZkqqHx_jDpMjHmNiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTextLineInfo::InStream (const BYTE*& pData)
{
	::FFReadData(dwMask, pData);				// _xZkqqHx_jHeMiMpIiDiBiDjDiDgPjFmPjAjEiCmMiDhNiDfIiDeOiBeC_xHqqkZx_
	::FFReadData(mmStartIndent, pData);		// _xZkqqHx_jAoGjDkKiNhDiCmMiNlGiDeDiDjDiDgGiDjDiDgHiBeC_xHqqkZx_
	::FFReadData(mmRightIndent, pData);		// _xZkqqHx_jAoGjDkKiBeFiMhAjBlBiNhDiCmMiJeFiDeDiDjDiDgGiDjDiDgHiBeC_xHqqkZx_
	::FFReadData(mmOffset, pData);			// _xZkqqHx_iMhAjBlBiNhDiCmMiDeDiDjDiDgGiDjDiDgHiBgJjAoGjDkKiNhDiCmJjBmOiClHiCoJiDeJiDhEiDfKiDgCiDgHjCgMiBgK_xHqqkZx_
	//----- _xZkqqHx_iDfOiDhFjEhKjHpB_xHqqkZx_ -----
	DWORD dwTabSz = ::ReadVSizeU(pData);
	mmvTabs.resize(dwTabSz);
	for (long lC = 0; lC < mmvTabs.size(); lC++)
		::FFReadData(mmvTabs[lC], pData);		// _xZkqqHx_iDfOiDhFjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
	::FFReadData(byAlignment, pData);			// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgHiBgJiNlGjCiGiJjLiJeFiKpBiClJiBgK_xHqqkZx_
	::FFReadData(nTwipLineAfter, pData);		// _xZkqqHx_iNhDiKnEiBgJiNhDiCmMiJlKiBgKiCmM_xHqqkZx_TWIPS_xZkqqHx_jAjEiBeC_xHqqkZx_
} // FCTextLineInfo::InStream.

FCUTLeftRight::FCUTLeftRight (mmetol l, mmetol r)
	: mmLeft(l), mmRight(r)
{
} // FCUTLeftRight::FCUTLeftRight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTextOut::FCTextOut
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dAngle		:_xZkqqHx_iDgFiDeMiDfIiDgHiJpBjDfNiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptCenter	:_xZkqqHx_iDgFiDeMiDfIiDgHiJpBjDfNiCmMjCiGjAfDiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTextOut::FCTextOut (double dAngle, const DBLPoint& mmptCenter)
{
	if (almost0(dAngle))
	//----- _xZkqqHx_iKhAjDhIiCkK_xHqqkZx_0_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_dAngle = 0.0;
		m_dSin = 0.0;
		m_dCos = 1.0;
	} else
	//----- _xZkqqHx_iKhAjDhIiCkK_xHqqkZx_0_xZkqqHx_iImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_dAngle = dAngle;
		m_dSin = sin(m_dAngle * M_PI);
		m_dCos = cos(m_dAngle * M_PI);
	}
	m_mmptCenter = mmptCenter;
} // FCTextOut::FCTextOut.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTextOut::ClearText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDoAjFjEiDgFiDeMiDfIiDgHiPoOjFpBiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTextOut::ClearText ()
{
	m_vTextLR.clear();
	m_vTextX.clear();
	m_vChar.clear();
} // FCTextOut::ClearText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTextOut::StockChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAjFlGiOjKiCpAiDfIiDgHiDgCiDeOiClHiCoJiBeCiDfIiDgHiDgCiDeOiClDiCoKiClNiDgFiDeMiDfIiDgHiCmNiBeB_xHqqkZx_FlushText_xZkqqHx_iCnMiCmF_xHqqkZx_
 *			_xZkqqHx_jFgAiJoGiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wChar		:_xZkqqHx_jFlGiOjKiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmX			:_xZkqqHx_jFlGiOjKjFgAiJoGiImKjChFiCmMiChHiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmLeft		:_xZkqqHx_jFlGiOjKiCmMjFgAiJoGjEmNiImNiCmMiNlGiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_mmX_xZkqqHx_iCmN_xHqqkZx_mmLeft_xZkqqHx_iCmMiJeFiCmJiCkNiCoJ_xHqqkZx_
 *						 _xZkqqHx_iPoKiNiHiCoAiCkAiCoJiClNiCnPiBeBjFgAiJoGjEmNiImNiCpAjCgNiCoJiCmJiCmNiClBiCmMiPoOjFpBiCkKjFeLjHhGiBeC_xHqqkZx_
 *			mmRight		:_xZkqqHx_jFlGiOjKiCmMjFgAiJoGjEmNiImNiCmMiJeFiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmY			:_xZkqqHx_jFlGiOjKjFgAiJoGiImKjChFiCmMiChIiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmHeight	:_xZkqqHx_jFlGiOjKiNiCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			byUnderline	:_xZkqqHx_iJlKjApMiCmMiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			byStrkeOut	:_xZkqqHx_iOoGiPmBiClFjApMiCmMiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			foid		:_xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiJlKjApMiBeFiOoGiPmBiClFjApMiCmMiImKjChFiCpAiOoGjDlOiClHiCoJ_xHqqkZx_
 *						 _xZkqqHx_iClHiCoJiClNiCnPiCmJjFeLjHhGiBeC_xHqqkZx_
 *			wOffset		:_xZkqqHx_jFlGiOjKiDeJiDhEiDfKiDgCiDgHiCpAiOhHjCoIiBeCiJlKjApMiBeFiOoGiPmBiClFjApMiCmMiImKjChFiCpAiOoGjDlOiClHiCoJ_xHqqkZx_
 *						 _xZkqqHx_iClHiCoJiClNiCnPiCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTextOut::StockChar (wchar_t wChar, mmetol mmX, mmetol mmLeft, mmetol mmRight,
							mmetol mmY, mmetol mmHeight,
							BYTE byUnderline, BYTE byStrikeOut,
							SFontID foid, WORD wOffset)
{
	m_vChar.push_back(wChar);
	m_vTextX.push_back(mmX);
	m_vTextLR.push_back(FCUTLeftRight(mmLeft, mmRight));
	m_mmY = mmY;
	m_mmHeight = mmHeight;
	m_byUnderline = byUnderline;
	m_byStrikeOut = byStrikeOut;
	m_foid = foid;
	m_wOffset = wOffset;
} // FCTextOut::StockChar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTextOut::FlushText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmJjHkNiCnPiNjOiCpBiClOiDgFiDeMiDfIiDgHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	atDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmX		:_xZkqqHx_iNmFiMoDiCmMjFlGiOjKiCmMiOjPiCmMjFgAiJoGiImKjChFiCpAiOhHjCoIiBeCjFlGiOjKjFgAiJoGiCmJiCmNjGnKiImAjCpGjDhI_xHqqkZx_
 *					 _xZkqqHx_iCmMjCgMiCmFjHmHiCkCiCkKiBeBiJlKjApMiBeFiOoGiPmBiClFjApMiCmMiJeFjCfLiNmAjFfHiCmGiClFiCmEiCoA_xHqqkZx_
 *					 _xZkqqHx_iOgHiCoNiCoKiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			wCodePage:_xZkqqHx_jFgAiJoGiClHiCoJjFlGiOjKjHpBiCmMiDfCiBfLiDgIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	95,98_xZkqqHx_iDhIiBfLiDfIiCmMiPoKiNiHiBeB_xHqqkZx_CMetaFileDC_xZkqqHx_iCmMiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiNoMjAkMiCmJiDgPiDePiCkK_xHqqkZx_
 *			_xZkqqHx_iCkAiCoJiClNiCnPiBeB_xHqqkZx_SetViewportExtEx_xZkqqHx_jDjJiCmFjEhLjHkGiCpAiPoDiClAiClNiPpDjBnEiCmF_xHqqkZx_ExtTextOut_xZkqqHx_iCmJ_xHqqkZx_
 *			pDxWidths_xZkqqHx_iCpAiOhHjCoIiClFiCmEiBeBjClHiCkCiDgFiDeMiDfIiDgHiCpAjFgAiJoGiClDiClJiCoGiCkEiCmGiClHiCoJiCmGiBeB_xHqqkZx_
 *			_xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLjCiGiCmMjFfMiOkGiNmAjFfHiPoOjFpBiCkKiJpDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *			ENMETA.EXE(C++_xZkqqHx_iDfEiDjDiDhGiDiL_xHqqkZx_)_xZkqqHx_iCmFiKgNjEeGiClFiClNiBeC_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKjHpBiCmNjDkPiClGiDfCiBfLiDgIiDhJiBfLiDfHiCmJjBkOiClFiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.13 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
// 02.08.16 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)
//void FCTextOut::FlushText (FCAutoDC& atDC, mmetol mmX)
void FCTextOut::FlushText (FCAutoDC& atDC, mmetol mmX, WORD wCodePage)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCkKjHkNiCnMiCmBiCmEiCkCiCmIiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
	if (m_vChar.empty()) return;
	// mmX_xZkqqHx_iDgPiDgCiDhEiDeAiCmJiBeBiNmFiMoDiCmMiDgFiDeMiDfIiDgHjFjNiCpAiMhGiOfKiClHiCoJiClNiCnPiCmM_xHqqkZx_mmX_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
	m_vTextX.push_back(mmX);

	if (!almost0(m_dAngle) || g_pReg->GetEditDrawText() == 1)
	//----- _xZkqqHx_iJpBjDfNiClFiCmEiCkCiCoJiCkJiBeB_xHqqkZx_TextOut_xZkqqHx_iKnGjAjEiPgPjHmNiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iCfAjFlGiOjKiCmDiCmC_xHqqkZx_Text_xZkqqHx_iPgPjHmNiBeC_xHqqkZx_
// 02.08.16 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)
//		FlushText1By1(atDC);
		FlushText1By1(atDC, wCodePage);
		return;
	}

	// ExtTextOut_xZkqqHx_iCmMjFlGiOjKiKnEjFjNiOhHjCoIiIpIjAjEjHhAiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
	intVector viDxWidths;
	// _xZkqqHx_jFgAiJoGjHhAjFlGiOjKjHpBiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
	WString strText;
	// _xZkqqHx_jFlGiOjKjFgAiJoGiKeKiOgOiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
	long lStart = -1;
	for (long lC = 0; lC < m_vChar.size(); lC++)
	{
		DBLRect mmrtText(m_vTextLR[lC].mmLeft, m_mmY,
						m_vTextLR[lC].mmRight, m_mmY + m_mmHeight);
		if (g_pView->IsRgnOverlap(mmrtText))
		//----- _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmGiDgFiDeMiDfIiDgHiCkKiPgEiCmIiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFlGiOjKjFgAiJoGiKeKiOgOiDeKiDeFiDjDiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
			if (lStart < 0) lStart = lC;
			// _xZkqqHx_jFlGiOjKiKnEjFjNiCpAiMhGiOfKiBeCjAoGiCmJjIfPjHjNiNmAjFfHiCmJiClFiCmEiCkIiCkJiCmIiCkCiCmGiBeB_xHqqkZx_
			// _xZkqqHx_iDeHiDgGiDeCiDfOiCmMjFfMiOkGiImKjChFiCmGiDfJiDiMiCkKjAlGiClGiCoJiBeC_xHqqkZx_
			long lW = mm2lg(m_vTextX[lC + 1]) - mm2lg(m_vTextX[lC]);
//----- 02.02.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			_TCHAR szBuff[3];
//			long lStrLen;
//			GetTChar(szBuff, lStrLen, m_vChar[lC]);
//			// _xZkqqHx_jFlGiOjKiCpAiDgFiDeMiDfIiDgHiDgPiDgCiDhEiDeAiCmJjCmHiJmBiBeC_xHqqkZx_
//			strText += szBuff;
//			// _xZkqqHx_jFlGiOjKiKnEjFjNiCpAiDgPiDgCiDhEiDeAiCmJjCmHiJmBiBeC_xHqqkZx_
//			if (lStrLen == 1)
//			{
//				viDxWidths.push_back(lW);
//			} else
//			{
//				viDxWidths.push_back(lW / 2);
//				viDxWidths.push_back(lW - viDxWidths.back());
//			}
//----- 02.02.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			// _xZkqqHx_jFlGiOjKiCpAiDgFiDeMiDfIiDgHiDgPiDgCiDhEiDeAiCmJjCmHiJmBiBeC_xHqqkZx_
			strText += m_vChar[lC];
			// _xZkqqHx_jFlGiOjKiKnEjFjNiCpAiDgPiDgCiDhEiDeAiCmJjCmHiJmBiBeC_xHqqkZx_
			viDxWidths.push_back(lW);
//----- 02.02.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		} else
		if (!strText.IsEmpty())
		//----- _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmGiDgFiDeMiDfIiDgHiCkKiPgEiCmIiCmBiCmEiCkCiCmIiCkCiKiOiCmCjGkCjFgAiJoGiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFgAiJoGiKeKiOgOiNmAjFfHiCpAiOoGjDlOiBjFiDgFiDeMiDfIiDgHjFgAiJoGiBeC_xHqqkZx_
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
//			TextOut(atDC, mm2lg(m_vTextX[lStart]), mm2lg(m_mmY),
//					strText, viDxWidths.begin());
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
			TextOut(atDC, mm2lg(m_vTextX[lStart]), mm2lg(m_mmY),
					strText, wCodePage, viDxWidths.begin());
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
			// _xZkqqHx_iDgFiDeMiDfIiDgHiDgPiDgCiDhEiDeAiBeBjFlGiOjKiKnEjFjNiDgPiDgCiDhEiDeAiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
			strText.Empty();
			viDxWidths.clear();
			// _xZkqqHx_jFlGiOjKjFgAiJoGiKeKiOgOiDeKiDeFiDjDiDfOiCpAiJpAiPjMiBeC_xHqqkZx_
			lStart = -1;
		}
	}
	if (!strText.IsEmpty())
	//----- _xZkqqHx_jGkCjFgAiJoGiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFgAiJoGiKeKiOgOiNmAjFfHiCpAiOoGjDlOiBjFiDgFiDeMiDfIiDgHjFgAiJoGiBeC_xHqqkZx_
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
//		TextOut(atDC, mm2lg(m_vTextX[lStart]), mm2lg(m_mmY),
//				strText, viDxWidths.begin());
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
		TextOut(atDC, mm2lg(m_vTextX[lStart]), mm2lg(m_mmY),
				strText, wCodePage, viDxWidths.begin());
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
	}
	// _xZkqqHx_iOoGiPmBiClFjApMiBeFiJlKjApMiCmMjFgAiJoGiBeC_xHqqkZx_
	DrawLines(atDC);
	ClearText();
} // FCTextOut::FlushText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTextOut::DrawLineHorz
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAiFjFlNiCmMiOoGiPmBiClFjApMiBeBiJlKjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	atDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lLineL	:_xZkqqHx_jApMiCmMiNlGiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lLineR	:_xZkqqHx_jApMiCmMiJeFiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lLineW	:_xZkqqHx_jApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lLineY	:_xZkqqHx_jApMiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	lLineY_xZkqqHx_iCpAjCiGjAfDiCmGiClFiCmEiBeBiPoDiJlKjFjN_xHqqkZx_lLineW_xZkqqHx_iCmMjAiFjFlNjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFjNiCkKiNeMiCkCiPoKiNiHiCmNiBeBiKhAiCkKiClNiCmCiCoGiCkEiCmJiLoJiMgAiCpAjFgAiJoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTextOut::DrawLineHorz (FCAutoDC& atDC, long lLineL, long lLineR,
								long lLineW, long lLineY)
{
	if (lLineW < 3)
	//----- _xZkqqHx_jApMiCmJiPfMjFkKiCmIjFjNiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iJlKjApMjHhAiDhJiDjDiCmMjAnNjCoIiBeC_xHqqkZx_
		atDC.SetPen(PS_SOLID, lLineW, atDC.GetTextColor());
		// _xZkqqHx_jClMjApMiCpAiIpIiCkNiBeC_xHqqkZx_
		atDC.MoveTo(lLineL, lLineY);
		atDC.LineTo(lLineR, lLineY);
	} else
	//----- _xZkqqHx_jApMiCmJiPfMjFkKiCmIjFjNiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iLoJiMgAiCpAjFgAiCkNiBeC_xHqqkZx_
		CRect lgrtLine(lLineL, lLineY - lLineW / 2,
						lLineR, lLineY + lLineW / 2);
		atDC.FillRect(lgrtLine, FCAtBrush(atDC.GetTextColor()));
	}
} // FCTextOut::DrawLineHorz.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTextOut::FlushText1By1
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAjFlGiOjKiClIiCmCjFgAiJoGiClHiCoJiPiIjHjNiBeCiJpBjDfNiCmJiCoAjBmOiJjOiBeC_xHqqkZx_FlushText_xZkqqHx_iCmMiDfEiDhFiKnGjAjEiCmG_xHqqkZx_
 *			_xZkqqHx_iClFiCmEjDkOiNoMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	atDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wCodePage:_xZkqqHx_jFgAiJoGiClHiCoJjFlGiOjKjHpBiCmMiDfCiBfLiDgIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 02.08.16 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)
//void FCTextOut::FlushText1By1 (FCAutoDC& atDC)
void FCTextOut::FlushText1By1 (FCAutoDC& atDC, WORD wCodePage)
{
	DBLRect		mmrtChar;		// _xZkqqHx_iCfAjFlGiOjKjFkKiCmMjHmMiIoGiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
	DBLPoint	mmptaChar[8];	// _xZkqqHx_iCfAjFlGiOjKjFkKiCmMjHmMiIoGiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
// 02.09.15 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)
//	WString		strText;
	for (long lC = 0; lC < m_vChar.size(); lC++)
	{
		//----- 1_xZkqqHx_jFlGiOjKiCmMjFgAiJoGjHmMiIoGiBgJiLoJiMgAiBgKiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
		mmptaChar[0].SetPoint(m_vTextLR[lC].mmLeft, m_mmY);
		mmptaChar[1].SetPoint(m_vTextLR[lC].mmRight, m_mmY);
		mmptaChar[2].SetPoint(m_vTextLR[lC].mmRight, m_mmY + m_mmHeight);
		mmptaChar[3].SetPoint(m_vTextLR[lC].mmLeft, m_mmY + m_mmHeight);
		//----- _xZkqqHx_jFlGiOjKiCmMjFgAiJoGiKeKiOgOiNmAjFfHiBgJiNlGiPoDiBgKiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
		mmptaChar[4].SetPoint(m_vTextX[lC], m_mmY);
		// _xZkqqHx_iKhAjDhIiCkKiCkAiCoJiPoKiNiHiCmNiBeBiJpBjDfNiPiIjHjNiBeCjFgAiJoGiKeKiOgOiNmAjFfHiCoAiCmCiCkCiCmFiCmJiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
		if (!almost0(m_dAngle))
			::RotateConv(mmptaChar, 5, m_dSin, m_dCos, m_mmptCenter.x, m_mmptCenter.y);
		// _xZkqqHx_iJpBjDfNiMoDiCmMiLoJiMgAiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
		::FFCalcFrame(mmrtChar, 4L, mmptaChar);
		if (g_pView->IsRgnOverlap(mmrtChar))
		//----- _xZkqqHx_iPgEiCmIiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
//----- 02.02.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			strText.Empty();
//			_TCHAR szBuff[3];
//			long lStrLen;
//			GetTChar(szBuff, lStrLen, m_vChar[lC]);
//			// _xZkqqHx_jFlGiOjKiCpAiDgFiDeMiDfIiDgHiDgPiDgCiDhEiDeAiCmJjCmHiJmBiBeC_xHqqkZx_
//			strText += szBuff;
//----- 02.02.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			// 95,98_xZkqqHx_iCmMiDgPiDePiCpAjEpAiCkPiCoJiClNiCnPiBeB_xHqqkZx_ExtTextOut_xZkqqHx_iCmNiOgHiCoNiCmIiCkCiClBiCmGiBeC_xHqqkZx_
// 02.09.15 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)
//			atDC.TextOut(mm2lg(mmptaChar[4].x), mm2lg(mmptaChar[4].y), &m_vChar[lC], 1);
			atDC.TextOut(mm2lg(mmptaChar[4].x), mm2lg(mmptaChar[4].y), &m_vChar[lC], 1, wCodePage);
//----- 02.02.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	// _xZkqqHx_iOoGiPmBiClFjApMiBeFiJlKjApMiCmMjFgAiJoGiBeC_xHqqkZx_
	DrawLines(atDC);
	ClearText();
} // FCTextOut::FlushText1By1.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTextOut::TextOut
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiDgFiDeMiDfIiDgHiPgPjHmNiMgAiOkOiCpAiNgMjHlGiClFiCmEiBeBiDgFiDeMiDfIiDgHiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	atDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgX, lgY	:_xZkqqHx_jFgAiJoGiKeKiOgOiImKjChFiBgJiNlGiPoDiBgKiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			str			:_xZkqqHx_jFgAiJoGjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wCodePage	:_xZkqqHx_jFgAiJoGiClHiCoJjFlGiOjKjHpBiCmMiDfCiBfLiDgIiDhJiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lpDxWidths	:_xZkqqHx_jFlGiOjKiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
//void FCTextOut::TextOut (FCAutoDC& atDC, long lgX, long lgY,
//						const WString& str, LPINT lpDxWidths)
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
void FCTextOut::TextOut (FCAutoDC& atDC, long lgX, long lgY,
						const WString& str, WORD wCodePage, LPINT lpDxWidths)
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
{
	if (g_pReg->GetEditDrawText() == 0)
	//----- ExtTextOut -----
	{
		// _xZkqqHx_jFgAiJoGiKeKiOgOiNmAjFfHiCpAiOoGjDlOiBjFiDgFiDeMiDfIiDgHjFgAiJoGiBeC_xHqqkZx_
// 02.09.15 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)
//		atDC.ExtTextOut(lgX, lgY, str, lpDxWidths);
		atDC.ExtTextOut(lgX, lgY, str, wCodePage, lpDxWidths);
	} else
	if (g_pReg->GetEditDrawText() == 2)
	//----- DrawTextEx -----
	{
		CRect lgrtText;
		lgrtText.left = lgX;
		lgrtText.top = lgY;
		lgrtText.right = lgrtText.left + 1;
		lgrtText.bottom = lgrtText.top + 1;
//----- 02.05.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_jFgAiJoGjFpLjGeAiCmJiBhFjAjEjFlGiOjKiClIiCmCiBhGiCpAiOhHjCoIiClHiCoJiCmGiBeB_xHqqkZx_&_xZkqqHx_iCkKiOjPiCmMjFlGiOjKiCmM_xHqqkZx___xZkqqHx_iCmJiCmIiCoJiBeC_xHqqkZx_)-----
//		atDC.DrawTextEx(str, lgrtText,
//						DT_NOCLIP|DT_LEFT|DT_TOP|DT_SINGLELINE, NULL);
//----- 02.05.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_jFgAiJoGjFpLjGeAiCmJiBhFjAjEjFlGiOjKiClIiCmCiBhGiCpAiOhHjCoIiClHiCoJiCmGiBeB_xHqqkZx_&_xZkqqHx_iCkKiOjPiCmMjFlGiOjKiCmM_xHqqkZx___xZkqqHx_iCmJiCmIiCoJiBeC_xHqqkZx_)-----
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
//		atDC.DrawTextEx(str, lgrtText,
//						DT_NOCLIP|DT_LEFT|DT_TOP|DT_SINGLELINE|DT_NOPREFIX, NULL);
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
		atDC.DrawTextEx(str, wCodePage, lgrtText,
						DT_NOCLIP|DT_LEFT|DT_TOP|DT_SINGLELINE|DT_NOPREFIX, NULL);
//----- 02.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (CodePage_xZkqqHx_iCmJjBmOiJjO_xHqqkZx_)-----
//----- 02.05.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_jFgAiJoGjFpLjGeAiCmJiBhFjAjEjFlGiOjKiClIiCmCiBhGiCpAiOhHjCoIiClHiCoJiCmGiBeB_xHqqkZx_&_xZkqqHx_iCkKiOjPiCmMjFlGiOjKiCmM_xHqqkZx___xZkqqHx_iCmJiCmIiCoJiBeC_xHqqkZx_)-----
	}
} // FCTextOut::TextOut.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTextOut::DrawLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOoGiPmBiClFjApMiBeBiJlKjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	atDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmWidth	:_xZkqqHx_jApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmOffset:_xZkqqHx_jApMiCmMiDeJiDhEiDfKiDgCiDgHiCpAiOhHjCoIiBeCiDhEiDeIiDjDiDgHiPoDjFjEiCkJiCoHiCmMiDeJiDhEiDfKiDgCiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTextOut::DrawLine (FCAutoDC& atDC, mmetol mmWidth, mmetol mmOffset)
{
	if (almost0(m_dAngle))
	//----- _xZkqqHx_iKhAjDhIiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jApMiCmMiNlGiJeFiCmMiNmAjFfHiBeC_xHqqkZx_
		long lLineL = mm2lg(m_vTextX.front());
		long lLineR = mm2lg(m_vTextX.back());
		long lLineW = mm2lg(mmWidth);
		long lLineY = mm2lg(m_mmY + mmOffset);
		DrawLineHorz(atDC, lLineL, lLineR, lLineW, lLineY);
	} else
	//----- _xZkqqHx_iKhAjDhIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		DBLPoint mmptaLine[4];
		long lLineW = mm2lg(mmWidth);
		if (lLineW < 3)
		//----- _xZkqqHx_jApMiCmJiPfMjFkKiCmIjFjNiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iJlKjApMiCmMjHlMjCfLiCpAjAnNjCoIiBeCiJpBjDfNjFmPiKlHiClFiCmEiCoAiCoHiCkEiClNiCnPiBeC_xHqqkZx_
			mmptaLine[0].SetPoint(m_vTextX.front(), m_mmY + mmOffset);
			mmptaLine[1].SetPoint(m_vTextX.back(), m_mmY + mmOffset);
			::RotateConv(mmptaLine, 2, m_dSin, m_dCos, m_mmptCenter.x, m_mmptCenter.y);
			// _xZkqqHx_iJlKjApMjHhAiDhJiDjDiCmMjAnNjCoIiBeC_xHqqkZx_
			atDC.SetPen(PS_SOLID, lLineW, atDC.GetTextColor());
			// _xZkqqHx_jClMjApMiCpAiIpIiCkNiBeC_xHqqkZx_
			atDC.MoveTo(mm2lg(mmptaLine[0]));
			atDC.LineTo(mm2lg(mmptaLine[1]));
		} else
		//----- _xZkqqHx_jApMiCmJiPfMjFkKiCmIjFjNiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iJlKjApMiCmM_xHqqkZx_4_xZkqqHx_jCfLiCpAjAnNjCoIiBeCiJpBjDfNjFmPiKlHiClFiCmEiCoAiCoHiCkEiClNiCnPiBeC_xHqqkZx_
			mmptaLine[0].SetPoint(m_vTextX.front(), m_mmY + mmOffset - mmWidth / 2.0);
			mmptaLine[1].SetPoint(m_vTextX.back(), mmptaLine[0].y);
			mmptaLine[2].SetPoint(mmptaLine[1].x, m_mmY + mmOffset + mmWidth / 2.0);
			mmptaLine[3].SetPoint(mmptaLine[0].x, mmptaLine[2].y);
			::RotateConv(mmptaLine, 4, m_dSin, m_dCos, m_mmptCenter.x, m_mmptCenter.y);
			CPoint lgptaLine[4];
			mm2lg(lgptaLine, mmptaLine, 4);
			// _xZkqqHx_iJlKjApMjHhAiDhFiDiJiDfGiCmMjAnNjCoIiBeC_xHqqkZx_
			atDC.SetBrush(atDC.GetTextColor());
			atDC.FillPoly(lgptaLine, 4);
		}
	}
} // FCTextOut::DrawLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTextOut::DrawLines
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOoGiPmBiClFjApMiBeBiJlKjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	atDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTextOut::DrawLines (FCAutoDC& atDC)
{
	if (!m_byUnderline && !m_byStrikeOut) return;
	//----- _xZkqqHx_iJlKjApMiBeFiOoGiPmBiClFjApMiCpAiKnMiCnOiDhEiDiMiBfLiDiAiCpAiOfKiPgP_xHqqkZx_ -----
	DBLRect mmrtText;
	if (almost0(m_dAngle))
	//----- _xZkqqHx_iKhAjDhIiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		mmrtText.SetRect(m_vTextX.front(), m_mmY,
						 m_vTextX.back(), m_mmY + m_mmHeight);
	} else
	//----- _xZkqqHx_iKhAjDhIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		DBLPoint mmptaLine[4];
		// _xZkqqHx_iJlKjApMiBeBiOoGiPmBiClFjApMiCmMjEmNiImNiCpAjAnNjCoIiBeCiJpBjDfNjFmPiKlHiClHiCoJiClNiCnPiBeC_xHqqkZx_
		mmptaLine[0].SetPoint(m_vTextX.front(), m_mmY);
		mmptaLine[1].SetPoint(m_vTextX.back(), m_mmY);
		mmptaLine[2].SetPoint(m_vTextX.back(), m_mmY + m_mmHeight);
		mmptaLine[3].SetPoint(m_vTextX.front(), m_mmY + m_mmHeight);
		::RotateConv(mmptaLine, 4, m_dSin, m_dCos, m_mmptCenter.x, m_mmptCenter.y);
		// _xZkqqHx_iJpBjDfNiMoDiCmMiLoJiMgAiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiBeC_xHqqkZx_
		::FFCalcFrame(mmrtText, 4L, mmptaLine);
	}
	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmGiPgEiCmIiCoHiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!g_pView->IsRgnOverlap(mmrtText)) return;
	if (m_byUnderline)
	//----- _xZkqqHx_iJlKjApMiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		mmetol mmUnderlineWidth = g_pEnv->GetSFontRec(m_foid)->GetUnderlineWidth(m_wOffset);
		mmetol mmUnderlineOffset = g_pEnv->GetSFontRec(m_foid)->
								GetUnderlineOffset(m_dAngle, m_wOffset);
		DrawLine(atDC, mmUnderlineWidth, mmUnderlineOffset);
	}
	if (m_byStrikeOut)
	//----- _xZkqqHx_iOoGiPmBiClFjApMiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		mmetol mmStrikeOutWidth = g_pEnv->GetSFontRec(m_foid)->GetStrikeOutWidth(m_wOffset);
		mmetol mmStrikeOutOffset = g_pEnv->GetSFontRec(m_foid)->
								GetStrikeOutOffset(m_dAngle, m_wOffset);
		DrawLine(atDC, mmStrikeOutWidth, mmStrikeOutOffset);
	}
} // FCTextOut::DrawLines.

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PARAFORMAT_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCpA_xHqqkZx_FCTextLineInfo_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCnGiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tli	:FCTextLineInfo_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *			pf	:PARAFORMAT_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCopy (FCTextLineInfo& tli, const PARAFORMAT& pf)
{
	// tli_xZkqqHx_iCmJ_xHqqkZx_memset_xZkqqHx_iCpAiCkJiCkPiCmEiCmNiCkCiCkPiCmIiCkCiBeCjDoAjFjEiCmJ_xHqqkZx_Vector_xZkqqHx_iCpAiOjNiCmCiClNiCnPiBeC_xHqqkZx_
	tli.dwMask = 0;
	if (pf.dwMask & PFM_STARTINDENT)
	{
		tli.dwMask |= FDTL_FLAG_STARTINDENT;
		tli.mmStartIndent = tw2mm(pf.dxStartIndent);
	}
	if (pf.dwMask & PFM_RIGHTINDENT)
	{
		tli.dwMask |= FDTL_FLAG_RIGHTINDENT;
		tli.mmRightIndent = tw2mm(pf.dxRightIndent);
	}
	if (pf.dwMask & PFM_OFFSET)
	{
		tli.dwMask |= FDTL_FLAG_OFFSET;
		tli.mmOffset = tw2mm(pf.dxOffset);
	}
	if (pf.dwMask & PFM_TABSTOPS)
	{
		tli.dwMask |= FDTL_FLAG_TABSTOPS;
		tli.mmvTabs.clear();
		for (short nTab = 0; nTab < pf.cTabCount; nTab++)
		{
//----- 06.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			tli.mmvTabs.push_back(tw2mm(pf.rgxTabs[nTab]));
//----- 06.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			// RichEdit2.0_xZkqqHx_iImIiNhOiCmFiCmNiBeB_xHqqkZx_rgxTabs[n]_xZkqqHx_iCmMjCgMiCmMiPoDiImKiCfHiDhCiDgCiDgHiCmN_xHqqkZx_
			// _xZkqqHx_jFhEiJmBiPoOjFpBiDhCiDgCiDgHiCmGiClFiCmEjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
			// Excel_xZkqqHx_iCmMjFfMiCpAjDfMiCoIjFhEiCkPiClNiPoKiNiHiCmIiCmHiBeBiClBiClBiCmJiDhCiDgCiDgHiCkKjHkHiCmCiCmMiCmF_xHqqkZx_
			// _xZkqqHx_iClLiCmMiCnMiCnMjFmPiKlHiClHiCoJiCmGiDfOiDhFjCgMiCkKiLjAjBoFiCmIjCgMiCmJiCmIiCoJiBeC_xHqqkZx_
			// PARAFORMAT2_xZkqqHx_iCmMiDhHiDiLiDhGiOfBiPmGiBeC_xHqqkZx_
			tli.mmvTabs.push_back(tw2mm(pf.rgxTabs[nTab] & 0x00ffffff));
//----- 06.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
	if (pf.dwMask & PFM_ALIGNMENT)
	{
		tli.dwMask |= FDTL_FLAG_ALIGNMENT;
		switch (pf.wAlignment)
		{
		case PFA_LEFT:
			tli.byAlignment = FDRC_AL_LEFT;
			break;
		case PFA_RIGHT:
			tli.byAlignment = FDRC_AL_RIGHT;
			break;
		case PFA_CENTER:
			tli.byAlignment = FDRC_AL_CENTER;
			break;
		default:
			tli.byAlignment = FDRC_AL_NONE;
		}
	}
} // FFCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCTextLineInfo_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCpA_xHqqkZx_PARAFORMAT_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCnGiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pf	:PARAFORMAT_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *			tli	:FCTextLineInfo_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCopy (PARAFORMAT& pf, const FCTextLineInfo& tli)
{
	memset(&pf, 0, sizeof(pf));
	pf.cbSize = sizeof(pf);
	pf.dwMask = 0;
	if (tli.dwMask & FDTL_FLAG_STARTINDENT)
	{
		pf.dwMask |= PFM_STARTINDENT;
		pf.dxStartIndent = mm2tw(tli.mmStartIndent);
	}
	if (tli.dwMask & FDTL_FLAG_RIGHTINDENT)
	{
		pf.dwMask |= PFM_RIGHTINDENT;
		pf.dxRightIndent = mm2tw(tli.mmRightIndent);
	}
	if (tli.dwMask & FDTL_FLAG_OFFSET)
	{
		pf.dwMask |= PFM_OFFSET;
		pf.dxOffset = mm2tw(tli.mmOffset);
	}
	if (tli.dwMask & FDTL_FLAG_TABSTOPS)
	{
		pf.dwMask |= PFM_TABSTOPS;
		pf.cTabCount = tli.mmvTabs.size();
		for (long lC = 0; lC < tli.mmvTabs.size() && lC < MAX_TAB_STOPS; lC++)
			pf.rgxTabs[lC] = mm2tw(tli.mmvTabs[lC]);
	}
	if (tli.dwMask & FDTL_FLAG_ALIGNMENT)
	{
		pf.dwMask |= PFM_ALIGNMENT;
		switch (tli.byAlignment)
		{
		case FDRC_AL_RIGHT:
			pf.wAlignment = PFA_RIGHT;
			break;
		case FDRC_AL_CENTER:
			pf.wAlignment = PFA_CENTER;
			break;
		default: // FDRC_AL_LEFT, FDRC_AL_LEFTRIGHT,FDRC_AL_NONE.
			pf.wAlignment = PFA_LEFT;
			break;
		}
	}
} // FFCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	==
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiNhDiPoOjFpBiCmMiIoKjChGiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL operator == (const FCTextLineInfo& tli1, const FCTextLineInfo& tli2)
{
	if (tli1.dwMask != tli2.dwMask) return FALSE;
	if (tli1.dwMask & FDTL_FLAG_STARTINDENT	&& !almosteq(tli1.mmStartIndent, tli2.mmStartIndent)) return FALSE;
	if (tli1.dwMask & FDTL_FLAG_RIGHTINDENT	&& !almosteq(tli1.mmRightIndent, tli2.mmRightIndent)) return FALSE;
	if (tli1.dwMask & FDTL_FLAG_OFFSET		&& !almosteq(tli1.mmOffset, tli2.mmOffset)) return FALSE;
	if (tli1.dwMask & FDTL_FLAG_TABSTOPS	&& !almosteq(tli1.mmvTabs, tli2.mmvTabs)) return FALSE;
	if (tli1.dwMask & FDTL_FLAG_ALIGNMENT	&& tli1.byAlignment != tli2.byAlignment) return FALSE;
	if (tli1.dwMask & FDTL_FLAG_LINEAFTER	&& tli1.nTwipLineAfter != tli2.nTwipLineAfter) return FALSE;
	return TRUE;
} // operator ==.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	!=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiNhDiPoOjFpBiCmMjFhDiIoKjChGiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL operator != (const FCTextLineInfo& tli1, const FCTextLineInfo& tli2)
{
	return !(tli1 == tli2);
} // operator !=.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFOverwrite
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	tli2_xZkqqHx_iCkJiCoHiBeBjAnNjCoIiClDiCoKiCmEiCkCiCoJjCgMiCmMiCnN_xHqqkZx_tli1_xZkqqHx_iCmJiPoDiPjBiCkLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tli1	:_xZkqqHx_iDfCiDhDiBfLjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tli2	:_xZkqqHx_iDfCiDhDiBfLiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMask	:_xZkqqHx_iDfCiDhDiBfLiJmCjEfMiCmIiDiBiDjDiDgPiBfLiCmMiDhNiDfIiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFOverwrite (FCTextLineInfo& tli1, const FCTextLineInfo& tli2, DWORD dwMask)
{
	if (tli2.dwMask & FDTL_FLAG_STARTINDENT && dwMask & FDTL_FLAG_STARTINDENT)
	//----- _xZkqqHx_jAoGjDkKiNhDiCmMiNlGiDeDiDjDiDgGiDjDiDgHiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		tli1.dwMask |= FDTL_FLAG_STARTINDENT;
		tli1.mmStartIndent = tli2.mmStartIndent;
	}
	if (tli2.dwMask & FDTL_FLAG_RIGHTINDENT && dwMask & FDTL_FLAG_RIGHTINDENT)
	//----- _xZkqqHx_jAoGjDkKiBeFiMhAjBlBiNhDiCmMiJeFiDeDiDjDiDgGiDjDiDgHiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		tli1.dwMask |= FDTL_FLAG_RIGHTINDENT;
		tli1.mmRightIndent = tli2.mmRightIndent;
	}
	if (tli2.dwMask & FDTL_FLAG_OFFSET && dwMask & FDTL_FLAG_OFFSET)
	//----- _xZkqqHx_iMhAjBlBiNhDiCmMiDeDiDjDiDgGiDjDiDgHiBgJjAoGjDkKiNhDiCmJjBmOiClHiCoJiDeJiDhEiDfKiDgCiDgHjCgMiBgKiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		tli1.dwMask |= FDTL_FLAG_OFFSET;
		tli1.mmOffset = tli2.mmOffset;
	}
	if (tli2.dwMask & FDTL_FLAG_TABSTOPS && dwMask & FDTL_FLAG_TABSTOPS)
	//----- _xZkqqHx_iDfOiDhFjEhKjHpBiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		tli1.dwMask |= FDTL_FLAG_TABSTOPS;
		tli1.mmvTabs = tli2.mmvTabs;
	}
	if (tli2.dwMask & FDTL_FLAG_ALIGNMENT && dwMask & FDTL_FLAG_ALIGNMENT)
	//----- _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgHiBgJiNlGjCiGiJjLiJeFiKpBiClJiBgKiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		tli1.dwMask |= FDTL_FLAG_ALIGNMENT;
		tli1.byAlignment = tli2.byAlignment;
	}
	if (tli2.dwMask & FDTL_FLAG_LINEAFTER && dwMask & FDTL_FLAG_LINEAFTER)
	//----- _xZkqqHx_iNhDiKnEiBgJiNhDiCmMiJlKiBgKiCmM_xHqqkZx_TWIPS_xZkqqHx_jAjEiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		tli1.dwMask |= FDTL_FLAG_LINEAFTER;
		tli1.nTwipLineAfter = tli2.nTwipLineAfter;
	}
} // FFOverwrite.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	|=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	tli2_xZkqqHx_iCkJiCoHiBeBjAnNjCoIiClDiCoKiCmEiCkCiCoJjCgMiCmMiCnN_xHqqkZx_tli1_xZkqqHx_iCmJiPoDiPjBiCkLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tli1	:_xZkqqHx_iDfCiDhDiBfLjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tli2	:_xZkqqHx_iDfCiDhDiBfLiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void operator |= (FCTextLineInfo& tli1, const FCTextLineInfo& tli2)
{
	FFOverwrite(tli1, tli2, FDTL_FLAG_ALL);
} // operator |=.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	&=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	tli1_xZkqqHx_jCiGiCmFiBeB_xHqqkZx_tli2_xZkqqHx_jCiGiCmMjCgMiCmGjDkPiClGjCgMiCpAiOjNiCmCjHhGjBgGiCmMiCnNiOgDiClFiCmEiBeBiClLiCoKiImIiKeP_xHqqkZx_
 *			_xZkqqHx_iCmNiPmBiLiOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tli1	:_xZkqqHx_iDfCiDhDiBfLjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tli2	:_xZkqqHx_iDfCiDhDiBfLiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFkBjAjEiCmMiNhDjBkOjAkLiCmM_xHqqkZx_AND_xZkqqHx_iCpAiCmGiCoJiPoKiNiHiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiBeBjFkBjAjEiCmMiNhDiCmMiLkEjCmKiCmMjBkOjAkLiCpAiOoGjDlOiClHiCoJiPoKiNiHiBeBiNmFiPiJiCmMiNhDiCmM_xHqqkZx_
 *			_xZkqqHx_jBkOjAkLiCpA_xHqqkZx_ tli1 _xZkqqHx_iCmJjAnNjCoIiClFiBeBiClLiCmMiMoDiCmMiNhDiCmMjBkOjAkLiCmN_xHqqkZx_
 *			tli1 &= _xZkqqHx_iCmF_xHqqkZx_AND_xZkqqHx_iCpAiOoGiCmBiCmEiCkCiCkNiBeC_xHqqkZx_
 *			&= _xZkqqHx_iCmN_xHqqkZx_ FDTL_FLAG_UNUSED _xZkqqHx_iDhEiDiJiDePiCkKjHeMiMpIiCmIiPoKiNiHiCmJiCmMiCnNiJiJiOfKiClHiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void operator &= (FCTextLineInfo& tli1, const FCTextLineInfo& tli2)
{
	if ((tli1.dwMask & FDTL_FLAG_UNUSED) == FDTL_FLAG_UNUSED &&
		(tli2.dwMask & FDTL_FLAG_UNUSED) != FDTL_FLAG_UNUSED)
	//----- tli1_xZkqqHx_iCkKjGlDiMpIiCmF_xHqqkZx_tli2_xZkqqHx_iCkKjHeMiMpIiCmIiPoKiNiH_xHqqkZx_ -----
	{
		tli1 = tli2;
	} else
	if ((tli1.dwMask & FDTL_FLAG_UNUSED) != FDTL_FLAG_UNUSED &&
		(tli2.dwMask & FDTL_FLAG_UNUSED) == FDTL_FLAG_UNUSED)
	//----- tli1_xZkqqHx_iCkKjHeMiMpIiCmF_xHqqkZx_tli2_xZkqqHx_iCkKjGlDiMpIiCmIiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
	} else
	//----- tli1_xZkqqHx_iBeB_xHqqkZx_tli2_xZkqqHx_iCmGiCoAiCmJiCkKjHeMiMpIiBeBiIlNiCkCiCmNiCmGiCoAiCmJjGlDiMpIiCmIiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAoGjDkKiNhDiCmMiNlGiDeDiDjDiDgGiDjDiDgHiCmMiDhEiDiJiDePiPiIjHjNiBeC_xHqqkZx_
		if (!(tli2.dwMask & FDTL_FLAG_STARTINDENT) || !almosteq(tli1.mmStartIndent, tli2.mmStartIndent))
			tli1.dwMask &= ~FDTL_FLAG_STARTINDENT;

		// _xZkqqHx_jAoGjDkKiBeFiMhAjBlBiNhDiCmMiJeFiDeDiDjDiDgGiDjDiDgHiCmMiDhEiDiJiDePiPiIjHjNiBeC_xHqqkZx_
		if (!(tli2.dwMask & FDTL_FLAG_RIGHTINDENT) || !almosteq(tli1.mmRightIndent, tli2.mmRightIndent))
			tli1.dwMask &= ~FDTL_FLAG_RIGHTINDENT;

		// _xZkqqHx_iMhAjBlBiNhDiCmMiDeDiDjDiDgGiDjDiDgHiBgJjAoGjDkKiNhDiCmJjBmOiClHiCoJiDeJiDhEiDfKiDgCiDgHjCgMiBgKiCmMiDhEiDiJiDePiPiIjHjNiBeC_xHqqkZx_
		if (!(tli2.dwMask & FDTL_FLAG_OFFSET) || !almosteq(tli1.mmOffset, tli2.mmOffset))
			tli1.dwMask &= ~FDTL_FLAG_OFFSET;

		// _xZkqqHx_iDfOiDhFjEhKjHpBiCmMiDhEiDiJiDePiPiIjHjNiBeC_xHqqkZx_
		if (!(tli2.dwMask & FDTL_FLAG_TABSTOPS) || !almosteq(tli1.mmvTabs, tli2.mmvTabs))
			tli1.dwMask &= ~FDTL_FLAG_TABSTOPS;

		// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgHiBgJiNlGjCiGiJjLiJeFiKpBiClJiBgKiCmMiDhEiDiJiDePiPiIjHjNiBeC_xHqqkZx_
		if (!(tli2.dwMask & FDTL_FLAG_ALIGNMENT) || tli1.byAlignment != tli2.byAlignment)
			tli1.dwMask &= ~FDTL_FLAG_ALIGNMENT;

		// _xZkqqHx_iNhDiKnEiBgJiNhDiCmMiJlKiBgKiCmM_xHqqkZx_TWIPS_xZkqqHx_jAjEiCmMiDhEiDiJiDePiPiIjHjNiBeC_xHqqkZx_
		if (!(tli2.dwMask & FDTL_FLAG_LINEAFTER) || tli1.nTwipLineAfter != tli2.nTwipLineAfter)
			tli1.dwMask &= ~FDTL_FLAG_LINEAFTER;
	}
} // operator &=.

//----------</NOT EXPORT TO VIEWER>-----------
