// TolBrObjInfo.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "RegData.h"		// For GetRegFontStatic.
#include "UtilWin.h"		// For FFHorznizeToolBar.
#include "UtilErr.h"		// For FFMessageBox.
#include "UtilStr.h"		// For FormatResString.

#include "DynamicDrawView.h"
#include "ObjDynabase.h"
#include "ObjFigure.h"
#include "ToolBase.h"
#include "FoundDoc.h"
#include "LinkManager.h"
#include "RichText.h"
#include "UtilCoord.h"	// For 	extern hic mm2hi (mmetol mm);

#include "UtilObj.h"	// For (16): extern const wchar_t* FFObjTypeToStr (FTObjectType nType);

#include "TolBrObjInfo.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCTolBrObjInfo

CFCTolBrObjInfo::CFCTolBrObjInfo ()
{
	m_nCurInfoMode = 0;
} // CFCTolBrObjInfo::CFCTolBrObjInfo.

CFCTolBrObjInfo::~CFCTolBrObjInfo ()
{
} // CFCTolBrObjInfo::~CFCTolBrObjInfo.

/////////////////////////////////////////////////////////////////////////////
// CFCTolBrObjInfo _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

static UINT BASED_CODE s_buttons[] =
{
	ID_STC_OBJECT_INF_0,
	ID_SEPARATOR,
	ID_STC_OBJECT_INF_1,
	ID_SEPARATOR,
	ID_STC_OBJECT_INF_2,
	ID_SEPARATOR,
	ID_STC_OBJECT_INF_3,
	ID_SEPARATOR,
	ID_STC_OBJECT_INF_4,
	ID_SEPARATOR,
	ID_STC_OBJECT_INF_5,
	ID_BTN_OBJECT_INFO,
};

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrObjInfo::Create
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiNoMjAkMiOjOiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCTolBrObjInfo::Create (CWnd* pParent)
{
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	WString strTitle;
	strTitle.LoadString(IDR_COMMON_OBJ_INFO);
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCpAiNoMjAkMiBeC_xHqqkZx_
//----- 05.07.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (!CreateEx(pParent, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP |
//					CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC,
//					CRect(0,0,0,0), ID_VIEW_TOOLBAR_OBJ_INFO))
//----- 05.07.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!CreateEx(pParent, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP |
					CBRS_GRIPPER | CBRS_FLYBY | CBRS_SIZE_DYNAMIC,
					CRect(0,0,0,0), ID_VIEW_TOOLBAR_OBJ_INFO))
//----- 05.07.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	{
		// IDS_ERR_MSG_FAIL_INIT_TOOLBAR = "_xZkqqHx_iDgDiBfLiDiLiDgPiBfL_xHqqkZx_ %s _xZkqqHx_iCmMiPiJiKpKiJlLiCmJiOlIjEhDiClFiCnMiClFiClNiBeC_xHqqkZx_"
		::FFErrorBox(IDS_ERR_MSG_FAIL_INIT_TOOLBAR, strTitle.c_str());
		return FALSE;
	}
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmJiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAjAnNjCoIiBeC_xHqqkZx_
	FFSetWindowText(this, strTitle);
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDhCiDgCiDgHiDhNiDgCiDhGiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	LoadBitmap(IDB_COMMON_OBJ_INFO);
	// _xZkqqHx_iDhLiDfOiDjDiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
	SetButtons(s_buttons, sizeof(s_buttons)/sizeof(UINT));
	// _xZkqqHx_iDhLiDfOiDjDiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
	SetSizes(CSize(25, 25), CSize(18, 18));
	//----- _xZkqqHx_iPoOjFpBjAnIiCoIjBnGiCkGiDhLiDfOiDjDiCmMiDeDiDiBiBfLiDfHiCpAjAnNjCoI_xHqqkZx_ -----
	m_nCurInfoMode = -1;
// 05.07.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	OnBtnObjectInfo();
	return TRUE;
} // CFCTolBrObjInfo::Create.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrObjInfo::Init
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiPeJjHlJiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCTolBrObjInfo::Init ()
{
	LOGFONT logFont;
	g_pReg->GetRegFontStatic(FDFT_OBJ_INFO_BAR)->GetLogFont(&logFont);
	int iHeight = labs(logFont.lfHeight);
	CRect rect;
	GetItemRect(0, &rect);
	if (rect.Height() < 2 * iHeight)
	{
		DWORD dwBtnSize = GetToolBarCtrl().GetButtonSize();
		WORD wWidth = LOWORD(dwBtnSize);
		WORD wHeight = HIWORD(dwBtnSize);
		GetToolBarCtrl().SetButtonSize(CSize(25, 2 * iHeight));
		SetHeight(2 * iHeight + 4);
	}
	// _xZkqqHx_iNmAjFfHiPoOjFpBjIgHiCmMjFjNiBeC_xHqqkZx_
	const int nCoordWidth = labs(logFont.lfHeight) * 7;
	// _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiCmMjBhNjDpMiPoKiPiKiBgJjFjNiBgKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
	SetButtonInfo(CommandToIndex(ID_STC_OBJECT_INF_0), ID_STC_OBJECT_INF_0, TBBS_SEPARATOR, nCoordWidth);
	SetButtonInfo(CommandToIndex(ID_STC_OBJECT_INF_1), ID_STC_OBJECT_INF_1, TBBS_SEPARATOR, nCoordWidth);
	SetButtonInfo(CommandToIndex(ID_STC_OBJECT_INF_2), ID_STC_OBJECT_INF_2, TBBS_SEPARATOR, nCoordWidth);
	SetButtonInfo(CommandToIndex(ID_STC_OBJECT_INF_3), ID_STC_OBJECT_INF_3, TBBS_SEPARATOR, nCoordWidth);
	SetButtonInfo(CommandToIndex(ID_STC_OBJECT_INF_4), ID_STC_OBJECT_INF_4, TBBS_SEPARATOR, nCoordWidth);
	SetButtonInfo(CommandToIndex(ID_STC_OBJECT_INF_5), ID_STC_OBJECT_INF_5, TBBS_SEPARATOR, nCoordWidth - 25);

	if (!InitStatic(&m_stcObjInf0, ID_STC_OBJECT_INF_0)) return FALSE;
	if (!InitStatic(&m_stcObjInf1, ID_STC_OBJECT_INF_1)) return FALSE;
	if (!InitStatic(&m_stcObjInf2, ID_STC_OBJECT_INF_2)) return FALSE;
	if (!InitStatic(&m_stcObjInf3, ID_STC_OBJECT_INF_3)) return FALSE;
	if (!InitStatic(&m_stcObjInf4, ID_STC_OBJECT_INF_4)) return FALSE;
	if (!InitStatic(&m_stcObjInf5, ID_STC_OBJECT_INF_5)) return FALSE;

	m_stcObjInf5.AddIcon(IDI_WARN_OVER_TEXT);
	m_stcObjInf5.AddIcon(IDI_WARN_OVER_LINK);

//----- 05.07.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDhLiDfOiDjDiCpAiJjPiClFiClNiDiBiDgCiDfKiBfLiDfHiCkKiBeBiDgDiBfLiDiLiDgPiBfLiCmJiNhDiCkNiCoGiCkEiCmJiDeJiBfLiDgJiBfLiCpAjFmPiNfIiBeC_xHqqkZx_
	GetToolBarCtrl().SetOwner(this);
//----- 05.07.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iPoOjFpBjAnIiCoIjBnGiCkGiDhLiDfOiDjDiCmMiDeDiDiBiBfLiDfHiCpAjAnNjCoI_xHqqkZx_ -----
	m_nCurInfoMode = -1;
	OnBtnObjectInfo();

	// _xZkqqHx_jAlDiPoNiPeJjHlJiBeC_xHqqkZx_
	return TRUE;
} // CFCTolBrObjInfo::Init.

//----- 05.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrObjInfo::ObjSelectNotify
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjBeJjBpAiPoOjFpBiCkKjFmPiNfIiClDiCoKiClNiPoKiNiHiBeBiPoOjFpBjAnIiCoIjBnGiCkGiDhLiDfOiDjDiCkKiJjPiClDiCoKiClN_xHqqkZx_
// *			_xZkqqHx_iPoKiNiHiCmJ_xHqqkZx_MainFrame_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCTolBrObjInfo::ObjSelectNotify (long lArgsSz, WString strArgs,
//										DWORD dwWarnSz, const DWORD* dwaWarn)
//{
//	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClFiCmIiCkCiCmIiCoHiCmOjFjMiLeBiBeCiDeBiDhGiDiKiPeJjHlJiOjOjDjJiCmJiBeC_xHqqkZx_
//	if (!::IsWindow(m_hWnd)) return;
//	if (m_nCurInfoMode == 1 && 10 < lArgsSz)
//	{
//		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiBeC_xHqqkZx_
//		long lScroll = lArgsSz - 10;
//		// _xZkqqHx_iCfBiNhDiClIiCmCjFfMiOkGiCmIiCmMiCmFiBeBiDfIiDeOiDiNiBfLiDiLjHmKiCpAiCfBiCmMjEhLjAjEiCmJiClHiCoJiBeC_xHqqkZx_
//		if (lScroll & 1) lScroll++;
//		while (0 < lScroll--)
//		{
//			::FFExtractUntil(strArgs, L"\n");
//		}
//	}
//	m_stcObjInf0.SetText1(::FFExtractUntil(strArgs, L"\n"));
//	m_stcObjInf0.SetText2(::FFExtractUntil(strArgs, L"\n"));
//	m_stcObjInf1.SetText1(::FFExtractUntil(strArgs, L"\n"));
//	m_stcObjInf1.SetText2(::FFExtractUntil(strArgs, L"\n"));
//	m_stcObjInf2.SetText1(::FFExtractUntil(strArgs, L"\n"));
//	m_stcObjInf2.SetText2(::FFExtractUntil(strArgs, L"\n"));
//	m_stcObjInf3.SetText1(::FFExtractUntil(strArgs, L"\n"));
//	m_stcObjInf3.SetText2(::FFExtractUntil(strArgs, L"\n"));
//	m_stcObjInf4.SetText1(::FFExtractUntil(strArgs, L"\n"));
//	m_stcObjInf4.SetText2(::FFExtractUntil(strArgs, L"\n"));
//	m_stcObjInf5.ClearVisible();
//	for (DWORD dwC = 0; dwC < dwWarnSz; dwC++)
//		m_stcObjInf5.SetVisible(dwaWarn[dwC], TRUE);
//	m_stcObjInf5.Invalidate();
//} // CFCTolBrObjInfo::ObjSelectNotify.
//----- 05.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrObjInfo::ObjSelectNotify
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjBeJjBpAiPoOjFpBiCkKjFmPiNfIiClDiCoKiClNiPoKiNiHiBeBiPoOjFpBjAnIiCoIjBnGiCkGiDhLiDfOiDjDiCkKiJjPiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmJ_xHqqkZx_MainFrame_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCTolBrObjInfo::ObjSelectNotify ()
{
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClFiCmIiCkCiCmIiCoHiCmOjFjMiLeBiBeCiDeBiDhGiDiKiPeJjHlJiOjOjDjJiCmJiBeC_xHqqkZx_
	if (!::IsWindow(m_hWnd)) return;
	if (g_pView == NULL) return;
	if (g_pView->GetCurrentTool() == NULL) return;
	//
	// _xZkqqHx_iImIiJlKiCmMiCfCiDfIiDgFiDgCiDhGiCmFiPiIjHjNiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iHeA_xHqqkZx_ _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmMiPoOjFpBiCpAjFmPjAjEiCmJiPfHiMhGiBeC_xHqqkZx_
	// _xZkqqHx_iHeB_xHqqkZx_ _xZkqqHx_iPfHiMhGiClDiCoKiClNjFmPjAjEiCpAjFlGiOjKjHpBiCmJjFmPiKlHiBeC_xHqqkZx_
	// _xZkqqHx_iHeC_xHqqkZx_ _xZkqqHx_jFlGiOjKjHpBiCpAiCnAiCmGiCmCiClIiCmDiDfCiDjDiDgHiDiNiBfLiDiLiCmJjAnNjCoIiBeC_xHqqkZx_
	//


	//----- _xZkqqHx_iHeA_xHqqkZx_ _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCmMiPoOjFpBiCpAjFmPjAjEiCmJiPfHiMhG_xHqqkZx_ -----

	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiKnGiMfH_xHqqkZx_ -----
	FTObjectType	nSelTypeObj = FDOJ_NONE;
	DWORD			dwSelMolipCount = DWORD(-1);
	DBLRect			mmrtSelFrame(0, 0, -1, -1);
	double			dSelObjAngle = 10.0;
	double			dSelTextAngle = 10.0;
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	double			dSelArea = -1.0;
	DWORDVector		vSelLinkIn;
	DWORDVector		vSelLinkOut;
	DWORDSet		stSelWarnLinkIn;
	DWORDSet		stSelWarnLinkOut;
	DWORD			dwSelLayerIdx = DWORD(-1);

	long lInfoSize = 0;
	WString wstrInfo;
	DWORDVector vSelWarning;

	const ObjDynabaseVector& vSelObj = g_pView->GetCurrentTool()->GetSelectLocalObjVector();
	if (!vSelObj.empty())
	{
		ObjDynabaseVector::const_iterator iObj;

		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDfOiDeDiDhG_xHqqkZx_ -----
		iObj = vSelObj.begin();
		nSelTypeObj = (*iObj)->Type();
		for (iObj++; iObj != vSelObj.end(); iObj++)
		{
			if (nSelTypeObj != (*iObj)->Type())
			{
				nSelTypeObj = FDOJ_NONE;
				break;
			}
		}

		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmM_xHqqkZx_MOLIP_xZkqqHx_jAjE_xHqqkZx_ -----
		iObj = vSelObj.begin();
		dwSelMolipCount = (*iObj)->GetMolipCount();
		dwSelMolipCount++;
		for (iObj++; iObj != vSelObj.end(); iObj++)
		{
			DWORD dwMolipCount = (*iObj)->GetMolipCount();
			dwMolipCount++;
			if (dwSelMolipCount != dwMolipCount)
			{
				dwSelMolipCount = DWORD(-1);
				break;
			}
		}
		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDhEiDiMiBfLiDiA_xHqqkZx_ -----
		iObj = vSelObj.begin();
		mmrtSelFrame = (*iObj)->GetResizeFrame();
		for (iObj++; iObj != vSelObj.end(); iObj++)
		{
			mmrtSelFrame |= (*iObj)->GetResizeFrame();
		}
		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiJpBjDfNiKhAjDhI_xHqqkZx_ -----
		iObj = vSelObj.begin();
		dSelObjAngle = (*iObj)->GetAngle();
		for (iObj++; iObj != vSelObj.end(); iObj++)
		{
			if (dSelObjAngle != (*iObj)->GetAngle())
			{
				dSelObjAngle = 10.0;
				break;
			}
		}
		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDgFiDeMiDfIiDgHiJpBjDfNiKhAjDhI_xHqqkZx_ -----
		for (iObj = vSelObj.begin(); iObj != vSelObj.end(); iObj++)
		{
			// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOjNiClNiCmIiCkCjFjEjFgJiCmIiCoHiCmOiBeBiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
			if (!(*iObj)->IsKindOf(FDOJ_FIGURE)) continue;
			FCObjFigure* pFig = (FCObjFigure*)*iObj;
			// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOjNiCmCiNmFiPiJiCmMjFjEjFgJiCmIiCoHiCmOiBeBiKhAjDhIiCpAiLeMjIfOiBeC_xHqqkZx_
			if (dSelTextAngle == 10.0)
			{
				dSelTextAngle = pFig->GetTextAngle();
				continue;
			}
			// _xZkqqHx_iDgFiDeMiDfIiDgHiKhAjDhIiCkKiInJiCmIiCoKiCmOiBeBiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
			if (dSelTextAngle != pFig->GetTextAngle())
			{
				dSelTextAngle = 10.0;
				break;
			}
		}

//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMjGmKjAmP_xHqqkZx_ -----
		iObj = vSelObj.begin();
		dSelArea = (*iObj)->CalcArea();
		for (iObj++; iObj != vSelObj.end(); iObj++)
		{
			// _xZkqqHx_jGmKjAmPiCkKiInJiCmIiCoKiCmOiBeBiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
			if (!abouteq(dSelArea, (*iObj)->CalcArea()))
			{
				dSelArea = -1.0;
				break;
			}
		}
//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCnGiCmMiDiKiDjDiDeOiDeDiDjD_xHqqkZx_ -----
		DWORDSet stSelObj;
		for (iObj = vSelObj.begin(); iObj != vSelObj.end(); iObj++)
			stSelObj.insert((*iObj)->GetObjID());
		for (iObj = vSelObj.begin(); iObj != vSelObj.end(); iObj++)
		{
			FCMolipRec rec;
			rec.dwObjID = (*iObj)->GetObjID();
			rec.lMolipId = -1;
			DWORDSet stAffected;
			g_pDoc->LinkManager()->GetAffectedByTo(stAffected, rec);
			DWORDSet::iterator iRec;
			for (iRec = stAffected.begin(); iRec != stAffected.end(); iRec++)
			{
				const FCLinkRec* pRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iRec);
				if (stSelObj.find(pRec->m_mlpFrom.dwObjID) == stSelObj.end())
					vSelLinkIn.push_back(*iRec);
			}
		}
		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCkJiCoHiCmMiDiKiDjDiDeOiDeBiDeFiDgH_xHqqkZx_ -----
		for (iObj = vSelObj.begin(); iObj != vSelObj.end(); iObj++)
		{
			FCMolipRec rec;
			rec.dwObjID = (*iObj)->GetObjID();
			rec.lMolipId = -1;
			DWORDSet stAffected;
			g_pDoc->LinkManager()->GetAffectedByFrom(stAffected, rec);
			DWORDSet::iterator iRec;
			for (iRec = stAffected.begin(); iRec != stAffected.end(); iRec++)
			{
				const FCLinkRec* pRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iRec);
				if (stSelObj.find(pRec->m_mlpTo.dwObjID) == stSelObj.end())
					vSelLinkOut.push_back(*iRec);
			}
		}
		//----- _xZkqqHx_iIoBiCkEiDfGiBfLiDgHiCkJiCoHiCmMiDiKiDjDiDeOiDeDiDjDiCmMiMhIiNjA_xHqqkZx_ -----
		DWORDVector::iterator iRec;
		for (iRec = vSelLinkIn.begin(); iRec != vSelLinkIn.end(); iRec++)
		{
			const FCLinkRec* pRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iRec);
			if (g_pDoc->ObjDynabaseToLZOrder(g_pDoc->ObjID2Object(pRec->m_mlpFrom.dwObjID)).
											dwLayerIdx == DWORD(-1))
			{
				stSelWarnLinkIn.insert(*iRec);
			}
		}
		//----- _xZkqqHx_iIoBiCkEiDfGiBfLiDgHiCnGiCmMiDiKiDjDiDeOiDeBiDeFiDgHiCmMiMhIiNjA_xHqqkZx_ -----
		for (iRec = vSelLinkOut.begin(); iRec != vSelLinkOut.end(); iRec++)
		{
			const FCLinkRec* pRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iRec);
			if (g_pDoc->ObjDynabaseToLZOrder(g_pDoc->ObjID2Object(pRec->m_mlpTo.dwObjID)).
											dwLayerIdx == DWORD(-1))
			{
				stSelWarnLinkOut.insert(*iRec);
			}
		}
		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDiMiDeDiDiEiBfL_xHqqkZx_ -----
		iObj = vSelObj.begin();
		dwSelLayerIdx = g_pDoc->ObjDynabaseToLZOrder(*iObj).dwLayerIdx;
		for (iObj++; iObj != vSelObj.end(); iObj++)
		{
			if (dwSelLayerIdx != g_pDoc->ObjDynabaseToLZOrder(*iObj).dwLayerIdx)
			{
				dwSelLayerIdx = DWORD(-1);
				break;
			}
		}
		//----- _xZkqqHx_iDgFiDeMiDfIiDgHiDeJiBfLiDgPiBfLiCmMiMhIiNjA_xHqqkZx_ -----
		BOOL bTextWarn = FALSE;
		for (iObj = vSelObj.begin(); !bTextWarn && iObj != vSelObj.end(); iObj++)
		{
			// _xZkqqHx_jFjEjFgJjCiGiCmMiBeB_xHqqkZx_OBJ_FIGURE_xZkqqHx_jFjEjFgJiCpAjBfDiCmEiOoGiCoIiPgPiClHiBeC_xHqqkZx_
			ObjDynabaseVector vFigObj;
			(*iObj)->GetKindOfMembers(vFigObj, FDOJ_FIGURE);
			ObjDynabaseVector::const_iterator iFig;
			for (iFig = vFigObj.begin(); !bTextWarn && iFig != vFigObj.end(); iFig++)
			{
				const FCObjFigure* pFig = (const FCObjFigure*)*iFig;
				if (pFig->GetRichText() != NULL)
				{
					if (pFig->GetRichText()->IsTextOver())
						bTextWarn = TRUE;
				}
			}
		}
		if (bTextWarn)
			vSelWarning.push_back(0);
		//----- _xZkqqHx_iIoBiCkEiDfGiBfLiDgHiCnGiCmMiDiKiDjDiDeOiDeDiDjDiBeFiDeBiDeFiDgHiCmMiMhIiNjA_xHqqkZx_ -----
		if (!stSelWarnLinkIn.empty() || !stSelWarnLinkOut.empty())
			vSelWarning.push_back(1);
	}

	//----- _xZkqqHx_iHeB_xHqqkZx_ _xZkqqHx_iPfHiMhGiClDiCoKiClNjFmPjAjEiCpAjFlGiOjKjHpBiCmJjFmPiKlH_xHqqkZx_ -----

	if (!vSelObj.empty())
	{
//----- 06.12.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// wstrInfo_xZkqqHx_jAjEiCpAjCmHiJmBiBeC_xHqqkZx_
//		lInfoSize += 12;
//----- 06.12.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		lInfoSize += 1;		// wstrInfo_xZkqqHx_jAjEiCpAjCmHiJmBiBeC_xHqqkZx_
		//----- _xZkqqHx_jFjEjFgJjGlMiCpAjAnNjCoI_xHqqkZx_ -----
		if (nSelTypeObj == FDOJ_NONE)
		{
			wstrInfo += L"--------\n";
		} else
		{
			wstrInfo += FFObjTypeToStr(nSelTypeObj);
			wstrInfo += L"\n";
		}
		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDiCiDiKiDhGjAjEiCpAjAnNjCoI_xHqqkZx_ -----
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		lInfoSize += 1;		// wstrInfo_xZkqqHx_jAjEiCpAjCmHiJmBiBeC_xHqqkZx_
		if (dwSelMolipCount == DWORD(-1))
		{
			wstrInfo += L"--------\n";
		} else
		{
			WString str;
			str.Format(L"MOLIP:%d\n", dwSelMolipCount);
			wstrInfo += str;
		}

// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		lInfoSize += 6;		// wstrInfo_xZkqqHx_jAjEiCpAjCmHiJmBiBeC_xHqqkZx_
		if (mmrtSelFrame.right < mmrtSelFrame.left)
		{
			wstrInfo += L"--------\n--------\n--------\n--------\n--------\n--------\n";
		} else
		{
			WString str;
			str.Format(L"L:%f\n", mm2hi(mmrtSelFrame.left));
			wstrInfo += str;
			str.Format(L"T:%f\n", mm2hi(mmrtSelFrame.top));
			wstrInfo += str;
			str.Format(L"R:%f\n", mm2hi(mmrtSelFrame.right));
			wstrInfo += str;
			str.Format(L"B:%f\n", mm2hi(mmrtSelFrame.bottom));
			wstrInfo += str;
			str.Format(L"W:%f\n", mm2hi(mmrtSelFrame.Width()));
			wstrInfo += str;
			str.Format(L"H:%f\n", mm2hi(mmrtSelFrame.Height()));
			wstrInfo += str;
		}
		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiKhAjDhIiCpAjAnNjCoI_xHqqkZx_ -----
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		lInfoSize += 1;		// wstrInfo_xZkqqHx_jAjEiCpAjCmHiJmBiBeC_xHqqkZx_
		if (2.0 <= dSelObjAngle)
		{
			wstrInfo += L"--------\n";
		} else
		{
			WString str;
			str.Format(L"OjR:%f\n", dSelObjAngle);
			wstrInfo += str;
		}
		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDgFiDeMiDfIiDgHiKhAjDhIiCpAjAnNjCoI_xHqqkZx_ -----
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		lInfoSize += 1;		// wstrInfo_xZkqqHx_jAjEiCpAjCmHiJmBiBeC_xHqqkZx_
		if (2.0 <= dSelTextAngle)
		{
			wstrInfo += L"--------\n";
		} else
		{
			WString str;
			str.Format(L"TxR:%f\n", dSelTextAngle);
			wstrInfo += str;
		}

//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMjGmKjAmPiCpAjAnNjCoI_xHqqkZx_ -----
		lInfoSize += 1;		// wstrInfo_xZkqqHx_jAjEiCpAjCmHiJmBiBeC_xHqqkZx_
		if (dSelArea < 0.0)
		{
			wstrInfo += L"--------\n";
		} else
		{
			WString str;
			str.Format(L"A:%f\n", mm22hi2(dSelArea));
			wstrInfo += str;
		}
//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

		//----- _xZkqqHx_iDiKiDjDiDeOjAjEiCpAjAnNjCoI_xHqqkZx_ -----
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		lInfoSize += 2;		// wstrInfo_xZkqqHx_jAjEiCpAjCmHiJmBiBeC_xHqqkZx_
		WString str;
		str.Format(L"LinkIn :%d\n", vSelLinkIn.size());
		wstrInfo += str;
		str.Format(L"LinkOut:%d\n", vSelLinkOut.size());
		wstrInfo += str;

		// strArgs_xZkqqHx_jAjEiCpAjCmHiJmBiBeC_xHqqkZx_
		lInfoSize += 1;
		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDiMiDeDiDiEiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoI_xHqqkZx_ -----
		if (dwSelLayerIdx == DWORD(-1))
		{
			wstrInfo += L"--------\n";
		} else
		{
			WString str;
			WString strName;
			g_pDoc->GetCurrentSheet()->GetLayerInfo(&strName, NULL, dwSelLayerIdx);
			str.Format(L"%d.%s\n", dwSelLayerIdx, strName.c_str());
			wstrInfo += str;
		}
	}

	//----- _xZkqqHx_iHeC_xHqqkZx_ _xZkqqHx_jFlGiOjKjHpBiCpAiCnAiCmGiCmCiClIiCmDiDfCiDjDiDgHiDiNiBfLiDiLiCmJjAnNjCoI_xHqqkZx_ -----

	if (m_nCurInfoMode == 1 && 10 < lInfoSize)
	{
		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiBeC_xHqqkZx_
		long lScroll = lInfoSize - 10;
		// _xZkqqHx_iCfBiNhDiClIiCmCjFfMiOkGiCmIiCmMiCmFiBeBiDfIiDeOiDiNiBfLiDiLjHmKiCpAiCfBiCmMjEhLjAjEiCmJiClHiCoJiBeC_xHqqkZx_
		if (lScroll & 1) lScroll++;
		while (0 < lScroll--)
		{
			::FFExtractUntil(wstrInfo, L"\n");
		}
	}
	m_stcObjInf0.SetText1(::FFExtractUntil(wstrInfo, L"\n"));
	m_stcObjInf0.SetText2(::FFExtractUntil(wstrInfo, L"\n"));
	m_stcObjInf1.SetText1(::FFExtractUntil(wstrInfo, L"\n"));
	m_stcObjInf1.SetText2(::FFExtractUntil(wstrInfo, L"\n"));
	m_stcObjInf2.SetText1(::FFExtractUntil(wstrInfo, L"\n"));
	m_stcObjInf2.SetText2(::FFExtractUntil(wstrInfo, L"\n"));
	m_stcObjInf3.SetText1(::FFExtractUntil(wstrInfo, L"\n"));
	m_stcObjInf3.SetText2(::FFExtractUntil(wstrInfo, L"\n"));
	m_stcObjInf4.SetText1(::FFExtractUntil(wstrInfo, L"\n"));
	m_stcObjInf4.SetText2(::FFExtractUntil(wstrInfo, L"\n"));
	m_stcObjInf5.ClearVisible();
	for (DWORD dwC = 0; dwC != vSelWarning.size(); dwC++)
		m_stcObjInf5.SetVisible(vSelWarning[dwC], TRUE);
	m_stcObjInf5.Invalidate();
} // CFCTolBrObjInfo::ObjSelectNotify.
//----- 05.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrObjInfo::InitStatic
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiDfCiDjDiDgHiDiNiBfLiDiLiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCTolBrObjInfo::InitStatic (CFCStc2Line* pEdit, DWORD dwID)
{
	//----- _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiCmMiNoMjAkMiBjFiPiJiKpKiJlL_xHqqkZx_ -----
	// _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiCmMiDfEiDeDiDfJiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
	CRect rect;
	GetItemRect(CommandToIndex(dwID), &rect);
	// _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiCpAiNoMjAkMiBeC_xHqqkZx_
	if (!pEdit->Create(_T(""), WS_VISIBLE|SS_SIMPLE, rect, this, dwID))
	{
		TRACE(_T("Failed to create static\n"));
		return FALSE;
	}
	// _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiCmJiDhEiDeIiDjDiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	pEdit->SetFont(g_pReg->GetRegFontStatic(FDFT_OBJ_INFO_BAR));
	return TRUE;
} // CFCTolBrObjInfo::InitStatic.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrObjInfo::InitStatic
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiDfCiDjDiDgHiDiNiBfLiDiLiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCTolBrObjInfo::InitStatic (CFCStcIcons* pEdit, DWORD dwID)
{
	//----- _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiCmMiNoMjAkMiBjFiPiJiKpKiJlL_xHqqkZx_ -----
	// _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiCmMiDfEiDeDiDfJiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
	CRect rect;
	GetItemRect(CommandToIndex(dwID), &rect);
	// _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiCpAiNoMjAkMiBeC_xHqqkZx_
	if (!pEdit->Create(CSize(21, 21), WS_VISIBLE|SS_SIMPLE, rect, this, dwID))
	{
		TRACE(_T("Failed to create static\n"));
		return FALSE;
	}
	return TRUE;
} // CFCTolBrObjInfo::InitStatic.

//----- 05.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrObjInfo::GetObjectInfo
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCTolBrObjInfo::GetObjectInfo (long& lInfoSize, WString& wstrInfo, DWORDVector& vSelWarning) const
//{
//	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiKnGiMfH_xHqqkZx_ -----
//	FTObjectType	nSelTypeObj;
//	DWORD			dwSelMolipCount;
//	DBLRect			mmrtSelFrame;
//	double			dSelObjAngle;
//	double			dSelTextAngle;
//	DWORDVector		vSelLinkIn;
//	DWORDVector		vSelLinkOut;
//	DWORDSet		stSelWarnLinkIn;
//	DWORDSet		stSelWarnLinkOut;
//	DWORD			dwSelLayerIdx;
//
//	nSelTypeObj = FDOJ_NONE;
//	dwSelMolipCount = DWORD(-1);
//	mmrtSelFrame.SetRect(0, 0, -1, -1);
//	dSelObjAngle = 10.0;
//	dSelTextAngle = 10.0;
//	vSelLinkIn.clear();
//	vSelLinkOut.clear();
//	stSelWarnLinkIn.clear();
//	stSelWarnLinkOut.clear();
//	dwSelLayerIdx = DWORD(-1);
//
//	lInfoSize = 0;
//	wstrInfo.Empty();
//	vSelWarning.clear();
//
//do {
//	if (g_pView == NULL) break;
//	if (g_pView->GetCurrentTool() == NULL) break;
//	const ObjDynabaseVector& vSelObj = g_pView->GetCurrentTool()->GetSelectLocalObjVector();
//	if (vSelObj.empty()) break;
//	ObjDynabaseVector::const_iterator iObj;
//
//	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDfOiDeDiDhG_xHqqkZx_ -----
//	iObj = vSelObj.begin();
//	nSelTypeObj = (*iObj)->Type();
//	for (iObj++; iObj != vSelObj.end(); iObj++)
//	{
//		if (nSelTypeObj != (*iObj)->Type())
//		{
//			nSelTypeObj = FDOJ_NONE;
//			break;
//		}
//	}
//
//	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmM_xHqqkZx_MOLIP_xZkqqHx_jAjE_xHqqkZx_ -----
//	iObj = vSelObj.begin();
//	dwSelMolipCount = (*iObj)->GetMolipCount();
//	dwSelMolipCount++;
//	for (iObj++; iObj != vSelObj.end(); iObj++)
//	{
//		DWORD dwMolipCount = (*iObj)->GetMolipCount();
//		dwMolipCount++;
//		if (dwSelMolipCount != dwMolipCount)
//		{
//			dwSelMolipCount = DWORD(-1);
//			break;
//		}
//	}
//	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDhEiDiMiBfLiDiA_xHqqkZx_ -----
//	iObj = vSelObj.begin();
//	mmrtSelFrame = (*iObj)->GetResizeFrame();
//	for (iObj++; iObj != vSelObj.end(); iObj++)
//	{
//		mmrtSelFrame |= (*iObj)->GetResizeFrame();
//	}
//	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiJpBjDfNiKhAjDhI_xHqqkZx_ -----
//	iObj = vSelObj.begin();
//	dSelObjAngle = (*iObj)->GetAngle();
//	for (iObj++; iObj != vSelObj.end(); iObj++)
//	{
//		if (dSelObjAngle != (*iObj)->GetAngle())
//		{
//			dSelObjAngle = 10.0;
//			break;
//		}
//	}
//	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDgFiDeMiDfIiDgHiJpBjDfNiKhAjDhI_xHqqkZx_ -----
//	for (iObj = vSelObj.begin(); iObj != vSelObj.end(); iObj++)
//	{
//		// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOjNiClNiCmIiCkCjFjEjFgJiCmIiCoHiCmOiBeBiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (!(*iObj)->IsKindOf(FDOJ_FIGURE)) continue;
//		FCObjFigure* pFig = (FCObjFigure*)*iObj;
//		// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOjNiCmCiNmFiPiJiCmMjFjEjFgJiCmIiCoHiCmOiBeBiKhAjDhIiCpAiLeMjIfOiBeC_xHqqkZx_
//		if (dSelTextAngle == 10.0)
//		{
//			dSelTextAngle = pFig->GetTextAngle();
//			continue;
//		}
//		// _xZkqqHx_iDgFiDeMiDfIiDgHiKhAjDhIiCkKiInJiCmIiCoKiCmOiBeBiDiLiBfLiDhGiPeJjHlJiBeC_xHqqkZx_
//		if (dSelTextAngle != pFig->GetTextAngle())
//		{
//			dSelTextAngle = 10.0;
//			break;
//		}
//	}
//	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCnGiCmMiDiKiDjDiDeOiDeDiDjD_xHqqkZx_ -----
//	DWORDSet stSelObj;
//	for (iObj = vSelObj.begin(); iObj != vSelObj.end(); iObj++)
//		stSelObj.insert((*iObj)->GetObjID());
//	for (iObj = vSelObj.begin(); iObj != vSelObj.end(); iObj++)
//	{
//		FCMolipRec rec;
//		rec.dwObjID = (*iObj)->GetObjID();
//		rec.lMolipId = -1;
//		DWORDSet stAffected;
//		g_pDoc->LinkManager()->GetAffectedByTo(stAffected, rec);
//		DWORDSet::iterator iRec;
//		for (iRec = stAffected.begin(); iRec != stAffected.end(); iRec++)
//		{
//			const FCLinkRec* pRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iRec);
//			if (stSelObj.find(pRec->m_mlpFrom.dwObjID) == stSelObj.end())
//				vSelLinkIn.push_back(*iRec);
//		}
//	}
//	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCkJiCoHiCmMiDiKiDjDiDeOiDeBiDeFiDgH_xHqqkZx_ -----
//	for (iObj = vSelObj.begin(); iObj != vSelObj.end(); iObj++)
//	{
//		FCMolipRec rec;
//		rec.dwObjID = (*iObj)->GetObjID();
//		rec.lMolipId = -1;
//		DWORDSet stAffected;
//		g_pDoc->LinkManager()->GetAffectedByFrom(stAffected, rec);
//		DWORDSet::iterator iRec;
//		for (iRec = stAffected.begin(); iRec != stAffected.end(); iRec++)
//		{
//			const FCLinkRec* pRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iRec);
//			if (stSelObj.find(pRec->m_mlpTo.dwObjID) == stSelObj.end())
//				vSelLinkOut.push_back(*iRec);
//		}
//	}
//	//----- _xZkqqHx_iIoBiCkEiDfGiBfLiDgHiCkJiCoHiCmMiDiKiDjDiDeOiDeDiDjDiCmMiMhIiNjA_xHqqkZx_ -----
//	DWORDVector::iterator iRec;
//	for (iRec = vSelLinkIn.begin(); iRec != vSelLinkIn.end(); iRec++)
//	{
//		const FCLinkRec* pRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iRec);
//		if (g_pDoc->ObjDynabaseToLZOrder(g_pDoc->ObjID2Object(pRec->m_mlpFrom.dwObjID)).
//										dwLayerIdx == DWORD(-1))
//		{
//			stSelWarnLinkIn.insert(*iRec);
//		}
//	}
//	//----- _xZkqqHx_iIoBiCkEiDfGiBfLiDgHiCnGiCmMiDiKiDjDiDeOiDeBiDeFiDgHiCmMiMhIiNjA_xHqqkZx_ -----
//	for (iRec = vSelLinkOut.begin(); iRec != vSelLinkOut.end(); iRec++)
//	{
//		const FCLinkRec* pRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iRec);
//		if (g_pDoc->ObjDynabaseToLZOrder(g_pDoc->ObjID2Object(pRec->m_mlpTo.dwObjID)).
//										dwLayerIdx == DWORD(-1))
//		{
//			stSelWarnLinkOut.insert(*iRec);
//		}
//	}
//	//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDiMiDeDiDiEiBfL_xHqqkZx_ -----
//	iObj = vSelObj.begin();
//	dwSelLayerIdx = g_pDoc->ObjDynabaseToLZOrder(*iObj).dwLayerIdx;
//	for (iObj++; iObj != vSelObj.end(); iObj++)
//	{
//		if (dwSelLayerIdx != g_pDoc->ObjDynabaseToLZOrder(*iObj).dwLayerIdx)
//		{
//			dwSelLayerIdx = DWORD(-1);
//			break;
//		}
//	}
//	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiDeJiBfLiDgPiBfLiCmMiMhIiNjA_xHqqkZx_ -----
//	BOOL bTextWarn = FALSE;
//	for (iObj = vSelObj.begin(); !bTextWarn && iObj != vSelObj.end(); iObj++)
//	{
//		// _xZkqqHx_jFjEjFgJjCiGiCmMiBeB_xHqqkZx_OBJ_FIGURE_xZkqqHx_jFjEjFgJiCpAjBfDiCmEiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//		ObjDynabaseVector vFigObj;
//		(*iObj)->GetKindOfMembers(vFigObj, FDOJ_FIGURE);
//		ObjDynabaseVector::const_iterator iFig;
//		for (iFig = vFigObj.begin(); !bTextWarn && iFig != vFigObj.end(); iFig++)
//		{
//			const FCObjFigure* pFig = (const FCObjFigure*)*iFig;
//			if (pFig->GetRichText() != NULL)
//			{
//				if (pFig->GetRichText()->IsTextOver())
//					bTextWarn = TRUE;
//			}
//		}
//	}
//	if (bTextWarn)
//		vSelWarning.push_back(0);
//	//----- _xZkqqHx_iIoBiCkEiDfGiBfLiDgHiCnGiCmMiDiKiDjDiDeOiDeDiDjDiBeFiDeBiDeFiDgHiCmMiMhIiNjA_xHqqkZx_ -----
//	if (!stSelWarnLinkIn.empty() || !stSelWarnLinkOut.empty())
//		vSelWarning.push_back(1);
//
//
//	if (g_pView != NULL &&
//		!g_pView->GetCurrentTool()->GetSelectLocalObjVector().empty())
//	{
//		// wstrInfo_xZkqqHx_jAjEiCpAjCmHiJmBiBeC_xHqqkZx_
//		lInfoSize += 12;
//		//----- _xZkqqHx_jFjEjFgJjGlMiCpAjAnNjCoI_xHqqkZx_ -----
//		if (nSelTypeObj == FDOJ_NONE)
//		{
//			wstrInfo += L"--------\n";
//		} else
//		{
//			wstrInfo += FFObjTypeToStr(nSelTypeObj);
//			wstrInfo += L"\n";
//		}
//		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDiCiDiKiDhGjAjEiCpAjAnNjCoI_xHqqkZx_ -----
//		if (dwSelMolipCount == DWORD(-1))
//		{
//			wstrInfo += L"--------\n";
//		} else
//		{
//			WString str;
//			str.Format(L"MOLIP:%d\n", dwSelMolipCount);
//			wstrInfo += str;
//		}
//
//		if (mmrtSelFrame.right < mmrtSelFrame.left)
//		{
//			wstrInfo += L"--------\n--------\n--------\n--------\n--------\n--------\n";
//		} else
//		{
//			WString str;
//			str.Format(L"L:%f\n", mm2hi(mmrtSelFrame.left));
//			wstrInfo += str;
//			str.Format(L"T:%f\n", mm2hi(mmrtSelFrame.top));
//			wstrInfo += str;
//			str.Format(L"R:%f\n", mm2hi(mmrtSelFrame.right));
//			wstrInfo += str;
//			str.Format(L"B:%f\n", mm2hi(mmrtSelFrame.bottom));
//			wstrInfo += str;
//			str.Format(L"W:%f\n", mm2hi(mmrtSelFrame.Width()));
//			wstrInfo += str;
//			str.Format(L"H:%f\n", mm2hi(mmrtSelFrame.Height()));
//			wstrInfo += str;
//		}
//		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiKhAjDhIiCpAjAnNjCoI_xHqqkZx_ -----
//		if (2.0 <= dSelObjAngle)
//		{
//			wstrInfo += L"--------\n";
//		} else
//		{
//			WString str;
//			str.Format(L"OjR:%f\n", dSelObjAngle);
//			wstrInfo += str;
//		}
//		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDgFiDeMiDfIiDgHiKhAjDhIiCpAjAnNjCoI_xHqqkZx_ -----
//		if (2.0 <= dSelTextAngle)
//		{
//			wstrInfo += L"--------\n";
//		} else
//		{
//			WString str;
//			str.Format(L"TxR:%f\n", dSelTextAngle);
//			wstrInfo += str;
//		}
//		//----- _xZkqqHx_iDiKiDjDiDeOjAjEiCpAjAnNjCoI_xHqqkZx_ -----
//		WString str;
//		str.Format(L"LinkIn :%d\n", vSelLinkIn.size());
//		wstrInfo += str;
//		str.Format(L"LinkOut:%d\n", vSelLinkOut.size());
//		wstrInfo += str;
//
//
//		// strArgs_xZkqqHx_jAjEiCpAjCmHiJmBiBeC_xHqqkZx_
//		lInfoSize += 1;
//		//----- _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiDiMiDeDiDiEiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoI_xHqqkZx_ -----
//		if (dwSelLayerIdx == DWORD(-1))
//		{
//			wstrInfo += L"--------\n";
//		} else
//		{
//			WString str;
//			WString strName;
//			g_pDoc->GetCurrentSheet()->GetLayerInfo(&strName, NULL, dwSelLayerIdx);
//			str.Format(L"%d.%s\n", dwSelLayerIdx, strName.c_str());
//			wstrInfo += str;
//		}
//	}
//} while (FALSE);
//} // CFCTolBrObjInfo::GetObjectInfo.
//----- 05.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// CFCTolBrObjInfo _xZkqqHx_iDeJiBfLiDgPiBfLiDiJiDeDiDgIiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrObjInfo::CalcFixedLayout
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmFjCoIiDfEiDeDiDfJiCmMiMhGiOfKiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeCiOoFiCmJiDgIiDgCiDeOiClDiCoKiCoJiCmGiCkLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CSize CFCTolBrObjInfo::CalcFixedLayout (BOOL bStretch, BOOL bHorz)
{
//	TRACE(_T("CFCTolBrObjInfo::CalcFixedLayout %d %d\r\n"), bStretch, bHorz);
	if (bHorz)
	//----- _xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDgIiDgCiDeOiOjO_xHqqkZx_ ------
	{
		// _xZkqqHx_jGhLjHiIiBeBiClBiCmMiPiIjHjNiCmNjFhDjHhGiCmIiCmMiClOiCkKiBeBiPgDjFpLiMpMiCmJjAeMiCmOiClFiClNiDhEiDiNiBfLiDgHiDgDiBfLiDiLiDgPiBfL_xHqqkZx_
		// _xZkqqHx_iCpAiDgIiDgCiDeOiClFiCoGiCkEiCmGiClHiCoJiCmGiBeBjFjEjFgJiCkKiCkEiCnMiCkN_xHqqkZx_SEPARATOR_xZkqqHx_iImKjChFiCmJiInKjDkOiClFiCmIiCkCiClNiCnPiBeC_xHqqkZx_
		FCWndAndId wid[] =
		{
			{ &m_stcObjInf0, ID_STC_OBJECT_INF_0 },
			{ &m_stcObjInf1, ID_STC_OBJECT_INF_1 },
			{ &m_stcObjInf2, ID_STC_OBJECT_INF_2 },
			{ &m_stcObjInf3, ID_STC_OBJECT_INF_3 },
			{ &m_stcObjInf4, ID_STC_OBJECT_INF_4 },
			{ &m_stcObjInf5, ID_STC_OBJECT_INF_5 },
		};
		::FFHorznizeToolBar(this, wid, sizeof(wid) / sizeof(wid[0]));
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return CFCTolBrBase::CalcFixedLayout(bStretch, bHorz);
} // CFCTolBrObjInfo::CalcFixedLayout.

BEGIN_MESSAGE_MAP(CFCTolBrObjInfo, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCTolBrObjInfo)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_BTN_OBJECT_INFO, OnBtnObjectInfo)
	ON_UPDATE_COMMAND_UI(ID_BTN_OBJECT_INFO, OnUpdateBtnObjectInfo)
	ON_MESSAGE(WM_USER_CMD_SESSION_ENDED, OnUserCmdSessionEnded)
	ON_MESSAGE(WM_USER_OBJ_SELECT_CHANGED, OnUserObjSelectChanged)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFCTolBrObjInfo _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrObjInfo::OnBtnObjectInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMjFjEjFgJiPoOjFpBjAnIiCoIjBnGiCkGiDhLiDfOiDjD_xHqqkZx_(CommonDrawFrame)_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCTolBrObjInfo::OnBtnObjectInfo ()
{
	m_nCurInfoMode++;
	if (1 < m_nCurInfoMode) m_nCurInfoMode = 0;
	TBBUTTONINFO inf;
	inf.cbSize = sizeof(inf);
	inf.dwMask = TBIF_IMAGE;
	inf.iImage = m_nCurInfoMode;
	GetToolBarCtrl().SetButtonInfo(ID_BTN_OBJECT_INFO, &inf);
	// _xZkqqHx_jFfMiOkGiCpAjAnNjCoIiBeC_xHqqkZx_
	ObjSelectNotify();
} // CFCTolBrObjInfo::OnBtnObjectInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrObjInfo::OnUpdateBtnObjectInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjFjEjFgJiPoOjFpBjAnIiCoIjBnGiCkGiBhGiCmMjFfMiOkGiPpDjBnEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCTolBrObjInfo::OnUpdateBtnObjectInfo (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(TRUE);
} // CFCTolBrObjInfo::OnUpdateBtnObjectInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrObjInfo::OnUserCmdSessionEnded
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiPeJjHlJiKnGjAjEiCkKiOmAiNhDiClDiCoKiClNiOjOiBeB_xHqqkZx_
 *			CommandGate_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	1
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCTolBrObjInfo::OnUserCmdSessionEnded (WPARAM, LPARAM)
{
	// _xZkqqHx_jFfMiOkGiCpAjAnNjCoIiBeC_xHqqkZx_
	ObjSelectNotify();
	return 1;
} // CFCTolBrObjInfo::OnUserCmdSessionEnded.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCTolBrObjInfo::OnUserObjSelectChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJ_xHqqkZx_View_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	1
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCTolBrObjInfo::OnUserObjSelectChanged (WPARAM, LPARAM)
{
	// _xZkqqHx_jFfMiOkGiCpAjAnNjCoIiBeC_xHqqkZx_
	ObjSelectNotify();
	return 1;
} // CFCTolBrObjInfo::OnUserObjSelectChanged.
