#include "stdafx.h"
#include <algorithm>			// For find template.
#include "DynamicDraw.h"		// For resource.h.
#include "DynamicDrawView.h"	// For g_pView.
#include "RegData.h"			// For FCRegData.
#include "FoundDoc.h"			// For g_pDoc.
#include "ObjDynabase.h"			// For FCObjDynabase.
#include "ObjPoint.h"			// For FCObjPoint.
#include "ObjGroup.h"			// For FCObjGroup.
#include "UtilCoord.h"			// For mm2lg.etc.
#include "UtilGraph.h"			// For FCEditDraw.
#include "FrameWnd.h"			// For FFGetMainWnd().
#include "ToolGroupSelect.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::FCToolGroupSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCToolGroupSelect::FCToolGroupSelect () : BASE_CLASS(FDOZ_ON_EDIT)
{
} // FCToolGroupSelect::FCToolGroupSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::DrawSelectMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjFfMiOkGiOjOiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBgJjEpBjFfMiOkGiBgKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jFfMiOkGiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMiDeKiDgJiDiBjDfPiDhNiBfLiDeOiCmGiBeBjBeJjBpAjCiGjIeBiMiLjDfPiCmMiIpIjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolGroupSelect::DrawSelectMark (CDC* pDC, FCObjDynabase* pObj)
{
	// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmFiCmIiCkCiPoKiNiHiCmNjFgAiJoGiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FDOJ_GROUP)) return;
	FCObjGroup* pGroup = (FCObjGroup*)pObj;

	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0);

	//----- _xZkqqHx_jFjEjFgJiOgMiLpHiCmJjBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoG_xHqqkZx_ -----
	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
	const CRect lgrt = mm2lg(pObj->GetResizeFrame());
	if (lgrt.left == lgrt.right && lgrt.top == lgrt.bottom)
	// _xZkqqHx_jBoFiCkLiClDiCkKjGlDiCkCiPoKiNiHiBeC_xHqqkZx_
	{
		eDraw.SmallMark(CPoint(lgrt.left, lgrt.top));
	} else
	if (lgrt.left == lgrt.right || lgrt.top == lgrt.bottom)
	// _xZkqqHx_jAiCjClMiBeFjAiFjFlNjApMiCmMiPoKiNiHiBeC_xHqqkZx_
	{
		eDraw.Line(&CPoint(lgrt.left, lgrt.top), &CPoint(lgrt.right, lgrt.bottom));
	} else
	// _xZkqqHx_iLoJiMgAiCmMiPoKiNiHiBeC_xHqqkZx_
	{
		eDraw.Line(	&CPoint(lgrt.left, lgrt.top),
					&CPoint(lgrt.right, lgrt.top),
					&CPoint(lgrt.right, lgrt.bottom),
					&CPoint(lgrt.left, lgrt.bottom),
					&CPoint(lgrt.left, lgrt.top));
	}
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = GetSelectLocalObjVector().begin(); iObj != GetSelectLocalObjVector().end(); iObj++)
	{
		if ((*iObj)->GetGroupParent() == pObj)
			DrawSelectLocalMark(pDC, *iObj);
	}
} // FCToolGroupSelect::DrawSelectedMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::CanHandle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkKiClBiCmMiDgDiBfLiDiLiCmFiIlFiCkGiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolGroupSelect::CanHandle (const FCObjDynabase* pObj) const
{
	// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiImIiKePiCmNiDfPiDiBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FDOJ_GROUP)) return FALSE;
	// _xZkqqHx_jFfMjFjEjFgJiCmNiBeBjAoKjHhAiCmMiDeHiDgGiDeCiDfOiCkKiCkAiCoJiClNiCnPjFnCiPfHiClFiCmIiCkCiBeC_xHqqkZx_
	if (pObj->IsKindOf(FDOJ_TABLE)) return FALSE;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::CanHandle(pObj);
} // FCToolGroupSelect::CanHandle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::OnAppendSelectObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiClBiCmJjFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJoGjGmKjFfMiOkGiCpAjBeJjBpAiPpDjBnEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::AppendSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
 *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolGroupSelect::OnAppendSelectObj (CDC* pDC, FCObjDynabase* pObj)
{
	// _xZkqqHx_jBmOiPnLjFjEjFgJiCmFiCmNiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!CanHandle(pObj)) return;
	BASE_CLASS::OnAppendSelectObj(pDC, pObj);

	//----- _xZkqqHx_iDhMiDeDiDjDiDgHjFjEjFgJiCmJiBeBjFfMiOkGiDhEiDiJiDePiCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
	BOOL bRedraw = FALSE;	// _xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCkJiBeI_xHqqkZx_
	for (long lIdx = 0; lIdx < pObj->GetMemberSize(); lIdx++)
	{
		if (pObj->GetMember(lIdx)->IsKindOf(FDOJ_POINT))
		{
			((FCObjPoint*)pObj->GetMember(lIdx))->SetIsVisible(TRUE);
			g_pView->AddRgn(pObj->GetMember(lIdx));
			bRedraw = TRUE;
		}
	}
	if (bRedraw) g_pView->PostRgnRedraw();
} // FCToolGroupSelect::OnAppendSelectObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::OnRemoveSelectObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCpAjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiClBiCkJiCoHjFjEjFgJiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJoGjGmKjFfMiOkGiCpAjEpBjBeJjBpAiPpDjBnEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::RemoveSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
 *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolGroupSelect::OnRemoveSelectObj (CDC* pDC, FCObjDynabase* pObj)
{
	// _xZkqqHx_jBmOiPnLjFjEjFgJiCmFiCmNiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!CanHandle(pObj)) return;
	BASE_CLASS::OnRemoveSelectObj(pDC, pObj);

	//----- _xZkqqHx_iDhMiDeDiDjDiDgHjFjEjFgJiCkJiCoHiBeBjFfMiOkGiDhEiDiJiDePiCpAiJpAiPjMiClHiCoJ_xHqqkZx_ -----
	BOOL bRedraw = FALSE;	// _xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCkJiBeI_xHqqkZx_
	for (long lIdx = 0; lIdx < pObj->GetMemberSize(); lIdx++)
	{
		if (pObj->GetMember(lIdx)->IsKindOf(FDOJ_POINT))
		{
			((FCObjPoint*)pObj->GetMember(lIdx))->SetIsVisible(FALSE);
			g_pView->AddRgn(pObj->GetMember(lIdx));
			bRedraw = TRUE;
		}
	}
	if (bRedraw) g_pView->PostRgnRedraw();

	// _xZkqqHx_iDiNiBfLiDeKiDiLiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCpAiJpAiPjMiBeC_xHqqkZx_
	ObjDynabaseVector::iterator iObj;
	for (iObj = m_vLocalObj.begin(); iObj != m_vLocalObj.end();)
	{
		if ((*iObj)->GetGroupParent() == pObj)
			iObj = m_vLocalObj.erase(iObj);
		else
			iObj++;
	}
} // FCToolGroupSelect::OnRemoveSelectObj.

//----- 05.07.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::OnClearSelectObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAjBfDiCmEjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
// *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
// *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::ClearSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
// *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolGroupSelect::OnClearSelectObj (CDC* pDC)
//{
//	//----- _xZkqqHx_iDhMiDeDiDjDiDgHjFjEjFgJiCkJiCoHiBeBjFfMiOkGiDhEiDiJiDePiCpAiJpAiPjMiClHiCoJ_xHqqkZx_ -----
//	BOOL bRedraw = FALSE;	// _xZkqqHx_iNmEjFgAiJoGiCkKjFeLjHhGiCkJiBeI_xHqqkZx_
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//	{
//		for (long lIdx = 0; lIdx < (*iObj)->GetMemberSize(); lIdx++)
//		{
//			if ((*iObj)->GetMember(lIdx)->IsKindOf(FDOJ_POINT))
//			{
//				((FCObjPoint*)(*iObj)->GetMember(lIdx))->SetIsVisible(FALSE);
//				g_pView->AddRgn((*iObj)->GetMember(lIdx));
//				bRedraw = TRUE;
//			}
//		}
//	}
//	if (bRedraw) g_pView->PostRgnRedraw();
//	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::OnClearSelectObj(pDC);
//	AfxDebugBreak();
//	m_vLocalObj.clear();
//} // FCToolGroupSelect::OnClearSelectObj.
//----- 05.07.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::CanSelectAll
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiClHiCnHiCmEjBeJjBpAiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolGroupSelect::CanSelectAll () const
//{
//	return !g_pView->SelectObjVector().empty();
//} // FCToolGroupSelect::CanSelectAll.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::OnSelectAll
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiClHiCnHiCmEjBeJjBpAiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiClHiCnHiCmEjBeJjBpAiBhGiCkJiCoH_xHqqkZx_View_xZkqqHx_iCpAjCmKiClFiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolGroupSelect::OnSelectAll ()
//{
//	ObjDynabaseVector vObj;
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//	{
//		for (long lIdx = 0; lIdx < (*iObj)->GetMemberSize(); lIdx++)
//			vObj.push_back((*iObj)->GetMember(lIdx));
//	}
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//	AppendSelectLocalObj(&dc, vObj);
//} // FCToolGroupSelect::OnSelectAll.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::CanClearSelect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpAiJpAiPjMiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolGroupSelect::CanClearSelect () const
//{
//	return !GetSelectLocalObjVector().empty();
//} // FCToolGroupSelect::CanClearSelect.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::OnClearSelect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpAiJpAiPjMiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolGroupSelect::OnClearSelect ()
//{
//	CClientDC dc(g_pView);
//	g_pView->OnPrepareDC(&dc, NULL);
//	ClearSelectLocalObj(&dc);
//} // FCToolGroupSelect::OnClearSelect.
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::CanCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolGroupSelect::CanCopy () const
{
	return !GetSelectLocalObjVector().empty();
} // FCToolGroupSelect::CanCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::OnCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiDfCiDhNiDjDiDgIiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolGroupSelect::OnCopy ()
{
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmJiKnGiCoNiCoJiDiKiDjDiDeOiCmMiCnNiOpLiCnPiClNiDhNiDgMiBfLiDfHiDiDiBfLiCpAiNoMjAkM_xHqqkZx_ -----
	FCLinkManager linkMgr;
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = g_pView->SelectObjVector().begin();
		 iObj != g_pView->SelectObjVector().end(); iObj++)
	{
		// _xZkqqHx_iDePiDiLiBfLiDhGjDoAiDiKiDjDiDeOiCpAiOoGjDlOiBeC_xHqqkZx_
		FCLinkRecVector vLinkRec;
		((FCObjGroup*)*iObj)->GetLink(vLinkRec);
		//----- _xZkqqHx_iDiKiDjDiDeOiCpAjDgPjIfOiClHiCoJ_xHqqkZx_ -----
		for (long lIdx = 0; lIdx < vLinkRec.size(); lIdx++)
		{
			linkMgr.AppendLink(	vLinkRec[lIdx].m_mlpFrom,
								vLinkRec[lIdx].m_mlpTo,
								vLinkRec[lIdx].m_wLinkKind);
		}
	}
	// _xZkqqHx_iDfCiDhDiBfLiBeC_xHqqkZx_
	g_pDoc->OnCopy(GetSelectLocalObjVector(), &linkMgr);
} // FCToolGroupSelect::OnCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::GetSelectLocalObjVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCmFiDiNiBfLiDeKiDiLiCmJjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const ObjDynabaseVector& FCToolGroupSelect::GetSelectLocalObjVector () const
{
	return m_vLocalObj;
} // FCToolGroupSelect::GetSelectLocalObjVector.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolLink.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolGroupSelect::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_

	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case BASE_CLASS::STATE_CANCEL_ENCLOSE_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDeMiDiDiDjDiDfKiDiLiBeC_xHqqkZx_
		iNextState = STATE_CHECK_EXIT_TOOL_BY_BUTTON;		// _xZkqqHx_iDhNiDeFiDfIiDhLiDfOiDjDiCmJiCoGiCoJiDgDiBfLiDiLiPeJjHlJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolGroupSelect::TransFDA.

//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::ClearSelectLocalObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDiNiBfLiDeKiDiLiCmJjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCpAiKeKjFpKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolGroupSelect::ClearSelectLocalObj (CDC* pDC)
//{
//	if (pDC != NULL)
//	{
//		ObjDynabaseVector::iterator iObj;
//		for (iObj = m_vLocalObj.begin(); iObj != m_vLocalObj.end(); iObj++)
//			DrawSelectLocalMark(pDC, *iObj);
//	}
//	m_vLocalObj.clear();
//	// _xZkqqHx_iNmFiMoDiCmJjCmHiJmBiClDiCoKiClNjFjEjFgJiCpAiJpAiPjMiBeC_xHqqkZx_
//	m_pLastSelectObj = NULL;
//	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeC_xHqqkZx_
//	FFGetMainWnd()->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//} // FCToolGroupSelect::ClearSelectLocalObj.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::AppendSelectLocalObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCpAiDgDiBfLiDiLiDiNiBfLiDeKiDiLiCmJjBeJjBpAiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolGroupSelect::AppendSelectLocalObj (CDC* pDC, FCObjDynabase* pObj)
//{
//	// _xZkqqHx_jBeJjBpAiNmPiCnNiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
//	if (IsSelectLocalObj(pObj)) return;
//	if (pDC != NULL)
//	{
//		DrawSelectLocalMark(pDC, pObj);
//	}
//	m_vLocalObj.push_back(pObj);
//	// _xZkqqHx_iNmFiMoDiCmJjCmHiJmBiClDiCoKiClNjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_pLastSelectObj = pObj;
//	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeC_xHqqkZx_
//	FFGetMainWnd()->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//} // FCToolGroupSelect::AppendSelectLocalObj.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::AppendSelectLocalObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCpAiDgDiBfLiDiLiDiNiBfLiDeKiDiLiCmJjBeJjBpAiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolGroupSelect::AppendSelectLocalObj (CDC* pDC, const ObjDynabaseVector& vObj)
//{
//	if (vObj.empty()) return;
//
//	//----- _xZkqqHx_iCnMiClIiBeBiKpJjBlGiCmMjFjEjFgJiCmMiPfHiNiHiCpAiNoMjAkM_xHqqkZx_ -----
//	ObjDynabaseSet stSelected;
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = GetSelectLocalObjVector().begin();
//		 iObj != GetSelectLocalObjVector().end(); iObj++)
//		stSelected.insert(*iObj);
//
//	//----- _xZkqqHx_iKpJjBlGiCmMjFjEjFgJiPfHiNiHiCmJiKnMiCnMiCoKiCmIiCkCjFjEjFgJiCmMiCnNjBeJjBpAjBmOiPnLiCmJ_xHqqkZx_ -----
//	ObjDynabaseVector vNewObj;
//	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
//		if (stSelected.find(*iObj) == stSelected.end())
//			vNewObj.push_back(*iObj);
//
//	if (vNewObj.empty()) return;
//
//	if (pDC != NULL)
//	{
//		ObjDynabaseVector::const_iterator iObj;
//		for (iObj = vNewObj.begin(); iObj != vNewObj.end(); iObj++)
//			DrawSelectLocalMark(pDC, *iObj);
//	}
//	m_vLocalObj.insert(m_vLocalObj.end(), vNewObj.begin(), vNewObj.end());
//	// _xZkqqHx_iNmFiMoDiCmJjCmHiJmBiClDiCoKiClNjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_pLastSelectObj = vNewObj.back();
//	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeC_xHqqkZx_
//	FFGetMainWnd()->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//} // FCToolGroupSelect::AppendSelectLocalObj.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::RemoveSelectLocalObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCpAiBeBiDgDiBfLiDiLiDiNiBfLiDeKiDiLiCmJjBeJjBpAiCkJiCoHiKeKjFpKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolGroupSelect::RemoveSelectLocalObj (CDC* pDC, FCObjDynabase* pObj)
//{
//	ObjDynabaseVector::iterator iObj = find(m_vLocalObj.begin(), m_vLocalObj.end(), pObj);
//	ASSERT(iObj != m_vLocalObj.end());
//	if (pDC != NULL)
//	{
//		DrawSelectLocalMark(pDC, pObj);
//	}
//	m_vLocalObj.erase(iObj);
//	if (pObj == m_pLastSelectObj)
//	//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCkKiNmFiMoDiCmJjBeJjBpAiClDiCoKiClNjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iNmFiMoDiCmJjCmHiJmBiClDiCoKiClNjFjEjFgJiCpAiJpAiPjMiBeC_xHqqkZx_
//		if (m_vLocalObj.empty())
//			m_pLastSelectObj = NULL;
//		else
//			m_pLastSelectObj = m_vLocalObj.back();
//	}
//	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeC_xHqqkZx_
//	FFGetMainWnd()->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//} // FCToolGroupSelect::RemoveSelectLocalObj.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::IsSelectLocalObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCkKiBeBiDiNiBfLiDeKiDiLiCmJjBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCmJiKnMiCnMiCoKiCoJiCkJiCmHiCkEiCkJ_xHqqkZx_
// *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolGroupSelect::IsSelectLocalObj (FCObjDynabase* pObj) const
//{
//	ObjDynabaseVector::const_iterator iObj = find(GetSelectLocalObjVector().begin(), GetSelectLocalObjVector().end(), pObj);
//	return (iObj != GetSelectLocalObjVector().end());
//} // FCToolGroupSelect::IsSelectLocalObj.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::GetLastSelectLocalObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDiNiBfLiDeKiDiLiCmFjBeJjBpAiClDiCoKiClNjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCObjDynabase* FCToolGroupSelect::GetLastSelectLocalObj ()
//{
//	return m_pLastSelectObj;
//} // FCToolGroupSelect::GetLastSelectLocalObj.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::SetLastSelectLocalObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDiNiBfLiDeKiDiLiCmFjBeJjBpAiClDiCoKiClNjFjEjFgJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolGroupSelect::SetLastSelectLocalObj (FCObjDynabase* pObj)
//{
//	if (IsSelectLocalObj(pObj))
//		m_pLastSelectObj = pObj;
//} // FCToolGroupSelect::SetLastSelectLocalObj.
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::CheckHitLocalObject
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCmFiDiNiBfLiDeKiDiLiCmJjBeJjBpAiJmCjEfMiCmIjFjEjFgJjCiGiCmFiBeBiDhNiDeFiDfIiImKjChFiCmJiDhBiDgCiDgH_xHqqkZx_
// *			_xZkqqHx_iClFiCmEiCkCiCoJjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pHitObj	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmNjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolGroupSelect::CheckHitLocalObject (FCObjDynabase*& pHitObj) const
//{
//	CPoint lgptMsc = mm2lg(m_mmptMsc);
//	ObjDynabaseVector::const_reverse_iterator rObj;
//	for (rObj = g_pView->SelectObjVector().rbegin();
//		 rObj != g_pView->SelectObjVector().rend(); rObj++)
//	{
//		for (long lIdx = (*rObj)->GetMemberSize() - 1; 0 <= lIdx; lIdx--)
//		{
//			if ((*rObj)->GetMember(lIdx)->IsIntersect(lgptMsc))
//			{
//				pHitObj = (*rObj)->GetMember(lIdx);
//				return TRUE;
//			}
//		}
//	}
//	return FALSE;
//} // FCToolGroupSelect::CheckHitLocalObject.
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::GetRectInLocalObject
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiLoJiMgAiCmMjDoAjBkEiCmJiBeBiDiNiBfLiDeKiDiLiCmJjBeJjBpAiJmCjEfMiCmIjFjEjFgJiCmFjBlGiNnNiClHiCoJiCoAiCmMiCpA_xHqqkZx_
// *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolGroupSelect::GetRectInLocalObject (ObjDynabaseVector& vObj, const DBLRect& mmrt) const
//{
//	ObjDynabaseVector::const_iterator iObj;
//	for (iObj = g_pView->SelectObjVector().begin();
//		 iObj != g_pView->SelectObjVector().end(); iObj++)
//	{
//		for (long lIdx = (*iObj)->GetMemberSize() - 1; 0 <= lIdx; lIdx--)
//		{
//			if ((*iObj)->GetMember(lIdx)->IsObjInRect(mmrt))
//				vObj.push_back((*iObj)->GetMember(lIdx));
//		}
//	}
//} // FCToolGroupSelect::GetRectInLocalObject.
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::GetSelectedXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiNmPiCnNiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			stXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiIoKjHjHiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vector/set _xZkqqHx_iCmMiCkCiClIiCoKiCmMiMgAiOkOiCmFiCoAjCgMiCpAjFnEiClJiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolGroupSelect::GetSelectedXXX (XXX_ObjDynabase, vector<FCObjDynabase*>* vXxx, set<FCObjDynabase*>* stXxx) const
{
	if (vXxx != NULL)
	//----- vXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		*vXxx = m_vLocalObj;
	}
	if (stXxx != NULL)
	//----- stXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		stXxx->clear();
		FFInsert(*stXxx, m_vLocalObj);
	}
	return m_vLocalObj.size();
} // FCToolGroupSelect::GetSelectedXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::GetSelectableXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmI_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vXxx	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiIoKjHjHiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiIoKjHjHiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCToolGroupSelect::GetSelectableXXX (XXX_ObjDynabase, vector<FCObjDynabase*>* vXxx) const
{
	if (vXxx != NULL)
	//----- vXxx _xZkqqHx_iCpAjFnEiClHiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiJmCjEfMiCmIiChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
		vXxx->clear();
		ObjDynabaseVector::const_iterator iObj;
		for (iObj = g_pView->SelectObjVector().begin();
			 iObj != g_pView->SelectObjVector().end(); iObj++)
		{
			for (long lIdx = 0; lIdx < (*iObj)->GetMemberSize(); lIdx++)
				vXxx->push_back((*iObj)->GetMember(lIdx));
		}
		return vXxx->size();
	} else
	//----- vXxx _xZkqqHx_iCpAjFnEiClDiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		long lSize = 0;
		ObjDynabaseVector::const_iterator iObj;
		for (iObj = g_pView->SelectObjVector().begin();
			 iObj != g_pView->SelectObjVector().end(); iObj++)
			lSize += (*iObj)->GetMemberSize();
		return lSize;
	}
} // FCToolGroupSelect::GetSelectableXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::SelectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiDiKiDfIiDgHiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolGroupSelect::SelectXXX (XXX_ObjDynabase, FCObjDynabase* pObj, CDC* pDC)
{
	// _xZkqqHx_jBeJjBpAiNmPiCnNiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
	if (IsSelectedXXX(XXX_OBJ_BASE, pObj)) return;
	if (pDC != NULL)
		DrawSelectLocalMark(pDC, pObj);
	m_vLocalObj.push_back(pObj);
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeC_xHqqkZx_
//	FFGetMainWnd()->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::SelectXXX(XXX_OBJ_BASE, pObj, pDC);
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	FCToolSelectTmpl<FCToolBaseEdit, FCObjDynabase*, FCToolSelectObjTmplId>::SelectXXX(XXX_OBJ_BASE, pObj, pDC);
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolGroupSelect::SelectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::UnselectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiBeBjBeJjBpAiPpDjBnEiCkJiCoHiKeKjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolGroupSelect::UnselectXXX (XXX_ObjDynabase, FCObjDynabase* pObj, CDC* pDC)
{
	if (pObj == InvalidValueXXX(XXX_OBJ_BASE))
	//----- _xZkqqHx_jBfDiCmEiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		ObjDynabaseVector::const_iterator iObj;
		for (iObj = GetSelectLocalObjVector().begin();
			 iObj != GetSelectLocalObjVector().end(); iObj++)
		{
			if (pDC != NULL)
				DrawSelectLocalMark(pDC, *iObj);
		}
		// _xZkqqHx_jBeJjBpAiCpAiJpAiPjMiBeC_xHqqkZx_
		m_vLocalObj.clear();
	} else
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (pDC != NULL)
			DrawSelectLocalMark(pDC, pObj);
		ObjDynabaseVector::iterator iObj = find(m_vLocalObj.begin(), m_vLocalObj.end(), pObj);
		m_vLocalObj.erase(iObj);
	}
	//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
	//	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeC_xHqqkZx_
	//	FFGetMainWnd()->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
	//----- 05.06.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::UnselectXXX(XXX_OBJ_BASE, pObj, pDC);
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	FCToolSelectTmpl<FCToolBaseEdit, FCObjDynabase*, FCToolSelectObjTmplId>::UnselectXXX(XXX_OBJ_BASE, pObj, pDC);
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolGroupSelect::UnselectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::GetLastSelectedXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjDynabase* FCToolGroupSelect::GetLastSelectedXXX (XXX_ObjDynabase)
{
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// SuperSuperclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	return BASE_BASE_CLASS::GetLastSelectedXXX(XXX_OBJ_BASE);
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return FCToolSelectTmpl<FCToolBaseEdit, FCObjDynabase*, FCToolSelectObjTmplId>::GetLastSelectedXXX(XXX_OBJ_BASE);
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolGroupSelect::GetLastSelectedXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::SetLastSelectedXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJjBeJjBpAiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolGroupSelect::SetLastSelectedXXX (XXX_ObjDynabase, FCObjDynabase* xxx)
{
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// SuperSuperclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_BASE_CLASS::SetLastSelectedXXX(XXX_OBJ_BASE, xxx);
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	FCToolSelectTmpl<FCToolBaseEdit, FCObjDynabase*, FCToolSelectObjTmplId>::SetLastSelectedXXX(XXX_OBJ_BASE, xxx);
//----- 05.07.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolGroupSelect::SetLastSelectedXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::IsIntersectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKiBeBiOhHjCoIiClDiCoKiClNiNmAjFfHiCmGiMpAiNlHiClHiCoJiCkJjClCiNlIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmpt	:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiNlHiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCToolSelectObjTmpl::BASE_CLASS::IsIntersectXXX_xZkqqHx_iCmFiCmNiCmIiCkNiBeB_xHqqkZx_
 *			FCToolBaseEdit::BASE_CLASS::IsIntersectXXX _xZkqqHx_iCmMiDeDiDjDiDhGiDiKiDiBiDjDiDgHiCmFiCkAiCoJ_xHqqkZx_
 *			_xZkqqHx_iClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			_xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiBeBjBeJjBpAiNmPiCnNiCmMiDePiDiLiBfLiDhGjFjEjFgJiCpAiDeOiDiKiDgCiDeOiClFiCmE_xHqqkZx_
 *			_xZkqqHx_jFnCiPfHjBmOiPnLiCkJiCoHiJpAiPjMiClFiClNiCkCiPoKiNiHiBeBiDePiDiLiBfLiDhGjFjEjFgJiCmMiDiBiDjDiDgPiBfLjFjEjFgJiCpA_xHqqkZx_
 *			_xZkqqHx_iDeOiDiKiDgCiDeOiClFiCmEiCoAiBeBiClLiCmMiDiBiDjDiDgPiBfLiCkKjFnCiPfHjBmOiPnLiCmGiClFiCmEjBeJjBpAiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAiNmPiCnNiCmMiDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiBeBiKePjBkEiCmJiDhEiDiMiBfLiDiAiCkKjFfMiOkGiClDiCoKiCmEiCkCiCoJiCmMiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iDhEiDiMiBfLiDiAiCpAiDeOiDiKiDgCiDeOiClHiCoJiClBiCmGiCmFjFnCiPfHjBmOiPnLiCkJiCoHiJpAiPjMiClDiCoKiCoJiCoGiCkEiCmJiBeB_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmFjFjEjFgJiMpAiNlHiCmMiPiIjHjNiCpAjClCjAkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolGroupSelect::IsIntersectXXX (XXX_EditObjDynabase, FCObjDynabase* pObj, const DBLPoint& mmpt) const
{
	// _xZkqqHx_jBeJjBpAiNmPiCnNiCmN_xHqqkZx_ IsSelectedXXX(XXX_EDIT_OBJ_BASE, pObj) _xZkqqHx_iCmFjClCiCnHiClNiCkCiCkKiBeB_xHqqkZx_
	// _xZkqqHx_iDfCiDjDiDhAiDeDiDiJiCkK_xHqqkZx_ XXX_EDIT_OBJ_BASE _xZkqqHx_iCmG_xHqqkZx_ XXX_OBJ_BASE _xZkqqHx_iCmMiIoBiCkCiCpA_xHqqkZx_
	// _xZkqqHx_iCkEiCnMiCkNjEeGiOkPiCmFiCkLiCmIiCkCiClNiCnPiBeB_xHqqkZx_View::IsSelectObj _xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
	if (g_pView->IsSelectObj(pObj))
	//----- _xZkqqHx_jBeJjBpAiNmPiCnNiCmMiDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMjIgHjApMiCmGiCmMiLjHjHkDiCkK_xHqqkZx_ mmMargin _xZkqqHx_iImIjDoAiCmFiCkAiCoKiCmO_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
		const mmetol mmMargin = lg2mm(FD_HIT_TEST_MARGIN);
		if (pObj->GetResizeFrame().ExtendRect(mmMargin).PtInRect(mmpt) &&
			!pObj->GetResizeFrame().ReduceRect(mmMargin).PtInRect(mmpt))
			return TRUE;
	}
	return pObj->IsIntersect(mmpt, FALSE);
} // FCToolGroupSelect::IsIntersectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolGroupSelect::DrawSelectLocalMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFjEjFgJiCmMiBeBiDgDiBfLiDiLiDiNiBfLiDeKiDiLiCmIjBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolGroupSelect::DrawSelectLocalMark (CDC* pDC, FCObjDynabase* pObj)
{
	FCToolBase::DrawSelectMark(pDC, pObj);
} // FCToolGroupSelect::DrawSelectLocalMark.

