#ifndef __ToolRichEditTmpl_h
#define __ToolRichEditTmpl_h

#include "stdafx.h"
#include "DynamicDraw.h"		// For ID_TEXT_STOP_EDIT.
#include "DynamicDrawView.h"	// For g_pView.
#include "FoundDoc.h"			// For g_pDoc.
#include "UtilMisc.h"			// For FFGetCurrentTime.
#include "UtilErr.h"			// For FFMessageBox.
#include "UtilFont.h"			// For FCFontCharInfo.
#include "TextOut.h"			// For FDRC_AL_XXX.
#include "UtilCoord.h"			// For lg2mm.
#include "UtilDlg.h"			// For FD_MENU_TOOL_XXX.
#include "ObjFigure.h"			// For m_pObjRText.
#include "ObjLabel.h"			// For FCObjLabel.
#include "RichText.h"			// For FCRichText.
#include "WndRichEdit.h"		// For g_pView->GetRTFEditor().
#include "LinkManager.h"		// For g_pDoc->LinkManager().
#include "SearchParser.h"		// For FCSearchParser.
#include "DlgTextMargin.h"		// For CFCDlgTextMargin.
#include "DlgTextLine.h"		// For CFCDlgTextLine.
#include "DlgFindText.h"		// For CFCDlgFindText.
#include "DlgReplaceText.h"		// For CFCDlgReplaceText.
#include "DlgFontSelect.h"		// For CFCDlgFontSelect.
#include "DlgFindNextContinue.h" // For CFCDlgFindNextContinue.
#include "DlgFindPrevContinue.h" // For CFCDlgFindPrevContinue.
#include "DlgReplaceContinueA.h" // For CFCDlgReplaceContinueA.

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS SUPER

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	class FCToolRichEditTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjFnCiPfHiClHiCoJiDgDiBfLiDiLiCmMiInHiCmM_xHqqkZx_template_xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_
 *			FCToolBaseCreate_xZkqqHx_iBeB_xHqqkZx_FCToolBase_xZkqqHx_jDjJiCmMiDfEiDhFiDeOiDiJiDfIiCmGiClFiCmEiNoMjAkMiClDiCoKiBeB_xHqqkZx_
 *			_xZkqqHx_iClDiCoHiCmJiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmGiClFiCmE_xHqqkZx_FCToolRichText,FCToolRichEdit_xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER> class FCToolRichEditTmpl : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;
typedef BASE_CLASS::BASE_CLASS BASE_BASE_CLASS;

public:
	FCToolRichEditTmpl ();

	//----- _xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmFjEeDiInD_xHqqkZx_ -----
	virtual void	OnSetFocus (CWnd* pOldWnd);

// 05.06.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	OnZoomChanged ();

// 05.06.30 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL	CanSetCurrentTextFont () const;
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	OnTextInflateFontSize ();
	virtual void	OnTextDeflateFontSize ();
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.06.29 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	GetCurrentTextFont (FCFontCharInfo& fciExtFontInfo, FCFontCharInfo& fciStdFontInfo) const;
	virtual BOOL	SetCurrentTextFont (const FCFontCharInfo& fciExtFontInfo, const FCFontCharInfo& fciStdFontInfo);
//----- 05.06.29 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual void	Unselect (CDC* pDC);
	virtual BOOL	CanSelectTool () const;

	virtual BOOL	CanDelete () const;
	virtual void	OnDelete (CDC* pDC);
	virtual BOOL	CanBackspace () const;
	virtual void	OnBackspace (CDC* pDC);

	virtual BOOL	CanUndo () const;
	virtual void	OnUndo ();
	virtual BOOL	CanRedo () const;
	virtual void	OnRedo ();

	virtual BOOL	CanSelectAll () const;
	virtual void	OnSelectAll ();
	virtual BOOL	CanClearSelect () const;
	virtual void	OnClearSelect ();
	virtual BOOL	CanSelectNext () const;
	virtual void	OnSelectNext ();

	virtual BOOL	CanFindText () const;
	virtual BOOL	CanFindNextText () const;
	virtual void	OnFindNextText ();
	virtual BOOL	CanFindPrevText () const;
	virtual void	OnFindPrevText ();

	virtual BOOL	CanReplaceText () const;
	virtual BOOL	CanReplaceNextText () const;
	virtual void	OnReplaceNextText ();
	virtual BOOL	CanReplacePrevText () const;
	virtual void	OnReplacePrevText ();
	virtual BOOL	CanReplaceTextAll () const;
	virtual void	OnReplaceTextAll ();

	virtual BOOL	CanCopy () const;
	virtual void	OnCopy ();
	virtual BOOL	CanPaste () const;
	virtual void	OnPaste (CDC* pDC);
	virtual BOOL	CanPasteSpec (UINT dwFormat) const;
	virtual void	OnPasteSpec (CDC* pDC, UINT dwFormat);
	virtual BOOL	CanFormatText () const;
	virtual void	OnFormatText ();
	virtual BOOL	CanTextLine () const;
	virtual void	OnTextLine ();
	virtual BOOL	CanTextMargin () const;
	virtual void	OnTextMargin ();
	virtual BOOL	CanAlignText () const;
	virtual int		GetTextAlignment () const;
	virtual void	OnAlignText (int iAlign);
	virtual BOOL	CanVertAlignText () const;
	virtual int		GetTextVertAlignment () const;
	virtual void	OnVertAlignText (int iAlign);

	virtual BOOL	CanObjectPutRtfObj () const;
	virtual void	OnObjectPutRtfObj ();

	virtual BOOL	IsEditingText () const;
	virtual void	OnStopToEditText ();

	virtual BOOL	CanZoomView () const;

// 06.11.26 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL	CanLockStatus () const;

	virtual BOOL	CanHandle (const FCObjDynabase* pObj) const;
	virtual BOOL	IsObjectCommandEnable (DWORD dwCmdID) const;

protected:

	//----- _xZkqqHx_iMjPiNpFiBeFjChFiKlHiDfPiDeDiDeBiDiNiDePiKnGjIeB_xHqqkZx_ -----
	virtual BOOL	CanSpecifySearchChipText () const;
	virtual BOOL	CanSpecifySearchLayer () const;
//----- 05.08.16 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	IsAvailableFindTextAll () const;
	virtual BOOL	IsAvailableFindTextAllInSelect () const;
	virtual BOOL	IsAvailableReplaceTextAllInSelect () const;
//----- 05.08.16 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeMiCmMiKnGjAjE_xHqqkZx_ -----
	virtual void	StartToEditText (FCObjFigure* pFig, FCObjDynabase* pTop, const DBLPoint* mmptCaret);
	virtual void	StopToEditText ();

// 06.04.08 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	EndOfSession ();

	//----- FCToolBaseFDA_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjFeLjHhGiCmJiJjOiClGiCmE_xHqqkZx_ -----
	virtual int		TransFDA (int iState, int iEvent);
// 05.06.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	StateFDA (int iState, CDC* pDC);

	//----- _xZkqqHx_jBeKiInKiPpDjBnEiPiIjHjNiBgJiDeJiBfLiDgPiBfLiDiJiDeDiDgIiBgK_xHqqkZx_ -----
	virtual void	StateIdle (CDC* pDC);			// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
// 06.03.31 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	StateExitToolByButton (CDC* pDC);		// _xZkqqHx_iDgDiBfLiDiLiPeJjHlJiBeC_xHqqkZx_

	//----- FCToolBaseFDA_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmFjFeLjHhGiCmJiJjOiClGiCmE_xHqqkZx_ -----
	virtual int		GetSubMenuIndex () const;

protected:
	//----- _xZkqqHx_jFnCiPfHjCiGiCmMiDiPiBfLiDeOjFmPjAjE_xHqqkZx_ -----
	FCObjFigure*	m_pTextObj;			// _xZkqqHx_iMlLiNnNjFnCiPfHjCiGiCmMjFjEjFgJiBeC_xHqqkZx_
	FCObjDynabase*		m_pTopObj;			// m_pTextObj _xZkqqHx_iCmMiDgHiDgCiDhGiDiMiDhIiDiLjFjEjFgJiBeC_xHqqkZx_
	FCRichText*		m_pRichText;		// _xZkqqHx_iMlLiNnNjFnCiPfHjCiGiCmMiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
	BOOL			m_bIsNewText;		// _xZkqqHx_iDgFiDeMiDfIiDgHjAfGiLeLiNoMjAkMiBeI_xHqqkZx_
}; // class FCToolRichEditTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::FCToolRichEditTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
FCToolRichEditTmpl<SUPER>::FCToolRichEditTmpl ()
{
	m_pTextObj = NULL;		// _xZkqqHx_jFnCiPfHjCiGiCmMjFjEjFgJiBeC_xHqqkZx_
	m_pTopObj = NULL;		// _xZkqqHx_jAgFjFjEjFgJiBeC_xHqqkZx_
	m_pRichText = NULL;		// _xZkqqHx_iMlLiNnNjFnCiPfHjCiGiCmMiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
	m_bIsNewText = FALSE;	// _xZkqqHx_iDgFiDeMiDfIiDgHjAfGiLeLiNoMjAkMiBeI_xHqqkZx_
} // FCToolRichEditTmpl<SUPER>::FCToolRichEditTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnSetFocus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CView_xZkqqHx_iCmJiDhEiDeIiBfLiDeKiDfIiCkKjHiIiClNiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pOldWnd	: _xZkqqHx_iClBiCmMjBePiCmJiDhEiDeIiBfLiDeKiDfIiCkKiCkAiCmBiClNiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnSetFocus (CWnd* pOldWnd)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsEditingText())
	{
		g_pView->GetRTFEditor()->SetFocus();
	}
} // FCToolRichEditTmpl<SUPER>::OnSetFocus.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnZoomChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLiCmMiDfJiBfLiDiAiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnZoomChanged ()
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiCmJiCmNiBeBiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmMiDfEiDeDiDfJiCmGiImKjChFiCoAjFmPiNfIiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	if (IsEditingText() &&
		!g_pView->GetRTFEditor()->IsFullScreenEditMode())
	{
		DBLRect mmrtRTFEditor;
		g_pView->GetRTFEditor()->GetWindowRectMM(mmrtRTFEditor);
		g_pView->GetRTFEditor()->MoveWindowMM(mmrtRTFEditor);
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnZoomChanged();
} // FCToolRichEditTmpl<SUPER>::OnZoomChanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanSetCurrentTextFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBiDhEiDeIiDjDiDgHiCmJiKnGiClHiCoJiPoOjFpBiCkKjAnNjCoIiCmFiCkLiCoJiCkJiCmHiCkEiCkJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanSetCurrentTextFont () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiCmJiCmNiJmCjEfMiBeC_xHqqkZx_
	if (IsEditingText()) return TRUE;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::CanSetCurrentTextFont();
} // FCToolRichEditTmpl<SUPER>::CanSetCurrentTextFont.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnTextInflateFontSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiDhEiDeIiDjDiDgHiDfEiDeDiDfJiCpA_xHqqkZx_
 *			_xZkqqHx_iCfAjCgJjBoFiCkLiCkNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnTextInflateFontSize ()
{
	if (IsEditingText())
	{
		g_pView->GetRTFEditor()->InflateFontSize();
//----- 06.03.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDhCiDiFiBfLiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeCjFmPiNfIiCpAiDgDiBfLiDiLiDgPiBfLiCmJjElNiJgGiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
		g_pView->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//----- 06.03.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	} else
	{
		BASE_CLASS::OnTextInflateFontSize();
	}
} // FCToolRichEditTmpl<SUPER>::OnTextInflateFontSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnTextDeflateFontSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDgFiDeMiDfIiDgHiCmMiBeBjFfHiPiAiBeFjFfHiPiAiKePiDhEiDeIiDjDiDgHiLkEjCmKiCmMiBeBiDhEiDeIiDjDiDgHiDfEiDeDiDfJiCpA_xHqqkZx_
 *			_xZkqqHx_iCfAjCgJiPkMiClDiCkNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnTextDeflateFontSize ()
{
	if (IsEditingText())
	{
		g_pView->GetRTFEditor()->DeflateFontSize();
//----- 06.03.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDhCiDiFiBfLiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeCjFmPiNfIiCpAiDgDiBfLiDiLiDgPiBfLiCmJjElNiJgGiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
		g_pView->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//----- 06.03.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	} else
	{
		BASE_CLASS::OnTextDeflateFontSize();
	}
} // FCToolRichEditTmpl<SUPER>::OnTextDeflateFontSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::GetCurrentTextFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiBeBiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjEmNiImNiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fciExtFontInfo	:_xZkqqHx_jFfHiPiAiKePiDhEiDeIiDjDiDgHiCmMiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			fciStdFontInfo	:_xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiCmMiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCpAiOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::GetCurrentTextFont (FCFontCharInfo& fciExtFontInfo, FCFontCharInfo& fciStdFontInfo) const
{
	if (IsEditingText())
	{
		// _xZkqqHx_iMlLiNnNiCmMiImKjChFiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		g_pView->GetRTFEditor()->GetCurCharInfo(fciExtFontInfo, fciStdFontInfo);
		return TRUE;
	} else
	{
		return BASE_CLASS::GetCurrentTextFont(fciExtFontInfo, fciStdFontInfo);
	}
} // FCToolRichEditTmpl<SUPER>::GetCurrentTextFont.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::SetCurrentTextFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiBeBiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjEmNiImNiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fciExtFontInfo	:_xZkqqHx_jFfHiPiAiKePiDhEiDeIiDjDiDgHiCmMiPoOjFpBiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			fciStdFontInfo	:_xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiCmMiPoOjFpBiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCpAjAnNjCoIiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::SetCurrentTextFont (const FCFontCharInfo& fciExtFontInfo, const FCFontCharInfo& fciStdFontInfo)
{
	if (IsEditingText())
	{
		g_pView->GetRTFEditor()->SetCurCharInfo(fciExtFontInfo, fciStdFontInfo);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDhCiDiFiBfLiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeCjFmPiNfIiCpAiDgDiBfLiDiLiDgPiBfLiCmJjElNiJgGiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
		g_pView->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		return TRUE;
	} else
	{
		return BASE_CLASS::SetCurrentTextFont(fciExtFontInfo, fciStdFontInfo);
	}
} // FCToolRichEditTmpl<SUPER>::SetCurrentTextFont.

//----- 01.04.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnContextMenu
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDeOiDiKiDgCiDeOiBfOiDiBiDgKiDiFiBfLiDhLiDfOiDjDiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
// *			lgpt	:_xZkqqHx_iDeOiDiKiDgCiDeOiClDiCoKiClNiImKjChFiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCToolRichEditTmpl<SUPER>::OnContextMenu (CDC* pDC, CPoint lgpt)
//{
//	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
//	if (IsEditingText()) return;
//	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::OnContextMenu(pDC, lgpt);
//} // FCToolRichEditTmpl<SUPER>::OnContextMenu.
//----- 01.04.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 01.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanObjectProperties
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDhGiDiNiDhAiDgFiDeCjFnCiPfHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//BOOL FCToolRichEditTmpl<SUPER>::CanObjectProperties () const
//{
//	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOjFhDiJmCjEfMiBeC_xHqqkZx_
//	return !IsEditingText();
//} // FCToolRichEditTmpl<SUPER>::CanObjectProperties.
//----- 01.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::Unselect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCmMjBeJjBpAiCkKiJpAiPjMiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::Unselect (CDC* pDC)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOjFnCiPfHiPeJjHlJiBeC_xHqqkZx_
	if (IsEditingText()) StopToEditText();
	//----- _xZkqqHx_iMjPiNpFiBeFjChFiKlHiDfPiDeDiDeBiDiNiDePiCpAiJeCiClHiBeCiOjPiJpBiClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiOjOiBeB_xHqqkZx_
	//		_xZkqqHx_iClBiCoKiCoHiCmMiDfPiDeDiDeBiDiNiDePiCkKjFfMiOkGiClDiCoKiCmIiCkCiCoGiCkEiCmJiClHiCoJiClNiCnP_xHqqkZx_ -----
	// _xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePiCpAiJeCiClHiBeC_xHqqkZx_
	if (IsFindDialogVisible())
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		GetFindDialog(this)->ShowWindow(SW_HIDE);
		GetFindDialog(this)->SetWindowVisible(FALSE);
	// _xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePiCpAiJeCiClHiBeC_xHqqkZx_
	if (IsReplaceDialogVisible())
// 05.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		GetReplaceDialog(this)->ShowWindow(SW_HIDE);
		GetReplaceDialog(this)->SetWindowVisible(FALSE);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Unselect(pDC);
} // FCToolRichEditTmpl<SUPER>::Unselect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanSelectTool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanSelectTool () const
{
	if (!FFCanEditObject()) return FALSE;
	return TRUE;
} // FCToolBaseCreate::CanSelectTool.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlNiCkJiClFiCoHiNoNiPjMiJmCjEfMiCmIiCoAiCmMiCpAjBeJjBpAjCiGiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjElLjCgGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiDiBiDgKiDiFiBfLiCmMjHeMiMpIiBfOjGlDiMpIiCpAjAnIiCoIjBnGiCkGiCoJiClNiCnPiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiJmCjEfMiCmIiPoKiNiH_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiH_xHqqkZx_ FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanDelete () const
{
//----- 00.08.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiJmCjEfMiBeC_xHqqkZx_
//	return IsEditingText();
//----- 00.08.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiJmCjEfMiBeC_xHqqkZx_
	if (IsEditingText())
	{
		return TRUE;
	} else
	{
		return BASE_CLASS::CanDelete();
	}
//----- 00.08.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolRichEditTmpl<SUPER>::CanDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjFkIiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnDelete (CDC* pDC)
{
	if (IsEditingText())
		g_pView->GetRTFEditor()->OnDelete();
	else
		BASE_CLASS::OnDelete(pDC);
} // FCToolRichEditTmpl<SUPER>::OnDelete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanBackspace
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	BS_xZkqqHx_iDeMiBfLiCkKjHeMiMpIiBeBjGlDiMpIiCkJiCmHiCkEiCkJiCpAjElLjCgGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanBackspace () const
{
//----- 00.08.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiJmCjEfMiBeC_xHqqkZx_
//	return IsEditingText();
//----- 00.08.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiJmCjEfMiBeC_xHqqkZx_
	if (IsEditingText())
	{
		return TRUE;
	} else
	{
		return BASE_CLASS::CanBackspace();
	}
//----- 00.08.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolRichEditTmpl<SUPER>::CanBackspace.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnBackspace
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	BS_xZkqqHx_iDeMiBfLiCmMiPiIjHjNiCpAiClHiCoJiBeCjCmKiPoNiCmNiNoNiPjMiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnBackspace (CDC* pDC)
{
	if (IsEditingText())
		g_pView->GetRTFEditor()->OnBackspace();
	else
		BASE_CLASS::OnBackspace(pDC);
} // FCToolRichEditTmpl<SUPER>::OnBackspace.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanUndo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Undo_xZkqqHx_iJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanUndo () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiDeHiDgGiDeCiDfOiCmJjGoCiCkCiNiHiCoNiClJiBeC_xHqqkZx_
	if (IsEditingText())
	{
		return g_pView->GetRTFEditor()->CanUndo();
	} else
	{
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		return BASE_CLASS::CanUndo();
	}
} // FCToolRichEditTmpl<SUPER>::CanUndo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnUndo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Undo_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnUndo ()
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiDeHiDgGiDeCiDfOiCmJiPiIjHjNiCpAiCnMiCoNiClHiBeC_xHqqkZx_
	if (IsEditingText())
	{
		g_pView->GetRTFEditor()->Undo();
	} else
	{
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::OnUndo();
	}
} // FCToolRichEditTmpl<SUPER>::OnUndo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanRedo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Redo_xZkqqHx_iJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanRedo () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiDeHiDgGiDeCiDfOiCmJjGoCiCkCiNiHiCoNiClJiBeC_xHqqkZx_
	if (IsEditingText())
	{
		return g_pView->GetRTFEditor()->CanRedo();
	} else
	{
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		return BASE_CLASS::CanRedo();
	}
} // FCToolRichEditTmpl<SUPER>::CanRedo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnRedo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Redo_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnRedo ()
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiDeHiDgGiDeCiDfOiCmJiPiIjHjNiCpAiCnMiCoNiClHiBeC_xHqqkZx_
	if (IsEditingText())
	{
		g_pView->GetRTFEditor()->Redo();
	} else
	{
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::OnRedo();
	}
} // FCToolRichEditTmpl<SUPER>::OnRedo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanSelectAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiClHiCnHiCmEjBeJjBpAiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanSelectAll () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiDeHiDgGiDeCiDfOiCmJjGoCiCkCiNiHiCoNiClJiBeC_xHqqkZx_
	if (IsEditingText())
	{
		return g_pView->GetRTFEditor()->CanSelectAll();
	} else
	{
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		return BASE_CLASS::CanSelectAll();
	}
} // FCToolRichEditTmpl<SUPER>::CanSelectAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnSelectAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiClHiCnHiCmEjBeJjBpAiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiClHiCnHiCmEjBeJjBpAiBhGiCkJiCoH_xHqqkZx_View_xZkqqHx_iCpAjCmKiClFiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnSelectAll ()
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiDeHiDgGiDeCiDfOiCmJiPiIjHjNiCpAiCnMiCoNiClHiBeC_xHqqkZx_
	if (IsEditingText())
	{
		g_pView->GetRTFEditor()->SelectAll();
	} else
	{
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::OnSelectAll();
	}
} // FCToolRichEditTmpl<SUPER>::OnSelectAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanClearSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpAiJpAiPjMiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanClearSelect () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiDeHiDgGiDeCiDfOiCmJjGoCiCkCiNiHiCoNiClJiBeC_xHqqkZx_
	if (IsEditingText())
	{
		long lFrom;
		long lTo;
		g_pView->GetRTFEditor()->GetSelectNormal(lFrom, lTo);
		return (lFrom != lTo);
	} else
	{
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		return BASE_CLASS::CanClearSelect();
	}
} // FCToolRichEditTmpl<SUPER>::CanClearSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnClearSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpAiJpAiPjMiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnClearSelect ()
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiDeHiDgGiDeCiDfOiCmJiPiIjHjNiCpAiCnMiCoNiClHiBeC_xHqqkZx_
	if (IsEditingText())
	{
		g_pView->GetRTFEditor()->SetSelect(-1, -1);
	} else
	{
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::OnClearSelect();
	}
} // FCToolRichEditTmpl<SUPER>::OnClearSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanSelectNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiOjPiCpAjBeJjBpAiBhGiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanSelectNext () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
	if (IsEditingText())
	{
		return TRUE;
	} else
	{
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		return BASE_CLASS::CanSelectNext();
	}
} // FCToolRichEditTmpl<SUPER>::CanSelectNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnSelectNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiOjPiCpAjBeJjBpAiBhGiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiOjPiCpAjBeJjBpAiBhGiCkJiCoH_xHqqkZx_View_xZkqqHx_iCpAjCmKiClFiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnSelectNext ()
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiDeHiDgGiDeCiDfOiCmMjBeJjBpAiCpAiOjPiCnGiBeC_xHqqkZx_
	if (IsEditingText())
	{
		// _xZkqqHx_jBeJjBpAjEmNiImNiCpAiOoGjDlOiBeC_xHqqkZx_
		long lFrom;
		long lTo;
		g_pView->GetRTFEditor()->GetSelectNormal(lFrom, lTo);
		// _xZkqqHx_jEmNiImNiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiMlLiNnNiCmMiDeKiDiMiDgCiDgHiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
		if (lTo == -1)
			lTo = g_pView->GetRTFEditor()->GetCurIndex();
		// _xZkqqHx_jBeJjBpAiImKjChFiCkKiNmFiMoDiCmJjCeCiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeBiOjPiCmMiCfAjFlGiOjKiCpAjBeJjBpAiPpDjBnEiCmJiBeC_xHqqkZx_
		if (lTo < g_pView->GetRTFEditor()->GetIndexSize())
		{
			g_pView->GetRTFEditor()->SetCurIndex(lTo + 1);
			g_pView->GetRTFEditor()->SetSelect(lTo, lTo + 1);
		}
	} else
	{
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::OnSelectNext();
	}
} // FCToolRichEditTmpl<SUPER>::OnSelectNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanFindText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMjPiNpFiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanFindText () const
{
	return (IsEditingText() && FFCanEditDocument());
} // FCToolRichEditTmpl<SUPER>::CanFindText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanFindNextText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMoDjFpLiMjPiNpFiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanFindNextText () const
{
	return IsEditingText();
} // FCToolRichEditTmpl<SUPER>::CanFindNextText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnFindNextText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMoDjFpLiMjPiNpFiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnFindNextText ()
{
	// _xZkqqHx_iOjPiMjPiNpFiCkKjFhDiJmCiCmIiCoHjFjMiLeBiBeC_xHqqkZx_
	if (!CanFindNextText()) return;
	FCSearchParser* pSP = GetSearchParser();
	if (pSP == NULL) return;
	if (!g_pView->GetRTFEditor()->FindNext(*pSP))
	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeJjCfLiCmJjCeCiClFiClNiCmMiCmFiBeBjGoCiCkCiNiHiCoNiClJiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeC_xHqqkZx_
		if (CFCDlgFindNextContinue(TRUE).DoModal() == IDC_FNC_BTN_FROM_TOP)
		//----- _xZkqqHx_iBhFiNmEiCnBiPoDiCkJiCoHiBhGiDhLiDfOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			g_pView->GetRTFEditor()->SetSelect(-1, -1);
			g_pView->GetRTFEditor()->SetCurIndex(0);
			g_pView->PostMessage(WM_COMMAND, ID_EDIT_FIND_NEXT_TEXT);
		}
	}
} // FCToolRichEditTmpl<SUPER>::OnFindNextText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanFindPrevText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBePjFpLiMjPiNpFiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanFindPrevText () const
{
	return IsEditingText();
} // FCToolRichEditTmpl<SUPER>::CanFindPrevText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnFindPrevText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBePjFpLiMjPiNpFiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnFindPrevText ()
{
	// _xZkqqHx_jBePiMjPiNpFiCkKjFhDiJmCiCmIiCoHjFjMiLeBiBeC_xHqqkZx_
	if (!CanFindPrevText()) return;
	FCSearchParser* pSP = GetSearchParser();
	if (pSP == NULL) return;
	if (!g_pView->GetRTFEditor()->FindPrev(*pSP))
	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeJjCfLiCmJjCeCiClFiClNiCmMiCmFiBeBjGoCiCkCiNiHiCoNiClJiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeC_xHqqkZx_
		if (CFCDlgFindPrevContinue(TRUE).DoModal() == IDC_FPC_BTN_FROM_BOTTOM)
		//----- _xZkqqHx_iBhFiNmEiCnBiJlKiCkJiCoHiBhGiDhLiDfOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			g_pView->GetRTFEditor()->SetSelect(-1, -1);
			g_pView->GetRTFEditor()->SetCurIndex(g_pView->GetRTFEditor()->GetIndexSize());
			g_pView->PostMessage(WM_COMMAND, ID_EDIT_FIND_PREV_TEXT);
		}
	}
} // FCToolRichEditTmpl<SUPER>::OnFindPrevText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanReplaceText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanReplaceText () const
{
	return (IsEditingText() && FFCanEditDocument());
} // FCToolRichEditTmpl<SUPER>::CanReplaceText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanReplaceNextText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMoDjFpLjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanReplaceNextText () const
{
	return IsEditingText();
} // FCToolRichEditTmpl<SUPER>::CanReplaceNextText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnReplaceNextText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiMoDjFpLjChFiKlHiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnReplaceNextText ()
{
	// _xZkqqHx_iOjPjChFiKlHiCkKjFhDiJmCiCmIiCoHjFjMiLeBiBeC_xHqqkZx_
	if (!CanReplaceNextText()) return;
	FCSearchParser* pSP = GetSearchParser();
	if (pSP == NULL) return;
	// _xZkqqHx_iMlLiNnNjBeJjBpAjCiGiCmMjEmNiImNiCmMjChFiKlHiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
	long lFrom, lTo;
	if (g_pView->GetRTFEditor()->ReplaceOne(lFrom, lTo, *pSP))
	//----- _xZkqqHx_jChFiKlHiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jChFiKlHiMoDiCmMjEmNiImNiCmMiMoDiImKjChFiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
		g_pView->GetRTFEditor()->SetCurIndex(lTo);
	}
	g_pView->PostMessage(WM_COMMAND, ID_EDIT_FIND_NEXT_TEXT);
} // FCToolRichEditTmpl<SUPER>::OnReplaceNextText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanReplacePrevText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBePjFpLjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanReplacePrevText () const
{
	return IsEditingText();
} // FCToolRichEditTmpl<SUPER>::CanReplacePrevText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnReplacePrevText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBePjFpLjChFiKlHiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnReplacePrevText ()
{
	// _xZkqqHx_jBePjChFiKlHiCkKjFhDiJmCiCmIiCoHjFjMiLeBiBeC_xHqqkZx_
	if (!CanReplacePrevText()) return;
	FCSearchParser* pSP = GetSearchParser();
	if (pSP == NULL) return;
	// _xZkqqHx_iMlLiNnNjBeJjBpAjCiGiCmMjEmNiImNiCmMjChFiKlHiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
	long lFrom, lTo;
	if (g_pView->GetRTFEditor()->ReplaceOne(lFrom, lTo, *pSP))
	//----- _xZkqqHx_jChFiKlHiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jChFiKlHiMoDiCmMjEmNiImNiCmMjBePiImKjChFiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
		g_pView->GetRTFEditor()->SetCurIndex(lTo);
	}
	g_pView->PostMessage(WM_COMMAND, ID_EDIT_FIND_PREV_TEXT);
} // FCToolRichEditTmpl<SUPER>::OnReplacePrevText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanReplaceTextAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBfDjChFiKlHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanReplaceTextAll () const
{
	return (IsEditingText() && FFCanEditDocument());
} // FCToolRichEditTmpl<SUPER>::CanReplaceTextAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnReplaceTextAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjBfDjChFiKlHiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnReplaceTextAll ()
{
	// _xZkqqHx_jBePjChFiKlHiCkKjFhDiJmCiCmIiCoHjFjMiLeBiBeC_xHqqkZx_
	if (!CanReplacePrevText()) return;
	FCSearchParser* pSP = GetSearchParser();
	if (pSP == NULL) return;
	// _xZkqqHx_iMlLiNnNiCmMiDeKiDiMiDgCiDgHiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
	long lCurIndex = g_pView->GetRTFEditor()->GetCurIndex();
	// _xZkqqHx_iDeKiDiMiDgCiDgHiImKjChFiImIiNhOiCpAjBfDiCmEjChFiKlHiBeC_xHqqkZx_
	g_pView->GetRTFEditor()->ReplaceAll(*pSP);
	//----- _xZkqqHx_iMhAjBlBiDfPiDeDiDeBiDiNiDePiCmMiPiIjHjN_xHqqkZx_ -----
	if (lCurIndex != 0)
	//----- _xZkqqHx_jDhCjCiGiCkJiCoHjChFiKlHiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeJjCfLiCmJjCeCiClFiClNiCmMiCmFiBeBjGoCiCkCiNiHiCoNiClJiDfPiDeDiDeBiDiNiDePjFfMiOkGiBeC_xHqqkZx_
		if (CFCDlgReplaceContinueA(TRUE).DoModal() == IDC_RLC_BTN_FROM_TOP)
		//-----_xZkqqHx_iBhFiNmEiCnBiPoDiCkJiCoHiBhGiDhLiDfOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeKiDiMiDgCiDgHiImKjChFiCpAiDgHiDgCiDhGiCnGiBeC_xHqqkZx_
			g_pView->GetRTFEditor()->SetCurIndex(0);
			g_pView->PostMessage(WM_COMMAND, ID_EDIT_REPLACE_TEXT_ALL);
		}
	} else
	//----- _xZkqqHx_iIoKjEnEiPoDiCkJiCoHjChFiKlHiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iBhFjBfDiCmEiCpAjChFiKlHiClFiCnMiClFiClNiBhGiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
		::FFErrorBox(IDS_MSG_REPLACED_ALL);
	}
} // FCToolRichEditTmpl<SUPER>::OnReplaceTextAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanCopy () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsEditingText())
	{
		return g_pView->GetRTFEditor()->CanCopy();
	} else
	{
		return BASE_CLASS::CanCopy();
	}
} // FCToolRichEditTmpl<SUPER>::CanCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiDfCiDhNiDjDiDgIiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiCoJ_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnCopy ()
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsEditingText())
	{
		g_pView->GetRTFEditor()->OnCopy();
	} else
	{
		BASE_CLASS::OnCopy();
	}
} // FCToolRichEditTmpl<SUPER>::OnCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanPaste
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfIiDgHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmJiDhJiBfLiDfIiDgHiJmCjEfMiCmIiDgGiBfLiDfOiCmGiClFiCmEiCmNiBeBjFkKiCkJiCmBiCmEiCkCiCoJ_xHqqkZx_
 *			_xZkqqHx_iCoAiCmMiCmFiImIiJlKiCkKiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iBeF_xHqqkZx_DD3_TEXT
 *			_xZkqqHx_iBeF_xHqqkZx_RTF
 *			_xZkqqHx_iBeF_xHqqkZx_UNICODETEXT (NT,2000,XP)
 *			_xZkqqHx_iBeF_xHqqkZx_TEXT
 *			_xZkqqHx_iCoAiClFiCkJiClFiClNiCoHiBeBiClBiCoKiImIiKePiCmJiCoAiCkAiCoJiCkJiCoAiClFiCoKiCmIiCkCiBgJjHoBiCkGiCmO_xHqqkZx_HTML_xZkqqHx_iCmIiCmHiBgKiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeB_xHqqkZx_CanPaste_xZkqqHx_iCpAjClCiCnHiCoJiOoIiPiHiCmGiClFiCmEiCmNiBeBiImIiJlKiCmGiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeE_xHqqkZx_DD3_TEXT _xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCkKiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmJjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeE_xHqqkZx_DD3_TEXT _xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_RICHEDIT_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJ_xHqqkZx_
 *				_xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiDgGiBfLiDfOiCpAjDfMiCoIjFhEiCkPiJmCjEfMiCkJjGoCiCkCiNiHiCoNiClJiCoJiBeC_xHqqkZx_
 *			RICHEDIT_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJjGoCiCkCiNiHiCoNiClJiCoJiClBiCmGiCmFiBeBjGkCjCgNiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCoA_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCoJiClBiCmGiCkKiCmFiCkLiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jCeBiClFiBeB_xHqqkZx_RICHEDIT_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmNiBeB_xHqqkZx_DD3_FILE/EMF/WMF_xZkqqHx_jDjJiCoAjDfMiCoIjFhEiCkPiJmCjEfMiCmG_xHqqkZx_
 *			_xZkqqHx_jElLjCgGiClFiCmEiCkCiCoJiDhEiDfGiCkKiCkAiCoJiBgJ_xHqqkZx_DD3_xZkqqHx_iCmMjCmKiPoNiCmMjFjEjFgJiDfCiDhDiBfLiCmFiCoAiBeB_xHqqkZx_
 *			RICHEDIT_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmNjDfMiCoIjFhEiCkPiJmCjEfMiCmGjFnEiClHiBgKiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeB_xHqqkZx_Paste_xZkqqHx_iKnGjAjEiCmFiCmNiBeBiImIiJlKiCmMiOoIiPiHiCpAiOoGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeEiImIiJlKiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCmMiPiHiCmJiBeBiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCmMjBlGiNnNiCpAjClCiCnHiBeBjBlGiNnNiClHiCoJ_xHqqkZx_
 *				_xZkqqHx_iPoKiNiHiCmNiClLiCmMiMgAiOkOiCmFjDfMiCoIjFhEiCkPiCoJiBeC_xHqqkZx_
 *				_xZkqqHx_iHeA_xHqqkZx_ DD3_TEXT
 *				_xZkqqHx_iHeB_xHqqkZx_ RTF
 *				_xZkqqHx_iHeC_xHqqkZx_ UNICODETEXT (NT,2000,XP)
 *				_xZkqqHx_iHeD_xHqqkZx_ TEXT
 *			_xZkqqHx_iCfBiBeEiCkCiClIiCoKiCmMiMgAiOkOiCoAjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeBiDhEiDeIiBfLiDhNiDgCiDgHiCpAiOhHjCoIiClJiClI_xHqqkZx_
 *				RICHEDIT_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDeOiDiKiDgCiDhGiDhLiBfLiDgIiDgGiBfLiDfOiCpAjDfMiCoIjFhEiCkPiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *			05.07.10 Fukushiro M. _xZkqqHx_iPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanPaste () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsEditingText())
	{
		return g_pView->GetRTFEditor()->CanPaste();
	} else
	{
		return BASE_CLASS::CanPaste();
	}
} // FCToolRichEditTmpl<SUPER>::CanPaste.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnPaste
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfIiDgHiDfCiDhNiDjDiDgIiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiCoJ_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnPaste (CDC* pDC)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsEditingText())
	{
		g_pView->GetRTFEditor()->OnPaste();
	} else
	{
		BASE_CLASS::OnPaste(pDC);
	}
} // FCToolRichEditTmpl<SUPER>::OnPaste.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanPasteSpec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiMgAiOkOiCmFiDhJiBfLiDfIiDgHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwFormat:_xZkqqHx_iDhJiBfLiDfIiDgHiClFiCoGiCkEiCmGiClHiCoJiDgGiBfLiDfOiMgAiOkOiBeCiMgAiOkOiCpAjDmBjCoIiClFiCmIiCkC_xHqqkZx_
 *					 _xZkqqHx_iPoKiNiHiCmNiCePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.04 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanPasteSpec (UINT dwFormat) const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsEditingText())
	{
		return g_pView->GetRTFEditor()->CanPasteSpec(dwFormat);
	} else
	{
		return BASE_CLASS::CanPasteSpec(dwFormat);
	}
} // FCToolRichEditTmpl<SUPER>::CanPasteSpec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnPasteSpec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiMgAiOkOiCmFiDeOiDiKiDgCiDhGiDhLiBfLiDgIiCkJiCoHiDhJiBfLiDfIiDgHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC			:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *			dwFormat	:_xZkqqHx_iDhJiBfLiDfIiDgHiClHiCoJiDgGiBfLiDfOiMgAiOkOiBeC_xHqqkZx_0_xZkqqHx_iCmIiCoHiCmOiOkJjDkOjElLjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	1. _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCkJiCoHiCmMjFjEjFgJiCmMiNoMjAkMiPiIjHjNiBeC_xHqqkZx_
 *			2. _xZkqqHx_iNoMjAkMiClDiCoKiClNjFjEjFgJiCmMiInKjDkOjHmKiMhGiOfKiBeC_xHqqkZx_
 *			3. _xZkqqHx_iKgHjCkDiDfGiBfLiDgHiCmMiDhEiDiMiBfLiDiAiCpAiNgMjHlGiClFiCmEiInKjDkOjHmKiCpAjFoCjAlDiBeC_xHqqkZx_
 *			4. _xZkqqHx_jFjEjFgJiCmMiInKjDkOiPiIjHjNiBeC_xHqqkZx_
 *			5. _xZkqqHx_iOjPiJpBiDhJiBfLiDfIiDgHiCmJjEpFiCkGiCmEiPiAjEpFiBeC_xHqqkZx_
 *			6. _xZkqqHx_iDhJiBfLiDfIiDgHjFjEjFgJiCmMjBeJjBpAiLhJiCnBiNmEjFgAiJoGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.04 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnPasteSpec (CDC* pDC, UINT dwFormat)
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsEditingText())
	{
		g_pView->GetRTFEditor()->OnPasteSpec(dwFormat);
	} else
	{
		BASE_CLASS::OnPasteSpec(pDC, dwFormat);
	}
} // FCToolRichEditTmpl<SUPER>::OnPasteSpec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanFormatText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCkKjAnNjCoIiJmCjEfMiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanFormatText () const
{
	return IsEditingText();
} // FCToolRichEditTmpl<SUPER>::CanFormatText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myGetFontInfoProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCpAiOoGjDlOiClHiCoJiClNiCnPiCmMiKnGjAjEiBeCiDhEiDeIiDjDiDgHiDfPiDeDiDeBiDiNiDePiCmM_xHqqkZx_
 *			_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fciAnsi	:_xZkqqHx_iJhAiMoKiDhEiDeIiDjDiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			fciSjis	:_xZkqqHx_jDpKjGhLiMoKiDhEiDeIiDjDiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			pData	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myGetFontInfoProc (	FCFontCharInfo& fciAnsi,
								FCFontCharInfo& fciSjis, void* pData)
{
	// _xZkqqHx_iMlLiNnNiCmMiImKjChFiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	g_pView->GetRTFEditor()->GetCurCharInfo(fciAnsi, fciSjis);
} // myGetFontInfoProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mySetFontInfoProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHiPoOjFpBiCpAjAnNjCoIiClHiCoJiClNiCnPiCmMiKnGjAjEiBeCiDhEiDeIiDjDiDgHiDfPiDeDiDeBiDiNiDePiCmM_xHqqkZx_
 *			_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fciAnsi	:_xZkqqHx_iJhAiMoKiDhEiDeIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fciSjis	:_xZkqqHx_jDpKjGhLiMoKiDhEiDeIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pData	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void mySetFontInfoProc (const FCFontCharInfo& fciAnsi,
								const FCFontCharInfo& fciSjis, void* pData)
{
	g_pView->GetRTFEditor()->SetCurCharInfo(fciAnsi, fciSjis);
//----- 06.05.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhCiDiFiBfLiCmJjBeJjBpAjFmPiNfIjCmKjCgNiBeCjFmPiNfIiCpAiDgDiBfLiDiLiDgPiBfLiCmJjElNiJgGiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
	g_pView->PostMessage(WM_USER_OBJ_SELECT_CHANGED);
//----- 06.05.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // mySetFontInfoProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnFormatText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDhEiDeIiDjDiDgHiCmMjAnNjCoIiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnFormatText ()
{
	CFCDlgFontSelect dlg;
	dlg.SetCallback(myGetFontInfoProc, mySetFontInfoProc, NULL);
	(void)dlg.DoModal();
} // FCToolRichEditTmpl<SUPER>::OnFormatText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanTextLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiNhDiKnEiCkKjAnNjCoIiJmCjEfMiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanTextLine () const
{
	return IsEditingText();
} // FCToolRichEditTmpl<SUPER>::CanTextLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnTextLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiNhDiKnEiCmMjAnNjCoIiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnTextLine ()
{
	CFCDlgTextLine dlg;
	dlg.SetTextEditor(g_pView->GetRTFEditor());
	dlg.DoModal();
} // FCToolRichEditTmpl<SUPER>::OnTextLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanTextMargin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjHfNjEjCiCkKjAnNjCoIiJmCjEfMiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanTextMargin () const
{
	return IsEditingText();
} // FCToolRichEditTmpl<SUPER>::CanTextMargin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnTextMargin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjHfNjEjCiCmMjAnNjCoIiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnTextMargin ()
{
	CFCDlgTextMargin dlg;
	dlg.SetTextEditor(g_pView->GetRTFEditor());
	dlg.DoModal();
} // FCToolRichEditTmpl<SUPER>::OnTextMargin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanAlignText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKpBiClJiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpBiClJiCoJiClBiCmGiCkKiPgPjHiIiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeDjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanAlignText () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsEditingText())
		return TRUE;
	else
		return BASE_CLASS::CanAlignText();
} // FCToolRichEditTmpl<SUPER>::CanAlignText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::GetTextAlignment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKpBiClJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpBiClJiCkKjFhDjGlOiCmMiPoKiNiHiCmNiCePiBeDiClLiCoKiImIiKePiCmNiKpBiClJiCpAjFnEiClHiBeC_xHqqkZx_WndRichEdit.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
int FCToolRichEditTmpl<SUPER>::GetTextAlignment () const
{
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
//	if (IsEditingText())
//		return g_pView->GetRTFEditor()->GetAlignment();
//	else
//		return FDRC_AL_NONE;
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsEditingText())
	{
		//----- _xZkqqHx_iDeHiDgGiDeCiDfOiCkJiCoHjBkOjAkLiCpAiOoGjDlO_xHqqkZx_ -----
		FCTextLineInfo tli;
		g_pView->GetRTFEditor()->GetCurLineInfo(tli);
		if (tli.dwMask & FDTL_FLAG_ALIGNMENT)
			return tli.byAlignment;
		else
			return FDRC_AL_NONE;
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::GetTextAlignment();
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolRichEditTmpl<SUPER>::GetTextAlignment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnAlignText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiKpBiClJiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iAlign	:_xZkqqHx_iKpBiClJiCoJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_WndRichEdit.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnAlignText (int iAlign)
{
	// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDkPiClGiCmIiCoHiCmOiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
	if (GetTextAlignment() == iAlign) return;
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsEditingText())
	{
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		g_pView->GetRTFEditor()->SetAlignment(iAlign);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FCTextLineInfo tli;
		tli.dwMask = FDTL_FLAG_ALIGNMENT;
		tli.byAlignment = BYTE(iAlign);
		g_pView->GetRTFEditor()->SetCurLineInfo(tli);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	} else
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	{
		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::OnAlignText(iAlign);
	}
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolRichEditTmpl<SUPER>::OnAlignText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanVertAlignText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiPoDiJlKiKpBiClJiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpBiClJiCoJiClBiCmGiCkKiPgPjHiIiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeDjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanVertAlignText () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsEditingText())
		return TRUE;
	else
		return BASE_CLASS::CanVertAlignText();
} // FCToolRichEditTmpl<SUPER>::CanVertAlignText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::GetTextVertAlignment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMiPoDiJlKiKpBiClJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKpBiClJiCkKjFhDjGlOiCmMiPoKiNiHiCmNiCePiBeDiClLiCoKiImIiKePiCmNiKpBiClJiCpAjFnEiClHiBeC_xHqqkZx_WndRichEdit.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
int FCToolRichEditTmpl<SUPER>::GetTextVertAlignment () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsEditingText())
		return g_pView->GetRTFEditor()->GetVertAlignment();
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	else
//		return FDRC_AL_NONE;
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::GetTextVertAlignment();
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolRichEditTmpl<SUPER>::GetTextVertAlignment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnVertAlignText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiPoDiJlKiKpBiClJiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iAlign	:_xZkqqHx_iKpBiClJiCoJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_WndRichEdit.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnVertAlignText (int iAlign)
{
	// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDkPiClGiCmIiCoHiCmOiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
	if (GetTextVertAlignment() == iAlign) return;
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiHiBeC_xHqqkZx_
	if (IsEditingText())
	{
		g_pView->GetRTFEditor()->SetVertAlignment(iAlign);
	} else
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	{
		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::OnVertAlignText(iAlign);
	}
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolRichEditTmpl<SUPER>::OnVertAlignText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanObjectPutRtfObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjDfJjFhEiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanObjectPutRtfObj () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOjFhDiJmCjEfMiBeC_xHqqkZx_
	if (IsEditingText()) return FALSE;
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::CanObjectPutRtfObj();
} // FCToolRichEditTmpl<SUPER>::CanObjectPutRtfObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnObjectPutRtfObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjDfJjFhEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnObjectPutRtfObj ()
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOiJlNiCoAiPiIjHjNiCpAiClFiCmIiCkCiBeC_xHqqkZx_
	if (IsEditingText()) return;
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnObjectPutRtfObj();
} // FCToolRichEditTmpl<SUPER>::OnObjectPutRtfObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::IsEditingText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFnCiPfHjCiGiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::IsEditingText () const
{
	return (m_pTextObj != NULL);
} // FCToolRichEditTmpl<SUPER>::IsEditingText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::OnStopToEditText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDgGiDeCiDfOiCmMjFnCiPfHiPeJjHlJiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iClBiClBiCmJjHiIiClNiOjOiCmNiLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiNmFjCiGiCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::OnStopToEditText ()
{
	// _xZkqqHx_jFnCiPfHjCiGiCmMjFjEjFgJiCkKjGlDiCkCiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
	if (m_pTextObj == NULL)
	{
		return;
	}
	// _xZkqqHx_jFnCiPfHiPeJjHlJiBeC_xHqqkZx_
	StopToEditText();
	// _xZkqqHx_iDgDiBfLiDiLiDfKiDgCiDfGiDiHiDjDiPeJjHlJiBeC_xHqqkZx_
	EndOfSession();
} // FCToolRichEditTmpl<SUPER>::OnStopToEditText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::EndOfSession
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCmMiCfAiCmCiCmMiPiIjHjNiCkKiPeJiCoNiCmBiClNiOjOiCmJiMmEiCnBiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKiDiNiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeBiClBiCmMiKnGjAjEiOmAiNhDiMoDiBeB_xHqqkZx_
 *			_xZkqqHx_iMlLiNnNiCmMiDgDiBfLiDiLiCmNjBeJjBpAiDgDiBfLiDiLiCmJjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::EndOfSession ()
{
	// BASE_CLASS::EndOfSession()_xZkqqHx_iCmFiBeBiOjPiCmMiDgDiBfLiDiLiCnGiCmMiDiBiDgCiDfKiBfLiDfHjBjHjFhEiCkK_xHqqkZx_
	// _xZkqqHx_iOoIjEhKiClDiCoKiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDiJiDhIiDiLjFjEjFgJiCmMjEhKjChFiOjOiCmIiCmHiBeBiOjPiCmMiDgDiBfLiDiLiCmJiDgFiDeMiDfIiDgHjFnCiPfHiDgDiBfLiDiLiCkKjAnNjCoIiClDiCoKiCmE_xHqqkZx_
	// _xZkqqHx_iCkCiCoJiPoKiNiHiCmNiBeBiClBiClBiCmFiDeMiDiDiDjDiDfKiDiLiClFiCmEiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	if (GetNextTool() == ID_TOOL_EDIT_RICH_TEXT)
		SetNextTool(-1);
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::EndOfSession();
} // FCToolRichEditTmpl<SUPER>::EndOfSession.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanZoomView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLiCmMiDfJiBfLiDiAiDeDiDjDiBeFiDeBiDeFiDgHiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanZoomView () const
{
//----- 02.05.31 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmJjCiGiDhLiDfOiDjDiCmFiDfJiBfLiDiAiClHiCoJiCmGiBeBiDeHiDgGiDeCiDfOiCkKiClLiCmMiCnMiCnM_xHqqkZx_)-----
//	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmNiDfJiBfLiDiAiCpAiLnGiOhOiClHiCoJiBeC_xHqqkZx_
//	return !IsEditingText();
//----- 02.05.31 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmJjCiGiDhLiDfOiDjDiCmFiDfJiBfLiDiAiClHiCoJiCmGiBeBiDeHiDgGiDeCiDfOiCkKiClLiCmMiCnMiCnM_xHqqkZx_)-----
	// _xZkqqHx_iDhEiDiLiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiCmMiDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmNiDfJiBfLiDiAiCpAiLnGiOhOiClHiCoJiBeC_xHqqkZx_
	if (IsEditingText() && g_pView->GetRTFEditor()->IsFullScreenEditMode())
		return FALSE;
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::CanZoomView();
//----- 02.05.31 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmJjCiGiDhLiDfOiDjDiCmFiDfJiBfLiDiAiClHiCoJiCmGiBeBiDeHiDgGiDeCiDfOiCkKiClLiCmMiCnMiCnM_xHqqkZx_)-----
} // FCToolRichEditTmpl<SUPER>::CanZoomView.

//----- 06.11.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanLockStatus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKiDiNiDgCiDeOiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiCoCiDgDiBfLiDiLiDgPiBfLiCmMiDiNiDgCiDeOiDfCiDhNiDjDiDgIiCmMjFfMiOkGiPoDiCmMjGoCjBoIiBeC_xHqqkZx_
 *			_xZkqqHx_jDoAjFjEjDeJiCmJiCmN_xHqqkZx_SetLockStatus_xZkqqHx_iCmFjAnNjCoIiJmCjEfMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanLockStatus () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHiPeJjHlJiOjOiCmJ_xHqqkZx_ STATE_CANCEL_TOOL _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiClNiCnPiBeB_xHqqkZx_
	// LockStatus_xZkqqHx_iCmNiLkNjAkHjDeJiCmJiJpAiPjMiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeBiDiNiDgCiDeOjFhDiJmCiCmGiClHiCoJiBeC_xHqqkZx_
	return FALSE;
} // FCToolRichEditTmpl<SUPER>::CanLockStatus.
//----- 06.11.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanHandle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkKiClBiCmMiDgDiBfLiDiLiCmFiIlFiCkGiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanHandle (const FCObjDynabase* pObj) const
{
	// pObj _xZkqqHx_iCkKiBeBjFnCiPfHiJmCjEfMiCmIiDiMiDeDiDiEiBfLiCmJjBkOiClDiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (!g_pDoc->CanDoOnObject(pObj, FDOZ_ON_EDIT)) return FALSE;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::CanHandle(pObj);
} // FCToolRichEditTmpl<SUPER>::CanHandle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::IsObjectCommandEnable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ ID_OBJECT_XXX _xZkqqHx_iCmMjCoIjAkLjDeJiCmIjHeMiMpIiBeFjGlDiMpIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmMiPoKiNiH_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::IsObjectCommandEnable (DWORD dwCmdID) const
{
	switch (dwCmdID)
	{
	case ID_OBJECT_PUT_RTF_OBJ:
		return TRUE;
	default:
// 01.11.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		return BASE_CLASS::IsObjectCommandEnable(dwCmdID);
		return FALSE;
	}
} // FCToolRichEditTmpl<SUPER>::IsObjectCommandEnable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanSpecifySearchChipText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiOjOiCmJiDgAiDgCiDhGjCiGiCmMjEpBjFnCiPfHiDgFiDeMiDfIiDgHiCoAiMjPiNpFjBmOiPnLiCmGiClFiCmEjAnNjCoIiJmCjEfMiCkJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanSpecifySearchChipText () const
{
	return FALSE;
} // FCToolRichEditTmpl<SUPER>::CanSpecifySearchChipText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::CanSpecifySearchLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiBeFjChFiKlHiOjOiCmJjDmBjCoIiCmMiDiMiDeDiDiEiBfLiCpAiMjPiNpFjBmOiPnLiCmGiClFiCmEjAnNjCoIiJmCjEfMiCkJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::CanSpecifySearchLayer () const
{
	return FALSE;
} // FCToolRichEditTmpl<SUPER>::CanSpecifySearchLayer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::IsAvailableFindTextAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKiBhFiClHiCnHiCmEiCmMiDgFiDeMiDfIiDgHiCpAiMjPiNpFiBhGiCpAiDfEiDhMiBfLiDgHiClFiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhMiBfLiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePiCmMiDhLiDfOiDjDiCmMjHeMiMpIjAkLjAnNjCoIiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::IsAvailableFindTextAll () const
{
	return FALSE;
} // FCToolRichEditTmpl<SUPER>::IsAvailableFindTextAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::IsAvailableFindTextAllInSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKiBhFjBeJjBpAjCiGiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiClHiCnHiCmEiMjPiNpFiBhGiCpAiDfEiDhMiBfLiDgH_xHqqkZx_
 *			_xZkqqHx_iClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhMiBfLiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMjPiNpFiDfPiDeDiDeBiDiNiDePiCmMiDhLiDfOiDjDiCmMjHeMiMpIjAkLjAnNjCoIiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::IsAvailableFindTextAllInSelect () const
{
	return FALSE;
} // FCToolRichEditTmpl<SUPER>::IsAvailableFindTextAllInSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::IsAvailableReplaceTextAllInSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKiBhFjBeJjBpAjCiGiCmMjFjEjFgJiCmMiDgFiDeMiDfIiDgHiCpAiClHiCnHiCmEjChFiKlHiBhGiCpAiDfEiDhMiBfLiDgH_xHqqkZx_
 *			_xZkqqHx_iClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhMiBfLiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jChFiKlHiDfPiDeDiDeBiDiNiDePiCmMiDhLiDfOiDjDiCmMjHeMiMpIjAkLjAnNjCoIiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL FCToolRichEditTmpl<SUPER>::IsAvailableReplaceTextAllInSelect () const
{
	return FALSE;
} // FCToolRichEditTmpl<SUPER>::IsAvailableReplaceTextAllInSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SpecKeyCallback
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDmBiOoKiCmIiDeMiBfLiBgJiCgEiChCiCgCjDjJiBgKiCkKiJjPiClDiCoKiClNiOjOiCmJ_xHqqkZx_
 *			_xZkqqHx_iMmEiCmOiCoKiCoJiBeC_xHqqkZx_StartToEditText_xZkqqHx_iKnGjAjEjCiGiCmFiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wKey	: _xZkqqHx_iJjPiClDiCoKiClNiDeMiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
static void SpecKeyCallback (WORD wKey)
{
	g_pView->PostMessage(WM_COMMAND, ID_TEXT_STOP_EDIT, (LPARAM)0);
} // SpecKeyCallback.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::StartToEditText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCmMjFnCiPfHiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pFig	:_xZkqqHx_jFnCiPfHiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pTop	:pFig_xZkqqHx_iCkKjBkOiClHiCoJiDgHiDgCiDhGiDiMiDhIiDiLiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_pFig_xZkqqHx_iCkKiDgHiDgCiDhG_xHqqkZx_
 *					 _xZkqqHx_iDiMiDhIiDiLiCmIiCoHiCmO_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptCaret:_xZkqqHx_iDeKiDiMiDgCiDgHiCpAiInKjDkOiClHiCoJiImKjChFiCpAiOhHjCoIiBeCiInKjDkOiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDjCiGiCmFiCmIiCkCiPoKiNiHiCmNiDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCpAiDeBiDeOiDgFiDeCiDhFiCmJiClHiCoJiBeC_xHqqkZx_
 *			OnStopToEditText_xZkqqHx_iKnGjAjEiCkKiOmAiNhDiClDiCoKiCoJiCnMiCmFiBeBiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmJ_xHqqkZx_
 *			_xZkqqHx_iDeDiDhIiDjDiDgHiCkKjBjHiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			01.04.27 Fukushiro M. _xZkqqHx_iPeDjAlD_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::StartToEditText (FCObjFigure* pFig, FCObjDynabase* pTop, const DBLPoint* mmptCaret)
{
	// _xZkqqHx_jFjEjFgJjFnCiPfHiJmCjEfMiCmFiCmIiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
	if (!FFCanEditObject()) return;
	// _xZkqqHx_jFjEjFgJiCkKiDgFiDeMiDfIiDgHjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
//----- 06.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (!pFig->CanBeTextObject()) return;
//----- 06.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!pFig->CanBeTextObject() ||
		pFig->CalcArea() < FD_MIN_AREA_FOR_TEXT) return;
//----- 06.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jFnCiPfHjCiGiCmMjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
	m_pTextObj = pFig;
	// _xZkqqHx_iDgHiDgCiDhGiDiMiDhIiDiLjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
	m_pTopObj = pTop;
	if (m_pTopObj == NULL) m_pTopObj = m_pTextObj;
	if (m_pTextObj->GetRichText() == NULL)
	{
		// _xZkqqHx_jFjEjFgJjCiGiCmMiDgFiDeMiDfIiDgHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiBeC_xHqqkZx_
		m_pRichText = m_pTextObj->CreateRichText();
		// _xZkqqHx_iDgFiDeMiDfIiDgHjAfGiLeLiNoMjAkMiCpAjAnNjCoIiBeC_xHqqkZx_
		m_bIsNewText = TRUE;
	} else
	{
		// _xZkqqHx_jFjEjFgJjCiGiCmMiDgFiDeMiDfIiDgHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		m_pRichText = m_pTextObj->GetRichText();
		// _xZkqqHx_iDgFiDeMiDfIiDgHjAfGiLeLiNoMjAkMiBeI_xHqqkZx_
		m_bIsNewText = FALSE;
	}
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiBeC_xHqqkZx_
	g_pDoc->SessionBegin();

	WORD wFixResize;
	BOOL bIsShortenByText;
	if (pTop != NULL)
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjBmOiPnLiCmMjFjEjFgJiCkKiDePiDiLiBfLiDhGjFjEjFgJiCmMiDiBiDjDiDgPiBfLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiDgHiDgCiDhGiCmMiDiKiDfEiDeDiDfJjBkOjAkLiCmJiPfNiCkEiBeC_xHqqkZx_
		wFixResize = pTop->GetMemberFixResizeByText(pFig);
		bIsShortenByText = pTop->GetIsMemberShortenByText(pFig);
	} else
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjBmOiPnLiCmMjFjEjFgJiCkKiDePiDiLiBfLiDhGjFjEjFgJiCmMiDiBiDjDiDgPiBfLiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		wFixResize = pFig->GetStdFixResizeByText();
		bIsShortenByText = pFig->GetIsShortenByText();
	}
	// _xZkqqHx_jFjEjFgJiCpAiDeHiDgGiDeCiDgCiDgHiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
	m_pRichText->OnStartToEditText(m_pTextObj, wFixResize, bIsShortenByText, TRUE, mmptCaret);
	g_pView->GetRTFEditor()->SetSpecKeyCallback(SpecKeyCallback);
} // FCToolRichEditTmpl<SUPER>::StartToEditText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::StopToEditText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDgGiDeCiDfOiCmMjFnCiPfHiPeJjHlJiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iClBiClBiCmJjHiIiClNiOjOiCmNiLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiNmFjCiGiCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::StopToEditText ()
{
	// _xZkqqHx_jFnCiPfHjCiGiCmMjFjEjFgJiCkKjGlDiCkCiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
	if (m_pTextObj == NULL) return;
	// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiCmMjBePiPiIjHjNiBeC_xHqqkZx_
	if (!m_bIsNewText)
		g_pDoc->BeforeCmdModifyAbcRichText(m_pTextObj);
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmMiDfCiBfLiDiLiDgPiDgCiDeOiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	g_pView->GetRTFEditor()->SetSpecKeyCallback(NULL);
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDgGiBfLiDfOiCpAjFmPiNfIiBeC_xHqqkZx_
	BYTEVector byvQueue;
	double dRatioHorz, dRatioVert;
	m_pRichText->OnStopToEditText(byvQueue, dRatioHorz, dRatioVert, m_pTextObj);
	if (!byvQueue.empty())
	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCkKiCkAiCoJiBgJjFmPiNfIiClDiCoKiClNjFlGiOjKiCkKiCkAiCoJiBgKiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiBeFjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		// _xZkqqHx_iDgFiDeMiDfIiDgHiNoMjAkMiOjOiCmNiBeBjFjEjFgJiDiKiDfEiDeDiDfJiOhHjCoIiCkK_xHqqkZx_OFF_xZkqqHx_iCmIiCmMiCmFjFjEjFgJiCmMiDfEiDeDiDfJiCmGiNiHiCoNiCmIiCkCjAfDjEhKiCmNiCmIiCkCiBeC_xHqqkZx_
		if (m_bIsNewText)
			g_pDoc->CmdCreate1RichText(m_pTextObj, m_pRichText);
		else
			g_pDoc->CmdModifyAbcRichText(m_pTextObj, byvQueue.size(), byvQueue.begin());
		if (m_pTextObj->IsKindOf(FDOJ_LABEL))
		{
			// _xZkqqHx_iDiJiDhIiDiLjFjEjFgJjFmPiNfIiOjOiKnEiCmMiLeMjIfOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			g_pDoc->CmdModifyLabel((FCObjLabel*)m_pTextObj,
									FCLabelRec(FDFP_LABELMTIME, FFGetCurrentTime(), 0));
		}
	}
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iOgHiCoNiCoKiCmEiCkCiCmIiCkCiDhEiDeIiDjDiDgHiCpAjAkOjHjNiBeC_xHqqkZx_
	// _xZkqqHx_iDhEiDeIiDjDiDgHjDgPjIfOiCmMiCnNiCmFiDfCiDhNiDjDiDgIiDeMiDiFiBfLiCkKiCmIiCkCiPoKiNiHiBgJiDeHiDgGiDeCiDfOjCiGiCmF_xHqqkZx_
	// Undo_xZkqqHx_iClHiCoJiCmGiDhEiDeIiDjDiDgHjDgPjIfOiCmMiCnNiBgK_xHqqkZx_
	g_pDoc->MulticmdDeleteUnusedFonts();
//----- 06.12.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 05.02.21 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// dRatioHorz, dRatioVert _xZkqqHx_iCpAjAlDiKgNiCmIjCgMiCmJjFoCjAlDiClHiCoJiBeC_xHqqkZx_
//	m_pTextObj->GetPreciseTextResizeRatio(dRatioHorz, dRatioVert);
////----- 05.02.21 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.03.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeCiDfEiDeDiDfJiCkKiPkMiClDiCkNiCmIiCoJiPoKiNiHiCoAiCkAiCoJiCmMiCmFiBeB_xHqqkZx_
	// _xZkqqHx_jFmPiNfIjBePiCmJiCoAiDiKiBfLiDfHiDiHiDjDjAnNjCoIiCkKjFeLjHhGiBeC_xHqqkZx_
	g_pView->AppendToLastRgn(m_pTopObj);

	// _xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmMiMmFjCoIjDfPiCpAiMhGiOfKiBeCiDgFiDeMiDfIiDgHjFjEjFgJiCmMiDiKiDfEiDeDiDfJiPoOjFpBiCpAiOgHiCmBiCmEiBeB_xHqqkZx_
	// _xZkqqHx_iDgHiDgCiDhGjFjEjFgJiCmMiMmFjCoIjDfPiCpAiLiBiCnPiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
	const DBLPoint mmptFixPoint = m_pTopObj->CalcFixPointForTextResize(
//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//												m_pTextObj->GetStdResizeHorzByText(),
//												m_pTextObj->GetStdResizeVertByText(),
//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
												m_pTextObj->GetStdFixResizeByText(),
//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
												m_pTextObj->GetTextAngle());
	// _xZkqqHx_iImIiJlKiCmMiDfEiDeDiDfJjFmPiNfIiCmNiBeBiDfCiDhNiDjDiDgIiDeMiDiFiBfLiCkKiLpDiCmMiPoKiNiHiCmFiCoAjHeMiCoIjDlOiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDfEiDeDiDfJiIoMiCoKiCmMjFjEjFgJiCpAiBeBjBfDiJoGjGmKiDeHiDgGiDeCiDfOiCmFiKeKiCkCiCmEiClHiCkOjFmCiClGiClNiPoKiNiHiBeC_xHqqkZx_
	// _xZkqqHx_jFjEjFgJiCpAiBeBiDgFiDeMiDfIiDgHiCmMiIoMiCoKiCkKjGlDiCkNiCmIiCoJiCoGiCkEiCmJiDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
	m_pTopObj->AdjustObjectSize(m_pTextObj, dRatioHorz, dRatioVert, mmptFixPoint);
	// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCkKjGlDiCkNiBeBiDgFiDeMiDfIiDgHiCkKjAfGiLeLiNoMjAkMiCmMiPoKiNiHiBeBiDgFiDeMiDfIiDgHiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	if (byvQueue.empty() && m_bIsNewText) delete m_pRichText;
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();

//----- 02.08.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmMjBfDiJoGjGmKiDiCiBfLiDgIiCmFiBeBiJlKiCmJiDfIiDeOiDiNiBfLiDiLiClFiCmEiBeB_xHqqkZx_ESC_xZkqqHx_iCmFiDeHiDgGiDeCiDfOiPeJjHlJiClFiCmEiCoAiBeBiCkEiCnMiCkNiNmEjFgAiJoGiClDiCoKiCmIiCkCiBeC_xHqqkZx_)-----
//	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeCiDfEiDeDiDfJiCmNjDkPiClGiCkJjBoFiCkLiCkNiCmIiCmBiCmEiCkCiCoJiCmMiCmFiBeBiClBiCmMiDiKiBfLiDfHiDiHiDjDiClOiCkPiCmFiCgOiCgKiBeC_xHqqkZx_
//	g_pView->AppendToLastRgn(m_pTopObj);
//	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//	g_pView->SendRgnRedraw();
//----- 02.08.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmMjBfDiJoGjGmKiDiCiBfLiDgIiCmFiBeBiJlKiCmJiDfIiDeOiDiNiBfLiDiLiClFiCmEiBeB_xHqqkZx_ESC_xZkqqHx_iCmFiDeHiDgGiDeCiDfOiPeJjHlJiClFiCmEiCoAiBeBiCkEiCnMiCkNiNmEjFgAiJoGiClDiCoKiCmIiCkCiBeC_xHqqkZx_)-----
	if (g_pView->GetRTFEditor()->IsFullScreenEditMode())
	//----- _xZkqqHx_iDhEiDiLiDfIiDeOiDiKiBfLiDjDjFnCiPfHiDiCiBfLiDgIiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeCiDhEiDiLiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmIiCmMiCmFiBeBjBfDiJoGjGmKiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
		// _xZkqqHx_iDfJiBfLiDiAiCmMjFmPiNfIiCoAiCkAiCoJiClNiCnPiBeBiDfJiBfLiDiAiCpAjGnPiClHiNnLiCmMiNmEjFgAiJoGiCoAjDpMiCmBiCmEiClFiCnMiCkEiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
		g_pView->SetClientToRgn();
	} else
	//----- _xZkqqHx_jCmKiPoNjFnCiPfHiDiCiBfLiDgIiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
		g_pView->AppendToLastRgn(m_pTopObj);
	}
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
//	(void)g_pView->PostRgnRedraw();
//----- 02.08.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmMjBfDiJoGjGmKiDiCiBfLiDgIiCmFiBeBiJlKiCmJiDfIiDeOiDiNiBfLiDiLiClFiCmEiBeB_xHqqkZx_ESC_xZkqqHx_iCmFiDeHiDgGiDeCiDfOiPeJjHlJiClFiCmEiCoAiBeBiCkEiCnMiCkNiNmEjFgAiJoGiClDiCoKiCmIiCkCiBeC_xHqqkZx_)-----
	//----- _xZkqqHx_jFnCiPfHjCiGiDiPiBfLiDeOjFmPjAjEiCpAiPiJiKpKiJlL_xHqqkZx_ -----
	m_pTextObj = NULL;		// _xZkqqHx_jFnCiPfHjCiGiCmMjFjEjFgJiBeC_xHqqkZx_
	m_pTopObj = NULL;		// _xZkqqHx_jAgFjFjEjFgJiBeC_xHqqkZx_
	m_pRichText = NULL;		// _xZkqqHx_iMlLiNnNjFnCiPfHjCiGiCmMiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
	m_bIsNewText = FALSE;	// _xZkqqHx_iDgFiDeMiDfIiDgHjAfGiLeLiNoMjAkMiBeI_xHqqkZx_
} // FCToolRichEditTmpl<SUPER>::StopToEditText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolTableEdit.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
int FCToolRichEditTmpl<SUPER>::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_IDLE:				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_LBUTTONDOWN:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			if (IsEditingText())
			//----- _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmMiLoJiMgAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
				DBLRect mmrtRTFEditor;
				g_pView->GetRTFEditor()->GetWindowRectMM(mmrtRTFEditor);
				// _xZkqqHx_iPfMjFkKiJjDiCkCiCmGjElLjCgGiClDiCoKiCoJiLjHjHkDiCpAiKgHjCkDiBeC_xHqqkZx_
				mmrtRTFEditor.Extend(lg2mm(FD_FAR_FROM_HANDLE));
				// _xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmMiLoJiMgAiKePiCmJiCkAiCoJiPoKiNiHiCmNiBeBiDgDiBfLiDiLiCpAiPeJjHlJiBeC_xHqqkZx_
				if (!mmrtRTFEditor.PtInRect(m_mmptMsc))
					iNextState = STATE_EXIT_TOOL_BY_BUTTON;		// _xZkqqHx_iDhNiDeFiDfIiDhLiDfOiDjDiCmJiCoGiCoIiDgDiBfLiDiLiPeJjHlJiBeC_xHqqkZx_
			}
			break;

//----- 06.03.23 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		case WM_COMMAND:		// _xZkqqHx_iDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			if (m_dwCommand == ID_TLCMD_CANCEL && IsEditingText())
			//----- _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmJ_xHqqkZx_ESC_xZkqqHx_iDeMiBfLiCmMiPoKiNiH_xHqqkZx_ -----
			{
// 06.03.31 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//				iNextState = STATE_EXIT_TOOL;		// _xZkqqHx_iDhNiDeFiDfIiDhLiDfOiDjDiCmJiCoGiCoIiDgDiBfLiDiLiPeJjHlJiBeC_xHqqkZx_
				iNextState = STATE_CANCEL_TOOL;		// _xZkqqHx_iDgDiBfLiDiLiDeMiDiDiDjDiDfKiDiLiBeC_xHqqkZx_
			}
			break;
//----- 06.03.23 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		}
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolRichEditTmpl<SUPER>::TransFDA.

//----- 05.06.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::StateFDA
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCToolRichEditTmpl<SUPER>::StateFDA (int iState, CDC* pDC)
//{
//	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
//	switch (iState)
//	{
//	case STATE_ENTER_MOVE_RULED:	// _xZkqqHx_iMhCjApMiInKjDkOjDpMiMpLiBeC_xHqqkZx_
//	default:
//		BASE_CLASS::StateFDA(iState, pDC);
//	}
//} // FCToolRichEditTmpl<SUPER>::StateFDA.
//----- 05.06.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::StateIdle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBnCiClPiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void FCToolRichEditTmpl<SUPER>::StateIdle (CDC* pDC)
{
	TRACE(_T("StateIdle\r\n"));
	// _xZkqqHx_jFnCiPfHjCiGiCmIiCoHiCmOiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
	if (IsEditingText()) return;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiBjFiDfIiDgFiBfLiDfOiDfIjFfMiOkGiBeC_xHqqkZx_
	BASE_CLASS::StateIdle(pDC);
} // FCToolRichEditTmpl<SUPER>::StateIdle.

//----- 06.03.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::StateExitToolByButton
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//template<class SUPER>
//void FCToolRichEditTmpl<SUPER>::StateExitToolByButton (CDC* pDC)
//{
//	TRACE(_T("StateExitToolByButton\r\n"));
////----- 05.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOjFnCiPfHiPeJjHlJiBeC_xHqqkZx_
////	if (IsEditingText())
////		OnStopToEditText();
////	else
////		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
////		BASE_CLASS::StateExitToolByButton(pDC);
////----- 05.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmIiCoHiCmOjFnCiPfHiPeJjHlJiBeC_xHqqkZx_
//	if (IsEditingText())
//		StopToEditText();
//	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::StateExitToolByButton(pDC);
////----- 05.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCToolRichEditTmpl<SUPER>::StateExitToolByButton.
//----- 06.03.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::GetSubMenuIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCToolRichEditTmpl<SUPER>::StateContextMenu _xZkqqHx_iCmFjFfMiOkGiClHiCoJiDfEiDhFiDiBiDgKiDiFiBfLiCmM_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
int FCToolRichEditTmpl<SUPER>::GetSubMenuIndex () const
{
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiDiBiDgKiDiFiBfLiBeC_xHqqkZx_
	if (IsEditingText()) return FD_MENU_TOOL_RICH_EDIT;
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::GetSubMenuIndex();
} // FCToolRichEditTmpl<SUPER>::GetSubMenuIndex.

#endif//__ToolRichEditTmpl_h
