#ifndef __FCToolWideBezierArrow_h
#define __FCToolWideBezierArrow_h

#include "ToolWideBezier.h"	// For FCToolWideBezier.
#include "ToolArrowTmpl.h"	// For FCToolArrowTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::InitNewObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiClFiClNjFjEjFgJiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iPiJiKpKiJlLiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<>
void FCToolArrowTmpl<FCToolWideBezier>::InitNewObject (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_jBkOjAkLiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	SUPER::InitNewObject(pObj);
	// _xZkqqHx_jFjEjFgJiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	FCObjPoly* pPoly = (FCObjPoly*)pObj;
	if (m_pBgnHitObj != NULL || m_pEndHitObj != NULL)
		pPoly->SetLinkMoveType(FDOP_LMTYPE_AXIS);
	const long lJointSz = pPoly->GetJointSize();

	// ToolPolyArrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
	// _xZkqqHx_iKeKiOgOjDfPiBeBiPeJjHlJjDfPiCpAiInKjDkOiBeC_xHqqkZx_
//----- 01.11.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_iBgnHitOn == FDPA_HIT_POL_MOLIP)
//	//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgH_xHqqkZx_ -----
//	{
//		DBLPoint mmptN = pPoly->GetJoint(1).m_mmptPivot + pPoly->GetJoint(1).m_mmptPrev;
//		if (abouteq(m_mmptBgnHitPos, pPoly->GetJoint(0).m_mmptPivot) &&
//			!abouteq(m_mmptBgnHitPos, mmptN))
//		//----- _xZkqqHx_jFjEjFgJjBkEiDiCiDiKiDhGiNmAjFfH_xHqqkZx_ == _xZkqqHx_iKeKiOgOjDfPiDiCiDiKiDhGiNmAjFfH_xHqqkZx_ -----
//		{
//			//----- _xZkqqHx_jClMjApM_xHqqkZx_AN_xZkqqHx_iCmGjAhNiMgAiCmMiDhMiDiKiDfDiDjDiCkKiMpAiNlHiClHiCoJjDfP_xHqqkZx_F_xZkqqHx_iCpAiLiBiCnPiCoJ_xHqqkZx_ -----
//			// ToolPolyArrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
//			DBLPoint mmptF = m_mmptBgnHitPos;
//			//----- _xZkqqHx_jAhNiMgAiCmMiDhMiDiKiDfDiDjDiCpAjAlGjAkMiClHiCoJ_xHqqkZx_ -----
//			DBLPointVector vmmptPoly;
//			BOOL bIsClose = m_pBgnHitObj->IsCloseLineMolipPolygon(m_lBgnHitMolip);
//			m_pBgnHitObj->NewLineMolipPolygon(vmmptPoly, m_lBgnHitMolip,
//												FFGetStdElemLen(), NULL, 0);
//			// _xZkqqHx_iDhMiDiKiDfDiDjDiCmGjClMjApM_xHqqkZx_AN_xZkqqHx_iCmMiMpAjDfP_xHqqkZx_F_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_F_xZkqqHx_iCmNiBeBiNmFiCoA_xHqqkZx_AN_xZkqqHx_jFpLiMpMiCmFiJjDiCkCiMpAjDfPiBeC_xHqqkZx_
//			// UtilMisc.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
//			::CalcCrossPointLinePolyline(mmptF, vmmptPoly.begin(), vmmptPoly.size(),
//										bIsClose, m_mmptBgnHitPos, mmptN);
//			// _xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCpAiBeBjDfP_xHqqkZx_F_xZkqqHx_iCnGiInKjDkOiBeC_xHqqkZx_
//			pPoly->GetJoint(0).m_mmptPivot = mmptF;
//			// _xZkqqHx_jBePiIpIjDfPiBeFiMoDiIpIjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
//			if (2 < lJointSz)
//				::CalcRoundy(pPoly->GetJoint(1),
//							pPoly->GetJoint(0).m_mmptPivot,
//							pPoly->GetJoint(2).m_mmptPivot, 50);
//		}
//	}
//	if (m_iEndHitOn == FDPA_HIT_POL_MOLIP)
//	//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgH_xHqqkZx_ -----
//	{
//		DBLPoint mmptN = pPoly->GetJoint(lJointSz - 2).m_mmptPivot +
//							pPoly->GetJoint(lJointSz - 2).m_mmptNext;
//		if (abouteq(m_mmptEndHitPos, pPoly->GetJoint(lJointSz - 1).m_mmptPivot) &&
//			!abouteq(m_mmptEndHitPos, mmptN))
//		//----- _xZkqqHx_jFjEjFgJjBkEiDiCiDiKiDhGiNmAjFfH_xHqqkZx_ == _xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiNmAjFfH_xHqqkZx_ -----
//		{
//			//----- _xZkqqHx_jClMjApM_xHqqkZx_AN_xZkqqHx_iCmGjAhNiMgAiCmMiDhMiDiKiDfDiDjDiCkKiMpAiNlHiClHiCoJjDfP_xHqqkZx_F_xZkqqHx_iCpAiLiBiCnPiCoJ_xHqqkZx_ -----
//			// ToolPolyArrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
//			DBLPoint mmptF = m_mmptEndHitPos;
//			//----- _xZkqqHx_jAhNiMgAiCmMiDhMiDiKiDfDiDjDiCpAjAlGjAkMiClHiCoJ_xHqqkZx_ -----
//			DBLPointVector vmmptPoly;
//			BOOL bIsClose = m_pEndHitObj->IsCloseLineMolipPolygon(m_lEndHitMolip);
//			m_pEndHitObj->NewLineMolipPolygon(vmmptPoly, m_lEndHitMolip,
//												FFGetStdElemLen(), NULL, 0);
//			// _xZkqqHx_iDhMiDiKiDfDiDjDiCmGjClMjApM_xHqqkZx_AN_xZkqqHx_iCmMiMpAjDfP_xHqqkZx_F_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_F_xZkqqHx_iCmNiBeBiNmFiCoA_xHqqkZx_AN_xZkqqHx_jFpLiMpMiCmFiJjDiCkCiMpAjDfPiBeC_xHqqkZx_
//			// UtilMisc.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
//			::CalcCrossPointLinePolyline(mmptF, vmmptPoly.begin(), vmmptPoly.size(),
//										bIsClose, m_mmptEndHitPos, mmptN);
//			// _xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCpAiBeBjDfP_xHqqkZx_F_xZkqqHx_iCnGiInKjDkOiBeC_xHqqkZx_
//			pPoly->GetJoint(lJointSz - 1).m_mmptPivot = mmptF;
//			// _xZkqqHx_jBePiIpIjDfPiBeFiMoDiIpIjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
//			if (2 < lJointSz)
//				::CalcRoundy(pPoly->GetJoint(lJointSz - 2),
//							pPoly->GetJoint(lJointSz - 3).m_mmptPivot,
//							pPoly->GetJoint(lJointSz - 1).m_mmptPivot, 50);
//		}
//	}
//----- 01.11.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (m_iBgnHitOn == FDPA_HIT_POL_MOLIP && m_dwBgnLinkKind == FDLM_LINK_ON_ANGLE)
	//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgH_xHqqkZx_ -----
	{
		if (abouteq(m_mmptBgnHitPos, pPoly->GetJoint(0).m_mmptPivot))
		{
			FCBezierControls bc;
			bc.A() = pPoly->GetJoint(0).m_mmptPivot;
			bc.B() = pPoly->GetJoint(0).m_mmptPivot + pPoly->GetJoint(0).m_mmptNext;
			bc.C() = pPoly->GetJoint(1).m_mmptPivot + pPoly->GetJoint(1).m_mmptPrev;
			bc.D() = pPoly->GetJoint(1).m_mmptPivot;
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			if (m_pBgnHitObj->CalcMolipCrossedControlPoint(bc, g_pReg->GetFrontArrowAutoGap(), m_lBgnHitMolip))
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			const mmetol mmArrowAutoGap = g_pReg->GetIsArrowAutoGap() ? g_pReg->GetFrontArrowAutoGap() : 0.0;
			if (m_pBgnHitObj->CalcMolipCrossedControlPoint(bc, mmArrowAutoGap, m_lBgnHitMolip))
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			{
				// _xZkqqHx_iDhDiDhLiDgCiDgHiBeBjBePiIpIjDfPiBeBiMoDiIpIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
				pPoly->GetJoint(0).m_mmptPivot = bc.A();
				pPoly->GetJoint(0).m_mmptNext = bc.B() - bc.A();
				pPoly->GetJoint(1).m_mmptPrev = bc.C() - bc.D();
			}
		}
	}
	if (m_iEndHitOn == FDPA_HIT_POL_MOLIP && m_dwEndLinkKind == FDLM_LINK_ON_ANGLE)
	//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgH_xHqqkZx_ -----
	{
		if (abouteq(m_mmptEndHitPos, pPoly->GetJoint(lJointSz - 1).m_mmptPivot))
		{
			FCBezierControls bc;
			bc.A() = pPoly->GetJoint(lJointSz - 1).m_mmptPivot;
			bc.B() = pPoly->GetJoint(lJointSz - 1).m_mmptPivot + pPoly->GetJoint(lJointSz - 1).m_mmptPrev;
			bc.C() = pPoly->GetJoint(lJointSz - 2).m_mmptPivot + pPoly->GetJoint(lJointSz - 2).m_mmptNext;
			bc.D() = pPoly->GetJoint(lJointSz - 2).m_mmptPivot;
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			if (m_pEndHitObj->CalcMolipCrossedControlPoint(bc, g_pReg->GetBackArrowAutoGap(), m_lEndHitMolip))
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			const mmetol mmArrowAutoGap = g_pReg->GetIsArrowAutoGap() ? g_pReg->GetBackArrowAutoGap() : 0.0;
			if (m_pEndHitObj->CalcMolipCrossedControlPoint(bc, mmArrowAutoGap, m_lEndHitMolip))
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			{
				// _xZkqqHx_iDhDiDhLiDgCiDgHiBeBjBePiIpIjDfPiBeBiMoDiIpIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
				pPoly->GetJoint(lJointSz - 1).m_mmptPivot = bc.A();
				pPoly->GetJoint(lJointSz - 1).m_mmptPrev = bc.B() - bc.A();
				pPoly->GetJoint(lJointSz - 2).m_mmptNext = bc.C() - bc.D();
			}
		}
	}
//----- 01.11.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolArrowTmpl<FCToolWideBezier>::InitNewObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::GetDefaultIdleCursor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	StateIdle_xZkqqHx_iCmFiDgGiDhEiDeIiDiLiDgHiCmJiOgHiCoNiCoKiCoJiDeKiBfLiDfMiDiLiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jFfHiPiAiCmMiDeKiBfLiDfMiDiLiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<>
HCURSOR FCToolArrowTmpl<FCToolWideBezier>::GetDefaultIdleCursor () const
{
//----- 05.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_bControlInvert)
//		return FFGetApp()->LoadCursor(IDC_CURSOR_TOOL_WIDE_BEZIER_ARROW);
//	else
//		return FFGetApp()->LoadCursor(IDC_CURSOR_TOOL_WIDE_BEZIER);
//----- 05.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return FFGetApp()->LoadCursor(IDC_CURSOR_TOOL_WIDE_BEZIER_ARROW);
//----- 05.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolArrowTmpl<FCToolWideBezier>::GetDefaultIdleCursor.

#endif//__FCToolWideBezierArrow_h
