#include "stdafx.h"
#include "resource.h"			// For IDS_XXX.
//----------<NOT EXPORT TO VIEWER>-----------
#include <algorithm>			// For lower_bound template.
#include <time.h>				// For time().
#include "UtilMath.h"			// For hix2histr.etc.
#include "UtilStr.h"			// For GetResString.FFExtractUntil.
#include "UtilErr.h"			// For CFCMiscException.
#include "UtilMisc.h"			// For FFGetCurrentTime.
#include "FrameWnd.h"			// For FFGetMainWnd().
//----------</NOT EXPORT TO VIEWER>-----------
#include "UtilWin.h"			// For ExecAndWaitApp.
#include "RegData.h"			// For g_pReg->GetIsLeftHand().
#include "DynamicDrawView.h"	// For g_pView.
#include "UtilCoord.h"			// For mm2lg.etc.
#include "UtilDlg.h"			// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//----------<NOT EXPORT TO VIEWER>-----------
// 06.02.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//typedef map<_TCHAR, _TCHAR> FTTcTcMap;
typedef map<wchar_t, wchar_t> FTTcTcMap;
static FTTcTcMap s_mpLeft2Right;	// s_mpLeft2Right[_xZkqqHx_iNlGjHjIiCkLjFlGiOjK_xHqqkZx_] = _xZkqqHx_iJeFjHjIiCkLjFlGiOjKiBeC_xHqqkZx_
static FTTcTcMap s_mpRight2Left;	// s_mpRight2Left[_xZkqqHx_iJeFjHjIiCkLjFlGiOjK_xHqqkZx_] = _xZkqqHx_iNlGjHjIiCkLjFlGiOjKiBeC_xHqqkZx_

static vector<ACCEL> s_vAccelL;		// _xZkqqHx_iNlGjHjIiCkLjHhAiCmMiDfGiDiHiBfLiDgHiDeKiDgCiDgHiDeMiBfLjAnNjCoIiBeC_xHqqkZx_
static vector<ACCEL> s_vAccelR;		// _xZkqqHx_iJeFjHjIiCkLjHhAiCmMiDfGiDiHiBfLiDgHiDeKiDgCiDgHiDeMiBfLjAnNjCoIiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myStrToAccel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFlGiOjKiCpAiDeBiDeOiDfKiDiJiDiMiBfLiDfOiDeMiBfLiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_wKey, byVirt _xZkqqHx_iCmJiCmN_xHqqkZx_
 *			_xZkqqHx_jCgMiCkKjChFiKlHiClDiCoKiCoJiCmMiCmFiCmNiCmIiCkNiBeBjCmHiJmBiClDiCoKiCoJiBeC_xHqqkZx_
 *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	F1_xZkqqHx_iCmNjFmPiKlHiCmFiCkLiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static BOOL myStrToAccel (WORD& wKey, BYTE& byVirt, const astring& strEachKey)
{
	if (strEachKey.length() == 1)
	{
		if ('a' <= strEachKey[0] && strEachKey[0] <= 'z')
			wKey = strEachKey[0] - ('a' - 'A');
		else
			wKey = strEachKey[0];
	} else
	if (strEachKey == "f1")
		wKey = VK_F1;
	else
	if (strEachKey == "f2")
		wKey = VK_F2;
	else
	if (strEachKey == "f3")
		wKey = VK_F3;
	else
	if (strEachKey == "f4")
		wKey = VK_F4;
	else
	if (strEachKey == "f5")
		wKey = VK_F5;
	else
	if (strEachKey == "f6")
		wKey = VK_F6;
	else
	if (strEachKey == "f7")
		wKey = VK_F7;
	else
	if (strEachKey == "f8")
		wKey = VK_F8;
	else
	if (strEachKey == "f9")
		wKey = VK_F9;
	else
	if (strEachKey == "f10")
		wKey = VK_F10;
	else
	if (strEachKey == "f11")
		wKey = VK_F11;
	else
	if (strEachKey == "f12")
		wKey = VK_F12;
	else
	if (strEachKey == "f13")
		wKey = VK_F13;
	else
	if (strEachKey == "f14")
		wKey = VK_F14;
	else
	if (strEachKey == "f15")
		wKey = VK_F15;
	else
	if (strEachKey == "insert")
		wKey = VK_INSERT;
	else
	if (strEachKey == "space")
		wKey = VK_SPACE;
	else
	if (strEachKey == "back")
		wKey = VK_BACK;
	else
	if (strEachKey == "delete")
		wKey = VK_DELETE;
	else
	if (strEachKey == "tab")
		wKey = VK_TAB;
	else
	if (strEachKey == "escape")
		wKey = VK_ESCAPE;
	else
	if (strEachKey == "return")
		wKey = VK_RETURN;
	else
//----- 05.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (strEachKey == "left")
		wKey = VK_LEFT;
	else
	if (strEachKey == "up")
		wKey = VK_UP;
	else
	if (strEachKey == "right")
		wKey = VK_RIGHT;
	else
	if (strEachKey == "down")
		wKey = VK_DOWN;
	else
//----- 05.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	if (strEachKey == "ctrl")
		byVirt |= FCONTROL;
	else
	if (strEachKey == "shift")
		byVirt |= FSHIFT;
	else
	if (strEachKey == "alt")
		byVirt |= FALT;
	else
	{
		// _xZkqqHx_iDeHiDiJiBfLiBeC_xHqqkZx_
		return FALSE;
	}
	return TRUE;
} // myStrToAccel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myAccelToStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeBiDeOiDfKiDiJiDiMiBfLiDfOiDeMiBfLiCpAjFlGiOjKiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	myStrToAccel_xZkqqHx_iCmGiIoBiCkCiBeB_xHqqkZx_F1_xZkqqHx_iCmNjFmPiKlHiCmFiCkLiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myAccelToStr (CString& strKey, WORD wKey, BYTE byVirt)
{
	strKey.Empty();
	if (byVirt & FALT) strKey += _T("Alt+");
	if (byVirt & FCONTROL) strKey += _T("Ctrl+");
	if (byVirt & FSHIFT) strKey += _T("Shift+");
	switch (wKey)
	{
	case VK_F1:
		strKey += _T("F1");
		break;
	case VK_F2:
		strKey += _T("F2");
		break;
	case VK_F3:
		strKey += _T("F3");
		break;
	case VK_F4:
		strKey += _T("F4");
		break;
	case VK_F5:
		strKey += _T("F5");
		break;
	case VK_F6:
		strKey += _T("F6");
		break;
	case VK_F7:
		strKey += _T("F7");
		break;
	case VK_F8:
		strKey += _T("F8");
		break;
	case VK_F9:
		strKey += _T("F9");
		break;
	case VK_F10:
		strKey += _T("F10");
		break;
	case VK_F11:
		strKey += _T("F11");
		break;
	case VK_F12:
		strKey += _T("F12");
		break;
	case VK_F13:
		strKey += _T("F13");
		break;
	case VK_F14:
		strKey += _T("F14");
		break;
	case VK_F15:
		strKey += _T("F15");
		break;
	case VK_INSERT:
		strKey += _T("Ins");
		break;
	case VK_SPACE:
		strKey += _T("Space");
		break;
	case VK_BACK:
		strKey += _T("Back");
		break;
	case VK_DELETE:
		strKey += _T("Del");
		break;
	case VK_TAB:
		strKey += _T("Tab");
		break;
	case VK_ESCAPE:
		strKey += _T("Esc");
		break;
	case VK_RETURN:
		strKey += _T("Return");
		break;
//----- 05.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case VK_LEFT:
		strKey += _T("Left");
		break;
	case VK_UP:
		strKey += _T("Up");
		break;
	case VK_RIGHT:
		strKey += _T("Right");
		break;
	case VK_DOWN:
		strKey += _T("Down");
		break;
//----- 05.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	default:
		strKey += (const _TCHAR)AStrToTStr(wKey);
	}
} // myAccelToStr.
//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CheckFloatStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDgGiDeCiDgCiDgHiDhLiDgCiDeOiDfIiCmMjCgMiCkKjFiCjDkOiPkMjAjEjDfPiCmMjFlGiOjKjHpBiCmFiNfMjAkMiClDiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiBeBiClLiCoKiImIiKePiCmMjFlGiOjKjFjEjFkKiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str		:_xZkqqHx_iOoGjDlOiClFiClNjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			pEdit	:_xZkqqHx_iDeHiDgGiDeCiDgCiDgHiDhLiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDCS_ERROR	:_xZkqqHx_jFlGiOjKjHpBiCmJiDeHiDiJiBfLiCkKiCkAiCoJiBeC_xHqqkZx_
 *			FDCS_EMPTY	:_xZkqqHx_jFlGiOjKjHpBiCkKiLpDiBeC_xHqqkZx_
 *			FDCS_NORMAL	:_xZkqqHx_jAlDiPoNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTCheckStr CheckFloatStr (WString& str, CEdit* pEdit)
{
	FFGetWindowText(pEdit, str);
	int iLen = str.GetLength();

	FTCheckStr check = FDCS_EMPTY;
	for (int i = 0; i < iLen; i++)
	{
		if (str.at(i) == L'+' || str.at(i) == L'-' ||
			str.at(i) == L'.' || isdigit(str.at(i)))
		{
			check = FDCS_NORMAL;
		} else if (!iswspace(str.at(i)))
		{
			pEdit->SetSel(i, i + 1);
			return FDCS_ERROR;
		}
	}
	return check;
} // CheckFloatStr

//----------<NOT EXPORT TO VIEWER>-----------
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CheckFloatStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiBgJiDfOiDeDiDhGiCkKiDgIiDiNiDgCiDhGiDfPiDeFiDjDiBgKiCmMjCgMiCkKjFiCjDkOiPkMjAjEjDfP_xHqqkZx_
 *			_xZkqqHx_iCmMjFlGiOjKjHpBiCmFiNfMjAkMiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiBeBiClLiCoKiImIiKePiCmMjFlGiOjKjFjEjFkK_xHqqkZx_
 *			_xZkqqHx_iCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str		:_xZkqqHx_iOoGjDlOiClFiClNjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			pBox	:_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDCS_ERROR	:_xZkqqHx_jFlGiOjKjHpBiCmJiDeHiDiJiBfLiCkKiCkAiCoJiBeC_xHqqkZx_
 *			FDCS_EMPTY	:_xZkqqHx_jFlGiOjKjHpBiCkKiLpDiBeC_xHqqkZx_
 *			FDCS_NORMAL	:_xZkqqHx_jAlDiPoNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.12.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTCheckStr CheckFloatStr (WString& str, CComboBox* pBox)
{
	FFGetWindowText(pBox, str);
	int iLen = str.GetLength();

	FTCheckStr check = FDCS_EMPTY;
	for (int i = 0; i < iLen; i++)
	{
		if (str.at(i) == L'+' || str.at(i) == L'-' ||
			str.at(i) == L'.' || isdigit(str.at(i)))
		{
			check = FDCS_NORMAL;
		} else if (!iswspace(str.at(i)))
		{
			pBox->SetEditSel(i, i + 1);
			return FDCS_ERROR;
		}
	}
	return check;
} // CheckFloatStr

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CheckDWORDStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDgGiDeCiDgCiDgHiDhLiDgCiDeOiDfIiCmMjCgMiCkKiOhHjCoIiCmMjAkOjAjEiCmMjFlGiOjKjHpBiCmFiNfMjAkMiClDiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiBeBiClLiCoKiImIiKePiCmMjFlGiOjKjFjEjFkKiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str		:_xZkqqHx_iOoGjDlOiClFiClNjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			pEdit	:_xZkqqHx_iDeHiDgGiDeCiDgCiDgHiDhLiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wBase	:_xZkqqHx_iKoOjAjEiCpAiOhHjCoIiBeCiCmGiCoIiCkAiCkGiClI_xHqqkZx_2,8,10,16_xZkqqHx_jAgJjAjEiCpAiDfEiDhMiBfLiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDCS_ERROR	:_xZkqqHx_jFlGiOjKjHpBiCmJiDeHiDiJiBfLiCkKiCkAiCoJiBeC_xHqqkZx_
 *			FDCS_EMPTY	:_xZkqqHx_jFlGiOjKjHpBiCkKiLpDiBeC_xHqqkZx_
 *			FDCS_NORMAL	:_xZkqqHx_jAlDiPoNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTCheckStr CheckDWORDStr (WString& str, CEdit* pEdit, WORD wBase)
{
	FFGetWindowText(pEdit, str);
	int iLen = str.GetLength();

	FTCheckStr check = FDCS_EMPTY;
	for (int i = 0; i < iLen; i++)
	{
		if (wBase == 2 &&
			(L'0' <= str.at(i) && str.at(i) <= L'1'))
		{
			check = FDCS_NORMAL;
		} else
		if (wBase == 8 &&
			(L'0' <= str.at(i) && str.at(i) <= L'7'))
		{
			check = FDCS_NORMAL;
		} else
		if (wBase == 10 &&
			(L'0' <= str.at(i) && str.at(i) <= L'9'))
		{
			check = FDCS_NORMAL;
		} else
		if (wBase == 16 &&
			(L'0' <= str.at(i) && str.at(i) <= L'9'))
		{
			check = FDCS_NORMAL;
		} else
		if (wBase == 16 &&
			(L'A' <= str.at(i) && str.at(i) <= L'F'))
		{
			check = FDCS_NORMAL;
		} else
		if (wBase == 16 &&
			(L'a' <= str.at(i) && str.at(i) <= L'f'))
		{
			check = FDCS_NORMAL;
		} else
		if (!iswspace(str.at(i)))
		{
			pEdit->SetSel(i, i + 1);
			return FDCS_ERROR;
		}
	}
	return check;
} // CheckDWORDStr

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SetStdBtnString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfHiPiAiCmMiDhLiDfOiDjD_xHqqkZx_(IDOK,IDCANCEL,etc)_xZkqqHx_iCmMjFfMiOkGjFlGiOjKjHpBiCpAjChFiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hWndDlg	:_xZkqqHx_jChFiCkLiKlHiCkGiCoJiDhLiDfOiDjDiCpAiOhBiCmJiOjNiCmCiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SetStdBtnString (HWND hWndDlg)
{
	for (HWND hWnd = ::GetWindow(hWndDlg, GW_CHILD);
		hWnd != NULL; hWnd = ::GetNextWindow(hWnd, GW_HWNDNEXT))
	{
		DWORD dwID = GetDlgCtrlID(hWnd);
		switch (dwID)
		{
		case IDOK:
			FFSetWindowText(hWnd, FFLoadWString(IDS_CTRL_OK));
			break;
		case IDCANCEL:
			FFSetWindowText(hWnd, FFLoadWString(IDS_CTRL_CANCEL));
			break;
		case IDHELP:
			FFSetWindowText(hWnd, FFLoadWString(IDS_CTRL_HELP));
			break;
//----- 00.09.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		case ID_APPLY_NOW:
			FFSetWindowText(hWnd, FFLoadWString(IDS_CTRL_APPLY_NOW));
			break;
//----- 00.09.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		}
	}
} // SetStdBtnString.
//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SetUnitString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmFiBeBiDeFiDeCiDjDiDgIiDeFiDgFiDeMiDfIiDgHiCkK_xHqqkZx_"$@@@"_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNiBeBiMlLiNnNiCmMjCfAiImKiBgJiDhOiDiKiBeBiDeDiDjDiDgAiBgKiCmMjFlGiOjKjHpBiCmGjChFiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hWndDlg	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SetUnitString (HWND hWndDlg)
{
	_TCHAR tcsBuff[1000];
	for (HWND hWnd = ::GetWindow(hWndDlg, GW_CHILD);
		hWnd != NULL; hWnd = ::GetNextWindow(hWnd, GW_HWNDNEXT))
	{
		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgFiDeMiDfIiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		::GetWindowText(hWnd, tcsBuff, sizeof(tcsBuff));
		// _xZkqqHx_iDgFiDeMiDfIiDgHiCkK_xHqqkZx_"$@@@"_xZkqqHx_iCmFiCkAiCoKiCmOiBeBjCfAiImKjFlGiOjKjHpBiCmJjChFiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
		if (!_tcscmp(tcsBuff, _T("$@@@")))
			SetWindowText(hWnd, WStrToTStr(g_pReg->GetUnitString()));
	}
} // SetUnitString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RightByLeftHand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePjCiGiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFlGiOjKiCpAiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNlGjHjIiCkLiCmJjAnNjCoIiCmMiPoKiNiHiCmNiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCmMiDeFiDeCiDjDiDgIiDeFiDgFiDeMiDfIiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_iJeFjHjIiCkLjHhAjFlGiOjKjHpBiCkJiCoHiNlGjHjIiCkLjHhAjFlGiOjKjHpBiCmJjChFiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hWndDlg	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void RightByLeftHand (HWND hWndDlg)
{
//----------<NOT EXPORT TO VIEWER>-----------
	// _xZkqqHx_iJeFjHjIiCkLiCmJjAnNjCoIiCmMiPoKiNiHiCmNiBeBjFjMiLeBiBeC_xHqqkZx_
	if (!g_pReg->GetIsLeftHand()) return;
//----- 06.01.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	_TCHAR tcsBuff[256];
//	for (HWND hWnd = ::GetWindow(hWndDlg, GW_CHILD);
//		hWnd != NULL; hWnd = ::GetNextWindow(hWnd, GW_HWNDNEXT))
//	{
//		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgFiDeMiDfIiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
//		::GetWindowText(hWnd, tcsBuff, sizeof(tcsBuff));
//		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLjFlGiOjKjHpBjCiGiCmM_xHqqkZx_"(&"_xZkqqHx_jFlGiOjKjHpBiCmMiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
//		_TCHAR* tcpFind = _tcsstr(tcsBuff, _T("(&"));
//		// _xZkqqHx_jFlGiOjKjHpBiCkKjGlDiCkCiPoKiNiHiCmNiBeBiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (tcpFind == NULL) continue;
//		//----- _xZkqqHx_jFlGiOjKjHpBiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
//		// _xZkqqHx_iNlGjHjIiCkLjHhAiCnGjFmPiKlHiPiIjHjNiBeC_xHqqkZx_
//		tcpFind[2] = s_mpRight2Left[tcpFind[2]];
//		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgFiDeMiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
//		::SetWindowText(hWnd, tcsBuff);
//	}
//----- 06.01.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	for (HWND hWnd = ::GetWindow(hWndDlg, GW_CHILD);
		hWnd != NULL; hWnd = ::GetNextWindow(hWnd, GW_HWNDNEXT))
	{
		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgFiDeMiDfIiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		WString wstr;
		FFGetWindowText(hWnd, wstr);
		// _xZkqqHx_iNlGjHjIiCkLjHhAiCnGjFmPiKlHiPiIjHjNiBeC_xHqqkZx_
		if (RightByLeftHand(wstr))
			FFSetWindowText(hWnd, wstr);
	}
//----- 06.01.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----------</NOT EXPORT TO VIEWER>-----------
} // RightByLeftHand.

//----------<NOT EXPORT TO VIEWER>-----------
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RightByLeftHand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFjHjIiCkLjHhAiCmMiDiBiDgKiDiFiBfLjFlGiOjKiCmGiNlGjHjIiCkLjHhAiCmMiDiBiDgKiDiFiBfLjFlGiOjKiCpAiMpAiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hMenu	:_xZkqqHx_iMpAiKlHiClHiCoJiDiBiDgKiDiFiBfLiBeC_xHqqkZx_
 *			bToLeft	:_xZkqqHx_iNlGjHjIiCkLjHhAiCmJjFmPiKlHiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiJeFjHjIiCkLjHhAiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iNmEiLeBiMmEiCnBiPgPiClFiCmJiCoGiCmBiCmEiBeB_xHqqkZx_hMenu_xZkqqHx_iCkJiCoHiDfEiDhFiDiBiDgKiDiFiBfLiCpAjCeIiCoIiBeBjBfDiCmEiCmM_xHqqkZx_
 *			_xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.03.13 Fukushiro M. MainFrame.cpp_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void RightByLeftHand (HMENU hMenu, BOOL bToLeft)
{
	MENUITEMINFO mii;
	// _xZkqqHx_iDiBiDgKiDiFiBfLjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
	const int iMenuCount = GetMenuItemCount(hMenu);
// 06.01.21 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	_TCHAR* tcpFind;
	for (int imi = 0; imi < iMenuCount; imi++)
	{
		_TCHAR tsz[250] = { _T('\0') };
		//----- _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBiCmGiDfEiDhFiDiBiDgKiDiFiBfLiDgOiDjDiDgIiDiLiCpAiOoGjDlO_xHqqkZx_ -----
		mii.cbSize = sizeof(mii);
		mii.fMask = MIIM_TYPE | MIIM_SUBMENU;
		mii.dwTypeData = tsz;
		mii.cch = sizeof(tsz) / sizeof(tsz[0]);
		GetMenuItemInfo(hMenu, imi, MF_BYPOSITION, &mii);
		// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCkKiCkAiCoJiPoKiNiHiCmNiNmEiLeBiMmEiCnBiPgPiClFiBeC_xHqqkZx_
		if (mii.hSubMenu != NULL) RightByLeftHand(mii.hSubMenu, bToLeft);
		// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBiCkKjGlDiCkCiPoKiNiHiBgJiDfKiDhAiDiMiBfLiDfOjDjJiBgKiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (mii.dwTypeData == NULL || *(mii.dwTypeData) == _T('\0')) continue;

//----- 06.01.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBjCiGiCmM_xHqqkZx_"("_xZkqqHx_jFlGiOjKjHpBiCmMiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
//		// _xZkqqHx_jFjEjFgJiDiBiDgKiDiFiBfLiCmFiBeBiDgDiBfLiDiLiCmJiCoGiCmBiCmEiCmN_xHqqkZx_"&"_xZkqqHx_iCpAiOoGiCoIiLiOiCmBiCmEiCkCiCoJ_xHqqkZx_
//		// _xZkqqHx_iPoKiNiHiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
//		tcpFind = _tcsstr(mii.dwTypeData, _T("("));
//		// _xZkqqHx_jFlGiOjKjHpBiCkKjGlDiCkCiPoKiNiHiCmNiBeBiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (tcpFind == NULL) continue;
//		//----- _xZkqqHx_jFlGiOjKjHpBiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
//		tcpFind++;
//		if (*tcpFind == _T('&')) tcpFind++;
//		if (bToLeft)
//		//----- _xZkqqHx_iNlGjHjIiCkLjHhAiCnGjFmPiKlHiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iNlGjHjIiCkLjHhAiCnGjFmPiKlHiPiIjHjNiBeC_xHqqkZx_
//			*tcpFind = s_mpRight2Left[*tcpFind];
//		} else
//		//----- _xZkqqHx_iJeFjHjIiCkLjHhAiCnGjFmPiKlHiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iNlGjHjIiCkLjHhAiCnGjFmPiKlHiPiIjHjNiBeC_xHqqkZx_
//			*tcpFind = s_mpLeft2Right[*tcpFind];
//		}
//----- 06.01.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		WString wstr = TStrToWStr(mii.dwTypeData);
		if (bToLeft)
		//----- _xZkqqHx_iNlGjHjIiCkLjHhAiCnGjFmPiKlHiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iNlGjHjIiCkLjHhAiCnGjFmPiKlHiPiIjHjNiBeC_xHqqkZx_
			if (RightByLeftHand(wstr))
				_tcscpy(mii.dwTypeData, WStrToTStr(wstr));
		} else
		//----- _xZkqqHx_iJeFjHjIiCkLjHhAiCnGjFmPiKlHiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iNlGjHjIiCkLjHhAiCnGjFmPiKlHiPiIjHjNiBeC_xHqqkZx_
			if (LeftByRightHand(wstr))
				_tcscpy(mii.dwTypeData, WStrToTStr(wstr));
		}
//----- 06.01.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		//----- _xZkqqHx_jFmPiKlHiMoDiCmMjFlGiOjKjHpBiCpAiDiBiDgKiDiFiBfLiCmJjAnNjCoI_xHqqkZx_ -----
		mii.cbSize = sizeof(mii);
// 06.01.21 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		mii.dwTypeData = tsz;
		mii.fMask = MIIM_TYPE;
		mii.fType = MFT_STRING;
		mii.cch = _tcslen(mii.dwTypeData);
		SetMenuItemInfo(hMenu, imi, MF_BYPOSITION, &mii);
	}
} // RightByLeftHand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RightByLeftHand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNlGjHjIiCkLiCmJjAnNjCoIiCmJiCmIiCmBiCmEiCkCiCoJiPoKiNiHiCmNiBeBiJeFjHjIiCkLjHhAiCmMjFlGiOjKiCpAiNlGjHjIiCkLjHhAiCmM_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKiCmJiMpAiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tc	:_xZkqqHx_iMpAiKlHiClHiCoJjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiKlHiClFiClNjFlGiOjKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.02.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//_TCHAR RightByLeftHand (_TCHAR tc)
wchar_t RightByLeftHand (wchar_t tc)
{
	// _xZkqqHx_iJeFjHjIiCkLiCmJjAnNjCoIiCmMiPoKiNiHiCmNiBeBjFjMiLeBiBeC_xHqqkZx_
	if (!g_pReg->GetIsLeftHand()) return tc;
	// _xZkqqHx_iNlGjHjIiCkLjHhAiCnGjFmPiKlHiPiIjHjNiBeC_xHqqkZx_
	return s_mpRight2Left[tc];
} // RightByLeftHand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RightByLeftHand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIjFlGiOjKjHpBjCiGiCmMiDfGiDiHiBfLiDgHiDeKiDgCiDgHjFlGiOjKiCpAiJeFjHjIiCkLiCkJiCoHiNlGjHjIiCkLjHhAiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstr	:_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeCjChFiKlHiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jChFiKlHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	'(' _xZkqqHx_iBkI_xHqqkZx_ '&' _xZkqqHx_iBkI_xHqqkZx_ X _xZkqqHx_iBkI_xHqqkZx_ ')' _xZkqqHx_iCmMiPiHiCmJjCfEiClFiCmEiIoKjChGiClHiCoKiCmOjFlGiOjK_xHqqkZx_X_xZkqqHx_iCpAjChFiKlHiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jCeBiClFiBeBjFjEjFgJiDiBiDgKiDiFiBfLiCmFiBeBiDgDiBfLiDiLiCmJiCoGiCmBiCmEiCmN_xHqqkZx_"&"_xZkqqHx_iCpAiOoGiCoIiLiOiCmBiCmEiCkCiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCkKiCkAiCoJiClNiCnPiBeBiJlKiCmMiCoGiCkEiCmJ_xHqqkZx_'&'_xZkqqHx_iCkKjGlDiCkNiCmEiCoAjChFiKlHjBmOiPnLiCmGiClHiCoJiBeC_xHqqkZx_
 *			'(' _xZkqqHx_iBkI_xHqqkZx_ X _xZkqqHx_iBkI_xHqqkZx_ ')'
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RightByLeftHand (WString& wstr)
{
#ifdef FD_TOP_ACCESSKEY		// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
	// & _xZkqqHx_iCkKiPmIjHkKiClDiCoKiCmEiCkCiCoJiPoKiNiHiCoAiCkAiCoJiClNiCnPiBeB_xHqqkZx_FD_TOP_ACCESSKEY_LEN _xZkqqHx_iCkJiCoH_xHqqkZx_ 1 _xZkqqHx_iCpAiIpIiCkNiBeC_xHqqkZx_
	if (wstr.GetLength() < FD_TOP_ACCESSKEY_LEN - 1)
		return FALSE;
	// _xZkqqHx_iDeMiBfLiCmMjFlGiOjKjFjEjFkKiCmMiImKjChFiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	const int iIndex = (wstr.at(0) == L'&') ? 1 : 0;
	FTTcTcMap::const_iterator i = s_mpRight2Left.find(wstr.at(iIndex));
	if (i != s_mpRight2Left.end())
	//----- _xZkqqHx_jFlGiOjKiCmJjBmOiJjOiClHiCoJiNlGjHjIiCkLjHhAjFlGiOjKiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFlGiOjKiCpAjChFiKlHiBeC_xHqqkZx_
		wstr.at(iIndex) = i->second;
		return TRUE;
	}
	return FALSE;
#else //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjCiGiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
	int iC = 0;
	for (;;)
	{
		if (iC == wstr.GetLength()) break;
		if (wstr.at(iC) == L'(')
		{
			iC++;
			if (iC == wstr.GetLength()) break;
			if (wstr.at(iC) == L'&')
			{
				iC++;
				if (iC == wstr.GetLength()) break;
			}
			if (wstr.at(iC) < 0x80)
			{
				iC++;
				if (iC == wstr.GetLength()) break;
				if (wstr.at(iC) == L')')
				{
// 06.02.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//					FTTcTcMap::const_iterator i = s_mpRight2Left.find(_TCHAR(wstr.at(iC - 1)));
					FTTcTcMap::const_iterator i = s_mpRight2Left.find(wstr.at(iC - 1));
					if (i == s_mpRight2Left.end()) break;
					wstr.at(iC - 1) = i->second;
					return TRUE;
				}
			}
		} else
		{
			iC++;
		}
	}
	return FALSE;
#endif //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
} // RightByLeftHand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	LeftByRightHand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIjFlGiOjKjHpBjCiGiCmMiDfGiDiHiBfLiDgHiDeKiDgCiDgHjFlGiOjKiCpAiNlGjHjIiCkLiCkJiCoHiJeFjHjIiCkLjHhAiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstr	:_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeCjChFiKlHiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jChFiKlHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	'(' _xZkqqHx_iBkI_xHqqkZx_ '&' _xZkqqHx_iBkI_xHqqkZx_ X _xZkqqHx_iBkI_xHqqkZx_ ')' _xZkqqHx_iCmMiPiHiCmJjCfEiClFiCmEiIoKjChGiClHiCoKiCmOjFlGiOjK_xHqqkZx_X_xZkqqHx_iCpAjChFiKlHiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jCeBiClFiBeBjFjEjFgJiDiBiDgKiDiFiBfLiCmFiBeBiDgDiBfLiDiLiCmJiCoGiCmBiCmEiCmN_xHqqkZx_"&"_xZkqqHx_iCpAiOoGiCoIiLiOiCmBiCmEiCkCiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCkKiCkAiCoJiClNiCnPiBeBiJlKiCmMiCoGiCkEiCmJ_xHqqkZx_'&'_xZkqqHx_iCkKjGlDiCkNiCmEiCoAjChFiKlHjBmOiPnLiCmGiClHiCoJiBeC_xHqqkZx_
 *			'(' _xZkqqHx_iBkI_xHqqkZx_ X _xZkqqHx_iBkI_xHqqkZx_ ')'
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL LeftByRightHand (WString& wstr)
{
#ifdef FD_TOP_ACCESSKEY		// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
	// & _xZkqqHx_iCkKiPmIjHkKiClDiCoKiCmEiCkCiCoJiPoKiNiHiCoAiCkAiCoJiClNiCnPiBeB_xHqqkZx_FD_TOP_ACCESSKEY_LEN _xZkqqHx_iCkJiCoH_xHqqkZx_ 1 _xZkqqHx_iCpAiIpIiCkNiBeC_xHqqkZx_
	if (wstr.GetLength() < FD_TOP_ACCESSKEY_LEN - 1)
		return FALSE;
	// _xZkqqHx_iDeMiBfLiCmMjFlGiOjKjFjEjFkKiCmMiImKjChFiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	const int iIndex = (wstr.at(0) == L'&') ? 1 : 0;
	FTTcTcMap::const_iterator i = s_mpLeft2Right.find(wstr.at(iIndex));
	if (i != s_mpRight2Left.end())
	//----- _xZkqqHx_jFlGiOjKiCmJjBmOiJjOiClHiCoJiNlGjHjIiCkLjHhAjFlGiOjKiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFlGiOjKiCpAjChFiKlHiBeC_xHqqkZx_
		wstr.at(iIndex) = i->second;
		return TRUE;
	}
	return FALSE;
#else //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjCiGiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
	int iC = 0;
	for (;;)
	{
		if (iC == wstr.GetLength()) break;
		if (wstr.at(iC) == L'(')
		{
			iC++;
			if (iC == wstr.GetLength()) break;
			if (wstr.at(iC) == L'&')
			{
				iC++;
				if (iC == wstr.GetLength()) break;
			}
			if (wstr.at(iC) < 0x80)
			{
				iC++;
				if (iC == wstr.GetLength()) break;
				if (wstr.at(iC) == L')')
				{
// 06.02.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//					FTTcTcMap::const_iterator i = s_mpLeft2Right.find(_TCHAR(wstr.at(iC - 1)));
					FTTcTcMap::const_iterator i = s_mpLeft2Right.find(wstr.at(iC - 1));
					if (i == s_mpLeft2Right.end()) break;
					wstr.at(iC - 1) = i->second;
					return TRUE;
				}
			}
		} else
		{
			iC++;
		}
	}
	return FALSE;
#endif //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
} // LeftByRightHand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	ShortenMenu
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiCpAjCfKiPgLiMgAiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hMenu	:_xZkqqHx_jFmPiKlHiClHiCoJiDiBiDgKiDiFiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.10.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void ShortenMenu (HMENU hMenu)
{
	map<WString, WString> mpLongToShort;
	WString strMenuTbl;
	strMenuTbl.LoadString(IDS_SHORT_MENU);

	while (!strMenuTbl.IsEmpty())
	{
		WString strLongMenu = FFExtractUntil(strMenuTbl, L"\n");
		WString strShortMenu = FFExtractUntil(strMenuTbl, L"\n");
		mpLongToShort[strLongMenu] = strShortMenu;
	}
	MENUITEMINFO mii;
	_TCHAR szMenu[260];
	// _xZkqqHx_iDiBiDgKiDiFiBfLjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
	const int iMenuCount = GetMenuItemCount(hMenu);
	for (int imi = 0; imi < iMenuCount; imi++)
	{
		//----- _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBiCmGiDfEiDhFiDiBiDgKiDiFiBfLiDgOiDjDiDgIiDiLiCpAiOoGjDlO_xHqqkZx_ -----
		mii.cbSize = sizeof(mii);
		mii.fMask = MIIM_TYPE;
		mii.dwTypeData = szMenu;
		mii.cch = sizeof(szMenu) / sizeof(szMenu[0]);
		GetMenuItemInfo(hMenu, imi, MF_BYPOSITION, &mii);
		// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBiCkKjGlDiCkCiPoKiNiHiBgJiDfKiDhAiDiMiBfLiDfOjDjJiBgKiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (mii.dwTypeData == NULL || *(mii.dwTypeData) == _T('\0')) continue;
#ifdef FD_TOP_ACCESSKEY		// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
		WString wstrMenu = TStrToWStr(mii.dwTypeData);
		// _xZkqqHx_jFlGjDkKiCmJ_xHqqkZx_'&'_xZkqqHx_iCkKjGlDiCkCiPoKiNiHiCmNiBeBiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (wstrMenu.at(0) != L'&') continue;
		//----- _xZkqqHx_jFlGiOjKjHpBiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
		// _xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLjFjEiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		const WString wstrAccesskey = wstrMenu.Left(FD_TOP_ACCESSKEY_LEN);
		// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGjGhLjBmMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		wstrMenu = wstrMenu.Mid(FD_TOP_ACCESSKEY_LEN);
		// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGjGhLjBmMiCpAjFmPiKlHiBeC_xHqqkZx_
		wstrMenu = mpLongToShort[wstrMenu];
		// _xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLiCpAjBhNjDpMiBeC_xHqqkZx_
		wstrMenu.Insert(0, wstrAccesskey);
		_tcscpy(szMenu, WStrToTStr(wstrMenu));
#else //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjCiGiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBjCiGiCmM_xHqqkZx_"(&"_xZkqqHx_jFlGiOjKjHpBiCmMiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
		_TCHAR* tcpFind = _tcsstr(mii.dwTypeData, _T("(&"));
		// _xZkqqHx_jFlGiOjKjHpBiCkKjGlDiCkCiPoKiNiHiCmNiBeBiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (tcpFind == NULL) continue;
		//----- _xZkqqHx_jFlGiOjKjHpBiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
		tcpFind[0] = _T('\0');
		CString strShort = WStrToTStr(mpLongToShort[TStrToWStr(szMenu)]);
		strShort += _T("(&");
		strShort += tcpFind[2];
		_tcscpy(szMenu, strShort);
#endif //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
		//----- _xZkqqHx_jFmPiKlHiMoDiCmMjFlGiOjKjHpBiCpAiDiBiDgKiDiFiBfLiCmJjAnNjCoI_xHqqkZx_ -----
		mii.cbSize = sizeof(mii);
		mii.dwTypeData = szMenu;
		mii.fMask = MIIM_TYPE;
		mii.fType = MFT_STRING;
		mii.cch = _tcslen(mii.dwTypeData);
		SetMenuItemInfo(hMenu, imi, MF_BYPOSITION, &mii);
	}
} // ShortenMenu.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	LengthenMenu
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiCpAjCmKiPoNiCmMjClHiClDiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hMenu	:_xZkqqHx_jFmPiKlHiClHiCoJiDiBiDgKiDiFiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.10.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void LengthenMenu (HMENU hMenu)
{
	map<WString, WString> mpShortToLong;
	WString strMenuTbl;
	strMenuTbl.LoadString(IDS_SHORT_MENU);

	while (!strMenuTbl.IsEmpty())
	{
		WString strLongMenu = FFExtractUntil(strMenuTbl, L"\n");
		WString strShortMenu = FFExtractUntil(strMenuTbl, L"\n");
		mpShortToLong[strShortMenu] = strLongMenu;
	}
	MENUITEMINFO mii;
	_TCHAR szMenu[260];
	// _xZkqqHx_iDiBiDgKiDiFiBfLjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
	const int iMenuCount = GetMenuItemCount(hMenu);
	for (int imi = 0; imi < iMenuCount; imi++)
	{
		//----- _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBiCmGiDfEiDhFiDiBiDgKiDiFiBfLiDgOiDjDiDgIiDiLiCpAiOoGjDlO_xHqqkZx_ -----
		mii.cbSize = sizeof(mii);
		mii.fMask = MIIM_TYPE;
		mii.dwTypeData = szMenu;
		mii.cch = sizeof(szMenu) / sizeof(szMenu[0]);
		GetMenuItemInfo(hMenu, imi, MF_BYPOSITION, &mii);
		// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBiCkKjGlDiCkCiPoKiNiHiBgJiDfKiDhAiDiMiBfLiDfOjDjJiBgKiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (mii.dwTypeData == NULL || *(mii.dwTypeData) == _T('\0')) continue;
#ifdef FD_TOP_ACCESSKEY		// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
		WString wstrMenu = TStrToWStr(mii.dwTypeData);
		// _xZkqqHx_jFlGjDkKiCmJ_xHqqkZx_'&'_xZkqqHx_iCkKjGlDiCkCiPoKiNiHiCmNiBeBiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (wstrMenu.at(0) != L'&') continue;
		//----- _xZkqqHx_jFlGiOjKjHpBiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
		// _xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLjFjEiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		const WString wstrAccesskey = wstrMenu.Left(FD_TOP_ACCESSKEY_LEN);
		// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGjGhLjBmMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		wstrMenu = wstrMenu.Mid(FD_TOP_ACCESSKEY_LEN);
		// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGjGhLjBmMiCpAjFmPiKlHiBeC_xHqqkZx_
		wstrMenu = mpShortToLong[wstrMenu];
		// _xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLiCpAjBhNjDpMiBeC_xHqqkZx_
		wstrMenu.Insert(0, wstrAccesskey);
		_tcscpy(szMenu, WStrToTStr(wstrMenu));
#else //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjCiGiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBjCiGiCmM_xHqqkZx_"(&"_xZkqqHx_jFlGiOjKjHpBiCmMiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
		_TCHAR* tcpFind = _tcsstr(mii.dwTypeData, _T("(&"));
		// _xZkqqHx_jFlGiOjKjHpBiCkKjGlDiCkCiPoKiNiHiCmNiBeBiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (tcpFind == NULL) continue;
		//----- _xZkqqHx_jFlGiOjKjHpBiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
		tcpFind[0] = _T('\0');
		CString strLong = WStrToTStr(mpShortToLong[TStrToWStr(szMenu)]);
		strLong += _T("(&");
		strLong += tcpFind[2];
		strLong += _T(')');
		_tcscpy(szMenu, strLong);
#endif //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
		//----- _xZkqqHx_jFmPiKlHiMoDiCmMjFlGiOjKjHpBiCpAiDiBiDgKiDiFiBfLiCmJjAnNjCoI_xHqqkZx_ -----
		mii.cbSize = sizeof(mii);
		mii.dwTypeData = szMenu;
		mii.fMask = MIIM_TYPE;
		mii.fType = MFT_STRING;
		mii.cch = _tcslen(mii.dwTypeData);
		SetMenuItemInfo(hMenu, imi, MF_BYPOSITION, &mii);
	}
} // LengthenMenu.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFMakeCommandText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDfOiDeDiDgHiDiLiCmGiDeBiDeOiDfKiDfIiDeMiBfLiCkJiCoHiBeBiDfCiDhNiDjDiDgIjFlGiOjKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTitle	:_xZkqqHx_iDfCiDhNiDjDiDgIjFlGiOjKjHpBiCmMiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcAccesskey	:_xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiBeG_xHqqkZx_wcpTitle = "_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_", wcAccesskey = 'F' -> "&F. _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_"
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFMakeCommandText (const wchar_t* wcpTitle, wchar_t wcAccesskey)
{
	wchar_t key[2] = { L'\0', L'\0' };
	key[0] = wcAccesskey;
#ifdef FD_ACCESSKEY_UC	// _xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLiCkKjBoFjFlGiOjKiCmMiPoKiNiHiBeC_xHqqkZx_
	_wcsupr(key);	// _xZkqqHx_jBoFjFlGiOjKiCmJiBeC_xHqqkZx_
#else //FD_ACCESSKEY_UC	// _xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLiCkKiPkMjFlGiOjKiCmMiPoKiNiHiBeC_xHqqkZx_
	_wcslwr(key);	// _xZkqqHx_iPkMjFlGiOjKiCmJiBeC_xHqqkZx_
#endif //FD_ACCESSKEY_UC	// _xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLiCkKiPkMjFlGiOjKiCmMiPoKiNiHiBeC_xHqqkZx_

	WString wstrText;
#ifdef FD_TOP_ACCESSKEY		// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
	wstrText.Format(FD_TOP_ACCESSKEY_FORM, wcAccesskey, wcpTitle);
#else //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjCiGiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
	wstrText.Format(L"%s (&%c)", wcpTitle, wcAccesskey);
#endif //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
	return wstrText;
} // FFMakeCommandText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SetHiListByRealData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiBeBiCgHiCgIiNmAjFfHiCmMjFfMiOkGiDiKiDfIiDgHiCpAiOhHjCoIiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iOmAiNmAjFfHiDgGiBfLiDfOjEhKjHpBiCkJiCoHjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmb	:_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iDataSz	:_xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmaData	:_xZkqqHx_jAnNjCoIiClHiCoJiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.09.14 Fukushiro M. _xZkqqHx_jDkPiClGjFlGiOjKjHpBiCmNjAnNjCoIiClFiCmIiCkCiBeC_xHqqkZx_
 *************************************************************************/
void SetHiListByRealData (CComboBox* pCmb, int iDataSz, const mmetol mmaData[])
{
	//----- _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiMpDjFoCiDgGiBfLiDfOjAnNjCoI_xHqqkZx_ -----
	WString strNum;
	wchar_t tcsBuff[200];
	pCmb->ResetContent();
	for (int iC = 0; iC < iDataSz; iC++)
	{
		if (strNum == hix2histr(tcsBuff, hixroundoff(mm2hix(mmaData[iC])))) continue;
		strNum = tcsBuff;
		FFAddString(pCmb ,strNum);
	}
} // SetHiListByRealData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SetXtmListByTmsData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiBeBiCgHiCgIiNmAjFfHiCmMjFfMiOkGiDiKiDfIiDgHiCpAiOhHjCoIiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iOmAiNmAjFfHiDgGiBfLiDfOjEhKjHpBiCkJiCoHjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmb	:_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iDataSz	:_xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tmsaData:_xZkqqHx_jAnNjCoIiClHiCoJiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SetXtmListByTmsData (CComboBox* pCmb, int iDataSz, const tmsc tmsaData[])
{
	//----- _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiMpDjFoCiDgGiBfLiDfOjAnNjCoI_xHqqkZx_ -----
	WString strNum;
	wchar_t tcsBuff[200];
	pCmb->ResetContent();
	for (int iC = 0; iC < iDataSz; iC++)
	{
		if (strNum == xtm2tmsstr(tcsBuff, tms2xtm(tmsaData[iC]))) continue;
		strNum = tcsBuff;
		FFAddString(pCmb ,strNum);
	}
} // SetXtmListByTmsData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SetAngleListByAngleData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmJiBeB_xHqqkZx_angle_xZkqqHx_iCmMjFfMiOkGiDiKiDfIiDgHiCpAiOhHjCoIiClDiCoKiClNiDgGiBfLiDfOjEhKjHpBiCkJiCoHjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmb	:_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iDataSz	:_xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			daData	:_xZkqqHx_jAnNjCoIiClHiCoJiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SetAngleListByAngleData (CComboBox* pCmb, int iDataSz, const angle daData[])
{
	//----- _xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiMpDjFoCiDgGiBfLiDfOjAnNjCoI_xHqqkZx_ -----
	WString strNum;
	pCmb->ResetContent();
	for (int iC = 0; iC < iDataSz; iC++)
	{
		strNum.Format(L"%.4f", daData[iC]);
		FFAddString(pCmb ,strNum);
	}
} // SetAngleListByAngleData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FindPropPage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeOiDiJiDfIiCmMiDhJiBfLiDfHiDeJiDhFiDfHiDeGiDeOiDgHiCpAjCfEiClFiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pSheet	:_xZkqqHx_jAgFiDfGiBfLiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pClass	:_xZkqqHx_iMjPiNpFjBmOiPnLiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmJiMkJiCmCiCkJiCmBiClNiDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			NULL _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CPropertyPage* FindPropPage (const CPropertySheet* pSheet, CRuntimeClass* pClass)
{
	if (pSheet == NULL) return NULL;
	for (int iC = 0; iC < pSheet->GetPageCount(); iC++)
	{
		CPropertyPage* pPage = pSheet->GetPage(iC);
		if (pPage->IsKindOf(pClass)) return pPage;
	}
	return NULL;
} // FindPropPage.
//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFJustifyWindow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPoDiCmMiOhHjCoIiCmMiNmAjFfHiCkKiDhNiDeFiDfIiDeKiBfLiDfMiDiLiPoDiCmJjHiIiCoJiCoGiCkEiCmJ_xHqqkZx_
 *			_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hWnd		:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			hWndOffset	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPoDiCmMiKoOiPiAiNmAjFfHiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	pOffset_xZkqqHx_iCkK_xHqqkZx_NULL_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiDfPiDeDiDeBiDiNiDePjCiGiJjLiCkKiDhNiDeFiDfIiImKjChFiCmJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFJustifyWindow (HWND hWnd, HWND hWndOffset)
{
	CRect rect;
	GetWindowRect(hWndOffset, rect);
	CPoint ptCenter = rect.CenterPoint();
	ScreenToClient(hWnd, &ptCenter);
	FFJustifyWindow(hWnd, &ptCenter);
} // FFJustifyWindow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFJustifyWindow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPoDiCmMiOhHjCoIiCmMiNmAjFfHiCkKiDhNiDeFiDfIiDeKiBfLiDfMiDiLiPoDiCmJjHiIiCoJiCoGiCkEiCmJ_xHqqkZx_
 *			_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hWnd	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pOffset	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPoDiCmMiKoOiPiAiNmAjFfHiCpAiOhHjCoIiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	pOffset_xZkqqHx_iCkK_xHqqkZx_NULL_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiDfPiDeDiDeBiDiNiDePjCiGiJjLiCkKiDhNiDeFiDfIiImKjChFiCmJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFJustifyWindow (HWND hWnd, CPoint* pOffset)
{
	static time_t	stTime = 0;
	static CPoint	stptOffset(0, 0);

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiClHiCoJiCkJiBeI_xHqqkZx_
	if (!g_pReg->GetIsShowDlgNearMouse()) return;

	CPoint ptOffset;
	CRect rtDialog;
	GetWindowRect(hWnd, rtDialog);
	if (pOffset == NULL)
	{
		ptOffset = rtDialog.CenterPoint();
	} else
	{
		ptOffset = *pOffset;
		ClientToScreen(hWnd, &ptOffset);
	}
	// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
	CPoint ptMouse;
	GetCursorPos(&ptMouse);
	// _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
	ptOffset = ptMouse - ptOffset;
	//----- _xZkqqHx_jCfKiCkCiOjOiKnEiCmJiDfPiDeDiDeBiDiNiDePiCpAjIeBjBlBiClFiCmEjFfMiOkGiClHiCoJiPoKiNiHiCmJiBeBiDfPiDeDiDeBiDiNiDePiCkKiInKjDkOiClFiCmIiCkCiCoGiCkEiCmJ_xHqqkZx_ -----
	// _xZkqqHx_iMlLiNnNiCmMiOjOiKnEiBgJjFgCiBgKiCpAiOoGjDlOiBeC_xHqqkZx_
	time_t timeNew = time(NULL);
	// _xZkqqHx_jBePiJpBiCmMiDfPiDeDiDeBiDiNiDePjFfMiOkGiCkJiCoH_xHqqkZx_3_xZkqqHx_jFgCjGkCjGjOiCmIiCoHiCmOiBeBjDkPiClGiImKjChFiCmJiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
	if (timeNew - stTime < 3)
		ptOffset = stptOffset;
	// static_xZkqqHx_iCmMiPoOjFpBiCpAiNfIjAfGiBeC_xHqqkZx_
	stTime = timeNew;
	stptOffset = ptOffset;
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiNmAjFfHiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
	rtDialog += ptOffset;

	// _xZkqqHx_iDiCiDgKiDfOiBfLiCmJiLoJiMgAiCkKiOpLiCnMiCoJiCoGiCkEjFoCjAlDiBeC_xHqqkZx_
	rtDialog += FFJustifyToMonitor(rtDialog);

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiInKjDkOiBeC_xHqqkZx_
	SetWindowPos(hWnd, NULL, rtDialog.left, rtDialog.top, 0, 0,
						SWP_NOACTIVATE|SWP_NOCOPYBITS|SWP_NOOWNERZORDER|
						SWP_NOSENDCHANGING|SWP_NOSIZE|SWP_NOZORDER);
} // FFJustifyWindow.

//----------<NOT EXPORT TO VIEWER>-----------
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFUpdateTextComboList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDgFiDeMiDfIiDgHjIgHiCmMiDgFiDeMiDfIiDgHiCpAiBeBiDiKiDfIiDgHiNmFiPoDiImKiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiKiDfIiDgHjCiGiCmJjDkPiClGiDgFiDeMiDfIiDgHiCkKiCkAiCoJiPoKiNiHiCmNiNoNiPjMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pBox	:_xZkqqHx_iDiKiDfIiDgHiDhLiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFUpdateTextComboList (CComboBox* pBox)
{
	WString wstrText;
	FFGetWindowText(pBox, wstrText);
//----- 05.06.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	int iIndex = pBox->FindStringExact(-1, WStrToTStr(wstrText));
//----- 05.06.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// CComboBox::FindStringExact_xZkqqHx_iCmNiBeBjBoFjFlGiOjKiCmGiPkMjFlGiOjKiCpAiLoGjFmKiClJiClIiMjPiNpFiClHiCoJiClNiCnPiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
	int iIndex;
	for (iIndex = 0; iIndex != pBox->GetCount(); iIndex++)
	{
		WString wstrList;
		FFGetLBText(pBox, iIndex, wstrList);
		if (wstrList == wstrText) break;
	}
//----- 05.06.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiKiDfIiDgHjDhCjCiGiCmJjDkPiClGjFlGiOjKjHpBiCkKiCkAiCoJiPoKiNiHiCmNiNoNiPjMiBeC_xHqqkZx_
	if (iIndex != pBox->GetCount())
		pBox->DeleteString(iIndex);
	// _xZkqqHx_iDiKiDfIiDgHiDgHiDgCiDhGiCmJjFlGiOjKjHpBjBhNjDpMiBeC_xHqqkZx_
	pBox->InsertString(0, WStrToTStr(wstrText));
	pBox->SetCurSel(0);
} // FFUpdateTextComboList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetDlgItemText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoH_xHqqkZx_UNICODE_xZkqqHx_iCmFjFlGiOjKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pWnd	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCtrl	:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			str		:_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetDlgItemText (CWnd* pWnd, DWORD dwCtrl, WString& wstr)
{
	CString str;
	pWnd->GetDlgItemText(dwCtrl, str);
// 02.06.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)
//	wstr = TStrToWStr(str);
	wstr = (const wchar_t*)TStrToWStr(str);
} // FFGetDlgItemText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetDlgItemText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoH_xHqqkZx_UNICODE_xZkqqHx_iCmFjFlGiOjKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCtrl	:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			str		:_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetDlgItemText (HWND hwnd, DWORD dwCtrl, WString& wstr)
{
	FFGetWindowText(::GetDlgItem(hwnd, dwCtrl), wstr, CP_ACP);
} // FFGetDlgItemText.

//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSetDlgItemText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJ_xHqqkZx_UNICODE_xZkqqHx_iCmFjFlGiOjKjHpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pWnd	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCtrl	:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstr	:_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSetDlgItemText (CWnd* pWnd, DWORD dwCtrl, const wchar_t* wstr)
{
	pWnd->SetDlgItemText(dwCtrl, WStrToTStr(wstr));
} // FFSetDlgItemText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSetDlgItemText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJ_xHqqkZx_UNICODE_xZkqqHx_iCmFjFlGiOjKjHpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCtrl	:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstr	:_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSetDlgItemText (HWND hwnd, DWORD dwCtrl, const wchar_t* wstr)
{
	SetDlgItemText(hwnd, dwCtrl, WStrToTStr(wstr));
} // FFSetDlgItemText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPopupSubmenu
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	scpt		:_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiClHiCoJiImKjChFiBgJjCmKiPoNiCmNiDhNiDeFiDfIiImKjChFiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiPoDiCmMiNmAjFfHjCgMiCmFiOhHjCoIiBeC_xHqqkZx_
 *			dwMenuId	:_xZkqqHx_iDiBiDgKiDiFiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			iSubmenuIdx	:_xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_dwMenuId_xZkqqHx_iCmM_xHqqkZx_
 *						 _xZkqqHx_iJlNjEnEjGnKiCkJiBeI_xHqqkZx_
 *			pParent		:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiDfCiDhNiDjDiDgIiDiBiDgCiDfKiBfLiDfHjBjHjFhEjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwTopCommand:_xZkqqHx_jHeEjAoGiClHiCoJiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiDiBiDgKiDiFiBfLiCmMiDgHiDgCiDhGiCmJ_xHqqkZx_
 *						 _xZkqqHx_jFfMiOkGiClDiCoKiCoJiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ DWORD(-1)_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiDhEiDeIiDjDiDgHiCpAiMhGiOfKiClFiBeBiDhNiDeFiDfIiCkKiDiBiDgKiDiFiBfLiNmFiPiJiCmMiDeBiDeDiDgFiDiAiPoDiCmJ_xHqqkZx_
 *			_xZkqqHx_jHiIiCoJiCoGiCkEiCmJiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPopupSubmenu (CPoint scpt, DWORD dwMenuId, int iSubmenuIdx, CWnd* pParent, DWORD dwTopCommand)
{
	CMenu menu;
	if (menu.LoadMenu(dwMenuId))
	{
//----- 06.02.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDhEiDiMiBfLiDiAiImIiKePiCmMiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_OnCmdMsg_xZkqqHx_iCmMiOmAiNhDiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
		if (pParent != NULL && pParent != FFGetMainWnd()->GetWnd())
			FFGetMainWnd()->SetOnCmdMsgWnd(pParent->m_hWnd);
//----- 06.02.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

		CMenu* pPopup = menu.GetSubMenu(iSubmenuIdx);
		ASSERT(pPopup != NULL);
		if (dwTopCommand != DWORD(-1))
		{
			//----- _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBiCpAiOoGjDlO_xHqqkZx_ -----
			_TCHAR tsz[250] = { _T('\0') };
			MENUITEMINFO mii;
			mii.cbSize = sizeof(mii);
			mii.fMask = MIIM_TYPE;
			mii.dwTypeData = tsz;
			mii.cch = sizeof(tsz) / sizeof(tsz[0]);
			if (pPopup->GetMenuItemInfo(dwTopCommand, &mii) && tsz[0] != _T('\0'))
			{
#ifdef FD_TOP_ACCESSKEY		// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
				// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBjCiGiCmM_xHqqkZx_"&X."_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
				WString wstrText = TStrToWStr(tsz);
				if (wstrText.GetAt(0) == L'&')
				{
					// _xZkqqHx_jAoGjDkKiCmMiDeBiDeOiDfKiDfIiDeMiBfLiCpAiPjMiCkNiBeC_xHqqkZx_
					wstrText = wstrText.Mid(FD_TOP_ACCESSKEY_LEN);
					// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCmMiDgHiDgCiDhGiCmJ_xHqqkZx_ "(&X)"_xZkqqHx_iCpAiPjMiCkCiClNiDiBiDgKiDiFiBfLiCpAjBhNjDpMiBeC_xHqqkZx_
					pPopup->InsertMenu(0, MF_STRING | MF_BYPOSITION, dwTopCommand, WStrToTStr(wstrText));
				}
#else //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjCiGiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
				// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBjCiGiCmM_xHqqkZx_"(&"_xZkqqHx_jFlGiOjKjHpBiCmMiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
				_TCHAR* tcpFind = _tcsstr(tsz, _T("(&"));
				if (tcpFind != NULL)
				{
					// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCmMiDgHiDgCiDhGiCmJ_xHqqkZx_ "(&X)"_xZkqqHx_iCpAiPjMiCkCiClNiDiBiDgKiDiFiBfLiCpAjBhNjDpMiBeC_xHqqkZx_
					*tcpFind = _T('\0');
					pPopup->InsertMenu(0, MF_STRING | MF_BYPOSITION, dwTopCommand, tsz);
				}
#endif //FD_TOP_ACCESSKEY	// _xZkqqHx_jFlGjDkKiCmJiDeBiDeOiDfKiDfIiDeMiBfLiCkKjHeMiCoJiPoKiNiHiBeC_xHqqkZx_
			}
		}

//----------<NOT EXPORT TO VIEWER>-----------
		// _xZkqqHx_iNlGjHjIiCkLiCmJjAnNjCoIiCmIiCoHiCmOiBeBiDiBiDgKiDiFiBfLiCpAjFmPiNfIiBeC_xHqqkZx_
		if (g_pReg->GetIsLeftHand())
			::RightByLeftHand(pPopup->m_hMenu, TRUE);
		// _xZkqqHx_iDfGiDiHiBfLiDgHiDeKiDgCiDgHiDeMiBfLiPoOjFpBiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
		::FFAddShortcutText(pPopup->m_hMenu, g_pReg->GetIsLeftHand());
//----------</NOT EXPORT TO VIEWER>-----------

		//---- GUI_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDfEiDeDiDfJiCkJiCoHiDeJiDhEiDfKiDgCiDgHiCpAiMhGiOfK_xHqqkZx_ -----
		CFont font;
		font.CreateStockObject(DEFAULT_GUI_FONT);
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		LOGFONT lf = {0};
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// memset _xZkqqHx_iCmFiPiJiKpKiJlLiClHiCoJiClBiCmGiBeC_xHqqkZx_ = {0} _xZkqqHx_iCmFiCmNiCkEiCnMiCkNiPiJiKpKiJlLiCmFiCkLiCmIiCkCiPoKiNiHiCkKiCkAiCmBiClNiBeC_xHqqkZx_
		LOGFONT lf;
		memset(&lf, 0, sizeof(lf));
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

		font.GetLogFont(&lf);
		scpt.x -= 3 * labs(lf.lfHeight);
		scpt.y -= 2 + labs(lf.lfHeight) / 2;	// _xZkqqHx_iNmFiPiJiCmM_xHqqkZx_2_xZkqqHx_iCmNiBeBiDiBiDgKiDiFiBfLiCmMiDhEiDiMiBfLiDiAjFjNiBeC_xHqqkZx_
		//----- _xZkqqHx_iDiBiDgKiDiFiBfLiCkKiDhEiDiMiBfLiDiAiCpAiCmNiCnNiPgPiClDiCmIiCkCiCoGiCkEiCmJjClCjAkO_xHqqkZx_ -----

		// _xZkqqHx_iDeFiDeDiDjDiDgIiDeFiNmFjBoFiCmJiClFiCmEiDgAiDgCiDhGiDfIiDgHiDeBiNlGiCmNiClGiCmFiDhNiDeFiDfIiJeFiDeOiDiKiDgCiDeOiCmF_xHqqkZx_
		// _xZkqqHx_iDiBiDgKiDiFiBfLiCkKjFmPiCmIiImKjChFiCmJjFfMiOkGiClDiCoKiCoJiCmMiCpAiPeDjAlDiBeC_xHqqkZx_
		scpt += FFJustifyToMonitor(scpt);
// 06.02.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		pPopup->TrackPopupMenu(TPM_RIGHTBUTTON | TPM_LEFTALIGN, scpt.x, scpt.y, pParent);
		pPopup->TrackPopupMenu(TPM_RIGHTBUTTON | TPM_LEFTALIGN, scpt.x, scpt.y, FFGetMainWnd()->GetWnd());

//----- 06.03.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// OnCmdMsg_xZkqqHx_iCmMjDgPjIfOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
		// PostMessage_xZkqqHx_iCmFjBjHjFhEiClHiCoJiClBiCmGiCmFiBeBiDfCiDhNiDjDiDgIjBeJjBpAiMoDiCmJiDeMiDiDiDjDiDfKiDiLiClDiClJiCoJiClBiCmGiCkKiCmFiCkLiCoJiBeC_xHqqkZx_
		FFGetMainWnd()->PostMessage(WM_COMMAND, ID_RBTN_END_MARK, 0);
//----- 06.03.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.02.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 06.02.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//		// OnCmdMsg_xZkqqHx_iCmMjDgPjIfOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
//		if (pParent != NULL && pParent != FFGetMainWnd()->GetWnd())
//			FFGetMainWnd()->ResetOnCmdMsgWnd(pParent);
////----- 06.02.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.02.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	}


} // FFPopupSubmenu.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPopupSubmenu
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt		:_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiClHiCoJiImKjChFiBgJjCmKiPoNiCmNiDhNiDeFiDfIiImKjChFiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMenuId	:_xZkqqHx_iDiBiDgKiDiFiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			iSubmenuIdx	:_xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_dwMenuId_xZkqqHx_iCmM_xHqqkZx_
 *						 _xZkqqHx_iJlNjEnEjGnKiCkJiBeI_xHqqkZx_
 *			pParent		:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiDfCiDhNiDjDiDgIiDiBiDgCiDfKiBfLiDfHjBjHjFhEjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwTopCommand:_xZkqqHx_jHeEjAoGiClHiCoJiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiDiBiDgKiDiFiBfLiCmMiDgHiDgCiDhGiCmJ_xHqqkZx_
 *						 _xZkqqHx_jFfMiOkGiClDiCoKiCoJiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ DWORD(-1)_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiCmMiDhEiDeIiDjDiDgHiCpAiMhGiOfKiClFiBeBiDhNiDeFiDfIiCkKiDiBiDgKiDiFiBfLiNmFiPiJiCmMiDeBiDeDiDgFiDiAiPoDiCmJ_xHqqkZx_
 *			_xZkqqHx_jHiIiCoJiCoGiCkEiCmJiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPopupSubmenu (const DBLPoint& mmpt, DWORD dwMenuId, int iSubmenuIdx, CWnd* pParent, DWORD dwTopCommand)
{
	// _xZkqqHx_iDgGiDgPiDeDiDfIiNmAjFfHiBeC_xHqqkZx_
	CPoint scpt = mm2lg(mmpt);
	// _xZkqqHx_iDgGiDgPiDeDiDfIiNmAjFfHiCnGjFmPiKlHiBeC_xHqqkZx_
	g_pView->LPtoDP(scpt);
	// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiNmAjFfHiCnGjFmPiKlHiBeC_xHqqkZx_
	g_pView->ClientToScreen(&scpt);
	FFPopupSubmenu(scpt, dwMenuId, iSubmenuIdx, pParent, dwTopCommand);
} // FFPopupSubmenu.

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myExtractMenuCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiCkJiCoHiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCmMiIoKjHjHiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myExtractMenuCommand (DWORDSet& stCommandId, HMENU hMenu)
{
	MENUITEMINFO mii;
	// _xZkqqHx_iDiBiDgKiDiFiBfLjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
	const int iMenuCount = GetMenuItemCount(hMenu);
	for (int imi = 0; imi < iMenuCount; imi++)
	{
		//----- _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBiCmGiDfEiDhFiDiBiDgKiDiFiBfLiDgOiDjDiDgIiDiLiCpAiOoGjDlO_xHqqkZx_ -----
		mii.cbSize = sizeof(mii);
		mii.fMask = MIIM_ID | MIIM_SUBMENU;
		GetMenuItemInfo(hMenu, imi, MF_BYPOSITION, &mii);
		// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCkKiCkAiCoJiPoKiNiHiCmNiNmEiLeBiMmEiCnBiPgPiClFiBeC_xHqqkZx_
		if (mii.hSubMenu != NULL)
			myExtractMenuCommand(stCommandId, mii.hSubMenu);
		else
			stCommandId.insert(mii.wID);
	}
} // myExtractMenuCommand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFInitKeyboardTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeMiBfLiDgFiBfLiDhFiDiLiBgJiDfGiDiHiBfLiDgHiDeKiDgCiDgHiDeMiBfLiBeB_xHqqkZx_1_xZkqqHx_jFlGiOjKiDiBiDgKiDiFiBfLiBgKiCmMiPiJiKpKiJlLiCpA_xHqqkZx_
 *			_xZkqqHx_iNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFInitKeyboardTable (const wchar_t* tcpPath, HMENU hMenu)
{
	static const char* s_cpDefaultTable =
		"<handed exchange>\n"
		"Q->P\n"
		"W->O\n"
		"E->I\n"
		"R->U\n"
		"T->Y\n"
		"A->;\n"
		"S->L\n"
		"D->K\n"
		"F->J\n"
		"G->H\n"
		"Z->/\n"
		"X->.\n"
		"C->,\n"
		"V->M\n"
		"B->N\n"
		"1->=\n"
		"2->-\n"
		"3->0\n"
		"4->9\n"
		"5->8\n"
		"6->7\n"
		"</handed exchange>\n"
		"<right shortcut key>\n"
		"ESCAPE,		TLCMD_CANCEL\n"
		"ALT+LEFT,		OBJECT_MOVE_SNAP_LEFT\n"
		"ALT+UP,		OBJECT_MOVE_SNAP_UP\n"
		"ALT+RIGHT,		OBJECT_MOVE_SNAP_RIGHT\n"
		"ALT+DOWN,		OBJECT_MOVE_SNAP_DOWN\n"
		"CTRL+C,		EDIT_COPY\n"
		"CTRL+INSERT,	EDIT_COPY\n"
		"SHIFT+DELETE,	EDIT_CUT\n"
		"CTRL+X,		EDIT_CUT\n"
		"DELETE,		EDIT_DELETE\n"
		"CTRL+V,		EDIT_PASTE\n"
		"SHIFT+INSERT,	EDIT_PASTE\n"
		"CTRL+R,		EDIT_REDO\n"
		"CTRL+A,		EDIT_SELECT_ALL\n"
		"ALT+BACK,		EDIT_UNDO\n"
		"CTRL+Z,		EDIT_UNDO\n"
		"CTRL+Q,		EDIT_SELECT_NEXT\n"
		"CTRL+S,		FILE_COMEDT_SAVE_EXIT\n"
		"CTRL+S,		FILE_SAVE_HIDOCUMENT\n"
		"CTRL+S,		FILE_SAVE\n"
		"CTRL+S,		FILE_UPDATE\n"
		"CTRL+R,		HTREE_MOVE_AFTER\n"
		"ALT+BACK,		HTREE_MOVE_BEFORE\n"
		"CTRL+Z,		HTREE_MOVE_BEFORE\n"
		"CTRL+W,		HTREE_MOVE_OPERATION_BEFORE\n"
		"CTRL+E,		HTREE_MOVE_OPERATION_AFTER\n"
		"F2,			EDIT_FIND_TEXT\n"
		"F3,			EDIT_FIND_NEXT_TEXT\n"
		"F4,			EDIT_FIND_PREV_TEXT\n"
		"F5,			EDIT_REPLACE_TEXT\n"
		"F6,			EDIT_REPLACE_NEXT_TEXT\n"
		"F7,			EDIT_REPLACE_PREV_TEXT\n"
		"F8,			EDIT_COPY\n"
		"F9,			EDIT_PASTE\n"
		"F10,			EDIT_SELECT_NEXT\n"
		"F11,			OBJECT_CONNECT\n"
		"F12,			OBJECT_DISCONNECT\n"
		"SHIFT+F2,		FORMAT_FONT\n"
		"SHIFT+F3,		TEXT_ALIGN_TOP\n"
		"SHIFT+F4,		TEXT_ALIGN_V_CENTER\n"
		"SHIFT+F5,		TEXT_ALIGN_BOTTOM\n"
		"SHIFT+F6,		TEXT_ALIGN_LEFT\n"
		"SHIFT+F7,		TEXT_ALIGN_CENTER\n"
		"SHIFT+F8,		TEXT_ALIGN_RIGHT\n"
		"SHIFT+F9,		TEXT_ALIGN_LEFTRIGHT\n"
		"SHIFT+F10,		TEXT_MARGIN\n"
		"SHIFT+F11,		TEXT_LINE\n"
		"SHIFT+F12,		TEXT_ROTATE_BACKGROUND_COLOR\n"
		"CTRL+F1,		OBJECT_SAME_SIZE_X\n"
		"CTRL+F2,		OBJECT_SAME_SIZE_Y\n"
		"CTRL+F3,		OBJECT_ALIGN_H_TOP\n"
		"CTRL+F4,		OBJECT_ALIGN_H_CENTER\n"
		"CTRL+F5,		OBJECT_ALIGN_H_BOTTOM\n"
		"CTRL+F6,		OBJECT_ALIGN_V_LEFT\n"
		"CTRL+F7,		OBJECT_ALIGN_V_CENTER\n"
		"CTRL+F8,		OBJECT_ALIGN_V_RIGHT\n"
		"CTRL+F9,		OBJECT_SAME_GAP_V\n"
		"CTRL+F10,		OBJECT_SAME_GAP_H\n"
		"CTRL+F11,		OBJECT_SAME_DIST_V\n"
		"CTRL+F12,		OBJECT_SAME_DIST_H\n"
		"ALT+F1,		VIEW_TOOLBAR_FUNCTION_KEY\n"
		"ALT+F2,		VIEW_COPY_POSITION\n"
		"ALT+F3,		VIEW_PASTE_POSITION\n"
// 06.06.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		"ALT+F4,		OPTION_POP_HINT_ENABLE\n"
		// ALT+F4 _xZkqqHx_iCmNiDeBiDhGiDiKiPeJjHlJjHhAiCmIiCmMiCmFiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
		"ALT+F5,		OBJECT_SIZE_TO_TEXT\n"
		"ALT+F6,		EDIT_REPLACE_TEXT_ALL\n"
		"ALT+F7,		OBJECT_ROTATE_RIGHT\n"
		"ALT+F8,		OBJECT_ROTATE_LEFT\n"
		"ALT+F9,		OBJECT_MIRROR_VERT\n"
		"ALT+F10,		OBJECT_MIRROR_HORZ\n"
		"ALT+F11,		EDIT_UNDO\n"
		"ALT+F12,		EDIT_REDO\n"
		"SHIFT+CTRL+F1,	VIEW_CHIP_STORE_VISIBLE\n"
		"SHIFT+CTRL+F2,	OPTION_AUTO_ALTKEY\n"
		"SHIFT+CTRL+F3,	OBJECT_GROUP\n"
		"SHIFT+CTRL+F4,	OBJECT_UNGROUP\n"
		"SHIFT+CTRL+F5,	VIEW_REDRAW\n"
		"SHIFT+CTRL+F6,	VIEW_ZOOMIN\n"
		"SHIFT+CTRL+F7,	VIEW_ZOOMOUT\n"
		"SHIFT+CTRL+F8,	EDIT_SELECT_ALL\n"
		"SHIFT+CTRL+F9,	EDIT_CLEAR_SELECT\n"
		"SHIFT+CTRL+F10,FILE_SHEET_SETUP\n"
		"SHIFT+CTRL+F11,FILE_PAGE_SETUP\n"
		"SHIFT+CTRL+F12,FILE_PRINT_PREVIEW\n"
		"CTRL+ALT+F6,	GRAPHICS_EDIT_COLOR_TABLE\n"
		"CTRL+ALT+F7,	GRAPHICS_EDIT_REGPEN_TABLE\n"
		"CTRL+ALT+F8,	GRAPHICS_EDIT_REGBRUSH_TABLE\n"
		"CTRL+ALT+F9,	GRAPHICS_EDIT_PICTURE_TABLE\n"
		"CTRL+ALT+F10,	GRAPHICS_EDIT_PICT_ARROW\n"
		"CTRL+ALT+F11,	GRAPHICS_EDIT_CHIP_GROUP\n"
		"CTRL+ALT+F12,	GRAPHICS_EDIT_CHIP\n"
		"SHIFT+ALT+F9,	OPTION_IS_GRID_VISIBLE\n"
		"SHIFT+ALT+F10,	OPTION_IS_PAGE_VISIBLE\n"
		"</right shortcut key>\n"
		"<left shortcut key>\n"
		"ESCAPE,		TLCMD_CANCEL\n"
		"ALT+LEFT,		OBJECT_MOVE_SNAP_LEFT\n"
		"ALT+UP,		OBJECT_MOVE_SNAP_UP\n"
		"ALT+RIGHT,		OBJECT_MOVE_SNAP_RIGHT\n"
		"ALT+DOWN,		OBJECT_MOVE_SNAP_DOWN\n"
		"CTRL+J,		EDIT_COPY\n"
		"CTRL+INSERT,	EDIT_COPY\n"
		"SHIFT+DELETE,	EDIT_CUT\n"
		"CTRL+K,		EDIT_CUT\n"
		"DELETE,		EDIT_DELETE\n"
		"CTRL+L,		EDIT_PASTE\n"
		"SHIFT+INSERT,	EDIT_PASTE\n"
		"CTRL+P,		EDIT_REDO\n"
		"CTRL+Y,		EDIT_REDO\n"
		"CTRL+M,		EDIT_SELECT_ALL\n"
		"ALT+BACK,		EDIT_UNDO\n"
		"CTRL+O,		EDIT_UNDO\n"
		"CTRL+/,		EDIT_SELECT_NEXT\n"
		"CTRL+I,		FILE_COMEDT_SAVE_EXIT\n"
		"CTRL+I,		FILE_SAVE_HIDOCUMENT\n"
		"CTRL+I,		FILE_SAVE\n"
		"CTRL+I,		FILE_UPDATE\n"
		"CTRL+P,		HTREE_MOVE_AFTER\n"
		"CTRL+Y,		HTREE_MOVE_AFTER\n"
		"ALT+BACK,		HTREE_MOVE_BEFORE\n"
		"CTRL+O,		HTREE_MOVE_BEFORE\n"
		"CTRL+U,		HTREE_MOVE_OPERATION_BEFORE\n"
		"CTRL+N,		HTREE_MOVE_OPERATION_AFTER\n"
		"F2,			EDIT_FIND_TEXT\n"
		"F3,			EDIT_FIND_NEXT_TEXT\n"
		"F4,			EDIT_FIND_PREV_TEXT\n"
		"F5,			EDIT_REPLACE_TEXT\n"
		"F6,			EDIT_REPLACE_NEXT_TEXT\n"
		"F7,			EDIT_REPLACE_PREV_TEXT\n"
		"F8,			EDIT_COPY\n"
		"F9,			EDIT_PASTE\n"
		"F10,			EDIT_SELECT_NEXT\n"
		"F11,			OBJECT_CONNECT\n"
		"F12,			OBJECT_DISCONNECT\n"
		"SHIFT+F2,		FORMAT_FONT\n"
		"SHIFT+F3,		TEXT_ALIGN_TOP\n"
		"SHIFT+F4,		TEXT_ALIGN_V_CENTER\n"
		"SHIFT+F5,		TEXT_ALIGN_BOTTOM\n"
		"SHIFT+F6,		TEXT_ALIGN_LEFT\n"
		"SHIFT+F7,		TEXT_ALIGN_CENTER\n"
		"SHIFT+F8,		TEXT_ALIGN_RIGHT\n"
		"SHIFT+F9,		TEXT_ALIGN_LEFTRIGHT\n"
		"SHIFT+F10,		TEXT_MARGIN\n"
		"SHIFT+F11,		TEXT_LINE\n"
		"SHIFT+F12,		TEXT_ROTATE_BACKGROUND_COLOR\n"
		"CTRL+F1,		OBJECT_SAME_SIZE_X\n"
		"CTRL+F2,		OBJECT_SAME_SIZE_Y\n"
		"CTRL+F3,		OBJECT_ALIGN_H_TOP\n"
		"CTRL+F4,		OBJECT_ALIGN_H_CENTER\n"
		"CTRL+F5,		OBJECT_ALIGN_H_BOTTOM\n"
		"CTRL+F6,		OBJECT_ALIGN_V_LEFT\n"
		"CTRL+F7,		OBJECT_ALIGN_V_CENTER\n"
		"CTRL+F8,		OBJECT_ALIGN_V_RIGHT\n"
		"CTRL+F9,		OBJECT_SAME_GAP_V\n"
		"CTRL+F10,		OBJECT_SAME_GAP_H\n"
		"CTRL+F11,		OBJECT_SAME_DIST_V\n"
		"CTRL+F12,		OBJECT_SAME_DIST_H\n"
		"ALT+F1,		VIEW_TOOLBAR_FUNCTION_KEY\n"
		"ALT+F2,		VIEW_COPY_POSITION\n"
		"ALT+F3,		VIEW_PASTE_POSITION\n"
// 06.06.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		"ALT+F4,		OPTION_POP_HINT_ENABLE\n"
		// ALT+F4 _xZkqqHx_iCmNiDeBiDhGiDiKiPeJjHlJjHhAiCmIiCmMiCmFiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
		"ALT+F5,		OBJECT_SIZE_TO_TEXT\n"
		"ALT+F6,		EDIT_REPLACE_TEXT_ALL\n"
		"ALT+F7,		OBJECT_ROTATE_RIGHT\n"
		"ALT+F8,		OBJECT_ROTATE_LEFT\n"
		"ALT+F9,		OBJECT_MIRROR_VERT\n"
		"ALT+F10,		OBJECT_MIRROR_HORZ\n"
		"ALT+F11,		EDIT_UNDO\n"
		"ALT+F12,		EDIT_REDO\n"
		"SHIFT+CTRL+F1,	VIEW_CHIP_STORE_VISIBLE\n"
		"SHIFT+CTRL+F2,	OPTION_AUTO_ALTKEY\n"
		"SHIFT+CTRL+F3,	OBJECT_GROUP\n"
		"SHIFT+CTRL+F4,	OBJECT_UNGROUP\n"
		"SHIFT+CTRL+F5,	VIEW_REDRAW\n"
		"SHIFT+CTRL+F6,	VIEW_ZOOMIN\n"
		"SHIFT+CTRL+F7,	VIEW_ZOOMOUT\n"
		"SHIFT+CTRL+F8,	EDIT_SELECT_ALL\n"
		"SHIFT+CTRL+F9,	EDIT_CLEAR_SELECT\n"
		"SHIFT+CTRL+F10,FILE_SHEET_SETUP\n"
		"SHIFT+CTRL+F11,FILE_PAGE_SETUP\n"
		"SHIFT+CTRL+F12,FILE_PRINT_PREVIEW\n"
		"CTRL+ALT+F6,	GRAPHICS_EDIT_COLOR_TABLE\n"
		"CTRL+ALT+F7,	GRAPHICS_EDIT_REGPEN_TABLE\n"
		"CTRL+ALT+F8,	GRAPHICS_EDIT_REGBRUSH_TABLE\n"
		"CTRL+ALT+F9,	GRAPHICS_EDIT_PICTURE_TABLE\n"
		"CTRL+ALT+F10,	GRAPHICS_EDIT_PICT_ARROW\n"
		"CTRL+ALT+F11,	GRAPHICS_EDIT_CHIP_GROUP\n"
		"CTRL+ALT+F12,	GRAPHICS_EDIT_CHIP\n"
		"SHIFT+ALT+F9,	OPTION_IS_GRID_VISIBLE\n"
		"SHIFT+ALT+F10,	OPTION_IS_PAGE_VISIBLE\n"
		"</left shortcut key>\n";

//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	static const char* s_cpDefaultHistViewTable =
		"<handed exchange>\n"
		"Q->P\n"
		"W->O\n"
		"E->I\n"
		"R->U\n"
		"T->Y\n"
		"A->;\n"
		"S->L\n"
		"D->K\n"
		"F->J\n"
		"G->H\n"
		"Z->/\n"
		"X->.\n"
		"C->,\n"
		"V->M\n"
		"B->N\n"
		"1->=\n"
		"2->-\n"
		"3->0\n"
		"4->9\n"
		"5->8\n"
		"6->7\n"
		"</handed exchange>\n"
		"<right shortcut key>\n"
		"ESCAPE,		TLCMD_CANCEL\n"
		"ALT+LEFT,		OBJECT_MOVE_SNAP_LEFT\n"
		"ALT+UP,		OBJECT_MOVE_SNAP_UP\n"
		"ALT+RIGHT,		OBJECT_MOVE_SNAP_RIGHT\n"
		"ALT+DOWN,		OBJECT_MOVE_SNAP_DOWN\n"
		"CTRL+C,		EDIT_COPY\n"
		"CTRL+INSERT,	EDIT_COPY\n"
		"DELETE,		EDIT_DELETE\n"
		"CTRL+A,		EDIT_SELECT_ALL\n"
		"CTRL+Q,		EDIT_SELECT_NEXT\n"
		"CTRL+R,		HTREE_MOVE_AFTER\n"
		"ALT+BACK,		HTREE_MOVE_BEFORE\n"
		"CTRL+Z,		HTREE_MOVE_BEFORE\n"
		"CTRL+W,		HTREE_MOVE_OPERATION_BEFORE\n"
		"CTRL+E,		HTREE_MOVE_OPERATION_AFTER\n"
		"F2,			HTREE_MOVE_BEFORE\n"
		"F3,			HTREE_MOVE_AFTER\n"
		"F4,			HTREE_MOVE_OPERATION_BEFORE\n"
		"F5,			HTREE_MOVE_OPERATION_AFTER\n"
		"F6,			HTREE_MOVE_HIGHER\n"
		"F7,			HTREE_MOVE_LOWER\n"
		"F8,			HTREE_MOVE_SELECTION_BEFORE\n"
		"F9,			HTREE_MOVE_SELECTION_AFTER\n"
		"F10,			HTREE_FIND_PANEL\n"
		"F11,			HTREE_FIND_RESULTS\n"
		"F12,			HTREE_JUMP_NEXT_FIND_RESULT\n"
		"SHIFT+F2,		EDIT_FIND_TEXT\n"
		"SHIFT+F3,		EDIT_FIND_NEXT_TEXT\n"
		"SHIFT+F4,		EDIT_FIND_PREV_TEXT\n"
		"SHIFT+F5,		EDIT_FIND_TEXT_ALL\n"
		"SHIFT+F6,		EDIT_FIND_TEXT_ALL_IN_SELECT\n"
		"SHIFT+F7,		EDIT_COPY_TEXT\n"
		"SHIFT+F8,		EDIT_COPY\n"
		"SHIFT+F9,		EDIT_SELECT_ALL\n"
		"SHIFT+F10,		EDIT_SELECT_NEXT\n"
		"SHIFT+F11,		EDIT_SELECT_SAME_KIND_OF_OBJECT\n"
		"SHIFT+F12,		EDIT_CLEAR_SELECT\n"
		"CTRL+F1,		VIEW_HTREE_VISIBLE\n"
		"CTRL+F2,		HTREE_PROJECT_VIEW\n"
		"CTRL+F3,		HTREE_TREE_VIEW\n"
		"CTRL+F4,		HTREE_BRANCH_VIEW\n"
		"CTRL+F5,		OPTION_AUTO_ALTKEY\n"
		"ALT+F1,		VIEW_TOOLBAR_FUNCTION_KEY\n"
		"ALT+F2,		VIEW_COPY_POSITION\n"
		"ALT+F3,		VIEW_PASTE_POSITION\n"
// 06.06.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		"ALT+F4,		OPTION_POP_HINT_ENABLE\n"
		// ALT+F4 _xZkqqHx_iCmNiDeBiDhGiDiKiPeJjHlJjHhAiCmIiCmMiCmFiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
		"ALT+F5,		VIEW_REDRAW\n"
		"ALT+F6,		VIEW_ZOOMIN\n"
		"ALT+F7,		VIEW_ZOOMOUT\n"
		"ALT+F8,		EDIT_SELECT_ALL\n"
		"ALT+F9,		EDIT_CLEAR_SELECT\n"
		"ALT+F10,		OPTION_IS_GRID_VISIBLE\n"
		"ALT+F11,		OPTION_IS_PAGE_VISIBLE\n"
		"ALT+F12,		FILE_PRINT_PREVIEW\n"
		"SHIFT+CTRL+F2,	OPTION_AUTO_ALTKEY\n"
		"SHIFT+CTRL+F5,	VIEW_REDRAW\n"
		"SHIFT+CTRL+F6,	VIEW_ZOOMIN\n"
		"SHIFT+CTRL+F7,	VIEW_ZOOMOUT\n"
		"SHIFT+CTRL+F8,	EDIT_SELECT_ALL\n"
		"SHIFT+CTRL+F9,	EDIT_CLEAR_SELECT\n"
		"SHIFT+CTRL+F12,FILE_PRINT_PREVIEW\n"
		"SHIFT+ALT+F9,	OPTION_IS_GRID_VISIBLE\n"
		"SHIFT+ALT+F10,	OPTION_IS_PAGE_VISIBLE\n"
		"</right shortcut key>\n"
		"<left shortcut key>\n"
		"ESCAPE,		TLCMD_CANCEL\n"
		"ALT+LEFT,		OBJECT_MOVE_SNAP_LEFT\n"
		"ALT+UP,		OBJECT_MOVE_SNAP_UP\n"
		"ALT+RIGHT,		OBJECT_MOVE_SNAP_RIGHT\n"
		"ALT+DOWN,		OBJECT_MOVE_SNAP_DOWN\n"
		"CTRL+J,		EDIT_COPY\n"
		"CTRL+INSERT,	EDIT_COPY\n"
		"DELETE,		EDIT_DELETE\n"
		"CTRL+M,		EDIT_SELECT_ALL\n"
		"CTRL+/,		EDIT_SELECT_NEXT\n"
		"CTRL+P,		HTREE_MOVE_AFTER\n"
		"CTRL+Y,		HTREE_MOVE_AFTER\n"
		"ALT+BACK,		HTREE_MOVE_BEFORE\n"
		"CTRL+O,		HTREE_MOVE_BEFORE\n"
		"CTRL+U,		HTREE_MOVE_OPERATION_BEFORE\n"
		"CTRL+N,		HTREE_MOVE_OPERATION_AFTER\n"
		"F2,			HTREE_MOVE_BEFORE\n"
		"F3,			HTREE_MOVE_AFTER\n"
		"F4,			HTREE_MOVE_OPERATION_BEFORE\n"
		"F5,			HTREE_MOVE_OPERATION_AFTER\n"
		"F6,			HTREE_MOVE_HIGHER\n"
		"F7,			HTREE_MOVE_LOWER\n"
		"F8,			HTREE_MOVE_SELECTION_BEFORE\n"
		"F9,			HTREE_MOVE_SELECTION_AFTER\n"
		"F10,			HTREE_FIND_PANEL\n"
		"F11,			HTREE_FIND_RESULTS\n"
		"F12,			HTREE_JUMP_NEXT_FIND_RESULT\n"
		"SHIFT+F2,		EDIT_FIND_TEXT\n"
		"SHIFT+F3,		EDIT_FIND_NEXT_TEXT\n"
		"SHIFT+F4,		EDIT_FIND_PREV_TEXT\n"
		"SHIFT+F5,		EDIT_FIND_TEXT_ALL\n"
		"SHIFT+F6,		EDIT_FIND_TEXT_ALL_IN_SELECT\n"
		"SHIFT+F7,		EDIT_COPY_TEXT\n"
		"SHIFT+F8,		EDIT_COPY\n"
		"SHIFT+F9,		EDIT_SELECT_ALL\n"
		"SHIFT+F10,		EDIT_SELECT_NEXT\n"
		"SHIFT+F11,		EDIT_SELECT_SAME_KIND_OF_OBJECT\n"
		"SHIFT+F12,		EDIT_CLEAR_SELECT\n"
		"CTRL+F1,		VIEW_HTREE_VISIBLE\n"
		"CTRL+F2,		HTREE_PROJECT_VIEW\n"
		"CTRL+F3,		HTREE_TREE_VIEW\n"
		"CTRL+F4,		HTREE_BRANCH_VIEW\n"
		"CTRL+F5,		OPTION_AUTO_ALTKEY\n"
		"ALT+F1,		VIEW_TOOLBAR_FUNCTION_KEY\n"
		"ALT+F2,		VIEW_COPY_POSITION\n"
		"ALT+F3,		VIEW_PASTE_POSITION\n"
// 06.06.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		"ALT+F4,		OPTION_POP_HINT_ENABLE\n"
		// ALT+F4 _xZkqqHx_iCmNiDeBiDhGiDiKiPeJjHlJjHhAiCmIiCmMiCmFiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
		"ALT+F5,		VIEW_REDRAW\n"
		"ALT+F6,		VIEW_ZOOMIN\n"
		"ALT+F7,		VIEW_ZOOMOUT\n"
		"ALT+F8,		EDIT_SELECT_ALL\n"
		"ALT+F9,		EDIT_CLEAR_SELECT\n"
		"ALT+F10,		OPTION_IS_GRID_VISIBLE\n"
		"ALT+F11,		OPTION_IS_PAGE_VISIBLE\n"
		"ALT+F12,		FILE_PRINT_PREVIEW\n"
		"SHIFT+CTRL+F2,	OPTION_AUTO_ALTKEY\n"
		"SHIFT+CTRL+F5,	VIEW_REDRAW\n"
		"SHIFT+CTRL+F6,	VIEW_ZOOMIN\n"
		"SHIFT+CTRL+F7,	VIEW_ZOOMOUT\n"
		"SHIFT+CTRL+F8,	EDIT_SELECT_ALL\n"
		"SHIFT+CTRL+F9,	EDIT_CLEAR_SELECT\n"
		"SHIFT+CTRL+F12,FILE_PRINT_PREVIEW\n"
		"SHIFT+ALT+F9,	OPTION_IS_GRID_VISIBLE\n"
		"SHIFT+ALT+F10,	OPTION_IS_PAGE_VISIBLE\n"
		"</left shortcut key>\n";
//----- 06.05.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	try
	{
		astring strBuff;
		long lCurLine = 1;
		long lNewLine = lCurLine;

		//----- strBuff _xZkqqHx_iCmJiBeBiDeMiBfLiKiEiCoIjDjGiCmEiDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----

		if (tcpPath != NULL && *tcpPath != L'\0')
		//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
//----- 06.01.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			CFCHIFSFile file(	tcpPath,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////								GENERIC_READ,
////								FILE_SHARE_READ,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//								OPEN_EXISTING, NULL, NULL);
//----- 06.01.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			CFile file(WStrToTStr(tcpPath), CFile::modeRead | CFile::shareDenyNone);
//----- 06.01.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			DWORD dwLen = file.GetLength();
			strBuff.assign(dwLen + 10, '\0');
			dwLen = file.Read(strBuff.begin(), strBuff.size());
			strBuff.resize(dwLen);
			file.Close();
		} else
		//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			tcpPath = L"";
			// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiCmNjDmBjFmKiBeC_xHqqkZx_
			if ((g_->appMode & FD_APPMODE_MASK) == FD_APPMODE_HISTORYVIEWER)
				strBuff = s_cpDefaultHistViewTable;
			else
				strBuff = s_cpDefaultTable;
		}
		astring strLine;
		// _xZkqqHx_iDiBiDgKiDiFiBfLiCmJiKnMiCnMiCoKiCoJiDfCiDhNiDjDiDgIiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
		DWORDSet stCommandId;
		myExtractMenuCommand(stCommandId, hMenu);

		while (!strBuff.empty())
		{
			// _xZkqqHx_jAfGiClFiCkCiNhDiCpAjAnNjCoIiBeC_xHqqkZx_
			lCurLine = lNewLine;
			// 1_xZkqqHx_iNhDjDmHiCnNiNjOiCnNiBeCiJpMiNhDiCmNiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
			long lLineCount;
			strLine = ::GetLine(strBuff, lLineCount);
			// _xZkqqHx_jAfGiClFiCkCiNhDiCpAiMhGiOfKiBeC_xHqqkZx_
			lNewLine = lCurLine + lLineCount;
//----- 03.03.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iNmFiPiJiCmMiLpDjEjCiBeFiJpMiNhDiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
//			TrimLeft(strBuff);
//----- 03.03.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_jHlMjBkEiCmMiLpDjEjCiBeFiJpMiNhDiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
			TrimLeft(strLine);
			TrimRight(strLine);
			// _xZkqqHx_iNhDiCmJiJlNiCoAjGlDiCkCiPoKiNiHiCmNiNhDiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (strLine.empty()) continue;
			// #_xZkqqHx_iCmFiOgOiCnMiCoJiPoKiNiHiCmNiNhDiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (strLine[0] == '#') continue;
			// _xZkqqHx_jBfDiCmEiPkMjFlGiOjKiCmJiBeC_xHqqkZx_
			_strlwr(strLine.begin());
			if (strLine[0] == '<')
			{
				if (strLine == "<handed exchange>")
					FFInitHandsTable(strBuff, tcpPath, lNewLine);
				else
				if (strLine == "<left shortcut key>")
					FFInitUserAccelerator(strBuff, TRUE, tcpPath, lNewLine, stCommandId);
				else
				if (strLine == "<right shortcut key>")
					FFInitUserAccelerator(strBuff, FALSE, tcpPath, lNewLine, stCommandId);
				else
				{
					FFThrowMiscException(IDS_ERR_SYNTAX_ERROR,
												tcpPath, lCurLine,
										(const wchar_t*)AStrToWStr(strLine.c_str()));
				}
			}
		}
		// _xZkqqHx_jAfGiClFiCkCiNhDiCpAjAnNjCoIiBeC_xHqqkZx_
		lCurLine = lNewLine;
	} catch (CException* e)
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiOoGjDlOiBeC_xHqqkZx_
		e->ReportError();
		e->Delete();
	}
} // FFInitKeyboardTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFInitHandsTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	1_xZkqqHx_jFlGiOjKiDiBiDgKiDiFiBfLiCmMjFlGiOjKiMpAiKlHiDgFiBfLiDhFiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strBuff	:_xZkqqHx_iDgFiBfLiDhFiDiLiPiJiKpKiJlLjHhAiCmMiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpPath	:_xZkqqHx_jCoIiLgAiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lCurLine:_xZkqqHx_iMlLiNnNiCmMiNhDjEnEiNiGiCpAiOhHjCoIiBeCiNfIjAfGiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFInitHandsTable (astring& astrBuff, const wchar_t* tcpPath, long& lCurLine)
{
	// _xZkqqHx_iKpJiCmJiDgGiBfLiDfOiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	ASSERT(s_mpLeft2Right.empty());

	static struct
	{
//----- 06.02.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		_TCHAR tcRight;		// _xZkqqHx_iJeFjHjIiCkLiDgGiBfLiDfOiBeC_xHqqkZx_
//		_TCHAR tcLeft;		// _xZkqqHx_iNlGjHjIiCkLiDgGiBfLiDfOiBeC_xHqqkZx_
//----- 06.02.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		wchar_t tcRight;		// _xZkqqHx_iJeFjHjIiCkLiDgGiBfLiDfOiBeC_xHqqkZx_
		wchar_t tcLeft;		// _xZkqqHx_iNlGjHjIiCkLiDgGiBfLiDfOiBeC_xHqqkZx_
//----- 06.02.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	} DEFAULT_HANDS_TBL[] =
	{
//----- 06.02.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		{ _T('Q'), _T('P') },
//		{ _T('W'), _T('O') },
//		{ _T('E'), _T('I') },
//		{ _T('R'), _T('U') },
//		{ _T('T'), _T('Y') },
//		{ _T('A'), _T(';') },
//		{ _T('S'), _T('L') },
//		{ _T('D'), _T('K') },
//		{ _T('F'), _T('J') },
//		{ _T('G'), _T('H') },
//		{ _T('Z'), _T('/') },
//		{ _T('X'), _T('.') },
//		{ _T('C'), _T(',') },
//		{ _T('V'), _T('M') },
//		{ _T('B'), _T('N') },
//		{ _T('1'), _T('=') },
//		{ _T('2'), _T('-') },
//		{ _T('3'), _T('0') },
//		{ _T('4'), _T('9') },
//		{ _T('5'), _T('8') },
//		{ _T('6'), _T('7') },
//----- 06.02.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
#ifdef FD_ACCESSKEY_UC	// _xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLiCkKjBoFjFlGiOjKiCmMiPoKiNiHiBeC_xHqqkZx_
		{ L'Q', L'P' },
		{ L'W', L'O' },
		{ L'E', L'I' },
		{ L'R', L'U' },
		{ L'T', L'Y' },
		{ L'A', L';' },
		{ L'S', L'L' },
		{ L'D', L'K' },
		{ L'F', L'J' },
		{ L'G', L'H' },
		{ L'Z', L'/' },
		{ L'X', L'.' },
		{ L'C', L',' },
		{ L'V', L'M' },
		{ L'B', L'N' },
		{ L'1', L'=' },
		{ L'2', L'-' },
		{ L'3', L'0' },
		{ L'4', L'9' },
		{ L'5', L'8' },
		{ L'6', L'7' },
#else //FD_ACCESSKEY_UC	// _xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLiCkKiPkMjFlGiOjKiCmMiPoKiNiHiBeC_xHqqkZx_
		{ L'q', L'p' },
		{ L'w', L'o' },
		{ L'e', L'i' },
		{ L'r', L'u' },
		{ L't', L'y' },
		{ L'a', L';' },
		{ L's', L'l' },
		{ L'd', L'k' },
		{ L'f', L'j' },
		{ L'g', L'h' },
		{ L'z', L'/' },
		{ L'x', L'.' },
		{ L'c', L',' },
		{ L'v', L'm' },
		{ L'b', L'n' },
		{ L'1', L'=' },
		{ L'2', L'-' },
		{ L'3', L'0' },
		{ L'4', L'9' },
		{ L'5', L'8' },
		{ L'6', L'7' },
#endif //FD_ACCESSKEY_UC	// _xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLiCkKiPkMjFlGiOjKiCmMiPoKiNiHiBeC_xHqqkZx_
//----- 06.02.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	};
	//----- _xZkqqHx_iJeFjHjIiCkL_xHqqkZx_->_xZkqqHx_iNlGjHjIiCkLiDgFiBfLiDhFiDiLiCmJiDgGiDhEiDeIiDiLiDgHiDgGiBfLiDfOiCpAjDgPjIfO_xHqqkZx_ -----
	const int iTblSize = sizeof(DEFAULT_HANDS_TBL) / sizeof(DEFAULT_HANDS_TBL[0]);
	int iC;
	for (iC = 0; iC < iTblSize; iC++)
	{
		// s_mpRight2Left[_xZkqqHx_iJeFjHjIiCkLjFlGiOjK_xHqqkZx_] = _xZkqqHx_iNlGjHjIiCkLjFlGiOjKiBeC_xHqqkZx_
		s_mpRight2Left[DEFAULT_HANDS_TBL[iC].tcRight] = DEFAULT_HANDS_TBL[iC].tcLeft;
	}
	astring astrLine;
	long lNewLine = lCurLine;
	// 1_xZkqqHx_iNhDjDmHiCnNiNjOiCnNiBeCiJpMiNhDiCmNiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
	while (!astrBuff.empty())
	{
		// _xZkqqHx_jAfGiClFiCkCiNhDiCpAjAnNjCoIiBeC_xHqqkZx_
		lCurLine = lNewLine;
		// 1_xZkqqHx_iNhDjDmHiCnNiNjOiCnNiBeCiJpMiNhDiCmNiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
		long lLineCount;
		astrLine = ::GetLine(astrBuff, lLineCount);
		// _xZkqqHx_jAfGiClFiCkCiNhDiCpAiMhGiOfKiBeC_xHqqkZx_
		lNewLine = lCurLine + lLineCount;
		// _xZkqqHx_jHlMjBkEiCmMiLpDjEjCiBeFiJpMiNhDiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
		TrimLeft(astrLine);
		TrimRight(astrLine);
		// _xZkqqHx_iNhDiCmJiJlNiCoAjGlDiCkCiPoKiNiHiCmNiNhDiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		if (astrLine.empty()) continue;
		// #_xZkqqHx_iCmFiOgOiCnMiCoJiPoKiNiHiCmNiDfCiDiBiDjDiDgHiNhDiCmIiCmMiCmFiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		if (astrLine[0] == '#') continue;
#ifdef FD_ACCESSKEY_UC	// _xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLiCkKjBoFjFlGiOjKiCmMiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_jBfDiCmEjBoFjFlGiOjKiCmJiBeC_xHqqkZx_
		_strupr(astrLine.begin());
#else //FD_ACCESSKEY_UC	// _xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLiCkKiPkMjFlGiOjKiCmMiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_jBfDiCmEiPkMjFlGiOjKiCmJiBeC_xHqqkZx_
		_strlwr(astrLine.begin());
#endif //FD_ACCESSKEY_UC	// _xZkqqHx_iDeBiDeOiDfKiDfIiDeMiBfLiCkKiPkMjFlGiOjKiCmMiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_ </handed exchange> _xZkqqHx_iCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (stricmp(astrLine.c_str(), "</handed exchange>") == 0) break;
		// _xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_ </end> _xZkqqHx_iCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (stricmp(astrLine.c_str(), "</end>") == 0) break;
		// _xZkqqHx_iNhDiCmMjFlGiOjKjAjEiCkKiCfDiImIiKePiCmMiPoKiNiHiCmNiNhDiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		if (astrLine.length() != 4)
		{
			// %s(%d):"%s" _xZkqqHx_iNlGiLeMiCmMiLeMiPhBiMgAiOkOiCmJiMoLiCoIiCkKiCkAiCoIiCnMiClHiBeC_xHqqkZx_
			FFThrowMiscException(	IDS_ERR_SYNTAX_ERROR,
									tcpPath, lCurLine,
									(const wchar_t*)AStrToWStr(astrLine.c_str()));
		}
		if (astrLine[0] == '<')
		{
			FFThrowMiscException(	IDS_ERR_SYNTAX_ERROR,
									tcpPath, lCurLine,
									(const wchar_t*)AStrToWStr(astrLine.c_str()));
		}
		AStrToWStr wstr(astrLine.c_str());
		// s_mpRight2Left[_xZkqqHx_iJeFjHjIiCkLjFlGiOjK_xHqqkZx_] = _xZkqqHx_iNlGjHjIiCkLjFlGiOjKiBeC_xHqqkZx_
		s_mpRight2Left[((const wchar_t*)wstr)[0]] = ((const wchar_t*)wstr)[3];
	}
	// _xZkqqHx_jAfGiClFiCkCiNhDiCpAjAnNjCoIiBeC_xHqqkZx_
	lCurLine = lNewLine;

	//----- _xZkqqHx_iNlGjHjIiCkL_xHqqkZx_->_xZkqqHx_iJeFjHjIiCkLiDgFiBfLiDhFiDiLiCpAiNoMjAkM_xHqqkZx_ -----
//----- 06.02.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	for (iC = 0; iC < iTblSize; iC++)
//	{
//		// s_mpLeft2Right[_xZkqqHx_iNlGjHjIiCkLjFlGiOjK_xHqqkZx_] = _xZkqqHx_iJeFjHjIiCkLjFlGiOjKiBeC_xHqqkZx_
//		s_mpLeft2Right[s_mpRight2Left[DEFAULT_HANDS_TBL[iC].tcRight]] =
//			DEFAULT_HANDS_TBL[iC].tcRight;
//	}
//----- 06.02.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FTTcTcMap::const_iterator iCc;
	for (iCc = s_mpRight2Left.begin(); iCc != s_mpRight2Left.end(); iCc++)
	{
		// s_mpLeft2Right[_xZkqqHx_iNlGjHjIiCkLjFlGiOjK_xHqqkZx_] = _xZkqqHx_iJeFjHjIiCkLjFlGiOjKiBeC_xHqqkZx_
		s_mpLeft2Right[iCc->second] = iCc->first;
	}
//----- 06.02.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFInitHandsTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCommandStringToId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfCiDhNiDjDiDgIjGlMiCmMjFlGiOjKjHpBiCpAiDfCiDhNiDjDiDgIiCgIiCgDiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cpCommandString	:_xZkqqHx_iDfCiDhNiDjDiDgIjGlMjFlGiOjKjHpBiCpAiOhHjCoIiBeCjBoFjFlGiOjKiBeBiPkMjFlGiOjKiCmM_xHqqkZx_
 *							 _xZkqqHx_iCmHiClPiCoHiCmFiCoAiCoGiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiCgIiCgDiBeCjBmOiJjOiClHiCoJiDfCiDhNiDjDiDgIiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DWORD(-1)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIjGlMiCmNiBeB_xHqqkZx_"ID_XXXXXX" _xZkqqHx_iCmM_xHqqkZx_ "ID_" _xZkqqHx_iCpAiOoGiCoIiPjMiCkCiClNjFjEjFkKiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiBeGiDfCiDhNiDjDiDgIjGlM_xHqqkZx_ "EDIT_COPY" -> _xZkqqHx_iDfCiDhNiDjDiDgIiCgIiCgD_xHqqkZx_ ID_EDIT_COPY
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FFCommandStringToId (const char* cpCommandString)
{
	struct myFCNameCmd
	{
		const char* cpName;
		DWORD dwCmdId;
	}; // struct myFCNameCmd.
	static const myFCNameCmd s_aNameCmd[] =
	{
		{ "APP_ABOUT",                               ID_APP_ABOUT },
		{ "APP_EXIT",                                ID_APP_EXIT },
		{ "APP_WIN_EXIT",                            ID_APP_WIN_EXIT },
		{ "ARROWEDIT_PROPERTY",                      ID_ARROWEDIT_PROPERTY },
		{ "ARROWEDIT_SET_DUTY",                      ID_ARROWEDIT_SET_DUTY },
		{ "ARROWEDIT_SET_FRAME",                     ID_ARROWEDIT_SET_FRAME },
		{ "BTN_OBJECT_INFO",                         ID_BTN_OBJECT_INFO },
		{ "CANCEL_EDIT_SRVR",                        ID_CANCEL_EDIT_SRVR },
		{ "CHIPEDIT_CMB_MOLIP_DUTY_ID",              ID_CHIPEDIT_CMB_MOLIP_DUTY_ID },
		{ "CHIPEDIT_CMB_TEXT_DUTY_ID",               ID_CHIPEDIT_CMB_TEXT_DUTY_ID },
		{ "CHIPEDIT_MODE_COMPOSITE_CHIP",            ID_CHIPEDIT_MODE_COMPOSITE_CHIP },
		{ "CHIPEDIT_MODE_OBJECT_CHIP",               ID_CHIPEDIT_MODE_OBJECT_CHIP },
		{ "CHIPEDIT_PROPERTY",                       ID_CHIPEDIT_PROPERTY },
		{ "CHIPEDIT_SET_DUTY",                       ID_CHIPEDIT_SET_DUTY },
		{ "CMB_BOTH_CODE_FONT_COLOR",                ID_CMB_BOTH_CODE_FONT_COLOR },
		{ "CMB_BOTH_CODE_FONT_NAME",                 ID_CMB_BOTH_CODE_FONT_NAME },
		{ "CMB_BOTH_CODE_FONT_SIZE",                 ID_CMB_BOTH_CODE_FONT_SIZE },
		{ "CMB_CURRENT_ARROW_SHEET",                 ID_CMB_CURRENT_ARROW_SHEET },
		{ "CMB_CURRENT_LAYER",                       ID_CMB_CURRENT_LAYER },
		{ "CMB_CURRENT_SHEET",                       ID_CMB_CURRENT_SHEET },
		{ "CMB_LABEL_LIST",                          ID_CMB_LABEL_LIST },
		{ "CMB_OBJ_BRUSH_COLOR",                     ID_CMB_OBJ_BRUSH_COLOR },
		{ "CMB_OBJ_PEN_COLOR",                       ID_CMB_OBJ_PEN_COLOR },
		{ "CMB_OBJ_PEN_STYLE",                       ID_CMB_OBJ_PEN_STYLE },
		{ "CMB_OBJ_PEN_WEIGHT",                      ID_CMB_OBJ_PEN_WEIGHT },
		{ "CMB_OBJ_REG_BRUSH",                       ID_CMB_OBJ_REG_BRUSH },
		{ "CMB_OBJ_REG_PEN",                         ID_CMB_OBJ_REG_PEN },
		{ "CONTEXT_HELP",                            ID_CONTEXT_HELP },
		{ "EDIT_BACKSPACE",                          ID_EDIT_BACKSPACE },
		{ "EDIT_CLEAR_SELECT",                       ID_EDIT_CLEAR_SELECT },
		{ "EDIT_COPY",                               ID_EDIT_COPY },
		{ "EDIT_COPY_TEXT",                          ID_EDIT_COPY_TEXT },
		{ "EDIT_CUT",                                ID_EDIT_CUT },
		{ "EDIT_DELETE",                             ID_EDIT_DELETE },
		{ "EDIT_EXCHANGE_HEAD_TAIL",                 ID_EDIT_EXCHANGE_HEAD_TAIL },
		{ "EDIT_FIND_NEXT_TEXT",                     ID_EDIT_FIND_NEXT_TEXT },
		{ "EDIT_FIND_PREV_TEXT",                     ID_EDIT_FIND_PREV_TEXT },
		{ "EDIT_FIND_TEXT",                          ID_EDIT_FIND_TEXT },
		{ "EDIT_FIND_TEXT_ALL",                      ID_EDIT_FIND_TEXT_ALL },
		{ "EDIT_FIND_TEXT_ALL_IN_SELECT",            ID_EDIT_FIND_TEXT_ALL_IN_SELECT },
		{ "EDIT_PASTE",                              ID_EDIT_PASTE },
		{ "EDIT_PASTE_OVER_AS",                      ID_EDIT_PASTE_OVER_AS },
		{ "EDIT_PASTE_SPECIAL",                      ID_EDIT_PASTE_SPECIAL },
		{ "EDIT_REDO",                               ID_EDIT_REDO },
		{ "EDIT_REPLACE_NEXT_TEXT",                  ID_EDIT_REPLACE_NEXT_TEXT },
		{ "EDIT_REPLACE_PREV_TEXT",                  ID_EDIT_REPLACE_PREV_TEXT },
		{ "EDIT_REPLACE_TEXT",                       ID_EDIT_REPLACE_TEXT },
		{ "EDIT_REPLACE_TEXT_ALL",                   ID_EDIT_REPLACE_TEXT_ALL },
		{ "EDIT_REPLACE_TEXT_ALL_IN_SELECT",         ID_EDIT_REPLACE_TEXT_ALL_IN_SELECT },
		{ "EDIT_SELECT_ALL",                         ID_EDIT_SELECT_ALL },
		{ "EDIT_SELECT_NEXT",                        ID_EDIT_SELECT_NEXT },
		{ "EDIT_SELECT_SAME_KIND_OF_OBJECT",         ID_EDIT_SELECT_SAME_KIND_OF_OBJECT },
		{ "EDIT_UNDO",                               ID_EDIT_UNDO },
		{ "FILE_CLOSE_HIDOCUMENT",                   ID_FILE_CLOSE_HIDOCUMENT },
		{ "FILE_CLOSE_OPEN",                         ID_FILE_CLOSE_OPEN },
		{ "FILE_COMEDT_NO_SAVE_EXIT",                ID_FILE_COMEDT_NO_SAVE_EXIT },
		{ "FILE_COMEDT_SAVE_EXIT",                   ID_FILE_COMEDT_SAVE_EXIT },
		{ "FILE_DELETE_HISTORY",                     ID_FILE_DELETE_HISTORY },
		{ "FILE_DOCUMENT_PROPERTY",                  ID_FILE_DOCUMENT_PROPERTY },
		{ "FILE_EXEC_HISTDRAW",                      ID_FILE_EXEC_HISTDRAW },
		{ "FILE_EXEC_HISTDRAW_TARGET",               ID_FILE_EXEC_HISTDRAW_TARGET },
		{ "FILE_EXEC_HISTVIEWER",                    ID_FILE_EXEC_HISTVIEWER },
		{ "FILE_EXEC_HISTVIEWER_TARGET",             ID_FILE_EXEC_HISTVIEWER_TARGET },
		{ "FILE_EXEC_MOLIPDRAW",                     ID_FILE_EXEC_MOLIPDRAW },
		{ "FILE_EXPORT",                             ID_FILE_EXPORT },
		{ "FILE_FORK_HISTORY",                       ID_FILE_FORK_HISTORY },
		{ "FILE_IMPORT",                             ID_FILE_IMPORT },
		{ "FILE_IMPORT_HIDOCUMENT",                  ID_FILE_IMPORT_HIDOCUMENT },
		{ "FILE_JOIN_PROJECT",                       ID_FILE_JOIN_PROJECT },
		{ "FILE_NEW_HIDOCUMENT",                     ID_FILE_NEW_HIDOCUMENT },
		{ "FILE_OPEN",                               ID_FILE_OPEN },
		{ "FILE_OPEN_HIDOCUMENT",                    ID_FILE_OPEN_HIDOCUMENT },
		{ "FILE_PAGE_SETUP",                         ID_FILE_PAGE_SETUP },
		{ "FILE_PRINT",                              ID_FILE_PRINT },
		{ "FILE_PRINT_PREVIEW",                      ID_FILE_PRINT_PREVIEW },
		{ "FILE_PRINT_SETUP",                        ID_FILE_PRINT_SETUP },
		{ "FILE_PROJECT_CLOSE",                      ID_FILE_PROJECT_CLOSE },
		{ "FILE_PROJECT_NEW",                        ID_FILE_PROJECT_NEW },
		{ "FILE_PROJECT_OPEN",                       ID_FILE_PROJECT_OPEN },
		{ "FILE_RECENT1",                            ID_FILE_RECENT1 },
		{ "FILE_SAVE",                               ID_FILE_SAVE },
		{ "FILE_SAVE_AS",                            ID_FILE_SAVE_AS },
		{ "FILE_SAVE_COPY_AS",                       ID_FILE_SAVE_COPY_AS },
		{ "FILE_SAVE_HIDOCUMENT",                    ID_FILE_SAVE_HIDOCUMENT },
		{ "FILE_SAVE_SELECT_AS",                     ID_FILE_SAVE_SELECT_AS },
		{ "FILE_SHEET_SETUP",                        ID_FILE_SHEET_SETUP },
		{ "FILE_UPDATE",                             ID_FILE_UPDATE },
		{ "FILE_WIN_NEW",                            ID_FILE_WIN_NEW },
		{ "FORMAT_FONT",                             ID_FORMAT_FONT },
		{ "GRAPHICS_CHIP_COPY",                      ID_GRAPHICS_CHIP_COPY },
// 06.10.31 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		{ "GRAPHICS_CHIP_PASTE",                     ID_GRAPHICS_CHIP_PASTE },
		{ "GRAPHICS_EDIT_CHIP",                      ID_GRAPHICS_EDIT_CHIP },
		{ "GRAPHICS_EDIT_CHIP_GROUP",                ID_GRAPHICS_EDIT_CHIP_GROUP },
		{ "GRAPHICS_EDIT_COLOR_TABLE",               ID_GRAPHICS_EDIT_COLOR_TABLE },
		{ "GRAPHICS_EDIT_PICTURE_TABLE",             ID_GRAPHICS_EDIT_PICTURE_TABLE },
		{ "GRAPHICS_EDIT_PICT_ARROW",                ID_GRAPHICS_EDIT_PICT_ARROW },
		{ "GRAPHICS_EDIT_REGBRUSH_TABLE",            ID_GRAPHICS_EDIT_REGBRUSH_TABLE },
		{ "GRAPHICS_EDIT_REGPEN_TABLE",              ID_GRAPHICS_EDIT_REGPEN_TABLE },
		{ "GRAPHICS_SHADOW_LENGTH",                  ID_GRAPHICS_SHADOW_LENGTH },
		{ "GRAPHICS_UNSELECT_CHIP",                  ID_GRAPHICS_UNSELECT_CHIP },
		{ "HELP",                                    ID_HELP },
		{ "HELP_FINDER",                             ID_HELP_FINDER },
		{ "HELP_MOLIP_HOMEPAGE",                     ID_HELP_MOLIP_HOMEPAGE },
// 06.03.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		{ "HELP_MOVIE",                              ID_HELP_MOVIE },
		{ "HTREE_BRANCH_VIEW",                       ID_HTREE_BRANCH_VIEW },
		{ "HTREE_CMB_UP_DOWN_KIND",                  ID_HTREE_CMB_UP_DOWN_KIND },
		{ "HTREE_CMB_ZOOM",                          ID_HTREE_CMB_ZOOM },
		{ "HTREE_CREATE_TIME_INDEX",                 ID_HTREE_CREATE_TIME_INDEX },
		{ "HTREE_FIND_PANEL",                        ID_HTREE_FIND_PANEL },
		{ "HTREE_FIND_RESULTS",                      ID_HTREE_FIND_RESULTS },
		{ "HTREE_FONT_LARGE",                        ID_HTREE_FONT_LARGE },
		{ "HTREE_FONT_MEDIUM",                       ID_HTREE_FONT_MEDIUM },
		{ "HTREE_FONT_SMALL",                        ID_HTREE_FONT_SMALL },
		{ "HTREE_JUMP_CURRENT_FIND_RESULT",          ID_HTREE_JUMP_CURRENT_FIND_RESULT },
		{ "HTREE_JUMP_NEXT_FIND_RESULT",             ID_HTREE_JUMP_NEXT_FIND_RESULT },
		{ "HTREE_JUMP_PREV_FIND_RESULT",             ID_HTREE_JUMP_PREV_FIND_RESULT },
		{ "HTREE_MOVE_AFTER",                        ID_HTREE_MOVE_AFTER },
		{ "HTREE_MOVE_BEFORE",                       ID_HTREE_MOVE_BEFORE },
		{ "HTREE_MOVE_HIGHER",                       ID_HTREE_MOVE_HIGHER },
		{ "HTREE_MOVE_LOWER",                        ID_HTREE_MOVE_LOWER },
// 06.03.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		{ "HTREE_MOVE_LTT_EACH",                     ID_HTREE_MOVE_LTT_EACH },
		{ "HTREE_MOVE_OPERATION_AFTER",              ID_HTREE_MOVE_OPERATION_AFTER },
		{ "HTREE_MOVE_OPERATION_BEFORE",             ID_HTREE_MOVE_OPERATION_BEFORE },
// 06.03.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		{ "HTREE_MOVE_OPERATION_EACH",               ID_HTREE_MOVE_OPERATION_EACH },
		{ "HTREE_MOVE_SELECTION_AFTER",              ID_HTREE_MOVE_SELECTION_AFTER },
		{ "HTREE_MOVE_SELECTION_BEFORE",             ID_HTREE_MOVE_SELECTION_BEFORE },
// 06.03.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		{ "HTREE_MOVE_TIME_EACH",                    ID_HTREE_MOVE_TIME_EACH },
		{ "HTREE_PROJECT_VIEW",                      ID_HTREE_PROJECT_VIEW },
		{ "HTREE_SELECT_MOVE_OPERATION",             ID_HTREE_SELECT_MOVE_OPERATION },
		{ "HTREE_TREE_VIEW",                         ID_HTREE_TREE_VIEW },
		{ "HTREE_USE_TIME_INDEX",                    ID_HTREE_USE_TIME_INDEX },
		{ "OBJECT_ALIGN_H_BOTTOM",                   ID_OBJECT_ALIGN_H_BOTTOM },
		{ "OBJECT_ALIGN_H_CENTER",                   ID_OBJECT_ALIGN_H_CENTER },
		{ "OBJECT_ALIGN_H_TOP",                      ID_OBJECT_ALIGN_H_TOP },
		{ "OBJECT_ALIGN_V_CENTER",                   ID_OBJECT_ALIGN_V_CENTER },
		{ "OBJECT_ALIGN_V_LEFT",                     ID_OBJECT_ALIGN_V_LEFT },
		{ "OBJECT_ALIGN_V_RIGHT",                    ID_OBJECT_ALIGN_V_RIGHT },
		{ "OBJECT_BACK_OBJ",                         ID_OBJECT_BACK_OBJ },
		{ "OBJECT_CONNECT",                          ID_OBJECT_CONNECT },
		{ "OBJECT_CONVERT_TO_POLY",                  ID_OBJECT_CONVERT_TO_POLY },
		{ "OBJECT_CROSS_SHEET",                      ID_OBJECT_CROSS_SHEET },
		{ "OBJECT_DISCONNECT",                       ID_OBJECT_DISCONNECT },
		{ "OBJECT_FRONT_OBJ",                        ID_OBJECT_FRONT_OBJ },
		{ "OBJECT_GROUP",                            ID_OBJECT_GROUP },
		{ "OBJECT_INSERT_JOINT",                     ID_OBJECT_INSERT_JOINT },
		{ "OBJECT_MIRROR_HORZ",                      ID_OBJECT_MIRROR_HORZ },
		{ "OBJECT_MIRROR_VERT",                      ID_OBJECT_MIRROR_VERT },
		{ "OBJECT_MOST_BACK_OBJ",                    ID_OBJECT_MOST_BACK_OBJ },
		{ "OBJECT_MOST_FRONT_OBJ",                   ID_OBJECT_MOST_FRONT_OBJ },
		{ "OBJECT_MOVE_SNAP_DOWN",                   ID_OBJECT_MOVE_SNAP_DOWN },
		{ "OBJECT_MOVE_SNAP_LEFT",                   ID_OBJECT_MOVE_SNAP_LEFT },
		{ "OBJECT_MOVE_SNAP_RIGHT",                  ID_OBJECT_MOVE_SNAP_RIGHT },
		{ "OBJECT_MOVE_SNAP_UP",                     ID_OBJECT_MOVE_SNAP_UP },
		{ "OBJECT_PROPERTIES",                       ID_OBJECT_PROPERTIES },
		{ "OBJECT_PUT_RTF_OBJ",                      ID_OBJECT_PUT_RTF_OBJ },
		{ "OBJECT_PUT_TIME_LABEL",                   ID_OBJECT_PUT_TIME_LABEL },
		{ "OBJECT_ROTATE",                           ID_OBJECT_ROTATE },
		{ "OBJECT_ROTATE_LEFT",                      ID_OBJECT_ROTATE_LEFT },
		{ "OBJECT_ROTATE_RIGHT",                     ID_OBJECT_ROTATE_RIGHT },
		{ "OBJECT_SAME_DIST_H",                      ID_OBJECT_SAME_DIST_H },
		{ "OBJECT_SAME_DIST_V",                      ID_OBJECT_SAME_DIST_V },
		{ "OBJECT_SAME_GAP_H",                       ID_OBJECT_SAME_GAP_H },
		{ "OBJECT_SAME_GAP_V",                       ID_OBJECT_SAME_GAP_V },
		{ "OBJECT_SAME_SIZE_X",                      ID_OBJECT_SAME_SIZE_X },
		{ "OBJECT_SAME_SIZE_Y",                      ID_OBJECT_SAME_SIZE_Y },
		{ "OBJECT_SIZE_TO_TEXT",                     ID_OBJECT_SIZE_TO_TEXT },
		{ "OBJECT_TABLE_ADD_COLUMN",                 ID_OBJECT_TABLE_ADD_COLUMN },
		{ "OBJECT_TABLE_ADD_LINE",                   ID_OBJECT_TABLE_ADD_LINE },
		{ "OBJECT_TABLE_DELETE_COLUMN",              ID_OBJECT_TABLE_DELETE_COLUMN },
		{ "OBJECT_TABLE_DELETE_LINE",                ID_OBJECT_TABLE_DELETE_LINE },
		{ "OBJECT_TABLE_INSERT_COLUMN",              ID_OBJECT_TABLE_INSERT_COLUMN },
		{ "OBJECT_TABLE_INSERT_LINE",                ID_OBJECT_TABLE_INSERT_LINE },
		{ "OBJECT_TABLE_MERGE_CELL",                 ID_OBJECT_TABLE_MERGE_CELL },
		{ "OBJECT_TABLE_SPLIT_CELL",                 ID_OBJECT_TABLE_SPLIT_CELL },
		{ "OBJECT_TIME_LABEL_PROPERTY",              ID_OBJECT_TIME_LABEL_PROPERTY },
		{ "OBJECT_UNGROUP",                          ID_OBJECT_UNGROUP },
		{ "OLE_INSERT_NEW",                          ID_OLE_INSERT_NEW },
		{ "OPTION_AUTO_ALTKEY",                      ID_OPTION_AUTO_ALTKEY },
		{ "OPTION_ENV",                              ID_OPTION_ENV },
		{ "OPTION_EXPERT_MODE",                      ID_OPTION_EXPERT_MODE },
		{ "OPTION_GRID_SNAP_SETUP",                  ID_OPTION_GRID_SNAP_SETUP },
		{ "OPTION_HISTORY_MOVE_OPE_LIST",            ID_OPTION_HISTORY_MOVE_OPE_LIST },
// 06.10.11 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		{ "OPTION_IS_ARROW_GAP_EFFECTIVE",           ID_OPTION_IS_ARROW_GAP_EFFECTIVE },
		{ "OPTION_IS_GRID_VISIBLE",                  ID_OPTION_IS_GRID_VISIBLE },
		{ "OPTION_IS_PAGE_VISIBLE",                  ID_OPTION_IS_PAGE_VISIBLE },
		{ "OPTION_IS_SNAP_EFFECTIVE",                ID_OPTION_IS_SNAP_EFFECTIVE },
		{ "OPTION_LAYER_ORDER",                      ID_OPTION_LAYER_ORDER },
		{ "OPTION_LEFT_HANDED",                      ID_OPTION_LEFT_HANDED },
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		{ "OPTION_MOVE_IN_LOWER_LAYER",              ID_OPTION_MOVE_IN_LOWER_LAYER },
		{ "OPTION_MOVE_IN_NEXT_SHEET",               ID_OPTION_MOVE_IN_NEXT_SHEET },
		{ "OPTION_MOVE_IN_PREV_SHEET",               ID_OPTION_MOVE_IN_PREV_SHEET },
		{ "OPTION_MOVE_IN_UPPER_LAYER",              ID_OPTION_MOVE_IN_UPPER_LAYER },
//----- 06.10.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		{ "OPTION_PAGE_MARGIN_VISIBLE",              ID_OPTION_PAGE_MARGIN_VISIBLE },
		{ "OPTION_POP_HINT_ENABLE",                  ID_OPTION_POP_HINT_ENABLE },
		{ "OPTION_RIGHT_HANDED",                     ID_OPTION_RIGHT_HANDED },
		{ "OPTION_SHEET_ORDER",                      ID_OPTION_SHEET_ORDER },
// 06.11.01 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		{ "OPTION_TOOL_LOCK",                        ID_OPTION_TOOL_LOCK },
		{ "OPTION_USER_REGISTRATION",                ID_OPTION_USER_REGISTRATION },
// 06.10.20 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		{ "RBTN_DELETE_HI_FORK_TAG",                 ID_RBTN_DELETE_HI_FORK_TAG },
		{ "RBTN_HTREE_CHANGE_BRANCH_INTO_TOP",       ID_RBTN_HTREE_CHANGE_BRANCH_INTO_TOP },
		{ "RBTN_HTREE_CHANGE_BRANCH_INTO_TRUNK",     ID_RBTN_HTREE_CHANGE_BRANCH_INTO_TRUNK },
		{ "RBTN_HTREE_CHANGE_TRUNK_INTO_BRANCH",     ID_RBTN_HTREE_CHANGE_TRUNK_INTO_BRANCH },
// 06.10.20 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		{ "RBTN_HTREE_DELETE_HI_FORK_TAG",           ID_RBTN_HTREE_DELETE_HI_FORK_TAG },
		{ "RBTN_HTREE_DELETE_TIME_LABEL",            ID_RBTN_HTREE_DELETE_TIME_LABEL },
		{ "RBTN_HTREE_DOCUMENT_PROPERTY",            ID_RBTN_HTREE_DOCUMENT_PROPERTY },
		{ "RBTN_HTREE_DOC_DELETE",                   ID_RBTN_HTREE_DOC_DELETE },
		{ "RBTN_HTREE_EXEC_HISTDRAW_TARGET",         ID_RBTN_HTREE_EXEC_HISTDRAW_TARGET },
		{ "RBTN_HTREE_EXEC_HISTVIEW_TARGET",         ID_RBTN_HTREE_EXEC_HISTVIEW_TARGET },
		{ "RBTN_HTREE_FORK_HISTORY",                 ID_RBTN_HTREE_FORK_HISTORY },
		{ "RBTN_HTREE_HI_TAG_PROPERTY",              ID_RBTN_HTREE_HI_TAG_PROPERTY },
		{ "RBTN_HTREE_PROJECT_PROPERTY",             ID_RBTN_HTREE_PROJECT_PROPERTY },
		{ "RBTN_HTREE_PUT_HI_FORK_TAG",              ID_RBTN_HTREE_PUT_HI_FORK_TAG },
		{ "RBTN_HTREE_TIME_LABEL_PROPERTY",          ID_RBTN_HTREE_TIME_LABEL_PROPERTY },
		{ "RBTN_ITEM_CHANGE",                        ID_RBTN_ITEM_CHANGE },
// 06.10.20 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		{ "RBTN_ITEM_CHANGE_2",                      ID_RBTN_ITEM_CHANGE_2 },
		{ "RBTN_ITEM_DELETE",                        ID_RBTN_ITEM_DELETE },
		{ "RBTN_ITEM_INSERT_NEXT",                   ID_RBTN_ITEM_INSERT_NEXT },
		{ "RBTN_ITEM_INSERT_PREV",                   ID_RBTN_ITEM_INSERT_PREV },
		{ "RBTN_ITEM_MERGE",                         ID_RBTN_ITEM_MERGE },
		{ "RBTN_ITEM_MOVE_BEGIN",                    ID_RBTN_ITEM_MOVE_BEGIN },
		{ "RBTN_ITEM_MOVE_CANCEL",                   ID_RBTN_ITEM_MOVE_CANCEL },
		{ "RBTN_ITEM_MOVE_NEXT",                     ID_RBTN_ITEM_MOVE_NEXT },
		{ "RBTN_ITEM_MOVE_OTHER",                    ID_RBTN_ITEM_MOVE_OTHER },
		{ "RBTN_ITEM_MOVE_PREV",                     ID_RBTN_ITEM_MOVE_PREV },
		{ "RBTN_ITEM_PASTE",                         ID_RBTN_ITEM_PASTE },
		{ "RBTN_RULER_CLEAR_ALL_TAB_POS",            ID_RBTN_RULER_CLEAR_ALL_TAB_POS },
		{ "RBTN_TOOLOBJ_PROPERTY",                   ID_RBTN_TOOLOBJ_PROPERTY },
		{ "RBTN_TOOLSELF_PROPERTY",                  ID_RBTN_TOOLSELF_PROPERTY },
		{ "SC_CLOSE",                                SC_CLOSE },
		{ "SC_MAXIMIZE",                             SC_MAXIMIZE },
		{ "SC_MINIMIZE",                             SC_MINIMIZE },
		{ "SC_MOVE",                                 SC_MOVE },
		{ "SC_RESTORE",                              SC_RESTORE },
		{ "SC_SIZE",                                 SC_SIZE },
		{ "STC_OBJECT_INF_0",                        ID_STC_OBJECT_INF_0 },
		{ "STC_OBJECT_INF_1",                        ID_STC_OBJECT_INF_1 },
		{ "STC_OBJECT_INF_2",                        ID_STC_OBJECT_INF_2 },
		{ "STC_OBJECT_INF_3",                        ID_STC_OBJECT_INF_3 },
		{ "STC_OBJECT_INF_4",                        ID_STC_OBJECT_INF_4 },
		{ "STC_OBJECT_INF_5",                        ID_STC_OBJECT_INF_5 },
		{ "TEXT_ALIGN_BOTTOM",                       ID_TEXT_ALIGN_BOTTOM },
		{ "TEXT_ALIGN_CENTER",                       ID_TEXT_ALIGN_CENTER },
		{ "TEXT_ALIGN_LEFT",                         ID_TEXT_ALIGN_LEFT },
		{ "TEXT_ALIGN_LEFTRIGHT",                    ID_TEXT_ALIGN_LEFTRIGHT },
		{ "TEXT_ALIGN_RIGHT",                        ID_TEXT_ALIGN_RIGHT },
		{ "TEXT_ALIGN_TOP",                          ID_TEXT_ALIGN_TOP },
		{ "TEXT_ALIGN_V_CENTER",                     ID_TEXT_ALIGN_V_CENTER },
		{ "TEXT_BOTH_CODE_FONT_BOLD",                ID_TEXT_BOTH_CODE_FONT_BOLD },
		{ "TEXT_BOTH_CODE_FONT_ITALIC",              ID_TEXT_BOTH_CODE_FONT_ITALIC },
		{ "TEXT_BOTH_CODE_FONT_UNDERLINE",           ID_TEXT_BOTH_CODE_FONT_UNDERLINE },
		{ "TEXT_DEFLATE_FONT_SIZE",                  ID_TEXT_DEFLATE_FONT_SIZE },
// 06.03.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		{ "TEXT_FULL_SCREEN_EDIT_MODE",              ID_TEXT_FULL_SCREEN_EDIT_MODE },
		{ "TEXT_INFLATE_FONT_SIZE",                  ID_TEXT_INFLATE_FONT_SIZE },
		{ "TEXT_LINE",                               ID_TEXT_LINE },
		{ "TEXT_MARGIN",                             ID_TEXT_MARGIN },
		{ "TEXT_REMOVE_FROM_OBJECT",                 ID_TEXT_REMOVE_FROM_OBJECT },
// 06.03.25 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
		{ "TEXT_ROTATE_BACKGROUND_COLOR",            ID_TEXT_ROTATE_BACKGROUND_COLOR },
		{ "TEXT_STOP_EDIT",                          ID_TEXT_STOP_EDIT },
		{ "TLCMD_CANCEL",                            ID_TLCMD_CANCEL },
		{ "TLCMD_DUPLICATE_OBJECT",                  ID_TLCMD_DUPLICATE_OBJECT },
		{ "TLCMD_ENCLOSE_AND",                       ID_TLCMD_ENCLOSE_AND },
		{ "TLCMD_ENCLOSE_OR",                        ID_TLCMD_ENCLOSE_OR },
		{ "TLCMD_ENCLOSE_XOR",                       ID_TLCMD_ENCLOSE_XOR },
		{ "TLCMD_MAKE_HORZ_LINK_OUT",                ID_TLCMD_MAKE_HORZ_LINK_OUT },
		{ "TLCMD_MAKE_LINK_IN_OUT",                  ID_TLCMD_MAKE_LINK_IN_OUT },
		{ "TLCMD_MAKE_LINK_OUT",                     ID_TLCMD_MAKE_LINK_OUT },
		{ "TLCMD_MAKE_VERT_LINK_OUT",                ID_TLCMD_MAKE_VERT_LINK_OUT },
		{ "TLCMD_MOVE_OBJECT",                       ID_TLCMD_MOVE_OBJECT },
		{ "TLCMD_POPUPMENU_ENDED",                   ID_TLCMD_POPUPMENU_ENDED },
		{ "TOOL_ANY_EDIT",                           ID_TOOL_ANY_EDIT },
		{ "TOOL_ARC",                                ID_TOOL_ARC },
		{ "TOOL_BEZIER_ARROW",                       ID_TOOL_BEZIER_ARROW },
		{ "TOOL_BEZILINE",                           ID_TOOL_BEZILINE },
//----- 06.10.05 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		{ "TOOL_BOX_BEZIER_ARROW",                   ID_TOOL_BOX_BEZIER_ARROW },
		{ "TOOL_BOX_POLY_ARROW",                     ID_TOOL_BOX_POLY_ARROW },
//----- 06.10.05 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		{ "TOOL_CHIP",                               ID_TOOL_CHIP },
		{ "TOOL_CHIP_PUT",                           ID_TOOL_CHIP_PUT },
		{ "TOOL_EDIT_RICH_TEXT",                     ID_TOOL_EDIT_RICH_TEXT },
		{ "TOOL_LINE",                               ID_TOOL_LINE },
		{ "TOOL_LINK",                               ID_TOOL_LINK },
		{ "TOOL_NOTE_LABEL_PUT",                     ID_TOOL_NOTE_LABEL_PUT },
		{ "TOOL_PEN_LABEL_PUT",                      ID_TOOL_PEN_LABEL_PUT },
		{ "TOOL_POINT",                              ID_TOOL_POINT },
		{ "TOOL_POLYLINE",                           ID_TOOL_POLYLINE },
		{ "TOOL_POLY_ARROW",                         ID_TOOL_POLY_ARROW },
		{ "TOOL_RECT",                               ID_TOOL_RECT },
		{ "TOOL_RICH_TEXT",                          ID_TOOL_RICH_TEXT },
		{ "TOOL_ROTATE",                             ID_TOOL_ROTATE },
		{ "TOOL_RRECT",                              ID_TOOL_RRECT },
		{ "TOOL_SELECT",                             ID_TOOL_SELECT },
		{ "TOOL_TABLE",                              ID_TOOL_TABLE },
		{ "TOOL_TEXT_PUT",                           ID_TOOL_TEXT_PUT },
		{ "TOOL_TIME_LABEL",                         ID_TOOL_TIME_LABEL },
		{ "TOOL_WIDE_BEZIER",                        ID_TOOL_WIDE_BEZIER },
		{ "TOOL_WIDE_BEZIER_ARROW",                  ID_TOOL_WIDE_BEZIER_ARROW },
		{ "TOOL_WIDE_POLY",                          ID_TOOL_WIDE_POLY },
		{ "TOOL_WIDE_POLY_ARROW",                    ID_TOOL_WIDE_POLY_ARROW },
		{ "TOOL_ZOOM",                               ID_TOOL_ZOOM },
		{ "VIEW_APPEND_DSM",                         ID_VIEW_APPEND_DSM },
		{ "VIEW_CHIP_STORE_DOCK_OR_FLOAT",           ID_VIEW_CHIP_STORE_DOCK_OR_FLOAT },
		{ "VIEW_CHIP_STORE_SIDE_CHANGE",             ID_VIEW_CHIP_STORE_SIDE_CHANGE },
		{ "VIEW_CHIP_STORE_VISIBLE",                 ID_VIEW_CHIP_STORE_VISIBLE },
		{ "VIEW_CMB_ZOOM",                           ID_VIEW_CMB_ZOOM },
		{ "VIEW_COPY_POSITION",                      ID_VIEW_COPY_POSITION },
		{ "VIEW_CURRENT_DSM",                        ID_VIEW_CURRENT_DSM },
		{ "VIEW_DELETE_DSM",                         ID_VIEW_DELETE_DSM },
		{ "VIEW_DSM_PANEL",                          ID_VIEW_DSM_PANEL },
		{ "VIEW_HTREE_DOCK_OR_FLOAT",                ID_VIEW_HTREE_DOCK_OR_FLOAT },
		{ "VIEW_HTREE_SIDE_CHANGE",                  ID_VIEW_HTREE_SIDE_CHANGE },
		{ "VIEW_HTREE_VISIBLE",                      ID_VIEW_HTREE_VISIBLE },
		{ "VIEW_NEXT_DSM",                           ID_VIEW_NEXT_DSM },
		{ "VIEW_OBJ_LABEL_LIST",                     ID_VIEW_OBJ_LABEL_LIST },
		{ "VIEW_OBJ_LABEL_SHOW_MODE",                ID_VIEW_OBJ_LABEL_SHOW_MODE },
		{ "VIEW_UNLINK_MARK_SHOW_MODE",              ID_VIEW_UNLINK_MARK_SHOW_MODE },
		{ "VIEW_PASTE_POSITION",                     ID_VIEW_PASTE_POSITION },
		{ "VIEW_PREV_DSM",                           ID_VIEW_PREV_DSM },
		{ "VIEW_REDRAW",                             ID_VIEW_REDRAW },
		{ "VIEW_STATUS_BAR",                         ID_VIEW_STATUS_BAR },
		{ "VIEW_TIME_LABEL_SHOW_MODE",               ID_VIEW_TIME_LABEL_SHOW_MODE },
		{ "VIEW_TOOLBAR_ARROW_DUTY",                 ID_VIEW_TOOLBAR_ARROW_DUTY },
		{ "VIEW_TOOLBAR_ARROW_EDIT",                 ID_VIEW_TOOLBAR_ARROW_EDIT },
		{ "VIEW_TOOLBAR_ARROW_TOOLS",                ID_VIEW_TOOLBAR_ARROW_TOOLS },
		{ "VIEW_TOOLBAR_ARROW_TOOLS2",               ID_VIEW_TOOLBAR_ARROW_TOOLS2 },
		{ "VIEW_TOOLBAR_CHIP_DUTY",                  ID_VIEW_TOOLBAR_CHIP_DUTY },
		{ "VIEW_TOOLBAR_CHIP_EDIT",                  ID_VIEW_TOOLBAR_CHIP_EDIT },
		{ "VIEW_TOOLBAR_CHIP_TOOLS",                 ID_VIEW_TOOLBAR_CHIP_TOOLS },
		{ "VIEW_TOOLBAR_CHIP_TOOLS2",                ID_VIEW_TOOLBAR_CHIP_TOOLS2 },
		{ "VIEW_TOOLBAR_COMDRW_TOOLS",               ID_VIEW_TOOLBAR_COMDRW_TOOLS },
		{ "VIEW_TOOLBAR_COMDRW_TOOLS2",              ID_VIEW_TOOLBAR_COMDRW_TOOLS2 },
		{ "VIEW_TOOLBAR_FONT",                       ID_VIEW_TOOLBAR_FONT },
		{ "VIEW_TOOLBAR_FUNCTION_KEY",               ID_VIEW_TOOLBAR_FUNCTION_KEY },
		{ "VIEW_TOOLBAR_HIST_DRAW_MAIN",             ID_VIEW_TOOLBAR_HIST_DRAW_MAIN },
		{ "VIEW_TOOLBAR_HIST_VIEW",                  ID_VIEW_TOOLBAR_HIST_VIEW },
		{ "VIEW_TOOLBAR_HIST_VIEW_TOOLS",            ID_VIEW_TOOLBAR_HIST_VIEW_TOOLS },
		{ "VIEW_TOOLBAR_HTREE_SEARCH",               ID_VIEW_TOOLBAR_HTREE_SEARCH },
		{ "VIEW_TOOLBAR_LAYER",                      ID_VIEW_TOOLBAR_LAYER },
		{ "VIEW_TOOLBAR_MAINFRAME",                  ID_VIEW_TOOLBAR_MAINFRAME },
		{ "VIEW_TOOLBAR_OBJ_INFO",                   ID_VIEW_TOOLBAR_OBJ_INFO },
		{ "VIEW_TOOLBAR_OBJ_LABEL",                  ID_VIEW_TOOLBAR_OBJ_LABEL },
		{ "VIEW_TOOLBAR_PEN_BRUSH",                  ID_VIEW_TOOLBAR_PEN_BRUSH },
		{ "VIEW_TOOLBAR_SHEET",                      ID_VIEW_TOOLBAR_SHEET },
		{ "VIEW_TOOLBAR_TEXT",                       ID_VIEW_TOOLBAR_TEXT },
		{ "VIEW_ZOOMIN",                             ID_VIEW_ZOOMIN },
		{ "VIEW_ZOOMOUT",                            ID_VIEW_ZOOMOUT },
		{ "WINDOW_ANOTHER1",                         ID_WINDOW_ANOTHER1 },
		{ "WND_CMB_STORE_CHIP_GROUP",                ID_WND_CMB_STORE_CHIP_GROUP },
		{ "WND_EDT_STORE_CHIP_NAME",                 ID_WND_EDT_STORE_CHIP_NAME },
		{ "WND_HORZ_RULER",                          ID_WND_HORZ_RULER },
		{ "WND_HTREE_VIEW",                          ID_WND_HTREE_VIEW },
		{ "WND_MTX_STORE_CHIP_VIEW",                 ID_WND_MTX_STORE_CHIP_VIEW },
		{ "WND_RULER_UNIT",                          ID_WND_RULER_UNIT },
		{ "WND_VERT_RULER",                          ID_WND_VERT_RULER },
	};
	static map<astring, DWORD> s_mpCommandStringToId;
	if (s_mpCommandStringToId.empty())
	{
		const long lNameCmdSz = sizeof(s_aNameCmd) / sizeof(s_aNameCmd[0]);
		// aNameCmd_xZkqqHx_iCkKjFeLiClIiPlIiPiHiCmJjFmAiCpBiCmFiCkCiCoJiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		for (long lC = 0; lC != lNameCmdSz; lC++)
			s_mpCommandStringToId[s_aNameCmd[lC].cpName] = s_aNameCmd[lC].dwCmdId;
	}
	// _xZkqqHx_jBoFjFlGiOjKiCmJjFmPiKlHiBeC_xHqqkZx_
	astring astr(cpCommandString);
	_strupr(&astr[0]);
	map<astring, DWORD>::const_iterator i = s_mpCommandStringToId.find(astr.c_str());
	if (i == s_mpCommandStringToId.end()) return DWORD(-1);
	return (*i).second;
} // FFCommandStringToId.

//----- 05.07.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//struct myFCNameCmd
//{
//	const char* cpName;
//	DWORD dwCmdId;
//}; // struct myFCNameCmd.
//
//inline bool operator < (const myFCNameCmd& v1, const myFCNameCmd& v2)
//{
//// 02.08.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ (_xZkqqHx_iClBiCoKiCmNjFhDjHhG_xHqqkZx_)
////	int i = strcmp(v1.cpName, v2.cpName);
//	return strcmp(v1.cpName, v2.cpName) < 0;
//} // bool operator <.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFInitUserAccelerator
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiDeBiDeOiDfKiDiJiDiMiBfLiDfOiDgFiBfLiDhFiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strBuff	:_xZkqqHx_iDgFiBfLiDhFiDiLiPiJiKpKiJlLjHhAiCmMiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *			bLeft	:_xZkqqHx_iNlGjHjIiCkLiCmIiCoHiCmO_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			tcpPath	:_xZkqqHx_jCoIiLgAiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lCurLine:_xZkqqHx_iMlLiNnNiCmMiNhDjEnEiNiGiCpAiOhHjCoIiBeCiNfIjAfGiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFInitUserAccelerator (astring& strBuff, BOOL bLeft, const wchar_t* tcpPath,
//							long& lCurLine, const DWORDSet& stCommandId)
//{
//	const myFCNameCmd aNameCmd[] =
//	{
//		{ "app_about",						ID_APP_ABOUT },						// Dynamic Draw_xZkqqHx_iCmMiDgPiBfLiDfHiDiHiDjDiPoOjFpB_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "app_exit",						ID_APP_EXIT },						// _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//		{ "app_win_exit",					ID_APP_WIN_EXIT },					// _xZkqqHx_jBfDiCmEiPeJjHlJiBeC_xHqqkZx_
//		{ "arrowedit_set_duty",				ID_ARROWEDIT_SET_DUTY },			// _xZkqqHx_jFjEjFgJiCmMjGpAiKiEiCpAjAnNjCoI_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "arrowedit_set_frame",			ID_ARROWEDIT_SET_FRAME },			// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
//		{ "chipedit_set_duty",				ID_CHIPEDIT_SET_DUTY },				// _xZkqqHx_jFjEjFgJiCmMjGpAiKiEiCpAjAnNjCoI_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "edit_clear_select",				ID_EDIT_CLEAR_SELECT },				// _xZkqqHx_jBeJjBpAiCpAiJpAiPjMiBeC_xHqqkZx_
//		{ "edit_copy",						ID_EDIT_COPY },						// _xZkqqHx_iDfCiDhDiBfLiBeC_xHqqkZx_
//		{ "edit_copy_resolution_1",			ID_EDIT_COPY_RESOLUTION_1 },		// 1_xZkqqHx_jEhLiBeC_xHqqkZx_
//		{ "edit_copy_resolution_2",			ID_EDIT_COPY_RESOLUTION_2 },		// 2_xZkqqHx_jEhLiBeC_xHqqkZx_
//		{ "edit_copy_resolution_4",			ID_EDIT_COPY_RESOLUTION_4 },		// 4_xZkqqHx_jEhLiBeC_xHqqkZx_
//		{ "edit_copy_resolution_6",			ID_EDIT_COPY_RESOLUTION_6 },		// 6_xZkqqHx_jEhLiBeC_xHqqkZx_
//		{ "edit_copy_resolution_8",			ID_EDIT_COPY_RESOLUTION_8 },		// 8_xZkqqHx_jEhLiBeC_xHqqkZx_
//		{ "edit_cut",						ID_EDIT_CUT },						// _xZkqqHx_jAnIiCoIiOoGiCoIiBeC_xHqqkZx_
//		{ "edit_delete",					ID_EDIT_DELETE },					// _xZkqqHx_iNoNiPjMiBeC_xHqqkZx_
//		{ "edit_find_next",					ID_EDIT_FIND_NEXT_TEXT },			// _xZkqqHx_iJlKjFpLiCpAiMjPiNpFiBeC_xHqqkZx_
//		{ "edit_find_prev",					ID_EDIT_FIND_PREV_TEXT },			// _xZkqqHx_iPoDjFpLiCpAiMjPiNpFiBeC_xHqqkZx_
//		{ "edit_find_text",					ID_EDIT_FIND_TEXT },				// _xZkqqHx_iDgFiDeMiDfIiDgHiMjPiNpF_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "edit_paste",						ID_EDIT_PASTE },					// _xZkqqHx_jDfMiCoIjFhEiCkPiBeC_xHqqkZx_
////		{ "edit_paste_as_metafile",			ID_EDIT_PASTE_AS_METAFILE },		// _xZkqqHx_jAhN_xHqqkZx_/_xZkqqHx_iDgFiDeMiDfIiDgHiMgAiOkOiCmFjDfMiCoIjFhEiCkPiBeC_xHqqkZx_
//		{ "edit_redo",						ID_EDIT_REDO },						// _xZkqqHx_iCoCiCoIjClMiClFiBeC_xHqqkZx_
//		{ "edit_replace_all",				ID_EDIT_REPLACE_TEXT_ALL },			// _xZkqqHx_jBfDiCmEiCpAjChFiKlHiBeC_xHqqkZx_
//		{ "edit_replace_next",				ID_EDIT_REPLACE_NEXT_TEXT },		// _xZkqqHx_jChFiKlHiMoDiJlKjFpLiCpAiMjPiNpFiBeC_xHqqkZx_
//		{ "edit_replace_prev",				ID_EDIT_REPLACE_PREV_TEXT },		// _xZkqqHx_jChFiKlHiMoDiPoDjFpLiCpAiMjPiNpFiBeC_xHqqkZx_
//		{ "edit_replace_text",				ID_EDIT_REPLACE_TEXT },				// _xZkqqHx_iDgFiDeMiDfIiDgHjChFiKlH_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "edit_select_all",				ID_EDIT_SELECT_ALL },				// _xZkqqHx_iClHiCnHiCmEiCpAjBeJjBpAiBeC_xHqqkZx_
//		{ "edit_select_next",				ID_EDIT_SELECT_NEXT },				// _xZkqqHx_iOjPiCpAjBeJjBpAiBeC_xHqqkZx_
//		{ "edit_undo",						ID_EDIT_UNDO },						// _xZkqqHx_iMlDiCmJjGnPiClHiBeC_xHqqkZx_
//		{ "file_close_hidocument",			ID_FILE_CLOSE_HIDOCUMENT },			// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAjFmCiClGiCoJiBeC_xHqqkZx_
//		{ "file_close_open",				ID_FILE_CLOSE_OPEN },				// _xZkqqHx_jFmCiClGiCmEiKeKiCkN_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_comedt_no_save_exit",		ID_FILE_COMEDT_NO_SAVE_EXIT },		// _xZkqqHx_iDgAiDgCiDhG_xHqqkZx_/_xZkqqHx_jGoOiIpDiCpAjDgPjIfOiClJiClIiPeJjHlJiBeC_xHqqkZx_
//		{ "file_comedt_save_exit",			ID_FILE_COMEDT_SAVE_EXIT },			// _xZkqqHx_iDgAiDgCiDhG_xHqqkZx_/_xZkqqHx_jGoOiIpDiCpAjDgPjIfOiClFiPeJjHlJiBeC_xHqqkZx_
//		{ "file_delete_history",			ID_FILE_DELETE_HISTORY },			// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAiNoNiPjMiBeC_xHqqkZx_
//		{ "file_exec_histdraw",				ID_FILE_EXEC_HISTDRAW },			// HistoricDraw_xZkqqHx_iCpAiLeOjDkOiBeC_xHqqkZx_
//		{ "file_exec_histdraw_target",		ID_FILE_EXEC_HISTDRAW_TARGET },		// _xZkqqHx_jFlGiPjBiCpA_xHqqkZx_HistoricDraw_xZkqqHx_iCmFiKeKiCkNiBeC_xHqqkZx_
//		{ "file_exec_histviewer",			ID_FILE_EXEC_HISTVIEWER },			// HistoryViewer_xZkqqHx_iCpAiLeOjDkOiBeC_xHqqkZx_
//		{ "file_exec_histviewer_target",	ID_FILE_EXEC_HISTVIEWER_TARGET },	// _xZkqqHx_jFlGiPjBiCpA_xHqqkZx_HistoryViewer_xZkqqHx_iCmFiKeKiCkNiBeC_xHqqkZx_
//		{ "file_exec_molipdraw",			ID_FILE_EXEC_MOLIPDRAW },			// Dynamic Draw_xZkqqHx_iCpAiLeOjDkOiBeC_xHqqkZx_
//		{ "file_fork_history",				ID_FILE_FORK_HISTORY },				// _xZkqqHx_jHjKjHpAjFkKiKpCiCpAiNoMjAkM_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_import",					ID_FILE_IMPORT },					// _xZkqqHx_jBlMiMgAiOkOiCmMiDhEiDeAiDeDiDiLiCpAjDmHiNjOiCnN_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_new",						ID_FILE_NEW },						// _xZkqqHx_jAfGiLeLiNoMjAkMiBeC_xHqqkZx_
//		{ "file_new_hidocument",			ID_FILE_NEW_HIDOCUMENT },			// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAjAfGiLeLiNoMjAkM_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_new_load_tmpl",				ID_FILE_NEW_LOAD_TMPL },			// _xZkqqHx_jAfGiLeLiNoMjAkMiCmGiDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLjDmHiNjOiCnN_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_open",						ID_FILE_OPEN },						// _xZkqqHx_iKeKiCkN_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_open_hidocument",			ID_FILE_OPEN_HIDOCUMENT },			// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAiKeKiCkN_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_page_setup",				ID_FILE_PAGE_SETUP },				// _xZkqqHx_iDhJiBfLiDfHiCmMjAnNjCoI_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_print",						ID_FILE_PRINT },					// _xZkqqHx_iIpDiNpM_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_print_preview",				ID_FILE_PRINT_PREVIEW },			// _xZkqqHx_iIpDiNpMiDhGiDiMiDhCiDiFiBfLiBeC_xHqqkZx_
//		{ "file_print_setup",				ID_FILE_PRINT_SETUP },				// _xZkqqHx_iDhGiDiKiDjDiDfOiCmGjHfNjEjCiCmMjAnNjCoI_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_project_close",				ID_FILE_PROJECT_CLOSE },			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAjFmCiClGiCoJiBeC_xHqqkZx_
//		{ "file_project_new",				ID_FILE_PROJECT_NEW },				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAjAfGiLeLiNoMjAkM_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_project_open",				ID_FILE_PROJECT_OPEN },				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiKeKiCkN_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_recent1",					ID_FILE_RECENT1 },					// _xZkqqHx_iNmFiLnPiOgHiCmBiClNiDhGiDiNiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
//		{ "file_save",						ID_FILE_SAVE },						// _xZkqqHx_iPoDiPjBiCkLjFnLjBlGiBeC_xHqqkZx_
//		{ "file_save_as",					ID_FILE_SAVE_AS },					// _xZkqqHx_jGlMjBePiCpAjFhEiCkPiCmEjFnLjBlG_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_save_copy_as",				ID_FILE_SAVE_COPY_AS },				// _xZkqqHx_iDfCiDhDiBfLiCmJjGlMjBePiCpAjFhEiCkPiCmEjFnLjBlG_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_save_hidocument",			ID_FILE_SAVE_HIDOCUMENT },			// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAjFnLjBlGiClHiCoJiBeC_xHqqkZx_
//		{ "file_save_select_as",			ID_FILE_SAVE_SELECT_AS },			// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiJoGjBjMiCpAiDeHiDeOiDfIiDhMiBfLiDgH_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_sheet_setup",				ID_FILE_SHEET_SETUP },				// _xZkqqHx_iDfGiBfLiDgHiDfEiDeDiDfJiCmMjAnNjCoI_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_tmpl_save",					ID_FILE_TMPL_SAVE },				// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLiCpAiPjBiNjOiCnN_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "file_update",					ID_FILE_UPDATE },					// _xZkqqHx_iNfIjAfGiBeC_xHqqkZx_
//		{ "file_win_new",					ID_FILE_WIN_NEW },					// _xZkqqHx_jAfGiLeLiNoMjAkMiBeC_xHqqkZx_
//		{ "format_font",					ID_FORMAT_FONT },					// _xZkqqHx_iDhEiDeIiDjDiDgHiCmMjAnNjCoI_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "graphics_chip_copy",				ID_GRAPHICS_CHIP_COPY },			// _xZkqqHx_iDgAiDgCiDhGiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//		{ "graphics_edit_chip",				ID_GRAPHICS_EDIT_CHIP },			// _xZkqqHx_iDgAiDgCiDhGiDgFiBfLiDhFiDiLiCmMjFnCiPfH_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "graphics_edit_chip_group",		ID_GRAPHICS_EDIT_CHIP_GROUP },		// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGiDgFiBfLiDhFiDiLiCmMjFnCiPfH_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "graphics_edit_color_table",		ID_GRAPHICS_EDIT_COLOR_TABLE },		// _xZkqqHx_jAeGiDgFiBfLiDhFiDiLiCmMjFnCiPfH_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "graphics_edit_pict_arrow",		ID_GRAPHICS_EDIT_PICT_ARROW },		// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDgFiBfLiDhFiDiLiCmMjFnCiPfH_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "graphics_edit_picture_table",	ID_GRAPHICS_EDIT_PICTURE_TABLE },	// _xZkqqHx_jEhHiMgJjAhNiDgFiBfLiDhFiDiLiCmMjFnCiPfH_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "graphics_edit_regbrush_table",	ID_GRAPHICS_EDIT_REGBRUSH_TABLE },	// _xZkqqHx_jDgPjIfOiDhFiDiJiDfGiDgFiBfLiDhFiDiLiCmMjFnCiPfH_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "graphics_edit_regpen_table",		ID_GRAPHICS_EDIT_REGPEN_TABLE },	// _xZkqqHx_jDgPjIfOiDhJiDjDiDgFiBfLiDhFiDiLiCmMjFnCiPfH_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "graphics_shadow_length",			ID_GRAPHICS_SHADOW_LENGTH },		// _xZkqqHx_iJgFiCmMjAnNjCoI_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "graphics_unselect_chip",			ID_GRAPHICS_UNSELECT_CHIP },		// _xZkqqHx_iDgAiDgCiDhGiCmMjBeJjBpAiCpAiJpAiPjMiBeC_xHqqkZx_
//		{ "help_finder",					ID_HELP_FINDER },					// _xZkqqHx_iDgHiDhDiDgCiDeOiCmMiMjPiNpFiBeC_xHqqkZx_
//		{ "help_molip_homepage",			ID_HELP_MOLIP_HOMEPAGE },			// _xZkqqHx_iDhKiBfLiDiAiDhJiBfLiDfH_xHqqkZx_MOLIPS_xZkqqHx_iCpAjFfMiOkG_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
////----- 04.11.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		{ "htree_detail_view",				ID_HTREE_DETAIL_VIEW },				// _xZkqqHx_iJlKiImKiJoGjGmKiCpAjFfMiOkGiBeC_xHqqkZx_
////		{ "htree_global_view",				ID_HTREE_GLOBAL_VIEW },				// _xZkqqHx_iPoDiImKiJoGjGmKiCpAjFfMiOkGiBeC_xHqqkZx_
////----- 04.11.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//		{ "htree_branch_view",				ID_HTREE_BRANCH_VIEW },				// _xZkqqHx_jHjKjHpAiNfMjBkCiDfIiDeOiDiKiBfLiDjDiCmJiDhFiDiJiDjDiDgAiDhCiDiFiBfLiCpAjFfMiOkGiBeC_xHqqkZx_
//		{ "htree_move_after",				ID_HTREE_MOVE_AFTER },				// _xZkqqHx_jHjKjHpAiCpAiJlKjFpLiCnGiInKjDkOiBeC_xHqqkZx_
//		{ "htree_move_before",				ID_HTREE_MOVE_BEFORE },				// _xZkqqHx_jHjKjHpAiCpAiPoDjFpLiCnGiInKjDkOiBeC_xHqqkZx_
//		{ "htree_move_higher",				ID_HTREE_MOVE_HIGHER },				// _xZkqqHx_iPoDiImKiCnGiInKjDkOiBeC_xHqqkZx_
//		{ "htree_move_lower",				ID_HTREE_MOVE_LOWER },				// _xZkqqHx_iJlKiImKiCnGiInKjDkOiBeC_xHqqkZx_
//		{ "htree_move_ltt_each",			ID_HTREE_MOVE_LTT_EACH },			// _xZkqqHx_jClHiNgMjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
//		{ "htree_move_operation_each",		ID_HTREE_MOVE_OPERATION_EACH },		// 1_xZkqqHx_jBiAiNoMjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
//		{ "htree_move_time_each",			ID_HTREE_MOVE_TIME_EACH },			// _xZkqqHx_iOjOiKnEjCfAiImKiCmFiInKjDkOiBeC_xHqqkZx_
//		{ "htree_project_view",				ID_HTREE_PROJECT_VIEW },			// _xZkqqHx_jHjKjHpAiNfMjBkCiDfIiDeOiDiKiBfLiDjDiCmJiDhGiDiNiDfHiDeGiDeOiDgHiDhCiDiFiBfLiCpAjFfMiOkGiBeC_xHqqkZx_
//		{ "htree_tree_view",				ID_HTREE_TREE_VIEW },				// _xZkqqHx_jHjKjHpAiNfMjBkCiDfIiDeOiDiKiBfLiDjDiCmJiDgDiDiKiBfLiDhCiDiFiBfLiCpAjFfMiOkGiBeC_xHqqkZx_
////----- 04.11.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		{ "htree_zoomin",					ID_HTREE_ZOOMIN },					// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiKgHjBoFiBeC_xHqqkZx_
////		{ "htree_zoomout",					ID_HTREE_ZOOMOUT },					// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiPgLiPkMiBeC_xHqqkZx_
////----- 04.11.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//		{ "object_align_h_bottom",			ID_OBJECT_ALIGN_H_BOTTOM },			// _xZkqqHx_iJlKjBkEiCmJjAkOjHpBiBeC_xHqqkZx_
//		{ "object_align_h_center",			ID_OBJECT_ALIGN_H_CENTER },			// _xZkqqHx_jCiGiJjLiCmJjAkOjHpBiBeC_xHqqkZx_
//		{ "object_align_h_top",				ID_OBJECT_ALIGN_H_TOP },			// _xZkqqHx_iPoDjBkEiCmJjAkOjHpBiBeC_xHqqkZx_
//		{ "object_align_v_center",			ID_OBJECT_ALIGN_V_CENTER },			// _xZkqqHx_jCiGiJjLiCmJjAkOjHpBiBeC_xHqqkZx_
//		{ "object_align_v_left",			ID_OBJECT_ALIGN_V_LEFT },			// _xZkqqHx_iNlGjBkEiCmJjAkOjHpBiBeC_xHqqkZx_
//		{ "object_align_v_right",			ID_OBJECT_ALIGN_V_RIGHT },			// _xZkqqHx_iJeFjBkEiCmJjAkOjHpBiBeC_xHqqkZx_
//		{ "object_back_obj",				ID_OBJECT_BACK_OBJ },				// _xZkqqHx_jFjEjFgJiCpAjEhHjGmKiCnGiBeC_xHqqkZx_
//		{ "object_connect",					ID_OBJECT_CONNECT },				// _xZkqqHx_jIeBiMiLjDfPiCmMjAnKjBlBiBeC_xHqqkZx_
//		{ "object_cross_sheet",				ID_OBJECT_CROSS_SHEET },			// _xZkqqHx_jFjEjFgJiCpAjBlMiDfGiBfLiDgH_xHqqkZx_/_xZkqqHx_iDiMiDeDiDiEiBfLiCnG_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "object_disconnect",				ID_OBJECT_DISCONNECT },				// _xZkqqHx_jIeBiMiLjDfPiCmMjAnKjBlBiJpAiPjMiBeC_xHqqkZx_
//		{ "object_front_obj",				ID_OBJECT_FRONT_OBJ },				// _xZkqqHx_jFjEjFgJiCpAjBePjGmKiCnGiBeC_xHqqkZx_
//		{ "object_group",					ID_OBJECT_GROUP },					// _xZkqqHx_iDePiDiLiBfLiDhGiJlLiBeC_xHqqkZx_
//		{ "object_insert_joint",			ID_OBJECT_INSERT_JOINT },			// _xZkqqHx_jIeBiMiLjDfPiCpAjBhNjDpMiBeC_xHqqkZx_
//		{ "object_mirror_horz",				ID_OBJECT_MIRROR_HORZ },			// _xZkqqHx_iNlGiJeFiCpAjElNjDfNiBeC_xHqqkZx_
//		{ "object_mirror_vert",				ID_OBJECT_MIRROR_VERT },			// _xZkqqHx_iPoDiJlKiCpAjElNjDfNiBeC_xHqqkZx_
//		{ "object_most_back_obj",			ID_OBJECT_MOST_BACK_OBJ },			// _xZkqqHx_jFjEjFgJiCpAiNmFjEhHjGmKiCnGiBeC_xHqqkZx_
//		{ "object_most_front_obj",			ID_OBJECT_MOST_FRONT_OBJ },			// _xZkqqHx_jFjEjFgJiCpAiNmFjBePjGmKiCnGiBeC_xHqqkZx_
////----- 05.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//		{ "object_move_snap_down",			ID_OBJECT_MOVE_SNAP_DOWN },			// _xZkqqHx_iJlKjFpLiMpMiDfIiDgJiDgCiDhGiInKjDkOiBeC_xHqqkZx_
//		{ "object_move_snap_left",			ID_OBJECT_MOVE_SNAP_LEFT },			// _xZkqqHx_iNlGjFpLiMpMiDfIiDgJiDgCiDhGiInKjDkOiBeC_xHqqkZx_
//		{ "object_move_snap_right",			ID_OBJECT_MOVE_SNAP_RIGHT },		// _xZkqqHx_iJeFjFpLiMpMiDfIiDgJiDgCiDhGiInKjDkOiBeC_xHqqkZx_
//		{ "object_move_snap_up",			ID_OBJECT_MOVE_SNAP_UP },			// _xZkqqHx_iPoDjFpLiMpMiDfIiDgJiDgCiDhGiInKjDkOiBeC_xHqqkZx_
////----- 05.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//		{ "object_properties",				ID_OBJECT_PROPERTIES },				// _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "object_put_rtf_obj",				ID_OBJECT_PUT_RTF_OBJ },			// _xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJiCpAjDfJjFhEiBeC_xHqqkZx_
//		{ "object_rotate_left",				ID_OBJECT_ROTATE_LEFT },			// _xZkqqHx_iNlGiCmJ_xHqqkZx_90_xZkqqHx_jDhIiJpBjDfNiBeC_xHqqkZx_
//		{ "object_rotate_right",			ID_OBJECT_ROTATE_RIGHT },			// _xZkqqHx_iJeFiCmJ_xHqqkZx_90_xZkqqHx_jDhIiJpBjDfNiBeC_xHqqkZx_
//		{ "object_same_dist_h",				ID_OBJECT_SAME_DIST_H },			// _xZkqqHx_jAiFjFlNiCmJiImKjChFiLmPjDjJiBeC_xHqqkZx_
//		{ "object_same_dist_v",				ID_OBJECT_SAME_DIST_V },			// _xZkqqHx_jAiCjClMiCmJiImKjChFiLmPjDjJiBeC_xHqqkZx_
//		{ "object_same_gap_h",				ID_OBJECT_SAME_GAP_H },				// _xZkqqHx_jAiFjFlNiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
//		{ "object_same_gap_v",				ID_OBJECT_SAME_GAP_V },				// _xZkqqHx_jAiCjClMiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
//		{ "object_same_size_x",				ID_OBJECT_SAME_SIZE_X },			// X_xZkqqHx_jFpLiMpMiCmJjDkPiDfEiDeDiDfJiBeC_xHqqkZx_
//		{ "object_same_size_y",				ID_OBJECT_SAME_SIZE_Y },			// Y_xZkqqHx_jFpLiMpMiCmJjDkPiDfEiDeDiDfJiBeC_xHqqkZx_
//		{ "object_size_to_text",			ID_OBJECT_SIZE_TO_TEXT },			// _xZkqqHx_iDgFiDeMiDfIiDgHiCmJiDfEiDeDiDfJiNiHiCoNiClJiBeC_xHqqkZx_
//		{ "object_ungroup",					ID_OBJECT_UNGROUP },				// _xZkqqHx_iDePiDiLiBfLiDhGiJpAiPjMiBeC_xHqqkZx_
//		{ "ole_insert_new",					ID_OLE_INSERT_NEW },				// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNoMjAkMiCmGjDfMiCoIjFhEiCkP_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "option_auto_altkey",				ID_OPTION_AUTO_ALTKEY },			// _xZkqqHx_iOkJjDkO_xHqqkZx_ALT_xZkqqHx_iDeMiBfLiCpAiOgHjHhAiBeC_xHqqkZx_
//		{ "option_env",						ID_OPTION_ENV },					// _xZkqqHx_iKmCiLkLjAnNjCoI_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "option_grid_snap_setup",			ID_OPTION_GRID_SNAP_SETUP },		// _xZkqqHx_iDePiDiKiDgCiDgI_xHqqkZx_/_xZkqqHx_iDfIiDgJiDgCiDhGiCmMjAnNjCoI_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "option_is_grid_visible",			ID_OPTION_IS_GRID_VISIBLE },		// _xZkqqHx_iDePiDiKiDgCiDgIiCmMjFfMiOkGiBeC_xHqqkZx_
//		{ "option_is_page_visible",			ID_OPTION_IS_PAGE_VISIBLE },		// _xZkqqHx_iDhJiBfLiDfHiLkLiKeFjApMiCmMjFfMiOkGiBeC_xHqqkZx_
//		{ "option_is_snap_effective",		ID_OPTION_IS_SNAP_EFFECTIVE },		// _xZkqqHx_iDfIiDgJiDgCiDhGiCpAjHeMiMpIiBeC_xHqqkZx_
//		{ "option_layer_order",				ID_OPTION_LAYER_ORDER },			// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjAnNjCoI_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "option_left_handed",				ID_OPTION_LEFT_HANDED },			// _xZkqqHx_iNlGjHjIiCkLiCmJjAnNjCoIiBeC_xHqqkZx_
//		{ "option_right_handed",			ID_OPTION_RIGHT_HANDED },			// _xZkqqHx_iJeFjHjIiCkLiCmJjAnNjCoIiBeC_xHqqkZx_
//		{ "option_sheet_order",				ID_OPTION_SHEET_ORDER },			// _xZkqqHx_iDfGiBfLiDgHiCmMjAnNjCoI_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "option_short_menu",				ID_OPTION_SHORT_MENU },				// _xZkqqHx_jCfKiPgLiDiBiDgKiDiFiBfLiCmFjFfMiOkGiBeC_xHqqkZx_
//		{ "option_sync_other_doc",			ID_OPTION_SYNC_OTHER_DOC },			// _xZkqqHx_jFmKjFlGiPjBiCmGjDkPiKpKiBeC_xHqqkZx_
//		{ "text_align_bottom",				ID_TEXT_ALIGN_BOTTOM },				// _xZkqqHx_iJlKiKpBiClJiBeC_xHqqkZx_
//		{ "text_align_center",				ID_TEXT_ALIGN_CENTER },				// _xZkqqHx_jCiGiJjLiKpBiClJiBeC_xHqqkZx_
//		{ "text_align_left",				ID_TEXT_ALIGN_LEFT },				// _xZkqqHx_iNlGiKpBiClJiBeC_xHqqkZx_
//		{ "text_align_leftright",			ID_TEXT_ALIGN_LEFTRIGHT },			// _xZkqqHx_jHlMjCfLjBlFiCkGiBeC_xHqqkZx_
//		{ "text_align_right",				ID_TEXT_ALIGN_RIGHT },				// _xZkqqHx_iJeFiKpBiClJiBeC_xHqqkZx_
//		{ "text_align_top",					ID_TEXT_ALIGN_TOP },				// _xZkqqHx_iPoDiKpBiClJiBeC_xHqqkZx_
//		{ "text_align_v_center",			ID_TEXT_ALIGN_V_CENTER },			// _xZkqqHx_jCiGiJjLiKpBiClJiBeC_xHqqkZx_
//		{ "text_full_screen_edit_mode",		ID_TEXT_FULL_SCREEN_EDIT_MODE },	// _xZkqqHx_jBfDiJoGjGmKiDeHiDgGiDeCiDfOiDiCiBfLiDgIiBeC_xHqqkZx_
//		{ "text_line",						ID_TEXT_LINE },						// _xZkqqHx_iDgFiDeMiDfIiDgHiNhDiKnEiCmMjAnNjCoI_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "text_margin",					ID_TEXT_MARGIN },					// _xZkqqHx_iDgFiDeMiDfIiDgHjHfNjEjCiCmMjAnNjCoI_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "text_remove_from_object",		ID_TEXT_REMOVE_FROM_OBJECT },		// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiNoNiPjMiBeC_xHqqkZx_
//		{ "text_stop_edit",					ID_TEXT_STOP_EDIT },				// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHiPeJjHlJiBeC_xHqqkZx_
//		{ "tlcmd_cancel",					ID_TLCMD_CANCEL },					// _xZkqqHx_jBiAiNoMiDeMiDiDiDjDiDfKiDiLiBeC_xHqqkZx_
//		{ "tool_any_edit",					ID_TOOL_ANY_EDIT },					// _xZkqqHx_jAhNiMgAjFnCiPfHiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_arc",						ID_TOOL_ARC },						// _xZkqqHx_iJhOiMmKiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_bezier_arrow",				ID_TOOL_BEZIER_ARROW },				// _xZkqqHx_jGoOiIpDiLmIjApMiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_beziline",					ID_TOOL_BEZILINE },					// _xZkqqHx_iLmIjApMiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_chip",						ID_TOOL_CHIP },						// _xZkqqHx_iDgAiDgCiDhGiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_chip_put",					ID_TOOL_CHIP_PUT },					// _xZkqqHx_iDgAiDgCiDhGjEhKjChFiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_edit_rich_text",			ID_TOOL_EDIT_RICH_TEXT },			// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_label_put",					ID_TOOL_PEN_LABEL_PUT },				// _xZkqqHx_iDiJiDhIiDiLjEhKjChFiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_line",						ID_TOOL_LINE },						// _xZkqqHx_jClMjApMiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_link",						ID_TOOL_LINK },						// _xZkqqHx_iDiKiDjDiDeOiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_point",						ID_TOOL_POINT },					// _xZkqqHx_iDiKiDjDiDeOjDfPiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_poly_arrow",				ID_TOOL_POLY_ARROW },				// _xZkqqHx_jGoOiIpDjBlNiKhAjApMiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_polyline",					ID_TOOL_POLYLINE },					// _xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_rect",						ID_TOOL_RECT },						// _xZkqqHx_iLoJiMgAiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_rich_text",					ID_TOOL_RICH_TEXT },				// _xZkqqHx_iDgFiDeMiDfIiDgHiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_rotate",					ID_TOOL_ROTATE },					// _xZkqqHx_iJpBjDfNiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_rrect",						ID_TOOL_RRECT },					// _xZkqqHx_iKnLiKhAiLoJiMgAiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_select",					ID_TOOL_SELECT },					// _xZkqqHx_jBeJjBpAiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_text_put",					ID_TOOL_TEXT_PUT },					// _xZkqqHx_iDiKiDjDiDeOiDgFiDeMiDfIiDgHjEhKjChFiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_wide_bezier",				ID_TOOL_WIDE_BEZIER },				// _xZkqqHx_jFjNiNeMiLmIjApMiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_wide_bezier_arrow",			ID_TOOL_WIDE_BEZIER_ARROW },		// _xZkqqHx_jGoOiIpDjFjNiNeMiLmIjApMiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_wide_poly",					ID_TOOL_WIDE_POLY },				// _xZkqqHx_jFjNiNeMjBlNiKhAjApMiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_wide_poly_arrow",			ID_TOOL_WIDE_POLY_ARROW },			// _xZkqqHx_jGoOiIpDjFjNiNeMjBlNiKhAjApMiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "tool_zoom",						ID_TOOL_ZOOM },						// _xZkqqHx_iDfJiBfLiDiAiDgDiBfLiDiLiBeC_xHqqkZx_
//		{ "view_chip_store_visible",		ID_VIEW_CHIP_STORE_VISIBLE },		// _xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiBeC_xHqqkZx_
//		{ "view_copy_position",				ID_VIEW_COPY_POSITION },			// _xZkqqHx_jFlGiPjBiImKjChFiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//		{ "view_htree_find_panel",			ID_VIEW_HTREE_FIND_PANEL },			// _xZkqqHx_jHjKjHpAiMjPiNpFiDhAiDgMiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
//		{ "view_htree_visible",				ID_VIEW_HTREE_VISIBLE },			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiBeC_xHqqkZx_
//		{ "view_obj_label_list",			ID_VIEW_OBJ_LABEL_LIST },			// _xZkqqHx_iDiJiDhIiDiLjFjEjFgJiIoKjHjHiDhAiDgMiDiL_xHqqkZx_..._xZkqqHx_iBeC_xHqqkZx_
//		{ "view_obj_label_show_mode",		ID_VIEW_OBJ_LABEL_SHOW_MODE },		// _xZkqqHx_iDiJiDhIiDiLjFjEjFgJjFfMiOkGiBeC_xHqqkZx_
//		{ "view_paste_position",			ID_VIEW_PASTE_POSITION },			// _xZkqqHx_iDfCiDhDiBfLiClDiCoKiClNjFlGiPjBiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
//		{ "view_redraw",					ID_VIEW_REDRAW },					// _xZkqqHx_iJoGjGmKiNmEjFfMiOkGiBeC_xHqqkZx_
//		{ "view_status_bar",				ID_VIEW_STATUS_BAR },				// _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_arrow_duty",		ID_VIEW_TOOLBAR_ARROW_DUTY },		// _xZkqqHx_jGoOiIpDjGpAiKiEiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_arrow_edit",		ID_VIEW_TOOLBAR_ARROW_EDIT },		// _xZkqqHx_iDiBiDeDiDjDiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_arrow_tools",		ID_VIEW_TOOLBAR_ARROW_TOOLS },		// _xZkqqHx_iDgDiBfLiDiLiDhLiDgCiDeOiDfI_xHqqkZx_1_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_arrow_tools2",		ID_VIEW_TOOLBAR_ARROW_TOOLS2 },		// _xZkqqHx_iDgDiBfLiDiLiDhLiDgCiDeOiDfI_xHqqkZx_2_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_chip_duty",			ID_VIEW_TOOLBAR_CHIP_DUTY },		// _xZkqqHx_iDgAiDgCiDhGjGpAiKiEiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_chip_edit",			ID_VIEW_TOOLBAR_CHIP_EDIT },		// _xZkqqHx_iDiBiDeDiDjDiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_chip_tools",		ID_VIEW_TOOLBAR_CHIP_TOOLS },		// _xZkqqHx_iDgDiBfLiDiLiDhLiDgCiDeOiDfI_xHqqkZx_1_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_chip_tools2",		ID_VIEW_TOOLBAR_CHIP_TOOLS2 },		// _xZkqqHx_iDgDiBfLiDiLiDhLiDgCiDeOiDfI_xHqqkZx_2_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_comdrw_tools",		ID_VIEW_TOOLBAR_COMDRW_TOOLS },		// _xZkqqHx_iDgDiBfLiDiLiDhLiDgCiDeOiDfI_xHqqkZx_1_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_comdrw_tools2",		ID_VIEW_TOOLBAR_COMDRW_TOOLS2 },	// _xZkqqHx_iDgDiBfLiDiLiDhLiDgCiDeOiDfI_xHqqkZx_2_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_function_key",		ID_VIEW_TOOLBAR_FUNCTION_KEY },		// _xZkqqHx_iDhEiDeAiDjDiDeOiDfGiDiHiDjDiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_hist_draw_main",	ID_VIEW_TOOLBAR_HIST_DRAW_MAIN },	// _xZkqqHx_iDiBiDeDiDjDiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_hist_view",			ID_VIEW_TOOLBAR_HIST_VIEW },		// _xZkqqHx_iDiBiDeDiDjDiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_hist_view_tools",	ID_VIEW_TOOLBAR_HIST_VIEW_TOOLS },	// _xZkqqHx_iDgDiBfLiDiLiDhLiDgCiDeOiDfIiDgPiBfLiBeC_xHqqkZx_
////		{ "view_toolbar_htree_ctrl",		ID_VIEW_TOOLBAR_HTREE_CTRL },		// _xZkqqHx_jHjKjHpAjGnIjAkHiMoEiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_layer",				ID_VIEW_TOOLBAR_LAYER },			// _xZkqqHx_iDiMiDeDiDiEiBfLiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_mainframe",			ID_VIEW_TOOLBAR_MAINFRAME },		// _xZkqqHx_iDiBiDeDiDjDiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_obj_info",			ID_VIEW_TOOLBAR_OBJ_INFO },			// _xZkqqHx_jFjEjFgJiPoOjFpBiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_obj_label",			ID_VIEW_TOOLBAR_OBJ_LABEL },		// _xZkqqHx_iDiJiDhIiDiLiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_pen_brush",			ID_VIEW_TOOLBAR_PEN_BRUSH },		// _xZkqqHx_iDhJiDjD_xHqqkZx_/_xZkqqHx_iDhFiDiJiDfGiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_sheet",				ID_VIEW_TOOLBAR_SHEET },			// _xZkqqHx_iDfGiBfLiDgHiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_toolbar_text",				ID_VIEW_TOOLBAR_TEXT },				// _xZkqqHx_iDgFiDeMiDfIiDgHiDgDiBfLiDiLiDgPiBfLiBeC_xHqqkZx_
//		{ "view_zoomin",					ID_VIEW_ZOOMIN },					// _xZkqqHx_iDfJiBfLiDiAiDeDiDjDiBeC_xHqqkZx_
//		{ "view_zoomout",					ID_VIEW_ZOOMOUT },					// _xZkqqHx_iDfJiBfLiDiAiDeBiDeFiDgHiBeC_xHqqkZx_
//	};
//	const long lNameCmdSz = sizeof(aNameCmd) / sizeof(aNameCmd[0]);
//
//#ifdef _DEBUG
//	// aNameCmd_xZkqqHx_iCkKjFeLiClIiPlIiPiHiCmJjFmAiCpBiCmFiCkCiCoJiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//	for (long lC = 1; lC < lNameCmdSz; lC++)
//		if (!(aNameCmd[lC - 1] < aNameCmd[lC])) AfxDebugBreak();
//#endif//_DEBUG
//
//	long lNewLine = lCurLine;
//	char* cpEndTag;
//	if (bLeft)
//		cpEndTag = "</left shortcut key>";
//	else
//		cpEndTag = "</right shortcut key>";
//
//	astring astrLine;
//	astring strKey;
//	astring strEachKey;
//	astring strCommand;
//	// 1_xZkqqHx_iNhDjDmHiCnNiNjOiCnNiBeCiJpMiNhDiCmNiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
//	while (!strBuff.empty())
//	{
//		// _xZkqqHx_jAfGiClFiCkCiNhDiCpAjAnNjCoIiBeC_xHqqkZx_
//		lCurLine = lNewLine;
//		// 1_xZkqqHx_iNhDjDmHiCnNiNjOiCnNiBeCiJpMiNhDiCmNiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
//		long lLineCount;
//		astrLine = ::GetLine(strBuff, lLineCount);
//		// _xZkqqHx_jAfGiClFiCkCiNhDiCpAiMhGiOfKiBeC_xHqqkZx_
//		lNewLine = lCurLine + lLineCount;
//		// _xZkqqHx_iNmFiPiJiBeFiNmFiMoDiCmMiLpDjEjCiBeFiJpMiNhDiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
//		TrimLeft(astrLine);
//		TrimRight(astrLine);
//		// _xZkqqHx_iNhDiCmJiJlNiCoAjGlDiCkCiPoKiNiHiCmNiNhDiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
//		if (astrLine.empty()) continue;
//		// #_xZkqqHx_iCmFiOgOiCnMiCoJiPoKiNiHiCmNiNhDiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
//		if (astrLine[0] == '#') continue;
//		// _xZkqqHx_jBfDiCmEiPkMjFlGiOjKiCmJiBeC_xHqqkZx_
//		_strlwr(astrLine.begin());
//		// _xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_ </XXX shortcut key> _xZkqqHx_iCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
//		if (astrLine == cpEndTag) break;
//		// _xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_ </end> _xZkqqHx_iCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
//		if (astrLine == "</end>") break;
//		// _xZkqqHx_iClLiCmMjBlMiCmMiDfOiDePiCmIiCoHiCmOiDeHiDiJiBfLiBeC_xHqqkZx_
//		if (astrLine[0] == '<')
//		{
//			FFThrowMiscException(IDS_ERR_SYNTAX_ERROR,
//									tcpPath, lCurLine,
//									(const wchar_t*)AStrToWStr(astrLine.c_str()));
//		}
//		strKey = ::FFExtractUntil(astrLine, ',');
//		strCommand = ::FFExtractUntil(astrLine, ',');
//		// _xZkqqHx_jHlMjBkEiCmMiLpDjEjCiBeFiJpMiNhDiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
//		TrimLeft(strKey);
//		TrimRight(strKey);
//		// _xZkqqHx_jHlMjBkEiCmMiLpDjEjCiBeFiJpMiNhDiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
//		TrimLeft(strCommand);
//		TrimRight(strCommand);
//
//		myFCNameCmd nameCmd = { strCommand.c_str(), 0 };
//		const myFCNameCmd* pPtr = lower_bound(aNameCmd, aNameCmd + lNameCmdSz, nameCmd);
//		if (pPtr == aNameCmd + lNameCmdSz ||
//			strcmp(pPtr->cpName, strCommand.c_str()) != 0)
//		//----- _xZkqqHx_iDfCiDhNiDjDiDgIjGlMiCmMjFlGiOjKjHpBiCkKiCmHiCoKiCmGiCoAiIoKjChGiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			FFThrowMiscException(IDS_ERR_SYNTAX_ERROR,
//									tcpPath, lCurLine,
//									(const wchar_t*)AStrToWStr(strCommand.c_str()));
//		}
//		// _xZkqqHx_iMlLiNnNiCmMiDiBiDgKiDiFiBfLiCmJiKnMiCnMiCoKiCmIiCkCiDfCiDhNiDjDiDgIiCmNiBeBiDeBiDeOiDfKiDiJiDiMiBfLiDfOiCmJjCmHiJmBiClFiCmIiCkCiBeC_xHqqkZx_
//		if (stCommandId.find(pPtr->dwCmdId) == stCommandId.end()) continue;
//
//		WORD wKey = WORD(-1);
//		BYTE byVirt = FVIRTKEY;
//		while (!strKey.empty())
//		{
//			strEachKey = ::FFExtractUntil(strKey, '+');
//			if (!myStrToAccel(wKey, byVirt, strEachKey))
//			{
//				FFThrowMiscException(IDS_ERR_SYNTAX_ERROR,
//										tcpPath, lCurLine,
//										(const wchar_t*)AStrToWStr(strEachKey.c_str()));
//			}
//		}
//		if (wKey == WORD(-1))
//		{
//			FFThrowMiscException(IDS_ERR_SYNTAX_ERROR,
//										tcpPath, lCurLine, L"");
//		}
//
//		ACCEL accel;
//		accel.fVirt = byVirt;
//		accel.key = wKey;
//		accel.cmd = pPtr->dwCmdId;
//
//		if (bLeft)
//			s_vAccelL.push_back(accel);
//		else
//			s_vAccelR.push_back(accel);
//	}
//	// _xZkqqHx_jAfGiClFiCkCiNhDiCpAjAnNjCoIiBeC_xHqqkZx_
//	lCurLine = lNewLine;
//} // FFInitUserAccelerator.
//----- 05.07.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFInitUserAccelerator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiDeBiDeOiDfKiDiJiDiMiBfLiDfOiDgFiBfLiDhFiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strBuff	:_xZkqqHx_iDgFiBfLiDhFiDiLiPiJiKpKiJlLjHhAiCmMiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bLeft	:_xZkqqHx_iNlGjHjIiCkLiCmIiCoHiCmO_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpPath	:_xZkqqHx_jCoIiLgAiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lCurLine:_xZkqqHx_iMlLiNnNiCmMiNhDjEnEiNiGiCpAiOhHjCoIiBeCiNfIjAfGiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			05.07.21 Fukushiro M. _xZkqqHx_iPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void FFInitUserAccelerator (astring& strBuff, BOOL bLeft, const wchar_t* tcpPath,
							long& lCurLine, const DWORDSet& stCommandId)
{
	long lNewLine = lCurLine;
	char* cpEndTag;
	if (bLeft)
		cpEndTag = "</left shortcut key>";
	else
		cpEndTag = "</right shortcut key>";

	astring astrLine;
	astring astrKey;
	astring astrEachKey;
	astring astrCommand;
	// 1_xZkqqHx_iNhDjDmHiCnNiNjOiCnNiBeCiJpMiNhDiCmNiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
	while (!strBuff.empty())
	{
		// _xZkqqHx_jAfGiClFiCkCiNhDiCpAjAnNjCoIiBeC_xHqqkZx_
		lCurLine = lNewLine;
		// 1_xZkqqHx_iNhDjDmHiCnNiNjOiCnNiBeCiJpMiNhDiCmNiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
		long lLineCount;
		astrLine = ::GetLine(strBuff, lLineCount);
		// _xZkqqHx_jAfGiClFiCkCiNhDiCpAiMhGiOfKiBeC_xHqqkZx_
		lNewLine = lCurLine + lLineCount;
		// _xZkqqHx_iNmFiPiJiBeFiNmFiMoDiCmMiLpDjEjCiBeFiJpMiNhDiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
		TrimLeft(astrLine);
		TrimRight(astrLine);
		// _xZkqqHx_iNhDiCmJiJlNiCoAjGlDiCkCiPoKiNiHiCmNiNhDiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		if (astrLine.empty()) continue;
		// #_xZkqqHx_iCmFiOgOiCnMiCoJiPoKiNiHiCmNiNhDiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		if (astrLine[0] == '#') continue;
		// _xZkqqHx_jBfDiCmEiPkMjFlGiOjKiCmJiBeC_xHqqkZx_
		_strlwr(astrLine.begin());
		// _xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_ </XXX shortcut key> _xZkqqHx_iCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (astrLine == cpEndTag) break;
		// _xZkqqHx_iPeJjHlJiDfOiDeP_xHqqkZx_ </end> _xZkqqHx_iCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (astrLine == "</end>") break;
		// _xZkqqHx_iClLiCmMjBlMiCmMiDfOiDePiCmIiCoHiCmOiDeHiDiJiBfLiBeC_xHqqkZx_
		if (astrLine[0] == '<')
		{
			FFThrowMiscException(IDS_ERR_SYNTAX_ERROR,
									tcpPath, lCurLine,
									(const wchar_t*)AStrToWStr(astrLine.c_str()));
		}
		astrKey = ::FFExtractUntil(astrLine, ',');
		astrCommand = ::FFExtractUntil(astrLine, ',');
		// _xZkqqHx_jHlMjBkEiCmMiLpDjEjCiBeFiJpMiNhDiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
		TrimLeft(astrKey);
		TrimRight(astrKey);
		// _xZkqqHx_jHlMjBkEiCmMiLpDjEjCiBeFiJpMiNhDiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
		TrimLeft(astrCommand);
		TrimRight(astrCommand);

		// _xZkqqHx_iDfCiDhNiDjDiDgIjGlMiCkJiCoHiDfCiDhNiDjDiDgIiCgIiCgDiCpAiOoGjDlOiBeC_xHqqkZx_
		DWORD dwCommandId = FFCommandStringToId(astrCommand.c_str());

		if (dwCommandId == DWORD(-1))
		//----- _xZkqqHx_iDfCiDhNiDjDiDgIjGlMiCmMjFlGiOjKjHpBiCkKiCmHiCoKiCmGiCoAiIoKjChGiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			FFThrowMiscException(	IDS_ERR_SYNTAX_ERROR,
										tcpPath, lCurLine,
										(const wchar_t*)AStrToWStr(astrCommand.c_str()));
		}
		// _xZkqqHx_iMlLiNnNiCmMiDiBiDgKiDiFiBfLiCmJiKnMiCnMiCoKiCmIiCkCiDfCiDhNiDjDiDgIiCmNiBeBiDeBiDeOiDfKiDiJiDiMiBfLiDfOiCmJjCmHiJmBiClFiCmIiCkCiBeC_xHqqkZx_
		if (stCommandId.find(dwCommandId) == stCommandId.end()) continue;

		WORD wKey = WORD(-1);
		BYTE byVirt = FVIRTKEY;
		while (!astrKey.empty())
		{
			astrEachKey = ::FFExtractUntil(astrKey, '+');
			if (!myStrToAccel(wKey, byVirt, astrEachKey))
			{
				FFThrowMiscException(IDS_ERR_SYNTAX_ERROR,
										tcpPath, lCurLine,
										(const wchar_t*)AStrToWStr(astrEachKey.c_str()));
			}
		}
		if (wKey == WORD(-1))
		{
			FFThrowMiscException(IDS_ERR_SYNTAX_ERROR,
										tcpPath, lCurLine, L"");
		}

		ACCEL accel;
		accel.fVirt = byVirt;
		accel.key = wKey;
		accel.cmd = dwCommandId;

		if (bLeft)
			s_vAccelL.push_back(accel);
		else
			s_vAccelR.push_back(accel);
	}
	// _xZkqqHx_jAfGiClFiCkCiNhDiCpAjAnNjCoIiBeC_xHqqkZx_
	lCurLine = lNewLine;
} // FFInitUserAccelerator.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetUserAccelerator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFjCoIiLgAiCmMiDeBiDeOiDfKiDiJiDiMiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetUserAccelerator (const ACCEL*& pAccel, long& lAccel, BOOL bLeft)
{
	if (bLeft)
	{
		pAccel = s_vAccelL.begin();
		lAccel = s_vAccelL.size();
	} else
	{
		pAccel = s_vAccelR.begin();
		lAccel = s_vAccelR.size();
	}
} // FFGetUserAccelerator.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myAddShortcutText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiCmJiDfGiDiHiBfLiDgHiDeKiDgCiDgHiDgFiDeMiDfIiDgHiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myAddShortcutText (HMENU hMenu, const map<DWORD, CString>& mpCmdToName)
{
	map<DWORD, CString>::const_iterator iCn;
	MENUITEMINFO mii;
	// _xZkqqHx_iDiBiDgKiDiFiBfLjAjEiCpAiOoGjDlOiBeC_xHqqkZx_
	const int iMenuCount = GetMenuItemCount(hMenu);
	_TCHAR* tcpFind;
	for (int imi = 0; imi < iMenuCount; imi++)
	{
		_TCHAR tsz[250] = { _T('\0') };
		//----- _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBiCmGiDfEiDhFiDiBiDgKiDiFiBfLiDgOiDjDiDgIiDiLiCpAiOoGjDlO_xHqqkZx_ -----
		mii.cbSize = sizeof(mii);
		mii.fMask = MIIM_TYPE | MIIM_ID | MIIM_SUBMENU;
		mii.dwTypeData = tsz;
		mii.cch = sizeof(tsz) / sizeof(tsz[0]);
		GetMenuItemInfo(hMenu, imi, MF_BYPOSITION, &mii);

		// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCkKiCkAiCoJiPoKiNiHiCmNiNmEiLeBiMmEiCnBiPgPiClFiBeC_xHqqkZx_
		if (mii.hSubMenu != NULL)
		{
			myAddShortcutText(mii.hSubMenu, mpCmdToName);
			continue;
		}
		// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBiCkKjGlDiCkCiPoKiNiHiBgJiDfKiDhAiDiMiBfLiDfOjDjJiBgKiCmNiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (tsz == NULL || *tsz == _T('\0')) continue;
		// _xZkqqHx_iDiBiDgKiDiFiBfLjFlGiOjKjHpBjCiGiCmM_xHqqkZx_"\t"_xZkqqHx_jFlGiOjKjHpBiCmMiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
		tcpFind = _tcsstr(tsz, _T("\t"));
		// _xZkqqHx_jFlGiOjKjHpBiCkKiCkAiCoJiPoKiNiHiCmNiDfOiDhFiCpAiPmBiLiOiBeC_xHqqkZx_
		if (tcpFind != NULL) *tcpFind = _T('\0');

		iCn = mpCmdToName.find(mii.wID);
		if (iCn != mpCmdToName.end())
		{
			_tcscat(tsz, _T("\t"));
			_tcscat(tsz, (*iCn).second);
		}
		//----- _xZkqqHx_jFmPiKlHiMoDiCmMjFlGiOjKjHpBiCpAiDiBiDgKiDiFiBfLiCmJjAnNjCoI_xHqqkZx_ -----
		mii.cbSize = sizeof(mii);
		mii.dwTypeData = tsz;
		mii.fMask = MIIM_TYPE;
		mii.fType = MFT_STRING;
		mii.cch = _tcslen(mii.dwTypeData);
		SetMenuItemInfo(hMenu, imi, MF_BYPOSITION, &mii);
	}
} // myAddShortcutText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFAddShortcutText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiCmJiDfGiDiHiBfLiDgHiDeKiDgCiDgHiDgFiDeMiDfIiDgHiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFAddShortcutText (HMENU hMenu, BOOL bLeft)
{
	const ACCEL* pAccel;
	long lAccel;
	CString strKey;
	FFGetUserAccelerator(pAccel, lAccel, bLeft);
	map<DWORD, CString> mpCmdToName;
	map<DWORD, CString>::iterator iCn;
	long lC;
	for (lC = 0; lC < lAccel; lC++)
	{
		myAccelToStr(strKey, pAccel[lC].key, pAccel[lC].fVirt);
		iCn = mpCmdToName.find(pAccel[lC].cmd);
		if (iCn == mpCmdToName.end())
		{
			mpCmdToName[pAccel[lC].cmd] = strKey;
		} else
		{
			(*iCn).second += _T(",");
			(*iCn).second += strKey;
		}
	}
	ACCEL accel[100];
	HACCEL hAccel = FFGetMainWnd()->GetWnd()->GetDefaultAccelerator();
	int iAccelSz = ::CopyAcceleratorTable(hAccel, accel, 100);
	for (lC = 0; lC < iAccelSz; lC++)
	{
		myAccelToStr(strKey, accel[lC].key, accel[lC].fVirt);
		iCn = mpCmdToName.find(accel[lC].cmd);
		if (iCn == mpCmdToName.end())
		{
			mpCmdToName[accel[lC].cmd] = strKey;
		} else
		{
			(*iCn).second += _T(",");
			(*iCn).second += strKey;
		}
	}
	myAddShortcutText(hMenu, mpCmdToName);
} // FFAddShortcutText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFShowMsgPanel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDhAiDgMiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwId	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDhAiDgMiDiLiCpAiOkPjFmKiClHiCoJiClNiCnPiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCjDkPiClG_xHqqkZx_
 *					 _xZkqqHx_iDhAiDgMiDiLiCpAjBlBiCkPiCmEjFfMiOkGiClDiClJiCmIiCkCiClNiCnPiCmJjFeLjHhGiBeC_xHqqkZx_
 *			tcpMsg	:_xZkqqHx_jFfMiOkGiClHiCoJiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_dwId_xZkqqHx_iCmFiOhHjCoIiClHiCoJiDiKiDfMiBfLiDfIjFlGiOjKjHpB_xHqqkZx_
 *					 _xZkqqHx_iCpAjFfMiOkGiClHiCoJiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFShowMsgPanel (DWORD dwId, const wchar_t* tcpMsg)
{
	static DWORD	s_dwLastId = DWORD(-1);
	static FDTIME	s_fdtmLast = 0;
	static CPoint	s_ptLast(0,0);

	// _xZkqqHx_iMlLiNnNiCmMiOjOiKnEiBgJ_xHqqkZx_10,000,000_xZkqqHx_jFkKiCmM_xHqqkZx_1_xZkqqHx_jFgCjCfAiImKiBgKiCpAiOoGjDlOiBeC_xHqqkZx_
	FDTIME fdtmNow = FFGetCurrentTime();
	if (FDTIME(fdtmNow - s_fdtmLast) < FDTIME(10000000))
	//----- _xZkqqHx_jBePiJpBiCmMiDhAiDgMiDiLjFfMiOkGiCkJiCoH_xHqqkZx_1_xZkqqHx_jFgCjGkCjGjOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		TRACE(_T("NO\r\n"));
		// _xZkqqHx_jBePiJpBiCmMiDhAiDgMiDiLjFfMiOkGiCkJiCoH_xHqqkZx_1_xZkqqHx_jFgCjGkCjGjOiCmMjDkPiClGiDhAiDgMiDiLiCmIiCoHiCmOiBeBiDhAiDgMiDiLiCpAjFfMiOkGiClJiClIjFjMiLeBiBeC_xHqqkZx_
		if (s_dwLastId == dwId) return;
		// _xZkqqHx_iDhAiDgMiDiLjFfMiOkGiImKjChFiCpAiJlKiCmJiClIiCoHiClHiBeC_xHqqkZx_
		s_ptLast.y += 50;
	} else
	//----- _xZkqqHx_jBePiJpBiCmMiDhAiDgMiDiLjFfMiOkGiCkJiCoH_xHqqkZx_1_xZkqqHx_jFgCiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		TRACE(_T("YES\r\n"));
//----- 06.02.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		//----- _xZkqqHx_iJoGjGmKiCmMiDfEiDeDiDfJiCpAiOoGjDlO_xHqqkZx_ -----
//		HDC hAttribDC = ::CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
//		if (hAttribDC != NULL)
//		{
//			int iDisplayW = GetDeviceCaps(hAttribDC, HORZRES);
//			int iDisplayH = GetDeviceCaps(hAttribDC, VERTRES);
//			::DeleteDC(hAttribDC);
//			//----- _xZkqqHx_iJoGjGmKjCiGiJjLiCpAiBeBiDfPiDeDiDeBiDiNiDePjFfMiOkGiImKjChFiCmMiDgGiDhEiDeIiDiLiDgHiCmJ_xHqqkZx_ -----
//			s_ptLast.x = iDisplayW / 2;
//			s_ptLast.y = iDisplayH / 2;
//		}
//----- 06.02.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iImIjBePiCmNiJoGjGmKjCiGiJjLiCpAiDgGiDhEiDeIiDiLiDgHiCmJiClFiCmEiCkCiClNiCkKiBeB_xHqqkZx_
		// _xZkqqHx_iDhNiDiLiDgAiDiCiDgKiDfOiBfLiCmFiCmNjDkOiNoMiCkKjFmPiBeC_xHqqkZx_
		// _xZkqqHx_iDeBiDhGiDiKiDhEiDiMiBfLiDiAiCmMjCiGiJjLiCpAiDgGiDhEiDeIiDiLiDgHiCmJjAnNjCoIiBeC_xHqqkZx_
		CRect dvrtFrame;
		FFGetMainWnd()->GetWnd()->GetWindowRect(dvrtFrame);
		s_ptLast = dvrtFrame.CenterPoint();
//----- 06.02.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	// static_xZkqqHx_iCmMiPoOjFpBiCpAiNfIjAfGiBeC_xHqqkZx_
	s_dwLastId = dwId;
	s_fdtmLast = fdtmNow;
	//----- _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDhAiDgMiDiLiCmMjFfMiOkG_xHqqkZx_ -----
	WString wstrMessage;
	if (tcpMsg != NULL)
		wstrMessage = tcpMsg;
	else
		wstrMessage.LoadString(dwId);
	WString strArg;
// 06.02.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	strArg.Format(L"x=%d y=%d m=1000 %s", s_ptLast.x, s_ptLast.y, wstrMessage.c_str());
	strArg.Format(	L"x=%d y=%d h=%lu m=1000 %s",
					s_ptLast.x,
					s_ptLast.y,
					FFGetMainWnd()->GetSafeHwnd(),
					wstrMessage.c_str());
	ExecAndWaitApp(L"MsgPanel.exe", strArg, 5000);
} // FFShowMsgPanel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetFileDialogFilterString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCmMiDhEiDeCiDiLiDfOjFlGiOjKjHpBiBgJ_xHqqkZx_m_ofn.lpstrFilter_xZkqqHx_iBgKiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strFilter	:_xZkqqHx_iDhEiDeCiDiLiDfOjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bisSave		:_xZkqqHx_jFnLjBlGiDfPiDeDiDeBiDiNiDePiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetFileDialogFilterString (CString& strFilter, BOOL bIsSave)
{
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiCmMiDhEiDeCiDiLiDfOjFlGiOjKjHpBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	// "Dynamic Draw Standard Format\n.mdrw\nDynamic Draw Portable Format\n.mdpf\n _xZkqqHx_iBeFiBeFiBeF_xHqqkZx_"
	WString wstrFilterName;
	if (!bIsSave)
	//----- _xZkqqHx_jDmHiCnNiNjOiCnNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		wstrFilterName.LoadString(IDS_CTRL_LOAD_SAVE_FILTER);
		//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCmMiDhEiDeCiDiLiDfOjFlGiOjKjHpBiCpAiNoMjAkM_xHqqkZx_ ------
		// _xZkqqHx_jHoB_xHqqkZx_ _xZkqqHx_jFnLjBlGiCmJjBmOiClFiCmEiBeBiClHiCnHiCmEiCmMjFlGiPjBiCmGiBeBiDgPiBfLiDfHiDiHiDjDjGlMiCkKjCmHiJmBiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
		// "_xZkqqHx_iClHiCnHiCmEiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_jFlGiPjB_xHqqkZx_ (*.mdrw;*.mdpf;_xZkqqHx_iBgD_xHqqkZx_)\0*.mdrw;*.mdpf;_xZkqqHx_iBgD_xHqqkZx_\0Dynamic Draw Standard Format 4.0 (*.mdrw)\0
		// *.mdrw\0Dynamic Draw Portable Format 4.0 (*.mdpf)\0*.mdpf\0 _xZkqqHx_iBeFiBeFiBeF_xHqqkZx_\0\0"

		// _xZkqqHx_jBfDiCmEiCmMiDhEiDeAiDeDiDiLiCmMiKgHjCkDiOhBiBeCjHoBiBhF_xHqqkZx_*.mdrw;*.mfdpf;*.mdvf_xZkqqHx_iBhG_xHqqkZx_
		CString strAllExts;
		// _xZkqqHx_iDhEiDeCiDiLiDfOjFlGiOjKjHpBiCpAjAnNjCoIiBeC_xHqqkZx_
		while (!wstrFilterName.IsEmpty())
		{
			WString wstrTypeName = FFExtractUntil(wstrFilterName, L"\n");
			WString wstrExtension = FFExtractUntil(wstrFilterName, L"\n");
			strAllExts += _T('*');
			strAllExts += WStrToTStr(wstrExtension);
			strAllExts += _T(';');
		}
		strAllExts.TrimRight(_T(';'));

		// strFilter += _T("_xZkqqHx_iClHiCnHiCmEiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_ (*.mdrw;*.mdpf)");
		// IDS_CTRL_ALL_DOCUMENT = _xZkqqHx_iClHiCnHiCmEiCmM_xHqqkZx_Dynamic Draw_xZkqqHx_jFlGiPjBiBeC_xHqqkZx_
		strFilter.LoadString(IDS_CTRL_ALL_DOCUMENT);
		strFilter += _T(" (");
		strFilter += strAllExts;
		strFilter += _T(")");
		strFilter += _T('\0');
		strFilter += strAllExts;
		strFilter += _T('\0');
	}

	wstrFilterName.LoadString(IDS_CTRL_LOAD_SAVE_FILTER);
	// _xZkqqHx_iDhEiDeCiDiLiDfOjFlGiOjKjHpBiCpAjAnNjCoIiBeC_xHqqkZx_
	while (!wstrFilterName.IsEmpty())
	{
		WString wstrTypeName = FFExtractUntil(wstrFilterName, L"\n");
		WString wstrExtension = FFExtractUntil(wstrFilterName, L"\n");

		strFilter += WStrToTStr(wstrTypeName);
		strFilter += _T(" (*");
		strFilter += WStrToTStr(wstrExtension);
		strFilter += _T(")");
		strFilter += _T('\0');
		strFilter += _T("*");
		strFilter += WStrToTStr(wstrExtension);
		strFilter += _T('\0');
	}
	strFilter += _T('\0');
} // FFGetFileDialogFilterString.
//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFInitDlgLayout
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmMiPiJiKpKiImKjChFiCmJiCoGiCmBiCmEiBeBiDiMiDeDiDeBiDeFiDgHiPoOjFpB_xHqqkZx_
 *			mpLayoutInfo _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mpLayoutInfo	:_xZkqqHx_iDiMiDeDiDeBiDeFiDgHiPoOjFpBiBeCjAnNjCoIiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			pWnd			:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lControlSize	:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			aControlId		:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmM_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwOffsetFlag	:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkKiDfPiDeDiDeBiDiNiDePiCmMiCmHiCmMjFnDiCmJjCmHiPfNiClHiCoJiCkJ_xHqqkZx_
 *							 _xZkqqHx_iOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FFInitDlgLayout_xZkqqHx_iKnGjAjEiBeB_xHqqkZx_FFInitDlgLayout_xZkqqHx_iKnGjAjEiCmNiBeBiDiKiDfEiDeDiDfJiJmCjEfMiCmI_xHqqkZx_
 *			_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmJiCkIiCkCiCmEiBeBiDiKiDfEiDeDiDfJiOjOiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmMiNmEjEhKjChFiCpA_xHqqkZx_
 *			_xZkqqHx_iOkJjDkOiJlLiClHiCoJiBeC_xHqqkZx_
 *			FFInitDlgLayout_xZkqqHx_iKnGjAjEiCmNiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCmMiNmEjEhKjChFiCmJjFeLjHhGiCmI_xHqqkZx_
 *			_xZkqqHx_iDiMiDeDiDeBiDeFiDgHiPoOjFpBiCpA_xHqqkZx_IdToDlgLayoutRecMap_xZkqqHx_iMfOjFmPjAjEiCmJjChOjAmPiClHiCoJiBeC_xHqqkZx_
 *			FFInitDlg_xZkqqHx_iKnGjAjEiCmNiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCmMiNmEjEhKjChFiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjAhNiCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *
 *             _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *             _xZkqqHx_iEkLiEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkCiEkL_xHqqkZx_
 *             _xZkqqHx_iEkLiEkA_xHqqkZx_                              _xZkqqHx_iEkAiEkL_xHqqkZx_
 *             _xZkqqHx_iEkLiEkA_xHqqkZx_            IDC_A             _xZkqqHx_iEkAiEkL_xHqqkZx_
 *             _xZkqqHx_iEkLiEkA_xHqqkZx_                              _xZkqqHx_iEkAiEkL_xHqqkZx_
 *             _xZkqqHx_iEkLiEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkL_xHqqkZx_
 *             _xZkqqHx_iEkLiEkBiEjPiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEjPiEkCiEkL_xHqqkZx_
 *             _xZkqqHx_iEkLiEkA_xHqqkZx_IDC_B _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_IDC_C _xZkqqHx_iEkAiEkA_xHqqkZx_IDC_D _xZkqqHx_iEkAiEkL_xHqqkZx_
 *             _xZkqqHx_iEkLiEkEiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEkDiEkL_xHqqkZx_
 *             _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_ 
 *                             _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_                 
 *                           _xZkqqHx_iEkBiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkC_xHqqkZx_               
 *                            _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_                
 *                              _xZkqqHx_iBfPiBfO_xHqqkZx_                  
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *          _xZkqqHx_iEkLiEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkCiEkL_xHqqkZx_
 *          _xZkqqHx_iEkLiEkA_xHqqkZx_                                      _xZkqqHx_iEkAiEkL_xHqqkZx_
 *          _xZkqqHx_iEkLiEkA_xHqqkZx_                                      _xZkqqHx_iEkAiEkL_xHqqkZx_
 *          _xZkqqHx_iEkLiEkA_xHqqkZx_                                      _xZkqqHx_iEkAiEkL_xHqqkZx_
 *          _xZkqqHx_iEkLiEkA_xHqqkZx_                 IDC_A                _xZkqqHx_iEkAiEkL_xHqqkZx_
 *          _xZkqqHx_iEkLiEkA_xHqqkZx_                                      _xZkqqHx_iEkAiEkL_xHqqkZx_
 *          _xZkqqHx_iEkLiEkA_xHqqkZx_                                      _xZkqqHx_iEkAiEkL_xHqqkZx_
 *          _xZkqqHx_iEkLiEkA_xHqqkZx_                                      _xZkqqHx_iEkAiEkL_xHqqkZx_
 *          _xZkqqHx_iEkLiEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkL_xHqqkZx_
 *          _xZkqqHx_iEkLiEkBiEjPiEjPiEjPiEkC_xHqqkZx_            _xZkqqHx_iEkBiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEjPiEkCiEkL_xHqqkZx_
 *          _xZkqqHx_iEkLiEkA_xHqqkZx_IDC_B _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_IDC_C _xZkqqHx_iEkAiEkA_xHqqkZx_IDC_D _xZkqqHx_iEkAiEkL_xHqqkZx_
 *          _xZkqqHx_iEkLiEkEiEjPiEjPiEjPiEkD_xHqqkZx_            _xZkqqHx_iEkEiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEkDiEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *
 *			IDC_A_xZkqqHx_iBeGiDfPiDeDiDeBiDiNiDePiCmMiOgMjFpLiCmJiNiHiCoNiClJiCmEiDiKiDfEiDeDiDfJ_xHqqkZx_
 *			IDC_B_xZkqqHx_iBeGiDfPiDeDiDeBiDiNiDePiCmMiNlGiJlKiCmJiNiHiCoNiClJiCmEiInKjDkO_xHqqkZx_
 *			IDC_C_xZkqqHx_iBeGiDfPiDeDiDeBiDiNiDePiCmMiJeFiJlKiCmJiNiHiCoNiClJiCmEiInKjDkO_xHqqkZx_
 *			IDC_D_xZkqqHx_iBeGiDfPiDeDiDeBiDiNiDePiCmMiJeFiJlKiCmJiNiHiCoNiClJiCmEiInKjDkO_xHqqkZx_
 *
 *			_xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiImIiJlKiCmMiCoGiCkEiCmJiBeB_xHqqkZx_FFInitDlgLayout_xZkqqHx_iKnGjAjEiCpAiCfCiJpBiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *			--------------------------------------------------------
 *			OnInitDialog ()
 *			{
 *				const long aId1[] = { IDC_A }
 *				const long aId2[] = { IDC_B }
 *				const long aId3[] = { IDC_C, IDC_D }
 *				FFInitDlgLayout(mpInfo, pWnd, lSize1, aId1,
 *								FCDlgLayoutRec::HOOK_LEFT |
 *								FCDlgLayoutRec::HOOK_TOP |
 *								FCDlgLayoutRec::HOOK_RIGHT |
 *								FCDlgLayoutRec::HOOK_BOTTOM);
 *				FFInitDlgLayout(mpInfo, pWnd, lSize2, aId2,
 *								FCDlgLayoutRec::HOOK_LEFT |
 *								FCDlgLayoutRec::HOOK_BOTTOM);
 *				FFInitDlgLayout(mpInfo, pWnd, lSize3, aId3,
 *								FCDlgLayoutRec::HOOK_RIGHT |
 *								FCDlgLayoutRec::HOOK_BOTTOM);
 *			}
 *			--------------------------------------------------------
 *
 *			_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMiNmEjEhKjChFiCmNiImIiJlKiCmMiCoGiCkEiCmJ_xHqqkZx_FFDlgLayout_xZkqqHx_iKnGjAjEiCpAiCfAiJpBiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *			--------------------------------------------------------
 *			OnSize (int cx, int cy)
 *			{
 *				FFDlgLayout(mpInfo, pWnd, CSize(cx, cy));
 *			}
 *			--------------------------------------------------------
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFInitDlgLayout (	IdToDlgLayoutRecMap& mpLayoutInfo,
						const CWnd* pWnd,
						long lControlSize,
						const long aControlId[],
						DWORD dwOffsetFlag)
{
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiDfIiDeOiDiKiBfLiDjDiNmAjFfHiMgOiCmFiOoGjDlOiBeC_xHqqkZx_
	CRect rtClient;
	pWnd->GetClientRect(rtClient);
	pWnd->ClientToScreen(rtClient);
	long lC;
	for (lC = 0; lC != lControlSize; lC++)
	{
		FCDlgLayoutRec rec(dwOffsetFlag, CRect(LONG_MAX, LONG_MAX, LONG_MAX, LONG_MAX));
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMiDeFiDeCiDjDiDgIiDeFjHmMiIoGiCpAiDfIiDeOiDiKiBfLiDjDiNmAjFfHiMgOiCmFiOoGjDlOiBeC_xHqqkZx_
		CRect rtControl;
		pWnd->GetDlgItem(aControlId[lC])->GetWindowRect(rtControl);
		if (dwOffsetFlag & FCDlgLayoutRec::HOOK_LEFT)
			rec.m_rtOffset.left = rtControl.left - rtClient.left;
		if (dwOffsetFlag & FCDlgLayoutRec::HOOK_TOP)
			rec.m_rtOffset.top = rtControl.top - rtClient.top;
		if (dwOffsetFlag & FCDlgLayoutRec::HOOK_RIGHT)
			rec.m_rtOffset.right = rtClient.right - rtControl.right;
		if (dwOffsetFlag & FCDlgLayoutRec::HOOK_BOTTOM)
			rec.m_rtOffset.bottom = rtClient.bottom - rtControl.bottom;
		mpLayoutInfo[aControlId[lC]] = rec;
	}
} // FFInitDlgLayout.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFDlgLayout
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCpAiNmEjEhKjChFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mpLayoutInfo	:_xZkqqHx_iDiMiDeDiDeBiDeFiDgHiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pWnd			:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szWnd			:_xZkqqHx_jAfGiClFiCkCiDfPiDeDiDeBiDiNiDePiDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJiCpAiOhHjCoI_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FFInitDlgLayout_xZkqqHx_iKnGjAjEiBeB_xHqqkZx_FFInitDlgLayout_xZkqqHx_iKnGjAjEiCmNiBeBiDiKiDfEiDeDiDfJiJmCjEfMiCmI_xHqqkZx_
 *			_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmJiCkIiCkCiCmEiBeBiDiKiDfEiDeDiDfJiOjOiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmMiNmEjEhKjChFiCpA_xHqqkZx_
 *			_xZkqqHx_iOkJjDkOiJlLiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iPnKiClFiCkNiCmN_xHqqkZx_FFInitDlgLayout_xZkqqHx_iKnGjAjEiCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFDlgLayout (	const IdToDlgLayoutRecMap& mpLayoutInfo,
					CWnd* pWnd,
					const CSize& szWnd)
{
	const CRect rtClient(0, 0, szWnd.cx, szWnd.cy);

	IdToDlgLayoutRecMap::const_iterator iInfo;
	for (iInfo = mpLayoutInfo.begin(); iInfo != mpLayoutInfo.end(); iInfo++)
	{
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMiLoJiMgAiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
		CRect rtControl;
		pWnd->GetDlgItem(iInfo->first)->GetClientRect(rtControl);
		const CSize szControl(rtControl.Width(), rtControl.Height());
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMiLoJiMgAiCpAjAnNjCoIiBeC_xHqqkZx_
		rtControl.SetRect(LONG_MAX, LONG_MAX, LONG_MAX, LONG_MAX);
		if (iInfo->second.m_rtOffset.left != LONG_MAX)
			rtControl.left = rtClient.left + iInfo->second.m_rtOffset.left;
		if (iInfo->second.m_rtOffset.top != LONG_MAX)
			rtControl.top = rtClient.top + iInfo->second.m_rtOffset.top;
		if (iInfo->second.m_rtOffset.right != LONG_MAX)
			rtControl.right = rtClient.right - iInfo->second.m_rtOffset.right;
		if (iInfo->second.m_rtOffset.bottom != LONG_MAX)
			rtControl.bottom = rtClient.bottom - iInfo->second.m_rtOffset.bottom;
		// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmMiNmAjFfHiCpAjFoCjAlDiBeC_xHqqkZx_
		if (rtControl.left == LONG_MAX)
			rtControl.left = rtControl.right - szControl.cx;
		else
		if (rtControl.right == LONG_MAX)
			rtControl.right = rtControl.left + szControl.cx;
		if (rtControl.top == LONG_MAX)
			rtControl.top = rtControl.bottom - szControl.cy;
		else
		if (rtControl.bottom == LONG_MAX)
			rtControl.bottom = rtControl.top + szControl.cy;
		pWnd->GetDlgItem(iInfo->first)->MoveWindow(rtControl, FALSE);
	}
	pWnd->Invalidate();
} // FFDlgLayout.
