/*************************************************************************
 * <_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_> UtilErr.cpp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_> _xZkqqHx_iDeHiDiJiBfLiKnGjIeBiCmMiDgDiBfLiDiLiPfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_> 99.02.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/

#include "stdafx.h"
#include <errno.h>				// For errno_xZkqqHx_jCoIjAjEiBeC_xHqqkZx_
#include "resource.h"			// For IDS_ERR_XXX.
#include "DynamicDrawView.h"	// For g_pView.
//----------<NOT EXPORT TO VIEWER>-----------
#include "DlgMessageBox.h"		// For CFCDlgMessageBox.
//----------</NOT EXPORT TO VIEWER>-----------
#include "DlgImageMessageBox.h"	// For CFCDlgImageMessageBox.
#include "DynamicDb.h"			// For g_pFileServer.
#include "DlgDebugOut.h"		// For CFCDlgDebugOut.
#include "FrameWnd.h"			// For FFGetMainWnd().
#include "UtilErr.h"			// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static DWORD			s_dwErrorCode = 0;			// _xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
static WString			s_wstrErrorMessage;			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
static auto_ptr<CFCDlgDebugOut>	s_autoDlgDebugOut;	// _xZkqqHx_iDiKiDiKiBfLiDfIiOjOiCmMiDeBiDeFiDgHiDhGiDgCiDgHiBeC_xHqqkZx_

///////////////////////////////////////////////////////////////////////////////
// CFCDDFileException _xZkqqHx_iDeOiDiJiDfIiDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

IMPLEMENT_DYNCREATE(CFCDDFileException, CFileException)

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDDFileException::CFCDDFileException
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCode		:_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFilePath	:_xZkqqHx_iDeHiDiJiBfLjEkNjAlGiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 04.10.08 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//CFCDDFileException::CFCDDFileException (FTFileErrType nCode, const wchar_t* wcpFilePath)
CFCDDFileException::CFCDDFileException (DWORD dwCode, const wchar_t* wcpFilePath)
				: CFileException (CFileException::generic, -1)
{
	// _xZkqqHx_iDeOiDiJiDfIiMmFjHeMiCmMiDeHiDiJiBfLiDfCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
	m_dwErrCode = dwCode;
	// CFileException_xZkqqHx_iCmMiDhEiDeAiDeDiDiLjGlMiCpAjAnNjCoIiBeC_xHqqkZx_
	if (wcpFilePath != NULL) m_strFileName = WStrToTStr(wcpFilePath);
//	m_strArg = wcpArg;
} // CFCDDFileException::CFCDDFileException.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDDFileException::GetErrorMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEkNjAlGiClFiClNiDeHiDiJiBfLiCmJiKnGiClHiCoJiDgFiDeMiDfIiDgHiCpAjCpBiLjPiClFiCnMiClHiBeCiClNiCmGiCkGiCmOiBeB_xHqqkZx_
 *			GetErrorMessage _xZkqqHx_iCpAiMmEiCnBiPgPiClFiCmEiBeB_xHqqkZx_CFile _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmJiPjBiCkLiNjOiCnNjCiGiCmJ_xHqqkZx_
 *			MFC _xZkqqHx_iCkK_xHqqkZx_ CFileException _xZkqqHx_iCpAiDfIiDiNiBfLiClHiCoJiMlEiIpGiCmGiCmIiCmBiClNiDeHiDiJiBfLiCpA_xHqqkZx_
 *			_xZkqqHx_jAoAjGlOiClHiCoJjFlGiOjKjHpBiCpAiOoGjDlOiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpszError	:_xZkqqHx_iDeHiDiJiBfL_xHqqkZx_ _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiCnGiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nMaxError	:_xZkqqHx_iDgPiDgCiDhEiDeAiCmJjFnLiOjNiCmFiCkLiCoJiNmFjBoFjFlGiOjKjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_jFlGiOjKjHpBiCmMiPeJiCoNiCoIiCpAiOkGiClH_xHqqkZx_ NULL _xZkqqHx_jFlGiOjKiCoAiKnMiCnNiCnMiClHiBeC_xHqqkZx_
 *			pnHelpContext:_xZkqqHx_iDhHiDiLiDhG_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_ ID _xZkqqHx_iCpAiOpDiCkPiOoGiCoJ_xHqqkZx_ UINT _xZkqqHx_iMfOjFmPjAjEiCmM_xHqqkZx_
 *						 _xZkqqHx_iDeBiDgIiDiMiDfIiCpAiOhHjCoIiBeC_xHqqkZx_NULL _xZkqqHx_iCmMiCmGiCkLiCmNiBeB_xHqqkZx_ID _xZkqqHx_iCmNjFnEiClDiCoKiCnMiClJiCpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiPeJjHlJiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iImIiKePiCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	GetErrorMessage _xZkqqHx_iCmNiDgPiDgCiDhEiDeAiCmJ_xHqqkZx_ nMaxError -1 _xZkqqHx_jFlGiOjKiCpAiJhKiCkGiCoJjFlGiOjKjHpBiCpA_xHqqkZx_
 *			_xZkqqHx_iDfCiDhDiBfLiClFiCnMiClJiCpBiBeCjFlGiOjKjHpBiCmMiNmFiMoDiCmJiCmNiPoNiCmJ_xHqqkZx_ NULL _xZkqqHx_jFlGiOjKiCpAjFhEiJmBiClFiCnMiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiPkMiClDiClHiCkMiCoJiCmGiCkLiCmNiBeBjFlGiOjKjHpBiCmNjAnIiCoIiLgMiCnPiCoHiCoKiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDDFileException::GetErrorMessage (LPTSTR lpszError, UINT nMaxError, PUINT pnHelpContext)
{
//----- 04.10.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//#define MYERRCASE(x) \
//	case FDERR_##x: \
//		strMsg.LoadString(IDS_ERR_##x); \
//		break; \
//
//	CString strMsg;
//	switch (m_nErrCode)
//	{
//MYERRCASE(FILE_NONE)
//MYERRCASE(FILE_UNKNOWN)
//MYERRCASE(FILE_WRONG_FORM)
//MYERRCASE(FILE_WRONG_VERSION)
//MYERRCASE(FILE_DESTROIED)
//MYERRCASE(FILE_WRONG_NAME)
//MYERRCASE(FILE_NOT_UNIQ_NAME)
//MYERRCASE(FILE_NOT_CREATE_DIRECTORY)
//MYERRCASE(ERRNO_E2BIG)
//MYERRCASE(ERRNO_EACCES)
//MYERRCASE(ERRNO_EAGAIN)
//MYERRCASE(ERRNO_EBADF)
//MYERRCASE(ERRNO_ECHILD)
//MYERRCASE(ERRNO_EDEADLOCK)
//MYERRCASE(ERRNO_EDOM)
//MYERRCASE(ERRNO_EEXIST)
//MYERRCASE(ERRNO_EINVAL)
//MYERRCASE(ERRNO_EMFILE)
////MYERRCASE(ERRNO_ENOENT)
//MYERRCASE(ERRNO_ENOEXEC)
//MYERRCASE(ERRNO_ENOMEM)
//MYERRCASE(ERRNO_ENOSPC)
//MYERRCASE(ERRNO_ERANGE)
//MYERRCASE(ERRNO_EXDEV)
//	default:	// etc.
//		strMsg.LoadString(IDS_ERR_FILE_UNKNOWN);
//		break;
//	}
//#undef MYERRCASE
//----- 04.10.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	CString strMsg;
	strMsg.LoadString(m_dwErrCode);
//----- 04.10.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	if (!m_strFileName.IsEmpty())
	{
		if (!strMsg.IsEmpty()) strMsg += _T(":");
		strMsg += m_strFileName;
	}

	// _xZkqqHx_jFlGiOjKjHpBjClHiBgJiPeJjCfLiCpAiKnMiCnOiBgKiCpAjAnNjCoIiBeC_xHqqkZx_
	int nMaxLen = strMsg.GetLength() + 1;
	if (nMaxError < nMaxLen) nMaxLen = nMaxError;
	// _xZkqqHx_iPeJjCfLjFkKiCpAiMlIiCoHiClHiBeC_xHqqkZx_
	nMaxLen--;
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	_tcsncpy(lpszError, strMsg, nMaxLen);
	lpszError[nMaxLen] = _T('\0');
	// _xZkqqHx_iDhHiDiLiDhGiDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_ID_xZkqqHx_iCmJ_xHqqkZx_0_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	if (pnHelpContext != NULL) *pnHelpContext = 0;
	return TRUE;
} // CFCDDFileException::GetErrorMessage.

//----- 04.10.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDDFileException::ErrnoToErrType
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiDfIiDgFiDiAiCkK_xHqqkZx_errno_xZkqqHx_iCmJjAnNjCoIiClHiCoJiDeHiDiJiBfLiCpAiBeB_xHqqkZx_FTFileErrType_xZkqqHx_iCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iErrno	:nerrno_xZkqqHx_iCmMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FTFileErrType_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFileException::ErrnoToException_xZkqqHx_iCmFiCoAjFmPiKlHiCmFiCkLiCoJiCkKiBeBiDeHiDiJiBfLiCmM_xHqqkZx_
// *			_xZkqqHx_iDfEiDhMiBfLiDgHiCkKiPkNiCmIiCkCiCmMiCmFjAfGiClNiCmJiNoMjAkMiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTFileErrType CFCDDFileException::ErrnoToErrType (int iErrno)
//{
//#define MYERRCASE(x) \
//	case x: \
//		return FDERR_ERRNO_##x;
//
//	switch (iErrno)
//	{
//MYERRCASE(E2BIG)
//MYERRCASE(EACCES)
//MYERRCASE(EAGAIN)
//MYERRCASE(EBADF)
//MYERRCASE(ECHILD)
//MYERRCASE(EDEADLOCK)
//MYERRCASE(EDOM)
//MYERRCASE(EEXIST)
//MYERRCASE(EINVAL)
//MYERRCASE(EMFILE)
//MYERRCASE(ENOENT)
//MYERRCASE(ENOEXEC)
//MYERRCASE(ENOMEM)
//MYERRCASE(ENOSPC)
//MYERRCASE(ERANGE)
//MYERRCASE(EXDEV)
//	default:
//		return FDERR_FILE_UNKNOWN;
//	}
//
//#undef MYERRCASE
//} // CFCDDFileException::ErrnoToErrType.
//----- 04.10.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

///////////////////////////////////////////////////////////////////////////////
// CFCMiscException _xZkqqHx_iDeOiDiJiDfIiDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

IMPLEMENT_DYNCREATE(CFCMiscException, CException)

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMiscException::CFCMiscException
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_CException _xZkqqHx_iCpAiMhAiPlDiClHiCoJiClNiCnPiCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCMiscException::CFCMiscException ()
					:CException(TRUE)
{
	m_dwMessageId = DWORD(-1);
} // CFCMiscException::CFCMiscException.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMiscException::CFCMiscException
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwMessageId	:_xZkqqHx_iDfIiDgHiDiKiDjDiDePiDiKiDfMiBfLiDfIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiDhEiDeIiBfLiDhNiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			...			:dwMessageId_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJiDhEiDeIiBfLiDhNiDgCiDgHiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCMiscException::CFCMiscException (DWORD dwMessageId, ...)
					:CException(TRUE)
{
	m_dwMessageId = dwMessageId;
	//----- _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmMjFlGiOjKjHpBiCpAjBgHiCnNjHkHiCmEiCoJ_xHqqkZx_ -----
	WString wstrFormat;
	(void)wstrFormat.LoadString(dwMessageId);
	va_list argList;
	va_start(argList, dwMessageId);
	m_strMsg.FormatV(wstrFormat.c_str(), argList);
	va_end(argList);
} // CFCMiscException::CFCMiscException.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMiscException::GetErrorMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEkNjAlGiClFiClNiDeHiDiJiBfLiCmJiKnGiClHiCoJiDgFiDeMiDfIiDgHiCpAjCpBiLjPiClFiCnMiClHiBeCiClNiCmGiCkGiCmOiBeB_xHqqkZx_
 *			GetErrorMessage _xZkqqHx_iCpAiMmEiCnBiPgPiClFiCmEiBeB_xHqqkZx_MFC _xZkqqHx_iCkK_xHqqkZx_ CException _xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_iDfIiDiNiBfLiClHiCoJiMlEiIpGiCmGiCmIiCmBiClNiDeHiDiJiBfLiCpAjAoAjGlOiClHiCoJjFlGiOjKjHpBiCpAiOoGjDlOiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpszError	:_xZkqqHx_iDeHiDiJiBfL_xHqqkZx_ _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiCnGiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nMaxError	:_xZkqqHx_iDgPiDgCiDhEiDeAiCmJjFnLiOjNiCmFiCkLiCoJiNmFjBoFjFlGiOjKjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_jFlGiOjKjHpBiCmMiPeJiCoNiCoIiCpAiOkGiClH_xHqqkZx_ NULL _xZkqqHx_jFlGiOjKiCoAiKnMiCnNiCnMiClHiBeC_xHqqkZx_
 *			pnHelpContext:_xZkqqHx_iDhHiDiLiDhG_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_ ID _xZkqqHx_iCpAiOpDiCkPiOoGiCoJ_xHqqkZx_ UINT _xZkqqHx_iMfOjFmPjAjEiCmM_xHqqkZx_
 *						 _xZkqqHx_iDeBiDgIiDiMiDfIiCpAiOhHjCoIiBeC_xHqqkZx_NULL _xZkqqHx_iCmMiCmGiCkLiCmNiBeB_xHqqkZx_ID _xZkqqHx_iCmNjFnEiClDiCoKiCnMiClJiCpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiPeJjHlJiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iImIiKePiCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	GetErrorMessage _xZkqqHx_iCmNiDgPiDgCiDhEiDeAiCmJ_xHqqkZx_ nMaxError -1 _xZkqqHx_jFlGiOjKiCpAiJhKiCkGiCoJjFlGiOjKjHpBiCpA_xHqqkZx_
 *			_xZkqqHx_iDfCiDhDiBfLiClFiCnMiClJiCpBiBeCjFlGiOjKjHpBiCmMiNmFiMoDiCmJiCmNiPoNiCmJ_xHqqkZx_ NULL _xZkqqHx_jFlGiOjKiCpAjFhEiJmBiClFiCnMiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiPkMiClDiClHiCkMiCoJiCmGiCkLiCmNiBeBjFlGiOjKjHpBiCmNjAnIiCoIiLgMiCnPiCoHiCoKiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMiscException::GetErrorMessage (LPTSTR lpszError, UINT nMaxError, PUINT pnHelpContext)
{
//----- 03.03.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//#define MYERRCASE(x) \
//	case FDERR_##x: \
//		strMsg.LoadString(IDS_ERR_##x); \
//		break;
//
//	CString strMsg;
//	switch (m_nErrCode)
//	{
//MYERRCASE(MISC_NONE)
//MYERRCASE(MISC_UNKNOWN)
//// MYERRCASE(MISC_OTHER) MISC_OTHER _xZkqqHx_iCmMiDiBiDgCiDfKiBfLiDfHiCmNiBeB_xHqqkZx_wcpAddMsg_xZkqqHx_iCmMiCnNiBeC_xHqqkZx_
//MYERRCASE(RES_TIMER_EXHAUST)
//MYERRCASE(ENV_NO_ENVVAR)
//MYERRCASE(SYNTAX_ERROR)
//	}
//#undef MYERRCASE
//	if (!m_strAddMsg.IsEmpty())
//	{
//		if (!strMsg.IsEmpty()) strMsg += _T(":");
//		strMsg += WStrToTStr(m_strAddMsg);
//	}
//	// _xZkqqHx_jFlGiOjKjHpBjClHiBgJiPeJjCfLiCpAiKnMiCnOiBgKiCpAjAnNjCoIiBeC_xHqqkZx_
//	int nMaxLen = strMsg.GetLength() + 1;
//	if (nMaxError < nMaxLen) nMaxLen = nMaxError;
//	// _xZkqqHx_iPeJjCfLjFkKiCpAiMlIiCoHiClHiBeC_xHqqkZx_
//	nMaxLen--;
//	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//	_tcsncpy(lpszError, strMsg, nMaxLen);
//	lpszError[nMaxLen] = _T('\0');
//	// _xZkqqHx_iDhHiDiLiDhGiDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_ID_xZkqqHx_iCmJ_xHqqkZx_0_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//	if (pnHelpContext != NULL) *pnHelpContext = 0;
//	return TRUE;
//----- 03.03.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	CString strMsg = WStrToTStr(m_strMsg);
	// _xZkqqHx_jFlGiOjKjHpBjClHiBgJiPeJjCfLiCpAiKnMiCnOiBgKiCpAjAnNjCoIiBeC_xHqqkZx_
	int nMaxLen = strMsg.GetLength() + 1;
	if (nMaxError < nMaxLen) nMaxLen = nMaxError;
	// _xZkqqHx_iPeJjCfLjFkKiCpAiMlIiCoHiClHiBeC_xHqqkZx_
	nMaxLen--;
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	_tcsncpy(lpszError, strMsg, nMaxLen);
	lpszError[nMaxLen] = _T('\0');
	// _xZkqqHx_iDhHiDiLiDhGiDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_ID_xZkqqHx_iCmJ_xHqqkZx_0_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	if (pnHelpContext != NULL) *pnHelpContext = 0;
	return TRUE;
//----- 03.03.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMiscException::GetErrorMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMiscException::GetMessageId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD CFCMiscException::GetMessageId () const
{
	return m_dwMessageId;
} // CFCMiscException::GetMessageId.

///////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDePiDiNiBfLiDgPiDiLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFResetDDError
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DD_xZkqqHx_iDeHiDiJiBfLiCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DD_xZkqqHx_iDeHiDiJiBfLiCmNiBeBiImIiJlKiCmMiCfBjCgJiKeLiCmJjDgOiCmBiCmEjClCiCnHiCoHiCoKiCoJiBeC_xHqqkZx_
 *			DDError -> FCDynamicDb
 *			_xZkqqHx_iPfNiCmBiCmEiBeBiDeHiDiJiBfLiCmMiDiKiDfKiDgCiDgHiCoAiCfBjCgJiKeLiCmJjBmOiClFiCmEiNhDiCoNiCoKiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFResetDDError ()
{
	s_dwErrorCode = 0;			// _xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	s_wstrErrorMessage.Empty();	// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
	// FCDynamicDb _xZkqqHx_iCmMiDeHiDiJiBfLiCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
	g_pFileServer->ResetError();
} // FFResetDDError.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSetDDErrorCodeMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DD_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiCmGiDiBiDgCiDfKiBfLiDfHjFlGiOjKjHpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwErrCode		:_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpErrMessage	:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSetDDErrorCodeMessage (DWORD dwErrCode, const wchar_t* wcpErrMessage)
{
	s_dwErrorCode = dwErrCode;			// _xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	s_wstrErrorMessage = wcpErrMessage;	// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
} // FFSetDDErrorCodeMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSetDDError
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DD_xZkqqHx_iDeHiDiJiBfLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwMessageId	:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_IDS_XXX_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSetDDError (DWORD dwMessageId, ...)
{
	s_dwErrorCode = dwMessageId;
	WString wstrForm;
	wstrForm.LoadString(dwMessageId);
	va_list argList;
	va_start(argList, dwMessageId);
	s_wstrErrorMessage.FormatV(wstrForm.c_str(), argList);
	va_end(argList);
} // FFSetDDError.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetDDErrorCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiOmAiNhDiClFiClNiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBePiJpBiOmAiNhDiClFiClNiOmAiNhDiMiLiJmKiBeCiDeHiDiJiBfLiCkKjGlDiCkCiPoKiNiHiCmNiCePiBeB_xHqqkZx_
 *			_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ IDS_ERR_XXX _xZkqqHx_iCkKjFnEiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FFGetDDErrorCode ()
{
	if (s_dwErrorCode != 0)
		return s_dwErrorCode;
	else
		return g_pFileServer->GetErrorCode();
} // FFGetDDErrorCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetDDErrorMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiOmAiNhDiClFiClNiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBePiJpBiOmAiNhDiClFiClNiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetDDErrorMessage ()
{
	if (s_dwErrorCode != 0)
		return s_wstrErrorMessage;
	else
		return g_pFileServer->GetErrorMessage();
} // FFGetDDErrorMessage.

//----- 04.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetErrorMessage
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pE			:_xZkqqHx_jHoBiKePiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lpszError	:_xZkqqHx_iDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeCiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
// *			nMaxError	:lpszError_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pnHelpContext:_xZkqqHx_jFmPjAjEiCmMiDeBiDgIiDiMiDfIiCpAiOhHjCoIiBeCiDhHiDiLiDhGiDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiOoGjDlOiCmMjAkMjEnLiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FFGetErrorMessage (CException* pE, wchar_t* lpszError, UINT nMaxError,
//						PUINT pnHelpContext)
//{
//#if defined(_MBCS)
//	astring astrBuff(nMaxError * sizeof(lpszError[0]), '\0');
//	BOOL bRet = pE->GetErrorMessage(astrBuff.begin(), astrBuff.size(), pnHelpContext);
//	wcsncpy(lpszError, TStrToWStr(astrBuff.begin()), nMaxError);
//	return bRet;
//#elif defined(_UNICODE)
//	return pE->GetErrorMessage(lpszError, nMaxError, pnHelpContext);
//#endif//_UNICODE
//} // FFGetErrorMessage.
//----- 04.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetErrorMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pE				:_xZkqqHx_jHoBiKePiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pnHelpContext	:_xZkqqHx_jFmPjAjEiCmMiDeBiDgIiDiMiDfIiCpAiOhHjCoIiBeCiDhHiDiLiDhGiDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetErrorMessage (CException* pE, PUINT pnHelpContext)
{
	TCHARVector vBuff(1000);
	for (;;)
	{
		// _xZkqqHx_jGjGjEpGiCmMiIoKiCmCjBePiCmJiLpDjFlGiOjKiCpAiDfKiDgCiDgHiClFiCmEiCkIiCkNiBeC_xHqqkZx_
		vBuff.at(vBuff.size() - 2) = _T('\0');
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAiOoGjDlOiBeC_xHqqkZx_
		if (!pE->GetErrorMessage(&vBuff.at(0), vBuff.size(), pnHelpContext))
			return WString();
		// _xZkqqHx_jGjGjEpGiCmMiIoKiCmCjBePiCkKjGiEiCnMiCmBiCmEiCkCiCmIiCkPiCoKiCmOiBeBiDgPiDgCiDhEiDeAiCmNiPfMjFkKiBeC_xHqqkZx_
		if (vBuff.at(vBuff.size() - 2) == _T('\0')) break;
		// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjEhLiCmJiKgHjCkDiBeC_xHqqkZx_
		vBuff.resize(vBuff.size() * 2);
	}
	return TStrToWStr(&vBuff.at(0));
} // FFGetErrorMessage.
//----- 04.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetErrorCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pE	:_xZkqqHx_jHoBiKePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHoBiKePiCkK_xHqqkZx_CFCDDFileException_xZkqqHx_iBeB_xHqqkZx_CFCMiscException_xZkqqHx_iCmMiPoKiNiHiCmNiDfCiBfLiDgIiCpA_xHqqkZx_
 *			_xZkqqHx_iOoGjDlOiCmFiCkLiCoJiBeCiClLiCoKiImIiKePiCmMiPoKiNiHiCmNiBeB_xHqqkZx_IDS_ERR_MISC_UNKNOWN_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FFGetErrorCode (CException* pE)
{
	if (pE->IsKindOf(RUNTIME_CLASS(CFCDDFileException)))
	//----- CFCDDFileException_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		CFCDDFileException* e = (CFCDDFileException*)pE;
		return e->m_dwErrCode;
	} else
	if (pE->IsKindOf(RUNTIME_CLASS(CFCMiscException)))
	//----- CFCMiscException_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		CFCMiscException* e = (CFCMiscException*)pE;
		return e->GetMessageId();
	} else
	{
		return IDS_ERR_MISC_UNKNOWN;
	}
} // FFGetErrorCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFThrowFileException
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FileException_xZkqqHx_iCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	AfxThrowFileException_xZkqqHx_iCmMiIpIjAjEiCmGjDkPiClGiBeC_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFThrowFileException (int cause, LONG lOsError, const wchar_t* lpszFileName)
{
// 06.03.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	AfxDebugBreak();
	AfxThrowFileException(cause, lOsError, WStrToTStr(lpszFileName));
} // FFThrowFileException.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFThrowDDFileException
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CFCDDFileException _xZkqqHx_iCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCode		:_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpFilePath	:_xZkqqHx_iDeHiDiJiBfLjEkNjAlGiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFThrowDDFileException (DWORD  dwCode,
							const wchar_t* wcpFilePath)
{
// 06.03.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	AfxDebugBreak();
	throw new CFCDDFileException(dwCode, wcpFilePath);
} // FFThrowDDFileException.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFThrowMiscExceptionCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CFCMiscException_xZkqqHx_iCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwMessageId	:_xZkqqHx_iDfIiDgHiDiKiDjDiDePiDiKiDfMiBfLiDfIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiDhEiDeIiBfLiDhNiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DynamicDraw_xZkqqHx_jGhLjBmMiCmFiCmN_xHqqkZx_ FFThrowMiscException_xZkqqHx_iKnGjAjEiCmFiCkCiCkCiCmMiClOiCkKiBeB_xHqqkZx_
 *			SDK_xZkqqHx_iCmFiCmN_xHqqkZx_ ... _xZkqqHx_iCkKiOgHiCkGiCmIiCkCiCmMiCmFiClBiCmMiKnGjAjEiCpAjHhAiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFThrowMiscExceptionCode (DWORD dwMessageId)
{
	CFCMiscException* pMisc = new CFCMiscException();
	pMisc->m_dwMessageId = dwMessageId;
	pMisc->m_strMsg.LoadString(dwMessageId);
	throw pMisc;
} // FFThrowMiscExceptionCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFThrowMiscException
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CFCMiscException_xZkqqHx_iCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwMessageId	:_xZkqqHx_iDfIiDgHiDiKiDjDiDePiDiKiDfMiBfLiDfIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiDhEiDeIiBfLiDhNiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			...			:dwMessageId_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJiDhEiDeIiBfLiDhNiDgCiDgHiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFThrowMiscException (DWORD dwMessageId, ...)
{
//	AfxDebugBreak();
	CFCMiscException* pMisc = new CFCMiscException();
	pMisc->m_dwMessageId = dwMessageId;
	//----- _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmMjFlGiOjKjHpBiCpAjBgHiCnNjHkHiCmEiCoJ_xHqqkZx_ -----
	WString wstrFormat;
	(void)wstrFormat.LoadString(dwMessageId);
	va_list argList;
	va_start(argList, dwMessageId);
	pMisc->m_strMsg.FormatV(wstrFormat.c_str(), argList);
	va_end(argList);
	throw pMisc;
} // FFThrowMiscException.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFThrowMiscException
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CFCMiscException_xZkqqHx_iCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpMessage	:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmMiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	PlugIn_xZkqqHx_iMpGiKeKjHhAiBeC_xHqqkZx_MessageId_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmIiCkCiClNiCnPiBeB_xHqqkZx_DynamicDraw_xZkqqHx_jGhLjBmMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iOgHiCoNiCmIiCkCiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCkJiCoH_xHqqkZx_CFCMiscException_xZkqqHx_iCpAjEkNjAlGiClDiClJiCoJiPoKiNiHiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFThrowMiscException (const wchar_t* wcpMessage)
{
// 06.03.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	AfxDebugBreak();
	CFCMiscException* pMisc = new CFCMiscException();
	pMisc->m_strMsg = wcpMessage;
	throw pMisc;
} // FFThrowMiscException.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFThrowMiscLastError
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetLastError_xZkqqHx_iKnGjAjEiCkKjFnEiClHiDeHiDiJiBfLiCpAiBeB_xHqqkZx_CFCMiscException_xZkqqHx_jHoBiKePiCmGiClFiCmE_xHqqkZx_
 *			_xZkqqHx_iDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFThrowMiscLastError ()
{
// 06.03.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	AfxDebugBreak();
	// GetLastError _xZkqqHx_iCkKjFnEiClHiDfCiBfLiDgIiCpAjFlGiOjKjHpBiJlLiClHiCoJiBeC_xHqqkZx_
	LPTSTR lpMsgBuf;
	::FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | 
					FORMAT_MESSAGE_FROM_SYSTEM | 
					FORMAT_MESSAGE_IGNORE_INSERTS,
					NULL,
					GetLastError(),
					MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
					(LPTSTR)&lpMsgBuf,
					0,
					NULL);
	CFCMiscException* pMisc = new CFCMiscException();
	pMisc->m_strMsg = TStrToWStr(lpMsgBuf);
	// Free the buffer.
	LocalFree(lpMsgBuf);
	throw pMisc;
} // FFThrowMiscLastError.

//----- 05.11.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFThrowUserException
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiClFiClNiMoDiBeB_xHqqkZx_CUserException_xZkqqHx_iCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpMessage	:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmMiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCiDiBiDgCiDfKiBfLiDfHiCpA_xHqqkZx_
// *						 _xZkqqHx_jFfMiOkGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CUserException_xZkqqHx_iCpAjEkNjAlGiClDiClJiCoJiPoKiNiHiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
// *			CUserException_xZkqqHx_iCmNiDiGiBfLiDfFiCkKiPiIjHjNiClHiCnHiCkLjHoBiKePiCmFiCkAiCoJiBeCiClBiCmMiClNiCnPiBeB_xHqqkZx_
// *			CUserException_xZkqqHx_iCkKjEkNjAlGiClFiClNiPoKiNiHiBeBjCmKiPoNiCmN_xHqqkZx_MFC_xZkqqHx_jDoAjFjEiCmFiCmNiDiBiDgCiDfKiBfLiDfHiCmM_xHqqkZx_
// *			_xZkqqHx_jFfMiOkGiCmNiClFiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFThrowUserException (const wchar_t* wcpMessage)
//{
//	if (wcpMessage != NULL)
//		FFErrorBox(wcpMessage);
//	AfxThrowUserException();
//} // FFThrowUserException.
//----- 05.11.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFThrowMiscUserException
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiClFiClNiMoDiBeB_xHqqkZx_CFCMiscException_xZkqqHx_iCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwMessageId	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpMessage	:_xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmMiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmKiPoN_xHqqkZx_CFCMiscException_xZkqqHx_iCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iCpAiDiKiDfMiBfLiDfI_xHqqkZx_ID_xZkqqHx_iCmGiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHjFlGiOjKjHpBiCpAiMlDiCmJiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjBgHiCnNjHkHiCmEiCoJiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iCmGiKnGiMfHiCmIiCkNiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiClHiCoJiPoKiNiHiCmJ_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCpAjHhAiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFThrowMiscUserException (DWORD dwMessageId, const wchar_t* wcpMessage)
{
// 06.03.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	AfxDebugBreak();
	CFCMiscException* pMisc = new CFCMiscException();
	pMisc->m_dwMessageId = dwMessageId;
	pMisc->m_strMsg = wcpMessage;
	throw pMisc;
} // FFThrowMiscUserException.
//----- 05.11.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFMessageBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDmGiOkJiCmMiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwText		:_xZkqqHx_iDgFiDeMiDfIiDgHjFlGiOjKjHpBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCaption	:_xZkqqHx_iDeMiDiDiDhGiDfGiDiHiDjDjFlGiOjKjHpBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_0_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_
 *						 _xZkqqHx_iDeBiDhGiDiKjGlMiCpAjFfMiOkGiBeC_xHqqkZx_
 *			dwType		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiMgAiOkOiBeC_xHqqkZx_
 *			szTextBox	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKjFfMiOkGiClDiCoKiCoJiDhLiDgCiDeOiDfIiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iClBiCmMjCgMiCkK_xHqqkZx_SIZE(0,0)_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiDfPiDeDiDeBiDiNiDePiDfEiDeDiDfJiCkK_xHqqkZx_
 *						 _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCmJiNiHiClJiCmEiDiKiDfEiDeDiDfJiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJjPiClDiCoKiClNiDhLiDfOiDjDiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FFMessageBox (DWORD dwText,
				DWORD dwCaption, DWORD dwType, CSize szTextBox)
{
	WString wstrText;
	WString wstrCaption;
	const wchar_t* wcpCaption = NULL;
	wstrText.LoadString(dwText);
	if (dwCaption != 0)
	{
		wstrCaption.LoadString(dwCaption);
		wcpCaption = wstrCaption.c_str();
	}
	return FFMessageBox(wstrText, wcpCaption, dwType, szTextBox);
} // FFMessageBox.

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFMessageBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDmGiOkJiCmMiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpText		:_xZkqqHx_iDgFiDeMiDfIiDgHjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpCaption	:_xZkqqHx_iDeMiDiDiDhGiDfGiDiHiDjDjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_NULL _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_
 *						 _xZkqqHx_iDeBiDhGiDiKjGlMiCpAjFfMiOkGiBeC_xHqqkZx_
 *			dwType		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiMgAiOkOiBeC_xHqqkZx_
 *			szTextBox	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKjFfMiOkGiClDiCoKiCoJiDhLiDgCiDeOiDfIiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iClBiCmMjCgMiCkK_xHqqkZx_SIZE(0,0)_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiDfPiDeDiDeBiDiNiDePiDfEiDeDiDfJiCkK_xHqqkZx_
 *						 _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCmJiNiHiClJiCmEiDiKiDfEiDeDiDfJiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJjPiClDiCoKiClNiDhLiDfOiDjDiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FFMessageBox (	const wchar_t* wcpText,
					const wchar_t* wcpCaption, DWORD dwType, CSize szTextBox)
{
	int iReturn;
	if (CFCDlgMessageBox::IsAcceptableType(dwType))
	//----- CFCDlgMessageBox_xZkqqHx_iCmFiPiIjHjNiJmCjEfMiCmIiDfOiDeDiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		CFCDlgMessageBox dlg;
		dlg.SetText(wcpText);
		if (wcpCaption != NULL)
			dlg.SetCaption(wcpCaption);
		dlg.SetType(dwType);
		dlg.SetTextBoxSize(szTextBox);
		iReturn = dlg.DoModal();
	} else
	//----- CFCDlgMessageBox_xZkqqHx_iCmFiPiIjHjNjFhDiJmCjEfMiCmIiDfOiDeDiDhGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		iReturn = MessageBox(NULL, WStrToTStr(wcpText), WStrToTStr(wcpCaption), dwType);
	}
	// _xZkqqHx_iNmEjFgAiJoGiCpAjBjHjAeNiBeC_xHqqkZx_OnRbtnHtreeChangeBranchIntoTrunk()_xZkqqHx_iCmIiCmHiDfPiDeDiDeBiDiNiDePiCpA_xHqqkZx_
	// _xZkqqHx_jFfMiOkGiClFiClNiMoDiClHiCkOiCmJiJoGjGmKiCmMiNmEjFgAiJoGiCpAiDeMiDiDiDjDiDfKiDiLiClHiCoJiCoGiCkEiCmIiPoKiNiHiBeB_xHqqkZx_
	// _xZkqqHx_iLkNjAkHjDeJiCmJiNmEjFgAiJoGiClFiCmEiCkIiCkJiCmIiCkCiCmGiJoGjGmKiCmJiPmBiClFiOgDiCoIiCkKiPgPiCoJiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
	return iReturn;
} // FFMessageBox.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFMakeDdSlideFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFMakeDdSlideFile (const wchar_t* wcpScenario, const wchar_t* wcpDdSlideFile)
{
	CFCDlgImageMessageBox::MakeDdSlideFile(wcpScenario, wcpDdSlideFile);
	return TRUE;
} // FFMakeDdSlideFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFImageMessageBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FFImageMessageBox (const wchar_t* wcpDdSlideFile)
{
	CFCDlgImageMessageBox dlg;
	dlg.SetDdSlideFile(wcpDdSlideFile);
	return dlg.DoModal();
} // FFImageMessageBox.

//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFErrorBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDmGiOkJiCmMiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
//----- 06.04.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	errboxShow	:_xZkqqHx_iDeHiDiJiBfLiOjOiCmMiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCmMjFfMiOkG_xHqqkZx_/_xZkqqHx_jEpBjFfMiOkG_xHqqkZx_
// *						 _xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *						 FD_ERRBOX_NOT_SHOW	:_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpA_xHqqkZx_
// *											 _xZkqqHx_jFfMiOkGiClFiCmIiCkCiBeC_xHqqkZx_
// *						 FD_ERRBOX_SHOW		:_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpA_xHqqkZx_
// *											 _xZkqqHx_jFfMiOkGiClHiCoJiBeC_xHqqkZx_
//----- 06.04.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
 *			dwFormatId	:_xZkqqHx_iDgFiDeMiDfIiDgHjFlGiOjKjHpBiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			...			:dwFormatId_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJiDhEiDeIiBfLiDhNiDgCiDgHiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.04.22 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FFErrorBox (FTIsShowErrorMessageBox errboxShow, DWORD dwFormatId, ...)
void FFErrorBox (DWORD dwFormatId, ...)
{
	va_list argList;
	va_start(argList, dwFormatId);
// 06.04.22 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	FFErrorBoxV(errboxShow, dwFormatId, argList);
	FFErrorBoxV(dwFormatId, argList);
	va_end(argList);
} // FFErrorBox.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFErrorBoxV
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDmGiOkJiCmMiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
//----- 06.04.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	errboxShow	:_xZkqqHx_iDeHiDiJiBfLiOjOiCmMiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCmMjFfMiOkG_xHqqkZx_/_xZkqqHx_jEpBjFfMiOkG_xHqqkZx_
// *						 _xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *						 FD_ERRBOX_NOT_SHOW	:_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpA_xHqqkZx_
// *											 _xZkqqHx_jFfMiOkGiClFiCmIiCkCiBeC_xHqqkZx_
// *						 FD_ERRBOX_SHOW		:_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpA_xHqqkZx_
// *											 _xZkqqHx_jFfMiOkGiClHiCoJiBeC_xHqqkZx_
//----- 06.04.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
 *			dwFormatId	:_xZkqqHx_iDgFiDeMiDfIiDgHjFlGiOjKjHpBiCmMiDhEiDeIiBfLiDhNiDgCiDgHiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			argList		:_xZkqqHx_iIpIjAjEiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.04.22 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FFErrorBoxV (FTIsShowErrorMessageBox errboxShow, DWORD dwFormatId, va_list argList)
void FFErrorBoxV (DWORD dwFormatId, va_list argList)
{
//----- 06.04.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpAjFfMiOkGiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (errboxShow == FD_ERRBOX_NOT_SHOW) return;
//----- 06.04.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmMjFlGiOjKjHpBiCpAjBgHiCnNjHkHiCmEiCoJ_xHqqkZx_ -----
	WString wstrFormat;
	(void)wstrFormat.LoadString(dwFormatId);
	WString wstrMsg;
	wstrMsg.FormatV(wstrFormat.c_str(), argList);
// 06.04.22 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	FFErrorBox(errboxShow, wstrMsg, CSize(0,0));
	FFErrorBox(wstrMsg, CSize(0,0));
} // FFErrorBoxV.

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFErrorBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDmGiOkJiCmMiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
//----- 06.04.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	errboxShow	:_xZkqqHx_iDeHiDiJiBfLiOjOiCmMiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCmMjFfMiOkG_xHqqkZx_/_xZkqqHx_jEpBjFfMiOkG_xHqqkZx_
// *						 _xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *						 FD_ERRBOX_NOT_SHOW	:_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpA_xHqqkZx_
// *											 _xZkqqHx_jFfMiOkGiClFiCmIiCkCiBeC_xHqqkZx_
// *						 FD_ERRBOX_SHOW		:_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpA_xHqqkZx_
// *											 _xZkqqHx_jFfMiOkGiClHiCoJiBeC_xHqqkZx_
//----- 06.04.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
 *			wcpText		:_xZkqqHx_iDgFiDeMiDfIiDgHjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szTextBox	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKjFfMiOkGiClDiCoKiCoJiDhLiDgCiDeOiDfIiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iClBiCmMjCgMiCkK_xHqqkZx_SIZE(0,0)_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiDfPiDeDiDeBiDiNiDePiDfEiDeDiDfJiCkK_xHqqkZx_
 *						 _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCmJiNiHiClJiCmEiDiKiDfEiDeDiDfJiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 06.04.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//void FFErrorBox (FTIsShowErrorMessageBox errboxShow,
//				const wchar_t* wcpText, CSize szTextBox)
//----- 06.04.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
void FFErrorBox (const wchar_t* wcpText, CSize szTextBox)
//----- 06.04.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
{
//----- 06.04.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpAjFfMiOkGiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (errboxShow == FD_ERRBOX_NOT_SHOW) return;
//----- 06.04.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmFiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
	FFMessageBox(wcpText, NULL, MB_OK, szTextBox);
} // FFErrorBox.

//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFDebugTrace
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDgPiDgCiDePiOjOiCmJiDeBiDeFiDgHiDhGiDgCiDgHiDeFiDeCiDjDiDgIiDeFiCmJjFlGiOjKjHpBiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_TRACE_xZkqqHx_iCmGjDkPiClGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFDebugTrace (const wchar_t* wcpFormat, ...)
{
#ifdef _DEBUG
	WString wstrMsg;
	va_list argList;
	va_start(argList, wcpFormat);
	wstrMsg.FormatV(wcpFormat, argList);
	va_end(argList);
	OutputDebugString(WStrToTStr(wstrMsg));
#endif//_DEBUG
} // FFDebugTrace.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFReleaseTrace
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDiKiBfLiDfIiOjOiCmJiDeBiDeFiDgHiDhGiDgCiDgHiDeFiDeCiDjDiDgIiDeFiCmJjFlGiOjKjHpBiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_TRACE_xZkqqHx_iCmGjDkPiClGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFReleaseTrace (const wchar_t* wcpFormat, ...)
{
	if (s_autoDlgDebugOut.get() != NULL)
	{
		WString wstrMsg;
		va_list argList;
		va_start(argList, wcpFormat);
		wstrMsg.FormatV(wcpFormat, argList);
		va_end(argList);
		FFReleaseTraceMessage(wstrMsg);
	}
} // FFReleaseTrace.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFReleaseTraceMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDiKiBfLiDfIiOjOiCmJiDeBiDeFiDgHiDhGiDgCiDgHiDeFiDeCiDjDiDgIiDeFiCmJjFlGiOjKjHpBiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_TRACE_xZkqqHx_iCmGjDkPiClGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFReleaseTraceMessage (const wchar_t* wcpMessage)
{
	if (s_autoDlgDebugOut.get() != NULL)
	{
		CEdit* pEdit = (CEdit*)s_autoDlgDebugOut->GetDlgItem(IDC_DOT_EDT_MESSAGE);
		pEdit->ReplaceSel(WStrToTStr(wcpMessage), FALSE);
	}
} // FFReleaseTraceMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFReleaseOutputOn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDiKiBfLiDfIiOjOiCmMiDeBiDeFiDgHiDhGiDgCiDgHiDeFiDeCiDjDiDgIiDeFiCpAjHeMiMpIiCmJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFReleaseOutputOn ()
{
	if (s_autoDlgDebugOut.get() == NULL)
	{
		s_autoDlgDebugOut = auto_ptr<CFCDlgDebugOut>(new CFCDlgDebugOut());
		s_autoDlgDebugOut->Create(CFCDlgDebugOut::IDD, FFGetMainWnd()->GetWnd());
	}
	s_autoDlgDebugOut->SetWindowVisible(TRUE);
} // FFReleaseOutputOn.
