#ifndef __UtilGraph_h
#define __UtilGraph_h

#include "Env.h"		// For PenStyleID. etc.
#include "UtilCoord.h"	// For FFLimitCoord.

class WString;
class FCAutoDC;
template<class T> class FCPolyBezier;
typedef FCPolyBezier<CPoint> FCLgPolyBezier;

enum FDRegColorType;

/**************** _xZkqqHx_jAeGiMgO_xHqqkZx_ ********************/

inline COLORREF OptiColor (COLORREF col)
{
	if (g_pFDPalette != NULL)
		return PALETTEINDEX(g_pFDPalette->GetNearestPaletteIndex(col));
	else
		return col;
} // OptiColor.

//----- 00.09.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
enum FTEditPenType
{
	FDPN_TIMID,	// _xZkqqHx_iOoDiCkCiDhJiDjDiCpAiNoMjAkMiClFiCnMiClHiBeC_xHqqkZx_
	FDPN_BOLD,	// _xZkqqHx_iLkNiCkCiDhJiDjDiCpAiNoMjAkMiClFiCnMiClHiBeC_xHqqkZx_
}; // enum FTEditPenType.
//----- 00.09.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCEditDraw
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CDC_xZkqqHx_iCpAiPeDjAlDjApMjHhAiCmJjBkOjAkLjAnNjCoIiBjFjBkOjAkLjFjMiLeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCEditDraw
{
public:
	FCEditDraw (CDC* pDC,
				long lgPenW = 1,
				COLORREF col = COLORREF(-1),
				long lPenStyle = -1,
				long lgOffsetX = g_->lgOffsetX,
				long lgOffsetY = g_->lgOffsetY);

//----- 05.02.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FCEditDraw (CDC* pDC, long lgPenW, COLORREF col,
//				long lgOffsetX = g_->lgOffsetX, long lgOffsetY = g_->lgOffsetY);
//	FCEditDraw (CDC* pDC, long lgPenW,
//				long lgOffsetX = g_->lgOffsetX, long lgOffsetY = g_->lgOffsetY);
//----- 05.02.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----------<NOT EXPORT TO VIEWER>-----------
	FCEditDraw (CDC* pDC, FTEditPenType penType,
				long lgOffsetX = g_->lgOffsetX, long lgOffsetY = g_->lgOffsetY);
//----------</NOT EXPORT TO VIEWER>-----------
protected:
	void	Initialize (CDC* pDC,
						long lgPenW,
						COLORREF col,
						long lPenStyle,
						long lgOffsetX,
						long lgOffsetY);

public:

	~FCEditDraw ();
public:
	void	RectLine (const CPoint& lgptCenter, long lgHalfW, long lgHalfH);
	void	RectLine (const CRect& lgrtFrame);

	void	RectFill (const CPoint& lgptCenter, long lgHalfW, long lgHalfH);
	void	RectFill (const CRect& lgrtFrame);

	void	SelMark (const CPoint& lgptCenter);
	void	UnselMark (const CPoint& lgptCenter);
	void	GeneralMark (const CPoint& lgptCenter);

//----------<NOT EXPORT TO VIEWER>-----------
	void	SmallMark (const CPoint& lgptCenter);
	void	Polyline (const CPoint* lpPoints, int nCount);
//----------</NOT EXPORT TO VIEWER>-----------

	void	Polygon (const CPoint* lpPoints, int nCount);
	void	Line (	const CPoint* pPoint0, const CPoint* pPoint1,
					const CPoint* pPoint2 = NULL, const CPoint* pPoint3 = NULL,
					const CPoint* pPoint4 = NULL, const CPoint* pPoint5 = NULL,
					const CPoint* pPoint6 = NULL, const CPoint* pPoint7 = NULL,
					const CPoint* pPoint8 = NULL, const CPoint* pPoint9 = NULL);
	void	ArcLine (const CRect& rect, const CPoint& ptStart, const CPoint& ptEnd);

//----- 06.12.27 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	void	MoveTo (const CPoint& lgpt);
	void	MoveTo (long lgX, long lgY);
	void	LineTo (const CPoint& lgpt);
	void	LineTo (long lgX, long lgY);
//----- 06.12.27 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----------<NOT EXPORT TO VIEWER>-----------
	static COLORREF	GetEditColor ();
//----------</NOT EXPORT TO VIEWER>-----------
	static int		GetSelMarkSizeHalf ();
	static int		GetGeneralMarkSizeHalf ();
	static int		GetSmallMarkSizeHalf ();

//----- 02.07.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
private:
	long	mylgx2dvx (long lgx) const;
	long	mylgy2dvy (long lgy) const;
//----- 02.07.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----

protected:
	CDC* 	m_pDC;
	long	m_lgOffsetX;	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
	long	m_lgOffsetY;	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
	CPen	m_pen;
	CBrush	m_brush;
	int		m_rop2Old;
	CPen*	m_pPenOld;
	CBrush*	m_pBrushOld;

// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	CPoint	m_lgptLastMoveTo;
}; // class FCEditDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::mylgx2dvx
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCDraw_xZkqqHx_iDeOiDiJiDfIiCmJiCkIiCkPiCoJjIfPjHjNiNmAjFfHiCpAjFkIjHjNiNmAjFfHiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgx	:X_xZkqqHx_iNmAjFfHjCgMiCpAjIfPjHjNiNmAjFfHiCmFiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkIjHjNiNmAjFfHiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline long FCEditDraw::mylgx2dvx (long lgx) const
{
	return FFLimitCoord(lgx - m_lgOffsetX);
} // FCEditDraw::mylgx2dvx.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCEditDraw::mylgy2dvy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCEditDraw_xZkqqHx_iDeOiDiJiDfIiCmJiCkIiCkPiCoJjIfPjHjNiNmAjFfHiCpAjFkIjHjNiNmAjFfHiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgy	:Y_xZkqqHx_iNmAjFfHjCgMiCpAjIfPjHjNiNmAjFfHiCmFiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkIjHjNiNmAjFfHiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline long FCEditDraw::mylgy2dvy (long lgy) const
{
	return FFLimitCoord(lgy - m_lgOffsetY);
} // FCEditDraw::mylgy2dvy.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCDraw
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmKiPoNiCmMjFgAiJoGjHhAiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.03 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
class FCDraw
{
public:
	FCDraw (CDC* pDC,
			FTDrawWhich eDrawWhich = g_->eDrawWhich,
			double dZoom = g_->dZoom,
			long lgOffsetX = g_->lgOffsetX, long lgOffsetY = g_->lgOffsetY);
	~FCDraw ();
	void	PenInit (	PenStyleID	psidPenStyle,
						fmmetol		mmfPenWeight,
						SColorID	scidPenBackSColor);
	void	BrushInit (	PatternID	ptidBrushPattern,
						SColorID	scidBrushForeSColor,
						SColorID	scidBrushBackSColor);
	void	PenInitNull ();
	void	BrushInitNull ();
//----- 01.03.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	void	PenInitSolid (fmmetol mmfPenWeight, COLORREF col);
//	void	BrushInitSolid (COLORREF col);
//----- 01.03.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	void	Polyline (const CPoint* lgptaPoly, long lPolySz);
	void	Polygon (const CPoint* lgptaPoly, long lPolySz, const CRect& lgrtRgn);

	void	Polyline (const FCLgPolyBezier& lgptaPoly);
	void	Polygon (const FCLgPolyBezier& lgptaPoly, const CRect& lgrtRgn);

// 05.04.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	void	PolyBezier (const CPoint* lgptaPoly, long lPolySz);
	void	Line (const CPoint& lgptFrom, const CPoint& lgptTo);
	void	FillRect (const CRect& lgrt, const CRect& lgrtRgn);
	void	RectLine (const CRect& lgrt);
	BOOL	DrawOLE (COleClientItem* pOle, const CRect& lgrt,
							DVASPECT nDrawAspect = (DVASPECT)-1);
	BOOL	PlayMetaFile (	HENHMETAFILE hEnhMetaFile,
							const CRect& lgrtBounds,
							const CRect& lgrtFrame,
							const FCLgPolyBezier& lgptaPoly,
							BOOL bTileH, BOOL bTileV);
protected:
	void	GetPenStyleArray (DWORD lgaData[]) const;
	long	mymm2lg (mmetol mm) const;
	CRect	mymm2lg (const DBLRect& drct) const;
	void	mylg2dv (POINT* dvpt, const POINT* lgpt, long lCount) const;
	CRect	mylg2dv (const CRect& lgrt) const;
	void	mylg2dv (FCLgPolyBezier& dvpt, const FCLgPolyBezier& lgpt) const;
//----- 02.07.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----
	long	mylgx2dvx (long lgx) const;
	long	mylgy2dvy (long lgy) const;
//----- 02.07.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----

	void	MoveTo (const CPoint& lgpt);
	void	MoveTo (long lgX, long lgY);
	void	LineTo (const CPoint& lgpt);
	void	LineTo (long lgX, long lgY);

//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	void	FillPathWithPattern (const POINT* dvptaPoly, long lPolySz,
//								const CRect& dvrtRgn);
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	void	FillPathWithPattern (const FCLgPolyBezier& dvptaPoly,
								const CRect& dvrtRgn);
//----- 05.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	static void	DrawPattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
							PatternID ptid, const CRect& rtClip);
	static void	DrawPinholePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
									short nSkip, short nHoleW, CRect rtClip);
	static void	DrawStarPattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
								short nSkip, short nStarW, CRect rtClip);
	static void	DrawVLinePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
								short nSkip, short nLineW, CRect rtClip);
	static void	DrawHLinePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
								short nSkip, short nLineW, CRect rtClip);
	static void	DrawLDLinePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
									short nSkip, short nLineW, CRect rtClip);
	static void	DrawRDLinePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
									short nSkip, short nLineW, CRect rtClip);
	static void	DrawVHLatticePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
									short nSkip, short nLineW, CRect rtClip);
	static void	DrawDgLatticePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
									short nSkip, short nLineW, CRect rtClip);
	static void	DrawHWavePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
									short nSkip, short nWaveW, short nLineW, CRect rtClip);
	static void	DrawVWavePattern (CDC* pDC, COLORREF cr, short nAtomLen, CRect& rtCanvas,
									short nSkip, short nWaveW, short nLineW, CRect rtClip);

protected:
	CDC* 	m_pDC;
	FTDrawWhich	m_eDrawWhich;	// _xZkqqHx_jFgAiJoGjBmOiPnLiBeC_xHqqkZx_FDDR_DISPLAY_xZkqqHx_iBeB_xHqqkZx_FDDR_METAFILE_xZkqqHx_jDjJiBeC_xHqqkZx_
	double	m_dZoom;
	long	m_lgOffsetX;	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
	long	m_lgOffsetY;	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
	CPen	m_pen;
	CBrush	m_brush;
	PenStyleID	m_psidPenStyle;
	fmmetol		m_mmfPenWeight;
//----- 01.03.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	SColorID	m_scidPenBackSColor;
	PatternID	m_ptidBrushPattern;		// BRUSH_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
	SColorID	m_scidBrushForeSColor;	// BRUSH_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
	SColorID	m_scidBrushBackSColor;
//----- 01.03.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	CPen*	m_pPenOld;
	CBrush*	m_pBrushOld;
	CPalette* m_pPaletteOld;

// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	CPoint	m_lgptLastMoveTo;
}; // class FCDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::mylgx2dvx
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCDraw_xZkqqHx_iDeOiDiJiDfIiCmJiCkIiCkPiCoJjIfPjHjNiNmAjFfHiCpAjFkIjHjNiNmAjFfHiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgx	:X_xZkqqHx_iNmAjFfHjCgMiCpAjIfPjHjNiNmAjFfHiCmFiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkIjHjNiNmAjFfHiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline long FCDraw::mylgx2dvx (long lgx) const
{
	return FFLimitCoord(lgx - m_lgOffsetX);
} // FCDraw::mylgx2dvx.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDraw::mylgy2dvy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCDraw_xZkqqHx_iDeOiDiJiDfIiCmJiCkIiCkPiCoJjIfPjHjNiNmAjFfHiCpAjFkIjHjNiNmAjFfHiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgy	:Y_xZkqqHx_iNmAjFfHjCgMiCpAjIfPjHjNiNmAjFfHiCmFiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkIjHjNiNmAjFfHiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline long FCDraw::mylgy2dvy (long lgy) const
{
	return FFLimitCoord(lgy - m_lgOffsetY);
} // FCDraw::mylgy2dvy.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCAutoGdiObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CPen,CBrush_xZkqqHx_jDjJiCpAiDiJiDgCiDhGiClFiCmEiBeBiDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCkKiNoNiPjMiClDiCoKiCoJiCmGiCkL_xHqqkZx_
 *			_xZkqqHx_iCmJiBeB_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCoAjDkPiOjOiCmJiKeKjFpKiClDiCoKiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class GDIOBJ> class FCAutoGdiObj
{
public:
	FCAutoGdiObj ();
	template<class T1> FCAutoGdiObj (T1 t1)
					 : m_GdiObj(t1), m_pAtDC(NULL)
		{
		}
	template<class T1, class T2> FCAutoGdiObj (T1 t1, T2 t2)
					 : m_GdiObj(t1, t2), m_pAtDC(NULL)
		{
		}
	template<class T1, class T2, class T3> FCAutoGdiObj (T1 t1, T2 t2, T3 t3)
					 : m_GdiObj(t1, t2, t3), m_pAtDC(NULL)
		{
		}
	template<class T1, class T2, class T3, class T4> FCAutoGdiObj (T1 t1, T2 t2, T3 t3, T4 t4)
					 : m_GdiObj(t1, t2, t3, t4), m_pAtDC(NULL)
		{
		}
	template<class T1, class T2, class T3, class T4, class T5> FCAutoGdiObj (T1 t1, T2 t2, T3 t3, T4 t4, T5 t5)
					 : m_GdiObj(t1, t2, t3, t4, t5), m_pAtDC(NULL)
		{
		}

	~FCAutoGdiObj ();
	GDIOBJ*	Get ();

friend class FCAutoDC;
private:
	void	SetAtDC (FCAutoDC* pAtDC);

private:
	GDIOBJ		m_GdiObj;
	FCAutoDC*	m_pAtDC;
}; // template<class GDIOBJ> class FCAutoGdiObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoGdiObj<GDIOBJ>::FCAutoGdiObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class GDIOBJ>
FCAutoGdiObj<GDIOBJ>::FCAutoGdiObj () : m_pAtDC(NULL)
{
} // FCAutoGdiObj<GDIOBJ>::FCAutoGdiObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoGdiObj<GDIOBJ>::~FCAutoGdiObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class GDIOBJ>
FCAutoGdiObj<GDIOBJ>::~FCAutoGdiObj ()
{
	// _xZkqqHx_iClBiCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKiBeBiMlLiNnN_xHqqkZx_CDC_xZkqqHx_iCmJjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
	// CDC_xZkqqHx_iCmMjAnNjCoIiCpAiMlDiCmJjGnPiClFiCmEiCkJiCoHiBeB_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
	if (m_pAtDC != NULL)
	{
		m_pAtDC->CurAtObject(*this) = NULL;
		m_pAtDC->GetDC()->SelectObject(m_pAtDC->BackupGdiObject((GDIOBJ*)NULL));
		m_pAtDC = NULL;
	}
} // FCAutoGdiObj<GDIOBJ>::~FCAutoGdiObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoGdiObj<GDIOBJ>::Get
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class GDIOBJ>
GDIOBJ*	FCAutoGdiObj<GDIOBJ>::Get ()
{
	return &m_GdiObj;
} // FCAutoGdiObj<GDIOBJ>::Get.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoGdiObj<GDIOBJ>::SetAtDC
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	AutoDC_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pAtDC	:AutoDC_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class GDIOBJ>
void FCAutoGdiObj<GDIOBJ>::SetAtDC (FCAutoDC* pAtDC)
{
	m_pAtDC = pAtDC;
} // FCAutoGdiObj<GDIOBJ>::SetAtDC.

typedef FCAutoGdiObj<CFont> FCAtFont;
typedef FCAutoGdiObj<CPen> FCAtPen;
typedef FCAutoGdiObj<CBrush> FCAtBrush;
typedef FCAutoGdiObj<CBitmap> FCAtBitmap;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCAutoDC
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CDC_xZkqqHx_iCpAiDiJiDgCiDhGiClFiCmEiBeBiClBiCmMiDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCkKiNoNiPjMiClDiCoKiCoJiCmGiCkLiCmJ_xHqqkZx_
 *			_xZkqqHx_iClHiCnHiCmEiCmMjFmPiNfIiCkKiMlDiCmJjGnPiClDiCoKiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCAutoDC
{
public:
	FCAutoDC (CDC* pDC, BOOL bSaveDC = FALSE,
				long lgOffsetX = g_->lgOffsetX, long lgOffsetY = g_->lgOffsetY);
	~FCAutoDC ();
	void	SetWindowOrg (POINT ptWindowOrg);
	void	SetBkColor (COLORREF crBkColor);
	void	SetBkMode (int iBkMode);
	void	SetTextColor (COLORREF crTextColor);
	COLORREF GetTextColor () const;
	void	SetMapMode (int iMapMode);

	void	SetFont (const LOGFONT* lpLogFont);
	void	SetPen (int nPenStyle, int nWidth, COLORREF crColor);
	void	SetPen (int nPenStyle, int nWidth, const LOGBRUSH* pLogBrush, int nStyleCount = 0, const DWORD* lpStyle = NULL);
	void	SetStockPen (int fnObject);
	void	SetBrush (COLORREF crColor);
	void	SetBrush (LPLOGBRUSH lpLogBrush);

	void	SetStockBrush (int fnObject);

	BOOL	GetCharABCWidth (wchar_t wChar, ABC& abc, WORD wCodePage) const;
	BOOL	GetCharWidth (wchar_t wChar, int& iWidth, WORD wCodePage) const;
// 06.05.18 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	CSize	GetOutputTextExtent (const wchar_t* wcpString, int nCount, WORD wCodePage) const;

	UINT	GetOutlineTextMetrics (UINT cbData, LPOUTLINETEXTMETRIC lpotm) const;

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::SetObject
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	AutoGDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	atObj	:AutoGDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	template<class T> void SetObject (T& atObj)
		{
			if (atObj.m_pAtDC == this) return;
			ASSERT(atObj.m_pAtDC == NULL);
			// _xZkqqHx_jAfGiClFiCkC_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjAnNjCoIiBeCiDgPiDgCiDeOiDeBiDgCiDhGiCkKjGlDiCkCiPoKiNiHiCmNiBeBiDgPiDgCiDeOiDeBiDgCiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
			(void)BackupGdiObject(m_pDC->SelectObject(atObj.Get()));
			// _xZkqqHx_iMlLiNnNjAnNjCoIjCiGiCmM_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiHiBeBjAnNjCoIiCpAiJpAiPjMiBeC_xHqqkZx_
			if (CurAtObject(atObj) != NULL) CurAtObject(atObj)->SetAtDC(NULL);
			// _xZkqqHx_jAfGiClFiCkC_xHqqkZx_GDI_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
			atObj.SetAtDC(this);
			CurAtObject(atObj) = &atObj;
		} // FCAutoDC::SetObject.

	CPoint	MoveTo (int x, int y);
	CPoint	MoveTo (POINT point);
	BOOL	LineTo (int x, int y);
	BOOL	LineTo (POINT point);
	BOOL	TextOut (int x, int y, const wchar_t* lpszString, int nCount, WORD wCodePage);
	BOOL	TextOut (int x, int y, const WString& str, WORD wCodePage);
	BOOL	ExtTextOut (int x, int y, UINT nOptions, int left, int top, int right, int bottom, const wchar_t* lpszString, UINT nCount, WORD wCodePage, LPINT lpDxWidths);
	BOOL	ExtTextOut (int x, int y, const WString& str, WORD wCodePage, LPINT lpDxWidths);
	int		DrawText (const wchar_t* lpszString, int nCount, WORD wCodePage, LPRECT lpRect, UINT nFormat);
	int		DrawText (const WString& str, WORD wCodePage, LPRECT lpRect, UINT nFormat);
	int		DrawTextEx (const WString& str, WORD wCodePage, LPRECT lpRect, UINT nFormat, DRAWTEXTPARAMS* lpDTParams);
	long	DrawTextLines (	const CRect& lgrtBox,
							const WString& wstr,
							WORD wCodePage,
							long pxLineHeight,
							long pxLineGap,
							DWORD dwFormat,
							BOOL bIsWordWrapE,
							BOOL bIsWordWrapJ);
	int		IntersectClipRect (int x1, int y1, int x2, int y2);
	int		IntersectClipRect (LPCRECT lpRect);
	int		SetClipRgn (CRgn* pRgn);
	int		SetClipRgn (CRgn* pRgn, int nMode);
	void	FillRect (LPCRECT lpRect, FCAtBrush& brush);
	void	FillPoly (LPPOINT lpPoints, int nCount);
	BOOL	Polygon (LPPOINT lpPoints, int nCount);
	BOOL	Polyline (LPPOINT lpPoints, int nCount);
	BOOL	Arc (LPCRECT lpRect, POINT ptStart, POINT ptEnd);
	BOOL	Pie (LPCRECT lpRect, POINT ptStart, POINT ptEnd);
	BOOL	Chord (LPCRECT lpRect, POINT ptStart, POINT ptEnd);
	BOOL	Rectangle (int x1, int y1, int x2, int y2);
	BOOL	Rectangle (LPCRECT lpRect);
	BOOL	BitBlt (int x, int y, int nWidth, int nHeight, CDC* pSrcDC, int xSrc, int ySrc, DWORD dwRop);
	void	DrawFocusRect (LPCRECT lpRect);
	BOOL	DrawEdge (LPRECT lpRect, UINT nEdge, UINT nFlags);
// 06.11.06 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	void	DrawEdge (LPCRECT lpRect, long lDepth, COLORREF colLight, COLORREF colShadow);

//----- 05.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	BOOL	PlayMetaFile (	HENHMETAFILE hEnhMetaFile,
//							const CRect& lgrtBounds,
//							const CRect& lgrtFrame,
//							const FCLgPolyBezier& lgptaPoly,
//							BOOL bTileH, BOOL bTileV);
//----- 05.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	BOOL	DrawIconEx (int xLeft, int yTop, HICON hIcon, int cxWidth, int cyWidth,
						UINT istepIfAniCur, HBRUSH hbrFlickerFreeDraw, UINT diFlags);

	CSize	GetTextExtent (const wchar_t* wszString, int nCount) const;

friend class FCAutoGdiObj<CFont>;
friend class FCAutoGdiObj<CPen>;
friend class FCAutoGdiObj<CBrush>;
friend class FCAutoGdiObj<CBitmap>;
private:
	FCAtFont* &		CurAtObject (FCAtFont&);
	FCAtPen* &		CurAtObject (FCAtPen&);
	FCAtBrush* &	CurAtObject (FCAtBrush&);
	FCAtBitmap* &	CurAtObject (FCAtBitmap&);

	CFont*	BackupGdiObject (CFont* pFont);
	CPen*	BackupGdiObject (CPen* pPen);
	CBrush*	BackupGdiObject (CBrush* pBrush);
	CBitmap* BackupGdiObject (CBitmap* pBitmap);

	CDC*	GetDC() const;

	CPoint	mylg2dv (const CPoint& lgpt) const;
	CPoint	mylg2dv (long x, long y) const;
	CRect	mylg2dv (const CRect& lgrt) const;
	CRect	mylg2dv (long left, long top, long right, long bottom) const;
	long	mylgx2dvx (long lgx) const;
	long	mylgy2dvy (long lgy) const;
	void	mylg2dv (POINT* dvpt, const POINT* lgpt, long lCount) const;
// 05.04.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	void	mylg2dv (FCLgPolyBezier& dvpt, const FCLgPolyBezier& lgpt) const;

private:
	CDC* 		m_pDC;
	BOOL		m_bSaveDC;
	long		m_lgOffsetX;	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
	long		m_lgOffsetY;	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_

	FCAtFont*	m_pCurAtFont;
	FCAtPen*	m_pCurAtPen;
	FCAtBrush*	m_pCurAtBrush;
	FCAtBitmap*	m_pCurAtBitmap;

	CFont*		m_pFontOrig;
	CPen*		m_pPenOrig;
	CBrush*		m_pBrushOrig;
	CBitmap*	m_pBitmapOrig;

	BOOL		m_bSetWindowOrg;
	CPoint		m_ptWindowOrgOrig;

	BOOL		m_bSetBkColor;
	COLORREF	m_crBkColorOrig;

	BOOL		m_bSetBkMode;
	int			m_iBkModeOrig;

	BOOL		m_bSetTextColor;
	COLORREF	m_crTextColorOrig;

	BOOL		m_bSetMapMode;
	int			m_iMapModeOrig;

	FCAtFont*	m_pOwnFont;
	FCAtPen*	m_pOwnPen;
	FCAtBrush*	m_pOwnBrush;

	CPalette*	m_pPaletteOld;

// 06.12.27 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	CPoint		m_lgptLastMoveTo;
}; // class FCAutoDC.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCAutoGdiStock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkBjAjEiCmM_xHqqkZx_FCAtPen_xZkqqHx_iBeB_xHqqkZx_FCAtBrush_xZkqqHx_iCpAiBeBiClBiCmMiDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHjCiGiCmJ_xHqqkZx_
 *			_xZkqqHx_jFnLjBlGiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDkPiClGiDhJiDjDiBeBiDhFiDiJiDfGiCpAiJlNjDhIiCoAiOgHiCkEiPoKiNiHiCmJiBeBiCkCiClPiCkCiClPiIpIjAjEiCmFiCkAiClPiClBiClPiCmM_xHqqkZx_
 *			_xZkqqHx_iKnGjAjEiCmJjDgOiClHiCmMiCoAjBoFjFmPiClOiClFiBeBjBiKiOoIiKnGjAjEjCiGiCmFjAfGiClNiCmJiNoMjAkMiClHiCoJiCmMiCmN_xHqqkZx_
 *			_xZkqqHx_iDfCiDfIiDgHiCkKiCkJiCkJiCoJiBeCiClBiCmMiDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHjCiGiCmFiKmHjHjNiClFiCmEiCkIiCkPiCmOiBeB_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiClOiCkPiCpAiKnGjAjEiCmJjDgOiClJiCmOiNmPiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCAutoGdiStock
{
public:
	FCAutoGdiStock ();
	virtual ~FCAutoGdiStock ();

	FCAtPen&	GetPen (int nPenStyle, int nWidth, COLORREF crColor);
	FCAtPen&	GetRegPen (int nPenStyle, int nWidth, FDRegColorType nType);
	FCAtBrush&	GetBrush (COLORREF crColor);
	FCAtBrush&	GetRegBrush (FDRegColorType nType);

protected:
	map<FC3Fold<int, int, COLORREF>, FCAtPen*>	m_mpPen;
	map<COLORREF, FCAtBrush*>					m_mpBrush;
}; // class FCAutoGdiStock.

//----- 02.07.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::mylgx2dvx
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCAutoDC_xZkqqHx_iDeOiDiJiDfIiCmJiCkIiCkPiCoJjIfPjHjNiNmAjFfHiCpAjFkIjHjNiNmAjFfHiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgx	:X_xZkqqHx_iNmAjFfHjCgMiCpAjIfPjHjNiNmAjFfHiCmFiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkIjHjNiNmAjFfHiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline long FCAutoDC::mylgx2dvx (long lgx) const
{
// 02.07.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)
//	return lgx - m_lgOffsetX;
	return FFLimitCoord(lgx - m_lgOffsetX);
} // FCAutoDC::mylgx2dvx.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCAutoDC::mylgy2dvy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCAutoDC_xZkqqHx_iDeOiDiJiDfIiCmJiCkIiCkPiCoJjIfPjHjNiNmAjFfHiCpAjFkIjHjNiNmAjFfHiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgy	:Y_xZkqqHx_iNmAjFfHjCgMiCpAjIfPjHjNiNmAjFfHiCmFiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkIjHjNiNmAjFfHiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline long FCAutoDC::mylgy2dvy (long lgy) const
{
// 02.07.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)
//	return lgy - m_lgOffsetY;
	return FFLimitCoord(lgy - m_lgOffsetY);
} // FCAutoDC::mylgy2dvy.
//----- 02.07.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)-----

extern COLORREF FFGetMiddleColor (double dProportion, COLORREF colBegin, COLORREF colEnd);

#endif//!__UtilGraph_h
