#ifndef __UtilMath_h
#define __UtilMath_h

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	Round
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IEEE_xZkqqHx_iMgAiOkOiCmMjFiCjDkOiPkMjAjEjDfPjAjEiCmMiBeBiNmFiMoDiCmMiCfDiDhCiDgCiDgHiCpAiKnLiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	f	:_xZkqqHx_iKnLiCnPiCoJjFiCjDkOiPkMjAjEjDfPjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	float_xZkqqHx_iMfOiCmM_xHqqkZx_32_xZkqqHx_iDhCiDgCiDgHiCmNiBeBiPoDiImKiCkJiCoHiPiHiCmJiImIiJlKiCmMjDoAjGpDiCmFiCkAiCoJiBeC_xHqqkZx_
 *				1 bit	:_xZkqqHx_jAlDjFiJiCmMjFiEiNiGiBeC_xHqqkZx_
 *				8 bit 	:_xZkqqHx_iOhHjAjEiBeC_xHqqkZx_2^(x - 127)_xZkqqHx_iBeC_xHqqkZx_
 *				23 bit	:_xZkqqHx_iJlMjAjEiBeC_xHqqkZx_1.xxxxxxxx_xZkqqHx_iBeC_xHqqkZx_
 *			_xZkqqHx_jFfMiClHjAjEjCgMiCkKiBhF_xHqqkZx_m * 2 ^ e_xZkqqHx_iBhGiCmMiPoKiNiHiBeBiOhHjAjEjFjEiCmNiBhF_xHqqkZx_e + 127_xZkqqHx_iBhGiBeBiJlMjAjEjFjEiCmN_xHqqkZx_
 *			_xZkqqHx_iBhF_xHqqkZx_m - 1_xZkqqHx_iBhGiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jGhLiKnGjAjEiCmFiCmNiBeBiJlMjAjEjFjEiCpA_xHqqkZx_DWORD_xZkqqHx_iMfOiCmFiOoGiCoIiPgPiClFiBeBiJlKiCkJiCoHiCfDiDhCiDgCiDgHjGnKiCpA_xHqqkZx_
 *			_xZkqqHx_iOgMiOmMiMnMjDpMiClFiCmEiCkCiCoJiBeCiClBiCmMiOjO_xHqqkZx_ _xZkqqHx_iMiFiCkKiCkAiCnDiCoKiClNiPoKiNiHiCmNiBeBiJlMjAjEjFjEiBiBiCeP_xHqqkZx_
 *			_xZkqqHx_iBgJjBkGiClPiCiNiBiBiCfAiBgKiCmGiClFiBeBiOhHjAjEjFjEiCmJiCfAiCpAiJmBiOfKiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline void Round (float& f)
{
	struct FF {
		unsigned num : 23;
		unsigned exp : 8;
		unsigned sig : 1;
	};
	FF& ff = *((FF*)&f);
	DWORD dw = (ff.num + 0x08) & 0xfffffff0;
	// _xZkqqHx_iMiFiCkAiCnDiCoKiBgJ_xHqqkZx_23bit_xZkqqHx_jGnKiCkKjHkHiCmBiCmEiCkCiCoJiCkJiBgKiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (dw & (0x01 << 23))
	{
		dw = 0;
		ff.exp += 1;
	}
	ff.num = dw;
} // Round (float& f).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	Round
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IEEE_xZkqqHx_iMgAiOkOiCmMjFiCjDkOiPkMjAjEjDfPjAjEiCmMiBeBiNmFiMoDiCmMiCfDiDhCiDgCiDgHiCpAiKnLiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	f	:_xZkqqHx_iKnLiCnPiCoJjFiCjDkOiPkMjAjEjDfPjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	double_xZkqqHx_iMfOiCmM_xHqqkZx_64_xZkqqHx_iDhCiDgCiDgHiCmNiBeBiPoDiImKiCkJiCoHiPiHiCmJiImIiJlKiCmMjDoAjGpDiCmFiCkAiCoJiBeC_xHqqkZx_
 *				1 bit	:_xZkqqHx_jAlDjFiJiCmMjFiEiNiGiBeC_xHqqkZx_
 *				11 bit 	:_xZkqqHx_iOhHjAjEiBeC_xHqqkZx_2^(x - 127)_xZkqqHx_iBeC_xHqqkZx_
 *				52 bit	:_xZkqqHx_iJlMjAjEiBeC_xHqqkZx_1.xxxxxxxx_xZkqqHx_iBeC_xHqqkZx_
 *			_xZkqqHx_jFfMiClHjAjEjCgMiCkKiBhF_xHqqkZx_m * 2 ^ e_xZkqqHx_iBhGiCmMiPoKiNiHiBeBiOhHjAjEjFjEiCmNiBhF_xHqqkZx_e + 1023_xZkqqHx_iBhGiBeBiJlMjAjEjFjEiCmN_xHqqkZx_
 *			_xZkqqHx_iBhF_xHqqkZx_m - 1_xZkqqHx_iBhGiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jGhLiKnGjAjEiCmFiCmNiBeBiJlMjAjEjFjEiCpAjFiEiNiGjGlDiClF_xHqqkZx_int64_xZkqqHx_iMfOiCmFiOoGiCoIiPgPiClFiBeBiJlKiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iCfDiDhCiDgCiDgHjGnKiCpAiOgMiOmMiMnMjDpMiClFiCmEiCkCiCoJiBeCiClBiCmMiOjO_xHqqkZx_ _xZkqqHx_iMiFiCkKiCkAiCnDiCoKiClNiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iJlMjAjEjFjEiBiBiCePiBgJjBkGiClPiCiNiBiBiCfAiBgKiCmGiClFiBeBiOhHjAjEjFjEiCmJiCfAiCpAiJmBiOfKiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_ DD_xZkqqHx_iCmFiCmNiBeBiJlMjAjEiCpAjClMjAnKiCfEiCfBiDhCiDgCiDgHiCmFiOoGiCoIiPgPiClJiCmIiCkCiInHiBgJiDhCiDgCiDgH_xHqqkZx_
 *			_xZkqqHx_iDhEiDeCiBfLiDiLiDgIiCmN_xHqqkZx_int_xZkqqHx_iMfOiBgKiBeB_xHqqkZx_DWORD(32bit)_xZkqqHx_iCmG_xHqqkZx_20bit_xZkqqHx_iCmMiDhCiDgCiDgHiDhEiDeCiBfLiDiLiDgIiCmJ_xHqqkZx_
 *			_xZkqqHx_jFkKiKiEiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline void Round (double& f)
{
	struct DD {
		DWORD	 num0;
		unsigned num1 : 20;
		unsigned exp  : 11;
		unsigned sig  : 1;
	};
	DD& ff = *((DD*)&f);
	unsigned __int64 qw = ff.num1;
	qw <<= 32;
	qw += ff.num0;
	qw += 0x08;
	qw &= 0xfffffffffffffff0;

	if (qw & (0x01i64 << 52))
	{
		qw = 0;
		ff.exp += 1;
	}
	ff.num0 = DWORD(qw & 0xffffffff);
	ff.num1 = qw >> 32;
} // Round (double& f).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	fli_abs
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	flint_xZkqqHx_iMfOiCmMjAoCjBmOjCgMiCpAiOfKiPgPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fli	:_xZkqqHx_jCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	fli _xZkqqHx_iCmMjAoCjBmOjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline fli_abs (flint fli)
{
	return (fli < 0) ? -fli : fli;
} // fli_abs.

// 10_xZkqqHx_jAgJjAjEjFlGiOjKjHpBiCpA_xHqqkZx___int64_xZkqqHx_iCmMjAjEjCgMiCmJjFmPiKlHiClHiCoJ_xHqqkZx_.
extern __int64 _w10toi64 (const wchar_t wcsBuf[]);

// __int64_xZkqqHx_iCmMjAjEjCgMiCpA_xHqqkZx_n_xZkqqHx_jAgJjAjEjFlGiOjKjHpBiCmJjFmPiKlHiClHiCoJ_xHqqkZx_.
extern WString _i64towcs (__int64 llNum, int iRadix);

// n_xZkqqHx_jAgJjAjEjFlGiOjKjHpBiCpA_xHqqkZx___int64_xZkqqHx_iCmMjAjEjCgMiCmJjFmPiKlHiClHiCoJ_xHqqkZx_.
extern __int64 _tcstoi64 (const _TCHAR* tcsBuf, const _TCHAR** tcpEndPtr, int iRadix);
extern __int64 _wcstoi64 (const wchar_t* wcpBuf, const wchar_t** wcpEndPtr, int iRadix);

extern unsigned __int64 _wcstoui64 (const wchar_t* tcsBuf, const wchar_t** tcpEndPtr, int iRadix);

// __int64_xZkqqHx_iCmMjAjEjCgMiCpA_xHqqkZx_10_xZkqqHx_jAgJjAjEjFlGiOjKjHpBiCmJjFmPiKlHiClFiBeBiPkMjAjEjDfPiCpAjFhEiJmBiClHiCoJ_xHqqkZx_.
extern void _i64tow10fig (__int64 llNum, wchar_t wcsBuf[],
							int iFig, int bIsCut0 = 0);

// _xZkqqHx_iOgMiOmMiMnMjDpMiClFiClNjFlGiOjKjHpBiCpAiOoGjDlOiClHiCoJ_xHqqkZx_.
extern void RoundOffStr (wchar_t wcsBuff[], double dNum,
							int iFig,int bIsCut0 = 0);
extern wchar_t* hix2histr (wchar_t wcsBuff[], hixc hix);

extern hixc histr2hix (const wchar_t* tcpStr);
extern xtmc tms2xtm (tmsc tms);
extern tmsc xtm2tms (xtmc tx);
extern wchar_t* xtm2tmsstr (wchar_t tcsBuff[], xtmc tx);
extern xtmc tmsstr2xtm (const wchar_t* tcpStr);
extern hixc RoundOff (hixc hixVal, int iFig, long lUnit);
extern hixc hixroundoff (hixc hix);
extern mmetol mmroundoff (mmetol mm);
extern DBLPoint mmroundoff (DBLPoint& mmpt);
extern DBLRect mmroundoff (DBLRect& mmrt);

extern wchar_t* dbpt2str (wchar_t tcsBuff[], dblpnt dbpt);

#endif//__UtilMath_h
