#include "stdafx.h"
#include "UtilFile.h"			// For ReadStream.
#include "UtilVirtualTable.h"	// This header.

//----- 05.12.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#ifdef _DEBUG
//#define new DEBUG_NEW
//#undef THIS_FILE
//static char THIS_FILE[] = __FILE__;
//#endif
//----- 05.12.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// FCTableIds.

FCTableIds::FCTableIds ()
{
	Clear();
} // FCTableIds::FCTableIds ();

FCTableIds::FCTableIds (const DWORD* pBegin, const DWORD* pEnd)
{
	Set(pBegin, pEnd);
} // FCTableIds::FCTableIds (const DWORD* pBegin, const DWORD* pEnd);

FCTableIds::FCTableIds (DWORD dwSize, DWORD dwId)
{
	m_dwIdsSize = dwSize;
	for (DWORD dwC = 0; dwC != dwSize; dwC++)
		m_dwIds[dwC] = dwId;
} // FCTableIds::FCTableIds (DWORD dwSize, DWORD dwId);

FCTableIds::FCTableIds (DWORD dwTableId0,
						DWORD dwTableId1,
						DWORD dwTableId2,
						DWORD dwTableId3,
						DWORD dwTableId4)
{
	Set(dwTableId0,
		dwTableId1,
		dwTableId2,
		dwTableId3,
		dwTableId4);
} // FCTableIds::FCTableIds.

void FCTableIds::Set (const DWORD* pBegin, const DWORD* pEnd)
{
	Set(pBegin, DWORD(pEnd - pBegin));
} // FCTableIds::Set.

void FCTableIds::Set (const DWORD id[], DWORD dwSize)
{
	m_dwIdsSize = dwSize;
	memcpy(m_dwIds, id, sizeof(DWORD) * dwSize);
} // FCTableIds::Set.

void FCTableIds::Set (	DWORD dwTableId0,
						DWORD dwTableId1,
						DWORD dwTableId2,
						DWORD dwTableId3,
						DWORD dwTableId4)
{
	Clear();
	do {
		if (dwTableId0 == DWORD(-1)) break;
		PushBack(dwTableId0);
		if (dwTableId1 == DWORD(-1)) break;
		PushBack(dwTableId1);
		if (dwTableId2 == DWORD(-1)) break;
		PushBack(dwTableId2);
		if (dwTableId3 == DWORD(-1)) break;
		PushBack(dwTableId3);
		if (dwTableId4 == DWORD(-1)) break;
		PushBack(dwTableId4);
	} while (FALSE);
} // void FCTableIds::Set.

DWORD FCTableIds::GetSize () const
{
	return m_dwIdsSize;
} // DWORD FCTableIds::GetSize () const;

const DWORD* FCTableIds::Get () const
{
	return m_dwIds;
} // const DWORD* FCTableIds::Get () const;

//void FCTableIds::push_back (DWORD dwId)
//{
//	m_dwIds[m_dwIdsSize] = dwId;
//	m_dwIdsSize++;
//} // void FCTableIds::push_back (DWORD dwId);
//
//DWORD& FCTableIds::back ()
//{
//	return m_dwIds[m_dwIdsSize - 1];
//} // DWORD& FCTableIds::back ();

void FCTableIds::Clear ()
{
	m_dwIdsSize = 0;
} // void FCTableIds::Dlear ();

//DWORD& FCTableIds::operator [] (DWORD dwIndex)
//{
//	return m_dwIds[dwIndex];
//} // DWORD& FCTableIds::operator [] (DWORD dwIndex);
//
//void FCTableIds::resize (DWORD dwSize)
//{
//	m_dwIdsSize = dwSize;
//} // void FCTableIds::resize (DWORD dwIndex);

const DWORD& FCTableIds::operator [] (DWORD dwIndex) const
{
	return m_dwIds[dwIndex];
} // const DWORD& FCTableIds::operator [] (DWORD dwIndex) const;

const DWORD* FCTableIds::End () const
{
	return m_dwIds + m_dwIdsSize;
} // const DWORD* FCTableIds::End () const;

FCTableIds& FCTableIds::PushBack (DWORD dwId)
{
	m_dwIds[m_dwIdsSize] = dwId;
	m_dwIdsSize++;
	return *this;
} // FCTableIds& FCTableIds::PushBack (DWORD dwId);

FCTableIds& FCTableIds::PopBack ()
{
	m_dwIdsSize--;
	return *this;
} // FCTableIds& FCTableIds::PopBack ();

FCTableIds& FCTableIds::SetLast (DWORD dwId)
{
	m_dwIds[m_dwIdsSize - 1] = dwId;
	return *this;
} // FCTableIds& FCTableIds::SetLast (DWORD dwId);

DWORD FCTableIds::GetLast () const
{
	return m_dwIds[m_dwIdsSize - 1];
} // DWORD FCTableIds::GetLast () const;

void FCTableIds::InStream (const BYTE*& pTransaction)
{
	FFReadStream(pTransaction, &m_dwIdsSize, sizeof(m_dwIdsSize));
	FFReadStream(pTransaction, m_dwIds, sizeof(DWORD) * m_dwIdsSize);
} // FFReadTableIds.

void FCTableIds::OutStream (BYTEVector& vTransaction) const
{
	vTransaction << m_dwIdsSize;
	FFWriteStream(vTransaction, m_dwIds, sizeof(DWORD) * m_dwIdsSize);
} // void FCTableIds::OutStream (BYTEVector& vTransaction) const;

bool operator < (const FCTableIds& tableIds1, const FCTableIds& tableIds2)
{
	for (DWORD dwC = 0;
		 dwC != tableIds1.m_dwIdsSize && dwC != tableIds2.m_dwIdsSize;
		 dwC++)
	{
		if (tableIds1.m_dwIds[dwC] < tableIds2.m_dwIds[dwC]) return true;
		if (tableIds1.m_dwIds[dwC] > tableIds2.m_dwIds[dwC]) return false;
	}
	return (tableIds1.m_dwIdsSize < tableIds2.m_dwIdsSize);
} // bool operator < (const FCTableIds& tableIds1, const FCTableIds& tableIds2);

bool operator != (const FCTableIds& tableIds1, const FCTableIds& tableIds2)
{
	if (tableIds1.m_dwIdsSize != tableIds2.m_dwIdsSize) return true;
	for (DWORD dwC = 0; dwC != tableIds1.m_dwIdsSize; dwC++)
		if (tableIds1.m_dwIds[dwC] != tableIds2.m_dwIds[dwC]) return true;
	return false;
} // bool operator < (const FCTableIds& tableIds1, const FCTableIds& tableIds2);

bool operator == (const FCTableIds& tableIds1, const FCTableIds& tableIds2)
{
	return !(tableIds1 != tableIds2);
} // bool operator < (const FCTableIds& tableIds1, const FCTableIds& tableIds2);

BYTEVector& operator << (BYTEVector& vStream, const FCTableIds& data)
{
	data.OutStream(vStream);
	return vStream;
} // BYTEVector& operator << (BYTEVector& vStream, const FCTableIds& data);

BYTEVector& operator << (BYTEVector& vStream, FCTableIds& data)
{
	data.OutStream(vStream);
	return vStream;
} // BYTEVector& operator << (BYTEVector& vStream, FCTableIds& data);

void FFReadData (FCTableIds& data, const BYTE*& pStream)
{
	data.InStream(pStream);
} // void FFReadData (FCTableIds& data, const BYTE*& pStream);

/////////////////////////////////////////////////////////////////////////////
// FCTableName

FCTableName::FCTableName ()
{
} // FCTableName::FCTableName.

FCTableName::FCTableName (const HString& hstrTopDirPath, const DWORD aTableIds[], DWORD dwTableIds)
			:	m_hstrTopDirPath(hstrTopDirPath),
				m_vTableIds(aTableIds, aTableIds + dwTableIds)
{
} // FCTableName::FCTableName.

FCTableName::FCTableName (const HString& hstrTopDirPath, const FCTableIds& vTableIds)
			:	m_hstrTopDirPath(hstrTopDirPath),
				m_vTableIds(vTableIds)
{
} // FCTableName::FCTableName.

FCTableName::FCTableName (	const HString& hstrTopDirPath,
							DWORD dwTableId0,
							DWORD dwTableId1,
							DWORD dwTableId2,
							DWORD dwTableId3,
							DWORD dwTableId4)
			:	m_hstrTopDirPath(hstrTopDirPath),
				m_vTableIds(dwTableId0,
							dwTableId1,
							dwTableId2,
							dwTableId3,
							dwTableId4)
{
} // FCTableName::FCTableName.

FCTableName::FCTableName (const FCTableName& tableName)
{
	operator = (tableName);
} // FCTableName::FCTableName.

FCTableName::FCTableName (const DsTableName& dsTableName)
{
	operator = (dsTableName);
} // FCTableName::FCTableName.

FCTableName::~FCTableName ()
{
//----- 05.12.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	delete[] m_hstrTopDirPath;
//	m_hstrTopDirPath = NULL;
//----- 05.12.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCTableName::FCTableName.

void FCTableName::operator = (const FCTableName& tableName)
{
	m_hstrTopDirPath = tableName.m_hstrTopDirPath;
	m_vTableIds = tableName.m_vTableIds;
} // FCTableName::operator = (const FCTableName& tableName).

void FCTableName::operator = (const DsTableName& dsTableName)
{
	m_hstrTopDirPath = HString(dsTableName.m_hstrTopDirPath.Get());
	m_vTableIds.Set(dsTableName.m_vTableIds.Get(), dsTableName.m_vTableIds.GetSize());
} // FCTableName::operator = (const DsTableName& dsTableName).

FCTableName::operator DsTableName () const
{
	DsTableName dsTableName;
	dsTableName.m_hstrTopDirPath = DsString(m_hstrTopDirPath);
	dsTableName.m_vTableIds.Set(m_vTableIds.Get(), m_vTableIds.GetSize());
	return dsTableName;
} // FCTableName::operator DsTableName () const;

void FCTableName::Clear ()
{
	m_hstrTopDirPath.Empty();
	m_vTableIds.Clear();
} // FCTableName::Clear.

DWORD FCTableName::GetSize () const
{
	return m_vTableIds.GetSize();
} // DWORD FCTableName::GetSize () const;

FCTableName& FCTableName::PushBack (DWORD dwId)
{
	m_vTableIds.PushBack(dwId);
	return *this;
} // FCTableName::PushBack.

FCTableName& FCTableName::PopBack ()
{
	m_vTableIds.PopBack();
	return *this;
} // FCTableName::PopBack.

FCTableName& FCTableName::SetLast (DWORD dwId)
{
	m_vTableIds.SetLast(dwId);
	return *this;
} // FCTableName::SetLast.

DWORD FCTableName::GetLast () const
{
	return m_vTableIds.GetLast();
} // DWORD FCTableName::GetLast () const;

const HString& FCTableName::GetTopDirPath () const
{
	return m_hstrTopDirPath;
} // const HString& FCTableName::GetTopDirPath () const;

const FCTableIds& FCTableName::GetTableIds () const
{
	return m_vTableIds;
} // const FCTableIds& FCTableName::GetTableIds () const;

WString FCTableName::GetTitle () const
{
	// _xZkqqHx_jHoB_xHqqkZx_ c:\asdf\asdf.xx|1|2
	WString wstrTitle = m_hstrTopDirPath;
	wchar_t wcBuff[100];
	for (long lC = 0; lC != m_vTableIds.GetSize(); lC++)
	{
		wstrTitle += L'|';
		wstrTitle += _ultow(m_vTableIds[lC], wcBuff, 10);
	}
	return wstrTitle;
} // WString FCTableName::GetTitle () const.

bool operator < (const FCTableName& tableName1, const FCTableName& tableName2)
{
	if (tableName1.m_hstrTopDirPath < tableName2.m_hstrTopDirPath) return true;
	if (tableName2.m_hstrTopDirPath < tableName1.m_hstrTopDirPath) return false;
	return (tableName1.m_vTableIds < tableName2.m_vTableIds);
} // operator < (const FCTableName& tableName1, const FCTableName& tableName2).

bool operator != (const FCTableName& tableName1, const FCTableName& tableName2)
{
	if (tableName1.m_hstrTopDirPath != tableName2.m_hstrTopDirPath) return true;
	return (tableName1.m_vTableIds != tableName2.m_vTableIds);
} // operator < (const FCTableName& tableName1, const FCTableName& tableName2).

bool operator == (const FCTableName& tableName1, const FCTableName& tableName2)
{
	return !(tableName1 != tableName2);
} // operator < (const FCTableName& tableName1, const FCTableName& tableName2).

BYTEVector& operator << (BYTEVector& vStream, const FCTableName& tableName)
{
	vStream << WString(tableName.GetTopDirPath());
	vStream << tableName.GetTableIds();
	return vStream;
} // BYTEVector& operator << (BYTEVector& vStream, const FCTableName& tableName);

BYTEVector& operator << (BYTEVector& vStream, FCTableName& tableName)
{
	vStream << WString(tableName.GetTopDirPath());
	vStream << tableName.GetTableIds();
	return vStream;
} // BYTEVector& operator << (BYTEVector& vStream, FCTableName& tableName);

void FFReadData (FCTableName& tableName, const BYTE*& pStream)
{
	WString wstrTopDirPath;
	FFReadData(wstrTopDirPath, pStream);
	tableName.m_hstrTopDirPath = wstrTopDirPath.c_str();
	FFReadData(tableName.m_vTableIds, pStream);
} // void FFReadData (FCTableName& tableName, const BYTE*& pStream);

/////////////////////////////////////////////////////////////////////////////
// class FCTableIndex.

// _xZkqqHx_iDgFiBfLiDhFiDiLiCmGiDeDiDjDiDgGiDgCiDeOiDfIiCmMiNfMjBkCiBeC_xHqqkZx_
//
//           _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record 0 _xZkqqHx_iEjPiEjPiEjPiEjPiEkJiEjPiEjP_xHqqkZx_ Record 1 _xZkqqHx_iEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record 2 _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_    _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record N _xZkqqHx_iEjPiEjPiEjPiEjPiEkH_xHqqkZx_
//           _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiBgDiBgDiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
//     Table _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_
//           _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiBgDiBgDiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
//           _xZkqqHx_iBkK_xHqqkZx_                        _xZkqqHx_iBkK_xHqqkZx_                  _xZkqqHx_iBkK_xHqqkZx_                            _xZkqqHx_iBkK_xHqqkZx_                              _xZkqqHx_iBkK_xHqqkZx_
//           _xZkqqHx_iEkA_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_                              _xZkqqHx_iEkA_xHqqkZx_
//           _xZkqqHx_iEkEiEjPiEkC_xHqqkZx_                    _xZkqqHx_iEkEiEkC_xHqqkZx_                _xZkqqHx_iEkEiEjPiEjPiEkC_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkBiEkD_xHqqkZx_
//               _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_
//           _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiBgDiBgDiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkC_xHqqkZx_
//     Index _xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_
//           _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiBgDiBgDiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkD_xHqqkZx_
//           _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
//           _xZkqqHx_iEkF_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJiBgDiBgDiEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkH_xHqqkZx_
//                   _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
//                   _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record 0 _xZkqqHx_iEjPiEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record 1 _xZkqqHx_iEjPiEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record 2 _xZkqqHx_iEjPiEjPiEjPiEkH_xHqqkZx_    _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record N _xZkqqHx_iEjPiEjPiEjPiEkH_xHqqkZx_
//

//----- 05.12.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//FCTableIndex::FCTableIndex (BYTE* pIndex, size_t szIndex)
//			:	m_szIndex(szIndex),
//				m_pIndex(pIndex)
//{
//} // FCTableIndex::FCTableIndex.
//----- 05.12.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
FCTableIndex::FCTableIndex (BYTE* pIndexData, DWORD dwDataSize, DWORD dwBeginIndex)
{
	m_pIndex = pIndexData;
	m_dwBeginIndex = dwBeginIndex;
	m_dwEndIndex = dwBeginIndex + ((dwDataSize - sizeof(flint)) / FD_INDEX_RECORD_SIZE);
} // FCTableIndex::FCTableIndex.
//----- 05.12.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 05.12.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//void FCTableIndex::Initialize (BYTE* pIndex, size_t szIndex)
//{
//	m_szIndex = szIndex;
//	m_pIndex = pIndex;
//} // FCTableIndex::Initialize.
//----- 05.12.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.12.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//DWORD FCTableIndex::GetCount () const
//{
//	return (m_szIndex - sizeof(flint)) / FD_INDEX_RECORD_SIZE;
//} // FCTableIndex::GetCount.
//----- 05.12.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
DWORD FCTableIndex::GetBeginIndex () const
{
	return m_dwBeginIndex;
} // FCTableIndex::GetBeginIndex.

DWORD FCTableIndex::GetEndIndex () const
{
	return m_dwEndIndex;
} // FCTableIndex::GetEndIndex.
//----- 05.12.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTableIndex::GetIndexFilePosition
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiImKjChFiBgJjAoGjDkKiCkJiCoHiCmMiDgPiDeDiDgHjAjEiBgKiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIndex	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAoGjDkKiCkJiCoHiCmMiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	BeginIndex = A_xZkqqHx_iBeB_xHqqkZx_EndIndex = N + 1 _xZkqqHx_iCmMiPoKiNiHiCmMiDgFiBfLiDhFiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCmMiNfMjBkCiBeC_xHqqkZx_
 *
 *           _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiBgDiBgDiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkC_xHqqkZx_
 *     Index _xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_PrimId_xZkqqHx_iEkA_xHqqkZx_Identi_xZkqqHx_iEkA_xHqqkZx_Addres_xZkqqHx_iEkA_xHqqkZx_
 *           _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiBgDiBgDiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkD_xHqqkZx_
 *           _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *           _xZkqqHx_iEkF_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkJiBgDiBgDiEkJ_xHqqkZx_flint-_xZkqqHx_iEkJ_xHqqkZx_DWORD-_xZkqqHx_iEkJ_xHqqkZx_flint-_xZkqqHx_iEkH_xHqqkZx_
 *                   _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
 *                   _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record A _xZkqqHx_iEjPiEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record B _xZkqqHx_iEjPiEjPiEjPiEkJiEjPiEjPiEjP_xHqqkZx_ Record C _xZkqqHx_iEjPiEjPiEjPiEkH_xHqqkZx_    _xZkqqHx_iEkFiEjPiEjPiEjP_xHqqkZx_ Record N _xZkqqHx_iEjPiEjPiEjPiEkH_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCTableIndex::GetIndexFilePosition (DWORD dwIndex) const
{
	return flint(sizeof(flint)) + (flint(dwIndex - GetBeginIndex()) * flint(FD_INDEX_RECORD_SIZE));
} // FCTableIndex::GetIndexFilePosition.

flint FCTableIndex::GetPrimaryId (DWORD dwIndex) const
{
	flint fliPrimaryId;
	memcpy(	&fliPrimaryId,
			m_pIndex + GetIndexFilePosition(dwIndex),
			sizeof(fliPrimaryId));
	return fliPrimaryId;
} // FCTableIndex::GetPrimaryId.

DWORD FCTableIndex::GetAppendIdentifier (DWORD dwIndex) const
{
	DWORD dwAppendIdentifier;
	memcpy(	&dwAppendIdentifier,
			m_pIndex + GetIndexFilePosition(dwIndex) + sizeof(flint),
			sizeof(dwAppendIdentifier));
	return dwAppendIdentifier;
} // FCTableIndex::GetAppendIdentifier.

flint FCTableIndex::GetDataFilePosition (DWORD dwIndex) const
{
	flint fliRecordPosition;
	// _xZkqqHx_iIoKiCmCjBePiCmMiImKjChFiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	memcpy(	&fliRecordPosition,
			m_pIndex + GetIndexFilePosition(dwIndex) - sizeof(flint),
			sizeof(fliRecordPosition));
	return fliRecordPosition;
} // FCTableIndex::GetDataFilePosition.

DWORD FCTableIndex::FindIndex (flint fliPrimaryId) const
{
	if (GetBeginIndex() == GetEndIndex())
		return DWORD(-1);

	DWORD dwIndexMin = GetBeginIndex();
	DWORD dwIndexMax = GetEndIndex() - 1;
	const flint fliPrimaryIdMin = GetPrimaryId(dwIndexMin);
	const flint fliPrimaryIdMax = GetPrimaryId(dwIndexMax);

	if (fliPrimaryId < fliPrimaryIdMin)
		return DWORD(-1);
	if (fliPrimaryId == fliPrimaryIdMin)
		return dwIndexMin;

	if (fliPrimaryIdMax < fliPrimaryId)
		return DWORD(-1);
	if (fliPrimaryId == fliPrimaryIdMax)
		return dwIndexMax;

	for (;;)
	{
		if (dwIndexMax - dwIndexMin < 2)
			break;
		DWORD dwIndexMid = (dwIndexMin + dwIndexMax) / 2;
		const flint fliPrimaryIdMid = GetPrimaryId(dwIndexMid);
		if (fliPrimaryId < fliPrimaryIdMid)
			dwIndexMax = dwIndexMid;
		else
		if (fliPrimaryIdMid < fliPrimaryId)
			dwIndexMin = dwIndexMid;
		else
			return fliPrimaryIdMid;
	}
	return DWORD(-1);
} // FCTableIndex::FindIndex.

//----- 05.12.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//void FCTableIndex::OffsetTableFilePosition (flint fliPositionOffset)
//{
//	DWORD dwIndex;
//	for (dwIndex = 0; dwIndex != GetCount(); dwIndex++)
//	{
//		flint fliRecordPosition;
//		memcpy(	&fliRecordPosition,
//				m_pIndex + GetIndexFilePosition(dwIndex) + sizeof(flint) + sizeof(DWORD),
//				sizeof(fliRecordPosition));
//		fliRecordPosition += fliPositionOffset;
//		memcpy(	m_pIndex + GetIndexFilePosition(dwIndex) + sizeof(flint) + sizeof(DWORD),
//				&fliRecordPosition,
//				sizeof(fliRecordPosition));
//	}
//} // FCTableIndex::OffsetTableFilePosition.
//----- 05.12.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

DWORD FCTableIndex::GetRecordSize (DWORD dwIndex) const
{
	return DWORD(GetDataFilePosition(dwIndex + 1) - GetDataFilePosition(dwIndex));
} // FCTableIndex::GetRecordSize.

/////////////////////////////////////////////////////////////////////////////

//----- 05.12.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//void FFReadTableIds (const BYTE*& pTransaction, FCTableIds& vTableIds)
//{
//	DWORD dwTableIds;
//	FFReadStream(pTransaction, &dwTableIds, sizeof(dwTableIds));
//	vTableIds.resize(dwTableIds);
//	FFReadStream(pTransaction, &vTableIds[0], sizeof(DWORD) * dwTableIds);
//} // FFReadTableIds.
//
//void FFWriteTableIds (BYTEVector& vTransaction, const FCTableIds& vTableIds)
//{
//	vTransaction << DWORD(vTableIds.size());
//	FFWriteStream(vTransaction, &vTableIds[0], sizeof(DWORD) * vTableIds.size());
//} // FFWriteTableIds.
//----- 05.12.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.12.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//void FFGetControlIds (FCTableIds& vControlIds, const FCTableIds& vTableIds)
//{
//	vControlIds = vTableIds;
//	vControlIds.back() = CONTROL_TABLE_ID;
//} // FFGetControlIds.
//
//void FFGetSubControlIds (FCTableIds& vSubControlIds, const FCTableIds& vGroupIds)
//{
//	vSubControlIds = vGroupIds;
//	vSubControlIds.push_back(CONTROL_TABLE_ID);
//} // FFGetSubControlIds.
//
//void FFGetSubControlIds (FCTableName& subControlIds, const FCTableName& groupIds)
//{
//	subControlIds = groupIds;
//	subControlIds.PushBack(CONTROL_TABLE_ID);
//} // FFGetSubControlIds.
//----- 05.12.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

WString FFGetFilePath (const FCTableIds& vTableIds)
{
	WString wstrFilePath;
	wchar_t wszBuff[100];
	for (size_t szC = 0; szC != vTableIds.GetSize(); szC++)
	{
		wstrFilePath += L'\\';
		wstrFilePath += _ultow(vTableIds[szC], wszBuff, 10);
	}
	return wstrFilePath;
} // FFGetFilePath.

WString FFGetFilePath (const FCTableName& tableName)
{
	return WString(tableName.m_hstrTopDirPath) + FFGetFilePath(tableName.m_vTableIds);
} // FFGetFilePath.

