#include "stdafx.h"
#if defined(_IME_ON)
#include <imm.h>
#endif // defined(_IME_ON)

//----------<NOT EXPORT TO VIEWER>-----------
#include <float.h>			// For DBL_MAX.
#include <winuser.h>		// For EnumDisplayMonitors.
#include "DynamicDraw.h"	// For CFCMolipDrawApp.
#include "UtilStr.h"		// For StrNewCpy.
#include "UtilErr.h"		// For FFMessageBox.
#include "UtilFile.h"		// For SplitFileName.
#include "UtilMisc.h"		// For FFVersionInfo.etc.
#include "RegData.h"		// For GetLocalAppName.
//----------</NOT EXPORT TO VIEWER>-----------
#include "FrameWnd.h"		// For FFGetMainWnd().
#include "DynamicDrawView.h"// For g_pView.
#include "UtilWin.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----------<NOT EXPORT TO VIEWER>-----------

static const wchar_t* s_tcpWinInfoName = L"WindowInfo";

// _xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDjClHiBeC_xHqqkZx_
static const long _MAX_COMMAND_LINE_LEN = 1020;	// Windows_xZkqqHx_jAkHiMmAjCgMiCmN_xHqqkZx_1024_xZkqqHx_iBeC_xHqqkZx_

//////////////////////////////////////////////////////////////////////////////
// FCWinTitleRec_xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCWinTitleRec::FCWinTitleRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCWinTitleRec::FCWinTitleRec ()
{
	hwndApp = NULL;
} // FCWinTitleRec::FCWinTitleRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCWinTitleRec::FCWinTitleRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcp		:_xZkqqHx_iDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.12.20 Fukushiro M. OtherAppList_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
FCWinTitleRec::FCWinTitleRec (HWND hwnd, const wchar_t* tcp)
{
	hwndApp = hwnd;
	atpTitle = WCharAuto(StrNewCpy(tcp));
} // FCWinTitleRec::FCWinTitleRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	= _xZkqqHx_iDeJiDhJiDiMiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.12.20 Fukushiro M. OtherAppList_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
FCWinTitleRec::operator = (const FCWinTitleRec& rec)
{
	hwndApp = rec.hwndApp;
	atpTitle = rec.atpTitle;
} // FCWinTitleRec::operator =.

////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiNiBfLiDeKiDiLiKnGjAjEiDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myEnumWindowsProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumWinTitle_xZkqqHx_iKnGjAjEjCiGiCmFiOgHjHhAiClDiCoKiCoJiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeCiDgHiDgCiDhGiDiMiDhIiDiL_xHqqkZx_
 *			_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAjHpBiLjDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *			lParam	:EnumWinTitle_xZkqqHx_iKnGjAjEiCmFiOhHjCoIiClDiCoKiClNjCgMiBeCiClBiCmMiPoKiNiHiCmN_xHqqkZx_vector<HWND>_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCkEiCmFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.12.20 Fukushiro M. OtherAppList_xZkqqHx_iCkJiCoHiInKjDkOiBjFiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
static BOOL CALLBACK myEnumWindowsProc (HWND hwnd, LPARAM lParam)
{
	((vector<HWND>*)lParam)->push_back(hwnd);
	return TRUE;
} // myEnumWindowsProc.

struct myFTWaitProc
{
	myFTWaitProc (DWORD dwa, HWND hwnd, DWORD dwb)
					: dwProcID(dwa), hWndMsg(hwnd), dwQuitMsg(dwb) {}
	DWORD dwProcID;
	HWND hWndMsg;
	DWORD dwQuitMsg;
}; // struct myFTWaitProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myWaitForExeQuit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MolipDraw.exe_xZkqqHx_iCmMiPeJjHlJiCpAiKmEiOiLiClHiCoJiDfIiDiMiDgCiDgIiDhGiDiNiDePiDiJiDiAiBeC_xHqqkZx_
 *			MolipDraw.exe_xZkqqHx_iCkKiPeJjHlJiClFiClNiCoHiBeBiDiBiDeDiDjDiDhEiDiMiBfLiDiAiCmJiPeJjHlJiDiBiDgCiDfKiBfLiDfHiCpA_xHqqkZx_
 *			_xZkqqHx_jBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	MolipDraw.exe_xZkqqHx_iCmMiDhGiDiNiDfKiDfIiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfIiDiMiDgCiDgIiCmMjAkMiMpHiBeFiOlIjEhDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static DWORD WINAPI myWaitForExeQuit (LPVOID pvoid)
{
	// _xZkqqHx_iDhGiDiNiDfKiDfI_xHqqkZx_ID_xZkqqHx_iCmGjBjHjFhEiDiBiDgCiDfKiBfLiDfHiCpAiOoGjDlOiBeC_xHqqkZx_
	myFTWaitProc* pData = (myFTWaitProc*)pvoid;
	// _xZkqqHx_iDhGiDiNiDfKiDfI_xHqqkZx_ID_xZkqqHx_iCkJiCoHiDgOiDjDiDgIiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
	HANDLE hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, pData->dwProcID);
	// MolipDraw.exe_xZkqqHx_iDhGiDiNiDfKiDfIiCkKiPeJjHlJiClHiCoJiCnMiCmFiBeBjGlDjAkHiMmAiCmFjBnCiCmCiBeC_xHqqkZx_
	WaitForSingleObject(hProcess, INFINITE);
	// MolipDraw.exe_xZkqqHx_iDgOiDjDiDgIiDiLiCmNiCoAiCkEiOgHiCoNiCmIiCkCiCkJiCoHiDeOiDiNiBfLiDfJiClHiCoJiBeC_xHqqkZx_
	CloseHandle(hProcess);
	// _xZkqqHx_iDiBiDeDiDjDiDhEiDiMiBfLiDiAiCnG_xHqqkZx_MolipDraw.exe_xZkqqHx_iPeJjHlJiCpAjCmKjCgNiBeC_xHqqkZx_
	PostMessage(pData->hWndMsg, pData->dwQuitMsg, 0, 0);
	// _xZkqqHx_iDgGiBfLiDfOjHmMiIoGiCpAiKeKjFpKiBeC_xHqqkZx_
	delete pData;
	// _xZkqqHx_jAlDiPoNiPeJjHlJiBeC_xHqqkZx_
    return S_OK;
} // myWaitForExeQuit.

////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDePiDiNiBfLiDgPiDiLiKnGjAjEiDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	EnumWinTitle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhEiDiMiBfLiDiAiDfOiDeDiDgHiDiLiCmGjDkPiClGjFlGiOjKjHpBiCpAiDeFiDeCiDjDiDgIiDeFiDfOiDeDiDgHiDiLjFlGiOjKjHpB_xHqqkZx_
 *			_xZkqqHx_iMoDjFpLiCmJiOjNiCmCiDeFiDeCiDjDiDgIiDeFjBfDiCmEiCpAjHpBiLjDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vWinTtl		:_xZkqqHx_jHpBiLjDiClFiClNiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiBhLiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
//----- 03.09.15 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
// *			tcpAppTitle	:_xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiDfOiDeDiDgHiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_NULL_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_
// *						 _xZkqqHx_iClBiCmMiDeBiDhGiDiKiCpAiOhHjCoIiBeC_xHqqkZx_
//----- 03.09.15 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 03.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//void EnumWinTitle (FCWinTitleRecVector& vWinTtl, const wchar_t* tcpAppTitle)
//{
//	//----- _xZkqqHx_iDeBiDhGiDiKiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
//	WString strAppTitle;
//	if (tcpAppTitle == NULL)
//		FFGetApp()->GetDocString(strAppTitle, CDocTemplate::windowTitle);
//	else
//		strAppTitle = tcpAppTitle;
//	//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
//	WString strTitle;
//	strTitle.Format(L" - %s", (const wchar_t*)strAppTitle);
//	DWORDVector vHwnd;
//	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFjHpBiLjDiBeC_xHqqkZx_
//	::EnumWindows(myEnumWindowsProc, LPARAM(&vHwnd));
//	for (DWORDVector::iterator iHwnd = vHwnd.begin(); iHwnd != vHwnd.end(); iHwnd++)
//	{
//		const HWND hwnd = HWND(*iHwnd);
//		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDfOiDeDiDgHiDiLiDgFiDeMiDfIiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
//		wchar_t tcsBuff[_MAX_PATH * 4];
//		FFGetWindowText(hwnd, tcsBuff, sizeof(tcsBuff) / sizeof(tcsBuff[0]));
//		// _xZkqqHx_iDfOiDeDiDgHiDiLiDgFiDeMiDfIiDgHiCmMiNmFiMoDiCkKjEoEiKhCjFlGiOjKjHpBiCmGiIoKjChGiClFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
//		int iLen = wcslen(tcsBuff) - strTitle.GetLength();
//		if (iLen < 0 || strTitle != (tcsBuff + iLen)) continue;
//		tcsBuff[iLen] = L'\0';
//		vWinTtl.push_back(FCWinTitleRec(hwnd, tcsBuff));
//	}
//} // EnumWinTitle.
//----- 03.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
void EnumWinTitle (FCWinTitleRecVector& vWinTtl)
{
	vector<HWND> vHwnd;
	// _xZkqqHx_iMlLiNnNiCmMiDeFiDeCiDjDiDgIiDeFjHpBiLjDiBeC_xHqqkZx_
	::EnumWindows(myEnumWindowsProc, LPARAM(&vHwnd));
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiDeBiDhGiDiKiCmMiDeFiDeCiDjDiDgIiDeFiIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
	set<HWND> stAppHwnd;
	g_pReg->GetActiveWinList(stAppHwnd);
	for (vector<HWND>::iterator iHwnd = vHwnd.begin(); iHwnd != vHwnd.end(); iHwnd++)
	{
		if (stAppHwnd.find(*iHwnd) != stAppHwnd.end())
		{
			WString wstrDoc = g_pReg->GetActiveWinAndInfo(*iHwnd, L"WinTitle");
			vWinTtl.push_back(FCWinTitleRec(*iHwnd, wstrDoc));
		}
	}
} // EnumWinTitle.
//----- 03.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFFindDdDocumentWindow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLjGlMiBgJjFlGiPjBjGlMiCmFiCoAjHmHiCkCiBgKiBeBiDeBiDhGiDiKjGlMiCmMiDeFiDeCiDjDiDgIiDeF_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeCiMmEiCnBiPgPiClFiMlDiCmMiDeFiDeCiDjDiDgIiDeFiCmNjBmOiPnLiCkJiCoHiPjMiKePiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpDocTitle	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			hwndFrom	:_xZkqqHx_iMmEiCnBiPgPiClFiMlDiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 03.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//HWND FFFindDdDocumentWindow (const wchar_t* tcpDocTitle, const wchar_t* tcpAppTitle, HWND hwndFrom)
//{
//	// _xZkqqHx_jDkPiClGiDeBiDhGiDiKiCmMiDeFiDeCiDjDiDgIiDeFjHpBiLjDiBeC_xHqqkZx_
//	FCWinTitleRecVector vWinTtl;
//	EnumWinTitle(vWinTtl, tcpAppTitle);
//	FCWinTitleRecVector::const_iterator iWin;
//	for (iWin = vWinTtl.begin(); iWin != vWinTtl.end(); iWin++)
//		if ((*iWin).hwndApp != hwndFrom &&
//// 01.05.08 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////			_tcscmp(tcpDocTitle, (*iWin).atpTitle.get()) == 0) return (*iWin).hwndApp;
//			_wcsicmp(tcpDocTitle, (*iWin).atpTitle.get()) == 0) return (*iWin).hwndApp;
//	return NULL;
//} // FFFindDdDocumentWindow.
//----- 03.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
HWND FFFindDdDocumentWindow (const wchar_t* tcpDocTitle, HWND hwndFrom)
{
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiDeBiDhGiDiKiCmMiDeFiDeCiDjDiDgIiDeFiIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
	set<HWND> stAppHwnd;
// 06.02.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	g_pReg->GetActiveWinList(stAppHwnd);
	g_pReg->GetActiveWinList(stAppHwnd, GetSpecAppName(FD_APPMODE_DYNAMICDRAW));
	for (set<HWND>::iterator iHwnd = stAppHwnd.begin(); iHwnd != stAppHwnd.end(); iHwnd++)
	//----- _xZkqqHx_jDkPiIoKiDeBiDhGiDiKiCmMiDeFiDeCiDjDiDgIiDeFiIoKjHjHiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		if (*iHwnd != hwndFrom)
		//----- _xZkqqHx_iMmEiCnBiPgPiClFiMlDiDeFiDeCiDjDiDgIiDeFiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCkJiCoHiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
			WString wstrTmpWinTitle = g_pReg->GetActiveWinAndInfo(*iHwnd, L"WinTitle");
			if (_wcsicmp(tcpDocTitle, wstrTmpWinTitle) == 0)
				return *iHwnd;
		}
	}
	return NULL;
} // FFFindDdDocumentWindow.
//----- 03.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFFindHidocumentWindow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiNiDfHiDeGiDeOiDgHiBeFjHjKjHpAjFlGiPjBiCpAiKeKiCkCiCmEiCkCiCoJjDkPiIoKiDeBiDhGiDiKiCmM_xHqqkZx_
 *			_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAjCfEiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocId			:_xZkqqHx_jHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			hwndFrom		:_xZkqqHx_iMmEiCnBiPgPiClFiMlDiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpAppName		:_xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDjGlMiCpAiOhHjCoIiBeC_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmN_xHqqkZx_
 *							 GetLocalAppName_xZkqqHx_iKnGjAjEiCmMjCgMiCpAiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDeDiDjDiDhEiDiMiBfLiDiAiCmMiDeFiDeCiDjDiDgIiDeFiCpAjFnEiClHiBeCjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HWND FFFindHidocumentWindow (const wchar_t* wcpProjectPath, long lDocId, HWND hwndFrom, const wchar_t* wcpAppName)
{
	if (wcpAppName == NULL) wcpAppName = GetLocalAppName();
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiDeBiDhGiDiKiCmMiDeFiDeCiDjDiDgIiDeFiIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
	set<HWND> stAppHwnd;
	g_pReg->GetActiveWinList(stAppHwnd, wcpAppName);
	for (set<HWND>::iterator iHwnd = stAppHwnd.begin(); iHwnd != stAppHwnd.end(); iHwnd++)
	//----- _xZkqqHx_jDkPiIoKiDeBiDhGiDiKiCmMiDeFiDeCiDjDiDgIiDeFiIoKjHjHiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		if (*iHwnd != hwndFrom)
		//----- _xZkqqHx_iMmEiCnBiPgPiClFiMlDiDeFiDeCiDjDiDgIiDeFiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCkJiCoHiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
			WString wstrTmpProjectPath = g_pReg->GetActiveWinAndInfo(*iHwnd, L"ProjectPath", wcpAppName);
			// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCkJiCoHiBeBjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
			WString wstrTmpDocId = g_pReg->GetActiveWinAndInfo(*iHwnd, L"DocId", wcpAppName);
			long lTmpDocId = -1L;
			if (!wstrTmpDocId.IsEmpty())
				lTmpDocId = wcstol(wstrTmpDocId, NULL, 10);
			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiBeBjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCkKiIoKjChGiClHiCoJiPoKiNiHiCmN_xHqqkZx_HWND_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
			if (wstrTmpProjectPath.CompareNoCase(wcpProjectPath) == 0 &&
				lTmpDocId == lDocId)
			{
				if (IsWindow(*iHwnd))
				//----- _xZkqqHx_jHeMiMpIiCmIiDeFiDeCiDjDiDgIiDeFiCmMiPoKiNiH_xHqqkZx_ -----
				{
					return *iHwnd;
				} else
				//----- _xZkqqHx_jGlDiMpIiCmIiDeFiDeCiDjDiDgIiDeFiCmMiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMjDgPjIfOiCpAjGjFiPmBiBeC_xHqqkZx_
					g_pReg->DeleteActiveWinAndInfo(*iHwnd, wcpAppName);
				}
			}
		}
	}
	return NULL;
} // FFFindHidocumentWindow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	ExecMolipDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhAiDiJiDiBiBfLiDfOjFlGiOjKiCpAjFhEiJmBiClFiCmEiBeB_xHqqkZx_MolipDraw.exe _xZkqqHx_iCpAiLeOjDkOiClHiCoJiBeC_xHqqkZx_
 *			dwQuitMsg_xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBiLeOjDkOiClFiClN_xHqqkZx_EXE_xZkqqHx_iCpAiDfIiDiMiDgCiDgIiCmFiKmEiOiLiClFiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iPeJjHlJiOjOiCmJ_xHqqkZx_ dwQuitMsg _xZkqqHx_iCpAiDhEiDiMiBfLiDiAiCmJiDhMiDfIiDgHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	szParam		:_xZkqqHx_iLeOjDkOiOjOiDhAiDiJiDiBiBfLiDfOiCpAiOhHjCoIiBeCjFhDjHhGiCmIiCoHiCmO_xHqqkZx_ NULL _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwQuitMsg	:_xZkqqHx_iPeJjHlJiOjOiCmMjBjHjAeNiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_0 _xZkqqHx_iCmIiCoHiCmO_xHqqkZx_
 *						 _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHjAeNiClFiCmIiCkCiBeC_xHqqkZx_
 *			hWndMsg		:_xZkqqHx_iPeJjHlJiOjOiCmMjBjHjAeNiDiBiDgCiDfKiBfLiDfHiCmMjBjHjAeNjAoGiBeC_xHqqkZx_NULL _xZkqqHx_iCmIiCoHiCmO_xHqqkZx_
 *						 _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHjAeNiClFiCmIiCkCiBeC_xHqqkZx_
 *			dwQuitMsg	:_xZkqqHx_iPeJjHlJiOjOiCmMjBjHjAeNiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pdwThreadID	:_xZkqqHx_iLeOjDkOiClFiClN_xHqqkZx_ EXE _xZkqqHx_iCmMiDfIiDiMiDgCiDgI_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_NULL _xZkqqHx_iCmIiCoHiCmO_xHqqkZx_
 *						 _xZkqqHx_jFnEiClDiCmIiCkCiBeC_xHqqkZx_
 *			pdwProcID	:_xZkqqHx_iLeOjDkOiClFiClN_xHqqkZx_ EXE _xZkqqHx_iCmMiDhGiDiNiDfKiDfI_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_NULL _xZkqqHx_iCmIiCoHiCmO_xHqqkZx_
 *						 _xZkqqHx_jFnEiClDiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLeOjDkOiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL ExecMolipDraw (const wchar_t* szParam, HWND hWndMsg, DWORD dwQuitMsg,
						DWORD* pdwThreadId, DWORD* pdwProcId)
{
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	// Initialize the STARTUPINFO structure.
	memset(&si, 0, sizeof(si));
	si.cb = sizeof(si);
	//----- _xZkqqHx_iLeOjDkOiDhAiDiJiDiBiBfLiDfOiCmMjFlGiOjKjHpBiCpAiNoMiCoJ_xHqqkZx_ -----
	_TCHAR szLine[5000];
	if (szParam != NULL && *szParam != L'\0')
		_stprintf(szLine, _T("%s %s"), (const _TCHAR*)WStrToTStr(FFGetMolipExePath()),
										(const _TCHAR*)WStrToTStr(szParam));
	else
		_tcscpy(szLine, WStrToTStr(FFGetMolipExePath()));
	// _xZkqqHx_iLeOjDkOiDhAiDiJiDiBiBfLiDfOiCkK_xHqqkZx_Windows_xZkqqHx_iCmMjAkHiMmAiCpAjClEiCkGiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (_MAX_COMMAND_LINE_LEN < _tcslen(szLine)) return FALSE;

	//----- MolipDraw.exe_xZkqqHx_iCpAiLeOjDkOiClHiCoJ_xHqqkZx_ -----
	if (!CreateProcess(
		NULL,	// pointer to name of executable module
		szLine,	// pointer to command line string
		NULL,	// pointer to process security attributes
		NULL,	// pointer to thread security attributes
		FALSE,	// handle inheritance flag
		0,		// creation flags
		NULL,	// pointer to new environment block
		NULL,	// pointer to current directory name
		&si,	// pointer to STARTUPINFO
		&pi		// pointer to PROCESS_INFORMATION
	   ))
	{
		// IDS_ERR_MSG_FAIL_START_EXE = "_xZkqqHx_iOmAiNhDiDhEiDeAiDeDiDiLiCmMiLeOjDkOiCmJiOlIjEhDiClFiCnMiClFiClN_xHqqkZx_"
		::FFErrorBox(IDS_ERR_MSG_FAIL_START_EXE);
		return FALSE;
	}
	// MolipDraw.exe_xZkqqHx_iCkKiKkOjBfDiCmJiLeOjDkOiClHiCoJ_xHqqkZx_(_xZkqqHx_iDiGiBfLiDfFjDpMjHmNjBnCiClPiPpDjBnEiCmJiCmIiCoJ_xHqqkZx_)_xZkqqHx_iCmMiCpAjBnCiCmCiBeC_xHqqkZx_
	if (WaitForInputIdle(pi.hProcess, 10000) != 0)
//	if (WaitForInputIdle(pi.hProcess, 10000000) != 0)
	{
		TerminateProcess(pi.hProcess, 0);
		// IDS_ERR_MSG_FAIL_START_EXE = "_xZkqqHx_iOmAiNhDiDhEiDeAiDeDiDiLiCmMiLeOjDkOiCmJiOlIjEhDiClFiCnMiClFiClN_xHqqkZx_"
		::FFErrorBox(IDS_ERR_MSG_FAIL_START_EXE);
		return FALSE;
	}
	// _xZkqqHx_iDfIiDiMiDgCiDgI_xHqqkZx_ID_xZkqqHx_iBeBiDhGiDiNiDfKiDfI_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (pdwThreadId != NULL) *pdwThreadId = pi.dwThreadId;
	if (pdwProcId != NULL) *pdwProcId = pi.dwProcessId;
	// CreateProcess_xZkqqHx_iCmFiKgNjFnLiClDiCoKiClNiDgOiDjDiDgIiDiLiCpAiJpAjFpK_xHqqkZx_(MolipDraw.exe_xZkqqHx_iCmNiPeJjHlJiClFiCmIiCkC_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
	CloseHandle(pi.hThread);
	CloseHandle(pi.hProcess);
	if (hWndMsg != NULL)
	//----- _xZkqqHx_iPeJjHlJiDiBiDgCiDfKiBfLiDfHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfIiDiMiDgCiDgIiCmJjDgOiClHiNfMjBkCjBmMiCpAiNoMjAkMiBeC_xHqqkZx_
		myFTWaitProc* pData = new myFTWaitProc(pi.dwProcessId, hWndMsg, dwQuitMsg);
		// MolipDraw.exe_xZkqqHx_iPeJjHlJiKmEiOiLiDfIiDiMiDgCiDgIiCpAiLeOjDkOiBeC_xHqqkZx_
		DWORD dwThreadId;
		// _xZkqqHx_iDfIiDiMiDgCiDgIiCpAiLeOjDkOiBeC_xHqqkZx_
		HANDLE hThread =
			CreateThread(NULL, 0, (PTHREAD_START_ROUTINE)myWaitForExeQuit,
						(LPVOID)pData, 0, &dwThreadId);
		// _xZkqqHx_iDfIiDiMiDgCiDgIiDgOiDjDiDgIiDiLiCpAiKeKjFpKiBeCiDfIiDiMiDgCiDgIiCmNiPeJjHlJiClFiCmIiCkCiBeC_xHqqkZx_
		CloseHandle(hThread);
	}
	return TRUE;
} // ExecMolipDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	ExecAndWaitApp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MolipDraw.exe_xZkqqHx_iCmGjDkPiClGiDhEiDeIiDiLiDfPiCmJiCkAiCoJiOhHjCoIiCmMiDeBiDhGiDiKiCpAiOmAiNhDiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iDeBiDhGiDiKiCkKiPeJjHlJiClHiCoJiCnMiCmFjBnCiCmCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	szAppPath	:_xZkqqHx_iDeBiDhGiDiKiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szParam		:_xZkqqHx_iDeBiDhGiDiKiCmMiIpIjAjEiOhHjCoIiBeCjFhDjHhGiCmIiCoHiCmO_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *			dwMillisec	:_xZkqqHx_iDeBiDhGiDiKiPeJjHlJiCnMiCmFiCmMjBnCiClPiOjOiKnEiCpAiOhHjCoIiBeCjGlDiMmAiCmJjBnCiCmCiPoKiNiHiCmN_xHqqkZx_
 *						 INFINITE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiPeJjHlJiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL ExecAndWaitApp (const wchar_t* szAppName, const wchar_t* szParam, DWORD dwMillisec)
{
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	// Initialize the STARTUPINFO structure.
	memset(&si, 0, sizeof(si));
	si.cb = sizeof(si);

	//----- _xZkqqHx_iLeOjDkOiDhAiDiJiDiBiBfLiDfOiCmMjFlGiOjKjHpBiCpAiNoMiCoJ_xHqqkZx_ -----
	// MolipDraw.exe_xZkqqHx_iCmMjBlGiNnNiClHiCoJiDhAiDfIiCpAiOoGiCoIiPgPiClHiBeCiDhAiDfIiNmFiMoDiCmJ_xHqqkZx_"\"_xZkqqHx_iCkKjFhEiCkCiCmEiCkCiCoJiBeC_xHqqkZx_
//----- 03.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	WString strDirPath;
//	FFSplitFileName(&strDirPath, NULL, NULL, FFGetMolipExePath());
//----- 03.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString strDirPath = FFGetFileDirectory(FFGetMolipExePath());
//----- 03.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDhAiDiJiDiBiBfLiDfOiNoMjAkMiBeCiDhEiDeAiDeDiDiLjGlMiCmN_xHqqkZx_""_xZkqqHx_iCmFiImNiCnOiBeCiDfIiDhJiBfLiDfIjDpMiCoIiDhEiDeAiDeDiDiLjGlMiCmJjBmOiJjOiBeC_xHqqkZx_
	_TCHAR szLine[5000];
	_stprintf(szLine, _T("\"%s%s\""), (const _TCHAR*)WStrToTStr(strDirPath),
										(const _TCHAR*)WStrToTStr(szAppName));
	if (szParam != NULL && *szParam != L'\0')
	{
		_tcscat(szLine, _T(" "));
		_tcscat(szLine, WStrToTStr(szParam));
	}
//----- 05.08.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iLeOjDkOiDhAiDiJiDiBiBfLiDfOiCkK_xHqqkZx_Windows_xZkqqHx_iCmMjAkHiMmAiCpAjClEiCkGiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (_MAX_COMMAND_LINE_LEN < _tcslen(szLine)) return FALSE;
//----- 05.08.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	//----- MolipDraw.exe_xZkqqHx_iCpAiLeOjDkOiClHiCoJ_xHqqkZx_ -----
	if (!CreateProcess(
		NULL,	// pointer to name of executable module
		szLine,	// pointer to command line string
		NULL,	// pointer to process security attributes
		NULL,	// pointer to thread security attributes
		FALSE,	// handle inheritance flag
		0,		// creation flags
		NULL,	// pointer to new environment block
		NULL,	// pointer to current directory name
		&si,	// pointer to STARTUPINFO
		&pi		// pointer to PROCESS_INFORMATION
	   ))
	{
		// IDS_ERR_MSG_FAIL_START_EXE = "_xZkqqHx_iOmAiNhDiDhEiDeAiDeDiDiLiCmMiLeOjDkOiCmJiOlIjEhDiClFiCnMiClFiClN_xHqqkZx_"
		::FFErrorBox(IDS_ERR_MSG_FAIL_START_EXE);
		return FALSE;
	}
	// MolipDraw.exe_xZkqqHx_iCkKiKkOjBfDiCmJiLeOjDkOiClHiCoJ_xHqqkZx_(_xZkqqHx_iDiGiBfLiDfFjDpMjHmNjBnCiClPiPpDjBnEiCmJiCmIiCoJ_xHqqkZx_)_xZkqqHx_iCmMiCpAjBnCiCmCiBeC_xHqqkZx_
	if (WaitForInputIdle(pi.hProcess, dwMillisec) != 0)
	{
		TerminateProcess(pi.hProcess, 0);
		// IDS_ERR_MSG_FAIL_START_EXE = "_xZkqqHx_iOmAiNhDiDhEiDeAiDeDiDiLiCmMiLeOjDkOiCmJiOlIjEhDiClFiCnMiClFiClN_xHqqkZx_"
		::FFErrorBox(IDS_ERR_MSG_FAIL_START_EXE);
		return FALSE;
	}
//----- 01.06.20 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// MolipDraw.exe_xZkqqHx_iDhGiDiNiDfKiDfIiCkKiPeJjHlJiClHiCoJiCnMiCmFjBnCiCmCiBeC_xHqqkZx_
//	while (WaitForSingleObject(pi.hProcess, dwMillisec) == WAIT_TIMEOUT)
//	{
//		// _xZkqqHx_iDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiCkKiPeJjHlJiClFiCnMiClJiCpBiBeCiNoMiLmGiCpAiMhAjBlBiClFiCnMiClHiCkJiBeI_xHqqkZx_
//		if (FFMessageBox(IDS_ERR_MSG_IS_CONTINUE_CONVERT, 0, MB_YESNO) == IDNO)
//		{
//			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfCiDjDiDgPiBfLiDfOiCpAiLkNjAkHiPeJjHlJiBeC_xHqqkZx_
//			TerminateProcess(pi.hProcess, 0);
//			// CreateProcess_xZkqqHx_iCmFiKgNjFnLiClDiCoKiClNiDgOiDjDiDgIiDiLiCpAiJpAjFpKiBeC_xHqqkZx_
//			CloseHandle(pi.hThread);
//			CloseHandle(pi.hProcess);
//			return FALSE;
//		}
//	}
//----- 01.06.20 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// CreateProcess_xZkqqHx_iCmFiKgNjFnLiClDiCoKiClNiDgOiDjDiDgIiDiLiCpAiJpAjFpKiBeC_xHqqkZx_
	CloseHandle(pi.hThread);
	CloseHandle(pi.hProcess);
	return TRUE;
} // ExecAndWaitApp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myETWProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumThreadWindows_xZkqqHx_iKnGjAjEiCmMiDfCiBfLiDiLiDgPiDgCiDeOiBeCjGhLiKnGjAjEiCmNiBeBiCkAiCoJiDfIiDiMiDgCiDgIiCmJ_xHqqkZx_
 *			_xZkqqHx_iKnGiClHiCoJiDeFiDeCiDjDiDgIiDeFiCkK_xHqqkZx_hwnd_xZkqqHx_iCmJjAnNjCoIiClDiCoKiCmEiOjPiBfIiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			hwnd_xZkqqHx_iCkKiDiBiDeDiDjDiDhEiDiMiBfLiDiAiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_jClCiCnHiCoJjBmOiPnLiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *			lParam	:hwnd_xZkqqHx_iCkKiDiBiDeDiDjDiDhEiDiMiBfLiDiAiCmMiOjOiCmJiBeB_xHqqkZx_hwnd_xZkqqHx_iCpAjFnEiClHjFmPjAjEiCmMiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHpBiLjDiCpAjBlBiCkPiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiPeJjHlJiClHiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.03.29 Fukushiro M. FoundDoc_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *			99.12.21 Fukushiro M. DynamicDrawDoc_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *			00.04.27 Fukushiro M. CommonDrawDoc_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *			00.04.27 Fukushiro M. _xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCkK_xHqqkZx_NULL_xZkqqHx_iCmMiPoKiNiHiCpAjElLjCgGiKoOiPiAiCmJiBeC_xHqqkZx_
 *************************************************************************/
static BOOL CALLBACK myETWProc (HWND hwnd, LPARAM lParam)
{
	HWND* hwdp = (HWND*)lParam;
//----- 02.10.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (WindowsXP+SP1_xZkqqHx_iCmFiBeBiDgAiDgCiDhGiDeHiDgGiDeCiDfOiCkKjAlDiPoNiCmJiLeOjDkOiClJiClIiBeBiDiNiDgCiDeOiClFiCmEiClFiCnMiCkE_xHqqkZx_)-----
//	if (GetParent(hwnd) == NULL)
//	{
//		*hwdp = (HWND)hwnd;
//		return FALSE;	// _xZkqqHx_iClBiClBiCmFjHpBiLjDiPiIjHjNiCmNiPeJiCoNiCoIiBeC_xHqqkZx_
//	}
//	return TRUE;
//----- 02.10.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (WindowsXP+SP1_xZkqqHx_iCmFiBeBiDgAiDgCiDhGiDeHiDgGiDeCiDfOiCkKjAlDiPoNiCmJiLeOjDkOiClJiClIiBeBiDiNiDgCiDeOiClFiCmEiClFiCnMiCkE_xHqqkZx_)-----
	// _xZkqqHx_iClBiClBiCmFiCmNiBeB_xHqqkZx_if (GetParent(hwnd) == NULL) _xZkqqHx_iCmFiMjPiNpFiClFiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	// MainFrame _xZkqqHx_iCmMjAgFiCkKjGlDiCkCiCmGiCmNiMmAiCoHiCmIiCkCiClNiCnPiBeC_xHqqkZx_
	// MainFrame _xZkqqHx_iCmJiCmNiBeB_xHqqkZx_IME_xZkqqHx_iKnGjIeBiCmMiDeFiDeCiDjDiDgIiDeFiCkKjEoNiClJiCoHiCoKiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	WString strWin;
	FFGetWindowText(hwnd, strWin);
	const WORD waAppMode[] =
	{
		FD_APPMODE_DYNAMICDRAW,		// DynamicDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		FD_APPMODE_CHIPEDITOR,		// _xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiCmMiPoKiNiHiBeC_xHqqkZx_
		FD_APPMODE_ARROWEDITOR,		// _xZkqqHx_iDeBiDiNiBfLiDeHiDgGiDeCiDfOiCmMiPoKiNiHiBeC_xHqqkZx_
		FD_APPMODE_HISTORICDRAW,	// Historic Draw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		FD_APPMODE_HISTORYVIEWER,	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
	};
	for (int iC = 0; iC < sizeof(waAppMode) / sizeof(waAppMode[0]); iC++)
	{
		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDeFiDeCiDjDiDgIiDeFiCmMjFlGiOjKjHpBjCiGiCmJiDhEiDiMiBfLiDiAjFfMiOkGjFlGiOjKiCkKiKnMiCnMiCoKiCoJiCkJiBeI_xHqqkZx_
		if (0 <= strWin.Find(GetSpecAppName(waAppMode[iC])))
		{
			*hwdp = (HWND)hwnd;
			return FALSE;	// _xZkqqHx_iClBiClBiCmFjHpBiLjDiPiIjHjNiCmNiPeJiCoNiCoIiBeC_xHqqkZx_
		}
	}
	return TRUE;
//----- 02.10.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (WindowsXP+SP1_xZkqqHx_iCmFiBeBiDgAiDgCiDhGiDeHiDgGiDeCiDfOiCkKjAlDiPoNiCmJiLeOjDkOiClJiClIiBeBiDiNiDgCiDeOiClFiCmEiClFiCnMiCkE_xHqqkZx_)-----
} // myETWProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetThreadTopWnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfIiDiMiDgCiDgIiCkKiPiKjBkOiClHiCoJiDeFiDeCiDjDiDgIiDeFiCmMiDgHiDgCiDhGiDeFiDeCiDjDiDgIiDeFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwThreadId	:_xZkqqHx_iDfIiDiMiDgCiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HWND GetThreadTopWnd (DWORD dwThreadId)
{
	HWND hwnd;
	// _xZkqqHx_iDiBiDeDiDjDiDhEiDiMiBfLiDiAiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	::EnumThreadWindows(dwThreadId, myETWProc, (LPARAM)&hwnd);
	return hwnd;
} // GetThreadTopWnd.
//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CloseImeStatus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCgIiCgMiCgEiCpAjFmCiClGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hWnd	:_xZkqqHx_jFmCiClGiCoJiCgIiCgMiCgEiCkKjFhEjBkOiClHiCoJiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CloseImeStatus (HWND hWnd)
{
#if defined(_IME_ON)
//----- 06.05.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	HIMC hIMC = ImmGetContext(hWnd);
//	if (hIMC)
//	{
//		BOOL bStatus = ImmGetOpenStatus(hIMC);
//		if (bStatus)
//			(void)ImmSetOpenStatus(hIMC, FALSE);
//
//		// IME_xZkqqHx_iCpAiKeKjFpKiBeC_xHqqkZx_
//		ImmReleaseContext(hWnd, hIMC);
//	}
//----- 06.05.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iMmEiCnBiPgPiClFjCiGiDiKiDfIiDgHiBeC_xHqqkZx_
	static set<HWND> s_stCalledHwnd;
	if (s_stCalledHwnd.insert(hWnd).second)
	//----- _xZkqqHx_iClBiCmMiKnGjAjEiCpAiMmEiCnBiPgPiClFjCiGiCmFiCmNiCmIiCkCiDeFiDeCiDjDiDgIiDeFiCmMiPoKiNiH_xHqqkZx_ -----
	{
		HIMC hIMC = ImmGetContext(hWnd);
		if (hIMC)
		{
			BOOL bStatus = ImmGetOpenStatus(hIMC);
			if (bStatus)
				(void)ImmSetOpenStatus(hIMC, FALSE);

			// ImmSetOpenStatus _xZkqqHx_iCmNiBeB_xHqqkZx_hWnd_xZkqqHx_iCmM_xHqqkZx_OnImeNotify(IMN_SETOPENSTATUS)_xZkqqHx_iCpA_xHqqkZx_
			// _xZkqqHx_iOmAiNhDiClHiCoJiCkKiBeBiClBiClBiCkJiCoHiClBiCmMiKnGjAjEiCkKiMmEiCmOiCoKiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iDgMiDfIiDgHiClFiCmEiClFiCnMiCkEiClNiCnPiBeB_xHqqkZx_s_stCalledHwnd _xZkqqHx_iCmFiDgMiDfIiDgHiCpAiJpBjEpAiBeC_xHqqkZx_

			// IME_xZkqqHx_iCpAiKeKjFpKiBeC_xHqqkZx_
			ImmReleaseContext(hWnd, hIMC);
		}
		// _xZkqqHx_iDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
		s_stCalledHwnd.erase(hWnd);
	}
//----- 06.05.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
#endif // defined(_IME_ON)
} // CloseImeStatus.

//----------<NOT EXPORT TO VIEWER>-----------
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetMolipExePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw.exe_xZkqqHx_iCmMiDhEiDiLiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiLiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.12.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* FFGetMolipExePath ()
{
	// EXE_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	static wchar_t tcwAppPath[_MAX_PATH * 2] = { L'\0' };
	if (tcwAppPath[0] == L'\0')
	{
		_TCHAR tcaAppPath[_MAX_PATH * 2] = { _T('\0') };
		::GetModuleFileName(NULL, tcaAppPath, sizeof(tcaAppPath) / sizeof(tcaAppPath[0]));
		wcscpy(tcwAppPath, TStrToWStr(tcaAppPath));
	}
	return tcwAppPath;
} // FFGetMolipExePath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetTemplateDirPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiCkKiOpLjIfOiClDiCoKiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDhEiDiLiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiDhEiDiLiDhAiDfIiBeCiNmFiMoDiCmJ_xHqqkZx_"\"_xZkqqHx_iCkKjFhEiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.12.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFGetTemplateDirPath ()
{
//----- 03.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAiDhAiDfIjFjEjFkKiCmGiDhEiDeAiDeDiDiLjGlMjFjEjFkKiCmJjFkKiJpAiClHiCoJiBeC_xHqqkZx_
//	WString strDirPath;
//	::FFSplitFileName(&strDirPath, NULL, NULL, FFGetMolipExePath());
//	strDirPath += L"Template";
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiBgJiDgGiDeCiDiMiDeOiDgHiDiKiBgKiCmMjBlGiNnNiCpAiKgNjEeGiBeC_xHqqkZx_
//	if (FFIsFileExist(strDirPath))
//		strDirPath += L"\\";
//	else
//		::FFSplitFileName(&strDirPath, NULL, NULL, FFGetMolipExePath());
//	return strDirPath;
//----- 03.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAiDhAiDfIjFjEjFkKiCmGiDhEiDeAiDeDiDiLjGlMjFjEjFkKiCmJjFkKiJpAiClHiCoJiBeC_xHqqkZx_
//----- 03.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	WString wstrExeDirPath;
//	::FFSplitFileName(&wstrExeDirPath, NULL, NULL, FFGetMolipExePath());
//----- 03.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString wstrExeDirPath = FFGetFileDirectory(FFGetMolipExePath());
//----- 03.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iKpJjBlGiCmMiDhEiDeAiDeDiDiLiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (FFIsThereFile(wstrExeDirPath + L"Template") == FD_FILE_DIRECTORY)
		return (wstrExeDirPath + L"Template\\");
	return (wstrExeDirPath + L'\\');
//----- 03.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFGetTemplateDirPath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFHorznizeToolBar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CToolBar_xZkqqHx_iCmMiBeB_xHqqkZx_CalcFixedLayout_xZkqqHx_iCmMiDiMiDeDiDeBiDeFiDgHiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pToolBar	:_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wid			:_xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_/ID_xZkqqHx_jEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lWidSz		:wid_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCpAiDeKiDfIiDgHiDhNiDeDiDfJiClHiCoJiPoKiNiHiBeBiDgDiBfLiDiLiDgPiBfLiCmMjAoGjDkKiCmJiDfKiDhAiDiMiBfLiDfO_xHqqkZx_
 *			_xZkqqHx_iCkKjIeBjBlBiClHiCoJiCmGiBeBiDiKiDfEiDeDiDfJiClDiCoKiClNiDgDiBfLiDiLiDgPiBfLiCpAiDgIiDgCiDeOiClHiCoJiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iMoDjElMiCmMiDhLiDfOiDjDjHnOiCkKiCkEiCnMiCkNjFfMiOkGiClDiCoKiCmIiCkCiBeCiClBiCoKiCpAiJpAiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFHorznizeToolBar (CToolBar* pToolBar, FCWndAndId wid[], long lWidSz)
{
	CRect rect;
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCpAiCfAiNhDiCmJiLkNjAkHiClHiCoJiBeC_xHqqkZx_
	pToolBar->GetToolBarCtrl().SetRows(1, FALSE, rect);
	for (long lC = 0; lC < lWidSz; lC++)
	{
		// _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiCmMiDfEiDeDiDfJiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
		pToolBar->GetItemRect(pToolBar->CommandToIndex(wid[lC].dwId), &rect);
		if (::IsWindow(wid[lC].pWnd->m_hWnd))
			wid[lC].pWnd->MoveWindow(rect);
	}
} // FFHorznizeToolBar.

//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetWindowText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetWindowText_xZkqqHx_iCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FFGetWindowText (const CWnd* pWnd, wchar_t* wszStringBuf, int nMaxCount, WORD wCodePage)
{
	return FFGetWindowText(pWnd->m_hWnd, wszStringBuf, nMaxCount, wCodePage);
} // FFGetWindowText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetWindowText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetWindowText_xZkqqHx_iCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FFGetWindowText (HWND hWnd, wchar_t* wszStringBuf, int nMaxCount, WORD wCodePage)
{
#if defined(_MBCS)
	astring astrBuff(nMaxCount * sizeof(wszStringBuf[0]), '\0');
// 06.04.20 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	int Ret = GetWindowText(hWnd, astrBuff.begin(), astrBuff.size());
	GetWindowText(hWnd, astrBuff.begin(), astrBuff.size());
	wcsncpy(wszStringBuf, TStrToWStr(astrBuff.begin(), wCodePage), nMaxCount);
//----- 06.04.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return Ret;
//----- 06.04.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDgPiDgCiDhEiDeAjFhDjBkLiCmMiPoKiNiHiCpAiNgMjHlGiClFiBeBiNmFiMoDiCmJiLpDjFlGiOjKiCpAjDpMiCoKiCmEiCkIiCkNiBeC_xHqqkZx_
	wszStringBuf[nMaxCount - 1] = L'\0';
	// _xZkqqHx_iLpDjFlGiOjKiCpAiKnMiCnMiCmIiCkCjFlGiOjKjAjEiCpAjFnEiClHiBeC_xHqqkZx_
	return wcslen(wszStringBuf);
//----- 06.04.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
#elif defined(_UNICODE)
	return GetWindowText(hWnd, wszStringBuf, nMaxCount);
#endif//_UNICODE
} // FFGetWindowText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetWindowText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetWindowText_xZkqqHx_iCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetWindowText (const CWnd* pWnd, WString& rString, WORD wCodePage)
{
//----- 02.10.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//#if defined(_MBCS)
//	CString strBuff;
//	pWnd->GetWindowText(strBuff);
//	rString = TStrToWStr(strBuff, wCodePage);
//#elif defined(_UNICODE)
//	pWnd->GetWindowText(rString);
//#endif//_UNICODE
//----- 02.10.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FFGetWindowText(pWnd->m_hWnd, rString, wCodePage);
//----- 02.10.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFGetWindowText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetWindowText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetWindowText_xZkqqHx_iCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.10.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetWindowText (HWND hWnd, WString& rString, WORD wCodePage)
{
//----- 06.04.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//#if defined(_MBCS)
//	// WindowText_xZkqqHx_jClHiCpAiOoGjDlOiBeCiNmFiMoDiCmMiLpDjFlGiOjKiCmNiKnMiCnMiCoKiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
//	int iTextLen = GetWindowTextLength(hWnd);
//	CString strBuff;
//	// strBuff_xZkqqHx_iCmJiCmNiBeBiLpDjFlGiOjKiCpAiJmBiOfKiClFiClNjHmMiIoGiCpAiKgNjFnLiBeCiLlAiCoHiCkNiBeBiJmBiOfKiCmNjFhDjHhGiClOiCkKjEePiCmMiClNiCnPiBeC_xHqqkZx_
//	// GetWindowText_xZkqqHx_iCmMjFlGiOjKjAjEiCmJiCmNiLpDjFlGiOjKiCpAiJmBiOfKiClFiClNjClHiClDiCpAiOhHjCoIiBeCiLpDjFlGiOjKiCmNjFeLiClIiJmBiOfKiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
//	iTextLen = GetWindowText(hWnd, strBuff.GetBufferSetLength(iTextLen + 1), iTextLen + 1);
//	strBuff.ReleaseBuffer(iTextLen);
//	rString = TStrToWStr(strBuff, wCodePage);
//#elif defined(_UNICODE)
//	int iTextLen = GetWindowTextLengthW(hWnd);
//	// _xZkqqHx_iLpDjFlGiOjKiCpAiJmBiOfKiClFiClNjHmMiIoGiCpAiKgNjFnLiBeCiLlAiCoHiCkNiBeBiJmBiOfKiCmNjFhDjHhGiClOiCkKjEePiCmMiClNiCnPiBeC_xHqqkZx_
//	WString strBuff(iTextLen + 1, L'\0');
//	// _xZkqqHx_iLpDjFlGiOjKiCpAiJmBiOfKiClFiClNjHmMiIoGiCpAiOhHjCoIiBeCiLpDjFlGiOjKiCmNjFeLiClIiJmBiOfKiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
//	iTextLen = GetWindowText(hWnd, &strBuff.at(0), iTextlen + 1);
//	strBuff.resize(iTextLen);
//#endif//_UNICODE
//----- 06.04.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// WindowText_xZkqqHx_jClHiCpAiOoGjDlOiBeCiNmFiMoDiCmMiLpDjFlGiOjKiCmNiKnMiCnMiCoKiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
	int iTextLen = GetWindowTextLength(hWnd);
	// _xZkqqHx_iNmFjBoFiCmMjHeMiCoIiCkGiCoJiDfEiDeDiDfJiCpAiKgNjFnLiBeC_xHqqkZx_
	rString.assign(iTextLen + 1, L'\0');
	iTextLen = FFGetWindowText(hWnd, &rString.at(0), rString.size(), wCodePage);
	rString.resize(iTextLen);
//----- 06.04.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFGetWindowText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSetWindowText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SetWindowText_xZkqqHx_iCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSetWindowText (CWnd* pWnd, const wchar_t* lpszString, WORD wCodePage)
{
	pWnd->SetWindowText(WStrToTStr(lpszString, wCodePage));
} // FFSetWindowText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSetWindowText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SetWindowText_xZkqqHx_iCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSetWindowText (HWND hWnd, const wchar_t* lpszString, WORD wCodePage)
{
	SetWindowText(hWnd, WStrToTStr(lpszString, wCodePage));
} // FFSetWindowText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetLBText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetLBText_xZkqqHx_iCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetLBText (const CComboBox* pCmb, int nIndex, WString& rString)
{
#if defined(_MBCS)
	CString strBuff;
	pCmb->GetLBText(nIndex, strBuff);
	rString = TStrToWStr(strBuff);
#elif defined(_UNICODE)
	return pCmb->GetLBText(nIndex, rString);
#endif//_UNICODE
} // FFGetLBText.

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetMenuString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetMenuString_xZkqqHx_iCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FFGetMenuString (const CMenu* pMenu, UINT nIDItem, WString& rString, UINT nFlags)
{
#if defined(_MBCS)
	CString strBuff;
	int Ret = pMenu->GetMenuString(nIDItem, strBuff, nFlags);
	rString = TStrToWStr(strBuff);
	return Ret;
#elif defined(_UNICODE)
	return pMenu->GetMenuString(nIDItem, rString, nFlags);
#endif//_UNICODE
} // FFGetMenuString.
//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSetItemText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SetItemText_xZkqqHx_iCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFSetItemText (CListCtrl* pCtrl, int nItem, int nSubItem, const wchar_t* lpszText)
{
	return pCtrl->SetItemText(nItem, nSubItem, WStrToTStr(lpszText));
} // FFSetItemText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSetItemText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SetItemText_xZkqqHx_iCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFSetItemText (CTreeCtrl* pCtrl, HTREEITEM hItem, const wchar_t* lpszItem)
{
	return pCtrl->SetItemText(hItem, WStrToTStr(lpszItem));
} // FFSetItemText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFInsertColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	InsertColumn_xZkqqHx_iCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FFInsertColumn (CListCtrl* pCtrl, int nCol, const wchar_t* lpszColumnHeading, int nFormat, int nWidth, int nSubItem)
{
	return pCtrl->InsertColumn(nCol, WStrToTStr(lpszColumnHeading), nFormat, nWidth, nSubItem);
} // FFInsertColumn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetMonitorRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDgKiDfOiBfLjHmMiIoGiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vMonitorRect	:_xZkqqHx_iDiCiDgKiDfOiBfLiCmMiLoJiMgAjEhKjHpBiBgJiDfIiDeOiDiKiBfLiDjDiNmAjFfHiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetMonitorRect (vector<CRect>& vMonitorRect)
{
	vMonitorRect.clear();
	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_WINDOWS &&
		FFVersionInfo().dwMajorVersion == 4 &&
		FFVersionInfo().dwMinorVersion == 0)
	//----- Windows95_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiCmMiLoJiMgAiCpAiOoGjDlOiBeC_xHqqkZx_
		CRect rtDesktop;
		GetWindowRect(GetDesktopWindow(), rtDesktop);
		vMonitorRect.push_back(rtDesktop);
	} else
	//----- Windows95_xZkqqHx_iImIiKePiCmMiPoKiNiH_xHqqkZx_ ------
	{
		struct l_ {
			static BOOL CALLBACK myMonitorEnumProc (HMONITOR hMonitor,	// _xZkqqHx_iDgGiDeCiDfIiDhGiDiMiDeDiDiCiDgKiDfOiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
													HDC hdcMonitor,		// _xZkqqHx_iDiCiDgKiDfOiCmJjDeLiClFiClNiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
													LPRECT lprcMonitor,	// _xZkqqHx_iDiCiDgKiDfOiPoDiCmMiMpAiNlHjFjEjFkKiCpAjFfMiClHjClHjFpLiMgAjHmMiIoGiCnGiCmMiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
													LPARAM dwData)		// EnumDisplayMonitors _xZkqqHx_iCkJiCoHjDgOiClDiCoKiClNiDgGiBfLiDfOiBeC_xHqqkZx_
			{
				CRectVector* vMonitorRect = (CRectVector*)dwData;
				vMonitorRect->push_back(*lprcMonitor);
				return TRUE;	// _xZkqqHx_jHpBiLjDiCpAjBlBiNhDiBeC_xHqqkZx_
			}; // myMonitorEnumProc.
		};
		EnumDisplayMonitors(NULL, NULL, l_::myMonitorEnumProc, LPARAM(&vMonitorRect));
	}
} // FFGetMonitorRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFJustifyToMonitor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiLoJiMgAiCkKiBeBiDiCiDgKiDfOiBfLjCiGiCmJiOpLiCnMiCoJiCoGiCkEiCmIiInKjDkOjHmKiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rect	:_xZkqqHx_iLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOjHmKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhNiDiLiDgAiDiCiDgKiDfOiBfLiCpAiNgMjHlGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CSize FFJustifyToMonitor (const CRect& rect)
{
	// _xZkqqHx_iDiCiDgKiDfOiBfLjHmMiIoGiCmMjEhKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
	CRectVector vMonitorRect;
	FFGetMonitorRect(vMonitorRect);
	//----- _xZkqqHx_iDiCiDgKiDfOiBfLiCmMiCkEiClPiBeB_xHqqkZx_rect _xZkqqHx_iCmGiPgEiCmIiCoJjHmMiIoGiCkKiNmFiCoAiNeMiCkCiDiCiDgKiDfOiBfLiCpAjCfEiClH_xHqqkZx_ -----
	long lMaxArea = 0;
//----- 06.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	long lMonitorIndex = 0;
//	for (long lC = 0; lC != vMonitorRect.size(); lC++)
//	{
//		CRect rtTmp = vMonitorRect[lC] & rect;
//		long lArea = rtTmp.Width() * rtTmp.Height();
//		if (lMaxArea < lArea)
//		{
//			lMaxArea = lArea;
//			lMonitorIndex = lC;
//		}
//	}
//----- 06.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	long lMonitorIndex = -1;
	long lC;
	for (lC = 0; lC != vMonitorRect.size(); lC++)
	{
		CRect rtTmp = vMonitorRect[lC] & rect;
		long lArea = rtTmp.Width() * rtTmp.Height();
		if (lMaxArea < lArea)
		{
			lMaxArea = lArea;
			lMonitorIndex = lC;
		}
	}
	if (lMonitorIndex == -1)
	//----- _xZkqqHx_iPgEiCmIiCoJiDiCiDgKiDfOiBfLiCkKiIoKiCmCiCoAjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iInKjDkOjBmOiPnLiCmMiLoJiMgAiCmMjCiGjAfDjDfPiBeC_xHqqkZx_
		const DBLPoint mmptP(rect.CenterPoint());
		double dMinDist2 = DBL_MAX;
		for (lC = 0; lC != vMonitorRect.size(); lC++)
		{
			// _xZkqqHx_iDiCiDgKiDfOiBfLiCmMiOpMiImNiCpAiDhMiDiKiDfDiDjDiJlLiBeC_xHqqkZx_
			DBLPoint mmpta[5];
			DBLRect(vMonitorRect[lC]).Get5Polygon(mmpta);
			// _xZkqqHx_iDhMiDiKiDfDiDjDiCmGjDfPiCgPiCmMiLjHjHkDiCpAiMhGiOfKiBeC_xHqqkZx_
			const double dDist2 = ::CalcPowDistance(DBLPoint(), mmpta, 5, mmptP);
			if (dDist2 < dMinDist2)
			//----- _xZkqqHx_iDhMiDiKiDfDiDjDiCmGjDfPiCgPiCkKiLnPiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iLjHjHkDiNmFiPkMjCgMiCpAiNfIjAfGiBeC_xHqqkZx_
				dMinDist2 = dDist2;
				// _xZkqqHx_iNmFiCoAiLnPiCkCiDiCiDgKiDfOiBfLiCmJjAnNjCoIiBeC_xHqqkZx_
				lMonitorIndex = lC;
			}
		}
	}
//----- 06.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iLoJiMgAiCkKiDiCiDgKiDfOiBfLiCmJiOpLiCnMiCoJiCoGiCkEiBeBiLoJiMgAiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iNmFiMoDiCmJiNlGiPoDiCmMjClCjAkOiCpAiClHiCoJiClBiCmGiCmFiBeBjFeLiClIiNlGiPoDiCkKiOpLiCnMiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
	CRect rectNew = rect;
	if (vMonitorRect[lMonitorIndex].bottom < rectNew.bottom)
		rectNew += CSize(0, vMonitorRect[lMonitorIndex].bottom - rectNew.bottom);
	if (vMonitorRect[lMonitorIndex].right < rectNew.right)
		rectNew += CSize(vMonitorRect[lMonitorIndex].right - rectNew.right, 0);
	if (rectNew.top < vMonitorRect[lMonitorIndex].top)
		rectNew += CSize(0, vMonitorRect[lMonitorIndex].top - rectNew.top);
	if (rectNew.left < vMonitorRect[lMonitorIndex].left)
		rectNew += CSize(vMonitorRect[lMonitorIndex].left - rectNew.left, 0);
	// _xZkqqHx_iInKjDkOjHmKiCpAjFnEiClHiBeC_xHqqkZx_
	return CSize(rectNew.left - rect.left, rectNew.top - rect.top);
} // FFJustifyToMonitor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFJustifyToMonitor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDfPiCkKiBeBiDhNiDeFiDfIiCmGjDkPiClGiDiCiDgKiDfOiBfLjCiGiCmJiOpLiCnMiCoJiCoGiCkEiCmIiInKjDkOjHmKiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pt	:_xZkqqHx_jDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOjHmKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhNiDiLiDgAiDiCiDgKiDfOiBfLiCpAiNgMjHlGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CSize FFJustifyToMonitor (const CPoint& pt)
{
	// _xZkqqHx_iDiCiDgKiDfOiBfLjHmMiIoGiCmMjEhKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
	CRectVector vMonitorRect;
	FFGetMonitorRect(vMonitorRect);
	// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMiMlLiNnNiCmMiImKjChFiCpAiBeBiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
	CPoint ptMsc;
	(void)::GetCursorPos(&ptMsc);
	//----- _xZkqqHx_iDiCiDgKiDfOiBfLiCmMiCkEiClPiBeB_xHqqkZx_ptMsc_xZkqqHx_iCmGiCkKjBkOiClHiCoJiDiCiDgKiDfOiBfLiCpAjCfEiClH_xHqqkZx_ -----
//----- 06.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	long lMonitorIndex = 0;
//	for (long lC = 0; lC != vMonitorRect.size(); lC++)
//	{
//		if (vMonitorRect[lC].PtInRect(ptMsc))
//		{
//			lMonitorIndex = lC;
//			break;
//		}
//	}
//----- 06.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	long lMonitorIndex = -1;
	for (long lC = 0; lC != vMonitorRect.size(); lC++)
	{
		if (vMonitorRect[lC].PtInRect(ptMsc))
		{
			lMonitorIndex = lC;
			break;
		}
	}
	if (lMonitorIndex == -1)
	//----- _xZkqqHx_iCmHiCmMiDiCiDgKiDfOiBfLiCmJiCoAjBkOiClDiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iInKjDkOjBmOiPnLiCmMjDfPiBeC_xHqqkZx_
		const DBLPoint mmptP(pt);
		double dMinDist2 = DBL_MAX;
		for (lC = 0; lC != vMonitorRect.size(); lC++)
		{
			// _xZkqqHx_iDiCiDgKiDfOiBfLiCmMiOpMiImNiCpAiDhMiDiKiDfDiDjDiJlLiBeC_xHqqkZx_
			DBLPoint mmpta[5];
			DBLRect(vMonitorRect[lC]).Get5Polygon(mmpta);
			// _xZkqqHx_iDhMiDiKiDfDiDjDiCmGjDfPiCgPiCmMiLjHjHkDiCpAiMhGiOfKiBeC_xHqqkZx_
			const double dDist2 = ::CalcPowDistance(DBLPoint(), mmpta, 5, mmptP);
			if (dDist2 < dMinDist2)
			//----- _xZkqqHx_iDhMiDiKiDfDiDjDiCmGjDfPiCgPiCkKiLnPiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iLjHjHkDiNmFiPkMjCgMiCpAiNfIjAfGiBeC_xHqqkZx_
				dMinDist2 = dDist2;
				// _xZkqqHx_iNmFiCoAiLnPiCkCiDiCiDgKiDfOiBfLiCmJjAnNjCoIiBeC_xHqqkZx_
				lMonitorIndex = lC;
			}
		}
	}
//----- 06.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	CSize szMove(0, 0);
	if (vMonitorRect[lMonitorIndex].bottom < pt.y)
		szMove.cy = vMonitorRect[lMonitorIndex].bottom - pt.y;
	if (vMonitorRect[lMonitorIndex].right < pt.x)
		szMove.cx = vMonitorRect[lMonitorIndex].right - pt.x;
	if (pt.y < vMonitorRect[lMonitorIndex].top)
		szMove.cy = vMonitorRect[lMonitorIndex].top - pt.y;
	if (pt.x < vMonitorRect[lMonitorIndex].left)
		szMove.cx = vMonitorRect[lMonitorIndex].left - pt.x;
	return szMove;
} // FFJustifyToMonitor.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPointToMenuId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNmAjFfHiImKjChFiCmJiDiBiDgKiDiFiBfLiCkKjFfMiOkGiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeBiClLiCmMiImKjChFiCmM_xHqqkZx_
 *			_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd:_xZkqqHx_iMjPiNpFiClFiOgOiCnPiCoJiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pt	:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeCiDfIiDeOiDiKiBfLiDjDiNmAjFfHiMgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iBeCiDfCiDhNiDjDiDgIiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DWORD(-1)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FFPointToMenuId (HWND hwnd, const CPoint& pt)
{
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkK_xHqqkZx_NULL_xZkqqHx_iCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (hwnd == NULL) return DWORD(-1);
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDeOiDiJiDfIjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	_TCHAR szClassName[100];
	GetClassName(hwnd, szClassName, sizeof(szClassName) / sizeof(szClassName[0]) - 1);
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDeOiDiJiDfIjGlMiCkKiDiBiDgKiDiFiBfLiDeFiDeCiDjDiDgIiDeFiCmFiCmNiCmIiCkCiPoKiNiHiCmNiPiIjHjNiCpAiPeJjHlJiBeC_xHqqkZx_
	// _xZkqqHx_iDiBiDgKiDiFiBfLiDeFiDeCiDjDiDgIiDeFiCmMiDeOiDiJiDfIjGlMiCmN_xHqqkZx_ "#32768"
	if (_tcscmp(szClassName, _T("#32768")) != 0)
		return DWORD(-1);

	for (int nPos = 0;; nPos++)
	{
		MENUBARINFO mbi;
		memset(&mbi, 0, sizeof(mbi));
		mbi.cbSize = sizeof(mbi);
		if (!::GetMenuBarInfo(hwnd, OBJID_CLIENT, nPos + 1, &mbi)) break;
		if (mbi.hwndMenu != NULL)
		//----- _xZkqqHx_iDeBiDeDiDgFiDiAiCkKiDfEiDhFiDiBiDgKiDiFiBfLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			DWORD dwHitId = FFPointToMenuId(mbi.hwndMenu, pt);
			if (dwHitId != DWORD(-1))
				return dwHitId;
		} else
		//----- _xZkqqHx_iDeBiDeDiDgFiDiAiCkKiDfCiDhNiDjDiDgIiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (::PtInRect(&mbi.rcBar, pt))
			{
				DWORD dwHitId = ::GetMenuItemID(mbi.hMenu, nPos);
				if (dwHitId == 0) dwHitId = DWORD(-1);
				return dwHitId;
			}
		}
	}
	return DWORD(-1);
} // FFPointToMenuId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPointToMenuId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNmAjFfHiImKjChFiCmJiDiBiDgKiDiFiBfLiCkKjFfMiOkGiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeBiClLiCmMiImKjChFiCmM_xHqqkZx_
 *			_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pt	:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeCiDfIiDeOiDiKiBfLiDjDiNmAjFfHiMgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iBeCiDfCiDhNiDjDiDgIiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DWORD(-1)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FFPointToMenuId (const CPoint& pt)
{
	HWND hwndPoint = ::WindowFromPoint(pt);
	if (hwndPoint == NULL) return DWORD(-1);
	// IsChild _xZkqqHx_iCmFiDeFiDeCiDjDiDgIiDeFiCmMjAgFiOhBiKnGiMfHiCpAjClCiCnHiCmEiCoAiBeBiDgAiDgCiDhGiDfIiDgHiDeBiCkK_xHqqkZx_
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiJlLiClDiCoKiClNiPoKiNiHiCmNjBmOiPnLiCmGiClFiCmEjEeGiOkPiClDiCoKiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iCoGiCmBiCmEiBeBjDkPiClGiDfIiDiMiDgCiDgIiCmJjBkOiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	if (GetWindowThreadProcessId(hwndPoint, NULL) != GetCurrentThreadId())
		return DWORD(-1);
	return FFPointToMenuId(hwndPoint, pt);
} // FFPointToMenuId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFWindowFromPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeFiDeCiDjDiDgIiDeFiCmMiBeBiOhHjCoIiClDiCoKiClNiImKjChFiCmMiOhBiDeFiDeCiDjDiDgIiDeFiCpA_xHqqkZx_
 *			_xZkqqHx_iNmEiLeBjDeJiCmJiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwndParent	:_xZkqqHx_iMjPiNpFiClHiCoJjAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pt			:hwndParent_xZkqqHx_iCmMiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			uFlags		:_xZkqqHx_iMjPiNpFiPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_ChildWindowFromPointEx _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiHiCmNiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiBeBiMkJiCmCiCkJiCoHiCmIiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HWND FFWindowFromPoint (HWND hwndParent, const CPoint& pt, UINT uFlags)
{
	const HWND hwndChild = ::ChildWindowFromPointEx(hwndParent, pt, uFlags);
	if (hwndChild == hwndParent || hwndChild == NULL)
		return hwndChild;
	// _xZkqqHx_iDhMiDeDiDjDiDgHiCmMiNmAjFfHiCpAjFmPiKlHiBeC_xHqqkZx_
	CPoint ptChild = pt;
	MapWindowPoints(hwndParent, hwndChild, &ptChild, 1);
	return FFWindowFromPoint(hwndChild, ptChild, uFlags);
} // FFWindowFromPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFWindowFromPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeFiDeCiDjDiDgIiDeFiCmMiBeBiOhHjCoIiClDiCoKiClNiImKjChFiCmMiOhBiDeFiDeCiDjDiDgIiDeFiCpA_xHqqkZx_
 *			_xZkqqHx_iNmEiLeBjDeJiCmJiMjPiNpFiClHiCoJiBeCiMjPiNpFjBmOiPnLiCmNiBeB_xHqqkZx_stHwnd_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiDeFiDeCiDjDiDgIiDeFiCmJ_xHqqkZx_
 *			_xZkqqHx_iMmAjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwndParent	:_xZkqqHx_iMjPiNpFiClHiCoJjAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stHwnd		:_xZkqqHx_iMjPiNpFiClHiCoJjBmOiPnLiCmMiDeFiDeCiDjDiDgIiDeFiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pt			:hwndParent_xZkqqHx_iCmMiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			uFlags		:_xZkqqHx_iMjPiNpFiPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_ChildWindowFromPointEx _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiHiCmNiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiBeBiMkJiCmCiCkJiCoHiCmIiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HWND FFWindowFromPoint (HWND hwndParent, const set<HWND>& stHwnd, const CPoint& pt, UINT uFlags)
{
	const HWND hwndChild = ::ChildWindowFromPointEx(hwndParent, pt, uFlags);
	if (stHwnd.find(hwndChild) != stHwnd.end())
		return hwndChild;
	if (hwndChild == hwndParent || hwndChild == NULL)
		return NULL;
	// _xZkqqHx_iDhMiDeDiDjDiDgHiCmMiNmAjFfHiCpAjFmPiKlHiBeC_xHqqkZx_
	CPoint ptChild = pt;
	MapWindowPoints(hwndParent, hwndChild, &ptChild, 1);
	return FFWindowFromPoint(hwndChild, stHwnd, ptChild, uFlags);
} // FFWindowFromPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSendDataMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAjElKiCmBiClNiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hWnd		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjBjHjFhEjAoGiCmM_xHqqkZx_HWND_xZkqqHx_iCpAiOhHjCoIiBeCjFmKiDeBiDhGiDiKiCmMiDeFiDeCiDjDiDgIiDeF_xHqqkZx_
 *						 _xZkqqHx_iCmFiCoAjBjHjFhEiJmCjEfMiBeC_xHqqkZx_
 *			dwMessage	:_xZkqqHx_jBjHjFhEiClHiCoJiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwDataSz	:_xZkqqHx_jBjHjFhEiClHiCoJiDgGiBfLiDfOiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pData		:_xZkqqHx_jBjHjFhEiClHiCoJiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.01.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSendDataMessage (HWND hWnd, DWORD dwMessage, DWORD dwDataSz, void* pData)
{
	COPYDATASTRUCT gcds;
	gcds.dwData = dwMessage;
	gcds.cbData = dwDataSz;
	gcds.lpData = pData;

	// FFGetMainWnd()->GetSafeHwnd()_xZkqqHx_iCmN_xHqqkZx_NULL_xZkqqHx_iCmFiCkAiCmBiCmEiCoAjDkOiNoMiClHiCoJiCoGiCkEiClOiBeC_xHqqkZx_
	// _xZkqqHx_iDeBiDhGiDiKiLeOjDkOiOjOiCmIiCmHiBeBiDhEiDiMiBfLiDiAiNoMjAkMjBePiCmJiOmAiNhDiClFiClNiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
// 06.02.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	::SendMessage(hWnd, WM_COPYDATA, (WPARAM)m_hWnd, (LPARAM)&gcds);
	::SendMessage(hWnd, WM_COPYDATA, (WPARAM)FFGetMainWnd()->GetSafeHwnd(), (LPARAM)&gcds);
} // FFSendDataMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFScreenToClient
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDeOiDiKiBfLiDjDiNmAjFfHiCpAiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_jFmPiKlHjAoGiCmMiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lpRect	:_xZkqqHx_jFmPiKlHiClHiCoJiNmAjFfHiCpAiOhHjCoIiBeCjFmPiKlHiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFScreenToClient (HWND hwnd, LPRECT lpRect)
{
	POINT pt1 = { lpRect->left, lpRect->top };
	POINT pt2 = { lpRect->right, lpRect->bottom };
	if (!ScreenToClient(hwnd, &pt1)) return FALSE;
	if (!ScreenToClient(hwnd, &pt2)) return FALSE;
	lpRect->left   = pt1.x;
	lpRect->top    = pt1.y;
	lpRect->right  = pt2.x;
	lpRect->bottom = pt2.y;
	return TRUE;
} // FFScreenToClient.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFClientToScreen
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCpAiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_jFmPiKlHiMlDiCmMiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lpRect	:_xZkqqHx_jFmPiKlHiClHiCoJiNmAjFfHiCpAiOhHjCoIiBeCjFmPiKlHiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFClientToScreen (HWND hwnd, LPRECT lpRect)
{
	POINT pt1 = { lpRect->left, lpRect->top };
	POINT pt2 = { lpRect->right, lpRect->bottom };
	if (!ClientToScreen(hwnd, &pt1)) return FALSE;
	if (!ClientToScreen(hwnd, &pt2)) return FALSE;
	lpRect->left   = pt1.x;
	lpRect->top    = pt1.y;
	lpRect->right  = pt2.x;
	lpRect->bottom = pt2.y;
	return TRUE;
} // FFClientToScreen.

//----- 06.12.05 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 06.12.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFAddRgn
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeFiDeCiDjDiDgIiDeFiCmMjHmMiIoGiCpAiBeB_xHqqkZx_View_xZkqqHx_iCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFAddRgn (HWND hwnd)
//{
//	if (g_pView != NULL &&
//		FFGetMainWnd()->GetSafeHwnd() != NULL &&
//		IsWindow(hwnd) &&
//		IsWindowVisible(hwnd))
//	//----- _xZkqqHx_jFfMiOkGiClFiCmEiCkCiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCkJiCoHiBeBiDeFiDeCiDjDiDgIiDeFiCkK_xHqqkZx_View_xZkqqHx_iCmJiCkJiCkJiCoJiPoKiNiHiCmMiCnNiPiIjHjNiBeC_xHqqkZx_
//		HWND hwndParent = GetParent(hwnd);
//		if (hwndParent == NULL ||
//			hwndParent == FFGetMainWnd()->GetSafeHwnd() ||
//			hwndParent == g_pView->m_hWnd)
//		{
//			// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCoCiDeFiDeCiDjDiDgIiDeFiCpAjFmCiClGiClNjClMiMoDiCmJiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpA_xHqqkZx_
//			// _xZkqqHx_jAnIiCmBiCmEiNmEjFgAiJoGiClHiCoJiCmGiDeFiDeCiDjDiDgIiDeFiCmMiDfDiDhOiCkKiOgDiCmBiCmEiClFiCnMiCkEiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
//			// _xZkqqHx_iClBiCoKiCpAjGgIiCkOiClNiCnPiBeBiDeFiDeCiDjDiDgIiDeFiCmMjHmMiIoGiCpAiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
//			CRect lgrtWin;
//			GetWindowRect(hwnd, lgrtWin);
//			g_pView->ScreenToClient(lgrtWin);
//			g_pView->DPtoLP(lgrtWin);
//			g_pView->AddRgn(lgrtWin);
//		}
//	}
//} // FFAddRgn.
////----- 06.12.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.12.05 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

////////////////////////////////////////////////////////////////////////////
// FCPendingMessage

// _xZkqqHx_jFnLjHkPiDiBiDgCiDfKiBfLiDfHiCpAiLeMjIfOiBeC_xHqqkZx_
static vector<FCPendingMessage> s_vPostMessages;
static set<CWnd*> s_stVisibleWnd;
// _xZkqqHx_iDfOiDeDiDhNiBfLiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
static UINT_PTR s_uipTimerId = 0;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myTimerProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnLjHkPiDiBiDgCiDfKiBfLiDfHiCpAiPiIjHjNiClHiCoJiDfOiDeDiDhNiBfLiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void CALLBACK myTimerProc (	HWND hwnd,	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
									UINT uMsg,	// WM_TIMER _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
									UINT_PTR idEvent,	// _xZkqqHx_iDfOiDeDiDhNiCmMiOkPjFmKiOhBiBeC_xHqqkZx_
									DWORD dwTime)		// _xZkqqHx_iMlLiNnNiCmMiDfGiDfIiDgFiDiAiOjOiNiPiBeC_xHqqkZx_
{
	if (!s_vPostMessages.empty())
	//----- _xZkqqHx_jFnLjHkPiDiBiDgCiDfKiBfLiDfHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		FFNotifyPendingMessage(NULL, FALSE);
	} else
	//----- _xZkqqHx_jFnLjHkPiDiBiDgCiDfKiBfLiDfHiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfOiDeDiDhNiBfLiCpAjCoCiOhOiBeC_xHqqkZx_
		KillTimer(NULL, s_uipTimerId);
		s_uipTimerId = 0;
	}
} // myTimerProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPendingMessage::FCPendingMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPendingMessage::FCPendingMessage ()
			:m_dwDestination(FD_PMSG_NONE),
			m_dwMessage(0),
			m_dwWParam(0),
			m_dwLParam(0),
			m_bImmediate(TRUE)
{
} // FCPendingMessage::FCPendingMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPendingMessage::FCPendingMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwDestinationConditons	:_xZkqqHx_jBjHjFhEjAoGiDeFiDeCiDjDiDgIiDeFiCmGiPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMessage		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjDoAjHgFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwWParam		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCmM_xHqqkZx_WPARAM_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwLParam		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCmM_xHqqkZx_LPARAM_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	dwDestinationConditons_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiDeFiDeCiDjDiDgIiDeFiCkKjHeMiMpIiCmJiCmIiCmBiClNiPoKiNiHiCmJ_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjBjHjFhEiBeBiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPendingMessage::FCPendingMessage (DWORD dwDestinationConditons,
									DWORD dwMessage,
									DWORD dwWParam,
									DWORD dwLParam,
									BOOL bImmediate)
			:m_dwDestination(dwDestinationConditons & FD_PMSG_MASK_INSTANCE),
			 m_dwMessage(dwMessage),
			 m_dwWParam(dwWParam),
			 m_dwLParam(dwLParam),
			 m_bImmediate(bImmediate)
{
	ASSERT((m_dwDestination & FD_PMSG_MASK_STATUS) == 0);
	ASSERT(m_dwDestination != FD_PMSG_DOCUMENT);
	ASSERT((dwDestinationConditons & FD_PMSG_MASK_STATUS) != 0);
	m_vConditions.push_back(dwDestinationConditons);
} // FCPendingMessage::FCPendingMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPendingMessage::FCPendingMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwDestination	:_xZkqqHx_jBjHjFhEjAoGiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMessage		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjDoAjHgFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwWParam		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCmM_xHqqkZx_WPARAM_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwLParam		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCmM_xHqqkZx_LPARAM_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCondition0	:_xZkqqHx_iPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjBfDiCmEiCmMiPpAiMiPiCkKiPfLiClNiClDiCoKiClNiOjOiCmJiDiBiDgCiDfKiBfLiDfHjBjHjFhEiBeBiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPendingMessage::FCPendingMessage (DWORD dwDestination,
									DWORD dwMessage,
									DWORD dwWParam,
									DWORD dwLParam,
									BOOL bImmediate,
									DWORD dwCondition0)
			:m_dwDestination(dwDestination),
			 m_dwMessage(dwMessage),
			 m_dwWParam(dwWParam),
			 m_dwLParam(dwLParam),
			 m_bImmediate(bImmediate)
{
	ASSERT((m_dwDestination & FD_PMSG_MASK_STATUS) == 0);
	ASSERT(m_dwDestination != FD_PMSG_DOCUMENT);
	m_vConditions.push_back(dwCondition0);
} // FCPendingMessage::FCPendingMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPendingMessage::FCPendingMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwDestination	:_xZkqqHx_jBjHjFhEjAoGiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMessage		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjDoAjHgFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwWParam		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCmM_xHqqkZx_WPARAM_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwLParam		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCmM_xHqqkZx_LPARAM_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCondition0	:_xZkqqHx_iPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCondition1	:_xZkqqHx_iPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjBfDiCmEiCmMiPpAiMiPiCkKiPfLiClNiClDiCoKiClNiOjOiCmJiDiBiDgCiDfKiBfLiDfHjBjHjFhEiBeBiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPendingMessage::FCPendingMessage (DWORD dwDestination,
									DWORD dwMessage,
									DWORD dwWParam,
									DWORD dwLParam,
									BOOL bImmediate,
									DWORD dwCondition0,
									DWORD dwCondition1)
			:m_dwDestination(dwDestination),
			 m_dwMessage(dwMessage),
			 m_dwWParam(dwWParam),
			 m_dwLParam(dwLParam),
			 m_bImmediate(bImmediate)
{
	ASSERT((m_dwDestination & FD_PMSG_MASK_STATUS) == 0);
	ASSERT(m_dwDestination != FD_PMSG_DOCUMENT);
	m_vConditions.push_back(dwCondition0);
	m_vConditions.push_back(dwCondition1);
} // FCPendingMessage::FCPendingMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPendingMessage::FCPendingMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwDestination	:_xZkqqHx_jBjHjFhEjAoGiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMessage		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjDoAjHgFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwWParam		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCmM_xHqqkZx_WPARAM_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwLParam		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCmM_xHqqkZx_LPARAM_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCondition0	:_xZkqqHx_iPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCondition1	:_xZkqqHx_iPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCondition2	:_xZkqqHx_iPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjBfDiCmEiCmMiPpAiMiPiCkKiPfLiClNiClDiCoKiClNiOjOiCmJiDiBiDgCiDfKiBfLiDfHjBjHjFhEiBeBiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPendingMessage::FCPendingMessage (DWORD dwDestination,
									DWORD dwMessage,
									DWORD dwWParam,
									DWORD dwLParam,
									BOOL bImmediate,
									DWORD dwCondition0,
									DWORD dwCondition1,
									DWORD dwCondition2)
			:m_dwDestination(dwDestination),
			 m_dwMessage(dwMessage),
			 m_dwWParam(dwWParam),
			 m_dwLParam(dwLParam),
			 m_bImmediate(bImmediate)
{
	ASSERT((m_dwDestination & FD_PMSG_MASK_STATUS) == 0);
	ASSERT(m_dwDestination != FD_PMSG_DOCUMENT);
	m_vConditions.push_back(dwCondition0);
	m_vConditions.push_back(dwCondition1);
	m_vConditions.push_back(dwCondition2);
} // FCPendingMessage::FCPendingMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPushPendingMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnLjHkPiClHiCoJiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pmsg		:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjDoAjHgFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bCheckNow	:pmsg _xZkqqHx_iCkKiClHiCkOiPiIjHjNiCmFiCkLiCoJiCkJjClCiCnHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
 *						 _xZkqqHx_iMoDiCmFjClCiCnHiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_TRUE_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmN_xHqqkZx_
 *						 _xZkqqHx_jBkGiOjOiCmJiDiBiDgCiDfKiBfLiDfHiCkKjBjHjFhEiClDiCoKiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFnLjHkPiClDiCoKiClNiDiBiDgCiDfKiBfLiDfHiCmNiBeBiPpAiMiPiCkKjBfDiCmEiPfLiClNiClDiCoKiClNiCmGiCkLiCmJiBeB_xHqqkZx_
 *			m_bImmediate_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNjFpLjGeAiCmFjBjHjFhEiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmMiOmAiNhDiOjOiCmJiBeBiPpAiMiPiCkKjBfDiCmEiPfLiClNiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmJiCmNiBeB_xHqqkZx_
 *			m_bImmediate_xZkqqHx_iCmJiPfNiCmBiCmEjBkGiOjOiCmJjBjHjFhEiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPushPendingMessage (const FCPendingMessage& pmsg, BOOL bCheckNow)
{
	s_vPostMessages.push_back(pmsg);
	if (bCheckNow)
		FFNotifyPendingMessage(NULL, FALSE);

	// _xZkqqHx_jFnLjHkPiDiBiDgCiDfKiBfLiDfHiCmMjBlGiNnNiCpAiDgAiDeGiDgCiDeOiBeCiPoDiCmM_xHqqkZx_ FFNotifyPendingMessage _xZkqqHx_iCmF_xHqqkZx_
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKiPiIjHjNiClDiCoKiCmEiCkCiCoJiJmCjEfMjAkLiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
	if (!s_vPostMessages.empty() && s_uipTimerId == 0)
	//----- _xZkqqHx_jFnLjHkPiDiBiDgCiDfKiBfLiDfHiCkKjBlGiNnNiClFiCmEiCkCiCmEiBeBiDfOiDeDiDhNiBfLiCkKjCoCiOhOiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfOiDeDiDhNiBfLiCpAjDkOiCkJiClHiBeC_xHqqkZx_
		s_uipTimerId = SetTimer(NULL, 0, 100, TIMERPROC(myTimerProc));
	}
} // FFPushPendingMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFNotifyPendingMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnLjHkPiClDiCoKiCmEiCkCiCoJiDiBiDgCiDfKiBfLiDfHiCpAiDgAiDeGiDgCiDeOiClFiBeBjBjHjFhEiJmCjEfMiCmIiDiBiDgCiDfKiBfLiDfHiCmN_xHqqkZx_
 *			_xZkqqHx_jBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pWnd	:_xZkqqHx_jFfMiOkGiPpDjBnEiCkKjFmPiNfIiClDiCoKiClNiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *					 _xZkqqHx_jFfMiOkGiPpDjBnEiCkKjFmPiNfIiClDiCoKiCmEiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bWndShow	:pWnd _xZkqqHx_iCkKjFfMiOkGiClDiCoKiClNiCmIiCoH_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKgFiDeFiDeCiDjDiDgIiDeFiCkKjFfMiOkGiClDiCoKiClNiDfOiDeDiDhOiDjDiDePjDjJiCmFiClBiCmMiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFNotifyPendingMessage (CWnd* pWnd, BOOL bWndShow)
{
//----- 06.03.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iKnGjAjEiPiIjHjNjCiGiCkJiBeI_xHqqkZx_
	static BOOL s_bIsDoing = FALSE;
	// _xZkqqHx_iKnGjAjEiPiIjHjNjCiGiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	// _xZkqqHx_iKnGjAjEjCiGiCkJiCoH_xHqqkZx_SendMessage -> Dialog_xZkqqHx_iLeOjDkO_xHqqkZx_ _xZkqqHx_iCmMiPoKiNiHiBeBiDfOiDeDiDhNiBfLiCmJiCoGiCmBiCmE_xHqqkZx_
	// _xZkqqHx_iClBiCmMiKnGjAjEiCkKiMmEiCmOiCoKiCmEiClFiCnMiCkEiBeCjBlNiPgEiCmJiPiIjHjNiClHiCoJiCmMiCpAjGgIiCkOiClNiCnPiBeBiClBiClBiCmFjAkHiMmAiBeC_xHqqkZx_
	if (s_bIsDoing) return;
	// _xZkqqHx_iKnGjAjEiPiIjHjNjCiGiCkJiBeI_xHqqkZx_
	s_bIsDoing = TRUE;
//----- 06.03.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMjFfMiOkGiPpDjBnEiCpAiLeMjIfOiBeC_xHqqkZx_
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmM_xHqqkZx_IsWindowVisible()_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_WS_VISIBLE _xZkqqHx_iCpAjClCiCnHiCoKiCmO_xHqqkZx_
	// _xZkqqHx_iCoNiCkJiCoIiClLiCkEiCmIiCoAiCmMiClOiCkKiBeBiOmAiNnLiCmN_xHqqkZx_ OnShowWindow _xZkqqHx_iCmMiClHiCkOiMoDiCmJ_xHqqkZx_
	// IsWindowVisible()_xZkqqHx_iCmJjElNiJgGiClDiCoKiCoJiCoNiCkPiCmFiCmNiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeB_xHqqkZx_s_stVisibleWnd _xZkqqHx_iCmJiDeFiDeCiDjDiDgIiDeFjFfMiOkGiPpDjBnEiCpAiLeMjIfOiBeC_xHqqkZx_
	if (pWnd != NULL)
	//----- _xZkqqHx_jFfMiOkGiPpDjBnEjFmPiNfIiCmMiDeFiDeCiDjDiDgIiDeFiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (bWndShow)
			s_stVisibleWnd.insert(pWnd);
		else
			s_stVisibleWnd.erase(pWnd);
	}

	vector<FCPendingMessage>::iterator i;
	for (i = s_vPostMessages.begin(); i != s_vPostMessages.end();)
	{
		// _xZkqqHx_iPpAiMiPiCmNjBfDiCmEiPfLiClNiClDiCoKiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
		BOOL bEnable = TRUE;
		DWORDVector::const_iterator iPc;
		// _xZkqqHx_jBfDiCmEiCmMiPpAiMiPiCpAiDgAiDeGiDgCiDeOiClHiCoJiDiLiBfLiDhGiBeC_xHqqkZx_
		for (iPc = (*i).m_vConditions.begin();
			 bEnable && iPc != (*i).m_vConditions.end();
			 iPc++)
		{
			if (*iPc & FD_PMSG_MASK_INSTANCE == FD_PMSG_DOCUMENT)
			//----- _xZkqqHx_iPpAiMiPiCmMiDfOiBfLiDfBiDgCiDgHiCkKiDgIiDeMiDiFiDiBiDjDiDgHiCmMiPoKiNiH_xHqqkZx_ -----
			{
				if (bEnable && *iPc & FD_PMSG_IF_ENABLE)
				//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_/_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkKjHeMiMpI_xHqqkZx_ -----
				{
					if (g_pDoc == NULL)
						bEnable = FALSE;
				}
				if (bEnable && *iPc & FD_PMSG_IF_DISABLE)
				//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_/_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkKjGlDiMpI_xHqqkZx_ -----
				{
					if (g_pDoc != NULL)
						bEnable = FALSE;
				}
			} else
			//----- _xZkqqHx_iPpAiMiPiCmMiDfOiBfLiDfBiDgCiDgHiCkKiDeFiDeCiDjDiDgIiDeFiCmMiPoKiNiH_xHqqkZx_ -----
			{
				CWnd* pTargetWnd = NULL;
				switch (*iPc & FD_PMSG_MASK_INSTANCE)
				{
				case FD_PMSG_MAIN_WND:		// FFGetMainWnd()->GetWnd()_xZkqqHx_iBeC_xHqqkZx_
					pTargetWnd = (CWnd*)FFGetMainWnd()->GetWnd();
					break;
				case FD_PMSG_FRAME:			// g_pFrame_xZkqqHx_iBeC_xHqqkZx_
					pTargetWnd = (CWnd*)g_pFrame;
					break;
				case FD_PMSG_IN_PLACE:		// g_pInPlace_xZkqqHx_iBeC_xHqqkZx_
					pTargetWnd = (CWnd*)g_pInPlace;
					break;
				case FD_PMSG_VIEW:			// g_pView.
					pTargetWnd = (CWnd*)g_pView;
					break;
				case FD_PMSG_MAIN_HRULER:	// FFGetMainWnd()->HRuler().
					pTargetWnd = (CWnd*)FFGetMainWnd()->HRuler();
					break;
				case FD_PMSG_MAIN_VRULER:	// FFGetMainWnd()->VRuler().
					pTargetWnd = (CWnd*)FFGetMainWnd()->VRuler();
					break;
				case FD_PMSG_TEXT_EDITOR:	// g_pView->GetRTFEditor().
					if (g_pView != NULL)
						pTargetWnd = (CWnd*)g_pView->GetRTFEditor();
					break;
				}

				if (bEnable && *iPc & FD_PMSG_IF_ENABLE)
				//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_/_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkKjHeMiMpI_xHqqkZx_ -----
				{
					if (pTargetWnd == NULL || !IsWindow(pTargetWnd->m_hWnd))
						bEnable = FALSE;
				}
				if (bEnable && *iPc & FD_PMSG_IF_DISABLE)
				//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_/_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkKjGlDiMpI_xHqqkZx_ -----
				{
					if (pTargetWnd != NULL && IsWindow(pTargetWnd->m_hWnd))
						bEnable = FALSE;
				}
				if (bEnable && *iPc & FD_PMSG_IF_VISIBLE)
				//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkKjFfMiOkGiPpDjBnE_xHqqkZx_ -----
				{
					if (pTargetWnd == NULL ||
						!IsWindow(pTargetWnd->m_hWnd) ||
						s_stVisibleWnd.find(pTargetWnd) == s_stVisibleWnd.end())
						bEnable = FALSE;
				}
				if (bEnable && *iPc & FD_PMSG_IF_INVISIBLE)
				//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkKjEpBjFfMiOkGiPpDjBnE_xHqqkZx_ -----
				{
					if (pTargetWnd != NULL &&
						IsWindow(pTargetWnd->m_hWnd) &&
						s_stVisibleWnd.find(pTargetWnd) != s_stVisibleWnd.end())
						bEnable = FALSE;
				}
			}
		}
		if (bEnable)
		//----- _xZkqqHx_iPpAiMiPiCkKjBfDiCmEiPfLiClNiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			CWnd* pTargetWnd = NULL;
			switch ((*i).m_dwDestination)
			{
			case FD_PMSG_MAIN_WND:		// FFGetMainWnd()->GetWnd()_xZkqqHx_iBeC_xHqqkZx_
				pTargetWnd = (CWnd*)FFGetMainWnd()->GetWnd();
				break;
			case FD_PMSG_FRAME:			// g_pFrame_xZkqqHx_iBeC_xHqqkZx_
				pTargetWnd = (CWnd*)g_pFrame;
				break;
			case FD_PMSG_IN_PLACE:		// g_pInPlace_xZkqqHx_iBeC_xHqqkZx_
				pTargetWnd = (CWnd*)g_pInPlace;
				break;
			case FD_PMSG_VIEW:			// g_pView_xZkqqHx_iBeC_xHqqkZx_
				pTargetWnd = (CWnd*)g_pView;
				break;
			case FD_PMSG_MAIN_HRULER:	// FFGetMainWnd()->HRuler()_xZkqqHx_iBeC_xHqqkZx_
				pTargetWnd = (CWnd*)FFGetMainWnd()->HRuler();
				break;
			case FD_PMSG_MAIN_VRULER:	// FFGetMainWnd()->VRuler()_xZkqqHx_iBeC_xHqqkZx_
				pTargetWnd = (CWnd*)FFGetMainWnd()->VRuler();
				break;
			case FD_PMSG_TEXT_EDITOR:	// g_pView->GetRTFEditor().
				if (g_pView != NULL)
					pTargetWnd = (CWnd*)g_pView->GetRTFEditor();
				break;
			}
			if (pTargetWnd != NULL)
			{
				if ((*i).m_bImmediate)
					pTargetWnd->SendMessage((*i).m_dwMessage, (*i).m_dwWParam, (*i).m_dwLParam);
				else
					pTargetWnd->PostMessage((*i).m_dwMessage, (*i).m_dwWParam, (*i).m_dwLParam);
			}
			// _xZkqqHx_jBjHjFhEiClFiClNiDiBiDgCiDfKiBfLiDfHiCpAiBeBjFnLjHkPiDiBiDgCiDfKiBfLiDfHiDgPiDgCiDhEiDeAiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
			i = s_vPostMessages.erase(i);
		} else
		{
			i++;
		}
	}

//----- 06.03.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iKnGjAjEiPiIjHjNjCiGiCkJiBeI_xHqqkZx_
	s_bIsDoing = FALSE;
//----- 06.03.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FFNotifyPendingMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSendPendingMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeFiDeCiDjDiDgIiDeFiCkKjHeMiMpIiCmJiCmIiCmBiClNiCmGiCkLiBeBiDiBiDgCiDfKiBfLiDfHiCpA_xHqqkZx_SendMessage
 *			_xZkqqHx_iCmFjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwDestination	:_xZkqqHx_jBjHjFhEjAoGiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeCiPpAiMiPiOhHjCoIiCpAiClFiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
 *			dwMessage		:_xZkqqHx_jBjHjFhEiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwWParam		:_xZkqqHx_jBjHjFhEiDiBiDgCiDfKiBfLiDfHiCmMiDhAiDiJiDiBiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwLParam		:_xZkqqHx_jBjHjFhEiDiBiDgCiDfKiBfLiDfHiCmMiDhAiDiJiDiBiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	dwDestination _xZkqqHx_iCmJiPpAiMiPiCkKjFhEjBnBiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiCmMiPpAiMiPiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFhEjBnBiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_FD_PMSG_IF_ENABLE _xZkqqHx_iCpAiPpAiMiPiCmGiClFiCmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSendPendingMessage (	DWORD dwDestination,
							DWORD dwMessage,
							DWORD dwWParam,
							DWORD dwLParam)
{
	// _xZkqqHx_iPpAiMiPjGkCjAnNjCoIiCmMiPoKiNiHiCmNiBeB_xHqqkZx_FD_PMSG_IF_ENABLE _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	if ((dwDestination & FD_PMSG_MASK_STATUS) == 0)
		dwDestination |= FD_PMSG_IF_ENABLE;
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjChOjAmPiBeC_xHqqkZx_
	FFPushPendingMessage(FCPendingMessage(	dwDestination,
											dwMessage,
											dwWParam,
											dwLParam, TRUE));
} // FFSendPendingMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPostPendingMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeFiDeCiDjDiDgIiDeFiCkKjHeMiMpIiCmJiCmIiCmBiClNiCmGiCkLiBeBiDiBiDgCiDfKiBfLiDfHiCpA_xHqqkZx_PostMessage
 *			_xZkqqHx_iCmFjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwDestination	:_xZkqqHx_jBjHjFhEjAoGiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeCiPpAiMiPiOhHjCoIiCpAiClFiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
 *			dwMessage		:_xZkqqHx_jBjHjFhEiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwWParam		:_xZkqqHx_jBjHjFhEiDiBiDgCiDfKiBfLiDfHiCmMiDhAiDiJiDiBiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwLParam		:_xZkqqHx_jBjHjFhEiDiBiDgCiDfKiBfLiDfHiCmMiDhAiDiJiDiBiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	dwDestination _xZkqqHx_iCmJiPpAiMiPiCkKjFhEjBnBiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiCmMiPpAiMiPiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFhEjBnBiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_FD_PMSG_IF_ENABLE _xZkqqHx_iCpAiPpAiMiPiCmGiClFiCmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPostPendingMessage (	DWORD dwDestination,
							DWORD dwMessage,
							DWORD dwWParam,
							DWORD dwLParam)
{
	// _xZkqqHx_iPpAiMiPjGkCjAnNjCoIiCmMiPoKiNiHiCmNiBeB_xHqqkZx_FD_PMSG_IF_ENABLE _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	if ((dwDestination & FD_PMSG_MASK_STATUS) == 0)
		dwDestination |= FD_PMSG_IF_ENABLE;
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjChOjAmPiBeC_xHqqkZx_
	FFPushPendingMessage(FCPendingMessage(dwDestination,
											dwMessage,
											dwWParam,
											dwLParam, FALSE));
} // FFPostPendingMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPostSendMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiBiDgCiDfKiBfLiDfHiCpAiBeBjChIiJiEiCmF_xHqqkZx_SendMessage_xZkqqHx_iCpAiOgHiCmBiCmEjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwDestination	:_xZkqqHx_jBjHjFhEjAoGiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeCiPpAiMiPiOhHjCoIiCpAiClFiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
 *			dwMessage		:_xZkqqHx_jBjHjFhEiDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwWParam		:_xZkqqHx_jBjHjFhEiDiBiDgCiDfKiBfLiDfHiCmMiDhAiDiJiDiBiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwLParam		:_xZkqqHx_jBjHjFhEiDiBiDgCiDfKiBfLiDfHiCmMiDhAiDiJiDiBiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FFSendPendingMessage _xZkqqHx_iCmGiCmMiIoBiCkCiCmNiBeB_xHqqkZx_FFSendPendingMessage_xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_iClHiCkOiCmJiDeFiDeCiDjDiDgIiDeFiCmMjHeMiMpIjAkLiCpAiDgAiDeGiDgCiDeOiBjFjBjHjFhEiPiIjHjNiCpAiClHiCoJiCmMiCmJjBmOiClFiCmEiBeB_xHqqkZx_
 *			FFPostSendMessage _xZkqqHx_iCmNiBeBiDfOiDeDiDhNiBfLiCmFiMoDiCkJiCoHiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeB_xHqqkZx_PostMessage_xZkqqHx_iCmMiCoGiCkEiCmJjChIiJiEiCmFiDiBiDgCiDfKiBfLiDfHiCkKjBjHjFhEiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCmIiClK_xHqqkZx_PostMessage_xZkqqHx_iCpAiOgHiCoNiCmIiCkCiCkJiCmGiCkCiCkEiCmGiBeB_xHqqkZx_Win98,Me_xZkqqHx_iCmJiCkIiCkCiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iClNiCkNiClDiCpBiCmMjFjEjFgJiCpAiKnMiCnOiDgAiDgCiDhGiCpAiDgIiDiJiDgCiDePiClFiCmEjCkDiCoIjFhEiCkPiClNiPoKiNiHiBeB_xHqqkZx_
 *			PostMessage_xZkqqHx_iCkKiPmBiOlIiClFiCmEiClFiCnMiCkEiMlLiPnLiCkKjEkNjAlGiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiKgNiOmAiCmJjBjHjFhEiCmFiCkLiCoJiKnGjAjEiCpAjHhAiInDiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPostSendMessage (DWORD dwDestination,
						DWORD dwMessage,
						DWORD dwWParam,
						DWORD dwLParam)
{
	// _xZkqqHx_iPpAiMiPjGkCjAnNjCoIiCmMiPoKiNiHiCmNiBeB_xHqqkZx_FD_PMSG_IF_ENABLE _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	if ((dwDestination & FD_PMSG_MASK_STATUS) == 0)
		dwDestination |= FD_PMSG_IF_ENABLE;
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjChOjAmPiBeC_xHqqkZx_
	FFPushPendingMessage(FCPendingMessage(	dwDestination,
											dwMessage,
											dwWParam,
											dwLParam,
											TRUE),
						 FALSE);
} // FFPostSendMessage.
