#include "stdafx.h"
#include "png.h"			// For PNG and ZLIB_xZkqqHx_iBeC_xHqqkZx_
#include "resource.h"		// For IDS_DOCUMENT_PROPERTY_FORMAT.
#include "UtilStr.h"		// For FFExtractUntil.
#include "UtilErr.h"		// For CFCDDFileException.
#include "UtilMisc.h"		// For FFVersionInfo.etc.
#include "UndoArchive.h"	// For FCUndoArchive.
//#include "FoundDoc.h"		// For FD_DPID_END.
#include "UtilZlibPng.h"	// This header.

const BYTE* PNG_IEND = (const BYTE*)"IEND";

//----- 03.06.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ID <-> _xZkqqHx_iDgFiDeMiDfIiDgHiDgAiDiDiDjDiDeOiCmMiLeLjCoIiDfOiDeDiDgHiDiL_xHqqkZx_ -----
//static const struct
//{
//	FTDocumentPropertyId dpid;
//	const char* cpKey;
//} s_DpidToKey[] =
//{
//	{ FD_DPID_DOCUMENT_TITLE,	"Title" },				// _xZkqqHx_jFlGiPjBiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
//	{ FD_DPID_DOCUMENT_AUTHOR,	"Author" },				// _xZkqqHx_jFlGiPjBiNoMiOnCiBeC_xHqqkZx_
//	{ FD_DPID_DOCUMENT_DESCRIPTION,	"Description" },	// _xZkqqHx_jFlGiPjBjAoAjGlOiBeC_xHqqkZx_
//	{ FD_DPID_DOCUMENT_COMMENT,	"Comment" }				// _xZkqqHx_jFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
//};
//----- 03.06.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//////////////////////////////////////////////////////////////////////
// static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_

static void myFuncPngRead (png_structp png_ptr, png_bytep data, png_size_t length)
{
	FCUndoArchive& fcar = *(FCUndoArchive*)png_get_io_ptr(png_ptr);
	if (data != NULL)
	{
		if (fcar.Read(data, length) != length)
			FFThrowDDFileException(IDS_ERR_FILE_WRONG_FORM, L"");
	} else
	{
		// FCUndoArchive_xZkqqHx_iCmNiBeB_xHqqkZx_ar.GetFile() _xZkqqHx_iCkJiCoHjDoAjFjEiDgPiDgCiDhEiDeAiCmJ_xHqqkZx_
		// _xZkqqHx_iCnMiCmGiCnPiCmEjDmHiCnNiNjOiCnOiClNiCnPiBeB_xHqqkZx_ar.GetFile()->Seek()
		// _xZkqqHx_iCmNiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
		BYTEVector vBuff(length);
		if (fcar.Read(vBuff.begin(), length) != length)
			FFThrowDDFileException(IDS_ERR_FILE_WRONG_FORM, L"");
	}
} // myFuncPngRead.

static void myFuncPngError (png_structp png_ptr, png_const_charp error_message)
{
	// PNG_xZkqqHx_iDiJiDeDiDhFiDiJiDiKiCmFiCmNiBeBiDeHiDiJiBfLiOoNjFmKiCpAjElLjFmKiCmFiCkLiCoJiDeHiDiJiBfLiDfCiBfLiDgIiCmNjGlDiCkNiBeB_xHqqkZx_
	// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHjFlGiOjKjHpBiCmFiClFiCkJiPgPjHmNiClFiCmIiCkCiBeC_xHqqkZx_
	// IDS_ERR_MSG_PNG = PNG_xZkqqHx_iDeHiDiJiBfL_xHqqkZx_:%s
	FFThrowMiscException(IDS_ERR_MSG_PNG, (const wchar_t*)AStrToWStr(error_message));
} // myFuncPngError.

static void myFuncPngWarning (png_structp png_ptr, png_const_charp warning_message)
{
} // myFuncPngWarning.

static void myFuncPngWrite (png_structp png_ptr, png_bytep data, png_size_t length)
{
	FCUndoArchive& ar = *(FCUndoArchive*)png_get_io_ptr(png_ptr);
	ar.Write(data, length);
} // myFuncPngWrite.

static void myFuncPngFlush (png_structp png_ptr)
{
	FCUndoArchive& ar = *(FCUndoArchive*)png_get_io_ptr(png_ptr);
	ar.Flush();
} // myFuncPngFlush.

//////////////////////////////////////////////////////////////////////
// exterun_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngGetIoPtr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	png_struct_xZkqqHx_iNfMjBkCjBmMiCkJiCoHiBeB_xHqqkZx_IO_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *			IO_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmNiBeB_xHqqkZx_FFPngReadInitialize_xZkqqHx_jDjJiCmFiOhHjCoIiClDiCoKiClNjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPngStr	:png_struct_xZkqqHx_iNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	IO_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	SDK_xZkqqHx_iCmJiMpGiKeKiClHiCoJiClNiCnPiCmJjHhAiInDiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void* FFPngGetIoPtr (png_struct* pPngPtr)
{
	return png_get_io_ptr(pPngPtr);
} // FFPngGetIoPtr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngGetUint32
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_PNG_xZkqqHx_iCmM_xHqqkZx_BYTE_xZkqqHx_jHpBiCpA_xHqqkZx_32Bit_xZkqqHx_jFiEiNiGjGlDiClFjAkOjAjEiCnGjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDeHiDjDiDgGiDeCiDeBiDjDiCmMiIoBiCkCiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pBuff	:BYTE_xZkqqHx_jHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiKlHiClFiClNjAjEjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FFPngGetUint32 (const BYTE* pBuff)
{
	DWORD dw = ((png_uint_32)(*pBuff) << 24) +
				((png_uint_32)(*(pBuff + 1)) << 16) +
				((png_uint_32)(*(pBuff + 2)) << 8) +
				(png_uint_32)(*(pBuff + 3));
	return dw;
} // FFPngGetUint32.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngGetUintByte32
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_32Bit_xZkqqHx_jFiEiNiGjGlDiClFjAkOjAjEiCpA_xHqqkZx_PNG_xZkqqHx_iCmM_xHqqkZx_BYTE_xZkqqHx_jHpBiCnGjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDeHiDjDiDgGiDeCiDeBiDjDiCmMiIoBiCkCiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pBuff	:BYTE_xZkqqHx_jHpBiCpAjFnEiClHiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dw		:_xZkqqHx_jFmPiKlHiClHiCoJjAjEjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngGetUintByte32 (png_bytep pBuff, png_uint_32 dw)
{
	pBuff[0] = (dw >> 24) & 0xff;
	pBuff[1] = (dw >> 16) & 0xff;
	pBuff[2] = (dw >> 8) & 0xff;
	pBuff[3] = dw & 0xff;
} // FFPngGetUintByte32.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFItxtToWStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	UTF8_xZkqqHx_iMgAiOkOjFlGiOjKjHpBiCpA_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCnGjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cpItxt	:UTF8_xZkqqHx_iMgAiOkOjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	UNICODE_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	UTF8_xZkqqHx_iMgAiOkOjFlGiOjKjHpBiCmN_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCmM_xHqqkZx_lang_key_xZkqqHx_iCmG_xHqqkZx_text_xZkqqHx_iCmJiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jCeBiClFiBeB_xHqqkZx_Windows95_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ MultiByteToWideChar_xZkqqHx_iKnGjAjEiCkK_xHqqkZx_ UTF8_xZkqqHx_iCmJ_xHqqkZx_
 *			_xZkqqHx_jBmOiJjOiClFiCmEiCkCiCmIiCkCiClNiCnPiBeB_xHqqkZx_UTF8_xZkqqHx_jFlGiOjKjHpBiCmM_xHqqkZx_char_xZkqqHx_iCpAiClLiCmMiCnMiCnM_xHqqkZx_wchar_t_xZkqqHx_jFlGiOjKiCnG_xHqqkZx_
 *			_xZkqqHx_jChFiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FFItxtToWStr (const char* cpItxt)
{
	WString wstr;
	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_WINDOWS &&
		FFVersionInfo().dwMajorVersion == 4 &&
		FFVersionInfo().dwMinorVersion == 0)
	//----- Windows95_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ ------
	{
		wstr.erase();
		for (; *cpItxt != '\0'; cpItxt++)
			wstr += wchar_t(BYTE(*cpItxt));
	} else
	//----- Windows95_xZkqqHx_iImIiKePiCmMiPoKiNiH_xHqqkZx_ ------
	{
		wstr = AStrToWStr(cpItxt, CP_UTF8);
	}
	return wstr;
} // FFItxtToWStr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFWStrToItxt
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	UNICODE_xZkqqHx_jFlGiOjKjHpBiCpA_xHqqkZx_UTF8_xZkqqHx_iMgAiOkOjFlGiOjKjHpBiCnGjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcp	:UNICODE_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	UTF8_xZkqqHx_iMgAiOkOjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	UTF8_xZkqqHx_iMgAiOkOjFlGiOjKjHpBiCmN_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCmM_xHqqkZx_lang_key_xZkqqHx_iCmG_xHqqkZx_text_xZkqqHx_iCmJiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jCeBiClFiBeB_xHqqkZx_Windows95_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ WideCharToMultiByte_xZkqqHx_iKnGjAjEiCkK_xHqqkZx_ UTF8_xZkqqHx_iCmJ_xHqqkZx_
 *			_xZkqqHx_jBmOiJjOiClFiCmEiCkCiCmIiCkCiClNiCnPiBeB_xHqqkZx_UNICODE_xZkqqHx_iCmM_xHqqkZx_wchar_t_xZkqqHx_iCpAiClLiCmMiCnMiCnM_xHqqkZx_char_xZkqqHx_jFlGiOjKiCnG_xHqqkZx_
 *			_xZkqqHx_jChFiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
astring FFWStrToItxt (const wchar_t* wcp)
{
	astring strItxt;
	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_WINDOWS &&
		FFVersionInfo().dwMajorVersion == 4 &&
		FFVersionInfo().dwMinorVersion == 0)
	//----- Windows95_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ ------
	{
		strItxt.erase();
		for (; *wcp != L'\0'; wcp++)
			strItxt += char(BYTE(*wcp));
	} else
	//----- Windows95_xZkqqHx_iImIiKePiCmMiPoKiNiH_xHqqkZx_ ------
	{
		strItxt = WStrToAStr(wcp, CP_UTF8);
	}
	return strItxt;
} // FFWStrToItxt.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFMakePngImage32
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_iCmJiOpLjIfOiClDiCoKiCoJiMgAiOkOiCmMiCfCiCfBiDhCiDgCiDgHiDeKiDiJiBfLiCmMiDeDiDiBiBfLiDfHiDgGiBfLiDfOiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byvBitBuff	:_xZkqqHx_iDhCiDgCiDgHiDhNiDgCiDhGiDgGiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *			szImage		:_xZkqqHx_iDhCiDgCiDgHiDhNiDgCiDhGiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			func		:_xZkqqHx_jFgAiJoGjHhAiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwData		:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCmJjDgOiCoJiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFMakePngImage32 (BYTEVector& byvBitBuff, const CSize& szImage,
						FuncDrawImage func, DWORD dwData)
{
	CDC dcDisplay;
	dcDisplay.CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
	CDC dc;
	dc.CreateCompatibleDC(&dcDisplay);
	BITMAPINFO bmi;
	ZeroMemory(&bmi, sizeof(BITMAPINFO));
	bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bmi.bmiHeader.biWidth = szImage.cx;
	// _xZkqqHx_iPoDiCkJiCoHiJlKiCnGiCmM_xHqqkZx_DIB_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_biHeight_xZkqqHx_iCkKjFiJiCmMjCgMiBeC_xHqqkZx_
	bmi.bmiHeader.biHeight = -szImage.cy;
	bmi.bmiHeader.biPlanes = 1;
	bmi.bmiHeader.biBitCount = 32;
	bmi.bmiHeader.biCompression = BI_RGB;
	bmi.bmiHeader.biSizeImage = szImage.cx * szImage.cy * 4;
	BYTE* pbyBits;
	HBITMAP hbitmap = CreateDIBSection(dc.m_hDC, &bmi, DIB_RGB_COLORS, (void**)&pbyBits, NULL, 0x0);
	SelectObject(dc.m_hDC, hbitmap);
	long x, y;
	// alpha_xZkqqHx_jCgMiCpA_xHqqkZx_FF_xZkqqHx_iCmFiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	for (y = 0; y < szImage.cy; y++)
		for (x = 0; x < szImage.cx; x++)
			pbyBits[4 * (x + y * szImage.cx) + 3] = 0xff;

	// _xZkqqHx_iDgPiDgCiDeOiDePiDiJiDeFiDjDiDgIiCpAjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
	dc.FillRect(CRect(0, 0, szImage.cx, szImage.cy),
				CBrush::FromHandle((HBRUSH)::GetStockObject(WHITE_BRUSH)));

	// _xZkqqHx_jFgAiJoGjHhAiDfCiBfLiDiLiDgPiDgCiDeOiCpAiOmAiNhDiBeC_xHqqkZx_
	(*func)(&dc, dwData, szImage);
	// DIB_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCpA_xHqqkZx_PNG_xZkqqHx_iMpMiCkPiCmJjFmPiNfIiBeC_xHqqkZx_
	FFDIBToPngImage32(pbyBits, szImage);
	// ChipRec_xZkqqHx_iCmM_xHqqkZx_m_pBits_xZkqqHx_iCmMiDfEiDeDiDfJiBeC_xHqqkZx_
	const DWORD dwChipBits = (szImage.cx * szImage.cy * 32) / 8;
	byvBitBuff.resize(dwChipBits);
	GetBitmapBits(hbitmap, dwChipBits, byvBitBuff.begin());
	DeleteObject(hbitmap);
} // FFMakePngImage32.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngImageToDIB32
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_iCmJiOpLjIfOiClDiCoKiCmEiCkCiCoJiDeDiDiBiBfLiDfHiDgGiBfLiDfOiCpA_xHqqkZx_DIB_xZkqqHx_iCmMiMgAiOkOiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bypData	:_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCpAiOhHjCoIiBeCjFmPiKlHiClFiClNiDeDiDiBiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			szImage	:_xZkqqHx_iDeDiDiBiBfLiDfHiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngImageToDIB32 (BYTE* bypData, const CSize& szImage)
{
	for (long y = 0; y < szImage.cy; y++)
	{
		for (long x = 0; x < szImage.cx; x++)
		{
			// RGB _xZkqqHx_iCmM_xHqqkZx_ R_xZkqqHx_iCmG_xHqqkZx_B_xZkqqHx_iCpAjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
			::Exchange(bypData[4 * (x + y * szImage.cx) + 0],
						bypData[4 * (x + y * szImage.cx) + 2]);
			// _xZkqqHx_jFgAiJoGiClFiClNjFjEjFkKiCmM_xHqqkZx_alpha_xZkqqHx_jCgMiCmN_xHqqkZx_0_xZkqqHx_iCmJiDiKiDfKiDgCiDgHiClDiCoKiCmEiCkCiCoJiClNiCnPiBeB_xHqqkZx_
			// _xZkqqHx_jBfDiCmEiCmMjHmMiIoGiCmF_xHqqkZx_alpha_xZkqqHx_jCgMiCpAjElNjDfNiClDiClJiCoJiBeCiClBiCoKiCmJiCoGiCmBiCmEiBeB_xHqqkZx_
			// _xZkqqHx_jFgAiJoGiClDiCoKiClNjFjEjFkKiCmM_xHqqkZx_alpha_xZkqqHx_jCgMiCmMiCnNiBeB_xHqqkZx_FF_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
			bypData[4 * (x + y * szImage.cx) + 3] ^= 0xff;
		}
	}
} // FFPngImageToDIB32.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFDIBToPngImage32
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DIB_xZkqqHx_iCmMiDeDiDiBiBfLiDfHiMgAiOkOiCpA_xHqqkZx_PNG_xZkqqHx_iCmJiOpLjIfOiClDiCoKiCmEiCkCiCoJiDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bypData	:_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCpAiOhHjCoIiBeCjFmPiKlHiClFiClNiDeDiDiBiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			szImage	:_xZkqqHx_iDeDiDiBiBfLiDfHiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFDIBToPngImage32 (BYTE* bypData, const CSize& szImage)
{
	FFPngImageToDIB32(bypData, szImage);
} // FFDIBToPngImage32.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngRead32BitImageAndText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ar_xZkqqHx_iCkJiCoH_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar					:_xZkqqHx_jDpMjHmNiMlDiCmMiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szp32Image			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			vp32Image;			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMjDpMjHmNiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstraDocProperty	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
 *								 _xZkqqHx_iCkJiCoHjDpMjHmNiClDiCoKiCoJiBeC_xHqqkZx_
 *								 iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSkipUntilEnd		:PNG_xZkqqHx_iPeJjCfLiCnMiCmFiDfIiDeMiDgCiDhGiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
 *								 _xZkqqHx_jFeLjHhGiCmIiDgGiBfLiDfOiCpAiOoGjDlOiClFiClNiOjOjDfPiCmFiPeJjHlJiClHiCoJ_xHqqkZx_
 *								 _xZkqqHx_iPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ar_xZkqqHx_iCkJiCoH_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClFiBeBiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNjFmPjAjEiCmJjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iIpIjAjEiCmF_xHqqkZx_NULL_xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiNiAjGnKiCmNjDmHiCnNiNjOiCnNiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *			MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCmMiDgAiDiDiDjDiDeOjGlMiCnMiCmFiBeBiIlNiCkCiCmN_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClFiCmIiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_PNG_xZkqqHx_iMgAiOkOiCmMiNmFiMoDiBgJ_xHqqkZx_IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCmMiPeJiCoNiCoIiBgKiCnMiCmF_xHqqkZx_ ar _xZkqqHx_iCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngRead32BitImageAndText (FCUndoArchive& ar,
								CSize* szp32Image,
								BYTEVector* vp32Image,
								WString* wstraDocProperty,
								long lDocPropertySize,
								BOOL bSkipUntilEnd)
{
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// png_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiBeC_xHqqkZx_
//	FCPngReadStruct* ps = FFPngReadInitialize(ar);
//	try
//	{
//		// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//		ps->m_szImage32 = szp32Image;
//		ps->m_vImage32 = vp32Image;
//		// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCjCgMiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//		ps->m_wstraDocumentProperty = wstraDocProperty;
//		ps->m_lDocumentPropertySize = lDocPropertySize;
//		// MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmFjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//		// FFPngReadUntilMdrwChunk_xZkqqHx_iKnGjAjEiCmNiBeB_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkK_xHqqkZx_
//		// _xZkqqHx_jBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_PNG_xZkqqHx_iPeJjCfLiCnMiCmFiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
//		if (FFPngReadUntilMdrwChunk(ps))
//		//----- MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iPeJjCfLiCnMiCmFiDfIiDeMiDgCiDhGiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoKiCmOiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
//			if (bSkipUntilEnd)
//				FFPngReadUntilEnd(ps);
//		}
//	} catch (CException* e)
//	//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
//		FFPngTerminate(ps);
//		throw e;
//	}
//	// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
//	FFPngTerminate(ps);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FFPngRead32BitImageAndText(	&ar,
								myFuncPngRead,
								myFuncPngError,
								myFuncPngWarning,
								szp32Image,
								vp32Image,
								wstraDocProperty,
								lDocPropertySize,
								bSkipUntilEnd);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFPngRead32BitImageAndText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngRead32BitImageAndText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ar_xZkqqHx_iCkJiCoH_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pIo					:_xZkqqHx_jDpMjHmNjHhAiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngRead			:_xZkqqHx_jDmHiCnNiPgPiClFjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngError		:_xZkqqHx_iDeHiDiJiBfLiPiIjHjNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngWarning		:_xZkqqHx_iMhIiNjAiPiIjHjNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szp32Image			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			vp32Image;			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMjDpMjHmNiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstraDocProperty	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
 *								 _xZkqqHx_iCkJiCoHjDpMjHmNiClDiCoKiCoJiBeC_xHqqkZx_
 *								 iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSkipUntilEnd		:PNG_xZkqqHx_iPeJjCfLiCnMiCmFiDfIiDeMiDgCiDhGiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeB_xHqqkZx_
 *								 _xZkqqHx_jFeLjHhGiCmIiDgGiBfLiDfOiCpAiOoGjDlOiClFiClNiOjOjDfPiCmFiPeJjHlJiClHiCoJ_xHqqkZx_
 *								 _xZkqqHx_iPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ar_xZkqqHx_iCkJiCoH_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClFiBeBiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNjFmPjAjEiCmJjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iIpIjAjEiCmF_xHqqkZx_NULL_xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiNiAjGnKiCmNjDmHiCnNiNjOiCnNiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *			MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCmMiDgAiDiDiDjDiDeOjGlMiCnMiCmFiBeBiIlNiCkCiCmN_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClFiCmIiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_PNG_xZkqqHx_iMgAiOkOiCmMiNmFiMoDiBgJ_xHqqkZx_IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCmMiPeJiCoNiCoIiBgKiCnMiCmF_xHqqkZx_ ar _xZkqqHx_iCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngRead32BitImageAndText (	void* pIo,
									FuncPngRead funcPngRead,
									FuncPngError funcPngError,
									FuncPngWarning funcPngWarning,
									CSize* szp32Image,
									BYTEVector* vp32Image,
									WString* wstraDocProperty,
									long lDocPropertySize,
									BOOL bSkipUntilEnd)
{
	// png_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiBeC_xHqqkZx_
	FCPngReadStruct* ps = FFPngReadInitialize(	pIo,
												funcPngRead,
												funcPngError,
												funcPngWarning);
	try
	{
		// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
		ps->m_szImage32 = szp32Image;
		ps->m_vImage32 = vp32Image;
		// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCjCgMiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
		ps->m_wstraDocumentProperty = wstraDocProperty;
		ps->m_lDocumentPropertySize = lDocPropertySize;
		// MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmFjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		// FFPngReadUntilMdrwChunk_xZkqqHx_iKnGjAjEiCmNiBeB_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkK_xHqqkZx_
		// _xZkqqHx_jBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_PNG_xZkqqHx_iPeJjCfLiCnMiCmFiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
		if (FFPngReadUntilMdrwChunk(ps))
		//----- MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iPeJjCfLiCnMiCmFiDfIiDeMiDgCiDhGiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoKiCmOiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (bSkipUntilEnd)
				FFPngReadUntilEnd(ps);
		}
	} catch (CException* e)
	//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
	{
		// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
		FFPngTerminate(ps);
		throw e;
	}
	// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
	FFPngTerminate(ps);
} // FFPngRead32BitImageAndText.

//----- 06.03.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngRead32BitData
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	file_xZkqqHx_iCkJiCoH_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	file				:_xZkqqHx_jDpMjHmNiMlDiCmMiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
// *			szp32Image			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			vp32Image;			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMjDpMjHmNiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			wstraDocProperty	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
// *								 _xZkqqHx_iCkJiCoHjDpMjHmNiClDiCoKiCoJiBeC_xHqqkZx_
// *								 iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocPropertySize	:m_wstraDocumentProperty_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			vpMdrwChunkData		:MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiDgGiBfLiDfOiCmMjDpMjHmNiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	file_xZkqqHx_iCkJiCoH_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClFiBeBiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNjFmPjAjEiCmJjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iIpIjAjEiCmF_xHqqkZx_NULL_xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiNiAjGnKiCmNjDmHiCnNiNjOiCnNiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
// *			PNG_xZkqqHx_iMgAiOkOiCmMiNmFiMoDiBgJ_xHqqkZx_IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCmMiPeJiCoNiCoIiBgKiCnMiCmF_xHqqkZx_ file _xZkqqHx_iCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFPngRead32BitData (	CFile& file,
//							CSize* szp32Image,
//							BYTEVector* vp32Image,
//							WString* wstraDocProperty,
//							long lDocPropertySize,
//							BYTEVector* vpMdrwChunkData)
//{
//	FFPngRead32BitData(	FCUndoArchive(&file, FD_ARCHIVE_LOAD),
//						szp32Image,
//						vp32Image,
//						wstraDocProperty,
//						lDocPropertySize,
//						vpMdrwChunkData);
//} // FFPngRead32BitData.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngRead32BitData
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ar_xZkqqHx_iCkJiCoH_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar					:_xZkqqHx_jDpMjHmNiMlDiCmMiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			szp32Image			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			vp32Image;			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMjDpMjHmNiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			wstraDocProperty	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
// *								 _xZkqqHx_iCkJiCoHjDpMjHmNiClDiCoKiCoJiBeC_xHqqkZx_
// *								 iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocPropertySize	:m_wstraDocumentProperty_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			vpMdrwChunkData		:MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiDgGiBfLiDfOiCmMjDpMjHmNiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ar_xZkqqHx_iCkJiCoH_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClFiBeBiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNjFmPjAjEiCmJjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iIpIjAjEiCmF_xHqqkZx_NULL_xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiNiAjGnKiCmNjDmHiCnNiNjOiCnNiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
// *			PNG_xZkqqHx_iMgAiOkOiCmMiNmFiMoDiBgJ_xHqqkZx_IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCmMiPeJiCoNiCoIiBgKiCnMiCmF_xHqqkZx_ ar _xZkqqHx_iCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFPngRead32BitData (	FCUndoArchive& ar,
//							CSize* szp32Image,
//							BYTEVector* vp32Image,
//							WString* wstraDocProperty,
//							long lDocPropertySize,
//							BYTEVector* vpMdrwChunkData)
//{
//	// png_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiBeC_xHqqkZx_
//	FCPngReadStruct* ps = FFPngReadInitialize(ar);
//	try
//	{
//		// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//		ps->m_szImage32 = szp32Image;
//		ps->m_vImage32 = vp32Image;
//		// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCjCgMiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//		ps->m_wstraDocumentProperty = wstraDocProperty;
//		ps->m_lDocumentPropertySize = lDocPropertySize;
//		// MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmFjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//		if (FFPngReadUntilMdrwChunk(ps))
//		//----- MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			if (vpMdrwChunkData != NULL)
//			//----- MDRW_xZkqqHx_iDgAiDiDiDjDiDeOjDmHiCnNiNjOiCnNiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iDgAiDiDiDjDiDeOiDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//				FFPngReadChunk(ps, *vpMdrwChunkData);
//			}
//			// PNG_xZkqqHx_iPeJjCfLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//			FFPngReadUntilEnd(ps);
//		}
//	} catch (CException* e)
//	//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
//		FFPngTerminate(ps);
//		throw e;
//	}
//	// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
//	FFPngTerminate(ps);
//} // FFPngRead32BitData.
//----- 06.03.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngRead32Begin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ar_xZkqqHx_iCkJiCoH_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCmMjClMjBePiCnMiCmF_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar					:_xZkqqHx_jDpMjHmNiMlDiCmMiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szp32Image			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			vp32Image;			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMjDpMjHmNiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstraDocProperty	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
 *								 _xZkqqHx_iCkJiCoHjDpMjHmNiClDiCoKiCoJiBeC_xHqqkZx_
 *								 iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocPropertySize	:m_wstraDocumentProperty_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmMiBeC_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ar_xZkqqHx_iCkJiCoH_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClFiBeBiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNjFmPjAjEiCmJjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iIpIjAjEiCmF_xHqqkZx_NULL_xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiNiAjGnKiCmNjDmHiCnNiNjOiCnNiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *			MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_PNG_xZkqqHx_iMgAiOkOiCmMiNmFiMoDiBgJ_xHqqkZx_IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCmMiPeJiCoNiCoIiBgK_xHqqkZx_
 *			_xZkqqHx_iCnMiCmF_xHqqkZx_ ar _xZkqqHx_iCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPngReadStruct* FFPngRead32Begin (	FCUndoArchive& ar,
									CSize* szp32Image,
									BYTEVector* vp32Image,
									WString* wstraDocProperty,
									long lDocPropertySize)
{
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// png_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiBeC_xHqqkZx_
//	FCPngReadStruct* ps = FFPngReadInitialize(ar);
//	try
//	{
//		// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//		ps->m_szImage32 = szp32Image;
//		ps->m_vImage32 = vp32Image;
//		// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCjCgMiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//		ps->m_wstraDocumentProperty = wstraDocProperty;
//		ps->m_lDocumentPropertySize = lDocPropertySize;
//		// MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmFjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//		if (!FFPngReadUntilMdrwChunk(ps))
//		//----- MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
//			FFPngTerminate(ps);
//			ps = NULL;
//		}
//	} catch (CException* e)
//	//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
//		FFPngTerminate(ps);
//		throw e;
//	}
//	return ps;
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return FFPngRead32Begin(&ar,
							myFuncPngRead,
							myFuncPngError,
							myFuncPngWarning,
							szp32Image,
							vp32Image,
							wstraDocProperty,
							lDocPropertySize);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFPngRead32Begin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngRead32Begin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ar_xZkqqHx_iCkJiCoH_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCmMjClMjBePiCnMiCmF_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pIo					:_xZkqqHx_jDpMjHmNjHhAiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngRead			:_xZkqqHx_jDmHiCnNiPgPiClFjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngError		:_xZkqqHx_iDeHiDiJiBfLiPiIjHjNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngWarning		:_xZkqqHx_iMhIiNjAiPiIjHjNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szp32Image			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			vp32Image;			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMjDpMjHmNiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstraDocProperty	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
 *								 _xZkqqHx_iCkJiCoHjDpMjHmNiClDiCoKiCoJiBeC_xHqqkZx_
 *								 iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAjDpMjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocPropertySize	:m_wstraDocumentProperty_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmMiBeC_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ar_xZkqqHx_iCkJiCoH_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClFiBeBiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNjFmPjAjEiCmJjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iIpIjAjEiCmF_xHqqkZx_NULL_xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiNiAjGnKiCmNjDmHiCnNiNjOiCnNiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *			MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_PNG_xZkqqHx_iMgAiOkOiCmMiNmFiMoDiBgJ_xHqqkZx_IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCmMiPeJiCoNiCoIiBgK_xHqqkZx_
 *			_xZkqqHx_iCnMiCmF_xHqqkZx_ ar _xZkqqHx_iCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPngReadStruct* FFPngRead32Begin (	void* pIo,
									FuncPngRead funcPngRead,
									FuncPngError funcPngError,
									FuncPngWarning funcPngWarning,
									CSize* szp32Image,
									BYTEVector* vp32Image,
									WString* wstraDocProperty,
									long lDocPropertySize)
{
	// png_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiBeC_xHqqkZx_
	FCPngReadStruct* ps = FFPngReadInitialize(	pIo,
												funcPngRead,
												funcPngError,
												funcPngWarning);
	try
	{
		// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
		ps->m_szImage32 = szp32Image;
		ps->m_vImage32 = vp32Image;
		// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCjCgMiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
		ps->m_wstraDocumentProperty = wstraDocProperty;
		ps->m_lDocumentPropertySize = lDocPropertySize;
		// MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmFjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		if (!FFPngReadUntilMdrwChunk(ps))
		//----- MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
			FFPngTerminate(ps);
			ps = NULL;
		}
	} catch (CException* e)
	//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
	{
		// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
		FFPngTerminate(ps);
		throw e;
	}
	return ps;
} // FFPngRead32Begin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngRead32MdrwChunk
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ps				:PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vMdrwChunkData	:MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjDmHiCnNiPgPiClJiClNiPoKiNiHiCmN_xHqqkZx_ ps_xZkqqHx_iBeBjDmHiCnNiPgPiClJiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClJiClIjDmHiCnNiPgPiClJiCmIiCkCiPoKiNiHiCmNiBeBiPeJjCfLiCnMiCmFjDmHiCnNiPgPiClFiCmE_xHqqkZx_
 *			ps _xZkqqHx_iCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPngReadStruct* FFPngRead32MdrwChunk (	FCPngReadStruct* ps,
										BYTEVector& vMdrwChunkData)
{
	try
	{
		// MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmFiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		if (FFPngSkipUntilSpecChunk(ps, FD_MDRW_CHUNK_NAME))
		//----- MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgAiDiDiDjDiDeOiDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
			FFPngReadChunk(ps, vMdrwChunkData);
		} else
		//----- MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
			FFPngTerminate(ps);
			ps = NULL;
		}
	} catch (CException* e)
	//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
	{
		// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
		FFPngTerminate(ps);
		throw e;
	}
	return ps;
} // FFPngRead32MdrwChunk.
//----- 06.03.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.03.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngWrite32BitData
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	file_xZkqqHx_iCmJ_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	file				:_xZkqqHx_iPgPjHmNjAoGiCmMiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			szp32Image			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			p32Image;			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			wstraDocProperty	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
// *								 _xZkqqHx_iCmGiClFiCmEiPgPjHmNiClDiCoKiCoJiBeC_xHqqkZx_
// *								 iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiPgPjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocPropertySize	:m_wstraDocumentProperty_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pMdrwChunkData		:MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCpA_xHqqkZx_
// *								 _xZkqqHx_iPgPjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			dwMdrwChunkDataSize	:pMdrwChunkData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFPngWrite32BitData (	CFile& file,
//							const CSize* szp32Image,
//							const BYTE* p32Image,
//							const WString* wstraDocProperty,
//							long lDocPropertySize,
//							const BYTE* pMdrwChunkData,
//							DWORD dwMdrwChunkDataSize)
//{
//	FFPngWrite32BitData(FCUndoArchive(&file, FD_ARCHIVE_STORE),
//						szp32Image,
//						p32Image,
//						wstraDocProperty,
//						lDocPropertySize,
//						pMdrwChunkData,
//						dwMdrwChunkDataSize);
//} // FFPngWrite32BitData.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngWrite32BitData
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ar_xZkqqHx_iCmJ_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar					:_xZkqqHx_iPgPjHmNjAoGiCmMiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			szp32Image			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			p32Image;			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			wstraDocProperty	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
// *								 _xZkqqHx_iCmGiClFiCmEiPgPjHmNiClDiCoKiCoJiBeC_xHqqkZx_
// *								 iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiPgPjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocPropertySize	:m_wstraDocumentProperty_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pMdrwChunkData		:MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCpA_xHqqkZx_
// *								 _xZkqqHx_iPgPjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			dwMdrwChunkDataSize	:pMdrwChunkData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFPngWrite32BitData (	FCUndoArchive& ar,
//							const CSize* szp32Image,
//							const BYTE* p32Image,
//							const WString* wstraDocProperty,
//							long lDocPropertySize,
//							const BYTE* pMdrwChunkData,
//							DWORD dwMdrwChunkDataSize)
//{
//	// png_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiBeC_xHqqkZx_
//	FCPngWriteStruct* ps = FFPngWriteInitialize(ar);
//	// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//	ps->m_szImage32 = szp32Image;
//	ps->m_pImage32 = p32Image;
//	// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCjCgMiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//	ps->m_wstraDocumentProperty = wstraDocProperty;
//	ps->m_lDocumentPropertySize = lDocPropertySize;
//	// PNG_xZkqqHx_iDhHiDgCiDfPiBeBiDeDiDiBiBfLiDfHiBeBiDgFiDeMiDfIiDgHiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	FFPngWriteUntilMdrwChunk(ps);
//	if (pMdrwChunkData != NULL)
//	//----- MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// MDRW_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//		png_structp png_ptr = (png_structp)ps->m_png_ptr;
//		png_write_chunk(png_ptr, (BYTE*)FD_MDRW_CHUNK_NAME,
//						(BYTE*)pMdrwChunkData, dwMdrwChunkDataSize);
//	}
//	// PNG_xZkqqHx_iPeJjCfLiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	FFPngWriteUntilEnd(ps);
//	// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
//	FFPngTerminate(ps);
//} // FFPngWrite32BitData.
//----- 06.03.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngWrite32Begin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ar_xZkqqHx_iCmJ_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCmMjAoGjDkKiCkJiCoH_xHqqkZx_mdRw_xZkqqHx_iDgAiDiDiDjDiDeOiCmMjClMjBePiCnMiCmFiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar					:_xZkqqHx_iPgPjHmNjAoGiCmMiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szp32Image			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			p32Image;			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstraDocProperty	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
 *								 _xZkqqHx_iCmGiClFiCmEiPgPjHmNiClDiCoKiCoJiBeC_xHqqkZx_
 *								 iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiPgPjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocPropertySize	:m_wstraDocumentProperty_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	PNG_xZkqqHx_iPgPjHmNiNfMjBkCjBmMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPngWriteStruct* FFPngWrite32Begin (	FCUndoArchive& ar,
										const CSize* szp32Image,
										const BYTE* p32Image,
										const WString* wstraDocProperty,
										long lDocPropertySize)
{
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// png_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiBeC_xHqqkZx_
//	FCPngWriteStruct* ps = FFPngWriteInitialize(ar);
//	// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//	ps->m_szImage32 = szp32Image;
//	ps->m_pImage32 = p32Image;
//	// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCjCgMiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//	ps->m_wstraDocumentProperty = wstraDocProperty;
//	ps->m_lDocumentPropertySize = lDocPropertySize;
//	// PNG_xZkqqHx_iDhHiDgCiDfPiBeBiDeDiDiBiBfLiDfHiBeBiDgFiDeMiDfIiDgHiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	FFPngWriteUntilMdrwChunk(ps);
//	return ps;
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return FFPngWrite32Begin(	&ar,
								myFuncPngWrite,
								myFuncPngFlush,
								myFuncPngError,
								myFuncPngWarning,
								szp32Image,
								p32Image,
								wstraDocProperty,
								lDocPropertySize);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFPngWrite32Begin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngWrite32Begin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ar_xZkqqHx_iCmJ_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCmMjAoGjDkKiCkJiCoH_xHqqkZx_mdRw_xZkqqHx_iDgAiDiDiDjDiDeOiCmMjClMjBePiCnMiCmFiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pIo					:_xZkqqHx_iPgPjHmNjHhAiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngWrite		:_xZkqqHx_iPjBiCkLiNjOiCnNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngFlush		:_xZkqqHx_iDgPiDgCiDhEiDeAiDhEiDiJiDgCiDfGiDiFjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngError		:_xZkqqHx_iDeHiDiJiBfLiPiIjHjNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngWarning		:_xZkqqHx_iMhIiNjAiPiIjHjNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szp32Image			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			p32Image;			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wstraDocProperty	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
 *								 _xZkqqHx_iCmGiClFiCmEiPgPjHmNiClDiCoKiCoJiBeC_xHqqkZx_
 *								 iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiPgPjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocPropertySize	:m_wstraDocumentProperty_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	PNG_xZkqqHx_iPgPjHmNiNfMjBkCjBmMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPngWriteStruct* FFPngWrite32Begin (	void* pIo,
										FuncPngWrite funcPngWrite,
										FuncPngFlush funcPngFlush,
										FuncPngError funcPngError,
										FuncPngWarning funcPngWarning,
										const CSize* szp32Image,
										const BYTE* p32Image,
										const WString* wstraDocProperty,
										long lDocPropertySize)
{
	// png_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiBeC_xHqqkZx_
	FCPngWriteStruct* ps = FFPngWriteInitialize(pIo,
												funcPngWrite,
												funcPngFlush,
												funcPngError,
												funcPngWarning);
	// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	ps->m_szImage32 = szp32Image;
	ps->m_pImage32 = p32Image;
	// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCjCgMiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	ps->m_wstraDocumentProperty = wstraDocProperty;
	ps->m_lDocumentPropertySize = lDocPropertySize;
	// PNG_xZkqqHx_iDhHiDgCiDfPiBeBiDeDiDiBiBfLiDfHiBeBiDgFiDeMiDfIiDgHiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	FFPngWriteUntilMdrwChunk(ps);
	return ps;
} // FFPngWrite32Begin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngWrite32MdrwChunk
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ar_xZkqqHx_iCmJ_xHqqkZx_mdRw_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ps					:PNG_xZkqqHx_iPgPjHmNiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pMdrwChunkData		:MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMdrwChunkDataSize	:pMdrwChunkData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngWrite32MdrwChunk (FCPngWriteStruct* ps,
							const BYTE* pMdrwChunkData,
							DWORD dwMdrwChunkDataSize)
{
	// MDRW_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	png_structp png_ptr = (png_structp)ps->m_png_ptr;
	png_write_chunk(png_ptr, (BYTE*)FD_MDRW_CHUNK_NAME,
					(BYTE*)pMdrwChunkData, dwMdrwChunkDataSize);
} // FFPngWrite32MdrwChunk.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngWrite32End
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ar_xZkqqHx_iCmJ_xHqqkZx_PNG_xZkqqHx_iCmMiPeJjCfLiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ps	:PNG_xZkqqHx_iPgPjHmNiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngWrite32End (FCPngWriteStruct* ps)
{
	// PNG_xZkqqHx_iPeJjCfLiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	FFPngWriteUntilEnd(ps);
	// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
	FFPngTerminate(ps);
} // FFPngWrite32End.

//----- 06.05.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngWrite32BitData
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ar_xZkqqHx_iCmJ_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar					:_xZkqqHx_iPgPjHmNjAoGiCmMiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
// *			szp32Image			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			p32Image;			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			wstraDocProperty	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
// *								 _xZkqqHx_iCmGiClFiCmEiPgPjHmNiClDiCoKiCoJiBeC_xHqqkZx_
// *								 iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiPgPjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocPropertySize	:m_wstraDocumentProperty_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pMdrwChunkData		:MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCpA_xHqqkZx_
// *								 _xZkqqHx_iPgPjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			dwMdrwChunkDataSize	:pMdrwChunkData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFPngWrite32BitData (	FCUndoArchive& ar,
//							const CSize* szp32Image,
//							const BYTE* p32Image,
//							const WString* wstraDocProperty,
//							long lDocPropertySize,
//							const BYTE* pMdrwChunkData,
//							DWORD dwMdrwChunkDataSize)
//{
////----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// png_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiBeC_xHqqkZx_
////	FCPngWriteStruct* ps = FFPngWriteInitialize(ar);
////	// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
////	ps->m_szImage32 = szp32Image;
////	ps->m_pImage32 = p32Image;
////	// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCjCgMiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
////	ps->m_wstraDocumentProperty = wstraDocProperty;
////	ps->m_lDocumentPropertySize = lDocPropertySize;
////	// PNG_xZkqqHx_iDhHiDgCiDfPiBeBiDeDiDiBiBfLiDfHiBeBiDgFiDeMiDfIiDgHiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
////	FFPngWriteUntilMdrwChunk(ps);
////	if (pMdrwChunkData != NULL)
////	//----- MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
////	{
////		// MDRW_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
////		png_structp png_ptr = (png_structp)ps->m_png_ptr;
////		png_write_chunk(png_ptr, (BYTE*)FD_MDRW_CHUNK_NAME,
////						(BYTE*)pMdrwChunkData, dwMdrwChunkDataSize);
////	}
////	// PNG_xZkqqHx_iPeJjCfLiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
////	FFPngWriteUntilEnd(ps);
////	// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
////	FFPngTerminate(ps);
////----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	FFPngWrite32BitData(&ar,
//						myFuncPngWrite,
//						myFuncPngFlush,
//						myFuncPngError,
//						myFuncPngWarning,
//						szp32Image,
//						p32Image,
//						wstraDocProperty,
//						lDocPropertySize,
//						pMdrwChunkData,
//						dwMdrwChunkDataSize);
////----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FFPngWrite32BitData.
////----- 06.03.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngWrite32BitData
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ar_xZkqqHx_iCmJ_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pIo					:_xZkqqHx_iPgPjHmNjHhAiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			funcPngWrite		:_xZkqqHx_iPjBiCkLiNjOiCnNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			funcPngFlush		:_xZkqqHx_iDgPiDgCiDhEiDeAiDhEiDiJiDgCiDfGiDiFjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			funcPngError		:_xZkqqHx_iDeHiDiJiBfLiPiIjHjNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			funcPngWarning		:_xZkqqHx_iMhIiNjAiPiIjHjNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			szp32Image			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			p32Image;			:PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
// *								 NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			wstraDocProperty	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
// *								 _xZkqqHx_iCmGiClFiCmEiPgPjHmNiClDiCoKiCoJiBeC_xHqqkZx_
// *								 iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiPgPjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocPropertySize	:m_wstraDocumentProperty_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pMdrwChunkData		:MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCpA_xHqqkZx_
// *								 _xZkqqHx_iPgPjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			dwMdrwChunkDataSize	:pMdrwChunkData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFPngWrite32BitData (	void* pIo,
//							FuncPngWrite funcPngWrite,
//							FuncPngFlush funcPngFlush,
//							FuncPngError funcPngError,
//							FuncPngWarning funcPngWarning,
//							const CSize* szp32Image,
//							const BYTE* p32Image,
//							const WString* wstraDocProperty,
//							long lDocPropertySize,
//							const BYTE* pMdrwChunkData,
//							DWORD dwMdrwChunkDataSize)
//{
//	// png_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiBeC_xHqqkZx_
//	FCPngWriteStruct* ps = FFPngWriteInitialize(pIo,
//												funcPngWrite,
//												funcPngFlush,
//												funcPngError,
//												funcPngWarning);
//	// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//	ps->m_szImage32 = szp32Image;
//	ps->m_pImage32 = p32Image;
//	// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCjCgMiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
//	ps->m_wstraDocumentProperty = wstraDocProperty;
//	ps->m_lDocumentPropertySize = lDocPropertySize;
//	// PNG_xZkqqHx_iDhHiDgCiDfPiBeBiDeDiDiBiBfLiDfHiBeBiDgFiDeMiDfIiDgHiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	FFPngWriteUntilMdrwChunk(ps);
//	if (pMdrwChunkData != NULL)
//	//----- MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// MDRW_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//		png_structp png_ptr = (png_structp)ps->m_png_ptr;
//		png_write_chunk(png_ptr, (BYTE*)FD_MDRW_CHUNK_NAME,
//						(BYTE*)pMdrwChunkData, dwMdrwChunkDataSize);
//	}
//	// PNG_xZkqqHx_iPeJjCfLiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	FFPngWriteUntilEnd(ps);
//	// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiBeC_xHqqkZx_
//	FFPngTerminate(ps);
//} // FFPngWrite32BitData.
//----- 06.05.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngReadInitialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmMiCpAiNoMjAkMiBeFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pIo				:_xZkqqHx_jDpMjHmNjHhAiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngRead		:_xZkqqHx_jDmHiCnNiPgPiClFjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngError	:_xZkqqHx_iDeHiDiJiBfLiPiIjHjNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngWarning	:_xZkqqHx_iMhIiNjAiPiIjHjNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	PNG_xZkqqHx_jDpMjHmNiCmJiOgHiCkEiNfMjBkCjBmMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//FCPngReadStruct* FFPngReadInitialize (FCUndoArchive& ar)
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
FCPngReadStruct* FFPngReadInitialize (	void* pIo,
										FuncPngRead funcPngRead,
										FuncPngError funcPngError,
										FuncPngWarning funcPngWarning)
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
{
	// png_ptr_xZkqqHx_iNfMjBkCjBmMiBeC_xHqqkZx_
	png_structp png_ptr;
	// info_ptr_xZkqqHx_iNfMjBkCjBmMiBeC_xHqqkZx_
	png_infop info_ptr;

	// png_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiClFiCnMiClHiBeC_xHqqkZx_
	png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	// info_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiClFiCnMiClHiBeC_xHqqkZx_
	info_ptr = png_create_info_struct(png_ptr);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeHiDiJiBfLiPiIjHjNiKnGjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
//	png_set_error_fn(png_ptr, NULL, myFuncPngError, myFuncPngWarning);
//	// _xZkqqHx_jDmHiCnNiNjOiCnNiCmMiKnGjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
//	png_set_read_fn(png_ptr, &ar, myFuncPngRead);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDeHiDiJiBfLiPiIjHjNiKnGjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
	png_set_error_fn(png_ptr, NULL, funcPngError, funcPngWarning);
	// _xZkqqHx_jDmHiCnNiNjOiCnNiCmMiKnGjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
	png_set_read_fn(png_ptr, pIo, funcPngRead);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	FCPngReadStruct* ps = new FCPngReadStruct;
	ps->m_szImage32 = NULL;
	ps->m_vImage32 = NULL;
	ps->m_wstraDocumentProperty = NULL;
	ps->m_lDocumentPropertySize = 0;
	ps->m_png_ptr = png_ptr;
	ps->m_info_ptr = info_ptr;
	return ps;
} // FFPngReadInitialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngWriteInitialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_iPgPjHmNiNfMjBkCjBmMiCpAiNoMjAkMiBeFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pIo				:_xZkqqHx_iPgPjHmNjHhAiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngWrite	:_xZkqqHx_iPjBiCkLiNjOiCnNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngFlush	:_xZkqqHx_iDgPiDgCiDhEiDeAiDhEiDiJiDgCiDfGiDiFjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngError	:_xZkqqHx_iDeHiDiJiBfLiPiIjHjNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			funcPngWarning	:_xZkqqHx_iMhIiNjAiPiIjHjNjHhAiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	PNG_xZkqqHx_iPgPjHmNiNfMjBkCjBmMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	PNG_xZkqqHx_iPgPjHmNiCmJiOgHiCkEiNfMjBkCjBmMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//FCPngWriteStruct* FFPngWriteInitialize (FCUndoArchive& ar)
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
FCPngWriteStruct* FFPngWriteInitialize (void* pIo,
										FuncPngWrite funcPngWrite,
										FuncPngFlush funcPngFlush,
										FuncPngError funcPngError,
										FuncPngWarning funcPngWarning)
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
{
	// png_ptr_xZkqqHx_iNfMjBkCjBmMiBeC_xHqqkZx_
	png_structp png_ptr;
	// info_ptr_xZkqqHx_iNfMjBkCjBmMiBeC_xHqqkZx_
	png_infop info_ptr;

	// png_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiClFiCnMiClHiBeC_xHqqkZx_
	png_ptr = png_create_write_struct(
					PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	// info_ptr_xZkqqHx_iNfMjBkCjBmMiCpAiKgNjFnLiBeFiPiJiKpKiJlLiClFiCnMiClHiBeC_xHqqkZx_
	info_ptr = png_create_info_struct(png_ptr);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeHiDiJiBfLiPiIjHjNiKnGjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
//	png_set_error_fn(png_ptr, NULL, myFuncPngError, myFuncPngWarning);
//	// _xZkqqHx_iPjBiCkLiPgPiClFiCmMiKnGjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
//	png_set_write_fn(png_ptr, &ar, myFuncPngWrite, myFuncPngFlush);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDeHiDiJiBfLiPiIjHjNiKnGjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
	png_set_error_fn(png_ptr, NULL, funcPngError, funcPngWarning);
	// _xZkqqHx_iPjBiCkLiPgPiClFiCmMiKnGjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
	png_set_write_fn(png_ptr, pIo, funcPngWrite, funcPngFlush);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	FCPngWriteStruct* ps = new FCPngWriteStruct;
	ps->m_szImage32 = NULL;
	ps->m_pImage32 = NULL;
	ps->m_wstraDocumentProperty = NULL;
	ps->m_lDocumentPropertySize = 0;
	ps->m_png_ptr = png_ptr;
	ps->m_info_ptr = info_ptr;
	return ps;
} // FFPngWriteInitialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngTerminate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmMiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ps	:PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FFPngReadInitialize_xZkqqHx_iKnGjAjEiCmFiOoGjDlOiClFiClN_xHqqkZx_PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmMiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngTerminate (FCPngReadStruct* ps)
{
	png_structp png_ptr = (png_structp)ps->m_png_ptr;
	png_infop info_ptr = (png_infop)ps->m_info_ptr;
	// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiClFiCnMiClHiBeC_xHqqkZx_
	png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
	delete ps;
} // FFPngTerminate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngTerminate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_iPgPjHmNiNfMjBkCjBmMiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ps	:PNG_xZkqqHx_iPgPjHmNiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FFPngWriteInitialize_xZkqqHx_iKnGjAjEiCmFiOoGjDlOiClFiClN_xHqqkZx_PNG_xZkqqHx_iPgPjHmNiNfMjBkCjBmMiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngTerminate (FCPngWriteStruct* ps)
{
	png_structp png_ptr = (png_structp)ps->m_png_ptr;
	png_infop info_ptr = (png_infop)ps->m_info_ptr;
	// _xZkqqHx_iCfBiCmCiCmMiNfMjBkCjBmMiCmMiDiBiDiCiDiKiCpAiJpAjFpKiClFiCnMiClHiBeC_xHqqkZx_
	png_destroy_write_struct(&png_ptr, &info_ptr);
	delete ps;
} // FFPngTerminate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngReadUntilMdrwChunk
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCmMiBeB_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmFiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ps	:PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiBgJ_xHqqkZx_PNG_xZkqqHx_iDfGiDePiDgMiDgAiDiDiCkKiIoKjChGiClFiCmIiCkCjDjJiBgKiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_jHoBiKeP_xHqqkZx_ CFCDDFileException(IDS_ERR_FILE_WRONG_FORM, L"")_xZkqqHx_iCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	PNG_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCmMiDfGiDePiDgMiDgAiDiDiBeBiDeDiDiBiBfLiDfHiBeBiDgFiDeMiDfIiDgHiCmGiBeB_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
 *			_xZkqqHx_iCmMjClMjBePiCnMiCmFiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *			[mdRw_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_]
 *			  _xZkqqHx_iEjPiEkGiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjP_xHqqkZx_
 *				_xZkqqHx_iEkA_xHqqkZx_ 4 Byte _xZkqqHx_iEkA_xHqqkZx_    4 Byte    _xZkqqHx_iEkA_xHqqkZx_ n Byte _xZkqqHx_iEkA_xHqqkZx_4 Byte_xZkqqHx_iEkA_xHqqkZx_
 *			  _xZkqqHx_iEjPiEkJiEjPiEjPiEjPiEjPiEkJiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkJiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkJiEjP_xHqqkZx_
 *				_xZkqqHx_iEkAiDgGiBfLiDfOjClHiEkA_xHqqkZx_m _xZkqqHx_iEkA_xHqqkZx_ d_xZkqqHx_iEkA_xHqqkZx_ R_xZkqqHx_iEkA_xHqqkZx_w _xZkqqHx_iEkA_xHqqkZx_DD_xZkqqHx_iDgGiBfLiDfOiEkA_xHqqkZx_  CRC _xZkqqHx_iEkA_xHqqkZx_
 *			    _xZkqqHx_iEkA_xHqqkZx_
 *			_xZkqqHx_iEjPiBkIiEkAiClBiClBiCnMiCmFjDmHiCnNiNjOiCnO_xHqqkZx_ 
 *
 *			_xZkqqHx_jCeBiClFiBeB_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_PNG_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCmM_xHqqkZx_
 *			_xZkqqHx_iNmFiMoDiCnMiCmFiBgJ_xHqqkZx_IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCmMiPeJiCoNiCoIiCnMiCmFiBgKjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmF_xHqqkZx_PNG_xZkqqHx_iCmMiNmFiPiJiCkJiCoH_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmFjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiMoDiBeB_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCpAjDmHiCnNiNjOiCnNiBeBiNmFiMoDiCmJ_xHqqkZx_FFPngReadUntilEnd_xZkqqHx_iKnGjAjEiCmF_xHqqkZx_
 *			IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmFjDmHiCnNiNjOiCpBiCmF_xHqqkZx_PNG_xZkqqHx_iDhEiDeAiDeDiDiLjDmHiCnNiNjOiCnNiCmNiPeJjHlJiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iIpIjAjEiCmM_xHqqkZx_FCPngReadStruct_xZkqqHx_iNfMjBkCjBmMiDiBiDjDiDgPiCmJiCmNiBeBiImIiJlKiCmMiPoOjFpBiCpAjAnNjCoIiClFiCmEiCkIiCkN_xHqqkZx_
 *			_xZkqqHx_jFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			m_szImage32				PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *									_xZkqqHx_iDeDiDiBiBfLiDfHiCpAiDfIiDeMiDgCiDhGiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			m_vImage32;				PNG_xZkqqHx_iDeDiDiBiBfLiDfHjDmHiCnNiNjOiCnNiDgPiDgCiDhEiDeAiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *									_xZkqqHx_iDeDiDiBiBfLiDfHiCpAiDfIiDeMiDgCiDhGiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			m_wstraDocumentProperty	_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCjDmHiCnNiNjOiCnNiDgPiDgCiDhEiDeAjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *									iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCkJiCoHjDpMjHmNiClDiCoKiCoJiBeC_xHqqkZx_
 *									iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiDfIiDeMiDgCiDhGiClHiCoJiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			m_lDocumentPropertySize	m_wstraDocumentProperty_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			m_png_ptr;				_xZkqqHx_iDfGiDfIiDgFiDiAiCkKiOgHiCkE_xHqqkZx_PNG_xZkqqHx_iCmMiDgGiBfLiDfOiBeCiDiGiBfLiDfFiCmNiOhHjCoIiClFiCmIiCkCiBeC_xHqqkZx_
 *			m_info_ptr;				_xZkqqHx_iDfGiDfIiDgFiDiAiCkKiOgHiCkE_xHqqkZx_PNG_xZkqqHx_iCmMiDgGiBfLiDfOiBeCiDiGiBfLiDfFiCmNiOhHjCoIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFPngReadUntilMdrwChunk (FCPngReadStruct* ps)
{
	// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDmHiCnNiNjOiCnOiCkJiBeI_xHqqkZx_
	BOOL bReadImage = (ps->m_szImage32 != NULL && ps->m_vImage32 != NULL);
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAjDmHiCnNiNjOiCnOiCkJiBeI_xHqqkZx_
	BOOL bReadText = (ps->m_wstraDocumentProperty != NULL);

	png_structp png_ptr = (png_structp)ps->m_png_ptr;
	png_infop info_ptr = (png_infop)ps->m_info_ptr;

	try
	{
		// PNG_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDfGiDePiDgMiDgAiDiDiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		// png_read_info _xZkqqHx_iCmNiBeBiDfGiDePiDgMiDgAiDiDiDgAiDeGiDgCiDeOiCpAjFkKjHkDiClFiClNiNoMiCoIiCmJjFmPiNfIiBeC_xHqqkZx_
		// _xZkqqHx_iCfBiJpBiOmAiNhDiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
		png_read_info(png_ptr, info_ptr);
	} catch (CFCMiscException* e)
	{
		if (e->GetMessageId() == IDS_ERR_MSG_PNG)
		//----- PNG_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiH_xHqqkZx_ ----
		{
			e->Delete();
			// IDS_ERR_MSG_NOT_PNG_DATA "PNG_xZkqqHx_iMgAiOkOiCmMiDgGiBfLiDfOiCmFiCmNiCkAiCoIiCnMiClJiCpBiBeC_xHqqkZx_"
			e = new CFCMiscException(IDS_ERR_MSG_NOT_PNG_DATA);
		}
		throw e;
	}
	// PNG_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDgFiDeMiDfIiDgHiPoOjFpBiBeB_xHqqkZx_
	// IDAT_xZkqqHx_iDgAiDiDiDjDiDeOiCmMjGlMjBePiCpAjDmHiCnNiNjOiCnNiCnMiClHiBeC_xHqqkZx_
	png_read_info(png_ptr, info_ptr);

//----- 06.03.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (bReadImage)
//	//----- _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDmHiCnNiNjOiCnOiPoKiNiH_xHqqkZx_ -----
//	{
//		//----- IHDR_xZkqqHx_iDgAiDiDiDjDiDeOiPoOjFpBiCpAiOoGjDlOiClFiCnMiClH_xHqqkZx_ -----
//		unsigned long dwImageW;
//		unsigned long dwImageH;
//		int iBitDepth;
//		int iColorType;
//		int iInterlaceType;
//		png_get_IHDR(png_ptr, info_ptr, &dwImageW, &dwImageH,
//					&iBitDepth, &iColorType, &iInterlaceType,
//					NULL, NULL);
//
//		ps->m_szImage32->cx = dwImageW;
//		ps->m_szImage32->cy = dwImageH;
//		ps->m_vImage32->resize(ps->m_szImage32->cx * ps->m_szImage32->cy * 4);
//		//----- _xZkqqHx_iJoGjBjMiDgGiBfLiDfOiCpAiBeB_xHqqkZx_PNG_xZkqqHx_jHhAiCmMjEhKjHpBiMgAiOkOiCmJjFmPiNfI_xHqqkZx_ -----
//		vector<BYTE*> vpImageLine(ps->m_szImage32->cy);
//		for (long lLine = 0; lLine < ps->m_szImage32->cy; lLine++)
//			vpImageLine[lLine] = &(ps->m_vImage32->at(lLine * ps->m_szImage32->cx * 4));
//		// _xZkqqHx_iJoGjBjMiDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//		// png_read_image _xZkqqHx_iCmNiBeBiNmFiMoDiCmM_xHqqkZx_CRC_xZkqqHx_iCpAjDmHiCnNiNjOiCnMiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
//		png_read_image(png_ptr, vpImageLine.begin());
//	} else
//	//----- _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDmHiCnNiNjOiCnMiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// png_read_info _xZkqqHx_iCmFiCmNiBeBiKpJiCmJiDfGiDePiDgMiDgAiDiDiCmMiMoDiBeB_xHqqkZx_IDAT_xZkqqHx_iDgAiDiDiDjDiDeOiCmMiDgAiDiDiDjDiDeOjGlMiBgJ_xHqqkZx_IDAT_xZkqqHx_iBgK_xHqqkZx_
//		// _xZkqqHx_iCnMiCmFiCkKjDmHiCnNiNjOiCnMiCoKiClNiPpDjBnEiCmFiCkAiCoJiBeCiPoOjFpBiCmNiBeB_xHqqkZx_png_ptr _xZkqqHx_iCmJiKgJjEfLiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
//		// IDAT_xZkqqHx_iCmMiDgGiBfLiDfOiDfEiDeDiDfJjFkKiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iDgGiBfLiDfOiCmNiDfIiDeMiDgCiDhGiClFiClNiCmGiClBiCoLiClOiCkKiBeB_xHqqkZx_png_read_end_xZkqqHx_iCkK_xHqqkZx_CRC_xZkqqHx_iCpAiDgAiDeGiDgCiDeOiClHiCoJiClNiCnPiBeB_xHqqkZx_
//		// png_crc_read _xZkqqHx_iCmFiDgGiBfLiDfOiCpAjDmHiCnNiNjOiCpBiCmF_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//		// CRC_xZkqqHx_iCmNjDmHiCnNiNjOiCnMiCmIiCkCiBeC_xHqqkZx_
//		BYTEVector vTmpBuff(png_ptr->idat_size);
//		png_crc_read(png_ptr, vTmpBuff.begin(), vTmpBuff.size());
//	}
//----- 06.03.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	//----- IHDR_xZkqqHx_iDgAiDiDiDjDiDeOiPoOjFpBiCpAiOoGjDlOiClFiCnMiClH_xHqqkZx_ -----
	unsigned long dwImageW;
	unsigned long dwImageH;
	int iBitDepth;
	int iColorType;
	int iInterlaceType;
	png_get_IHDR(png_ptr, info_ptr, &dwImageW, &dwImageH,
				&iBitDepth, &iColorType, &iInterlaceType,
				NULL, NULL);
	if (bReadImage)
	//----- _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDmHiCnNiNjOiCnOiPoKiNiH_xHqqkZx_ -----
	{
		ps->m_szImage32->cx = dwImageW;
		ps->m_szImage32->cy = dwImageH;
		ps->m_vImage32->resize(dwImageW * dwImageH * 4);
		//----- _xZkqqHx_iJoGjBjMiDgGiBfLiDfOiCpAiBeB_xHqqkZx_PNG_xZkqqHx_jHhAiCmMjEhKjHpBiMgAiOkOiCmJjFmPiNfI_xHqqkZx_ -----
		vector<BYTE*> vpImageLine(dwImageH);
		for (long lLine = 0; lLine != dwImageH; lLine++)
			vpImageLine[lLine] = &(ps->m_vImage32->at(lLine * ps->m_szImage32->cx * 4));
		// _xZkqqHx_iJoGjBjMiDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		// png_read_image _xZkqqHx_iCmNiBeBiNmFiMoDiCmM_xHqqkZx_CRC_xZkqqHx_iCpAjDmHiCnNiNjOiCnMiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
		png_read_image(png_ptr, vpImageLine.begin());
	} else
	//----- _xZkqqHx_iDeDiDiBiBfLiDfHiCpAjDmHiCnNiNjOiCnMiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// png_crc_read _xZkqqHx_iCmF_xHqqkZx_ IDAT_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiDfIiDeMiDgCiDhGiClFiCmEiCkCiClNiCkKiBeB_xHqqkZx_
		// _xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCkKjBoFiCkLiCkNiCmIiCoJiCmGiBeB_xHqqkZx_IDAT_xZkqqHx_iDgAiDiDiDjDiDeOiCmN_xHqqkZx_
		// _xZkqqHx_iCfBiCmCiImIiPoDiCmJiCmIiCmBiCmEiDeHiDiJiBfLiCpAiPgPiClFiCmEiCkCiClNiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiClNiCnPiBeB_xHqqkZx_png_read_image_xZkqqHx_iCpAiOmAiNhDiClHiCoJiCoGiCkEiCmJjFmPiNfIiBeC_xHqqkZx_

		// _xZkqqHx_iCfAiNhDjFkKiCmMiDgPiDgCiDhEiDeAiCpAjHhAiInDiBeC_xHqqkZx_
		BYTEVector vWorkBuff(dwImageW * 4);
		// PNG_xZkqqHx_jHhAiCmMjEhKjHpBiMgAiOkOiCpAjHhAiInDiBeCiCfAiNhDjFkKiCmMiDgPiDgCiDhEiDeAiCpA_xHqqkZx_
		// _xZkqqHx_jBfDiNhDiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
		vector<BYTE*> vpImageLine(dwImageH);
		for (long lLine = 0; lLine != dwImageH; lLine++)
			vpImageLine[lLine] = &vWorkBuff[0];
		// _xZkqqHx_iJoGjBjMiDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		// png_read_image _xZkqqHx_iCmNiBeBiNmFiMoDiCmM_xHqqkZx_CRC_xZkqqHx_iCpAjDmHiCnNiNjOiCnMiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
		png_read_image(png_ptr, vpImageLine.begin());
	}
//----- 06.03.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	if (bReadText)
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCpAjDmHiCnNiNjOiCnOiPoKiNiH_xHqqkZx_ -----
	{
		// png_read_end_xZkqqHx_iCmNiBeBiClLiCoKiCnMiCmFiCmJjDmHiCnNiPgPiClFiClN_xHqqkZx_IDAT_xZkqqHx_iCmM_xHqqkZx_CRC_xZkqqHx_iCpAiDgAiDeGiDgCiDeOiClFiBeB_xHqqkZx_
		// MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmFiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		// IDAT_xZkqqHx_iDgAiDiDiDjDiDeOiCmNjBfDiCmEjDmHiCnNiPgPiClDiCoKiCmEiCkCiCoJiCmNiClIiCmIiCmMiCmFiBeB_xHqqkZx_png_read_end_xZkqqHx_iCmFiCmN_xHqqkZx_
		// IDAT_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjDmHiCnNiPgPiClDiCoKiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_jCeBiClFiBeBiDfEiDeDiDfJiCePiCmM_xHqqkZx_IDAT_xZkqqHx_iCmIiCoHjHmHiCkCiBeC_xHqqkZx_
		const DWORD dwChunkDataSize = png_read_end(png_ptr, info_ptr);
		png_textp text_ptr;
		int num_text;
		png_get_text(png_ptr, info_ptr, &text_ptr, &num_text);
		for (long lC = 0; lC < num_text; lC++)
		{
			if (text_ptr[lC].compression != PNG_ITXT_COMPRESSION_zTXt &&
				text_ptr[lC].compression != PNG_ITXT_COMPRESSION_NONE)
				continue;
			FTDocumentPropertyId dpid = FFAKeyToDocumentPropertyId(text_ptr[lC].key);
			if (dpid != FD_DPID_NONE &&
				dpid < ps->m_lDocumentPropertySize)
			//----- _xZkqqHx_jGlDiMpI_xHqqkZx_ID_xZkqqHx_iCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				ps->m_wstraDocumentProperty[dpid] = FFItxtToWStr(text_ptr[lC].text);
			}
		}
		// MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCkKjBlGiNnNiClJiClI_xHqqkZx_IEND_xZkqqHx_jDmHiCnNiNjOiCnNiCmFiPeJjHlJiCmMiPoKiNiHiBeC_xHqqkZx_
		if (dwChunkDataSize == DWORD(-1)) return FALSE;

		//----- _xZkqqHx_iDgAiDiDiDjDiDeOjGlMiCmGiDgAiDiDiDjDiDeOjClHiCpA_xHqqkZx_Undo -----
		FCUndoArchive& fcar = *(FCUndoArchive*)png_get_io_ptr(png_ptr);
		fcar.Undo(FD_MDRW_CHUNK_NAME, 4);
		// _xZkqqHx_iDgAiDiDiDjDiDeOjClHiBeC_xHqqkZx_
		png_byte byaTmpChunkLen[4];
		FFPngGetUintByte32(byaTmpChunkLen, dwChunkDataSize);
		fcar.Undo(byaTmpChunkLen, 4);
		// CRC_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
		png_reset_crc(png_ptr);
		return TRUE;
	} else
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCpAjDmHiCnNiNjOiCnMiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// IDAT_xZkqqHx_iCmM_xHqqkZx_CRC_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		png_crc_finish(png_ptr, 0);
//----- 03.07.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmFiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		return FFPngSkipUntilSpecChunk(ps, FD_MDRW_CHUNK_NAME);
//----- 03.07.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 03.07.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		for (;;)
//		{
//			// _xZkqqHx_iDgAiDiDiDjDiDeOjClHiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//			png_byte byaTmpChunkLen[4];
//// 03.07.01 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////			(*(png_ptr->read_data_fn))(png_ptr, byaTmpChunkLen, 4);
//			png_read_data(png_ptr, byaTmpChunkLen, 4);
//			DWORD dwChunkDataSize = FFPngGetUint32(byaTmpChunkLen);
//
//			// _xZkqqHx_iDgAiDiDiDjDiDeOjGlMiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//			BYTE byaTmpChunkName[4];
//// 03.07.01 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////			(*(png_ptr->read_data_fn))(png_ptr, byaTmpChunkName, 4);
//			png_read_data(png_ptr, byaTmpChunkName, 4);
//
//			if (memcmp(byaTmpChunkName, FD_MDRW_CHUNK_NAME, 4) == 0)
//			//----- MDRW_xZkqqHx_iMgAiOkOiDgAiDiDiDjDiDeOiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				//----- _xZkqqHx_iDgAiDiDiDjDiDeOjGlMiCmGiDgAiDiDiDjDiDeOjClHiCpA_xHqqkZx_Undo -----
//				FCUndoArchive& fcar = *(FCUndoArchive*)png_get_io_ptr(png_ptr);
//				fcar.Undo(byaTmpChunkName, 4);
//				fcar.Undo(byaTmpChunkLen, 4);
//				return TRUE;
//			}
//			// _xZkqqHx_iDgGiBfLiDfOiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
//// 03.07.01 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////			(*(png_ptr->read_data_fn))(png_ptr, NULL, dwChunkDataSize);
//			png_read_data(png_ptr, NULL, dwChunkDataSize);
//			// CRC_xZkqqHx_jFkKiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
//// 03.07.01 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////			(*(png_ptr->read_data_fn))(png_ptr, NULL, 4);
//			png_read_data(png_ptr, NULL, 4);
//
//			if (memcmp(byaTmpChunkName, PNG_IEND, 4) == 0)
//			//----- IEND_xZkqqHx_iMgAiOkOiDgAiDiDiDjDiDeOiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				break;
//			}
//		}
//		return FALSE;
//----- 03.07.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	}
} // FFPngReadUntilMdrwChunk.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngReadChunk
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDiDiDjDiDeOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ps			:PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vDataBuff	:_xZkqqHx_iDgAiDiDiDjDiDeOiCmMiDgGiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCmMiDhMiDeDiDjDiDfOiCmNiDgAiDiDiDjDiDeOjAoGjDkKiCmJiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iDgAiDiDiDjDiDeOiDfEiDeDiDfJiBeBiDgAiDiDiDjDiDeOjGlMiCpAjDmHiCnNiNjOiCnNiBeBiDgGiBfLiDfOiCpA_xHqqkZx_vDataBuff_xZkqqHx_iCnG_xHqqkZx_
 *			_xZkqqHx_iDfCiDhDiBfLiBeB_xHqqkZx_CRC_xZkqqHx_iCpAjDmHiCnNiNjOiCpBiCmFiPeJjHlJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngReadChunk (FCPngReadStruct* ps, BYTEVector& vDataBuff)
{
	png_structp png_ptr = (png_structp)ps->m_png_ptr;
	// _xZkqqHx_iDgAiDiDiDjDiDeOjClHiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	png_byte byaTmpChunkLen[4];
	png_read_data(png_ptr, byaTmpChunkLen, 4);
	const DWORD dwChunkDataSize = FFPngGetUint32(byaTmpChunkLen);
	// CRC_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	png_reset_crc(png_ptr);
	// _xZkqqHx_iDgAiDiDiDjDiDeOjGlMiCpAjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
	png_crc_read(png_ptr, png_ptr->chunk_name, 4);
	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAiKgNjFnLiBeC_xHqqkZx_
	vDataBuff.resize(dwChunkDataSize);
	// _xZkqqHx_iDgAiDiDiDjDiDeOiDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
	png_crc_read(png_ptr, vDataBuff.begin(), vDataBuff.size());
	// CRC_xZkqqHx_jDmHiCnNiNjOiCnNiBeBiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	png_crc_finish(png_ptr, 0);
} // FFPngReadChunk.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngSkipChunk
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ps	:PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCmMiDhMiDeDiDjDiDfOiCmNiDgAiDiDiDjDiDeOjAoGjDkKiCmJiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngSkipChunk (FCPngReadStruct* ps)
{
	png_structp png_ptr = (png_structp)ps->m_png_ptr;
	// _xZkqqHx_iDgAiDiDiDjDiDeOjClHiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	png_byte byaTmpChunkLen[4];
	png_read_data(png_ptr, byaTmpChunkLen, 4);
	const DWORD dwChunkDataSize = FFPngGetUint32(byaTmpChunkLen);
	// _xZkqqHx_iDgAiDiDiDjDiDeOjGlM_xHqqkZx_(4)+_xZkqqHx_iDgAiDiDiDjDiDeOiDgGiBfLiDfO_xHqqkZx_(dwChunkDataSize)+CRC(4)_xZkqqHx_iCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
	png_read_data(png_ptr, NULL, 8 + dwChunkDataSize);
} // FFPngSkipChunk.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngSkipUntilSpecChunk
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgAiDiDiDjDiDeOiCmMjClMjBePiCnMiCmFiDgGiBfLiDfOiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ps			:PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bypChunkName:_xZkqqHx_iDgAiDiDiDjDiDeOjGlMiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgAiDiDiDjDiDeOiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjBlGiNnNiClJiClIiBeB_xHqqkZx_PNG_xZkqqHx_iPeJjCfL_xHqqkZx_
 *			_xZkqqHx_iCnMiCmFiDfIiDeMiDgCiDhGiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_jHoBiKeP_xHqqkZx_ CFCDDFileException(IDS_ERR_FILE_WRONG_FORM, L"")_xZkqqHx_iCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgAiDiDiDjDiDeOiCmMjClMjBePiCnMiCmFiDgGiBfLiDfOiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeCiDgAiDiDiDjDiDeOiCkK_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeBiOhHjCoIiClDiCoKiClNiDgAiDiDiDjDiDeOiCkKiDhEiDeAiDeDiDiLjCiGiCmJ_xHqqkZx_
 *			_xZkqqHx_jBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_PNG_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCmM_xHqqkZx_IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmF_xHqqkZx_
 *			_xZkqqHx_iBgJjBkGiClP_xHqqkZx_PNG_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiPeJjCfLiCnMiCmFiBgKiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFPngSkipUntilSpecChunk (	FCPngReadStruct* ps,
								const BYTE* bypChunkName)
{
	png_structp png_ptr = (png_structp)ps->m_png_ptr;
	BOOL bSucceed = TRUE;
	for (;;)
	{
		// _xZkqqHx_iDgAiDiDiDjDiDeOjClHiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		png_byte byaTmpChunkLen[4];
		png_read_data(png_ptr, byaTmpChunkLen, 4);
		const DWORD dwChunkDataSize = FFPngGetUint32(byaTmpChunkLen);
		// _xZkqqHx_iDgAiDiDiDjDiDeOjGlMiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		BYTE byaTmpChunkName[4];
		png_read_data(png_ptr, byaTmpChunkName, 4);

		if (bypChunkName != NULL &&
			memcmp(byaTmpChunkName, bypChunkName, 4) == 0)
		//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNiDgAiDiDiDjDiDeOiCmMiPoKiNiH_xHqqkZx_ -----
		{
			//----- _xZkqqHx_iDgAiDiDiDjDiDeOjGlMiCmGiDgAiDiDiDjDiDeOjClHiCpA_xHqqkZx_Undo -----
			FCUndoArchive& fcar = *(FCUndoArchive*)png_get_io_ptr(png_ptr);
			fcar.Undo(byaTmpChunkName, 4);
			fcar.Undo(byaTmpChunkLen, 4);
			break;
		}

		// _xZkqqHx_iDgGiBfLiDfOiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
		png_read_data(png_ptr, NULL, dwChunkDataSize);
		// CRC_xZkqqHx_jFkKiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
		png_read_data(png_ptr, NULL, 4);

		if (memcmp(byaTmpChunkName, PNG_IEND, 4) == 0)
		//----- IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCmMiPoKiNiH_xHqqkZx_ -----
		{
			bSucceed = FALSE;
			break;
		}
	}
	// CRC_xZkqqHx_iCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	png_reset_crc(png_ptr);
	return bSucceed;
} // FFPngSkipUntilSpecChunk.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngReadUntilEnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCmM_xHqqkZx_IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmFiBgJjBkGiClP_xHqqkZx_PNG_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiPeJjCfLiCnMiCmFiBgK_xHqqkZx_
 *			_xZkqqHx_iDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ps	:PNG_xZkqqHx_jDpMjHmNiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_jHoBiKeP_xHqqkZx_ CFCDDFileException(IDS_ERR_FILE_WRONG_FORM, L"")_xZkqqHx_iCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FFPngReadUntilMdrwChunk_xZkqqHx_iKnGjAjEiCmF_xHqqkZx_PNG_xZkqqHx_iCmMiNmFiPiJiCkJiCoH_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmF_xHqqkZx_
 *			_xZkqqHx_jDmHiCnNiNjOiCnOiBeCiClLiCmMiMoDiBeB_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOiCpAjDmHiCnNiNjOiCnNiBeBiNmFiMoDiCmJiClBiCmMiKnGjAjEiCmF_xHqqkZx_
 *			IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCnMiCmFjDmHiCnNiNjOiCpBiCmF_xHqqkZx_PNG_xZkqqHx_iDhEiDeAiDeDiDiLjDmHiCnNiNjOiCnNiCmNiPeJjHlJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngReadUntilEnd (FCPngReadStruct* ps)
{
	FFPngSkipUntilSpecChunk(ps, NULL);
} // FFPngReadUntilEnd.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngWriteUntilMdrwChunk
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCmMiNmFiPiJiCmMiDfGiDePiDgMiDgAiDiDiBeBiDeDiDiBiBfLiDfHiKnGjIeBiCmMiDgAiDiDiDjDiDeOiBeB_xHqqkZx_
 *			_xZkqqHx_iDgFiDeMiDfIiDgHiDgAiDiDiDjDiDeOiCnMiCmFiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ps	:PNG_xZkqqHx_iPgPjHmNiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_jHoBiKeP_xHqqkZx_ CFCDDFileException(IDS_ERR_FILE_WRONG_FORM, L"")_xZkqqHx_iCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiKnGjAjEiCmF_xHqqkZx_PNG_xZkqqHx_iCmMjBePjElMiCpAiPjBiCkLiPgPiClHiBeCiClLiCmMiMoDiBeB_xHqqkZx_MDRW_xZkqqHx_iDgAiDiDiDjDiDeOjDjJiCpAiPjBiCkLiPgPiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iNmFiMoDiCmJ_xHqqkZx_FFPngWriteUntilEnd_xZkqqHx_iKnGjAjEiCmF_xHqqkZx_IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiPjBiCkLiPgPiClFiCmE_xHqqkZx_
 *			PNG_xZkqqHx_iDhEiDeAiDeDiDiLiCmNiKkOjAkMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iIpIjAjEiCmM_xHqqkZx_FCPngWriteStruct_xZkqqHx_iNfMjBkCjBmMiDiBiDjDiDgPiCmJiCmNiBeBiImIiJlKiCmMiPoOjFpBiCpAjAnNjCoIiClFiCmEiCkIiCkN_xHqqkZx_
 *			_xZkqqHx_jFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			m_szImage32				PNG_xZkqqHx_iDeDiDiBiBfLiDfHiCmMiDfEiDeDiDfJiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *									_xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *									NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			m_pImage32;				PNG_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *									_xZkqqHx_iLpDiBgJiCkJiCoHiBgKiCmMiDeDiDiBiBfLiDfHiCpAiPgPjHmNiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *									NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			m_wstraDocumentProperty	_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeO_xHqqkZx_
 *									_xZkqqHx_iCmGiClFiCmEiPgPjHmNiClDiCoKiCoJiBeC_xHqqkZx_
 *									iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiPgPjHmNiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			m_lDocumentPropertySize	m_wstraDocumentProperty_xZkqqHx_jEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			m_png_ptr;				_xZkqqHx_iDfGiDfIiDgFiDiAiCkKiOgHiCkE_xHqqkZx_PNG_xZkqqHx_iCmMiDgGiBfLiDfOiBeCiDiGiBfLiDfFiCmNiOhHjCoIiClFiCmIiCkCiBeC_xHqqkZx_
 *			m_info_ptr;				_xZkqqHx_iDfGiDfIiDgFiDiAiCkKiOgHiCkE_xHqqkZx_PNG_xZkqqHx_iCmMiDgGiBfLiDfOiBeCiDiGiBfLiDfFiCmNiOhHjCoIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngWriteUntilMdrwChunk (FCPngWriteStruct* ps)
{
	// _xZkqqHx_iDeDiDiBiBfLiDfHiCpAiPjBiCkLiPgPiClHiCkJiBeI_xHqqkZx_
	BOOL bWriteImage = (ps->m_szImage32 != NULL && ps->m_pImage32 != NULL);
	// iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiPjBiCkLiPgPiClHiCkJiBeI_xHqqkZx_
	BOOL bWriteText = (ps->m_wstraDocumentProperty != NULL);

	png_structp png_ptr = (png_structp)ps->m_png_ptr;
	png_infop info_ptr = (png_infop)ps->m_info_ptr;

	CSize szImage32;
	const BYTE* pImage32;
	// _xZkqqHx_iLpDiDeDiDiBiBfLiDfHiDgGiBfLiDfOiBeC_xHqqkZx_
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	static BYTE s_pNullImage[(1 * 1 * 32) / 8] = { 0 };
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// memset _xZkqqHx_iCmFiPiJiKpKiJlLiClHiCoJiClBiCmGiBeC_xHqqkZx_ = {0} _xZkqqHx_iCmFiCmNiCkEiCnMiCkNiPiJiKpKiJlLiCmFiCkLiCmIiCkCiPoKiNiHiCkKiCkAiCmBiClNiBeC_xHqqkZx_
	static BYTE s_pNullImage[(1 * 1 * 32) / 8];
	memset(s_pNullImage, 0, sizeof(s_pNullImage));
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	if (bWriteImage)
	//----- _xZkqqHx_iDeDiDiBiBfLiDfHiCpAiPjBiCkLiPgPiClHiPoKiNiH_xHqqkZx_ -----
	{
		szImage32 = *ps->m_szImage32;
		pImage32 = ps->m_pImage32;
	} else
	//----- _xZkqqHx_iLpDiCmMiDeDiDiBiBfLiDfHiCpAiPjBiCkLiPgPiClHiPoKiNiH_xHqqkZx_ -----
	{
		szImage32 = CSize(1,1);
		pImage32 = s_pNullImage;
	}

	//----- _xZkqqHx_iJoGjBjMiDgGiBfLiDfOiCpAiBeB_xHqqkZx_PNG_xZkqqHx_jHhAiCmMjEhKjHpBiMgAiOkOiCmJjFmPiNfI_xHqqkZx_ -----
	vector<const BYTE*> vpImageLine(szImage32.cy);
	for (long lLine = 0; lLine < szImage32.cy; lLine++)
		vpImageLine[lLine] = &pImage32[lLine * szImage32.cx * 4];

	if (bWriteText)
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiPjBiCkLiPgPiClHiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiDhEiDeIiBfLiDhNiDgCiDgHiPoOjFpBiBeC_xHqqkZx_
		// "ja\nTitle\n_xZkqqHx_iDfOiDeDiDgHiDiL_xHqqkZx_\n_xZkqqHx_iNoMjAkMiOnC_xHqqkZx_\n_xZkqqHx_jAoAjGlO_xHqqkZx_\n_xZkqqHx_iDfCiDiBiDjDiDgH_xHqqkZx_"
		WString wstrDocPropFormat;
		wstrDocPropFormat.LoadString(IDS_DOCUMENT_PROPERTY_FORMAT);
		// _xZkqqHx_iMlOiMoKiDfCiBfLiDgIiBeCjDpKjGhL_xHqqkZx_="ja"
		astring strLangCode = WStrToAStr(FFExtractUntil(wstrDocPropFormat, L"\n"));
		for (long lPropId = 0;
			lPropId < FD_DPID_END && lPropId < ps->m_lDocumentPropertySize; lPropId++)
		{
			png_text text_ptr;
			ASSERT(!wstrDocPropFormat.IsEmpty());
			astring strKey = FFDocumentPropertyIdToAKey(FTDocumentPropertyId(lPropId));
			astring strText = FFWStrToItxt(ps->m_wstraDocumentProperty[lPropId]);
			astring strLangKey = FFWStrToItxt(FFExtractUntil(wstrDocPropFormat, L"\n"));
			// _xZkqqHx_iDgFiDeMiDfIiDgHiDgAiDiDiDjDiDeOiCmMiMgAiOkOiBgJjBlNiMlOiMoKjBmOiJjOiCmM_xHqqkZx_iTXt_xZkqqHx_iBeBiIlDiPgLiMgAiOkOiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
			text_ptr.compression = PNG_ITXT_COMPRESSION_zTXt;
			// _xZkqqHx_iLeLjCoIiCmMiDeMiBfLiBgJ_xHqqkZx_Title/Author_xZkqqHx_jDjJiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
			text_ptr.key = &strKey[0];
			// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMjDoAjHgFiCpAiOhHjCoIiBeC_xHqqkZx_
			text_ptr.text = &strText[0];
			// _xZkqqHx_iMlOiMoKiDfCiBfLiDgIiBgJiLeLjGpB_xHqqkZx_ RFC-1766_xZkqqHx_iBgKiCpAiOhHjCoIiBeC_xHqqkZx_
			text_ptr.lang = &strLangCode[0];
			// _xZkqqHx_iMlOiMoKiImLjBlGiCmMiDeMiBfLiBgJiDfOiDeDiDgHiDiL_xHqqkZx_/_xZkqqHx_iNoMjAkMiOnCjDjJiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
			text_ptr.lang_key = &strLangKey[0];
			// _xZkqqHx_iDgFiDeMiDfIiDgHiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
			png_set_text(png_ptr, info_ptr, &text_ptr, 1);
		}
	}

	//----- PNG_xZkqqHx_iMgAiOkOiCmFiPgPjHmN_xHqqkZx_ -----

	// IHDR_xZkqqHx_iDgAiDiDiDjDiDeOiPoOjFpBiCpAjAnNjCoIiClFiCnMiClHiBeC_xHqqkZx_
	png_set_IHDR(png_ptr, info_ptr, szImage32.cx, szImage32.cy,
				8, PNG_COLOR_TYPE_RGB_ALPHA, PNG_INTERLACE_NONE,
				PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT);

	// PNG_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDfGiDePiDgMiDgAiDiDiBeBiDgFiDeMiDfIiDgHiPoOjFpBiCpAiPjBiCkLiPgPiClFiCnMiClHiBeC_xHqqkZx_
	png_write_info(png_ptr, info_ptr);
	// _xZkqqHx_iJoGjBjMiDgGiBfLiDfOiCpAiPjBiCkLiPgPiClFiBeC_xHqqkZx_
	png_write_image(png_ptr, (BYTE**)vpImageLine.begin());
	// _xZkqqHx_iOgDiCoIiCmMiPoOjFpBiCpAiPjBiCkLiPgPiClFiCnMiClHiBeC_xHqqkZx_
	// info_ptr_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_IEND _xZkqqHx_iCpAiPjBiCkLiNjOiCnMiClIiPeJjHlJiClHiCoJiCoGiCkEiCmJ_xHqqkZx_libpng_xZkqqHx_iCpAjFmPiNfIiBeC_xHqqkZx_
	png_write_end(png_ptr, info_ptr);
} // FFPngWriteUntilMdrwChunk.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngWriteChunk
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgAiDiDiDjDiDeOjGlMiCmGiDgAiDiDiDjDiDeOiDgGiBfLiDfOiCmFiBeBiDgAiDiDiDjDiDeOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ps				:PNG_xZkqqHx_iPgPjHmNiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bypChunkName	:_xZkqqHx_iDgAiDiDiDjDiDeOjGlMiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *			pChunkData		:_xZkqqHx_iDgAiDiDiDjDiDeOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwChunkDataSize	:pChunkData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngWriteChunk (	FCPngWriteStruct* ps,
						const BYTE* bypChunkName,
						const BYTE* pChunkData,
						DWORD dwChunkDataSize)
{
	// MDRW_xZkqqHx_iMgAiOkOiDgGiBfLiDfOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	png_structp png_ptr = (png_structp)ps->m_png_ptr;
	png_write_chunk(png_ptr, (BYTE*)bypChunkName,
					(BYTE*)pChunkData, dwChunkDataSize);
} // FFPngWriteChunk.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFPngWriteUntilEnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCmM_xHqqkZx_IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ps	:PNG_xZkqqHx_iPgPjHmNiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_jHoBiKeP_xHqqkZx_ CFCDDFileException(IDS_ERR_FILE_WRONG_FORM, L"")_xZkqqHx_iCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FFPngWriteUntilMdrwChunk_xZkqqHx_iKnGjAjEiCmF_xHqqkZx_PNG_xZkqqHx_iCmMjBePjElMiCpAiPjBiCkLiPgPiClHiBeCiClLiCmMiMoDiBeB_xHqqkZx_
 *			MDRW_xZkqqHx_iDgAiDiDiDjDiDeOjDjJiCpAiPjBiCkLiPgPiClFiBeBiNmFiMoDiCmJiClBiCmMiKnGjAjEiCmF_xHqqkZx_IEND_xZkqqHx_iDgAiDiDiDjDiDeOiCpA_xHqqkZx_
 *			_xZkqqHx_iPjBiCkLiPgPiClFiCmE_xHqqkZx_PNG_xZkqqHx_iDhEiDeAiDeDiDiLiCmNiKkOjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFPngWriteUntilEnd (FCPngWriteStruct* ps)
{
	png_structp png_ptr = (png_structp)ps->m_png_ptr;
	// _xZkqqHx_iOgDiCoIiCmMiPoOjFpBiCpAiPjBiCkLiPgPiClFiCnMiClHiBeC_xHqqkZx_
	// NULL_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_IEND _xZkqqHx_iClOiCkPiPjBiCkLiPgPiClFiCmEiPeJjHlJiClHiCoJiCoGiCkEiCmJ_xHqqkZx_libpng_xZkqqHx_iCpAjFmPiNfIiBeC_xHqqkZx_
	png_write_end(png_ptr, NULL);
} // FFPngWriteUntilEnd.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFDocumentPropertyIdToAKey
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ID_xZkqqHx_iCkJiCoHiDgFiDeMiDfIiDgHiDgAiDiDiDjDiDeOiCmMiLeLjCoI_xHqqkZx_ASCII_xZkqqHx_iDeMiBfLjFlGiOjKjHpBiCnG_xHqqkZx_
 *			_xZkqqHx_jFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dpid	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLeLjCoI_xHqqkZx_ASCII_xZkqqHx_iDeMiBfLjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	I_xZkqqHx_iDeMiBfLjFlGiOjKjHpB_xHqqkZx_		ASCII_xZkqqHx_iDeMiBfLjFlGiOjKjHpB_xHqqkZx_		_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ID
 *		------------------------------------------------------------------
 *			_xZkqqHx_jFlGiPjBiDfOiDeDiDgHiDiL_xHqqkZx_		"Title"			FD_DPID_DOCUMENT_TITLE
 *			_xZkqqHx_jFlGiPjBiNoMiOnC_xHqqkZx_			"Author"		FD_DPID_DOCUMENT_AUTHOR
 *			_xZkqqHx_jFlGiPjBjAoAjGlO_xHqqkZx_			"Description"	FD_DPID_DOCUMENT_DESCRIPTION
 *			_xZkqqHx_jFlGiPjBiDfCiDiBiDjDiDgH_xHqqkZx_		"Comment"		FD_DPID_DOCUMENT_COMMENT
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const char* FFDocumentPropertyIdToAKey (FTDocumentPropertyId dpid)
{
	static vector<astring> l_vAKey;
	if (l_vAKey.empty())
	{
		CString str;
		str.LoadString(IDS_DOCUMENT_PROPERTY_A_KEY);
		astring strKeys = TStrToAStr(str);
		while (!strKeys.empty())
		{
			astring strKey = FFExtractUntil(strKeys, '\n');
			l_vAKey.push_back(strKey);
		}
		ASSERT(l_vAKey.size() == FD_DPID_END);
	}
	if (l_vAKey.size() <= dpid)
		return NULL;
	return l_vAKey[int(dpid)].c_str();
} // FFDocumentPropertyIdToAKey.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFDocumentPropertyIdToIKey
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ID_xZkqqHx_iCkJiCoHiDgFiDeMiDfIiDgHiDgAiDiDiDjDiDeOiCmMiLeLjCoI_xHqqkZx_2_xZkqqHx_iDgPiDeDiDgHiDeMiBfLjFlGiOjKjHpBiCnG_xHqqkZx_
 *			_xZkqqHx_jFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dpid	:_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLeLjCoI_xHqqkZx_2_xZkqqHx_iDgPiDeDiDgHiDeMiBfLjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	I_xZkqqHx_iDeMiBfLjFlGiOjKjHpB_xHqqkZx_		ASCII_xZkqqHx_iDeMiBfLjFlGiOjKjHpB_xHqqkZx_		_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ID
 *		------------------------------------------------------------------
 *			_xZkqqHx_jFlGiPjBiDfOiDeDiDgHiDiL_xHqqkZx_		"Title"			FD_DPID_DOCUMENT_TITLE
 *			_xZkqqHx_jFlGiPjBiNoMiOnC_xHqqkZx_			"Author"		FD_DPID_DOCUMENT_AUTHOR
 *			_xZkqqHx_jFlGiPjBjAoAjGlO_xHqqkZx_			"Description"	FD_DPID_DOCUMENT_DESCRIPTION
 *			_xZkqqHx_jFlGiPjBiDfCiDiBiDjDiDgH_xHqqkZx_		"Comment"		FD_DPID_DOCUMENT_COMMENT
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* FFDocumentPropertyIdToIKey (FTDocumentPropertyId dpid)
{
	static WStringVector l_vAKey;
	if (l_vAKey.empty())
	{
		WString wstrKeys;
		wstrKeys.LoadString(IDS_DOCUMENT_PROPERTY_W_KEY);
		while (!wstrKeys.empty())
		{
			WString wstrKey = FFExtractUntil(wstrKeys, L"\n");
			l_vAKey.push_back(wstrKey);
		}
		ASSERT(l_vAKey.size() == FD_DPID_END);
	}
	if (l_vAKey.size() <= dpid)
		return NULL;
	return l_vAKey[int(dpid)].c_str();
} // FFDocumentPropertyIdToIKey.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFAKeyToDocumentPropertyId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDgAiDiDiDjDiDeOiCmMiLeLjCoIiDeMiBfLjFlGiOjKjHpBiCkJiCoHiBeBjFlGiPjBiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ID_xZkqqHx_iCnGjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cpKey	:_xZkqqHx_iLeLjCoIiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	  _xZkqqHx_jGlMiPmM_xHqqkZx_			_xZkqqHx_iDeMiBfLjFlGiOjKjHpB_xHqqkZx_		_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ID
 *		------------------------------------------------------------------
 *			_xZkqqHx_jFlGiPjBiDfOiDeDiDgHiDiL_xHqqkZx_	"Title"			FD_DPID_DOCUMENT_TITLE
 *			_xZkqqHx_jFlGiPjBiNoMiOnC_xHqqkZx_		"Author"		FD_DPID_DOCUMENT_AUTHOR
 *			_xZkqqHx_jFlGiPjBjAoAjGlO_xHqqkZx_		"Description"	FD_DPID_DOCUMENT_DESCRIPTION
 *			_xZkqqHx_jFlGiPjBiDfCiDiBiDjDiDgH_xHqqkZx_	"Comment"		FD_DPID_DOCUMENT_COMMENT
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocumentPropertyId FFAKeyToDocumentPropertyId (const char* cpKey)
{
	static map<astring, FTDocumentPropertyId> s_mpKeyToDpid;
	if (s_mpKeyToDpid.empty())
	{
		for (long lC = 0;; lC++)
		{
			const char* cpTmp = FFDocumentPropertyIdToAKey(FTDocumentPropertyId(lC));
			if (cpTmp == NULL) break;
			s_mpKeyToDpid[cpTmp] = FTDocumentPropertyId(lC);
		}
	}
	map<astring, FTDocumentPropertyId>::const_iterator i = s_mpKeyToDpid.find(cpKey);
	if (i == s_mpKeyToDpid.end()) return FD_DPID_NONE;
	return (*i).second;
} // FFAKeyToDocumentPropertyId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFZlibCompress
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiCpA_xHqqkZx_LZ77_xZkqqHx_iIlDiPgLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vCompressBuff	:_xZkqqHx_iIlDiPgLiMoDiCmMiDgGiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *			pSrcData		:_xZkqqHx_iIlDiPgLjBePiCmMiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwSrcDataSize	:pSrcData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIlDiPgLiCmJiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	vCompressBuff_xZkqqHx_iCmJiKpJiCmJjDpMiCmBiCmEiCkCiCoJiDgGiBfLiDfOiCmMiMoDiCoLiCmJjCmHiJmBiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFZlibCompress (BYTEVector& vCompressBuff, const BYTE* pSrcData, DWORD dwSrcDataSize)
{
	int iErr = FFZlibCompress2(vCompressBuff, pSrcData, dwSrcDataSize, Z_DEFAULT_COMPRESSION);
	return (iErr == Z_OK);
} // FFZlibCompress.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFZlibCompress2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiCpA_xHqqkZx_LZ77_xZkqqHx_iIlDiPgLiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vCompressBuff	:_xZkqqHx_iIlDiPgLiMoDiCmMiDgGiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *			pSrcData		:_xZkqqHx_iIlDiPgLjBePiCmMiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwSrcDataSize	:pSrcData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iLevel			:_xZkqqHx_iIlDiPgLiCmMiDiMiDhIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *				Z_NO_COMPRESSION         0
 *				Z_BEST_SPEED             1
 *				Z_BEST_COMPRESSION       9
 *				Z_DEFAULT_COMPRESSION  (-1)
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIlDiPgLiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ Z_OK_xZkqqHx_iBeCiClLiCoKiImIiKePiCmNiDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	vCompressBuff_xZkqqHx_iCmJiKpJiCmJjDpMiCmBiCmEiCkCiCoJiDgGiBfLiDfOiCmMiMoDiCoLiCmJjCmHiJmBiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FFZlibCompress2 (BYTEVector& vCompressBuff, const BYTE* pSrcData, DWORD dwSrcDataSize, int iLevel)
{
	int iErr;
	// _xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
	const long lInitSize = vCompressBuff.size();
	uLongf destLen = compressBound(dwSrcDataSize);
	for (;;)
	{
		// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiBeC_xHqqkZx_
		vCompressBuff.resize(lInitSize + destLen);
		iErr = compress2(vCompressBuff.begin() + lInitSize, &destLen, pSrcData, dwSrcDataSize, iLevel);
		if (iErr == Z_OK)
		{
			// _xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAjDeLjAnIiCmIiDfEiDeDiDfJiCmJiPgLiPkMiBeC_xHqqkZx_
			vCompressBuff.resize(lInitSize + destLen);
			// _xZkqqHx_iPiIjHjNiCpAiPeJjHlJiBeC_xHqqkZx_
			break;
		}
		//----- _xZkqqHx_iDgPiDgCiDhEiDeAjFhDjBkLiImIiKePiCmMiDeHiDiJiBfLiCmMiPoKiNiH_xHqqkZx_ -----
		if (iErr != Z_BUF_ERROR)
			break;

		// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAiCfAiBeEiCfEjEhLiClFiCmEiNmEiDgAiDiDiDiMiDjDiDfHiBeC_xHqqkZx_
		destLen = (vCompressBuff.size() - lInitSize) * 1.5;
	}
	return iErr;
} // FFZlibCompress2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFZlibUncompress
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiCpAiJpAjDiAiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vDataBuff			:_xZkqqHx_iJpAjDiAiMoDiCmMiDgGiBfLiDfOiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_jHfMiCnPjFeLjHhGiCmIjHmMiIoGiCmJiKgHjBoFiClFiCmEiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *								 _xZkqqHx_iDgGiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *			pCompressData		:_xZkqqHx_iIlDiPgLiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCompressDataSize	:pCompressData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJpAjDiAiCmJiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFZlibUncompress (BYTEVector& vDataBuff, const BYTE* pCompressData, DWORD dwCompressDataSize)
{
	uLongf destLen = vDataBuff.size();
	if (uncompress(vDataBuff.begin(), &destLen, pCompressData, dwCompressDataSize) != Z_OK)
		return FALSE;
	if (destLen != vDataBuff.size())
		return FALSE;
	return TRUE;
} // FFZlibUncompress.
