// WndHistoryTree.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#if defined(_IME_ON)
#include <imm.h>			// For IMN_SETOPENSTATUS.
#endif // defined(_IME_ON)
#include "DynamicDraw.h"
#include "UtilMisc.h"		// For FdsecToFiletime.
#include "UtilWin.h"		// For CloseImeStatus.
#include "UtilStr.h"		// For FFCalcCharCount.etc.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilDlg.h"		// For RightByLeftHand.
#include "UtilErr.h"		// For FFMessageBox.
#include "UtilStdLib.h"		// For mdef_iterator.
#include "RegData.h"		// For InitRegFont.etc.
#include "HTreeRec.h"		// For FCHTreeRec.etc.
#include "HTreeManager.h"	// For m_pHtreeManager.
#include "HiProject.h"	// For FCHiProject.
#include "FrameWnd.h"		// For FFGetMainWnd().
#include "PursuerText.h"	// For CFCPursuerText.
#include "DynamicDb.h"	// For g_pFileServer.
#include "WndHistoryTree.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Superclass_xZkqqHx_iCmMjCoIiLgAiBeC_xHqqkZx_

// _xZkqqHx_jDgPjIfOjGlMiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
LPCTSTR CFCWndHistoryTree::s_lpszClassName = NULL;

#define FD_HTREE_HPS_MARK_DIAMETER	20	// _xZkqqHx_jHjKjHpAiImKjChFiDhNiBfLiDeOiCmMjClMiMgBiBeC_xHqqkZx_
#define FD_HTREE_HPS_MARK_LINE_W	8	// _xZkqqHx_jHjKjHpAiImKjChFiDhNiBfLiDeOiCmMjApMjClHiBeC_xHqqkZx_
#define FD_HTREE_HPS_MARK_BOX_EXT	4	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkPiCoJjHjKjHpAiImKjChFiDhNiBfLiDeOiCmMiDeNiDiDiDgCiDhGiBeC_xHqqkZx_

#define FDTIMER_HTREE_TEMP_MARK_BLINK	1
#define FDTIMER_HTREE_MARK_UP_BLINK		2
#define FD_WAIT_HTREE_TEMP_MARK_BLINK	80
#define FD_WAIT_HTREE_MARK_UP_BLINK		80


/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiNiBfLiDeKiDiLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myDrawProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDgNiBfLiDgIiCmMiDeHiDgCiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rect		:_xZkqqHx_iDgNiBfLiDgIiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsSelected	:_xZkqqHx_iDgNiBfLiDgIiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pAtDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			gdiStock	:_xZkqqHx_jFgAiJoGjHhAiDhJiDjDiBeFiDhFiDiJiDfGiCmMiDfIiDgHiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myDrawProject (	const CRect& rect,
							BOOL bIsSelected,
							FCAutoDC* pAtDC,
							FCAutoGdiStock& gdiStock)
{
//----- 05.09.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (bIsSelected)
//		pAtDC->FillRect(rect, gdiStock.GetRegBrush(FDCL_HTREE_SELECTION));
//	else
//		pAtDC->FillRect(rect, gdiStock.GetRegBrush(FDCL_HTREE_NODE_FACE));
//	pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 2, FDCL_HTREE_LIGHT));
//	pAtDC->MoveTo(rect.left, rect.bottom);
//	pAtDC->LineTo(rect.left, rect.top);
//	pAtDC->LineTo(rect.right, rect.top);
//	pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 2, FDCL_HTREE_SHADOW));
//	pAtDC->LineTo(rect.right, rect.bottom);
//	pAtDC->LineTo(rect.left, rect.bottom);
//----- 05.09.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	//----- _xZkqqHx_jDgIiCoIiCmCiCnEiClH_xHqqkZx_ -----
	pAtDC->FillRect(rect, gdiStock.GetRegBrush(FDCL_HTREE_PROJECT_FACE));

	COLORREF colShadow;
	COLORREF colLight;
	if (bIsSelected)
	//----- _xZkqqHx_jBeJjBpAiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		colShadow = g_pReg->GetOptiRegColor(FDCL_HTREE_SELECTION);
		colLight = FFGetMiddleColor(0.4, colShadow, g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT));
	} else
	//----- _xZkqqHx_jBeJjBpAiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		colShadow = g_pReg->GetOptiRegColor(FDCL_HTREE_SHADOW);
		colLight = g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT);
	}
	pAtDC->SetObject(gdiStock.GetPen(PS_SOLID, 2, colLight));
	pAtDC->MoveTo(rect.left, rect.bottom);
	pAtDC->LineTo(rect.left, rect.top);
	pAtDC->LineTo(rect.right, rect.top);
	pAtDC->SetObject(gdiStock.GetPen(PS_SOLID, 2, colShadow));
	pAtDC->LineTo(rect.right, rect.bottom);
	pAtDC->LineTo(rect.left, rect.bottom);
//----- 05.09.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // myDrawProject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myDrawExpBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rect		:_xZkqqHx_iDgNiBfLiDgIiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsPlus		:_xZkqqHx_iBhLiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiBhMiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsSelected	:_xZkqqHx_iDhLiDgCiDeOiDfIiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pAtDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			gdiStock	:_xZkqqHx_jFgAiJoGjHhAiDhJiDjDiBeFiDhFiDiJiDfGiCmMiDfIiDgHiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myDrawExpBox (	const CRect& rect,
							BOOL bIsPlus,
							BOOL bIsSelected,
							FCAutoDC* pAtDC,
							FCAutoGdiStock& gdiStock)
{
//----- 05.09.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iCnMiClIjDgIiCoIjCnHiClHiBeC_xHqqkZx_
//	if (bIsSelected)
//		pAtDC->FillRect(rect, gdiStock.GetRegBrush(FDCL_HTREE_EBOX_SEL_FACE));
//	else
//		pAtDC->FillRect(rect, gdiStock.GetRegBrush(FDCL_HTREE_EBOX_FACE));
//	// _xZkqqHx_jApMiCpAjFgAiJoGiBeC_xHqqkZx_
//	pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 0, FDCL_HTREE_SHADOW));
//	pAtDC->MoveTo(rect.right, rect.top);
//	pAtDC->LineTo(rect.right, rect.bottom);
//	pAtDC->LineTo(rect.left, rect.bottom);
//
//	pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 0, FDCL_HTREE_LIGHT));
//	pAtDC->LineTo(rect.left, rect.top);
//	pAtDC->LineTo(rect.right, rect.top);
//
//	pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 0, FDCL_HTREE_GRAY));
//	pAtDC->MoveTo(rect.left + 1, rect.top + 1);
//	pAtDC->LineTo(rect.right - 1, rect.top + 1);
//	pAtDC->LineTo(rect.right - 1, rect.bottom - 1);
//	pAtDC->LineTo(rect.left + 1, rect.bottom - 1);
//	pAtDC->LineTo(rect.left + 1, rect.top + 1);
//	const CPoint ptCenter = rect.CenterPoint();
//
//	if (bIsSelected)
//		pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 0, FDCL_HTREE_EBOX_SEL_LINE));
//	else
//		pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 0, FDCL_HTREE_EBOX_LINE));
//
//	pAtDC->MoveTo(rect.left + 3, ptCenter.y);
//	pAtDC->LineTo(rect.right - 3, ptCenter.y);
//	if (bIsPlus)
//	{
//		pAtDC->MoveTo(ptCenter.x, rect.top + 3);
//		pAtDC->LineTo(ptCenter.x, rect.bottom - 3);
//	}
//----- 05.09.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	//----- _xZkqqHx_jDgIiCoIiCmCiCnEiClH_xHqqkZx_ -----
	pAtDC->FillRect(rect, gdiStock.GetRegBrush(FDCL_HTREE_EBOX_FACE));

	COLORREF colShadow;
	COLORREF colLight;
	if (bIsSelected)
	//----- _xZkqqHx_jBeJjBpAiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		colShadow = g_pReg->GetOptiRegColor(FDCL_HTREE_SELECTION);
		colLight = FFGetMiddleColor(0.4, colShadow, g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT));
	} else
	//----- _xZkqqHx_jBeJjBpAiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		colShadow = g_pReg->GetOptiRegColor(FDCL_HTREE_SHADOW);
		colLight = g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT);
	}

	// _xZkqqHx_iImDiCkCjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	pAtDC->SetObject(gdiStock.GetPen(PS_SOLID, 2, colShadow));
	pAtDC->MoveTo(rect.right, rect.top);
	pAtDC->LineTo(rect.right, rect.bottom);
	pAtDC->LineTo(rect.left, rect.bottom);
	// _xZkqqHx_jGlOiCoJiCkCjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	pAtDC->SetObject(gdiStock.GetPen(PS_SOLID, 2, colLight));
	pAtDC->LineTo(rect.left, rect.top);
	pAtDC->LineTo(rect.right, rect.top);
	// (+)_xZkqqHx_iDhNiBfLiDeOiCpAjFgAiJoGiBeC_xHqqkZx_
	const CPoint ptCenter = rect.CenterPoint();
	pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 0, FDCL_HTREE_EBOX_LINE));
	pAtDC->MoveTo(rect.left + 3, ptCenter.y);
	pAtDC->LineTo(rect.right - 3, ptCenter.y);
	if (bIsPlus)
	{
		pAtDC->MoveTo(ptCenter.x, rect.top + 3);
		pAtDC->LineTo(ptCenter.x, rect.bottom - 3);
	}
//----- 05.09.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // myDrawExpBox.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myDrawIntroLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDlBjDpMjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ptLine0		:_xZkqqHx_jApMiCmMiOgOjDfPiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ptLine1		:_xZkqqHx_jApMiCmMiPeJjDfPiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pAtDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			gdiStock	:_xZkqqHx_jFgAiJoGjHhAiDhJiDjDiBeFiDhFiDiJiDfGiCmMiDfIiDgHiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	ptLine0, ptLine1_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJiKgFjApMjFkKiCmNiBeBjAiFjFlNiCkJjAiCjClMiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myDrawIntroLine (const CPoint& ptLine0,
							 const CPoint& ptLine1,
							 FCAutoDC* pAtDC,
							 FCAutoGdiStock& gdiStock)
{
	ASSERT(ptLine0.x == ptLine1.x || ptLine0.y == ptLine1.y);

	// _xZkqqHx_iImDiCkCjApMiCpAjBeJjBpAiBeC_xHqqkZx_
	pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 0, FDCL_HTREE_SHADOW));
	pAtDC->MoveTo(ptLine0);
	pAtDC->LineTo(ptLine1);
	// _xZkqqHx_jGlOiCoJiCkCjApMiCpAjBeJjBpAiBeC_xHqqkZx_
	pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 0, FDCL_HTREE_LIGHT));
	if (ptLine0.y == ptLine1.y)
	//----- _xZkqqHx_jAiFjFlNjApMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		pAtDC->MoveTo(ptLine0.x, ptLine0.y + 1);
		pAtDC->LineTo(ptLine1.x, ptLine1.y + 1);
	} else
	//----- _xZkqqHx_jAiCjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		pAtDC->MoveTo(ptLine0.x + 1, ptLine0.y);
		pAtDC->LineTo(ptLine1.x + 1, ptLine1.y);
	}
} // myDrawIntroLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myDrawNode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgNiBfLiDgIiCmMiDhLiDgCiDeOiDfIiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pHtreeManager	:_xZkqqHx_iDhNiDgMiBfLiDfHiDiDiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rect			:_xZkqqHx_iDgNiBfLiDgIiLoJiMgAiBeC_xHqqkZx_
 *			pAtDC			:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			gdiStock		:_xZkqqHx_jFgAiJoGjHhAiDhJiDjDiBeFiDhFiDiJiDfGiCmMiDfIiDgHiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsSelected		:_xZkqqHx_iDgNiBfLiDgIiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsOpenBottom	:_xZkqqHx_iDgNiBfLiDgIiCmMjCoKiCpAiKeKiCkNiCkJiCmHiCkEiCkJiOhHjCoIiBeC_xHqqkZx_
 *			dHtreeScore		:_xZkqqHx_jHjKjHpAiDfIiDfCiDeBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iBkAiCmGiBkBiCmNiBeBjDgPjIfOiClDiCoKiCmEiCkCiCoJjAeGiCmMjApMiBeCjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAjAeGiCpAiOgHiCkEiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkAiBkA_xHqqkZx_
 *          _xZkqqHx_iBkA_xHqqkZx_                            _xZkqqHx_iBkB_xHqqkZx_
 *          _xZkqqHx_iBkA_xHqqkZx_                            _xZkqqHx_iBkB_xHqqkZx_
 *          _xZkqqHx_iBkA_xHqqkZx_    _xZkqqHx_iDfIiDfCiDeBjAeGiCmFjDgIiCoIiCmCiCnEiClH_xHqqkZx_    _xZkqqHx_iBkB_xHqqkZx_
 *          _xZkqqHx_iBkA_xHqqkZx_                            _xZkqqHx_iBkB_xHqqkZx_
 *          _xZkqqHx_iBkA_xHqqkZx_                            _xZkqqHx_iBkB_xHqqkZx_
 *          _xZkqqHx_iBkBiBkBiBkBiBkB_xHqqkZx_    _xZkqqHx_iBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkB_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myDrawNode (const FCHTreeManager* pHtreeManager,
						const CRect& rect,
						FCAutoDC* pAtDC,
						FCAutoGdiStock& gdiStock,
						BOOL bIsSelected,
						BOOL bIsOpenBottom,
						double dHtreeScore)
{
	//----- _xZkqqHx_jDgIiCoIiCmCiCnEiClH_xHqqkZx_ -----
	COLORREF colFill = FFGetMiddleColor(dHtreeScore,
										g_pReg->GetOptiRegColor(FDCL_HTREE_NODE_FACE_LOW_SCORE),
										g_pReg->GetOptiRegColor(FDCL_HTREE_NODE_FACE_HI_SCORE));
	pAtDC->FillRect(rect, FCAtBrush(colFill));

	COLORREF colShadow;
	COLORREF colLight;
	if (bIsSelected)
	//----- _xZkqqHx_jBeJjBpAiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		colShadow = g_pReg->GetOptiRegColor(FDCL_HTREE_SELECTION);
		colLight = FFGetMiddleColor(0.4, colShadow, g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT));
	} else
	//----- _xZkqqHx_jBeJjBpAiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		colShadow = g_pReg->GetOptiRegColor(FDCL_HTREE_SHADOW);
		colLight = g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT);
	}
	// _xZkqqHx_jGlOiCoJiCkCiDhJiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	pAtDC->SetObject(gdiStock.GetPen(PS_SOLID, 2, colLight));
	// _xZkqqHx_iDhLiDgCiDeOiDfIiCmMjGlOjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	pAtDC->MoveTo(rect.left, rect.bottom);
	pAtDC->LineTo(rect.left, rect.top);
	pAtDC->LineTo(rect.right, rect.top);
	// _xZkqqHx_iImDiCkCiDhJiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	pAtDC->SetObject(gdiStock.GetPen(PS_SOLID, 2, colShadow));
	// _xZkqqHx_iDhLiDgCiDeOiDfIiCmMiImDjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	pAtDC->LineTo(rect.right, rect.bottom);
	if (bIsOpenBottom)
	//----- _xZkqqHx_jCoKiCpAiKeKiCkNiPoKiNiH_xHqqkZx_ -----
	{
		pAtDC->LineTo(rect.left + pHtreeManager->GetHtBoxWidthL() + pHtreeManager->GetHtLifeWidthH(), rect.bottom);
		pAtDC->MoveTo(rect.left + pHtreeManager->GetHtBoxWidthL() - pHtreeManager->GetHtLifeWidthH(), rect.bottom);
		pAtDC->LineTo(rect.left, rect.bottom);
	} else
	//----- _xZkqqHx_jCoKiCpAjFmCiClGiCoJiPoKiNiH_xHqqkZx_ -----
	{
		pAtDC->LineTo(rect.left, rect.bottom);
	}
} // myDrawNode.

//----- 05.09.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myDrawLifeArrow
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjApMiCmGjGoOiIpDiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rtLifeLine	:_xZkqqHx_jHjKjHpAjApMiCmMiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
// *			rtLifeArrow	:_xZkqqHx_jHjKjHpAjApMiCmMjAoGjCfLiCmMjGoOiIpDiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pAtDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
// *			gdiStock	:_xZkqqHx_jFgAiJoGjHhAiDhJiDjDiBeFiDhFiDiJiDfGiCmMiDfIiDgHiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
// *			bIsSelected	:_xZkqqHx_iDgNiBfLiDgIiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//static void myDrawLifeArrow (const CRect& rtLifeLine,
//							 const CRect& rtLifeArrow,
//							 FCAutoDC* pAtDC,
//							 FCAutoGdiStock& gdiStock,
//							 BOOL bIsSelected)
//{
//	// _xZkqqHx_iPeJjHlJjDfPjGoOiIpDiCmMjHmMiIoGiBeC_xHqqkZx_
//	POINT ptaArw[3] = {	{ rtLifeArrow.left, rtLifeArrow.top },
//						{ (rtLifeArrow.left + rtLifeArrow.right) / 2, rtLifeArrow.bottom },
//						{ rtLifeArrow.right, rtLifeArrow.top } };
//
////----- 05.09.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	if (bIsFill)
////	//----- _xZkqqHx_jDgIiCoIiCmCiCnEiClFiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
////	{
////		// _xZkqqHx_jDkHjGlOiDhJiDjDiCmGiBeBjEhHiMgJjAeGiDhFiDiJiDfGiCpAjAnNjCoIiBeC_xHqqkZx_
////		pAtDC->SetStockPen(NULL_PEN);
////		if (bIsSelected)
////			pAtDC->SetObject(gdiStock.GetRegBrush(FDCL_HTREE_SELECTION));
////		else
////			pAtDC->SetObject(gdiStock.GetRegBrush(FDCL_HTREE_NODE_FACE));
////		// _xZkqqHx_jHjKjHpAjApMiCmMjHmMiIoGiCpAjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_bottom + 1_xZkqqHx_iCmJiClFiCmIiCkCiCmGiBeB_xHqqkZx_
////		// _xZkqqHx_jHjKjHpAjApMiCmGjGoOiIpDiCmMiKnEiCmJiKnEiMiEiCkKjAlGiClGiCoJiBeC_xHqqkZx_
////		pAtDC->Rectangle(CRect(rtLifeLine.left, rtLifeLine.top, rtLifeLine.right, rtLifeLine.bottom + 1));
////		// _xZkqqHx_iPeJjHlJjDfPjGoOiIpDiCmMjHmMiIoGiCpAjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
////		pAtDC->Polygon(ptaArw, 3);
////	}
////	// _xZkqqHx_iImDiCkCiDhJiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
////	pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 2, FDCL_HTREE_SHADOW));
////	// _xZkqqHx_jHjKjHpAjApMiCmMiImDjApMiCpAjFgAiJoGiBeC_xHqqkZx_
////	pAtDC->MoveTo(rtLifeLine.right, rtLifeLine.top);		// _xZkqqHx_jHjKjHpAjApMiCmMiJeFiPoDjCfLiBeC_xHqqkZx_
////	pAtDC->LineTo(rtLifeLine.right, rtLifeLine.bottom);		// _xZkqqHx_jHjKjHpAjApMiCmMiJeFiJlKjCfLiBeC_xHqqkZx_
////	// _xZkqqHx_iPeJjHlJjDfPjGoOiIpDiCmMiImDjApMiCpAjFgAiJoGiBeC_xHqqkZx_
////	pAtDC->MoveTo(ptaArw[2]);		// _xZkqqHx_jGoOiIpDiJeFiPoDiBeC_xHqqkZx_
////	pAtDC->LineTo(ptaArw[1]);		// _xZkqqHx_jGoOiIpDjAoGjCfLiBeC_xHqqkZx_
////	// _xZkqqHx_jGlOiCoJiCkCiDhJiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
////	pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 2, FDCL_HTREE_LIGHT));
////	// _xZkqqHx_jHjKjHpAjApMiCmMjGlOjApMiCpAjFgAiJoGiBeC_xHqqkZx_
////	pAtDC->MoveTo(rtLifeLine.left, rtLifeLine.top);		// _xZkqqHx_jHjKjHpAjApMiCmMiNlGiPoDjCfLiBeC_xHqqkZx_
////	pAtDC->LineTo(rtLifeLine.left, rtLifeLine.bottom);	// _xZkqqHx_jHjKjHpAjApMiCmMiNlGiJlKjCfLiBeC_xHqqkZx_
////	// _xZkqqHx_iPeJjHlJjDfPjGoOiIpDiCmMjGlOjApMiCpAjFgAiJoGiBeC_xHqqkZx_
////	pAtDC->MoveTo(ptaArw[2]);							// _xZkqqHx_jGoOiIpDiJeFiPoDiBeC_xHqqkZx_
////	pAtDC->LineTo(rtLifeLine.right, ptaArw[2].y);		// _xZkqqHx_jHjKjHpAjApMiCmMiJeFiJlKjCfLiBeC_xHqqkZx_
////	pAtDC->MoveTo(rtLifeLine.left, ptaArw[2].y);		// _xZkqqHx_jHjKjHpAjApMiCmMiNlGiJlKjCfLiBeC_xHqqkZx_
////	pAtDC->LineTo(ptaArw[0]);							// _xZkqqHx_jGoOiIpDiNlGiPoDiBeC_xHqqkZx_
////	pAtDC->LineTo(ptaArw[1]);							// _xZkqqHx_jGoOiIpDjAoGjCfLiBeC_xHqqkZx_
////----- 05.09.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	COLORREF colShadow;
//	COLORREF colLight;
//	if (bIsSelected)
//	//----- _xZkqqHx_jBeJjBpAiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		colShadow = g_pReg->GetOptiRegColor(FDCL_HTREE_SELECTION);
//		colLight = FFGetMiddleColor(0.4, colShadow, g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT));
//	} else
//	//----- _xZkqqHx_jBeJjBpAiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		colShadow = g_pReg->GetOptiRegColor(FDCL_HTREE_SHADOW);
//		colLight = g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT);
//	}
//
//	// _xZkqqHx_jDkHjGlOiDhJiDjDiCmGiBeBjEhHiMgJjAeGiDhFiDiJiDfGiCpAjAnNjCoIiBeC_xHqqkZx_
//	pAtDC->SetStockPen(NULL_PEN);
//	pAtDC->SetObject(gdiStock.GetRegBrush(FDCL_HTREE_NODE_FACE));
//	// _xZkqqHx_jHjKjHpAjApMiCmMjHmMiIoGiCpAjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_bottom + 1_xZkqqHx_iCmJiClFiCmIiCkCiCmGiBeB_xHqqkZx_
//	// _xZkqqHx_jHjKjHpAjApMiCmGjGoOiIpDiCmMiKnEiCmJiKnEiMiEiCkKjAlGiClGiCoJiBeC_xHqqkZx_
//	pAtDC->Rectangle(CRect(rtLifeLine.left, rtLifeLine.top, rtLifeLine.right, rtLifeLine.bottom + 1));
//	// _xZkqqHx_iPeJjHlJjDfPjGoOiIpDiCmMjHmMiIoGiCpAjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
//	pAtDC->Polygon(ptaArw, 3);
//	// _xZkqqHx_iImDiCkCiDhJiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	pAtDC->SetObject(gdiStock.GetPen(PS_SOLID, 2, colShadow));
//	// _xZkqqHx_jHjKjHpAjApMiCmMiImDjApMiCpAjFgAiJoGiBeC_xHqqkZx_
//	pAtDC->MoveTo(rtLifeLine.right, rtLifeLine.top);		// _xZkqqHx_jHjKjHpAjApMiCmMiJeFiPoDjCfLiBeC_xHqqkZx_
//	pAtDC->LineTo(rtLifeLine.right, rtLifeLine.bottom);		// _xZkqqHx_jHjKjHpAjApMiCmMiJeFiJlKjCfLiBeC_xHqqkZx_
//	// _xZkqqHx_iPeJjHlJjDfPjGoOiIpDiCmMiImDjApMiCpAjFgAiJoGiBeC_xHqqkZx_
//	pAtDC->MoveTo(ptaArw[2]);		// _xZkqqHx_jGoOiIpDiJeFiPoDiBeC_xHqqkZx_
//	pAtDC->LineTo(ptaArw[1]);		// _xZkqqHx_jGoOiIpDjAoGjCfLiBeC_xHqqkZx_
//	// _xZkqqHx_jGlOiCoJiCkCiDhJiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	pAtDC->SetObject(gdiStock.GetPen(PS_SOLID, 2, colLight));
//	// _xZkqqHx_jHjKjHpAjApMiCmMjGlOjApMiCpAjFgAiJoGiBeC_xHqqkZx_
//	pAtDC->MoveTo(rtLifeLine.left, rtLifeLine.top);		// _xZkqqHx_jHjKjHpAjApMiCmMiNlGiPoDjCfLiBeC_xHqqkZx_
//	pAtDC->LineTo(rtLifeLine.left, rtLifeLine.bottom);	// _xZkqqHx_jHjKjHpAjApMiCmMiNlGiJlKjCfLiBeC_xHqqkZx_
//	// _xZkqqHx_iPeJjHlJjDfPjGoOiIpDiCmMjGlOjApMiCpAjFgAiJoGiBeC_xHqqkZx_
//	pAtDC->MoveTo(ptaArw[2]);							// _xZkqqHx_jGoOiIpDiJeFiPoDiBeC_xHqqkZx_
//	pAtDC->LineTo(rtLifeLine.right, ptaArw[2].y);		// _xZkqqHx_jHjKjHpAjApMiCmMiJeFiJlKjCfLiBeC_xHqqkZx_
//	pAtDC->MoveTo(rtLifeLine.left, ptaArw[2].y);		// _xZkqqHx_jHjKjHpAjApMiCmMiNlGiJlKjCfLiBeC_xHqqkZx_
//	pAtDC->LineTo(ptaArw[0]);							// _xZkqqHx_jGoOiIpDiNlGiPoDiBeC_xHqqkZx_
//	pAtDC->LineTo(ptaArw[1]);							// _xZkqqHx_jGoOiIpDjAoGjCfLiBeC_xHqqkZx_
//
////----- 05.09.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // myDrawLifeArrow.
//----- 05.09.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myDrawLifeArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjApMiCmGjGoOiIpDiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rtLifeLine	:_xZkqqHx_jHjKjHpAjApMiCmMiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtLifeArrow	:_xZkqqHx_jHjKjHpAjApMiCmMjAoGjCfLiCmMjGoOiIpDiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vSessionHtreeScore	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDjEmNiImNiCmGjHjKjHpAiDfIiDfCiDeBiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mpSessionToY:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->Y_xZkqqHx_iNmAjFfHiDgOiDgCiDfGiDiFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pAtDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *			gdiStock	:_xZkqqHx_jFgAiJoGjHhAiDhJiDjDiBeFiDhFiDiJiDfGiCmMiDfIiDgHiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsSelected	:_xZkqqHx_iDgNiBfLiDgIiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			05.09.20 Fukushiro M. _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiCmFjAeGiCpAjFmPiCkGiCoJiCoGiCkEiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
static void myDrawLifeArrow (const CRect& rtLifeLine,
							 const CRect& rtLifeArrow,
							 const vector<FCSessionHtreeScoreRec>& vSessionHtreeScore,
							 const map<flint, long>& mpSessionToY,
							 FCAutoDC* pAtDC,
							 FCAutoGdiStock& gdiStock,
							 BOOL bIsSelected)
{
	// _xZkqqHx_iPeJjHlJjDfPjGoOiIpDiCmMjHmMiIoGiBeC_xHqqkZx_
	POINT ptaArw[3] = {	{ rtLifeArrow.left, rtLifeArrow.top },
						{ (rtLifeArrow.left + rtLifeArrow.right) / 2, rtLifeArrow.bottom },
						{ rtLifeArrow.right, rtLifeArrow.top } };

	COLORREF colShadow;
	COLORREF colLight;
	if (bIsSelected)
	//----- _xZkqqHx_jBeJjBpAiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		colShadow = g_pReg->GetOptiRegColor(FDCL_HTREE_SELECTION);
		colLight = FFGetMiddleColor(0.4, colShadow, g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT));
	} else
	//----- _xZkqqHx_jBeJjBpAiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		colShadow = g_pReg->GetOptiRegColor(FDCL_HTREE_SHADOW);
		colLight = g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT);
	}

	// _xZkqqHx_jDkHjGlOiDhJiDjDiCmGiBeBjEhHiMgJjAeGiDhFiDiJiDfGiCpAjAnNjCoIiBeC_xHqqkZx_
	pAtDC->SetStockPen(NULL_PEN);
	COLORREF colFill;
	vector<FCSessionHtreeScoreRec>::const_iterator iShs;
	for (iShs = vSessionHtreeScore.begin(); iShs != vSessionHtreeScore.end(); iShs++)
	{
		//----- _xZkqqHx_jDgIiCoIiCmCiCnEiClH_xHqqkZx_ -----
		// _xZkqqHx_jDgIiCoIiCmCiCnEiClFjAeGiCpAiOfKiPgPiBeC_xHqqkZx_
		colFill = FFGetMiddleColor(	iShs->m_dHtreeScore,
									g_pReg->GetOptiRegColor(FDCL_HTREE_NODE_FACE_LOW_SCORE),
									g_pReg->GetOptiRegColor(FDCL_HTREE_NODE_FACE_HI_SCORE));
		// _xZkqqHx_jDgIiCoIiCmCiCnEiClFiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
		CRect rect(	rtLifeLine.left,
					mpSessionToY.find(iShs->m_fliFromSessionIndex)->second,
					rtLifeLine.right,
					mpSessionToY.find(iShs->m_fliUntilSessionIndex)->second);
		// _xZkqqHx_iNmFiPiJiCmMiDfKiDgCiDfGiDiHiDjDjEmNiImNiCmNiBeBjHjKjHpAjApMiLoJiMgAiCmMiDgHiDgCiDhGiCkJiCoHiBeCjHjKjHpAjClHiBiBiCePiCmMiPoKiNiHiBeB_xHqqkZx_
		// _xZkqqHx_jHjKjHpAjApMiLoJiMgAiCmJiNmFiPkMjCgMiCkKjAnNjCoIiClDiCoKiCoJiClNiCnPiBeBiClBiCmMiPiIjHjNiCkKjFeLjHhGiBeC_xHqqkZx_
		if (iShs == vSessionHtreeScore.begin())
			rect.top = rtLifeLine.top;
		// _xZkqqHx_jHjKjHpAiLoJiMgAiCmMiDfKiDgCiDfGiDiHiDjDjEmNiImNiCpAjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
		pAtDC->FillRect(rect, FCAtBrush(colFill));
	}
	// _xZkqqHx_iPeJjHlJjDfPjGoOiIpDiCmMjHmMiIoGiCpAiBeBjHjKjHpAiLoJiMgAiCmMiNmFiMoDiCmMjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
	pAtDC->SetBrush(colFill);
	pAtDC->Polygon(ptaArw, 3);
	// _xZkqqHx_iImDiCkCiDhJiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	pAtDC->SetObject(gdiStock.GetPen(PS_SOLID, 2, colShadow));
	// _xZkqqHx_jHjKjHpAjApMiCmMiImDjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	pAtDC->MoveTo(rtLifeLine.right, rtLifeLine.top);		// _xZkqqHx_jHjKjHpAjApMiCmMiJeFiPoDjCfLiBeC_xHqqkZx_
	pAtDC->LineTo(rtLifeLine.right, rtLifeLine.bottom);		// _xZkqqHx_jHjKjHpAjApMiCmMiJeFiJlKjCfLiBeC_xHqqkZx_
	// _xZkqqHx_iPeJjHlJjDfPjGoOiIpDiCmMiImDjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	pAtDC->MoveTo(ptaArw[2]);		// _xZkqqHx_jGoOiIpDiJeFiPoDiBeC_xHqqkZx_
	pAtDC->LineTo(ptaArw[1]);		// _xZkqqHx_jGoOiIpDjAoGjCfLiBeC_xHqqkZx_
	// _xZkqqHx_jGlOiCoJiCkCiDhJiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	pAtDC->SetObject(gdiStock.GetPen(PS_SOLID, 2, colLight));
	// _xZkqqHx_jHjKjHpAjApMiCmMjGlOjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	pAtDC->MoveTo(rtLifeLine.left, rtLifeLine.top);		// _xZkqqHx_jHjKjHpAjApMiCmMiNlGiPoDjCfLiBeC_xHqqkZx_
	pAtDC->LineTo(rtLifeLine.left, rtLifeLine.bottom);	// _xZkqqHx_jHjKjHpAjApMiCmMiNlGiJlKjCfLiBeC_xHqqkZx_
	// _xZkqqHx_iPeJjHlJjDfPjGoOiIpDiCmMjGlOjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	pAtDC->MoveTo(ptaArw[2]);							// _xZkqqHx_jGoOiIpDiJeFiPoDiBeC_xHqqkZx_
	pAtDC->LineTo(rtLifeLine.right, ptaArw[2].y);		// _xZkqqHx_jHjKjHpAjApMiCmMiJeFiJlKjCfLiBeC_xHqqkZx_
	pAtDC->MoveTo(rtLifeLine.left, ptaArw[2].y);		// _xZkqqHx_jHjKjHpAjApMiCmMiNlGiJlKjCfLiBeC_xHqqkZx_
	pAtDC->LineTo(ptaArw[0]);							// _xZkqqHx_jGoOiIpDiNlGiPoDiBeC_xHqqkZx_
	pAtDC->LineTo(ptaArw[1]);							// _xZkqqHx_jGoOiIpDjAoGjCfLiBeC_xHqqkZx_
} // myDrawLifeArrow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myDrawLabelEdge
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLiCmMiDhEiDiMiBfLiDiAiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rect		:_xZkqqHx_iDiJiDhIiDiLiLoJiMgAiBeC_xHqqkZx_
 *			pAtDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *			gdiStock	:_xZkqqHx_jFgAiJoGjHhAiDhJiDjDiBeFiDhFiDiJiDfGiCmMiDfIiDgHiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsSelected	:_xZkqqHx_iDgNiBfLiDgIiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myDrawLabelEdge (const CRect& rect,
							 FCAutoDC* pAtDC,
							 FCAutoGdiStock& gdiStock,
							 BOOL bIsSelected)
{
//----- 05.09.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhLiDgCiDeOiDfIjFgAiJoGjHhAiCmMiDhJiDjDiCmGiDhFiDiJiDfGiCpAjAnNjCoIiBeC_xHqqkZx_
//	pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 0, FDCL_HTREE_SHADOW));
//	pAtDC->SetObject(gdiStock.GetRegBrush(FDCL_HTREE_LABEL_FACE));
//	// _xZkqqHx_iDhLiDgCiDeOiDfIjFgAiJoGiBeC_xHqqkZx_
//	pAtDC->Rectangle(rect);
//	// _xZkqqHx_iDhLiDgCiDeOiDfIiCmMiJgFiCpAjFgAiJoGiBeC_xHqqkZx_
//	pAtDC->SetObject(gdiStock.GetRegPen(PS_SOLID, 2, FDCL_HTREE_SHADOW));
//	pAtDC->MoveTo(rect.right + 1, rect.top + 3);
//	pAtDC->LineTo(rect.right + 1, rect.bottom + 1);
//	pAtDC->LineTo(rect.left + 3, rect.bottom + 1);
//----- 05.09.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	COLORREF colShadow;
	COLORREF colLight;
	if (bIsSelected)
	//----- _xZkqqHx_jBeJjBpAiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		colShadow = g_pReg->GetOptiRegColor(FDCL_HTREE_SELECTION);
		colLight = FFGetMiddleColor(0.4, colShadow, g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT));
	} else
	//----- _xZkqqHx_jBeJjBpAiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		colShadow = g_pReg->GetOptiRegColor(FDCL_HTREE_SHADOW);
		colLight = g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT);
	}

	// _xZkqqHx_iLoJiMgAjEmNiImNiCpAjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
	pAtDC->FillRect(rect, FCAtBrush(g_pReg->GetOptiRegColor(FDCL_HTREE_LABEL_FACE)));

	// _xZkqqHx_iImDiCkCiDhJiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	pAtDC->SetObject(gdiStock.GetPen(PS_SOLID, 2, colShadow));
	// _xZkqqHx_iImDjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	pAtDC->MoveTo(rect.right, rect.top);		// _xZkqqHx_iJeFiPoDjCfLiBeC_xHqqkZx_
	pAtDC->LineTo(rect.right, rect.bottom);		// _xZkqqHx_iJeFiJlKjCfLiBeC_xHqqkZx_
	pAtDC->LineTo(rect.left, rect.bottom);		// _xZkqqHx_iNlGiJlKjCfLiBeC_xHqqkZx_
	// _xZkqqHx_jGlOiCoJiCkCiDhJiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
	pAtDC->SetObject(gdiStock.GetPen(PS_SOLID, 2, colLight));
	// _xZkqqHx_jGlOjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	pAtDC->LineTo(rect.left, rect.top);			// _xZkqqHx_iNlGiPoDjCfLiBeC_xHqqkZx_
	pAtDC->LineTo(rect.right, rect.top);		// _xZkqqHx_iJeFiPoDjCfLiBeC_xHqqkZx_
//----- 05.09.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // myDrawLabelEdge.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myDrawBoxText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiBeBiDiJiDhIiDiLjDjJiCmMiDgFiDeMiDfIiDgHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rect		:_xZkqqHx_iDgNiBfLiDgIiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pAtDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			gdiStock	:_xZkqqHx_jFgAiJoGjHhAiDhJiDjDiBeFiDhFiDiJiDfGiCmMiDfIiDgHiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			hIcon		:_xZkqqHx_jFgAiJoGiClHiCoJiDeBiDeDiDfCiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lFontHeight	:_xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpText1	:_xZkqqHx_iCfAiNhDjGnKiCmMiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCiJpMiNhDiDfCiBfLiDgIiCkKjDpMiCmBiCmEiCkCiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *			wcpText2	:_xZkqqHx_iCfBiNhDjGnKiCmMiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCiJpMiNhDiDfCiBfLiDgIiCkKjDpMiCmBiCmEiCkCiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_jHfMiCnPiBeBiDhEiDeIiDjDiDgHiCmGiDgFiDeMiDfIiDgHjAeGiCmNjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMjFgAiJoGiDiMiDeDiDeBiDeFiDgHiBeC_xHqqkZx_
 *
 *                           GetHtBoxIconW()
 *                              _xZkqqHx_iEkFiBkJiEjPiBkIiEkH_xHqqkZx_
 *       GetHtBoxIconMarginL()  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                                    GetHtBoxTextMarginR()
 *                          _xZkqqHx_iBkIiEkJiEkJiBkJ_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iBkIiEkJiEjPiEkJiBkJ_xHqqkZx_
 *                            _xZkqqHx_iEkAiEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      GetHtBoxTextMarginL()   _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *    GetHtBoxIconMarginT()   _xZkqqHx_iEkAiEkA_xHqqkZx_    _xZkqqHx_iBkIiEkJiEjPiEkJiBkJ_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      GetHtBoxTextMarginT()
 *                    _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iEkAiEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_
 *                    _xZkqqHx_iEkJiEjPiEjPiEjPiEkMiElJiEkKiEkKiEkKiElJiEkKiElJiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElJiEkKiEkNiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *              _xZkqqHx_iEkGiEjPiEjPiEkJiEjPiEjPiEjPiElOiEkMiBgDiBgDiBgDiEkN_xHqqkZx_                                  _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iBkK_xHqqkZx_    _xZkqqHx_iBkK_xHqqkZx_      _xZkqqHx_iEkLiBeG_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkMiBgDiEkNiEkMiBgDiEkNiEkMiBgDiEkNiEkMiBgDiEkNiEkMiBgDiEkN_xHqqkZx_  _xZkqqHx_iElOiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *    GetHtBoxIconH()         _xZkqqHx_iEkLiBeG_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_GetHtBoxTextLineGap()
 *              _xZkqqHx_iBkL_xHqqkZx_            _xZkqqHx_iEkLiBeG_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkPiBgDiEkOiEkPiBgDiEkOiEkPiBgDiEkOiEkPiBgDiEkOiEkPiBgDiEkO_xHqqkZx_  _xZkqqHx_iElOiEjPiEjPiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *              _xZkqqHx_iEkIiEjPiEjPiEjPiEjPiEjPiEjPiElOiEkPiBgDiBgDiBgDiEkO_xHqqkZx_                                  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
 *                            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkMiBgDiEkNiEkMiBgDiEkNiEkMiBgDiEkNiEkMiBgDiEkNiEkMiBgDiEkN_xHqqkZx_  _xZkqqHx_iElOiEjPiEjPiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *                            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkK_xHqqkZx_
 *                            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkPiBgDiEkOiEkPiBgDiEkOiEkPiBgDiEkOiEkPiBgDiEkOiEkPiBgDiEkO_xHqqkZx_  _xZkqqHx_iElOiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *                            _xZkqqHx_iEkL_xHqqkZx_                                            _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *                            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkOiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *                                          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                                    _xZkqqHx_iBkK_xHqqkZx_
 *                                          _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_                                  GetHtBoxTextMarginB()
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myDrawBoxText (	const FCHTreeManager* pHtreeManager,
							const CRect& rect,
							FCAutoDC* pAtDC,
							FCAutoGdiStock* gdiStock,
							HICON hIcon,
							long lFontHeight,
							const wchar_t* wcpText1,
							const wchar_t* wcpText2)
{
	// _xZkqqHx_iDeBiDeDiDfCiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
	pAtDC->DrawIconEx(rect.left + pHtreeManager->GetHtBoxIconMarginL(),
					rect.top + pHtreeManager->GetHtBoxIconMarginT(),
					hIcon, 0, 0, 0, NULL, DI_NORMAL);
	CRect rtText;
	rtText.left = rect.left + pHtreeManager->GetHtBoxIconMarginL() + pHtreeManager->GetHtBoxIconW() + pHtreeManager->GetHtBoxTextMarginL();
	rtText.top = rect.top + pHtreeManager->GetHtBoxTextMarginT();
	rtText.right = rect.right - pHtreeManager->GetHtBoxTextMarginR();
	rtText.bottom = rect.bottom - pHtreeManager->GetHtBoxTextMarginB();
	pAtDC->DrawText(wcpText1, wcslen(wcpText1), CP_ACP,
					rtText, DT_LEFT|DT_TOP|DT_SINGLELINE);
	rtText.top += lFontHeight + pHtreeManager->GetHtBoxTextLineGap();
	pAtDC->DrawText(wcpText2, wcslen(wcpText2), CP_ACP,
					rtText, DT_LEFT|DT_TOP|DT_SINGLELINE);
} // myDrawBoxText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myDrawBoxText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiBeBiDiJiDhIiDiLjDjJiCmMiDgFiDeMiDfIiDgHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rect		:_xZkqqHx_iDgNiBfLiDgIiLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pAtDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			gdiStock	:_xZkqqHx_jFgAiJoGjHhAiDhJiDjDiBeFiDhFiDiJiDfGiCmMiDfIiDgHiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			hIcon		:_xZkqqHx_jFgAiJoGiClHiCoJiDeBiDeDiDfCiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lFontHeight	:_xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpText		:_xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCiJpMiNhDiDfCiBfLiDgIiCkKjDpMiCmBiCmEiCkCiCmEiCoAiCoGiCkCiBeC_xHqqkZx_
 *						 _xZkqqHx_iCfAiNhDiCmJiOpLiCnMiCoHiCmIiCkCjFlGiOjKjHpBiCmNiCfBiNhDjGnKiCmJjFfMiOkGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_jHfMiCnPiBeBiDhEiDeIiDjDiDgHiCmGiDgFiDeMiDfIiDgHjAeGiCmNjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCmMjFgAiJoGiDiMiDeDiDeBiDeFiDgHiBeC_xHqqkZx_
 *
 *                           GetHtBoxIconW()
 *                              _xZkqqHx_iEkFiBkJiEjPiBkIiEkH_xHqqkZx_
 *       GetHtBoxIconMarginL()  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                                    GetHtBoxTextMarginR()
 *                          _xZkqqHx_iBkIiEkJiEkJiBkJ_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_                            _xZkqqHx_iBkIiEkJiEjPiEkJiBkJ_xHqqkZx_
 *                            _xZkqqHx_iEkAiEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      GetHtBoxTextMarginL()   _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *    GetHtBoxIconMarginT()   _xZkqqHx_iEkAiEkA_xHqqkZx_    _xZkqqHx_iBkIiEkJiEjPiEkJiBkJ_xHqqkZx_                        _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_      GetHtBoxTextMarginT()
 *                    _xZkqqHx_iBkL_xHqqkZx_      _xZkqqHx_iEkAiEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_                          _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_
 *                    _xZkqqHx_iEkJiEjPiEjPiEjPiEkMiElJiEkKiEkKiEkKiElJiEkKiElJiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElJiEkKiEkNiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *              _xZkqqHx_iEkGiEjPiEjPiEkJiEjPiEjPiEjPiElOiEkMiBgDiBgDiBgDiEkN_xHqqkZx_                                  _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iBkK_xHqqkZx_    _xZkqqHx_iBkK_xHqqkZx_      _xZkqqHx_iEkLiBeG_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkMiBgDiEkNiEkMiBgDiEkNiEkMiBgDiEkNiEkMiBgDiEkNiEkMiBgDiEkN_xHqqkZx_  _xZkqqHx_iElOiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *    GetHtBoxIconH()         _xZkqqHx_iEkLiBeG_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_GetHtBoxTextLineGap()
 *              _xZkqqHx_iBkL_xHqqkZx_            _xZkqqHx_iEkLiBeG_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkPiBgDiEkOiEkPiBgDiEkOiEkPiBgDiEkOiEkPiBgDiEkOiEkPiBgDiEkO_xHqqkZx_  _xZkqqHx_iElOiEjPiEjPiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *              _xZkqqHx_iEkIiEjPiEjPiEjPiEjPiEjPiEjPiElOiEkPiBgDiBgDiBgDiEkO_xHqqkZx_                                  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
 *                            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkMiBgDiEkNiEkMiBgDiEkNiEkMiBgDiEkNiEkMiBgDiEkNiEkMiBgDiEkN_xHqqkZx_  _xZkqqHx_iElOiEjPiEjPiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *                            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeGiBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iBkL_xHqqkZx_  _xZkqqHx_iBkK_xHqqkZx_
 *                            _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkPiBgDiEkOiEkPiBgDiEkOiEkPiBgDiEkOiEkPiBgDiEkOiEkPiBgDiEkO_xHqqkZx_  _xZkqqHx_iElOiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *                            _xZkqqHx_iEkL_xHqqkZx_                                            _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *                            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkOiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *                                          _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                                    _xZkqqHx_iBkK_xHqqkZx_
 *                                          _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_                                  GetHtBoxTextMarginB()
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myDrawBoxText (	const FCHTreeManager* pHtreeManager,
							const CRect& rect,
							FCAutoDC* pAtDC,
							FCAutoGdiStock* gdiStock,
							HICON hIcon,
							long lFontHeight,
							const wchar_t* wcpText)
{
	// _xZkqqHx_iDeBiDeDiDfCiDjDiCpAjFgAiJoGiBeC_xHqqkZx_
	pAtDC->DrawIconEx(rect.left + pHtreeManager->GetHtBoxIconMarginL(),
					rect.top + pHtreeManager->GetHtBoxIconMarginT(),
					hIcon, 0, 0, 0, NULL, DI_NORMAL);
	CRect rtText;
	rtText.left = rect.left + pHtreeManager->GetHtBoxIconMarginL() + pHtreeManager->GetHtBoxIconW() + pHtreeManager->GetHtBoxTextMarginL();
	rtText.top = rect.top + pHtreeManager->GetHtBoxTextMarginT();
	rtText.right = rect.right - pHtreeManager->GetHtBoxTextMarginR();
	rtText.bottom = rect.bottom - pHtreeManager->GetHtBoxTextMarginB();
	pAtDC->DrawTextLines(rtText,
						WString(wcpText),
						CP_ACP,
						lFontHeight,
						pHtreeManager->GetHtBoxTextLineGap(),
						DT_LEFT|DT_TOP,
						TRUE,
						TRUE);
} // myDrawBoxText.

/////////////////////////////////////////////////////////////////////////////
// CFCWndHistoryTree

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::CFCWndHistoryTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pProject	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// 04.07.07 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
// *			pRequestDoc	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBjBjHjFhEjAoGiCpAiOhHjCoIiBeCjFhDjHhGiCmIiCoH_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCWndHistoryTree::CFCWndHistoryTree ()
{
	//----- _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCmMiPiJiKpKiJlL_xHqqkZx_ -----
	m_pMessageWnd = NULL;						// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHjBjHjFhEjAoGiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
	m_pHtreeManager	= new FCHTreeManager();		// _xZkqqHx_jHjKjHpAjGnIiKmHjHjNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_

	m_lSelectedDocumentId = -1L;				// _xZkqqHx_iHeAiMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJjFfMiOkGiClDiCoKiCmEiCoJiBgJjBkGiClPjBeJjBpAiClDiCoKiCmEiCkCiCoJiBgKjHjKjHpAiOhNiBeC_xHqqkZx_
	m_fliSelectedSessionIndex = -1;
	m_clsSelectedObject = FDTR_NONE_REC;
	m_lSelectedObjectId = -1;

	m_lCurMarkedDocumentId = -1L;				// _xZkqqHx_iHeBiMlLiNnN_xHqqkZx_ _xZkqqHx_iDhNiBfLiDeKiBfLiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiBeC_xHqqkZx_
	m_fliCurMarkedSessionIndex = flint(-1);		// _xZkqqHx_iHeBiMlLiNnN_xHqqkZx_ _xZkqqHx_iDhNiBfLiDeKiBfLiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiBeCiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiBeC_xHqqkZx_

	m_hIconProject = NULL;			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhLiDgCiDeOiDfIjHhAiDeBiDeDiDfCiDjDiBeC_xHqqkZx_
	m_hIconHidocument	= NULL;		// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIjHhAiDeBiDeDiDfCiDjDiBeC_xHqqkZx_
	m_hIconBgnLabel	= NULL;			// _xZkqqHx_iKeKiOgOiDiJiDhIiDiLiDhLiDgCiDeOiDfIjHhAiDeBiDeDiDfCiDjDiBeC_xHqqkZx_
	m_hIconHiForkTag = NULL;		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePjHhAiDeBiDeDiDfCiDjDiBeC_xHqqkZx_
	m_hIconTimeLabel = NULL;		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLjHhAiDeBiDeDiDfCiDjDiBeC_xHqqkZx_

	m_lgOffsetX = 0;		// Scroll_xZkqqHx_iCmMiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
	m_lgOffsetY = 0;		// Scroll_xZkqqHx_iCmMiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
	m_dScrollRatioX = 1.0;	// Scroll_xZkqqHx_jHmKiCmGiOmAiNnLiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCmMjEoEiBeC_xHqqkZx_
	m_dScrollRatioY = 1.0;	// Scroll_xZkqqHx_jHmKiCmGiOmAiNnLiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCmMjEoEiBeC_xHqqkZx_

	m_lLastDocumentId = -1L;			// _xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNjHjKjHpAiOhNiBeC_xHqqkZx_
	m_fliLastSessionIndex = flint(-1);	// _xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNjHjKjHpAiOhNiImKjChFiBeC_xHqqkZx_
	m_clsLastObject = FDTR_NONE_REC;	// _xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	m_lLastObjectId = -1;				// _xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_

	m_nTempMarkOrLabel = -1;
	m_lTempMarkDocumentId = -1L;			// _xZkqqHx_iJlMjAnNjFkKiKpCjHjKjHpAiOhNiBeC_xHqqkZx_
	m_fliTempMarkSessionIndex = flint(-1);	// _xZkqqHx_iJlMjAnNjFkKiKpCjHjKjHpAiImKjChFiBeC_xHqqkZx_
	m_lTimerBlink = 0;						// _xZkqqHx_iJlMjAnNjFkKiKpCjDjJiCmMjDfPjGmFiMfHjAjEiBeC_xHqqkZx_

	// _xZkqqHx_jBePiJpBiCmMiDhNiDeFiDfIiImKjChFiBeCiDhNiDeFiDfIiInKjDkOiCmMiDgAiDeGiDgCiDeOiCmJiOgHiCkEiClNiCnPiBeBiCkAiCoIiCkGiCmIiCkCjCgMiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
	m_lgptLastMouse = CPoint(LONG_MIN, LONG_MIN);
} // CFCWndHistoryTree::CFCWndHistoryTree.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::~CFCWndHistoryTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.02.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCWndHistoryTree::~CFCWndHistoryTree ()
{
	// _xZkqqHx_jHjKjHpAjGnIiKmHjHjNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	delete m_pHtreeManager;
} // CFCWndHistoryTree::~CFCWndHistoryTree.

BEGIN_MESSAGE_MAP(CFCWndHistoryTree, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCWndHistoryTree)
	ON_WM_PAINT()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	ON_WM_SIZE()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEWHEEL()
	ON_WM_CONTEXTMENU()
	ON_WM_SETFOCUS()
	ON_WM_RBUTTONDOWN()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_IME_NOTIFY, OnImeNotify)
	ON_MESSAGE(WM_USER_SET_ZOOM256, OnUserSetZoom256)
	ON_MESSAGE(WM_USER_PURSUER_TEXT_NEED_INFO, OnUserPursuerTextNeedInfo)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::Create
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmJiMiLiCnBjFhEiCkPiCoHiCoKiClNiOhBiDeFiDeCiDjDiDgIiDeFiCpAiNoMjAkMiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iPiJiKpKiJlLiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwExStyle	:_xZkqqHx_iKgHjCkDiDeFiDeCiDjDiDgIiDeFiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwStyle		:Window_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rect		:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pParentWnd	:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nID			:_xZkqqHx_iOhBiDeFiDeCiDjDiDgIiDeFiCmM_xHqqkZx_ ID _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pMessageWnd	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjBjHjFhEjAoGiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_NULL_xZkqqHx_iCmM_xHqqkZx_
 *						 _xZkqqHx_iPoKiNiHiCmNjAgFiDeFiDeCiDjDiDgIiDeFiCmJjBjHjFhEiClDiCoKiCoJiBeC_xHqqkZx_
 *			pContext	:_xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jAlDiPoNiPeJjHlJ_xHqqkZx_
 *			FALSE	:_xZkqqHx_iInJiPoNiPeJjHlJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.02.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::Create (DWORD dwExStyle,
								DWORD dwStyle,
								const CRect& rect,
								CWnd* pParentWnd,
								UINT nID,
								CWnd* pMessageWnd,
								BOOL bIsAutoAlt,
								const DWORD* pActionList,
								long lActionListCount,
								const DWORD* pMenuIdList,
								long lMenuIdListCount,
								CCreateContext* pContext)
{
	//----- _xZkqqHx_iDeOiDiJiDfIiCpAjDgPjIfO_xHqqkZx_ -----
	if (s_lpszClassName == NULL)
    	s_lpszClassName = ::AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW,
										FFGetApp()->LoadStandardCursor(IDC_ARROW));
	if (!CreateEx(	dwExStyle, s_lpszClassName, _T(""), dwStyle,
					rect.left, rect.top, rect.Width(), rect.Height(),
					pParentWnd->GetSafeHwnd(), NULL, NULL)) return FALSE;
	SetDlgCtrlID(nID);	// _xZkqqHx_iOhBiDeFiDeCiDjDiDgIiDeFiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_

	///////////// _xZkqqHx_iKgFiOoNjFmPjAjEiCmMiPiJiKpKiJlL_xHqqkZx_ /////////////
	m_pMessageWnd = pMessageWnd;				// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHjBjHjFhEjAoGiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
//----- 05.01.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (m_pMessageWnd == NULL)
//		m_pMessageWnd = pParentWnd;				// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHjBjHjFhEjAoGiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
//----- 05.01.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	m_lSelectedDocumentId = -1L;				// _xZkqqHx_iHeAiMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJjFfMiOkGiClDiCoKiCmEiCoJiBgJjBkGiClPjBeJjBpAiClDiCoKiCmEiCkCiCoJiBgKjHjKjHpAiOhNiBeC_xHqqkZx_
	m_fliSelectedSessionIndex = -1;
	m_clsSelectedObject = FDTR_NONE_REC;
	m_lSelectedObjectId = -1;

	m_lCurMarkedDocumentId = -1L;				// _xZkqqHx_iHeBiMlLiNnN_xHqqkZx_ _xZkqqHx_jGhLjBmMiCmFiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiBeGjHjKjHpAiImKjChFiDhNiBfLiDeKiBfLiCpAjFfMiOkGiClHiCoJiClNiCnPiCmMiPoOjFpBiBeC_xHqqkZx_
	m_fliCurMarkedSessionIndex = flint(-1);		// _xZkqqHx_iHeCiMlLiNnN_xHqqkZx_ _xZkqqHx_jGhLjBmMiCmFiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMiImKjChFiBeGjHjKjHpAiImKjChFiDhNiBfLiDeKiBfLiCpAjFfMiOkGiClHiCoJiClNiCnPiCmMiPoOjFpBiBeC_xHqqkZx_
	// _xZkqqHx_iDeBiDeDiDfCiDjDiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	m_hIconProject = FFGetApp()->LoadIcon(IDI_HTREE_PROJECT);
	m_hIconHidocument = FFGetApp()->LoadIcon(IDI_HTREE_DOCUMENT);
	m_hIconBgnLabel = FFGetApp()->LoadIcon(IDI_HTREE_LABEL);
	m_hIconHiForkTag = FFGetApp()->LoadIcon(IDI_HTREE_HI_FORK_TAG);
	m_hIconTimeLabel = FFGetApp()->LoadIcon(IDI_HTREE_TIME_LABEL);

	m_lLastDocumentId = -1L;			// _xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNjHjKjHpAiOhNiBeC_xHqqkZx_
	m_fliLastSessionIndex = flint(-1);	// _xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNjHjKjHpAiOhNiImKjChFiBeC_xHqqkZx_
	m_clsLastObject = FDTR_NONE_REC;	// _xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	m_lLastObjectId = -1;				// _xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_

	m_nTempMarkOrLabel = -1;
	m_lTempMarkDocumentId = -1L;			// _xZkqqHx_iJlMjAnNjFkKiKpCjHjKjHpAiOhNiBeC_xHqqkZx_
	m_fliTempMarkSessionIndex = flint(-1);	// _xZkqqHx_iJlMjAnNjFkKiKpCjHjKjHpAiImKjChFiBeC_xHqqkZx_
	m_lTimerBlink = 0;						// _xZkqqHx_iJlMjAnNjFkKiKpCjDjJiCmMjDfPjGmFiMfHjAjEiBeC_xHqqkZx_

	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiOkJjDkO_xHqqkZx_Alt_xZkqqHx_iCmMjBmOiPnLiCmGiClHiCoJiBeC_xHqqkZx_
	if (bIsAutoAlt)
		FFGetMainWnd()->AddAutoAltWindow(m_hWnd);

	// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
	if (pActionList != NULL)
		m_vActionList.insert(m_vActionList.begin(), pActionList, pActionList + lActionListCount);
	// _xZkqqHx_iDiBiDgKiDiFiBfL_xHqqkZx_ID_xZkqqHx_iCmMiDiKiDfIiDgHiBeC_xHqqkZx_
	if (pMenuIdList != NULL)
		m_vMenuIdList.insert(m_vMenuIdList.begin(), pMenuIdList, pMenuIdList + lMenuIdListCount);
	return TRUE;
} // CFCWndHistoryTree::Create.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SyncToDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjFfMiOkGiCpAiDgIiDeMiDiFiDiBiDjDiDgHjCiGiCmMjHjKjHpAjFlGiPjBiCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jDkPiOjOiCmJiBeBjHjKjHpAjFlGiPjBiDhEiDeAiDeDiDiLiCmMiNfIjAfGiCpAiDgAiDeGiDgCiDeOiClFiCmEiBeBiNfIjAfGiClDiCoKiCmE_xHqqkZx_
 *			_xZkqqHx_iCkCiClNiPoKiNiHiCmNjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	viewMode				:_xZkqqHx_jAfGiClFiCkCiDhCiDiFiBfLiDiCiBfLiDgIiCpAiOhHjCoIiBeCjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *									 FDHT_VMODE_NONE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpProjectPath			:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocumentId				:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex			:_xZkqqHx_jFlGiPjBiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsSelect				:_xZkqqHx_jBeJjBpAiImKjChFiCpAiOhHjCoIiImKjChFiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
 *			bIsMark					:_xZkqqHx_iDhNiBfLiDeKiBfLiImKjChFiCpAiOhHjCoIiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
 *			bIsFitHtreeViewZoom	:	:_xZkqqHx_iJoGjGmKiDfEiDeDiDfJiCmJiDfJiBfLiDiAiCpAiDhEiDeCiDgCiDgHiClDiClJiCoJiCkJiOhHjCoIiBeC_xHqqkZx_
 *			bScrollTo				:_xZkqqHx_iDhCiDiFiBfLiCmMjBiLiCpAjHjKjHpAiImKjChFiCmJiNiHiCoNiClJiCmEiDfIiDeOiDiNiBfLiDiL_xHqqkZx_
 *						 			 _xZkqqHx_iClHiCoJiCkJiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmMiInKiNhDiKnGiMfHiBeC_xHqqkZx_bScrollTo = TRUE_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *			_xZkqqHx_jFfMiOkGiCmIiClFiDiCiBfLiDgIiBeC_xHqqkZx_
 *				_xZkqqHx_iBjMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_ _xZkqqHx_iOhHjCoIjGlDiClF_xHqqkZx_
 *				-> _xZkqqHx_jFfMiOkGiCmIiClFiDiCiBfLiDgI_xHqqkZx_
 *				_xZkqqHx_iBjMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_ _xZkqqHx_iOhHjCoIjHeMiCoI_xHqqkZx_
 *				_xZkqqHx_iBjMjHjKjHpAjFlGiPjB_xHqqkZx_ _xZkqqHx_iOhHjCoIjGlDiClF_xHqqkZx_
 *				-> _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgI_xHqqkZx_
 *				_xZkqqHx_iBjMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_ _xZkqqHx_iOhHjCoIjHeMiCoI_xHqqkZx_
 *				_xZkqqHx_iBjMjHjKjHpAjFlGiPjB_xHqqkZx_ _xZkqqHx_iOhHjCoIjHeMiCoI_xHqqkZx_
 *				-> _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgI_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
 *				_xZkqqHx_iBjMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_ _xZkqqHx_iOhHjCoIjGlDiClF_xHqqkZx_
 *				-> _xZkqqHx_jFfMiOkGiCmIiClFiDiCiBfLiDgI_xHqqkZx_
 *				_xZkqqHx_iBjMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_ _xZkqqHx_iOhHjCoIjHeMiCoI_xHqqkZx_
 *				-> _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgI_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgI_xHqqkZx_
 *				_xZkqqHx_iBjMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_ _xZkqqHx_iOhHjCoIjGlDiClF_xHqqkZx_
 *				-> _xZkqqHx_jFfMiOkGiCmIiClFiDiCiBfLiDgI_xHqqkZx_
 *				_xZkqqHx_iBjMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_ _xZkqqHx_iOhHjCoIjHeMiCoI_xHqqkZx_
 *				_xZkqqHx_iBjMjHjKjHpAjFlGiPjB_xHqqkZx_ _xZkqqHx_iOhHjCoIjGlDiClF_xHqqkZx_
 *				-> _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgI_xHqqkZx_
 *				_xZkqqHx_iBjMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_ _xZkqqHx_iOhHjCoIjHeMiCoI_xHqqkZx_
 *				_xZkqqHx_iBjMjHjKjHpAjFlGiPjB_xHqqkZx_ _xZkqqHx_iOhHjCoIjHeMiCoIiClF_xHqqkZx_
 *				-> _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgI_xHqqkZx_
 *			_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgI_xHqqkZx_
 *				_xZkqqHx_iBjMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_ _xZkqqHx_iOhHjCoIjGlDiClF_xHqqkZx_
 *				-> _xZkqqHx_jFfMiOkGiCmIiClFiDiCiBfLiDgI_xHqqkZx_
 *				_xZkqqHx_iBjMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_ _xZkqqHx_iOhHjCoIjHeMiCoI_xHqqkZx_
 *				_xZkqqHx_iBjMjHjKjHpAjFlGiPjB_xHqqkZx_ _xZkqqHx_iOhHjCoIjGlDiClF_xHqqkZx_
 *				-> _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgI_xHqqkZx_
 *				_xZkqqHx_iBjMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfI_xHqqkZx_ _xZkqqHx_iOhHjCoIjHeMiCoI_xHqqkZx_
 *				_xZkqqHx_iBjMjHjKjHpAjFlGiPjB_xHqqkZx_ _xZkqqHx_iOhHjCoIjHeMiCoIiClF_xHqqkZx_
 *				-> _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgI_xHqqkZx_
 *			bScrollTo = FALSE_xZkqqHx_iCmMiPoKiNiHiBeBiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmNiInKiNhDiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::SyncToDocument (
			FTHTViewMode viewMode,					// _xZkqqHx_jAfGiClFiCkCiDhCiDiFiBfLiDiCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
			const wchar_t* wcpProjectPath,			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiBeC_xHqqkZx_
			long lDocumentId,						// _xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			flint fliSessionIndex,					// _xZkqqHx_jFlGiPjBiImKjChFiBeC_xHqqkZx_
			BOOL bIsSelect,							// _xZkqqHx_jBeJjBpAiImKjChFiCpAiOhHjCoIiImKjChFiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
			BOOL bIsMark,							// _xZkqqHx_iDhNiBfLiDeKiBfLiImKjChFiCpAiOhHjCoIiImKjChFiCmJiNiHiCoNiClJiCoJiCkJiBeI_xHqqkZx_
			BOOL bIsFitHtreeViewZoom,				// _xZkqqHx_iDfJiBfLiDiAjCgMiCpAiBeBjHjKjHpAjGnIiCkKiOpLiCnMiCoJiCoGiCkEiCmJjClCjAkOiClHiCoJiCkJiBeI_xHqqkZx_
			BOOL bScrollTo,							// _xZkqqHx_iDhNiBfLiDeKiBfLjFfMiOkGjBmOiPnLiCpAiBeBiMlLiNnNiCmMjFfMiOkGiCmGiClFiCmEjAnNjCoIiClHiCoJiCkJiBeI_xHqqkZx_
			const WStringVector* vProjectPath,
			const longVector* vDocumentId)
{
	TRACE(_T("CFCWndHistoryTree::SyncToDocument\n"));

	//
	// 1._xZkqqHx_iCnMiClIiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCkKiMlLiNnNiCmMjAnNjCoIiCmGiInJiCmIiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	// 2._xZkqqHx_iInJiCmIiCoJiPoKiNiHiCmNiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCpAjAnNjCoIiBeCjDkPiOjOiCmJiClBiCoKiCnMiCmFjDmHiCnNiNjOiCpBiClOjHjKjHpAjFlGiPjBiPoOjFpBiCmNjEgKiKpMiClDiCoKiCoJiBeC_xHqqkZx_
	// 3._xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiNfIjAfGiCpAjClCiCnHiBeBiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNjAfGiClFiCkCiDhGiDiNiDfHiDeGiDeOiDgHiPoOjFpBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	// 4._xZkqqHx_jAfGiClFiCkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiPfNiCmBiCmEiBeBjFeLjHhGiCmIiDhEiDeAiDeDiDiLiCmMiNfIjAfGiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	// 5._xZkqqHx_jAfGiClFiCkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmGjFfMiOkGiImKjChFiCmMiPoOjFpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	// 

	if (g_pFileServer->IsFlushing())
	//----- _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmNiBeBiDiNiDgCiDeOiCoCiDhEiDeAiDeDiDiLiCmJiIoKjAnIiDfOiDgCiDgAiClFiCmIiCkC_xHqqkZx_
		// _xZkqqHx_iCoGiCkEiCmJiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiClNiCnPiBeBjGlDiMpIiCmFiClHiBeC_xHqqkZx_
		FFErrorBox(IDS_MSG_INVALID_IN_FLUSHING);
// 05.11.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		return;
		return FALSE;
	}

	// _xZkqqHx_jFfMiOkGiCkKjFmPiNfIiClDiCoKiClNiCkJiCmHiCkEiCkJiBeCjBeJjBpAiCmMjFmPiNfIjDjJiBeCiNmEjFgAiJoGiCkKjFeLjHhGiBeC_xHqqkZx_
	BOOL bIsViewChanged = FALSE;
	// _xZkqqHx_iDiMiDeDiDeBiDeFiDgHiCkKjFmPiNfIiClDiCoKiClNiCkJiCmHiCkEiCkJiBeCiDiMiDeDiDeBiDeFiDgHiNmEiMhGiOfKiCmGiNmEjFgAiJoGiCkKjFeLjHhGiBeC_xHqqkZx_
	BOOL bIsLayoutChanged = FALSE;

//----- 05.09.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhCiDiFiBfLiCmJjFfMiOkGiClHiCoJjHjKjHpAjFlGiPjBiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
	WString wstrSelectedProjectPath = GetSelectedProjectPath();
	// _xZkqqHx_iDhCiDiFiBfLiCmJjFfMiOkGiClHiCoJjHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
	long lSelectedDocumentId = GetSelectedDocumentId();
	flint fliSelectedSessionIndex = GetSelectedSessionIndex();
	FDTRClass clsSelectedObject = GetSelectedObject();
	long lSelectedObjectId = GetSelectedObjectId();
	if (bIsSelect)
	//----- _xZkqqHx_jBeJjBpAiImKjChFiCpAiOhHjCoIiImKjChFiCmJiNiHiCoNiClJiCoJiPoKiNiH_xHqqkZx_ -----
	{
		wstrSelectedProjectPath = wcpProjectPath;
		lSelectedDocumentId = lDocumentId;
		fliSelectedSessionIndex = fliSessionIndex;
		clsSelectedObject = FDTR_TRUNK_REC;
		lSelectedObjectId = -1;
	}

	// _xZkqqHx_iDhNiBfLiDeKiBfLjFfMiOkGjBmOiPnLiCmMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiBeC_xHqqkZx_
	WString wstrMarkedProjectPath = GetMarkedProjectPath();
	// _xZkqqHx_iDhNiBfLiDeKiBfLjFfMiOkGjBmOiPnLiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	long lMarkedDocumentId = GetMarkedDocumentId();
	// _xZkqqHx_iDhNiBfLiDeKiBfLjFfMiOkGjBmOiPnLiCmMjFlGiPjBiImKjChFiBeC_xHqqkZx_
	flint fliMarkedSessionIndex = GetMarkedSessionIndex();
	if (bIsMark)
	//----- _xZkqqHx_iDhNiBfLiDeKiBfLiImKjChFiCpAiOhHjCoIiImKjChFiCmJiNiHiCoNiClJiCoJiPoKiNiH_xHqqkZx_ -----
	{
		wstrMarkedProjectPath = wcpProjectPath;
		lMarkedDocumentId = lDocumentId;
		fliMarkedSessionIndex = fliSessionIndex;
	}
//----- 05.09.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	switch (GetViewMode())
	{
	case FDHT_VMODE_NONE:		// _xZkqqHx_jFfMiOkGiCmIiClFiBeCiPiJiKpKiOjOiCmJiCmNiClBiClBiCmJiBeC_xHqqkZx_
		if (wstrSelectedProjectPath.IsEmpty())
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFfMiOkGiCmIiClFiDiCiBfLiDgIiCnGiBeC_xHqqkZx_
			viewMode = FDHT_VMODE_NONE;
		} else
		if (lSelectedDocumentId == -1L)
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiCnNiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCnGiBeC_xHqqkZx_
			viewMode = FDHT_VMODE_PROJECT;
		} else
		//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiOhHjCoIiCmMiPoKiNiHiCmNjHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCnGiBeC_xHqqkZx_
			if (viewMode == FDHT_VMODE_NONE)
				viewMode = FDHT_VMODE_TREE;
		}
		break;
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		if (wstrSelectedProjectPath.IsEmpty())
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFfMiOkGiCmIiClFiDiCiBfLiDgIiCnGiBeC_xHqqkZx_
			viewMode = FDHT_VMODE_NONE;
		} else
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCnGiBeC_xHqqkZx_
			viewMode = FDHT_VMODE_PROJECT;
		}
		break;
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		if (wstrSelectedProjectPath.IsEmpty())
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFfMiOkGiCmIiClFiDiCiBfLiDgIiCnGiBeC_xHqqkZx_
			viewMode = FDHT_VMODE_NONE;
		} else
		if (lSelectedDocumentId == -1L)
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiCnNiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCnGiBeC_xHqqkZx_
			viewMode = FDHT_VMODE_PROJECT;
		} else
		//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiOhHjCoIiCmMiPoKiNiHiCmNjHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCnGiBeC_xHqqkZx_
			if (viewMode == FDHT_VMODE_NONE)
				viewMode = FDHT_VMODE_TREE;
		}
		break;
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		if (wstrSelectedProjectPath.IsEmpty())
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFfMiOkGiCmIiClFiDiCiBfLiDgIiCnGiBeC_xHqqkZx_
			viewMode = FDHT_VMODE_NONE;
		} else
		if (lSelectedDocumentId == -1L)
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiCnNiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCnGiBeC_xHqqkZx_
			viewMode = FDHT_VMODE_PROJECT;
		} else
		//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiOhHjCoIiCmMiPoKiNiHiCmNiMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCnGiBeC_xHqqkZx_
			if (viewMode == FDHT_VMODE_NONE)
				viewMode = FDHT_VMODE_BRANCH;
		}
		break;
	}

	WStringVector vCheckProjectPath;
	longVector vCheckDocumentId;
	if (vProjectPath != NULL)
		vCheckProjectPath = *vProjectPath;
	if (vDocumentId != NULL)
		vCheckDocumentId = *vDocumentId;
	vCheckProjectPath.push_back(wstrMarkedProjectPath);
	vCheckDocumentId.push_back(lMarkedDocumentId);

	// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIjAnNjCoIiBeC_xHqqkZx_
	// _xZkqqHx_iMlLiNnNjAnNjCoIjCiGiCmMjFlGiPjBiBeBiDhNiBfLiDeOjCiGiCmMjFlGiPjBiCoAiNfIjAfGiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iMlLiNnNiImKjChFiCmGiIoBiCkEjFlGiPjBiCmJjFkKiKpCiDfOiDePiCpAjAnNjChFiClHiCoJiPoKiNiHiCmIiCmHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJjFlGiPjBiCoAiNfIjAfGiCpAiDgAiDeGiDgCiDeOiClFiCmEiCkIiCkJiCmIiCkCiCmG_xHqqkZx_
	// _xZkqqHx_iNfIjAfGiCkKjElNiJgGiClDiCoKiCmIiCkCiBeC_xHqqkZx_
	if (!SetViewMode(	bIsViewChanged,
						bIsLayoutChanged,
						viewMode,
						wstrSelectedProjectPath,
						lSelectedDocumentId,
						fliSelectedSessionIndex,
						clsSelectedObject,
						lSelectedObjectId,
						vCheckProjectPath,
						vCheckDocumentId))
		return FALSE;

	if (bIsFitHtreeViewZoom)
	//----- _xZkqqHx_iJoGjGmKiDfEiDeDiDfJiCmJiDfJiBfLiDiAiCpAiDhEiDeCiDgCiDgHiClDiClJiCoJiOhHjCoIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfJiBfLiDiAiCpAiNmEjAnNjCoIiBeCiClBiCoKiCmJiCoGiCmBiCmEiDiMiDeDiDeBiDeFiDgHiCoAiNmEiMhGiOfKiClDiCoKiCoJiBeC_xHqqkZx_
		SetZoom(-1.0);
	} else
	if (bIsLayoutChanged)
	//----- _xZkqqHx_iDiMiDeDiDeBiDeFiDgHiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfJiBfLiDiAiCpAiNmEjAnNjCoIiBeCiClBiCoKiCmJiCoGiCmBiCmEiDiMiDeDiDeBiDeFiDgHiCoAiNmEiMhGiOfKiClDiCoKiCoJiBeC_xHqqkZx_
		SetZoom(GetZoom());
	} else
	if (bIsViewChanged)
	//----- _xZkqqHx_jFfMiOkGiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		RedrawWindow();
	}

	if (GetViewMode() != FDHT_VMODE_NONE)
	//----- _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMlLiNnNiImKjChFiDhNiBfLiDeOiCpAjFfMiOkGiBeCjFeLjHhGiCmIiCoHiClLiClBiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		UpdateCurrent(	bScrollTo,
						wstrMarkedProjectPath,
						lMarkedDocumentId,
						fliMarkedSessionIndex);
	} else
	{
		// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jGhLjBmMiCmFiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmGiMlLiNnN_xHqqkZx_ _xZkqqHx_jGhLjBmMiCmFiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMiImKjChFiCpAiNfIjAfGiBeC_xHqqkZx_
		// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAjFmCiClGiCmEiCkCiCoJiPoKiNiHiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCpAjFmCiClGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_
		// _xZkqqHx_iCmFiCkAiCmBiCmEiCoAiBeBiPiJiKpKjCgMiCkKjBoDjDpMiClDiCoKiCoJiBeC_xHqqkZx_
		m_wstrCurMarkedProjectPath = wstrMarkedProjectPath;
		m_lCurMarkedDocumentId = lMarkedDocumentId;
		m_fliCurMarkedSessionIndex = fliMarkedSessionIndex;
	}

//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// 05.11.18 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	return TRUE;
} // CFCWndHistoryTree::SyncToDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetFontZoom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDfJiBfLiDiAjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAjCgMiCpAjFnEiClHiBeC_xHqqkZx_(0.0, 1.0]
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDfEiDeDiDfJiCmMiCnNjFmPiNfIiClHiCoJiBeCjHjKjHpAiCmMiDhLiDgCiDeOiDfIjDjJiCmNiBeBiDhEiDeIiDjDiDgHiDfEiDeDiDfJ_xHqqkZx_
 *			_xZkqqHx_iCpAiMlDiCmJiDfEiDeDiDfJiCkKiMiIjCoIiClDiCoKiCmEiCkCiCoJiCmMiCmFiBeBiClBiCoKiCoHiCmMiDfEiDeDiDfJiCoAjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double CFCWndHistoryTree::GetFontZoom () const
{
	return m_pHtreeManager->GetFontZoom();
} // CFCWndHistoryTree::GetFontZoom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetFontZoom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDfJiBfLiDiAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dZoom	:_xZkqqHx_iDfJiBfLiDiAjCgMiCpAiOhHjCoIiBeC_xHqqkZx_(0.0, 1.0]
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDfEiDeDiDfJiCmMiCnNjFmPiNfIiClHiCoJiBeCjHjKjHpAiCmMiDhLiDgCiDeOiDfIjDjJiCmNiBeBiDhEiDeIiDjDiDgHiDfEiDeDiDfJ_xHqqkZx_
 *			_xZkqqHx_iCpAiMlDiCmJiDfEiDeDiDfJiCkKiMiIjCoIiClDiCoKiCmEiCkCiCoJiCmMiCmFiBeBiClBiCoKiCoHiCmMiDfEiDeDiDfJiCoAjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::SetFontZoom (double dZoom)
{
	if (g_pFileServer->IsFlushing())
	//----- _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmNiBeBiDiNiDgCiDeOiCoCiDhEiDeAiDeDiDiLiCmJiIoKjAnIiDfOiDgCiDgAiClFiCmIiCkC_xHqqkZx_
		// _xZkqqHx_iCoGiCkEiCmJiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiClNiCnPiBeBjGlDiMpIiCmFiClHiBeC_xHqqkZx_
		FFErrorBox(IDS_MSG_INVALID_IN_FLUSHING);
		return;
	}

	m_pHtreeManager->SetFontZoom(dZoom);
	// _xZkqqHx_iDfJiBfLiDiAiCpAiNmEjAnNjCoIiBeCiClBiCoKiCmJiCoGiCmBiCmEiDiMiDeDiDeBiDeFiDgHiCoAiNmEiMhGiOfKiClDiCoKiCoJiBeC_xHqqkZx_
	SetZoom(GetZoom());
} // CFCWndHistoryTree::SetFontZoom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::ChangeViewMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhCiDiFiBfLiDiCiBfLiDgIiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	viewMode	:_xZkqqHx_iDhCiDiFiBfLiDiCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMjFfMiOkGjBmOiPnLiBeBjBeJjBpAiPpDjBnEiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiNfIjAfGiCpAiDgAiDeGiDgCiDeOiClFiBeBjFmPiNfIiCkKiCkAiCoJiPoKiNiHiCmNiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::ChangeViewMode (FTHTViewMode viewMode)
{
	if (g_pFileServer->IsFlushing())
	//----- _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmNiBeBiDiNiDgCiDeOiCoCiDhEiDeAiDeDiDiLiCmJiIoKjAnIiDfOiDgCiDgAiClFiCmIiCkC_xHqqkZx_
		// _xZkqqHx_iCoGiCkEiCmJiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiClNiCnPiBeBjGlDiMpIiCmFiClHiBeC_xHqqkZx_
		FFErrorBox(IDS_MSG_INVALID_IN_FLUSHING);
		return FALSE;
	}

	if (viewMode == GetViewMode()) return TRUE;
	if (!CanChangeViewMode(viewMode)) return TRUE;
	BOOL bIsViewChanged = FALSE;
	BOOL bIsLayoutChanged = FALSE;
	if (!SetViewMode(bIsViewChanged,
					bIsLayoutChanged,
					viewMode,
					GetSelectedProjectPath(),
					GetSelectedDocumentId(),
					GetSelectedSessionIndex(),
					GetSelectedObject(),
					GetSelectedObjectId(),
					WStringVector(1, GetMarkedProjectPath()),
					longVector(1, GetMarkedDocumentId())))
		return FALSE;
//----- 05.08.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFfMiOkGiCkKjFmPiNfIiClDiCoKiClNiCkJiCmMiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//	if (CheckFileUpdatedAndViewMode(GetSelectedProjectPath(), GetSelectedDocumentId(),
//									m_wstrCurMarkedProjectPath, m_lCurMarkedDocumentId))
//	{
//		bIsViewChanged = TRUE;
//		bIsLayoutChanged = TRUE;
//	}
//----- 05.08.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	if (bIsLayoutChanged)
		SetZoom(GetZoom());	// _xZkqqHx_iDfJiBfLiDiAiCpAiNmEjAnNjCoIiBeCiClBiCoKiCmJiCoGiCmBiCmEiDiMiDeDiDeBiDeFiDgHiCoAiNmEiMhGiOfKiClDiCoKiCoJiBeC_xHqqkZx_
	else
	if (bIsViewChanged)
		RedrawWindow();
	// _xZkqqHx_iMlLiNnNiImKjChFiDhNiBfLiDeOiCpAjFfMiOkGiBeCiClLiClBiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
	UpdateCurrent(TRUE);
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return TRUE;
} // CFCWndHistoryTree::ChangeViewMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::CanChangeViewMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhCiDiFiBfLiDiCiBfLiDgIiCmJiInKjDkOiCmFiCkLiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	viewMode	:_xZkqqHx_iDhCiDiFiBfLiDiCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::CanChangeViewMode (FTHTViewMode viewMode) const
{
	// _xZkqqHx_jGlDiClFiDiCiBfLiDgIiBeC_xHqqkZx_
	if (viewMode == FDHT_VMODE_NONE) return TRUE;
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCmIiCkCiCmIiCoHiCmOiInKjDkOjFhDiJmCiBeC_xHqqkZx_
	if (!m_pHtreeManager->IsProjectOpened()) return FALSE;
	switch (viewMode)
	{
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		return TRUE;
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		// _xZkqqHx_jHjKjHpAjFlGiPjBiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiCmIiCoHiCmOiInKjDkOiJmCiBeC_xHqqkZx_
		if (GetSelectedDocumentId() != -1L) return TRUE;
		break;
	}
	return FALSE;
} // CFCWndHistoryTree::CanChangeViewMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetUpperViewMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPoDiImKiCmMiDhCiDiFiBfLiDiCiBfLiDgIiCnGiInKjDkOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::SetUpperViewMode ()
{
	if (g_pFileServer->IsFlushing())
	//----- _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmNiBeBiDiNiDgCiDeOiCoCiDhEiDeAiDeDiDiLiCmJiIoKjAnIiDfOiDgCiDgAiClFiCmIiCkC_xHqqkZx_
		// _xZkqqHx_iCoGiCkEiCmJiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiClNiCnPiBeBjGlDiMpIiCmFiClHiBeC_xHqqkZx_
		FFErrorBox(IDS_MSG_INVALID_IN_FLUSHING);
		return FALSE;
	}

	BOOL bIsViewChanged = FALSE;
	BOOL bIsLayoutChanged = FALSE;
	switch (GetViewMode())
	{
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	{
		if (!SetViewMode(bIsViewChanged,
						bIsLayoutChanged,
						FDHT_VMODE_PROJECT,
						GetSelectedProjectPath(),
						GetSelectedDocumentId(),
						GetSelectedSessionIndex(),
						GetSelectedObject(),
						GetSelectedObjectId(),
						WStringVector(1, GetMarkedProjectPath()),
						longVector(1, GetMarkedDocumentId())))
			return FALSE;
		break;
	}
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	{
		if (!SetViewMode(bIsViewChanged,
						bIsLayoutChanged,
						FDHT_VMODE_TREE,
						GetSelectedProjectPath(),
						GetSelectedDocumentId(),
						GetSelectedSessionIndex(),
						GetSelectedObject(),
						GetSelectedObjectId(),
						WStringVector(1, GetMarkedProjectPath()),
						longVector(1, GetMarkedDocumentId())))
			return FALSE;
		break;
	}
	default:
		ASSERT(FALSE);
		return FALSE;
	}
//----- 05.08.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFfMiOkGiCkKjFmPiNfIiClDiCoKiClNiCkJiCmMiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//	if (CheckFileUpdatedAndViewMode(GetSelectedProjectPath(), GetSelectedDocumentId(),
//									m_wstrCurMarkedProjectPath, m_lCurMarkedDocumentId))
//	{
//		bIsViewChanged = TRUE;
//		bIsLayoutChanged = TRUE;
//	}
//----- 05.08.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	if (bIsLayoutChanged)
		SetZoom(GetZoom());	// _xZkqqHx_iDfJiBfLiDiAiCpAiNmEjAnNjCoIiBeCiClBiCoKiCmJiCoGiCmBiCmEiDiMiDeDiDeBiDeFiDgHiCoAiNmEiMhGiOfKiClDiCoKiCoJiBeC_xHqqkZx_
	else
	if (bIsViewChanged)
		RedrawWindow();
	// _xZkqqHx_iMlLiNnNiImKjChFiDhNiBfLiDeOiCpAjFfMiOkGiBeCiClLiClBiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
	UpdateCurrent(TRUE);
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return TRUE;
} // CFCWndHistoryTree::SetUpperViewMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::CanUpperViewMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPoDiImKiCmMiDhCiDiFiBfLiDiCiBfLiDgIiCnGiInKjDkOiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::CanUpperViewMode ()
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCmIiCkCiCmIiCoHiCmOiInKjDkOjFhDiJmCiBeC_xHqqkZx_
	if (!m_pHtreeManager->IsProjectOpened()) return FALSE;
	return (GetViewMode() != FDHT_VMODE_NONE &&
			GetViewMode() != FDHT_VMODE_PROJECT);
} // CFCWndHistoryTree::CanUpperViewMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetLowerViewMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlKiImKiCmMiDhCiDiFiBfLiDiCiBfLiDgIiCnGiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::SetLowerViewMode ()
{
	if (g_pFileServer->IsFlushing())
	//----- _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmNiBeBiDiNiDgCiDeOiCoCiDhEiDeAiDeDiDiLiCmJiIoKjAnIiDfOiDgCiDgAiClFiCmIiCkC_xHqqkZx_
		// _xZkqqHx_iCoGiCkEiCmJiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiClNiCnPiBeBjGlDiMpIiCmFiClHiBeC_xHqqkZx_
		FFErrorBox(IDS_MSG_INVALID_IN_FLUSHING);
		return FALSE;
	}

	BOOL bIsViewChanged = FALSE;
	BOOL bIsLayoutChanged = FALSE;
	switch (GetViewMode())
	{
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	{
		if (!SetViewMode(bIsViewChanged,
						bIsLayoutChanged,
						FDHT_VMODE_TREE,
						GetSelectedProjectPath(),
						GetSelectedDocumentId(),
						GetSelectedSessionIndex(),
						GetSelectedObject(),
						GetSelectedObjectId(),
						WStringVector(1, GetMarkedProjectPath()),
						longVector(1, GetMarkedDocumentId())))
			return FALSE;
		break;
	}
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	{
		if (!SetViewMode(bIsViewChanged,
						bIsLayoutChanged,
						FDHT_VMODE_BRANCH,
						GetSelectedProjectPath(),
						GetSelectedDocumentId(),
						GetSelectedSessionIndex(),
						GetSelectedObject(),
						GetSelectedObjectId(),
						WStringVector(1, GetMarkedProjectPath()),
						longVector(1, GetMarkedDocumentId())))
			return FALSE;
		break;
	}
	default:
		ASSERT(FALSE);
	}
//----- 05.08.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jFfMiOkGiCkKjFmPiNfIiClDiCoKiClNiCkJiCmMiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//	if (CheckFileUpdatedAndViewMode(GetSelectedProjectPath(), GetSelectedDocumentId(),
//									m_wstrCurMarkedProjectPath, m_lCurMarkedDocumentId))
//	{
//		bIsViewChanged = TRUE;
//		bIsLayoutChanged = TRUE;
//	}
//----- 05.08.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	if (bIsLayoutChanged)
		SetZoom(GetZoom());	// _xZkqqHx_iDfJiBfLiDiAiCpAiNmEjAnNjCoIiBeCiClBiCoKiCmJiCoGiCmBiCmEiDiMiDeDiDeBiDeFiDgHiCoAiNmEiMhGiOfKiClDiCoKiCoJiBeC_xHqqkZx_
	else
	if (bIsViewChanged)
		RedrawWindow();
	// _xZkqqHx_iMlLiNnNiImKjChFiDhNiBfLiDeOiCpAjFfMiOkGiBeCiClLiClBiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
	UpdateCurrent(TRUE);
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return TRUE;
} // CFCWndHistoryTree::SetLowerViewMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::CanLowerViewMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlKiImKiCmMiDhCiDiFiBfLiDiCiBfLiDgIiCnGiInKjDkOiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::CanLowerViewMode ()
{
	switch (GetViewMode())
	{
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		// _xZkqqHx_jHjKjHpAjFlGiPjBiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiCmIiCoHiCmOiInKjDkOiJmCiBeC_xHqqkZx_
		if (GetSelectedDocumentId() != -1L) return TRUE;
		break;
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		return TRUE;
	}
	return FALSE;
//----- 04.01.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCWndHistoryTree::CanLowerViewMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetTempMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlMjAnNjHjKjHpAjFkKiKpCiCpAjAnNjCoIiClFiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJjFfMiOkGiClDiClJiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClDiCoKiClNiJlMjAnNjHjKjHpAjFkKiKpCiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nForkOrLabel	:_xZkqqHx_iJlMjAnNjHjKjHpAjFkKiKpCiCmMiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeB_xHqqkZx_
 *							 _xZkqqHx_iJlMjAnNjHjKjHpAjFkKiKpCiDfOiDePiCmMiPoKiNiHiCmN_xHqqkZx_ 1 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpProjectPath	:_xZkqqHx_jFkKiKpCiMlDiCmMiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_NULL _xZkqqHx_iCpA_xHqqkZx_
 *							 _xZkqqHx_iOhHjCoIiClFiCmEiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *			lDocumentId		:_xZkqqHx_jFkKiKpCiMlDiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_jFkKiKpCiMlDiCmMjHjKjHpAjFlGiPjBiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::SetTempMark (short nForkOrLabel,
									const wchar_t* wcpProjectPath,
									long lDocumentId,
									flint fliSessionIndex)
{
#ifdef _DEBUG
	if (wcpProjectPath == NULL || wcpProjectPath[0] == L'\0')
		ASSERT(!m_wstrTempMarkProjectPath.IsEmpty());
	if (wcpProjectPath != NULL && wcpProjectPath[0] != L'\0')
		ASSERT(m_wstrTempMarkProjectPath.IsEmpty());
#endif//_DEBUG

	KillTimer(FDTIMER_HTREE_TEMP_MARK_BLINK);
	// _xZkqqHx_iJlMjAnNiDhNiBfLiDeOiCmMiLoJiMgAiCpAiOoGjDlOiBeC_xHqqkZx_
	CPoint pt;
	CRect rtTempMark;
	if (GetTempMarkRect(pt, rtTempMark))
	//----- _xZkqqHx_iJlMjAnNiDhNiBfLiDeOiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAnNjCoIiCpAiJpAiPjMiBeCiPmBiLiOiNmEjFgAiJoGiOjOiCmJjFgAiJoGiClDiCoKiCmIiCkCiCoGiCkEiCmJiClHiCoJiClNiCnPiBeC_xHqqkZx_
		m_nTempMarkOrLabel = -1;
		m_wstrTempMarkProjectPath.Empty();
		m_lTempMarkDocumentId = -1L;
		m_fliTempMarkSessionIndex = flint(-1);
		m_lTimerBlink = 0;

		// _xZkqqHx_iNmEjFgAiJoGjHmMiIoGiCpAiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiClFiCmEiNmEjFgAiJoGiBeC_xHqqkZx_
		rtTempMark |= CRect(pt, pt + CSize(1,1));
		rtTempMark.InflateRect(4, 4);
		InvalidateRect(LPtoDP(rtTempMark));
		// _xZkqqHx_iNmEjFgAiJoGiBeC_xHqqkZx_
		UpdateWindow();
	}

	// _xZkqqHx_jAfGiClFiCkCjAnNjCoIiBeC_xHqqkZx_
	m_nTempMarkOrLabel = nForkOrLabel;
	m_wstrTempMarkProjectPath = wcpProjectPath;
	m_lTempMarkDocumentId = lDocumentId;
	m_fliTempMarkSessionIndex = fliSessionIndex;
	m_lTimerBlink = 0;

	switch (GetViewMode())
	{
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		// _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
		CClientDC dc(this);
		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDfIiDeOiDiNiBfLiDiLiImKjChFiCmFiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCmMiNmAjFfHjFoCjAlDiBeC_xHqqkZx_
		dc.SetWindowOrg(m_lgOffsetX, m_lgOffsetY);
		// _xZkqqHx_iJlMjAnNjFkKiKpCiCpAjFgAiJoGiBeC_xHqqkZx_
		if (DrawTempMarkMark(&dc))
			SetTimer(FDTIMER_HTREE_TEMP_MARK_BLINK, FD_WAIT_HTREE_TEMP_MARK_BLINK, NULL);
		break;
	  }
	}
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // CFCWndHistoryTree::SetTempMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetMarkUpHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCpAjAnNjCoIiClFiBeBjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJjFfMiOkGiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpProjectPath	:_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stDocId			:_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCmNjBfDiCmEjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJiDhNiBfLiDeOiClDiCoKiClNiPpDjBnEiCmF_xHqqkZx_
 *			_xZkqqHx_jFfMiOkGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::SetMarkUpHidocument (const wchar_t* wcpProjectPath,
											 const longSet& stDocId)
{
  do {
	KillTimer(FDTIMER_HTREE_MARK_UP_BLINK);
	if (wcpProjectPath == NULL ||
		wcscmp(m_pHtreeManager->GetProjectPath(), wcpProjectPath) != 0)
	//----- _xZkqqHx_iMlLiNnNiKeKiCkJiCoKiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCmGiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhNiBfLiDeOiDeBiDgCiDhGjHjKjHpAjFlGiPjBiCpAjBfDiCmEiNmEjFgAiJoGiBeC_xHqqkZx_
		RedrawMarkUpHidocument();
		// _xZkqqHx_iMlLiNnNiKeKiCkJiCoKiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCmGiInJiCmIiCoJiPoKiNiHiCmNiPiIjHjNiCpAiPeJjHlJiBeC_xHqqkZx_
		m_stMarkUpDocumentId.clear();
		break;
	}

	m_stMarkUpDocumentId = stDocId;
	m_lTimerBlink = 0;

	// _xZkqqHx_jAfGiClFiCkNjHjKjHpAjFlGiPjBiCkKjAnNjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBjDfPjGmFjHhAiDfOiDeDiDhNiBfLiCpAjAnNjCoIiBeC_xHqqkZx_
	if (!m_stMarkUpDocumentId.empty())
		SetTimer(FDTIMER_HTREE_MARK_UP_BLINK, FD_WAIT_HTREE_MARK_UP_BLINK, NULL);
  } while (FALSE);
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // CFCWndHistoryTree::SetMarkUpHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetZoom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double CFCWndHistoryTree::GetZoom () const
{
	return m_pHtreeManager->GetZoom(GetSelectedDocumentId());
} // CFCWndHistoryTree::GetZoom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::CanZoom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::CanZoom () const
{
	switch (GetViewMode())
	{
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		return IsWindowVisible();
	default:
		return FALSE;
	}
} // CFCWndHistoryTree::CanZoom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetZoomLimit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAiCmMiNmFjBoFjCgMiBeBiNmFiPkMjCgMiCpAiMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dZoomMin	:_xZkqqHx_iDfJiBfLiDiAiNmFiPkMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			dZoomMax	:_xZkqqHx_iDfJiBfLiDiAiNmFjBoFjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			dZoomFit	:_xZkqqHx_jDeLjDjGiCmIiDfJiBfLiDiAjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::GetZoomLimit (	double& dZoomMin,
										double& dZoomMax,
										double& dZoomFit)
{
//	AfxDebugBreak();
	switch (GetViewMode())
	{
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	{
		// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMiBeBiDgHiDgCiDhGiCmMjHjKjHpAiOhNiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		const long lTopDocId = m_pHtreeManager->SubDocumentIdToTopId(GetSelectedDocumentId());
		// _xZkqqHx_iDgHiDgCiDhGiCmMjHjKjHpAiOhNiCmMiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(lTopDocId);
		if (pRec == NULL) break;
		// _xZkqqHx_iDgHiDgCiDhGiCmMjHjKjHpAiOhNiCkJiCoHiJlKiCpAiMhGiOfKiBeC_xHqqkZx_
		CRect rect;
		GetClientRect(rect);
		pRec->GetZoomLimitTree(dZoomMin, dZoomMax, dZoomFit,
								rect.Height(), 0);
		break;
	}
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	{
		// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
		if (pRec == NULL) break;
		// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiOhNiCpAiMhGiOfKiBeC_xHqqkZx_
		CRect rect;
		GetClientRect(rect);
		pRec->GetZoomLimitBranch(dZoomMin, dZoomMax, dZoomFit,
								CSize(rect.Width(), rect.Height()));
		break;
	}
	default:
		dZoomMin = 1.0;
		dZoomMax = 1.0;
		dZoomFit = 1.0;
		break;
	}
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // CFCWndHistoryTree::GetZoomLimit.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetViewMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBlMiCmMiDeOiDiJiDfIiCkJiCoHiOgHiCkEiClNiCnPiCmJiNoMjAkMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTHTViewMode CFCWndHistoryTree::GetViewMode () const
{
	return m_pHtreeManager->GetViewMode();
} // CFCWndHistoryTree::GetViewMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetLastClickedProjectPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CFCWndHistoryTree::GetLastClickedProjectPath () const
{
	return m_wstrLastProjectPath;
} // CFCWndHistoryTree::GetLastClickedProjectPath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetLastClickedDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCWndHistoryTree::GetLastClickedDocumentId () const
{
	return m_lLastDocumentId;
} // CFCWndHistoryTree::GetLastClickedDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetLastClickedSessionIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNjHjKjHpAiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint CFCWndHistoryTree::GetLastClickedSessionIndex () const
{
	return m_fliLastSessionIndex;
} // CFCWndHistoryTree::GetLastClickedSessionIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetLastClickedObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiCmMiOoNjHnOiCpAjFnEiClH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiCmMiOoNjHnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDTRClass CFCWndHistoryTree::GetLastClickedObject () const
{
	return m_clsLastObject;
} // CFCWndHistoryTree::GetLastClickedObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetLastClickedObjectRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiCmMiDiMiDfCiBfLiDgIiCpAjFnEiClH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBePiJpBiDeOiDiKiDgCiDeOiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiCmMiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const void* CFCWndHistoryTree::GetLastClickedObjectRec () const
{
//----- 05.09.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (GetLastClickedProjectPath()[0] == L'\0') return NULL;
//	if (GetLastClickedDocumentId() == -1) return NULL;
//----- 05.09.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	switch (GetLastClickedObject())
	{
	case FDTR_LABEL_REC:		// _xZkqqHx_iDiJiDhIiDiLiBeC_xHqqkZx_
	  {
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetLastClickedDocumentId());
// 06.04.07 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		return pRec->GetHLabelBeginRec(m_lLastObjectId);
		return pRec->GetHiLabelRec(m_lLastObjectId);
	  }
	case FDTR_TIME_LABEL_REC:	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
	  {
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetLastClickedDocumentId());
		return pRec->GetTimeLabelRec(m_lLastObjectId);
	  }
	default:
		return NULL;
	}
} // CFCWndHistoryTree::GetLastClickedObjectRec.

//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetDefaultClickedPosition
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiBeBiIlNiCkCiCmNiMlLiNnNiDhNiBfLiDeOjFfMiOkGiClDiCoKiCmEiCkCiCoJiImKjChFiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *			lDocId			:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCWndHistoryTree::GetDefaultClickedPosition (WString& wstrProjectPath, long& lDocId, flint& fliSessionIndex) const
//{
//	if (GetLastClickedDocumentId() == -1)
//	//----- _xZkqqHx_iNmFiMoDiCmJjEhHiMgJiCpAiDeOiDiKiDgCiDeOiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		if (wcscmp(GetMarkedProjectPath(), GetSelectedProjectPath()) == 0 &&
//			GetMarkedDocumentId() == GetSelectedDocumentId())
//		//----- _xZkqqHx_iDhNiBfLiDeOjFfMiOkGjCiGiCmMjHjKjHpAjFlGiPjBiCmGjBeJjBpAjCiGjHjKjHpAjFlGiPjBiCkKiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDhNiBfLiDeOjFfMiOkGiCmMiImKjChFiCpAiOgHiCkEiBeC_xHqqkZx_
//			wstrProjectPath = GetMarkedProjectPath();
//			lDocId = GetMarkedDocumentId();
//			fliSessionIndex = GetMarkedSessionIndex();
//			return;
//		}
//	}
//	wstrProjectPath = GetLastClickedProjectPath();
//	lDocId = GetLastClickedDocumentId();
//	fliSessionIndex = GetLastClickedSessionIndex();
//} // CFCWndHistoryTree::GetDefaultClickedPosition.
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 04.11.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetDefaultClickedProjectPath
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiBeBiIlNiCkCiCmNiMlLiNnNiDhNiBfLiDeOjFfMiOkGiClDiCoKiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const wchar_t* CFCWndHistoryTree::GetDefaultClickedProjectPath () const
//{
//	if (GetLastClickedDocumentId() == -1)
//	//----- _xZkqqHx_iNmFiMoDiCmJjEhHiMgJiCpAiDeOiDiKiDgCiDeOiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		if (m_wstrCurMarkedProjectPath == GetSelectedProjectPath() &&
//			m_lCurMarkedDocumentId == GetSelectedDocumentId())
//		//----- _xZkqqHx_iDhNiBfLiDeOjFfMiOkGjCiGiCmMjHjKjHpAjFlGiPjBiCmGjBeJjBpAjCiGjHjKjHpAjFlGiPjBiCkKiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDhNiBfLiDeOjFfMiOkGiCmMiImKjChFiCpAiOgHiCkEiBeC_xHqqkZx_
//			return m_wstrCurMarkedProjectPath;
//		}
//	}
//	return GetLastClickedProjectPath();
//} // CFCWndHistoryTree::GetDefaultClickedProjectPath.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetDefaultClickedDocumentId
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiBeBiIlNiCkCiCmNiMlLiNnNiDhNiBfLiDeOjFfMiOkGiClDiCoKiCmEiCkCiCoJjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//long CFCWndHistoryTree::GetDefaultClickedDocumentId () const
//{
//	if (GetLastClickedDocumentId() == -1)
//	//----- _xZkqqHx_iNmFiMoDiCmJjEhHiMgJiCpAiDeOiDiKiDgCiDeOiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		if (m_wstrCurMarkedProjectPath == GetSelectedProjectPath() &&
//			m_lCurMarkedDocumentId == GetSelectedDocumentId())
//		//----- _xZkqqHx_iDhNiBfLiDeOjFfMiOkGjCiGiCmMjHjKjHpAjFlGiPjBiCmGjBeJjBpAjCiGjHjKjHpAjFlGiPjBiCkKiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDhNiBfLiDeOjFfMiOkGiCmMiImKjChFiCpAiOgHiCkEiBeC_xHqqkZx_
//			return m_lCurMarkedDocumentId;
//		}
//	}
//	return GetLastClickedDocumentId();
//} // CFCWndHistoryTree::GetDefaultClickedDocumentId.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetDefaultClickedSessionIndex
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiBeBiIlNiCkCiCmNiMlLiNnNiDhNiBfLiDeOjFfMiOkGiClDiCoKiCmEiCkCiCoJjHjKjHpAiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiImKjChFiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//flint CFCWndHistoryTree::GetDefaultClickedSessionIndex () const
//{
//	if (GetLastClickedDocumentId() == -1)
//	//----- _xZkqqHx_iNmFiMoDiCmJjEhHiMgJiCpAiDeOiDiKiDgCiDeOiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		if (m_wstrCurMarkedProjectPath == GetSelectedProjectPath() &&
//			m_lCurMarkedDocumentId == GetSelectedDocumentId())
//		//----- _xZkqqHx_iDhNiBfLiDeOjFfMiOkGjCiGiCmMjHjKjHpAjFlGiPjBiCmGjBeJjBpAjCiGjHjKjHpAjFlGiPjBiCkKiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDhNiBfLiDeOjFfMiOkGiCmMiImKjChFiCpAiOgHiCkEiBeC_xHqqkZx_
//			return m_fliCurMarkedSessionIndex;
//		}
//	}
//	return GetLastClickedSessionIndex();
//} // CFCWndHistoryTree::GetDefaultClickedSessionIndex.
//----- 04.11.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetMarkedProjectPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiDhNiBfLiDeOjFfMiOkGiClDiCoKiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CFCWndHistoryTree::GetMarkedProjectPath () const
{
	return m_wstrCurMarkedProjectPath;
} // CFCWndHistoryTree::GetMarkedProjectPath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetMarkedDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiDhNiBfLiDeOjFfMiOkGiClDiCoKiCmEiCkCiCoJjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCWndHistoryTree::GetMarkedDocumentId () const
{
	return m_lCurMarkedDocumentId;
} // CFCWndHistoryTree::GetMarkedDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetMarkedSessionIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiDhNiBfLiDeOjFfMiOkGiClDiCoKiCmEiCkCiCoJjHjKjHpAiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint CFCWndHistoryTree::GetMarkedSessionIndex () const
{
	return m_fliCurMarkedSessionIndex;
} // CFCWndHistoryTree::GetMarkedSessionIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::IsProjectSelected
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iKePiMpMiCkPiCmMiKnGjAjEiCmFiCkAiCoIiBeB_xHqqkZx_GetSelectedDocumentId_xZkqqHx_iKnGjAjEiCoC_xHqqkZx_
 *			GetSelectedObject_xZkqqHx_iKnGjAjEiCmGjFnEiClHjCgMiCkKiInJiCmIiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::IsProjectSelected (WString* wstrProjectPath) const
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (!IsSelectedProjectOpened()) return FALSE;
	// _xZkqqHx_jFlGiPjBiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoKiCmO_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (GetSelectedDocumentId() != -1) return FALSE;
	if (wstrProjectPath != NULL)
		*wstrProjectPath = GetSelectedProjectPath();
	return TRUE;
} // CFCWndHistoryTree::IsProjectSelected.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::IsDocumentSelected
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocumentId		:_xZkqqHx_jHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iKePiMpMiCkPiCmMiKnGjAjEiCmFiCkAiCoIiBeB_xHqqkZx_GetSelectedDocumentId_xZkqqHx_iKnGjAjEiCoC_xHqqkZx_
 *			GetSelectedObject_xZkqqHx_iKnGjAjEiCmGjFnEiClHjCgMiCkKiInJiCmIiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::IsDocumentSelected (WString* wstrProjectPath,
											long* lDocumentId,
											flint* fliSessionIndex) const
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (!IsSelectedProjectOpened()) return FALSE;
	// _xZkqqHx_jFlGiPjBiCkKiKeKiCkCiCmEiCkCiCmIiCkPiCoKiCmO_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (GetSelectedDocumentId() == -1) return FALSE;

	long lSelectedDocumentId = GetSelectedDocumentId();
	flint fliSelectedSessionIndex = GetSelectedSessionIndex();
	switch (GetSelectedObject())
	{
	case FDTR_NONE_REC:			// _xZkqqHx_jGlDiClFiBeC_xHqqkZx_
	case FDTR_LABEL_REC:		// _xZkqqHx_iDiJiDhIiDiLiBeC_xHqqkZx_
	case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
	case FDTR_TIME_LABEL_REC:	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
		return FALSE;
	case FDTR_HTREE_REC:		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
		lSelectedDocumentId = GetSelectedObjectId();
		fliSelectedSessionIndex = -1;
		break;
	case FDTR_TRUNK_REC:		// _xZkqqHx_iKlCiDgNiBfLiDgIiBeC_xHqqkZx_FCHLabelHtreeRec _xZkqqHx_iCmFiCmNiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
		break;
	default:
		FFThrowMiscUnknown();
	}
	if (wstrProjectPath != NULL)
		*wstrProjectPath = GetSelectedProjectPath();
	if (lDocumentId != NULL)
		*lDocumentId = lSelectedDocumentId;
	if (fliSessionIndex != NULL)
		*fliSessionIndex = fliSelectedSessionIndex;
	return TRUE;
} // CFCWndHistoryTree::IsDocumentSelected.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::IsHiTagSelected
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDfOiDePiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocumentId		:_xZkqqHx_jHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDfOiDePiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iKePiMpMiCkPiCmMiKnGjAjEiCmFiCkAiCoIiBeB_xHqqkZx_GetSelectedDocumentId_xZkqqHx_iKnGjAjEiCoC_xHqqkZx_
 *			GetSelectedObject_xZkqqHx_iKnGjAjEiCmGjFnEiClHjCgMiCkKiInJiCmIiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::IsHiTagSelected (	WString* wstrProjectPath,
											long* lDocumentId,
											flint* fliSessionIndex,
											FCHiForkTagRec* hiForkTagRec) const
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (!IsSelectedProjectOpened()) return FALSE;
	// _xZkqqHx_jFlGiPjBiCkKiKeKiCkCiCmEiCkCiCmIiCkPiCoKiCmO_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (GetSelectedDocumentId() == -1) return FALSE;

	switch (GetSelectedObject())
	{
	case FDTR_NONE_REC:			// _xZkqqHx_jGlDiClFiBeC_xHqqkZx_
	case FDTR_LABEL_REC:		// _xZkqqHx_iDiJiDhIiDiLiBeC_xHqqkZx_
	case FDTR_TIME_LABEL_REC:	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
	case FDTR_HTREE_REC:		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
	case FDTR_TRUNK_REC:		// _xZkqqHx_iKlCiDgNiBfLiDgIiBeC_xHqqkZx_FCHLabelHtreeRec _xZkqqHx_iCmFiCmNiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
		return FALSE;
	case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
		break;
	default:
		FFThrowMiscUnknown();
	}
	if (wstrProjectPath != NULL)
		*wstrProjectPath = GetSelectedProjectPath();
	if (lDocumentId != NULL)
		*lDocumentId = GetSelectedDocumentId();
	if (fliSessionIndex != NULL)
		*fliSessionIndex = GetSelectedSessionIndex();
	if (hiForkTagRec != NULL)
	{
		// _xZkqqHx_iDiJiDhIiDiLiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
		*hiForkTagRec = *pRec->GetHiForkTagRec(GetSelectedObjectId());
	}
	return TRUE;
} // CFCWndHistoryTree::IsHiTagSelected.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::IsTimeLabelSelected
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocumentId		:_xZkqqHx_jHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			timeLabelRec	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iKePiMpMiCkPiCmMiKnGjAjEiCmFiCkAiCoIiBeB_xHqqkZx_GetSelectedDocumentId_xZkqqHx_iKnGjAjEiCoC_xHqqkZx_
 *			GetSelectedObject_xZkqqHx_iKnGjAjEiCmGjFnEiClHjCgMiCkKiInJiCmIiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::IsTimeLabelSelected (	WString* wstrProjectPath,
												long* lDocumentId,
												flint* fliSessionIndex,
												FCTimeLabelRec* timeLabelRec) const
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (!IsSelectedProjectOpened()) return FALSE;
	// _xZkqqHx_jFlGiPjBiCkKiKeKiCkCiCmEiCkCiCmIiCkPiCoKiCmO_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (GetSelectedDocumentId() == -1) return FALSE;

	switch (GetSelectedObject())
	{
	case FDTR_NONE_REC:			// _xZkqqHx_jGlDiClFiBeC_xHqqkZx_
	case FDTR_LABEL_REC:		// _xZkqqHx_iDiJiDhIiDiLiBeC_xHqqkZx_
	case FDTR_HTREE_REC:		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
	case FDTR_TRUNK_REC:		// _xZkqqHx_iKlCiDgNiBfLiDgIiBeC_xHqqkZx_FCHLabelHtreeRec _xZkqqHx_iCmFiCmNiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
	case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
		return FALSE;
	case FDTR_TIME_LABEL_REC:	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
		break;
	default:
		FFThrowMiscUnknown();
	}
	if (wstrProjectPath != NULL)
		*wstrProjectPath = GetSelectedProjectPath();
	if (lDocumentId != NULL)
		*lDocumentId = GetSelectedDocumentId();
	if (fliSessionIndex != NULL)
		*fliSessionIndex = GetSelectedSessionIndex();
	if (timeLabelRec != NULL)
	{
		// _xZkqqHx_iDiJiDhIiDiLiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
		*timeLabelRec = *pRec->GetTimeLabelRec(GetSelectedObjectId());
	}
	return TRUE;
} // CFCWndHistoryTree::IsTimeLabelSelected.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::IsSelectedProjectOpened
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCkKiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::IsSelectedProjectOpened () const
{
	return m_pHtreeManager->IsProjectOpened();
} // CFCWndHistoryTree::IsSelectedProjectOpened.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::IsThereFork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiImKjChFiCmJjHjKjHpAjFkKiKpCiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocumentId		:_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::IsThereFork (	const wchar_t* wcpProjectPath,
										long lDocumentId,
										flint fliSessionIndex)
{
	BOOL bFound = FALSE;
do {
	// _xZkqqHx_iKeKiCkCiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCkKiInJiCmIiCoJiPoKiNiHiCmNjClCiCnHiCoJiClBiCmGiCkKiPgPjHiIiCmIiCkCiBeCjGlDjDoPiCmJ_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (!IsSelectedProjectOpened() ||
		wcscmp(GetSelectedProjectPath(), wcpProjectPath) != 0)
		break;
	// _xZkqqHx_jHjKjHpAiCmMiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(lDocumentId);
	// _xZkqqHx_iOhHjCoIiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmGjDkPiClGjEmNiImNiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	pair<FTSessionToNodeMmap::const_iterator, FTSessionToNodeMmap::const_iterator> range =
		pRec->GetSessionToNodeMmap().equal_range(fliSessionIndex);
	FTSessionToNodeMmap::const_iterator iN;
	for (iN = range.first; !bFound && iN != range.second; iN++)
	{
		// _xZkqqHx_jHjKjHpAjGnIiDgNiBfLiDgIiCmMiPoKiNiHiBeC_xHqqkZx_
		if ((*iN).second.m_class == FDTR_HTREE_REC)
			bFound = TRUE;
	}
} while (FALSE);
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return bFound;
} // CFCWndHistoryTree::IsThereFork.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::IsThereHiForkTag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiImKjChFiCmJjHjKjHpAjFkKiKpCiDfOiDePiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocumentId		:_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::IsThereHiForkTag (	const wchar_t* wcpProjectPath,
											long lDocumentId,
											flint fliSessionIndex)
{
	BOOL bFound = FALSE;
do {
	// _xZkqqHx_iKeKiCkCiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCkKiInJiCmIiCoJiPoKiNiHiCmNjClCiCnHiCoJiClBiCmGiCkKiPgPjHiIiCmIiCkCiBeCjGlDjDoPiCmJ_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (!IsSelectedProjectOpened() ||
		wcscmp(GetSelectedProjectPath(), wcpProjectPath) != 0)
		break;
	// _xZkqqHx_jHjKjHpAiCmMiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(lDocumentId);
	// _xZkqqHx_iOhHjCoIiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmGjDkPiClGjEmNiImNiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	pair<FTSessionToNodeMmap::const_iterator, FTSessionToNodeMmap::const_iterator> range =
		pRec->GetSessionToNodeMmap().equal_range(fliSessionIndex);
	FTSessionToNodeMmap::const_iterator iN;
	for (iN = range.first; !bFound && iN != range.second; iN++)
	{
		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiPoKiNiHiBeC_xHqqkZx_
		if ((*iN).second.m_class == FDTR_HI_FORK_TAG_REC)
			bFound = TRUE;
	}
} while (FALSE);
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return bFound;
} // CFCWndHistoryTree::IsThereHiForkTag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetSelectedProjectPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjFfMiOkGiClDiCoKiCmEiCkCiCoJjHjKjHpAjFlGiPjBiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString CFCWndHistoryTree::GetSelectedProjectPath () const
{
	return m_pHtreeManager->GetProjectPath();
} // CFCWndHistoryTree::GetSelectedProjectPath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetSelectedDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjFfMiOkGiClDiCoKiCmEiCkCiCoJjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCWndHistoryTree::GetSelectedDocumentId () const
{
	return m_lSelectedDocumentId;
} // CFCWndHistoryTree::GetSelectedDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::IsSelectedProjectUnknownFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjFfMiOkGiClDiCoKiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCkKjGkCjFnLjBlGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGkCjFnLjBlGiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::IsSelectedProjectUnknownFile () const
{
	return m_pHtreeManager->IsProjectUnknownFile();
} // CFCWndHistoryTree::IsSelectedProjectUnknownFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetSelectedSessionIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjFfMiOkGiClDiCoKiCmEiCkCiCoJjHjKjHpAiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint CFCWndHistoryTree::GetSelectedSessionIndex () const
{
	return m_fliSelectedSessionIndex;
} // CFCWndHistoryTree::GetSelectedSessionIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetSelectedObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjFfMiOkGiClDiCoKiCmEiCkCiCoJjHjKjHpAiDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDTRClass CFCWndHistoryTree::GetSelectedObject () const
{
	return m_clsSelectedObject;
} // CFCWndHistoryTree::GetSelectedObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetSelectedObjectId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjFfMiOkGiClDiCoKiCmEiCkCiCoJjHjKjHpAiDeJiDhFiDfHiDeGiDeOiDgHiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeJiDhFiDfHiDeGiDeOiDgHiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCWndHistoryTree::GetSelectedObjectId () const
{
	return m_lSelectedObjectId;
} // CFCWndHistoryTree::GetSelectedObjectId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetZoom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dZoom	:_xZkqqHx_iDfJiBfLiDiAjCgMiCpAiOhHjCoIiBeCiJoGjGmKiDfEiDeDiDfJiCmJiNiHiCoNiClJiCoJiPoKiNiHiCmNiBeB_xHqqkZx_-1.0_xZkqqHx_iCpA_xHqqkZx_
 *					 _xZkqqHx_iOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiClBiCmFiCmNiBeBiDfJiBfLiDiAjCgMiCmJjFmPiNfIiCmMjHeMiCoIjGlDiClFiCmJiKnGiMfHiCmIiCkNiBeBiNmEjFgAiJoGiCpA_xHqqkZx_
 *			_xZkqqHx_iNhDiCkEiBeCiDfJiBfLiDiAjCgMiCmMjAnNjCoIiCmNiBeBiNmEjFgAiJoGiCmMjBoDiCoNiCoIiCmJiCoAiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::SetZoom (double dZoom)
{
	// _xZkqqHx_iDfJiBfLiDiAiCmMiPoDiMmAiBeFiJlKiMmAiBeBiNmFjDeLjCgMiCpAiOfKiPgPiBeC_xHqqkZx_5
	double dZoomMin, dZoomMax, dZoomFit;
	GetZoomLimit(dZoomMin, dZoomMax, dZoomFit);
	// _xZkqqHx_iDfJiBfLiDiAjCgMiCkKjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	if (dZoom < 0.0) dZoom = dZoomFit;
	if (dZoom < dZoomMin) dZoom = dZoomMin;
	if (dZoomMax < dZoom) dZoom = dZoomMax;
	m_pHtreeManager->SetZoom(GetSelectedDocumentId(), dZoom);

	for (;;)
	{
		m_pHtreeManager->CalcLayout(GetSelectedDocumentId());
		if (m_pHtreeManager->GetMostRightBottom().y < 32000) break;
		m_pHtreeManager->SetZoom(GetSelectedDocumentId(), GetZoom() / 2.0);
	}

	// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiDgGiDgPiDeDiDfIiNmAjFfHiCmFjDlOiCoJiBeC_xHqqkZx_
	CRect dvrctClient;
	GetClientRect(&dvrctClient);
	// _xZkqqHx_iNmFiMoDiCmMiDeOiDiKiDgCiDeOiImKjChFiCkKjCiGjAfDiCmJjHiIiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiCmMiDeJiDhEiDfKiDgCiDgHiCpAiMhGiOfKiBjFjAnNjCoIiBeC_xHqqkZx_
	const CPoint ptLastPoint = GetLastPoint();
	m_lgOffsetX = ptLastPoint.x - dvrctClient.right / 2;
	m_lgOffsetY = ptLastPoint.y - dvrctClient.bottom / 2;
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmMiIoGiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateScrollSize();
	// _xZkqqHx_jBkGiOjOiBeBjBfDiJoGjGmKiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	Invalidate();
	UpdateWindow();
} // CFCWndHistoryTree::SetZoom.

//----- 05.08.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::CheckFileUpdatedAndViewMode
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiJlKiCmFiBeBiMlLiNnN_xHqqkZx_ _xZkqqHx_iOmAjBmMiCmMiCkAiCoJjBfDiCmEiCmM_xHqqkZx_FCHTreeRec_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmJ_xHqqkZx_
// *			_xZkqqHx_jBmOiClFiCmEiBeBjBmOiJjOiClHiCoJjHjKjHpAiDhEiDeAiDeDiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iNoNiPjMiClDiCoKiClNiDeJiDhFiDfHiDeGiDeOiDgHiCmNiBeBiOjPiCmMiOfBiPmGiOjOiCmJiOkJjDkOjDeJiCmJjDmHiCnNiNjOiCnMiCoKiCoJiClNiCnP_xHqqkZx_
// *			_xZkqqHx_jGoCjBoIiCmIiCkCiBeC_xHqqkZx_
// *			_xZkqqHx_iMlLiNnNiCmMjBeJjBpAjCiGiCmMjHjKjHpAjFlGiPjBiCkKiDhGiDiNiDfHiDeGiDeOiDgHiCmJjBlGiNnNiClHiCoJiCkJjClCiCnHiBeB_xHqqkZx_
// *			_xZkqqHx_jBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeBjBeJjBpAiCpAiJpAiPjMiClFiDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCnG_xHqqkZx_
// *			_xZkqqHx_iInKiNhDiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpProjectPath1		:_xZkqqHx_jClCiCnHiCoJiCnHiCkLjHjKjHpAjFlGiPjBiCfAiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocumentId1		:_xZkqqHx_jClCiCnHiCoJiCnHiCkLjHjKjHpAjFlGiPjBiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcpProjectPath2		:_xZkqqHx_jClCiCnHiCoJiCnHiCkLjHjKjHpAjFlGiPjBiCfBiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocumentId2		:_xZkqqHx_jClCiCnHiCoJiCnHiCkLjHjKjHpAjFlGiPjBiCfBiCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcpProjectPath3		:_xZkqqHx_jClCiCnHiCoJiCnHiCkLjHjKjHpAjFlGiPjBiCfCiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocumentId3		:_xZkqqHx_jClCiCnHiCoJiCnHiCkLjHjKjHpAjFlGiPjBiCfCiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCWndHistoryTree::CheckFileUpdatedAndViewMode (const wchar_t* wcpProjectPath1,
//													 long lDocumentId1,
//													 const wchar_t* wcpProjectPath2,
//													 long lDocumentId2,
//													 const wchar_t* wcpProjectPath3,
//													 long lDocumentId3)
//{
//	TRACE(_T("CFCWndHistoryTree::CheckFileUpdatedAndViewMode\n"));
//
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (!m_pHtreeManager->IsProjectOpened()) return FALSE;
//
//	longSet stDocumentId;
//	if (wcpProjectPath1 != NULL &&
//		wcscmp(GetSelectedProjectPath(), wcpProjectPath1) == 0 &&
//		lDocumentId1 != -1)
//		stDocumentId.insert(lDocumentId1);
//	if (wcpProjectPath2 != NULL &&
//		wcscmp(GetSelectedProjectPath(), wcpProjectPath2) == 0 &&
//		lDocumentId2 != -1)
//		stDocumentId.insert(lDocumentId2);
//	if (wcpProjectPath3 != NULL &&
//		wcscmp(GetSelectedProjectPath(), wcpProjectPath3) == 0 &&
//		lDocumentId3 != -1)
//		stDocumentId.insert(lDocumentId3);
//
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJiCkJiCmMiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//	// _xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBjAfGiClFiCkNjDmHiCnNiNjOiCnMiCoKiCoJiBeC_xHqqkZx_
//	if (m_pHtreeManager->CheckFileUpdated(stDocumentId))
//	//----- _xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jFfMiOkGiBgJjBeJjBpAiBgKjCiGiCmMjHjKjHpAjFlGiPjBiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiBeBjFfMiOkGiCpAjFmPiNfIiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
//		if (GetSelectedDocumentId() != -1 &&
//			m_pHtreeManager->GetDocRecExtData(GetSelectedDocumentId()) == NULL)
//		//----- _xZkqqHx_jFfMiOkGjCiGjHjKjHpAjFlGiPjBiCkKiDhGiDiNiDfHiDeGiDeOiDgHjCiGiCmJjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCnGiBeC_xHqqkZx_
//			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAiOhHiOkGiBeC_xHqqkZx_
//			// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmJiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
//			BOOL bIsViewChanged;
//			BOOL bIsLayoutChanged;
//			SetViewMode(bIsViewChanged,
//						bIsLayoutChanged,
//						FDHT_VMODE_PROJECT,
//						GetSelectedProjectPath(),
//						-1, -1);
//			// CheckFileUpdated _xZkqqHx_iCmFiCmNiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCmMiNfIjAfGiCmNjFeLiClIiDgAiDeGiDgCiDeOiClDiCoKiCoJiBeC_xHqqkZx_
//			// _xZkqqHx_iClBiCmMiClNiCnPiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJjFmPiNfIiClDiCoKiCmEiCoAiBeB_xHqqkZx_
//			// _xZkqqHx_iNfIjAfGiCpAiNmEjDhIiDgAiDeGiDgCiDeOiClHiCoJjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
//		}
//		return TRUE;
//	} else
//	//----- _xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		return FALSE;
//	}
//} // CFCWndHistoryTree::CheckFileUpdatedAndViewMode.
//----- 05.08.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::UpdateCurrent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiDhGiDiNiDfHiDeGiDeOiDgHiBeBjHjKjHpAjFlGiPjBiBeBjHjKjHpAiImKjChFiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	 bScrollTo:_xZkqqHx_iMlLiNnNiImKjChFiCkKjFfMiOkGiClDiCoKiCoJiCoGiCkEiDfIiDeOiDiNiBfLiDiLiClHiCoJiCkJiBeI_xHqqkZx_
 *			wcpNewMarkedProjectPath
 *					:_xZkqqHx_jAfGiClFiCkCiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOhHjCoIiBeCiMlLiNnNiKeKiCkCiCmEiCkCiCoJiImKjChFiCpA_xHqqkZx_
 *					 _xZkqqHx_jFmPiNfIiClHiCoJiPoKiNiHiCmJjAnNjCoIiBeCjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *			lNewMarkedDocumentId
 *					:_xZkqqHx_jAfGiClFiCkCjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiMlLiNnNiKeKiCkCiCmEiCkCiCoJiImKjChFiCpA_xHqqkZx_
 *					 _xZkqqHx_jFmPiNfIiClHiCoJiPoKiNiHiCmJjAnNjCoIiBeC_xHqqkZx_
 *			fliNewMarkedSessionIndex:
 *					:_xZkqqHx_jAfGiClFiCkCjHjKjHpAjFlGiPjBiImKjChFiCpAiOhHjCoIiBeCiMlLiNnNiKeKiCkCiCmEiCkCiCoJiImKjChFiCpA_xHqqkZx_
 *					 _xZkqqHx_jFmPiNfIiClHiCoJiPoKiNiHiCmJjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.04.07 Fukushiro M. _xZkqqHx_jBoFjFjNiCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::UpdateCurrent (	BOOL bScrollTo,
										const wchar_t* wcpNewMarkedProjectPath,
										long lNewMarkedDocumentId,
										flint fliNewMarkedSessionIndex)
{
	// _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
	CClientDC dc(this);
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDfIiDeOiDiNiBfLiDiLiImKjChFiCmFiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCmMiNmAjFfHjFoCjAlDiBeC_xHqqkZx_
	dc.SetWindowOrg(m_lgOffsetX, m_lgOffsetY);
	// _xZkqqHx_iNfIjAfGjBePiCmMiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
	DrawPositionMark(NULL, &dc, m_wstrCurMarkedProjectPath,
								m_lCurMarkedDocumentId,
								m_fliCurMarkedSessionIndex);

	if (wcpNewMarkedProjectPath != NULL)
	//----- _xZkqqHx_jAfGiClFiCkCiInKjDkOjAoGiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jGhLjBmMiCmFiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmGiMlLiNnN_xHqqkZx_ _xZkqqHx_jGhLjBmMiCmFiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMiImKjChFiCpAiNfIjAfGiBeC_xHqqkZx_
		m_wstrCurMarkedProjectPath = wcpNewMarkedProjectPath;
		m_lCurMarkedDocumentId = lNewMarkedDocumentId;
		m_fliCurMarkedSessionIndex = fliNewMarkedSessionIndex;
	}
	// _xZkqqHx_iNfIjAfGiMoDiCmMiDhNiBfLiDeOiCpAjFgAiJoGiBeC_xHqqkZx_
	CPoint ptMark;
	if (!DrawPositionMark(&ptMark, &dc, m_wstrCurMarkedProjectPath,
									m_lCurMarkedDocumentId,
									m_fliCurMarkedSessionIndex))
		bScrollTo = FALSE;
	if (bScrollTo)
	//----- _xZkqqHx_iMlLiNnNiImKjChFiCkKjFfMiOkGiClDiCoKiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiOoGjDlOiBeC_xHqqkZx_
		CRect rect;
		GetClientRect(rect);
		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHiOoGjDlOiBeC_xHqqkZx_
		SCROLLINFO oSCInfoH;
		GetScrollInfo(SB_HORZ, &oSCInfoH);
		SCROLLINFO oSCInfoV;
		GetScrollInfo(SB_VERT, &oSCInfoV);
		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDfIiDeOiDiNiBfLiDiLiImKjChFiCmFiNmAjFfHjFoCjAlDiBeC_xHqqkZx_
		rect += CPoint(	D2L(oSCInfoH.nPos * m_dScrollRatioX),
						D2L(oSCInfoV.nPos * m_dScrollRatioY));
		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCmMiOpMiImNiCfAiCePiBjDiCpAiPgLiPkMiBeCiDhNiBfLiDeOiCkKiCfAiCePiBjDiCpAiJhKiCkGiClNiCoHiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		rect.DeflateRect(CSize(rect.Width() / 10, rect.Height() / 10));
		if (ptMark.y < rect.top)
		{
			long lNewPos = D2L(oSCInfoV.nPos * m_dScrollRatioY) - (rect.top - ptMark.y);
			ScrollTo(m_lgOffsetX, lNewPos);
		} else
		if (rect.bottom < ptMark.y)
		{
			long lNewPos = D2L(oSCInfoV.nPos * m_dScrollRatioY) + (ptMark.y - rect.bottom);
			ScrollTo(m_lgOffsetX, lNewPos);
		}

		if (ptMark.x < rect.left)
		{
			long lNewPos = D2L(oSCInfoH.nPos * m_dScrollRatioX) - (rect.left - ptMark.x);
			ScrollTo(lNewPos, m_lgOffsetY);
		} else
		if (rect.right < ptMark.x)
		{
			long lNewPos = D2L(oSCInfoH.nPos * m_dScrollRatioX) + (ptMark.x - rect.right);
			ScrollTo(lNewPos, m_lgOffsetY);
		}
	}
} // CFCWndHistoryTree::UpdateCurrent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetViewMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLiDiCiBfLiDgIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsViewChanged		:_xZkqqHx_jFfMiOkGiCmJjFmPiNfIiCkKiCkAiCmBiClNiCkJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsLayoutChanged	:_xZkqqHx_iDiMiDeDiDeBiDeFiDgHiNmEiMhGiOfKiCkKjFeLjHhGiCmFiCkAiCoJiPoKiNiHiCmN_xHqqkZx_
 *								 TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			viewMode			:_xZkqqHx_jAfGiClFiCkCiDhCiDiFiBfLiDiCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpNewProjectPath	:_xZkqqHx_jAfGiClFiCkCiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lSelectedDocumentId			:_xZkqqHx_jAfGiClFiCkCjHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	bIsViewChanged_xZkqqHx_iBeB_xHqqkZx_bIsLayoutChanged _xZkqqHx_iCmGiCoAiBeB_xHqqkZx_TRUE _xZkqqHx_iCpAjFnEiClDiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAjAnNjCoIiClFiCmIiCkCiBeCiCmCiCnMiCoI_xHqqkZx_ FALSE _xZkqqHx_iCpAjAnNjCoIiClFiCmEjFnEiClHiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCpAiMmEiCnEiCmGiCkLiCmJiBeBiPiJiKpKiJlLiClFiCmEiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::SetViewMode (	BOOL& bIsViewChanged,
										BOOL& bIsLayoutChanged,
										FTHTViewMode viewMode,
										const wchar_t* wcpSelectedProjectPath,
										long lSelectedDocumentId,
										flint fliSelectedSessionIndex,
										FDTRClass clsSelectedObject,
										long lSelectedObjectId,
										const WStringVector& vCheckProjectPath,
										const longVector& vCheckDocumentId)
{
//----- 06.01.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (wcpSelectedProjectPath == NULL) wcpSelectedProjectPath = L"";
//	BOOL bProjectUpdated = FALSE;
//	if (wcscmp(wcpSelectedProjectPath, m_pHtreeManager->GetProjectPath()) != 0)
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAjFmPiNfIiBeCiPoOjFpBiCmNiDeOiDiKiDeBiClDiCoKiCoJiBeC_xHqqkZx_
//		m_pHtreeManager->SetProjectPath(wcpSelectedProjectPath);
//		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiNfIjAfGiClDiCoKiClNiBeC_xHqqkZx_
//		bProjectUpdated = TRUE;
//		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjCmKjCgNiBeC_xHqqkZx_
//		if (GetMessageWnd() != NULL)
//			GetMessageWnd()->PostMessage(WM_USER_WHT_SELCHANGED, (WPARAM)GetDlgCtrlID(), 0);
//	}
//
//	if (m_pHtreeManager->GetProjectPath().IsEmpty())
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jFfMiOkGiCmIiClFiBeC_xHqqkZx_
//		viewMode = FDHT_VMODE_NONE;
//	} else
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iImIiJlKiCmMiCfCiCmCiCmMiKnGjAjEiCmNiBeBiDhEiDeAiDeDiDiLiCkKiDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiHiCmJ_xHqqkZx_
//		// _xZkqqHx_iDeHiDiJiBfLiCpAiDfIiDiNiBfLiClHiCoJiBeC_xHqqkZx_
//		// m_pHtreeManager->CheckFileUpdatedProject()
//		// m_pHtreeManager->CheckFileUpdatedTree(stDocumentId)
//		// m_pHtreeManager->CheckFileUpdatedBranch(stDocumentId)
//		try
//		{
//			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjFmPiNfIiClDiCoKiClNiCkJiCmMiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//			if (m_pHtreeManager->CheckFileUpdatedProject())
//			//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjFmPiNfIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiNfIjAfGiClDiCoKiClNiBeC_xHqqkZx_
//				bProjectUpdated = TRUE;
//			}
//
////----- 05.10.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//			if (bProjectUpdated &&
//				GetSelectedDocumentId() != -1 &&
//				m_pHtreeManager->GetDocRecExtData(GetSelectedDocumentId()) == NULL)
//			//----- _xZkqqHx_jBeJjBpAjCiGiCmMjHjKjHpAjFlGiPjBiCkKiDhGiDiNiDfHiDeGiDeOiDgHjCiGiCmJjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjGlDiMpIiCmJiBeC_xHqqkZx_
//				// SetSelected _xZkqqHx_iCmNiBeBjCgMiCpAjFmPiCkGiCmEiClFiCnMiCkEiCmMiCmFiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
//				m_lSelectedDocumentId = -1L;
//				m_fliSelectedSessionIndex = -1;
//				m_clsSelectedObject = FDTR_NONE_REC;
//				m_lSelectedObjectId = -1;
//			}
//			if (bProjectUpdated &&
//				GetMarkedDocumentId() != -1 &&
//				m_pHtreeManager->GetDocRecExtData(GetMarkedDocumentId()) == NULL)
//			//----- _xZkqqHx_jBeJjBpAjCiGiCmMjHjKjHpAjFlGiPjBiCkKiDhGiDiNiDfHiDeGiDeOiDgHjCiGiCmJjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_iDhNiBfLiDeKiBfLiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiBeC_xHqqkZx_
//				m_lCurMarkedDocumentId = -1L;
//				// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_iDhNiBfLiDeKiBfLiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiBeCiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiBeC_xHqqkZx_
//				m_fliCurMarkedSessionIndex = flint(-1);
//			}
////----- 05.10.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//			if (lSelectedDocumentId != -1 &&
//				m_pHtreeManager->GetDocRecExtData(lSelectedDocumentId) == NULL)
//			//----- _xZkqqHx_iOhHjCoIiCmMjHjKjHpAjFlGiPjBiCkKiDhGiDiNiDfHiDeGiDeOiDgHjCiGiCmJjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//				viewMode = FDHT_VMODE_PROJECT;
//				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjBeJjBpAiCmJjFmPiNfIiBeC_xHqqkZx_
//				lSelectedDocumentId = -1;
//			}
//
//			// _xZkqqHx_iNfIjAfGiClDiCoKiClNjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iPfHiNiHiBeC_xHqqkZx_
//			longSet stDocumentId;
//			if (!bProjectUpdated)
//			//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiNfIjAfGiClDiCoKiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//			{
//				if (lSelectedDocumentId != -1)
//					stDocumentId.insert(lSelectedDocumentId);
//				for (long lC = 0; lC != vCheckProjectPath.size(); lC++)
//				{
//					if (vCheckDocumentId[lC] != -1 &&
//						vCheckProjectPath[lC] == m_pHtreeManager->GetProjectPath())
//						stDocumentId.insert(vCheckDocumentId[lC]);
//				}
//			}
////----- 05.10.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
//			switch (viewMode)
//			{
//			case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//				// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkPiCoJiDhEiDeAiDeDiDiLiCmMiNfIjAfGiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiPeDjAlDiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_stDocumentId.empty()_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
//				if (m_pHtreeManager->CheckFileUpdatedTree(stDocumentId))
//				{
//					// _xZkqqHx_jFfMiOkGiCkKjFmPiNfIiClDiCoKiClNiCkJiCmHiCkEiCkJiBeCjBeJjBpAiCmMjFmPiNfIjDjJiBeCiNmEjFgAiJoGiCkKjFeLjHhGiBeC_xHqqkZx_
//					bIsViewChanged = TRUE;
//					// _xZkqqHx_iDiMiDeDiDeBiDeFiDgHiCkKjFmPiNfIiClDiCoKiClNiCkJiCmHiCkEiCkJiBeCiDiMiDeDiDeBiDeFiDgHiNmEiMhGiOfKiCmGiNmEjFgAiJoGiCkKjFeLjHhGiBeC_xHqqkZx_
//					bIsLayoutChanged = TRUE;
//				}
//				break;
//			case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//				// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkPiCoJiDhEiDeAiDeDiDiLiCmMiNfIjAfGiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiPeDjAlDiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_stDocumentId.empty()_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
//				if (m_pHtreeManager->CheckFileUpdatedBranch(stDocumentId))
//				{
//					// _xZkqqHx_jFfMiOkGiCkKjFmPiNfIiClDiCoKiClNiCkJiCmHiCkEiCkJiBeCjBeJjBpAiCmMjFmPiNfIjDjJiBeCiNmEjFgAiJoGiCkKjFeLjHhGiBeC_xHqqkZx_
//					bIsViewChanged = TRUE;
//					// _xZkqqHx_iDiMiDeDiDeBiDeFiDgHiCkKjFmPiNfIiClDiCoKiClNiCkJiCmHiCkEiCkJiBeCiDiMiDeDiDeBiDeFiDgHiNmEiMhGiOfKiCmGiNmEjFgAiJoGiCkKjFeLjHhGiBeC_xHqqkZx_
//					bIsLayoutChanged = TRUE;
//				}
//			}
//		} catch (CFCMiscException* e)
//		//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAiDiKiDfKiDgCiDgHiBeCiPoOjFpBiCmNiDeOiDiKiDeBiClDiCoKiCoJiBeC_xHqqkZx_
//			m_pHtreeManager->SetProjectPath(NULL);
//			// _xZkqqHx_jFfMiOkGiCmIiClFiBeC_xHqqkZx_
//			viewMode = FDHT_VMODE_NONE;
////----- 06.01.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////			// _xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
////			dwErrorCode = e->GetMessageId();
////			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
////			wstrErrorMessage = FFGetErrorMessage(e);
////----- 06.01.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//			// _xZkqqHx_iDeHiDiJiBfLiCpAiNoNiPjMiBeC_xHqqkZx_
//			e->Delete();
//		}
//	}
//
//	if (GetViewMode() != viewMode)
//	//----- _xZkqqHx_iDhCiDiFiBfLiDiCiBfLiDgIiCkKjFmPiNfIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjCmKjCgNiBeC_xHqqkZx_
//		if (GetMessageWnd() != NULL)
//			GetMessageWnd()->PostMessage(WM_USER_WHT_VIEW_MODE_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
//	}
//	if (bProjectUpdated)
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjAnNjCoIiCmJjFmPiNfIiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		bIsViewChanged = TRUE;
//		bIsLayoutChanged = TRUE;
//	}
//	switch (viewMode)
//	{
//	case FDHT_VMODE_NONE:		// _xZkqqHx_jFfMiOkGiCmIiClFiBeC_xHqqkZx_
//		SetNoneView(bIsViewChanged,
//					bIsLayoutChanged);
//		break;
//	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//		SetProjectView(	bIsViewChanged,
//						bIsLayoutChanged,
//						lSelectedDocumentId,
//						fliSelectedSessionIndex,
//						clsSelectedObject,
//						lSelectedObjectId);
//		break;
//	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//		SetTreeView(bIsViewChanged,
//					bIsLayoutChanged,
//					lSelectedDocumentId,
//					fliSelectedSessionIndex,
//					clsSelectedObject,
//					lSelectedObjectId);
//		break;
//	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//		SetBranchView(	bIsViewChanged,
//						bIsLayoutChanged,
//						lSelectedDocumentId,
//						fliSelectedSessionIndex,
//						clsSelectedObject,
//						lSelectedObjectId);
//		break;
//	default:
//		FFThrowMiscUnknown();
//	}
//	return (g_pFileServer->GetErrorCode() == 0);
//----- 06.01.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iCnMiClIiDiNiDgCiDeOiCpAjAoGiNhDiClDiClJiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iNfIjAfGiCpAiDgAiDeGiDgCiDeOiClHiCoJjFeLjHhGiCmMiCkAiCoJiDhEiDeAiDeDiDiLiCpAjBfDiCmEjClCiCnHiPoDiClAiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClLiCoKiCoHiCpAjBfDiCmEiDiNiDgCiDeOiClHiCoJiBeCiCoAiClFiIoKiCmCiCmFiCoAiDiNiDgCiDeOiCmFiCkLiCmIiCkPiCoKiCmOiBeB_xHqqkZx_
	// _xZkqqHx_iJlNiCoAjFmPiCkGiClIiCmJ_xHqqkZx_SYNC_xZkqqHx_iCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jBfDiCmEiDiNiDgCiDeOiCmFiCkLiClNiPoKiNiHiCmNiBeBiIoKiCmCiClIiCmCiNfIjAfGiCpAiDgAiDeGiDgCiDeOiClFiBeBiNfIjAfGiClDiCoKiClN_xHqqkZx_
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCmNjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
	// 
	// _xZkqqHx_iDgAiDeGiDgCiDeOjEmNiImNiCpAiMiIjCoIiClHiCoJiCmJiCmNiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoOjFpBiCkKjFeLjHhGiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCmNjFeLiClIjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	// _xZkqqHx_iClLiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoOjFpBiCpAiOgHiCmBiCmEiDgAiDeGiDgCiDeOjEmNiImNiCpAiMiIjCoIiBeC_xHqqkZx_
	// 
	// _xZkqqHx_jBfDiCmEiCkKiDiNiDgCiDeOiCmFiCkLiClNiCmGiCkLiCmNiBeBjDmHiCnNiNjOiCpBiClOiDhGiDiNiDfHiDeGiDeOiDgHiCpA_xHqqkZx_
	// m_projectCopy _xZkqqHx_iCmJjElNiJgGiClDiClJiCoJiBeC_xHqqkZx_
	// 
	// 
	// viewMode_xZkqqHx_iBiBiDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeAiCmMiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiNfIjAfGiCmMiCnNiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	// 
	// viewMode_xZkqqHx_iBiBiMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeAiCmMiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiNfIjAfGiCmGiBeBjBmOiPnLiCmMjHjKjHpAiCmMiNfIjAfGiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	// 
	// viewMode_xZkqqHx_iBiBjHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeAiCmMiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiNfIjAfGiCmGiBeB_xHqqkZx_
	// _xZkqqHx_iBeFjHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgI_xHqqkZx_->_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeAiCmM_xHqqkZx_
	// _xZkqqHx_iBeAiPoKiNiHiCmNiBeBiOhHjCoIiClDiCoKiClNjClCiNlIjBmOiPnLiCmMjHjKjHpAiCmMiCnNiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	// _xZkqqHx_iBeFjBlMiCmMiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgI_xHqqkZx_->_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeAiCmM_xHqqkZx_
	// _xZkqqHx_iBeAiPoKiNiHiCmNiBeBjFfMiOkGiClDiCoKiCoJjGnIiNfMjBkCiCmMjBfDiCmEiCmMjHjKjHpAiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	// 
	// _xZkqqHx_jClCiCnHiCoJiCnHiCkLiNiAjGnK_xHqqkZx_
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCkKjFmPiNfIiClDiCoKiClNiPoKiNiH_xHqqkZx_/_xZkqqHx_jFmPiNfIiClDiCoKiCmIiCkCiPoKiNiH_xHqqkZx_
	// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCkKjFmPiNfIiClDiCoKiClNiPoKiNiH_xHqqkZx_/_xZkqqHx_jFmPiNfIiClDiCoKiCmIiCkCiPoKiNiH_xHqqkZx_
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJiNfIjAfGiCkKiCkAiCmBiClNiPoKiNiH_xHqqkZx_/_xZkqqHx_iNfIjAfGiCkKjGlDiCkCiPoKiNiH_xHqqkZx_
	// _xZkqqHx_iKpJjBlGjFlGiPjBiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_/_xZkqqHx_jBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_

	if (wcpSelectedProjectPath == NULL) wcpSelectedProjectPath = L"";
	if (wcpSelectedProjectPath[0] != L'\0')
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		if (!g_pFileServer->IsTopGroupExist(HString(wcpSelectedProjectPath)))
			wcpSelectedProjectPath = L"";
	}
	// _xZkqqHx_jFfMiOkGiCmIiClFiBeC_xHqqkZx_
	if (viewMode == FDHT_VMODE_NONE) wcpSelectedProjectPath = L"";
	if (wcpSelectedProjectPath[0] == L'\0') viewMode = FDHT_VMODE_NONE;

	FCDbReadLock readLockProject;
	FCHiProject project;
// 06.02.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	FCDbReadLockVector vReadLock;
	FCDbLockBank lockBank;
	// _xZkqqHx_iDgAiDeGiDgCiDeOiClHiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iPfHiNiHiBeC_xHqqkZx_
	longSet stDocumentId;
	if (viewMode != FDHT_VMODE_NONE)
	//----- _xZkqqHx_iClLiCmMjBlMiCmMiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAiOhHjCoIiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		project = g_pFileServer->GetTopGroup(wcpSelectedProjectPath);
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		if (!project.TryLock(readLockProject))
			return FALSE;
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiNfIjAfGiBeC_xHqqkZx_
		project.UpdateData(readLockProject);

		if (lSelectedDocumentId != -1 &&
			project.GetDocumentRec(lSelectedDocumentId).GetIsInvalid())
		//----- _xZkqqHx_iOhHjCoIiCmMjHjKjHpAjFlGiPjBiCkKiDhGiDiNiDfHiDeGiDeOiDgHjCiGiCmJjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
			viewMode = FDHT_VMODE_PROJECT;
			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjBeJjBpAiCmJjFmPiNfIiBeC_xHqqkZx_
			lSelectedDocumentId = -1;
		}

		switch (viewMode)
		{
		case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
			break;
		case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
			stDocumentId.insert(lSelectedDocumentId);
			if (GetViewMode() != FDHT_VMODE_TREE ||
				m_pHtreeManager->IsVirtualTableRecordModified(project))
			//----- _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCnGiInKiNhDiClHiCoJiPoKiNiHiBeB_xHqqkZx_
			//		_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJiPeDjAlDiCkKjDpMiCmBiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jGnIiNfMjBkCiCmMjBfDiCmEiCmMjFlGiPjBiCpAiDgAiDeGiDgCiDeOjBmOiPnLiCmJiBeC_xHqqkZx_
				long lTopDocId = project.SubDocumentIdToTopId(lSelectedDocumentId);
				longSet stLowerDocId;
				project.GetLowerHidocument(stLowerDocId, lTopDocId);
				FFInsert(stDocumentId, stLowerDocId);
			} else
			//----- _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIjFmPiNfIiCkKjGlDiCkNiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCmJiPeDjAlDiCoAjGlDiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDgAiDeGiDgCiDeOjBmOiPnLiCmGiClFiCmEiOhHjCoIiClDiCoKiCmEiCkCiCoJjFlGiPjBiCpAjCmHiJmBiBeC_xHqqkZx_
				for (long lC = 0; lC != vCheckProjectPath.size(); lC++)
				{
					if (vCheckDocumentId[lC] != -1 &&
						vCheckProjectPath[lC] == wcpSelectedProjectPath)
						stDocumentId.insert(vCheckDocumentId[lC]);
				}
			}
			break;
		case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
			stDocumentId.insert(lSelectedDocumentId);
//----- 06.04.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			if (GetViewMode() != FDHT_VMODE_BRANCH ||
				m_pHtreeManager->IsVirtualTableRecordModified(project))
			//----- _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCnGiInKiNhDiClHiCoJiPoKiNiHiBeB_xHqqkZx_
			//		_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJiPeDjAlDiCkKjDpMiCmBiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iIoKiCmCiJlKiCmMjHjKjHpAjFlGiPjBiCpAiDgAiDeGiDgCiDeOjBmOiPnLiCmJiBeC_xHqqkZx_
				// _xZkqqHx_iIoKiCmCiJlKiCmMiOhNiCoAjClCiCnHiCmEiCkIiCkJiCmIiCkCiCmGiBeBiOhNiCkKjAfGiLeLjCmHiJmBiCmMiPoKiNiHiCmJ_xHqqkZx_
				// _xZkqqHx_iCkEiCnMiCkNiDiMiDeDiDeBiDeFiDgHiClDiCoKiCmIiCkCiBeC_xHqqkZx_
				longSet stSubDocId;
				project.GetSubHidocument(stSubDocId, lSelectedDocumentId);
				FFInsert(stDocumentId, stSubDocId);
			}
//----- 06.04.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			break;
		}

		mdef_const_iterator(longSet, iId);
		m1_for (iId, stDocumentId)
		{
			FCDbReadLock readLockTerm(project.GetSubTableName(*iId, FDHI_TERMINATE_TABLE_ID));
			if (!readLockTerm.TryLock()) return FALSE;
			lockBank.Append(readLockTerm);
			FCDbReadLock readLockFork(project.GetSubTableName(*iId, FDHI_FORK_TABLE_ID));
			if (!readLockFork.TryLock()) return FALSE;
			lockBank.Append(readLockFork);
			// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
			if (viewMode == FDHT_VMODE_BRANCH)
			{
				FCDbReadLock readLockSummary(project.GetSubTableName(*iId, FDHI_SUMMARY_TABLE_ID));
				if (!readLockSummary.TryLock()) return FALSE;
				lockBank.Append(readLockSummary);
			}
		}
	}

	//-------------_xZkqqHx_iBkKiClBiClBiCoGiCoIiPoDiCmFiCmNjFmPjAjEiCpAjFmPiNfIiClFiCmEiCmNiCmIiCoHiCmIiCkC_xHqqkZx_-----------------------
	// _xZkqqHx_jFeLjHhGiCmIiDhEiDeAiDeDiDiLiCmNjBfDiCmEiDiNiDgCiDeOiCmFiCkLiClNiBeC_xHqqkZx_
	// _xZkqqHx_iClBiClBiCmFiPiJiCnPiCmEjFmPiNfIiCmMiDgAiDeGiDgCiDeOiCmGjDoAjHgFiCmMiNfIjAfGiCkKiJmCjEfMiCmJiCmIiCoJiBeC_xHqqkZx_
	//-----------------------------------------------------------------------------

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiNfIjAfGiClDiCoKiClNiCkJiBeI_xHqqkZx_
	BOOL bProjectUpdated = FALSE;
	if (m_pHtreeManager->GetProjectPath() != wcpSelectedProjectPath)
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjGlDiMpIiCmJiBeC_xHqqkZx_
		// SetSelected _xZkqqHx_iCmNiBeBjCgMiCpAjFmPiCkGiCmEiClFiCnMiCkEiCmMiCmFiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
		m_lSelectedDocumentId = -1L;
		m_fliSelectedSessionIndex = -1;
		m_clsSelectedObject = FDTR_NONE_REC;
		m_lSelectedObjectId = -1;
		// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_iDhNiBfLiDeKiBfLiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiBeC_xHqqkZx_
		m_lCurMarkedDocumentId = -1L;
		// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_iDhNiBfLiDeKiBfLiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiBeCiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiBeC_xHqqkZx_
		m_fliCurMarkedSessionIndex = flint(-1);
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiNfIjAfGiClDiCoKiClNiBeC_xHqqkZx_
		bProjectUpdated = TRUE;
		// _xZkqqHx_iPoOjFpBiCmNiDeOiDiKiDeBiClDiCoKiCoJiBeC_xHqqkZx_
		m_pHtreeManager->Clear();
		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjCmKjCgNiBeC_xHqqkZx_
		if (GetMessageWnd() != NULL)
			GetMessageWnd()->PostMessage(WM_USER_WHT_SELCHANGED, (WPARAM)GetDlgCtrlID(), 0);
	}

	if (viewMode != FDHT_VMODE_NONE)
	//----- _xZkqqHx_iClLiCmMjBlMiCmMiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAiOhHjCoIiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjFmPiNfIiClDiCoKiClNiCkJiCmMiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		if (m_pHtreeManager->CheckFileUpdatedProject(project))
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjFmPiNfIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiNfIjAfGiClDiCoKiClNiBeC_xHqqkZx_
			bProjectUpdated = TRUE;
		}

		if (bProjectUpdated)
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiNfIjAfGiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
		{
			if (GetSelectedDocumentId() != -1 &&
				m_pHtreeManager->GetDocRecExtData(GetSelectedDocumentId()) == NULL)
			//----- _xZkqqHx_jBeJjBpAjCiGiCmMjHjKjHpAjFlGiPjBiCkKiNfIjAfGiMoDiCmMiDhGiDiNiDfHiDeGiDeOiDgHjCiGiCmJjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjGlDiMpIiCmJiBeC_xHqqkZx_
				// SetSelected _xZkqqHx_iCmNiBeBjCgMiCpAjFmPiCkGiCmEiClFiCnMiCkEiCmMiCmFiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
				m_lSelectedDocumentId = -1L;
				m_fliSelectedSessionIndex = -1;
				m_clsSelectedObject = FDTR_NONE_REC;
				m_lSelectedObjectId = -1;
			}
			if (GetMarkedDocumentId() != -1 &&
				project.GetDocumentRec(GetMarkedDocumentId()).GetIsInvalid())
			//----- _xZkqqHx_jBeJjBpAjCiGiCmMjHjKjHpAjFlGiPjBiCkKiNfIjAfGiMoDiCmMiDhGiDiNiDfHiDeGiDeOiDgHjCiGiCmJjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_iDhNiBfLiDeKiBfLiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiBeC_xHqqkZx_
				m_lCurMarkedDocumentId = -1L;
				// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_iDhNiBfLiDeKiBfLiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiBeCiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiBeC_xHqqkZx_
				m_fliCurMarkedSessionIndex = flint(-1);
			}
		}
		switch (viewMode)
		{
		case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
			// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkPiCoJiDhEiDeAiDeDiDiLiCmMiNfIjAfGiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiPeDjAlDiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_stDocumentId.empty()_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
			if (m_pHtreeManager->CheckFileUpdatedTree(stDocumentId, lockBank))
			{
				// _xZkqqHx_jFfMiOkGiCkKjFmPiNfIiClDiCoKiClNiCkJiCmHiCkEiCkJiBeCjBeJjBpAiCmMjFmPiNfIjDjJiBeCiNmEjFgAiJoGiCkKjFeLjHhGiBeC_xHqqkZx_
				bIsViewChanged = TRUE;
				// _xZkqqHx_iDiMiDeDiDeBiDeFiDgHiCkKjFmPiNfIiClDiCoKiClNiCkJiCmHiCkEiCkJiBeCiDiMiDeDiDeBiDeFiDgHiNmEiMhGiOfKiCmGiNmEjFgAiJoGiCkKjFeLjHhGiBeC_xHqqkZx_
				bIsLayoutChanged = TRUE;
			}
			break;
		case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
			// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkPiCoJiDhEiDeAiDeDiDiLiCmMiNfIjAfGiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiPeDjAlDiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_stDocumentId.empty()_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
			if (m_pHtreeManager->CheckFileUpdatedBranch(stDocumentId, lockBank))
			{
				// _xZkqqHx_jFfMiOkGiCkKjFmPiNfIiClDiCoKiClNiCkJiCmHiCkEiCkJiBeCjBeJjBpAiCmMjFmPiNfIjDjJiBeCiNmEjFgAiJoGiCkKjFeLjHhGiBeC_xHqqkZx_
				bIsViewChanged = TRUE;
				// _xZkqqHx_iDiMiDeDiDeBiDeFiDgHiCkKjFmPiNfIiClDiCoKiClNiCkJiCmHiCkEiCkJiBeCiDiMiDeDiDeBiDeFiDgHiNmEiMhGiOfKiCmGiNmEjFgAiJoGiCkKjFeLjHhGiBeC_xHqqkZx_
				bIsLayoutChanged = TRUE;
			}
		}
	}
	if (GetViewMode() != viewMode)
	//----- _xZkqqHx_iDhCiDiFiBfLiDiCiBfLiDgIiCkKjFmPiNfIiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjCmKjCgNiBeC_xHqqkZx_
		if (GetMessageWnd() != NULL)
			GetMessageWnd()->PostMessage(WM_USER_WHT_VIEW_MODE_CHANGED, (WPARAM)GetDlgCtrlID(), 0);
	}
	if (bProjectUpdated)
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjAnNjCoIiCmJjFmPiNfIiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
	{
		bIsViewChanged = TRUE;
		bIsLayoutChanged = TRUE;
	}
	switch (viewMode)
	{
	case FDHT_VMODE_NONE:		// _xZkqqHx_jFfMiOkGiCmIiClFiBeC_xHqqkZx_
		SetNoneView(bIsViewChanged,
					bIsLayoutChanged);
		break;
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		SetProjectView(	bIsViewChanged,
						bIsLayoutChanged,
						lSelectedDocumentId,
						fliSelectedSessionIndex,
						clsSelectedObject,
						lSelectedObjectId);
		break;
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		SetTreeView(bIsViewChanged,
					bIsLayoutChanged,
					lSelectedDocumentId,
					fliSelectedSessionIndex,
					clsSelectedObject,
					lSelectedObjectId);
		break;
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		SetBranchView(	bIsViewChanged,
						bIsLayoutChanged,
						lSelectedDocumentId,
						fliSelectedSessionIndex,
						clsSelectedObject,
						lSelectedObjectId);
		break;
	default:
		FFThrowMiscUnknown();
	}
	return TRUE;
//----- 06.01.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCWndHistoryTree::SetViewMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetNoneView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiInKiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsViewChanged		:_xZkqqHx_jFfMiOkGiCmJjFmPiNfIiCkKiCkAiCmBiClNiCkJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsLayoutChanged	:_xZkqqHx_iDiMiDeDiDeBiDeFiDgHiNmEiMhGiOfKiCkKjFeLjHhGiCmFiCkAiCoJiPoKiNiHiCmN_xHqqkZx_
 *								 TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	bIsViewChanged_xZkqqHx_iBeB_xHqqkZx_bIsLayoutChanged _xZkqqHx_iCmGiCoAiBeB_xHqqkZx_TRUE _xZkqqHx_iCpAjFnEiClDiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAjAnNjCoIiClFiCmIiCkCiBeCiCmCiCnMiCoI_xHqqkZx_ FALSE _xZkqqHx_iCpAjAnNjCoIiClFiCmEjFnEiClHiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCpAiMmEiCnEiCmGiCkLiCmJiBeBiPiJiKpKiJlLiClFiCmEiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::SetNoneView (BOOL& bIsViewChanged,
									BOOL& bIsLayoutChanged)
{
//----- 05.09.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jAnNjCoIiCkKiInJiCmIiCoJiPoKiNiHiCmNiBeBiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
//	if (GetViewMode() == FDHT_VMODE_NONE &&
//		!bProjectUpdated &&
//		GetSelectedDocumentId() == -1)
//	//----- _xZkqqHx_jAnNjCoIiCmJjFmPiNfIiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//	} else
//	//----- _xZkqqHx_jAnNjCoIiCmJjFmPiNfIiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		bIsViewChanged = TRUE;
//		bIsLayoutChanged = TRUE;
//	}
//----- 05.09.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jAnNjCoIiCkKiInJiCmIiCoJiPoKiNiHiCmNiBeBiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
	if (GetViewMode() != FDHT_VMODE_NONE ||
		GetSelectedDocumentId() != -1)
	//----- _xZkqqHx_jAnNjCoIiCmJjFmPiNfIiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
	{
		bIsViewChanged = TRUE;
		bIsLayoutChanged = TRUE;
	} else
	//----- _xZkqqHx_jAnNjCoIiCmJjFmPiNfIiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		bIsViewChanged = TRUE;
		bIsLayoutChanged = TRUE;
	}
//----- 05.09.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	SetSelected(-1, -1, FDTR_NONE_REC, -1);
	// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
	m_pHtreeManager->SetViewMode(FDHT_VMODE_NONE);
} // CFCWndHistoryTree::SetNoneView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetProjectView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiInKiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsViewChanged		:_xZkqqHx_jFfMiOkGiCmJjFmPiNfIiCkKiCkAiCmBiClNiCkJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsLayoutChanged	:_xZkqqHx_iDiMiDeDiDeBiDeFiDgHiNmEiMhGiOfKiCkKjFeLjHhGiCmFiCkAiCoJiPoKiNiHiCmN_xHqqkZx_
 *								 TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lSelectedDocumentId	:_xZkqqHx_jAfGiClFiCkCjHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	bIsViewChanged_xZkqqHx_iBeB_xHqqkZx_bIsLayoutChanged _xZkqqHx_iCmGiCoAiBeB_xHqqkZx_TRUE _xZkqqHx_iCpAjFnEiClDiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAjAnNjCoIiClFiCmIiCkCiBeCiCmCiCnMiCoI_xHqqkZx_ FALSE _xZkqqHx_iCpAjAnNjCoIiClFiCmEjFnEiClHiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCpAiMmEiCnEiCmGiCkLiCmJiBeBiPiJiKpKiJlLiClFiCmEiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::SetProjectView (BOOL& bIsViewChanged,
										BOOL& bIsLayoutChanged,
										long lSelectedDocumentId,
										flint fliSelectedSessionIndex,
										FDTRClass clsSelectedObject,
										long lSelectedObjectId)
{
	// _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiCmNjBeJjBpAiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	ASSERT(clsSelectedObject != FDTR_TIME_REC);

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkCiCmEiCmNiBeBjBeJjBpAiCmFiCkLiCoJiCmMiCmN_xHqqkZx_
	// _xZkqqHx_jHjKjHpAjGnIiBgJiKlCiBgKiCmMiCnNiCmFiCkAiCoJiBeC_xHqqkZx_
	if (lSelectedDocumentId != -1)
	{
		switch (clsSelectedObject)
		{
		case FDTR_TRUNK_REC:			// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBgJiKlCiBgKiBeC_xHqqkZx_
			break;
		case FDTR_HTREE_REC:		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
			lSelectedDocumentId = lSelectedObjectId;
			clsSelectedObject = FDTR_TRUNK_REC;
			fliSelectedSessionIndex = -1;
			lSelectedObjectId = -1;
			break;
		case FDTR_LABEL_REC:		// _xZkqqHx_iDiJiDhIiDiLiBeC_xHqqkZx_
		case FDTR_TIME_LABEL_REC:	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
		case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
			clsSelectedObject = FDTR_TRUNK_REC;
			lSelectedObjectId = -1;
			break;
		default:
			FFThrowMiscUnknown();
		}
	}

	// _xZkqqHx_jAnNjCoIiCkKiInJiCmIiCoJiPoKiNiHiCmNiBeBiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
	if (GetViewMode() != FDHT_VMODE_PROJECT)
	//----- _xZkqqHx_jAnNjCoIiCmJjFmPiNfIiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
	{
		bIsViewChanged = TRUE;
		bIsLayoutChanged = TRUE;
	} else
	//----- _xZkqqHx_jAnNjCoIiCmJjFmPiNfIiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiCmMjFmPiNfIiCpAjClCiCnHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiImKjChFiCmNiBeBjFmPiNfIiClDiCoKiCmEiCoA_xHqqkZx_
		// _xZkqqHx_iNmEjFgAiJoGiCmMjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
		if (lSelectedDocumentId != GetSelectedDocumentId() ||
			clsSelectedObject != GetSelectedObject() ||
			lSelectedObjectId != GetSelectedObjectId())
		//----- _xZkqqHx_jBeJjBpAjCiGiCmMjHjKjHpAiCmJjFmPiNfIiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
		{
			bIsViewChanged = TRUE;
		}
	}

	// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	SetSelected(lSelectedDocumentId,
				fliSelectedSessionIndex,
				clsSelectedObject,
				lSelectedObjectId);
	// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
	m_pHtreeManager->SetViewMode(FDHT_VMODE_PROJECT);
} // CFCWndHistoryTree::SetProjectView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetTreeView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiInKiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsViewChanged		:_xZkqqHx_jFfMiOkGiCmJjFmPiNfIiCkKiCkAiCmBiClNiCkJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsLayoutChanged	:_xZkqqHx_iDiMiDeDiDeBiDeFiDgHiNmEiMhGiOfKiCkKjFeLjHhGiCmFiCkAiCoJiPoKiNiHiCmN_xHqqkZx_
 *								 TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lSelectedDocumentId	:_xZkqqHx_jAfGiClFiCkCjHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	bIsViewChanged_xZkqqHx_iBeB_xHqqkZx_bIsLayoutChanged _xZkqqHx_iCmGiCoAiBeB_xHqqkZx_TRUE _xZkqqHx_iCpAjFnEiClDiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAjAnNjCoIiClFiCmIiCkCiBeCiCmCiCnMiCoI_xHqqkZx_ FALSE _xZkqqHx_iCpAjAnNjCoIiClFiCmEjFnEiClHiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCpAiMmEiCnEiCmGiCkLiCmJiBeBiPiJiKpKiJlLiClFiCmEiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::SetTreeView (	BOOL& bIsViewChanged,
										BOOL& bIsLayoutChanged,
										long lSelectedDocumentId,
										flint fliSelectedSessionIndex,
										FDTRClass clsSelectedObject,
										long lSelectedObjectId)
{
	// _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiCmNjBeJjBpAiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	ASSERT(clsSelectedObject != FDTR_TIME_REC);

	// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkCiCmEiCmNiBeBjBeJjBpAiCmFiCkLiCoJiCmMiCmN_xHqqkZx_
	// _xZkqqHx_jHjKjHpAjGnIiBgJiKlCiBgKiCkJjHjKjHpAjFkKiKpCiDfOiDePiCmMiCnNiCmFiCkAiCoJiBeC_xHqqkZx_
	if (lSelectedDocumentId != -1)
	{
		switch (clsSelectedObject)
		{
		case FDTR_TRUNK_REC:			// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBgJiKlCiBgKiBeC_xHqqkZx_
			break;
		case FDTR_HTREE_REC:		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
			lSelectedDocumentId = lSelectedObjectId;
			clsSelectedObject = FDTR_TRUNK_REC;
			fliSelectedSessionIndex = -1;
			lSelectedObjectId = -1;
			break;
		case FDTR_LABEL_REC:		// _xZkqqHx_iDiJiDhIiDiLiBeC_xHqqkZx_
		case FDTR_TIME_LABEL_REC:	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
			clsSelectedObject = FDTR_TRUNK_REC;
			lSelectedObjectId = -1;
			break;
		case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
			break;
		default:
			FFThrowMiscUnknown();
		}
	}

	// _xZkqqHx_jAnNjCoIiCkKiInJiCmIiCoJiPoKiNiHiCmNiBeBiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
	if (GetViewMode() != FDHT_VMODE_TREE)
	//----- _xZkqqHx_jAnNjCoIiCmJjFmPiNfIiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
	{
		bIsViewChanged = TRUE;
		bIsLayoutChanged = TRUE;
	} else
	//----- _xZkqqHx_jAnNjCoIiCmJjFmPiNfIiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiCmMjFmPiNfIiCpAjClCiCnHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiImKjChFiCmNiBeBjFmPiNfIiClDiCoKiCmEiCoA_xHqqkZx_
		// _xZkqqHx_iNmEjFgAiJoGiCmMjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
		if (lSelectedDocumentId != GetSelectedDocumentId() ||
			clsSelectedObject != GetSelectedObject() ||
			lSelectedObjectId != GetSelectedObjectId())
		//----- _xZkqqHx_jBeJjBpAiCmJjFmPiNfIiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			bIsViewChanged = TRUE;
			if (GetSelectedDocumentId() == -1 ||
				m_pHtreeManager->SubDocumentIdToTopId(GetSelectedDocumentId()) !=
				m_pHtreeManager->SubDocumentIdToTopId(lSelectedDocumentId))
			//----- _xZkqqHx_iDgHiDgCiDhGiCmMjHjKjHpAiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				bIsLayoutChanged = TRUE;
			}
		}
	}

	// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	SetSelected(lSelectedDocumentId,
				fliSelectedSessionIndex,
				clsSelectedObject,
				lSelectedObjectId);
	// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
	m_pHtreeManager->SetViewMode(FDHT_VMODE_TREE);
} // CFCWndHistoryTree::SetTreeView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetBranchView
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiInKiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsViewChanged		:_xZkqqHx_jFfMiOkGiCmJjFmPiNfIiCkKiCkAiCmBiClNiCkJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsLayoutChanged	:_xZkqqHx_iDiMiDeDiDeBiDeFiDgHiNmEiMhGiOfKiCkKjFeLjHhGiCmFiCkAiCoJiPoKiNiHiCmN_xHqqkZx_
 *								 TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lSelectedDocumentId	:_xZkqqHx_jAfGiClFiCkCjHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	bIsViewChanged_xZkqqHx_iBeB_xHqqkZx_bIsLayoutChanged _xZkqqHx_iCmGiCoAiBeB_xHqqkZx_TRUE _xZkqqHx_iCpAjFnEiClDiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAjAnNjCoIiClFiCmIiCkCiBeCiCmCiCnMiCoI_xHqqkZx_ FALSE _xZkqqHx_iCpAjAnNjCoIiClFiCmEjFnEiClHiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCpAiMmEiCnEiCmGiCkLiCmJiBeBiPiJiKpKiJlLiClFiCmEiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::SetBranchView (	BOOL& bIsViewChanged,
										BOOL& bIsLayoutChanged,
										long lSelectedDocumentId,
										flint fliSelectedSessionIndex,
										FDTRClass clsSelectedObject,
										long lSelectedObjectId)
{
	// _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiCmNjBeJjBpAiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	ASSERT(clsSelectedObject != FDTR_TIME_REC);

	if (GetViewMode() != FDHT_VMODE_BRANCH)
	//----- _xZkqqHx_jAnNjCoIiCmJjFmPiNfIiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
	{
		bIsViewChanged = TRUE;
		bIsLayoutChanged = TRUE;
	} else
	//----- _xZkqqHx_jAnNjCoIiCmJjFmPiNfIiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiCmMjFmPiNfIiCpAjClCiCnHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiImKjChFiCmNiBeBjFmPiNfIiClDiCoKiCmEiCoA_xHqqkZx_
		// _xZkqqHx_iNmEjFgAiJoGiCmMjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
		if (lSelectedDocumentId != GetSelectedDocumentId() ||
			clsSelectedObject != GetSelectedObject() ||
			lSelectedObjectId != GetSelectedObjectId())
		//----- _xZkqqHx_jBeJjBpAiCmJjFmPiNfIiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
		{
			bIsViewChanged = TRUE;
			if (lSelectedDocumentId != GetSelectedDocumentId())
			//----- _xZkqqHx_jFlGiPjBiCmMjBeJjBpAiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				bIsLayoutChanged = TRUE;
			}
		}
	}

	// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	SetSelected(lSelectedDocumentId,
				fliSelectedSessionIndex,
				clsSelectedObject,
				lSelectedObjectId);
	// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
	m_pHtreeManager->SetViewMode(FDHT_VMODE_BRANCH);
} // CFCWndHistoryTree::SetBranchView.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetSelected
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiClDiCoKiCoJjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeBjHjKjHpAiImKjChFiBeBiDeJiDhFiDfHiDeGiDeOiDgHiBeBiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ID_xZkqqHx_iCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocumentId		:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_ID_xZkqqHx_iCpAiDeOiDiKiDeBiClHiCoJiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_jHjKjHpAiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			clsObject		:_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lObjectId		:_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiCkKiCkAiCmBiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::SetSelected (long lDocumentId,
									flint fliSessionIndex,
									FDTRClass clsObject,
									long lObjectId)
{
	if (clsObject == FDTR_NONE_REC)
	//----- _xZkqqHx_jEhHiMgJiCmFiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (wcscmp(GetMarkedProjectPath(), GetSelectedProjectPath()) == 0 &&
			GetMarkedDocumentId() == GetSelectedDocumentId())
		{
			// _xZkqqHx_iMlLiNnNiDhNiBfLiDeOiClDiCoKiCmEiCkCiCoJiImKjChFiCpAjBeJjBpAiBeC_xHqqkZx_
			lDocumentId = GetMarkedDocumentId();
			fliSessionIndex = GetMarkedSessionIndex();
		} else
		{
			// _xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiKlCiCmMjFlGiPjBiCmMiBeBiDfKiDgCiDfGiDiHiDjD_xHqqkZx_-1 _xZkqqHx_iCpAjBeJjBpAiBeC_xHqqkZx_
			lDocumentId = GetSelectedDocumentId();
			fliSessionIndex = -1;
		}
		clsObject = FDTR_TRUNK_REC;
		lObjectId = -1;
	} else
	if (clsObject == FDTR_EXPBOX_REC)
	//----- _xZkqqHx_jDfHiKeKiDhLiDgCiDeOiDfIiCmFiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDfHiKeKiDhLiDgCiDeOiDfIiCmMjBeJjBpAiCmNiCmFiCkLiCmIiCkCiBeCiKlCiCmMjBeJjBpAiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
		clsObject = FDTR_TRUNK_REC;
		lObjectId = -1;
	} else
	if (clsObject == FDTR_TIME_REC)
	//----- _xZkqqHx_iOjOiKnEiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOjOiKnEiCmMjBeJjBpAiCmNiCmFiCkLiCmIiCkCiBeCiKlCiCmMjBeJjBpAiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
		clsObject = FDTR_TRUNK_REC;
		lObjectId = -1;
	}

	// _xZkqqHx_jFmPiNfIiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (lDocumentId == GetSelectedDocumentId() &&
		fliSessionIndex == GetSelectedSessionIndex() &&
		clsObject == GetSelectedObject() &&
		lObjectId == GetSelectedObjectId()) return FALSE;

	// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJiPoOjFpBiBeC_xHqqkZx_
	m_lSelectedDocumentId = lDocumentId;
	m_fliSelectedSessionIndex = fliSessionIndex;
	m_clsSelectedObject = clsObject;
	m_lSelectedObjectId = lObjectId;

	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjCmKjCgNiBeC_xHqqkZx_
	if (GetMessageWnd() != NULL)
		GetMessageWnd()->PostMessage(WM_USER_WHT_SELCHANGED, (WPARAM)GetDlgCtrlID(), 0);

	return TRUE;
} // CFCWndHistoryTree::SetSelected.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::UpdateScrollSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiOjOiBeBjFfMiOkGjHmMiIoGiCmMiDfEiDeDiDfJjFmPiNfIjDjJiBeBiDfEiDeDiDfJiCmMjFmPiNfIiMoDiCmJiOmAiNhDiBeC_xHqqkZx_
 *			_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiCmMjClCjAkOjDjJiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::UpdateScrollSize ()
{
	// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIiCmMjIfPjHjNiNmAjFfHiCpAjDlOiCoJiBeC_xHqqkZx_
	CRect lgrtCanvas = GetCanvasRect();
	// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCmMjBoFiCkLiClDiCpAjIfPjHjNiNmAjFfHiCmFjDlOiCoJiBeC_xHqqkZx_
	CRect lgrtClient = GetClientRectLG();

	//----- _xZkqqHx_iMlLiNnNiCmMiDfIiDeOiDiNiBfLiDiLiImKjChFiCpAjFoCjAlDiClHiCoJ_xHqqkZx_ -----
	long lgDiff;
	lgDiff = lgrtClient.right - lgrtCanvas.right;
	if (0 < lgDiff)
	{
		lgrtClient.left -= lgDiff;
		lgrtClient.right -= lgDiff;
		m_lgOffsetX -= lgDiff;
	}
	lgDiff = lgrtCanvas.left - lgrtClient.left;
	if (0 < lgDiff)
	{
		lgrtClient.left += lgDiff;
		lgrtClient.right += lgDiff;
		m_lgOffsetX += lgDiff;
	}
	lgDiff = lgrtClient.bottom - lgrtCanvas.bottom;
	if (0 < lgDiff)
	{
		lgrtClient.top -= lgDiff;
		lgrtClient.bottom -= lgDiff;
		m_lgOffsetY -= lgDiff;
	}
	lgDiff = lgrtCanvas.top - lgrtClient.top;
	if (0 < lgDiff)
	{
		lgrtClient.top += lgDiff;
		lgrtClient.bottom += lgDiff;
		m_lgOffsetY += lgDiff;
	}

	// SetScrollInfo_xZkqqHx_iKnGjAjEiCmFiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCkKiPmBjGmFiClHiCoJiCmGiBeB_xHqqkZx_OnSize_xZkqqHx_iCkJiCoHiClBiCmMiKnGjAjEiCkK_xHqqkZx_
	// _xZkqqHx_iDgMiDfIiDgHiClFiCmEiClFiCnMiCkEiBeCiClBiCoKiCpAjGgIiCkOiClNiCnPiBeB_xHqqkZx_nPage_xZkqqHx_iCkKjBoFiCkLiCkNiCmIiCoHiCmIiCkCiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_

	// lgrtCanvas.left = 0 _xZkqqHx_iCmFiCkAiCoJiClNiCnPiBeBiImIiJlKiCmMiDfCiBfLiDgIiCmFiCmN_xHqqkZx_ lgrtCanvas.left
	// _xZkqqHx_iCmMjAoCjBmOjCgMiCmMiNgMjHlGiCmNjGhLjHiIjFhDjHhGiCmFiCkAiCoJiBeC_xHqqkZx_
	// CFCDynamicDrawView::UpdateScrollSize _xZkqqHx_iCmGiOgEjHgMiCpAiNiHiCoNiClJiCoJiClNiCnPiBeB_xHqqkZx_
	// _xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiCmIiCmBiCmEiCkCiCoJiBeC_xHqqkZx_

	long lgMax = ::abs(lgrtCanvas.left);
	if (lgMax < abs(lgrtCanvas.right)) lgMax = abs(lgrtCanvas.right);
	if (lgMax < lgrtClient.Width())	 lgMax = lgrtClient.Width();
	m_dScrollRatioX = static_cast<double>(lgMax) / 30000.0;

	lgMax = ::abs(lgrtCanvas.top);
	if (lgMax < abs(lgrtCanvas.bottom)) lgMax = abs(lgrtCanvas.bottom);
	if (lgMax < lgrtClient.Height())	  lgMax = lgrtClient.Height();
	m_dScrollRatioY = static_cast<double>(lgMax) / 30000.0;

	//----- _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiCmMiPiJiKpKiJlL_xHqqkZx_ -----
	SCROLLINFO oSCInfo;
	oSCInfo.cbSize	= sizeof(oSCInfo);
	oSCInfo.fMask	= SIF_ALL;
	oSCInfo.nMin	= D2L(lgrtCanvas.left / m_dScrollRatioX);
	oSCInfo.nMax	= D2L(lgrtCanvas.right / m_dScrollRatioX);
	oSCInfo.nPage	= D2L(lgrtClient.Width() / m_dScrollRatioX);
	oSCInfo.nPos	= D2L(m_lgOffsetX / m_dScrollRatioX);
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiPmBjGmFiCpAjGgIiCkOiBeC_xHqqkZx_
	if (oSCInfo.nMax - oSCInfo.nMin < int(oSCInfo.nPage))
		oSCInfo.nPage = oSCInfo.nMax - oSCInfo.nMin;
	SetScrollInfo(SB_HORZ, &oSCInfo);

	oSCInfo.cbSize	= sizeof(oSCInfo);
	oSCInfo.fMask	= SIF_ALL;
	oSCInfo.nMin	= D2L(lgrtCanvas.top / m_dScrollRatioY);
	oSCInfo.nMax	= D2L(lgrtCanvas.bottom / m_dScrollRatioY);
	oSCInfo.nPage	= D2L(lgrtClient.Height() / m_dScrollRatioY);
	oSCInfo.nPos	= D2L(m_lgOffsetY / m_dScrollRatioY);
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiPmBjGmFiCpAjGgIiCkOiBeC_xHqqkZx_
	if (oSCInfo.nMax - oSCInfo.nMin < int(oSCInfo.nPage))
		oSCInfo.nPage = oSCInfo.nMax - oSCInfo.nMin;
	SetScrollInfo(SB_VERT, &oSCInfo);
} // CFCWndHistoryTree::UpdateScrollSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::DrawPositionMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCpAiOkGiClHiDhNiBfLiDeOiCpAjFfMiOkGiBgJjEpBjFfMiOkGiBgKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ptMark			:_xZkqqHx_jFgAiJoGiClHiCoJiDhNiBfLiDeOiCmMjCiGjAfDiNmAjFfHiCpAiOpDiCkPiOoGiCoJjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC				:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_SetWindowOrg_xZkqqHx_iCmJ_xHqqkZx_
 *							 _xZkqqHx_iCoGiCmBiCmEjFoCjAlDiNmPiCnNiBeC_xHqqkZx_
 *			lMarkDocId		:_xZkqqHx_iMlLiNnNiImKjChFiCmMjHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliMarkSessionIdxPos:_xZkqqHx_iMlLiNnNiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFgAiJoGiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.06.23 Fukushiro M. ptMark_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::DrawPositionMark (	CPoint* ptMark,
											CDC* pDC,
											const wchar_t* wcpMarkProjectPath,
											long lMarkDocId,
											flint fliMarkSessionIdxPos)
{
	ASSERT(m_pHtreeManager->IsProjectOpened());
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCkKiInJiCmIiCoJiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
	if (wcscmp(m_pHtreeManager->GetProjectPath(), wcpMarkProjectPath) != 0)
		return FALSE;
	// _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiPeJjHlJiBeC_xHqqkZx_
	if (lMarkDocId == -1L) return FALSE;
	// _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiNoNiPjMiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
	if (m_pHtreeManager->GetDocRecExtData(lMarkDocId) == NULL)
		return FALSE;

	switch (GetViewMode())
	{
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		// lMarkDocId _xZkqqHx_iCkKjBkOiClHiCoJiDgDiDiKiBfLiCmFiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiCmF_xHqqkZx_
		// _xZkqqHx_jDfHiKeKiClDiCoKiCmEiCkCiCoJiBeBiNmFiCoAiPoDiImKiCmMiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
		// _xZkqqHx_iDhNiBfLiDeOiCpAjFgAiJoGiClHiCoJiLoJiMgAiBeC_xHqqkZx_
		CRect rtMark = GetTopRectInProject(lMarkDocId);
		rtMark.InflateRect(FD_HTREE_HPS_MARK_BOX_EXT, FD_HTREE_HPS_MARK_BOX_EXT);
		FCEditDraw eDraw(pDC, 0, g_pReg->GetOptiRegColor(FDCL_HTREE_SELECTION) ^
								 g_pReg->GetOptiRegColor(FDCL_HTREE_BACKGROUND), -1, 0, 0);
		// _xZkqqHx_jIgHiCpAjFfMiOkGiBeC_xHqqkZx_
		eDraw.RectLine(rtMark);
		if (ptMark != NULL)
		{
			// _xZkqqHx_jIgHiBgJiDhNiBfLiDeOiBgKiCmMjCiGjAfDiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
			*ptMark = rtMark.CenterPoint();
		}
		break;
	  }
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jGhLjBmMiCmFiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMiImKjChFiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiPeJjHlJiBeC_xHqqkZx_
		if (fliMarkSessionIdxPos == flint(-1)) break;
		// _xZkqqHx_jFfMiOkGjCiGiCmMjHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiCmGiInJiCmIiCoJiOhNiCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (m_pHtreeManager->SubDocumentIdToTopId(lMarkDocId) !=
			m_pHtreeManager->SubDocumentIdToTopId(GetSelectedDocumentId())) break;
		// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiCmMiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(lMarkDocId);
		// _xZkqqHx_iDiMiDfCiBfLiDgIiCkKiOoGjDlOiCmFiCkLiCmIiCkCiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (pRec == NULL) break;
		//----- _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoG_xHqqkZx_ -----
		// _xZkqqHx_jHjKjHpAjApMiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
		const CRect rtLifeLine = pRec->GetLifeLineRect();
		// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jGhLjBmMiCmFiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMiImKjChFiCmMiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
		long lY = pRec->SessionIndexToYTree(fliMarkSessionIdxPos);
		FCEditDraw eDraw(pDC, 0, g_pReg->GetOptiRegColor(FDCL_HTREE_SELECTION) ^
									g_pReg->GetOptiRegColor(FDCL_HTREE_BACKGROUND), -1, 0, 0);
		eDraw.Line(	&CPoint(rtLifeLine.left - (FD_HTREE_HPS_MARK_LINE_W / 2), lY),
					&CPoint(rtLifeLine.right + (FD_HTREE_HPS_MARK_LINE_W / 2), lY));
		eDraw.ArcLine(CRect(rtLifeLine.left - (FD_HTREE_HPS_MARK_DIAMETER / 2),
							lY - m_pHtreeManager->GetHtLifeWidthH() - (FD_HTREE_HPS_MARK_DIAMETER / 2),
							rtLifeLine.right + (FD_HTREE_HPS_MARK_DIAMETER / 2),
							lY + m_pHtreeManager->GetHtLifeWidthH() + (FD_HTREE_HPS_MARK_DIAMETER / 2)),
					 CPoint(0, 0), CPoint(0, 0));
		if (ptMark != NULL)
		{
			// _xZkqqHx_jIgHiBgJiDhNiBfLiDeOiBgKiCmMjCiGjAfDiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
			ptMark->x = (rtLifeLine.left + rtLifeLine.right) / 2;
			ptMark->y = lY;
		}
		break;
	  }
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jGhLjBmMiCmFiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMiImKjChFiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiPeJjHlJiBeC_xHqqkZx_
		if (fliMarkSessionIdxPos == flint(-1)) break;
		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJjFfMiOkGjCiGiCmMiOhNiCmGiBeBjHjKjHpAjFlGiPjBiCkKiInJiCmIiCoJiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (GetSelectedDocumentId() != lMarkDocId) break;
		// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiCmMiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(lMarkDocId);
		// _xZkqqHx_iDiMiDfCiBfLiDgIiCkKiOoGjDlOiCmFiCkLiCmIiCkCiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (pRec == NULL) break;
		// _xZkqqHx_iOjOiKnEiDhCiDiFiBfLiCmMiLoJiMgAiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
		CRect rtTmView(0, 0, m_pHtreeManager->CalcTimeViewWidth(),
								m_pHtreeManager->GetMostRightBottom().y);
		// _xZkqqHx_jFfMiOkGiJoGjGmKiCmMiDeOiDiJiDeDiDeBiDjDiDgHjIfPjHjNiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
		CRect rtClient;
		GetClientRect(rtClient);
		rtClient = DPtoLP(rtClient);
		//----- _xZkqqHx_jAfGiClFiCkCjApMiCpAjFgAiJoG_xHqqkZx_ -----
//----- 05.09.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		double dRat = 0.0;
//		if (pRec->GetSessionIndexLength() != 0)
//			dRat = double(fliMarkSessionIdxPos - pRec->GetFirstSessionIndex()) / double(pRec->GetSessionIndexLength());
//		// _xZkqqHx_iPoDiMmAiCpAjClEiCkGiClNiPoKiNiHiCmNjFoCjAlDiBeC_xHqqkZx_
//		if (1.0 < dRat) dRat = 1.0;
//
//		// _xZkqqHx_jHjKjHpAjApMiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
//		const CRect rtLifeLine = pRec->GetLifeLineRect();
//		// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jGhLjBmMiCmFiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMiImKjChFiCmMiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
//		long lY = rtLifeLine.top + D2L(dRat * (double)rtLifeLine.Height());
//----- 05.09.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_jHjKjHpAjApMiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
		const CRect rtLifeLine = pRec->GetLifeLineRect();
		// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jGhLjBmMiCmFiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMiImKjChFiCmMiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
		long lY = pRec->SessionIndexToYBranch(fliMarkSessionIdxPos);
//----- 05.09.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		{
			FCEditDraw eDraw(pDC, 0, g_pReg->GetOptiRegColor(FDCL_HTREE_SELECTION) ^
										g_pReg->GetOptiRegColor(FDCL_HTREE_LABEL_FACE), -1, 0, 0);
			eDraw.Line(&CPoint(rtTmView.left, lY), &CPoint(rtTmView.right, lY));
		}
		{
			FCEditDraw eDraw(pDC, 0, g_pReg->GetOptiRegColor(FDCL_HTREE_SELECTION) ^
										g_pReg->GetOptiRegColor(FDCL_HTREE_BACKGROUND), -1, 0, 0);
			eDraw.Line(&CPoint(rtTmView.right, lY), &CPoint(rtClient.right, lY));
		}
		if (ptMark != NULL)
		{
			// _xZkqqHx_jIgHiBgJiDhNiBfLiDeOiBgKiCmMjCiGjAfDiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
			ptMark->x = (rtLifeLine.left + rtLifeLine.right) / 2;
			ptMark->y = lY;
		}
		break;
	  }
	}
	return TRUE;
} // CFCWndHistoryTree::DrawPositionMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::DrawTempMarkMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlMjAnNjFkKiKpCiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC						:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFgAiJoGiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iBeIiCmMiDhLiDgCiDeOiDfIiCkKiJlMjAnNjFkKiKpCiBeC_xHqqkZx_
 *
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_ m_pHtreeManager->GetHtLineIntroX()
 *                _xZkqqHx_iEkLiEkFiElOiEjPiEjPiEjPiEkJiBkJ_xHqqkZx_
 *                _xZkqqHx_iEkLiEkAiEkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkNiEjPiEkG_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiEkKiElC_xHqqkZx_    _xZkqqHx_iBeI_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_m_pHtreeManager->GetHistBoxSize().cy _xZkqqHx_iBiA_xHqqkZx_ 2
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkOiEjPiEkI_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *              _xZkqqHx_iEkMiEkO_xHqqkZx_  _xZkqqHx_iEkPiEkN_xHqqkZx_    m_pHtreeManager->GetHistBoxSize().cx _xZkqqHx_iBiA_xHqqkZx_ 2
 *               _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                 _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::DrawTempMarkMark (CDC* pDC)
{
	ASSERT(	GetViewMode() == FDHT_VMODE_TREE ||
			GetViewMode() == FDHT_VMODE_BRANCH);
	// _xZkqqHx_iJlMjAnNiDhNiBfLiDeOiCmMiLoJiMgAiCpAiOoGjDlOiBeC_xHqqkZx_
	CPoint pt;
	CRect rtTempMark;
	if (GetTempMarkRect(pt, rtTempMark))
	//----- _xZkqqHx_iJlMjAnNiDhNiBfLiDeOiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDC(pDC, FALSE, 0, 0);
		// GDI_xZkqqHx_iDfIiDgHiDgCiDeOiBeC_xHqqkZx_
		FCAutoGdiStock gdiStock;
		switch (m_nTempMarkOrLabel)
		{
		case 0:	// _xZkqqHx_iJlMjAnNjHjKjHpAjFkKiKpCiCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			// _xZkqqHx_jDlBjDpMjApMiCpAjFgAiJoGiBeC_xHqqkZx_
			myDrawIntroLine(CPoint(pt.x + m_pHtreeManager->GetHtLifeWidthH(), pt.y),
							CPoint(pt.x + m_pHtreeManager->GetHtLineIntroX(), pt.y),
							&atDC,
							gdiStock);
			// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIjFgAiJoGiBeC_xHqqkZx_
			myDrawNode(	m_pHtreeManager,
						rtTempMark,
						&atDC,
						gdiStock,
						FALSE,
						FALSE,
						1.0);
			break;
		  }
		case 1:	// _xZkqqHx_iJlMjAnNjHjKjHpAjFkKiKpCiDfOiDePiCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			// _xZkqqHx_jDlBjDpMjApMiCpAjFgAiJoGiBeC_xHqqkZx_
			if (GetViewMode() == FDHT_VMODE_BRANCH)
				myDrawIntroLine(CPoint(pt.x + m_pHtreeManager->GetHtLifeWidthH(), pt.y),
								CPoint(pt.x + m_pHtreeManager->GetHtLineIntroX(), pt.y),
								&atDC,
								gdiStock);
			// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIjFgAiJoGiBeC_xHqqkZx_
			myDrawLabelEdge(rtTempMark, &atDC, gdiStock, FALSE);
			break;
		  }
		}
		return TRUE;
	}
	return FALSE;
} // CFCWndHistoryTree::DrawTempMarkMark.

/////////////////////////////////////////////////////////////////////////////
// CFCWndHistoryTree _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnPaint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmEjFgAiJoGiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnPaint ()
{
	CPaintDC dc(this); // _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_
	// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiOoGjDlOiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(rtClient);
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjEhHiMgJjAeGiCmFiBeBjEhHiMgJiCpAjDgIiCoIjCnHiClHiBeC_xHqqkZx_
	dc.FillRect(rtClient, &CBrush(g_pReg->GetOptiRegColor(FDCL_HTREE_BACKGROUND)));
	if (m_pHtreeManager->IsProjectOpened())
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDfIiDeOiDiNiBfLiDiLiImKjChFiCmFiNmAjFfHjFoCjAlDiBeC_xHqqkZx_
		dc.SetWindowOrg(CPoint(m_lgOffsetX, m_lgOffsetY));
		switch (GetViewMode())
		{
		case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
			OnPaintProject(&dc);
			break;
		case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
			OnPaintTree(&dc);
			break;
		case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
			OnPaintBranch(&dc);
			break;
		}
	}
//----- 05.09.29 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 05.09.29 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCWndHistoryTree::OnPaint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnPaintProjectSub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmMjFgAiJoGiCpAiNhDiCkEiDfEiDhFiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId			:_xZkqqHx_jFgAiJoGiClHiCoJjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiDhGiDiNiDfHiDeGiDeOiDgH_xHqqkZx_
 *							 _xZkqqHx_iCpAiOhHjCoIiClHiCoJiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lSelectedDocId	:_xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bExpBoxSelected	:_xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAjFlGiPjBiCkKiDfIiDeOiDiKiBfLiDjDjCiGiCmF_xHqqkZx_
 *							 _xZkqqHx_iClNiClNiCnMiCoKiCmEiCkCiCoJiPoKiNiHiBeBiClLiCoKiCpAjBoDjFfMiClHiCoJiPoDiImKiCmM_xHqqkZx_
 *							 _xZkqqHx_jHjKjHpAjFlGiPjBiCkKjBeJjBpAiPpDjBnEiCmGiCmIiCoJiBeC_xHqqkZx_
 *							 lSelectedDocId _xZkqqHx_iCkKiBeBjBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAjFlGiPjB_xHqqkZx_
 *							 _xZkqqHx_iCpAiOkGiClHiCmMiCkJiBeBiIlNiCkCiCmNjBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAjFlGiPjBiCmM_xHqqkZx_
 *							 _xZkqqHx_iPoDiImKiCpAiOkGiClHiCmMiCkJiBeBiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			atDC			:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			penDark0		:_xZkqqHx_iImDiCkCjAeGiCmMjFjNiCePiCmMiDhJiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			penLight0		:_xZkqqHx_jGlOiCoJiCkCjAeGiCmMjFjNiCePiCmMiDhJiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			penDark2		:_xZkqqHx_iImDiCkCjAeGiCmMjFjNiCfBiCmMiDhJiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			penLight2		:_xZkqqHx_jGlOiCoJiCkCjAeGiCmMjFjNiCfBiCmMiDhJiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			brsSelected		:_xZkqqHx_jBeJjBpAiClDiCoKiClNjHjKjHpAjFlGiPjBiCpAjDgIiCoIjCnHiClHiDhFiDiJiDfGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			brsUnselected	:_xZkqqHx_jGkCjBeJjBpAiCmMjHjKjHpAjFlGiPjBiCpAjDgIiCoIjCnHiClHiDhFiDiJiDfGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 *			penGray0		:_xZkqqHx_iKeEjAeGiCmMjFjNiCePiCmMiDhJiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			penExpBoxLine0	:_xZkqqHx_jDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiCmMjDoAjFjEiCmMiPfMiOjKiCpAjFgAiJoGiClHiCoJ_xHqqkZx_
 *							 _xZkqqHx_jFjNiCePiCmMiDhJiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			penExpBoxLineSelected0	:_xZkqqHx_jDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiCmMjDoAjFjEiCmMiPfMiOjKiCpAjFgAiJoGiClHiCoJ_xHqqkZx_
 *							 _xZkqqHx_jFjNiCePiCmMiDhJiDjDiBeBjGkCjBeJjBpAiOjOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			brsExpBoxSelected	:_xZkqqHx_jBeJjBpAjCiGiCmMjDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiCpAjDgIiCoIjCnHiClHiDhFiDiJiDfGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			brsExpBoxUnselected	:_xZkqqHx_jGkCjBeJjBpAiCmMjDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiCpAjDgIiCoIjCnHiClHiDhFiDiJiDfGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
// 04.05.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
// *			szBox			:_xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lFontH			:_xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCpAiOhHjCoIiBeCjAlDiCmMjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iNmEiLeBjDeJiCmJiBeBiJlKiImKiCmMjHjKjHpAjFlGiPjBiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnPaintProjectSub (	long lDocId,
											long lSelectedDocId,
											BOOL bExpBoxSelected,
											FCAutoDC& atDC, 
											FCAutoGdiStock& gdiStock,
											long lFontH)
{
	// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	const CRect rtVBox = m_pHtreeManager->GetNodeBoxRectInProject(lDocId);

	// _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiDiKiDfIiDgHiBeC_xHqqkZx_
	const longVector* vSubDocId;
	// _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiCpAjDfHiKeKiClFiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
	BOOL bSubExpanded = TRUE;
	if (lDocId != -1)
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iKgHjCkDiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
// 06.01.05 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		const FCDocRecExtData* pExtData = (const FCDocRecExtData*)m_pHtreeManager->GetDocRecExtData(lDocId).GetExtData();
		const FCDocRecExtData* pExtData = m_pHtreeManager->GetDocRecExtData(lDocId);
		// _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiDiKiDfIiDgHiBeC_xHqqkZx_
		vSubDocId = &pExtData->GetSubDocumentId();
		// _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiCpAjDfHiKeKiClFiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
		bSubExpanded = pExtData->GetIsSubTreeExpanded();

		// _xZkqqHx_jDlBjDpMjApMiCpAjFgAiJoGiBeC_xHqqkZx_
		myDrawIntroLine(pExtData->GetRootPoint(),
						CPoint(pExtData->GetBoxPoint().x, pExtData->GetRootPoint().y),
						&atDC, gdiStock);

		if (!pExtData->GetSubDocumentId().empty())
		//----- _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			CRect rtExpBox = m_pHtreeManager->GetExpBoxRectInProject(lDocId);

			// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIjFgAiJoGiBeCjBeJjBpAjCiGiCkJiCmHiCkEiCkJiCmFjAeGiCpAjFmPiCkGiCoJiBeC_xHqqkZx_
			myDrawExpBox(rtExpBox,
						!pExtData->GetIsSubTreeExpanded(),
						(bExpBoxSelected && lDocId == lSelectedDocId),
						&atDC,
						gdiStock);
		}

		// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIjFgAiJoGiBeCjBeJjBpAjCiGiCkJiCmHiCkEiCkJiCmFjAeGiCpAjFmPiCkGiCoJiBeC_xHqqkZx_
//----- 05.09.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		myDrawNode(rtVBox, (!bExpBoxSelected && lDocId == lSelectedDocId), &atDC, gdiStock);
//----- 05.09.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		myDrawNode(	m_pHtreeManager,
					rtVBox,
					&atDC,
					gdiStock,
					(!bExpBoxSelected && lDocId == lSelectedDocId),
					FALSE,
					1.0);
//----- 05.09.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDgFiDeMiDfIiDgHjAeGiBeC_xHqqkZx_
		atDC.SetTextColor(g_pReg->GetOptiRegColor(FDCL_HTREE_NODE_TEXT));
		// _xZkqqHx_iDgPiBfLiDfHiDiHiDjDiBeBiDgIiDeMiDiFiDiBiDjDiDgHjGlMiCpAjFgAiJoGiBeC_xHqqkZx_
		WString wstrVersion;
		wstrVersion.Format(L"V-%s", m_pHtreeManager->GetDocRecExtData(lDocId)->GetVersion().c_str());
		myDrawBoxText(	m_pHtreeManager,
						rtVBox,
						&atDC,
						NULL,
						m_hIconHidocument,
						lFontH,
//----- 05.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//						wstrVersion,
//						m_pHtreeManager->GetDocRecExtData(lDocId)->GetDocTitle());
//----- 05.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
						m_pHtreeManager->GetDocRecExtData(lDocId)->GetDocTitle(),
						wstrVersion);
//----- 05.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	} else
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiDiKiDfIiDgHiBeC_xHqqkZx_
		vSubDocId = &m_pHtreeManager->GetTopDocumentIdVector();
		// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIjFgAiJoGiBeCjBeJjBpAjCiGiCkJiCmHiCkEiCkJiCmFjAeGiCpAjFmPiCkGiCoJiBeC_xHqqkZx_
		myDrawProject(rtVBox, lDocId == lSelectedDocId, &atDC, gdiStock);
		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDgFiDeMiDfIiDgHjAeGiBeC_xHqqkZx_
		atDC.SetTextColor(g_pReg->GetOptiRegColor(FDCL_HTREE_NODE_TEXT));
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjGlMiCpAjFgAiJoGiBeC_xHqqkZx_
		myDrawBoxText(	m_pHtreeManager,
						rtVBox,
						&atDC,
						NULL,
						m_hIconProject,
						lFontH,
						m_pHtreeManager->GetProjectTitle());
	}

	if (bSubExpanded && !vSubDocId->empty())
	//----- _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iKgHjCkDiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
// 06.01.05 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		const FCDocRecExtData* pExtData = (const FCDocRecExtData*)m_pHtreeManager->GetDocRecExtData(vSubDocId->back()).GetExtData();
		const FCDocRecExtData* pExtData = m_pHtreeManager->GetDocRecExtData(vSubDocId->back());
		// _xZkqqHx_jBfDjBmMiCmMiPgDjApMiCpAjFgAiJoGiBeC_xHqqkZx_
		myDrawIntroLine(CPoint(pExtData->GetRootPoint().x, rtVBox.bottom),
						CPoint(pExtData->GetRootPoint().x, pExtData->GetRootPoint().y),
						&atDC,
						gdiStock);

		longVector::const_iterator iId;
		for (iId = vSubDocId->begin();
			 iId != vSubDocId->end(); iId++)
		{
			// _xZkqqHx_iJlKiImKiCmMjFgAiJoGiCpAiNhDiCkEiBeC_xHqqkZx_
			OnPaintProjectSub(	*iId,
								lSelectedDocId,
								bExpBoxSelected,
								atDC,
								gdiStock,
								lFontH);
		}
	}
} // CFCWndHistoryTree::OnPaintProjectSub.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnPaintProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiCmMjFfMiOkGiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnPaintProject (CDC* pDC)
{
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	FCAutoDC atDC(pDC, FALSE, 0, 0);
//----- 04.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
//	const CSize szBox = m_pHtreeManager->GetHistBoxSize();
//----- 04.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDhEiDeIiDjDiDgHiCmMiPiAjEpF_xHqqkZx_ -----
	// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
	atDC.SetTextColor(g_pReg->GetOptiRegColor(FDCL_HTREE_NODE_TEXT));
	// _xZkqqHx_jEhHiMgJjFgAiJoGiDiCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
	atDC.SetBkMode(TRANSPARENT);
	// _xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCpAiOoGjDlOiBeC_xHqqkZx_
	long lFontH = m_pHtreeManager->GetFontHeight(FDFT_HTREE_TEXT);
	FCAtFont font;
	m_pHtreeManager->InitFont(*font.Get(), FDFT_HTREE_TEXT);	// _xZkqqHx_iDhEiDeIiDjDiDgHiCpAiNoMjAkMiBeC_xHqqkZx_
	atDC.SetObject(font);	// _xZkqqHx_jAfGiClFiCkCiDhEiDeIiDjDiDgHiCpAjAnNjCoIiBeC_xHqqkZx_

//----- 04.06.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iDhJiDjDiBeFiDhFiDiJiDfGiCmMiPiAjEpF_xHqqkZx_ -----
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiJgFjAeG_xHqqkZx_ _xZkqqHx_jFjN_xHqqkZx_=0_xZkqqHx_iBeC_xHqqkZx_
//	FCAtPen penDark0(PS_SOLID, 0, g_pReg->GetOptiRegColor(FDCL_HTREE_SHADOW));
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiMpFjAeG_xHqqkZx_ _xZkqqHx_jFjN_xHqqkZx_=0_xZkqqHx_iBeC_xHqqkZx_
//	FCAtPen penLight0(PS_SOLID, 0, g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT));
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiJgFjAeG_xHqqkZx_ _xZkqqHx_jFjN_xHqqkZx_=2_xZkqqHx_iBeC_xHqqkZx_
//	FCAtPen penDark2(PS_SOLID, 2, g_pReg->GetOptiRegColor(FDCL_HTREE_SHADOW));
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiMpFjAeG_xHqqkZx_ _xZkqqHx_jFjN_xHqqkZx_=2_xZkqqHx_iBeC_xHqqkZx_
//	FCAtPen penLight2(PS_SOLID, 2, g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT));
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjBeJjBpAjCiGjHjKjHpAjGnIjAeGiBeC_xHqqkZx_
//	FCAtBrush brsSelected(g_pReg->GetOptiRegColor(FDCL_HTREE_SELECTION));
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjGkCjBeJjBpAjCiGjHjKjHpAjGnIjAeGiBeC_xHqqkZx_
//	FCAtBrush brsUnselected(g_pReg->GetOptiRegColor(FDCL_HTREE_NODE_FACE));
//
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiKeEjAeG_xHqqkZx_ _xZkqqHx_jFjN_xHqqkZx_=0_xZkqqHx_iBeC_xHqqkZx_
//	FCAtPen penGray0(PS_SOLID, 0, g_pReg->GetOptiRegColor(FDCL_HTREE_GRAY));
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjDfHiKeKiDhLiDfOiDjDjApMiBeC_xHqqkZx_
//	FCAtPen penExpBoxLine0(PS_SOLID, 0, g_pReg->GetOptiRegColor(FDCL_HTREE_EBOX_LINE));
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjBeJjBpAjDfHiKeKiDhLiDfOiDjDjApMiBeC_xHqqkZx_
//	FCAtPen penExpBoxLineSelected0(PS_SOLID, 0, g_pReg->GetOptiRegColor(FDCL_HTREE_EBOX_SEL_LINE));
//
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjDfHiKeKiDhLiDfOiDjDjEhHiMgJiBeC_xHqqkZx_
//	FCAtBrush brsExpBoxSelected(g_pReg->GetOptiRegColor(FDCL_HTREE_EBOX_SEL_FACE));
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMjBeJjBpAjDfHiKeKiDhLiDfOiDjDjEhHiMgJiBeC_xHqqkZx_
//	FCAtBrush brsExpBoxUnselected(g_pReg->GetOptiRegColor(FDCL_HTREE_EBOX_FACE));
//----- 04.06.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// GDI_xZkqqHx_iDfIiDgHiDgCiDeOiBeC_xHqqkZx_
	FCAutoGdiStock gdiStock;

	// _xZkqqHx_jBeJjBpAjCiGjHjKjHpAjFlGiPjBiCkKjBkOiClHiCoJiDgDiDiKiBfLiCmFiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiCmF_xHqqkZx_
	// _xZkqqHx_jDfHiKeKiClDiCoKiCmEiCkCiCoJiBeBiNmFiCoAiPoDiImKiCmMiOhNiCpAjFnEiClHiBeC_xHqqkZx_
	long lSelectedDocId = -1;
	if (GetSelectedDocumentId() != -1)
		lSelectedDocId = GetExpandedTopDocumentId(GetSelectedDocumentId());
	// _xZkqqHx_iNmEiLeBjDeJiCmJjHjKjHpAiDhLiDgCiDeOiDfIiCpAjFgAiJoGiBeC_xHqqkZx_
	OnPaintProjectSub(	-1,
						lSelectedDocId,
						lSelectedDocId != GetSelectedDocumentId(),
						atDC,
//----- 04.06.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//						penDark0,
//						penLight0,
//						penDark2,
//						penLight2,
//						brsSelected,
//						brsUnselected,
//
//						penGray0,
//						penExpBoxLine0,
//						penExpBoxLineSelected0,
//						brsExpBoxSelected,
//						brsExpBoxUnselected,
//----- 04.06.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
						gdiStock,
//----- 04.06.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

// 04.05.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//						szBox,
						lFontH);
	// _xZkqqHx_iMlLiNnNiImKjChFiCpAjFfMiOkGiBeC_xHqqkZx_
	DrawPositionMark(NULL, pDC, m_wstrCurMarkedProjectPath,
								m_lCurMarkedDocumentId,
								m_fliCurMarkedSessionIndex);
//	DrawPositionMark(NULL, pDC, m_lCurMarkedDocumentId, m_fliCurMarkedSessionIndex);
//	DrawSelectMark(NULL, pDC, GetSelectedDocumentId());
//----- 04.01.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCWndHistoryTree::OnPaintProject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnPaintTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiOjOiCmJiBeBjBfDjBmMiCmMjGnIiNfMjBkCjFgAiJoGiCpAiNhDiCkEiBeC_xHqqkZx_OnPaint_xZkqqHx_iCmMiDfEiDhFiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnPaintTree (CDC* pDC)
{
	// CDC_xZkqqHx_iCmMiDeOiDiKiDgCiDhGiDhLiDgCiDeOiDfIiCpAjDlOiCoJiBeC_xHqqkZx_lgrtClip_xZkqqHx_iCmNjIfPjHjNiNmAjFfHiMgOiBeC_xHqqkZx_
	CRect rtUpdate;
	pDC->GetClipBox(rtUpdate);

	//----- _xZkqqHx_jFgAiJoGjBmOiPnLiCmGiCmIiCoJjHjKjHpAjGnIiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiLiBiCnPiCoJ_xHqqkZx_ -----
	// _xZkqqHx_iDgHiDgCiDhGiImIiJlKiCmMjHjKjHpAjGnIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	longVector vDocId;
	m_pHtreeManager->GetTotalTreeDocId(vDocId, m_pHtreeManager->SubDocumentIdToTopId(GetSelectedDocumentId()));

	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	FCAutoDC atDC(pDC, FALSE, 0, 0);
	// GDI_xZkqqHx_iDfIiDgHiDgCiDeOiBeC_xHqqkZx_
	FCAutoGdiStock gdiStock;

	//----- _xZkqqHx_iDhEiDeIiDjDiDgHiCmMiPiAjEpF_xHqqkZx_ -----
	// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
	atDC.SetTextColor(g_pReg->GetOptiRegColor(FDCL_HTREE_NODE_TEXT));
	// _xZkqqHx_jEhHiMgJjFgAiJoGiDiCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
	atDC.SetBkMode(TRANSPARENT);
	// _xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCpAiOoGjDlOiBeC_xHqqkZx_
	long lFontH = m_pHtreeManager->GetFontHeight(FDFT_HTREE_TEXT);

	//----- _xZkqqHx_jDlBjDpMjApMiCmMjFgAiJoG_xHqqkZx_ -----

	longVector::const_iterator iDocId;
	for (iDocId = vDocId.begin(); iDocId != vDocId.end(); iDocId++)
	{
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iDocId);
		if (pRec == NULL) continue;
		myDrawIntroLine(pRec->GetRootPoint(),
						CPoint(pRec->GetBoxPoint().x, pRec->GetRootPoint().y),
						&atDC, gdiStock);
		myDrawIntroLine(CPoint(pRec->GetBoxPoint().x, pRec->GetRootPoint().y),
						pRec->GetBoxPoint(),
						&atDC, gdiStock);
	}

	//----- _xZkqqHx_jHjKjHpAjApMiCmGjGoOiIpDiCpAjFgAiJoG_xHqqkZx_ -----

	for (iDocId = vDocId.begin(); iDocId != vDocId.end(); iDocId++)
	{
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iDocId);
		if (pRec == NULL) continue;
		// _xZkqqHx_jHjKjHpAjApMiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
		const CRect rtLifeLine = pRec->GetLifeLineRect();
		// _xZkqqHx_jHjKjHpAjApMjGoOiIpDiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
		const CRect rtArrowLine = pRec->GetLifeArrowRect();
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDjEmNiImNiCmGjHjKjHpAiDfIiDfCiDeBiCmMjEhKjHpBiBeC_xHqqkZx_
		vector<FCSessionHtreeScoreRec> vSessionHtreeScore;
		pRec->GetAccumulatedHtreeScore(vSessionHtreeScore);
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->Y_xZkqqHx_iNmAjFfHiCmMiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
		map<flint, long> mpSessionToY;
		vector<FCSessionHtreeScoreRec>::const_iterator iShs;
		for (iShs = vSessionHtreeScore.begin(); iShs != vSessionHtreeScore.end(); iShs++)
		{
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDjEmNiImNiCmMiKeKiOgOiImKjChFiBeC_xHqqkZx_
			if (mpSessionToY.find(iShs->m_fliFromSessionIndex) == mpSessionToY.end())
				mpSessionToY[iShs->m_fliFromSessionIndex] = pRec->SessionIndexToYTree(iShs->m_fliFromSessionIndex);
			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDjEmNiImNiCmMiPeJjHlJiImKjChFiBeC_xHqqkZx_
			if (mpSessionToY.find(iShs->m_fliUntilSessionIndex) == mpSessionToY.end())
				mpSessionToY[iShs->m_fliUntilSessionIndex] = pRec->SessionIndexToYTree(iShs->m_fliUntilSessionIndex);
		}
		// _xZkqqHx_jHjKjHpAjApMjFgAiJoGiBeCjBeJjBpAjCiGiCkJiCmHiCkEiCkJiCmFjAeGiCpAjFmPiCkGiCoJiBeC_xHqqkZx_

		if (GetSelectedObject() == FDTR_TRUNK_REC &&
			GetSelectedDocumentId() == *iDocId)
		//----- _xZkqqHx_jBeJjBpAjCiGiCmMiPoKiNiH_xHqqkZx_ -----
		{
			myDrawLifeArrow(rtLifeLine,
							rtArrowLine,
							vSessionHtreeScore,
							mpSessionToY,
							&atDC,
							gdiStock,
							TRUE);
		} else
		//----- _xZkqqHx_jBeJjBpAjCiGiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			myDrawLifeArrow(rtLifeLine,
							rtArrowLine,
							vSessionHtreeScore,
							mpSessionToY,
							&atDC,
							gdiStock,
							FALSE);
		}
	}

	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjFgAiJoG_xHqqkZx_ -----

	for (iDocId = vDocId.begin(); iDocId != vDocId.end(); iDocId++)
	{
		long lIndex;
		for (lIndex = 0;; lIndex++)
		{
			CRect rtHiForkTag = GetRectInTree(*iDocId, FDTR_HI_FORK_TAG_REC, lIndex);
			if (rtHiForkTag.IsRectNull()) break;
			atDC.DrawIconEx(rtHiForkTag.left,
							rtHiForkTag.top,
							m_hIconHiForkTag,
							0, 0, 0, NULL, DI_NORMAL);
			if (GetSelectedDocumentId() == *iDocId &&
				GetSelectedObject() == FDTR_HI_FORK_TAG_REC &&
				GetSelectedObjectId() == lIndex)
			//----- _xZkqqHx_jBeJjBpAjCiGiCmMjHjKjHpAjFkKiKpCiDfOiDePiCmMiPoKiNiH_xHqqkZx_ -----
			{
				atDC.SetPen(PS_SOLID, 2, g_pReg->GetOptiRegColor(FDCL_HTREE_SELECTION));
				atDC.SetStockBrush(HOLLOW_BRUSH);
				atDC.Rectangle(rtHiForkTag);
			}
		}
	}

	//----- _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiOpMiImNiBgJiPoDiJlKiBgKiCmMiDeNiDiDiDgCiDhGiCmMjFgAiJoG_xHqqkZx_ -----
	for (iDocId = vDocId.begin(); iDocId != vDocId.end(); iDocId++)
	{
		// _xZkqqHx_jHfMiCnPiBeBjEhHiMgJjAeGiCmFjHjKjHpAiDhLiDgCiDeOiDfIiCmMiOpMiImNiCpAiPkNiClFjBoFiCkLiCnPiCmJjDgIiCoIiCmCiCnEiClHiBeC_xHqqkZx_
		// _xZkqqHx_iKpJiCmJjFgAiJoGiClDiCoKiCmEiCkCiCoJjHjKjHpAjApMiCmIiCmHiCmJiBeBiMiEiKnEiCpAjHfOiCkGiCoJiClNiCnPiBeC_xHqqkZx_

		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iDocId);
		if (pRec == NULL) continue;
		//
		//             pRec->GetBoxPoint().x
		//                    _xZkqqHx_iEkL_xHqqkZx_
		//          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEkLiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkCiEjPiEkJ_xHqqkZx_
		//          _xZkqqHx_iEkA_xHqqkZx_ rtGap0 _xZkqqHx_iEkL_xHqqkZx_    rtGap1    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_m_pHtreeManager->GetHtBoxGapY()
		//          _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkNiEjPiEkJ_xHqqkZx_
		//          _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_
		//          _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_
		//          _xZkqqHx_iEkL_xHqqkZx_ pRec->GetNodeBoxRect() _xZkqqHx_iEkL_xHqqkZx_
		//          _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_
		//          _xZkqqHx_iEkL_xHqqkZx_                        _xZkqqHx_iEkL_xHqqkZx_
		//          _xZkqqHx_iEkPiEkKiEkKiEkKiEkNiEjPiEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkOiEjPiEkJ_xHqqkZx_
		//          _xZkqqHx_iEkA_xHqqkZx_rtGap2_xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  rtGap3    _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_m_pHtreeManager->GetHtBoxGapY()
		//          _xZkqqHx_iEkEiEjPiEjPiEjPiEkL_xHqqkZx_  _xZkqqHx_iEkLiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEjPiEkJ_xHqqkZx_
		//                  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
		//                  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_ pRec->GetLifeLineRect()
		//                  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
		//                _xZkqqHx_iEkMiEkOiEjPiEkPiEkN_xHqqkZx_
		//                 _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
		//                   _xZkqqHx_iBfPiBfO_xHqqkZx_
		//
		// _xZkqqHx_jHjKjHpAjApMiCmMiLoJiMgAiBeC_xHqqkZx_
		const CRect rtLifeLine = pRec->GetLifeLineRect();
		// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCmMiLoJiMgAiBeC_xHqqkZx_
		const CRect rtVBox = pRec->GetNodeBoxRect();
		// _xZkqqHx_iDeNiDiDiDgCiDhGiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
		const CRect rtGap0(	rtVBox.left,
							rtVBox.top - m_pHtreeManager->GetHtBoxGapY(),
							pRec->GetBoxPoint().x - 2,
							rtVBox.top);
		const CRect rtGap1(	pRec->GetBoxPoint().x + 2,
							rtVBox.top - m_pHtreeManager->GetHtBoxGapY(),
							rtVBox.right,
							rtVBox.top);
		const CRect rtGap2(	rtVBox.left,
							rtVBox.bottom,
							rtLifeLine.left - 2,
							rtVBox.bottom + m_pHtreeManager->GetHtBoxGapY());
		const CRect rtGap3(	rtLifeLine.right + 2,
							rtVBox.bottom,
							rtVBox.right,
							rtVBox.bottom + m_pHtreeManager->GetHtBoxGapY());
		atDC.FillRect(rtGap0, gdiStock.GetRegBrush(FDCL_HTREE_BACKGROUND));
		atDC.FillRect(rtGap1, gdiStock.GetRegBrush(FDCL_HTREE_BACKGROUND));
		atDC.FillRect(rtGap2, gdiStock.GetRegBrush(FDCL_HTREE_BACKGROUND));
		atDC.FillRect(rtGap3, gdiStock.GetRegBrush(FDCL_HTREE_BACKGROUND));
	}
	//----- _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCmMjFgAiJoG_xHqqkZx_ -----
	FCAtFont font;
	m_pHtreeManager->InitFont(*font.Get(), FDFT_HTREE_TEXT);	// _xZkqqHx_iDhEiDeIiDjDiDgHiCpAiNoMjAkMiBeC_xHqqkZx_
	atDC.SetObject(font);		// _xZkqqHx_jAfGiClFiCkCiDhEiDeIiDjDiDgHiCpAjAnNjCoI_xHqqkZx_.
	for (iDocId = vDocId.begin(); iDocId != vDocId.end(); iDocId++)
	{
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iDocId);
		if (pRec == NULL) continue;
		CRect rtVBox = pRec->GetNodeBoxRect();
		// _xZkqqHx_jBeJjBpAjCiGiCmIiCoHjHjKjHpAiDhLiDgCiDeOiDfIiCpAjDgIiCoIjCnHiClHiBeC_xHqqkZx_
		if (GetSelectedObject() == FDTR_TRUNK_REC &&
			GetSelectedDocumentId() == *iDocId)
		//----- _xZkqqHx_jBeJjBpAjCiGiCmMiPoKiNiH_xHqqkZx_ -----
		{
			myDrawNode(	m_pHtreeManager,
						rtVBox,
						&atDC,
						gdiStock,
						TRUE,
						TRUE,
						pRec->GetAccumulatedHtreeScore(-1));
		} else
		//----- _xZkqqHx_jBeJjBpAjCiGiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ ------
		{
			myDrawNode(	m_pHtreeManager,
						rtVBox,
						&atDC,
						gdiStock,
						FALSE,
						TRUE,
						pRec->GetAccumulatedHtreeScore(-1));
		}
		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDgFiDeMiDfIiDgHjAeGiBeC_xHqqkZx_
		atDC.SetTextColor(g_pReg->GetOptiRegColor(FDCL_HTREE_NODE_TEXT));
		// _xZkqqHx_iDgPiBfLiDfHiDiHiDjDiBeBiDgIiDeMiDiFiDiBiDjDiDgHjGlMiCpAjFgAiJoGiBeC_xHqqkZx_
		WString wstrVersion;
		wstrVersion.Format(L"V-%s", (const wchar_t*)pRec->GetVersionString());
		myDrawBoxText(	m_pHtreeManager,
						rtVBox,
						&atDC,
						NULL,
						m_hIconHidocument,
						lFontH,
//----- 05.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//						wstrVersion,
//						pRec->GetDocumentTitle());
//----- 05.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
						pRec->GetDocumentTitle(),
						wstrVersion);
//----- 05.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	// _xZkqqHx_iMlLiNnNiImKjChFiCpAjFfMiOkGiBeC_xHqqkZx_
	DrawPositionMark(	NULL,
						pDC,
						m_wstrCurMarkedProjectPath,
						m_lCurMarkedDocumentId,
						m_fliCurMarkedSessionIndex);
	// _xZkqqHx_iJlMjAnNjFkKiKpCiCpAjFfMiOkGiBeC_xHqqkZx_
	if (!m_wstrTempMarkProjectPath.IsEmpty())
		DrawTempMarkMark(pDC);
} // CFCWndHistoryTree::OnPaintTree.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnPaintBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiCmMjFfMiOkGiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnPaintBranch (CDC* pDC)
{
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	FCAutoDC atDC(pDC, FALSE, 0, 0);
	// GDI_xZkqqHx_iDfIiDgHiDgCiDeOiBeC_xHqqkZx_
	FCAutoGdiStock gdiStock;
	// _xZkqqHx_iOjOiKnEjHmMiIoGiCmMjFjNiCpAiOoGjDlOiBeCiDhEiDeIiDjDiDgHiNiCiCmMiCfHjEhLiBeC_xHqqkZx_
	const long lTimeWidth = m_pHtreeManager->CalcTimeViewWidth();
	//----- _xZkqqHx_iDhEiDeIiDjDiDgHiCmMiPiAjEpF_xHqqkZx_ -----
	// _xZkqqHx_jEhHiMgJjFgAiJoGiDiCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
	atDC.SetBkMode(TRANSPARENT);
	// _xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCpAiOoGjDlOiBeC_xHqqkZx_
	const long lFontH = m_pHtreeManager->GetFontHeight(FDFT_HTREE_TEXT);
	const long lTimeFontH = m_pHtreeManager->GetFontHeight(FDFT_HTREE_TIME);

	// _xZkqqHx_iOjOiKnEiDhCiDiFiBfLiCmMiLoJiMgAiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
	CRect rtTmView(0, 0, lTimeWidth, m_pHtreeManager->GetMostRightBottom().y);
	// _xZkqqHx_jFfMiOkGiJoGjGmKiCmMiLoJiMgAiCmMjIfPjHjNiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(rtClient);
	rtClient = DPtoLP(rtClient);
	// _xZkqqHx_iOjOiKnEiDhCiDiFiBfLiLoJiMgAiCmGjFfMiOkGiJoGjGmKiCmMiPgEiCmIiCmBiClNjFjEjFkKiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	rtTmView &= rtClient;
	// _xZkqqHx_iOjOiKnEiDhCiDiFiBfLiCmMiNiCiClDiCkKjFfMiOkGiJoGjGmKiCmJjEoEiCnHiCmEiPkMiClDiCkCiOjOiBeBjFfMiOkGiJoGjGmKiCkCiCmBiCmPiCkCiCmJiKgHjBoFiBeC_xHqqkZx_
	if (rtTmView.bottom < rtClient.bottom) rtTmView.bottom = rtClient.bottom;
	// _xZkqqHx_iPgEiCmIiCoIiCmMiLoJiMgAiCpAjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiOjOiKnEiDfNiBfLiDjDiCmMjEhHiMgJjAeGiCmFjDgIiCoIjCnHiClHiBeC_xHqqkZx_
	atDC.FillRect(rtTmView, gdiStock.GetRegBrush(FDCL_HTREE_TIME_ZONE_BACK));
	// _xZkqqHx_iOjOiKnEiDhCiDiFiBfLiCmGjHjKjHpAjApMiDhCiDiFiBfLiCmMiLkLiKeFjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	atDC.SetObject(gdiStock.GetRegPen(PS_SOLID, 0, FDCL_HTREE_SHADOW));
	atDC.MoveTo(rtTmView.right, rtTmView.top);
	atDC.LineTo(rtTmView.right, rtTmView.bottom);
	// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiCmMiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	FCHTreeRec* pCurRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
	if (pCurRec == NULL) return;
	//----- _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCmMjFgAiJoG_xHqqkZx_ -----
	// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
	atDC.SetTextColor(g_pReg->GetOptiRegColor(FDCL_HTREE_NODE_TEXT));

	FCAtFont font;
	m_pHtreeManager->InitFont(*font.Get(), FDFT_HTREE_TEXT);	// _xZkqqHx_iDhEiDeIiDjDiDgHiCpAiNoMjAkMiBeC_xHqqkZx_
	atDC.SetObject(font);					// _xZkqqHx_jAfGiClFiCkCiDhEiDeIiDjDiDgHiCpAjAnNjCoIiBeC_xHqqkZx_

	CRect rtVBox = pCurRec->GetNodeBoxRect();
	// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCpAjFgAiJoGiBeC_xHqqkZx_
	myDrawNode(	m_pHtreeManager,
				rtVBox,
				&atDC,
				gdiStock,
				GetSelectedObject() == FDTR_TRUNK_REC,
				TRUE,
				pCurRec->GetAccumulatedHtreeScore(-1));

	// _xZkqqHx_iDgPiBfLiDfHiDiHiDjDiBeBiDgIiDeMiDiFiDiBiDjDiDgHjGlMiCpAjFgAiJoGiBeC_xHqqkZx_
	WString wstrVersion;
	wstrVersion.Format(L"V-%s", (const wchar_t*)pCurRec->GetVersionString());
	myDrawBoxText(	m_pHtreeManager,
					rtVBox,
					&atDC,
					NULL,
					m_hIconHidocument,
					lFontH,
//----- 05.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//					wstrVersion,
//					pCurRec->GetDocumentTitle());
//----- 05.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
					pCurRec->GetDocumentTitle(),
					wstrVersion);
//----- 05.11.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_jFkKiKpCjHjKjHpAiDhLiDgCiDeOiDfI_xHqqkZx_/_xZkqqHx_iDiJiDhIiDiLiDhLiDgCiDeOiDfIiCmMjFgAiJoG_xHqqkZx_ -----
	FTSessionToNodeMmap::const_iterator iN;
	for (iN = pCurRec->GetSessionToNodeMmap().begin();
		 iN != pCurRec->GetSessionToNodeMmap().end(); iN++)
	{
		rtVBox.SetRect(	(*iN).second.m_ptRoot.x,
						(*iN).second.m_ptRoot.y - m_pHtreeManager->GetHistBoxSize().cy / 2,
						(*iN).second.m_ptRoot.x + m_pHtreeManager->GetHistBoxSize().cx,
						(*iN).second.m_ptRoot.y + m_pHtreeManager->GetHistBoxSize().cy / 2);
		// _xZkqqHx_jBeJjBpAiPpDjBnEiCkJiCmHiCkEiCkJiBeC_xHqqkZx_
		BOOL bIsSelected = (*iN).second.m_class == GetSelectedObject() &&
							(*iN).second.m_lId == GetSelectedObjectId();

		if ((*iN).second.m_class == FDTR_HTREE_REC)	// _xZkqqHx_jHjKjHpAjGnIiDgNiBfLiDgIiCmMiPoKiNiHiBeC_xHqqkZx_
		{
			FCHTreeRec* pTRec = m_pHtreeManager->DocumentIdToHTreeRec((*iN).second.m_lId);
			myDrawNode(	m_pHtreeManager,
						rtVBox,
						&atDC,
						gdiStock,
						bIsSelected,
						FALSE,
						pTRec->GetAccumulatedHtreeScore(-1));
		} else
		{
			// _xZkqqHx_iDiJiDhIiDiLiDhEiDiMiBfLiDiAiCpAjFgAiJoGiBeCjBeJjBpAiPpDjBnEiCkJiCmHiCkEiCkJiCmFiPiIjHjNiCoNiCkPiBeC_xHqqkZx_
			myDrawLabelEdge(rtVBox, &atDC, gdiStock, bIsSelected);
		}

		//----- _xZkqqHx_iDiJiDhIiDiLiCnGiCmMjDlBjDpMjApMiCmMjFgAiJoG_xHqqkZx_ -----
		if (rtVBox.left <= pCurRec->GetBoxPoint().x + m_pHtreeManager->GetHtLineIntroX())
		{
			myDrawIntroLine(CPoint(pCurRec->GetBoxPoint().x + m_pHtreeManager->GetHtLifeWidthH(), (*iN).second.m_ptRoot.y),
							(*iN).second.m_ptRoot,
							&atDC,
							gdiStock);
		}
		switch ((*iN).second.m_class)
		{
		case FDTR_HTREE_REC:	// _xZkqqHx_jHjKjHpAjGnIiDgNiBfLiDgIiCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
			atDC.SetTextColor(g_pReg->GetOptiRegColor(FDCL_HTREE_NODE_TEXT));
			FCHTreeRec* pTRec = m_pHtreeManager->DocumentIdToHTreeRec((*iN).second.m_lId);
			// _xZkqqHx_iDgPiBfLiDfHiDiHiDjDiBeBiDgIiDeMiDiFiDiBiDjDiDgHjGlMiCpAjFgAiJoGiBeC_xHqqkZx_
			WString wstrVersion;
			wstrVersion.Format(L"V-%s", (const wchar_t*)pTRec->GetVersionString());
			myDrawBoxText(	m_pHtreeManager,
							rtVBox,
							&atDC,
							NULL,
							m_hIconHidocument,
							lFontH,
							pTRec->GetDocumentTitle(),
							wstrVersion);
			break;
		  }
		case FDTR_LABEL_REC:		// _xZkqqHx_iDiJiDhIiDiLiCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
			atDC.SetTextColor(g_pReg->GetOptiRegColor(FDCL_HTREE_LABEL_TEXT));
// 06.04.07 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			const FCHLabelBeginRec* pLRec = pCurRec->GetHLabelBeginRec((*iN).second.m_lId);
			const FCHiLabelRec* pLRec = pCurRec->GetHiLabelRec((*iN).second.m_lId);
			// _xZkqqHx_iDiJiDhIiDiLiCpAjFgAiJoGiBeC_xHqqkZx_
			myDrawBoxText(	m_pHtreeManager,
							rtVBox,
							&atDC,
							NULL,
							m_hIconBgnLabel,
							lFontH,
							pLRec->GetLabelString());
			break;
		  }
		case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
			atDC.SetTextColor(g_pReg->GetOptiRegColor(FDCL_HTREE_LABEL_TEXT));
			const FCHiForkTagRec* pTLRec = pCurRec->GetHiForkTagRec((*iN).second.m_lId);
			// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjFgAiJoGiBeC_xHqqkZx_
			myDrawBoxText(	m_pHtreeManager,
							rtVBox,
							&atDC,
							NULL,
							m_hIconHiForkTag,
							lFontH,
							pTLRec->GetTitleString(),
							pTLRec->GetCommentString());
			break;
		  }
//----- 05.09.14 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		case FDTR_TIME_LABEL_REC:		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
			atDC.SetTextColor(g_pReg->GetOptiRegColor(FDCL_HTREE_LABEL_TEXT));
			const FCTimeLabelRec* pTRec = pCurRec->GetTimeLabelRec((*iN).second.m_lId);
			// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAjFgAiJoGiBeC_xHqqkZx_
			myDrawBoxText(	m_pHtreeManager,
							rtVBox,
							&atDC,
							NULL,
							m_hIconTimeLabel,
							lFontH,
							pTRec->GetContentsText());
			break;
		  }
//----- 05.09.14 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		}
	}
	//----- _xZkqqHx_jHjKjHpAjApMiCmGjGoOiIpDiCpAjFgAiJoG_xHqqkZx_ -----
	// _xZkqqHx_jHjKjHpAjApMiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
	const CRect rtLifeLine = pCurRec->GetLifeLineRect();
	// _xZkqqHx_jHjKjHpAjApMjGoOiIpDiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
	const CRect rtArrowLine = pCurRec->GetLifeArrowRect();
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDjEmNiImNiCmGjHjKjHpAiDfIiDfCiDeBiCmMjEhKjHpBiBeC_xHqqkZx_
	vector<FCSessionHtreeScoreRec> vSessionHtreeScore;
	pCurRec->GetAccumulatedHtreeScore(vSessionHtreeScore);
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->Y_xZkqqHx_iNmAjFfHiCmMiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	map<flint, long> mpSessionToY;
	vector<FCSessionHtreeScoreRec>::const_iterator iShs;
	for (iShs = vSessionHtreeScore.begin(); iShs != vSessionHtreeScore.end(); iShs++)
	{
		// _xZkqqHx_jHjKjHpAiOhNiCmMiImKjChFiCmMiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
		mpSessionToY[iShs->m_fliFromSessionIndex] = pCurRec->SessionIndexToYBranch(iShs->m_fliFromSessionIndex);
		// _xZkqqHx_jHjKjHpAiOhNiCmMiImKjChFiCmMiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
		mpSessionToY[iShs->m_fliUntilSessionIndex] = pCurRec->SessionIndexToYBranch(iShs->m_fliUntilSessionIndex);
	}
	myDrawLifeArrow(rtLifeLine,
					rtArrowLine,
					vSessionHtreeScore,
					mpSessionToY,
					&atDC,
					gdiStock,
					GetSelectedObject() == FDTR_TRUNK_REC);

	//----- _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiCpAjFgAiJoGiClHiCoJ_xHqqkZx_ -----
	FCAtFont fntTime;
	LOGFONT logFont;
	m_pHtreeManager->InitFont(logFont, FDFT_HTREE_TIME);
	logFont.lfUnderline = TRUE;
	::FFCreateFontIndirect(*(fntTime.Get()), logFont);
	atDC.SetObject(fntTime);			// _xZkqqHx_jAfGiClFiCkCiDhEiDeIiDjDiDgHiCpAjAnNjCoI_xHqqkZx_.

	// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
	atDC.SetTextColor(g_pReg->GetOptiRegColor(FDCL_HTREE_TIME_ZONE_TEXT));
	// _xZkqqHx_iDgFiDeMiDfIiDgHjEhHiMgJjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
	atDC.SetBkColor(g_pReg->GetOptiRegColor(FDCL_HTREE_TIME_ZONE_BACK));
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFgAiJoGiOjOiCmJjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClHiCoGiCkEjAnNjCoIiBeCiOjOiKnEjFfMiOkGiCmNiPgEiCmIiCoJiCmG_xHqqkZx_
	// _xZkqqHx_iMkJiCkGiCmDiCoHiCkNiCmIiCoJiClNiCnPiBeC_xHqqkZx_
	atDC.SetBkMode(OPAQUE);
	HTRTimeRecVector::const_iterator iT;
	CRect rtTime;
	COleDateTime otmDate;
	for (iT = pCurRec->GetTimeRecVector().begin();
		 iT != pCurRec->GetTimeRecVector().end(); iT++)
	{
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDjEmNiImNiKePiCmMiOjOiKnEiCmMiPoKiNiH_xHqqkZx_(Undo_xZkqqHx_iClFiCmEiCkCiCoJiPoKiNiHiCmNiCmNiCnNiPgPiClHiClBiCmGiCkKiCkAiCoJ_xHqqkZx_)_xZkqqHx_iCmNiPeJjHlJiBeC_xHqqkZx_
		if (pCurRec->GetEndSessionIndex() < (*iT).m_fliSessionIdx) break;
		otmDate = FdsecToFiletime((*iT).m_fdstTime);
		rtTime.SetRect(0, (*iT).m_y - lTimeFontH,
						lTimeWidth - 5, (*iT).m_y + lTimeFontH);

		// _xZkqqHx_jHoBiBeG_xHqqkZx_04/12/19 12:15
		// IDS_FORM_DATE_TIME = "%y/%m/%d %H:%M"
		atDC.DrawText(TStrToWStr(otmDate.Format(FFLoadString(IDS_FORM_DATE_TIME))), CP_ACP, rtTime, DT_RIGHT | DT_TOP);
	}
	// _xZkqqHx_iDgFiDeMiDfIiDgHjEhHiMgJiCpAjDkHjGlOiCmJjGnPiClHiBeC_xHqqkZx_
	atDC.SetBkMode(TRANSPARENT);
	// _xZkqqHx_iMlLiNnNiImKjChFiCpAjFfMiOkGiBeC_xHqqkZx_
	DrawPositionMark(NULL, pDC, m_wstrCurMarkedProjectPath,
								m_lCurMarkedDocumentId,
								m_fliCurMarkedSessionIndex);
	// _xZkqqHx_iJlMjAnNjFkKiKpCiCpAjFfMiOkGiBeC_xHqqkZx_
	if (!m_wstrTempMarkProjectPath.IsEmpty())
		DrawTempMarkMark(pDC);
} // CFCWndHistoryTree::OnPaintBranch.

//----- 05.09.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::WhichPtInProjectSub
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkCiCmEiBeBiOhHjCoIiCmMjHjKjHpAjFlGiPjBiCoGiCoI_xHqqkZx_
// *			_xZkqqHx_iJlKjHkMiCmMjHjKjHpAjFlGiPjBiCmJiKnGiClFiCmEiOhHjCoIiCmMiNmAjFfHiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpA_xHqqkZx_
// *			_xZkqqHx_jClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lHitDocId	:_xZkqqHx_iDhBiDgCiDgHiClFiClNjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *						 _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
// *			bHitExpandBox:_xZkqqHx_jDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_
// *						 TRUE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			lgrtHitBox	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
// *			lDocId		:_xZkqqHx_jClCiCnHiCoJjBmOiPnLiCmMjHjKjHpAjFlGiPjBiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
// *			pt			:_xZkqqHx_jClCiCnHiCoJiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	WhichPtInProject_xZkqqHx_iCmMjFjLiKnGjAjEiBeCiNmEiLeBjDeJiCmJiBeB_xHqqkZx_lDocId_xZkqqHx_iImIiJlKiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCWndHistoryTree::WhichPtInProjectSub (long& lHitDocId,
//											BOOL& bHitExpandBox,
//											CRect& lgrtHitBox,
//											long lDocId,
//											const CPoint& pt) const
//{
//	// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
//	const CRect rtBox = m_pHtreeManager->GetNodeBoxRectInProject(lDocId);
//	// _xZkqqHx_iClBiCmMjHjKjHpAjFlGiPjBiCkKjDfHiKeKiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeBiClBiCoKiImIiPoDjClCiCnHiCmIiCkCiBeC_xHqqkZx_
//	if (rtBox.IsRectNull()) return FALSE;
//	if (rtBox.PtInRect(pt))
//	//----- _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIjCiGiCmJiNmAjFfHiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		lHitDocId = lDocId;
//		bHitExpandBox = FALSE;
//		lgrtHitBox = rtBox;
//		return TRUE;
//	}
//	if (lDocId == -1)
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		longVector::const_iterator iId;
//		for (iId = m_pHtreeManager->GetTopDocumentIdVector().begin();
//			 iId != m_pHtreeManager->GetTopDocumentIdVector().end(); iId++)
//		{
//			// _xZkqqHx_iOhBiLjPiCmMjHjKjHpAjFlGiPjBiCmJiKnGiClFiCmEjClCiCnHiCoJiBeC_xHqqkZx_
//			if (WhichPtInProjectSub(lHitDocId, bHitExpandBox, lgrtHitBox, *iId, pt))
//				return TRUE;
//		}
//	} else
//	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iKgHjCkDiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
//		const FCDocRecExtData* pExtData = (const FCDocRecExtData*)m_pHtreeManager->GetDocRecExtData(lDocId).GetExtData();
//		if (!pExtData->GetSubDocumentId().empty())
//		//----- _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_jDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiCmMiNmAjFfHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//			const CRect rtBox = m_pHtreeManager->GetExpBoxRectInProject(lDocId);
//			if (rtBox.PtInRect(pt))
//			//----- _xZkqqHx_jDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIjCiGiCmJiNmAjFfHiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//			{
//				lHitDocId = lDocId;
//				bHitExpandBox = TRUE;
//				lgrtHitBox = rtBox;
//				return TRUE;
//			}
//			longVector::const_iterator iId;
//			for (iId = pExtData->GetSubDocumentId().begin(); iId != pExtData->GetSubDocumentId().end(); iId++)
//			{
//				// _xZkqqHx_iOhBiLjPiCmMjHjKjHpAjFlGiPjBiCmJiKnGiClFiCmEjClCiCnHiCoJiBeC_xHqqkZx_
//				if (WhichPtInProjectSub(lHitDocId, bHitExpandBox, lgrtHitBox, *iId, pt))
//					return TRUE;
//			}
//		}
//	}
//	return FALSE;
//} // CFCWndHistoryTree::WhichPtInProjectSub.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::WhichPtInProject
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkCiCmEiBeBiNmAjFfHiCkKiCmHiCmMjHjKjHpAiPoDiCmJiCkAiCoJiCkJiCpA_xHqqkZx_
// *			_xZkqqHx_jClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lHitDocId	:_xZkqqHx_iDhBiDgCiDgHiClFiClNjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *						 _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
// *			bHitExpandBox:_xZkqqHx_jDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_
// *						 TRUE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			lgrtHitBox	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
// *			pt			:_xZkqqHx_jClCiCnHiCoJiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCWndHistoryTree::WhichPtInProject (	long& lHitDocId,
//											BOOL& bHitExpandBox,
//											CRect& lgrtHitBox,
//											const CPoint& pt) const
//{
//	return WhichPtInProjectSub(	lHitDocId,
//								bHitExpandBox,
//								lgrtHitBox,
//								-1,
//								pt);
//} // CFCWndHistoryTree::WhichPtInProject.
//----- 05.09.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::WhichPtInProjectSub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkCiCmEiBeBiOhHjCoIiCmMjHjKjHpAjFlGiPjBiCoGiCoI_xHqqkZx_
 *			_xZkqqHx_iJlKjHkMiCmMjHjKjHpAjFlGiPjBiCmJiKnGiClFiCmEiOhHjCoIiCmMiNmAjFfHiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpA_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lHitDocId	:_xZkqqHx_iDhBiDgCiDgHiClFiClNjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *			lgrtHitBox	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *			lDocId		:_xZkqqHx_jClCiCnHiCoJjBmOiPnLiCmMjHjKjHpAjFlGiPjBiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			pt			:_xZkqqHx_jClCiCnHiCoJiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDTR_NONE_REC	:_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
 *			FDTR_TRUNK_REC	:_xZkqqHx_jHjKjHpAjFlGiPjBiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
 *			FDTR_EXPBOX_REC	:_xZkqqHx_jDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	WhichPtInProject_xZkqqHx_iCmMjFjLiKnGjAjEiBeCiNmEiLeBjDeJiCmJiBeB_xHqqkZx_lDocId_xZkqqHx_iImIiJlKiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			05.09.27 Fukushiro M. _xZkqqHx_jFnEjCgMiCpAjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
FDTRClass CFCWndHistoryTree::WhichPtInProjectSub (	long& lHitDocId,
													CRect& lgrtHitBox,
													long lDocId,
													const CPoint& pt) const
{
	// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	const CRect rtBox = m_pHtreeManager->GetNodeBoxRectInProject(lDocId);
	// _xZkqqHx_iClBiCmMjHjKjHpAjFlGiPjBiCkKjDfHiKeKiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeBiClBiCoKiImIiPoDjClCiCnHiCmIiCkCiBeC_xHqqkZx_
	if (rtBox.IsRectNull()) return FDTR_NONE_REC;
	if (rtBox.PtInRect(pt))
	//----- _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIjCiGiCmJiNmAjFfHiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		lHitDocId = lDocId;
		lgrtHitBox = rtBox;
		return FDTR_TRUNK_REC;
	}
	if (lDocId == -1)
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
	{
		longVector::const_iterator iId;
		for (iId = m_pHtreeManager->GetTopDocumentIdVector().begin();
			 iId != m_pHtreeManager->GetTopDocumentIdVector().end(); iId++)
		{
			// _xZkqqHx_iOhBiLjPiCmMjHjKjHpAjFlGiPjBiCmJiKnGiClFiCmEjClCiCnHiCoJiBeC_xHqqkZx_
			FDTRClass cls = WhichPtInProjectSub(lHitDocId, lgrtHitBox, *iId, pt);
			if (cls != FDTR_NONE_REC) return cls;
		}
	} else
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iKgHjCkDiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
// 06.01.05 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		const FCDocRecExtData* pExtData = (const FCDocRecExtData*)m_pHtreeManager->GetDocRecExtData(lDocId).GetExtData();
		const FCDocRecExtData* pExtData = m_pHtreeManager->GetDocRecExtData(lDocId);
		if (!pExtData->GetSubDocumentId().empty())
		//----- _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiCmMiNmAjFfHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
			const CRect rtBox = m_pHtreeManager->GetExpBoxRectInProject(lDocId);
			if (rtBox.PtInRect(pt))
			//----- _xZkqqHx_jDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIjCiGiCmJiNmAjFfHiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				lHitDocId = lDocId;
				lgrtHitBox = rtBox;
				return FDTR_EXPBOX_REC;
			}
//----- 06.01.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			longVector::const_iterator iId;
//			for (iId = pExtData->GetSubDocumentId().begin();
//				 iId != pExtData->GetSubDocumentId().end(); iId++)
//----- 06.01.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			mdef_const_iterator(longVector, iId);
			m1_for (iId, pExtData->GetSubDocumentId())
//----- 06.01.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			{
				// _xZkqqHx_iOhBiLjPiCmMjHjKjHpAjFlGiPjBiCmJiKnGiClFiCmEjClCiCnHiCoJiBeC_xHqqkZx_
				FDTRClass cls = WhichPtInProjectSub(lHitDocId, lgrtHitBox, *iId, pt);
				if (cls != FDTR_NONE_REC) return cls;
			}
		}
	}
	return FDTR_NONE_REC;
} // CFCWndHistoryTree::WhichPtInProjectSub.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::WhichPtInProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkCiCmEiBeBiNmAjFfHiCkKiCmHiCmMjHjKjHpAiPoDiCmJiCkAiCoJiCkJiCpA_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lHitDocId	:_xZkqqHx_iDhBiDgCiDgHiClFiClNjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *			lgrtHitBox	:_xZkqqHx_iDhBiDgCiDgHiClFiClNiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *			pt			:_xZkqqHx_jClCiCnHiCoJiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FDTR_NONE_REC	:_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
 *			FDTR_TRUNK_REC	:_xZkqqHx_jHjKjHpAjFlGiPjBiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
 *			FDTR_EXPBOX_REC	:_xZkqqHx_jDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			05.09.27 Fukushiro M. _xZkqqHx_jFnEjCgMiCpAjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
FDTRClass CFCWndHistoryTree::WhichPtInProject (	long& lHitDocId,
												CRect& lgrtHitBox,
												const CPoint& pt) const
{
	return WhichPtInProjectSub(	lHitDocId,
								lgrtHitBox,
								-1,
								pt);
} // CFCWndHistoryTree::WhichPtInProject.
//----- 05.09.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 05.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::WhichPtInTree
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkCiCmEiBeBiNmAjFfHiCkKiCmHiCmMjHjKjHpAiPoDiCmJiCkAiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_jHjKjHpAiImKjChFiBgJiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBgKiCpAjFnEiClHiBeC_xHqqkZx_
// *			lDocId			:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			lHiForkTagId	:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDeP_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			lgrtHitBox		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
// *			pt				:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPoDiCmJiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBjGlDiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_lDocId_xZkqqHx_iCmG_xHqqkZx_lHiForkTagId_xZkqqHx_iCmM_xHqqkZx_
// *			_xZkqqHx_jHlMjFpLiCmMjFmPjAjEiCmJjCgMiCkKjFnEiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCWndHistoryTree::WhichPtInTree (	flint& fliSessionIndex,
//										long& lDocId,
//										long& lHiForkTagId,
//										CRect& lgrtHitBox,
//										const CPoint& pt)
//{
//	lDocId = -1;		// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	lHiForkTagId = -1;	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDeP_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//
//	// _xZkqqHx_iDgHiDgCiDhGiImIiJlKiCmMjHjKjHpAjGnIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
//	const long lTopDocId = m_pHtreeManager->GetProject()->SubDocumentIdToTopId(GetSelectedDocumentId());
//	longVector vDocId;
//	m_pHtreeManager->GetTotalTreeDocId(vDocId, lTopDocId);
//
//	//----- _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCmMiPoDiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_ -----
//
//	longVector::const_iterator iDocId;
//	for (iDocId = vDocId.begin(); iDocId != vDocId.end(); iDocId++)
//	{
//		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iDocId);
//		if (pRec == NULL) continue;
//		const CRect rtVBox = pRec->GetNodeBoxRect();
//		if (rtVBox.PtInRect(pt))
//		{
//			lDocId = *iDocId;
//			fliSessionIndex = pRec->GetFirstSessionIndex();
//			lgrtHitBox = rtVBox;
//			return TRUE;
//		}
//	}
//
//	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiPoDiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_ -----
//	//
//	//                                               _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
//	//              m_pHtreeManager->GetHtBoxIconW() _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
//	//                                     _xZkqqHx_iEkFiBkJiEjPiBkIiEkHiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
//	//                                     _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkAiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
//	//                               _xZkqqHx_iEkGiEjPiEjPiEkMiEkKiEkKiEkKiEkNiEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
//	//                               _xZkqqHx_iBkK_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkLiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
//	//    m_pHtreeManager->GetHtBoxIconH() _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCgA_xHqqkZx_  _xZkqqHx_iEkLiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
//	//                               _xZkqqHx_iBkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkLiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
//	//                               _xZkqqHx_iEkIiEjPiEjPiEkPiEkKiEkKiEkKiEkOiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
//	//                                             _xZkqqHx_iEkAiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
//	//     m_pHtreeManager->GetHtHiForkTagGapX() _xZkqqHx_iBkIiEkJiElOiBkJiEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
//	//                                               _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
//	//                                               _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_            _xZkqqHx_iBeG_xHqqkZx_
//	//  
//
//	for (iDocId = vDocId.begin(); iDocId != vDocId.end(); iDocId++)
//	{
//		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iDocId);
//		if (pRec == NULL) continue;
//		// _xZkqqHx_jHjKjHpAjApMiCmJiJiIiCmBiClNiBeBjHjKjHpAjFkKiKpCiDfOiDePiCmMjFmAiCpBiCmFiCkCiCoJiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
//		CRect rtHiForkTags = pRec->GetLifeLineRect();
//		rtHiForkTags.left -= m_pHtreeManager->GetHtHiForkTagGapX() + m_pHtreeManager->GetHtBoxIconW();
//		rtHiForkTags.right = rtHiForkTags.left + m_pHtreeManager->GetHtBoxIconW();
//		rtHiForkTags.bottom += m_pHtreeManager->GetHtBoxIconH();
//		if (rtHiForkTags.PtInRect(pt))
//		//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMjFmAiCpBiCmFiCkCiCoJiLoJiMgAiCmMjEmNiImNiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			long lIndex;
//			for (lIndex = 0;; lIndex++)
//			{
//				const FCHiForkTagRec* pTreeLabelRec = pRec->GetHiForkTagRec(lIndex);
//				if (pTreeLabelRec == NULL) break;
//				long lY = pRec->SessionIndexToYTree(pTreeLabelRec->GetSessionIndex());
//				CRect rtTLBox;
//				rtTLBox.left = rtHiForkTags.left;
//				rtTLBox.top = lY;
//				rtTLBox.right = rtHiForkTags.right;
//				rtTLBox.bottom = rtTLBox.top + m_pHtreeManager->GetHtBoxIconH();
//				if (rtTLBox.PtInRect(pt))
//				{
//					lDocId = *iDocId;
//					lHiForkTagId = lIndex;
//					fliSessionIndex = pTreeLabelRec->GetSessionIndex();
//					lgrtHitBox = rtTLBox;
//					return TRUE;
//				}
//			}
//		}
//	}
//
//	//----- _xZkqqHx_jHjKjHpAjApMiCmMiPoDiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_ -----
//	for (iDocId = vDocId.begin(); iDocId != vDocId.end(); iDocId++)
//	{
//		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iDocId);
//		if (pRec == NULL) continue;
//		// _xZkqqHx_jHjKjHpAjApMiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
//		CRect rtLifeLine = pRec->GetLifeLineRect();
//		rtLifeLine.left -= 2;
//		rtLifeLine.right += 2;
//		if (rtLifeLine.PtInRect(pt))
//		{
//			lDocId = *iDocId;
//			fliSessionIndex = pRec->YToSessionIndexTree(pt.y);
//			lgrtHitBox = rtLifeLine;
//			return TRUE;
//		}
//		// _xZkqqHx_jHjKjHpAjApMjGoOiIpDiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
//		CRect rtArrowLine = pRec->GetLifeArrowRect();
//		rtArrowLine.left -= 2;
//		rtArrowLine.right += 2;
//		if (rtArrowLine.PtInRect(pt))
//		{
//			lDocId = *iDocId;
//			fliSessionIndex = pRec->GetEndSessionIndex();
//			lgrtHitBox = rtArrowLine;
//			return TRUE;
//		}
//	}
//
//	//----- _xZkqqHx_jDlBjDpMjApMiCmMiPoDiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_ -----
//	//
//	//                        _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
//	//                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
//	//                        _xZkqqHx_iEkLiEkAiEkL_xHqqkZx_ m_pHtreeManager->GetHtInterLineX()
//	//                        _xZkqqHx_iEkLiEkFiBkJiEjPiEjPiEjPiEjPiEjPiBkIiEkH_xHqqkZx_
//	//                        _xZkqqHx_iEkLiEkAiEkL_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
//	//                        _xZkqqHx_iEkLiBeFiElAiEkKiEkKiEkKiEkKiEkKiEkKiEkNiEjPiEkG_xHqqkZx_
//	//                        _xZkqqHx_iEkLiBkKiEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkK_xHqqkZx_
//	//             m_ptRoot _xZkqqHx_iEjPiElOiEkDiEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_m_pHtreeManager->GetHtBoxIntroY()
//	//                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
//	//                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
//	//                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkMiEkKiEkKiEkKiElDiEkKiElIiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
//	//                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
//	//                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
//	//                        _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_                      _xZkqqHx_iBeG_xHqqkZx_
//	//
//	for (iDocId = vDocId.begin(); iDocId != vDocId.end(); iDocId++)
//	{
//		// _xZkqqHx_iDgHiDgCiDhGiCmMjHjKjHpAjGnIiCmMjDlBjDpMjApMiCmNjClCiCnHiCmIiCkCiBeC_xHqqkZx_
//		if (*iDocId == lTopDocId) continue;
//		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iDocId);
//		if (pRec == NULL) continue;
//		CRect rtIntro;
//		rtIntro.left = pRec->GetRootPoint().x + m_pHtreeManager->GetHtLifeWidthH();
//		rtIntro.top = pRec->GetRootPoint().y - (m_pHtreeManager->GetHtIntroGapY() / 2);
//		rtIntro.right = pRec->GetRootPoint().x + m_pHtreeManager->GetHtInterLineX();
//		rtIntro.bottom = rtIntro.top + m_pHtreeManager->GetHtIntroGapY();
//
//		if (rtIntro.PtInRect(pt))
//		{
//			lDocId = (m_pHtreeManager->GetDocRecExtData(*iDocId))->GetSuperDocId();
//			fliSessionIndex = pRec->GetFirstSessionIndex();
//			lgrtHitBox = rtIntro;
//			return TRUE;
//		}
//	}
//
//	return FALSE;
//} // CFCWndHistoryTree::WhichPtInTree.
//----- 05.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::WhichPtInTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkCiCmEiBeBiNmAjFfHiCkKiCmHiCmMjHjKjHpAiPoDiCmJiCkAiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_jHjKjHpAiImKjChFiBgJiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *			lDocId			:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lHiForkTagId	:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDeP_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lgrtHitBox		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *			pt				:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPoDiCmMiDhBiDgCiDgHiClFiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmNiBeB_xHqqkZx_lDocId_xZkqqHx_iCmG_xHqqkZx_lHiForkTagId_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jHlMjFpLiCmMjFmPjAjEiCmJjCgMiCkKjFnEiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmEiBeBiChHiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ FDTR_HTREE_REC _xZkqqHx_iCmFiCmNiCmIiCkN_xHqqkZx_
 *			FDTR_TRUNK_REC _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iCgAiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ FDTR_HI_FORK_TAG_REC _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *                          _xZkqqHx_iEkL_xHqqkZx_
 *                          _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkMiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iChH_xHqqkZx_              _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkPiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *             _xZkqqHx_iEkMiEkKiEkKiEkKiEkN_xHqqkZx_ _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *             _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
 *             _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCgA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
 *             _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_ _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkMiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *             _xZkqqHx_iEkPiEkKiEkKiEkKiEkO_xHqqkZx_ _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                      _xZkqqHx_iEkMiEkO_xHqqkZx_  _xZkqqHx_iEkPiEkN_xHqqkZx_  _xZkqqHx_iEkPiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *                       _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_         _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                         _xZkqqHx_iBfPiBfO_xHqqkZx_           _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDTRClass CFCWndHistoryTree::WhichPtInTree (	flint& fliSessionIndex,
												long& lDocId,
												long& lObjectId,
												CRect& lgrtHitBox,
												const CPoint& pt)
{
	lDocId = -1;		// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	lObjectId = -1;		// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	// _xZkqqHx_iDgHiDgCiDhGiImIiJlKiCmMjHjKjHpAjGnIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
// 06.01.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
	const long lTopDocId = m_pHtreeManager->SubDocumentIdToTopId(GetSelectedDocumentId());
	longVector vDocId;
	m_pHtreeManager->GetTotalTreeDocId(vDocId, lTopDocId);

	//----- _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCmMiPoDiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_ -----

	longVector::const_iterator iDocId;
	for (iDocId = vDocId.begin(); iDocId != vDocId.end(); iDocId++)
	{
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iDocId);
		if (pRec == NULL) continue;
		const CRect rtVBox = pRec->GetNodeBoxRect();
		if (rtVBox.PtInRect(pt))
		{
			lDocId = *iDocId;
			fliSessionIndex = pRec->GetFirstSessionIndex();
			lgrtHitBox = rtVBox;
			return FDTR_TRUNK_REC;		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
		}
	}

	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMiPoDiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_ -----
	//
	//                                               _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
	//              m_pHtreeManager->GetHtBoxIconW() _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
	//                                     _xZkqqHx_iEkFiBkJiEjPiBkIiEkHiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
	//                                     _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkAiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
	//                               _xZkqqHx_iEkGiEjPiEjPiEkMiEkKiEkKiEkKiEkNiEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
	//                               _xZkqqHx_iBkK_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkLiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
	//    m_pHtreeManager->GetHtBoxIconH() _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iCgA_xHqqkZx_  _xZkqqHx_iEkLiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
	//                               _xZkqqHx_iBkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkLiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
	//                               _xZkqqHx_iEkIiEjPiEjPiEkPiEkKiEkKiEkKiEkOiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
	//                                             _xZkqqHx_iEkAiEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
	//     m_pHtreeManager->GetHtHiForkTagGapX() _xZkqqHx_iBkIiEkJiElOiBkJiEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
	//                                               _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
	//                                               _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_            _xZkqqHx_iBeG_xHqqkZx_
	//  

	for (iDocId = vDocId.begin(); iDocId != vDocId.end(); iDocId++)
	{
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iDocId);
		if (pRec == NULL) continue;
		// _xZkqqHx_jHjKjHpAjApMiCmJiJiIiCmBiClNiBeBjHjKjHpAjFkKiKpCiDfOiDePiCmMjFmAiCpBiCmFiCkCiCoJiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
		CRect rtHiForkTags = pRec->GetLifeLineRect();
		rtHiForkTags.left -= m_pHtreeManager->GetHtHiForkTagGapX() + m_pHtreeManager->GetHtBoxIconW();
		rtHiForkTags.right = rtHiForkTags.left + m_pHtreeManager->GetHtBoxIconW();
		rtHiForkTags.bottom += m_pHtreeManager->GetHtBoxIconH();
		if (rtHiForkTags.PtInRect(pt))
		//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmMjFmAiCpBiCmFiCkCiCoJiLoJiMgAiCmMjEmNiImNiCmMiPoKiNiH_xHqqkZx_ -----
		{
			long lIndex;
			for (lIndex = 0;; lIndex++)
			{
				const FCHiForkTagRec* pTreeLabelRec = pRec->GetHiForkTagRec(lIndex);
				if (pTreeLabelRec == NULL) break;
				long lY = pRec->SessionIndexToYTree(pTreeLabelRec->GetSessionIndex());
				CRect rtTLBox;
				rtTLBox.left = rtHiForkTags.left;
				rtTLBox.top = lY;
				rtTLBox.right = rtHiForkTags.right;
				rtTLBox.bottom = rtTLBox.top + m_pHtreeManager->GetHtBoxIconH();
				if (rtTLBox.PtInRect(pt))
				{
					lDocId = *iDocId;
					lObjectId = lIndex;
					fliSessionIndex = pTreeLabelRec->GetSessionIndex();
					lgrtHitBox = rtTLBox;
					return FDTR_HI_FORK_TAG_REC;	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
				}
			}
		}
	}

	//----- _xZkqqHx_jHjKjHpAjApMiCmMiPoDiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_ -----
	for (iDocId = vDocId.begin(); iDocId != vDocId.end(); iDocId++)
	{
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iDocId);
		if (pRec == NULL) continue;
		// _xZkqqHx_jHjKjHpAjApMiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
		CRect rtLifeLine = pRec->GetLifeLineRect();
		rtLifeLine.left -= 2;
		rtLifeLine.right += 2;
		if (rtLifeLine.PtInRect(pt))
		{
			lDocId = *iDocId;
			fliSessionIndex = pRec->YToSessionIndexTree(pt.y);
			lgrtHitBox = rtLifeLine;
			return FDTR_TRUNK_REC;		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
		}
		// _xZkqqHx_jHjKjHpAjApMjGoOiIpDiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
		CRect rtArrowLine = pRec->GetLifeArrowRect();
		rtArrowLine.left -= 2;
		rtArrowLine.right += 2;
		if (rtArrowLine.PtInRect(pt))
		{
			lDocId = *iDocId;
			fliSessionIndex = pRec->GetEndSessionIndex();
			lgrtHitBox = rtArrowLine;
			return FDTR_TRUNK_REC;		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
		}
	}

	//----- _xZkqqHx_jDlBjDpMjApMiCmMiPoDiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJ_xHqqkZx_ -----
	//
	//                        _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
	//                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
	//                        _xZkqqHx_iEkLiEkAiEkL_xHqqkZx_ m_pHtreeManager->GetHtInterLineX()
	//                        _xZkqqHx_iEkLiEkFiBkJiEjPiEjPiEjPiEjPiEjPiBkIiEkH_xHqqkZx_
	//                        _xZkqqHx_iEkLiEkAiEkL_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
	//                        _xZkqqHx_iEkLiBeFiElAiEkKiEkKiEkKiEkKiEkKiEkKiEkNiEjPiEkG_xHqqkZx_
	//                        _xZkqqHx_iEkLiBkKiEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkK_xHqqkZx_
	//             m_ptRoot _xZkqqHx_iEjPiElOiEkDiEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_m_pHtreeManager->GetHtBoxIntroY()
	//                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
	//                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
	//                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkMiEkKiEkKiEkKiElDiEkKiElIiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
	//                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
	//                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
	//                        _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_                      _xZkqqHx_iBeG_xHqqkZx_
	//
	for (iDocId = vDocId.begin(); iDocId != vDocId.end(); iDocId++)
	{
		// _xZkqqHx_iDgHiDgCiDhGiCmMjHjKjHpAjGnIiCmMjDlBjDpMjApMiCmNjClCiCnHiCmIiCkCiBeC_xHqqkZx_
		if (*iDocId == lTopDocId) continue;
		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iDocId);
		if (pRec == NULL) continue;
		CRect rtIntro;
		rtIntro.left = pRec->GetRootPoint().x + m_pHtreeManager->GetHtLifeWidthH();
		rtIntro.top = pRec->GetRootPoint().y - (m_pHtreeManager->GetHtIntroGapY() / 2);
		rtIntro.right = pRec->GetRootPoint().x + m_pHtreeManager->GetHtInterLineX();
		rtIntro.bottom = rtIntro.top + m_pHtreeManager->GetHtIntroGapY();

		if (rtIntro.PtInRect(pt))
		{
			lDocId = m_pHtreeManager->GetDocRecExtData(*iDocId)->GetSuperDocId();
			fliSessionIndex = pRec->GetFirstSessionIndex();
			lgrtHitBox = rtIntro;
			return FDTR_TRUNK_REC;		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
		}
	}
	return FDTR_NONE_REC;		// _xZkqqHx_jGlDiClFiBeC_xHqqkZx_
} // CFCWndHistoryTree::WhichPtInTree.
//----- 05.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 05.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::WhichPtInBranch
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkCiCmEiBeBiNmAjFfHiCkKjHjKjHpAiDhEiDeAiDeDiDiLiPoDiCmM_xHqqkZx_ _xZkqqHx_iCmHiCmMiImKjChFiCmJ_xHqqkZx_
// *			_xZkqqHx_iCkAiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_jHjKjHpAiImKjChFiBgJiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBgKiCpAjFnEiClHiBeC_xHqqkZx_
// *			lDocId			:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			lLabelId		:_xZkqqHx_iDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			lHiForkTagId	:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDeP_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			lTimeId			:_xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiL_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *							 _xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *			lgrtHitBox		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
// *			pt				:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPoDiCmJiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBjGlDiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpAiCmMjHjKjHpAiDhLiDgCiDeOiDfIiBeBjGoOiIpDiBeBiOjOiKnEiBeBiDiJiDhIiDiLjDjJiCmFiCmMiDeOiDiKiDgCiDeOiCpA_xHqqkZx_
// *			_xZkqqHx_jClCiCnHiBeBjBiKjDjGiClHiCoJiMlLiNnN_xHqqkZx_ _xZkqqHx_jGhLjBmMiCmFiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMiImKjChFiCmJjFmPiKlHiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *			03.03.30 Fukushiro M. _xZkqqHx_iNfIjAfG_xHqqkZx_
// *************************************************************************/
//BOOL CFCWndHistoryTree::WhichPtInBranch (	flint& fliSessionIndex,
//											long& lDocId,
//											long& lLabelId,
//											long& lHiForkTagId,
//											long& lTimeLabelId,
//											long& lTimeId,
//											CRect& lgrtHitBox,
//											const CPoint& pt)
//{
//	lDocId = -1;			// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	lLabelId = -1;			// _xZkqqHx_iDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	lHiForkTagId = -1;		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDeP_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	lTimeLabelId = -1;		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	lTimeId = -1;			// _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//	// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCmMjHjKjHpAjApMiCkJiCoHiJeFiCmGiBeBiNiCiClDiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
//	CRect rtVBox;
//	// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiCmMiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
//	FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
//	if (pRec == NULL) return FALSE;
//
//	//----- _xZkqqHx_jFkKiKpCjHjKjHpAiDhLiDgCiDeOiDfI_xHqqkZx_/_xZkqqHx_iDiJiDhIiDiLiDhLiDgCiDeOiDfIjCiGiCkJiCmHiCkEiCkJiDgAiDeGiDgCiDeO_xHqqkZx_ -----
//	FTSessionToNodeMmap::const_reverse_iterator irN;
//	for (irN = pRec->GetSessionToNodeMmap().rbegin();
//		 irN != pRec->GetSessionToNodeMmap().rend(); irN++)
//	{
//		rtVBox.SetRect(	(*irN).second.m_ptRoot.x,
//						(*irN).second.m_ptRoot.y - m_pHtreeManager->GetHistBoxSize().cy / 2,
//						(*irN).second.m_ptRoot.x + m_pHtreeManager->GetHistBoxSize().cx,
//						(*irN).second.m_ptRoot.y + m_pHtreeManager->GetHistBoxSize().cy / 2);
//		if (rtVBox.PtInRect(pt))
//		//----- _xZkqqHx_jFkKiKpCjHjKjHpAiDhLiDgCiDeOiDfIiBeFiDiJiDhIiDiLiDhLiDgCiDeOiDfIiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//		{
//			fliSessionIndex = (*irN).first;
//			switch ((*irN).second.m_class)
//			{
//			case FDTR_HTREE_REC:
//				lDocId = (*irN).second.m_lId;		// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//				break;
//			case FDTR_LABEL_REC:		// _xZkqqHx_iDiJiDhIiDiLiCmMiPoKiNiHiBeC_xHqqkZx_
//				lLabelId = (*irN).second.m_lId;		// _xZkqqHx_iDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//				break;
//			case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
//				lHiForkTagId = (*irN).second.m_lId;	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDeP_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//				break;
//			case FDTR_TIME_LABEL_REC:	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
//				lTimeLabelId = (*irN).second.m_lId;	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//				break;
//			}
//			lgrtHitBox = rtVBox;
//			return TRUE;
//		}
//	}
//
//	//----- _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiPoDiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
//	// _xZkqqHx_iOjOiKnEjHmMiIoGiCmMjFjNiCpAiOoGjDlOiBeC_xHqqkZx_
//	const long lTimeWidth = m_pHtreeManager->CalcTimeViewWidth();
//	// _xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCpAiOoGjDlOiBeC_xHqqkZx_
//	const long lTimeFontH = m_pHtreeManager->GetFontHeight(FDFT_HTREE_TIME);
//	long lIndex;
//	for (lIndex = pRec->GetTimeRecVector().size() - 1;
//		 0 <= lIndex; lIndex--)
//	{
//		const HTRTimeRec* pTimeRec = pRec->GetTimeRec(lIndex);
//		if (pTimeRec->m_fliSessionIdx <= pRec->GetEndSessionIndex())
//		//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDjEmNiImNjDoAiCmMiOjOiKnEiCmMiPoKiNiH_xHqqkZx_(Undo_xZkqqHx_iClFiCmEiCkCiCoJiPoKiNiHiCmNiCmNiCnNiPgPiClHiClBiCmGiCkKiCkAiCoJ_xHqqkZx_) -----
//		{
//			// _xZkqqHx_iOjOiKnEiCmMiLoJiMgAiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
//			CRect rtTime(0, pTimeRec->m_y - lTimeFontH, lTimeWidth - 5, pTimeRec->m_y);
//			if (rtTime.PtInRect(pt))
//			//----- _xZkqqHx_iOjOiKnEiCmMiLoJiMgAjCiGiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//			{
//				fliSessionIndex = pTimeRec->m_fliSessionIdx;
//				// _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
//				lTimeId = lIndex;
//				lgrtHitBox = rtTime;
//				return TRUE;
//			}
//		}
//	}
//
//	//----- _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiPoDiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
//	rtVBox = pRec->GetNodeBoxRect();
//	if (rtVBox.PtInRect(pt))
//	{
//		fliSessionIndex = pRec->GetFirstSessionIndex();
//		// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//		lDocId = GetSelectedDocumentId();
//		lgrtHitBox = rtVBox;
//		return TRUE;
//	}
//	//----- _xZkqqHx_jHjKjHpAjApMiPoDiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
//	// _xZkqqHx_jHjKjHpAjApMiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
//	CRect rtLifeLine = pRec->GetLifeLineRect();
//	rtLifeLine.left -= 2;
//	rtLifeLine.right += 2;
//	ASSERT(pRec->GetLife() != 0);
//	if (rtLifeLine.PtInRect(pt))
//	{
////----- 05.09.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		fliSessionIndex = D2LL((double(pt.y - rtLifeLine.top) / double(pRec->GetLife())) *
////								pRec->GetSessionIndexLength()) + pRec->GetFirstSessionIndex();
////----- 05.09.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		fliSessionIndex = pRec->YToSessionIndexBranch(pt.y);
////----- 05.09.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//		lDocId = GetSelectedDocumentId();
//		lgrtHitBox = rtLifeLine;
//		return TRUE;
//	}
//	//----- _xZkqqHx_jGoOiIpDiPoDiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
//	// _xZkqqHx_jHjKjHpAjApMjGoOiIpDiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
//	CRect rtArrowLine = pRec->GetLifeArrowRect();
//	rtArrowLine.left -= 2;
//	rtArrowLine.right += 2;
//	if (rtArrowLine.PtInRect(pt))
//	{
//		fliSessionIndex = pRec->GetEndSessionIndex();
//		// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//		lDocId = GetSelectedDocumentId();
//		lgrtHitBox = rtArrowLine;
//		return TRUE;
//	}
//	return FALSE;
//} // CFCWndHistoryTree::WhichPtInBranch.
//----- 05.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::WhichPtInBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkCiCmEiBeBiNmAjFfHiCkKjHjKjHpAiDhEiDeAiDeDiDiLiPoDiCmM_xHqqkZx_ _xZkqqHx_iCmHiCmMiImKjChFiCmJ_xHqqkZx_
 *			_xZkqqHx_iCkAiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_jHjKjHpAiImKjChFiBgJiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *			lDocId			:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lLabelId		:_xZkqqHx_iDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lHiForkTagId	:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDeP_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lTimeId			:_xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiL_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *							 _xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lgrtHitBox		:_xZkqqHx_iDhBiDgCiDgHiClFiClNiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *			pt				:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPoDiCmMiDhBiDgCiDgHiClFiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmEiBeBiChHiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ FDTR_HTREE_REC _xZkqqHx_iCmFiCmNiCmIiCkN_xHqqkZx_
 *			FDTR_TRUNK_REC _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 *                          _xZkqqHx_iEkL_xHqqkZx_
 *                          _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkMiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iChH_xHqqkZx_              _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkPiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiElC_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkN_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkPiEkKiElC_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElDiEkKiEkN_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iEkPiEkKiElC_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiElC_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                    _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                      _xZkqqHx_iEkMiEkO_xHqqkZx_  _xZkqqHx_iEkPiEkN_xHqqkZx_
 *                       _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_ 
 *                         _xZkqqHx_iBfPiBfO_xHqqkZx_   
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			03.03.30 Fukushiro M. _xZkqqHx_iNfIjAfG_xHqqkZx_
 *************************************************************************/
FDTRClass CFCWndHistoryTree::WhichPtInBranch (	flint& fliSessionIndex,
												long& lObjectId,
												CRect& lgrtHitBox,
												const CPoint& pt)
{
	lObjectId = -1;				// _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCmMjHjKjHpAjApMiCkJiCoHiJeFiCmGiBeBiNiCiClDiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	CRect rtVBox;
	// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiCmMiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
	if (pRec == NULL) return FDTR_NONE_REC;		// _xZkqqHx_jGlDiClFiBeC_xHqqkZx_

	//----- _xZkqqHx_jFkKiKpCjHjKjHpAiDhLiDgCiDeOiDfI_xHqqkZx_/_xZkqqHx_iDiJiDhIiDiLiDhLiDgCiDeOiDfIjCiGiBeBjDlBjDpMjApMiPoDiCkJiCmHiCkEiCkJiDgAiDeGiDgCiDeO_xHqqkZx_ -----
	FTSessionToNodeMmap::const_reverse_iterator irN;
	for (irN = pRec->GetSessionToNodeMmap().rbegin();
		 irN != pRec->GetSessionToNodeMmap().rend(); irN++)
	{
		rtVBox.SetRect(	(*irN).second.m_ptRoot.x,
						(*irN).second.m_ptRoot.y - m_pHtreeManager->GetHistBoxSize().cy / 2,
						(*irN).second.m_ptRoot.x + m_pHtreeManager->GetHistBoxSize().cx,
						(*irN).second.m_ptRoot.y + m_pHtreeManager->GetHistBoxSize().cy / 2);
		if (rtVBox.PtInRect(pt))
		//----- _xZkqqHx_jFkKiKpCjHjKjHpAiDhLiDgCiDeOiDfIiBeFiDiJiDhIiDiLiDhLiDgCiDeOiDfIiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			fliSessionIndex = (*irN).first;
			lObjectId = (*irN).second.m_lId;
			lgrtHitBox = rtVBox;
			return (*irN).second.m_class;
		}
		//----- _xZkqqHx_iDiJiDhIiDiLiCnGiCmMjDlBjDpMjApMiCmMiDgAiDeGiDgCiDeO_xHqqkZx_ -----
		if (rtVBox.left <= pRec->GetBoxPoint().x + m_pHtreeManager->GetHtLineIntroX())
		{
			CRect rtIntro;
			rtIntro.left = pRec->GetBoxPoint().x + m_pHtreeManager->GetHtLifeWidthH();
			rtIntro.top = (*irN).second.m_ptRoot.y - (m_pHtreeManager->GetHtIntroGapY() / 2);
			rtIntro.right = pRec->GetBoxPoint().x + m_pHtreeManager->GetHtInterLineX();
			rtIntro.bottom = rtIntro.top + m_pHtreeManager->GetHtIntroGapY();
			if (rtIntro.PtInRect(pt))
			{
				fliSessionIndex = (*irN).first;
				lgrtHitBox = rtIntro;
				return FDTR_TRUNK_REC;		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
			}
		}
	}

	//----- _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiPoDiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
	// _xZkqqHx_iOjOiKnEjHmMiIoGiCmMjFjNiCpAiOoGjDlOiBeC_xHqqkZx_
	const long lTimeWidth = m_pHtreeManager->CalcTimeViewWidth();
	// _xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCpAiOoGjDlOiBeC_xHqqkZx_
	const long lTimeFontH = m_pHtreeManager->GetFontHeight(FDFT_HTREE_TIME);
	long lIndex;
	for (lIndex = pRec->GetTimeRecVector().size() - 1;
		 0 <= lIndex; lIndex--)
	{
		const HTRTimeRec* pTimeRec = pRec->GetTimeRec(lIndex);
		if (pTimeRec->m_fliSessionIdx <= pRec->GetEndSessionIndex())
		//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDjEmNiImNjDoAiCmMiOjOiKnEiCmMiPoKiNiH_xHqqkZx_(Undo_xZkqqHx_iClFiCmEiCkCiCoJiPoKiNiHiCmNiCmNiCnNiPgPiClHiClBiCmGiCkKiCkAiCoJ_xHqqkZx_) -----
		{
			// _xZkqqHx_iOjOiKnEiCmMiLoJiMgAiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
			CRect rtTime(0, pTimeRec->m_y - lTimeFontH, lTimeWidth - 5, pTimeRec->m_y);
			if (rtTime.PtInRect(pt))
			//----- _xZkqqHx_iOjOiKnEiCmMiLoJiMgAjCiGiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				fliSessionIndex = pTimeRec->m_fliSessionIdx;
				lObjectId = lIndex;
				lgrtHitBox = rtTime;
				return FDTR_TIME_REC;
			}
		}
	}

	//----- _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiPoDiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
	rtVBox = pRec->GetNodeBoxRect();
	if (rtVBox.PtInRect(pt))
	{
		fliSessionIndex = pRec->GetFirstSessionIndex();
		lObjectId = GetSelectedDocumentId();
		lgrtHitBox = rtVBox;
		return FDTR_TRUNK_REC;
	}
	//----- _xZkqqHx_jHjKjHpAjApMiPoDiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
	// _xZkqqHx_jHjKjHpAjApMiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
	CRect rtLifeLine = pRec->GetLifeLineRect();
	rtLifeLine.left -= 2;
	rtLifeLine.right += 2;
	ASSERT(pRec->GetLife() != 0);
	if (rtLifeLine.PtInRect(pt))
	{
		fliSessionIndex = pRec->YToSessionIndexBranch(pt.y);
		// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		lObjectId = GetSelectedDocumentId();
		lgrtHitBox = rtLifeLine;
		return FDTR_TRUNK_REC;
	}
	//----- _xZkqqHx_jGoOiIpDiPoDiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
	// _xZkqqHx_jHjKjHpAjApMjGoOiIpDiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
	CRect rtArrowLine = pRec->GetLifeArrowRect();
	rtArrowLine.left -= 2;
	rtArrowLine.right += 2;
	if (rtArrowLine.PtInRect(pt))
	{
		fliSessionIndex = pRec->GetEndSessionIndex();
		lObjectId = GetSelectedDocumentId();
		lgrtHitBox = rtArrowLine;
		return FDTR_TRUNK_REC;
	}
	return FDTR_NONE_REC;		// _xZkqqHx_jGlDiClFiBeC_xHqqkZx_
} // CFCWndHistoryTree::WhichPtInBranch.
//----- 05.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetLastPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiImKjChFiCpAiNmAjFfHiCmFjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiImKjChFiCmNiBeBjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeBjHjKjHpAiImKjChFiCmMiPoOjFpBiCmFiLeMiJkP_xHqqkZx_
 *			_xZkqqHx_iClFiCmEiCkCiCoJiBeCiMlLiNnNiCmMjFfMiOkGjEhLjHkGiBeBiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiNiHiCoNiClJiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iNmAjFfHiCpAiMhGiOfKiClFiCmEiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CPoint CFCWndHistoryTree::GetLastPoint ()
{
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	switch (GetViewMode())
//	{
//	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//		return GetPointInProject(GetLastClickedProjectPath(),
//								GetLastClickedDocumentId());
//	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//		return GetPointInTree(	GetLastClickedProjectPath(),
//								GetLastClickedDocumentId(),
//								GetLastClickedSessionIndex());
//	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//		return GetPointInBranch(GetLastClickedProjectPath(),
//								GetLastClickedDocumentId(),
//								GetLastClickedSessionIndex());
//	default:
//		return CPoint(-1, -1);
//	}
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	switch (GetViewMode())
	{
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		return GetPointInProject(GetSelectedProjectPath(),
								GetSelectedDocumentId());
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		return GetPointInTree(	GetSelectedProjectPath(),
								GetSelectedDocumentId(),
								GetSelectedSessionIndex());
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		return GetPointInBranch(GetSelectedProjectPath(),
								GetSelectedDocumentId(),
								GetSelectedSessionIndex());
	default:
		return CPoint(-1, -1);
	}
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCWndHistoryTree::GetLastPoint.

//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetLastPoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiImKjChFiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lDocId			:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliSessionIndex	:_xZkqqHx_jHjKjHpAjFlGiPjBiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCWndHistoryTree::SetLastPoint (	const wchar_t* wcpProjectPath,
//										long lDocId,
//										flint fliSessionIndex)
//{
//	m_wstrLastProjectPath = wcpProjectPath;
//	m_lLastDocumentId = lDocId;
//	m_fliLastSessionIndex = fliSessionIndex;
//} // CFCWndHistoryTree::SetLastPoint.
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::SetLastPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDeOiDiKiDgCiDeOiClDiCoKiClNiImKjChFiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocId			:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_jHjKjHpAjFlGiPjBiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			clsObject		:_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lObjectId		:_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::SetLastPoint (	const wchar_t* wcpProjectPath,
										long lDocId,
										flint fliSessionIndex,
										FDTRClass clsObject,
										long lObjectId)
{
	m_wstrLastProjectPath = wcpProjectPath;
	m_lLastDocumentId = lDocId;
	m_fliLastSessionIndex = fliSessionIndex;
	m_clsLastObject = clsObject;
	m_lLastObjectId = lObjectId;
} // CFCWndHistoryTree::SetLastPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetPointInProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkPiCoJiBeBiOhHjCoIiClDiCoKiClNiDhGiDiNiDfHiDeGiDeOiDgHiBeB_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocId			:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMjFfMiOkGjEhLjHkGiBeBiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiNiHiCoNiClJiCmEiBeBiNmAjFfHiCpAiMhGiOfKiClFiCmEiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CPoint CFCWndHistoryTree::GetPointInProject (	const wchar_t* wcpProjectPath,
												long lDocId)
{
	if (wcscmp(m_pHtreeManager->GetProjectPath(), wcpProjectPath) != 0)
		return CPoint(-1, -1);
	// _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiNoNiPjMiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
	if (m_pHtreeManager->GetDocRecExtData(lDocId) == NULL)
		lDocId = -1;

	CRect rtBox;
	for (;;)
	{
		// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
		rtBox = m_pHtreeManager->GetNodeBoxRectInProject(lDocId);
		// _xZkqqHx_iClBiCmMjHjKjHpAjFlGiPjBiCkKjDfHiKeKiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDhLiDgCiDeOiDfIiCmMjCiGjAfDiCpAjFnEiClHiBeC_xHqqkZx_
		if (!rtBox.IsRectNull()) break;
		// _xZkqqHx_iClBiCmMjHjKjHpAjFlGiPjBiCkKjDfHiKeKiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_iPoDiImKiCmMjHjKjHpAjFlGiPjBiCpAiOoGjDlOiBeC_xHqqkZx_
		lDocId = m_pHtreeManager->GetDocRecExtData(lDocId)->GetSuperDocId();
	}
	return rtBox.CenterPoint();
} // CFCWndHistoryTree::GetPointInProject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetPointInTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkPiCoJiBeBiOhHjCoIiClDiCoKiClNiDhGiDiNiDfHiDeGiDeOiDgHiBeB_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocId			:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_jHjKjHpAjFlGiPjBiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmAjFfHiBeCiDhGiDiNiDfHiDeGiDeOiDgHiBeBjHjKjHpAjFlGiPjBiCkKjFfMiOkGjCiGiCmMiDfIiDeOiDiKiBfLiDjDiCmGiInJiCmIiCoJiPoKiNiHiCmN_xHqqkZx_
 *			(-1, -1)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMjFfMiOkGjEhLjHkGiBeBiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiNiHiCoNiClJiCmEiBeBiNmAjFfHiCpAiMhGiOfKiClFiCmEiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CPoint CFCWndHistoryTree::GetPointInTree (	const wchar_t* wcpProjectPath,
											long lDocId,
											flint fliSessionIndex)
{
	if (wcscmp(m_pHtreeManager->GetProjectPath(), wcpProjectPath) != 0 ||
		lDocId == -1)
		return CPoint(-1, -1);
	// _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiNoNiPjMiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
	if (m_pHtreeManager->GetDocRecExtData(lDocId) == NULL)
		return CPoint(-1, -1);

	// _xZkqqHx_jFfMiOkGjCiGiCmMjHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiCmGiInJiCmIiCoJiOhNiCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
	if (m_pHtreeManager->SubDocumentIdToTopId(lDocId) !=
		m_pHtreeManager->SubDocumentIdToTopId(GetSelectedDocumentId()))
		return CPoint(-1, -1);

	FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(lDocId);
	if (fliSessionIndex < pRec->GetFirstSessionIndex())
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiCkKiDfKiDgCiDfGiDiHiDjDjAoGjDkKiCoGiCoIiCoAiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return pRec->GetNodeBoxRect().CenterPoint();
	} else
	if (pRec->GetEndSessionIndex() < fliSessionIndex)
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiCkKiDfKiDgCiDfGiDiHiDjDjGjGjEpGiCoGiCoIjBoFiCkLiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return pRec->GetLifeArrowRect().CenterPoint();
	} else
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiCkKiDfKiDgCiDfGiDiHiDjDjAoGjDkKiCmGjGjGjEpGiCmMiKnEiCmFiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		const CRect rtLifeLine = pRec->GetLifeLineRect();
		CPoint pt;
		pt.x = (rtLifeLine.left + rtLifeLine.right) / 2;
		if (pRec->GetSessionIndexLength() != 0)
			pt.y = rtLifeLine.top +
						D2L(double(rtLifeLine.Height()) *
								double(fliSessionIndex - pRec->GetFirstSessionIndex()) /
								double(pRec->GetSessionIndexLength()));
		else
			pt.y = rtLifeLine.top;
		return pt;
	}
} // CFCWndHistoryTree::GetPointInTree.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetPointInBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkPiCoJiBeBiOhHjCoIiClDiCoKiClNiDhGiDiNiDfHiDeGiDeOiDgHiBeB_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocId			:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_jHjKjHpAjFlGiPjBiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMjFfMiOkGjEhLjHkGiBeBiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiNiHiCoNiClJiCmEiBeBiNmAjFfHiCpAiMhGiOfKiClFiCmEiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CPoint CFCWndHistoryTree::GetPointInBranch (const wchar_t* wcpProjectPath,
											long lDocId,
											flint fliSessionIndex)
{
	if (wcscmp(m_pHtreeManager->GetProjectPath(), wcpProjectPath) != 0)
		return CPoint(-1, -1);
	// _xZkqqHx_jHjKjHpAjFlGiPjBiCkKiNoNiPjMiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
	if (m_pHtreeManager->GetDocRecExtData(lDocId) == NULL)
		return CPoint(-1, -1);

	// _xZkqqHx_jFfMiOkGjCiGiCmMiMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiCmGiInJiCmIiCoJiOhNiCmMiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
	if (lDocId != GetSelectedDocumentId())
		return CPoint(-1, -1);

	FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(lDocId);
	if (fliSessionIndex < pRec->GetFirstSessionIndex())
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiCkKiDfKiDgCiDfGiDiHiDjDjAoGjDkKiCoGiCoIiCoAiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return pRec->GetNodeBoxRect().CenterPoint();
	} else
	if (pRec->GetEndSessionIndex() < fliSessionIndex)
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiCkKiDfKiDgCiDfGiDiHiDjDjGjGjEpGiCoGiCoIjBoFiCkLiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return pRec->GetLifeArrowRect().CenterPoint();
	} else
	//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiCkKiDfKiDgCiDfGiDiHiDjDjAoGjDkKiCmGjGjGjEpGiCmMiKnEiCmFiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		const CRect rtLifeLine = pRec->GetLifeLineRect();
		CPoint pt;
		pt.x = (rtLifeLine.left + rtLifeLine.right) / 2;
		if (pRec->GetSessionIndexLength() != 0)
			pt.y = rtLifeLine.top +
						D2L(double(rtLifeLine.Height()) *
								double(fliSessionIndex - pRec->GetFirstSessionIndex()) /
								double(pRec->GetSessionIndexLength()));
		else
			pt.y = rtLifeLine.top;
		return pt;
	}
} // CFCWndHistoryTree::GetPointInBranch.

//----- 03.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnUpdatePopupMenu
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiDiBiDgKiDiFiBfLiDeBiDeDiDgFiDiAiCmMjHeMiMpIjAkLiCpAiDgAiDeGiDgCiDeOiClFiBeB_xHqqkZx_
// *			_xZkqqHx_jGlDiMpIiCmMiDfCiDhNiDjDiDgIiCmNiDePiDiMiBfLiBjFjGlDiMpIiJlLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pMenu	:_xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiDiBiDgKiDiFiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCWndHistoryTree::OnUpdatePopupMenu (CMenu* pMenu) const
//{
//	ON_UPDATE_POPUP_MENU(ID_RBTN_HTREE_DOC_PROPERTY,
//							m_pHtreeManager->IsProjectOpened())
//	ON_UPDATE_POPUP_MENU(ID_RBTN_HTREE_DOC_DELETE,
//							m_pHtreeManager->IsProjectOpened())
//} // CFCWndHistoryTree::OnUpdatePopupMenu.
//----- 03.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetClientRectLG
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHiCpAiNgMjHlGiClFiClNjIfPjHjNiNmAjFfHiMgOiCmMiJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jIfPjHjNiNmAjFfHiMgOiCmMiJoGjGmKiCmMjFgAiJoGjHmMiIoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect CFCWndHistoryTree::GetClientRectLG () const
{
	CRect dvrtClient;
	GetClientRect(&dvrtClient);
	return DPtoLP(dvrtClient);
} // CFCWndHistoryTree::GetClientRectLG.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetCanvasRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeMiDiDiDjDiDgPiDfIiCmMiDfEiDeDiDfJiCpAjFnEiClHiBeCjIfPjHjNiNmAjFfHiMgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeMiDiDiDjDiDgPiDfIiCmMiDfEiDeDiDfJiBeCjIfPjHjNiNmAjFfHiMgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect CFCWndHistoryTree::GetCanvasRect () const
{
//----- 04.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
//	CRect lgrtCanvas;
//	GetClientRect(lgrtCanvas);
//
//	//----- _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDeMiDiDiDjDiDgPiDfIiDfEiDeDiDfJiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
//	if (m_pHtreeManager->IsProjectOpened())
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDeJiBfLiDhGiDjDiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		switch (GetViewMode())
//		{
//		case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//		{
//			// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
//			const CSize szBox = m_pHtreeManager->GetHistBoxSize();
//			lgrtCanvas.right = 10 + 10 + 30 + szBox.cx + 10;
//			lgrtCanvas.bottom = 10 + szBox.cy + 10;
//			long lDocId;
//			for (lDocId = m_pHtreeManager->GetProject()->GetFirstDocumentId(); lDocId != -1;
//				 lDocId = m_pHtreeManager->GetProject()->GetNextDocumentId(lDocId))
//			{
//				if (!m_pHtreeManager->GetDocRecExtData(lDocId).IsKindOf(FCHistoryDocRec::CLASS))
//					continue;
//				// _xZkqqHx_iDgHiDgCiDhGjHjKjHpAiCmIiCoHiCmOiBeB_xHqqkZx_Y_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
//				if ((m_pHtreeManager->GetDocRecExtData(lDocId)).GetSuperDocId() == -1)
//					lgrtCanvas.bottom += szBox.cy + 10;
//			}
//			break;
//		}
//		case FDHT_VMODE_TREE:	// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//		case FDHT_VMODE_BRANCH:	// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//			lgrtCanvas.right = m_pHtreeManager->GetMostRightBottom().x;
//			lgrtCanvas.bottom = m_pHtreeManager->GetMostRightBottom().y;
//			break;
//		}
//	}
//	return lgrtCanvas;
//----- 04.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	CRect lgrtCanvas;
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
	GetClientRect(lgrtCanvas);

	// UpdateScrollSize_xZkqqHx_iKnGjAjEjCiGiCmF_xHqqkZx_ GetCanvasRect _xZkqqHx_iCkKiOgHiCoNiCoKiCoJiCkKiBeB_xHqqkZx_
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjFmCiClGiCmEiCkCiCmEiBeBiKiOiCmC_xHqqkZx_ _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCmM_xHqqkZx_
	// _xZkqqHx_jFjNiBeFiNiCiClDiCkKiCePiCmMiPoKiNiHiBeB_xHqqkZx_UpdateScrollSize_xZkqqHx_jCiGiCmFiDeHiDiJiBfLiCpAjAlGiClGiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeBiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCkKiCePiCmJiCmIiCoHiCmIiCkCiCoGiCkEjFoCjAlDiBeC_xHqqkZx_
	if (lgrtCanvas.Width() == 0)
		lgrtCanvas.right = lgrtCanvas.left + 1;
	if (lgrtCanvas.Height() == 0)
		lgrtCanvas.bottom = lgrtCanvas.top + 1;

	//----- _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDeMiDiDiDjDiDgPiDfIiDfEiDeDiDfJiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
	if (m_pHtreeManager->IsProjectOpened())
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiDeJiBfLiDhGiDjDiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		lgrtCanvas.right = m_pHtreeManager->GetMostRightBottom().x;
		lgrtCanvas.bottom = m_pHtreeManager->GetMostRightBottom().y;
	}
	return lgrtCanvas;
//----- 04.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCWndHistoryTree::GetCanvasRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::ScrollTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJoGjGmKiCpAiDfIiDeOiDiNiBfLiDiLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgX 		:_xZkqqHx_jAfGiClFiCkCiDfIiDeOiDiNiBfLiDiLiImKjChFiBeCjIfPjHjNiNmAjFfHiBeC_xHqqkZx_
 *			lgY 		:_xZkqqHx_jAfGiClFiCkCiDfIiDeOiDiNiBfLiDiLiImKjChFiBeCjIfPjHjNiNmAjFfHiBeC_xHqqkZx_
 *			bRedrawNow	:_xZkqqHx_jBkGiOjOiNmEjFgAiJoGiCmIiCoH_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::ScrollTo (long lgX, long lgY, BOOL bRedrawNow)
{
//	TRACE(_T("CFCWndHistoryTree::ScrollTo\n"));

	CRect rtClient;
	GetClientRect(&rtClient);
	const CRect rtCanvas = GetCanvasRect();

	const long lOfstXMin	= rtCanvas.left;
	const long lOfstXMax	= rtCanvas.right;
	const long lPageX		= rtClient.Width();

	if (lOfstXMax - lPageX < lgX)
		lgX = lOfstXMax - lPageX;
	if (lgX < lOfstXMin)
		lgX = lOfstXMin;

	const long lOfstYMin	= rtCanvas.top;
	const long lOfstYMax	= rtCanvas.bottom;
	const long lPageY		= rtClient.Height();

	if (lOfstYMax - lPageY < lgY)
		lgY = lOfstYMax - lPageY;
	if (lgY < lOfstYMin)
		lgY = lOfstYMin;

	if (lgX == m_lgOffsetX && lgY == m_lgOffsetY) return;

	SetScrollPos(SB_HORZ, D2L(lgX / m_dScrollRatioX));
	SetScrollPos(SB_VERT, D2L(lgY / m_dScrollRatioY));

	if (lPageX <= ::abs(m_lgOffsetX - lgX) ||
		lPageY <= ::abs(m_lgOffsetY - lgY) ||
		!bRedrawNow)
	//----- _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiCkKiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAjClEiCkGiCoJiPoKiNiH_xHqqkZx_
	//			_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_ _xZkqqHx_jBkGiOjOiNmEjFgAiJoGiCmFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		m_lgOffsetX = lgX;
		m_lgOffsetY = lgY;
		if (IsWindowVisible())
		{
			// _xZkqqHx_jBfDiJoGjGmKiCpAiNmEjFgAiJoGjHmMiIoGiCmJiBeC_xHqqkZx_
			Invalidate();
			// _xZkqqHx_jBfDiJoGjGmKiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
			if (bRedrawNow) UpdateWindow();
		}
	} else
	//----- _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiCkKiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAjClEiCkGiCmIiCkCiPoKiNiH_xHqqkZx_
	//			_xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_jBkGiOjOiNmEjFgAiJoGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		const long lgMoveX = m_lgOffsetX - lgX;
		const long lgMoveY = m_lgOffsetY - lgY;
		if (IsWindowVisible())
		{
			CClientDC dc(this); // _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_
			//----- X_xZkqqHx_jFpLiMpMiCmMiDfIiDeOiDiNiBfLiDiLiCpAiOmAiNhD_xHqqkZx_ -----
			m_lgOffsetX = lgX;
			CRect rtUpdateX;
			(void)dc.ScrollDC(lgMoveX, 0, &rtClient, &rtClient, NULL, &rtUpdateX);
			// _xZkqqHx_iNmEjFgAiJoGjHmMiIoGiCpAiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiClFiCmEiNmEjFgAiJoGiBeC_xHqqkZx_
			InvalidateRect(rtUpdateX);
			//----- Y_xZkqqHx_jFpLiMpMiCmMiDfIiDeOiDiNiBfLiDiLiCpAiOmAiNhD_xHqqkZx_ -----
			m_lgOffsetY = lgY;
			CRect rtUpdateY;
			(void)dc.ScrollDC(0, lgMoveY, &rtClient, &rtClient, NULL, &rtUpdateY);
			// _xZkqqHx_iNmEjFgAiJoGjHmMiIoGiCpAiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiClFiCmEiNmEjFgAiJoGiBeC_xHqqkZx_
			InvalidateRect(rtUpdateY);
			// _xZkqqHx_jBkGiOjOiNmEjFgAiJoGiBeC_xHqqkZx_
			UpdateWindow();
//----- 03.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_jFeLiClIjBkGiOjOiNmEjFgAiJoGiCmFiCkAiCoJiClNiCnPiBeBiNmEjFgAiJoGiBeC_xHqqkZx_
//			SendRgnRedraw();
//----- 03.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		} else
		{
			m_lgOffsetX = lgX;
			m_lgOffsetY = lgY;
		}
	}
} // CFCWndHistoryTree::ScrollTo.

//----- 04.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetLifeArrowRect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjApMiCmMjAoGjCfLiCmMjGoOiIpDiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jHjKjHpAjApMiCpAiOhHjCoIiClHiCoJjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKePjAnKiLoJiMgAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//CRect CFCWndHistoryTree::GetLifeArrowRect (long lDocId) const
//{
////----- 04.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
////	const CSize szHistBox = m_pHtreeManager->GetHistBoxSize();
////----- 04.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	switch (GetViewMode())
//	{
//	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//		return CRect(0, 0, 0, 0);
//	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//	{
//		const CRect rtLife = m_pHtreeManager->GetLifeLineRect(lDocId);
//		const long lCenterX = (rtLife.left + rtLife.right) / 2;
//		return CRect(	lCenterX - ARW_WIDTH_H,
//						rtLife.bottom,
//						lCenterX + ARW_WIDTH_H,
//						rtLife.bottom + ARW_HEIGHT);
//	}
//	default:
//		return CRect(0, 0, 0, 0);
//	}
//} // CFCWndHistoryTree::GetLifeArrowRect.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetLifeLineRect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjApMiBgJjAoGjCfLiCmMjGoOiIpDiCpAiPjMiCkNiBgKiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jHjKjHpAjApMiCpAiOhHjCoIiClHiCoJjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKePjAnKiLoJiMgAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//CRect CFCWndHistoryTree::GetLifeLineRect (long lDocId) const
//{
////----- 04.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
////	const CSize szHistBox = m_pHtreeManager->GetHistBoxSize();
////----- 04.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	switch (GetViewMode())
//	{
//	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//		return CRect(0, 0, 0, 0);
//	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//	{
//		FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(lDocId);
//		return CRect(	pRec->GetBoxPoint().x - m_pHtreeManager->GetHtLifeWidthH(),
//						pRec->GetBoxPoint().y + m_pHtreeManager->GetHistBoxSize().cy,
//						pRec->GetBoxPoint().x + m_pHtreeManager->GetHtLifeWidthH(),
//						pRec->GetBoxPoint().y + m_pHtreeManager->GetHistBoxSize().cy + pRec->GetLife());
//	}
//	default:
//		return CRect(0, 0, 0, 0);
//	}
//} // CFCWndHistoryTree::GetLifeLineRect.
//----- 04.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 04.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetNodeBoxRect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjApMiCmMiDgNiBfLiDgIiDhLiDgCiDeOiDfIiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jHjKjHpAjApMiCpAiOhHjCoIiClHiCoJjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKePjAnKiLoJiMgAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//CRect CFCWndHistoryTree::GetNodeBoxRect (long lDocId) const
//{
//	switch (GetViewMode())
//	{
//	case FDHT_VMODE_PROJECT:// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//		if (lDocId == -1)
//		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			return CRect(FD_HTREE_VIEW_GAP,
//						 FD_HTREE_VIEW_GAP,
//						 FD_HTREE_VIEW_GAP + m_pHtreeManager->GetHistBoxSize().cx,
//						 FD_HTREE_VIEW_GAP + m_pHtreeManager->GetHistBoxSize().cy);
//		} else
//		//----- _xZkqqHx_jHjKjHpAjFlGiPjBiOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iKgHjCkDiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
//			const FCDocRecExtData* pExtData = (const FCDocRecExtData*)m_pHtreeManager->GetDocRecExtData(lDocId).GetExtData();
//			// _xZkqqHx_iClBiCmMjHjKjHpAjFlGiPjBiCkKjDfHiKeKiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeBiLpDiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
//			if (pExtData->GetBoxPoint().x == -1) return CRect(0,0,0,0);
//			return CRect(pExtData->GetBoxPoint().x,
//						 pExtData->GetBoxPoint().y,
//						 pExtData->GetBoxPoint().x + m_pHtreeManager->GetHistBoxSize().cx,
//						 pExtData->GetBoxPoint().y + m_pHtreeManager->GetHistBoxSize().cy);
//		}
//	case FDHT_VMODE_TREE:	// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//	case FDHT_VMODE_BRANCH:	// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
//	  {
//		const FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(lDocId);
//		// _xZkqqHx_iClBiCmMjHjKjHpAjFlGiPjBiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeBiLpDiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
//		if (pRec == NULL) return CRect(0,0,0,0);
//		return CRect(	pRec->GetBoxPoint().x - m_pHtreeManager->GetHtBoxWidthL(),
//						pRec->GetBoxPoint().y,
//						pRec->GetBoxPoint().x + m_pHtreeManager->GetHistBoxSize().cx - m_pHtreeManager->GetHtBoxWidthL(),
//						pRec->GetBoxPoint().y + m_pHtreeManager->GetHistBoxSize().cy);
//	  }
//	default:
//		return CRect(0,0,0,0);
//	}
//} // CFCWndHistoryTree::GetNodeBoxRect.
//----- 04.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::LPtoDP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIfPjHjNiNmAjFfHiMgOiCpAiDgGiDgPiDeDiDfIiNmAjFfHiMgOiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgpt	:_xZkqqHx_jFmPiKlHiClHiCoJ_xHqqkZx_CPoint_xZkqqHx_iNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiKlHiMoDiCmMjDfPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CPoint CFCWndHistoryTree::LPtoDP (CPoint lgpt) const
{
	lgpt.x -= m_lgOffsetX;
	lgpt.y -= m_lgOffsetY;
	return lgpt;
} // CFCWndHistoryTree::LPtoDP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::LPtoDP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIfPjHjNiNmAjFfHiMgOiCpAiDgGiDgPiDeDiDfIiNmAjFfHiMgOiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgrt	:_xZkqqHx_jFmPiKlHiClHiCoJ_xHqqkZx_CRect_xZkqqHx_iNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiKlHiMoDiCmMiLoJiMgAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect CFCWndHistoryTree::LPtoDP (CRect lgrt) const
{
	lgrt.left -= m_lgOffsetX;
	lgrt.top -= m_lgOffsetY;
	lgrt.right -= m_lgOffsetX;
	lgrt.bottom -= m_lgOffsetY;
	return lgrt;
} // CFCWndHistoryTree::LPtoDP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::DPtoLP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDgPiDeDiDfIiNmAjFfHiMgOiCpAjIfPjHjNiNmAjFfHiMgOiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dvpt	:_xZkqqHx_jFmPiKlHiClHiCoJ_xHqqkZx_CPoint_xZkqqHx_iNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiKlHiMoDiCmMjDfPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CPoint CFCWndHistoryTree::DPtoLP (CPoint dvpt) const
{
	dvpt.x += m_lgOffsetX;
	dvpt.y += m_lgOffsetY;
	return dvpt;
} // CFCWndHistoryTree::DPtoLP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::DPtoLP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDgPiDeDiDfIiNmAjFfHiMgOiCpAjIfPjHjNiNmAjFfHiMgOiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dvrt	:_xZkqqHx_jFmPiKlHiClHiCoJ_xHqqkZx_CPoint_xZkqqHx_iNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiKlHiMoDiCmMiLoJiMgAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect CFCWndHistoryTree::DPtoLP (CRect dvrt) const
{
	dvrt.left += m_lgOffsetX;
	dvrt.top += m_lgOffsetY;
	dvrt.right += m_lgOffsetX;
	dvrt.bottom += m_lgOffsetY;
	return dvrt;
} // CFCWndHistoryTree::DPtoLP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetExpandedTopDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCkKjBkOiClHiCoJiDgDiDiKiBfLiCmFiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiCmF_xHqqkZx_
 *			_xZkqqHx_jDfHiKeKiClDiCoKiCmEiCkCiCoJiBeBiNmFiCoAiPoDiImKiCmMiOhNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiCoAiPoDiImKiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiOgHiCkEiCmMiCmFiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiL_xHqqkZx_
 *			_xZkqqHx_iCmJiKoOiCmDiCkNiPoOjFpBiImIiKePiCmNiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCWndHistoryTree::GetExpandedTopDocumentId (long lDocId) const
{
	for (;;)
	{
// 06.01.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//		FCHiDocumentRec hiDocRec = m_pHtreeManager->GetDocRecExtData(lDocId);
		// _xZkqqHx_iKgHjCkDiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
// 06.01.05 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		const FCDocRecExtData* pExtData = (const FCDocRecExtData*)hiDocRec.GetExtData();
		const FCDocRecExtData* pExtData = m_pHtreeManager->GetDocRecExtData(lDocId);
		// _xZkqqHx_jFfMiOkGiDhLiDgCiDeOiDfIiCmMiKoOiPiAjDfPiBeC_xHqqkZx_
		// pExtData->GetIsSubTreeExpanded() _xZkqqHx_iCmNiBeBiDfEiDhFiDgDiDiKiBfLiCpAjDfHiKeKiClFiCmEiCkCiCoJiCkJiCpA_xHqqkZx_
		// _xZkqqHx_iOkGiClHiClNiCnPiBeBiClBiCmMiDgNiBfLiDgIiCkKjDfHiKeKiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCmMjElLjCgGiCmNiPgPjHiIiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCkKjDfHiKeKiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjCgNiCoJiCmJiCmNiBeB_xHqqkZx_
		// pExtData->GetBoxPoint() _xZkqqHx_iCmMiNmAjFfHjCgMiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		if (pExtData->GetBoxPoint() != CPoint(-1, -1)) break;
		// _xZkqqHx_iIoKiCmCiPoDiImKiCmMjHjKjHpAjFlGiPjBiCnGiInKjDkOiBeC_xHqqkZx_
		lDocId = pExtData->GetSuperDocId();
	}
	return lDocId;
} // CFCWndHistoryTree::GetExpandedTopDocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetTopRectInProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkCiCmEiBeBiOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCmM_xHqqkZx_
 *			_xZkqqHx_iDgNiBfLiDgIiCkKiPpEiCnMiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBjBkOiClHiCoJiPoDiImKiDgNiBfLiDgIiCmFjDfHiKeKiClDiCoKiCmEiCkCiCoJ_xHqqkZx_
 *			_xZkqqHx_iDgNiBfLiDgIiCmMjDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiCmMiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCmMiDgNiBfLiDgIiCkKjDfHiKeKiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDgNiBfLiDgIiCmM_xHqqkZx_
 *			_xZkqqHx_iLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_ 
 *			lDocId=-1_xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCmMiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLoJiMgAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect CFCWndHistoryTree::GetTopRectInProject (long lDocId) const
{
	if (lDocId == -1)
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
	{
		return m_pHtreeManager->GetNodeBoxRectInProject(-1);
	} else
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// lMarkDocId _xZkqqHx_iCkKjBkOiClHiCoJiDgDiDiKiBfLiCmFiBeBiDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiCmF_xHqqkZx_
		// _xZkqqHx_jDfHiKeKiClDiCoKiCmEiCkCiCoJiBeBiNmFiCoAiPoDiImKiCmMiOhNiCpAjFnEiClHiBeC_xHqqkZx_
		long lTargetDocId = GetExpandedTopDocumentId(lDocId);
		if (lTargetDocId == lDocId)
		//----- _xZkqqHx_iOhHjCoIiCmMjHjKjHpAjFlGiPjBiCmMiDgNiBfLiDgIiCkKjDfHiKeKiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			return m_pHtreeManager->GetNodeBoxRectInProject(lTargetDocId);
		} else
		//----- _xZkqqHx_iOhHjCoIiCmMjHjKjHpAjFlGiPjBiCmMiDgNiBfLiDgIiCkKjDfHiKeKiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiBeC_xHqqkZx_
			return m_pHtreeManager->GetExpBoxRectInProject(lTargetDocId);
		}
	}
} // CFCWndHistoryTree::GetTopRectInProject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetRectInTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeBjHjKjHpAiImKjChFiBeBiDeJiDhFiDfHiDeGiDeOiDgHiBeBiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ID_xZkqqHx_iCkJiCoH_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkPiCoJiDeJiDhFiDfHiDeGiDeOiDgHiCmJiKePjAnKiClHiCoJjHmMiIoGiCpA_xHqqkZx_
 *			_xZkqqHx_iOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocumentId		:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_ID_xZkqqHx_iCpAiDeOiDiKiDeBiClHiCoJiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			clsObject		:_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lObjectId		:_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLoJiMgAjHmMiIoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect CFCWndHistoryTree::GetRectInTree (long lDocumentId,
										FDTRClass clsObject,
										long lObjectId)
{
	FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(lDocumentId);
	switch (clsObject)
	{
	case FDTR_TRUNK_REC:			// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
		return (pRec->GetLifeArrowRect() | pRec->GetLifeLineRect() | pRec->GetNodeBoxRect());
	case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
	  {
		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		const FCHiForkTagRec* pHiForkTagRec = pRec->GetHiForkTagRec(lObjectId);
		if (pHiForkTagRec == NULL) break;
		long lY = pRec->SessionIndexToYTree(pHiForkTagRec->GetSessionIndex());
		// _xZkqqHx_jHjKjHpAjApMiCmJiJiIiCmBiClNiBeBjHjKjHpAjFkKiKpCiDfOiDePiCmMjFmAiCpBiCmFiCkCiCoJiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
		CRect rtHiForkTags;
		rtHiForkTags.left = pRec->GetLifeLineRect().left - m_pHtreeManager->GetHtHiForkTagGapX() - m_pHtreeManager->GetHtBoxIconW();
		rtHiForkTags.right = rtHiForkTags.left + m_pHtreeManager->GetHtBoxIconW();
		rtHiForkTags.top = lY;
		rtHiForkTags.bottom = rtHiForkTags.top + m_pHtreeManager->GetHtBoxIconH();
		return rtHiForkTags;
	  }
	}
	return CRect(0,0,0,0);
} // CFCWndHistoryTree::GetRectInTree.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetRectInBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeBjHjKjHpAiImKjChFiBeBiDeJiDhFiDfHiDeGiDeOiDgHiBeBiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ID_xZkqqHx_iCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkPiCoJiDeJiDhFiDfHiDeGiDeOiDgHiCmJiKePjAnKiClHiCoJjHmMiIoGiCpA_xHqqkZx_
 *			_xZkqqHx_iOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	clsObject		:_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lObjectId		:_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLoJiMgAjHmMiIoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect CFCWndHistoryTree::GetRectInBranch (	FDTRClass clsObject,
											long lObjectId)
{
	FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
	switch (clsObject)
	{
	case FDTR_TRUNK_REC:			// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBgJiKlCiBgKiBeC_xHqqkZx_
		return (pRec->GetLifeArrowRect() | pRec->GetLifeLineRect() | pRec->GetNodeBoxRect());
	case FDTR_HTREE_REC:		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
	case FDTR_LABEL_REC:		// _xZkqqHx_iDiJiDhIiDiLiBeC_xHqqkZx_
	case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
	case FDTR_TIME_LABEL_REC:	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
	  {
		FTSessionToNodeMmap::const_iterator iN;
		for (iN = pRec->GetSessionToNodeMmap().begin();
			 iN != pRec->GetSessionToNodeMmap().end(); iN++)
		{
			if ((*iN).second.m_class == clsObject &&
				(*iN).second.m_lId == lObjectId)
			{
				return CRect(	(*iN).second.m_ptRoot.x,
								(*iN).second.m_ptRoot.y - m_pHtreeManager->GetHistBoxSize().cy / 2,
								(*iN).second.m_ptRoot.x + m_pHtreeManager->GetHistBoxSize().cx,
								(*iN).second.m_ptRoot.y + m_pHtreeManager->GetHistBoxSize().cy / 2);
			}
		}
		break;
	  }
	default:
		FFThrowMiscUnknown();
	}
	return CRect(0,0,0,0);
} // CFCWndHistoryTree::GetRectInBranch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::BlinkTempMarkMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlMjAnNjHjKjHpAjFkKiKpCiCmMiDhLiDgCiDeOiDfIiCpAjDfPjGmFiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::BlinkTempMarkMark ()
{
	// _xZkqqHx_iJlMjAnNiDhNiBfLiDeOiCmMiLoJiMgAiCpAiOoGjDlOiBeC_xHqqkZx_
	CPoint pt;
	CRect rtTempMark;
	if (GetTempMarkRect(pt, rtTempMark))
	//----- _xZkqqHx_iJlMjAnNiDhNiBfLiDeOiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
		CClientDC dc(this);
		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDfIiDeOiDiNiBfLiDiLiImKjChFiCmFiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCmMiNmAjFfHjFoCjAlDiBeC_xHqqkZx_
		dc.SetWindowOrg(m_lgOffsetX, m_lgOffsetY);
		COLORREF col = FFGetMiddleColor(double(labs(m_lTimerBlink)) / 5.0,
										g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT),
										g_pReg->GetOptiRegColor(FDCL_HTREE_TEMP_NODE));
		CPen pen(PS_COSMETIC, 1, col);
		CPen* pPenOld = dc.SelectObject(&pen);
		CBrush* pBrushOld = dc.SelectObject(CBrush::FromHandle((HBRUSH)GetStockObject(HOLLOW_BRUSH)));

		dc.Rectangle(rtTempMark);
		rtTempMark.DeflateRect(1, 1);
		dc.Rectangle(rtTempMark);

		dc.SelectObject(pPenOld);
		dc.SelectObject(pBrushOld);
		// _xZkqqHx_iJlMjAnNjFkKiKpCjDjJiCmMjDfPjGmFiMfHjAjEiBeC_xHqqkZx_
		if (m_lTimerBlink == 5)
			m_lTimerBlink = -5;
		m_lTimerBlink++;
	}
} // CFCWndHistoryTree::BlinkTempMarkMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::BlinkMarkUpHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDeOiDeBiDgCiDhGiClDiCoKiClNjHjKjHpAjFlGiPjBiCpAjDfPjGmFiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::BlinkMarkUpHidocument ()
{
	// _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
	CClientDC dc(this);
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDfIiDeOiDiNiBfLiDiLiImKjChFiCmFiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCmMiNmAjFfHjFoCjAlDiBeC_xHqqkZx_
	dc.SetWindowOrg(m_lgOffsetX, m_lgOffsetY);
	COLORREF col = FFGetMiddleColor(double(labs(m_lTimerBlink)) / 5.0,
									g_pReg->GetOptiRegColor(FDCL_HTREE_LIGHT),
									g_pReg->GetOptiRegColor(FDCL_HTREE_TEMP_NODE));
	CPen pen(PS_COSMETIC, 1, col);
	CPen* pPenOld = dc.SelectObject(&pen);
	CBrush* pBrushOld = dc.SelectObject(CBrush::FromHandle((HBRUSH)GetStockObject(HOLLOW_BRUSH)));

	switch (GetViewMode())
	{
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		longSet::const_iterator iId;
		for (iId = m_stMarkUpDocumentId.begin(); iId != m_stMarkUpDocumentId.end(); iId++)
		{
			// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
			CRect rtVBox = m_pHtreeManager->GetNodeBoxRectInProject(*iId);
			if (!rtVBox.IsRectNull())
			{
//				rtVBox.DeflateRect(2, 2);
				dc.Rectangle(rtVBox);
				rtVBox.DeflateRect(1, 1);
				dc.Rectangle(rtVBox);
			}
		}
		break;
	  }
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		longSet::const_iterator iId;
		for (iId = m_stMarkUpDocumentId.begin(); iId != m_stMarkUpDocumentId.end(); iId++)
		{
			FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iId);
			if (pRec == NULL) continue;
			// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
			CRect rtVBox = pRec->GetNodeBoxRect();
//			rtVBox.DeflateRect(2, 2);
			dc.Rectangle(rtVBox);
			rtVBox.DeflateRect(1, 1);
			dc.Rectangle(rtVBox);
			// _xZkqqHx_jHjKjHpAjApMjGoOiIpDiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
			const CRect rtArrowLine = pRec->GetLifeArrowRect();
			CPoint pt[] = {
//----- 04.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//				CPoint(rtArrowLine.right - 1, rtArrowLine.top + 1),
//				CPoint((rtArrowLine.left + rtArrowLine.right) / 2, rtArrowLine.bottom - 1),
//				CPoint(rtArrowLine.left + 1, rtArrowLine.top + 1),
//				CPoint(rtArrowLine.right - 1, rtArrowLine.top + 1),
//----- 04.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
				CPoint(rtArrowLine.right, rtArrowLine.top),
				CPoint((rtArrowLine.left + rtArrowLine.right) / 2, rtArrowLine.bottom),
				CPoint(rtArrowLine.left, rtArrowLine.top),
				CPoint(rtArrowLine.right, rtArrowLine.top),
//----- 04.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			};
			dc.Polyline(pt, sizeof(pt) / sizeof(pt[0]));
			CPoint pt2[] = {
//----- 04.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//				CPoint(rtArrowLine.right - 2, rtArrowLine.top + 2),
//				CPoint((rtArrowLine.left + rtArrowLine.right) / 2, rtArrowLine.bottom - 2),
//				CPoint(rtArrowLine.left + 2, rtArrowLine.top + 2),
//				CPoint(rtArrowLine.right - 2, rtArrowLine.top + 2),
//----- 04.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
				CPoint(rtArrowLine.right - 1, rtArrowLine.top + 1),
				CPoint((rtArrowLine.left + rtArrowLine.right) / 2, rtArrowLine.bottom - 1),
				CPoint(rtArrowLine.left + 1, rtArrowLine.top + 1),
				CPoint(rtArrowLine.right - 1, rtArrowLine.top + 1),
//----- 04.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			};
			dc.Polyline(pt2, sizeof(pt2) / sizeof(pt2[0]));
		}
		break;
	  }
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		if (m_stMarkUpDocumentId.find(GetSelectedDocumentId()) != m_stMarkUpDocumentId.end())
		//----- _xZkqqHx_jBeJjBpAjCiGiCmMjHjKjHpAjFlGiPjBiCkKiDhNiBfLiDeOiDeBiDgCiDhGjBmOiPnLjCiGiCmJjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiCmMiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
			if (pRec == NULL) return;
			CRect rtVBox = pRec->GetNodeBoxRect();
//			rtVBox.DeflateRect(2, 2);
			dc.Rectangle(rtVBox);
			rtVBox.DeflateRect(1, 1);
			dc.Rectangle(rtVBox);
			// _xZkqqHx_jHjKjHpAjApMjGoOiIpDiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
			const CRect rtArrowLine = pRec->GetLifeArrowRect();
			CPoint pt[] = {
//----- 04.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//				CPoint(rtArrowLine.right - 1, rtArrowLine.top + 1),
//				CPoint((rtArrowLine.left + rtArrowLine.right) / 2, rtArrowLine.bottom - 1),
//				CPoint(rtArrowLine.left + 1, rtArrowLine.top + 1),
//				CPoint(rtArrowLine.right - 1, rtArrowLine.top + 1),
//----- 04.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
				CPoint(rtArrowLine.right, rtArrowLine.top),
				CPoint((rtArrowLine.left + rtArrowLine.right) / 2, rtArrowLine.bottom),
				CPoint(rtArrowLine.left, rtArrowLine.top),
				CPoint(rtArrowLine.right, rtArrowLine.top),
//----- 04.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			};
			dc.Polyline(pt, sizeof(pt) / sizeof(pt[0]));
			CPoint pt2[] = {
//----- 04.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//				CPoint(rtArrowLine.right - 2, rtArrowLine.top + 2),
//				CPoint((rtArrowLine.left + rtArrowLine.right) / 2, rtArrowLine.bottom - 2),
//				CPoint(rtArrowLine.left + 2, rtArrowLine.top + 2),
//				CPoint(rtArrowLine.right - 2, rtArrowLine.top + 2),
//----- 04.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
				CPoint(rtArrowLine.right - 1, rtArrowLine.top + 1),
				CPoint((rtArrowLine.left + rtArrowLine.right) / 2, rtArrowLine.bottom - 1),
				CPoint(rtArrowLine.left + 1, rtArrowLine.top + 1),
				CPoint(rtArrowLine.right - 1, rtArrowLine.top + 1),
//----- 04.06.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			};
			dc.Polyline(pt2, sizeof(pt2) / sizeof(pt2[0]));

			//----- _xZkqqHx_jFkKiKpCjHjKjHpAiDhLiDgCiDeOiDfI_xHqqkZx_/_xZkqqHx_iDiJiDhIiDiLiDhLiDgCiDeOiDfIiCmMjFgAiJoG_xHqqkZx_ -----
			FTSessionToNodeMmap::const_iterator iN;
			for (iN = pRec->GetSessionToNodeMmap().begin();
				 iN != pRec->GetSessionToNodeMmap().end(); iN++)
			{
				rtVBox.SetRect(	(*iN).second.m_ptRoot.x,
								(*iN).second.m_ptRoot.y - m_pHtreeManager->GetHistBoxSize().cy / 2,
								(*iN).second.m_ptRoot.x + m_pHtreeManager->GetHistBoxSize().cx,
								(*iN).second.m_ptRoot.y + m_pHtreeManager->GetHistBoxSize().cy / 2);
				rtVBox.DeflateRect(2, 2);
				dc.Rectangle(rtVBox);
				rtVBox.DeflateRect(1, 1);
				dc.Rectangle(rtVBox);
			}
		}
		break;
	  }
	}

	dc.SelectObject(pPenOld);
	dc.SelectObject(pBrushOld);
	// _xZkqqHx_iJlMjAnNjFkKiKpCjDjJiCmMjDfPjGmFiMfHjAjEiBeC_xHqqkZx_
	if (m_lTimerBlink == 5)
		m_lTimerBlink = -5;
	m_lTimerBlink++;
} // CFCWndHistoryTree::BlinkMarkUpHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::RedrawMarkUpHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiBfLiDeOiDeBiDgCiDhGjHjKjHpAjFlGiPjBiCpAiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::RedrawMarkUpHidocument ()
{
	switch (GetViewMode())
	{
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		longSet::const_iterator iId;
		for (iId = m_stMarkUpDocumentId.begin(); iId != m_stMarkUpDocumentId.end(); iId++)
		{
			// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
			CRect rtVBox = m_pHtreeManager->GetNodeBoxRectInProject(*iId);
			if (!rtVBox.IsRectNull())
			{
				InvalidateRect(LPtoDP(rtVBox));
			}
		}
		break;
	  }
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		longSet::const_iterator iId;
		for (iId = m_stMarkUpDocumentId.begin(); iId != m_stMarkUpDocumentId.end(); iId++)
		{
			FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(*iId);
			if (pRec == NULL) continue;
			// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
			CRect rtVBox = pRec->GetNodeBoxRect();
			InvalidateRect(LPtoDP(rtVBox));
			// _xZkqqHx_jHjKjHpAjApMjGoOiIpDiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
			const CRect rtArrowLine = pRec->GetLifeArrowRect();
			InvalidateRect(LPtoDP(rtArrowLine));
		}
		break;
	  }
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		if (m_stMarkUpDocumentId.find(GetSelectedDocumentId()) != m_stMarkUpDocumentId.end())
		//----- _xZkqqHx_jBeJjBpAjCiGiCmMjHjKjHpAjFlGiPjBiCkKiDhNiBfLiDeOiDeBiDgCiDhGjBmOiPnLjCiGiCmJjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiCmMiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
			if (pRec == NULL) return;
			CRect rtVBox = pRec->GetNodeBoxRect();
			InvalidateRect(LPtoDP(rtVBox));
			// _xZkqqHx_jHjKjHpAjApMjGoOiIpDiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
			const CRect rtArrowLine = pRec->GetLifeArrowRect();
			InvalidateRect(LPtoDP(rtArrowLine));
			//----- _xZkqqHx_jFkKiKpCjHjKjHpAiDhLiDgCiDeOiDfI_xHqqkZx_/_xZkqqHx_iDiJiDhIiDiLiDhLiDgCiDeOiDfIiCmMjFgAiJoG_xHqqkZx_ -----
			FTSessionToNodeMmap::const_iterator iN;
			for (iN = pRec->GetSessionToNodeMmap().begin();
				 iN != pRec->GetSessionToNodeMmap().end(); iN++)
			{
				rtVBox.SetRect(	(*iN).second.m_ptRoot.x,
								(*iN).second.m_ptRoot.y - m_pHtreeManager->GetHistBoxSize().cy / 2,
								(*iN).second.m_ptRoot.x + m_pHtreeManager->GetHistBoxSize().cx,
								(*iN).second.m_ptRoot.y + m_pHtreeManager->GetHistBoxSize().cy / 2);
				InvalidateRect(LPtoDP(rtVBox));
			}
		}
		break;
	  }
	}
	// _xZkqqHx_iNmEjFgAiJoGiBeC_xHqqkZx_
	UpdateWindow();
} // CFCWndHistoryTree::RedrawMarkUpHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetTempMarkRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJlMjAnNiDhNiBfLiDeOiCmMiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pt			:_xZkqqHx_iJlMjAnNiDhNiBfLiDeOiCmMjHjKjHpAjApMiPoDiCmMjAnKjBlBiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			rtTempMark	:_xZkqqHx_iJlMjAnNiDhNiBfLiDeOiCmMiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJlMjAnNiDhNiBfLiDeOiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::GetTempMarkRect (CPoint& pt, CRect& rtTempMark)
{
	switch (GetViewMode())
	{
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		pt = GetPointInTree(m_wstrTempMarkProjectPath,
							m_lTempMarkDocumentId,
							m_fliTempMarkSessionIndex);
		break;
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		pt = GetPointInBranch(	m_wstrTempMarkProjectPath,
								m_lTempMarkDocumentId,
								m_fliTempMarkSessionIndex);
		break;
	default:
		FFThrowMiscUnknown();
	}
	if (pt.x != -1)
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiBeBjHjKjHpAjFlGiPjBiCkKiMlLiNnNiCmMiDfIiDeOiDiKiBfLiDjDiCmGiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (GetViewMode() == FDHT_VMODE_BRANCH ||
			m_nTempMarkOrLabel == 0)
		//----- _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgI_xHqqkZx_ _xZkqqHx_iIlNiCkCiCmN_xHqqkZx_ _xZkqqHx_iJlMjAnNjHjKjHpAjFkKiKpCiCmMiPoKiNiH_xHqqkZx_ -----
		{
			CSize szForkBox = m_pHtreeManager->GetHistBoxSize();
			szForkBox.cx /= 2;
			szForkBox.cy /= 2;
			rtTempMark.left	= pt.x + m_pHtreeManager->GetHtLineIntroX();
			rtTempMark.top	= pt.y - (szForkBox.cy / 2);
			rtTempMark.right= rtTempMark.left + szForkBox.cx;
			rtTempMark.bottom= rtTempMark.top + szForkBox.cy;
		} else
		{
			rtTempMark.left	= pt.x - m_pHtreeManager->GetHtLifeWidthH() - m_pHtreeManager->GetHtHiForkTagGapX() - m_pHtreeManager->GetHtBoxIconW();
			rtTempMark.top	= pt.y;
			rtTempMark.right= rtTempMark.left + m_pHtreeManager->GetHtBoxIconW();
			rtTempMark.bottom= rtTempMark.top + m_pHtreeManager->GetHtBoxIconH();
		}
		return TRUE;
	}
	return FALSE;
} // CFCWndHistoryTree::GetTempMarkRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetAction
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiPpAiMiPiCmJiIoKjChGiClHiCoJiDeBiDeOiDfGiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwState	:_xZkqqHx_iPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeOiDfGiDiHiDjDiBeCiIoKjChGiClHiCoJiDeBiDeOiDfGiDiHiDjDiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_DWORD(0)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD CFCWndHistoryTree::GetAction (DWORD dwState) const
{
	DWORDVector::const_iterator i;
	for (i = m_vActionList.begin(); i != m_vActionList.end(); i++)
	{
		// _xZkqqHx_iCmHiCmMiDhCiDiFiBfLiCkJiBeC_xHqqkZx_
		if ((*i & dwState & FD_WHT_VW_MASK) == 0) continue;
		// _xZkqqHx_iDhNiDeFiDfIiCkKiCmHiClBiCmJiCkAiCoJiCkJiBeC_xHqqkZx_
		if ((*i & dwState & FD_WHT_ON_MASK) == 0) continue;
		// _xZkqqHx_iDhNiDeFiDfIiDhLiDfOiDjDiCmMiPpDjBnEiBeC_xHqqkZx_
		if ((*i & dwState & FD_WHT_MS_MASK) == 0) continue;
		// _xZkqqHx_iDeMiBfLiCmMiPpDjBnEiBeCiDeMiBfLiCmMiPpDjBnEiCmNiKkOjBfDiCmJiIoKjChGiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		if ((*i & FD_WHT_KY_MASK) != (dwState & FD_WHT_KY_MASK)) continue;
		return (*i & FD_WHT_AC_MASK);
	}
	return DWORD(0);
} // CFCWndHistoryTree::GetAction.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetMenuId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiPpAiMiPiCmJiIoKjChGiClHiCoJiDiBiDgKiDiFiBfL_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwState	:_xZkqqHx_iPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfL_xHqqkZx_ID_xZkqqHx_iBeCiIoKjChGiClHiCoJiDiBiDgKiDiFiBfL_xHqqkZx_ID_xZkqqHx_iCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCWndHistoryTree::GetMenuId (DWORD dwState) const
{
	DWORDVector::const_iterator i;
	for (i = m_vMenuIdList.begin(); i != m_vMenuIdList.end(); i++)
	{
		// _xZkqqHx_iCmHiCmMiDhCiDiFiBfLiCkJiBeC_xHqqkZx_
		if ((*i & dwState & FD_WHT_VW_MASK) == 0) continue;
		// _xZkqqHx_iDhNiDeFiDfIiCkKiCmHiClBiCmJiCkAiCoJiCkJiBeC_xHqqkZx_
		if ((*i & dwState & FD_WHT_ON_MASK) == 0) continue;
		return long(*i & FD_WHT_MENU_ID_MASK);
	}
	return -1;
} // CFCWndHistoryTree::GetMenuId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::GetMessageWnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjBjHjFhEjAoGiCmMiDeFiDeCiDjDiDgIiDeFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjBjHjFhEjAoGiCmMiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CWnd* CFCWndHistoryTree::GetMessageWnd ()
{
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjCmKjCgNiBeC_xHqqkZx_
	return (m_pMessageWnd != NULL) ? m_pMessageWnd : GetParent();
} // CFCWndHistoryTree::GetMessageWnd.

/////////////////////////////////////////////////////////////////////////////
// CFCWndHistoryTree _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDhNiDgCiDhGiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnDestroy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiNoNiPjMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnDestroy ()
{
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiOkJjDkO_xHqqkZx_Alt_xZkqqHx_iCmMjBmOiPnLiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
	FFGetMainWnd()->DeleteAutoAltWindow(m_hWnd);

	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	CWnd::OnDestroy();
} // CFCWndHistoryTree::OnDestroy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnVScroll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAiCjClMjFpLiMpMiCmMiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCkKjBiAiNoMiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nSBCode	:_xZkqqHx_jBiAiNoMiCmMiOoNjHnOiBeC_xHqqkZx_
 *			nPos	:_xZkqqHx_jBiAiNoMiMoDiCmM_xHqqkZx_thumb_xZkqqHx_iCmMiImKjChFiBeCiMmAiCoHiCoKiClN_xHqqkZx_nSBCode_xZkqqHx_iCmFiClFiCkJjHeMiMpIiCmFiCmIiCkCiBeC_xHqqkZx_
 *			pScrollBar:_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnVScroll (UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	int			iNewPos;
	SCROLLINFO	oSCInfo;
	GetScrollInfo(SB_VERT, &oSCInfo);
	int	iScrPos	= oSCInfo.nPos;
	int	iScrMin	= oSCInfo.nMin;
	int	iScrMax	= oSCInfo.nMax;
	int	iScrPage= oSCInfo.nPage;
	switch (nSBCode)
	{
	case SB_BOTTOM:
		// _xZkqqHx_iIoKjEnEiJlKiCnMiCmFiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		iNewPos	= iScrMax - iScrPage + 1;
		break;
	case SB_ENDSCROLL:
		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiPeJjHlJiBeC_xHqqkZx_
		iNewPos	= iScrPos;
		break;
	case SB_LINEDOWN:
		// 1 _xZkqqHx_iNhDiJlKiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		iNewPos	= iScrPos + iScrPage / 20;
		break;
	case SB_LINEUP:
		// 1 _xZkqqHx_iNhDiPoDiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		iNewPos	= iScrPos - iScrPage / 20;
		break;
	case SB_PAGEDOWN:
		// 1 _xZkqqHx_iDhJiBfLiDfHiJlKiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		iNewPos	= iScrPos + iScrPage;
		break;
	case SB_PAGEUP:
		// 1 _xZkqqHx_iDhJiBfLiDfHiPoDiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		iNewPos	= iScrPos - iScrPage;
		break;
	case SB_THUMBPOSITION:
		// _xZkqqHx_jAoCjBmOiImKjChFiCnGiDfIiDeOiDiNiBfLiDiLiBeCiMlLiNnNiImKjChFiCmN_xHqqkZx_ nPos _xZkqqHx_iCmFjCpBiLjPiBeC_xHqqkZx_
		iNewPos	= nPos;
		break;
	case SB_THUMBTRACK:
		// _xZkqqHx_iOhHjCoIiImKjChFiCnGiDfIiDeOiDiNiBfLiDiL_xHqqkZx_ _xZkqqHx_iDhLiDgCiDeOiDfIiCpAiDgIiDiJiDgCiDePiBeCiMlLiNnNiImKjChFiCmN_xHqqkZx_ nPos _xZkqqHx_iCmFjCpBiLjPiBeC_xHqqkZx_
		iNewPos	= nPos;
		break;
	case SB_TOP:
		// _xZkqqHx_iIoKjEnEiPoDiCnMiCmFiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		iNewPos	= iScrMin;
		break;
	}

//----- 03.03.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiImKjChFiCmMiPoDiMmAiBeFiJlKiMmAiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//	if (iNewPos < iScrMin) iNewPos = iScrMin;
//	if (iScrMax - iScrPage + 1 < iNewPos)
//		iNewPos = iScrMax - iScrPage + 1;
//	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
//	int iMove = iScrPos - iNewPos;
//	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjGlDiClFiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
//	if (iMove == 0) return;
//	// _xZkqqHx_iJoGjGmKiCpAiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
//	ScrollWindow(0, iMove);
//	// _xZkqqHx_jAfGiClFiCkCiDfIiDeOiDiNiBfLiDiLiDgPiBfLiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
//	SetScrollPos(SB_VERT, iNewPos);
//	// _xZkqqHx_jGlDiMpIjHmMiIoGiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//	UpdateWindow();
//----- 03.03.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	ScrollTo(m_lgOffsetX, D2L(iNewPos * m_dScrollRatioY));
//----- 03.03.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnVScroll(nSBCode, nPos, pScrollBar);
} // CFCWndHistoryTree::OnVScroll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnHScroll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCkKjBiAiNoMiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nSBCode	:_xZkqqHx_jBiAiNoMiCmMiOoNjHnOiBeC_xHqqkZx_
 *			nPos	:_xZkqqHx_jBiAiNoMiMoDiCmM_xHqqkZx_thumb_xZkqqHx_iCmMiImKjChFiBeCiMmAiCoHiCoKiClN_xHqqkZx_nSBCode_xZkqqHx_iCmFiClFiCkJjHeMiMpIiCmFiCmIiCkCiBeC_xHqqkZx_
 *			pScrollBar:_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnHScroll (UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	int			iNewPos;
	SCROLLINFO	oSCInfo;
	GetScrollInfo(SB_HORZ, &oSCInfo);
	int	iScrPos	= oSCInfo.nPos;
	int	iScrMin	= oSCInfo.nMin;
	int	iScrMax	= oSCInfo.nMax;
	int	iScrPage= oSCInfo.nPage;
	switch (nSBCode)
	{
	case SB_RIGHT:
		// _xZkqqHx_iIoKjEnEiJeFiCnMiCmFiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		iNewPos	= iScrMax - iScrPage + 1;
		break;
	case SB_ENDSCROLL:
		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiPeJjHlJiBeC_xHqqkZx_
		iNewPos	= iScrPos;
		break;
	case SB_LINERIGHT:
		// 1 _xZkqqHx_iNhDiJeFiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		iNewPos	= iScrPos + iScrPage / 20;
		break;
	case SB_LINELEFT:
		// 1 _xZkqqHx_iNhDiNlGiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		iNewPos	= iScrPos - iScrPage / 20;
		break;
	case SB_PAGERIGHT:
		// 1 _xZkqqHx_iDhJiBfLiDfHiJeFiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		iNewPos	= iScrPos + iScrPage;
		break;
	case SB_PAGELEFT:
		// 1 _xZkqqHx_iDhJiBfLiDfHiNlGiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		iNewPos	= iScrPos - iScrPage;
		break;
	case SB_THUMBPOSITION:
		// _xZkqqHx_jAoCjBmOiImKjChFiCnGiDfIiDeOiDiNiBfLiDiLiBeCiMlLiNnNiImKjChFiCmN_xHqqkZx_ nPos _xZkqqHx_iCmFjCpBiLjPiBeC_xHqqkZx_
		iNewPos	= nPos;
		break;
	case SB_THUMBTRACK:
		// _xZkqqHx_iOhHjCoIiImKjChFiCnGiDfIiDeOiDiNiBfLiDiL_xHqqkZx_ _xZkqqHx_iDhLiDgCiDeOiDfIiCpAiDgIiDiJiDgCiDePiBeCiMlLiNnNiImKjChFiCmN_xHqqkZx_ nPos _xZkqqHx_iCmFjCpBiLjPiBeC_xHqqkZx_
		iNewPos	= nPos;
		break;
	case SB_LEFT:
		// _xZkqqHx_iIoKjEnEiNlGiCnMiCmFiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		iNewPos	= iScrMin;
		break;
	}
	ScrollTo(D2L(iNewPos * m_dScrollRatioX), m_lgOffsetY);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnHScroll(nSBCode, nPos, pScrollBar);
} // CFCWndHistoryTree::OnHScroll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_iDfEiDeDiDfJjFmPiNfIiCmMiDfOiDeDiDhGiBeC_xHqqkZx_
 *			cx		:_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMjAfGiClFiCkCjFjNiBeC_xHqqkZx_
 *			cy		:_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMjAfGiClFiCkCiNiCiClDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnSize (UINT nType, int cx, int cy)
{
	BASE_CLASS::OnSize(nType, cx, cy);
	UpdateScrollSize();
} // CFCWndHistoryTree::OnSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnMouseMove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiInKjDkOiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_iDeMiBfLiCmMiPpDjBnEjDjJiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDeKiBfLiDfMiDiLiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnMouseMove (UINT nFlags, CPoint point)
{
//	TRACE(_T("CFCWndHistoryTree::OnMouseMove\n"));
	// _xZkqqHx_iDeKiBfLiDfMiDiLiImKjChFiCpAiDfIiDeOiDiNiBfLiDiLjFkKjFoCjAlDiBeC_xHqqkZx_
	CPoint ptLog = DPtoLP(point);

	// _xZkqqHx_jBePiJpBiCmMiDhNiDeFiDfIiImKjChFiCmGjEoEiKhCiBeCiDhNiDeFiDfIiCkKiInKjDkOiClFiCmEiCkCiCmIiCkNiCmEiCoA_xHqqkZx_
	// OnMouseMove_xZkqqHx_iCkKiIoKjCoIiOjOiKnEiKnEiKhFiCmFiMmEiCmOiCoKiCoJiCmMiCmFiBeBiClBiClBiCmFiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	// _xZkqqHx_jIfPjHjNiNmAjFfHiCmJjFmPiKlHiClFiCmEjEoEiKhCiClFiCmIiCkCiCmGiBeBiDhKiDeDiBfLiDiLiCmFiDfIiDeOiDiNiBfLiDiL_xHqqkZx_
	// _xZkqqHx_iClFiClNiCmGiCkLiCmJiBeBiDhNiDeFiDfIiNmAjFfHjCgMiCkKjFmPiJlLiClFiCmIiCkCiBeC_xHqqkZx_
	if (m_lgptLastMouse == ptLog) return;
	m_lgptLastMouse = ptLog;

	switch (GetViewMode())
	{
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		long lHitDocId;
		CRect lgrtHitBox;
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhLiDgCiDeOiDfIiBeBjHjKjHpAiDhLiDgCiDeOiDfIiCmMiCkCiClIiCoKiCkJiCmJiDhBiDgCiDgHiClFiClNiPoKiNiHiCmNiBeBiOhHiMfOiDeKiBfLiDfMiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
		if (WhichPtInProject(lHitDocId, lgrtHitBox, ptLog) != FDTR_NONE_REC)
			FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadCursor(IDC_CURSOR_FINGER));
		else
			FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadStandardCursor(IDC_ARROW));
		break;
	  }
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		flint fliSessionIndex;
		long lHitDocId;
		long lObjectId;
		CRect lgrtHitBox;
		if (WhichPtInTree(fliSessionIndex, lHitDocId, lObjectId, lgrtHitBox, ptLog) != FDTR_NONE_REC)
		//----- _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iOhHiMfOiDeKiBfLiDfMiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadCursor(IDC_CURSOR_FINGER));
		} else
		//----- _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCmJiDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jGoOiIpDiDeKiBfLiDfMiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadStandardCursor(IDC_ARROW));
		}
		break;
	  }
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		flint fliSessionIdx;
		long lObjectId;
		CRect lgrtHitBox;
		if (WhichPtInBranch(fliSessionIdx, lObjectId, lgrtHitBox, ptLog) != FDTR_NONE_REC)
		{
			// _xZkqqHx_iOhHiMfOiDeKiBfLiDfMiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadCursor(IDC_CURSOR_FINGER));
		} else
		{
			// _xZkqqHx_jGoOiIpDiDeKiBfLiDfMiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadStandardCursor(IDC_ARROW));
		}
		break;
	  }
	}
	// _xZkqqHx_iDfIiBfLiDhAiBfLiDeOiDiJiDfIiDiBiDjDiDgPiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnMouseMove(nFlags, point);
} // CFCWndHistoryTree::OnMouseMove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnLButtonDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiNlGiDhLiDfOiDjDiCpAiJlKiClAiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_iDeMiBfLiCmMiPpDjBnEjDjJiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDeKiBfLiDfMiDiLiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnLButtonDown (UINT nFlags, CPoint point)
{
	// _xZkqqHx_iClBiCmMiDeFiDeCiDjDiDgIiDeFiCmJiDhEiDeIiBfLiDeKiDfIiCpAiInKiClHiBeC_xHqqkZx_
	SetFocus();
	// _xZkqqHx_iDeKiBfLiDfMiDiLiImKjChFiCpAiDfIiDeOiDiNiBfLiDiLjFkKjFoCjAlDiBeC_xHqqkZx_
	CPoint ptLog = DPtoLP(point);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
//	SetLastPoint(L"", -1, -1);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
	SetLastPoint(L"", -1, -1, FDTR_NONE_REC, -1);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
	DWORD dwState = FD_WHT_MS_LBDOWN;

	if (nFlags & MK_SHIFT)
	//----- _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
		dwState |= FD_WHT_KY_SHIFT;
	} else
	if (nFlags & MK_CONTROL)
	//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
		dwState |= FD_WHT_KY_CTRL;
	}

	switch (GetViewMode())
	{
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
		dwState |= FD_WHT_VW_PROJECT;

		long lHitDocId = -1;
		CRect lgrtHitBox;
		FDTRClass clsHitObject = WhichPtInProject(lHitDocId, lgrtHitBox, ptLog);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
		SetLastPoint(GetSelectedProjectPath(), lHitDocId, -1, clsHitObject, -1);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		switch (clsHitObject)
		{
		case FDTR_TRUNK_REC:	// _xZkqqHx_iKlCiDgNiBfLiDgIiBeC_xHqqkZx_FCHLabelHtreeRec _xZkqqHx_iCmFiCmNiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//			SetLastPoint(m_pHtreeManager->GetProjectPath(), lHitDocId, -1);
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			if (lHitDocId == -1)
			//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiPoDiCmFiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
				dwState |= FD_WHT_ON_PROJECT;
			} else
			//----- _xZkqqHx_iCkCiClIiCoKiCkJiCmMjHjKjHpAiPoDiCmFiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
				dwState |= FD_WHT_ON_DOCUMENT;
			}
			break;
		case FDTR_EXPBOX_REC:	// _xZkqqHx_jDfHiKeKiDfCiDjDiDgHiDiNiBfLiDiLiDhLiDgCiDeOiDfIiDgNiBfLiDgIiBeC_xHqqkZx_FCHLabelHtreeRec _xZkqqHx_iCmFiCmNiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
		  {
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//			SetLastPoint(m_pHtreeManager->GetProjectPath(), lHitDocId, -1);
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iKgHjCkDiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
// 06.01.05 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			FCDocRecExtData* pExtData = (FCDocRecExtData*)m_pHtreeManager->GetDocRecExtData(lHitDocId).GetExtData();
			FCDocRecExtData* pExtData = m_pHtreeManager->GetDocRecExtData(lHitDocId);
			pExtData->SetIsSubTreeExpanded(!pExtData->GetIsSubTreeExpanded());
			SetZoom(GetZoom());	// _xZkqqHx_iDfJiBfLiDiAiCpAiNmEjAnNjCoIiBeCiClBiCoKiCmJiCoGiCmBiCmEiDiMiDeDiDeBiDeFiDgHiCoAiNmEiMhGiOfKiClDiCoKiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iMlLiNnNiImKjChFiDhNiBfLiDeOiCpAjFfMiOkGiBeCiDfIiDeOiDiNiBfLiDiLiCmNiClFiCmIiCkCiBeC_xHqqkZx_
			UpdateCurrent(FALSE);
			// _xZkqqHx_iClBiClBiCmFiPeJjHlJiBeC_xHqqkZx_
			dwState = 0;
			break;
		  }
		case FDTR_NONE_REC:		// _xZkqqHx_jGlDiClFiBeC_xHqqkZx_
			// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_BACKGROUND;
			break;
		default:
			FFThrowMiscUnknown();
		}

		switch (GetAction(dwState))
		{
		case FD_WHT_AC_MESSAGE:		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiDhMiDfIiDgHiBeC_xHqqkZx_
			if (GetMessageWnd() != NULL)
				GetMessageWnd()->PostMessage(WM_USER_WHT_LBUTTONDOWN, (WPARAM)GetDlgCtrlID(), 0);
			// _xZkqqHx_iOhHiMfOiDeKiBfLiDfMiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadCursor(IDC_CURSOR_FINGER));
			break;
		case FD_WHT_AC_SELECT:		// _xZkqqHx_jBeJjBpAiCpAjFmPiNfIiBeC_xHqqkZx_
		  {
			long lSelectedDocumentId = GetSelectedDocumentId();
			if (SetSelected(lHitDocId, -1, clsHitObject, -1))
			//----- _xZkqqHx_jHjKjHpAiCmMjBeJjBpAiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				InvalidateRect(LPtoDP(GetTopRectInProject(lSelectedDocumentId)) + CRect(2,2,2,2));
				InvalidateRect(LPtoDP(GetTopRectInProject(GetSelectedDocumentId())) + CRect(2,2,2,2));
			}
			break;
		  }
		case FD_WHT_AC_LOWER:		// _xZkqqHx_iJlKiImKiDhCiDiFiBfLiCnGjFmPiNfIiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iMlLiNnN_xHqqkZx_ _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmFjBeJjBpAiClDiCoKiCmEiCkCiCoJjHjKjHpAiOhNiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			SetSelected(lHitDocId, -1, clsHitObject, -1);
			if (!SetLowerViewMode())
				FFErrorBox(FFGetDDErrorMessage());
			break;
		  }
		}
		break;
	  }
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
		dwState |= FD_WHT_VW_TREE;

		flint fliSessionIdx;
		long lHitDocId;
		long lObjectId;
		CRect lgrtHitBox;
		FDTRClass clsHitObject = WhichPtInTree(fliSessionIdx, lHitDocId, lObjectId, lgrtHitBox, ptLog);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
		SetLastPoint(GetSelectedProjectPath(), lHitDocId, fliSessionIdx, clsHitObject, lObjectId);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		switch (clsHitObject)
		{
		case FDTR_TRUNK_REC:	// _xZkqqHx_jHjKjHpAjFlGiPjBiPoDiCmFiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//			SetLastPoint(m_pHtreeManager->GetProjectPath(), lHitDocId, fliSessionIdx);
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_DOCUMENT;
			break;
		case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//			SetLastPoint(m_pHtreeManager->GetProjectPath(), lHitDocId, fliSessionIdx);
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_HI_TAG;
			break;
		case FDTR_NONE_REC:		// _xZkqqHx_jEhHiMgJiBeC_xHqqkZx_
			// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_BACKGROUND;
			break;
		}
		switch (GetAction(dwState))
		{
		case FD_WHT_AC_MESSAGE:		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiDhMiDfIiDgHiBeC_xHqqkZx_
			if (GetMessageWnd() != NULL)
				GetMessageWnd()->PostMessage(WM_USER_WHT_LBUTTONDOWN, (WPARAM)GetDlgCtrlID(), 0);
			// _xZkqqHx_iOhHiMfOiDeKiBfLiDfMiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadCursor(IDC_CURSOR_FINGER));
			break;
		case FD_WHT_AC_SELECT:		// _xZkqqHx_jBeJjBpAiCpAjFmPiNfIiBeC_xHqqkZx_
		  {
			long lSelectedDocumentId = GetSelectedDocumentId();
			FDTRClass clsSelectedObject = GetSelectedObject();
			long lSelectedObjectId = GetSelectedObjectId();
			if (SetSelected(lHitDocId, fliSessionIdx, clsHitObject, lObjectId))
			//----- _xZkqqHx_jHjKjHpAiCmMjBeJjBpAiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				InvalidateRect(LPtoDP(GetRectInTree(lSelectedDocumentId,
													clsSelectedObject,
													lSelectedObjectId)) + CRect(2,2,2,2));
				InvalidateRect(LPtoDP(GetRectInTree(GetSelectedDocumentId(),
													GetSelectedObject(),
													GetSelectedObjectId())) + CRect(2,2,2,2));
			}
			break;
		  }
		case FD_WHT_AC_LOWER:		// _xZkqqHx_iJlKiImKiDhCiDiFiBfLiCnGjFmPiNfIiBeC_xHqqkZx_
		  {
			SetSelected(lHitDocId, fliSessionIdx, clsHitObject, lObjectId);
			if (!SetLowerViewMode())
				FFErrorBox(FFGetDDErrorMessage());
			break;
		  }
		case FD_WHT_AC_UPPER:		// _xZkqqHx_iPoDiImKiDhCiDiFiBfLiCnGjFmPiNfIiBeC_xHqqkZx_
		  {
			if (!SetUpperViewMode())
				FFErrorBox(FFGetDDErrorMessage());
			break;
		  }
		}
		break;
	  }
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
		dwState |= FD_WHT_VW_BRANCH;

		flint fliSessionIdx;
		long lObjectId;
		CRect lgrtHitBox;
		FDTRClass clsHitObject = WhichPtInBranch(fliSessionIdx, lObjectId, lgrtHitBox, ptLog);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
		SetLastPoint(GetSelectedProjectPath(), GetSelectedDocumentId(), fliSessionIdx, clsHitObject, lObjectId);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		switch (clsHitObject)
		{
		case FDTR_TRUNK_REC:	// _xZkqqHx_jHjKjHpAjFlGiPjBiPoDiCmFiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//			SetLastPoint(m_pHtreeManager->GetProjectPath(), GetSelectedDocumentId(), fliSessionIdx);
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_DOCUMENT;
			break;
		case FDTR_HTREE_REC:		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//			SetLastPoint(m_pHtreeManager->GetProjectPath(), GetSelectedDocumentId(), fliSessionIdx);
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_SUB_DOCUMENT;
			break;
		case FDTR_LABEL_REC:		// _xZkqqHx_iDiJiDhIiDiLiBeC_xHqqkZx_
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//			SetLastPoint(m_pHtreeManager->GetProjectPath(), GetSelectedDocumentId(), fliSessionIdx);
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_LABEL;
			break;
		case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//			SetLastPoint(m_pHtreeManager->GetProjectPath(), GetSelectedDocumentId(), fliSessionIdx);
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_HI_TAG;
			break;
		case FDTR_TIME_LABEL_REC:	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//			SetLastPoint(m_pHtreeManager->GetProjectPath(), GetSelectedDocumentId(), fliSessionIdx);
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_TIME_LABEL;
			break;
		case FDTR_TIME_REC:			// _xZkqqHx_iOjOiKnEiBeC_xHqqkZx_FCHLabelHtreeRec _xZkqqHx_iCmFiCmNiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//			SetLastPoint(m_pHtreeManager->GetProjectPath(), GetSelectedDocumentId(), fliSessionIdx);
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_TIME;
			break;
		case FDTR_NONE_REC:		// _xZkqqHx_jEhHiMgJiBeC_xHqqkZx_
			// _xZkqqHx_iDeBiDeOiDfGiDiHiDjDiPpAiMiPiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_BACKGROUND;
			break;
		default:
			FFThrowMiscUnknown();
		}

		switch (GetAction(dwState))
		{
		case FD_WHT_AC_MESSAGE:		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiDhMiDfIiDgHiBeC_xHqqkZx_
			if (GetMessageWnd() != NULL)
				GetMessageWnd()->PostMessage(WM_USER_WHT_LBUTTONDOWN, (WPARAM)GetDlgCtrlID(), 0);
			// _xZkqqHx_iOhHiMfOiDeKiBfLiDfMiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadCursor(IDC_CURSOR_FINGER));
			break;
		case FD_WHT_AC_SELECT:		// _xZkqqHx_jBeJjBpAiCpAjFmPiNfIiBeC_xHqqkZx_
		  {
			FDTRClass clsSelectedObject = GetSelectedObject();
			long lSelectedObjectId = GetSelectedObjectId();
			if (SetSelected(GetSelectedDocumentId(), fliSessionIdx, clsHitObject, lObjectId))
			//----- _xZkqqHx_jHjKjHpAiCmMjBeJjBpAiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				InvalidateRect(LPtoDP(GetRectInBranch(clsSelectedObject,
													lSelectedObjectId)) + CRect(2,2,2,2));
				InvalidateRect(LPtoDP(GetRectInBranch(GetSelectedObject(),
													GetSelectedObjectId())) + CRect(2,2,2,2));
			}
			break;
		  }
		case FD_WHT_AC_UPPER:		// _xZkqqHx_iPoDiImKiDhCiDiFiBfLiCnGjFmPiNfIiBeC_xHqqkZx_
		  {
			if (!SetUpperViewMode())
				FFErrorBox(FFGetDDErrorMessage());
			break;
		  }
		}
		break;
	  }
	}
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnLButtonDown(nFlags, point);
} // CFCWndHistoryTree::OnLButtonDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnLButtonUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiNlGiDhLiDfOiDjDiCpAiPoDiClAiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_iDeMiBfLiCmMiPpDjBnEjDjJiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDeKiBfLiDfMiDiLiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnLButtonUp (UINT nFlags, CPoint point)
{
	// _xZkqqHx_iDeKiBfLiDfMiDiLiImKjChFiCpAiDfIiDeOiDiNiBfLiDiLjFkKjFoCjAlDiBeC_xHqqkZx_
	CPoint ptLog = DPtoLP(point);

	switch (GetViewMode())
	{
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		long lHitDocId;
		CRect lgrtHitBox;
		if (WhichPtInProject(lHitDocId, lgrtHitBox, ptLog) != FDTR_NONE_REC)
			FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadCursor(IDC_CURSOR_FINGER));
										// _xZkqqHx_iOhHiMfOiDeKiBfLiDfMiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
		break;
	  }
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		flint fliSessionIndex;
		long lHitDocId;
		long lObjectId;
		CRect lgrtHitBox;
		if (WhichPtInTree(fliSessionIndex, lHitDocId, lObjectId, lgrtHitBox, ptLog) != FDTR_NONE_REC)
			FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadCursor(IDC_CURSOR_FINGER));
										// _xZkqqHx_iOhHiMfOiDeKiBfLiDfMiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
		break;
	  }
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		flint fliSessionIndex;
		long lObjectId;
		CRect lgrtHitBox;
		if (WhichPtInBranch(fliSessionIndex, lObjectId, lgrtHitBox, ptLog) != FDTR_NONE_REC)
			FFGetMainWnd()->SetCurCursor(this, FFGetApp()->LoadCursor(IDC_CURSOR_FINGER));
										// _xZkqqHx_iOhHiMfOiDeKiBfLiDfMiDiLiCpAjFfMiOkGiBeC_xHqqkZx_
		break;
	  }
	}
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnLButtonUp(nFlags, point);
} // CFCWndHistoryTree::OnLButtonUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnRButtonDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiJeFiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_iDeMiBfLiCmMiPpDjBnEjDjJiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDeKiBfLiDfMiDiLiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnRButtonDown (UINT nFlags, CPoint point)
{
	// _xZkqqHx_iClBiCmMiDeFiDeCiDjDiDgIiDeFiCmJiDhEiDeIiBfLiDeKiDfIiCpAiInKiClHiBeC_xHqqkZx_
	SetFocus();
	// _xZkqqHx_iDeKiBfLiDfMiDiLiImKjChFiCpAiDfIiDeOiDiNiBfLiDiLjFkKjFoCjAlDiBeC_xHqqkZx_
	CPoint ptLog = DPtoLP(point);

//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
//	SetLastPoint(L"", -1, -1);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
	SetLastPoint(L"", -1, -1, FDTR_NONE_REC, -1);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	switch (GetViewMode())
	{
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		long lHitDocId;
		CRect lgrtHitBox;
		FDTRClass clsHitObject = WhichPtInProject(lHitDocId, lgrtHitBox, ptLog);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
		SetLastPoint(GetSelectedProjectPath(), lHitDocId, -1, clsHitObject, -1);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//		SetLastPoint(m_pHtreeManager->GetProjectPath(), lHitDocId, -1);
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		long lSelectedDocumentId = GetSelectedDocumentId();
		if (SetSelected(lHitDocId, -1, clsHitObject, -1))
		//----- _xZkqqHx_jHjKjHpAiCmMjBeJjBpAiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			InvalidateRect(LPtoDP(GetTopRectInProject(lSelectedDocumentId)) + CRect(2,2,2,2));
			InvalidateRect(LPtoDP(GetTopRectInProject(GetSelectedDocumentId())) + CRect(2,2,2,2));
		}
		break;
	  }
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		flint fliSessionIdx;
		long lHitDocId;
		long lObjectId;
		CRect lgrtHitBox;
		FDTRClass clsHitObject = WhichPtInTree(fliSessionIdx, lHitDocId, lObjectId, lgrtHitBox, ptLog);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
		SetLastPoint(GetSelectedProjectPath(), lHitDocId, fliSessionIdx, clsHitObject, lObjectId);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//		SetLastPoint(m_pHtreeManager->GetProjectPath(), lHitDocId, fliSessionIdx);
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		long lSelectedDocumentId = GetSelectedDocumentId();
		FDTRClass clsSelectedObject = GetSelectedObject();
		long lSelectedObjectId = GetSelectedObjectId();
		if (SetSelected(lHitDocId, fliSessionIdx, clsHitObject, lObjectId))
		//----- _xZkqqHx_jHjKjHpAiCmMjBeJjBpAiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			InvalidateRect(LPtoDP(GetRectInTree(lSelectedDocumentId,
												clsSelectedObject,
												lSelectedObjectId)) + CRect(2,2,2,2));
			InvalidateRect(LPtoDP(GetRectInTree(GetSelectedDocumentId(),
												GetSelectedObject(),
												GetSelectedObjectId())) + CRect(2,2,2,2));
		}
		break;
	  }
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		flint fliSessionIdx;
		long lObjectId;
		CRect lgrtHitBox;
		FDTRClass clsHitObject = WhichPtInBranch(fliSessionIdx, lObjectId, lgrtHitBox, ptLog);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
		SetLastPoint(GetSelectedProjectPath(), GetSelectedDocumentId(), fliSessionIdx, clsHitObject, lObjectId);
//----- 05.09.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iNmFiMoDiCmMiDhNiDeFiDfIiDeOiDiKiDgCiDeOiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//		SetLastPoint(m_pHtreeManager->GetProjectPath(), GetSelectedDocumentId(), fliSessionIdx);
//----- 05.09.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

		FDTRClass clsSelectedObject = GetSelectedObject();
		long lSelectedObjectId = GetSelectedObjectId();
		if (SetSelected(GetSelectedDocumentId(), fliSessionIdx, clsHitObject, lObjectId))
		//----- _xZkqqHx_jHjKjHpAiCmMjBeJjBpAiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			InvalidateRect(LPtoDP(GetRectInBranch(clsSelectedObject,
												lSelectedObjectId)) + CRect(2,2,2,2));
			InvalidateRect(LPtoDP(GetRectInBranch(GetSelectedObject(),
												GetSelectedObjectId())) + CRect(2,2,2,2));
		}
		break;
	  }
	}
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnRButtonDown(nFlags, point);
} // CFCWndHistoryTree::OnRButtonDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnMouseWheel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgFiDiKiDhNiDeFiDfIiCmM_xHqqkZx_wheel_xZkqqHx_iCkKiJpBjDfNiClFiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiCmEiCkCiCoJiDeMiBfLiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			zDelta	:_xZkqqHx_iJpBjDfNiLjHjHkDiCpAiOhHiOkGiBeC_xHqqkZx_zDelta _xZkqqHx_jCgMiCmN_xHqqkZx_ WHEEL_DELTA (_xZkqqHx_jCgM_xHqqkZx_ 120)
 *					 _xZkqqHx_iCmMjEhLjAjEiCnMiClNiCmNjGpBjAjEiCmJiClFiCnMiClHiBeC_xHqqkZx_
 *			pt		:_xZkqqHx_iDeKiBfLiDfMiDiLiCmM_xHqqkZx_ xy _xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeCiDeFiDeCiDjDiDgIiDeFiCmMiNlGiPoDiLpHiCpAiMlEjDfPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiDhKiDeDiBfLiDiLiDfIiDeOiDiNiBfLiDiLiCkKjHeMiMpIiCmIiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iImIiKePiCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jGlDiMpIiCmIiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCWndHistoryTree::OnMouseWheel (UINT nFlags, short zDelta, CPoint pt)
{
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiCpAiOfKiPgPiBeC_xHqqkZx_
	int nToScroll = FFWheelDeltaToScrollCount(zDelta);

	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiCkKiJjPiClDiCoKiCmEiCkCiCoKiCmOiDfJiBfLiDiAiBeC_xHqqkZx_
	// _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCkKiJjPiClDiCoKiCmEiCkCiCoKiCmOiJkBiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
	// _xZkqqHx_iJlNiCoAiJjPiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiPgDiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
	if (nFlags & MK_CONTROL)
	//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiCkKiJjPiClDiCoKiCmEiCkCiCoKiCmOiDfJiBfLiDiA_xHqqkZx_ -----
	{
		if (CanZoom())
		//----- _xZkqqHx_iDfJiBfLiDiAiJmCjEfMiCmFiCkAiCoKiCmOiDfJiBfLiDiA_xHqqkZx_ -----
		{
			// _xZkqqHx_iMlLiNnNiCmMiDfJiBfLiDiAiCpA_xHqqkZx_100%_xZkqqHx_jFfMiLeMiCmFiOoGjDlOiBeC_xHqqkZx_
			long lZoom100 = D2L(100.0 * GetZoom());
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			if (nToScroll < 0)
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			if ((0 < nToScroll && !g_pReg->GetIsZoomReverseCtrlWheel()) ||
				(nToScroll < 0 && g_pReg->GetIsZoomReverseCtrlWheel()))
//----- 06.11.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			{
				if (GetMessageWnd() != NULL)
				{
					// _xZkqqHx_iMlLiNnNiCmMiDfJiBfLiDiAjCgMiCoGiCoIiBeBiIoKiCmCiPkMiClDiCkCjCgMiCpAjBeJjBpAiBeC_xHqqkZx_
					long lNewZoom = D2L(double(FFGetLowerZoomValue(ID_HTREE_CMB_ZOOM, lZoom100)) * 2.56);
					GetMessageWnd()->PostMessage(WM_USER_SET_HIVIEW_ZOOM256, TRUE, lNewZoom);
				}

			} else
			{
				if (GetMessageWnd() != NULL)
				{
					// _xZkqqHx_iMlLiNnNiCmMiDfJiBfLiDiAjCgMiCoGiCoIiBeBiIoKiCmCjBoFiCkLiCkCjCgMiCpAjBeJjBpAiBeC_xHqqkZx_
					long lNewZoom = D2L(double(FFGetUpperZoomValue(ID_HTREE_CMB_ZOOM, lZoom100)) * 2.56);
					GetMessageWnd()->PostMessage(WM_USER_SET_HIVIEW_ZOOM256, TRUE, lNewZoom);
				}
			}
		}
	} else
	if (nFlags & MK_SHIFT)
	//----- _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCkKiJjPiClDiCoKiCmEiCkCiCoKiCmOiJkBiDfIiDeOiDiNiBfLiDiL_xHqqkZx_ -----
	{
		SCROLLINFO oSCInfo;
		GetScrollInfo(SB_HORZ, &oSCInfo);
		int nScrPos  = oSCInfo.nPos;
		int nScrDelt = int(oSCInfo.nPage) / 20;
		if (nScrDelt <= 0) nScrDelt = 1;
		int nNewPos = nScrPos + nToScroll * nScrDelt;
		SendMessage(WM_HSCROLL, MAKELONG(SB_THUMBPOSITION, nNewPos), 0);
	} else
	//----- _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCkKiJjPiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiPgDiDfIiDeOiDiNiBfLiDiL_xHqqkZx_ -----
	{
		SCROLLINFO oSCInfo;
		GetScrollInfo(SB_VERT, &oSCInfo);
		int nScrPos  = oSCInfo.nPos;
		int nScrDelt = int(oSCInfo.nPage) / 20;
		if (nScrDelt <= 0) nScrDelt = 1;
		int nNewPos = nScrPos + nToScroll * nScrDelt;
		SendMessage(WM_VSCROLL, MAKELONG(SB_THUMBPOSITION, nNewPos), 0);
	}

	// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMiMlLiNnNiCmMiImKjChFiCpAiBeBiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
	CPoint dvptMsc;
	(void)::GetCursorPos(&dvptMsc);
	// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiNmAjFfHiCpAiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCnGjFmPiKlHiBeC_xHqqkZx_
	ScreenToClient(&dvptMsc);
	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiDiBiDgCiDfKiBfLiDfHiCpAiDhMiDfIiDgHiBeC_xHqqkZx_
	PostMessage(WM_MOUSEMOVE, 0, MAKELPARAM(dvptMsc.x, dvptMsc.y));

//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::OnMouseWheel(nFlags, zDelta, pt);
} // CFCWndHistoryTree::OnMouseWheel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnContextMenu
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDeOiDiKiDgCiDeOiCmFiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pWnd	:_xZkqqHx_iJeFiDeOiDiKiDgCiDeOiCmMjBmOiPnLiCmMiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiBgJiDfIiDeOiDiKiBfLiDjDiNmAjFfHiBgKiCpAiOhHjCoIiBeCiDiBiDgKiDiFiBfL_xHqqkZx_
 *					 _xZkqqHx_iDeMiBfLiCmMiPoKiNiHiCmN_xHqqkZx_(-1,-1)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnContextMenu (CWnd* pWnd, CPoint point)
{
	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAjIfPjHjNiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
	ScreenToClient(&point);
	// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(&rtClient);
	if (!rtClient.PtInRect(point))
	//----- _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCkKiDeOiDiJiDeDiDeBiDjDiDgHiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		CRect rtBox(0,0,0,0);
		switch (GetViewMode())
		{
		case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
			rtBox = m_pHtreeManager->GetNodeBoxRectInProject(GetSelectedDocumentId());
			break;
		case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		  {
			const FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
			rtBox = pRec->GetNodeBoxRect();
			break;
		  }
		}
		// _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCmMjCiGjAfDiNmAjFfHiCpAiDiBiDgKiDiFiBfLiNmAjFfHiCmJiBeC_xHqqkZx_
		point = LPtoDP(CPoint((rtBox.left + rtBox.right) / 2, rtBox.bottom));
		// _xZkqqHx_iDiBiDgKiDiFiBfLiNmAjFfHiCkKiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiKePiCmMiPoKiNiHiCmNiBeBjFoCjAlDiBeC_xHqqkZx_
		if (point.x < rtClient.left) point.x = rtClient.left;
		if (point.y < rtClient.top) point.y = rtClient.top;
		if (rtClient.right < point.x) point.x = rtClient.right;
		if (rtClient.bottom < point.y) point.y = rtClient.bottom;
	}
	// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmJjGnPiClHiBeC_xHqqkZx_
	ClientToScreen(&point);

	// _xZkqqHx_iDiBiDgKiDiFiBfL_xHqqkZx_ID_xZkqqHx_iPpAiMiPiBeC_xHqqkZx_
	DWORD dwState = 0;
	switch (GetViewMode())
	{
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		// _xZkqqHx_iDiBiDgKiDiFiBfL_xHqqkZx_ID_xZkqqHx_iPpAiMiPiBeC_xHqqkZx_
		dwState |= FD_WHT_VW_PROJECT;
		break;
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		// _xZkqqHx_iDiBiDgKiDiFiBfL_xHqqkZx_ID_xZkqqHx_iPpAiMiPiBeC_xHqqkZx_
		dwState |= FD_WHT_VW_TREE;
		break;
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
		// _xZkqqHx_iDiBiDgKiDiFiBfL_xHqqkZx_ID_xZkqqHx_iPpAiMiPiBeC_xHqqkZx_
		dwState |= FD_WHT_VW_BRANCH;
		break;
	}
//----- 05.09.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (*GetLastClickedProjectPath() == L'\0')
//		dwState |= FD_WHT_ON_BACKGROUND;
//	else
//	if (GetLastClickedDocumentId() == -1)
//		dwState |= FD_WHT_ON_PROJECT;
//	else
//		dwState |= FD_WHT_ON_DOCUMENT;
//----- 05.09.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!IsSelectedProjectOpened())
	{
		dwState |= FD_WHT_ON_BACKGROUND;
	} else
	{
		switch (GetSelectedObject())
		{
		case FDTR_TRUNK_REC:	// _xZkqqHx_jHjKjHpAjFlGiPjBiPoDiCmFiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
			if (GetSelectedDocumentId() == -1)
				dwState |= FD_WHT_ON_PROJECT;
			else
				dwState |= FD_WHT_ON_DOCUMENT;
			break;
		case FDTR_HTREE_REC:		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_SUB_DOCUMENT;
			break;
		case FDTR_LABEL_REC:		// _xZkqqHx_iDiJiDhIiDiLiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_LABEL;
			break;
		case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_HI_TAG;
			break;
		case FDTR_TIME_LABEL_REC:	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
			dwState |= FD_WHT_ON_TIME_LABEL;
			break;
		default:	// FDTR_TIME_REC_xZkqqHx_iBgJiOjOiKnEiBgKiBeB_xHqqkZx_FDTR_NONE_REC_xZkqqHx_iBgJjEhHiMgJiBgK_xHqqkZx_
			FFThrowMiscUnknown();
		}
	}
//----- 05.09.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	long lMenuId = GetMenuId(dwState);
	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeC_xHqqkZx_
//----- 06.02.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (lMenuId != -1)
//		FFPopupSubmenu(point, IDR_RBTN_MISC, lMenuId, AfxGetMainWnd());
//----- 06.02.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (lMenuId != -1)
		FFPopupSubmenu(point, IDR_RBTN_MISC, lMenuId, FFGetMainWnd()->GetWnd());
//----- 06.02.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // CFCWndHistoryTree::OnContextMenu.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnSetFocus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiBfLiDeKiDfIiCkKjAnNjCoIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pOldWnd	: _xZkqqHx_iClBiCmMjBePiCmJiDhEiDeIiBfLiDeKiDfIiCkKjAnNjCoIiClDiCoKiCmEiCkCiClNiDeFiDeCiDjDiDgIiDeF_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnSetFocus (CWnd* pOldWnd)
{
	// IME_xZkqqHx_iCpAjFmCiClGiCoJiBeC_xHqqkZx_
	::CloseImeStatus(m_hWnd);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSetFocus(pOldWnd);
} // CFCWndHistoryTree::OnSetFocus.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnImeNotify
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IME_xZkqqHx_iCmM_xHqqkZx_On/Off_xZkqqHx_iCpAjAnIiCoIjBnGiCkGiCoJiCmGiCkLiCmIiCmHiCkKjCmKjCgNiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_jCmKjCgNiCmMjDoAjHgFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCfAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCWndHistoryTree::OnImeNotify (WPARAM wParam, LPARAM lParam)
{
#if defined(_IME_ON)
	if (wParam == IMN_SETOPENSTATUS)
	{
		// IME_xZkqqHx_iCpAjFmCiClGiCoJiBeC_xHqqkZx_
		::CloseImeStatus(m_hWnd);
		return 1;
	}
#endif // defined(_IME_ON)
	// _xZkqqHx_iClBiCoKiCpAiMmEiCmOiCmIiCkCiCmGiBeB_xHqqkZx_WindowsMe_xZkqqHx_iCmFiNmFiPiJiCmMiLeOjDkOiOjOiCmMiCnNjDpKjGhLiMoKjDpMjHmNiOjOiCmJ_xHqqkZx_IME_xZkqqHx_iCkKjFfMiOkGiClDiCoKiCmIiCkCiBeC_xHqqkZx_
	return Default();
} // CFCWndHistoryTree::OnImeNotify.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnUserSetZoom256
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAjEhLjHkGiCpAjAnNjCoIiClHiCoJiBeCjAnNjCoIiClHiCoJjAjEjCgMiCmNiBeB_xHqqkZx_256_xZkqqHx_iCpAiCfAjEhLiCmGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jBkGiClPiBeBiCfBjEhLiCmIiCoHiCmO_xHqqkZx_512_xZkqqHx_iBeB_xHqqkZx_0.5_xZkqqHx_jEhLiCmIiCoHiCmO_xHqqkZx_128_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_iDfJiBfLiDiAjEhLjHkGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCfAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCWndHistoryTree::OnUserSetZoom256 (WPARAM wParam, LPARAM lParam)
{
	if (g_pFileServer->IsFlushing())
	//----- _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmNiBeBiDiNiDgCiDeOiCoCiDhEiDeAiDeDiDiLiCmJiIoKjAnIiDfOiDgCiDgAiClFiCmIiCkC_xHqqkZx_
		// _xZkqqHx_iCoGiCkEiCmJiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCmMiClNiCnPiBeBjGlDiMpIiCmFiClHiBeC_xHqqkZx_
		FFErrorBox(IDS_MSG_INVALID_IN_FLUSHING);
		return 1;
	}

	// _xZkqqHx_iDfJiBfLiDiAjCgMiCmJjFmPiNfIjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (D2L(GetZoom() * 256.0) == lParam) return 1;
	// _xZkqqHx_iDfJiBfLiDiAjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	SetZoom(double(lParam) / 256.0);
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeCiKePjFjEiCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_public_xZkqqHx_iKnGjAjEiCmJjFeLjAhLiBeC_xHqqkZx_
//	m_pHtreeManager->UnlockAll();
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return 1;
} // CFCWndHistoryTree::OnUserSetZoom256.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnUserPursuerTextNeedInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCkKiDhBiDjDiDgHiPoOjFpBiCmMjAnNjCoIiCpAjHhGiLiBiClHiCoJiNnLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFeLiClIiBeB_xHqqkZx_GetCursorPos_xZkqqHx_iKnGjAjEiCmFiDhNiDeFiDfIiImKjChFiCpAiOoGjDlOiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCkK_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJjHiKiCmBiCmEiCkCiCoJiCmGiBeBiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmIiCmHiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiMlLiNnNiCmMiImKjChFiCmGjAeIiCkCiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCWndHistoryTree::OnUserPursuerTextNeedInfo (WPARAM, LPARAM)
{
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmMiDhMiDgCiDhGiDhBiDjDiDgHiCpAjFfMiOkGiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!g_pReg->GetIsPopupHint() || !g_pReg->GetIsPopupHtreeViewHint()) return 1;
	switch (GetViewMode())
	{
	case FDHT_VMODE_PROJECT:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		long lHitDocId;
		CRect lgrtHitBox;
		switch (WhichPtInProject(lHitDocId, lgrtHitBox, m_lgptLastMouse))
		{
		case FDTR_TRUNK_REC:	// _xZkqqHx_iKlCiDgNiBfLiDgIiBeC_xHqqkZx_
			if (lHitDocId != -1)
			//----- _xZkqqHx_jHjKjHpAiDhLiDgCiDeOiDfIiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jCmHjAnFiDgFiDeMiDfIiDgHiDhBiDjDiDgHiCpAjFfMiOkGiBeC_xHqqkZx_
				FFGetApp()->GetPopHint()->SetTargetInfo(m_pHtreeManager->GetDocRecExtData(lHitDocId)->GetHintText());
			} else
			//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhLiDgCiDeOiDfIiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ ----
			{
				// _xZkqqHx_jCmHjAnFiDgFiDeMiDfIiDgHiDhBiDjDiDgHiCpAjFfMiOkGiBeC_xHqqkZx_
				FFGetApp()->GetPopHint()->SetTargetInfo(m_pHtreeManager->GetProjectHintText());
			}
// 06.03.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			break;
			return 1;
		}
		break;
	  }
	case FDHT_VMODE_TREE:		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		flint fliSessionIndex;
		long lHitDocId;
		long lObjectId;
		CRect lgrtHitBox;
		switch (WhichPtInTree(fliSessionIndex, lHitDocId, lObjectId, lgrtHitBox, m_lgptLastMouse))
		{
		case FDTR_TRUNK_REC:		// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
		  {
			FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(lHitDocId);
			// _xZkqqHx_jCmHjAnFiDgFiDeMiDfIiDgHiDhBiDjDiDgHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetApp()->GetPopHint()->SetTargetInfo(pRec->GetHintText(fliSessionIndex));
// 06.03.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			break;
			return 1;
		  }
		case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
		  {
			FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(lHitDocId);
			// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			FCHiForkTagRec* pHiForkTagRec = pRec->GetHiForkTagRec(lObjectId);
			// _xZkqqHx_jCmHjAnFiDgFiDeMiDfIiDgHiDhBiDjDiDgHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetApp()->GetPopHint()->SetTargetInfo(pHiForkTagRec->GetHintText(m_pHtreeManager));
// 06.03.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			break;
			return 1;
		  }
		}
		break;
	  }
	case FDHT_VMODE_BRANCH:		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	  {
		flint fliSessionIdx;
		long lObjectId;
		CRect lgrtHitBox;
		switch (WhichPtInBranch(fliSessionIdx, lObjectId, lgrtHitBox, m_lgptLastMouse))
		{
		case FDTR_TRUNK_REC:				// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBgJiKlCiBgKiBeC_xHqqkZx_
		  {
			FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
			// _xZkqqHx_jCmHjAnFiDgFiDeMiDfIiDgHiDhBiDjDiDgHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetApp()->GetPopHint()->SetTargetInfo(pRec->GetHintText(fliSessionIdx));
// 06.03.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			break;
			return 1;
		  }
		case FDTR_HTREE_REC:			// _xZkqqHx_jHjKjHpAiDgNiBfLiDgIiBeC_xHqqkZx_
		  {
			FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(lObjectId);
			// _xZkqqHx_jCmHjAnFiDgFiDeMiDfIiDgHiDhBiDjDiDgHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetApp()->GetPopHint()->SetTargetInfo(pRec->GetHintText(fliSessionIdx));
// 06.03.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			break;
			return 1;
		  }
		case FDTR_LABEL_REC:			// _xZkqqHx_iDiJiDhIiDiLiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDiJiDhIiDiLiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
// 06.04.07 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			const FCHLabelBeginRec* pLabelRec = pRec->GetHLabelBeginRec(lObjectId);
			const FCHiLabelRec* pLabelRec = pRec->GetHiLabelRec(lObjectId);
			// _xZkqqHx_jCmHjAnFiDgFiDeMiDfIiDgHiDhBiDjDiDgHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetApp()->GetPopHint()->SetTargetInfo(pLabelRec->GetHintText(m_pHtreeManager));
// 06.03.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			break;
			return 1;
		  }
		case FDTR_HI_FORK_TAG_REC:	// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiBeC_xHqqkZx_
		  {
			// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
			FCHiForkTagRec* pHiForkTagRec = pRec->GetHiForkTagRec(lObjectId);
			// _xZkqqHx_jCmHjAnFiDgFiDeMiDfIiDgHiDhBiDjDiDgHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetApp()->GetPopHint()->SetTargetInfo(pHiForkTagRec->GetHintText(m_pHtreeManager));
// 06.03.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			break;
			return 1;
		  }
		case FDTR_TIME_LABEL_REC:	// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDiJiDhIiDiLiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
			const FCTimeLabelRec* pTimeLabelRec = pRec->GetTimeLabelRec(lObjectId);
			// _xZkqqHx_jCmHjAnFiDgFiDeMiDfIiDgHiDhBiDjDiDgHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetApp()->GetPopHint()->SetTargetInfo(pTimeLabelRec->GetHintText(m_pHtreeManager));
// 06.03.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			break;
			return 1;
		  }
		case FDTR_TIME_REC:			// _xZkqqHx_iOjOiKnEiBeC_xHqqkZx_FCHLabelHtreeRec _xZkqqHx_iCmFiCmNiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiDiMiDfCiBfLiDgIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			FCHTreeRec* pRec = m_pHtreeManager->DocumentIdToHTreeRec(GetSelectedDocumentId());
			const HTRTimeRec* pTimeRec = pRec->GetTimeRec(lObjectId);
			// _xZkqqHx_jCmHjAnFiDgFiDeMiDfIiDgHiDhBiDjDiDgHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetApp()->GetPopHint()->SetTargetInfo(pTimeRec->GetHintText(m_pHtreeManager));
// 06.03.09 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			break;
			return 1;
		  }
		}
		break;
	  }
	}
//----- 06.03.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCnGiCmNiPiIjHjNiCpAiCnMiCoNiClDiCmIiCkCiBeC_xHqqkZx_
//	return 1;
//----- 06.03.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCnGiCmNiPiIjHjNiCpAiCnMiCoNiClHiBeC_xHqqkZx_
	return 0;
//----- 06.03.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCWndHistoryTree::OnUserPursuerTextNeedInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCWndHistoryTree::OnTimer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDhNiBfLiDeDiDhIiDjDiDgHiCmFiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nIDEvent	:_xZkqqHx_iDfOiDeDiDhNiBfLiDeDiDhIiDjDiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCWndHistoryTree::OnTimer (UINT nIDEvent)
{
	switch (nIDEvent)
	{
	case FDTIMER_HTREE_TEMP_MARK_BLINK:
		BlinkTempMarkMark();
		break;
	case FDTIMER_HTREE_MARK_UP_BLINK:
		BlinkMarkUpHidocument();
		break;
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	CWnd::OnTimer(nIDEvent);
} // CFCWndHistoryTree::OnTimer.
