#ifndef __ZOrder_h
#define __ZOrder_h

class FCObjDynabase;

typedef vector <const ObjDynabaseVector*>	ConstObjDynabaseVPV;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCZOrderIterator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCZOrder_xZkqqHx_iCmMiPiHjFpLiMpMiCmM_xHqqkZx_Iterator_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCZOrderIterator
{
	void operator ++ (int)
		{
			iV1++;
			if (iV1 == (*iV2)->end())
			{
				for (iV2++; iV2 != pvvObj->end(); iV2++)
				{
					if (!(*iV2)->empty())
					{
						iV1 = (*iV2)->begin();
						break;
					}
				}
			}
		}
	FCObjDynabase* operator * ()
		{
			return *iV1;
		}
	BOOL	IsEnd () const
		{
			return (iV2 == pvvObj->end());
		}

	const ConstObjDynabaseVPV*			pvvObj;
	ConstObjDynabaseVPV::const_iterator	iV2;
	ObjDynabaseVector::const_iterator	iV1;
}; // struct FCZOrderIterator.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCZOrderReverseIterator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCZOrder_xZkqqHx_iCmMiLhEjFpLiMpMiCmM_xHqqkZx_Iterator_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCZOrderReverseIterator
{
	void operator ++ (int)
		{
			iV1++;
			if (iV1 == (*iV2)->rend())
			{
				for (iV2++; iV2 != pvvObj->rend(); iV2++)
				{
					if (!(*iV2)->empty())
					{
						iV1 = (*iV2)->rbegin();
						break;
					}
				}
			}
		}

	FCObjDynabase* operator * ()
		{
			return *iV1;
		}
	BOOL	IsEnd () const
		{
			return (iV2 == pvvObj->rend());
		}

	const ConstObjDynabaseVPV*					pvvObj;
	ConstObjDynabaseVPV::const_reverse_iterator	iV2;
	ObjDynabaseVector::const_reverse_iterator	iV1;
}; // struct FCZOrderReverseIterator.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkBjAjEiCmMjFjEjFgJjHpBiCpAjBkJiCmLiCmEiBeB_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCmGiClFiCmEiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCZOrder
{
public:
	void	Begin (FCZOrderIterator& i) const;
	void	Rbegin (FCZOrderReverseIterator& i) const;
	BOOL	IsEmpty() const;
	DWORD	Size () const;
	FCObjDynabase*	Front () const;
	void	GetAllOrder (ObjDynabaseVector& vObj) const;
	void	PushBack (const ObjDynabaseVector* vObj);
protected:
	ConstObjDynabaseVPV	m_vvZOrder;
}; // class FCZOrder.

#endif//__ZOrder_h
