#ifndef __AutoLock_h
#define __AutoLock_h

#include <io.h>			// For _topen.etc.
#include <fcntl.h>		// For _O_BINARY.etc.
#include <sys/stat.h>	// For _S_IREAD.etc.
#include <share.h>		// For _SH_DENYWR.
#include "resource.h"	// For IDS_XXX.
#include "UtilStr.h"	// For FFGuidToString.
#include "UtilMisc.h"	// For FFGetCurrentTime.
#include "UtilFile.h"	// For FDTBL_LOCK_OWN_DIR_NAME.etc.

#ifndef INVALID_FILE_ATTRIBUTES
// PlatformSDK_xZkqqHx_iCmM_xHqqkZx_WinBase.h_xZkqqHx_jCiGiCmFjCoIiLgAiBeC_xHqqkZx_
#define INVALID_FILE_ATTRIBUTES ((DWORD)-1)
#endif//INVALID_FILE_ATTRIBUTES

#define FD_LOCK_STD_WAIT_TIME	DWORD(5000)
#define FD_LOCK_WAIT_INFINITE	DWORD(-1)

struct FCTableName;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCAutoLock
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmJ_xHqqkZx_ own/req _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeC_xHqqkZx_
 *			own_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmJiCmNiBeBiDhEiDeAiDeDiDiLiCmMiPiKjHeMiCpAiOkGiClHiDhEiDiJiDePjHhAiDhEiDeAiDeDiDiLiCpA_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *			req_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmJiCmNiBeBiDhEiDeAiDeDiDiLiCmMiJpAjFpKiCpAjHhGiLiBiClHiCoJiDhEiDiJiDePjHhA_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCoHiCmMiDhEiDiJiDePjHhAiDhEiDeAiDeDiDiLiCpA_xHqqkZx_SHARE/EXCLUSIVE _xZkqqHx_iCmMiCkCiClIiCoKiCkJiCmF_xHqqkZx_
 *			_xZkqqHx_iDeJiBfLiDhGiDjDiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iClBiCmGiCmFiBeBiDfOiBfLiDfBiDgCiDgHiCmGiCmIiCoJiDhEiDeAiDeDiDiLiCmMiLkEjHeMiBeFjAoIjHeMiKnGiMfHiCpAjAkHiMoEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/

/*************************************************************************
 * <_xZkqqHx_iMfOjCoIiLgA_xHqqkZx_>	FTWatchUnlockRequestCallback
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpAjFpKjHhGiLiBiCmFiOmAiNhDiClDiCoKiCoJiDfCiBfLiDiLiDgPiDgCiDeOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	data			:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOjAnNjCoIiOjOiCmJjDkPiOjOiCmJjAnNjCoIiClHiCoJiDiGiBfLiDfFiDgGiBfLiDfO_xHqqkZx_
 *							 _xZkqqHx_iCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			aGroupName		:_xZkqqHx_iJpAjFpKjHhGiLiBiCmMiCkAiCmBiClNiDePiDiLiBfLiDhGiCmMiDiKiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szGroupNameCount:aGroupName_xZkqqHx_iCmMjEhKjHpBjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	StartWatchUnlockRequestThread_xZkqqHx_iKnGjAjEiCmFiJpAjFpKjHhGiLiBiCmMiKmEiOiLiCpAiKeKiOgOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKjHhGiLiBiCkKiCkAiCmBiClNiPoKiNiHiBeBiClBiCmMiKnGjAjEiCkKiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
typedef void (*FTWatchUnlockRequestCallback)(void* data, const FCTableName aGroupName[], size_t szGroupNameCount);

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	_FCAutoLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgH_xHqqkZx_ _HPCProject _xZkqqHx_iCmMiDiNiDgCiDeOiCpAiNhDiCkCiBeBiDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiL_xHqqkZx_
 *			_xZkqqHx_iCpAiBeBiDgGiDfIiDgHiDiJiDeOiDfOiCmFiOkJjDkOjDeJiCmJiJpAjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
class _FCAutoLock
{
public:
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDiNiDgCiDeOiKnGjAjEiCmMiDiNiDgCiDeOiOoNjHnO_xHqqkZx_ -----
	enum ReadOrWrite
	{
		LOCK_ROW_NONE	= 0xff,
		LOCK_READ		= 0x01,	// _xZkqqHx_jDmHiCnNiNjOiCnNiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
		LOCK_WRITE		= 0x02,	// _xZkqqHx_iPjBiCkLiPgPiClFiCmFiDiNiDgCiDeOiBeC_xHqqkZx_
	}; // enum ReadOrWrite.
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDiNiDgCiDeOiKnGjAjEiCmMiDiNiDgCiDeOiOoNjHnO_xHqqkZx_ -----
	enum ShareKind
	{
		LOCK_SHARE_NONE	= 0xff,
		LOCK_EXCLUSIVE	= 0x00,
		LOCK_SHARED		= 0x01,
	}; // enum ShareKind.

protected:
	//----- _xZkqqHx_iDiBiDjDiDgPiKnGjAjE_xHqqkZx_ -----
	_FCAutoLock ();
	virtual ~_FCAutoLock ();

public:
	static BOOL		IsLockFileExist (const FCTableName& tableName);

	virtual long	TryLockFile2 ();
	virtual void	UnlockFile ();

	virtual void	UnlockFileAll ();
	virtual long	GetLockCount () const;
	virtual BOOL	IsFileLocked () const;
	virtual WString	GetFilePath () const;
	virtual FCTableName	GetTableName () const;
	virtual ShareKind	GetShareKind () const;

	static WString	WhoLockingFile (const FCTableName& tableName);
	static int		IssueUnlockRequest (const FCTableName& groupName);
	static void		RemoveUnlockRequest (const FCTableName& groupName, int fhReq);
	static void		SetLoginUserName (const wchar_t* wcpUserName);
	static WString	GetLoginUserName ();
	static void		StartWatchUnlockRequestThread (const FCTableName& groupName, FTWatchUnlockRequestCallback callback, void* data);
	static void		StopWatchUnlockRequestThread (const FCTableName& groupName);
	static void		TerminateAllWatchUnlockRequestThread ();
	static long		GetWatchUnlockRequestThreadCount ();
	static void		GetWatchUnlockRequestThreadName (set<FCTableName>& stWatchGroupName);
	static void		DeleteLockFile (const FCTableName& tableName);
	static BOOL		IsThereValidReqFile (const FCTableName& groupName);

protected:
	virtual void	Initialize ();
	virtual void	Set (const FCTableName& tableName,
						 ReadOrWrite rwKind,
						 ShareKind shKind,
						 DWORD dwWaitMillisec);

	virtual long	TryLockFile (const FCTableName& tableName,
								 ReadOrWrite rwKind,
								 ShareKind shKind,
								 DWORD dwWaitMillisec = FD_LOCK_STD_WAIT_TIME);

	virtual void	CreateWhoLockFile (const wchar_t* wcpWhoFilePath);
	virtual void	DeleteWhoLockFile ();

	static void		DeleteAllWhoLockFile (const FCTableName& tableName);

	static WString	GetOwnDirPath (const FCTableName& tableName);
	static WString	GetOwnFilePath (const FCTableName& tableName);
	static WString	GetOwnFileName (const FCTableName& tableName);
	static WString	GetWhoFilePath (const FCTableName& tableName);
	static WString	GetReqDirPath (const FCTableName& tableName);
	static WString	GetReqFilePath (const FCTableName& tableName);

	static void	GetAllWhoLockFile (set<WString>& stWhoFile, const FCTableName& tableName);

	static DWORD WINAPI	myWatchUnlockRequestProc (LPVOID pvoid);

protected:
	/*************************************************************************
	 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCRequestThreadData
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDiNiDgCiDeOiJpAjFpKjHhGiLiBiKmEiOiLiDfIiDiMiDgCiDgIiCmJjDgOiClHiDgGiBfLiDfOiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	struct FCRequestThreadData
	{
		FCRequestThreadData ():	m_hThreadEvent(INVALID_HANDLE_VALUE),
								m_callbackProc(NULL),
								m_data(NULL) {}
		HANDLE							m_hThreadEvent;		// _xZkqqHx_iDfIiDiMiDgCiDgIiOhHiOkGjHhAiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
		FTWatchUnlockRequestCallback	m_callbackProc;		// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
		void*							m_data;				// _xZkqqHx_iDiGiBfLiDfFiDgGiBfLiDfOiBeC_xHqqkZx_
		set<FCTableName>				m_stWatchedGroup;	// _xZkqqHx_iKmEiOiLiClHiCoJiDePiDiLiBfLiDhGjGlMiCmMiPfHiNiHiBeC_xHqqkZx_
	}; // struct FCRequestThreadData.
	static FCCsAreaDef<FCRequestThreadData>*		s_rtd;
	typedef FCCsAreaRead<FCRequestThreadData>		rtdread;
	typedef FCCsAreaWrite<FCRequestThreadData>		rtdwrite;
	typedef FCCsAreaReadWrite<FCRequestThreadData>	rtdreadwrite;

	//----- _xZkqqHx_jCmKiPoNiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ -----
	struct M0
	{
		FCTableName	m_tableName;		// _xZkqqHx_iDiNiDgCiDeOjBmOiPnLiCmMiDgFiBfLiDhFiDiLjGlMiBeC_xHqqkZx_
		ReadOrWrite	m_rwKind;			// _xZkqqHx_jDmHiCnNiPjBiCkLiCmMiOhHjCoIiBeC_xHqqkZx_LOCK_READ/LOCK_WRITE_xZkqqHx_iCmMiCmHiClPiCoHiCkJiBeC_xHqqkZx_
		ShareKind	m_shKind;			// _xZkqqHx_iDhEiDeAiDeDiDiLiLkEjHeMiCmMiOoNjHnOiBeC_xHqqkZx_LOCK_SHARED/LOCK_EXCLUSIVE_xZkqqHx_iCmMiCmHiClPiCoHiCkJiBeC_xHqqkZx_
		DWORD		m_dwWaitMillisec;	// _xZkqqHx_iDiNiDgCiDeOiCpAjBnCiCmCiOjOiKnEiBeC_xHqqkZx_
		long		m_lLockCount;		// _xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
		int			m_fhOwn;			// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
		int			m_fhWho;			// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
	};
	FCCsAreaDef<M0>	m_0;
	typedef FCCsAreaRead<M0>		m0read;
	typedef FCCsAreaWrite<M0>		m0write;
	typedef FCCsAreaReadWrite<M0>	m0readwrite;

	//----- _xZkqqHx_iDiNiDgCiDeOiOkPjFmK_xHqqkZx_ID_xZkqqHx_iBeBiDiGiBfLiDfFjGlM_xHqqkZx_ -----
	struct S0 {
		S0 () : s_guidHpcId(FFCreateGuid()) {}
		GUID		s_guidHpcId;
		WString		s_wstrUserName;
	};
	static FCCsAreaDef<S0>	s_0;
	typedef FCCsAreaRead<S0>		s0read;
	typedef FCCsAreaWrite<S0>		s0write;
	typedef FCCsAreaReadWrite<S0>	s0readwrite;
}; // class _FCAutoLock.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	_FCAutoReadLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmM_xHqqkZx_ READ_xZkqqHx_iDiNiDgCiDeOiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
class _FCAutoReadLock : public _FCAutoLock<T>
{
public:
	_FCAutoReadLock ();
	virtual long	TryLockFile (const FCTableName& tableName,
								 ShareKind shKind,
								 DWORD dwWaitMillisec = FD_LOCK_STD_WAIT_TIME);
	virtual long	TryLockFile2 ();
	virtual GUID	GetTableGuid () const;
	virtual DWORD	GetDeleteIdentifier () const;
	virtual DWORD	GetAppendIdentifier () const;

	virtual void	SetTableGuid (GUID guidTable);
	virtual void	SetDeleteIdentifier (DWORD dwDeleteIdentifier);
	virtual void	SetAppendIdentifier (DWORD dwAppendIdentifier);

protected:
	virtual BOOL	ReadOwnFile (GUID& guidTable,
								 DWORD& dwDeleteIdentifier,
								 DWORD& dwAppendIdentifier);
protected:
	struct M1 {
		GUID	m_guidTable;			// _xZkqqHx_iNkBiJpBiDiNiDgCiDeOiClDiCoKiClNiOjOiCmJjDmHiCnNiNjOiCnMiCoKiClNiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
		DWORD	m_dwDeleteIdentifier;	// _xZkqqHx_iNkBiJpBiDiNiDgCiDeOiClDiCoKiClNiOjOiCmJjDmHiCnNiNjOiCnMiCoKiClNiNoNiPjM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		DWORD	m_dwAppendIdentifier;	// _xZkqqHx_iNkBiJpBiDiNiDgCiDeOiClDiCoKiClNiOjOiCmJjDmHiCnNiNjOiCnMiCoKiClNjCmHiJmB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	};
	FCCsAreaDef<M1>	m_1;
typedef FCCsAreaRead<M1>		m1read;
typedef FCCsAreaWrite<M1>		m1write;
typedef FCCsAreaReadWrite<M1>	m1readwrite;
}; // class _FCAutoReadLock.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	_FCAutoWriteLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmM_xHqqkZx_ WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
class _FCAutoWriteLock : public _FCAutoLock<T>
{
public:
	_FCAutoWriteLock ();
	virtual long	CreateLockFile (const FCTableName& tableName,
									GUID guidTable,
									DWORD dwDeleteIdentifier,
									DWORD dwAppendIdentifier);
	virtual long	TryLockFile (const FCTableName& tableName,
								 ShareKind shKind,
								 DWORD dwWaitMillisec = FD_LOCK_STD_WAIT_TIME);
	virtual void	WriteOwnFile (	GUID guidTable,
									DWORD dwDeleteIdentifier,
									DWORD dwAppendIdentifier);
	virtual void	WriteOwnFile (	DWORD dwDeleteIdentifier,
									DWORD dwAppendIdentifier);
}; // class _FCAutoWriteLock.


// _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiDiBiDjDiDgPiCmMiOmAjBmMjAoJiMlOiBeC_xHqqkZx_
template<class T> FCCsAreaDef<_FCAutoLock<T>::FCRequestThreadData>* _FCAutoLock<T>::s_rtd = NULL;
template<class T> FCCsAreaDef<_FCAutoLock<T>::S0> _FCAutoLock<T>::s_0;

// 06.01.23 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//template<class T> const GUID _FCAutoLock<T>::g_HpcGuid = FFCreateGuid();

////////////////////////////////////////////////////////////////////////////
// _FCAutoLock_xZkqqHx_iDeOiDiJiDfIiDiBiDjDiDgPiKnGjAjE_xHqqkZx_
////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	_FCAutoLock
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmJ_xHqqkZx_ own/req _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeC_xHqqkZx_
 *			own_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmJiCmNiBeBiDhEiDeAiDeDiDiLiCmMiPiKjHeMiCpAiOkGiClHiDhEiDiJiDePjHhAiDhEiDeAiDeDiDiLiCpA_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *			req_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmJiCmNiBeBiDhEiDeAiDeDiDiLiCmMiJpAjFpKiCpAjHhGiLiBiClHiCoJiDhEiDiJiDePjHhA_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCoHiCmMiDhEiDiJiDePjHhAiDhEiDeAiDeDiDiLiCpA_xHqqkZx_SHARE/EXCLUSIVE _xZkqqHx_iCmMiCkCiClIiCoKiCkJiCmF_xHqqkZx_
 *			_xZkqqHx_iDeJiBfLiDhGiDjDiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iClBiCmGiCmFiBeBiDfOiBfLiDfBiDgCiDgHiCmGiCmIiCoJiDhEiDeAiDeDiDiLiCmMiLkEjHeMiBeFjAoIjHeMiKnGiMfHiCpAjAkHiMoEiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	_FCAutoLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgH_xHqqkZx_ HPCProject _xZkqqHx_iCmMiDiNiDgCiDeOiCpAiNhDiCkCiBeBiDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiL_xHqqkZx_
 *			_xZkqqHx_iCpAiBeBiDgGiDfIiDgHiDiJiDeOiDfOiCmFiOkJjDkOjDeJiCmJiJpAjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::_FCAutoLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiClFiCmIiCkCiBeCiClBiCmMiPoKiNiHiCmNiBeB_xHqqkZx_TryLockFile_xZkqqHx_iKnGjAjEiCmFiIpIjAjEiCpA_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
_FCAutoLock<T>::_FCAutoLock ()
{
	// _xZkqqHx_jBfDjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	Initialize();
} // _FCAutoLock<T>::_FCAutoLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::~_FCAutoLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
_FCAutoLock<T>::~_FCAutoLock ()
{
	// _xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeC_xHqqkZx_
	UnlockFileAll();
	// _xZkqqHx_jBfDjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	Initialize();
} // _FCAutoLock<T>::~_FCAutoLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::IsLockFileExist
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiCmMiDiNiDgCiDeOiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFilePath	:_xZkqqHx_iDiNiDgCiDeOiClHiCoJiDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
BOOL _FCAutoLock<T>::IsLockFileExist (const FCTableName& tableName)
{
	// _xZkqqHx_jCmKiPoNiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
	return (FFIsThereFile(GetOwnFilePath(tableName)) == FD_FILE_32);
} // _FCAutoLock<T>::IsLockFileExist.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::TryLockFile2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiCmMiDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiCmFiIpIjAjEiCkKiOhHjCoIiClDiCoKiCmEiCkCiClNiPoKiNiHiCmJiCmMiCnNiOmAiNhDiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
long _FCAutoLock<T>::TryLockFile2 ()
{
	m0readwrite m0rw(m_0);

	if (IsFileLocked())
	//----- _xZkqqHx_iKpJiCmJiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiCpAiJmBiOfKiClFiCmEjAfOiCpAjFnEiClHiBeC_xHqqkZx_
		m0rw->m_lLockCount++;
		return 0;
	}

	//----- Own/Req_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiBeBiDhEiDeAiDeDiDiLjGlMiCmMiNoMjAkM_xHqqkZx_ -----
	WString strOwnFilePath = GetOwnFilePath(GetTableName());
	WString strWhoFilePath = GetWhoFilePath(GetTableName());

	// _xZkqqHx_iMgPiJnPiOjOiKnEiBeC_xHqqkZx_
	DWORD dwSpentMillisec = 0;
	int oflag;
	int shflag;
	if (m0rw->m_rwKind == LOCK_READ)
	//----- READ_xZkqqHx_iDiNiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnNiCmFiDeJiBfLiDhGiDjDiBeC_xHqqkZx_
		oflag = _O_BINARY | _O_RDONLY;
		if (m0rw->m_shKind == LOCK_SHARED)
		{
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMjDmHiCnNiPgPiClFiCmGiPjBiCkLiNjOiCnNiCpAiLjGiJmCiBeC_xHqqkZx_
			shflag = _SH_DENYNO;
		} else	// m0rw->m_shKind == LOCK_EXCLUSIVE.
		{
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMjDmHiCnNiPgPiClFiCpAiLnGiOhOiBeC_xHqqkZx_
			shflag = _SH_DENYRD;
		}
	} else	// m0rw->m_rwKind == LOCK_WRITE.
	//----- WRITE_xZkqqHx_iDiNiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnNiBeFiNoMjAkMiCmFiDeJiBfLiDhGiDjDiBeC_xHqqkZx_
		oflag = _O_BINARY | _O_WRONLY;
		if (m0rw->m_shKind == LOCK_SHARED)
		{
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMjDmHiCnNiPgPiClFiCmGiPjBiCkLiNjOiCnNiCpAiLjGiJmCiBeC_xHqqkZx_
			shflag = _SH_DENYNO;
		} else	// m0rw->m_shKind == LOCK_EXCLUSIVE.
		{
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiPjBiCkLiNjOiCnNiCpAiLnGiOhO_xHqqkZx_
			shflag = _SH_DENYWR;
		}
	}
	// _xZkqqHx_jFnEjCgMiBeC_xHqqkZx_
	long lErrCode = 0;
	for (;;)
	{
		// _xZkqqHx_iKpJjBlGiCmMiPiKjHeMiMkAiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
//		HPD_BEGIN_CHECK_TIME(L"_tsopen")
		m0rw->m_fhOwn = _tsopen(WStrToTStr(strOwnFilePath),
								oflag, shflag, 0);
//		HPD_END_CHECK_TIME

		// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCkKiDeJiBfLiDhGiDjDiCmFiCkLiClNiPoKiNiHiCmNiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
		if (m0rw->m_fhOwn != -1) break;

		//----- _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCkKiDeJiBfLiDhGiDjDiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----

		if (dwSpentMillisec == 0)
		//----- _xZkqqHx_iCfAiJpBjGnKiCmMiPiKjHeMiMkAiOoGjDlOiDgHiDiJiDeDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCpAiDeJiBfLiDhGiDjDiCmFiCkLiCmIiCkCiPoKiNiHiBeBjBlMiDeBiDhGiDiKiCkKiJpAjFpKiClFiCmIiCkC_xHqqkZx_
			// _xZkqqHx_iPoKiNiHiImIiKePiCmJiBeBiImIiJlKiCmMiCfBiCmCiCmMiDeHiDiJiBfLiCkKjHeMiCoIjDlOiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iHeA_xHqqkZx_READONLY_xZkqqHx_iCmMiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiHiBeC_xHqqkZx_
			// _xZkqqHx_iHeBiDgGiDeCiDiMiDeOiDgHiDiKiCmJiDhEiDeAiDeDiDiLiNoMjAkMiMkAiCkKjGlDiCkNiBeBiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
			// _xZkqqHx_iClBiCoKiCoHiCmMiPoKiNiHiBeBiDeHiDiJiBfLiCpAjFnEiClHjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiMkAiCmMiKgNjEeGiBeC_xHqqkZx_
			const DWORD dwAttrib = GetFileAttributes(WStrToTStr(strOwnFilePath));
			if ((oflag & _O_WRONLY) && (dwAttrib & FILE_ATTRIBUTE_READONLY))
			//----- WRITE_xZkqqHx_iDiNiDgCiDeOiCmFiBeBiPiKjHeMiMkAiDhEiDeAiDeDiDiLiCkK_xHqqkZx_READ ONLY_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFnEjCgM_xHqqkZx_ = _xZkqqHx_iBhFiDhEiDeAiDeDiDiLiCnGiCmMiDeBiDeOiDfKiDfIiCkKiLjBjEnLiClDiCoKiCnMiClFiClNiBeCiDhEiDeAiDeDiDiLiBeBiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDeBiDeOiDfKiDfIiMkAiCpAiKgNjEeGiClFiCmEiCkNiClOiClDiCkCiBeCiBhG_xHqqkZx_
				lErrCode = IDS_DYSR_ERR_FILE_ACCESS_DENIED;
				break;
			}
			if (dwAttrib == INVALID_FILE_ATTRIBUTES)
			//----- _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFnEjCgM_xHqqkZx_ = _xZkqqHx_iBhFiDhEiDeAiDeDiDiLiCnGiCmMiDeBiDeOiDfKiDfIiCkKiLjBjEnLiClDiCoKiCnMiClFiClNiBeCiDhEiDeAiDeDiDiLiBeBiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDeBiDeOiDfKiDfIiMkAiCpAiKgNjEeGiClFiCmEiCkNiClOiClDiCkCiBeCiBhG_xHqqkZx_
				lErrCode = IDS_DYSR_ERR_FILE_ACCESS_DENIED;
				break;
			}
		}

		// _xZkqqHx_iOhHjCoIiCmMjBnCiClPiOjOiKnEiCpAiJnPiCkMiCmEiCkCiCoJiPoKiNiHiCmNiPiIjHjNiCpAjCiGiOhOiBeC_xHqqkZx_
		if (m0rw->m_dwWaitMillisec != FD_LOCK_WAIT_INFINITE && m0rw->m_dwWaitMillisec <= dwSpentMillisec)
		{
			// _xZkqqHx_jFnEjCgM_xHqqkZx_ = _xZkqqHx_iBhFiDhEiDeAiDeDiDiLiCmNiKpJiCmJjBlMiCmMiDiGiBfLiDfFiBfLiCmJiCoGiCmBiCmEiDiNiDgCiDeOiClDiCoKiCmEiCkCiCnMiClHiBhG_xHqqkZx_
			lErrCode = IDS_DYSR_ERR_FILE_LOCKED_BY_OTHERS;
			break;
		}

		// 0.05_xZkqqHx_jFgCjBnCiClPiBeC_xHqqkZx_
		dwSpentMillisec += 50;
		Sleep(50);
	}
	if (m0rw->m_fhOwn != -1)
	//----- _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCkKiKeKiCkJiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
		CreateWhoLockFile(strWhoFilePath.c_str());
		// _xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiCpAiJmBiOfKiBeC_xHqqkZx_
		m0rw->m_lLockCount++;
	}
	// _xZkqqHx_jFnEjCgMiBeC_xHqqkZx_
	return lErrCode;
} // _FCAutoLock<T>::TryLockFile2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::UnlockFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiCkKiDeKiDeFiDjDiDgHiClDiCoKiCmEiCkCiCoJiClNiCnPiBeBiDiNiDgCiDeOiJpBjAjEiCmJiJjOiClGiCmE_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiCpAiJpAjFpKiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeCiDiNiDgCiDeOiDeKiDeFiDjDiDfOiCkKiCePiCmJiCmIiCmBiClN_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmJiCmMiCnNiBeBjGhLjDjGiCmJiDhEiDeAiDeDiDiLiCmMiDiNiDgCiDeOiCkKiJpAjFpKiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::UnlockFile ()
{
	if (!IsFileLocked()) return;
	m0readwrite m0rw(m_0);
	// _xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiCpAiMlIiOfKiBeC_xHqqkZx_
	m0rw->m_lLockCount--;
	// _xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiCkKiCePiCmFjGlDiCkPiCoKiCmOiJlNiCoAiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (IsFileLocked()) return;

	//----- _xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiCkKiCePiCmMiPoKiNiH_xHqqkZx_ -----

	// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	DeleteWhoLockFile();
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
	_close(m0rw->m_fhOwn);
	m0rw->m_fhOwn = -1;
} // _FCAutoLock<T>::UnlockFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::UnlockFileAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKkOjBfDiCmJiDiNiDgCiDeOiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiCkKjHhNjAkHiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiCkKiKpEiCmCiCmFiCkAiCmBiCmEiCoAiBeBiDiNiDgCiDeOiDeKiDeFiDjDiDfOiCpAiCePiCnMiCmFjGnPiClFiCmE_xHqqkZx_
 *			_xZkqqHx_jGhLjDjGiCmJiDhEiDeAiDeDiDiLiCmMiDiNiDgCiDeOiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::UnlockFileAll ()
{
	while (IsFileLocked()) UnlockFile();
} // _FCAutoLock<T>::UnlockFileAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::GetLockCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
long _FCAutoLock<T>::GetLockCount () const
{
	return m0read(m_0)->m_lLockCount;
} // _FCAutoLock<T>::GetLockCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::IsFileLocked
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCkKiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
BOOL _FCAutoLock<T>::IsFileLocked () const
{
	return (m0read(m_0)->m_lLockCount != 0);
} // _FCAutoLock<T>::IsFileLocked.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::GetFilePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOjBmOiPnLiDhEiDeAiDeDiDiLiCmMiDhEiDiLiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.12.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
WString _FCAutoLock<T>::GetFilePath () const
{
	return FFGetFilePath(m0read(m_0)->m_tableName);
} // _FCAutoLock<T>::GetFilePath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::GetTableName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOjBmOiPnLiDhEiDeAiDeDiDiLiCmMiDgFiBfLiDhFiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
FCTableName _FCAutoLock<T>::GetTableName () const
{
	return m0read(m_0)->m_tableName;
} // _FCAutoLock<T>::GetTableName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::GetShareKind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiLkEjHeMiCmMiOoNjHnOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	LOCK_SHARED/LOCK_EXCLUSIVE_xZkqqHx_iCmMiCmHiClPiCoHiCkJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
_FCAutoLock<T>::ShareKind _FCAutoLock<T>::GetShareKind () const
{
	return m0read(m_0)->m_shKind;
} // _FCAutoLock<T>::GetShareKind.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::WhoLockingFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiClFiCmEiCkCiCoJiDiGiBfLiDfFiBfLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiBfLjGlMiCmMiDiKiDfIiDgHiBeCiDiGiBfLiDfFiBfLjGlMiCpA_xHqqkZx_ '/' _xZkqqHx_iCmFiCmCiCmIiCkCiClOjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
WString _FCAutoLock<T>::WhoLockingFile (const FCTableName& tableName)
{
	// _xZkqqHx_iClBiCmMiDgFiBfLiDhFiDiLiCmMiPiKjHeMiOnCiDhEiDeAiDeDiDiLiIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
	set<WString> stWhoFile;
	GetAllWhoLockFile(stWhoFile, tableName);
	set<WString>::iterator iWho;
	for (iWho = stWhoFile.begin(); iWho != stWhoFile.end();)
	{
		// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
		if (mywremove((*iWho).c_str()) == 0)
			iWho = stWhoFile.erase(iWho);
		else
			iWho++;
	}
	// _xZkqqHx_iNoNiPjMiCmFiCkLiCmIiCkJiCmBiClNiPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCmNiBeBiCnMiClOiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiBeC_xHqqkZx_

//----- 06.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiNiDgCiDeOiCpAiClFiCmEiCkCiCoJjBlMiCmMiDiGiBfLiDfFiBeC_xHqqkZx_
//	WString wstrWhoLockAll;
//	for (iWho = stWhoFile.begin(); iWho != stWhoFile.end(); iWho++)
//	{
//		// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//		int fh = _topen(WStrToTStr((*iWho).c_str()), _O_RDONLY | _O_BINARY);
//		if (fh != -1)
//		{
//			// _xZkqqHx_iDiNiDgCiDeOiCpAiClFiCmEiCkCiCoJjBlMiCmMiDiGiBfLiDfFiBfLiBeC_xHqqkZx_
//			WString wstrWhoLock;
//			long lSize = _filelength(fh);
//			// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiCpAjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
//			wstrWhoLock.resize(lSize / sizeof(wchar_t), L'\0');
//			lSize = _read(fh, wstrWhoLock.begin(), lSize);
//			wstrWhoLock.resize(lSize / sizeof(wchar_t));
//			_close(fh);
//			wstrWhoLockAll += wstrWhoLock + L'/';
//		}
//	}
//	wstrWhoLockAll.TrimRight(L'/');
//----- 06.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiClFiCmEiCkCiCoJiDiGiBfLiDfFiBfLiCmMjGlMjBePiCpAiOoGjDlOiBeC_xHqqkZx_
	// _xZkqqHx_jDkPiClGiDiGiBfLiDfFiBfLiCkK_xHqqkZx_Read/Write _xZkqqHx_iDiNiDgCiDeOiClFiCmEiCkCiCoJiPoKiNiHiCmIiCmHiBeB_xHqqkZx_
	// _xZkqqHx_jDkPiClGjGlMjBePiCkKjFkBjAjEiJpBjDgPjIfOiClDiCoKiCoJiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeB_xHqqkZx_stWhoName_xZkqqHx_iCmFiPfHjGpBiBeC_xHqqkZx_
	set<WString> stWhoName;
	for (iWho = stWhoFile.begin(); iWho != stWhoFile.end(); iWho++)
	{
		// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		int fh = _topen(WStrToTStr((*iWho).c_str()), _O_RDONLY | _O_BINARY);
		if (fh != -1)
		{
			// _xZkqqHx_iDiNiDgCiDeOiCpAiClFiCmEiCkCiCoJjBlMiCmMiDiGiBfLiDfFiBfLiBeC_xHqqkZx_
			WString wstrWhoLock;
			long lSize = _filelength(fh);
			// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiCpAjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
			wstrWhoLock.resize(lSize / sizeof(wchar_t), L'\0');
			lSize = _read(fh, wstrWhoLock.begin(), lSize);
			wstrWhoLock.resize(lSize / sizeof(wchar_t));
			_close(fh);
			stWhoName.insert(wstrWhoLock);
		}
	}
//----- 06.04.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iClOiCkCiClNiCkCiCmMiPoKiNiHiBeBjDkPiClGiDeBiDhGiDiKiCmM_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiCmMiPiKjHeMiOnCiCkK_xHqqkZx_ stWhoName _xZkqqHx_iCmJ_xHqqkZx_
//	// _xZkqqHx_iKnMiCnMiCoKiCoJiBeC_xHqqkZx_stWhoName _xZkqqHx_iCkKiCfBiCmCiImIiPoDjGlMjBePiCpAiKnMiCnOiPoKiNiHiCmJiCmNiBeB_xHqqkZx_
//	// _xZkqqHx_iOkJjAgHiCmMjGlMjBePiCmNiNoNiPjMiClFiCmEiCoAjBoFiPoEjFhGiBeC_xHqqkZx_
//	if (1 < stWhoName.size())
//		stWhoName.erase(GetLoginUserName());
//----- 06.04.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiNiDgCiDeOiCpAiClFiCmEiCkCiCoJjBlMiCmMiDiGiBfLiDfFiBeC_xHqqkZx_
	WString wstrWhoLockAll;
	for (iWho = stWhoName.begin(); iWho != stWhoName.end(); iWho++)
		wstrWhoLockAll += *iWho + L'/';
	wstrWhoLockAll.TrimRight(L'/');
//----- 06.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	return wstrWhoLockAll;
} // _FCAutoLock<T>::WhoLockingFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::IssueUnlockRequest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpAjFpKjHhGiLiBiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	groupName	:_xZkqqHx_iJpAjFpKjHhGiLiBiCpAjEkNiNhDiClHiCoJiDePiDiLiBfLiDhGjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeCiOlIjEhDiClFiClNiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
int _FCAutoLock<T>::IssueUnlockRequest (const FCTableName& groupName)
{
	// _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiDhAiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	WString strReqFilePath = GetReqFilePath(FCTableName(groupName).PushBack(0));

//----- 06.04.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iCoAiCmGiCoAiCmGiCmNjBgHiCnNiNjOiCpBiCmFiCkCiCmIiCkJiCmBiClNiCkKiBeBiDhGiDiNiDfHiDeGiDeOiDgHiClCiCmG_xHqqkZx_ZIP_xZkqqHx_iCmFiIlDiPgLiClFiJpAjDiAiClFiClNiCmGiClBiCoLiBeB_xHqqkZx_
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMjGlDiCkCiDgGiDeCiDiMiDeOiDgHiDiKiCmNjDfHiKeKiClDiCoKiClIiBeB_xHqqkZx_ .req _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCoAiOlIiCoNiCoKiCmEiClFiCnMiCmBiClNiBeC_xHqqkZx_
	// .req_xZkqqHx_iCkKjGlDiCkCiCmGiMoLjDkOiNoMiClHiCoJiClNiCnPiBeBiClBiClBiCmFiLkNjAkHjDeJiCmJiNoMjAkMiClHiCoJiBeC_xHqqkZx_
	WString wstrReqDirPath = FFGetFileDirectory(strReqFilePath, TRUE);
	//----- Req_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiNoMjAkM_xHqqkZx_ -----
	if (FFIsThereFile(wstrReqDirPath) == FD_FILE_NOT_EXIST)
		FFRecursiveCreateDirectory(&WString(), wstrReqDirPath);
//----- 06.04.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
	int fhReq = _tsopen(WStrToTStr(strReqFilePath),
						_O_BINARY|_O_CREAT|_O_TRUNC|_O_RDWR,
						_SH_DENYWR,				// _xZkqqHx_jBlMiCkJiCoHiCmMiPjBiCkLiNjOiCnNiCpAiLnGiOhOiBeC_xHqqkZx_
						_S_IREAD|_S_IWRITE);	// _xZkqqHx_jDmHiCnNiPgPiClFiBeFiPjBiCkLiNjOiCnNiCpAiLjGiJmCiClFiCmEiNoMjAkMiBeC_xHqqkZx_

	FFDebugTrace(L"IssueUnlockRequest 1 : %d : %s\n", fhReq, strReqFilePath.c_str());

	if (fhReq != -1)
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkKiDeJiBfLiDhGiDjDiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLiCmJiOkPjFmKiOhBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
		int iSize = _write(fhReq, &(s0read(s_0)->s_guidHpcId), sizeof(GUID));
		_chsize(fhReq, iSize);
		// _xZkqqHx_iDhEiDeAiDeDiDiLiCmJiDhEiDiJiDgCiDfGiDiFiClHiCoJiBeC_xHqqkZx_
		_commit(fhReq);
	}
	return fhReq;
} // _FCAutoLock<T>::IssueUnlockRequest.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::RemoveUnlockRequest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpAjFpKjHhGiLiBiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	groupName	:_xZkqqHx_iJpAjFpKjHhGiLiBiCpAjEkNiNhDjCiGiCmMiDePiDiLiBfLiDhGjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fhReq		:_xZkqqHx_iDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::RemoveUnlockRequest (const FCTableName& groupName, int fhReq)
{
	// _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCpAiJpAjFpKiBeC_xHqqkZx_
	_close(fhReq);
	// _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
	WString strReqFilePath = GetReqFilePath(FCTableName(groupName).PushBack(0));
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
	mywremove(strReqFilePath);
} // _FCAutoLock<T>::RemoveUnlockRequest.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::SetLoginUserName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDePiDeDiDjDiClFiCmEiCkCiCoJiDiGiBfLiDfFiCmMiDiGiBfLiDfFjGlMiCpAjAnNjCoIiClHiCoJiBeCiClBiCmMiDiGiBfLiDfFjGlMiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiCmJiPjBiCkLiNjOiCnMiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpUserName	:_xZkqqHx_iDiGiBfLiDfFjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFjGlMiCmNiBeBiDhEiDeAiDeDiDiLiCpAjCeOiCkKiDiNiDgCiDeOiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiClBiCmGiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iIpIiCkLiPgPiClHiClBiCmGiCkKiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.03.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::SetLoginUserName (const wchar_t* wcpUserName)
{
	s0readwrite(s_0)->s_wstrUserName = wcpUserName;
} // _FCAutoLock<T>::SetLoginUserName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::GetLoginUserName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDePiDeDiDjDiClFiCmEiCkCiCoJiDiGiBfLiDfFiCmMiDiGiBfLiDfFjGlMiCpAjFnEiClHiBeCiClBiCmMiDiGiBfLiDfFjGlMiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiCmJiPjBiCkLiNjOiCnMiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFjGlMiCmNiBeBiDhEiDeAiDeDiDiLiCpAjCeOiCkKiDiNiDgCiDeOiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiClBiCmGiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iIpIiCkLiPgPiClHiClBiCmGiCkKiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.08.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
WString _FCAutoLock<T>::GetLoginUserName ()
{
	return s0read(s_0)->s_wstrUserName;
} // _FCAutoLock<T>::GetLoginUserName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::StartWatchUnlockRequestThread
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiJlKiCmMiDhEiDeAiDeDiDiLiDiNiDgCiDeOiCmMiBeBiJpAjFpKjHhGiLiBiCpAiKmEiOiLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpDirPath	:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiOhHjCoIiBeCiNmFiMoDiCmJ_xHqqkZx_'\\'_xZkqqHx_iCmNjFhEiCkJiCmIiCkCiBeC_xHqqkZx_
 *			callback	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			data		:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfIiDiMiDgCiDgIiCpAiNoMjAkMiClFiBeBiClLiCmMiDfIiDiMiDgCiDgIiCmJiCoGiCmBiCmEiOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCmM_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKjHhGiLiBiCpAiKmEiOiLiClFjBlBiCkPiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJpAjFpKjHhGiLiBiCkKiCkAiCmBiClNiPoKiNiHiCmNiBeBiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::StartWatchUnlockRequestThread (const FCTableName& groupName,
													FTWatchUnlockRequestCallback callback,
													void* data)
{
	// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCmNjFeLiClIjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBiBiCgNiChEiCgLiCgLiCkKiDfIiDiMiDgCiDgIjCoCiOhOiCmMiNiHjAhNiCmGiClFiCmEiOgHiCoNiCoKiCoJiClNiCnPiBeC_xHqqkZx_
	if (callback == NULL)
		FFThrowMiscUnknown();
	if (s_rtd == NULL)
	//----- _xZkqqHx_iKmEiOiLiDfIiDiMiDgCiDgIiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		s_rtd = new FCCsAreaDef<FCRequestThreadData>();
		//----- _xZkqqHx_iJpAjFpKjHhGiLiBiKmEiOiLiKmEiOiLiDfIiDiMiDgCiDgIiCmMiNoMjAkM_xHqqkZx_ -----
		rtdreadwrite rtdrw(*s_rtd);
		rtdrw->m_hThreadEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
		rtdrw->m_callbackProc = callback;			// _xZkqqHx_iJpAjFpKjHhGiLiBiOjOiCmJiOmAiNhDiClHiCoJiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
		rtdrw->m_data = data;						// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCmMiIpIjAjEiBeCiDiGiBfLiDfFiDgGiBfLiDfOiBeC_xHqqkZx_
		// groupName _xZkqqHx_iDePiDiLiBfLiDhGiCpAiKmEiOiLjBmOiPnLiCmJjAnNjCoIiBeC_xHqqkZx_
		rtdrw->m_stWatchedGroup.insert(groupName);	// _xZkqqHx_iKmEiOiLiClHiCoJiDePiDiLiBfLiDhGjGlMiBeC_xHqqkZx_
		// _xZkqqHx_iKmEiOiLiDfIiDiMiDgCiDgIiCpAiKeKiOgOiBeC_xHqqkZx_
		DWORD dwThreadId;
		CreateThread(	NULL, 0,
						(PTHREAD_START_ROUTINE)myWatchUnlockRequestProc,
						(LPVOID)s_rtd, 0, &dwThreadId);
	} else
	//----- _xZkqqHx_iKmEiOiLiDfIiDiMiDgCiDgIiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfIiDiMiDgCiDgIiOhHiOkGjHhAiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
		HANDLE hThreadEvent = INVALID_HANDLE_VALUE;
		{
			rtdreadwrite rtdrw(*s_rtd);
			// _xZkqqHx_iKmEiOiLiClHiCoJiDePiDiLiBfLiDhGjGlMiBeC_xHqqkZx_
			if (rtdrw->m_stWatchedGroup.find(groupName) == rtdrw->m_stWatchedGroup.end())
			//----- groupName_xZkqqHx_iCkKjGkCiClOiKmEiOiLjBmOiPnLiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// groupName _xZkqqHx_iDePiDiLiBfLiDhGiCpAiKmEiOiLjBmOiPnLiCmJjAnNjCoIiBeC_xHqqkZx_
				rtdrw->m_stWatchedGroup.insert(groupName);
				// _xZkqqHx_iDfIiDiMiDgCiDgIiOhHiOkGjHhAiDeDiDhIiDjDiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
				hThreadEvent = rtdrw->m_hThreadEvent;
			}
		}
		// _xZkqqHx_iDfIiDiMiDgCiDgIiOhHiOkGjHhAiDeDiDhIiDjDiDgHiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiDfIiDiMiDgCiDgIiCmJiDeDiDhIiDjDiDgHjBjHjFhEiBeC_xHqqkZx_
		// _xZkqqHx_iDfIiDiMiDgCiDgIiCmFjAfGiClFiCkCiDePiDiLiBfLiDhGiCmMiKmEiOiLiCkKiKeKiOgOiClDiCoKiCoJiBeC_xHqqkZx_
		if (hThreadEvent != INVALID_HANDLE_VALUE)
			SetEvent(hThreadEvent);
	}
} // _FCAutoLock<T>::StartWatchUnlockRequestThread.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::StopWatchUnlockRequestThread
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmMiJpAjFpKjHhGiLiBiKmEiOiLiCpAjCoCiOhOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	groupName	:_xZkqqHx_iDePiDiLiBfLiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::StopWatchUnlockRequestThread (const FCTableName& groupName)
{
	// _xZkqqHx_iDfIiDiMiDgCiDgIiOhHiOkGjHhAiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	HANDLE hThreadEvent = INVALID_HANDLE_VALUE;
	{
		if (s_rtd != NULL)
		//----- _xZkqqHx_iKmEiOiLiDfIiDiMiDgCiDgIiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			rtdreadwrite rtdrw(*s_rtd);
			// _xZkqqHx_iKmEiOiLiClHiCoJiDePiDiLiBfLiDhGjGlMiBeC_xHqqkZx_
			if (rtdrw->m_stWatchedGroup.find(groupName) != rtdrw->m_stWatchedGroup.end())
			//----- groupName_xZkqqHx_iCkKiKmEiOiLjBmOiPnLiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// groupName _xZkqqHx_iDePiDiLiBfLiDhGiCpAiKmEiOiLjBmOiPnLiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
				rtdrw->m_stWatchedGroup.erase(groupName);
				// _xZkqqHx_iDfIiDiMiDgCiDgIiOhHiOkGjHhAiDeDiDhIiDjDiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
				hThreadEvent = rtdrw->m_hThreadEvent;
			}
		}
	}
	// _xZkqqHx_iDfIiDiMiDgCiDgIiOhHiOkGjHhAiDeDiDhIiDjDiDgHiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiDfIiDiMiDgCiDgIiCmJiDeDiDhIiDjDiDgHjBjHjFhEiBeC_xHqqkZx_
	// _xZkqqHx_iDfIiDiMiDgCiDgIiCmFiOhHjCoIiDePiDiLiBfLiDhGiCmMiKmEiOiLiCkKjCoCiOhOiClDiCoKiCoJiBeC_xHqqkZx_
	if (hThreadEvent != INVALID_HANDLE_VALUE)
		SetEvent(hThreadEvent);
} // _FCAutoLock<T>::StopWatchUnlockRequestThread.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::TerminateAllWatchUnlockRequestThread
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpAjFpKjHhGiLiBiKmEiOiLiDfIiDiMiDgCiDgIiCpAjCoCiOhOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::TerminateAllWatchUnlockRequestThread ()
{
	if (s_rtd != NULL)
	//----- _xZkqqHx_iKmEiOiLiDfIiDiMiDgCiDgIiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfIiDiMiDgCiDgIiOhHiOkGjHhAiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
		HANDLE hThreadEvent = INVALID_HANDLE_VALUE;
		{
			rtdreadwrite rtdrw(*s_rtd);
			// _xZkqqHx_iJpAjFpKjHhGiLiBiOjOiCmJiOmAiNhDiClHiCoJiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiClHiCoJiClBiCmGiCmFiDfIiDiMiDgCiDgIiCkKjCoCiOhOiClHiCoJiBeC_xHqqkZx_
			rtdrw->m_callbackProc = NULL;
			// _xZkqqHx_iDfIiDiMiDgCiDgIiOhHiOkGjHhAiDeDiDhIiDjDiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
			hThreadEvent = rtdrw->m_hThreadEvent;
		}
		// _xZkqqHx_iDfIiDiMiDgCiDgIiCmJiDeDiDhIiDjDiDgHjBjHjFhEiBeC_xHqqkZx_
		// _xZkqqHx_iDfIiDiMiDgCiDgIiCkKjCoCiOhOiClDiCoKiCoJiBeC_xHqqkZx_
		if (hThreadEvent != INVALID_HANDLE_VALUE)
			SetEvent(hThreadEvent);
	}
} // _FCAutoLock<T>::TerminateAllWatchUnlockRequestThread.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::GetWatchUnlockRequestThreadName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiBeBiJpAjFpKjHhGiLiBiCkKiKmEiOiLiClDiCoKiCmEiCkCiCoJiDePiDiLiBfLiDhGiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stWatchGroupName	:_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDgFiBfLiDhFiDiLjGlMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::GetWatchUnlockRequestThreadName (set<FCTableName>& stWatchGroupName)
{
	// _xZkqqHx_iIpIjAjEiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	stWatchGroupName.clear();
	if (s_rtd != NULL)
	//----- _xZkqqHx_iKmEiOiLiDfIiDiMiDgCiDgIiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		rtdread rtdr(*s_rtd);
		stWatchGroupName = rtdr->m_stWatchedGroup;
	}
} // _FCAutoLock<T>::GetWatchUnlockRequestThreadName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::DeleteLockFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgFiBfLiDhFiDiLiCmJiKnGiClHiCoJiDiNiDgCiDeOiDhEiDeAiDeDiDiLiCpAjBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::DeleteLockFile (const FCTableName& tableName)
{
	// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
	mywremove(GetOwnFilePath(tableName));
	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmJiKnGiCoNiCoJjBfDiCmEiCmMiPiKjHeMiOnCiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
	DeleteAllWhoLockFile(tableName);
} // _FCAutoLock<T>::DeleteLockFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::IsThereValidReqFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDePiDiLiBfLiDhGiCmJiKnGiClFiCmEjBlMiDeBiDhGiDiKiCkJiCoHiJpAjFpKjHhGiLiBiCkKiPgPiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	groupName	:_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPgPiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJpAjFpKjHhGiLiBiCkKjHeMiMpIiCkJiCmHiCkEiCkJiCoGiCkNjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
BOOL _FCAutoLock<T>::IsThereValidReqFile (const FCTableName& groupName)
{
	FFDebugTrace(L"IsThereValidReqFile 1: %s\n", groupName.GetTitle().c_str());

	BOOL bIsValidReqFile = FALSE;
	// _xZkqqHx_iKmEiOiLjBmOiPnLiCmMiDhEiDeAiDeDiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	const WString wstrReqFilePath = GetReqFilePath(FCTableName(groupName).PushBack(0));
	if (GetFileAttributes(WStrToTStr(wstrReqFilePath)) != INVALID_FILE_ATTRIBUTES)
	//----- _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		FFDebugTrace(L"IsThereValidReqFile 2\n");
		// _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeCiJpAjFpKjHhGiLiBjCiGiCmNiDhEiDeAiDeDiDiLiCkKiDeJiBfLiDhGiDjDiClFiCmBiCmPiCmIiClF_xHqqkZx_
		// _xZkqqHx_iCmMiClNiCnPiBeBiNoNiPjMiCmFiCkLiCmIiCkCiCmNiClIiBeC_xHqqkZx_
		mywremove(wstrReqFilePath);
		// _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCpAjDmHiCnNiPgPiClFiCmFiKeKiCkNiBeC_xHqqkZx_
		int fhReq = _tsopen(WStrToTStr(wstrReqFilePath),
							_O_BINARY|_O_RDONLY,
							_SH_DENYNO,
							0);
		if (fhReq != -1)
		//----- _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCkKiKeKiCkPiClNiPoKiNiH_xHqqkZx_ -----
		{
			FFDebugTrace(L"IsThereValidReqFile 3\n");

			// _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCmM_xHqqkZx_GUID_xZkqqHx_iCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
			GUID guid;
			const int iSize = _read(fhReq, &guid, sizeof(guid));
			_close(fhReq);
			if (iSize == sizeof(guid))
			//----- GUID_xZkqqHx_iCpAjDmHiCnNiPgPiClJiClNiPoKiNiH_xHqqkZx_ -----
			{
				if (guid != s0read(s_0)->s_guidHpcId)
				//----- _xZkqqHx_jBlMiDeBiDhGiDiKiCkKjEkNiNhDiClFiClNiJpAjFpKjHhGiLiBiCmMiPoKiNiH_xHqqkZx_ -----
				{
					FFDebugTrace(L"IsThereValidReqFile 4\n");
					// _xZkqqHx_jHeMiMpIiCmIiJpAjFpKjHhGiLiBiBeC_xHqqkZx_
					bIsValidReqFile = TRUE;
				}
			}
		}
	}
	return bIsValidReqFile;
} // _FCAutoLock<T>::IsThereValidReqFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmJjFeLiClIiIoKjDhIiClOiCkPiClBiCmMiKnGjAjEiCpAiOmAiNhDiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOjCiGiCmFiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::Initialize ()
{
	m0readwrite m0rw(m_0);
	// _xZkqqHx_iDiNiDgCiDeOiClHiCoJiDhEiDeAiDeDiDiLiDhAiDfIjGlMiBeC_xHqqkZx_
	m0rw->m_tableName.Clear();
	// _xZkqqHx_jDmHiCnNiPjBiCkLiCmMiOhHjCoIiBeC_xHqqkZx_LOCK_READ/LOCK_WRITE_xZkqqHx_iCmMiCmHiClPiCoHiCkJiBeC_xHqqkZx_
	m0rw->m_rwKind = LOCK_ROW_NONE;
	// _xZkqqHx_iDhEiDeAiDeDiDiLiLkEjHeMiCmMiOoNjHnOiBeC_xHqqkZx_
	// LOCK_SHARED/LOCK_EXCLUSIVE_xZkqqHx_iCmMiCmHiClPiCoHiCkJiBeC_xHqqkZx_
	m0rw->m_shKind = ShareKind(-2);
	// _xZkqqHx_iDiNiDgCiDeOiCpAjBnCiCmCiOjOiKnEiBeC_xHqqkZx_
	m0rw->m_dwWaitMillisec = 0;
	// _xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
	m0rw->m_lLockCount = 0;
	// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
	m0rw->m_fhOwn = -1;
	// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
	m0rw->m_fhWho = -1;
} // _FCAutoLock<T>::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::Set
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiPoOjFpBiCpAjDoAjFjEiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName		:_xZkqqHx_jBmOiPnLiCmMiDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rwKind			:_xZkqqHx_jDmHiCnNiPjBiCkLiCmMiOhHjCoIiBeC_xHqqkZx_LOCK_READ/LOCK_WRITE_xZkqqHx_iCmM_xHqqkZx_
 *							 _xZkqqHx_iCmHiClPiCoHiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			shKind			:_xZkqqHx_iDhEiDeAiDeDiDiLiLkEjHeMiCmMiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 LOCK_SHARED/LOCK_EXCLUSIVE_xZkqqHx_iCmMiCmHiClPiCoHiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwWaitMillisec	:_xZkqqHx_iDiNiDgCiDeOiCpAjBnCiCmCiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOjDjJiCkJiCoHiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::Set (	const FCTableName& tableName,
							ReadOrWrite rwKind,
							ShareKind shKind,
							DWORD dwWaitMillisec)
{
	assert(!IsFileLocked());
	// READ/WRITE_xZkqqHx_jHlMjFpLiCmMiOhHjCoIiCmNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	assert(rwKind != (LOCK_READ|LOCK_WRITE));

	m0readwrite m0rw(m_0);
	m0rw->m_tableName = tableName;
					// _xZkqqHx_iDgFiBfLiDhFiDiLjGlMiBeC_xHqqkZx_
	m0rw->m_rwKind = rwKind;
					// _xZkqqHx_jDmHiCnNiPjBiCkLiCmMiOhHjCoIiBeC_xHqqkZx_LOCK_READ/LOCK_WRITE_xZkqqHx_iCmMiCmHiClPiCoHiCkJiBeC_xHqqkZx_
	m0rw->m_shKind = shKind;
					// _xZkqqHx_iDhEiDeAiDeDiDiLiLkEjHeMiCmMiOoNjHnOiBeC_xHqqkZx_
					// LOCK_SHARED/LOCK_EXCLUSIVE_xZkqqHx_iCmMiCmHiClPiCoHiCkJiBeC_xHqqkZx_
	m0rw->m_dwWaitMillisec = dwWaitMillisec;
					// _xZkqqHx_iDiNiDgCiDeOiCpAjBnCiCmCiOjOiKnEiBeC_xHqqkZx_
} // _FCAutoLock<T>::Set.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::TryLockFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName		:_xZkqqHx_jBmOiPnLiCmMiDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rwKind			:_xZkqqHx_jDmHiCnNiPjBiCkLiCmMiOhHjCoIiBeC_xHqqkZx_LOCK_READ/LOCK_WRITE_xZkqqHx_iCmM_xHqqkZx_
 *							 _xZkqqHx_iCmHiClPiCoHiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			shKind			:_xZkqqHx_iDhEiDeAiDeDiDiLiLkEjHeMiCmMiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 LOCK_SHARED/LOCK_EXCLUSIVE_xZkqqHx_iCmMiCmHiClPiCoHiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwWaitMillisec	:_xZkqqHx_iDiNiDgCiDeOiCpAjBnCiCmCiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOjPiCmJ_xHqqkZx_TryLockFile_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiClHiCoJiCmGiCkLiCmNiBeBiIpIjAjEiCpAiOhHjCoIiClFiCmIiCkNiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiClHiCoJiPoKiNiHiCmNiBeBiCnMiCmBiClNiCkNjDkPiClGiIpIjAjEiCpAiOhHjCoIiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
long _FCAutoLock<T>::TryLockFile (	const FCTableName& tableName,
									ReadOrWrite rwKind,
									ShareKind shKind,
									DWORD dwWaitMillisec)
{
	if (IsFileLocked())
	//----- _xZkqqHx_iKpJiCmJiBeBiDiNiDgCiDeOiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		m0readwrite m0rw(m_0);
		if ((m0rw->m_tableName != tableName) ||
			(m0rw->m_rwKind != rwKind) ||
			(m0rw->m_shKind != shKind))
			return IDS_DYSR_ERR_FILE_LOCKED_OTHERKIND;
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCmNiKpJiCmJjBlMiCmMiDiNiDgCiDeOiOoNjHnOiCmFiDiNiDgCiDeOiClDiCoKiCmEiCkCiCnMiClHiBeC_xHqqkZx_
		m0rw->m_dwWaitMillisec = dwWaitMillisec;
	} else
	//----- _xZkqqHx_iDiNiDgCiDeOiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		Set(tableName, rwKind, shKind, dwWaitMillisec);
	}
	return TryLockFile2();
} // _FCAutoLock<T>::TryLockFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::CreateWhoLockFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClFiClNiPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCmMiPiKjHeMiOnCiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpOwnDirPath	:_xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiL_xHqqkZx_"_xZkqqHx_iDiGiDgKiBfLiDeOiCmI_xHqqkZx_ID.who"_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiCpAiNoMjAkMiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiDhEiDeAiDeDiDiLjCiGiCmJiPiKjHeMiOnCjGlMiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiClDiCoKiClNiDhEiDeAiDeDiDiLiCmNiBeBiPiKjHeMiClDiCoKiCmEiCkCiCoJiKnEjCiGiCmNiPjBiCkLiNjOiCnNiLnGiOhOiCmF_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *			DeleteWhoLockFile _xZkqqHx_iCmFiBeBiDfDiDhOiCmGiCmIiCmBiCmEiOgDiCmBiClNiPiKjHeMiOnCiPoOjFpBiCpAjBhMiPjM_xHqqkZx_
 *			_xZkqqHx_iClDiClJiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.08.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::CreateWhoLockFile (const wchar_t* wcpWhoFilePath)
{
	m0readwrite m0rw(m_0);
	assert(m0rw->m_fhWho == -1);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeCjBlGiNnNiClFiCmIiCkPiCoKiCmOiNoMjAkMiClFiBeBjBlGiNnNiClHiCoJiPoKiNiHiCmNiDfEiDeDiDfJiCpAiCePiCmJiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iLkEjHeMiCmFiNoMjAkMiCoAiJmCjEfMiBeCiDhEiDeAiDeDiDiLiCkKjFmCiClGiCoHiCoKiCoJiCnMiCmFiCmNiNoNiPjMiCmNjFhDiJmCiBeC_xHqqkZx_
	m0rw->m_fhWho = _tcreat(WStrToTStr(wcpWhoFilePath), _S_IREAD | _S_IWRITE);
	if (m0rw->m_fhWho != -1)
	//----- _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCkKiNoMjAkMiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLiCmJiDiGiBfLiDfFjGlMiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
		_write(m0rw->m_fhWho, GetLoginUserName().c_str(), sizeof(wchar_t) * GetLoginUserName().size());
		// _xZkqqHx_iDhEiDeAiDeDiDiLiCmJiDhEiDiJiDgCiDfGiDiFiClHiCoJiBeC_xHqqkZx_
		_commit(m0rw->m_fhWho);
	}
} // _FCAutoLock<T>::CreateWhoLockFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::DeleteWhoLockFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiCpAiJpAjFpKiClFiClNiPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCmMiPiKjHeMiOnCiPoOjFpBiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	CreateWhoLockFile_xZkqqHx_iCmFiNoMjAkMiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClLiCoKiImIiKePiCmJiCoAiBeBiDeBiDhGiDiKiCmMjFhDjGhLiInDiCmIiPeJjHlJiCmJjElKiCmBiCmEiDfDiDhOiCmGiClFiCmEiOgDiCmBiClN_xHqqkZx_
 *			_xZkqqHx_iPiKjHeMiOnCiPoOjFpBiCpAjBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.08.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::DeleteWhoLockFile ()
{
	m0readwrite m0rw(m_0);
	if (m0rw->m_fhWho != -1)
	//----- _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
		_close(m0rw->m_fhWho);
		m0rw->m_fhWho = -1;
		// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
		mywremove(GetWhoFilePath(GetTableName()));
	}
} // _FCAutoLock<T>::DeleteWhoLockFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::DeleteAllWhoLockFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiDiNiDgCiDeOiClFiCoGiCkEiCmGiClFiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCmJiKnGiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCpAjBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::DeleteAllWhoLockFile (const FCTableName& tableName)
{
	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiPiKjHeMiOnCiDhEiDeAiDeDiDiLiIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
	set<WString> stWhoFile;
	GetAllWhoLockFile(stWhoFile, tableName);
	// _xZkqqHx_iPiKjHeMiOnCiDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
	set<WString>::iterator iWho;
	for (iWho = stWhoFile.begin(); iWho != stWhoFile.end(); iWho++)
		mywremove((*iWho).c_str());
} // _FCAutoLock<T>::DeleteAllWhoLockFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::GetOwnDirPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiMkAiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiMkAiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
WString _FCAutoLock<T>::GetOwnDirPath (const FCTableName& tableName)
{
	return WString(tableName.m_hstrTopDirPath) + L'\\' + FDTBL_LOCK_OWN_DIR_NAME;
} // _FCAutoLock<T>::GetOwnDirPath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::GetOwnFilePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
WString _FCAutoLock<T>::GetOwnFilePath (const FCTableName& tableName)
{
	return GetOwnDirPath(tableName) + L'\\' + GetOwnFileName(tableName) + FDTBL_LOCK_OWN_FILE_EXT;
} // _FCAutoLock<T>::GetOwnFilePath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::GetOwnFileName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
WString _FCAutoLock<T>::GetOwnFileName (const FCTableName& tableName)
{
	WString wstrOwnFileName = L"$";
	wchar_t wszBuff[100];
	for (size_t szC = 0; szC != tableName.m_vTableIds.GetSize(); szC++)
	{
		wstrOwnFileName += _ultow(tableName.m_vTableIds[szC], wszBuff, 10);
		wstrOwnFileName += L'$';
	}
	return wstrOwnFileName;
} // _FCAutoLock<T>::GetOwnFileName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::GetWhoFilePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiOnCiDhEiDeAiDeDiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiOnCiDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
WString _FCAutoLock<T>::GetWhoFilePath (const FCTableName& tableName)
{
	return GetOwnDirPath(tableName) + L'\\' +
			FFGuidToString(s0read(s_0)->s_guidHpcId) + L'.' + GetOwnFileName(tableName);
} // _FCAutoLock<T>::GetWhoFilePath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::GetReqDirPath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpAjFpKjHhGiLiBiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJpAjFpKjHhGiLiBiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
WString _FCAutoLock<T>::GetReqDirPath (const FCTableName& tableName)
{
	return WString(tableName.m_hstrTopDirPath) + L'\\' +
			FDTBL_LOCK_REQ_DIR_NAME + L'\\' + GetOwnFileName(FCTableName(tableName).PopBack());
} // _FCAutoLock<T>::GetReqDirPath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::GetReqFilePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
WString _FCAutoLock<T>::GetReqFilePath (const FCTableName& tableName)
{
	return GetReqDirPath(tableName) + L'\\' + FDTBL_LOCK_REQ_FILE_NAME;
} // _FCAutoLock<T>::GetReqFilePath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::GetAllWhoLockFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgFiBfLiDhFiDiLiCpAiPiKjHeMiClHiCoJjBfDiCmEiCmMiPiKjHeMiOnCiDhEiDeAiDeDiDiLiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stWhoFile	:_xZkqqHx_iPiKjHeMiOnCiDhEiDeAiDeDiDiLiDhAiDfIiIoKjHjHiBeC_xHqqkZx_
 *			tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOgHiCoNiCoKiCmIiCkNiCmIiCmBiClNiPiKjHeMiOnCiDhEiDeAiDeDiDiLiCoAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoLock<T>::GetAllWhoLockFile (set<WString>& stWhoFile, const FCTableName& tableName)
{
	// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiDgGiDeCiDiMiDeOiDgHiDiKiCmMiNoMjAkMiBeC_xHqqkZx_
	WString wstrOwnDirPath = GetOwnDirPath(tableName);
	WString wstrOwnFileName = GetOwnFileName(tableName);
	WIN32_FIND_DATA findData;
	HANDLE hDir = FindFirstFile(WStrToTStr(wstrOwnDirPath + L"\\*." + wstrOwnFileName), &findData);
	if (hDir != INVALID_HANDLE_VALUE)
	{
		do
		{
			// _xZkqqHx_iMjPiNpFiClDiCoKiClNiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
			const WString wstrFileName =
					wstrOwnDirPath + L'\\' + (const wchar_t*)TStrToWStr(findData.cFileName);
			stWhoFile.insert(wstrFileName);
		} while (FindNextFile(hDir, &findData));
		FindClose(hDir);
	}
} // _FCAutoLock<T>::GetAllWhoLockFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoLock<T>::myWatchUnlockRequestProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBlMiCmMiDeBiDhGiDiKiCmJiCoGiCmBiCmEiBeBiJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCkKiPjBiCkLiNjOiCnMiCoKiCoJiCmMiCpA_xHqqkZx_
 *			_xZkqqHx_iKmEiOiLiClHiCoJiDfIiDiMiDgCiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pvoid	:_xZkqqHx_iDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiJpAjFpKjHhGiLiBiBgJiDgGiDeCiDiMiDeOiDgHiDiKjFmPiNfIiBgKjBnCiClPiPpDjBnEiCmFjBnCiLeAiBeCjFmPiNfIiCkKjEkNjAlG_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiCmGiBeBiDiNiDgCiDeOiJpAiPjMiCmMiKnGjAjEiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FindFirstChangeNotification _xZkqqHx_iCpAiOgHiCmBiCmEiDgGiDeCiDiMiDeOiDgHiDiKiCpAiKmEiOiLiClFiCmEiCkCiClN_xHqqkZx_
 *			_xZkqqHx_iCmMiClOiCkKiBeB_xHqqkZx_FindFirstChangeNotification -> FindNextChangeNotification_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_ FindFirstChangeNotification -> FindCloseChangeNotification _xZkqqHx_iCmN_xHqqkZx_
 *			_xZkqqHx_jIeBjBlBiClFiCmEiOmAiNhDiClFiCmEiCkCiCoJiCmGiKmEiOiLjBmOiPnLiDgGiDeCiDiMiDeOiDgHiDiKjCiGiCmMiDhEiDeAiDeDiDiLiCpAiDiNiDgCiDeOiClFiCmE_xHqqkZx_
 *			_xZkqqHx_iClFiCnMiCkEiCoHiClFiCkNiBeBiJlNjDhIiCkJiMeKiCoIjFnEiClHiCkEiClPiCmJjDkOiNoMiCkKiCkIiCkJiClFiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iCkCiCoLiCkCiCoLiDgHiDiJiDeDiClFiCmEiCoAiJpMjBfAiClFiCmIiCkCiCmMiCmFiBeBiDhEiDeAiDeDiDiLiCmMjBlGiNnNiCpAiIoKjCoIiOjOiKnEiClCiCmGiCmJ_xHqqkZx_
 *			_xZkqqHx_iDgAiDeGiDgCiDeOiClHiCoJjFpLjGeAiCmJjFmPiNfIiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
DWORD WINAPI _FCAutoLock<T>::myWatchUnlockRequestProc (LPVOID pvoid)
{
	// _xZkqqHx_iDfIiDiMiDgCiDgIjHhAiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
	FCCsAreaDef<FCRequestThreadData>* pData = (FCCsAreaDef<FCRequestThreadData>*)pvoid;
	for (;;)
	{
		HANDLE hEvent;					// _xZkqqHx_iDeDiDhIiDjDiDgHjCmKjCgNiBeC_xHqqkZx_
		set<FCTableName> stGroupName;	// _xZkqqHx_iKmEiOiLjBmOiPnLiDePiDiLiBfLiDhGiBeC_xHqqkZx_
		{
			// _xZkqqHx_iDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDjFnLiMoMjHmMiIoGiBeC_xHqqkZx_
			rtdread rtdr(*pData);
			// _xZkqqHx_iPiIjHjNiPeJjHlJiOhHjHnPiCmMiPoKiNiHiCmNiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
			if (rtdr->m_callbackProc == NULL) break;
			// _xZkqqHx_iKmEiOiLiClHiCoJiDeDiDhIiDjDiDgHiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
			hEvent = rtdr->m_hThreadEvent;
			// _xZkqqHx_iKmEiOiLjBmOiPnLiDePiDiLiBfLiDhGiBeC_xHqqkZx_
			stGroupName = rtdr->m_stWatchedGroup;
		}

		for (;;)
		{
			// _xZkqqHx_iDeDiDhIiDjDiDgHjCmKjCgNiCkJiBeI_xHqqkZx_
			BOOL bSignaled = FALSE;
			// _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiCkJiBeI_xHqqkZx_
			BOOL bIsThereReqFile = FALSE;

			mdef_const_iterator(set<FCTableName>, iGroupName);
			m1_for (iGroupName, stGroupName)
			{
				// _xZkqqHx_iDeDiDhIiDjDiDgHjCmKjCgNiCkJiBeI_xHqqkZx_
				bSignaled = (WaitForSingleObject(hEvent, 0) == WAIT_OBJECT_0);
				// _xZkqqHx_iDeDiDhIiDjDiDgHjCmKjCgNiCmIiCoHiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
				if (bSignaled) break;

				// _xZkqqHx_iKmEiOiLjBmOiPnLiCmMiDhEiDeAiDeDiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
				const WString wstrReqFilePath = GetReqFilePath(FCTableName(*iGroupName).PushBack(0));
				if (GetFileAttributes(WStrToTStr(wstrReqFilePath)) != INVALID_FILE_ATTRIBUTES)
				//----- _xZkqqHx_iKmEiOiLjBmOiPnLiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiCkJiBeI_xHqqkZx_
					bIsThereReqFile = TRUE;
					break;
				}
			}
			// _xZkqqHx_iDeDiDhIiDjDiDgHjCmKjCgNiCmIiCoHiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
			if (bSignaled) break;

			FFDebugTrace(L"myWatchUnlockRequestProc 1\n");

			if (bIsThereReqFile)
			//----- _xZkqqHx_iJpAjFpKjHhGiLiBiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// 0.2_xZkqqHx_jFgCiCnJiCmHiLhIiMgFiBeCjBfDiCmEiCmMiJpAjFpKjHhGiLiBiCkKiClLiCoLiCkEiCmMiCpAjBnCiCmCiClNiCnPiBeC_xHqqkZx_
				bSignaled = (WaitForSingleObject(hEvent, 200) == WAIT_OBJECT_0);
				// _xZkqqHx_iDeDiDhIiDjDiDgHjCmKjCgNiCmIiCoHiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
				if (bSignaled) break;

				// _xZkqqHx_iJpAjFpKjHhGiLiBiCkKiPgPiCmEiCkCiCoJiDePiDiLiBfLiDhGiCmMiDgFiBfLiDhFiDiLjGlMiDiKiDfIiDgHiBeC_xHqqkZx_
				vector<FCTableName> vReqGroupName;
				// _xZkqqHx_iKmEiOiLjBmOiPnLiDePiDiLiBfLiDhGiCpAjBfDiCmEjClCiCnHiCoJiBeC_xHqqkZx_
				// _xZkqqHx_iPoDiCmF_xHqqkZx_0.2_xZkqqHx_jFgCiLhIiMgFiClFiCmEiCkCiCoJiKnEiCmJiBeBjBlMiCmMiJpAjFpKjHhGiLiBiCoAiPgPiCmEiCkCiCoJiJmCjEfMjAkLiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
				m1_for (iGroupName, stGroupName)
				{
					FFDebugTrace(L"myWatchUnlockRequestProc 2\n");
					// _xZkqqHx_iDeDiDhIiDjDiDgHjCmKjCgNiCkJiBeI_xHqqkZx_
					bSignaled = (WaitForSingleObject(hEvent, 0) == WAIT_OBJECT_0);
					// _xZkqqHx_iDeDiDhIiDjDiDgHjCmKjCgNiCmIiCoHiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
					if (bSignaled) break;

					if (IsThereValidReqFile(*iGroupName))
					//----- _xZkqqHx_jBlMiDeBiDhGiDiKiCkKjEkNiNhDiClFiClNiBeBjHeMiMpIiCmIiJpAjFpKjHhGiLiBiCmMiPoKiNiH_xHqqkZx_ -----
					{
						FFDebugTrace(L"myWatchUnlockRequestProc 3\n");
						// _xZkqqHx_iJpAjFpKjHhGiLiBiCkKiPgPiCmEiCkCiCoJiDePiDiLiBfLiDhGiCmMiDgFiBfLiDhFiDiLjGlMiDiKiDfIiDgHiBeC_xHqqkZx_
						vReqGroupName.push_back(*iGroupName);
					}
				}
				// _xZkqqHx_iDeDiDhIiDjDiDgHjCmKjCgNiCmIiCoHiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
				if (bSignaled) break;

				if (!vReqGroupName.empty())
				//----- _xZkqqHx_iJpAjFpKjHhGiLiBiCkKiIoKiCmCiCmFiCoAiPgPiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_jHmMiIoGiCpAiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiCmFjFnLiMoMiBeC_xHqqkZx_
					rtdread rtdr(*pData);
					// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiOmAiNhDiBeC_xHqqkZx_
					if (rtdr->m_callbackProc != NULL)
						(*rtdr->m_callbackProc)(rtdr->m_data, &vReqGroupName[0], vReqGroupName.size());
				}

			}
			// _xZkqqHx_jIeBjBlBiClFiCmEiKmEiOiLiClHiCoJiCmGiPiIjHjNiCmJjCmHiCoNiCoKiCmEiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkKjDkOiNoMiClFiCmIiCkNiCmIiCoJiClNiCnPiBeB_xHqqkZx_
			// _xZkqqHx_iClBiClBiCmFiPkNiClFiDfIiDiKiBfLiDhGiCpAjDpMiCoKiCmEiCoCiCoJiBeC_xHqqkZx_
			// _xZkqqHx_iDfIiDiKiBfLiDhGiClFiCmEiCkCiCoJiKnEiCoAiPeJjHlJiKiEiCoIiNjOiCnNiCoAiKmEiOiLiClHiCoJjFeLjHhGiCkKiCkAiCoJiCmMiCmF_xHqqkZx_ 
			// Sleep _xZkqqHx_iCmFiCmNiCmIiCkN_xHqqkZx_WaitForSingleObject _xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
			// _xZkqqHx_iCfBjFgCjBnCiCmCiBeC_xHqqkZx_
			bSignaled = (WaitForSingleObject(hEvent, 2000) == WAIT_OBJECT_0);
			// _xZkqqHx_iDeDiDhIiDjDiDgHjCmKjCgNiCmIiCoHiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
			if (bSignaled) break;
		}
	}
	{
		rtdreadwrite rtdrw(*pData);
		// _xZkqqHx_iDfIiDiMiDgCiDgIiPeJjHlJjCmKjCgNiDgOiDjDiDgIiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
		if (rtdrw->m_hThreadEvent != NULL)
			CloseHandle(rtdrw->m_hThreadEvent);
		rtdrw->m_hThreadEvent = NULL;
	}
	// _xZkqqHx_iDgGiBfLiDfOjHmMiIoGiCpAiNoNiPjMiBeC_xHqqkZx_
	delete pData;
	return S_OK;
} // _FCAutoLock<T>::myWatchUnlockRequestProc.

////////////////////////////////////////////////////////////////////////////
// _FCAutoReadLock_xZkqqHx_iDeOiDiJiDfIiDiBiDjDiDgPiKnGjAjE_xHqqkZx_
////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoReadLock<T>::_FCAutoReadLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiClFiCmIiCkCiBeCiClBiCmMiPoKiNiHiCmNiBeB_xHqqkZx_TryLockFile_xZkqqHx_iKnGjAjEiCmFiIpIjAjEiCpA_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
_FCAutoReadLock<T>::_FCAutoReadLock ()
{
	m1readwrite m1rw(m_1);
	m1rw->m_guidTable = GUID_NULL;
	m1rw->m_dwDeleteIdentifier = 0;
	m1rw->m_dwAppendIdentifier = 0;
} // _FCAutoReadLock<T>::_FCAutoReadLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoReadLock<T>::TryLockFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName		:_xZkqqHx_jBmOiPnLiCmMiDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			shKind			:_xZkqqHx_iDhEiDeAiDeDiDiLiLkEjHeMiCmMiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 LOCK_SHARED/LOCK_EXCLUSIVE_xZkqqHx_iCmMiCmHiClPiCoHiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwWaitMillisec	:_xZkqqHx_iDiNiDgCiDeOiCpAjBnCiCmCiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOjPiCmJ_xHqqkZx_TryLockFile_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiClHiCoJiCmGiCkLiCmNiBeBiIpIjAjEiCpAiOhHjCoIiClFiCmIiCkNiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiClHiCoJiPoKiNiHiCmNiBeBiCnMiCmBiClNiCkNjDkPiClGiIpIjAjEiCpAiOhHjCoIiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
long _FCAutoReadLock<T>::TryLockFile (	const FCTableName& tableName,
										ShareKind shKind,
										DWORD dwWaitMillisec)
{
	return _FCAutoLock<T>::TryLockFile(	tableName,
										LOCK_READ,
										shKind,
										dwWaitMillisec);
} // _FCAutoReadLock<T>::TryLockFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoReadLock<T>::TryLockFile2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiCmM_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiCmFiIpIjAjEiCkKiOhHjCoIiClDiCoKiCmEiCkCiClNiPoKiNiHiCmJiCmMiCnNiOmAiNhDiCmFiCkLiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
long _FCAutoReadLock<T>::TryLockFile2 ()
{
	// _xZkqqHx_iKpJiCmJ_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiNmPiCnNiCmMiPoKiNiHiCmNiBeB_xHqqkZx_Baseclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiClFiCmEiPeJjHlJiBeC_xHqqkZx_
	if (IsFileLocked())
		return _FCAutoLock<T>::TryLockFile2();

	//----- _xZkqqHx_iNmFiPiJiCmM_xHqqkZx_ READ_xZkqqHx_iDiNiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ -----
	m1readwrite m1rw(m_1);
	// _xZkqqHx_iNoNiPjMiBeFjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_
	m1rw->m_guidTable = GUID_NULL;
	m1rw->m_dwDeleteIdentifier = DWORD(0);
	m1rw->m_dwAppendIdentifier = DWORD(0);
	// _xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
	DWORD dwLock = _FCAutoLock<T>::TryLockFile2();
	if (dwLock == 0)
	//----- _xZkqqHx_iDiNiDgCiDeOiCkKjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNoNiPjMiBeFjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		GUID guidTable;
		DWORD dwDeleteIdentifier;
		DWORD dwAppendIdentifier;
		if (ReadOwnFile(guidTable, dwDeleteIdentifier, dwAppendIdentifier))
		//----- _xZkqqHx_iDiNiDgCiDeOiClDiCoKiClNiDhEiDeAiDeDiDiLiCmJiNoNiPjMiBeFjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCkKiLeMjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iNoNiPjMiBeFjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_
			m1rw->m_guidTable = guidTable;
			m1rw->m_dwDeleteIdentifier = dwDeleteIdentifier;
			m1rw->m_dwAppendIdentifier = dwAppendIdentifier;
		}
		return 0;
	} else
	//----- _xZkqqHx_iDiNiDgCiDeOiCkKiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		return dwLock;
	}
} // _FCAutoReadLock<T>::TryLockFile2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoReadLock<T>::GetTableGuid
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCkJiCoHjDmHiCnNiPgPiClFiClNiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
GUID _FCAutoReadLock<T>::GetTableGuid () const
{
	return m1read(m_1)->m_guidTable;
} // _FCAutoReadLock<T>::GetTableGuid.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoReadLock<T>::GetDeleteIdentifier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCkJiCoHjDmHiCnNiPgPiClFiClNiDgFiBfLiDhFiDiLiCmMiNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCoJjBmOiPnLiCmMiPiKjHeMiMkAiDhEiDeAiDeDiDiLiCmJiCmNiBeBiNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iCmG_xHqqkZx_
 *			_xZkqqHx_jCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCkKiLeMjIfOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iCmNiBeBiDgFiBfLiDhFiDiLjCiGiCmMiDiMiDfCiBfLiDgIiCkKiNoNiPjMiClDiCoKiClNiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiCkKiJpAiPjMiClDiCoKiCoJiOjOiCmJiNoNiPjMiJpBjAjEjFkKiJmBiOfKiClDiCoKiBeBiNmEiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.10.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
DWORD _FCAutoReadLock<T>::GetDeleteIdentifier () const
{
	return m1read(m_1)->m_dwDeleteIdentifier;
} // _FCAutoReadLock<T>::GetDeleteIdentifier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoReadLock<T>::GetAppendIdentifier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCkJiCoHjDmHiCnNiPgPiClFiClNiDgFiBfLiDhFiDiLiCmMiDgFiBfLiDhFiDiLiCmMjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCoJjBmOiPnLiCmMiPiKjHeMiMkAiDhEiDeAiDeDiDiLiCmJiCmNiBeBiNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iCmG_xHqqkZx_
 *			_xZkqqHx_jCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCkKiLeMjIfOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCmNiBeBiDgFiBfLiDhFiDiLjCiGiCmMiDiMiDfCiBfLiDgIiCkKjCmHiJmBiClDiCoKiClNiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iDiNiDgCiDeOiCkKiJpAiPjMiClDiCoKiCoJiOjOiCmJjCmHiJmBiJpBjAjEjFkKiJmBiOfKiClDiCoKiBeBiNmEiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.10.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
DWORD _FCAutoReadLock<T>::GetAppendIdentifier () const
{
	return m1read(m_1)->m_dwAppendIdentifier;
} // _FCAutoReadLock<T>::GetAppendIdentifier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoReadLock<T>::SetTableGuid
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidTable	:_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiClN_xHqqkZx_GUID_xZkqqHx_iCmNiBeBjDoAjFjEjFmPjAjEiCmGiClFiCmEjFnLjBlGiClDiCoKiCoJiClOiCkPiCmFiBeBiDhEiDeAiDeDiDiLiCmJ_xHqqkZx_
 *			_xZkqqHx_iPjBiCkLiNjOiCnNiCmNiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoReadLock<T>::SetTableGuid (GUID guidTable)
{
	m1readwrite(m_1)->m_guidTable = guidTable;
} // _FCAutoReadLock<T>::SetTableGuid.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoReadLock<T>::SetDeleteIdentifier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwDeleteIdentifier	:_xZkqqHx_iNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiClN_xHqqkZx_Identifier_xZkqqHx_iCmNiBeBjDoAjFjEjFmPjAjEiCmGiClFiCmEjFnLjBlGiClDiCoKiCoJiClOiCkPiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiCmJiPjBiCkLiNjOiCnNiCmNiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoReadLock<T>::SetDeleteIdentifier (DWORD dwDeleteIdentifier)
{
	m1readwrite(m_1)->m_dwDeleteIdentifier = dwDeleteIdentifier;
} // _FCAutoReadLock<T>::SetDeleteIdentifier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoReadLock<T>::SetAppendIdentifier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwAppendIdentifier	:_xZkqqHx_jCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiClN_xHqqkZx_Identifier_xZkqqHx_iCmNiBeBjDoAjFjEjFmPjAjEiCmGiClFiCmEjFnLjBlGiClDiCoKiCoJiClOiCkPiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiCmJiPjBiCkLiNjOiCnNiCmNiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoReadLock<T>::SetAppendIdentifier (DWORD dwAppendIdentifier)
{
	m1readwrite(m_1)->m_dwAppendIdentifier = dwAppendIdentifier;
} // _FCAutoReadLock<T>::SetAppendIdentifier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoReadLock<T>::ReadOwnFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	READ_xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCkJiCoHiBeBiDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidTable			:_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDgGiBfLiDfOiCmMiBeBiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			dwDeleteIdentifier	:_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDgGiBfLiDfOiCmMiBeBiNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			dwAppendIdentifier	:_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDgGiBfLiDfOiCmMiBeBjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCgMiCkKjDmHiCnNiNjOiCnMiCoKiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	READ_xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCmMjDoAjHgFiCmNiBeBiDgPiDeDiDgJiDiKiCmF_xHqqkZx_
 *			_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID+_xZkqqHx_iNoNiPjM_xHqqkZx_Identifier+_xZkqqHx_jCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.10.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
BOOL _FCAutoReadLock<T>::ReadOwnFile (	GUID& guidTable,
										DWORD& dwDeleteIdentifier,
										DWORD& dwAppendIdentifier)
{
	m0read m0r(m_0);
	if (m0r->m_fhOwn == -1) return FALSE;
	long lDataSize = 0;
	// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCmJiBeBiNoNiPjMiBeFjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCmGiDiGiBfLiDfFjGlMiCpAiLeMjIfOiBeC_xHqqkZx_
	_lseek(m0r->m_fhOwn, 0, SEEK_SET);
	lDataSize += _read(m0r->m_fhOwn, &guidTable, sizeof(guidTable));
	lDataSize += _read(m0r->m_fhOwn, &dwDeleteIdentifier, sizeof(dwDeleteIdentifier));
	lDataSize += _read(m0r->m_fhOwn, &dwAppendIdentifier, sizeof(dwAppendIdentifier));
	return (lDataSize == sizeof(guidTable) + sizeof(dwDeleteIdentifier) + sizeof(dwAppendIdentifier));
} // _FCAutoReadLock<T>::ReadOwnFile.

////////////////////////////////////////////////////////////////////////////
// _FCAutoWriteLock_xZkqqHx_iDeOiDiJiDfIiDiBiDjDiDgPiKnGjAjE_xHqqkZx_
////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoWriteLock<T>::_FCAutoWriteLock
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiClFiCmIiCkCiBeCiClBiCmMiPoKiNiHiCmNiBeB_xHqqkZx_TryLockFile_xZkqqHx_iKnGjAjEiCmFiIpIjAjEiCpA_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
_FCAutoWriteLock<T>::_FCAutoWriteLock ()
{
} // _FCAutoWriteLock<T>::_FCAutoWriteLock.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoWriteLock<T>::CreateLockFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiBgJiPiKjHeMiMkAiDhEiDeAiDeDiDiLiBgKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName			:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidTable			:_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwDeleteIdentifier	:_xZkqqHx_iNoNiPjM_xHqqkZx_Identifier_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwAppendIdentifier	:_xZkqqHx_jCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
long _FCAutoWriteLock<T>::CreateLockFile (	const FCTableName& tableName,
											GUID guidTable,
											DWORD dwDeleteIdentifier,
											DWORD dwAppendIdentifier)
{
	Set(tableName, LOCK_WRITE, LOCK_EXCLUSIVE, FD_LOCK_STD_WAIT_TIME);

	//----- Own/Req_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiBeBiDhEiDeAiDeDiDiLjGlMiCmMiNoMjAkM_xHqqkZx_ -----
	WString strOwnDirPath = GetOwnDirPath(GetTableName());
	WString strOwnFilePath = GetOwnFilePath(GetTableName());
	WString strReqDirPath = GetReqDirPath(GetTableName());
	WString strWhoFilePath = GetWhoFilePath(GetTableName());

	//----- _xZkqqHx_iKpJiCmJiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCmNiKpJiCmJiDiNiDgCiDeOiClDiCoKiCmEiCkCiCnMiClHiBeC_xHqqkZx_
	if (IsFileLocked())
		return IDS_DYSR_ERR_FILE_LOCKED_BY_SELF;

	// own_xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiDeHiDiJiBfLiCmJiClFiCmEiCkCiClNiCkKiBeB_xHqqkZx_
	// own_xZkqqHx_iDhEiDeAiDeDiDiLiNoMjAkMiMoDiCmJiDeHiDiJiBfLiPeJjHlJiClFiClNiPoKiNiHiBeB_xHqqkZx_own_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiCnN_xHqqkZx_
	// _xZkqqHx_iOgDiCoJiPpDjBnEiCkKiCkAiCoIiBeBiCoNiClEiCoNiClEiPeDjFjMiDgDiBfLiDiLiCpAiOgHiCoNiCmIiCkNiCmEiCoA_xHqqkZx_
	// _xZkqqHx_iPoDiPjBiCkLiClFiCmEiClFiCnMiCkGiCmOiCoGiCkCiCmMiCmFiBeBiDeHiDiJiBfLiDgAiDeGiDgCiDeOiCmNiPmIiCkCiClNiBeC_xHqqkZx_

//----- 06.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// own_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmNjBlGiNnNiClFiCmEiCkCiCmEiCoAjHmHiCkCiCkKiBeB_xHqqkZx_own_xZkqqHx_iDhEiDeAiDeDiDiLiCmNiDfPiDiBiBeC_xHqqkZx_
//	// _xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiCkKiKpJiCmJjBlGiNnNiClFiCmEiCkCiCnMiClHiBeC_xHqqkZx_
//	if (FFIsThereFile(strOwnFilePath) != FD_FILE_NOT_EXIST)
//		return IDS_DYSR_ERR_FILE_ALREADY_EXIST;
//----- 06.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	long lError = 0;
	BOOL bIsCreateOwnDir = FALSE;
	BOOL bIsCreateReqDir = FALSE;
	int fhReadOwn = -1;

	m0readwrite m0rw(m_0);
  do
  {

	//----- Own/Req_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiNoMjAkM_xHqqkZx_ -----
	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeCiNoMjAkMiOlIjEhDiCmMiPoKiNiHiDeHiDiJiBfLiPiIjHjNiBeC_xHqqkZx_
	if (FFIsThereFile(strOwnDirPath) == FD_FILE_NOT_EXIST)
	{
		WString wstrCreatedPath;
		if (!FFRecursiveCreateDirectory(&wstrCreatedPath, strOwnDirPath))
		{
			// _xZkqqHx_iNoMjAkMiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoNiPjMiBeC_xHqqkZx_
			if (!wstrCreatedPath.IsEmpty())
				FFRecursiveRemoveDirectory(wstrCreatedPath);
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCnGiCmMiDeBiDeOiDfKiDfIiCkKiLjBjEnLiClDiCoKiCnMiClFiClNiBeCiDhEiDeAiDeDiDiLiBeBiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDeBiDeOiDfKiDfIiMkAiCpAiKgNjEeGiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_
			lError = IDS_DYSR_ERR_FILE_ACCESS_DENIED;
			break;
		}
		bIsCreateOwnDir = TRUE;
	}
	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoMjAkMiBeCiNoMjAkMiOlIjEhDiCmMiPoKiNiHiDeHiDiJiBfLiPiIjHjNiBeC_xHqqkZx_
	if (FFIsThereFile(strReqDirPath) == FD_FILE_NOT_EXIST)
	{
		WString wstrCreatedPath;
		if (!FFRecursiveCreateDirectory(&wstrCreatedPath, strReqDirPath))
		{
			// _xZkqqHx_iNoMjAkMiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCpAiNoNiPjMiBeC_xHqqkZx_
			if (!wstrCreatedPath.IsEmpty())
				FFRecursiveRemoveDirectory(wstrCreatedPath);
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCnGiCmMiDeBiDeOiDfKiDfIiCkKiLjBjEnLiClDiCoKiCnMiClFiClNiBeCiDhEiDeAiDeDiDiLiBeBiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDeBiDeOiDfKiDfIiMkAiCpAiKgNjEeGiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_
			lError = IDS_DYSR_ERR_FILE_ACCESS_DENIED;
			break;
		}
		bIsCreateReqDir = TRUE;
	}

	// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCpAiNoMjAkMiBgJiKeKiCkNiBgKiBeC_xHqqkZx_
	fhReadOwn = _tsopen(WStrToTStr(strOwnFilePath),
// 06.04.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//						_O_BINARY | O_CREAT | _O_EXCL | _O_RDONLY,
						_O_BINARY | O_CREAT | _O_TRUNC | _O_RDONLY,
						_SH_DENYRD,				// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMjDmHiCnNiPgPiClFiCpAiLnGiOhOiBeC_xHqqkZx_
						_S_IREAD | _S_IWRITE);
	// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCkKiDeJiBfLiDhGiDjDiCmFiCkLiCmIiCkCiPoKiNiHiCmNiPiIjHjNiCpAjElCiCkPiCoJiBeC_xHqqkZx_
	if (fhReadOwn == -1) break;

	// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
	m0rw->m_fhOwn = _tsopen(WStrToTStr(strOwnFilePath),
							_O_BINARY | _O_WRONLY,
							_SH_DENYWR,
							0);
	// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCkKiDeJiBfLiDhGiDjDiCmFiCkLiCmIiCkCiPoKiNiHiCmNiPiIjHjNiCpAjElCiCkPiCoJiBeC_xHqqkZx_
	if (m0rw->m_fhOwn == -1) break;

	//----- _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCkKiKeKiCkJiCoKiClNiPoKiNiH_xHqqkZx_ -----

	// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCmJiBeBiDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
	WriteOwnFile(	guidTable,
					dwDeleteIdentifier,
					dwAppendIdentifier);

	// _xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
	CreateWhoLockFile(strWhoFilePath.c_str());
	// _xZkqqHx_iDiNiDgCiDeOiDeKiDeFiDjDiDfOiCpAiJmBiOfKiBeC_xHqqkZx_
	m0rw->m_lLockCount++;
	// Read_xZkqqHx_iDeJiBfLiDhGiDjDiCmNjFmCiClGiCoJiBeC_xHqqkZx_
	_close(fhReadOwn);
	fhReadOwn = -1;
	// _xZkqqHx_jFnEjCgMiBeC_xHqqkZx_
	return 0;
  } while (FALSE);

	if (m0rw->m_fhOwn != -1)
	{
		_close(m0rw->m_fhOwn);
		m0rw->m_fhOwn = -1;
	}
	if (fhReadOwn != -1)
	{
		_close(fhReadOwn);
		fhReadOwn = -1;
	}
	mywremove(strOwnFilePath);

	if (bIsCreateOwnDir)
		FFRecursiveRemoveDirectory(strOwnDirPath);
	if (bIsCreateReqDir)
		FFRecursiveRemoveDirectory(strReqDirPath);

	if (lError == 0)
	{
		// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCpAiDeJiBfLiDhGiDjDiCmFiCkLiCmIiCkCiPoKiNiHiBeBiImIiJlKiCmMiDeHiDiJiBfLiCkKjHeMiCoIjDlOiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmJiDhEiDeAiDeDiDiLiNoMjAkMiMkAiCkKjGlDiCkNiBeBiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCoKiCoHiCmMiPoKiNiHiBeBiDeHiDiJiBfLiCpAjFnEiClHjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDeBiDeOiDfKiDfIiMkAiCmMiKgNjEeGiBeC_xHqqkZx_
		const DWORD dwAttrib = GetFileAttributes(WStrToTStr(strOwnFilePath));
		if (dwAttrib == INVALID_FILE_ATTRIBUTES)
		//----- _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFnEjCgM_xHqqkZx_ = _xZkqqHx_iBhFiDhEiDeAiDeDiDiLiCnGiCmMiDeBiDeOiDfKiDfIiCkKiLjBjEnLiClDiCoKiCnMiClFiClNiBeCiDhEiDeAiDeDiDiLiBeBiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDeBiDeOiDfKiDfIiMkAiCpAiKgNjEeGiClFiCmEiCkNiClOiClDiCkCiBeCiBhG_xHqqkZx_
			lError = IDS_DYSR_ERR_FILE_ACCESS_DENIED;
		} else
		{
			lError = IDS_DYSR_ERR_FILE_UNKNOWN;	// _xZkqqHx_jGkCjCgNiCmMiDeHiDiJiBfLiBeC_xHqqkZx_
		}
	}
	return lError;
} // _FCAutoWriteLock<T>::CreateLockFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoWriteLock<T>::TryLockFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmM_xHqqkZx_WRITE_xZkqqHx_iDiNiDgCiDeOiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName		:_xZkqqHx_jBmOiPnLiCmMiDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			shKind			:_xZkqqHx_iDhEiDeAiDeDiDiLiLkEjHeMiCmMiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 LOCK_SHARED/LOCK_EXCLUSIVE_xZkqqHx_iCmMiCmHiClPiCoHiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwWaitMillisec	:_xZkqqHx_iDiNiDgCiDeOiCpAjBnCiCmCiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeCiDeHiDiJiBfLiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOjPiCmJ_xHqqkZx_TryLockFile_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiClHiCoJiCmGiCkLiCmNiBeBiIpIjAjEiCpAiOhHjCoIiClFiCmIiCkNiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iIpIjAjEiCpAiOhHjCoIiClHiCoJiPoKiNiHiCmNiBeBiCnMiCmBiClNiCkNjDkPiClGiIpIjAjEiCpAiOhHjCoIiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
long _FCAutoWriteLock<T>::TryLockFile (const FCTableName& tableName,
										ShareKind shKind,
										DWORD dwWaitMillisec)
{
	return _FCAutoLock<T>::TryLockFile(tableName,
										LOCK_WRITE,
										shKind,
										dwWaitMillisec);
} // _FCAutoWriteLock<T>::TryLockFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoWriteLock<T>::WriteOwnFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCmJiBeBiDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guidTable			:_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiCoJiDgGiBfLiDfOiBeBiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwDeleteIdentifier	:_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiCoJiDgGiBfLiDfOiBeBiNoNiPjM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwAppendIdentifier	:_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiCoJiDgGiBfLiDfOiBeBjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoWriteLock<T>::WriteOwnFile (	GUID guidTable,
											DWORD dwDeleteIdentifier,
											DWORD dwAppendIdentifier)
{
	m0read m0r(m_0);
	if (m0r->m_fhOwn == -1) return;
	// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCmJiBeBiNoNiPjMiBeFjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCmGiDiGiBfLiDfFjGlMiCpAiLeMjIfOiBeC_xHqqkZx_
	_lseek(m0r->m_fhOwn, 0, SEEK_SET);
	_write(m0r->m_fhOwn, &guidTable, sizeof(guidTable));
	_write(m0r->m_fhOwn, &dwDeleteIdentifier, sizeof(dwDeleteIdentifier));
	_write(m0r->m_fhOwn, &dwAppendIdentifier, sizeof(dwAppendIdentifier));
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCmJiDhEiDiJiDgCiDfGiDiFiClHiCoJiBeC_xHqqkZx_
	_commit(m0r->m_fhOwn);
} // _FCAutoWriteLock<T>::WriteOwnFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_FCAutoWriteLock<T>::WriteOwnFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiKjHeMiOnCiPoOjFpBiDhEiDeAiDeDiDiLiCmJiBeBiDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwDeleteIdentifier	:_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiCoJiDgGiBfLiDfOiBeBiNoNiPjM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwAppendIdentifier	:_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiCoJiDgGiBfLiDfOiBeBjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.10.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _FCAutoWriteLock<T>::WriteOwnFile (	DWORD dwDeleteIdentifier,
											DWORD dwAppendIdentifier)
{
	m0read m0r(m_0);
	if (m0r->m_fhOwn == -1) return;
	// _xZkqqHx_iPiKjHeMiMkAiDhEiDeAiDeDiDiLiCmJiBeBiNoNiPjMiBeFjCmHiJmB_xHqqkZx_ID_xZkqqHx_iCmGiDiGiBfLiDfFjGlMiCpAiLeMjIfOiBeC_xHqqkZx_
	_lseek(m0r->m_fhOwn, sizeof(GUID), SEEK_SET);
	_write(m0r->m_fhOwn, &dwDeleteIdentifier, sizeof(dwDeleteIdentifier));
	_write(m0r->m_fhOwn, &dwAppendIdentifier, sizeof(dwAppendIdentifier));
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCmJiDhEiDiJiDgCiDfGiDiFiClHiCoJiBeC_xHqqkZx_
	_commit(m0r->m_fhOwn);
} // _FCAutoWriteLock<T>::WriteOwnFile.

typedef _FCAutoLock<void> FCAutoLock;
typedef _FCAutoReadLock<void> FCAutoReadLock;
typedef _FCAutoWriteLock<void> FCAutoWriteLock;

#endif//__AutoLock_h
