#ifndef __ServerTableManager_h
#define __ServerTableManager_h

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ServerTableManager.h : _xZkqqHx_iDhHiDgCiDfPiBfL_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "VirtualTableManager.h"	// For FCVirtualTableManager.

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS FCVirtualTableManager

class FCDbServer;
class FCFile32;

/////////////////////////////////////////////////////////////////////////////
// FCServerTableManager

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCServerTableManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmMiJlKiCmMjBfDiCmEiCmMiDgFiBfLiDhFiDiLiCpAiBeBiJlMjBhKiDgFiBfLiDhFiDiLiCmGiClFiCmE_xHqqkZx_
 *			_xZkqqHx_iKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Baseclass_xZkqqHx_iCmM_xHqqkZx_FCVirtualTableManager_xZkqqHx_iCmMiLeAjEfMiCmJiJmBiCkGiCmEiBeBiJlMjBhKiDgFiBfLiDhFiDiLiCmM_xHqqkZx_
 *			_xZkqqHx_jDoAjHgFiCpAjFkIjHjNiDgFiBfLiDhFiDiLiDhEiDeAiDeDiDiLiCmJiPjBiCkLiPgPiClHiLeAjEfMiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCServerTableManager : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;

public:
	FCServerTableManager (FCDbServer* pDbServer, const HString& hstrTopDirPath);
	virtual void	FlushAll (vector<FCTableName>& vDeletedTableName);
	virtual void	FlushAll2 (vector<FCTableName>& vDeletedTableName);

protected:
	virtual void	DoTransCommand (BYTE byCommand, const BYTE*& pTransaction);
	virtual void	CalcRecordInfoGroup (FCGroupRec* pGroupRec, const FCTableIds& vGroupIds);
	virtual void	CalcRecordInfoTable (FCTableRec* pTableRec, const FCTableIds& vTableIds);

	virtual void	MakeRecoveryGroup (	WStringVector& vOldDirPath,
										WStringVector& vOldFilePath,
										FCFile32& fileRecover,
										FCGroupRec* pGroupRec,
										const FCTableIds& vGroupIds);
	virtual void	MakeRecoveryTable (	WStringVector& vOldFilePath,
										FCFile32& fileRecover,
										FCTableRec* pTableRec,
										const FCTableIds& vTableIds);
	virtual void	WriteGroup (FCGroupRec* pGroupRec, const FCTableIds& vGroupIds);
	virtual void	WriteTable (FCTableRec* pTableRec, const FCTableIds& vTableIds);

	virtual FCVirtualWriteTable*	CreateVirtualTable ();
	virtual FCTableRec*	UpdateVirtualTable (const FCTableIds& vTableIds);
	virtual void	GetReadLockInfo (	GUID& guidTable,
										DWORD& dwDeleteIdentifier,
										DWORD& dwAppendIdentifier,
										const FCTableIds& vTableIds) const;
	virtual void	SetLockGuidAndIdentifier (	const FCTableIds& vTableIds,
												const GUID& guidTable,
												DWORD dwDeleteIdentifier,
												DWORD dwAppendIdentifier);
	virtual void	SetLockIdentifier (	const FCTableIds& vTableIds,
										DWORD dwDeleteIdentifier,
										DWORD dwAppendIdentifier);

protected:
	FCDbServer*	m_pDbServer;
}; // class FCServerTableManager.

/////////////////////////////////////////////////////////////////////////////

#endif //__ServerTableManager_h
