#ifndef __COleLinkingDoc_h
#define __COleLinkingDoc_h

class MfcOleLinkingDoc : public MfcOleDocument
{
	virtual MfcRuntimeClass* GetRuntimeClass() const;

// Constructors
public:

// Overridables
protected:
	virtual MfcOleServerItem* OnGetLinkedItem(LPCTSTR lpszItemName);
		// return item for the named linked item (for supporting links)
	virtual MfcOleClientItem* OnFindEmbeddedItem(LPCTSTR lpszItemName);
		// return item for the named embedded item (for links to embeddings)

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(MfcDumpContext& dc) const;
#endif
	virtual ~MfcOleLinkingDoc();

	// overrides for updating of monikers & running object table registration
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	virtual void OnCloseDocument();
	virtual LPOLEITEMCONTAINER GetContainer();
	virtual LPMONIKER GetMoniker(OLEGETMONIKER nAssign);

	// special handling of error messages during save/load
	virtual void ReportSaveLoadException(LPCTSTR lpszPathName,
		MfcException* e, BOOL bSaving, UINT nIDPDefault);

	// implementation helpers
	virtual BOOL RegisterIfServerAttached(LPCTSTR lpszPathName, BOOL bMessage);
	virtual void OnShowViews(BOOL bVisible);

	virtual void SaveToStorage(MfcObject* pObject = NULL);

// Interface Maps
public:
	virtual const AFX_MFC_INTERFACEMAP* GetInterfaceMap() const;
};

#endif//__COleLinkingDoc_h
