/*************************************************************************
 * <File name>		MpaCompo_0.cpp
 *
 * <Summary>		This is a source code of the Component-0.
 *					A single plug-in includes one or more components.
 *
 * <History>		01.08.10 Fukushiro M. Creation.
 *************************************************************************/

#include "stdafx.h"
#include <assert.h>		// For assert.
#include <tchar.h>		// For _TCHAR.
#include "MpaModule.h"	// For FMpgGetModule().

// A CLSID for the Component-0.
// Each Component must have a unique CLSID.
// You can get the unique CLSID using 'guidgen.exe'.
// Caution!
// This CLSID must be different from the value of PG_MODULE_CLSID.
----- Modify below -----
// {A9AF7D19-B197-413F-BF49-D6D293CA0B24}
static const GUID PG_COMPONENT_CLSID = FMpgGuid(0xa9af7d19, 0xb197, 0x413f, 0xbf, 0x49, 0xd6, 0xd2, 0x93, 0xca, 0xb, 0x24);
----- End of modification -----

----- Modify below -----
// Component name.
static const wchar_t*	s_wcpComponentName = L"Component-0";
// Author.
static const wchar_t* s_wcpAuthorName = L"Ichiro Tokyo";
// Component version.
static const wchar_t*	s_wcpComponentVersion = L"1.0";
// Comments about Component.
static const wchar_t*	s_wcpComponentComment = L"Description about this component.";
// Menu of commands provided by this Component.
static const wchar_t*	s_tcpMenu[] =
{
	L"Setup about Component-0...",		// Command-0.
	L"Help",							// Command-1.
	L"About Component-0...",			// Command-2.
};

// Pophint for the commands.
// This message is displayed when you rest the mouse pointer on the target.
static const wchar_t*	s_wcpHintText[] =
{
	L"Pophint for the Component-0.\r\nIf it is not needed, this will be empty.",
	L"Pophint for the help.\r\nIf it is not needed, this will be empty.",
	L"Pophint for the About component-0.\r\nIf it is not needed, this will be empty.",
};

// Recommended accesskey for the Component.
static const wchar_t	s_wcComponentShortcut = L'G';

// Accesskeys for the commands.
static const wchar_t	s_tcpMenuShortcut[] =
{
	L'G',
	L'B',
	L'A',
};
----- End of modification -----

/////////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <Function>		CA0::GetComponentCLSID
 *
 * <Summary>	This returns the CLSID of this Component.
 *
 * <Return value>	CLSID.
 *
 * <History>		05.05.24 Fukushiro M. Creation
 *************************************************************************/
const GUID& CA0::GetComponentCLSID () const
{
	return PG_COMPONENT_CLSID;
} // CA0::GetComponentCLSID.

/*************************************************************************
 * <Function>		CA0::GetAuthorName
 *
 * <Summary>		This returns the author's name of this Component.
 *
 * <Return value>	Author's name of this Component.
 *
 * <History>		01.12.16 Fukushiro M. Creation
 *************************************************************************/
const wchar_t* CA0::GetAuthorName () const
{
	return s_wcpAuthorName;
} // CA0::GetAuthorName.

/*************************************************************************
 * <Function>		CA0::GetComponentName
 *
 * <Summary>		This returns the name of this Component.
 *
 * <Return value>	Name of this Component.
 *
 * <Description>	The returned value is used as the name of plug-in menu.
 *
 * <History>		01.08.02 Fukushiro M. Creation
 *************************************************************************/
const wchar_t* CA0::GetComponentName () const
{
	return s_wcpComponentName;
} // CA0::GetComponentName.

/*************************************************************************
 * <Function>		CA0::GetVersionName
 *
 * <Summary>		This returns the version name of this Component.
 *
 * <Return value>	Version name of this Component.
 *
 * <History>		01.08.02 Fukushiro M. Creation
 *************************************************************************/
const wchar_t* CA0::GetVersionName () const
{
	return s_wcpComponentVersion;
} // CA0::GetVersionName.

/*************************************************************************
 * <Function>		CA0::GetComment
 *
 * <Summary>		This returns the comments of this Component.
 *
 * <Return value>	Comment string of this Component.
 *
 * <History>		01.08.02 Fukushiro M. Creation
 *************************************************************************/
const wchar_t* CA0::GetComment () const
{
	return s_wcpComponentComment;
} // CA0::GetComment.

/*************************************************************************
 * <Function>		CA0::GetComponentShortcut
 *
 * <Summary>		This returns the accesskey which is used in
 *					the menu of Dynamic Draw.
 *
 * <Return value>	Code of the accesskey.
 *
 * <Description>	It is not guaranteed, but recommended to use
 *					the returned value.
 *
 * <History>		01.08.02 Fukushiro M. Creation
 *************************************************************************/
wchar_t CA0::GetComponentShortcut () const
{
	return s_wcComponentShortcut;
} // CA0::GetComponentShortcut.

/////////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <Function>		CA0::Initialize
 *
 * <Summary>		This function is called to initialize this Component.
 *
 * <Parameters>		pI	:It specifies the interface of Dynamic Draw.
 *
 * <Return value>	If successful, returns S_OK.
 *
 * <History>		01.08.02 Fukushiro M. Creation
 *************************************************************************/
HRESULT CA0::Initialize (IMpgMolipMain* pI)
{
	// The size of the array 'm_adwCommandId' must be more than the amount of the commands.
	assert((sizeof(s_tcpMenu) / sizeof(s_tcpMenu[0])) <= (sizeof(m_adwCommandId) / sizeof(m_adwCommandId[0])));

	// Superclass function.
	if (FAILED(IMpgInterface::Initialize(pI))) return E_FAIL;
	// Registration of the commands.
	for (int iC = 0; iC < sizeof(s_tcpMenu) / sizeof(s_tcpMenu[0]); iC++)
	{
		m_adwCommandId[iC] = GetMolipMainI()->
				RegisterCommand(TRUE, s_tcpMenu[iC], s_tcpMenuShortcut[iC]);
	}
	return S_OK;
} // CA0::Initialize.

/*************************************************************************
 * <Function>		CA0::Terminate
 *
 * <Summary>		This function is called to terminate this Component.
 *
 * <Return value>	If successful, returns S_OK.
 *
 * <History>		01.08.02 Fukushiro M. Creation
 *************************************************************************/
HRESULT CA0::Terminate ()
{
	// Superclass function.
	return IMpgInterface::Terminate();
} // CA0::Terminate.

/*************************************************************************
 * <Function>		CA0::OnCommand
 *
 * <Summary>		This function is called to execute the command that
 *					is registered by GetMolipMainI()->RegisterCommand.
 *
 * <Parameters>		nCmdID	:It specifies the command ID.
 *
 * <Return value>	If successful, returns S_OK.
 *
 * <History>		01.08.02 Fukushiro M. Creation
 *************************************************************************/
HRESULT CA0::OnCommand (UINT nCmdID)
{
	if (nCmdID == m_adwCommandId[0])
	//----- Implementation of the command-0 -----
	{
		GetUtilErrI()->MessageBox(L"CA0::OnCommand 0", L"Message", MB_OK, MfcSize(0,0));
	} else
	if (nCmdID == m_adwCommandId[1])
	//----- Implementation of the command-1 -----
	{
		// Getting the file path name of this plug-in module.
		// The file extension is omitted from the file path name.
		_TCHAR tcsModule[_MAX_PATH];
		FMpgGetModule()->GetModulePathName(tcsModule, _MAX_PATH);
		_tcscat(tcsModule, _T(".hlp"));
		::WinHelp(GetMolipMainI()->GetMainWindow(), tcsModule, HELP_FINDER,(DWORD)0);
	} else
	if (nCmdID == m_adwCommandId[2])
	//----- Implementation of the command-2 -----
	{
		// Show the information about this Component.
		GetMolipMainI()->ShowAboutDialog();
	}
	return S_OK;
} // CA0::OnCommand.

/*************************************************************************
 * <Function>		CA0::OnUpdateCommandUI
 *
 * <Summary>		This function is called to check that the specified
 *					command is valid or invalid.
 *
 * <Parameters>		pCmdUI	:It specifies the command interface.
 *
 * <Return value>	If successful, returns S_OK.
 *
 * <History>		01.08.02 Fukushiro M. Creation
 *************************************************************************/
HRESULT CA0::OnUpdateCommandUI (MfcCmdUI* pCmdUI)
{
	// When this is called from the submenu, returns without doing anything.
	if (pCmdUI->m_pSubMenu != NULL) return S_OK;
	if (pCmdUI->m_nID == m_adwCommandId[0])
	//----- Implementation of the command-0 -----
	{
		pCmdUI->Enable(TRUE);
	} else
	if (pCmdUI->m_nID == m_adwCommandId[1])
	//----- Implementation of the command-1 -----
	{
		pCmdUI->Enable(TRUE);
	} else
	if (pCmdUI->m_nID == m_adwCommandId[2])
	//----- Implementation of the command-2 -----
	{
		pCmdUI->Enable(TRUE);
	}
	return S_OK;
} // CA0::OnUpdateCommandUI.

/*************************************************************************
 * <Function>		CA0::GetPopHint
 *
 * <Summary>		This function returns the text of the pophint.
 *					The text is displayed when you rest the mouse pointer
 *					on the target.
 *
 * <Parameters>		wstrHintText:It returns the text of the pophint.
 *					nCmdID		:It specifies the command.
 *
 * <Return value>	If successful, returns S_OK.
 *
 * <History>		05.08.04 Fukushiro M. Creation
 *************************************************************************/
HRESULT CA0::GetPopHint (WString& wstrHintText, UINT nCmdID)
{
	if (nCmdID == m_adwCommandId[0])
	//----- Implementation of the command-0 -----
	{
		wstrHintText = s_wcpHintText[0];
	} else
	if (nCmdID == m_adwCommandId[1])
	//----- Implementation of the command-1 -----
	{
		wstrHintText = s_wcpHintText[1];
	} else
	if (nCmdID == m_adwCommandId[2])
	//----- Implementation of the command-2 -----
	{
		wstrHintText = s_wcpHintText[2];
	}
	return S_OK;
} // CA0::GetPopHint.

/////////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <Function>	CA0::CA0
 *
 * <Summary>	Constructer.
 *
 * <History>	01.08.10 Fukushiro M. Creation
 *************************************************************************/
CA0::CA0 ()
{
} // CA0::CA0.

/*************************************************************************
 * <Function>	CA0::~CA0
 *
 * <Summary>	Destructer.
 *
 * <History>	01.08.10 Fukushiro M. Creation
 *************************************************************************/
CA0::~CA0 ()
{
} // CA0::~CA0.

