#include "stdafx.h"
#include "2RichText.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// MC2StatChar
MC2StatChar::MC2StatChar ()
{
	memset(this, 0, sizeof(*this));
} // MC2StatChar::MC2StatChar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2StatChar::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkOjAkLiDgGiBfLiDfOiCmMiPgPjHmNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPgPjHmNjAoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2StatChar::OutStream (MC2ARCHIVE& ar) const
{
	ar << m_wChar;			// _xZkqqHx_jFlGiOjKiDfCiBfLiDgI_xHqqkZx_.
	ar << m_dwForStream;	// _xZkqqHx_jDpMiPgPjHmNjHhAiBeC_xHqqkZx_
	ar << m_mmfAbcA;		// ABC_xZkqqHx_iNfMjBkCjBmMiCmM_xHqqkZx_abcA_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
	ar << m_mmfAbcC;		// ABC_xZkqqHx_iNfMjBkCjBmMiCmM_xHqqkZx_abcC_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
} // MC2StatChar::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2StatChar::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkOjAkLiDgGiBfLiDfOiCmMjDpMjHmNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDpMjHmNjAoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2StatChar::InStream (MC2ARCHIVE& ar)
{
	ar >> m_wChar;			// _xZkqqHx_jFlGiOjKiDfCiBfLiDgI_xHqqkZx_.
	ar >> m_dwForStream;	// _xZkqqHx_jDpMiPgPjHmNjHhAiBeC_xHqqkZx_
	ar >> m_mmfAbcA;		// ABC_xZkqqHx_iNfMjBkCjBmMiCmM_xHqqkZx_abcA_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
	ar >> m_mmfAbcC;		// ABC_xZkqqHx_iNfMjBkCjBmMiCmM_xHqqkZx_abcC_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
} // MC2StatChar::InStream.

/////////////////////////////////////////////////////////////////////////////
// MC2StatLine

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2StatLine::MC2StatLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.19 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2StatLine::MC2StatLine ()
{
	m_mmStartIndent	= 0.0;
	m_mmRightIndent	= 0.0;
	m_mmOffset		= 0.0;
	m_mmvTabs.clear();
	m_byAlignment	= MD2_FDRC_AL_LEFT;
	m_byLineType	= MD2_FDRC_LT_HEAD;
	m_wPointLineAfter = 0;
	m_vStatChar.clear();
	m_mmY			= 0.0;
	m_mmfTMHeight	= 0.0;
	m_mmfTMAscent	= 0.0;
	m_mmfTMExternalLeading	= 0.0;
} // MC2StatLine::MC2StatLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2StatLine::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkOjAkLiDgGiBfLiDfOiCmMiPgPjHmNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPgPjHmNjAoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.04 Fukushiro M. MC2ARCHIVE_xZkqqHx_iCkJiCoH_xHqqkZx_MC2ARCHIVE_xZkqqHx_iCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void MC2StatLine::OutStream (MC2ARCHIVE& ar) const
{
	ar << m_mmStartIndent;			// _xZkqqHx_jAoGjDkKiNhDiCmMiNlGiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	ar << m_mmRightIndent;			// _xZkqqHx_jAoGjDkKiBeFiMhAjBlBiNhDiCmMiJeFiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	ar << m_mmOffset;				// _xZkqqHx_iMhAjBlBiNhDiCmMiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	//----- _xZkqqHx_iDfOiDhFiCmMiImKjChFiCmMjHpBiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	ar << static_cast<WORD>(m_mmvTabs.size());
	doubleVector::const_iterator iTab;
	for (iTab = m_mmvTabs.begin(); iTab != m_mmvTabs.end(); iTab++)
		ar << *iTab;
	//----- _xZkqqHx_iClLiCmMjBlMiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	ar << m_byAlignment;			// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgH_xHqqkZx_.
	ar << m_byLineType;				// _xZkqqHx_iNhDiCmMiDfOiDeDiDhG_xHqqkZx_(_xZkqqHx_jAoGjDkK_xHqqkZx_/_xZkqqHx_iMhAjBlB_xHqqkZx_)
	ar << m_wPointLineAfter;		// _xZkqqHx_iNhDiKnEiBgJiNhDiCmMiJlKiBgKiCmMiDhMiDeDiDjDiDgHjAjEiBeC_xHqqkZx_
	//----- _xZkqqHx_jFlGiOjKjHpBiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	ar << static_cast<WORD>(m_vStatChar.size());
	MC2StatCharVector::const_iterator i;
	for (i = m_vStatChar.begin(); i != m_vStatChar.end(); i++)
		(*i).OutStream(ar);
	//----- _xZkqqHx_iClLiCmMjBlMiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	ar << m_mmY;					// _xZkqqHx_iNhDiCmMiPoDiCmMiNmAjFfH_xHqqkZx_.
	ar << m_mmfTMHeight;			// _xZkqqHx_jFlGiOjKiCmMiNiCiClD_xHqqkZx_.
	ar << m_mmfTMAscent;			// _xZkqqHx_iDhIiBfLiDfIiDiJiDeDiDjDiCkJiCoHiNhDiCmMiPoDiCnMiCmFiCmMiNiCiClD_xHqqkZx_.
	ar << m_mmfTMExternalLeading;	// _xZkqqHx_jFlGiOjKiCmMiJlKiCmMiMiEiKnE_xHqqkZx_.
} // MC2StatLine::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2StatLine::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkOjAkLiDgGiBfLiDfOiCmMjDpMjHmNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDpMjHmNjAoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.04 Fukushiro M. MC2ARCHIVE_xZkqqHx_iCkJiCoH_xHqqkZx_MC2ARCHIVE_xZkqqHx_iCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void MC2StatLine::InStream (MC2ARCHIVE& ar)
{
	ar >> m_mmStartIndent;			// _xZkqqHx_jAoGjDkKiNhDiCmMiNlGiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	ar >> m_mmRightIndent;			// _xZkqqHx_jAoGjDkKiBeFiMhAjBlBiNhDiCmMiJeFiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	ar >> m_mmOffset;				// _xZkqqHx_iMhAjBlBiNhDiCmMiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	//----- _xZkqqHx_iDfOiDhFiCmMiImKjChFiCmMjHpBiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	m_mmvTabs.clear();
	WORD wSize;
	double mmTab;
	ar >> wSize;
	long lC;
	for (lC = 0; lC < wSize; lC++)
	{
		ar >> mmTab;
		m_mmvTabs.push_back(mmTab);
	}
	//----- _xZkqqHx_iClLiCmMjBlMiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	ar >> m_byAlignment;			// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgH_xHqqkZx_.
	ar >> m_byLineType;				// _xZkqqHx_iNhDiCmMiDfOiDeDiDhG_xHqqkZx_(_xZkqqHx_jAoGjDkK_xHqqkZx_/_xZkqqHx_iMhAjBlB_xHqqkZx_)
	ar >> m_wPointLineAfter;		// _xZkqqHx_iNhDiKnEiBgJiNhDiCmMiJlKiBgKiCmMiDhMiDeDiDjDiDgHjAjEiBeC_xHqqkZx_
	//----- _xZkqqHx_jFlGiOjKjHpBiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	m_vStatChar.clear();
	MC2StatChar sc;
	ar >> wSize;
	for (lC = 0; lC < wSize; lC++)
	{
		sc.InStream(ar);
		m_vStatChar.push_back(sc);
	}
	//----- _xZkqqHx_iClLiCmMjBlMiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	ar >> m_mmY;					// _xZkqqHx_iNhDiCmMiPoDiCmMiNmAjFfH_xHqqkZx_.
	ar >> m_mmfTMHeight;			// _xZkqqHx_jFlGiOjKiCmMiNiCiClD_xHqqkZx_.
	ar >> m_mmfTMAscent;			// _xZkqqHx_iDhIiBfLiDfIiDiJiDeDiDjDiCkJiCoHiNhDiCmMiPoDiCnMiCmFiCmMiNiCiClD_xHqqkZx_.
	ar >> m_mmfTMExternalLeading;	// _xZkqqHx_jFlGiOjKiCmMiJlKiCmMiMiEiKnE_xHqqkZx_.
} // MC2StatLine::InStream.

/////////////////////////////////////////////////////////////////////////////
// MC2StatLineVector_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2StatLineVector::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAiDfIiDgHiDiKiBfLiDiAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPgPjHmNjHhAiDeBiBfLiDeKiDeDiDhFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2StatLineVector::OutStream (MC2ARCHIVE& ar) const
{
	//----- _xZkqqHx_jFlGiOjKjHpBiPoOjFpBiCpAiPgPjHmN_xHqqkZx_ -----
	ar << static_cast<long>(size());
	MC2StatLineVector::const_iterator iL;
	for (iL = begin(); iL != end(); iL++) (*iL).OutStream(ar);
} // MC2StatLineVector::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2StatLineVector::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiCkJiCoHiDgGiBfLiDfOiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDpMjHmNjHhAiDeBiBfLiDeKiDeDiDhFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2StatLineVector::InStream (MC2ARCHIVE& ar)
{
	//----- _xZkqqHx_jFlGiOjKjHpBiPoOjFpBiCpAjDpMjHmN_xHqqkZx_ -----
	// _xZkqqHx_iKpJjBlGiCmMjFlGiOjKjHpBiPoOjFpBiCpAiNoNiPjMiBeC_xHqqkZx_
	clear();
	long lSize;
	ar >> lSize;
	while (0 < lSize--)
	{
		push_back(MC2StatLine());
		back().InStream(ar);
	}
} // MC2StatLineVector::InStream.

////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2RichText::MC2RichText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.09.16 Fukushiro M. _xZkqqHx_iDhNiBfLiDfHiDjDiDgGiDhEiDeIiDiLiDgHjCgMiCpAjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
MC2RichText::MC2RichText ()
{
	m_mmMarginL = FFUtilMathI->mmroundoff(0.5);	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiNlGiDhNiBfLiDfHiDjD_xHqqkZx_.
	m_mmMarginT = FFUtilMathI->mmroundoff(0.5);	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiPoDiDhNiBfLiDfHiDjD_xHqqkZx_.
	m_mmMarginR = FFUtilMathI->mmroundoff(0.5);	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJeFiDhNiBfLiDfHiDjD_xHqqkZx_.
	m_mmMarginB = FFUtilMathI->mmroundoff(0.5);	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJlKiDhNiBfLiDfHiDjD_xHqqkZx_.
	m_mmrtText.SetRect(0,0,0,0);
	m_dAngle = 0.0;	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKhAjDhIiBeC_xHqqkZx_
	m_dwVertAlign = MD2_FDRC_AL_TOP;	// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiBeC_xHqqkZx_
	m_vpLine = new MC2StatLineVector;
} // MC2RichText::MC2RichText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2RichText::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_MC2ARCHIVE
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
*************************************************************************/
void MC2RichText::OutStream (MC2ARCHIVE& ar)
{
	ar << m_mmMarginL;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiNlGiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar << m_mmMarginT;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiPoDiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar << m_mmMarginR;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJeFiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar << m_mmMarginB;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJlKiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar << m_mmrtText;	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	ar << m_dAngle;	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKhAjDhIiBeC_xHqqkZx_
	ar << m_dwVertAlign;// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiBeC_xHqqkZx_
	// _xZkqqHx_jFlGiOjKjHpBiPoOjFpBiCpAiPgPjHmNiBeC_xHqqkZx_
	m_vpLine->OutStream(ar);
} // MC2RichText::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2RichText::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_MC2ARCHIVE
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2RichText::InStream (MC2ARCHIVE& ar)
{
	ar >> m_mmMarginL;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiNlGiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar >> m_mmMarginT;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiPoDiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar >> m_mmMarginR;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJeFiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar >> m_mmMarginB;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJlKiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar >> m_mmrtText;	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	ar >> m_dAngle;		// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKhAjDhIiBeC_xHqqkZx_

	// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiBeC_xHqqkZx_
	ar >> m_dwVertAlign;
	// _xZkqqHx_iKpJjBlGiCmMjFlGiOjKjHpBiPoOjFpBiCpAiNoNiPjMiClFiBeBjDkPiOjOiCmJjFlGiOjKjHpBiPoOjFpBiCpAjDpMjHmNiBeC_xHqqkZx_
	m_vpLine->InStream(ar);
} // MC2RichText::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2RichText::~MC2RichText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2RichText::~MC2RichText ()
{
	delete m_vpLine;
} // MC2RichText::~MC2RichText.

