#ifndef __3NewFDObjAny_h
#define __3NewFDObjAny_h

#include "3ObjArc.h"
#include "3ObjChipMaster.h"
#include "3ObjPictArrow.h"
#include "3ObjGroup.h"
#include "3ObjLine.h"
#include "3ObjOle.h"
#include "3ObjPoly.h"
#include "3ObjPoint.h"
#include "3ObjRect.h"
#include "3ObjRoundRect.h"
#include "3ObjWidePoly.h"
#include "3ObjLabel.h"

inline MC3ObjBase* NewFDObjAny (FTObjectType nType)
{
	switch (nType)
	{
	case FDOJ_LINE:
		return new MC3ObjLine();
	case FDOJ_RECT:
		return new MC3ObjRect();
	case FDOJ_ROUND_RECT:
		return new MC3ObjRoundRect();
	case FDOJ_ARC:
		return new MC3ObjArc();
	case FDOJ_POLY:
		return new MC3ObjPoly();
	case FDOJ_GROUP:
		return new MC3ObjGroup();
	case FDOJ_WIDE_POLY:
		return new MC3ObjWidePoly();
	case FDOJ_OLE:
		return new MC3ObjOle();
	case FDOJ_CHIP_MASTER:
		return new MC3ObjChipMaster();
	case FDOJ_PICT_ARROW:
		return new MC3ObjPictArrow();
	case FDOJ_POINT:
		return new MC3ObjPoint();
	case FDOJ_LABEL:
		return new MC3ObjLabel();
	}
	return NULL;
} // NewFDObjAny.

#endif//__3NewFDObjAny_h
