// 34Document.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "4HeaderInf.h"		// For MC4HeaderInf.
#include "4App.h"				// For MC4App.
#include "4Env.h"				// For MC4Env.
#include "4ToolManager.h"		// For MC4ToolManager.
#include "4LayerManager.h"		// For MC4LayerManager.
#include "4SheetManager.h"		// For MC4SheetManager.
#include "4LinkManager.h"		// For MC4LinkManager.
#include "4Reg.h"				// For MC4Reg.
#include "4CanvasStat.h"		// For MC4CanvasStat.
#include "4Document.h"			// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

MC4Document* g_pDoc = NULL;

/////////////////////////////////////////////////////////////////////////////
// MC4Document

IMPLEMENT_DYNCREATE(MC4Document, COleServerDoc)

//////////////////////////////////////////////////////////////////////
// static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myFuncPngRead
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_iDgGiBfLiDfOiCmMjDmHiCnNiPgPiClFjHhAiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myFuncPngRead (png_struct* pPngPtr, BYTE* pData, size_t szLength)
{
	CArchive& ar = *(CArchive*)FFUtilZlibPngI->PngGetIoPtr(pPngPtr);
	if (pData != NULL)
	{
		if (ar.Read(pData, szLength) != szLength)
			FFUtilErrI->ThrowDDFileException(FD_IDS_ERR_FILE_WRONG_FORM, L"");
	} else
	{
		// CArchive_xZkqqHx_iCmNiBeB_xHqqkZx_ar.GetFile() _xZkqqHx_iCkJiCoHjDoAjFjEiDgPiDgCiDhEiDeAiCmJ_xHqqkZx_
		// _xZkqqHx_iCnMiCmGiCnPiCmEjDmHiCnNiNjOiCnOiClNiCnPiBeB_xHqqkZx_ar.GetFile()->Seek()
		// _xZkqqHx_iCmNiOgHiCkGiCmIiCkCiBeC_xHqqkZx_
		BYTEVector vBuff(szLength);
		if (ar.Read(&vBuff.front(), szLength) != szLength)
			FFUtilErrI->ThrowDDFileException(FD_IDS_ERR_FILE_WRONG_FORM, L"");
	}
} // myFuncPngRead.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myFuncPngError
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_iDgGiBfLiDfOiCmMiDeHiDiJiBfLiPiIjHjNjHhAiKnGjAjE_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myFuncPngError (png_struct* pPngPtr, const char* pErrorMessage)
{
	// PNG_xZkqqHx_iDiJiDeDiDhFiDiJiDiKiCmFiCmNiBeBiDeHiDiJiBfLiOoNjFmKiCpAjElLjFmKiCmFiCkLiCoJiDeHiDiJiBfLiDfCiBfLiDgIiCmNjGlDiCkNiBeB_xHqqkZx_
	// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHjFlGiOjKjHpBiCmFiClFiCkJiPgPjHmNiClFiCmIiCkCiBeC_xHqqkZx_
	// FD_IDS_ERR_MSG_PNG = PNG_xZkqqHx_iDeHiDiJiBfL_xHqqkZx_:%s
	FFUtilErrI->ThrowMiscException((const wchar_t*)AStrToWStr(pErrorMessage));
} // myFuncPngError.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myFuncPngWarning
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PNG_xZkqqHx_iDgGiBfLiDfOiCmMiMhIiNjAiPiIjHjNjHhAiKnGjAjE_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myFuncPngWarning (png_struct* pPngPtr, const char* pWarningMessage)
{
} // myFuncPngWarning.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myFuncPngWrite
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myFuncPngWrite (png_struct* pPngPtr, BYTE* pData, size_t szLength)
{
	CArchive& ar = *(CArchive*)FFUtilZlibPngI->PngGetIoPtr(pPngPtr);
	ar.Write(pData, szLength);
} // myFuncPngWrite.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myFuncPngFlush
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myFuncPngFlush (png_struct* pPngPtr)
{
	CArchive& ar = *(CArchive*)FFUtilZlibPngI->PngGetIoPtr(pPngPtr);
	ar.Flush();
} // myFuncPngFlush.

/////////////////////////////////////////////////////////////////////////////
// MC4Document _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4Document::SetRootStorage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCpAjChFiCkLiKlHiCkGiCoJiBeCiDeBiBfLiDeKiDeDiDhFiCkJiCoH_xHqqkZx_OLE_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pStorage	:_xZkqqHx_jChFiCkLiKlHiCkGiCoJiDfIiDgHiDiMiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCoAiCmGiCoAiCmGiCmMiDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCkJiCoH_xHqqkZx_OLE_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiPoKiNiHiBeBjFkBiNiHiDhEiDeAiDeDiDiLiCmFiCkAiCoKiCmOiBeB_xHqqkZx_
 *			_xZkqqHx_iDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCmGiDeBiBfLiDeKiDeDiDhFiCmNiDfKiDgCiDgHiCmJiCmIiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jBkGiClPiBeBiDeBiBfLiDeKiDeDiDhFiCmMjDmHiCnNiNjOiCnNiImKjChFiCkKiClPiCoFiCkEiCmH_xHqqkZx_OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmM_xHqqkZx_
 *			_xZkqqHx_iImKjChFiCmJiCmIiCmBiClNiCmGiCkLiBeBjDmHiCnNiNjOiCnNjAoGiCmNiDeBiBfLiDeKiDeDiDhFiCmFiCmNiCmIiCkN_xHqqkZx_
 *			_xZkqqHx_iDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCmJiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiDeBiBfLiDeKiDeDiDhFiCmGiDfKiDgCiDgHiCmJiCmIiCmBiClNiDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCpA_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDgIiDeMiDiFiDiBiDjDiDgHiCmJjDgOiClFiCmEiCoCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhEiDiJiDgCiDgHiDhEiDeAiDeDiDiLiCmMiPoKiNiHiCmNiBeBiClBiCmMjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClNiClOiClFiBeBiDhEiDiJiDgCiDgHiDhEiDeAiDeDiDiLiCmFiCkAiCmBiCmEiCoAiBeBjDmHiCnNiNjOiCnNiOjOiCmJ_xHqqkZx_
 *			OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiHiBeBiImIiJlKiCmMiImKjChFiCmF_xHqqkZx_
 *			_xZkqqHx_iDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCmJ_xHqqkZx_OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClFiCmJ_xHqqkZx_
 *			_xZkqqHx_iNhDiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCpA_xHqqkZx_(-1)_xZkqqHx_iCmFjChFiCkLiKlHiCkGiCoJiClBiCmGiCmN_xHqqkZx_
 *			_xZkqqHx_iClFiCmIiCkCiBeC_xHqqkZx_
 *			OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiDhEiDiJiDgCiDgHiDhEiDeAiDeDiDiLiCnGiPjBiCkLiPgPiClHiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iDiLiBfLiDgHiDfIiDgHiDiMiBfLiDfHiCpAjEePiCmMiClNiCnPiCmJ_xHqqkZx_(-1)_xZkqqHx_iCmJjChFiCkLiKlHiCkGiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iJlNiCoAiPiIjHjNiCkKiCmIiCkCiCoGiCkEiCmJiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *			
 *			void COleClientItem::ReadItemCompound(CArchive& ar)
 *			{
 *				:
 *				:
 *				GetItemStorageCompound();
 *				~~~~~~~~~~~~~~~~~~~~~~~~~_xZkqqHx_iClBiCmMiKnGjAjEjCiG_xHqqkZx_
 *
 *			void COleClientItem::GetItemStorageCompound()
 *			{
 *				:
 *				:
 *				SCODE sc = pDoc->m_lpRootStg->CreateStorage(T2COLE(szItemName),
 *					STGM_CREATE|STGM_READWRITE|STGM_TRANSACTED|STGM_SHARE_EXCLUSIVE,
 *					0, 0, &lpStorage);
 *				~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~_xZkqqHx_iClBiClB_xHqqkZx_
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LPSTORAGE MC4Document::SetRootStorage (LPSTORAGE pStorage)
{
	LPSTORAGE pStorageOld = m_lpRootStg;
	m_lpRootStg = pStorage;
	return pStorageOld;
} // MC4Document::SetRootStorage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4Document::SetFileType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPgPjHmNiClHiCoJiDhEiDeAiDeDiDiLiMfOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	df	:_xZkqqHx_iDhEiDeAiDeDiDiLiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC4Document::SetFileType (FTDocumentFormat df)
{
	m_headerInf->SetFileType(df);
} // MC4Document::SetFileType.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4Document::SetImage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ccore_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCmJjDfJjFhEiClHiCoJiPgLiPkMiDeDiDiBiBfLiDfHiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pImageData	:_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lImageSize	:_xZkqqHx_iDeDiDiBiBfLiDfHiDgGiBfLiDfOiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szImage		:_xZkqqHx_iDeDiDiBiBfLiDfHiCmMjFjNiBeFiNiCiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC4Document::SetImage (const BYTE* pImageData,
							long lImageSize,
							const CSize& szImage)
{
	m_vImageData.clear();
	m_vImageData.insert(m_vImageData.begin(), pImageData, pImageData + lImageSize);
	m_szImage = szImage;
} // MC4Document::SetImage.

void MC4Document::InStreamCore (CArchive& ar, BOOL bIsFcore)
{
	// _xZkqqHx_iDhHiDgCiDfPiPoOjFpBiCmMjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
	m_headerInf->InStream(ar);
	// _xZkqqHx_iDhHiDgCiDfPjDmHiCnNiNjOiCnNiCmMiCnNiCmIiCoHjFjMiLeBiBeC_xHqqkZx_
	if (m_bHeaderLoadOnly) return;
	if (bIsFcore)
	//----- _xZkqqHx_iDhEiDiJiDgCiDgHiDfCiDeBiCmMiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiDfEiDeDiDfJ_xHqqkZx_(_xZkqqHx_iDgPiDeDiDgHjAjE_xHqqkZx_)_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//		long lDocPropertySize;
//		ar >> lDocPropertySize;
//		// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiDgPiDgCiDhEiDeAiCmJjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//		m_vDocProperty.resize(lDocPropertySize);
//		if (lDocPropertySize != 0)
//			ar.Read(&m_vDocProperty[0], lDocPropertySize);
//----- 06.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// DD_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiDfIiDgHiDiKiBfLiDiAiCmMjDmHiCnNiPgPiClFiBeC_xHqqkZx_
		long lStreamSize;
		ar >> lStreamSize;
		if (lStreamSize != 0)
		{
			BYTEVector vStream(lStreamSize);
			ar.Read(&vStream[0], vStream.size());
			FFGetMolipBaseI()->GetDocument()->StreamToDocumentProperty(	m_wstrDocumentProperty,
																	FD_DPID_END,
																	&vStream.front(),
																	lStreamSize);
		}
//----- 06.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	} else
	//----- _xZkqqHx_jFkBiNiHiDfCiDeBiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// ccore_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_PNG_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiCkKiDhHiDgCiDfPjClMiMoDiCmJjBhNjDpMiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
		// PNG_xZkqqHx_jCiGiCmM_xHqqkZx_iTXt_xZkqqHx_iDgAiDiDiDjDiDeOiCkJiCoHjFlGiPjBiDhGiDiNiDhAiDgFiDeCiCmMiCnNjDmHiCnNiNjOiCnNiBeBiOgDiCoIiCmN_xHqqkZx_
		// _xZkqqHx_iDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
		WString wstrDocumentProperty[FD_DPID_END];	// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiBeC_xHqqkZx_
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		FFUtilZlibPngI->PngRead32BitImageAndText(	ar, NULL, NULL,
//													wstrDocumentProperty,
//													sizeof(wstrDocumentProperty) / sizeof(wstrDocumentProperty[0]),
//													TRUE);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FFUtilZlibPngI->PngRead32BitImageAndText(	&ar,
													myFuncPngRead,
													myFuncPngError,
													myFuncPngWarning,
													NULL,
													NULL,
													wstrDocumentProperty,
													sizeof(wstrDocumentProperty) / sizeof(wstrDocumentProperty[0]),
													TRUE);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	// _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBjDjJiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	m_app->InStream(ar);
	// _xZkqqHx_iKmCiLkLiPoOjFpBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	m_env->InStream(ar);
	// _xZkqqHx_iDgDiBfLiDiLjAnNjCoIiPoOjFpBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	m_toolManager->InStream(ar);
	// _xZkqqHx_iDfGiBfLiDgHiBeBjFjEjFgJiPoOjFpBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	m_sheetManager->InStream(ar);
	// _xZkqqHx_iDiKiDjDiDeOiPoOjFpBiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
	m_linkManager->InStream(ar);
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiPoOjFpBiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
	m_reg->InStream(ar);
	// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIiPoOjFpBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	m_canvasStat->InStream(ar);
} // MC4Document::InStreamCore.

void MC4Document::OutStreamCore (CArchive& ar, BOOL bIsFcore)
{
	// _xZkqqHx_iDhHiDgCiDfPiPoOjFpBiCmMiPjBiCkLiPgPiClFiBeC_xHqqkZx_
	m_headerInf->OutStream(ar);
	if (bIsFcore)
	//----- _xZkqqHx_iDhEiDiJiDgCiDgHiDfCiDeBiCmMiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiDfEiDeDiDfJiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
//		const long lDocPropertySize = long(m_vDocProperty.size());
//		ar << lDocPropertySize;
//		if (lDocPropertySize != 0)
//			ar.Write(&m_vDocProperty[0], lDocPropertySize);
//----- 06.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// DD_xZkqqHx_jFlGiPjBiDhGiDiNiDhAiDgFiDeCiDfIiDgHiDiKiBfLiDiAiCmMiPjBiCkLiNjOiCnNiBeC_xHqqkZx_
		BYTEVector vStream;
// 06.05.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		g_pMolipMainI->GetDocument()->DocumentPropertyToStream(vStream, m_wstrDocumentProperty, FD_DPID_END);
		FFGetMolipBaseI()->GetDocument()->DocumentPropertyToStream(vStream, m_wstrDocumentProperty, FD_DPID_END);
		ar << long(vStream.size());
		ar.Write(&vStream.front(), vStream.size());
//----- 06.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	} else
	//----- _xZkqqHx_jFkBiNiHiDfCiDeBiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// ar_xZkqqHx_iCmJ_xHqqkZx_PNG_xZkqqHx_iDgGiBfLiDfOiCmMjAoGjDkKiCkJiCoH_xHqqkZx_mdRw_xZkqqHx_iDgAiDiDiDjDiDeOiCmMjClMjBePiCnMiCmFiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		FCPngWriteStruct* ps = FFUtilZlibPngI->PngWrite32Begin(	ar, &m_szImage, &m_vImageData.front(),
//																m_wstrDocumentProperty,
//																sizeof(m_wstrDocumentProperty) / sizeof(m_wstrDocumentProperty[0]));
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		const MfcSize mfcszImage(m_szImage.cx, m_szImage.cy);
		FCPngWriteStruct* ps = FFUtilZlibPngI->PngWrite32Begin(	&ar,
																myFuncPngWrite,
																myFuncPngFlush,
																myFuncPngError,
																myFuncPngWarning,
																&mfcszImage,
																&m_vImageData.front(),
																m_wstrDocumentProperty,
																sizeof(m_wstrDocumentProperty) / sizeof(m_wstrDocumentProperty[0]));
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		// ar_xZkqqHx_iCmJ_xHqqkZx_PNG_xZkqqHx_iCmMiPeJjCfLiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
		FFUtilZlibPngI->PngWrite32End(ps);
	}
	// _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBjDjJiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	m_app->OutStream(ar);
	// _xZkqqHx_iKmCiLkLiPoOjFpBiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	m_env->OutStream(ar);
	// _xZkqqHx_iDgDiBfLiDiLjAnNjCoIiPoOjFpBiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	m_toolManager->OutStream(ar);
	// _xZkqqHx_iDfGiBfLiDgHiBeBjFjEjFgJiPoOjFpBiCpAiPgPjHmNiBeC_xHqqkZx_
	m_sheetManager->OutStream(ar);
	// _xZkqqHx_iDiKiDjDiDeOiPoOjFpBiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	m_linkManager->OutStream(ar);
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiPoOjFpBiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	m_reg->OutStream(ar);
	// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIiCmMjFfMiOkGiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	m_canvasStat->OutStream(ar);
} // MC4Document::OutStreamCore.

//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4Document::LoadTemplate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFilePath	:_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL MC4Document::LoadTemplate (const wchar_t* wcpFilePath)
//{
//	// _xZkqqHx_jFjEjFgJjBkOjAkLiDfIiDgHiDiKiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
//	CArchive* ar = FFClassCreate((CArchive*)NULL);
//	ar->Initialize(wcpFilePath, FD_ARCHIVE_LOAD, this, TRUE);
//	// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiCmMiDhHiDgCiDfPiPoOjFpBiBeC_xHqqkZx_
//	m_headerInf->InStream(*ar);
//	// _xZkqqHx_iKmCiLkLjFnLjBlGjFmPjAjEiCpAjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
//	m_env->InStream(*ar);
//	// _xZkqqHx_iDgDiBfLiDiLjAnNjCoIiPoOjFpBiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	m_toolManager->InStream(*ar);
//	// _xZkqqHx_iDfGiBfLiDgHiBeBjFjEjFgJiPoOjFpBiCpAiPgPjHmNiBeC_xHqqkZx_
//	m_sheetManager->InStream(*ar);
//	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiPoOjFpBiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
//	m_reg->InStream(*ar);
//	// _xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCpAiNoNiPjMiBeC_xHqqkZx_
//	FFClassDelete(ar);
//	return TRUE;
//} // MC4Document::LoadTemplate.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4Document::SaveTemplate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFilePath	:_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL MC4Document::SaveTemplate (const wchar_t* wcpFilePath)
//{
//	// _xZkqqHx_jFjEjFgJjBkOjAkLiDfIiDgHiDiKiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
//	CArchive* ar = FFClassCreate((CArchive*)NULL);
//	ar->Initialize(wcpFilePath, FD_ARCHIVE_STORE, this, TRUE);
//	// _xZkqqHx_iDhHiDgCiDfPiPoOjFpBiCmMiPjBiCkLiPgPiClFiBeC_xHqqkZx_
//	m_headerInf->OutStream(*ar);
//	// _xZkqqHx_iKmCiLkLiPoOjFpBiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	m_env->OutStream(*ar);
//	// _xZkqqHx_iDgDiBfLiDiLjAnNjCoIiPoOjFpBiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	m_toolManager->OutStream(*ar);
//	// _xZkqqHx_iDfGiBfLiDgHiBeBjFjEjFgJiPoOjFpBiCpAiPgPjHmNiBeC_xHqqkZx_
//	m_sheetManager->OutStream(*ar);
//	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiPoOjFpBiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
//	m_reg->OutStream(*ar);
//	// _xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCpAjFmCiClGiCoJiBeCjFeLjAhLiBeC_xHqqkZx_
//	ar->Close();
//	// _xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCpAiNoNiPjMiBeC_xHqqkZx_
//	FFClassDelete(ar);
//	return TRUE;
//} // MC4Document::SaveTemplate.
//----- 06.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

void MC4Document::SetHeaderLoadOnly (BOOL bHeaderLoadOnly)
{
	// _xZkqqHx_iDhHiDgCiDfPjDmHiCnNiNjOiCnNiCmMiCnNiBeC_xHqqkZx_
	m_bHeaderLoadOnly = bHeaderLoadOnly;
} // MC4Document::SetHeaderLoadOnly.

const MC4HeaderInf* MC4Document::GetHeaderInfo () const
{
	return m_headerInf;
} // MC4Document::GetHeaderInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4Document::RegisterObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiClFiCkNjAlGjAkMiClDiCoKiClNjFjEjFgJiCpAiOhHjCoIiClFiClN_xHqqkZx_ID_xZkqqHx_iCmFjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jDgPjIfOiClHiCoJjFjEjFgJ_xHqqkZx_
 *			dwID	: _xZkqqHx_jDgPjIfOiClHiCoJjFjEjFgJiCmM_xHqqkZx_ID
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	ID_xZkqqHx_iCmMiPgEjFkBiCpAiDgAiDeGiDgCiDeOiClFiCmIiCkCiCmMiCmFiBeB_xHqqkZx_m_obppObjID2P_xZkqqHx_iCkKiClHiCnHiCmEiLpDiCmMiOjOiBeB_xHqqkZx_
 *			_xZkqqHx_iClHiCmIiCoNiClP_xHqqkZx_m_dwObjID2PNext = 0_xZkqqHx_iCmMiOjOiCmMiCnNiOgHjHhAiCmFiCkLiCoJiBeCjAfGiLeLiCmJiDhEiDeAiDeDiDiL_xHqqkZx_
 *			_xZkqqHx_iCpAiDiNiBfLiDgIiClHiCoJiOjOiCmMiCnNiCmGiNgMiCkGiCmEiCoGiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.14 Fukushiro M. _xZkqqHx_iDgFiBfLiDhFiDiLiCkK_xHqqkZx_NULL_xZkqqHx_iCmMiPiIjHjNiCpAjCmHiJmB_xHqqkZx_.ChipTbl::InStream_xZkqqHx_iCmMiInH_xHqqkZx_.
 *************************************************************************/
void MC4Document::RegisterObject (MC4ObjBase* pObj, DWORD dwID)
{
	ASSERT(m_mpIdToObj.find(dwID) == m_mpIdToObj.end());
	m_mpIdToObj[dwID] = pObj;
} // MC4Document::RegisterObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4Document::UnregisterObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpA_xHqqkZx_ID_xZkqqHx_jDgPjIfOiCkJiCoHiCmNiClIiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jFjEjFgJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.14 Fukushiro M. _xZkqqHx_iDgFiBfLiDhFiDiLiCkK_xHqqkZx_NULL_xZkqqHx_iCmMiPiIjHjNiCpAjCmHiJmB_xHqqkZx_.ChipTbl::InStream_xZkqqHx_iCmMiInH_xHqqkZx_.
 *************************************************************************/
void MC4Document::UnregisterObject (MC4ObjBase* pObj)
{
	// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iDgFiBfLiDhFiDiLiCkJiCoHjFjEjFgJiCpAiPjMiCkNiBeC_xHqqkZx_
	ASSERT(m_mpIdToObj.find(pObj->GetObjID()) != m_mpIdToObj.end());
	m_mpIdToObj.erase(pObj->GetObjID());
} // MC4Document::UnregisterObject.

/////////////////////////////////////////////////////////////////////////////
// MC4Document


MC4Document::MC4Document ()
{
	// OLE _xZkqqHx_jFkBiNiHiDhEiDeAiDeDiDiLiCpAiOgHjHhAiClFiCnMiClHiBeC_xHqqkZx_
	EnableCompoundFile();
	// _xZkqqHx_iDhHiDgCiDfPjDmHiCnNiNjOiCnNiCmMiCnNiBeC_xHqqkZx_
	m_bHeaderLoadOnly = FALSE;
	// _xZkqqHx_iDhHiDgCiDfPiPoOjFpBiBeC_xHqqkZx_
	m_headerInf = new MC4HeaderInf;
	// _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBjDjJiBeC_xHqqkZx_
	m_app = new MC4App;
	// _xZkqqHx_iKmCiLkLiPoOjFpBiBeC_xHqqkZx_
	m_env = new MC4Env;
	// _xZkqqHx_iDgDiBfLiDiLjAnNjCoIiPoOjFpBiBeC_xHqqkZx_
	m_toolManager = new MC4ToolManager;
	// _xZkqqHx_iDfGiBfLiDgHiBeBjFjEjFgJiPoOjFpBiBeC_xHqqkZx_
	m_sheetManager = new MC4SheetManager;
	// _xZkqqHx_iDiKiDjDiDeOiPoOjFpBiBeC_xHqqkZx_
	m_linkManager = new MC4LinkManager;
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiPoOjFpBiBeC_xHqqkZx_
	m_reg = new MC4Reg;
	// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIiPoOjFpBiBeC_xHqqkZx_
	m_canvasStat = new MC4CanvasStat;

//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iLpDiCmMjEjCjAeGiCmMiDeDiDiBiBfLiDfHiCpAiNoMjAkMiBeC_xHqqkZx_
	m_szImage = CSize(1, 1);
	long lImageSize = (m_szImage.cx * m_szImage.cy * 32) / 8;
	m_vImageData.assign(lImageSize, 1);
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.06.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgDiBfLiDiLiDhNiDgMiBfLiDfHiDiDiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_toolManager->Initialize(this);
//----- 05.06.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

} // MC4Document::MC4Document.

MC4Document::~MC4Document ()
{
	m_sheetManager->DeleteAll();

//----- 05.06.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgDiBfLiDiLiDhNiDgMiBfLiDfHiDiDiPeJjHlJiJlLiBeC_xHqqkZx_
//	m_toolManager->Terminate();
//----- 05.06.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIiPoOjFpBiBeC_xHqqkZx_
	delete m_canvasStat;
	m_canvasStat = NULL;
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiPoOjFpBiBeC_xHqqkZx_
	delete m_reg;
	m_reg = NULL;
	// _xZkqqHx_iDiKiDjDiDeOiPoOjFpBiBeC_xHqqkZx_
	delete m_linkManager;
	m_linkManager = NULL;
	// _xZkqqHx_iDfGiBfLiDgHiBeBjFjEjFgJiPoOjFpBiBeC_xHqqkZx_
	delete m_sheetManager;
	m_sheetManager = NULL;
	// _xZkqqHx_iDgDiBfLiDiLjAnNjCoIiPoOjFpBiBeC_xHqqkZx_
	delete m_toolManager;
	m_toolManager = NULL;
	// _xZkqqHx_iKmCiLkLiPoOjFpBiBeC_xHqqkZx_
	delete m_env;
	m_env = NULL;
	// _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBjDjJiBeC_xHqqkZx_
	delete m_app;
	m_app = NULL;
	// _xZkqqHx_iDhHiDgCiDfPiPoOjFpBiBeC_xHqqkZx_
	delete m_headerInf;
	m_headerInf = NULL;
} // MC4Document::~MC4Document.

BOOL MC4Document::OnNewDocument ()
{
	if (!COleServerDoc::OnNewDocument())
		return FALSE;
	return TRUE;
} // MC4Document::OnNewDocument.

COleServerItem* MC4Document::OnGetEmbeddedItem()
{
	// OnGetEmbeddedItem _xZkqqHx_iCmNiBeBiDgIiDeMiDiFiDiBiDjDiDgHiCmJiKnGjIeBjFhEiCkPiCoHiCoKiClN_xHqqkZx_ COleServerItem _xZkqqHx_iCpA_xHqqkZx_
	// _xZkqqHx_iOoGjDlOiClHiCoJiClNiCnPiCmJiDhEiDiMiBfLiDiAiDiPiBfLiDeOiCkJiCoHjFeLjHhGiCmIiPoKiNiHiCmJiCmMiCnNiMmEiCnBiPgPiClDiCoKiCnMiClHiBeC_xHqqkZx_

	// NULL _xZkqqHx_iCpAjFnEiClHjBoDiCoNiCoIiCmJiBeBiClBiCmMiDgIiDeMiDiFiDiBiDjDiDgHiCmJjIeBiMiLiClDiCoKiClN_xHqqkZx_ COleServerItem _xZkqqHx_iCmM_xHqqkZx_
	// _xZkqqHx_jEgIjAlGiDeOiDiJiDfIiCnGiCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiCoGiCkEiCmJjFmPiNfIiClFiCmEiJlKiClDiCkCiBeCiClLiCmMiMoDiBeBiImIiJlKiCmM_xHqqkZx_
	// ASSERT(FALSE) _xZkqqHx_iNhDiCpAiNoNiPjMiClFiCmEiJlKiClDiCkCiBeC_xHqqkZx_
	//  (_xZkqqHx_jHoB_xHqqkZx_: return new CMyServerItem)
	ASSERT(FALSE);			// _xZkqqHx_iPiIjHjNiLeMiPhBiMoDiBeBiNoNiPjMiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_
	return NULL;
}


BEGIN_MESSAGE_MAP(MC4Document, COleServerDoc)
	//{{AFX_MSG_MAP(MC4Document)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// MC4Document _xZkqqHx_jAgGjCgG_xHqqkZx_

#ifdef _DEBUG
void MC4Document::AssertValid() const
{
	COleServerDoc::AssertValid();
}

void MC4Document::Dump(CDumpContext& dc) const
{
	COleServerDoc::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// MC4Document _xZkqqHx_iDfGiDiKiDeBiDiJiDeDiDfJ_xHqqkZx_

void MC4Document::Serialize (CArchive& ar)
{
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJjBkOjAkLiDfIiDgHiDiKiBfLiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
//	CArchive* udar = FFClassCreate((CArchive*)NULL);
//	udar->Initialize(ar);
//	if (ar.IsStoring())
//	{
//		OutStreamCore(*udar, FALSE);
//		// _xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCpAiDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
//		udar->Flush();
//	}
//	else
//	{
//		InStreamCore(*udar, FALSE);
//	}
//	// _xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCpAiNoNiPjMiBeC_xHqqkZx_
//	FFClassDelete(udar);
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (ar.IsStoring())
	{
		OutStreamCore(ar, FALSE);
		// _xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCpAiDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
		ar.Flush();
	}
	else
	{
		InStreamCore(ar, FALSE);
	}
//----- 06.05.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // MC4Document::Serialize.

/////////////////////////////////////////////////////////////////////////////
// MC4Document _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_
