#include "stdafx.h"
#include "4LinkManager.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

MC4LinkManager::MC4LinkManager ()
{
} // MC4LinkManager::MC4LinkManager.

MC4LinkManager::~MC4LinkManager ()
{
	ClearAll();
} // MC4LinkManager::~MC4LinkManager.

void MC4LinkManager::InStream (CArchive& ar)
{
	// _xZkqqHx_jBfDiCmEiCmMjDoAjFjEiPoOjFpBiCpAjGjFiPmBiBeC_xHqqkZx_
	ClearAll();
	DWORD dwLinkID;
	for (;;)
	{
		// _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		ar >> dwLinkID;
		// _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCkKiPeJjHlJiDfCiBfLiDgIiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
		if (dwLinkID == DWORD(-1)) break;
		// _xZkqqHx_iDiKiDjDiDeOiCpAiNoMjAkMiBeC_xHqqkZx_
		MC4LinkRec* linkRec = new MC4LinkRec;
		// _xZkqqHx_iDiKiDjDiDeOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		ar.Read(linkRec, sizeof(*linkRec));
		// _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID->_xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCnGjDgPjIfOiBeC_xHqqkZx_
		ASSERT(m_mpIdToLinkRec.find(dwLinkID) == m_mpIdToLinkRec.end());
		m_mpIdToLinkRec[dwLinkID] = linkRec;
	}
} // MC4LinkManager::InStream.

void MC4LinkManager::OutStream (CArchive& ar)
{
	map<DWORD, MC4LinkRec*>::const_iterator iLr;
	for (iLr = m_mpIdToLinkRec.begin(); iLr != m_mpIdToLinkRec.end(); iLr++)
	{
		// _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
		DWORD dwLinkId = (*iLr).first;
		const MC4LinkRec* linkRec = (*iLr).second;
		// _xZkqqHx_iDiKiDjDiDeO_xHqqkZx_ID_xZkqqHx_iCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
		ar << dwLinkId;
		// _xZkqqHx_iDiKiDjDiDeOiDiMiDfCiBfLiDgIiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
		ar.Write(linkRec, sizeof(*linkRec));
	}
	// _xZkqqHx_iPeJjHlJiDfCiBfLiDgIiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	ar << DWORD(-1);
} // MC4LinkManager::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4LinkManager::ClearAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMiPoOjFpBiCpAiPmBiLiOiClFiBeBiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC4LinkManager::ClearAll ()
{
	// _xZkqqHx_iDiKiDjDiDeOiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	map<DWORD, MC4LinkRec*>::iterator iLr;
	for (iLr = m_mpIdToLinkRec.begin(); iLr != m_mpIdToLinkRec.end(); iLr++)
	{
		MC4LinkRec* linkRec = (*iLr).second;
		delete linkRec;
	}
	// _xZkqqHx_iDiBiDeDiDjDiDiKiDjDiDeOiDgFiBfLiDhFiDiLiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
	m_mpIdToLinkRec.clear();
} // MC4LinkManager::ClearAll.
