#ifndef __4NewFDObjAny_h
#define __4NewFDObjAny_h

#include "4ObjArc.h"
#include "4ObjChipMaster.h"
#include "4ObjPictArrow.h"
#include "4ObjGroup.h"
#include "4ObjLine.h"
#include "4ObjOle.h"
#include "4ObjPoly.h"
#include "4ObjPoint.h"
#include "4ObjRect.h"
#include "4ObjRoundRect.h"
#include "4ObjWidePoly.h"
#include "4ObjLabel.h"

inline MC4ObjBase* NewFDObjAny (FTObjectType nType)
{
	switch (nType)
	{
	case FDOJ_LINE:
		return new MC4ObjLine();
	case FDOJ_RECT:
		return new MC4ObjRect();
	case FDOJ_ROUND_RECT:
		return new MC4ObjRoundRect();
	case FDOJ_ARC:
		return new MC4ObjArc();
	case FDOJ_POLY:
		return new MC4ObjPoly();
	case FDOJ_GROUP:
		return new MC4ObjGroup();
	case FDOJ_WIDE_POLY:
		return new MC4ObjWidePoly();
	case FDOJ_OLE:
		return new MC4ObjOle();
	case FDOJ_CHIP_MASTER:
		return new MC4ObjChipMaster();
	case FDOJ_PICT_ARROW:
		return new MC4ObjPictArrow();
	case FDOJ_POINT:
		return new MC4ObjPoint();
	case FDOJ_LABEL:
		return new MC4ObjLabel();
	}
	return NULL;
} // NewFDObjAny.

#endif//__4NewFDObjAny_h
