#include "stdafx.h"
//#include "2Document.h"		// For MC2Document.
#include "2ObjOle.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif//SUPER_CLASS
#define SUPER_CLASS MC2ObjBase

//extern MC2MolipConvDllApp theApp;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjOle::MC2ObjOle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_FDFoundDoc_xZkqqHx_iCmM_xHqqkZx_InStream_xZkqqHx_iCmFjFeLjHhGiBeC_xHqqkZx_
 *************************************************************************/
MC2ObjOle::MC2ObjOle ()
{
	m_pOleItem = NULL;
	m_mmptLeftTop.x = 0;
	m_mmptLeftTop.y = 0;
	m_dRatioX = 1.0;		// OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmGiDhEiDiMiBfLiDiAiCmMiKgHiPgLjEoEiBeC_xHqqkZx_
	m_dRatioY = 1.0;		// OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmGiDhEiDiMiBfLiDiAiCmMiKgHiPgLjEoEiBeC_xHqqkZx_
} // MC2ObjOle::MC2ObjOle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	: _xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	: _xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *************************************************************************/
BOOL MC2ObjOle::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_OLE) return TRUE;
	return SUPER_CLASS::IsKindOf(nType);
} // MC2ObjOle::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjOle::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiMfOiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiCmMiMfO_xHqqkZx_
 *************************************************************************/
FTObjectType MC2ObjOle::Type () const
{
	return FDOJ_OLE;
} // MC2ObjOle::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjOle::OutStreamV3
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_MCARCHIVE
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	m_pOleItem_xZkqqHx_iCmNiDfGiDiKiDeBiDiJiDeDiDfJiCmMjFeLjHhGiCmNiCmIiCkCiBeCjDmHiCnNiNjOiCnNiOjOiCmJiCmNiBeB_xHqqkZx_
 *			Document_xZkqqHx_iCmMiDfGiDiKiDeBiDiJiDeDiDfJiCmFjAnNjCoIiClFiCmEiCkNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. MCARCHIVE_xZkqqHx_iCpA_xHqqkZx_MCARCHIVE_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void MC2ObjOle::OutStreamV3 (MCARCHIVE& ar)
{
	SUPER_CLASS::OutStreamV3(ar);

	ar << m_mmptLeftTop;	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmMiNlGiPoDiNmAjFfHiBeC_xHqqkZx_
	ar << m_dRatioX;		// OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmGiDhEiDiMiBfLiDiAiCmMiKgHiPgLjEoEiBeC_xHqqkZx_
	ar << m_dRatioY;		// OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmGiDhEiDiMiBfLiDiAiCmMiKgHiPgLjEoEiBeC_xHqqkZx_
	if (m_pOleItem != NULL)
	{
		ar << WORD(TRUE);
		// OLE_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCpAiLeMjIfOiBeC_xHqqkZx_
		ar << m_pOleItem;
	} else
	{
		ar << WORD(FALSE);
	}
} // MC2ObjOle::OutStreamV3.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjOle::InStreamV12
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_MCARCHIVE
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	m_pOleItem_xZkqqHx_iCmNiDfGiDiKiDeBiDiJiDeDiDfJiCmMjFeLjHhGiCmNiCmIiCkCiBeCjDmHiCnNiNjOiCnNiOjOiCmJiCmNiBeB_xHqqkZx_
 *			Document_xZkqqHx_iCmMiDfGiDiKiDeBiDiJiDeDiDfJiCmFjAnNjCoIiClFiCmEiCkNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. MCARCHIVE_xZkqqHx_iCpA_xHqqkZx_MCARCHIVE_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void MC2ObjOle::InStreamV12 (MCARCHIVE& ar)
{
	SUPER_CLASS::InStreamV12(ar);

	DBLRect mmrtResize;
	ar >> mmrtResize;		// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	// _xZkqqHx_iDhEiDiMiBfLiDiAiCmMiNlGiPoDiNmAjFfHiBeC_xHqqkZx_
	m_mmptLeftTop.x = mmrtResize.left;
	m_mmptLeftTop.y = mmrtResize.top;
	// OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmGiDhEiDiMiBfLiDiAiCmMiKgHiPgLjEoEiBeCiJlMiCmMjCgMiCmGiClFiCmEiBeB_xHqqkZx_ResizeFrame_xZkqqHx_iCmMjBoFiCkLiClDiCpAjAnNjCoIiBeC_xHqqkZx_
	m_dRatioX = mmrtResize.Width();
	m_dRatioY = mmrtResize.Height();
} // MC2ObjOle::InStreamV12.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjOle::~MC2ObjOle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *************************************************************************/
MC2ObjOle::~MC2ObjOle ()
{
	if (m_pOleItem != NULL)
	{
		// _xZkqqHx_iClBiClBiCmFiBeB_xHqqkZx_m_pOleItem->Delete();_xZkqqHx_iCpAiOmAiNhDiClFiClNiCkCiCmMiClOiCkKiBeBiClLiCkEiClHiCoJiCmG_xHqqkZx_
		// Molip_xZkqqHx_iCpA_xHqqkZx_OLE_xZkqqHx_iCmGiClFiCmEiDhJiBfLiDfIiDgHiClFiClNjAoGiCmMiDeBiDhGiDiKiCkJiCoHiBeB_xHqqkZx_Molip_xZkqqHx_iNmEjFnCiPfHiCkK_xHqqkZx_
		// _xZkqqHx_iCmFiCkLiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
		// OLE_xZkqqHx_iCmMiDfDiDhOiCmNiOgDiCoJiCkKiBeBiJoEjGjNiBeC_xHqqkZx_
		m_pOleItem = NULL;
	}
} // MC2ObjOle::~MC2ObjOle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjOle::SetOleClientItemAndRatio
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCmGiDfEiDeDiDfJjEoEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pItem	:OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRatioX	:_xZkqqHx_iDfEiDeDiDfJiCmM_xHqqkZx_X_xZkqqHx_jEoEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRatioY	:_xZkqqHx_iDfEiDeDiDfJiCmM_xHqqkZx_Y_xZkqqHx_jEoEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCmNiBeBiDfCiDhDiBfLiCpAiCmGiCoHiClIiCmJiClLiCmMiCnMiCnMjDoAjFjEiCmFiOgHjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2ObjOle::SetOleClientItemAndRatio (COleClientItem* pItem,
										double dRatioX, double dRatioY)
{
	m_pOleItem = pItem;
	m_dRatioX = dRatioX;
	m_dRatioY = dRatioY;
} // MC2ObjOle::SetOleClientItemAndRatio.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjOle::Resize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	: X_xZkqqHx_jFpLiMpMiCmMjElNjDfNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bYPosi	: Y_xZkqqHx_jFpLiMpMiCmMjElNjDfNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmrtNew	: _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfHiCpAiOhHjCoIiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2ObjOle::Resize (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew)
{
	// _xZkqqHx_iDhEiDiMiBfLiDiAiNlGiPoDiCpAjFmPiNfIiBeC_xHqqkZx_
	m_mmptLeftTop.x = mmrtNew.left;
	m_mmptLeftTop.y = mmrtNew.top;
	if (m_pOleItem != NULL)
	{
		CSize size = GetSize(m_pOleItem);
		// OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDfEiDeDiDfJiCkK_xHqqkZx_0_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_10_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_GetResizeFrame _xZkqqHx_iCmGiNiHiCoNiClJiCoJiBeC_xHqqkZx_
		// JW CAD _xZkqqHx_iCmFjDfMiCoIjFhEiCkPiClNiDgGiBfLiDfOiCmNiBeBiDfEiDeDiDfJiCmMjGoCiCkCiCkJiCkPiCmJ_xHqqkZx_0 _xZkqqHx_iCpAjFnEiClHiCoHiClFiCkCiBeC_xHqqkZx_
		if (size.cx == 0) size.cx = 10;
		if (size.cy == 0) size.cy = 10;
		//----- _xZkqqHx_iDfEiDeDiDfJjEoEjHkGiCpAiOfKiPgPiBeCjGjMiCkKiIoKiCpAiNgMiCkGiCmEiBeB_xHqqkZx_size _xZkqqHx_iCkK_xHqqkZx_ 0_xZkqqHx_iCmMiPoKiNiHiCpAiNgMjHlG_xHqqkZx_ -----
		m_dRatioX = mmrtNew.Width() / (double(size.cx) / g_dDisplayPPM);
		m_dRatioY = mmrtNew.Height() / (double(size.cy) / g_dDisplayPPM);
	} else
	{
		m_dRatioX = mmrtNew.Width();
		m_dRatioY = mmrtNew.Height();
	}
} // MC2ObjOle::Resize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjOle::GetResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jCgMiCmMjAlDiKgNiClDiCmGiOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *************************************************************************/
DBLRect MC2ObjOle::GetResizeFrame () const
{
	DBLRect mmrtResize(m_mmptLeftTop.x, m_mmptLeftTop.y, 0, 0);
	if (m_pOleItem != NULL)
	{
		CSize size = GetSize(m_pOleItem);
		// OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDfEiDeDiDfJiCkK_xHqqkZx_0_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiJlMiCmM_xHqqkZx_10_xZkqqHx_iCpAjAnNjCoIiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiBeB_xHqqkZx_
		// _xZkqqHx_iBhFiDeJiDhFiDfHiDeGiDeOiDgHiCpAjBhNjDpMiBhGiCmFiBhF_xHqqkZx_MolipDraw Document_xZkqqHx_iBhGiCpAjBeJjBpAiClFiClNiPoKiNiHiCmJ_xHqqkZx_
		// _xZkqqHx_iDfEiDeDiDfJiCkK_xHqqkZx_0_xZkqqHx_iCmJiCmIiCmBiCmEiClFiCnMiCkCiBeBjAlDiPoNiCmJjDkOiNoMiClFiCmIiCkCiBeC_xHqqkZx_
		if (size.cx == 0) size.cx = 10;
		if (size.cy == 0) size.cy = 10;
		// _xZkqqHx_iCfAjEhLiDfJiBfLiDiAiOjOiCmMjIfPjHjNiDfEiDeDiDfJiCpAiOmAiDfEiDeDiDfJiCmJjFmPiKlHiBeC_xHqqkZx_
		mmrtResize.right = mmrtResize.left + m_dRatioX * (double(size.cx) / g_dDisplayPPM);
		mmrtResize.bottom = mmrtResize.top + m_dRatioY * (double(size.cy) / g_dDisplayPPM);
	} else
	{
		mmrtResize.right = mmrtResize.left + m_dRatioX;
		mmrtResize.bottom = mmrtResize.top + m_dRatioY;
	}
	return mmrtResize;
} // MC2ObjOle::GetResizeFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjOle::Terminate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPeJjHlJiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_CommandGate_xZkqqHx_iCmFjFjEjFgJiCpAiNoNiPjMiClHiCoJjBePiCmJiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiOjOiBeBiDeBiDhGiDiKiPeJjHlJiOjOiCmJiCmNiOmAiNhDiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.11.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2ObjOle::Terminate ()
{
	if (m_pOleItem != NULL)
	{
		// OleClientItem_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_OleClientItem_xZkqqHx_iCmNiBeB_xHqqkZx_COleDocument_xZkqqHx_iCmFiKmHjHjNiClDiCoKiCmE_xHqqkZx_
		// _xZkqqHx_iCkCiCoJiCmMiCmFiBeB_xHqqkZx_Delete_xZkqqHx_iKnGjAjEiCmFiNoNiPjMiClHiCoJiBeC_xHqqkZx_
		m_pOleItem->Delete();
		m_pOleItem = NULL;
	}
} // MC2ObjOle::Terminate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjOle::GetOleClientItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OLE_xZkqqHx_iDeBiDeDiDgFiDiAiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	OLE_xZkqqHx_iDeBiDeDiDgFiDiA_xHqqkZx_
 *************************************************************************/
COleClientItem* MC2ObjOle::GetOleClientItem () const
{
	return m_pOleItem;
} // MC2ObjOle::GetOleClientItem.

CSize MC2ObjOle::GetSize (COleClientItem* pItem)
{
	CSize size(0,0);
	if (pItem->GetCachedExtent(&size))
	{
		// OLE _xZkqqHx_iCkJiCoHjFnEiClDiCoKiCoJiDfEiDeDiDfJiCmNiBeB_xHqqkZx_HIMETRIC _xZkqqHx_iDiGiDgKiDgCiDgHjCfAiImKiCmJiCmIiCmBiCmEiCkCiCnMiClHiBeCiDhDiDeOiDfKiDiLjCfAiImKiCmJjFmPiKlHiClFiCnMiClHiBeC_xHqqkZx_
		CClientDC dc(NULL);
		dc.HIMETRICtoDP(&size);
	}
	return size;
} // MC2ObjOle::GetSize.

