#include "stdafx.h"
#include <float.h>			// For DBL_MAX.
#include "3CanvasStat.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

MC3CanvasStat::MC3CanvasStat ()
{
	//----- _xZkqqHx_jCgMiCmMiPiJiKpKiJlL_xHqqkZx_ -----
	m_lZoom256	= 256;		// _xZkqqHx_iDfJiBfLiDiAjCgMiBeC_xHqqkZx_
	m_stid		= 0;		// _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_mmCenterX	= 0.0;		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjCiGjAfDiNmAjFfHiBeC_xHqqkZx_
	m_mmCenterY	= 0.0;		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjCiGjAfDiNmAjFfHiBeC_xHqqkZx_
} // MC3CanvasStat::MC3CanvasStat.

MC3CanvasStat::~MC3CanvasStat ()
{
} // MC3CanvasStat::~MC3CanvasStat.

void MC3CanvasStat::InStream (MCARCHIVE& ar)
{
	// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
	DWORD dwSize;
	ar >> dwSize;
	BYTEVector vStream(dwSize);
	ar.Read(&vStream.front(), dwSize);
	const BYTE* pStreamHead = &vStream.front();

//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	short nCenterX = 0;		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjCiGjAfDiChHiNmAjFfHiBeC_xHqqkZx_
//	short nCenterY = 0;		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjCiGjAfDiChIiNmAjFfHiBeC_xHqqkZx_
//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.03.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	m_mmCenterX = 0.0;
	m_mmCenterY = 0.0;
//----- 06.03.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	while (pStreamHead != &(*vStream.end()))
	{
		BYTE byType;
		ReadData(byType, pStreamHead);
		switch (byType)
		{
		case FDGLST_ZOOM:		// _xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
			ReadData(m_lZoom256, pStreamHead);
			break;
		case FDGLST_VIEW_POSITION:		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHiBeC_xHqqkZx_
		  {
			ReadData(m_stid, pStreamHead);
			if (g_nVersion == 3)
			//----- Version3.x_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
			{
				short nCenterX;		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjCiGjAfDiChHiNmAjFfHiBeC_xHqqkZx_
				short nCenterY;		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjCiGjAfDiChIiNmAjFfHiBeC_xHqqkZx_
				ReadData(nCenterX, pStreamHead);
				ReadData(nCenterY, pStreamHead);
//----- 06.03.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
				m_mmCenterX = mmetol(nCenterX);
				m_mmCenterY = mmetol(nCenterY);
//----- 06.03.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			} else
			//----- Version4.x_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
			{
				ReadData(m_mmCenterX, pStreamHead);
				ReadData(m_mmCenterY, pStreamHead);
			}
			break;
		  }
		default:
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjEgKjBlJiClFiCmEiCkCiCnMiClHiBeC_xHqqkZx_
// 06.02.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			AfxThrowArchiveException(CArchiveException::badIndex, NULL);
			FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
		}
	}
//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (g_nVersion == 3)
//	//----- Version3.x_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		double dZoom = FFUtilCoordI->GetZoom100() * double(m_lZoom256) / 256.0;
//		// _xZkqqHx_iDhCiDiFiBfLiDfEiDeDiDfJiCpA_xHqqkZx_ 1024 x 768 _xZkqqHx_iCmGiJlMjCoIiClFiCmEiBeBjCiGjAfDiNmAjFfH_xHqqkZx_(512, 384)_xZkqqHx_iCpAiJmBiOfKiClHiCoJiBeC_xHqqkZx_
//		m_mmCenterX = FFUtilCoordI->lg2mm(nCenterX + 512, dZoom);
//		m_mmCenterY = FFUtilCoordI->lg2mm(nCenterY + 384, dZoom);
//	}
//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // MC3CanvasStat::InStream.

void MC3CanvasStat::OutStream (MCARCHIVE& ar)
{
//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	short nCenterX = 0;		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjCiGjAfDiChHiNmAjFfHiBeC_xHqqkZx_
//	short nCenterY = 0;		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjCiGjAfDiChIiNmAjFfHiBeC_xHqqkZx_
//	if (g_nVersion == 3)
//	//----- Version3.x_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		double dZoom = FFUtilCoordI->GetZoom100() * double(m_lZoom256) / 256.0;
//		// _xZkqqHx_iDhCiDiFiBfLiDfEiDeDiDfJiCpA_xHqqkZx_ 1024 x 768 _xZkqqHx_iCmGiJlMjCoIiClFiCmEiBeBjCiGjAfDiNmAjFfH_xHqqkZx_(512, 384)_xZkqqHx_iCpAiJmBiOfKiClHiCoJiBeC_xHqqkZx_
//		nCenterX = short(FFUtilCoordI->mm2lg(m_mmCenterX, dZoom) - 512);
//		nCenterY = short(FFUtilCoordI->mm2lg(m_mmCenterY, dZoom) - 384);
//	}
//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDhCiDiFiBfLiCmMjFnCiPfHiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPgPjHmNiClHiCoJ_xHqqkZx_ -----
	BYTEVector vStream;
	//----- _xZkqqHx_jEhLjHkG_xHqqkZx_  ------
	vStream << BYTE(FDGLST_ZOOM);
	vStream << m_lZoom256;
	//----- _xZkqqHx_iDhCiDiFiBfLiImKjChF_xHqqkZx_ -----
	vStream << BYTE(FDGLST_VIEW_POSITION);
	vStream << m_stid;
	if (g_nVersion == 3)
	//----- Version3.x_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.03.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		short nCenterX = short(m_mmCenterX);		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjCiGjAfDiChHiNmAjFfHiBeC_xHqqkZx_
		short nCenterY = short(m_mmCenterY);		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjCiGjAfDiChIiNmAjFfHiBeC_xHqqkZx_
//----- 06.03.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		vStream << nCenterX;
		vStream << nCenterY;
	} else
	//----- Version4.x_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		vStream << m_mmCenterX;
		vStream << m_mmCenterY;
	}
	// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	ar << DWORD(vStream.size());
	// _xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiBeC_xHqqkZx_
	ar.Write(&vStream.front(), (long)vStream.size());
} // MC3CanvasStat::OutStream.
