#include "stdafx.h"
#include "resource.h"		// For IDS_.
#include "3ObjBase.h"		// For MC3ObjBase.
#include "3NewFDObjAny.h"	// For NewFDObjAny.
#include "3LayerManager.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3LayerRec::MC3LayerRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpName	:_xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wFlag	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiLjGiJmCiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pvLayer	:_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC3LayerRec::MC3LayerRec (const wchar_t* tcpName, WORD wFlag, MC3ObjBaseVector* pvLayer)
			: m_strName(tcpName), m_wFlag(wFlag), m_pvLayer(pvLayer)
{
} // MC3LayerRec::MC3LayerRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3LayerRec::Delete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiBeBiNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMiDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCmNiKePjFjEiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_jHfOiCkGiCoHiCoKiCoJiCmMiCmFiBeBiNoNiPjMiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC3LayerRec::Delete ()
{
	delete m_pvLayer;
	m_pvLayer = NULL;
} // MC3LayerRec::Delete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3LayerManager::MC3LayerManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpName			:_xZkqqHx_iDfGiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mpLZHash		:_xZkqqHx_iCgLiChJiDeJiBfLiDfPiBfL_xHqqkZx_->_xZkqqHx_iDiMiDeDiDiEiBfLiDgOiDgCiDfGiDiFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vBottomLayer	:_xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vTopLayer		:_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC3LayerManager::MC3LayerManager (MC3ObjBaseVector& vBottomLayer, MC3ObjBaseVector& vTopLayer)
{
	// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiBeC_xHqqkZx_
	CString strBtm;
	strBtm.LoadString(IDS_BOTTOM_LAYER);
	MC3LayerRec recBtm(TStrToWStr(strBtm), FDOZ_ON_DRAW, &vBottomLayer);
	// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiBeC_xHqqkZx_
	CString strTop;
	strTop.LoadString(IDS_TOP_LAYER);
	MC3LayerRec recTop(TStrToWStr(strTop), FDOZ_ON_DRAW, &vTopLayer);
	// _xZkqqHx_iNmFiJlKiImKiBeBiNmFiPoDiImKiDiMiDeDiDiEiBfLiCpAjAnNjCoIiBeC_xHqqkZx_
	m_vLayerTable.push_back(recBtm);
	m_vLayerTable.push_back(recTop);
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiNmFiPoDiImKiDiMiDeDiDiEiBfLiCmJjAnNjCoIiBeC_xHqqkZx_
	m_dwCurLayerIdx = DWORD(m_vLayerTable.size() - 1);
} // MC3LayerManager::MC3LayerManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3LayerManager::~MC3LayerManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC3LayerManager::~MC3LayerManager ()
{
	for (long lC = 1; lC < long(GetLayerSize()) - 1; lC++)
	{
		m_vLayerTable[lC].Delete();
	}
	m_vLayerTable.clear();
} // MC3LayerManager::~MC3LayerManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3LayerManager::DeleteAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjBfDiCmEiNoNiPjMiClFiBeBjDoAjHgFiCpAjBfDiCmEjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC3LayerManager::DeleteAll ()
{
	//----- _xZkqqHx_iDiMiDeDiDiEiBfLiDgFiBfLiDhFiDiLjCiGiCmMiKgFiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiNoNiPjM_xHqqkZx_ -----
	MC3ObjBaseVector::iterator iObj;
	for (long lC = 1; lC < long(GetLayerSize()) - 1; lC++)
	{
		MC3ObjBaseVector* pvObj = GetObjOrder(lC);
		// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiNoNiPjMiBeC_xHqqkZx_
		for (iObj = pvObj->begin(); iObj != pvObj->end(); iObj++)
		{
			delete *iObj;
		}
		// _xZkqqHx_iDiMiDeDiDiEiBfLiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
		m_vLayerTable[lC].Delete();
	}
	// _xZkqqHx_iDiMiDeDiDiEiBfLiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_vLayerTable.clear();
} // MC3LayerManager::DeleteAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3LayerManager::GetName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString& MC3LayerManager::GetName ()
{
	return m_strName;
} // MC3LayerManager::GetName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3LayerManager::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPgPjHmNjAoGiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC3LayerManager::OutStream (MCARCHIVE& ar) const
{
	// _xZkqqHx_iDfGiBfLiDgHjGlMiCpAiPgPjHmNiBeC_xHqqkZx_
	WriteString(ar, m_strName);
	//----- _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLiCmMiLeMjIfO_xHqqkZx_ -----
	MC3ObjBaseVector::iterator iObj;
	// _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << DWORD(m_vLayerTable.size() - 2);
	for (DWORD dwC = 1; dwC < m_vLayerTable.size() - 1; dwC++)
	{
		// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAiPgPjHmNiBeC_xHqqkZx_
		WriteString(ar, m_vLayerTable[dwC].m_strName);
		// _xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
		ar << m_vLayerTable[dwC].m_wFlag;
		// _xZkqqHx_jFjEjFgJjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
		ar << DWORD(m_vLayerTable[dwC].m_pvLayer->size());
		for (iObj = m_vLayerTable[dwC].m_pvLayer->begin();
			 iObj != m_vLayerTable[dwC].m_pvLayer->end(); iObj++)
		{
			// _xZkqqHx_jFjEjFgJiDfOiDeDiDhGiBjFjFjEjFgJiCpAiLeMjIfOiBeC_xHqqkZx_
			ar << BYTE((*iObj)->Type());
			(*iObj)->OutStream(ar);
		}
	}
	// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_vLayerTable.front().m_wFlag;
	// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_vLayerTable.back().m_wFlag;
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_dwCurLayerIdx;
} // MC3LayerManager::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3LayerManager::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDpMjHmNiMlDiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC3LayerManager::InStream (MCARCHIVE& ar)
{
	ASSERT(m_vLayerTable.size() == 2);
	// _xZkqqHx_iDfGiBfLiDgHjGlMiCpAjDpMjHmNiBeC_xHqqkZx_
	ReadString(ar, m_strName);
	//----- _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLiCmMjDgPjIfO_xHqqkZx_ -----
	WORD wFlag;
	WString wstrName;
	DWORD dwLayerSz;
	DWORD dwObjSz;
	BYTE byType;
	MC3ObjBase* pObj;
	// _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
	ar >> dwLayerSz;
	for (DWORD dwLayerC = 1; dwLayerC <= dwLayerSz; dwLayerC++)
	{
		// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAjDpMjHmNiBeC_xHqqkZx_
		ReadString(ar, wstrName);
		// _xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAjDpMjHmNiBeC_xHqqkZx_
		ar >> wFlag;
		// _xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_1_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		InsertLayer(dwLayerC, wstrName.c_str(), wFlag);
		// _xZkqqHx_jFjEjFgJjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
		ar >> dwObjSz;
		for (DWORD dwObjC = 0; dwObjC < dwObjSz; dwObjC++)
		{
			ar >> byType;
			pObj = NewFDObjAny(FTObjectType(byType));
			pObj->InStream(ar);
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiDgFiBfLiDhFiDiLiCmJiLkNjAkHjDgPjIfOiBeCiDePiDiLiBfLiDhGiCmMiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiCoAjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
			pObj->RegisterObjForceID();
			// _xZkqqHx_jFjEjFgJiCpAiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiCmJjDgPjIfOiBeC_xHqqkZx_
			AppendToLZOrder(dwLayerC, pObj);
		}
	}
	// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> m_vLayerTable.front().m_wFlag;
	// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> m_vLayerTable.back().m_wFlag;
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> m_dwCurLayerIdx;
} // MC3LayerManager::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3LayerManager::InsertLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMiJlKiCmJiDiMiDeDiDiEiBfLiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_jBhNjDpMiClHiCoJiDiMiDeDiDiEiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeCjBhNjDpMiMoDiBeBiClBiCmM_xHqqkZx_
 *						 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmJiCmIiCoJiBeC_xHqqkZx_
 *			tcpName, wFlag	:_xZkqqHx_iDiMiDeDiDiEiBfLiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC3LayerManager::InsertLayer (DWORD dwLayerIdx, const wchar_t* tcpName, WORD wFlag)
{
	m_vLayerTable.insert(m_vLayerTable.begin() + dwLayerIdx,
						MC3LayerRec(tcpName, wFlag, new MC3ObjBaseVector));
} // MC3LayerManager::InsertLayer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3LayerManager::AppendToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_jCmHiJmBiClHiCoJiDiMiDeDiDiEiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObj		:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC3LayerManager::AppendToLZOrder (DWORD dwLayerIdx, MC3ObjBase* pObj)
{
	// _xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCmM_xHqqkZx_ZOrder_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_
	DWORD dwZOrder = (DWORD)GetObjOrder(dwLayerIdx)->size();
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiNmFiMoDiCmJjCmHiJmBiBeC_xHqqkZx_
	GetObjOrder(dwLayerIdx)->push_back(pObj);
} // MC3LayerManager::AppendToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3LayerManager::GetLayerSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD MC3LayerManager::GetLayerSize () const
{
	return (DWORD)m_vLayerTable.size();
} // MC3LayerManager::GetLayerSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3LayerManager::GetObjOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDeDiDiEiBfLiCmMjFjEjFgJjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC3ObjBaseVector* MC3LayerManager::GetObjOrder (DWORD dwLayerIdx) const
{
	return m_vLayerTable[dwLayerIdx].m_pvLayer;
} // MC3LayerManager::GetObjOrder.

