/*
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is "SVG Export" plug-in for DynamicDraw.

The Initial Developer of the Original Code is FUKUSHIRO Masayuki.

Copyright (C) 2001,2002  FUKUSHIRO Masayuki ( yt3m-fksr@asahi-net.or.jp ), 
HIROSAWA Masashi ( hirosawa@cam.hi-ho.ne.jp ). 
All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms
of the GNU General Public License Version 2 (the "GPL"), in which case
the provisions of the GPL are applicable instead of those above.  If you
wish to allow use of your version of this file only under the terms of
the GPL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the
GPL.

Alternatively, the contents of this file may be used under the terms
of the New BSD License (the "BSDL"), in which case the provisions
of the BSDL are applicable instead of those above.  If you wish
to allow use of your version of this file only under the terms of
the BSDL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the BSDL.

If you do not delete the provisions above, a recipient may use
your version of this file under any of the MPL, the GPL or the BSDL.
*/

#include "stdafx.h"
#include "Module.h"			// For FMpgGetModule().
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#include "MpgExtern.h"		// For Global.
//#include "DBLMath.h"		// For DBLPoint.
//#include "DBLPoint.h"		// For DBLPoint.
//#include "DBLRect.h"		// For DBLRect.
//#include "FCLinkManagerExpType.h"	// For FCLinkRecVector.
//#include "FCObjectExp.h"	// For FC_objectExp.
//#include "FCEnvExpType.h"	// For FCEnvExp.h.
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

#include "png.h"
#include "PrintSVGOLEProcess.h"
#include "SvgExportOption.h"
#include "SvgExportInfo.h"

#define D2L(a)  (0 < (a) ? (long)((a) + 0.5) : (long)((a) - 0.4))

// _xZkqqHx_iDfIiDeKiDiJiBfLjCgMiCmMjFmPiKlHiBeCjIfPjHjNiNmAjFfHjCgM_xHqqkZx_(pixel)_xZkqqHx_iCkJiCoHiOmAiNmAjFfHjCgM_xHqqkZx_(mm)_xZkqqHx_iCnGjFmPiKlHiBeC_xHqqkZx_
inline double lg2mm (long a, double dZoom)
{
	return static_cast<double>(a) / dZoom;
}

// _xZkqqHx_iDfIiDeKiDiJiBfLjCgMiCmMjFmPiKlHiBeCiOmAiNmAjFfHjCgM_xHqqkZx_(mm)_xZkqqHx_iCkJiCoHjIfPjHjNiNmAjFfHjCgM_xHqqkZx_(pixel)_xZkqqHx_iCnGjFmPiKlHiBeC_xHqqkZx_
inline long mm2lg (double a, double dZoom)
{
	return D2L(dZoom * a);
}

// OnDraw_xZkqqHx_iCmMjBePiPiIjHjN_xHqqkZx_
int PrintSvgOLEProcess::preprocess( FCObjDynabase *objectExp ) {

	// mm_xZkqqHx_iDfEiDeDiDfJ_xHqqkZx_
	mmRect = objectExp->GetOuterFrame();

// 06.07.03 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	double zoom = FFGetMolipBaseI()->GetZoom();

	// _xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjEiCmJiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLjFgAiJoGiCmFiCkAiCoJiClBiCmGiCpAjAnNjCoIiBeC_xHqqkZx_
	drawWhichBack = FFGetMolipBaseI()->SetDrawWhich(FDDR_ENHANCED_METAFILE);

	//------ _xZkqqHx_jFfHiPiAiCmMjAlIjDhIiCmF_xHqqkZx_Viewport_xZkqqHx_iDfEiDeDiDfJiCpAiMhGiOfK_xHqqkZx_ -----
	zoomBackup = FFGetMolipBaseI()->SetZoom(FFGetMolipBaseI()->GetDisplayPPM());
// 06.07.03 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	const double zoom = FFGetMolipBaseI()->GetZoom();

	//----- _xZkqqHx_jFgAiJoGiDeJiDhEiDfKiDgCiDgHjCgMiCpAjAnNjCoI_xHqqkZx_ -----
	offsetX = FFGetMolipBaseI()->SetOffsetX( mm2lg( mmRect.left, zoom ) );
	offsetY = FFGetMolipBaseI()->SetOffsetY( mm2lg( mmRect.top, zoom ) );

	// _xZkqqHx_iJoGjGmKjFgAiJoGjHhAiDhAiDiMiDgCiDgHiCpAiJpAiPjMiBeCiDhAiDiMiDgCiDgHjGlDiClFiCmJiBeC_xHqqkZx_
	pPal = FFGetMolipBaseI()->SetPalette(NULL);

	// _xZkqqHx_jFgAiJoGiClHiCoJiDhDiDeOiDfKiDiLiImKjChF_xHqqkZx_
	pxWidth = mm2lg(mmRect.right - mmRect.left, zoom );
	pxHeight = mm2lg(mmRect.bottom - mmRect.top, zoom );

	// CDC_xZkqqHx_iPiAjEpF_xHqqkZx_
	if ( 0 == dc.CreateCompatibleDC( NULL ) ) {
		return SVGEXPORT_ERROR;
	}
	if ( 0 == bmp.CreateBitmap( pxWidth, pxHeight, dc.GetDeviceCaps( PLANES ), dc.GetDeviceCaps( BITSPIXEL), NULL ) ) {
		return SVGEXPORT_ERROR;
	}
	oldBmp = dc.SelectObject( &(bmp) );

	// _xZkqqHx_iCmGiCoIiCkAiCkGiClIjEjCiCmFiDeOiDiKiDeBiClFiCmEiCkIiCkN_xHqqkZx_
	dc.FillSolidRect( 0, 0, pxWidth, pxHeight, RGB(255,255,255) );

	return SVGEXPORT_OK;

} // end of printSvgOLE_preprocess




// OnDraw_xZkqqHx_iCmMiMoDiPiIjHjN_xHqqkZx_
void PrintSvgOLEProcess::postprocess() {

	// _xZkqqHx_iDhAiDiMiDgCiDgHiCpAjGnPiClHiBeC_xHqqkZx_
	FFGetMolipBaseI()->SetPalette( pPal );

	//----- _xZkqqHx_jFgAiJoGiDeJiDhEiDfKiDgCiDgHiCpAjGnPiClH_xHqqkZx_ -----
	FFGetMolipBaseI()->SetOffsetX( offsetX );
	FFGetMolipBaseI()->SetOffsetY( offsetY );

	// _xZkqqHx_iDfJiBfLiDiAiCpAjGnPiClHiBeC_xHqqkZx_
	FFGetMolipBaseI()->SetZoom( zoomBackup );

	// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLjFgAiJoGiPeJjHlJiClFiBeBiMlDiCmJjGnPiClHiBeC_xHqqkZx_
	FFGetMolipBaseI()->SetDrawWhich( drawWhichBack );

	// _xZkqqHx_jEePiCmMiClNiCnP_xHqqkZx_
	dc.SelectObject( oldBmp );

} // end of printSvgOLE_postprocess


// _xZkqqHx_iOhHjCoIjAeGiCkKiOgHiCoNiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJ_xHqqkZx_
bool PrintSvgOLEProcess::isUsedColor( int r, int g, int b ) {

	for ( int y = 0; y < pxHeight; y++ ) {
		for ( int x = 0; x < pxWidth; x++ ) {
			if ( 0 == x && y == 0 ) continue;
			//if ( RGB( r, g, b ) == dc.GetPixel( x, y ) ) {
			COLORREF c = dc.GetPixel( x, y );
			if ( RGB( r, g, b ) == c ) {
				return true;
			}
		} // for x
	} // for y

	return false;

} // end of isUsedColor


// _xZkqqHx_jDkHjGlOjAeGiCpAjCfEiClH_xHqqkZx_
int PrintSvgOLEProcess::findTransparentColor( COLORREF *transColor ) {

	int r = 255, g = 255, b = 255;
	COLORREF color, setColor, prevColor = RGB( r, g, b );

	for ( r = 0xff; -1 < r; r-- ) {
		// _xZkqqHx_iClNiCnEiCpB_xHqqkZx_bit_xZkqqHx_jAjEiCpAiMkJiCoKiCmOiMiIiCnPjBmFiClPiCmFiCoCiCmBiCmEiCoAjHmHiCkCiCmGiOhGiCkEiCkKiBeBjEePiCmMiClNiCnP_xHqqkZx_
		// CBitmap_xZkqqHx_iCmFjFmPiJlLiClHiCoJjAeGiCpAjDlOiCoJ_xHqqkZx_
		color = RGB( r, g, b );
		setColor = dc.SetPixel( 0, 0, color );
		if ( GetRValue(setColor) == GetRValue(prevColor) ) {
			continue;
		}
		prevColor = setColor;
		for ( g = 0xff; -1 < g; g-- ) {
			color = RGB( r, g, b );
			setColor = dc.SetPixel( 0, 0, color );
			if ( GetGValue(setColor) == GetGValue(prevColor) ) {
				continue;
			}
			prevColor = setColor;
			for ( b = 0xff; -1 < b; b-- ) {
				color = RGB( r, g, b );
				setColor = dc.SetPixel( 0, 0, color );
				if ( setColor == prevColor ) {
					continue;
				}
				prevColor = setColor;
				if ( false == isUsedColor( GetRValue(setColor), GetGValue(setColor), GetBValue(setColor) ) ) {
					*transColor = setColor;
					return SVGEXPORT_OK;
				}
			} // for b
		} // for g
	} // for r

	return SVGEXPORT_ERROR;

} // end of findTransparentColor



// _xZkqqHx_jDkHjGlOjAeGiPiIjHjN_xHqqkZx_
int PrintSvgOLEProcess::processTransparentColor( COLORREF *transColor, FCObjDynabase *objectExp ) {

	// _xZkqqHx_jDkHjGlOjAeGiCpAjCfEiClH_xHqqkZx_
	if ( findTransparentColor( transColor ) ) {
		return SVGEXPORT_ERROR;
	}
	//trans16Values->red = 240 << 8; 
	//trans16Values->green = 0x00 << 8;
	//trans16Values->blue = 0x00 << 8;
	//*transColor = RGB( 0xff, 00, 00 );

	// _xZkqqHx_jDkHjGlOjAeGiCmFiDeOiDiKiDeB_xHqqkZx_
	dc.FillSolidRect( 0, 0, pxWidth, pxHeight, *transColor );

	//trans16Values->red = 248 << 8; 

	// _xZkqqHx_jFgAiJoG_xHqqkZx_
//----- 06.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	objectExp->OnDraw( &dc, false );
//----- 06.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	objectExp->OnDraw( MfcDC::FromHandle(dc.GetSafeHdc()), false );
	MfcDC::DeleteTempMap();
//----- 06.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	COLORREF color2 = dc.GetPixel( 0, 0 );

	return SVGEXPORT_OK;

} // end of processTransparentColor
