#ifndef __DBLShortLine_h
#define __DBLShortLine_h

/**********************************************************************
 * class DBLShortLine
 **********************************************************************/
//;----- <EXPORT TO SDK> -----;
class DBLShortLine
{
//;----- </EXPORT TO SDK> -----;
public:
	DBLShortLine ();
	DBLShortLine (mmetol mmOx, mmetol mmOy, mmetol mmPx, mmetol mmPy);
	DBLShortLine (const DBLPoint& O, const DBLPoint& P);
	void	SetPoints (const DBLPoint& O, const DBLPoint& P);
	BOOL	IsVertical () const;
	BOOL	IsHorizontal () const;
	BOOL	CrossPoint (DBLPoint& P, const DBLShortLine& L) const;
	BOOL	CrossPoint (DBLPoint& ptP, const DBLLine& lnL);
	BOOL	IsInside (const DBLPoint& ptP) const;

//;----- <EXPORT TO SDK> -----;
public:
	DBLPoint	pt0;
	DBLPoint	pt1;
}; // class DBLShortLine.
//;----- </EXPORT TO SDK> -----;

/**********************************************************************
 * class DBLShortLine
 **********************************************************************/
inline DBLShortLine::DBLShortLine () {}

inline DBLShortLine::DBLShortLine (mmetol mmOx, mmetol mmOy, mmetol mmPx, mmetol mmPy)
					: pt0(mmOx, mmOy), pt1(mmPx, mmPy) {}

inline DBLShortLine::DBLShortLine (const DBLPoint& O, const DBLPoint& P)
					: pt0(O), pt1(P)
{
} // DBLShortLine::DBLShortLine.

inline void DBLShortLine::SetPoints (const DBLPoint& O, const DBLPoint& P)
{
	pt0 = O;
	pt1 = P;
} // DBLShortLine::SetPoints.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLShortLine::IsVertical
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMiCkKjAiCjClMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_jAiCjClM_xHqqkZx_
 *			FALSE	: _xZkqqHx_jAiCjClMiCmFiCmNiCmIiCkC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL DBLShortLine::IsVertical () const
{
	return (almosteq(pt0.x, pt1.x) && !almosteq(pt0.y, pt1.y));
} // DBLShortLine::IsVertical.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLShortLine::IsHorizontal
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMiCkKjAiFjFlNiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_jAiFjFlN_xHqqkZx_
 *			FALSE	: _xZkqqHx_jAiFjFlNiCmFiCmNiCmIiCkC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL DBLShortLine::IsHorizontal () const
{
	return (!almosteq(pt0.x, pt1.x) && almosteq(pt0.y, pt1.y));
} // DBLShortLine::IsHorizontal.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLShortLine::CrossPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjApMjFkKiCmGiIpIjAjE_xHqqkZx_L_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiCoJjApMjFkKiCkKiMpAiNlHiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *			P_xZkqqHx_iCmJiMpAiNlHiClHiCoJjDfPiCmMiNmAjFfHiCpAjAnNjCoIiClF_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiBeCiMpAiNlHiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	P	:_xZkqqHx_iMpAiNlHiClHiCoJjDfPiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			L	:_xZkqqHx_jApMjFkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_iMpAiNlHiClHiCoJiPoKiNiHiBeC_xHqqkZx_
 *			FALSE	:_xZkqqHx_iMpAiNlHiClFiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMpAjDfPiCgPiCpAiLiBiCnPiCoJiJiJiOfKiBgJ_xHqqkZx_Lab & Lcd_xZkqqHx_iBgKiCmFiMoLiNlHiCkKjAlGiClGiCoJiClNiCnPiBeBiMlFjGkHiCmJ_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCoJiClBiCmGiCmNiPgPjHiIiCmIiCkCiBeCiMpAiNlHiClHiCoJjFpLiCmJiPkNiClFiKmDiCkNjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCmCiCnMiCoIiBeBiMlFjGkHiCmJiMkJiCoJiCmGiMpAiNlHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmFiCoAiBeBiMpAiNlHiClFiCmEiCkCiCoJiCmG_xHqqkZx_
 *			_xZkqqHx_jElLjCgGiClHiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.22 Fukushiro M. _xZkqqHx_jEpHjGkNiCmIiPoKiNiHiCmNiMpAiNlHiClFiCmEiCkCiCoJiCoGiCkEiCmJjElLjCgGiBeC_xHqqkZx_
 *************************************************************************/
inline BOOL DBLShortLine::CrossPoint (DBLPoint& P, const DBLShortLine& L) const
{
	DBLLine	Lab(pt0, pt1);
	DBLLine Lcd(L.pt0, L.pt1);
	if (Lab == Lcd)
	//----- _xZkqqHx_iCfBjApMiCkKjDkPiIoKjApMiCmFiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		DBLPoint	a,  b,  c,  d;
		double		a0, b0, c0, d0;
		if (Lab.IsVertical())
		//----- _xZkqqHx_iClDiCoHiCmJiClBiCmMjApMjFkKiCkKjAiCjApMiCmFiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (pt0.y < pt1.y)
			{
				a	= pt0;
				b	= pt1;
				a0	= pt0.y;
				b0	= pt1.y;
			} else
			{
				a	= pt1;
				b	= pt0;
				a0	= pt1.y;
				b0	= pt0.y;
			}
			if (L.pt0.y < L.pt1.y)
			{
				c	= L.pt0;
				d	= L.pt1;
				c0	= L.pt0.y;
				d0	= L.pt1.y;
			} else
			{
				c	= L.pt1;
				d	= L.pt0;
				c0	= L.pt1.y;
				d0	= L.pt0.y;
			}
		} else
		{
			if (pt0.x < pt1.x)
			{
				a	= pt0;
				b	= pt1;
				a0	= pt0.x;
				b0	= pt1.x;
			} else
			{
				a	= pt1;
				b	= pt0;
				a0	= pt1.x;
				b0	= pt0.x;
			}
			if (L.pt0.x < L.pt1.x)
			{
				c	= L.pt0;
				d	= L.pt1;
				c0	= L.pt0.x;
				d0	= L.pt1.x;
			} else
			{
				c	= L.pt1;
				d	= L.pt0;
				c0	= L.pt1.x;
				d0	= L.pt0.x;
			}
		}
		if (a0 <= d0 && d0 <= b0)
		{
			P	= d;
			return TRUE;
		}
		if (a0 <= c0 && c0 <= b0)
		{
			P	= b;
			return TRUE;
		}
		if (c0 <= a0 && b0 <= d0)
		{
			P	= b;
			return TRUE;
		}
		return FALSE;
	}
	if (Lab || Lcd)
	//----- _xZkqqHx_iCfBjApMiCkKjFlNiNhDiCmFiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		return FALSE;
	}
	// _xZkqqHx_iMpAjDfPiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	P = Lab & Lcd;
	if (Lab.IsVertical())
	{
		if (almostless((P.y - pt0.y) * (pt1.y - P.y), 0.0)) return FALSE;
	} else
	{
		if (almostless((P.x - pt0.x) * (pt1.x - P.x), 0.0)) return FALSE;
	}
	if (Lcd.IsVertical())
	{
		if (almostless((P.y - L.pt0.y) * (L.pt1.y - P.y), 0.0)) return FALSE;
	} else
	{
		if (almostless((P.x - L.pt0.x) * (L.pt1.x - P.x), 0.0)) return FALSE;
	}
	return TRUE;
} // DBLShortLine::CrossPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLShortLine::CrossPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[pt0, pt1)_xZkqqHx_iCmMjApMjFkKiCmG_xHqqkZx_lnL_xZkqqHx_iCkKiMpAiNlDiClHiCoJjDfP_xHqqkZx_ptP_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ptP	:_xZkqqHx_iMpAiNlDiClHiCoJjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *			lnL	:_xZkqqHx_jClMjApM_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiNlDiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE, _xZkqqHx_iMpAiNlDiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL DBLShortLine::CrossPoint (DBLPoint& ptP, const DBLLine& lnL)
{
	DBLLine lnM(pt0, pt1);
	if (lnM || lnL)
	/*----- _xZkqqHx_jDpBiCmCiCmMjApMiCkKjFlNiNhDiCmMiPoKiNiH_xHqqkZx_ -----*/
	{
		if (lnM == lnL)
		/*---- _xZkqqHx_jDpBiCmCiCmMjApMiCkKjDkPiIoKiCmMiPoKiNiH_xHqqkZx_ -----*/
		{
			ptP = pt0;
			return TRUE;
		}
		return FALSE;
	}
	// _xZkqqHx_iCfBjApMiCmMiMpAiNlDjDfPiCpAiLiBiCnPiCoJ_xHqqkZx_.
	ptP = lnM & lnL;

	if (lnM.IsVertical())
	{
		return (pt0.y <= ptP.y && ptP.y < pt1.y) ||
					(pt1.y < ptP.y && ptP.y <= pt0.y);
	}
	if (lnM.IsHorizontal())
	{
		return (pt0.x <= ptP.x && ptP.x < pt1.x) ||
					(pt1.x < ptP.x && ptP.x <= pt0.x);
	}
	// x_xZkqqHx_iOlCiBeB_xHqqkZx_y_xZkqqHx_iOlCjHlMjFpLiCmJiKnGiClFiCmEjBoFiPkMiKnGiMfHiCpAjClCiCnHiCoJiCmMiCmNiBeBjEpHjGkNiCmIiDgPiDiJiDjDiDfIiCmF_xHqqkZx_
	// _xZkqqHx_jFnAjFpLiCmMiOlCiClOiCkPiCmFiCmNiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
	return (pt0.x <= ptP.x && ptP.x < pt1.x) ||
			(pt1.x < ptP.x && ptP.x <= pt0.x) ||
			(pt0.y <= ptP.y && ptP.y < pt1.y) ||
			(pt1.y < ptP.y && ptP.y <= pt0.y);
} // DBLShortLine::CrossPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLShortLine::IsInside
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDfPiCgPiCmNiClBiCmMjApMjFkKiCkKjBkOiClHiCoJjClMjApMiPoDiCmJiCkAiCoJjDfPiCmFiCkAiCoJiBeCjDfPiCgPiCkKiBeBjApMjFkKiCmM_xHqqkZx_
 *			_xZkqqHx_jCiGiCmJiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ptP	:_xZkqqHx_jDfPiCgPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDoAjBkE_xHqqkZx_(_xZkqqHx_iLkLiKeFiPoDiCpAiKnMiCnOiBgKiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE, _xZkqqHx_iKePjBkEiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL DBLShortLine::IsInside (const DBLPoint& ptP) const
{
	BOOL bX = FALSE;
	BOOL bY = FALSE;
	if (pt0.x <= ptP.x && ptP.x <= pt1.x) bX = TRUE;
	if (pt1.x <= ptP.x && ptP.x <= pt0.x) bX = TRUE;
	if (pt0.y <= ptP.y && ptP.y <= pt1.y) bY = TRUE;
	if (pt1.y <= ptP.y && ptP.y <= pt0.y) bY = TRUE;
	// X,Y_xZkqqHx_jHlMjFpLiCmFjCfLjDfPiCmMiKnEiCmJiCkAiCoJiPoKiNiHiCmMiCnN_xHqqkZx_TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	return bX & bY;
} // DBLShortLine::IsInside.

#endif//__DBLShortLine_h
