// DbTable.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "resource.h"		// For IDS_ERR_XX.
#include "UtilMisc.h"		// For FFCalcCRC.
#include "UtilErr.h"		// For FFThrowDDFileException.
#include "DynamicDb.h"		// For g_pFileServer.
#include "VirtualTable.h"	// For FCVirtualTable.
#include "DbTable.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// FCDbTable

FCDbTable::FCDbTable ()
{
} // FCDbTable::FCDbTable.

FCDbTable::FCDbTable (const FCTableName& tableName)
{
	Initialize(tableName);
} // FCDbTable::FCDbTable.

FCDbTable::~FCDbTable ()
{
} // FCDbTable::~FCDbTable.

void FCDbTable::Initialize (const FCTableName& tableName)
{
	// _xZkqqHx_jDoAjFjEjFmPjAjEiCpAiDeOiDiKiDeBiBeCiClBiClBiClOiCkPiCmIiCoHjFhDjHhGiClOiCkKiBeB_xHqqkZx_
	// _xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmMiClBiCmGiCoAiNgMiCkGiCmEiBeBjFeLiClIiOmAiNhDiClHiCoJiClBiCmGiBeC_xHqqkZx_
	Clear();
	m_tableName = tableName;
} // FCDbTable::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbTable::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbTable::Clear ()
{
	m_tableName.Clear();
} // FCDbTable::Clear.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbTable::operator = (const FCDbTable& dbTable)
{
	Set(dbTable);
} // FCDbTable::operator.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbTable::Set
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbTable::Set (const FCDbTable& dbTable)
{
	Initialize(dbTable.m_tableName);
} // FCDbTable::Set.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbTable::SetTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_Clear _xZkqqHx_iCmNiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableName	:_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbTable::SetTable (const FCTableName& tableName)
{
	m_tableName = tableName;
} // FCDbTable::SetTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbTable::SetTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLjGlMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_Clear _xZkqqHx_iCmNiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dbTable	:_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbTable::SetTable (const FCDbTable& dbTable)
{
	m_tableName = dbTable.GetTableName();
} // FCDbTable::SetTable.

BOOL FCDbTable::TryLock (FCDbReadLock& readLock)
{
	return FFTryLock(readLock, m_tableName);
} // FCDbTable::TryLock.

BOOL FCDbTable::TryLock (FCDbWriteLock& writeLock)
{
	return FFTryLock(writeLock, m_tableName);
} // FCDbTable::TryLock.

BOOL FCDbTable::TryLock (FCDbReadLock& readLock, FCDbWriteLock& writeLock)
{
	return FFTryLock(readLock, writeLock, m_tableName);
} // FCDbTable::TryLock.

BOOL FCDbTable::GetIsReadLocked () const
{
	return g_pFileServer->GetIsReadLocked(m_tableName);
} // FCDbTable::GetIsReadLocked.

BOOL FCDbTable::GetIsWriteLocked () const
{
	return g_pFileServer->GetIsWriteLocked(m_tableName);
} // FCDbTable::GetIsWriteLocked.

DWORD FCDbTable::AppendRecordAuto (const void* pData, DWORD dwDataSize)
{
	const FCVirtualTable* pVirtualTable = g_pFileServer->QueryTable(m_tableName);
	return AppendRecord(pVirtualTable->GetRecordLastPrimaryId() + 1, pData, dwDataSize);
} // FCDbTable::AppendRecordAuto.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbTable::AppendRecord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiNmFiMoDiCmJiBeBiDiMiDfCiBfLiDgIiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliPrimaryId	:_xZkqqHx_iDiMiDfCiBfLiDgIiCmMiDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pData			:_xZkqqHx_iDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwDataSize		:_xZkqqHx_iDgGiBfLiDfOiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiNmFiMoDiCmJiBeBiDiMiDfCiBfLiDgIiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iOkJjDkOjDeJiCmJiBeBiDgGiBfLiDfOiCmM_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClFiBeBjAoGjDkKiCmJjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDbTable::AppendRecord (flint fliPrimaryId, const void* pData, DWORD dwDataSize)
{
	// CRC_xZkqqHx_iCpAiMhGiOfKiBeC_xHqqkZx_
	const WORD wCRC = FFCalcCRC(dwDataSize, pData);
	return g_pFileServer->CmdAppendRecord(m_tableName, fliPrimaryId, &wCRC, sizeof(wCRC), pData, dwDataSize);
} // FCDbTable::AppendRecord.

DWORD FCDbTable::GetRecordCount ()
{
	const FCVirtualTable* pVirtualTable = g_pFileServer->QueryTable(m_tableName);
	return pVirtualTable->GetRecordCount();
} // FCDbTable::GetRecordCount.

void FCDbTable::ReduceRecordCount (DWORD dwIndex)
{
	ASSERT(dwIndex <= GetRecordCount());
	if (dwIndex != GetRecordCount())
		g_pFileServer->CmdReduceRecordCount(m_tableName, dwIndex);
} // FCDbTable::ReduceRecordCount.

void FCDbTable::DeleteRecord (DWORD dwIndex)
{
	DWORDSet stIndex;
	stIndex.insert(dwIndex);
	DeleteRecords(stIndex);
} // FCDbTable::DeleteRecord.

void FCDbTable::DeleteRecords (const DWORDSet& stIndex)
{
	g_pFileServer->MultiCmdDeleteRecords(m_tableName, stIndex);
} // FCDbTable::DeleteRecords.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbTable::CopyRecord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiOhHjCoIjEmNiImNiCmMiDiMiDfCiBfLiDgIiCpAiBeBiClBiCmMiDgFiBfLiDhFiDiLiCmMjGjGjEpGiCmJ_xHqqkZx_
 *			_xZkqqHx_jCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tableNameSrc	:_xZkqqHx_iDfCiDhDiBfLiClHiCoJiMlDiCmMiDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwIndexBegin	:_xZkqqHx_iDfCiDhDiBfLiClHiCoJiDiMiDfCiBfLiDgIjEmNiImNiCmMiNmFiPiJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwIndexEnd		:_xZkqqHx_iDfCiDhDiBfLiClHiCoJiDiMiDfCiBfLiDgIjEmNiImNiCmMiNmFiMoDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiClDiCoKiCoJiDiMiDfCiBfLiDgIiCmNiBeB_xHqqkZx_AppendIdentifier_xZkqqHx_iCmMiCnNjAfGiClFiCkCjCgMiCmJjFmPiNfIiClDiCoK_xHqqkZx_
 *			_xZkqqHx_iOgDiCoIiCmMjCgMiCmNiMlDiCmMiCnMiCnMjCmHiJmBiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiPiIjHjNiCmNiDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmFiNhDiCoNiCoKiBeBiDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iDfCiDhDiBfLiMlDiCmNiCkCiCmBiClDiCkCiOfBiPmGiClFiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBjBoFiCkLiCmIiDfEiDeDiDfJiCmMiDgFiBfLiDhFiDiLiCpAjFkBiOmKiClHiCoJiPoKiNiHiCmJjHeMiMpIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbTable::CopyRecord (const FCTableName& tableNameSrc, DWORD dwIndexBegin, DWORD dwIndexEnd)
{
	g_pFileServer->CmdCopyRecord(m_tableName, tableNameSrc, dwIndexBegin, dwIndexEnd);
} // FCDbTable::CopyRecord.

GUID FCDbTable::GetTableGuid () const
{
	const FCVirtualTable* pVirtualTable = g_pFileServer->QueryTable(m_tableName);
	return pVirtualTable->GetTableGuid();
} // FCDbTable::GetTableGuid.

DWORD FCDbTable::GetRecordAppendIdentifier (DWORD dwIndex)
{
	const FCVirtualTable* pVirtualTable = g_pFileServer->QueryTable(m_tableName);
	// _xZkqqHx_jCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCmNiDeDiDjDiDgGiDgCiDeOiDfIiCmJiKnMiCnMiCoKiCoJiCmMiCmFiBeBiDiNiBfLiDgIiClHiCoJjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
	return pVirtualTable->GetRecordAppendIdentifier(dwIndex);
} // FCDbTable::GetRecordAppendIdentifier.

flint FCDbTable::GetRecordPrimaryId (DWORD dwIndex)
{
	const FCVirtualTable* pVirtualTable = g_pFileServer->QueryTable(m_tableName);
	// _xZkqqHx_iDhGiDiJiDeDiDhNiDiK_xHqqkZx_ID_xZkqqHx_iCmNiDeDiDjDiDgGiDgCiDeOiDfIiCmJiKnMiCnMiCoKiCoJiCmMiCmFiBeBiDiNiBfLiDgIiClHiCoJjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
	return pVirtualTable->GetRecordPrimaryId(dwIndex);
} // FCDbTable::GetRecordPrimaryId.

DWORD FCDbTable::GetRecordDataSize (DWORD dwIndex)
{
	const FCVirtualTable* pVirtualTable = g_pFileServer->QueryTable(m_tableName);
	// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCmNiDeDiDjDiDgGiDgCiDeOiDfIiCmJiKnMiCnMiCoKiCoJiCmMiCmFiBeBiDiNiBfLiDgIiClHiCoJjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
	// CRC_xZkqqHx_jFkKiCpAiDhNiDeDiDgJiDfIiBeC_xHqqkZx_
	return (pVirtualTable->GetRecordDataSize(dwIndex) - sizeof(WORD));
} // FCDbTable::GetRecordDataSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbTable::GetRecordData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDataBuff	:_xZkqqHx_iDgGiBfLiDfOiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwBuffSize	:_xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOhHjCoIiBeCjBfDiCmEiCmMiDgGiBfLiDfOiCpA_xHqqkZx_
 *						 _xZkqqHx_iOoGjDlOiClHiCoJiPoKiNiHiCmN_xHqqkZx_ DOWRD(-1) _xZkqqHx_iCpAiOhHjCoIiClFiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiPgPiClDiCoKiClNiDgGiBfLiDfOiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCDbTable::GetRecordData (void* pDataBuff, DWORD dwBuffSize, DWORD dwIndex)
{
	const FCVirtualTable* pVirtualTable = g_pFileServer->QueryTable(m_tableName);
	if (pVirtualTable->IsNullRecord(dwIndex))
		g_pFileServer->CacheTableRealRecords(m_tableName, dwIndex);
	// CRC_xZkqqHx_iCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	WORD wCRC;
	pVirtualTable->GetRecordData(&wCRC, sizeof(wCRC), dwIndex, 0);
	// _xZkqqHx_iDgGiBfLiDfOiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	DWORD dwDataSize = pVirtualTable->GetRecordData(pDataBuff, dwBuffSize, dwIndex, sizeof(WORD));
	if (sizeof(wCRC) + dwDataSize == pVirtualTable->GetRecordDataSize(dwIndex))
	//----- _xZkqqHx_jBfDiCmEiCmMiDgGiBfLiDfOiCkKjDmHiCnNiPgPiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		// CRC_xZkqqHx_iCpAiMhGiOfKiBeC_xHqqkZx_
		if (wCRC != FFCalcCRC(dwDataSize, pDataBuff))
			FFThrowDDFileException(	IDS_ERR_FILE_DESTROIED,
									WString(GetTableName().GetTopDirPath()));
	}
	return dwDataSize;
} // FCDbTable::GetRecordData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbTable::GetRecord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbTable::GetRecord (flint& fliPrimaryId, BYTEVector* vBuff, DWORD dwIndex)
{
	fliPrimaryId = GetRecordPrimaryId(dwIndex);
	if (vBuff != NULL)
	{
		vBuff->resize(GetRecordDataSize(dwIndex));
		GetRecordData(&(*vBuff)[0], vBuff->size(), dwIndex);
	}
} // FCDbTable::GetRecord.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbTable::GetRealRecordPrimaryId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Real_xZkqqHx_iDiMiDfCiBfLiDgIiBgJjFkIjHjNiDhEiDeAiDeDiDiLiCkJiCoH_xHqqkZx_Read_xZkqqHx_iDeMiDiDiDgCiDfGiDiFiClDiCoKiClNiDiMiDfCiBfLiDgIiBgKiCmM_xHqqkZx_
 *			_xZkqqHx_iDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIndex	:_xZkqqHx_iDiMiDfCiBfLiDgIiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDeDiDhNiDiK_xHqqkZx_ID_xZkqqHx_iCmNiDeDiDjDiDgGiDgCiDeOiDfIiCmJiKnMiCnMiCoKiCoJiCmMiCmFiBeBiDiNiBfLiDgIiClHiCoJjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCDbTable::GetRealRecordPrimaryId (DWORD dwIndex)
{
	const FCVirtualTable* pVirtualTable = g_pFileServer->QueryTable(m_tableName);
	// _xZkqqHx_iDhGiDiJiDeDiDhNiDiK_xHqqkZx_ID_xZkqqHx_iCmNiDeDiDjDiDgGiDgCiDeOiDfIiCmJiKnMiCnMiCoKiCoJiCmMiCmFiBeBiDiNiBfLiDgIiClHiCoJjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
	return pVirtualTable->GetRealRecordPrimaryId(dwIndex);
} // FCDbTable::GetRealRecordPrimaryId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbTable::GetTableName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTableName FCDbTable::GetTableName () const
{
	return m_tableName;
} // FCDbTable::GetTableName.

BOOL FCDbTable::GetIsInvalid () const
{
	return m_tableName.m_hstrTopDirPath.IsNull();
} // FCDbTable::GetIsInvalid.

//----- 06.01.15 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbTable::GetIsTableExist
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCDbTable::GetIsTableExist () const
//{
//	return g_pFileServer->GetIsTableExist(m_tableName);
//} // FCDbTable::GetIsTableExist.
//----- 06.01.15 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

DWORD FCDbTable::PrimaryIdToLowerBoundIndex (flint fliPrimaryId)
{
	const FCVirtualTable* pVirtualTable = g_pFileServer->QueryTable(m_tableName);
	return pVirtualTable->PrimaryIdToLowerBoundIndex(fliPrimaryId);
} // FCDbTable::PrimaryIdToLowerBoundIndex.

DWORD FCDbTable::PrimaryIdToUpperBoundIndex (flint fliPrimaryId)
{
	const FCVirtualTable* pVirtualTable = g_pFileServer->QueryTable(m_tableName);
	return pVirtualTable->PrimaryIdToUpperBoundIndex(fliPrimaryId);
} // FCDbTable::PrimaryIdToUpperBoundIndex.

DWORD FCDbTable::PrimaryIdToIndex (flint fliPrimaryId)
{
	const FCVirtualTable* pVirtualTable = g_pFileServer->QueryTable(m_tableName);
	return pVirtualTable->PrimaryIdToIndex(fliPrimaryId);
} // FCDbTable::PrimaryIdToIndex.

