// DlgCreateTimeIndex.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilStr.h"			// For FFLoadWString.
#include "UtilDlg.h"			// For SetUnitString.etc.
#include "DlgSelectUser.h"		// For CFCDlgSelectUser.
#include "DlgCreateTimeIndex.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKjFnLjBlGjGlM_xHqqkZx_ -----
static const wchar_t* REG_DLG_CREATE_TIME_INDEX = L"CFCDlgCreateTimeIndex";

/////////////////////////////////////////////////////////////////////////////
// CFCDlgCreateTimeIndex _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

CFCDlgCreateTimeIndex::CFCDlgCreateTimeIndex(CWnd* pParent /*=NULL*/)
	: BASE_CLASS(CFCDlgCreateTimeIndex::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFCDlgCreateTimeIndex)
	m_bTimeFrom = FALSE;
	m_bTimeUntil = FALSE;
	m_bNarrowByUser = FALSE;
	m_otmTimeFrom = COleDateTime::GetCurrentTime();
	m_otmTimeUntil = COleDateTime::GetCurrentTime();
	//}}AFX_DATA_INIT
}

/////////////////////////////////////////////////////////////////////////////
// CFCDlgCreateTimeIndex _xZkqqHx_iDiGiBfLiDfFiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	project	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsDocumentOpened
 *					:_xZkqqHx_jFlGiPjBiCkKiKeKiCkCiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgCreateTimeIndex::Initialize (FCHiProject& project, BOOL bIsDocumentOpened)
{
	m_projectCopy = project;
	m_bIsDocumentOpened = bIsDocumentOpened;
} // CFCDlgCreateTimeIndex::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::GetProjectPathH
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HString CFCDlgCreateTimeIndex::GetProjectPathH () const
{
	return HString(m_projectCopy.GetFilePath());
} // CFCDlgCreateTimeIndex::GetProjectPathH.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::GetSearchWhere
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiClHiCoJjEmNiImNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjEmNiImNiBeC_xHqqkZx_IDC_CTI_RDO_SEARCH_ALL,IDC_CTI_RDO_SEARCH_BELOW_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCDlgCreateTimeIndex::GetSearchWhere () const
{
	return m_lSearchWhere;
} // CFCDlgCreateTimeIndex::GetSearchWhere.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::GetNarrowTimeFrom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiNgJiNjOiCnNiCmMiKeKiOgOiOjOiKnEiCpAiOoGjDlOiBeCiNgJiCoIiClBiCnMiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iNmFiPkMjCgM_xHqqkZx_(FDSECTIME_MIN)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiNgJiNjOiCnNiCmMiKeKiOgOiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME CFCDlgCreateTimeIndex::GetNarrowTimeFrom () const
{
	// _xZkqqHx_iNgJiNjOiCnNiCmMiOjOiKnEiCpAiOfKiPgPiBeCiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiNmFiPkMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	return m_bTimeFrom ? COleDtToFdsec(m_otmTimeFrom) : FDSECTIME_MIN;
} // CFCDlgCreateTimeIndex::GetNarrowTimeFrom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::GetNarrowTimeUntil
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiNgJiNjOiCnNiCmMiPeJjHlJiOjOiKnEiCpAiOoGjDlOiBeCiNgJiCoIiClBiCnMiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iNmFiPkMjCgM_xHqqkZx_(FDSECTIME_MAX)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiNgJiNjOiCnNiCmMiPeJjHlJiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME CFCDlgCreateTimeIndex::GetNarrowTimeUntil () const
{
	// _xZkqqHx_iNgJiNjOiCnNiCmMiOjOiKnEiCpAiOfKiPgPiBeCiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiNmFjBoFjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	return m_bTimeUntil ? COleDtToFdsec(m_otmTimeUntil) : FDSECTIME_MAX;
} // CFCDlgCreateTimeIndex::GetNarrowTimeUntil.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::GetNarrowUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiNgJiNjOiCnNiCmMiDiGiBfLiDfFjEhKjHpBiCpAjFnEiClHiBeCiNgJiCoIiNjOiCnMiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iLpDiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiNgJiNjOiCnNiCmMiDiGiBfLiDfFjEhKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const set<GUID>& CFCDlgCreateTimeIndex::GetNarrowUserId () const
{
	static set<GUID> stDummy;
	return m_bNarrowByUser ? m_stSelectedUserId : stDummy;
} // CFCDlgCreateTimeIndex::GetNarrowUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::UpdateControls
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmPjAjEiCmMjCgMiCmFiBeBiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgCreateTimeIndex::UpdateControls ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateData(FALSE);

	// _xZkqqHx_iMjPiNpFjEmNiImNiCmMiDiJiDfHiDeJiDhLiDfOiDjDiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	CheckRadioButton(IDC_CTI_RDO_SEARCH_ALL, IDC_CTI_RDO_SEARCH_BELOW, m_lSearchWhere);

	// _xZkqqHx_iNgJiNjOiCnNiDiGiBfLiDfFiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	m_lsvUserList.ClearUser();
	set<GUID>::const_iterator iId;
	for (iId = m_stSelectedUserId.begin(); iId != m_stSelectedUserId.end(); iId++)
	{
		// _xZkqqHx_iNgJiNjOiCnNiDiGiBfLiDfFiDiKiDfIiDgHiCmJiDiGiBfLiDfFiCpAjCmHiJmBiBeC_xHqqkZx_
		if (*iId == GUID_NULL)
// 06.04.29 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			m_lsvUserList.AddUser(*iId, FFLoadWString(IDS_UNSET));
			m_lsvUserList.AddUser(*iId, FFLoadWString(IDS_GUEST));
		else
			m_lsvUserList.AddUser(*iId, m_projectCopy.UserIdToUserName(*iId));
	}
} // CFCDlgCreateTimeIndex::UpdateControls.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::UpdateVariables
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFiBeBjFmPjAjEiCmMjCgMiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgCreateTimeIndex::UpdateVariables ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateData(TRUE);
	// _xZkqqHx_iMjPiNpFjEmNiImNiCmMiDiJiDfHiDeJiDhLiDfOiDjDiCmMjCgMiCpAiOoGjDlOiBeC_xHqqkZx_
	m_lSearchWhere = GetCheckedRadioButton(IDC_CTI_RDO_SEARCH_ALL, IDC_CTI_RDO_SEARCH_BELOW);
	// _xZkqqHx_iNgJiNjOiCnNiDiGiBfLiDfFiDiKiDfIiDgHiCkJiCoHiDiGiBfLiDfFiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
	m_lsvUserList.GetUserId(m_stSelectedUserId);
} // CFCDlgCreateTimeIndex::UpdateVariables.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::UpdateActivate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKgFiDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgCreateTimeIndex::UpdateActivate ()
{
	//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiCpAjAnNjCoI_xHqqkZx_ -----

	// _xZkqqHx_iClBiCmMjFlGiPjBiCoGiCoIiJlKiCpAiMjPiNpFiCmMiDhLiDfOiDjDiBeC_xHqqkZx_
	GetDlgItem(IDC_CTI_RDO_SEARCH_BELOW)->EnableWindow(m_bIsDocumentOpened);

	//----- _xZkqqHx_jDpKiOjOiNgJiCoIiNjOiCnNiDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ -----
	GetDlgItem(IDC_CTI_STC_TIME_FROM)->EnableWindow(m_bTimeFrom);
	GetDlgItem(IDC_CTI_DTM_TIME_FROM)->EnableWindow(m_bTimeFrom);
	GetDlgItem(IDC_CTI_STC_TIME_UNTIL)->EnableWindow(m_bTimeUntil);
	GetDlgItem(IDC_CTI_DTM_TIME_UNTIL)->EnableWindow(m_bTimeUntil);

	// _xZkqqHx_iDiGiBfLiDfFiNgJiNjOiCnNiDfCiDjDiDgHiDiNiBfLiDiLiBeC_xHqqkZx_
	GetDlgItem(IDC_CTI_BTN_SELECT_USER)->EnableWindow(m_bNarrowByUser);
	GetDlgItem(IDC_CTI_LSV_USER_LIST)->EnableWindow(m_bNarrowByUser);
} // CFCDlgCreateTimeIndex::UpdateActivate.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgCreateTimeIndex _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

void CFCDlgCreateTimeIndex::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCDlgCreateTimeIndex)
	DDX_Control(pDX, IDC_CTI_LSV_USER_LIST, m_lsvUserList);
	DDX_Control(pDX, IDC_CTI_STC_BORDER_1, m_stcBorder1);
	DDX_Control(pDX, IDC_CTI_STC_BORDER_2, m_stcBorder2);
	DDX_Check(pDX, IDC_CTI_CHK_TIME_FROM, m_bTimeFrom);
	DDX_Check(pDX, IDC_CTI_CHK_TIME_UNTIL, m_bTimeUntil);
	DDX_Check(pDX, IDC_CTI_CHK_NARROW_BY_USER, m_bNarrowByUser);
	DDX_DateTimeCtrl(pDX, IDC_CTI_DTM_TIME_FROM, m_otmTimeFrom);
	DDX_DateTimeCtrl(pDX, IDC_CTI_DTM_TIME_UNTIL, m_otmTimeUntil);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFCDlgCreateTimeIndex, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCDlgCreateTimeIndex)
	ON_BN_CLICKED(IDC_CTI_CHK_TIME_FROM, OnCtiChkTimeFrom)
	ON_BN_CLICKED(IDC_CTI_CHK_TIME_UNTIL, OnCtiChkTimeUntil)
	ON_BN_CLICKED(IDC_CTI_CHK_NARROW_BY_USER, OnCtiChkNarrowByUser)
	ON_BN_CLICKED(IDC_CTI_BTN_SELECT_USER, OnCtiBtnSelectUser)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCDlgCreateTimeIndex _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgCreateTimeIndex::OnInitDialog ()
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	if (!BASE_CLASS::OnInitDialog())
		return FALSE;

	//----- _xZkqqHx_jDpKiCmJiClPjFfMiOkGiCpA_xHqqkZx_ 1999_xZkqqHx_jEeO_xHqqkZx_ 2_xZkqqHx_iMiO_xHqqkZx_ 9_xZkqqHx_jDpK_xHqqkZx_ 14_xZkqqHx_iOjO_xHqqkZx_21_xZkqqHx_jFkK_xHqqkZx_ _xZkqqHx_iCmMiMgAiOkOiCmJiPeDjAlD_xHqqkZx_ -----
	CString strForm;
	strForm.LoadString(IDS_FORM_DATE_TIME_LONG_2);
	((CDateTimeCtrl*)GetDlgItem(IDC_CTI_DTM_TIME_FROM))->SetFormat(strForm);
	((CDateTimeCtrl*)GetDlgItem(IDC_CTI_DTM_TIME_UNTIL))->SetFormat(strForm);

	// _xZkqqHx_iDiGiBfLiDfFiDiKiDfIiDgHiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	m_lsvUserList.Initialize(REG_DLG_CREATE_TIME_INDEX, L"IDC_CTI_LSV_USER_LIST");

	// _xZkqqHx_iMjPiNpFjEmNiImNiBeC_xHqqkZx_
	m_lSearchWhere = IDC_CTI_RDO_SEARCH_ALL;

	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	UpdateControls();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
	::FFJustifyWindow(m_hWnd);

	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCDlgCreateTimeIndex::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::OnOK
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OK_xZkqqHx_iDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgCreateTimeIndex::OnOK ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnOK();
} // CFCDlgCreateTimeIndex::OnOK.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::OnCtiChkTimeFrom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDpKiOjOiCpAjAkHiMmAiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgCreateTimeIndex::OnCtiChkTimeFrom ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCDlgCreateTimeIndex::OnCtiChkTimeFrom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::OnCtiChkTimeUntil
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDpKiOjOiCpAjAkHiMmAiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgCreateTimeIndex::OnCtiChkTimeUntil ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCDlgCreateTimeIndex::OnCtiChkTimeUntil.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::OnCtiChkNarrowByUser
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiBfLiCmFiNgJiCoIiNjOiCnOiDgAiDeGiDgCiDeOiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgCreateTimeIndex::OnCtiChkNarrowByUser ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiBeFjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateActivate();
} // CFCDlgCreateTimeIndex::OnCtiChkNarrowByUser.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgCreateTimeIndex::OnCtiBtnSelectUser
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiBfLiCpAjAnNjCoIiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgCreateTimeIndex::OnCtiBtnSelectUser ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCkJiCoHiDiBiDjDiDgPjFmPjAjEiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
	UpdateVariables();
	CFCDlgSelectUser dlg;
	dlg.Initialize(&m_projectCopy, TRUE);
	dlg.SetSelectedUserId(m_stSelectedUserId);
	if (dlg.DoModal() == IDOK)
	{
		// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
		dlg.GetSelectedUserId(m_stSelectedUserId);
		// _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCkJiCoHiDfCiDjDiDgHiDiNiBfLiDiLiCnGiDgGiBfLiDfOiCpAjDfNjBjHiBeC_xHqqkZx_
		UpdateControls();
	}
} // CFCDlgCreateTimeIndex::OnCtiBtnSelectUser.
